/*
 * Copyright (c) 2020 Huawei Device Co., Ltd.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef UI_TEXT_LANGUAGE_H
#define UI_TEXT_LANGUAGE_H

#include <cstdint>

namespace OHOS {
#pragma pack(1)

enum UITextLanguageLangId : uint8_t {
    LANGUAGE_CH = 0,
    LANGUAGE_GB = 1,
    LANGUAGE_FR = 2,
    LANGUAGE_DE = 3,
    LANGUAGE_PT = 4,
    LANGUAGE_RU = 5,
    LANGUAGE_ES = 6,
    LANGUAGE_IT = 7,
    LANGUAGE_PL = 8,
    LANGUAGE_EN = 9,
    LANGUAGE_TR = 10,
    LANGUAGE_DK = 11,
    LANGUAGE_SE = 12,
    LANGUAGE_NOR = 13,
    LANGUAGE_FI = 14,
    LANGUAGE_HK = 15,
    LANGUAGE_TW = 16,
    LANGUAGE_JA = 17,
    LANGUAGE_KR = 18,
    LANGUAGE_AR = 19,
    LANGUAGE_PTB = 20,
    LANGUAGE_ESL = 21,
    LANGUAGE_TH = 22,
    LANGUAGE_VI = 23,
    LANGUAGE_HE = 24,
    LANGUAGE_CS = 25,
    LANGUAGE_SK = 26,
    LANGUAGE_NL = 27,
    LANGUAGE_EL = 28,
    LANGUAGE_HU = 29,
    LANGUAGE_MS = 30,
    LANGUAGE_RO = 31,
    LANGUAGE_SR = 32,
    LANGUAGE_HI = 33,
    LANGUAGE_UK = 34,
    LANGUAGE_MY = 35,
    LANGUAGE_ID = 36,
    LANGUAGE_BG = 37,
    LANGUAGE_HR = 38,
    LANGUAGE_SL = 39,
    LANGUAGE_LT = 40,
    LANGUAGE_LV = 41,
    LANGUAGE_ET = 42,
    LANGUAGE_MAX = 43
}; // UITextLanguageLangId

enum UITextLanguageFontId : uint8_t {
    F_ROBOTOCONDENSED_REGULAR_14_4 = 0,
    F_ROBOTOCONDENSED_REGULAR_18_4 = 1,
    F_ROBOTOCONDENSED_REGULAR_20_4 = 2,
    F_ROBOTOCONDENSED_REGULAR_23_4 = 3,
    F_ROBOTOCONDENSED_REGULAR_24_4 = 4,
    F_ROBOTOCONDENSED_REGULAR_26_4 = 5,
    F_ROBOTOCONDENSED_REGULAR_28_4 = 6,
    F_ROBOTOCONDENSED_REGULAR_30_4 = 7,
    F_ROBOTOCONDENSED_REGULAR_38_4 = 8,
    F_ROBOTOCONDENSED_REGULAR_48_4 = 9,
    F_HYQIHEI_65S_14_4 = 10,
    F_HYQIHEI_65S_18_4 = 11,
    F_HYQIHEI_65S_16_4 = 12,
    F_HYQIHEI_65S_22_4 = 13,
    F_HYQIHEI_65S_24_4 = 14,
    F_HYQIHEI_65S_26_4 = 15,
    F_HYQIHEI_65S_30_4 = 16,
    F_HYQIHEI_65S_34_4 = 17,
    F_HYQIHEI_65S_38_4 = 18,
    F_HYQIHEI_65S_48_4 = 19,
    F_NOTONASKHARABIC_REGULAR_14_4 = 20,
    F_NOTONASKHARABIC_REGULAR_18_4 = 21,
    F_NOTONASKHARABIC_REGULAR_24_4 = 22,
    F_NOTONASKHARABIC_REGULAR_30_4 = 23,
    F_NOTONASKHARABIC_REGULAR_38_4 = 24,
    F_NOTONASKHARABIC_REGULAR_20_4 = 25,
    F_NOTONASKHARABIC_REGULAR_23_4 = 26,
    F_NOTONASKHARABIC_REGULAR_26_4 = 27,
    F_NOTONASKHARABIC_REGULAR_28_4 = 28,
    F_NOTONASKHARABIC_REGULAR_48_4 = 29,
    F_NOTOSANSCJKJP_REGULAR_14_4 = 30,
    F_NOTOSANSCJKJP_REGULAR_18_4 = 31,
    F_NOTOSANSCJKJP_REGULAR_24_4 = 32,
    F_NOTOSANSCJKJP_REGULAR_20_4 = 33,
    F_NOTOSANSCJKJP_REGULAR_23_4 = 34,
    F_NOTOSANSCJKJP_REGULAR_26_4 = 35,
    F_NOTOSANSCJKJP_REGULAR_28_4 = 36,
    F_NOTOSANSCJKJP_REGULAR_30_4 = 37,
    F_NOTOSANSCJKJP_REGULAR_38_4 = 38,
    F_NOTOSANSCJKJP_REGULAR_48_4 = 39,
    F_NOTOSANSCJKKR_REGULAR_14_4 = 40,
    F_NOTOSANSCJKKR_REGULAR_18_4 = 41,
    F_NOTOSANSCJKKR_REGULAR_24_4 = 42,
    F_NOTOSANSCJKKR_REGULAR_20_4 = 43,
    F_NOTOSANSCJKKR_REGULAR_23_4 = 44,
    F_NOTOSANSCJKKR_REGULAR_26_4 = 45,
    F_NOTOSANSCJKKR_REGULAR_28_4 = 46,
    F_NOTOSANSCJKKR_REGULAR_30_4 = 47,
    F_NOTOSANSCJKKR_REGULAR_38_4 = 48,
    F_NOTOSANSCJKKR_REGULAR_48_4 = 49,
    F_NOTOSANSTHAI_REGULAR_14_4 = 50,
    F_NOTOSANSTHAI_REGULAR_18_4 = 51,
    F_NOTOSANSTHAI_REGULAR_24_4 = 52,
    F_NOTOSANSTHAI_REGULAR_30_4 = 53,
    F_NOTOSANSTHAI_REGULAR_38_4 = 54,
    F_NOTOSANSHEBREW_REGULAR_14_4 = 55,
    F_NOTOSANSHEBREW_REGULAR_18_4 = 56,
    F_NOTOSANSHEBREW_REGULAR_24_4 = 57,
    F_NOTOSANSHEBREW_REGULAR_30_4 = 58,
    F_NOTOSANSHEBREW_REGULAR_38_4 = 59,
    F_NOTOSANSHEBREW_REGULAR_20_4 = 60,
    F_NOTOSANSHEBREW_REGULAR_23_4 = 61,
    F_NOTOSANSHEBREW_REGULAR_26_4 = 62,
    F_NOTOSANSHEBREW_REGULAR_28_4 = 63,
    F_NOTOSANSHEBREW_REGULAR_48_4 = 64,
    F_NOTOSANSTHAI_REGULAR_20_4 = 65,
    F_NOTOSANSTHAI_REGULAR_23_4 = 66,
    F_NOTOSANSTHAI_REGULAR_26_4 = 67,
    F_NOTOSANSTHAI_REGULAR_28_4 = 68,
    F_NOTOSANSTHAI_REGULAR_48_4 = 69,
    F_NOTOSANSDEVANAGARI_REGULAR_14_4 = 70,
    F_NOTOSANSDEVANAGARI_REGULAR_18_4 = 71,
    F_NOTOSANSDEVANAGARI_REGULAR_24_4 = 72,
    F_NOTOSANSDEVANAGARI_REGULAR_20_4 = 73,
    F_NOTOSANSDEVANAGARI_REGULAR_23_4 = 74,
    F_NOTOSANSDEVANAGARI_REGULAR_26_4 = 75,
    F_NOTOSANSDEVANAGARI_REGULAR_28_4 = 76,
    F_NOTOSANSDEVANAGARI_REGULAR_30_4 = 77,
    F_NOTOSANSDEVANAGARI_REGULAR_38_4 = 78,
    F_NOTOSANSDEVANAGARI_REGULAR_48_4 = 79,
    LANGUAGE_FONT_ID_MAX = 80
}; // UITextLanguageFontId

enum UITextLanguageTextId : uint16_t {
    T_IDS_GLYPHS_VERSION = 0,
    T_SCREEN1_CHINA1 = 1,
    T_SCREEN1_CHINA2 = 2,
    T_SCREEN1_CHINA3 = 3,
    T_SCREEN3_CHINA1 = 4,
    T_SCREEN3_CHINA4 = 5,
    T_SCREEN2_CHINA1 = 6,
    T_SCREEN2_CHINA2 = 7,
    T_SCREEN2_CHINA3 = 8,
    T_SCREEN2_CHINA4 = 9,
    T_SCREEN2_CHINA5 = 10,
    T_SCREEN2_CHINA6 = 11,
    T_SCREEN2_CHINA7 = 12,
    T_SCREEN2_CHINA8 = 13,
    T_HEARTRATE_CHINA1 = 14,
    T_HEARTRATE_CHINA2 = 15,
    T_HEARTRATE_CHINA3 = 16,
    T_HEARTRATE_CHINA4 = 17,
    T_HEARTRATE_CHINA5 = 18,
    T_HEARTRATE_CHINA6 = 19,
    T_HEARTRATE_CHINA7 = 20,
    T_HEARTRATE_CHINA8 = 21,
    T_HEARTRATE_CHINA9 = 22,
    T_HEARTRATE_CHINA10 = 23,
    T_HEARTRATE_CHINA11 = 24,
    T_HEARTRATE_CHINA17 = 25,
    T_EXITCONFIRM_CHINA1 = 26,
    T_HEARTRATE2_CHINA1 = 27,
    T_HEARTRATE2_CHINA2 = 28,
    T_HEARTRATE2_CHINA3 = 29,
    T_HEARTRATE2_CHINA4 = 30,
    T_HEARTRATE2_CHINA5 = 31,
    T_HEARTRATE3_CHINA1 = 32,
    T_SLEEP_CHARACTER_HOUR = 33,
    T_SLEEP_CHARACTER_MINUTE = 34,
    T_SLEEP_CHARACTER_AIMS = 35,
    T_SLEEP_CHARACTER1 = 36,
    T_SLEEP_CHARACTER2 = 37,
    T_SLEEP_CHARACTER3 = 38,
    T_RESOURCEID1 = 39,
    T_RESOURCEID2 = 40,
    T_RESOURCEID3 = 41,
    T_RESOURCEID4 = 42,
    T_RESOURCEID5 = 43,
    T_RESOURCEID6 = 44,
    T_RESOURCEID7 = 45,
    T_RESOURCEID8 = 46,
    T_RESOURCEID9 = 47,
    T_RESOURCEID10 = 48,
    T_RESOURCEID11 = 49,
    T_RESOURCEID12 = 50,
    T_RESOURCEID13 = 51,
    T_RESOURCEID14 = 52,
    T_RESOURCEID15 = 53,
    T_RESOURCEID16 = 54,
    T_RESOURCEID17 = 55,
    T_RESOURCEID18 = 56,
    T_RESOURCEID19 = 57,
    T_RESOURCEID20 = 58,
    T_RESOURCEID21 = 59,
    T_RESOURCEID22 = 60,
    T_RESOURCEID26 = 61,
    T_RESOURCEID27 = 62,
    T_RESOURCEID28 = 63,
    T_RESOURCEID29 = 64,
    T_RESOURCEID30 = 65,
    T_RESOURCEID31 = 66,
    T_RESOURCEID32 = 67,
    T_RESOURCEID33 = 68,
    T_RESOURCEID36 = 69,
    T_RESOURCEID37 = 70,
    T_RESOURCEID38 = 71,
    T_RESOURCEID39 = 72,
    T_RESOURCEID40 = 73,
    T_RESOURCEID41 = 74,
    T_RESOURCEID42 = 75,
    T_RESOURCEID43 = 76,
    T_RESOURCEID44 = 77,
    T_RESOURCEID45 = 78,
    T_RESOURCEID46 = 79,
    T_RESOURCEID47 = 80,
    T_RESOURCEID48 = 81,
    T_RESOURCEID49 = 82,
    T_RESOURCEID50 = 83,
    T_RESOURCEID51 = 84,
    T_RESOURCEID52 = 85,
    T_NULL = 86,
    T_RESOURCEID23 = 87,
    T_NO_SLEEP_HELP = 88,
    T_NO_SLEEP_RECORD = 89,
    T_FINDPHONERINGINGTEXT = 90,
    T_FINDPHONESTOPRINGTEXT = 91,
    T_FINDPHONELINGLOSSTEXT = 92,
    T_RESTART_OPTIONS = 93,
    T_SHUTDOWN_OPTIONS = 94,
    T_PAIR_SCAN_CODE = 95,
    T_PAIR_TLS_BACK = 96,
    T_PAIR_REQUEST = 97,
    T_PAIRING = 98,
    T_PAIR_SUCCESS = 99,
    T_PAIR_FAIL = 100,
    T_CLICKTXT = 101,
    T_FOUNDTXT = 102,
    T_CLICINGKTXT = 103,
    T_COMPLETETXT = 104,
    T_FAILTXT = 105,
    T_ELECTRICITYONE = 106,
    T_ELECTRICITYTWO = 107,
    T_ELECTRICITYBTU = 108,
    T_EXITORGOONTXT = 109,
    T_SHOWSTOPWATCH = 110,
    T_FIXEDTIMEMIN = 111,
    T_FIXEDTIMEHOUR = 112,
    T_CUSTIOMTIME = 113,
    T_TIMETXT = 114,
    T_SETTIMETXT = 115,
    T_EXITTIMERTXT = 116,
    T_APP_EXERCISE = 117,
    T_APP_EXERCISE_RECORD = 118,
    T_APP_TAINING_STATUS = 119,
    T_APP_HEART_RATE = 120,
    T_APP_ACTIVITY_RECORD = 121,
    T_APP_SLEEP = 122,
    T_APP_PRESSURE = 123,
    T_APP_BREATHING_TRAINING = 124,
    T_APP_ALTITUDE_BAROMETER = 125,
    T_APP_COMPASS = 126,
    T_APP_WEATHER = 127,
    T_APP_INFORMATION = 128,
    T_APP_BUS_CARD = 129,
    T_APP_ALIPAY = 130,
    T_APP_STOPWATCH = 131,
    T_APP_COUNTDOWN_TIMER = 132,
    T_APP_ALARM_CLOCK = 133,
    T_APP_FLASHLIGHT = 134,
    T_APP_SEARCH_PHONE = 135,
    T_APP_SYSTEM_SETTING = 136,
    T_BINDWATCH1 = 137,
    T_BINDWATCH2 = 138,
    T_BINDWATCH3 = 139,
    T_BINDWATCH4 = 140,
    T_BINDWATCH5 = 141,
    T_BINDWATCH6 = 142,
    T_BINDWATCH7 = 143,
    T_BINDWATCH8 = 144,
    T_BINDWATCH9 = 145,
    T_BINDWATCH10 = 146,
    T_SINGLEUSEID5 = 147,
    T_SINGLEUSEID6 = 148,
    T_SINGLEUSEID7 = 149,
    T_SINGLEUSEID8 = 150,
    T_SINGLEUSEID9 = 151,
    T_SINGLEUSEID10 = 152,
    T_SINGLEUSEID11 = 153,
    T_SINGLEUSEID12 = 154,
    T_SINGLEUSEID13 = 155,
    T_IDS_TRAIN_BURN_FAT = 156,
    T_IDS_TRAIN_RELAX = 157,
    T_IDS_TRAIN_ANAEROBIC = 158,
    T_IDS_TRAIN_LIMIT = 159,
    T_SINGLEUSEID14 = 160,
    T_SINGLEUSEID15 = 161,
    T_SINGLEUSEID16 = 162,
    T_SINGLEUSEID25 = 163,
    T_SINGLEUSEID26 = 164,
    T_SINGLEUSEID27 = 165,
    T_SINGLEUSEID34 = 166,
    T_SINGLEUSEID35 = 167,
    T_SINGLEUSEID36 = 168,
    T_SINGLEUSEID41 = 169,
    T_SINGLEUSEID44 = 170,
    T_SINGLEUSEID45 = 171,
    T_SINGLEUSEID46 = 172,
    T_SINGLEUSEID47 = 173,
    T_SINGLEUSEID48 = 174,
    T_SINGLEUSEID49 = 175,
    T_SINGLEUSEID50 = 176,
    T_SINGLEUSEID55 = 177,
    T_SINGLEUSEID56 = 178,
    T_SINGLEUSEID61 = 179,
    T_SINGLEUSEID62 = 180,
    T_SINGLEUSEID67 = 181,
    T_SINGLEUSEID68 = 182,
    T_SINGLEUSEID73 = 183,
    T_SINGLEUSEID74 = 184,
    T_SINGLEUSEID75 = 185,
    T_SINGLEUSEID80 = 186,
    T_SINGLEUSEID81 = 187,
    T_SINGLEUSEID86 = 188,
    T_SINGLEUSEID87 = 189,
    T_SINGLEUSEID88 = 190,
    T_SINGLEUSEID99 = 191,
    T_SINGLEUSEID104 = 192,
    T_SINGLEUSEID105 = 193,
    T_SINGLEUSEID108 = 194,
    T_SINGLEUSEID109 = 195,
    T_SINGLEUSEID110 = 196,
    T_SINGLEUSEID111 = 197,
    T_SINGLEUSEID113 = 198,
    T_SINGLEUSEID114 = 199,
    T_SINGLEUSEID117 = 200,
    T_SINGLEUSEID118 = 201,
    T_SINGLEUSEID121 = 202,
    T_SINGLEUSEID122 = 203,
    T_SINGLEUSEID125 = 204,
    T_SINGLEUSEID126 = 205,
    T_SINGLEUSEID129 = 206,
    T_SINGLEUSEID130 = 207,
    T_SINGLEUSEID131 = 208,
    T_SINGLEUSEID134 = 209,
    T_SINGLEUSEID135 = 210,
    T_SINGLEUSEID136 = 211,
    T_SINGLEUSEID137 = 212,
    T_SINGLEUSEID146 = 213,
    T_SINGLEUSEID147 = 214,
    T_SINGLEUSEID150 = 215,
    T_SINGLEUSEID159 = 216,
    T_SINGLEUSEID160 = 217,
    T_SINGLEUSEID171 = 218,
    T_SINGLEUSEID172 = 219,
    T_SINGLEUSEID175 = 220,
    T_SINGLEUSEID178 = 221,
    T_SINGLEUSEID181 = 222,
    T_SINGLEUSEID182 = 223,
    T_SINGLEUSEID183 = 224,
    T_SINGLEUSEID186 = 225,
    T_SINGLEUSEID187 = 226,
    T_SINGLEUSEID190 = 227,
    T_SINGLEUSEID191 = 228,
    T_SINGLEUSEID194 = 229,
    T_SINGLEUSEID195 = 230,
    T_SINGLEUSEID196 = 231,
    T_SINGLEUSEID199 = 232,
    T_SINGLEUSEID202 = 233,
    T_SINGLEUSEID203 = 234,
    T_SINGLEUSEID204 = 235,
    T_SINGLEUSEID213 = 236,
    T_SINGLEUSEID214 = 237,
    T_SINGLEUSEID218 = 238,
    T_SINGLEUSEID219 = 239,
    T_SINGLEUSEID220 = 240,
    T_SINGLEUSEID221 = 241,
    T_SINGLEUSEID222 = 242,
    T_SINGLEUSEID223 = 243,
    T_SINGLEUSEID224 = 244,
    T_SINGLEUSEID225 = 245,
    T_SINGLEUSEID226 = 246,
    T_SINGLEUSEID227 = 247,
    T_SINGLEUSEID228 = 248,
    T_SINGLEUSEID229 = 249,
    T_SINGLEUSEID230 = 250,
    T_SINGLEUSEID231 = 251,
    T_SINGLEUSEID232 = 252,
    T_SINGLEUSEID233 = 253,
    T_SINGLEUSEID234 = 254,
    T_SINGLEUSEID235 = 255,
    T_SINGLEUSEID236 = 256,
    T_SINGLEUSEID237 = 257,
    T_SINGLEUSEID238 = 258,
    T_SINGLEUSEID239 = 259,
    T_SINGLEUSEID240 = 260,
    T_SINGLEUSEID241 = 261,
    T_SINGLEUSEID242 = 262,
    T_SINGLEUSEID245 = 263,
    T_SINGLEUSEID246 = 264,
    T_SINGLEUSEID247 = 265,
    T_SINGLEUSEID249 = 266,
    T_SINGLEUSEID250 = 267,
    T_SINGLEUSEID251 = 268,
    T_SINGLEUSEID252 = 269,
    T_SINGLEUSEID253 = 270,
    T_SINGLEUSEID254 = 271,
    T_SINGLEUSEID256 = 272,
    T_SINGLEUSEID257 = 273,
    T_SINGLEUSEID258 = 274,
    T_SINGLEUSEID259 = 275,
    T_SINGLEUSEID260 = 276,
    T_SINGLEUSEID261 = 277,
    T_SINGLEUSEID262 = 278,
    T_SINGLEUSEID263 = 279,
    T_SINGLEUSEID264 = 280,
    T_SINGLEUSEID265 = 281,
    T_SINGLEUSEID266 = 282,
    T_SINGLEUSEID267 = 283,
    T_SINGLEUSEID268 = 284,
    T_SINGLEUSEID273 = 285,
    T_SINGLEUSEID274 = 286,
    T_SINGLEUSEID281 = 287,
    T_SINGLEUSEID282 = 288,
    T_SINGLEUSEID283 = 289,
    T_SINGLEUSEID284 = 290,
    T_SINGLEUSEID285 = 291,
    T_SINGLEUSEID286 = 292,
    T_SINGLEUSEID290 = 293,
    T_SINGLEUSEID291 = 294,
    T_SINGLEUSEID292 = 295,
    T_SINGLEUSEID293 = 296,
    T_SINGLEUSEID294 = 297,
    T_SINGLEUSEID295 = 298,
    T_SINGLEUSEID296 = 299,
    T_SINGLEUSEID297 = 300,
    T_SINGLEUSEID298 = 301,
    T_SINGLEUSEID299 = 302,
    T_SINGLEUSEID300 = 303,
    T_SINGLEUSEID301 = 304,
    T_SINGLEUSEID302 = 305,
    T_SINGLEUSEID303 = 306,
    T_SINGLEUSEID304 = 307,
    T_SINGLEUSEID305 = 308,
    T_SINGLEUSEID306 = 309,
    T_SINGLEUSEID307 = 310,
    T_SINGLEUSEID308 = 311,
    T_SINGLEUSEID309 = 312,
    T_SINGLEUSEID310 = 313,
    T_SINGLEUSEID311 = 314,
    T_SINGLEUSEID312 = 315,
    T_SINGLEUSEID313 = 316,
    T_SINGLEUSEID314 = 317,
    T_SINGLEUSEID315 = 318,
    T_SINGLEUSEID316 = 319,
    T_SINGLEUSEID317 = 320,
    T_SINGLEUSEID318 = 321,
    T_SINGLEUSEID319 = 322,
    T_SINGLEUSEID320 = 323,
    T_SINGLEUSEID321 = 324,
    T_SINGLEUSEID322 = 325,
    T_SINGLEUSEID323 = 326,
    T_SINGLEUSEID324 = 327,
    T_SINGLEUSEID325 = 328,
    T_SINGLEUSEID326 = 329,
    T_SINGLEUSEID327 = 330,
    T_SINGLEUSEID328 = 331,
    T_SINGLEUSEID329 = 332,
    T_SINGLEUSEID330 = 333,
    T_SINGLEUSEID331 = 334,
    T_SINGLEUSEID332 = 335,
    T_SINGLEUSEID333 = 336,
    T_SINGLEUSEID336 = 337,
    T_SINGLEUSEID337 = 338,
    T_SINGLEUSEID338 = 339,
    T_SINGLEUSEID339 = 340,
    T_SINGLEUSEID340 = 341,
    T_SINGLEUSEID341 = 342,
    T_SINGLEUSEID342 = 343,
    T_SINGLEUSEID343 = 344,
    T_SINGLEUSEID348 = 345,
    T_SINGLEUSEID349 = 346,
    T_SINGLEUSEID350 = 347,
    T_SINGLEUSEID351 = 348,
    T_SINGLEUSEID352 = 349,
    T_SINGLEUSEID353 = 350,
    T_SINGLEUSEID354 = 351,
    T_SINGLEUSEID355 = 352,
    T_SINGLEUSEID356 = 353,
    T_SINGLEUSEID426 = 354,
    T_SINGLEUSEID427 = 355,
    T_SINGLEUSEID428 = 356,
    T_SINGLEUSEID429 = 357,
    T_SINGLEUSEID430 = 358,
    T_SINGLEUSEID431 = 359,
    T_SINGLEUSEID432 = 360,
    T_SINGLEUSEID433 = 361,
    T_INCOMINGCALLMETUTXT = 362,
    T_INCOMINGCALLPICKUPTXT = 363,
    T_INCOMINGCALLNAMETXT = 364,
    T_INCOMINGCALLTARGETTXT = 365,
    T_ALARMREMINDNAMETXT = 366,
    T_ALARMREMINDSLEEPTXT = 367,
    T_ALARMREMINDAMTXT = 368,
    T_ALARMREMINDPMTXT = 369,
    T_CHARGING_REMINDER_TXT = 370,
    T_CHARGING_STATUS_TXT = 371,
    T_CHARGING_STATUS1_TXT = 372,
    T_SETHEADTXT = 373,
    T_SETTING_1 = 374,
    T_SETTING_3 = 375,
    T_SETTING_5 = 376,
    T_SETTING_6 = 377,
    T_SHOW_HEAD = 378,
    T_CHANGE_DIAL = 379,
    T_ADJUST_BRIGHTNESS = 380,
    T_OPEN_SCREEN = 381,
    T_SYSTEM_TXT = 382,
    T_RESTART = 383,
    T_SHUT_DOWN = 384,
    T_RESTORE_THE_FACTORY = 385,
    T_ABOUT_TXT = 386,
    T_DEVICE_NAME = 387,
    T_DEVICE_CONTENT = 388,
    T_MODEL_TXT = 389,
    T_MODEL_CONTENT = 390,
    T_MAC_ADDRESS = 391,
    T_MAC_CONTENT = 392,
    T_VERSION_NUMBER = 393,
    T_VERSION_NUMBER_CONTENT = 394,
    T_SERIAL_NUMBER = 395,
    T_SERIAL_NUMBER_CONTENT = 396,
    T_ELECTRONIC_NAMEPLATE = 397,
    T_ELECTRONIC_NAMEPLATE_CONTENT = 398,
    T_LEGAL_NOTICES = 399,
    T_IDS_SET_ABOUT_DEVICE_INFO = 400,
    T_VIBRATION_STRENGTH_NAME = 401,
    T_RESTART_NAME = 402,
    T_RESTART_WATCH_OR_NOT = 403,
    T_ADJUST_BRIGHTNESS_NAME = 404,
    T_SHOW_ADJUST_NUMBER = 405,
    T_SHOW_ADJUST_BACK_NUMBER = 406,
    T_SHOW_ADJUST_CENTER_NUMBER = 407,
    T_SHOW_ADJUST_BACK_NUMBER_CURRENT_AUTO = 408,
    T_SHOW_ADJUST_BACK_NUMBER_CURRENT = 409,
    T_SHOW_ADJUST_BACK_NUMBER_CUSTOMER = 410,
    T_SHOW_ADJUST_CENTER_NUMBER_CUSTOMER = 411,
    T_SHUTDOWN_NAME = 412,
    T_SHUTDOWN_WATCH_OR_NOT = 413,
    T_RESTOREFACTORY_NAME = 414,
    T_RESTOREFACTORY_WATCH_OR_NOT = 415,
    T_LOCKSCREENTXT = 416,
    T_LOCKSCREENRELEASETXT = 417,
    T_IDS_COMPASS_ANGLE_TEXT_NORTH = 418,
    T_IDS_COMPASS_ANGLE_TEXT_NORTHEAST = 419,
    T_IDS_COMPASS_ANGLE_TEXT_EAST = 420,
    T_IDS_COMPASS_ANGLE_TEXT_SOUTHEAST = 421,
    T_IDS_COMPASS_ANGLE_TEXT_SOUTH = 422,
    T_IDS_COMPASS_ANGLE_TEXT_SOUTHWEST = 423,
    T_IDS_COMPASS_ANGLE_TEXT_WEST = 424,
    T_IDS_COMPASS_ANGLE_TEXT_NORTHWEST = 425,
    T_IDS_COMPASS_CALIBRATION_TEXT = 426,
    T_APP_TRAIN_SWIM1 = 427,
    T_APP_TRAIN_SWIM2 = 428,
    T_APP_TRAIN_SWIM3 = 429,
    T_APP_TRAIN_SWIM12 = 430,
    T_APP_TRAIN_SWIM13 = 431,
    T_APP_TRAIN_SWIM14 = 432,
    T_APP_TRAIN_SWIM15 = 433,
    T_APP_TRAIN_SWIM16 = 434,
    T_APP_TRAIN_SWIM17 = 435,
    T_APP_TRAIN_SWIM18 = 436,
    T_APP_TRAIN_SWIM19 = 437,
    T_APP_TRAIN_SWIM20 = 438,
    T_APP_TRAIN_SWIM21 = 439,
    T_APP_TRAIN_SWIM22 = 440,
    T_APP_TRAIN_SWIM29 = 441,
    T_APP_TRAIN_SWIM30 = 442,
    T_APP_TRAIN_SWIM31 = 443,
    T_APP_TRAIN_SWIM32 = 444,
    T_APP_TRAIN_SWIM33 = 445,
    T_APP_TRAIN_SWIM34 = 446,
    T_APP_TRAIN_SWIM35 = 447,
    T_APP_TRAIN_SWIM36 = 448,
    T_APP_TRAIN_SWIM37 = 449,
    T_APP_TRAIN_SWIM38 = 450,
    T_APP_TRAIN_SWIM39 = 451,
    T_APP_TRAIN_SWIM40 = 452,
    T_APP_TRAIN_SWIM41 = 453,
    T_APP_TRAIN_SWIM42 = 454,
    T_APP_TRAIN_SWIM43 = 455,
    T_APP_TRAIN_SWIM44 = 456,
    T_APP_TRAIN_SWIM45 = 457,
    T_APP_TRAIN_SWIM46 = 458,
    T_APP_TRAIN_SWIM47 = 459,
    T_APP_TRAIN_SWIM48 = 460,
    T_APP_TRAIN_SWIM51 = 461,
    T_APP_TRAIN_SWIM52 = 462,
    T_APP_TRAIN_SWIM53 = 463,
    T_APP_TRAIN_SWIM54 = 464,
    T_APP_TRAIN_SWIM55 = 465,
    T_APP_TRAIN_SWIM56 = 466,
    T_APP_TRAIN_SWIM63 = 467,
    T_APP_TRAIN_SWIM64 = 468,
    T_APP_TRAIN_SWIM65 = 469,
    T_APP_TRAIN_SWIM66 = 470,
    T_APP_TRAIN_SWIM67 = 471,
    T_APP_TRAIN_SWIM68 = 472,
    T_IDS_SWIM_BREASTSTROKE = 473,
    T_IDS_SWIM_BUTTERFLY_STROKE = 474,
    T_IDS_SWIM_FREESTYLE = 475,
    T_IDS_SWIM_BACKSTROKE = 476,
    T_IDS_SWIM_MIX = 477,
    T_APP_TRAIN_SWIM73 = 478,
    T_APP_TRAIN_SWIM74 = 479,
    T_APP_TRAIN_SWIM75 = 480,
    T_APP_TRAIN_SWIM84 = 481,
    T_APP_TRAIN_SWIM85 = 482,
    T_APP_TRAIN_SWIM88 = 483,
    T_APP_TRAIN_SWIM97 = 484,
    T_APP_TRAIN_SWIM100 = 485,
    T_APP_TRAIN_SWIM101 = 486,
    T_APP_TRAIN_SWIM102 = 487,
    T_APP_TRAIN_SWIM103 = 488,
    T_BUSCARDSBALANCETXT = 489,
    T_SETASDEFAULTTXT = 490,
    T_DEFAULTCARD = 491,
    T_BUSCARDSBALANCE = 492,
    T_PAYSUCCESS_TXT = 493,
    T_PAYSUCCESS_PAY_TXT = 494,
    T_PAYSUCCESS_BALANCE_TXT = 495,
    T_PAYSUCCESS_PAY_DYNAMIC_TXT = 496,
    T_PAYSUCCESS_BALANCE_DYNAMIC_TXT = 497,
    T_PAYFAILEDTXT = 498,
    T_PLEASE_TRY_AGAIN = 499,
    T_INSUFFICIENTBALANCETXT = 500,
    T_ADDBUSCARDS_OPENTXT = 501,
    T_ADDBUSCARDS_HUWEIPAYTXT = 502,
    T_ADDBUSCARDS_OPENAPPTXT = 503,
    T_BUSCARDS_SHENZHEN = 504,
    T_BUSCARDS_GUANGZHOU = 505,
    T_BUSCARDS_BEIJING = 506,
    T_BUSCARDS_SHANGHAI = 507,
    T_BUSCARDS_CHENGDU = 508,
    T_BUSCARDS_WUHAN = 509,
    T_BUSCARDS_CHANGAN = 510,
    T_BUSCARDS_SUZHOU = 511,
    T_BUSCARDS_GUANGXI = 512,
    T_ADDBUSCARDS_OPENPHONEPAY = 513,
    T_EXPLORER_KCAL_NAME_ID = 514,
    T_EXPLORER_STEP_NAME_ID = 515,
    T_EXPLORER_HEART_RATE_NAME_ID = 516,
    T_EXPLORER_WEEK_SUN_28_ID = 517,
    T_EXPLORER_WEEK_MON_28_ID = 518,
    T_EXPLORER_WEEK_TUE_28_ID = 519,
    T_EXPLORER_WEEK_WED_28_ID = 520,
    T_EXPLORER_WEEK_THU_28_ID = 521,
    T_EXPLORER_WEEK_FRI_28_ID = 522,
    T_EXPLORER_WEEK_SAT_28_ID = 523,
    T_SETTING_WEEK_SUN_26_ID = 524,
    T_SETTING_WEEK_MON_26_ID = 525,
    T_SETTING_WEEK_TUE_26_ID = 526,
    T_SETTING_WEEK_WED_26_ID = 527,
    T_SETTING_WEEK_THU_26_ID = 528,
    T_SETTING_WEEK_FRI_26_ID = 529,
    T_SETTING_WEEK_SAT_26_ID = 530,
    T_IDS_WEATHER_CITY = 531,
    T_IDS_WEATHER_TEXT_SUNY = 532,
    T_IDS_WEATHER_TEXT_CLOUDY = 533,
    T_IDS_WEATHER_TEXT_OVERCAST = 534,
    T_IDS_WEATHER_TEXT_SHOWER = 535,
    T_IDS_WEATHER_TEXT_THUNDERSHOWER = 536,
    T_IDS_WEATHER_TEXT_THUNDERSHOWERHAIL = 537,
    T_IDS_WEATHER_TEXT_SLEET = 538,
    T_IDS_WEATHER_TEXT_LIGHTRAIN = 539,
    T_IDS_WEATHER_TEXT_MODERATERAIN = 540,
    T_IDS_WEATHER_TEXT_HEAVYRAIN = 541,
    T_IDS_WEATHER_TEXT_STORM = 542,
    T_IDS_WEATHER_TEXT_HEAVYSTORM = 543,
    T_IDS_WEATHER_TEXT_SEVERESTORM = 544,
    T_IDS_WEATHER_TEXT_SNOWFLURRY = 545,
    T_IDS_WEATHER_TEXT_LIGHTSNOW = 546,
    T_IDS_WEATHER_TEXT_MODERATESNOW = 547,
    T_IDS_WEATHER_TEXT_HEAVYSNOW = 548,
    T_IDS_WEATHER_TEXT_SNOWSTORM = 549,
    T_IDS_WEATHER_TEXT_FOGGY = 550,
    T_IDS_WEATHER_TEXT_ICERAIN = 551,
    T_IDS_WEATHER_TEXT_DUSTSTORM = 552,
    T_IDS_WEATHER_TEXT_LIGHTTOMODERATERAIN = 553,
    T_IDS_WEATHER_TEXT_MODERATETOHEAVYRAIN = 554,
    T_IDS_WEATHER_TEXT_HEAVYTOSTORMRAIN = 555,
    T_IDS_WEATHER_TEXT_STORMTOHEAVYSTORMRAIN = 556,
    T_IDS_WEATHER_TEXT_HEAVYTOSEVERESTORM = 557,
    T_IDS_WEATHER_TEXT_LIGHTTOMODERATESNOW = 558,
    T_IDS_WEATHER_TEXT_MODERATETOHEAVYSNOW = 559,
    T_IDS_WEATHER_TEXT_HEAVYSNOWTOSNOWSTORM = 560,
    T_IDS_WEATHER_TEXT_DUST = 561,
    T_IDS_WEATHER_TEXT_SAND = 562,
    T_IDS_WEATHER_TEXT_SANDSTORM = 563,
    T_IDS_WEATHER_TEXT_HAZE = 564,
    T_IDS_WEATHER_TEXT_UNKNOWN = 565,
    T_IDS_WEATHER_PM2DOT5_TEXT_EXCELLENT = 566,
    T_IDS_WEATHER_PM2DOT5_TEXT_GOOD = 567,
    T_IDS_WEATHER_PM2DOT5_TEXT_LIGHT = 568,
    T_IDS_WEATHER_PM2DOT5_TEXT_MODERATE = 569,
    T_IDS_WEATHER_PM2DOT5_TEXT_SEVERE = 570,
    T_IDS_WEATHER_NOTICE_TITLE = 571,
    T_IDS_WEATHER_NOTICE_INFO = 572,
    T_LOCK_ID = 573,
    T_UNLOCK_ID = 574,
    T_IDS_TRAIN_STEPFREQUENCY = 575,
    T_IDS_ALTIMETER_TITLE = 576,
    T_IDS_ALTIMETER_NUM_CUR_UNIT = 577,
    T_IDS_BAROMETERS_TITLE = 578,
    T_IDS_BAROMETERS_NUM_CUR_UNIT = 579,
    T_IDS_ALT_BAR_BUTTON_TEXT = 580,
    T_IDS_ALT_BAR_TEXT_DEFAULT_CARD = 581,
    T_IDS_ALT_BAR_BUTTON_TEXT_CALIBRATE = 582,
    T_IDS_ALT_BAR_BUTTON_TEXT_OK = 583,
    T_IDS_ALT_BAR_BUTTON_TEXT_ENTER = 584,
    T_IDS_ALT_BAR_TEXT_CAL_NOTICE = 585,
    T_IDS_ALT_BAR_TEXT_CAL_INFO = 586,
    T_IDS_ALT_BAR_TEXT_CAL_FAIL = 587,
    T_IDS_ALT_BAR_TEXT_CAL_PROCESS = 588,
    T_IDS_ALT_BAR_TEXT_ATTENTION = 589,
    T_IDS_ALT_BAR_TEXT_CLOCK = 590,
    T_IDS_ALT_BAR_TEXT_INFORMATION = 591,
    T_HEALTH_CALO_2_ID = 592,
    T_HEALTH_PRESSURE_ID = 593,
    T_SINGLEUSEID360 = 594,
    T_SINGLEUSEID362 = 595,
    T_SINGLEUSEID363 = 596,
    T_SINGLEUSEID364 = 597,
    T_SINGLEUSEID365 = 598,
    T_SINGLEUSEID366 = 599,
    T_SINGLEUSEID367 = 600,
    T_SINGLEUSEID368 = 601,
    T_SINGLEUSEID369 = 602,
    T_SINGLEUSEID370 = 603,
    T_SINGLEUSEID371 = 604,
    T_SINGLEUSEID372 = 605,
    T_SINGLEUSEID373 = 606,
    T_SINGLEUSEID374 = 607,
    T_SINGLEUSEID375 = 608,
    T_SINGLEUSEID376 = 609,
    T_SINGLEUSEID377 = 610,
    T_SINGLEUSEID378 = 611,
    T_SINGLEUSEID379 = 612,
    T_SINGLEUSEID381 = 613,
    T_SINGLEUSEID383 = 614,
    T_SINGLEUSEID385 = 615,
    T_SINGLEUSEID387 = 616,
    T_SINGLEUSEID388 = 617,
    T_SINGLEUSEID389 = 618,
    T_SINGLEUSEID391 = 619,
    T_SINGLEUSEID392 = 620,
    T_SINGLEUSEID393 = 621,
    T_SINGLEUSEID394 = 622,
    T_PARTICLES_WHEEL_SELECTOR_BACKGROUND = 623,
    T_PARTICLES_WHEEL_SELECTOR_CENTER = 624,
    T_SINGLEUSEID395 = 625,
    T_SINGLEUSEID396 = 626,
    T_SINGLEUSEID397 = 627,
    T_SINGLEUSEID398 = 628,
    T_SINGLEUSEID399 = 629,
    T_SINGLEUSEID400 = 630,
    T_SINGLEUSEID401 = 631,
    T_SINGLEUSEID402 = 632,
    T_SINGLEUSEID403 = 633,
    T_SINGLEUSEID404 = 634,
    T_SINGLEUSEID405 = 635,
    T_SINGLEUSEID406 = 636,
    T_SINGLEUSEID407 = 637,
    T_SINGLEUSEID408 = 638,
    T_SINGLEUSEID409 = 639,
    T_SINGLEUSEID410 = 640,
    T_SINGLEUSEID411 = 641,
    T_SINGLEUSEID412 = 642,
    T_SINGLEUSEID413 = 643,
    T_SINGLEUSEID414 = 644,
    T_SINGLEUSEID415 = 645,
    T_SINGLEUSEID416 = 646,
    T_SINGLEUSEID417 = 647,
    T_SINGLEUSEID418 = 648,
    T_SINGLEUSEID419 = 649,
    T_SINGLEUSEID420 = 650,
    T_SINGLEUSEID421 = 651,
    T_SINGLEUSEID422 = 652,
    T_SINGLEUSEID423 = 653,
    T_SINGLEUSEID424 = 654,
    T_SINGLEUSEID425 = 655,
    T_DO_NOT_DISTURB_MODE = 656,
    T_DO_NOT_DISTURB_MODE_TXT = 657,
    T_NO_DISTURB_THE_TIME_PERIOD_TXT = 658,
    T_START_TIME_TXT = 659,
    T_END_TIME_TXT = 660,
    T_CLICK_SUER_TXT = 661,
    T_TIME_ADJUST_TXT = 662,
    T_HOUR_TICK_TXT = 663,
    T_MINUTE_TICK_TXT = 664,
    T_TIME_ADJUST_MINUTE_TXT = 665,
    T_TIME_DOT_TXT = 666,
    T_TIME_ADJUST_HOUR_TXT = 667,
    T_SECOND_DAY_TXT = 668,
    T_STARTTIME_ADJUST_HOUR_SHOW = 669,
    T_STARTTIME_ADJUST_MINUTE_SHOW = 670,
    T_ENDTIME_ADJUST_HOUR_SHOW = 671,
    T_ENDTIME_ADJUST_MINUTE_SHOW = 672,
    T_IDS_SET_DISTURB_TIME_SECOND_DAY = 673,
    T_DISTURB_MODEL_ON_TXT = 674,
    T_DISTURB_MODEL_OFF_TXT = 675,
    T_SHOW_TIME_TXT = 676,
    T_SHOW_TIME_ON_TXT = 677,
    T_SHOW_TIME_OFF_TXT = 678,
    T_U_LOW_POWER = 679,
    T_ALARMCLOCKLISTMODETXT = 680,
    T_ALARMCLOCKEDITTXT = 681,
    T_ALARMCLOCKDELETETXT = 682,
    T_TIMEDATETXT = 683,
    T_NOTETXT = 684,
    T_MODETXT = 685,
    T_ALARMCLOCKMODETXT = 686,
    T_ALARMCLOCK_ALARMCLOCKTXT = 687,
    T_ALARMCLOCK_ADDALARMCLOCKTXT = 688,
    T_ALARMCLOCK_SETTIMERTXT = 689,
    T_ALARMCLOCK_NEXTTXT = 690,
    T_ALARMCLOCK_SETHOURTXT = 691,
    T_ALARMCLOCK_SETMINTXT = 692,
    T_FAC_MAC_ADDR_TXT = 693,
    T_FAC_SERVER_ADDR_TXT = 694,
    T_ULTRALLOWPOWER = 695,
    T_STOP_RUNING_TXT = 696,
    T_STOP_RUNING_DISTANCE_FEW_TXT = 697,
    T_STOP_RUNING_TIME_FEW_TXT = 698,
    T_CHANGE_DISTANCE_REMIND_TXT = 699,
    T_CHANGE_DISTANCE_CALIBRATION_TXT = 700,
    T_IDS_RUNWAY_RESOURCEID2 = 701,
    T_IDS_RUNWAY_RUNTYPE = 702,
    T_IDS_RUNWAY_RESOURCEID9 = 703,
    T_IDS_RUNWAY_RESOURCEID16 = 704,
    T_IDS_RUNWAY_RESOURCEID17 = 705,
    T_IDS_RUNWAY_RESOURCEID19 = 706,
    T_IDS_RUNWAY_RESOURCEID21 = 707,
    T_IDS_RUNWAY_RESOURCEID23 = 708,
    T_IDS_RUNWAY_DETAILID1 = 709,
    T_IDS_RUNWAY_RUNNING_COMPLETED2 = 710,
    T_IDS_RUNWAY_DETAIL_CONTENT_MIN = 711,
    T_IDS_RUNWAY_COURSE_DELETE = 712,
    T_IDS_RUNWAY_COURSE_NAME = 713,
    T_IDS_RUNWAY_COURSE_INFO = 714,
    T_IDS_RUNWAY_COURSE_NAME_ITEM = 715,
    T_IDS_RUNWAY_COURSE_LEVEL = 716,
    T_IDS_RUNWAY_COURSE_LEVEL_EASY = 717,
    T_IDS_RUNWAY_HEART_RATE_UNIT = 718,
    T_IDS_RUNWAY_HEART_RATE_ALARM1 = 719,
    T_IDS_RUNWAY_HEART_RATE_ALARM2 = 720,
    T_IDS_RUNWAY_STAGE_DESC = 721,
    T_IDS_RUNWAY_HEART_RATE_SUGGEST = 722,
    T_IDS_RUNWAY_SYNC_INFO = 723,
    T_IDS_RUNWAY_SPEED_UNIT = 724,
    T_IDS_RUNWAY_SPEED_ALARM1 = 725,
    T_IDS_RUNWAY_SPEED_ALARM2 = 726,
    T_IDS_RUNWAY_COURSE_LEVEL_BASIS = 727,
    T_IDS_RUNWAY_COURSE_LEVEL_ADVANCED = 728,
    T_IDS_RUNWAY_COURSE_LEVEL_STRENGTHEN = 729,
    T_IDS_RUNWAY_COURSE_LEVEL_ITEM = 730,
    T_IDS_RUNWAY_DISTANCE = 731,
    T_IDS_RUNWAY_ACTION_NAME1 = 732,
    T_IDS_RUNWAY_ACTION_NAME2 = 733,
    T_IDS_RUNWAY_ACTION_NAME3 = 734,
    T_IDS_RUNWAY_ACTION_NAME4 = 735,
    T_IDS_RUNWAY_ACTION_NAME5 = 736,
    T_IDS_RUNWAY_ACTION_NAME6 = 737,
    T_IDS_RUNWAY_ACTION_NAME7 = 738,
    T_IDS_RUNWAY_ACTION_NAME8 = 739,
    T_IDS_RUNWAY_ACTION_NAME9 = 740,
    T_IDS_RUNWAY_ACTION_NAME10 = 741,
    T_IDS_RUNWAY_COURSE_DESC = 742,
    T_IDS_RUNWAY_COURSE_DESC1 = 743,
    T_IDS_RUNWAY_ACTION_NAME = 744,
    T_IDS_RUNWAY_ACTION_DATA_UNIT1 = 745,
    T_IDS_RUNWAY_ACTION_DATA_UNIT2 = 746,
    T_IDS_RUNWAY_ACTION_DATA = 747,
    T_IDS_RUNWAY_SPEED_SUGGEST = 748,
    T_IDS_RUNWAY_SPEED_SUGGEST_UNIT = 749,
    T_IDS_RUNWAY__HEART_RATE_DATA_UNIT = 750,
    T_IDS_RUNWAY_RUNNING_REST_DISTANCE = 751,
    T_IDS_RUNWAY_RUNNING_REST_TIME = 752,
    T_IDS_RUNWAY_COURSE_NAME1 = 753,
    T_IDS_RUNWAY_COURSE_NAME2 = 754,
    T_IDS_RUNWAY_COURSE_NAME3 = 755,
    T_IDS_RUNWAY_COURSE_NAME4 = 756,
    T_IDS_RUNWAY_COURSE_NAME5 = 757,
    T_IDS_RUNWAY_COURSE_NAME6 = 758,
    T_IDS_RUNWAY_COURSE_NAME7 = 759,
    T_IDS_RUNWAY_COURSE_NAME8 = 760,
    T_IDS_RUNWAY_COURSE_NAME9 = 761,
    T_WATCH_FACE_METER_ID = 762,
    T_WATCH_FACE_EXPLORER_ID = 763,
    T_WATCH_FACE_HEALTH_ID = 764,
    T_WATCH_FACE_TECHNOLOGY_ID = 765,
    T_WATCH_FACE_ENERGY_ID = 766,
    T_WATCH_FACE_OUTDOORS_ID = 767,
    T_WATCH_FACE_ENGRAVE_ID = 768,
    T_WATCH_FACE_HEART_RATE_ID = 769,
    T_WATCH_FACE_WEATHER_ID = 770,
    T_WATCH_FACE_THREENEEDLES_ID = 771,
    T_WATCH_FACE_DARKBLUE_ID = 772,
    T_ALARM_ONCE_TXT = 773,
    T_ALARM_CHOSE_MODE_1 = 774,
    T_ALARM_CHOSE_MODE_2 = 775,
    T_ALARM_CHOSE_MODE_3 = 776,
    T_ALARM_CHOSE_MODE_4 = 777,
    T_ALARM_CHOSE_MODE_5 = 778,
    T_ALARM_CHOSE_MODE_6 = 779,
    T_ALARM_CHOSE_MODE_7 = 780,
    T_ALARM_CHOSE_MODE_CONFIRM = 781,
    T_ENEGY_STEP_NUM_ID = 782,
    T_MARATHONREMIND_NAME = 783,
    T_MARATHONREMIND_NAME1 = 784,
    T_A039_RESOURCEID1 = 785,
    T_A039_RESOURCEID2 = 786,
    T_A039_RESOURCEID4 = 787,
    T_PROMOTION_PHYSICAL_FITNESS_TXT = 788,
    T_EXCESSIVE_EXERCISE_TXT = 789,
    T_HEARTRATE_NUMBER_TXT = 790,
    T_HEARTRATE_TOO_HIGH_TXT = 791,
    T_HEARTRATE_TOO_LOW_TXT = 792,
    T_HEARTRATE_EXCEEDS_UPPER_LIMIT = 793,
    T_NON_AEROBIC_TRAINING_EFFECT_TXT = 794,
    T_SMALL_EFFECT_TXT = 795,
    T_IMPROVE_PHYSICAL_FITNESS_TXT = 796,
    T_MAINTAIN_HEALTH_TXT = 797,
    T_STEP_NAME_TXT = 798,
    T_TARGET_REACH_TXT = 799,
    T_RUN_DISTANCE_TXT1 = 800,
    T_RUN_DISTANCE_TXT = 801,
    T_RUN_TIME_TXT = 802,
    T_RUN_CALORIE_TXT = 803,
    T_INFORMATION_LIST_NAME = 804,
    T_INFORMATION_LIST_CONTENT = 805,
    T_INFORMATION_CLEARALL = 806,
    T_INFORMATION_DETAIL_NAME = 807,
    T_INFORMATION_DETAIL_CONTENT = 808,
    T_INFORMATION_NO_MSG = 809,
    T_IDS_SCREEN2_ALTITUDE_TITLE = 810,
    T_IDS_SCREEN2_ALTITUDE_UNIT = 811,
    T_IDS_SCREEN2_TE_TITLE = 812,
    T_IDS_SCREEN2_TE_AEROBIC = 813,
    T_IDS_SCREEN2_TE_ANAEROBIC = 814,
    T_TRAINING_RECORD001 = 815,
    T_TRAINING_RECORD004 = 816,
    T_TRAINING_RECORD005 = 817,
    T_SCREEN3_511 = 818,
    T_SCREEN3_512 = 819,
    T_SCREEN3_513 = 820,
    T_BREATHE_HEART_RATE_UINIT = 821,
    T_BREATHE_HEART_RATE_PRE = 822,
    T_BREATHE_TIME_LENGTH = 823,
    T_BREATHE_RESULT_1 = 824,
    T_BREATHE_RESULT_2 = 825,
    T_CHANGE_DISTANCE_UNIT_TXT = 826,
    T_CHANGE_DISTANCE_SAVE_TXT = 827,
    T_BREATHE_NO_WEAR = 828,
    T_ALARM_MODE_26_1 = 829,
    T_ALARM_MODE_26_2 = 830,
    T_ALARM_MODE_26_3 = 831,
    T_ALARM_MODE_26_4 = 832,
    T_ALARM_MODE_26_5 = 833,
    T_ALARM_MODE_26_6 = 834,
    T_ALARM_MODE_26_7 = 835,
    T_ALARM_NOTETXT = 836,
    T_IDS_RUNWAY_COURSE_FINISH_TIME = 837,
    T_IDS_RUNWAY_COURSE_NAME1_BIG = 838,
    T_IDS_RUNWAY_COURSE_NAME2_BIG = 839,
    T_IDS_RUNWAY_COURSE_NAME3_BIG = 840,
    T_IDS_RUNWAY_COURSE_NAME4_BIG = 841,
    T_IDS_RUNWAY_COURSE_NAME5_BIG = 842,
    T_IDS_RUNWAY_COURSE_NAME6_BIG = 843,
    T_IDS_RUNWAY_COURSE_NAME7_BIG = 844,
    T_IDS_RUNWAY_COURSE_NAME8_BIG = 845,
    T_IDS_RUNWAY_COURSE_NAME9_BIG = 846,
    T_IDS_RUNWAY_COURSE_NAME0_BIG = 847,
    T_HEART_RATE_ALARM_32_1 = 848,
    T_HEART_RATE_ALARM_26_1 = 849,
    T_HEARTRATE_CHINA12 = 850,
    T_HEARTRATE_CHINA13 = 851,
    T_HEARTRATE_CHINA14 = 852,
    T_HEARTRATE_CHINA15 = 853,
    T_HEARTRATE_CHINA16 = 854,
    T_IDS_ALARM_NAME = 855,
    T_IDS_SCREEN2_TE_RESULT_0 = 856,
    T_IDS_SCREEN2_TE_RESULT_1 = 857,
    T_IDS_SCREEN2_TE_RESULT_2 = 858,
    T_IDS_SCREEN2_TE_RESULT_3 = 859,
    T_IDS_SCREEN2_TE_RESULT_4 = 860,
    T_IDS_SCREEN2_TE_RESULT_5 = 861,
    T_IDS_ALARM_SMART_NAME = 862,
    T_IDS_ALARM_ALARM_ONCE = 863,
    T_VIRTUALMATE_RESOURCEID01 = 864,
    T_VIRTUALMATE_RESOURCEID02 = 865,
    T_VIRTUALMATE_RESOURCEID03 = 866,
    T_VIRTUALMATE_RESOURCEID04 = 867,
    T_VIRTUALMATE_RESOURCEID05 = 868,
    T_IDS_SCREEN2_TE_RESULT_ANAEROBIC_0 = 869,
    T_IDS_SCREEN2_TE_RESULT_ANAEROBIC_1 = 870,
    T_IDS_SCREEN2_TE_RESULT_ANAEROBIC_2 = 871,
    T_IDS_SCREEN2_TE_RESULT_ANAEROBIC_3 = 872,
    T_IDS_SCREEN2_TE_RESULT_ANAEROBIC_4 = 873,
    T_IDS_SCREEN2_TE_RESULT_ANAEROBIC_5 = 874,
    T_IDS_RUNWAY_COURSE_NAME10_BIG = 875,
    T_IDS_RUNWAY_COURSE_NAME11_BIG = 876,
    T_IDS_RUNWAY_COURSE_NAME12_BIG = 877,
    T_IDS_RUNWAY_COURSE_DESC00 = 878,
    T_IDS_RUNWAY_COURSE_DESC01 = 879,
    T_IDS_RUNWAY_COURSE_DESC02 = 880,
    T_IDS_RUNWAY_COURSE_DESC03 = 881,
    T_IDS_RUNWAY_COURSE_DESC04 = 882,
    T_IDS_RUNWAY_COURSE_DESC05 = 883,
    T_IDS_RUNWAY_COURSE_DESC06 = 884,
    T_IDS_RUNWAY_COURSE_DESC07 = 885,
    T_IDS_RUNWAY_COURSE_DESC08 = 886,
    T_IDS_RUNWAY_COURSE_DESC09 = 887,
    T_IDS_RUNWAY_COURSE_DESC10 = 888,
    T_IDS_RUNWAY_COURSE_DESC11 = 889,
    T_IDS_RUNWAY_COURSE_DESC12 = 890,
    T_IDS_RUNWAY_ACTION_NAME1_BIG = 891,
    T_IDS_RUNWAY_ACTION_NAME2_BIG = 892,
    T_IDS_RUNWAY_ACTION_NAME3_BIG = 893,
    T_IDS_RUNWAY_ACTION_NAME4_BIG = 894,
    T_IDS_RUNWAY_ACTION_NAME5_BIG = 895,
    T_IDS_RUNWAY_ACTION_NAME6_BIG = 896,
    T_IDS_RUNWAY_ACTION_NAME7_BIG = 897,
    T_IDS_RUNWAY_ACTION_NAME8_BIG = 898,
    T_IDS_RUNWAY_ACTION_NAME9_BIG = 899,
    T_IDS_RUNWAY_ACTION_NAME10_BIG = 900,
    T_IDS_EPHEMERIS_UPDATE = 901,
    T_IDS_EPHEMERIS_UPDATE_CONTENT1 = 902,
    T_IDS_EPHEMERIS_UPDATE_CONTENT2 = 903,
    T_SIT_LONG_TXT = 904,
    T_TRAININGSTATUS_STATIC = 905,
    T_TRAININGSTATUS_STATUS1 = 906,
    T_TRAININGSTATUS_STATUS2 = 907,
    T_TRAININGSTATUS_STATUS3 = 908,
    T_TRAININGSTATUS_STATUS4 = 909,
    T_TRAININGSTATUS_STATUS5 = 910,
    T_TRAININGSTATUS_STATUS6 = 911,
    T_TRAININGSTATUS_STATUS7 = 912,
    T_TRAININGSTATUS_STATUS8 = 913,
    T_TRAININGSTATUS_PHYSICAL = 914,
    T_TRAININGSTATUS_LOAD = 915,
    T_TRAININGSTATUS_STATUSBUFFER = 916,
    T_TRAININGSTATUS_TEXT1 = 917,
    T_TRAININGSTATUS_RECOVERYTIME_STATIC = 918,
    T_TRAININGSTATUS_RECOVERYTIME_REMIND = 919,
    T_TRAININGSTATUS_RECOVERYTIME_REMIND2 = 920,
    T_TRAININGSTATUS_RECOVERYTIME_REMIND3 = 921,
    T_TRAININGSTATUS_RECOVERYTIME_STATUS_BUFF = 922,
    T_TRAININGSTATUS_LOAD_STATIC = 923,
    T_TRAININGSTATUS_LOAD_TYPE1 = 924,
    T_TRAININGSTATUS_LOAD_TYPE2 = 925,
    T_TRAININGSTATUS_LOAD_TYPE3 = 926,
    T_TRAININGSTATUS_LOAD_TYPE4 = 927,
    T_TRAININGSTATUS_LOAD_STATUS_BUFF = 928,
    T_TRAININGSTATUS_TEXT2 = 929,
    T_TRAININGSTATUS_TEXT3 = 930,
    T_TRAININGSTATUS_VO2_STATIC = 931,
    T_TRAININGSTATUS_VO2_TYPE = 932,
    T_TRAININGSTATUS_VO2_TYPE1 = 933,
    T_TRAININGSTATUS_VO2_TYPE2 = 934,
    T_TRAININGSTATUS_VO2_TYPE3 = 935,
    T_TRAININGSTATUS_VO2_TYPE4 = 936,
    T_TRAININGSTATUS_VO2_TYPE5 = 937,
    T_TRAININGSTATUS_VO2_TYPE6 = 938,
    T_TRAININGSTATUS_VO2_TYPE7 = 939,
    T_TRAININGSTATUS_VO2_UTIL = 940,
    T_TRAININGSTATUS_VO2_STATUS_BUFF = 941,
    T_SCREEN3_EXCERCE_TYPE_VALUE = 942,
    T_SCREEN3_EXCERCE_TYPE_RESOURCEID2 = 943,
    T_SCREEN3_EXCERCE_TYPE_RESOURCEID3 = 944,
    T_SCREEN3_EXCERCE_TYPE_RESOURCEID4 = 945,
    T_SCREEN3_EXCERCE_TYPE_RESOURCEID5 = 946,
    T_SCREEN3_EXCERCE_TYPE_RESOURCEID6 = 947,
    T_SCREEN3_EXCERCE_TYPE_RESOURCEID7 = 948,
    T_SCREEN3_EXCERCE_TYPE_RESOURCEID8 = 949,
    T_SCREEN3_EXCERCE_TYPE_RESOURCEID9 = 950,
    T_SCREEN3_EXCERCE_TYPE_RESOURCEID10 = 951,
    T_SCREEN3_EXCERCE_TYPE_RESOURCEID11 = 952,
    T_BREATHE_TIME_SET_UNIT = 953,
    T_BREATHE_RESULT_3 = 954,
    T_BREATHE_RESULT_4 = 955,
    T_BREATHE_RESULT_5 = 956,
    T_BREATHE_RESULT_6 = 957,
    T_BREATHE_SUCTION = 958,
    T_BREATHE_EXPIRATION = 959,
    T_BREATHE_RHYTHEM_1 = 960,
    T_BREATHE_RHYTHEM_2 = 961,
    T_BREATHE_RHYTHEM_3 = 962,
    T_BREATHE_RHYTHEM_4 = 963,
    T_BREATHE_RHYTHEM_5 = 964,
    T_BREATHE_RHYTHEM_6 = 965,
    T_BREATHE_RHYTHEM_7 = 966,
    T_BREATHE_RHYTHEM_8 = 967,
    T_BREATHE_RHYTHEM_9 = 968,
    T_BREATHE_START_WAIT_NOTICE1 = 969,
    T_BREATHE_START_WAIT_NOTICE2 = 970,
    T_BREATHE_HEART_RATE_PRE_UNIT = 971,
    T_BREATHE_TIME_LENGTH_UNIT = 972,
    T_ITEM_HEAD = 973,
    T_ITEM_0 = 974,
    T_ITEM_1 = 975,
    T_ITEM_2 = 976,
    T_ITEM_3 = 977,
    T_ITEM_4 = 978,
    T_ITEM_5 = 979,
    T_ITEM_6 = 980,
    T_ITEM_7 = 981,
    T_ITEM_8 = 982,
    T_ITEM_9 = 983,
    T_ITEM_10 = 984,
    T_ITEM_11 = 985,
    T_ITEM_12 = 986,
    T_ITEM_13 = 987,
    T_ITEM_14 = 988,
    T_TRAINDATAPAGE1_TIME = 989,
    T_TRAINDATAPAGE1_DISTANCE = 990,
    T_TRAINDATAPAGE1_HEARTRATE = 991,
    T_TRAINDATAPAGE1_PACE = 992,
    T_TRAINDATAPAGE1_AVGPACE = 993,
    T_TRAINDATAPAGE1_SPEED = 994,
    T_TRAINDATAPAGE1_AVGSPEED = 995,
    T_TRAINDATAPAGE1_TOTALCALORIES = 996,
    T_TRAINDATAPAGE1_CADENCE = 997,
    T_TRAINDATAPAGE1_STEPS = 998,
    T_TRAINDATAPAGE1_TOTALCLIMBING = 999,
    T_TRAINDATAPAGE1_TOTALDESCENT = 1000,
    T_TRAINDATAPAGE1_VERTICALSPEED = 1001,
    T_TRAINDATAPAGE1_LAPS = 1002,
    T_TRAINDATAPAGE1_TOTALHEIGHT = 1003,
    T_TRAINDATAPAGE1_1_DISTANCE = 1004,
    T_TRAINDATAPAGE1_1_TOTALCLIMBING = 1005,
    T_TRAINDATAPAGE1_1_TOTALDESCENT = 1006,
    T_TRAINDATAPAGE1_1_TOTALHEIGHT = 1007,
    T_TRAINDATAPAGE3_TIME = 1008,
    T_TRAINDATAPAGE3_DISTANCE = 1009,
    T_TRAINDATAPAGE3_HEARTRATE = 1010,
    T_TRAINDATAPAGE3_PACE = 1011,
    T_TRAINDATAPAGE3_AVGPACE = 1012,
    T_TRAINDATAPAGE3_SPEED = 1013,
    T_TRAINDATAPAGE3_AVGSPEED = 1014,
    T_TRAINDATAPAGE3_TOTALCALORIES = 1015,
    T_TRAINDATAPAGE3_CADENCE = 1016,
    T_TRAINDATAPAGE3_STEPS = 1017,
    T_TRAINDATAPAGE3_TOTALCLIMBING = 1018,
    T_TRAINDATAPAGE3_TOTALDESCENT = 1019,
    T_TRAINDATAPAGE3_VERTICALSPEED = 1020,
    T_TRAINDATAPAGE3_LAPS = 1021,
    T_TRAINDATAPAGE3_TOTALHEIGHT = 1022,
    T_TRAINDATAPAGE3_1_DISTANCE = 1023,
    T_TRAINDATAPAGE3_1_TOTALCLIMBING = 1024,
    T_TRAINDATAPAGE3_1_TOTALDESCENT = 1025,
    T_TRAINDATAPAGE3_1_TOTALHEIGHT = 1026,
    T_TRAINDATAPAGE4_TIME = 1027,
    T_TRAINDATAPAGE4_DISTANCE = 1028,
    T_TRAINDATAPAGE4_HEARTRATE = 1029,
    T_TRAINDATAPAGE4_PACE = 1030,
    T_TRAINDATAPAGE4_AVGPACE = 1031,
    T_TRAINDATAPAGE4_SPEED = 1032,
    T_TRAINDATAPAGE4_AVGSPEED = 1033,
    T_TRAINDATAPAGE4_TOTALCALORIES = 1034,
    T_TRAINDATAPAGE4_CADENCE = 1035,
    T_TRAINDATAPAGE4_STEPS = 1036,
    T_TRAINDATAPAGE4_TOTALCLIMBING = 1037,
    T_TRAINDATAPAGE4_TOTALDESCENT = 1038,
    T_TRAINDATAPAGE4_VERTICALSPEED = 1039,
    T_TRAINDATAPAGE4_LAPS = 1040,
    T_TRAINDATAPAGE4_TOTALHEIGHT = 1041,
    T_TRAINDATAPAGE4_1_DISTANCE = 1042,
    T_TRAINDATAPAGE4_1_TOTALCLIMBING = 1043,
    T_TRAINDATAPAGE4_1_TOTALDESCENT = 1044,
    T_TRAINDATAPAGE4_1_TOTALHEIGHT = 1045,
    T_NOT_SUPPORT_CUSTOM = 1046,
    T_TRAINING_RECORD006 = 1047,
    T_APP_TRAIN_SWIM105 = 1048,
    T_APP_TRAIN_SWIM106 = 1049,
    T_APP_TRAIN_SWIM107 = 1050,
    T_APP_TRAIN_SWIM108 = 1051,
    T_NFF_YES_TEXT = 1052,
    T_NFF_NO_TEXT = 1053,
    T_NFF_VALUE_TEXT = 1054,
    T_NFF_START_TEXT = 1055,
    T_NFF_RESULT_VERIFY = 1056,
    T_NFF_MOTOR_START_TEXT = 1057,
    T_NFF_MOTOR_TEXT = 1058,
    T_NFF_KEY_TEXT = 1059,
    T_NFF_KEY_Y_TEXT = 1060,
    T_NFF_KEY_N_TEXT = 1061,
    T_NFF_SCREEN_DARK_TEXT = 1062,
    T_NFF_SCREEN_LIGHT_TEXT = 1063,
    T_NFF_ACC_START_TEXT = 1064,
    T_NFF_ACC_STILL_TEXT = 1065,
    T_NFF_ACC_MOVE_TEXT = 1066,
    T_NFF_PPG_START_TEXT = 1067,
    T_NFF_PPG_VALUE_TEXT = 1068,
    T_NFF_GYRO_START_TEXT = 1069,
    T_NFF_MAG_VALUE_TEXT = 1070,
    T_NFF_END_TEXT = 1071,
    T_SETTING_7 = 1072,
    T_SETTING_8 = 1073,
    T_HEARTRATE_CHINA12_SMALL = 1074,
    T_HEARTRATE_CHINA13_SMALL = 1075,
    T_HEARTRATE_CHINA14_SMALL = 1076,
    T_HEARTRATE_CHINA15_SMALL = 1077,
    T_HEARTRATE_CHINA16_SMALL = 1078,
    T_TRAINAPPLIST1 = 1079,
    T_TRAINAPPLIST2 = 1080,
    T_TRAINAPPLIST3 = 1081,
    T_TRAINAPPLIST4 = 1082,
    T_TRAINAPPLIST5 = 1083,
    T_TRAINAPPLIST6 = 1084,
    T_TRAINAPPLIST7 = 1085,
    T_TRAINAPPLIST8 = 1086,
    T_TRAINAPPLIST9 = 1087,
    T_TRAINAPPLIST10 = 1088,
    T_TRAINAPPLIST11 = 1089,
    T_TRAINAPPLIST12 = 1090,
    T_TRAINAPPLISTBUFFERCENTER = 1091,
    T_TRAINAPPLISTBUFFERLEFT = 1092,
    T_TRAINAPPLIST21 = 1093,
    T_TRAINAPPLIST21_1 = 1094,
    T_TRAINAPPLIST22 = 1095,
    T_TRAINAPPLIST23 = 1096,
    T_TRAINAPPLIST24 = 1097,
    T_TRAINAPPLISTBUFFER = 1098,
    T_SET1 = 1099,
    T_SET2 = 1100,
    T_SET3 = 1101,
    T_SET4 = 1102,
    T_SET5 = 1103,
    T_SET6 = 1104,
    T_SET7 = 1105,
    T_SET8 = 1106,
    T_SET21 = 1107,
    T_SET22 = 1108,
    T_TARGET1 = 1109,
    T_TARGET2 = 1110,
    T_TARGET3 = 1111,
    T_TARGET4 = 1112,
    T_TARGET5 = 1113,
    T_TARGET6 = 1114,
    T_REMIND1 = 1115,
    T_REMIND2 = 1116,
    T_REMIND3 = 1117,
    T_DISPLAY1 = 1118,
    T_DISPLAY2 = 1119,
    T_DISPLAY3 = 1120,
    T_DISPLAY4 = 1121,
    T_DISPLAY5 = 1122,
    T_INTELLIGENTRUNNING1 = 1123,
    T_INTELLIGENTRUNNING1_1 = 1124,
    T_INTELLIGENTRUNNINGBUFFER1 = 1125,
    T_INTELLIGENTRUNNINGBUFFER2 = 1126,
    T_INTELLIGENTRUNNING2 = 1127,
    T_INTELLIGENTRUNNING3 = 1128,
    T_TARGETPACE1 = 1129,
    T_TARGETPACE2 = 1130,
    T_TARGETPACE3 = 1131,
    T_TARGETPACE4 = 1132,
    T_TARGETPACE5 = 1133,
    T_SELECTOR_BACKGROUND = 1134,
    T_SELECTOR_CENTER = 1135,
    T_TARGETPACEUSERDEFINE1 = 1136,
    T_TARGETPACEUSERDEFINE1_1 = 1137,
    T_TARGETPACEUSERDEFINE2 = 1138,
    T_TARGETPACEUSERDEFINE3 = 1139,
    T_USERDEFINEBUFFER = 1140,
    T_TARGET7 = 1141,
    T_TARGET8 = 1142,
    T_TARGET9 = 1143,
    T_TARGET10 = 1144,
    T_SELECTOR_BACKGROUND1 = 1145,
    T_SELECTOR_CENTER1 = 1146,
    T_UNIT1 = 1147,
    T_UNIT2 = 1148,
    T_UNIT3 = 1149,
    T_UNIT4 = 1150,
    T_UNIT5 = 1151,
    T_UNIT6 = 1152,
    T_TARGET11 = 1153,
    T_TARGET12 = 1154,
    T_USERDEFINEBIG = 1155,
    T_USERDEFINESMALL = 1156,
    T_UNIT7 = 1157,
    T_UNIT8 = 1158,
    T_UNIT9 = 1159,
    T_UNIT10 = 1160,
    T_UNIT11 = 1161,
    T_UNIT1_1 = 1162,
    T_UNIT7_1 = 1163,
    T_THREENEEDLES_DATA_ID = 1164,
    T_SINGLEUSEID_TE = 1165,
    T_HEARTRATE_STEP_ID = 1166,
    T_A043_RESOURCEID2 = 1167,
    T_A043_RESOURCEID3 = 1168,
    T_A043_RESOURCEID5 = 1169,
    T_SLEEP_CHARACTER_SCORE = 1170,
    T_A045_RESOURCEID1 = 1171,
    T_A045_RESOURCEID2 = 1172,
    T_A045_RESOURCEID3 = 1173,
    T_A045_RESOURCEID4 = 1174,
    T_A045_RESOURCEID5 = 1175,
    T_A045_RESOURCEID6 = 1176,
    T_A045_RESOURCEID7 = 1177,
    T_A045_RESOURCEID8 = 1178,
    T_A045_RESOURCEID9 = 1179,
    T_A045_RESOURCEID10 = 1180,
    T_A045_RESOURCEID11 = 1181,
    T_A045_RESOURCEID12 = 1182,
    T_A045_RESOURCEID13 = 1183,
    T_A045_RESOURCEID14 = 1184,
    T_A045_RESOURCEID15 = 1185,
    T_IDS_WEATHER_CITY_SHOWCASE = 1186,
    T_SWIM_DISTANCE_TXT1 = 1187,
    T_SWIM_DISTANCE_TXT2 = 1188,
    T_SWIM_TRIPS_TXT = 1189,
    T_SLEEP_TITLE_CHARACTER = 1190,
    T_BUSCARDSINQUIRE_TXT = 1191,
    T_CHANGE_DISTANCE_UNIT_MI_TXT = 1192,
    T_A039_RESOURCEID8 = 1193,
    T_HEALTH_HEIGHT_ID = 1194,
    T_BETTRYCHECK_TXT1 = 1195,
    T_BETTRYCHECK_TXT2 = 1196,
    T_BETTRYCHECK_TXT3 = 1197,
    T_BETTRYCHECK_TXT4 = 1198,
    T_BETTRYCHECK_TXT5 = 1199,
    T_TRAININGSTATUS_DETRAINING = 1200,
    T_TRAININGSTATUS_RECOVERY = 1201,
    T_TRAININGSTATUS_MAINTAINING = 1202,
    T_TRAININGSTATUS_PRODUCTIVE = 1203,
    T_TRAININGSTATUS_PEAKING = 1204,
    T_TRAININGSTATUS_OVERREACHING = 1205,
    T_TRAININGSTATUS_UNPRODUCTIVE = 1206,
    T_TRAININGSTATUS_STATUSBUFF = 1207,
    T_STRESS_TITLE = 1208,
    T_STRESS_DESCRIB1 = 1209,
    T_STRESS_DESCRIB2 = 1210,
    T_STRESS_DESCRIB3 = 1211,
    T_STRESS_DESCRIB4 = 1212,
    T_STRESS_NO_VALUE1 = 1213,
    T_STRESS_NO_VALUE2 = 1214,
    T_STRESS_DESCRIB5 = 1215,
    T_TRAINDATAPAGE1_1_SPEED = 1216,
    T_TRAINDATAPAGE1_1_AVGSPEED = 1217,
    T_TRAINDATAPAGE1_1_VERTICALSPEED = 1218,
    T_TRAINDATAPAGE3_1_SPEED = 1219,
    T_TRAINDATAPAGE3_1_AVGSPEED = 1220,
    T_TRAINDATAPAGE3_1_VERTICALSPEED = 1221,
    T_TRAINDATAPAGE4_1_SPEED = 1222,
    T_TRAINDATAPAGE4_1_AVGSPEED = 1223,
    T_TRAINDATAPAGE4_1_VERTICALSPEED = 1224,
    T_OUTSWIM_REMINDTEXT = 1225,
    T_NFF_BETTRYVALUE_TEST = 1226,
    T_NFF_PLESAECHARGING = 1227,
    T_NFF_CHARGESTATE_TEST = 1228,
    T_NFF_CHARGEIN30_TEST = 1229,
    T_TRAINAPPLIST2_RUNCOURSES = 1230,
    T_BINDWATCH11 = 1231,
    T_NFF_NFC_STATUS_TEST = 1232,
    T_NFF_NFC_OPENCARD_TEST = 1233,
    T_NFF_ALS_STATUS_TEST = 1234,
    T_NFF_ALS_VALUS_TEST = 1235,
    T_NFF_GPS_VALUS_TEST = 1236,
    T_NFF_ALS_REMIND_NORMAL_TEST = 1237,
    T_NFF_ALS_REMIND_DARK_TEST = 1238,
    T_NFF_PRE_VALUS_TEST = 1239,
    T_NFF_TP_CHANNEL_TEST = 1240,
    T_NFF_TP_CAPACITANCE_TEST = 1241,
    T_NFF_TP_CIRCLE_TEST = 1242,
    T_STRESS_DESCRIB6 = 1243,
    T_HEALTH_HPA_ID = 1244,
    T_LOCK_ID1 = 1245,
    T_LOCK_ID2 = 1246,
    T_STRESS_RECENT = 1247,
    T_SET_INTELLIGENT = 1248,
    T_ALARM_MODE_LIST_26_1 = 1249,
    T_ALARM_MODE_LIST_26_2 = 1250,
    T_ALARM_MODE_LIST_26_3 = 1251,
    T_ALARM_MODE_LIST_26_4 = 1252,
    T_ALARM_MODE_LIST_26_5 = 1253,
    T_ALARM_MODE_LIST_26_6 = 1254,
    T_ALARM_MODE_LIST_26_7 = 1255,
    T_TRAIN_HEART_REAMID_TEXT = 1256,
    T_USING_GUIDETXT = 1257,
    T_USING_GUIDETXT1 = 1258,
    T_SCAN_CODE_USE_TXT = 1259,
    T_SCREEN_ALWAYS_ON_TXT = 1260,
    T_MESSAGE_ALWAYS_ON_TXT = 1261,
    T_BACK_MAC_TXT = 1262,
    T_IDS_EXERCISE_RECOVERYTIME = 1263,
    T_AMBIENT_MESSAGE_TXT  = 1264,
    T_STANDBY_DIAL_TXT = 1265,
    T_DIAL_COLOR_TXT = 1266,
    T_DIAL_TYPE_1_TXT = 1267,
    T_DIAL_TYPE_2_TXT = 1268,
    T_DIAL_TYPE_3_TXT = 1269,
    T_DIAL_TYPE_4_TXT = 1270,
    T_DIAL_TYPE_5_TXT = 1271,
    T_DIAL_TYPE_6_TXT = 1272,
    T_DIAL_COLOR_1_TXT = 1273,
    T_DIAL_COLOR_2_TXT = 1274,
    T_DIAL_COLOR_3_TXT = 1275,
    T_DIAL_COLOR_4_TXT = 1276,
    T_DIAL_COLOR_5_TXT = 1277,
    T_DIAL_COLOR_6_TXT = 1278,
    T_STANDBY_DIAL_HEAD_TXT = 1279,
    T_DIAL_TYPE_TXT = 1280,
    T_DIAL_TYPE_LIST_TXT = 1281,
    T_DIAL_COLOR_LIST_TXT = 1282,
    T_BUSCARDS_QINGDAO = 1283,
    T_BUSCARDS_XIAMEN = 1284,
    T_BUSCARDS_HAERBIN = 1285,
    T_BUSCARDS_COMMON = 1286,
    T_AMBIENT_DIGATAL_WATCH_DATE = 1287,
    T_AMBIENT_DIGATAL_WATCH_SUN = 1288,
    T_AMBIENT_DIGATAL_WATCH_MON = 1289,
    T_AMBIENT_DIGATAL_WATCH_TUE = 1290,
    T_AMBIENT_DIGATAL_WATCH_WED = 1291,
    T_AMBIENT_DIGATAL_WATCH_THU = 1292,
    T_AMBIENT_DIGATAL_WATCH_FRI = 1293,
    T_AMBIENT_DIGATAL_WATCH_SAT = 1294,
    T_WATCH_FACE_PETALS_ID = 1295,
    T_IDS_WEATHER_PM2DOT5_TEXT_SERIOUS = 1296,
    T_AMBIENT_DIAL_WATCH_AM = 1297,
    T_AMBIENT_DIAL_WATCH_PM = 1298,
    T_BINDWATCH12 = 1299,
    T_BINDWATCH13 = 1300,
    T_BINDWATCH14 = 1301,
    T_BINDWATCH15 = 1302,
    T_BINDWATCH16 = 1303,
    T_BINDWATCH17 = 1304,
    T_BINDWATCH18 = 1305,
    T_BINDWATCH19 = 1306,
    T_BINDWATCH20 = 1307,
    T_BINDWATCH21 = 1308,
    T_BINDWATCH22 = 1309,
    T_BINDWATCH23 = 1310,
    T_BINDWATCH24 = 1311,
    T_BINDWATCH25 = 1312,
    T_BINDWATCH26 = 1313,
    T_BINDWATCH27 = 1314,
    T_PAIR_TXT = 1315,
    T_SWIPE_UP_SCAN_CODE_TXT = 1316,
    T_ELEGANT_CIRCLE_VALUE = 1317,
    T_WATCH_FACE_ELEGANCE_ID = 1318,
    T_SMART_CARE_FLIGHT_COMPANY = 1319,
    T_SMART_CARE_FLIGHT_DEPART_LOCATION = 1320,
    T_SMART_CARE_FLIGHT_ARRIVE_LOCATION = 1321,
    T_SMART_CARE_DEPART_TIME = 1322,
    T_SMART_CARE_ARRIVE_TIME = 1323,
    T_SMART_CARE_DATE = 1324,
    T_SMART_CARE_WEEK_SUN_ID = 1325,
    T_SMART_CARE_WEEK_MON_ID = 1326,
    T_SMART_CARE_WEEK_TUE_ID = 1327,
    T_SMART_CARE_WEEK_WED_ID = 1328,
    T_SMART_CARE_WEEK_THU_ID = 1329,
    T_SMART_CARE_WEEK_FRI_ID = 1330,
    T_SMART_CARE_WEEK_SAT_ID = 1331,
    T_NO_DISTRUB_MODEL_REMIND_TXT = 1332,
    T_LOCK_SCREEN_PROMPT_TXT = 1333,
    T_WEATHER_UPDATE_TIME_TXT = 1334,
    T_SOLARTERM_DATE_ID = 1335,
    T_SOLARTERM_RESOURCEID1 = 1336,
    T_SOLARTERM_RESOURCEID2 = 1337,
    T_SOLARTERM_RESOURCEID3 = 1338,
    T_SOLARTERM_RESOURCEID4 = 1339,
    T_SOLARTERM_RESOURCEID5 = 1340,
    T_SOLARTERM_RESOURCEID6 = 1341,
    T_SOLARTERM_RESOURCEID7 = 1342,
    T_SOLARTERM_LUNAR_ID2 = 1343,
    T_SOLARTERM_LUNARDATE_ID = 1344,
    T_WATCH_FACE_SOLAR_ID = 1345,
    T_SOLARTERM_LUNARNAME_ID1 = 1346,
    T_SOLARTERM_LUNAR_AM = 1347,
    T_SOLARTERM_LUNAR_PM = 1348,
    T_WATCH_FACE_COLORFUL_ID = 1349,
    T_VITALITY_WEEK_SUN = 1350,
    T_VITALITY_WEEK_MON = 1351,
    T_VITALITY_WEEK_TUE = 1352,
    T_VITALITY_WEEK_WED = 1353,
    T_VITALITY_WEEK_THU = 1354,
    T_VITALITY_WEEK_FRI = 1355,
    T_VITALITY_WEEK_SAT = 1356,
    T_WATCH_FACE_VITALITY_HAND_ID = 1357,
    T_DINCONDENSED_BOLD_38_L = 1358,
    T_DINCONDENSED_BOLD_38_C = 1359,
    T_DINCONDENSED_BOLD_38_R = 1360,
    T_DINCONDENSED_BOLD_42_L = 1361,
    T_DINCONDENSED_BOLD_42_C = 1362,
    T_DINCONDENSED_BOLD_42_R = 1363,
    T_DINNEXTFORHUAWEI_BOLD_40_L = 1364,
    T_DINNEXTFORHUAWEI_BOLD_40_C = 1365,
    T_DINNEXTFORHUAWEI_BOLD_40_R = 1366,
    T_DIN_BLACKITALIC_32_L = 1367,
    T_DIN_BLACKITALIC_32_C = 1368,
    T_DIN_BLACKITALIC_32_R = 1369,
    T_DINNEXTLTPRO_MEDIUM_32_L = 1370,
    T_DINNEXTLTPRO_MEDIUM_32_C = 1371,
    T_DINNEXTLTPRO_MEDIUM_32_R = 1372,
    T_DINNEXTLTPRO_REGULAR_24_L = 1373,
    T_DINNEXTLTPRO_REGULAR_24_C = 1374,
    T_DINNEXTLTPRO_REGULAR_24_R = 1375,
    T_DINNEXTLTPRO_REGULAR_46_L = 1376,
    T_DINNEXTLTPRO_REGULAR_46_C = 1377,
    T_DINNEXTLTPRO_REGULAR_46_R = 1378,
    T_HYQIHEI_60S_20_L = 1379,
    T_HYQIHEI_60S_20_C = 1380,
    T_HYQIHEI_60S_20_R = 1381,
    T_HYQIHEI_60S_23_L = 1382,
    T_HYQIHEI_60S_23_C = 1383,
    T_HYQIHEI_60S_23_R = 1384,
    T_HYQIHEI_60S_26_L = 1385,
    T_HYQIHEI_60S_26_C = 1386,
    T_HYQIHEI_60S_26_R = 1387,
    T_HYQIHEI_60S_28_L = 1388,
    T_HYQIHEI_60S_28_C = 1389,
    T_HYQIHEI_60S_28_R = 1390,
    T_HYQIHEI_60S_30_L = 1391,
    T_HYQIHEI_60S_30_C = 1392,
    T_HYQIHEI_60S_30_R = 1393,
    T_HYQIHEI_60S_38_L = 1394,
    T_HYQIHEI_60S_38_C = 1395,
    T_HYQIHEI_60S_38_R = 1396,
    T_HYQIHEI_60S_48_L = 1397,
    T_HYQIHEI_60S_48_C = 1398,
    T_HYQIHEI_60S_48_R = 1399,
    T_ROBOTOCONDENSED_REGULAR_20_L = 1400,
    T_ROBOTOCONDENSED_REGULAR_20_C = 1401,
    T_ROBOTOCONDENSED_REGULAR_20_R = 1402,
    T_ROBOTOCONDENSED_REGULAR_23_L = 1403,
    T_ROBOTOCONDENSED_REGULAR_23_C = 1404,
    T_ROBOTOCONDENSED_REGULAR_23_R = 1405,
    T_ROBOTOCONDENSED_REGULAR_26_L = 1406,
    T_ROBOTOCONDENSED_REGULAR_26_C = 1407,
    T_ROBOTOCONDENSED_REGULAR_26_R = 1408,
    T_ROBOTOCONDENSED_REGULAR_28_L = 1409,
    T_ROBOTOCONDENSED_REGULAR_28_C = 1410,
    T_ROBOTOCONDENSED_REGULAR_28_R = 1411,
    T_ROBOTOCONDENSED_REGULAR_30_L = 1412,
    T_ROBOTOCONDENSED_REGULAR_30_C = 1413,
    T_ROBOTOCONDENSED_REGULAR_30_R = 1414,
    T_ROBOTOCONDENSED_REGULAR_38_L = 1415,
    T_ROBOTOCONDENSED_REGULAR_38_C = 1416,
    T_ROBOTOCONDENSED_REGULAR_38_R = 1417,
    T_ROBOTOCONDENSED_REGULAR_48_L = 1418,
    T_ROBOTOCONDENSED_REGULAR_48_C = 1419,
    T_ROBOTOCONDENSED_REGULAR_48_R = 1420,
    T_TRIATHLON = 1421,
    T_TRIATHLON_ITEM1 = 1422,
    T_TRIATHLON_ITEM2 = 1423,
    T_TRIATHLON_ITEM3 = 1424,
    T_TRIATHLON_NONE = 1425,
    T_TRIATHLON_SET_POOLSWIM = 1426,
    T_TRIATHLON_SET_1 = 1427,
    T_TRIATHLON_SET_2 = 1428,
    T_TRIATHLON_SET_3 = 1429,
    T_TRIATHLON_SET_4 = 1430,
    T_TRIATHLON_SET_5 = 1431,
    T_TRIATHLON_SET_6 = 1432,
    T_TRIATHLON_SET_7 = 1433,
    T_TRIATHLON_SET_8 = 1434,
    T_TRIATHLON_SET_9 = 1435,
    T_TRIATHLON_SET_10 = 1436,
    T_TRIATHLON_CHANGE_ITEM1 = 1437,
    T_TRIATHLON_CHANGE_ITEM2 = 1438,
    T_TRIATHLON_START_RIDING = 1439,
    T_TRIATHLON_START_SWIM = 1440,
    T_TRIATHLON_START_RUN = 1441,
    T_TRIATHLON_CUSTOMIZE = 1442,
    T_TRIATHLON_STANDARD = 1443,
    T_TRIATHLON_PROMPT1 = 1444,
    T_TRIATHLON_PROMPT2 = 1445,
    T_TRIATHLON_PROMPT3 = 1446,
    T_TRIATHLON_TOTAL_TIME = 1447,
    T_TRIATHLON_SWIM = 1448,
    T_TRIATHLON_RIDE = 1449,
    T_TRIATHLON_RUN = 1450,
    T_TRIATHLON_CHANGE_ITEM1_SMALL = 1451,
    T_TRIATHLON_CHANGE_ITEM2_SMALL = 1452,
    T_TRIATHLON_SWIMMING_RESULTS = 1453,
    T_TRIATHLON_RIDING_RESULTS = 1454,
    T_TRIATHLON_RUNNING_RESULTS = 1455,
    T_TRIATHLON_UNIT = 1456,
    T_TRIATHLON_TRANSITION1 = 1457,
    T_TRIATHLON_TRANSITION2 = 1458,
    T_TRIATHLON_TOTAL_DISTANCE = 1459,
    T_TRIATHLON_TOTAL_HEAT = 1460,
    T_TRIATHLON_DISTANCE = 1461,
    T_TRIATHLON_TIME = 1462,
    T_TRIATHLON_PACE = 1463,
    T_TRIATHLON_TRANSITION_TIME = 1464,
    T_TRIATHLON_TRIATHLON = 1465,
    T_TRIATHLON_START_REMIND = 1466,
    T_WEATH_TIPS_NUM1 = 1467,
    T_WEATH_TIPS_NUM2 = 1468,
    T_WEATH_TIPS_NUM3 = 1469,
    T_WEATH_TIPS_NUM4 = 1470,
    T_WEATH_TIPS_NUM5 = 1471,
    T_WEATH_TIPS_NUM6 = 1472,
    T_WEATH_TIPS_NUM7 = 1473,
    T_WEATH_TIPS_NUM8 = 1474,
    T_WEATH_TIPS_NUM9 = 1475,
    T_WEATH_TIPS_NUM10 = 1476,
    T_WEATHER_UPDATE_TIME_TXT2 = 1477,
    T_UNKOWNINCOMINGCALLNAMETXT = 1478,
    T_CHANGE_ITEM_DATA_TRANSITION1 = 1479,
    T_CHANGE_ITEM_DATA_TRANSITION2 = 1480,
    T_WATCH_FACE_ENERGYGREEN_ID = 1481,
    T_ADVANCED_SET = 1482,
    T_ADVANCED_SET_NAME  = 1483,
    T_OFF_SCREEN_TIME = 1484,
    T_OFF_SCREEN_TIME_NAME = 1485,
    T_LONG_BRIGHT_TIME = 1486,
    T_LONG_BRIGHT_TIME_NAME = 1487,
    T_ENDURANCE_REMIND = 1488,
    T_OFF_SCREEN_TIME_S = 1489,
    T_OFF_SCREEN_TIME_S1 = 1490,
    T_LONG_BRIGHT_TIME_MIN = 1491,
    T_AMBIENT_LOW_POWER_REMIND = 1492,
    T_VITALITY_HAND_WATCH_DATE = 1493,
    T_PAIR_PHONENAME = 1494,
    T_PAIR_GUIDE_HINT = 1495,
    T_SETTING_MOTOR = 1496,
    T_MOTOR_SET = 1497,
    T_MOTOR_SET_NAME  = 1498,
    T_PHONE_CALL_NAME = 1499,
    T_PHONE_CALL_NUMBER_WITH_NAME = 1500,
    T_PHONE_CALL_NUMBER_WITHOUT_NAME = 1501,
    T_PHONE_CALL_TIMING = 1502,
    T_PHONE_CALL_COMMUNICATION_OVER = 1503,
    T_PHONE_CALL_CONTACT_NAME = 1504,
    T_PHONE_CALL_CONTACT_NUMBER = 1505,
    T_PHONE_CALL_CONTACT_NUMBER_WITHOUT_NAME = 1506,
    T_PHONE_CALL_CONTACTS_TITLE = 1507,
    T_PHONE_CALL_CONTACTS_EMPTY_TIPS = 1508,
    T_PHONE_CALL_HISTORY_BTN = 1509,
    T_PHONE_CALL_CONTACTS_BTN = 1510,
    T_PHONE_CALL_HISTORY_NAME_OR_NUM = 1511,
    T_PHONE_CALL_HISTORY_WHEN = 1512,
    T_PHONE_CALL_HISTORY_TITLE = 1513,
    T_PHONE_CALL_HISTORY_CLEAR_ALL_BTN = 1514,
    T_PHONE_CALL_DIALING = 1515,
    T_PHONE_CALL_HISTORY_NONE = 1516,
    T_PHONE_CALL_DIAL_BACK = 1517,
    T_PHONE_CALL_NO_BT_CONNECTION = 1518,
    T_QUICK_SETTING_ALARM_CLOCK = 1519,
    T_DOWNLOAD_ABOUT = 1520,
    T_DOWNLOAD_SELSECT = 1521,
    T_DOWNLOAD_PAIR_SCAN = 1522,
    T_DOWNLOAD_SWIPE_UP_SCAN = 1523,
    T_DOWNLOAD_SELSECT_LANGUAGE = 1524,
    T_MUSIC_SETTING_TITLE = 1525,
    T_MUSIC_SETTING_WATCH_DEV = 1526,
    T_MUSIC_SETTING_PHONE_DEV = 1527,
    T_MUSIC_SETTING_BT_EARPHONE = 1528,
    T_MUSIC_SETTING_BT_CONNECTED = 1529,
    T_MUSIC_SETTING_BT_NOT_CONNECTED = 1530,
    T_MUSIC_SETTING_BT_DISCONNECTED = 1531,
    T_MUSIC_SETTING_DELETE = 1532,
    T_MUSIC_NO_SONG = 1533,
    T_MUSIC_APP_CONNECTING = 1534,
    T_MUSIC_IOS_SMALL_NOTICE = 1535,
    T_MUSIC_IOS_BIG_NOTICE = 1536,
    T_MUSIC_SEQUENCE_MODE = 1537,
    T_MUSIC_SINGLE_MODE = 1538,
    T_MUSIC_CYCLE_MODE = 1539,
    T_MUSIC_RANDOM_MODE = 1540,
    T_MUSIC_NOT_SUPPORT = 1541,
    T_MUSIC_FILE_ERROR = 1542,
    T_MUSIC_BT_NOTICE = 1543,
    T_MUSIC_CONNECT_BT = 1544,
    T_MUSIC_FROM_APP = 1545,
    T_MUSIC_CONTROL_NAME = 1546,
    T_MUSIC_CONTROL_SINGER = 1547,
    T_MUSIC_LIST_TITLE = 1548,
    T_MUSIC_LIST_FOLDER_NAME = 1549,
    T_MUSIC_LIST_FOLDER_NUMBER = 1550,
    T_MUSIC_LIST_FILE_TITLE = 1551,
    T_MUSIC_NOTICE_GET = 1552,
    T_MUSIC_APP_OPEN_NOTICE = 1553,
    T_MUSIC_CONTROL_NOTICE = 1554,
    T_MUSIC_PLAY_ON_PHONE = 1555,
    T_MUSIC_LIST_FILE_NAME = 1556,
    T_MUSIC_LIST_FILE_SINGER = 1557,
    T_AUTO_PAUSE = 1558,
    T_TRAINING_SETTING_SWITCH = 1559,
    T_TRAINING_SETTING_HALF_MARATHON = 1560,
    T_TRAINING_SETTING_FULL_MARATHON = 1561,
    T_USERDEFINESUPERBIG = 1562,
    T_UNIT_HALF_MARATHON = 1563,
    T_UNIT_FULL_MARATHON = 1564,
    T_INTERVAL_REMINDER = 1565,
    T_HEART_RATE_REMINDER = 1566,
    T_BODY_CONDITION = 1567,
    T_HEART_RATE_RANGE = 1568,
    T_HEART_RATE_HIGH = 1569,
    T_HEART_RATE_LOW = 1570,
    T_HIGH_EFFICIENCY_FAT_BURNING = 1571,
    T_CARDIOPULMONARY_ELEVATION = 1572,
    T_RECOVERY_TRAINING = 1573,
    T_TRAINING_ASSISTANT = 1574,
    T_TRAINING_ASSISTANT_INFO = 1575,
    T_ITEM_15 = 1576,
    T_ITEM_16 = 1577,
    T_TRAINDATAPAGE1_PRESSURE = 1578,
    T_TRAINDATAPAGE1_CLOCK = 1579,
    T_TRAINDATAPAGE3_PRESSURE = 1580,
    T_TRAINDATAPAGE3_CLOCK = 1581,
    T_TRAINDATAPAGE4_PRESSURE = 1582,
    T_TRAINDATAPAGE4_CLOCK = 1583,
    T_REMIND_POOL_LENGTH = 1584,
    T_REMIND_POOL_LENGTH_SETINFO = 1585,
    T_REMIND_WEAR_SWIM = 1586,
    T_MUSIC_APP = 1587,
    T_MUSIC_CONTROL_NO_MUSIC = 1588,
    T_SPO2_PROMPT = 1589,
    T_SPO2_REMIND = 1590,
    T_SPO2_MEASURE_TEXT1 = 1591,
    T_SPO2_MEASURE_TEXT2 = 1592,
    T_SPO2_TITLE = 1593,
    T_SPO2_TITLE1 = 1594,
    T_SPO2_INTRODUCTION = 1595,
    T_ACTIVITY_REMIND_HARM_0 = 1596,
    T_ACTIVITY_REMIND_HARM_1 = 1597,
    T_ACTIVITY_REMIND_HARM_2 = 1598,
    T_ACTIVITY_REMIND_HARM_3 = 1599,
    T_ACTIVITY_REMIND_HARM_4 = 1600,
    T_ACTIVITY_REMIND_HARM_5 = 1601,
    T_ACTIVITY_REMIND_HARM_6 = 1602,
    T_ACTIVITY_REMIND_HARM_7 = 1603,
    T_ACTIVITY_REMIND_HARM_8 = 1604,
    T_ACTIVITY_REMIND_HARM_9 = 1605,
    T_ACTIVITY_REMIND_HARM_10 = 1606,
    T_ACTIVITY_REMIND_HARM_11 = 1607,
    T_ACTIVITY_REMIND_HARM_12 = 1608,
    T_ACTIVITY_REMIND_HARM_13 = 1609,
    T_ACTIVITY_REMIND_HARM_14 = 1610,
    T_ACTIVITY_REMIND_HARM_15 = 1611,
    T_ACTIVITY_REMIND_SUGGEST = 1612,
    T_ACTIVITY_STEP_REMIND = 1613,
    T_ACTIVITY_STEPS_REMIND = 1614,
    T_ACTIVITY_HOUR_REMIND = 1615,
    T_ACTIVITY_HOURS_REMIND = 1616,
    T_ACTIVITY_MIN_REMIND = 1617,
    T_ACTIVITY_STRENGTH_REMIND = 1618,
    T_ACTIVITY_CHALLENGE_REMIND = 1619,
    T_TRAINAPPLIST_INDOOR_WALK = 1620,
    T_TRAINAPPLIST_HIKING = 1621,
    T_TRAINAPPLIST_SKIING = 1622,
    T_TRAINAPPLIST_ELLIPTICAL_MOTION = 1623,
    T_TRAINAPPLIST_ROWING_MOTION = 1624,
    T_SETTING_MENU_FUNCTIONKEY = 1625,
    T_SETTING_MENU_BT = 1626,
    T_SETTING_MENU_VOLUME = 1627,
    T_SETTING_UPGRADE_TITLE = 1628,
    T_SETTING_UPGRADE_BUTTON_LABLE = 1629,
    T_DIAL_TYPE_7_TXT = 1630,
    T_DIAL_TYPE_8_TXT = 1631,
    T_DIAL_TYPE_9_TXT = 1632,
    T_DIAL_COLOR_7_TXT = 1633,
    T_DIAL_COLOR_8_TXT = 1634,
    T_DIAL_COLOR_9_TXT = 1635,
    T_DIAL_COLOR_10_TXT = 1636,
    T_DIAL_COLOR_11_TXT = 1637,
    T_DIAL_COLOR_12_TXT = 1638,
    T_SETTING_NOT_DISTURB_ALLDAY = 1639,
    T_SETTING_NOT_DISTURB_PERIOD = 1640,
    T_NO_DISTRUB_MODEL_REMIND_TIPS = 1641,
    T_SCREEN_ALWAYS_ON_TIME_TXT = 1642,
    T_TRAINING_STATUS_REMIND_TITLE = 1643,
    T_TRAINING_STATUS_REMIND_POOR = 1644,
    T_TRAINING_STATUS_REMIND_NORMAL = 1645,
    T_TRAINING_STATUS_REMIND_GOOD = 1646,
    T_TRAINING_BEST_RESULT_UNIT_KM = 1647,
    T_TRAINING_WALKING_LONGEST_DISTANCE = 1648,
    T_TRAINING_WALKING_MAXIMUM_STEPS = 1649,
    T_TRAINING_BEST_RESULT_UNIT_STEP = 1650,
    T_TRAINING_HALF_MARATHON_MIN_TIME = 1651,
    T_TRAINING_FULL_MARATHON_MIN_TIME = 1652,
    T_TRAINING_RUNNING_LONGEST_DISTANCE = 1653,
    T_TRAINING_RUNNING_3KM_MINIMUM_TIME = 1654,
    T_TRAINING_RUNNING_5KM_MINIMUM_TIME = 1655,
    T_TRAINING_RUNNING_10KM_MINIMUM_TIME = 1656,
    T_TRAINING_RIDE_LONGEST_DISTANCE = 1657,
    T_BLUETOOTH_STATIC_TITLE = 1658,
    T_BT_CONN_SUCCESS_OK = 1659,
    T_BT_CONN_SUCCESS = 1660,
    T_BT_DEV_NOT_FOUND = 1661,
    T_BT_DEV_CONN_RETRY = 1662,
    T_BT_DEV_CONN_RETRY_FAILED = 1663,
    T_BT_DEV_CONN_RETRYING = 1664,
    T_BT_DEV_SEARCHING = 1665,
    T_BT_DEV_SEARCHED = 1666,
    T_BT_DEV_CONNECTED = 1667,
    T_BT_DEV_DISCONNECTED = 1668,
    T_BT_DISCONNECTED_DEV = 1669,
    T_BT_DEV_NEW = 1670,
    T_BT_DEV_UNPAIR = 1671,
    T_BT_DEV_RECONNECT = 1672,
    T_BT_DEV_ITEM_NAME = 1673,
    T_BT_DEV_ITEM_STATUS = 1674,
    T_NO_REMINDER = 1675,
    T_NO_REMINDER_SMALL = 1676,
    T_HR_RANGE_VALUE_SMALL = 1677,
    T_SPO2_HEART_RATE = 1678,
    T_SPO2_MEASURE = 1679,
    T_SPO2_INTRODUCTION2 = 1680,
    T_SPO2_INTRODUCTION3 = 1681,
    T_SPO2_INTRODUCTION4 = 1682,
    T_HEARTRATE_UNIT = 1683,
    T_BT_DEV_JUDGE_NOTICE = 1684,
    T_BT_DEV_FAIL_NOTICE = 1685,
    T_TRAIN_DATA_TYPE_REMIND_TEXT = 1686,
    T_TRAIN_DATA_TYPE_NO_EDIT = 1687,
    T_TRAIN_BT_CLOSE_WORKOUT = 1688,
    T_TRAIN_BT_TRY_CONNECT = 1689,
    T_TIME_SYNC_TIPS = 1690,
    T_TRAINING_PREDICTING_SCORE_TITLE = 1691,
    T_TRAINING_PREDICTING_5KM = 1692,
    T_TRAINING_PREDICTING_10KM = 1693,
    T_TRAINING_PREDICTING_HALF_MARATHON = 1694,
    T_TRAINING_PREDICTING_FULL_MARATHON = 1695,
    T_APP_SPO2 = 1696,
    T_SPO2_ALTITUDE = 1697,
    T_RESOURCE_TRAIL_RUN = 1698,
    T_RESOURCE_INDOOR_WALK = 1699,
    T_RESOURCE_HIKING = 1700,
    T_RESOURCE_ELLIPTICAL_MOTION = 1701,
    T_RESOURCE_ROWING_MOTION = 1702,
    T_GO_TO_APP_RECORD = 1703,
    T_SPO2_LAST_TIME = 1704,
    T_VOICEASTREMIND_BT = 1705,
    T_VOICEASTREMIND_CHECK = 1706,
    T_ACTIVITY_RECORD_EXERCICE_TITLE = 1707,
    T_ACTIVITY_RECORD_HOURS_TITLE = 1708,
    T_ACTIVITY_RECORD_EXERCICE = 1709,
    T_ACTIVITY_RECORD_HOURS = 1710,
    T_MMI3_SUCCESS = 1711,
    T_MMI3_FAILED = 1712,
    T_MMI3_CLICK_START_TEST = 1713,
    T_MMI3_SWIPELEFT_START_LCD_TEST = 1714,
    T_MMI3_LCD_TEST_END = 1715,
    T_MMI3_SEMI_BRIGHT_TEST = 1716,
    T_MMI3_SEMI_BRIGHT_TEST_OVER = 1717,
    T_MMI3_START_TP_CIRCLE_TEST = 1718,
    T_MMI3_PRESS_POWER_KEY_END = 1719,
    T_MMI3_TP_TEST_RESULT_SUCCESS = 1720,
    T_MMI3_CLICK_CONFIRM_TP_TEST_RESULT = 1721,
    T_MMI3_POWER_KEY_TEST = 1722,
    T_MMI3_TEST_RESULTS = 1723,
    T_MMI3_FUNCTION_KEY_TEST = 1724,
    T_MMI3_CLICK_FUNCTION_KEY_TO_TEST = 1725,
    T_MMI3_MOTOR_TEST = 1726,
    T_MMI3_BATTERY_TEST_BEGIN = 1727,
    T_MMI3_TEST_INTERFACE = 1728,
    T_MMI3_BATTERY_TEST_RESULTS = 1729,
    T_MMI3_CHARGING_TEST_BEGIN = 1730,
    T_MMI3_CLICK_SCREEN_TO_START_RECORDING = 1731,
    T_MMI3_RECORDING_COUNTDOWN = 1732,
    T_MMI3_PLAYING_THE_RECORDING = 1733,
    T_MMI3_CLICK_TO_PLAY_THE_SOUND = 1734,
    T_MMI3_MALE_VOICE = 1735,
    T_MMI3_NO_VOICE = 1736,
    T_MMI3_FEMALE_VOICE = 1737,
    T_MMI3_START_AG_HORIZONTAL_CALIBRATION = 1738,
    T_MMI3_AG_CALIBRATION = 1739,
    T_MMI3_AG_CALIBRATION_RESULTS = 1740,
    T_MMI3_AG_VALUE_TEST = 1741,
    T_MMI3_AG_READING = 1742,
    T_MMI3_AG_READ_FAILURE = 1743,
    T_MMI3_READ_VALUE_RESULTS = 1744,
    T_MMI3_SENSOR_TESTING = 1745,
    T_MMI3_IN_SENSOR_TESTING = 1746,
    T_MMI3_IN_SENSOR_TEST_FAILURE = 1747,
    T_MMI3_FAILURE_ITEM_ID = 1748,
    T_MMI3_MM_TEST_RESULTS_INTERFACE = 1749,
    T_MMI3_QR_CODE_INTERFACE = 1750,
    T_MMI3_CLICK_SCREEN_START_MMI_TEST = 1751,
    T_MMI3_CLICK_THE_TOP_BUTTON_TWICE = 1752,
    T_MMI3_POWER_KEY_TEST_FAILED = 1753,
    T_MMI3_CLICK_THE_BELOW_BUTTON_TWICE = 1754,
    T_MMI3_FUNCTION_KEY_TEST_FAILED = 1755,
    T_MMI3_CONFIRM = 1756,
    T_MMI3_RETEST = 1757,
    T_MMI3_BATTERY_POWER = 1758,
    T_MMI3_BATTERY_VOLTAGE = 1759,
    T_MMI3_BATTERY_CHARGING_ABNORMAL = 1760,
    T_MMI3_TEST_NOT_COMPLETE = 1761,
    T_MMI3_LONG_PRESS_POWERKEY_RETEST = 1762,
    T_MMI3_TP_TEST_FAILURE = 1763,
    T_MMI3_BATTERY_ABNORMAL = 1764,
    T_MMI3_CHARGING_SUCCESS = 1765,
    T_MMI3_NUMBER_1 = 1766,
    T_MMI3_NUMBER_2 = 1767,
    T_MMI3_NUMBER_3 = 1768,
    T_MMI3_NUMBER_4 = 1769,
    T_MMI3_NUMBER_5 = 1770,
    T_MMI3_NUMBER_6 = 1771,
    T_MMI3_NUMBER_7 = 1772,
    T_MMI3_NUMBER_8 = 1773,
    T_MMI3_NUMBER_9 = 1774,
    T_MMI3_NUMBER_10 = 1775,
    T_MMI3_NUMBER_11 = 1776,
    T_MMI3_NUMBER_12 = 1777,
    T_MMI3_NUMBER_13 = 1778,
    T_MMI3_NUMBER_14 = 1779,
    T_MMI3_NUMBER_15 = 1780,
    T_MMI3_NUMBER_16 = 1781,
    T_MMI3_NUMBER_17 = 1782,
    T_MMI3_NUMBER_18 = 1783,
    T_MMI3_NUMBER_19 = 1784,
    T_MMI3_NUMBER_20 = 1785,
    T_MMI3_NUMBER_21 = 1786,
    T_MMI3_NUMBER_22 = 1787,
    T_MMI3_MAC_ADDR = 1788,
    T_MMI3_MAC_4 = 1789,
    T_MMI3_FAILURE_ITEM_ID_3 = 1790,
    T_MMI3_FAILURE_ITEM_ID_2 = 1791,
    T_MMI3_FEATURE_START_TEST = 1792,
    T_MMI3_FEATURE_STOP_TEST = 1793,
    T_MMI3_FEATURE_TITLE = 1794,
    T_DUALTIMEZONE_NZDT = 1795,
    T_DUALTIMEZONE_IDLE = 1796,
    T_DUALTIMEZONE_NZST = 1797,
    T_DUALTIMEZONE_AESST = 1798,
    T_DUALTIMEZONE_ACSST = 1799,
    T_DUALTIMEZONE_EAST = 1800,
    T_DUALTIMEZONE_GST = 1801,
    T_DUALTIMEZONE_SAT = 1802,
    T_DUALTIMEZONE_WDT = 1803,
    T_DUALTIMEZONE_JST = 1804,
    T_DUALTIMEZONE_KST = 1805,
    T_DUALTIMEZONE_MT = 1806,
    T_DUALTIMEZONE_WST = 1807,
    T_DUALTIMEZONE_CCT = 1808,
    T_DUALTIMEZONE_JT = 1809,
    T_DUALTIMEZONE_IT = 1810,
    T_DUALTIMEZONE_BT = 1811,
    T_DUALTIMEZONE_EETDST = 1812,
    T_DUALTIMEZONE_CETDST = 1813,
    T_DUALTIMEZONE_EET = 1814,
    T_DUALTIMEZONE_FWT = 1815,
    T_DUALTIMEZONE_MEST = 1816,
    T_DUALTIMEZONE_BST = 1817,
    T_DUALTIMEZONE_CET = 1818,
    T_DUALTIMEZONE_FST = 1819,
    T_DUALTIMEZONE_SWT = 1820,
    T_DUALTIMEZONE_WETDST = 1821,
    T_DUALTIMEZONE_GMT = 1822,
    T_DUALTIMEZONE_WET = 1823,
    T_DUALTIMEZONE_WAT = 1824,
    T_DUALTIMEZONE_NDT = 1825,
    T_DUALTIMEZONE_ADT = 1826,
    T_DUALTIMEZONE_NFT = 1827,
    T_DUALTIMEZONE_AST = 1828,
    T_DUALTIMEZONE_EDT = 1829,
    T_DUALTIMEZONE_CDT = 1830,
    T_DUALTIMEZONE_EST = 1831,
    T_DUALTIMEZONE_CST = 1832,
    T_DUALTIMEZONE_MDT = 1833,
    T_DUALTIMEZONE_MST = 1834,
    T_DUALTIMEZONE_PDT = 1835,
    T_DUALTIMEZONE_PST = 1836,
    T_DUALTIMEZONE_HDT = 1837,
    T_DUALTIMEZONE_AHST = 1838,
    T_DUALTIMEZONE_NT = 1839,
    T_DUALTIMEZONE_IDLW = 1840,
    T_DUALTIMEZONE_TIME_NZDT = 1841,
    T_DUALTIMEZONE_TIME_IDLE = 1842,
    T_DUALTIMEZONE_TIME_NZST = 1843,
    T_DUALTIMEZONE_TIME_AESST = 1844,
    T_DUALTIMEZONE_TIME_ACSST = 1845,
    T_DUALTIMEZONE_TIME_EAST = 1846,
    T_DUALTIMEZONE_TIME_GST = 1847,
    T_DUALTIMEZONE_TIME_SAT = 1848,
    T_DUALTIMEZONE_TIME_WDT = 1849,
    T_DUALTIMEZONE_TIME_JST = 1850,
    T_DUALTIMEZONE_TIME_KST = 1851,
    T_DUALTIMEZONE_TIME_MT = 1852,
    T_DUALTIMEZONE_TIME_WST = 1853,
    T_DUALTIMEZONE_TIME_CCT = 1854,
    T_DUALTIMEZONE_TIME_JT = 1855,
    T_DUALTIMEZONE_TIME_IT = 1856,
    T_DUALTIMEZONE_TIME_BT = 1857,
    T_DUALTIMEZONE_TIME_EETDST = 1858,
    T_DUALTIMEZONE_TIME_CETDST = 1859,
    T_DUALTIMEZONE_TIME_EET = 1860,
    T_DUALTIMEZONE_TIME_FWT = 1861,
    T_DUALTIMEZONE_TIME_MEST = 1862,
    T_DUALTIMEZONE_TIME_BST = 1863,
    T_DUALTIMEZONE_TIME_CET = 1864,
    T_DUALTIMEZONE_TIME_FST = 1865,
    T_DUALTIMEZONE_TIME_SWT = 1866,
    T_DUALTIMEZONE_TIME_WETDST = 1867,
    T_DUALTIMEZONE_TIME_GMT = 1868,
    T_DUALTIMEZONE_TIME_WET = 1869,
    T_DUALTIMEZONE_TIME_WAT = 1870,
    T_DUALTIMEZONE_TIME_NDT = 1871,
    T_DUALTIMEZONE_TIME_ADT = 1872,
    T_DUALTIMEZONE_TIME_NFT = 1873,
    T_DUALTIMEZONE_TIME_AST = 1874,
    T_DUALTIMEZONE_TIME_EDT = 1875,
    T_DUALTIMEZONE_TIME_CDT = 1876,
    T_DUALTIMEZONE_TIME_EST = 1877,
    T_DUALTIMEZONE_TIME_CST = 1878,
    T_DUALTIMEZONE_TIME_MDT = 1879,
    T_DUALTIMEZONE_TIME_MST = 1880,
    T_DUALTIMEZONE_TIME_PDT = 1881,
    T_DUALTIMEZONE_TIME_PST = 1882,
    T_DUALTIMEZONE_TIME_HDT = 1883,
    T_DUALTIMEZONE_TIME_AHST = 1884,
    T_DUALTIMEZONE_TIME_NT = 1885,
    T_DUALTIMEZONE_TIME_IDLW = 1886,
    T_DUALTIMEZONE_TITLE_ID = 1887,
    T_DUALTIMEZONE_SWITCH_ID = 1888,
    T_DUALTIMEZONE_ID_NZDT = 1889,
    T_DUALTIMEZONE_ID_IDLE = 1890,
    T_DUALTIMEZONE_ID_NZST = 1891,
    T_DUALTIMEZONE_ID_AESST = 1892,
    T_DUALTIMEZONE_ID_ACSST = 1893,
    T_DUALTIMEZONE_ID_EAST = 1894,
    T_DUALTIMEZONE_ID_GST = 1895,
    T_DUALTIMEZONE_ID_SAT = 1896,
    T_DUALTIMEZONE_ID_WDT = 1897,
    T_DUALTIMEZONE_ID_JST = 1898,
    T_DUALTIMEZONE_ID_KST = 1899,
    T_DUALTIMEZONE_ID_MT = 1900,
    T_DUALTIMEZONE_ID_WST = 1901,
    T_DUALTIMEZONE_ID_CCT = 1902,
    T_DUALTIMEZONE_ID_JT = 1903,
    T_DUALTIMEZONE_ID_IT = 1904,
    T_DUALTIMEZONE_ID_BT = 1905,
    T_DUALTIMEZONE_ID_EETDST = 1906,
    T_DUALTIMEZONE_ID_CETDST = 1907,
    T_DUALTIMEZONE_ID_EET = 1908,
    T_DUALTIMEZONE_ID_FWT = 1909,
    T_DUALTIMEZONE_ID_MEST = 1910,
    T_DUALTIMEZONE_ID_BST = 1911,
    T_DUALTIMEZONE_ID_CET = 1912,
    T_DUALTIMEZONE_IDFST = 1913,
    T_DUALTIMEZONE_ID_SWT = 1914,
    T_DUALTIMEZONE_ID_WETDST = 1915,
    T_DUALTIMEZONE_ID_GMT = 1916,
    T_DUALTIMEZONE_ID_WET = 1917,
    T_DUALTIMEZONE_ID_WAT = 1918,
    T_DUALTIMEZONE_ID_NDT = 1919,
    T_DUALTIMEZONE_ID_ADT = 1920,
    T_DUALTIMEZONE_ID_NFT = 1921,
    T_DUALTIMEZONE_ID_AST = 1922,
    T_DUALTIMEZONE_ID_EDT = 1923,
    T_DUALTIMEZONE_ID_CDT = 1924,
    T_DUALTIMEZONE_ID_EST = 1925,
    T_DUALTIMEZONE_ID_CST = 1926,
    T_DUALTIMEZONE_ID_MDT = 1927,
    T_DUALTIMEZONE_ID_MST = 1928,
    T_DUALTIMEZONE_ID_PDT = 1929,
    T_DUALTIMEZONE_ID_PST = 1930,
    T_DUALTIMEZONE_ID_HDT = 1931,
    T_DUALTIMEZONE_ID_AHST = 1932,
    T_DUALTIMEZONE_ID_NT = 1933,
    T_DUALTIMEZONE_ID_IDLW = 1934,
    T_ACTIVITY2_CHINA1 = 1935,
    T_ACTIVITY2_CHINA2 = 1936,
    T_ACTIVITY2_CHINA3 = 1937,
    T_ACTIVITY2_CHINA4 = 1938,
    T_ACTIVITY2_CHINA5 = 1939,
    T_ACTIVITY2_CHINA6 = 1940,
    T_ACTIVITY3_CHINA1 = 1941,
    T_ACTIVITY3_CHINA2 = 1942,
    T_ACTIVITY3_CHINA3 = 1943,
    T_ACTIVITY3_CHINA4 = 1944,
    T_ACTIVITY_WEEK_1 = 1945,
    T_ACTIVITY_WEEK_2 = 1946,
    T_ACTIVITY_WEEK_3 = 1947,
    T_ACTIVITY_WEEK_4 = 1948,
    T_ACTIVITY_WEEK_5 = 1949,
    T_ACTIVITY_WEEK_6 = 1950,
    T_ACTIVITY_WEEK_7 = 1951,
    T_ACTIVITY4_CHINA1 = 1952,
    T_ACTIVITY4_CHINA2 = 1953,
    T_ACTIVITY5_CHINA1 = 1954,
    T_ACTIVITY5_CHINA2 = 1955,
    T_ACTIVITY6_CHINA1 = 1956,
    T_ACTIVITY6_CHINA2 = 1957,
    T_ACTIVITY6_CHINA3 = 1958,
    T_ACTIVITY6_CHINA4 = 1959,
    T_ACTIVITY6_CHINA5 = 1960,
    T_ACTIVITY6_ARABIC1 = 1961,
    T_ACTIVITY6_ARABIC2 = 1962,
    T_ACTIVITY6_ARABIC3 = 1963,
    T_TRAIN_APP_BT_DISCONNECT = 1964,
    T_TRAIN_APP_BT_RETRY = 1965,
    T_TRAIN_APP_EXIT_SHOW = 1966,
    T_TRAIN_APP_BT_EXIT_SHOW = 1967,
    T_TRAIN_COMPLETE = 1968,
    T_TRAINING_STOPED = 1969,
    T_TRAINING_AUTO_CLOSE = 1970,
    T_WATCH_FACE_NIGHT_SPEED_ID = 1971,
    T_MOTOR_SET_SHARP = 1972,
    T_MOTOR_SET_SOFT = 1973,
    T_MOTOR_SET_END = 1974,
    T_MOTOR_SET_SHARP_BACK = 1975,
    T_MOTOR_SET_SOFT_BACK = 1976,
    T_MOTOR_SET_END_BACK = 1977,
    T_APP_TRAIN_PAUSE_STATE = 1978,
    T_MAX_PACE = 1979,
    T_TRAINDATAPAGE1_1_PACE = 1980,
    T_TRAINDATAPAGE1_1_AVGPACE = 1981,
    T_TRAINDATAPAGE3_1_PACE = 1982,
    T_TRAINDATAPAGE3_1_AVGPACE = 1983,
    T_TRAINDATAPAGE4_1_PACE = 1984,
    T_TRAINDATAPAGE4_1_AVGPACE = 1985,
    T_SPO2_CURRENT_TIME = 1986,
    T_PHONE_CALL_BT_CALL_SWITCH_OFF = 1987,
    T_STORE_QR_CODE = 1988,
    T_STORE_SCAN_CODE = 1989,
    T_COURSE_FUNC_FAT_BURNING = 1990,
    T_COURSE_FUNC_AEROBIC = 1991,
    T_COURSE_FUNC_ENDURANCE = 1992,
    T_COURSE_FUNC_BEGINNER = 1993,
    T_INFORMATION_MSG_SWITCH = 1994,
    T_CHANGE_DISTANCE_REMIND_2_TXT = 1995,
    T_WATCH_FACE_URBAN_ID = 1996,
    T_WATCH_FACE_BURNING_ID = 1997,
    T_WATCH_FACE_SHADOWS_ID = 1998,
    T_WATCH_FACE_PASSING_ID = 1999,
    T_WATCH_FACE_EDGES_ID = 2000,
    T_WATCH_FACE_STRIPES_ID = 2001,
    T_WATCH_FACE_SLEEK_ID = 2002,
    T_WATCH_FACE_CLEAR_ID = 2003,
    T_WATCH_FACE_X_ID = 2004,
    T_WATCH_FACE_SPEEDOMETER_ID = 2005,
    T_WATCH_FACE_CLASSIC_ID = 2006,
    T_SECOND_CALL_COMMU = 2007,
    T_SECOND_CALL_INFO = 2008,
    T_SPO2_ALTITUDE_FOOT = 2009,
    T_HEART_RATE_ALARM_32_2 = 2010,
    T_HEART_RATE_ALARM_26_2 = 2011,
    T_NFF_BATTERYTEMP_TEST = 2012,
    T_NFF_SHELLTEMP_TEST = 2013,
    T_NFF_BATTERYTEMP_TXT = 2014,
    T_NFF_SHELLTEMP_TXT = 2015,
    T_PHONE_CALL_UNKNOWN_INCOMING_CALL = 2016,
    T_TRIATHLON_PROMPT4 = 2017,
    T_HIVOICE_REMIND_UNCONNECT = 2018,
    T_HIVOICE_REMIND_CHECKBT = 2019,
    T_HIVOICE_REMIND_CHECKPERMISSION = 2020,
    T_HIVOICE_REMIND_CHECKVERSION = 2021,
    T_DISTANCE_CALIBRATION_TXT = 2022,
    T_TRAINING_TARGET_REACH_UNIT_M = 2023,
    T_TRAINING_TARGET_REACH_UNIT_YD = 2024,
    T_COURSE_HEART_RATE_ID_30 = 2025,
    T_COURSE_FINISH_TIME_TXT_CENTER = 2026,
    T_HEARTRATE_TOO_HIGH_30 = 2027,
    T_HEARTRATE_TOO_LOW_30 = 2028,
    T_TRAIN_DATA_TYPE_NO_EDIT_34 = 2029,
    T_TRAIN_DATA_TYPE_REMIND_38 = 2030,
    T_RESTOREPHONE_NAME = 2031,
    T_RESTOREPHONE_WATCH_OR_NOT = 2032,
    T_SPO2_PROMPT_TEXT1 = 2033,
    T_SPO2_PROMPT_TEXT2 = 2034,
    T_SPO2_PROMPT_TEXT3 = 2035,
    T_TRAINDATAPAGE2_AVGSPEED = 2036,
    T_TRAINDATAPAGE2_1_AVGSPEED = 2037,
    T_ALARMCLOCK_CLOSEDTXT = 2038,
    T_DUALTIMEZONE_CITY_NEWYORK = 2039,
    T_DUALTIMEZONE_CITY_NEWYORK_DST = 2040,
    T_DUALTIMEZONE_CITY_LONDON = 2041,
    T_DUALTIMEZONE_CITY_LONDON_DST = 2042,
    T_DUALTIMEZONE_CITY_PARIS = 2043,
    T_DUALTIMEZONE_CITY_PARIS_DST = 2044,
    T_DUALTIMEZONE_CITY_TOKYO = 2045,
    T_DUALTIMEZONE_CITY_LOSANGELES = 2046,
    T_DUALTIMEZONE_CITY_LOSANGELES_DST = 2047,
    T_DUALTIMEZONE_CITY_SINGAPORE = 2048,
    T_DUALTIMEZONE_CITY_CHICAGO = 2049,
    T_DUALTIMEZONE_CITY_CHICAGO_DST = 2050,
    T_DUALTIMEZONE_CITY_BEIJING = 2051,
    T_DUALTIMEZONE_CITY_BRUSSELS = 2052,
    T_DUALTIMEZONE_CITY_BRUSSELS_DST = 2053,
    T_DUALTIMEZONE_CITY_BERLIN = 2054,
    T_DUALTIMEZONE_CITY_BERLIN_DST = 2055,
    T_DUALTIMEZONE_TIME_NEWYORK = 2056,
    T_DUALTIMEZONE_TIME_NEWYORK_DST = 2057,
    T_DUALTIMEZONE_TIME_LONDON = 2058,
    T_DUALTIMEZONE_TIME_LONDON_DST = 2059,
    T_DUALTIMEZONE_TIME_PARIS = 2060,
    T_DUALTIMEZONE_TIME_PARIS_DST = 2061,
    T_DUALTIMEZONE_TIME_TOKYO = 2062,
    T_DUALTIMEZONE_TIME_LOSANGELES = 2063,
    T_DUALTIMEZONE_TIME_LOSANGELES_DST = 2064,
    T_DUALTIMEZONE_TIME_SINGAPORE = 2065,
    T_DUALTIMEZONE_TIME_CHICAGO = 2066,
    T_DUALTIMEZONE_TIME_CHICAGO_DST = 2067,
    T_DUALTIMEZONE_TIME_BEIJING = 2068,
    T_DUALTIMEZONE_TIME_BRUSSELS = 2069,
    T_DUALTIMEZONE_TIME_BRUSSELS_DST = 2070,
    T_DUALTIMEZONE_TIME_BERLIN = 2071,
    T_DUALTIMEZONE_TIME_BERLIN_DST = 2072,
    T_DUALTIMEZONE_ID_NEWYORK = 2073,
    T_DUALTIMEZONE_ID_LONDON = 2074,
    T_DUALTIMEZONE_ID_PARIS = 2075,
    T_DUALTIMEZONE_ID_TOKYO = 2076,
    T_DUALTIMEZONE_ID_LOSANGELES = 2077,
    T_DUALTIMEZONE_ID_SINGAPORE = 2078,
    T_DUALTIMEZONE_ID_CHICAGO = 2079,
    T_DUALTIMEZONE_ID_BEIJING = 2080,
    T_DUALTIMEZONE_ID_BRUSSELS = 2081,
    T_DUALTIMEZONE_ID_BERLIN = 2082,
    T_PHONE_CALL_MISS_CALL = 2083,
    T_ALBUM_WEEK_MON_30_ID = 2084,
    T_ALBUM_WEEK_TUE_30_ID = 2085,
    T_ALBUM_WEEK_WED_30_ID = 2086,
    T_ALBUM_WEEK_THU_30_ID = 2087,
    T_ALBUM_WEEK_FRI_30_ID = 2088,
    T_ALBUM_WEEK_SAT_30_ID = 2089,
    T_ALBUM_WEEK_SUN_30_ID = 2090,
    T_ALARMCLOCKEVERYDAYMODETXT = 2091,
    T_MUSIC_NEED_PERMISSION = 2092,
    T_MUSIC_COPYRIGHT_EXPIRED = 2093,
    T_MUSIC_COPYRIGHT_NOTICE = 2094,
    T_SPO2_PROMPT_TEXT4 = 2095,
    T_SPO2_PROMPT_TEXT5 = 2096,
    T_SPO2_PROMPT_TEXT6 = 2097,
    T_SPO2_PROMPT_TEXT7 = 2098,
    T_SPO2_PROMPT_TEXT8 = 2099,
    T_PHONE_CALL_MISS_CALL_NUMBER = 2100,
    T_INFORM_CALL_MISS_CALL = 2101,
    T_TRAIN_SWIM_STOP_CONTINUE = 2102,
    T_TRAIN_SWIM_STOP_CLOSE = 2103,
    T_MODEL_CONTENT_HONOR = 2104,
    T_INFORM_CALL_UNKNOWN = 2105,
    T_ELECTRICITYTHREE = 2106,
    T_CHARGING_REMINDER1_TXT = 2107,
    T_ALBUM_MESSAGE_GENERATED_ID = 2108,
    T_ALBUM_MESSAGE_FAIL_ID = 2109,
    T_HIVOICE_REMIND_BT_UNCONNECT = 2110,
    T_HIVOICE_REMIND_START_ERROR = 2111,
    T_HIVOICE_REMIND_CHECK_FUNCTION = 2112,
    T_HIVOICE_REMIND_EMUI_VERSION = 2113,
    T_HIVOICE_REMIND_LISTENING = 2114,
    T_HIVOICE_REMIND_CLICK_AGAIN = 2115,
    T_HEART_RATE_INFO_TITLE = 2116,
    T_HEART_RATE_INFO_CONTENT = 2117,
    T_IDS_RUNWAY_COURSE_NAME_TEXT = 2118,
    T_TRAINDATAPAGE2_TIME = 2119,
    T_TRAINDATAPAGE2_DISTANCE = 2120,
    T_TRAINDATAPAGE2_HEARTRATE = 2121,
    T_TRAINDATAPAGE2_PACE = 2122,
    T_TRAINDATAPAGE2_AVGPACE = 2123,
    T_TRAINDATAPAGE2_SPEED = 2124,
    T_TRAINDATAPAGE2_TOTALCALORIES = 2125,
    T_TRAINDATAPAGE2_CADENCE = 2126,
    T_TRAINDATAPAGE2_STEPS = 2127,
    T_TRAINDATAPAGE2_TOTALCLIMBING = 2128,
    T_TRAINDATAPAGE2_TOTALDESCENT = 2129,
    T_TRAINDATAPAGE2_VERTICALSPEED = 2130,
    T_TRAINDATAPAGE2_LAPS = 2131,
    T_TRAINDATAPAGE2_TOTALHEIGHT = 2132,
    T_TRAINDATAPAGE2_1_DISTANCE = 2133,
    T_TRAINDATAPAGE2_1_TOTALCLIMBING = 2134,
    T_TRAINDATAPAGE2_1_TOTALDESCENT = 2135,
    T_TRAINDATAPAGE2_1_TOTALHEIGHT = 2136,
    T_TRAINDATAPAGE2_1_SPEED = 2137,
    T_TRAINDATAPAGE2_1_VERTICALSPEED = 2138,
    T_TRAINDATAPAGE2_PRESSURE = 2139,
    T_TRAINDATAPAGE2_CLOCK = 2140,
    T_TRAINDATAPAGE2_1_PACE = 2141,
    T_TRAINDATAPAGE2_1_AVGPACE = 2142,
    T_NFF_CLICK_START_MIC_TEST = 2143,
    T_NFF_MIC_TEST = 2144,
    T_SETTING_SUBTITLE_TXT = 2145,
    T_APP_EXERCISE_SUBTITLE = 2146,
    T_APP_EXERCISE_RECORD_SUBTITLE = 2147,
    T_APP_TAINING_STATUS_SUBTITLE = 2148,
    T_APP_HEART_RATE_SUBTITLE = 2149,
    T_SPO2_SUBTITLE = 2150,
    T_APP_ACTIVITY_RECORD_SUBTITLE = 2151,
    T_APP_SLEEP_SUBTITLE = 2152,
    T_APP_PRESSURE_SUBTITLE = 2153,
    T_APP_BREATHING_TRAINING_SUBTITLE = 2154,
    T_APP_MUSIC_SUBTITLE = 2155,
    T_PHONE_CALL_CONTACTS_SUBTITLE = 2156,
    T_PHONE_CALL_HISTORY_SUBTITLE = 2157,
    T_APP_ALTITUDE_BAROMETER_SUBTITLE = 2158,
    T_APP_COMPASS_SUBTITLE = 2159,
    T_APP_WEATHER_SUBTITLE = 2160,
    T_APP_INFORMATION_SUBTITLE = 2161,
    T_APP_BUS_CARD_SUBTITLE = 2162,
    T_APP_ALIPAY_SUBTITLE = 2163,
    T_APP_STOPWATCH_SUBTITLE = 2164,
    T_APP_COUNTDOWN_TIMER_SUBTITLE = 2165,
    T_APP_ALARM_CLOCK_SUBTITLE = 2166,
    T_APP_FLASHLIGHT_SUBTITLE = 2167,
    T_APP_SEARCH_PHONE_SUBTITLE = 2168,
    T_APP_SETTING_SUBTITLE = 2169,
    T_SETTING_RINGTONE_SIZE = 2170,
    T_SETTING_SILENT_MODE = 2171,
    T_SETTING_SILENT_MODE_TIPS = 2172,
    T_SPO2_PROMPT_TEXT9 = 2173,
    T_SPO2_PROMPT_TEXT10 = 2174,
    T_SPO2_PROMPT_TEXT11 = 2175,
    T_SPO2_INTRODUCTION5 = 2176,
    T_SPO2_INTRODUCTION6 = 2177,
    T_SPO2_INTRODUCTION7 = 2178,
    T_SPO2_INTRODUCTION8 = 2179,
    T_SPO2_INTRODUCTION9 = 2180,
    T_SPO2_INTRODUCTION10 = 2181,
    T_SPO2_INTRODUCTION11 = 2182,
    T_SPO2_INTRODUCTION12 = 2183,
    T_SPO2_INTRODUCTION13 = 2184,
    T_SPO2_INTRODUCTION14 = 2185,
    T_SPO2_INTRODUCTION15 = 2186,
    T_SPO2_INTRODUCTION16 = 2187,
    T_SPO2_INTRODUCTION17 = 2188,
    T_SPO2_INTRODUCTION18 = 2189,
    T_NFF_CLICK_TO_PLAY_THE_SOUND = 2190,
    T_SINGLEUSEID76_2 = 2191,
    T_SINGLEUSEID80_2 = 2192,
    T_TARGETPACEUSERDEFINEUNIT = 2193,
    T_TARGETPACEUSERDEFINEUNIT_1 = 2194,
    T_SELECTOR_BACKGROUND2 = 2195,
    T_SELECTOR_CENTER2 = 2196,
    T_UNIT1_2 = 2197,
    T_UNIT2_2 = 2198,
    T_UNIT3_2 = 2199,
    T_UNIT6_2 = 2200,
    T_UNIT7_2 = 2201,
    T_UNIT1_3 = 2202,
    T_UNIT7_3 = 2203,
    T_HEARTRATE_CHINA1_1 = 2204,
    T_CLICKTXT1 = 2205,
    T_WATCH_FACE_ALBUM_ID = 2206,
    T_ALARM_CLOCK_ADD_ID = 2207,
    T_WEARY_DRIVE_TXT = 2208,
    T_SHARE_ONEHOP_ID = 2209,
    T_SHARE_ONEHOP_ACTIVATE_ID = 2210,
    T_SHARE_ONEHOP_ACTIVATING_ID = 2211,
    T_SHARE_ONEHOP_ACTIVATED_ID = 2212,
    T_SHARE_ONEHOP_ACTIVE_FAILED_ID = 2213,
    T_SHARE_ONEHOP_CHECK_NW_ID = 2214,
    T_SHARE_ONEHOP_CHECK_LOGIN_ID = 2215,
    T_SHARE_ONEHOP_REACTIVATE_ID = 2216,
    T_SHARE_ONEHOP_INACTIVE_ID = 2217,
    T_SHARE_ONEHOP_ACTIVATED_ID_SMALL = 2218,
    T_CHARGING_REMINDER_TXT_ONE = 2219,
    T_CHARGING_REMINDER_TXT_TWO = 2220,
    T_SHARE_ONEHOP_REMIND_ID = 2221,
    T_DIAL_TYPE_10_TXT = 2222,
    T_DIAL_TYPE_12_TXT = 2223,
    T_DIAL_TYPE_11_TXT = 2224,
    T_DIAL_TYPE_13_TXT = 2225,
    T_ALBUM_MESSAGE_WAIT_ID = 2226,
    T_CARD_SETTING_SET = 2227,
    T_CARD_SETTING_ADD = 2228,
    T_CARD_SETTING_SELECT = 2229,
    T_CARD_SETTING_LIMIT_TIPS = 2230,
    T_SHAREONEHOPREMINDSMALL = 2231,
    T_ACCESS_CARD_TITLE = 2232,
    T_ACCESS_CARD_HINT = 2233,
    T_SPO2_MEASURE_FIRST = 2234,
    T_DIAL_CUSTOM_TITLE_ID = 2235,
    T_DIAL_CUSTOM_STEP_ID = 2236,
    T_DIAL_CUSTOM_STRENGTHTIME_ID = 2237,
    T_DIAL_CUSTOM_STANDUPTIME_ID = 2238,
    T_DIAL_CUSTOM_DATE_ID = 2239,
    T_DIAL_CUSTOM_WEEK_ID = 2240,
    T_DIAL_CUSTOM_POWER_ID = 2241,
    T_DIAL_CUSTOM_CALORIE_ID = 2242,
    T_DIAL_CUSTOM_HEARTRATE_ID = 2243,
    T_DIAL_CUSTOM_STRESS_ID = 2244,
    T_DIAL_CUSTOM_WEATHER_ID = 2245,
    T_DIAL_CUSTOM_AQI_ID = 2246,
    T_DIAL_CUSTOM_PRESSURE_ID = 2247,
    T_DIAL_CUSTOM_ALTITUDE_ID = 2248,
    T_DIAL_CUSTOM_VO2MAX_ID = 2249,
    T_DIAL_CUSTOM_DUALTIME_ID = 2250,
    T_DIAL_CUSTOM_NODATA_ID = 2251,
    T_PAUSE_ON_TREADMILL_PROMPT = 2252,
    T_CARD_ACTIVITY_RECORD = 2253,
    T_CARD_HEART_RATE = 2254,
    T_CARD_PRESSURE = 2255,
    T_CARD_ALIPAY = 2256,
    T_CARD_MUSIC = 2257,
    T_CARD_EXERCISE_RECORD = 2258,
    T_CARD_TAINING_STATUS = 2259,
    T_CARD_TRAININGSTATUS_RECOVERYTIME = 2260,
    T_CARD_TRAININGSTATUS_LOAD = 2261,
    T_CARD_TRAININGSTATUS_VO2 = 2262,
    T_CARD_SLEEP = 2263,
    T_CARD_PHONE_CALL_HISTORY = 2264,
    T_CARD_PHONE_CALL_CONTACTS = 2265,
    T_CARD_BAROMETERS = 2266,
    T_CARD_ALTIMETER = 2267,
    T_CARD_COMPASS = 2268,
    T_CARD_WEATHER = 2269,
    T_CARD_BUS_CARD = 2270,
    T_ALARMCLOCKEVERYDAYTXT = 2271,
    T_RED_PACKET = 2272,
    T_WATCH_FACE_GOLDRAT_ID = 2273,
    T_DIAL_EDIT_PROMPT_ID = 2274,
    T_IDS_ALTIMETER_CALIBRATION_CUR_TITLE = 2275,
    T_IDS_ALTIMETER_CALIBRATION_TITLE = 2276,
    T_IDS_ALTIMETER_CALIBRATION_DESC_TXT = 2277,
    T_IDS_ALTIMETER_MANUAL_CALIBRATION_TXT = 2278,
    T_IDS_ALTIMETER_CALIBRATION_TXT = 2279,
    T_PAIR_ADDRESS_TXT = 2280,
    T_WEATHER_AM_TXT = 2281,
    T_WEATHER_PM_TXT = 2282,
    T_SELFIDENTIFICATION_SET_BOTTON = 2283,
    LANGUAGE_TEXT_ID_MAX = 2284
}; // UITextLanguageTextId

#pragma pack()
} // namespace OHOS

#endif // UI_TEXT_LANGUAGE_H
