/*
 * Copyright (c) 2020 Huawei Device Co., Ltd.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <stdio.h>
#include <dlfcn.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <gtest/gtest.h>
#include "log.h"
#include "utils.h"
#include "libfs.h"
#include "KernelConstants.h"

using namespace testing::ext;

class DlopenTest : public testing::Test {
};

#define RES_DIR_DYLOAD RES_DIR_KERNEL "dyload/"
#define DYLOAD_TEST_DIR "/storage/data/"

/**
 * @tc.number   SUB_KERNEL_DL_SO_0400
 * @tc.name     the elf doesn't depend on any user-so. dlopen a not exist so.
 * @tc.desc     [C- SOFTWARE -0200]
 * @tc.size     SMALL
 * @tc.type     FUNC
 */
HWTEST_F(DlopenTest, testDlopenNotExistSo, TestSize.Level3)
{
    dlerror(); // clear any old error message
    char* errMsg = dlerror();
    if (errMsg) {
        LOG("dlerror should return NULL when called twice.");
        FAIL();
    }

    void* h = dlopen("not_exist_dso1.so", RTLD_NOW);
    if (h) {
        LOG("dlopen a non-exist-so should return NULL!");
        FAIL();
    }
    errMsg = dlerror();
    if (!errMsg) {
        LOG("dlerror return NULL!");
        FAIL();
    }
    char* p = strcasestr(errMsg, "No such file");
    if (!p) {
        LOG("dlerror msg invalid, should include 'No such file', actual msg=%s", errMsg);
        FAIL();
    }
}
