/*
 * Copyright (C) 2012 Cyril Hrubis <chrubis@suse.cz>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it would be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Further, this software is distributed without any warranty that it is
 * free of the rightful claim of any third person regarding infringement
 * or the like.  Any license provided herein, whether implied or
 * otherwise, applies only to this software file.  Patent licenses, if
 * any, provided herein do not apply to combinations of this program with
 * other software, or any other product whatsoever.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "test.h"

char *TCID = "tst_device";
int TST_TOTAL = 1;

static const char *dev;

static void cleanup(void)
{
	if (dev)
		tst_release_device(dev);

	tst_rmdir();
}

int main(void)
{
	tst_tmpdir();

	dev = tst_acquire_device(cleanup);
	if (!dev)
		tst_brkm(TCONF, cleanup, "Failed to acquire test device");

	printf("Test device='%s'\n", dev);

	tst_mkfs(cleanup, dev, "ext2", NULL, NULL);

	cleanup();
	tst_exit();
}
