#!/usr/bin/env python3
#coding=utf-8

'''
* Copyright (c) 2020 HiSilicon (Shanghai) Technologies CO., LIMITED.
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*     http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
* Description: Menuconfig entry
'''

import os
from kconfiglib import Kconfig
from menuconfig import menuconfig

def mconf_set_env(style, conf, header):
    """
    These parameters would not be effect unless kconflib supported these.
    """
    os.environ["MENUCONFIG_STYLE"] = style
    os.environ["KCONFIG_CONFIG"] = conf
    os.environ["KCONFIG_CONFIG_HEADER"] = header

def hi_mconfig():
    kconfig = os.path.join("tools", "menuconfig", "Kconfig")
    display_style = "default selection=fg:white,bg:red"
    target_conf = os.path.join("build", "config", "usr_config.mk")
    header = "# Generated by HiSilicon menuconfig tool"
    mconf_set_env(display_style, target_conf, header)
    kconf = Kconfig(filename=kconfig)
    menuconfig(kconf)

if __name__ == "__main__":
    hi_mconfig()
