// CParkCarparkDlg.cpp : ʵļ
//

#include "stdafx.h"
#include "NETSDKDemo3.0.3.h"
#include "CParkCarparkDlg.h"


LPVOID gParklDlg;
CTmsVehicleInfo gstVehicleInfo;
CTmsParkingStatusInfo gstParkStatusInfo;

VOID STDCALL TmsParkStatusDataCallBackFun(IN LPVOID lpUserID, IN NETDEV_TMS_PARKINGSTATUS_S *pstParkStatusData, IN LPVOID lpUserParam)
{
  CCParkCarparkDlg *pDlg = (CCParkCarparkDlg*)gParklDlg;

  gstParkStatusInfo.m_strTollgateID = pstParkStatusData->szTollgateID;
  gstParkStatusInfo.m_strCarPlate = pstParkStatusData->szCarPlate;
  gstParkStatusInfo.m_strSampleTime = pstParkStatusData->szSampleTime;
  gstParkStatusInfo.m_lLedStatus = pstParkStatusData->lLedStatus;
  gstParkStatusInfo.m_lLedColour = pstParkStatusData->lLedColour;
  gstParkStatusInfo.m_lParkingLotID = pstParkStatusData->lParkingLotID;

  PostMessage(pDlg->m_hWnd, WM_UPTMPARKSTATUSDATA, FALSE, FALSE);

  return;

}
											

VOID STDCALL TmsMultiPicDataCallBackFun(IN NETDEV_PIC_DATA_S *pstUniviewData, IN LPVOID lpUserParam)
{
	int iSize = sizeof(NETDEV_PIC_DATA_S);
	CHAR szTmp[256] = {0};
	CHAR szTmpFile[256] = {0};
	INT i = 0;
	LONG lLen = 0;
	FILE *fp = NULL;

	CCParkCarparkDlg *pDlg = (CCParkCarparkDlg*)gParklDlg;

	sprintf(szTmp, "%s\\pic", gszCurrentDir);
	if (!PathIsDirectory(szTmp))    
	{
		if (!CreateDirectory(szTmp, NULL))
		{   
			CString strError;
			strError.Format("Create file path\"%s\"fail.", szTmp);
			AfxMessageBox(strError);
			return;   
		}   		
	}

	/* Ƭ */
	for (i=0; i< pstUniviewData->ulPicNumber; i++)
	{
		memset(szTmpFile,0,256);
		sprintf(szTmpFile, "%s\\%s_%d.jpg", szTmp,pstUniviewData->szPassTime, i);
		FILE *fp =fopen(szTmpFile,"wb");
		if (NULL != fp)
		{
			fwrite(pstUniviewData->apcData[i],1,pstUniviewData->aulDataLen[i], fp);
			fclose(fp);
		}
	}
    gstVehicleInfo.m_strTollgateID = pstUniviewData->szTollgateID;
	gstVehicleInfo.m_lIndex = pstUniviewData->ulRecordID;
	gstVehicleInfo.m_lLaneID = pstUniviewData->lLaneID;
	gstVehicleInfo.m_lColour = pstUniviewData->lPlateColor;
	gstVehicleInfo.m_strCaptureTime = pstUniviewData->acPassTime[0];
	gstVehicleInfo.m_strCarPlate = pstUniviewData->szCarPlate;

	PostMessage(pDlg->m_hWnd, WM_UPTMSVEHICLEDATA, FALSE, FALSE);

	return ;
}

// CCParkCarparkDlg Ի

IMPLEMENT_DYNAMIC(CCParkCarparkDlg, CDialog)

CCParkCarparkDlg::CCParkCarparkDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCParkCarparkDlg::IDD, pParent)
	, m_dwKeepTime(10)
	, m_strTextOne(_T("@2#1ǻͣ"))
	, m_strTextTwo(_T("@2#1ʶ"))
	, m_strTextThree(_T("@2#1һһ"))
	, m_strTextFour(_T("@2#1#T"))
	, m_strLocalIP(_T("192.174.1.5"))
	, m_EnableRadio(0)
{
	m_Vecindex = 0;
	m_Parkindex = 0;
	gParklDlg = this;
}

CCParkCarparkDlg::~CCParkCarparkDlg()
{
}

void CCParkCarparkDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_PARK_PIC_LIST, m_vehicleStatusCtrl);
	DDX_Text(pDX, IDC_PARK_LEDTIME_EDIT, m_dwKeepTime);
	DDX_Control(pDX, IDC_PARK_LEDSCENE_COMBO, m_dwScenceType);
	DDX_Text(pDX, IDC_PARK_LEDTEXT1_EDIT, m_strTextOne);
	DDX_Text(pDX, IDC_PARK_LEDTEXT2_EDIT, m_strTextTwo);
	DDX_Text(pDX, IDC_PARK_LEDTEXT3_EDIT, m_strTextThree);
	DDX_Text(pDX, IDC_PARK_LEDTEXT4_EDIT, m_strTextFour);
	DDX_Text(pDX, IDC_PARK_LOCALIP_EDIT, m_strLocalIP);
	DDX_CBIndex(pDX, IDC_PARK_LEDSCENE_COMBO, m_EnableRadio);
	DDX_Control(pDX, IDC_LIST_PARKING_STATUS, m_ParkingStatusCtrl);
}


BEGIN_MESSAGE_MAP(CCParkCarparkDlg, CDialog)
	ON_MESSAGE(WM_UPTMSVEHICLEDATA, &CCParkCarparkDlg::OnUpdatevehicleData)
	ON_MESSAGE(WM_UPTMPARKSTATUSDATA, &CCParkCarparkDlg::OnUpdateParkStatusData)
	ON_BN_CLICKED(IDC_PARK_SETLEDCFG_BUTTON, &CCParkCarparkDlg::OnBnClickedParkSetledcfgButton)
	ON_BN_CLICKED(IDC_PARK_OUTPUT_BUTTON, &CCParkCarparkDlg::OnBnClickedParkOutputButton)
	ON_BN_CLICKED(IDC_PARK_STARTSTREAM_BUTTON, &CCParkCarparkDlg::OnBnClickedParkStartstreamButton)
	ON_BN_CLICKED(IDC_PARK_STOPSTREAM_BUTTON, &CCParkCarparkDlg::OnBnClickedParkStopstreamButton)
END_MESSAGE_MAP()

BOOL CCParkCarparkDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ڴӶĳʼ
	CRect rect;  
	m_vehicleStatusCtrl.GetClientRect(&rect);  
	m_vehicleStatusCtrl.SetExtendedStyle(m_vehicleStatusCtrl.GetExtendedStyle() | LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES);  
	m_vehicleStatusCtrl.InsertColumn(0,"DeviceID", LVCFMT_CENTER, 3*rect.Width()/20,0);
	m_vehicleStatusCtrl.InsertColumn(1,"PassTime", LVCFMT_CENTER, 4*rect.Width()/20,1);
	m_vehicleStatusCtrl.InsertColumn(2,"LaneId", LVCFMT_CENTER, 3*rect.Width()/20,2);
	m_vehicleStatusCtrl.InsertColumn(3,"License Plate", LVCFMT_CENTER, 5*rect.Width()/20,3);
	m_vehicleStatusCtrl.InsertColumn(4,"colour", LVCFMT_CENTER, 5*rect.Width()/20,4);

	m_ParkingStatusCtrl.GetClientRect(&rect);  
	m_ParkingStatusCtrl.SetExtendedStyle(m_vehicleStatusCtrl.GetExtendedStyle() | LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES);  
	m_ParkingStatusCtrl.InsertColumn(0,"DeviceID", LVCFMT_CENTER, 3*rect.Width()/20,0);
	m_ParkingStatusCtrl.InsertColumn(1,"PassTime", LVCFMT_CENTER, 4*rect.Width()/20,1);
	m_ParkingStatusCtrl.InsertColumn(2,"LaneId", LVCFMT_CENTER, 3*rect.Width()/20,2);
	m_ParkingStatusCtrl.InsertColumn(3,"CarPlate", LVCFMT_CENTER, 5*rect.Width()/20,3);
	m_ParkingStatusCtrl.InsertColumn(4,"ParkingStatus", LVCFMT_CENTER, 5*rect.Width()/20,4);

	m_dwScenceType.InsertString(0, "Idle");
	m_dwScenceType.InsertString(1, "Allow vehicle Passing");
	m_dwScenceType.InsertString(2, "Block vehicle Passing");
	m_dwScenceType.InsertString(3, "Temporary vehicle Passing");
	m_dwScenceType.InsertString(4, "Unlicensed vehicle Passing");
	m_dwScenceType.SetCurSel(0);

	return TRUE;  // return TRUE unless you set the focus to a control
	// 쳣: OCX ҳӦ FALSE
}

// CCParkCarparkDlg Ϣ

LRESULT CCParkCarparkDlg::OnUpdateParkStatusData(WPARAM wParam, LPARAM lParam)
{
	CString tmp;
	char acVehicleStatus[3][10] = {"None","In","other"};
	ULONG index = 4;

	m_ParkingStatusCtrl.InsertItem(m_Parkindex,"");
	//tmp.Format("%d", m_index + 1);
	m_ParkingStatusCtrl.SetItemText(m_Parkindex,0,gstParkStatusInfo.m_strTollgateID);
	m_ParkingStatusCtrl.SetItemText(m_Parkindex,1,gstParkStatusInfo.m_strSampleTime);
	tmp.Format("%d", gstParkStatusInfo.m_lParkingLotID);
	m_ParkingStatusCtrl.SetItemText(m_Parkindex,2,tmp);

	if (0<= gstParkStatusInfo.m_lParkingLotStatus && gstParkStatusInfo.m_lParkingLotStatus<=2)
	{
		index = gstParkStatusInfo.m_lParkingLotStatus;
	}
	m_ParkingStatusCtrl.SetItemText(m_Parkindex,3,gstParkStatusInfo.m_strCarPlate);
	m_ParkingStatusCtrl.SetItemText(m_Parkindex,4,acVehicleStatus[index]);
	m_Parkindex++;
	m_ParkingStatusCtrl.EnsureVisible(m_vehicleStatusCtrl.GetItemCount() - 1,FALSE);
	return 0;
}


LRESULT CCParkCarparkDlg::OnUpdatevehicleData(WPARAM wParam, LPARAM lParam)
{
	CString tmp;
	char acVehicleColour[8][10] = {"White","Yellow","Blue","Black","Other","Green","Red","Y&G"};
	ULONG index = 4;

	m_vehicleStatusCtrl.InsertItem(m_Vecindex,"");
	//tmp.Format("%d", m_index + 1);
	m_vehicleStatusCtrl.SetItemText(m_Vecindex,0,gstVehicleInfo.m_strTollgateID);
	m_vehicleStatusCtrl.SetItemText(m_Vecindex,1,gstVehicleInfo.m_strCaptureTime);
	tmp.Format("%d", gstVehicleInfo.m_lLaneID);
	m_vehicleStatusCtrl.SetItemText(m_Vecindex,2,tmp);

	if (0 <= gstVehicleInfo.m_lColour && gstVehicleInfo.m_lColour <= 7)
	{
		index = gstVehicleInfo.m_lColour;
	}
	m_vehicleStatusCtrl.SetItemText(m_Vecindex,3,gstVehicleInfo.m_strCarPlate);
    
	m_vehicleStatusCtrl.SetItemText(m_Vecindex,4,acVehicleColour[index]);
    m_Vecindex++;
	m_vehicleStatusCtrl.EnsureVisible(m_vehicleStatusCtrl.GetItemCount() - 1,FALSE);
	return 0;
}


void CCParkCarparkDlg::OnBnClickedParkSetledcfgButton()
{
	UpdateData(TRUE);
	if(NULL == m_lpDevHandle)
	{
		return;
	}

	NETDEV_LED_LIST_CFG_S stLedListCfgs;
	stLedListCfgs.dwPlateShowTime = m_dwKeepTime;
	stLedListCfgs.dwSceneNum = 1;
	stLedListCfgs.stuLedLineInfo.dwEnabled = 1;
	stLedListCfgs.stuLedLineInfo.dwScreenLineNum = 4;
	stLedListCfgs.stuLedLineInfo.dwSceneType = m_dwScenceType.GetCurSel();
	stLedListCfgs.stuLedLineInfo.stuContextList[0].dwEnCode = 1;
	strcpy(stLedListCfgs.stuLedLineInfo.stuContextList[0].szContext, m_strTextOne.GetBuffer(0));
	stLedListCfgs.stuLedLineInfo.stuContextList[1].dwEnCode = 1;
	strcpy(stLedListCfgs.stuLedLineInfo.stuContextList[1].szContext, m_strTextTwo.GetBuffer(0));
	stLedListCfgs.stuLedLineInfo.stuContextList[2].dwEnCode = 1;
	strcpy(stLedListCfgs.stuLedLineInfo.stuContextList[2].szContext, m_strTextThree.GetBuffer(0));
	stLedListCfgs.stuLedLineInfo.stuContextList[3].dwEnCode = 1;
	strcpy(stLedListCfgs.stuLedLineInfo.stuContextList[3].szContext, m_strTextFour.GetBuffer(0));


	INT32 iRet = NETDEV_setDeviceLedCfg(m_lpDevHandle, (LPNETDEV_LED_LIST_CFG_S)&stLedListCfgs);
	if(NETDEV_E_SUCCEED != iRet)
	{
		CString strError;
		strError.Format("set DeviceLed Cfg fail:%d.", iRet);
		AfxMessageBox(strError);	
	}
	else
	{
		CString strError;
		strError.Format("set DeviceLed Cfg succeed");
		AfxMessageBox(strError);
	}

}

void CCParkCarparkDlg::OnBnClickedParkOutputButton()
{
	if(NULL == m_lpDevHandle)
	{
		return;
	}

	BOOL bRet = NETDEV_SetOutputSwitchStatusCfg(m_lpDevHandle);
	if(TRUE != bRet)
	{
		CString strError;
		strError.Format("setOutputSwitch fail.");
		AfxMessageBox(strError);	
	}
	else
	{
		CString strError;
		strError.Format("setOutputSwitch succeed");
		AfxMessageBox(strError);
	}
}

void CCParkCarparkDlg::OnBnClickedParkStartstreamButton()
{
	UpdateData(TRUE);

	if(NULL == m_lpDevHandle)
	{
		return;
	}

	BOOL bRet = FALSE;
	if(NULL != m_lpTmsPicHandle)
	{
		bRet = NETDEV_StopPicStream(m_lpTmsPicHandle);
		if (TRUE == bRet)
		{
			m_lpPicHandle = NULL;
		}
	}

	m_lpTmsPicHandle = NETDEV_StartPicStream(m_lpDevHandle, m_hPic.m_hWnd, TRUE, m_strLocalIP.GetBuffer(0), (NETDEV_PIC_UPLOAD_PF)TmsMultiPicDataCallBackFun, NULL);
	if (FALSE == int(m_lpTmsPicHandle))
	{
		CString strError;
		strError.Format("Start Tms PicStream fail.");
		AfxMessageBox(strError);
		return;	
	}
	else
	{
		bRet = NETDEV_SetParkingStatusCB(m_lpDevHandle, (NETDEV_PARKING_STATUS_PF) TmsParkStatusDataCallBackFun, NULL);

		AfxMessageBox("Start Tms PicStream succeed.");
	}

	return;
}

void CCParkCarparkDlg::OnBnClickedParkStopstreamButton()
{
	if(NULL !=  m_lpTmsPicHandle)
	{
		BOOL ulRet = NETDEV_StopPicStream(m_lpTmsPicHandle);
		if (TRUE != ulRet)
		{
			CString strError;
			strError.Format("Stop Tms PicStream fail:%lu.", ulRet);
			AfxMessageBox(strError);
			return;	
		}
		else
		{
			AfxMessageBox("Stop Tms PicStream succeed.");
		}
	}
	m_lpTmsPicHandle = NULL;

	return;
}

