#pragma once

#include "CParkLocalFeaturesDlg.h"
#include "CLiveOperationDlg.h"
#include "CParkPictureDlg.h"
#include "CVehicleListDlg.h"
#include "CParkDevParameterDlg.h"
#include "CParkCarparkDlg.h"
#include "CParkVoiceIntercomDlg.h"
#include "CParkMaintenanceDlg.h"
#include "CParkingCfgDlg.h"
#include "afxcmn.h"



// CCParkDevDlg Ի
typedef enum tagTabIndex
{
    TAB_INDEX_PARKLOCAL = 0,                        /*Local Features*/
	TAB_INDEX_PARKVIDEO = 1,                        /* Live view */
	TAB_INDEX_PARKPHOTO = 2,                        /*Photo */
	TAB_INDEX_VEHICLELIST = 3,                      /*VehicleList operation*/
	TAB_INDEX_PARAMETER = 4,                        /*Parameter*/
	TAB_INDEX_PARKING = 5,                          /*Parking*/
	TAB_INDEX_VOICE = 6 ,                           /*Voice function*/
	TAB_INDEX_MAINTENANCE = 7 ,                     /*system maintenance*/
    TAB_INDEX_PARKCFG = 8 ,                         /*Parking space configuration*/
}TAB_INDEX_E;

class CCParkDevDlg : public CDialog
{
	DECLARE_DYNAMIC(CCParkDevDlg)

public:
	CCParkDevDlg(CWnd* pParent = NULL);   // ׼캯
	virtual ~CCParkDevDlg();

// Ի
	enum { IDD = IDD_PARK_DLG };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV ֧

	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnBnClickedButtonParkLogin();
	afx_msg void OnBnClickedButtonParkLoginout();
    afx_msg void OnTcnSelchangeParkFuncTab(NMHDR *pNMHDR, LRESULT *pResult);
	virtual BOOL OnInitDialog();

public:
	CTabCtrl m_ParkFuncTableCtrl;

	CCLiveOperationDlg m_oLiveOperationDlg;

	CCParkLocalFeaturesDlg m_oParkLocalFeaturesDlg;

	CCParkPictureDlg m_oParkPictureDlg;

	CCVehicleListDlg m_oVehicleListDlg;

	CCParkDevParameterDlg m_oParkDevParameterDlg;

	CCParkCarparkDlg m_oParkCarparkDlg;

	CCParkVoiceIntercomDlg m_oParkVoiceIntercomDlg; 

	CCParkMaintenanceDlg  m_oParkMaintenanceDlg; 

	CCParkingCfgDlg  m_oParkCfgDlg;

public:
	CString m_strDevIP;                  /*Login IP*/
	CString m_strUserName;               
	CString m_strPwd;
	INT16   m_dwDevPort;

};
