// CVehicleListDlg.cpp : ʵļ
//

#include "stdafx.h"
#include "NETSDKDemo3.0.3.h"
#include "CVehicleListDlg.h"


// CCVehicleListDlg Ի

IMPLEMENT_DYNAMIC(CCVehicleListDlg, CDialog)

CCVehicleListDlg::CCVehicleListDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCVehicleListDlg::IDD, pParent)
	, m_dwId(0)
	, m_strPlateNo(_T("A0000"))
	, m_dwEffectiveTime(1555200000)
	, m_dwExpirationTime(155530000)
	, m_ListRadio(0)
{

}

CCVehicleListDlg::~CCVehicleListDlg()
{
}

void CCVehicleListDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//DDX_Radio(pDX, IDC_PARK_ALLOW_RADIO, m_RadioGroupF);
	DDX_Text(pDX, IDC_PARK_RECORDID_EDIT, m_dwId);
	DDX_Text(pDX, IDC_PARK_RECORDPALTE_EDIT, m_strPlateNo);
	//DDX_Text(pDX, IDC_PARK_STARTTIME_EDIT, m_dwEffectiveTime);
	//DDX_Text(pDX, IDC_PARK_ENDTIME_EDIT, m_dwExpirationTime);
	DDX_Radio(pDX, IDC_PARK_ALLOW_RADIO, m_ListRadio);
	DDX_Control(pDX, IDC_BEGINDATE, m_BeginData);
	DDX_Control(pDX, IDC_BEGINTIME, m_BeginTime);
	DDX_Control(pDX, IDC_ENDDATA, m_EndData);
	DDX_Control(pDX, IDC_ENDTIME, m_EndTime);
}


BEGIN_MESSAGE_MAP(CCVehicleListDlg, CDialog)
	ON_BN_CLICKED(IDC_PARK_ADDLISTFILE_BUTTON, &CCVehicleListDlg::OnBnClickedParkAddlistfileButton)
	ON_BN_CLICKED(IDC_PARK_IMPORTLISTFILE_BUTTON, &CCVehicleListDlg::OnBnClickedParkImportlistfileButton)
	ON_BN_CLICKED(IDC_PARK_ALLOWLIST_BUTTON, &CCVehicleListDlg::OnBnClickedParkAllowlistButton)
	ON_BN_CLICKED(IDC_PARK_BLOCKLIST_BUTTON2, &CCVehicleListDlg::OnBnClickedParkBlocklistButton2)
	ON_BN_CLICKED(IDC_PARK_ADDRECORD_BUTTON, &CCVehicleListDlg::OnBnClickedParkAddrecordButton)
	ON_BN_CLICKED(IDC_PARK_MODIFYRECORD_BUTTON, &CCVehicleListDlg::OnBnClickedParkModifyrecordButton)
	ON_BN_CLICKED(IDC_PARK_DELETERECORD_BUTTON, &CCVehicleListDlg::OnBnClickedParkDeleterecordButton)
END_MESSAGE_MAP()


// CCVehicleListDlg Ϣ

void CCVehicleListDlg::OnBnClickedParkAddlistfileButton()
{
	CFileDialog dlg(TRUE, NULL, NULL, OFN_HIDEREADONLY, _T("csv files(*.csv)|*.csv||"), NULL, NULL, FALSE);
	if (IDOK == dlg.DoModal())
	{
		m_strImportPath = dlg.GetPathName();
		SetDlgItemText(IDC_PARK_LISTPATH_EDIT, m_strImportPath);
	}
}

void CCVehicleListDlg::OnBnClickedParkImportlistfileButton()
{
   if(!m_strImportPath.IsEmpty())
   {
	   INT32 iRet = 0;
	   char *listPath = m_strImportPath.GetBuffer(m_strImportPath.GetLength()+1);

	   iRet = NETDEV_ImportBlackWhiteListFile(m_lpDevHandle, listPath);
	   if (0 == iRet)
	   {
		   MessageBox("Import List succeed.");
	   }
	   else
	   {
		   MessageBox("Import List fail.");
	   }
   }
}

void CCVehicleListDlg::OnBnClickedParkAllowlistButton()
{
	CHAR szTmp[256] = {0};
	CHAR szTmpFile[256] = {0};

	sprintf(szTmp, "%s\\Allowlist", gszCurrentDir);
	if (!PathIsDirectory(szTmp))    
	{
		if (!CreateDirectory(szTmp, NULL))
		{   
			CString strError;
			strError.Format("Create fail path: %s fail.", szTmp);
			return;   
		}   		
	}
	sprintf(szTmp, "%s\\GateWhitelist.csv", szTmp);

	INT32 iRet = NETDEV_ExportBlackWhiteListFile(m_lpDevHandle, szTmp);
	if (0 == iRet)
	{
		CString strText;
		strText.Format("Export Allowlist succeed Path:%s.",szTmp);
		AfxMessageBox(strText);
	}
	else
	{
		MessageBox("Export Allowlist fail.");
	}

}

void CCVehicleListDlg::OnBnClickedParkBlocklistButton2()
{
	CHAR szTmp[256] = {0};
	CHAR szTmpFile[256] = {0};
	sprintf(szTmp, "%s\\Blocklist", gszCurrentDir);
	if (!PathIsDirectory(szTmp))    
	{
		if (!CreateDirectory(szTmp, NULL))
		{   
			CString strError;
			strError.Format("Create fail path:%s fail.", szTmp);
			return;   
		}   		
	}
	sprintf(szTmp, "%s\\GateBlacklist.csv", szTmp);


	INT32 iRet = NETDEV_ExportBlackWhiteListFile(m_lpDevHandle, szTmp);
	if (0 == iRet)
	{
		CString strText;
		strText.Format("Export Blocklist succeed Path:%s.",szTmp);
		AfxMessageBox(strText);
	}
	else
	{
		MessageBox("Export Blocklist fail.");
	}
}

void CCVehicleListDlg::OnBnClickedParkAddrecordButton()
{

	UpdateData(TRUE);

	SYSTEMTIME BeginData;
	SYSTEMTIME BeginTime;
    SYSTEMTIME EndData;
	SYSTEMTIME EndTime;

	m_BeginData.GetTime(&BeginData);
	m_BeginTime.GetTime(&BeginTime);
	BeginData.wHour = BeginTime.wHour;
	BeginData.wMinute = BeginTime.wMinute;
	BeginData.wSecond = BeginTime.wSecond;

	m_EndData.GetTime(&EndData);
	m_EndTime.GetTime(&EndTime);
	EndData.wHour = EndTime.wHour;
	EndData.wMinute = EndTime.wMinute;
	EndData.wSecond = EndTime.wSecond;

	CTime EffectiveTime(BeginData);
	CTime ExpirationTime(EndData);

	INT64 nBeginTSenconds = EffectiveTime.GetTime();
	INT64 nEndTSenconds = ExpirationTime.GetTime();

	LPNETDEV_PARK_VEHICLE_RECORD_S pstVehicleRecord = new NETDEV_PARK_VEHICLE_RECORD_S;
	pstVehicleRecord->dwId = m_dwId;
	pstVehicleRecord->dwEnableType = 1;
	strcpy(pstVehicleRecord->szPlateNo,m_strPlateNo.GetBuffer(0));
	pstVehicleRecord->dwEffectiveTime = nBeginTSenconds;
	pstVehicleRecord->dwExpirationTime = nEndTSenconds;

	NETDEV_PARK_VEHICLE_RECORD_EXTERN_S stVehicleRecordExtern;
    stVehicleRecordExtern.dwListType = m_ListRadio;
	stVehicleRecordExtern.dwDBOperateType = NETDEV_DB_OPERATE_ADD;
	stVehicleRecordExtern.stVehicleRecordList.dwNum = 1;
	stVehicleRecordExtern.stVehicleRecordList.astVehicleRecord = (CHAR*)pstVehicleRecord;

	INT32 iRet = NETDEV_AddVehicleRecord(m_lpDevHandle,(LPNETDEV_PARK_VEHICLE_RECORD_EXTERN_S)&stVehicleRecordExtern);
	if (0 == iRet)
	{
		MessageBox("add  record succeed.");
	}
	else
	{
		MessageBox("add  record fail.");
	}

	delete  pstVehicleRecord;
	pstVehicleRecord = NULL;

}

void CCVehicleListDlg::OnBnClickedParkModifyrecordButton()
{
	UpdateData(TRUE);

	SYSTEMTIME BeginData;
	SYSTEMTIME BeginTime;
	SYSTEMTIME EndData;
	SYSTEMTIME EndTime;

	m_BeginData.GetTime(&BeginData);
	m_BeginTime.GetTime(&BeginTime);
	BeginData.wHour = BeginTime.wHour;
	BeginData.wMinute = BeginTime.wMinute;
	BeginData.wSecond = BeginTime.wSecond;

	m_EndData.GetTime(&EndData);
	m_EndTime.GetTime(&EndTime);
	EndData.wHour = EndTime.wHour;
	EndData.wMinute = EndTime.wMinute;
	EndData.wSecond = EndTime.wSecond;

	CTime EffectiveTime(BeginData);
	CTime ExpirationTime(EndData);

	INT64 nBeginTSenconds = EffectiveTime.GetTime();
	INT64 nEndTSenconds = ExpirationTime.GetTime();


	NETDEV_PARK_VEHICLE_RECORD_S stVehicleRecord;
	stVehicleRecord.dwId = m_dwId;
	stVehicleRecord.dwEnableType = 1;
	strcpy(stVehicleRecord.szPlateNo,m_strPlateNo.GetBuffer(0));
	stVehicleRecord.dwEffectiveTime = nBeginTSenconds;
	stVehicleRecord.dwExpirationTime = nEndTSenconds;

	INT32 iRet = 0;
	if(0 == m_ListRadio)
	{
		iRet =  NETDEV_ModifyAllowVehicleRecord(m_lpDevHandle,(LPNETDEV_PARK_VEHICLE_RECORD_S)&stVehicleRecord);
	}
	else
	{
		iRet =  NETDEV_ModifyBlockVehicleRecord(m_lpDevHandle,(LPNETDEV_PARK_VEHICLE_RECORD_S)&stVehicleRecord);
	}

	if (0 == iRet)
	{
		MessageBox("Modify  record succeed.");
	}
	else
	{
		MessageBox("Modify  record fail.");
	}

}

void CCVehicleListDlg::OnBnClickedParkDeleterecordButton()
{
	UpdateData(TRUE);

	INT32 iRet = 0;
	if(0 == m_ListRadio)
	{
		iRet =  NETDEV_DeleteAllowVehicleRecord(m_lpDevHandle,m_dwId);
	}
	else
	{
		iRet =  NETDEV_DeleteBlockVehicleRecord(m_lpDevHandle,m_dwId);
	}

	if (0 == iRet)
	{
		MessageBox("Delete  record succeed.");
	}
	else
	{
		MessageBox("Delete  record fail.");
	}

}
