// CLiveOperationDlg.cpp : ʵļ
//
#pragma once

#include "stdafx.h"
#include "NETSDKDemo3.0.3.h"
#include "CLiveOperationDlg.h"
#include "CParkDevDlg.h"
#include "include.h"

VOID NETDEV_PARSE_VIDEO_DATA_CALLBACK(IN LPVOID lpPlayHandle,
									  IN const NETDEV_PARSE_VIDEO_DATA_S *pstParseVideoData,
									  IN LPVOID lpUserParam)
{
	FILE *fp = NULL;
	CHAR szTime[64] = {0};
	CHAR szTmp[256] = {0};
	CHAR szTmpFile[256] = {0};

	itoa(pstParseVideoData->tTimeStamp, szTime, 10);
	sprintf(szTmp, "%s\\ParseVideoData", gszCurrentDir);
	if (!PathIsDirectory(szTmp))    
	{
		if (!CreateDirectory(szTmp, NULL))
		{   
			CString strError;
			strError.Format("Create fail path\"%s\"fail.", szTmp);
			AfxMessageBox(strError);
			return;   
		}   		
	}

	memset(szTmpFile,0, 256);
	sprintf(szTmpFile, "%s\\%s", szTmp, szTime);
	fp =fopen(szTmpFile,"wb");
	if (NULL != fp)
	{
		fwrite(pstParseVideoData->pucData, 1, pstParseVideoData->dwDataLen, fp);
		fclose(fp);
	}

	return ;
}

VOID NETDEV_DECODE_VIDEO_DATA_CALLBACK(IN LPVOID lpPlayHandle,
									   IN const NETDEV_PICTURE_DATA_S *pstPictureData,
									   IN LPVOID lpUserParam)
{
	FILE *fp = NULL;
	CHAR szTime[64] = {0};
	CHAR szTmp[256] = {0};
	CHAR szTmpFile[256] = {0};

	itoa(pstPictureData->tRenderTime, szTime, 10);
	sprintf(szTmp, "%s\\DecodeVideoData", gszCurrentDir);
	if (!PathIsDirectory(szTmp))    
	{
		if (!CreateDirectory(szTmp, NULL))
		{   
			CString strError;
			strError.Format("Create fail path\"%s\"fail.", szTmp);
			AfxMessageBox(strError);
			return;   
		}   		
	}

	memset(szTmpFile,0, 256);
	sprintf(szTmpFile, "%s\\%s", szTmp, szTime);
	fp =fopen(szTmpFile,"wb");
	if (NULL != fp)
	{
		fwrite(pstPictureData->pucData[0], 1, pstPictureData->dwLineSize[0], fp);
		fclose(fp);
	}

	return ;
}

// CCLiveOperationDlg Ի

IMPLEMENT_DYNAMIC(CCLiveOperationDlg, CDialog)

CCLiveOperationDlg::CCLiveOperationDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCLiveOperationDlg::IDD, pParent)
{

}

CCLiveOperationDlg::~CCLiveOperationDlg()
{
}

void CCLiveOperationDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_PARK_RECORD_FORMAT_COMBO, m_ComboxVideoFileFmt);
	DDX_Control(pDX, IDC_PARK_DATA_FORMAT_COMBO, m_ComboxBitStreamType);
}


BEGIN_MESSAGE_MAP(CCLiveOperationDlg, CDialog)
	ON_BN_CLICKED(IDC_PARK_VIDEO_START_BUTTON, &CCLiveOperationDlg::OnBnClickedParkVideoStartButton)
	ON_BN_CLICKED(IDC_PARK_VIDEO_STOP_BUTTON, &CCLiveOperationDlg::OnBnClickedParkVideoStopButton)
	ON_BN_CLICKED(IDC_PARK_VDESNAP_BUTTON, &CCLiveOperationDlg::OnBnClickedParkVdesnapButton)
	ON_BN_CLICKED(IDC_PARK_START_RECORD_BUTTON, &CCLiveOperationDlg::OnBnClickedParkStartRecordButton)
	ON_BN_CLICKED(IDC_PARK_STOPRECORD_BUTTON, &CCLiveOperationDlg::OnBnClickedParkStoprecordButton)
	ON_BN_CLICKED(IDC_PARK_VIDEODATA_START_BUTTON, &CCLiveOperationDlg::OnBnClickedParkVideodataStartButton)
	ON_BN_CLICKED(IDC_PARK_VIDEODATA_RESET_BUTTON, &CCLiveOperationDlg::OnBnClickedParkVideodataResetButton)
END_MESSAGE_MAP()




BOOL CCLiveOperationDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	m_ComboxVideoFileFmt.InsertString(0, "MP4(audio+video)");
	m_ComboxVideoFileFmt.InsertString(1, "TS(audio+video)");
	m_ComboxVideoFileFmt.InsertString(2, "MP4(audio+video),media file with time in file name");
	m_ComboxVideoFileFmt.InsertString(3, "TS(audio+video),media file with time in file name");
	m_ComboxVideoFileFmt.InsertString(4, "TS(audio)");
	m_ComboxVideoFileFmt.InsertString(5, "MP4(audio)");
	m_ComboxVideoFileFmt.InsertString(6, "TS(audio),media file with time in file name");
	m_ComboxVideoFileFmt.InsertString(7, "MP4(audio),media file with time in file name");
	m_ComboxVideoFileFmt.SetCurSel(0);

	m_ComboxBitStreamType.InsertString(0, "Parse video data.");
	m_ComboxBitStreamType.InsertString(1, "Decode video data.");
	m_ComboxBitStreamType.SetCurSel(0);


	return TRUE;  // return TRUE unless you set the focus to a control
}

void CCLiveOperationDlg::OnBnClickedParkVideoStartButton()
{
	UpdateData(TRUE);

	BOOL bRet = FALSE;
	if(NULL != m_lpPlayHandle)
	{
		bRet = NETDEV_StopRealPlay(m_lpPlayHandle);
		if (TRUE == bRet)
		{
			m_lpPlayHandle = NULL;
		}
		else
		{
			MessageBox(_T("stop videoStream fail."));
			return;
		}
	}

	NETDEV_PREVIEWINFO_S stNetInfo = {0};
	stNetInfo.dwChannelID = m_lChannelID;
	stNetInfo.hPlayWnd = m_hVid.m_hWnd;
    stNetInfo.dwStreamType = NETDEV_LIVE_STREAM_INDEX_MAIN;
	stNetInfo.dwLinkMode = NETDEV_TRANSPROTOCAL_RTPTCP;

	m_lpPlayHandle = NETDEV_RealPlay(m_lpDevHandle, &stNetInfo, NULL, 0);
	if(NULL ==  m_lpPlayHandle)
	{
		MessageBox(_T("start videoStream fail."));
	}
	else
	{
	    CCParkDevDlg *pDlg = (CCParkDevDlg*)glParkDlg;
	    pDlg->SetDlgItemText(IDC_STATIC_VIDEOSTATUS,"Online");
		UpdateData(TRUE);
		MessageBox(_T("start videoStream succeed."));
	}

	return;
}

void CCLiveOperationDlg::OnBnClickedParkVideoStopButton()
{
	if(NULL !=  m_lpPlayHandle)
	{
		BOOL bRet = NETDEV_StopRealPlay(m_lpPlayHandle);
		if (TRUE != bRet)
		{
			MessageBox(_T("stop videoStream fail."));
			return;
		}
		else
		{
			m_lpPlayHandle = NULL;
			MessageBox(_T("stop videoStream succeed."));
		}
	}

	return;
}

void CCLiveOperationDlg::OnBnClickedParkVdesnapButton()
{
	CHAR szCurPath[NETDEV_LEN_260] = {0};
	CHAR szTmpPath[MAX_PATH] = {0};
	CString strCurPath = _T("");
	CString str;
	CTime tm;
	tm = CTime::GetCurrentTime();
	str = tm.Format("%Y%m%d%H%M%S");

	sprintf(szCurPath, ".\\SnapPicture\\%s", str.GetBuffer());

	if(NULL != m_lpPlayHandle)
	{
		CString strOut;

		BOOL bRet = NETDEV_CapturePicture(m_lpPlayHandle, szCurPath, NETDEV_PICTURE_JPG);
		if(TRUE != bRet)
		{
			strOut.Format("CapturePicture Fail.");
		}   
		else
		{
			CString strText;
			strText.Format("CapturePicture Succeed.! Path: %s",szCurPath);
			AfxMessageBox(strText);
		}

		MessageBox(strOut);
	}

	return;
}

void CCLiveOperationDlg::OnBnClickedParkStartRecordButton()
{
	/*Get Save Path*/
	CHAR m_acPlateColor[8][32] = {"MP4(audio+video).mp4","TS(audio+video).ts","MP4(audio+video+time).mp4","TS(audio+video+time).ts","TS(audio).ts","MP4(audio).mp4","TS(audio+time).ts","MP4(audio+time).mp4"};
	CString strVideoPath = "";
	TCHAR szPath[_MAX_PATH];  
	BROWSEINFO bi;  
	bi.hwndOwner = GetSafeHwnd();  
	bi.pidlRoot = NULL;  
	bi.lpszTitle = "Please select the input path";  
	bi.pszDisplayName = szPath;  
	bi.ulFlags = BIF_RETURNONLYFSDIRS;  
	bi.lpfn = NULL;  
	bi.lParam = NULL;  

	LPITEMIDLIST pItemIDList = SHBrowseForFolder(&bi);  

	if(pItemIDList)  
	{  
		if(SHGetPathFromIDList(pItemIDList,szPath))  
		{  
			strVideoPath = szPath;  
			strVideoPath = strVideoPath+"\\";
		}  

		IMalloc* pMalloc;  
		if( SHGetMalloc(&pMalloc) != NOERROR )  
		{  
			TRACE(_T("Can't get the IMalloc interface\n"));  
		}  

		pMalloc->Free(pItemIDList);  
		if(pMalloc)  
			pMalloc->Release();  

		SetDlgItemText(IDC_PARK_VIDEOPATH_EDIT,strVideoPath);
		UpdateData(TRUE);  
	}

	/* Get File Format */
	INT32 dwSelectIndex = m_ComboxVideoFileFmt.GetCurSel();

	CHAR szSaveFileName[260] = {0};
	sprintf(szSaveFileName,"%s%s",strVideoPath,m_acPlateColor[dwSelectIndex]);

    /*start calling SDK fuction*/
	BOOL bRet = NETDEV_SaveRealData(m_lpPlayHandle, szSaveFileName, dwSelectIndex);
	if (TRUE != bRet)
	{
		MessageBox("Start SaveRealData fail.");
	}
	else
	{
		MessageBox("Start SaveRealData succeed.");
	}
    
	return;
}

void CCLiveOperationDlg::OnBnClickedParkStoprecordButton()
{
	BOOL bRet = NETDEV_StopSaveRealData(m_lpPlayHandle);
	if (TRUE != bRet)
	{
		MessageBox("Stop SaveRealData fail.");
	}
	else
	{
		MessageBox("Stop SaveRealData succeed.");
	}
}

void CCLiveOperationDlg::OnBnClickedParkVideodataStartButton()
{
	UpdateData(TRUE);
	BOOL bRet = TRUE;

	INT32 dwSelectIndex = m_ComboxBitStreamType.GetCurSel();
	if (0 == dwSelectIndex)
	{
		bRet = NETDEV_SetPlayParseCB(m_lpPlayHandle, (NETDEV_PARSE_VIDEO_DATA_CALLBACK_PF)NETDEV_PARSE_VIDEO_DATA_CALLBACK, 1, NULL);
	}
	else if (1 == dwSelectIndex)
	{
		bRet = NETDEV_SetPlayDecodeVideoCB(m_lpPlayHandle, (NETDEV_DECODE_VIDEO_DATA_CALLBACK_PF)NETDEV_DECODE_VIDEO_DATA_CALLBACK, 1, NULL);
	}

	if (TRUE != bRet)
	{
		MessageBox("Set PlayVideoCB fail.");
	}
	else
	{
		MessageBox("Set PlayVideoCB succeed.save Path:%s",gszCurrentDir);
	}

	return;
}

void CCLiveOperationDlg::OnBnClickedParkVideodataResetButton()
{
	UpdateData(TRUE);
	BOOL bRet = TRUE;

	INT32 dwSelectIndex = m_ComboxBitStreamType.GetCurSel();

	if (0 == dwSelectIndex)
	{
		bRet = NETDEV_SetPlayParseCB(m_lpPlayHandle,NULL, 1, NULL);
	}
	else if (1 == dwSelectIndex)
	{
		bRet = NETDEV_SetPlayDecodeVideoCB(m_lpPlayHandle,NULL, 1, NULL);
	}

	if (TRUE != bRet)
	{
		MessageBox("Stop PlayVideoCB fail.");
	}
	else
	{
		MessageBox("Stop PlayVideoCB succeed.");
	}

	return;

}


