// CParkDevDlg.cpp : ʵļ
//
#pragma once
#include "stdafx.h"
#include "NETSDKDemo3.0.3.h"
#include "CParkDevDlg.h"
#include "include.h"



VOID ParkStatusReportCB(IN LPVOID lpUserID,IN UINT32 ulReportType, IN VOID *pParam,IN LPVOID lpUserData)
{
	LONG lLen = 0;
	CHAR szTmp[128] = {0};

	CCParkDevDlg *pDlg = (CCParkDevDlg*)glParkDlg;

	switch(ulReportType)
	{
	case NETDEV_ITS_DEV_OFFLINE_E:
		{
			if(lpUserID == m_lpDevHandle)
			{
               pDlg->SetDlgItemText(IDC_STATIC_DEVICESTATUS,"Offline");
			}
			
			break;
		}
	case NETDEV_ITS_DEV_RONLINE_E:
		{
			if(lpUserID == m_lpDevHandle)
			{
		      pDlg->SetDlgItemText(IDC_STATIC_DEVICESTATUS,"Online");
			}

			break;
		}
	case NETDEV_ITS_MEDIA_OFFLINE_E:
		{
			if(pParam == m_lpPicHandle)
			{
              pDlg->SetDlgItemText(IDC_STATIC_PICSTATUS,"Offline");
			}
			else if(pParam == m_lpPlayHandle)
			{
                pDlg->SetDlgItemText(IDC_STATIC_VIDEOSTATUS,"Offline");
			}

			break;
		}
	case NETDEV_ITS_MEDIA_RONLINE_E:
		{
			if(pParam == m_lpPicHandle)
			{
				pDlg->SetDlgItemText(IDC_STATIC_VIDEOSTATUS,"Online");
			}
			else if(pParam == m_lpPlayHandle)
			{
				pDlg->SetDlgItemText(IDC_STATIC_PICSTATUS,"Online");
			}

			break;
		}

	default:
		break;
	}

	pDlg->UpdateData(TRUE);


	return;
}


IMPLEMENT_DYNAMIC(CCParkDevDlg, CDialog)

CCParkDevDlg::CCParkDevDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCParkDevDlg::IDD, pParent)
	, m_strDevIP(_T("192.174.1.173"))
	, m_dwDevPort(80)
	, m_strUserName(_T("admin"))
	, m_strPwd(_T("admin_123"))
{
	glParkDlg = this;
	ULONG ulRet = GetCurrentDirectoryA(MAX_PATH, gszCurrentDir);
	if ((ulRet == 0) || (ulRet >= MAX_PATH))
	{
		return;
	}
}

CCParkDevDlg::~CCParkDevDlg()
{
}

void CCParkDevDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_STATIC_PARK_VIDEO, m_hVid);
	DDX_Control(pDX, IDC_STATIC_PARK_PHOTO, m_hPic);
	DDX_Control(pDX, IDC_PARK_FUNC_TAB, m_ParkFuncTableCtrl);
	DDX_Text(pDX, IDC_EDIT_PARK_DEVIP, m_strDevIP);
	DDX_Text(pDX, IDC_EDIT_PARK_PORT, m_dwDevPort);
	DDX_Text(pDX, IDC_EDIT_PARK_USERNAME, m_strUserName);
	DDX_Text(pDX, IDC_EDIT_PARK_PASSWORD, m_strPwd);
}


BEGIN_MESSAGE_MAP(CCParkDevDlg, CDialog)
	ON_BN_CLICKED(IDC_BUTTON_PARK_LOGIN, &CCParkDevDlg::OnBnClickedButtonParkLogin)
	ON_BN_CLICKED(IDC_BUTTON_PARK_LOGINOUT, &CCParkDevDlg::OnBnClickedButtonParkLoginout)
	ON_NOTIFY(TCN_SELCHANGE, IDC_PARK_FUNC_TAB, &CCParkDevDlg::OnTcnSelchangeParkFuncTab)
END_MESSAGE_MAP()


// CCParkDevDlg Ϣ
BOOL CCParkDevDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ڴӶĳʼ
	// TODO: Add extra initialization here
	m_oLiveOperationDlg.Create(IDD_PARK_VIDED_DLG, GetDlgItem(IDC_PARK_FUNC_TAB));
	m_oParkLocalFeaturesDlg.Create(IDD_PARK_LOCAL_DLG, GetDlgItem(IDC_PARK_FUNC_TAB));
	m_oParkPictureDlg.Create(IDD_PARK_PICTURE_DLG, GetDlgItem(IDC_PARK_FUNC_TAB));
	m_oVehicleListDlg.Create(IDD_PARK_VEHICLELIST_DLG, GetDlgItem(IDC_PARK_FUNC_TAB));
	m_oParkDevParameterDlg.Create(IDD_PARK_PARAMETERCFG_DLG, GetDlgItem(IDC_PARK_FUNC_TAB));
	m_oParkCarparkDlg.Create(IDD_PARK_CARPARK_DLG, GetDlgItem(IDC_PARK_FUNC_TAB));
	m_oParkVoiceIntercomDlg.Create(IDD_PARK_VOICE_DIALOG, GetDlgItem(IDC_PARK_FUNC_TAB));
	m_oParkMaintenanceDlg.Create(IDD_PARK_MAINTENANCE_DLG, GetDlgItem(IDC_PARK_FUNC_TAB));
	m_oParkCfgDlg.Create(IDD_PARKING_CFG_DLG, GetDlgItem(IDC_PARK_FUNC_TAB));

	m_ParkFuncTableCtrl.InsertItem(0, "Local Features");
	m_ParkFuncTableCtrl.InsertItem(1, "Live operation");
	m_ParkFuncTableCtrl.InsertItem(2, "Picture operation");
	m_ParkFuncTableCtrl.InsertItem(3, "VehicleList operation");
	m_ParkFuncTableCtrl.InsertItem(4, "Parameter");
	m_ParkFuncTableCtrl.InsertItem(5, "Parking lot");
	m_ParkFuncTableCtrl.InsertItem(6, "Voice function");
    m_ParkFuncTableCtrl.InsertItem(7, "system maintenance");
	m_ParkFuncTableCtrl.InsertItem(8, "Parking Configuration");


	CRect oTabPtion;
	m_ParkFuncTableCtrl.GetClientRect(&oTabPtion);
	oTabPtion.top    += 25;
	oTabPtion.left   += 2;
	oTabPtion.right  -= 2;
	oTabPtion.bottom -= 2;

	m_oParkLocalFeaturesDlg.MoveWindow(&oTabPtion);

	m_oLiveOperationDlg.MoveWindow(&oTabPtion);

	m_oParkPictureDlg.MoveWindow(&oTabPtion);

	m_oVehicleListDlg.MoveWindow(&oTabPtion);

	m_oParkDevParameterDlg.MoveWindow(&oTabPtion);

	m_oParkCarparkDlg.MoveWindow(&oTabPtion);

	m_oParkVoiceIntercomDlg.MoveWindow(&oTabPtion);

	m_oParkMaintenanceDlg.MoveWindow(&oTabPtion);

	m_oParkCfgDlg.MoveWindow(&oTabPtion);


	m_oParkLocalFeaturesDlg.ShowWindow(SW_SHOW);


	m_ParkFuncTableCtrl.SetCurSel(0);

	UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	// 쳣: OCX ҳӦ FALSE
}

void CCParkDevDlg::OnTcnSelchangeParkFuncTab(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: ڴӿؼ֪ͨ
	m_oParkLocalFeaturesDlg.ShowWindow(SW_HIDE);
	m_oLiveOperationDlg.ShowWindow(SW_HIDE);
	m_oParkPictureDlg.ShowWindow(SW_HIDE);
	m_oVehicleListDlg.ShowWindow(SW_HIDE);
	m_oParkDevParameterDlg.ShowWindow(SW_HIDE);
	m_oParkCarparkDlg.ShowWindow(SW_HIDE);
	m_oParkVoiceIntercomDlg.ShowWindow(SW_HIDE);
	m_oParkMaintenanceDlg.ShowWindow(SW_HIDE);
	m_oParkCfgDlg.ShowWindow(SW_HIDE);

	/* show by tab index */
	switch(m_ParkFuncTableCtrl.GetCurSel())
	{
		case TAB_INDEX_PARKLOCAL:
			{
				m_oParkLocalFeaturesDlg.ShowWindow(SW_SHOW);
				break;
			}
		case TAB_INDEX_PARKVIDEO:
			{
				m_oLiveOperationDlg.ShowWindow(SW_SHOW);
				break;
			}
		case TAB_INDEX_PARKPHOTO:
			{
				m_oParkPictureDlg.ShowWindow(SW_SHOW);
				break;
			}
		case TAB_INDEX_VEHICLELIST:
			{
				m_oVehicleListDlg.ShowWindow(SW_SHOW);
				break;
			}
		case TAB_INDEX_PARAMETER:
			{
				m_oParkDevParameterDlg.ShowWindow(SW_SHOW);
				break;
			}
		case TAB_INDEX_PARKING:
			{
				m_oParkCarparkDlg.ShowWindow(SW_SHOW);
				break;
			}
		case TAB_INDEX_VOICE:
			{
				m_oParkVoiceIntercomDlg.ShowWindow(SW_SHOW);
				break;
			}
		case TAB_INDEX_MAINTENANCE:
			{
				m_oParkMaintenanceDlg.ShowWindow(SW_SHOW);
				break;
			}
        case TAB_INDEX_PARKCFG:
	        {
				m_oParkCfgDlg.ShowWindow(SW_SHOW);
				break;
			}


	default:
		break;
	}

    UpdateData(FALSE);

	*pResult = 0;

	return;
}


void CCParkDevDlg::OnBnClickedButtonParkLogin()
{
	UpdateData(TRUE);
	CString strError;
	NETDEV_DEVICE_INFO_S stDevInfo = {0};

	if(NULL != m_lpDevHandle)
	{
		NETDEV_Logout(m_lpDevHandle);
		m_lpDevHandle = NULL;

		if(NULL != m_lpPlayHandle)
		{
			NETDEV_StopRealPlay(m_lpPlayHandle);
			m_lpPlayHandle = NULL;
		}

		if(NULL != m_lpPicHandle)
		{
			NETDEV_StopPicStream(m_lpPicHandle);
			m_lpPicHandle = NULL;
		}
	}

	m_lpDevHandle = NETDEV_Login(m_strDevIP.GetBuffer(0), m_dwDevPort, m_strUserName.GetBuffer(0), m_strPwd.GetBuffer(0), &stDevInfo);
	if(m_lpDevHandle == NULL)
	{
		strError.Format("Login fail.");
		AfxMessageBox(strError);
		return;
	}
	else
	{
		SetDlgItemText(IDC_STATIC_DEVICESTATUS,"Online");
		UpdateData(TRUE);
		AfxMessageBox("Login succeed.");
	}

	BOOL bRet = NETDEV_SetParkStatusCallBack(m_lpDevHandle, (NETDEV_ParkStatusReportCallBack_PF)ParkStatusReportCB, NULL);
	if (TRUE != bRet)
	{
		AfxMessageBox("Set ParkStatus CallBack fail.");
	}

}

void CCParkDevDlg::OnBnClickedButtonParkLoginout()
{
	
	if(NULL != m_lpPlayHandle)
	{
		NETDEV_StopRealPlay((HANDLE)m_lpPlayHandle);
		m_lpPlayHandle = NULL;
	}

	if(NULL != m_lpPicHandle)
	{
		NETDEV_StopPicStream((HANDLE)m_lpPicHandle);
		m_lpPicHandle = NULL;
	}

	BOOL bRet = NETDEV_Logout(m_lpDevHandle);
	if (TRUE == bRet)
	{
		m_lpDevHandle = NULL;
		AfxMessageBox("Logout succeed.");
	}
	else
	{
		AfxMessageBox("Logout fail.");
	}

    return;
}


