// CParkDevParameter.cpp : ʵļ
//

#include "stdafx.h"
#include "NETSDKDemo3.0.3.h"
#include "CParkDevParameterDlg.h"


// CCParkDevParameter Ի

IMPLEMENT_DYNAMIC(CCParkDevParameterDlg, CDialog)

CCParkDevParameterDlg::CCParkDevParameterDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCParkDevParameterDlg::IDD, pParent)
{

}

CCParkDevParameterDlg::~CCParkDevParameterDlg()
{
}

void CCParkDevParameterDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_PARK_GETCFG_COMBO, m_ComboxGetConfig);
	DDX_Control(pDX, IDC_PARK_SETCFG_COMBO, m_ComboxSetConfig);
	DDX_Control(pDX, IDC_COMBO3, m_ComboxCapability);
	DDX_Control(pDX, IDC_PARK_OSDEFFECT_COMBO, m_ComboxOsdFontStytle);
	DDX_Control(pDX, IDC_PARK_OSDFONTSIZE_COMBO, m_ComboxOsdFontSize);
	DDX_Control(pDX, IDC_PARK_OSDMIN_COMBO, m_ComboxOsdMin);
	DDX_Control(pDX, IDC_PARK_OSDFONTCOL_COMBO, m_ComboxOsdColor);
}


BEGIN_MESSAGE_MAP(CCParkDevParameterDlg, CDialog)
	ON_BN_CLICKED(IDC_PARK_GETCFG_BUTTON, &CCParkDevParameterDlg::OnBnClickedParkGetcfgButton)
	ON_BN_CLICKED(IDC_PARK_SETCFG_BUTTON, &CCParkDevParameterDlg::OnBnClickedParkSetcfgButton)
	ON_BN_CLICKED(IDC_PARK_GETCAPA_BUTTON2, &CCParkDevParameterDlg::OnBnClickedParkGetcapaButton2)
	ON_BN_CLICKED(IDC_PARK_SETOSD_BUTTON, &CCParkDevParameterDlg::OnBnClickedParkSetosdButton)
//	ON_BN_CLICKED(IDC_PARK_GETCFGS_BUTTON, &CCParkDevParameterDlg::OnBnClickedParkGetcfgsButton)
END_MESSAGE_MAP()


// CCParkDevParameter Ϣ
BOOL CCParkDevParameterDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ڴӶĳʼ
	m_lChannelID = 0;
	InitComb();

	return TRUE;  // return TRUE unless you set the focus to a control
	// 쳣: OCX ҳӦ FALSE
}


void CCParkDevParameterDlg::InitComb()
{
	m_ComboxGetConfig.InsertString(0, "豸Ϣ");
	m_ComboxGetConfig.InsertString(1, "NTP");
	m_ComboxGetConfig.InsertString(2, "Ƶ");
	m_ComboxGetConfig.InsertString(3, "Ƶ(չʹ)");
	m_ComboxGetConfig.InsertString(4, "ͼɼʽ");
	//m_ComboxGetConfig.InsertString(5, "OSDϢ");
	m_ComboxGetConfig.InsertString(5, "OSDϢ(չʹ)");
	m_ComboxGetConfig.InsertString(6, "OSDʽ");
	m_ComboxGetConfig.InsertString(7, "Ϣ");
	m_ComboxGetConfig.InsertString(8, "");
	m_ComboxGetConfig.InsertString(9, "ͼϢ");
	m_ComboxGetConfig.InsertString(10, "Ϣ");
	m_ComboxGetConfig.InsertString(11, "ӲϢ");
	m_ComboxGetConfig.InsertString(12, "۽Ϣ");
	m_ComboxGetConfig.InsertString(13, "ҹģʽϢ");
	m_ComboxGetConfig.InsertString(14, "͸ģʽϢ");
	//m_ComboxGetConfig.InsertString(16, "λ״̬Ϣ(Ͻӿ)");
	//m_ComboxGetConfig.InsertString(17, "λϢ(old)");
	m_ComboxGetConfig.InsertString(15, "OSDʽ");
	//m_ComboxGetConfig.InsertString(17, "OSD");
//	m_ComboxGetConfig.InsertString(18, "ʲ");
	m_ComboxGetConfig.InsertString(16, "ͼع̬");
	m_ComboxGetConfig.InsertString(17, "ͼ̬");
	m_ComboxGetConfig.InsertString(18, "ƬƬл");
	m_ComboxGetConfig.InsertString(19, "ͼ");
	//m_ComboxGetConfig.InsertString(22, "ͼ");
	m_ComboxGetConfig.InsertString(20, "ãв");
	m_ComboxGetConfig.InsertString(21, "ã");
	m_ComboxGetConfig.InsertString(22, "ã");
	m_ComboxGetConfig.InsertString(23, "λָʾƿ");
	m_ComboxGetConfig.InsertString(24, "ڰװ");
	m_ComboxGetConfig.SetCurSel(0);

	m_ComboxSetConfig.InsertString(0, "NTP");
	m_ComboxSetConfig.InsertString(1, "Ƶ");
	m_ComboxSetConfig.InsertString(2, "Ƶ(չʹ)");
	m_ComboxSetConfig.InsertString(3, "ͼɼʽ");
	m_ComboxSetConfig.InsertString(4, "OSDϢ");
	m_ComboxSetConfig.InsertString(5, "OSDϢ(չʹ)");
	m_ComboxSetConfig.InsertString(6, "OSDʽ");
	m_ComboxSetConfig.InsertString(7, "Ϣ");
	m_ComboxSetConfig.InsertString(8, "");
	m_ComboxSetConfig.InsertString(9, "ͼϢ");
	m_ComboxSetConfig.InsertString(10, "Ϣ");
	m_ComboxSetConfig.InsertString(11, "۽Ϣ");
	m_ComboxSetConfig.InsertString(12, "ҹģʽϢ");
	m_ComboxSetConfig.InsertString(13, "͸ģʽϢ");
	m_ComboxSetConfig.InsertString(14, "λϢ");
	m_ComboxSetConfig.InsertString(15, "OSDʽ");
	m_ComboxSetConfig.InsertString(16, "OSD");
	m_ComboxSetConfig.InsertString(17, "ʲ");
	m_ComboxSetConfig.InsertString(18, "ͼع̬");
	m_ComboxSetConfig.InsertString(19, "ͼ̬");
	m_ComboxSetConfig.InsertString(20, "ƬƬл");
	m_ComboxSetConfig.InsertString(21, "ͼ");
	m_ComboxSetConfig.InsertString(22, "ͼ");
	m_ComboxSetConfig.InsertString(23, "ͼͨл");
	m_ComboxSetConfig.InsertString(24, "ãв");
	m_ComboxSetConfig.InsertString(25, "ã");
	m_ComboxSetConfig.InsertString(26, "ã");
	m_ComboxSetConfig.InsertString(27, "λָʾƿ");
	m_ComboxSetConfig.InsertString(28, "ڰװ");
	m_ComboxSetConfig.SetCurSel(0);


	m_ComboxCapability.InsertString(0, "Ƶ");
	m_ComboxCapability.InsertString(1, "OSD");
	m_ComboxCapability.InsertString(2, "Ƶ(չ)");
	m_ComboxCapability.SetCurSel(0);

	m_ComboxOsdFontStytle.InsertString(0,"Background");
	m_ComboxOsdFontStytle.InsertString(1,"Stroke");
	m_ComboxOsdFontStytle.InsertString(2,"Hollow");
	m_ComboxOsdFontStytle.InsertString(3,"Normal");
	m_ComboxOsdFontStytle.InsertString(4,"Inverse");
	m_ComboxOsdFontStytle.SetCurSel(0);

	m_ComboxOsdFontSize.InsertString(0,"X-large");
	m_ComboxOsdFontSize.InsertString(1,"large");
	m_ComboxOsdFontSize.InsertString(2,"Medium");
	m_ComboxOsdFontSize.InsertString(3,"small");
	m_ComboxOsdFontSize.SetCurSel(0);

	m_ComboxOsdMin.InsertString(0,"None");
	m_ComboxOsdMin.InsertString(1,"Single");
	m_ComboxOsdMin.InsertString(2,"Double");
	m_ComboxOsdMin.SetCurSel(0);

	m_ComboxOsdColor.InsertString(0,"Black");
	m_ComboxOsdColor.InsertString(1,"Red");
	m_ComboxOsdColor.InsertString(2,"Blue");
	m_ComboxOsdColor.InsertString(3,"Green");
	m_ComboxOsdColor.SetCurSel(0);
}


void GetDeviceConfig()
{
	CString strError;
	INT32 dwBytesReturned = 0;
	NETDEV_DEVICE_BASICINFO_S stDeviceBasicInfo = {0};

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_DEVICECFG, &stDeviceBasicInfo, sizeof(NETDEV_DEVICE_BASICINFO_S), &dwBytesReturned);
	if (TRUE != bRet)
	{
		strError.Format("ȡ豸Ϣʧ, :%d", bRet);
		AfxMessageBox(strError);
		return;
	}

	strError.Format("豸ͺţ%s\nӲкţ%s\n汾ţ%s\nIPv4Macַ%s\n豸ƣ%s", stDeviceBasicInfo.szDevModel, stDeviceBasicInfo.szSerialNum, 
		stDeviceBasicInfo.szFirmwareVersion, stDeviceBasicInfo.szMacAddress, stDeviceBasicInfo.szDeviceName);
	AfxMessageBox(strError);

	return;
}

void GetNTPConfig()
{
	CString strError;
	INT32 dwBytesReturned = 0;
	NETDEV_SYSTEM_NTP_INFO_S stSystemNtpInfo;
	memset(&stSystemNtpInfo, 0, sizeof(NETDEV_SYSTEM_NTP_INFO_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_NTPCFG, &stSystemNtpInfo, sizeof(NETDEV_SYSTEM_NTP_INFO_S), &dwBytesReturned);
	if (TRUE != bRet)
	{
		strError.Format("ȡNTPʧ, :%d", bRet);
		AfxMessageBox(strError);
		return;
	}

	strError.Format("Ƿ֧DHCP%d\nNTP Ϣ\nЭͣ%d\nIPַ%s", stSystemNtpInfo.bSupportDHCP, stSystemNtpInfo.stAddr.eIPType, stSystemNtpInfo.stAddr.szIPAddr);
	AfxMessageBox(strError);

	return;
}

void GetStreamConfig()
{
	CString strError;
	INT32 dwBytesReturned = 0;
	NETDEV_VIDEO_STREAM_INFO_S stVideoStreamInfo;
	memset(&stVideoStreamInfo, 0, sizeof(NETDEV_VIDEO_STREAM_INFO_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_STREAMCFG, &stVideoStreamInfo, sizeof(NETDEV_VIDEO_STREAM_INFO_S), &dwBytesReturned);
	if (TRUE != bRet)
	{
		strError.Format("ȡƵʧ, :%d", bRet);
		AfxMessageBox(strError);
		return;
	}

	strError.Format("%d\nǷã%d\nƵֱ-Height%d\nƵֱ-Width%d\nƵ֡ʣ%d\nʣ%d\nƵʽ%d\nͼ%d\nI֡%d",
		stVideoStreamInfo.enStreamType, stVideoStreamInfo.bEnableFlag, stVideoStreamInfo.dwHeight, stVideoStreamInfo.dwWidth, stVideoStreamInfo.dwFrameRate,
		stVideoStreamInfo.dwBitRate, stVideoStreamInfo.enCodeType, stVideoStreamInfo.enQuality, stVideoStreamInfo.dwGop);
	AfxMessageBox(strError);

	return;
}

void GetStreamConfigEx()
{
	CString strError;
	INT32 dwBytesReturned = 0;
	NETDEV_VIDEO_STREAM_INFO_LIST_S stVideoStreamInfoList;
	memset(&stVideoStreamInfoList, 0, sizeof(NETDEV_VIDEO_STREAM_INFO_LIST_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_STREAMCFG_EX, &stVideoStreamInfoList, sizeof(NETDEV_VIDEO_STREAM_INFO_LIST_S), &dwBytesReturned);
	if (TRUE != bRet)
	{
		strError.Format("ȡƵ(չʹ)ʧ, :%d", bRet);
		AfxMessageBox(strError);
		return;
	}

	strError.Format("Ƶ%d\nƵϢб\n[\nƵǷñ룺%d\n%d\nͣ%d\nƵϢ\n[\nSVC,0ر,1%d\nƵʽϢ%d\n"\
		"ͼȣ%d\nͼ߶ȣ%d\nʣ%d\nͣ%d\n֡ʣ%d\nGopģʽ%d\nI֡Χ%d\nͼΧ[1, 9]9ͼߣ%d\n"\
		"ƽȼΧ[1,9]1ƽͣ%d\nܱģʽ%d\n]\n]", stVideoStreamInfoList.udwNum, stVideoStreamInfoList.astVideoStreamInfoList[0].bEnabled,
		stVideoStreamInfoList.astVideoStreamInfoList[0].udwStreamID, stVideoStreamInfoList.astVideoStreamInfoList[0].udwMainStreamType,
		stVideoStreamInfoList.astVideoStreamInfoList[0].stVideoEncodeInfo.bEnableSVCMode, stVideoStreamInfoList.astVideoStreamInfoList[0].stVideoEncodeInfo.udwEncodeFormat,
		stVideoStreamInfoList.astVideoStreamInfoList[0].stVideoEncodeInfo.udwWidth, stVideoStreamInfoList.astVideoStreamInfoList[0].stVideoEncodeInfo.udwHeight,
		stVideoStreamInfoList.astVideoStreamInfoList[0].stVideoEncodeInfo.udwBitrate, stVideoStreamInfoList.astVideoStreamInfoList[0].stVideoEncodeInfo.udwBitrateType,
		stVideoStreamInfoList.astVideoStreamInfoList[0].stVideoEncodeInfo.udwFrameRate, stVideoStreamInfoList.astVideoStreamInfoList[0].stVideoEncodeInfo.udwGopType,
		stVideoStreamInfoList.astVideoStreamInfoList[0].stVideoEncodeInfo.udwIFrameInterval, stVideoStreamInfoList.astVideoStreamInfoList[0].stVideoEncodeInfo.udwImageQuality,
		stVideoStreamInfoList.astVideoStreamInfoList[0].stVideoEncodeInfo.udwSmoothLevel, stVideoStreamInfoList.astVideoStreamInfoList[0].stVideoEncodeInfo.udwSmartEncodeMode);
	AfxMessageBox(strError);

	return;
}

void GetVideoModeConfig()
{
	CString strError;
	INT32 dwBytesReturned = 0;
	NETDEV_VIDEO_MODE_INFO_S stVideoModeInfo;
	memset(&stVideoModeInfo, 0, sizeof(NETDEV_VIDEO_MODE_INFO_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_VIDEOMODECFG, &stVideoModeInfo, sizeof(NETDEV_VIDEO_MODE_INFO_S), &dwBytesReturned);
	if (TRUE != bRet)
	{
		strError.Format("ȡͼɼʽʧ, :%d", bRet);
		AfxMessageBox(strError);
		return;
	}

	strError.Format("ͼȣ%d\nͼ߶ȣ%d\nͼ֡ʣ%d", stVideoModeInfo.udwWidth, stVideoModeInfo.udwHeight, stVideoModeInfo.udwFrameRate);
	AfxMessageBox(strError);

	return;
}

void GetPtzPresets()
{
	CString strTemp, strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_PTZ_ALLPRESETS_S stPtzPresets;
	memset(&stPtzPresets, 0, sizeof(NETDEV_PTZ_ALLPRESETS_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_PTZPRESETS, (LPVOID)&stPtzPresets, sizeof(NETDEV_PTZ_ALLPRESETS_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡ̨Ԥλʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	strOut.Format("Ԥλ%d\nԤλϢṹ\n[\n", stPtzPresets.dwSize);

	for(INT32 i = 0; i < stPtzPresets.dwSize; i++)
	{
		strTemp.Format("ţ%d, ԤλID%d, Ԥλƣ%s\n", i, stPtzPresets.astPreset[i].dwPresetID, stPtzPresets.astPreset[i].szPresetName);
		strOut += strTemp;
	}
	strOut += "]";

	AfxMessageBox(strOut);

	return;
}

void GetOSDConfig()
{
	CString strTemp, strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_VIDEO_OSD_CFG_S stVideoOsdConfig;
	memset(&stVideoOsdConfig, 0, sizeof(NETDEV_VIDEO_OSD_CFG_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_OSDCFG, (LPVOID)&stVideoOsdConfig, sizeof(NETDEV_VIDEO_OSD_CFG_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡOSDϢʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	strOut.Format("ͨʱOSDϢ\n[\nʱOSDʹܣ%d\nǷʾ(Ԥ)%d\n꣺xֵ[0,10000]%dyֵ[0,10000]%d\n"\
		"ʱOSDʱʽ%d\nOSDʱʽ%d\n]\nͨOSDϢ\n[\nOSDַʹܣ%d\nOSDַ꣺xֵ[0,10000]%d"\
		"yֵ[0,10000]%d\nOSDַַ%s\n]\nַOSD%d\nͨOSDַϢ\n[\n", stVideoOsdConfig.stTimeOSD.bEnableFlag,
		stVideoOsdConfig.stTimeOSD.bWeekEnableFlag, stVideoOsdConfig.stTimeOSD.stAreaScope.dwLocateX, stVideoOsdConfig.stTimeOSD.stAreaScope.dwLocateY,
		stVideoOsdConfig.stTimeOSD.udwTimeFormat, stVideoOsdConfig.stTimeOSD.udwDateFormat, stVideoOsdConfig.stNameOSD.bEnableFlag,
		stVideoOsdConfig.stNameOSD.stAreaScope.dwLocateX, stVideoOsdConfig.stNameOSD.stAreaScope.dwLocateY, stVideoOsdConfig.stNameOSD.szOSDText,
		stVideoOsdConfig.wTextNum);

	for(INT32 i = 0; i < NETDEV_OSD_TEXTOVERLAY_NUM; i++)
	{
		strTemp.Format("ţ%d, OSDַʹܣ%d, OSDַ꣺xֵ[0,10000]%d,yֵ[0,10000]%dOSDַַ%s\n", i,
			stVideoOsdConfig.astTextOverlay[i].bEnableFlag, stVideoOsdConfig.astTextOverlay[i].stAreaScope.dwLocateX,
			stVideoOsdConfig.astTextOverlay[i].stAreaScope.dwLocateY, stVideoOsdConfig.astTextOverlay[i].szOSDText);
		strOut += strTemp;
	}
	strOut += "]";

	AfxMessageBox(strOut);

	return;
}

void GetOSDContentConfig()
{
	CString strTemp, strTemp1, strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_OSD_CONTENT_S stOsdContent;
	memset(&stOsdContent, 0, sizeof(NETDEV_OSD_CONTENT_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_OSD_CONTENT_CFG, (LPVOID)&stOsdContent, sizeof(NETDEV_OSD_CONTENT_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡOSDϢ(չʹ)ʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	strOut.Format("OSD%d\nOSDϢб\n[\n", stOsdContent.udwNum);

	for(INT32 i = 0; (i < stOsdContent.udwNum) && (i < NETDEV_LEN_32); i++)
	{
		strTemp.Format("ţ%d, OSDʹܣ%d, OSDţΧ[0,7]%d, ǰOSDĿ%d, OSD,Χ[0,9999]%d, OSD,Χ[0,9999]%d, "\
			"old޴˲OSD,Χ[0,9999]%d, old޴˲OSD,Χ[0,9999]%d, ǰOSDϢ\n[\n", i,
			stOsdContent.astContentList[i].bEnabled, stOsdContent.astContentList[i].udwOSDID, stOsdContent.astContentList[i].udwAreaOSDNum,
			stOsdContent.astContentList[i].udwTopLeftX, stOsdContent.astContentList[i].udwTopLeftY, stOsdContent.astContentList[i].udwBotRightX,
			stOsdContent.astContentList[i].udwBotRightY);
		for (INT32 j = 0; (j < stOsdContent.astContentList[i].udwAreaOSDNum) && (j < NETDEV_LEN_8); j++)
		{
			strTemp1.Format("ţ%d, OSDͣ%d, OSDıϢ%s\n", j, stOsdContent.astContentList[i].astContentInfo[j].udwContentType,
				stOsdContent.astContentList[i].astContentInfo[j].szOSDText);
			strTemp += strTemp1;
		}
		strTemp += "]\n";
		strOut += strTemp;
	}
	strOut += "]";

	AfxMessageBox(strOut);

	return;
}

void GetOSDContentStyleCfg()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_OSD_CONTENT_STYLE_S stOsdContentStyle;
	memset(&stOsdContentStyle, 0, sizeof(NETDEV_OSD_CONTENT_STYLE_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_OSD_CONTENT_STYLE_CFG, (LPVOID)&stOsdContentStyle, sizeof(NETDEV_OSD_CONTENT_STYLE_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡOSDʽʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	strOut.Format("ʽ%d\nС%d\nɫ%d\nڸʽ%d\nʱʽ%d\n룬̶8IPC֧֣[%d, %d, %d, %d, %d, %d, %d, %d]\nԵյַIPC֧֣%d",
		stOsdContentStyle.udwFontStyle, stOsdContentStyle.udwFontSize, stOsdContentStyle.udwColor, stOsdContentStyle.udwDateFormat, stOsdContentStyle.udwTimeFormat,
		stOsdContentStyle.audwFontAlignList[0], stOsdContentStyle.audwFontAlignList[1], stOsdContentStyle.audwFontAlignList[2], stOsdContentStyle.audwFontAlignList[3],
		stOsdContentStyle.audwFontAlignList[4], stOsdContentStyle.audwFontAlignList[5], stOsdContentStyle.audwFontAlignList[6], stOsdContentStyle.audwFontAlignList[7],
		stOsdContentStyle.udwMargin);

	AfxMessageBox(strOut);

	return;
}

void GetAlarmOutputCfg()
{
	CString strTemp, strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_ALARM_OUTPUT_LIST_S stAlarmOutputList;
	memset(&stAlarmOutputList, 0, sizeof(NETDEV_ALARM_OUTPUT_LIST_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_ALARM_OUTPUTCFG, (LPVOID)&stAlarmOutputList, sizeof(NETDEV_ALARM_OUTPUT_LIST_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡϢʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	strOut.Format("%d\nϢ\n[\n", stAlarmOutputList.dwSize);

	for (int i = 0; (i < stAlarmOutputList.dwSize) && (i < NETDEV_MAX_ALARM_IN_NUM); i++)
	{
		strTemp.Format("ţ%d, ƣ%s, ͨţ%d, Ĭ״̬%d, 澯ʱ λ S%d\n", i, stAlarmOutputList.astAlarmOutputInfo[i].szName,
			stAlarmOutputList.astAlarmOutputInfo[i].dwChancelId, stAlarmOutputList.astAlarmOutputInfo[i].enDefaultStatus, stAlarmOutputList.astAlarmOutputInfo[i].dwDurationSec);
		strOut += strTemp;
	}
	strOut += "]";

	AfxMessageBox(strOut);

	return;
}

void GetAlarmInputCfg()
{
	CString strTemp, strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_ALARM_INPUT_LIST_S stAlarmInputList;
	memset(&stAlarmInputList, 0, sizeof(NETDEV_ALARM_INPUT_LIST_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_ALARM_INPUTCFG, (LPVOID)&stAlarmInputList, sizeof(NETDEV_ALARM_INPUT_LIST_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	strOut.Format("뿪%d\n뿪Ϣ\n[\n", stAlarmInputList.dwSize);

	for (int i = 0; (i < stAlarmInputList.dwSize) && (i < NETDEV_MAX_ALARM_IN_NUM); i++)
	{
		strTemp.Format("ţ%d, 뿪ƣ%s\n", i, stAlarmInputList.astAlarmInputInfo[i].szName);
		strOut += strTemp;
	}
	strOut += "]";

	AfxMessageBox(strOut);

	return;
}

void GetImageCfg()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_IMAGE_SETTING_S stImageSetting;
	memset(&stImageSetting, 0, sizeof(NETDEV_IMAGE_SETTING_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_IMAGECFG, (LPVOID)&stImageSetting, sizeof(NETDEV_IMAGE_SETTING_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡͼϢʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	strOut.Format("Աȶȣ%d\nȣ%d\nͶȣ%d\nȣ%d", stImageSetting.dwContrast, stImageSetting.dwBrightness, stImageSetting.dwSaturation,
		stImageSetting.dwSharpness);
	AfxMessageBox(strOut);

	return;
}

void GetNetworkCfg()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_NETWORKCFG_S stNetworkCfg;
	memset(&stNetworkCfg, 0, sizeof(NETDEV_NETWORKCFG_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_NETWORKCFG, (LPVOID)&stNetworkCfg, sizeof(NETDEV_NETWORKCFG_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡϢʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	strOut.Format("MTUֵ%d\nIPv4DHCP%d\nIPv4IPַ%s\nIPv4صַ%s\nIPv4룺%s", stNetworkCfg.dwMTU, stNetworkCfg.bIPv4DHCP,
		stNetworkCfg.szIpv4Address, stNetworkCfg.szIPv4GateWay, stNetworkCfg.szIPv4SubnetMask);
	AfxMessageBox(strOut);

	return;
}

void GetPrivacyMaskCfg()
{
	CString strTemp, strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_PRIVACY_MASK_CFG_S stPrivacyMaskCfg;
	memset(&stPrivacyMaskCfg, 0, sizeof(NETDEV_PRIVACY_MASK_CFG_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_PRIVACYMASKCFG, (LPVOID)&stPrivacyMaskCfg, sizeof(NETDEV_PRIVACY_MASK_CFG_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡ˽ڸϢʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	strOut.Format("%d\nڸ\n[\n", stPrivacyMaskCfg.dwSize);

	for (int i = 0; (i < stPrivacyMaskCfg.dwSize) && (i < NETDEV_MAX_PRIVACY_MASK_AREA_NUM); i++)
	{
		strTemp.Format("ţ%d, Ƿã%d, ϽX [0, 10000]%d, ϽY [0, 10000]%d, ½X [0, 10000]%d, ½Y [0, 10000]%d, %d\n", i,
			stPrivacyMaskCfg.astArea[i].bIsEanbled, stPrivacyMaskCfg.astArea[i].dwTopLeftX, stPrivacyMaskCfg.astArea[i].dwTopLeftY,
			stPrivacyMaskCfg.astArea[i].dwBottomRightX, stPrivacyMaskCfg.astArea[i].dwBottomRightY, stPrivacyMaskCfg.astArea[i].dwIndex);
		strOut += strTemp;
	}
	strOut += "]";
	AfxMessageBox(strOut);

	return;
}

void GetTamperAlarm()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_TAMPER_ALARM_INFO_S stTamperAlarmInfo;
	memset(&stTamperAlarmInfo, 0, sizeof(NETDEV_TAMPER_ALARM_INFO_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_TAMPERALARM, (LPVOID)&stTamperAlarmInfo, sizeof(NETDEV_TAMPER_ALARM_INFO_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡڵ澯Ϣʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	strOut.Format("ȣ%d", stTamperAlarmInfo.dwSensitivity);
	AfxMessageBox(strOut);

	return;
}

void GetMotionAlarm()
{
	CString strTemp, strTemp1, strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_MOTION_ALARM_INFO_S stMotionAlarmInfo;
	memset(&stMotionAlarmInfo, 0, sizeof(NETDEV_MOTION_ALARM_INFO_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_MOTIONALARM, (LPVOID)&stMotionAlarmInfo, sizeof(NETDEV_MOTION_ALARM_INFO_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡ˶澯Ϣʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	strOut.Format("ȣ%d\nС%d\nʱ䣺%d\nĻϢ\n[\n", stMotionAlarmInfo.dwSensitivity, stMotionAlarmInfo.dwObjectSize,
		stMotionAlarmInfo.dwHistory);

	for (int i = 0; i < NETDEV_SCREEN_INFO_ROW; i++)
	{
		strTemp += "[";
		for (int j = 0; j < NETDEV_SCREEN_INFO_COLUMN; j++)
		{
			strTemp1.Format("%d, ", stMotionAlarmInfo.awScreenInfo[i][j]);
			strTemp += strTemp1;
		}
		strTemp += "]\n";
		strOut += strTemp;
	}
	strOut += "]";

	AfxMessageBox(strOut);

	return;
}

void GetDisksInfo()
{
	CString strTemp, strTemp1, strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_DISK_INFO_LIST_S stDiskInfoList;
	memset(&stDiskInfoList, 0, sizeof(NETDEV_DISK_INFO_LIST_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_DISKSINFO, (LPVOID)&stDiskInfoList, sizeof(NETDEV_DISK_INFO_LIST_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡӲϢʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	strOut.Format("Ӳ̸%d\nӲϢ\n[\n", stDiskInfoList.dwSize);

	for (int i = 0; i < NETDEV_SCREEN_INFO_ROW; i++)
	{

		strOut += strTemp;
	}
	strOut += "]";

	AfxMessageBox(strOut);

	return;
}

void GetPtzStatus()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_PTZ_STATUS_S stPtzStatusInfo;
	memset(&stPtzStatusInfo, 0, sizeof(NETDEV_PTZ_STATUS_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_PTZSTATUS, (LPVOID)&stPtzStatusInfo, sizeof(NETDEV_FOCUS_INFO_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡ̨״̬Ϣʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	strOut.Format("ˮƽ:%f\nֱ:%f\nԾ۽:%f\n̨״̬ͣ%d\n۽״̬ͣ%d\n", 
		stPtzStatusInfo.fPanTiltX,
		stPtzStatusInfo.fPanTiltY,
		stPtzStatusInfo.fZoomX,
		stPtzStatusInfo.enPanTiltStatus,
		stPtzStatusInfo.enZoomStatus
		);

	AfxMessageBox(strOut);

	return;
}

void GetFocusInfo()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_FOCUS_INFO_S stFocusInfo;
	memset(&stFocusInfo, 0, sizeof(NETDEV_FOCUS_INFO_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_FOCUSINFO, (LPVOID)&stFocusInfo, sizeof(NETDEV_FOCUS_INFO_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡ۽Ϣʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	strOut.Format("۽ģʽ%d", stFocusInfo.enFocusMode);

	AfxMessageBox(strOut);

	return;
}

void GetIrcutFilterInfo()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_IRCUT_FILTER_INFO_S stIrcutFilterInfo;
	memset(&stIrcutFilterInfo, 0, sizeof(NETDEV_IRCUT_FILTER_INFO_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_IRCUTFILTERINFO, (LPVOID)&stIrcutFilterInfo, sizeof(NETDEV_IRCUT_FILTER_INFO_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡҹģʽϢʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	strOut.Format("ҹģʽ%d", stIrcutFilterInfo.enIrCutFilterMode);

	AfxMessageBox(strOut);

	return;
}

/* PTZ */
void GetDefoggingInfo()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_DEFOGGING_INFO_S stDefoggingInfo;
	memset(&stDefoggingInfo, 0, sizeof(NETDEV_DEFOGGING_INFO_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_DEFOGGINGINFO, (LPVOID)&stDefoggingInfo, sizeof(NETDEV_DEFOGGING_INFO_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡ͸ģʽϢʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	strOut.Format("ģʽ%d\nȼ%f", stDefoggingInfo.enDefoggingMode, stDefoggingInfo.fDefoggingLevel);

	AfxMessageBox(strOut);

	return;
}

void GetParkStatusInfo()
{
	/*CString strTemp, strTemp1, strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_PARKSTATUS_INFO_S stParkStatusInfo;
	memset(&stParkStatusInfo, 0, sizeof(NETDEV_PARKSTATUS_INFO_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_PARKSTATUSINFO, (LPVOID)&stParkStatusInfo, sizeof(NETDEV_PARKSTATUS_INFO_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡλ״̬Ϣʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	strOut.Format("λ%d\nλ״̬Ϣ\n[\n", stParkStatusInfo.ulParkNum);

	for (int i = 0; (i < stParkStatusInfo.ulParkNum) && (i < 6); i++)
	{
		strTemp += "[";
		strTemp1.Format("ţ%s, λ:%l, ʱ̣%s, λ״̬0޳1г2ʶ쳣%l, ƺ:Զʶ"-"ʾλ޳ʱԸֶΣ%s,"\
			"λָʾ״̬ 0Ϩ12˸3˸%l, λָʾɫ 1ɫ2ɫ3ɫ%l, 糵λ澯 0δ糵λ1糵λ:%l", stParkStatusInfo.astParkSatus[i].szCamID,
			stParkStatusInfo.astParkSatus[i].lParkID, stParkStatusInfo.astParkSatus[i].szSampleTime, stParkStatusInfo.astParkSatus[i].lParkingLotStatus,
			stParkStatusInfo.astParkSatus[i].szCarPlate, stParkStatusInfo.astParkSatus[i].lLEDStatus, stParkStatusInfo.astParkSatus[i].lLEDColor,
			stParkStatusInfo.astParkSatus[i].lCrossAlarm);
		strTemp += strTemp1;
		strTemp += "]\n";
		strOut += strTemp;
	}
	strOut += "]";

	AfxMessageBox(strOut);*/

	return;
}

void GetCarportCfg()
{

	/*CString strTemp, strTemp1, strTemp2, strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_CARPORT_CFG_S stCarportCfg;
	memset(&stCarportCfg, 0, sizeof(NETDEV_CARPORT_CFG_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_CARPORTCFG, (LPVOID)&stCarportCfg, sizeof(NETDEV_CARPORT_CFG_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡλϢʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	strOut.Format("%s\nλϢ\n[\n", stCarportCfg.szArea);

	for (int i = 0; i < 6; i++)
	{
		strTemp += "[";
		strTemp1.Format("ʹܱ־, 0ʾʹ,1ʾʹ,2ʾЧ%lu, λţ%lu, λ,Σ֧6㣺Ч:%lu, ",
			stCarportCfg.astParkAreaInfo[i].ulParkDetstaus, stCarportCfg.astParkAreaInfo[i].ulParkAreaID,
			stCarportCfg.astParkAreaInfo[i].stParkAreaLocation.ulNum);

		for (int j = 0; (j < stCarportCfg.astParkAreaInfo[i].stParkAreaLocation.ulNum) && (j < 12); j++)
		{
			strTemp2.Format("[ţ%d, xֵ[0,10000]%d, yֵ[0,10000]%d]", j, stCarportCfg.astParkAreaInfo[i].stParkAreaLocation.astPoint->dwLocateX,
				stCarportCfg.astParkAreaInfo[i].stParkAreaLocation.astPoint->dwLocateY);
			strTemp1 += strTemp2;
		}

		strTemp += strTemp1;
		strTemp += "]\n";
		strOut += strTemp;
	}
	strOut += "]";

	AfxMessageBox(strOut);*/

	return;
}

void GetOsdStyleCfg()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_OSDSTYLE_CFG_S stOsdStyleCfg;
	memset(&stOsdStyleCfg, 0, sizeof(NETDEV_OSDSTYLE_CFG_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_OSDSTYLECFG, (LPVOID)&stOsdStyleCfg, sizeof(NETDEV_OSDSTYLE_CFG_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡOSDʽʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	strOut.Format("ʽ%d\nС%d\n, ݲ֧ã%d\nɫ%d\n͸ȣ%d\nʱʽ%d\nڸʽ%d", stOsdStyleCfg.ulFontStyle,
		stOsdStyleCfg.ulFontSize, stOsdStyleCfg.ulFontType, stOsdStyleCfg.ulColor, stOsdStyleCfg.ulAlpha, stOsdStyleCfg.ulTimeFormat, stOsdStyleCfg.ulDateFormat);
	AfxMessageBox(strOut);

	return;
}

/* ʧ */
void GetInfoOsdCfg()
{
	CString strTemp, strTemp1, strTemp2, strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_INFOOSD_CFG_S stInfoOsdCfg;
	memset(&stInfoOsdCfg, 0, sizeof(NETDEV_INFOOSD_CFG_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_INFOOSDCFG, (LPVOID)&stInfoOsdCfg, sizeof(NETDEV_INFOOSD_CFG_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡOSDʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	strOut.Format("%d\nOSD ã\n[\n", stInfoOsdCfg.ulAreaNum);

	for (int i = 0; (i < stInfoOsdCfg.ulAreaNum) && (i < stInfoOsdCfg.ulAreaNum); i++)
	{
		strTemp.Format("ID%d, ʹܿأ%d, ݣ");
		for (int j = 0; j < 8; j++)
		{
			strTemp1.Format("[ͣ%lu, Զ OSD ݣ%s]", stInfoOsdCfg.astInfoOSD[i].astInfoParam[j].ulInfoType, stInfoOsdCfg.astInfoOSD[i].astInfoParam[j].szValue);
			strTemp += strTemp1;
		}
		strOut += strTemp;

		strTemp2.Format("Ͻ꣺,ֱȣ%d, ,ֱȣ%d, ½꣺,ֱȣ%d, ,ֱȣ%d", stInfoOsdCfg.astInfoOSD[i].stArea.stTopLeft.dwPointX,
			stInfoOsdCfg.astInfoOSD[i].stArea.stTopLeft.dwPointY, stInfoOsdCfg.astInfoOSD[i].stArea.stBotRight.dwPointX, stInfoOsdCfg.astInfoOSD[i].stArea.stBotRight.dwPointY);
		strOut += strTemp2;
	}
	strOut += "]";

	AfxMessageBox(strOut);

	return;
}

void GetAccpLicInfo()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_ACCPLIC_INFO_S stAccpLicInfo;
	memset(&stAccpLicInfo, 0, sizeof(NETDEV_ACCPLIC_INFO_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_ACCPLICINFO, (LPVOID)&stAccpLicInfo, sizeof(NETDEV_ACCPLIC_INFO_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡʲʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	strOut.Format("Ѻ 10رգ%d\nMacַУ 10رգ%d\n", stAccpLicInfo.bFriendlyPassword, stAccpLicInfo.bMacBind);
	AfxMessageBox(strOut);

	return;
}

void GetExposureCfg()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_EXPOSURE_INFO_S stExposureInfo;
	memset(&stExposureInfo, 0, sizeof(NETDEV_EXPOSURE_INFO_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_EXPOSURE_CFG_S, (LPVOID)&stExposureInfo, sizeof(NETDEV_EXPOSURE_INFO_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡͼع̬ʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	strOut.Format("عģʽ%d\nعⲹ%d\nȦֵ, λ: fֵ*100%d\nֵ%d\n, λ: db%d\nԶع\n[\n"\
		"Ȧ, λ: fֵ*100%d\nСȦ, λ: fֵ*100%d\nţ%d\nţ%d\n, λ: db%d\n"\
		"С, λ: db%d\n]\nŲ[ʹ%d, ţ%d]\n̬\n[\n̬ģʽ%d\n"\
		"عʣݲ֧֣%d\nulOnSense%d\nulOffSense%d\nbAntiFlicker%d\n]\n\n[\nģʽ%d\n"\
		"ٷֱȣ(%d, %d),(%d, %d)\nοȣ%d\nʱ䣺%d\n]\nҹ\n[\nҹģʽ%d\nлȣ%d\n]", 
		stExposureInfo.ulMode, stExposureInfo.lExpCompensate, stExposureInfo.ulIris, stExposureInfo.ulShutter, stExposureInfo.ulGain,
		stExposureInfo.stCustomExposure.ulMaxIris, stExposureInfo.stCustomExposure.ulMinIris, stExposureInfo.stCustomExposure.ulSlowShutter,
		stExposureInfo.stCustomExposure.ulFastShutter, stExposureInfo.stCustomExposure.ulMaxGain, stExposureInfo.stCustomExposure.ulMinGain,
		stExposureInfo.stSlowShutter.bEnable, stExposureInfo.stSlowShutter.ulMaxSlowShutter, stExposureInfo.stWDR.ulMode, stExposureInfo.stWDR.ulExpRatio,
		stExposureInfo.stWDR.ulOnSense, stExposureInfo.stWDR.ulOffSense, stExposureInfo.stWDR.bAntiFlicker, stExposureInfo.stMetering.ulMode,
		stExposureInfo.stMetering.stArea.stTopLeft.dwPointX, stExposureInfo.stMetering.stArea.stTopLeft.dwPointY, stExposureInfo.stMetering.stArea.stBotRight.dwPointX,
		stExposureInfo.stMetering.stArea.stBotRight.dwPointY, stExposureInfo.stMetering.ulRefBrightness, stExposureInfo.stMetering.ulHoldTime,
		stExposureInfo.stDayNight.ulMode, stExposureInfo.stDayNight.ulSensitivity);
	AfxMessageBox(strOut);

	return;
}

void GetTelentConfig()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_TELNET_INFO_S stTelnetInfo;
	memset(&stTelnetInfo, 0, sizeof(NETDEV_TELNET_INFO_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_TELENTCONFIG, (LPVOID)&stTelnetInfo, sizeof(NETDEV_TELNET_INFO_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡͼ̬ʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	strOut.Format("(Ƿ),0 ر,1 %d", stTelnetInfo.bIsEnable);
	AfxMessageBox(strOut);

	return;
}

void GetIrcut()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_ICRCUT_INFO_S stIrcutInfo;
	memset(&stIrcutInfo, 0, sizeof(NETDEV_ICRCUT_INFO_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_IRCUT, (LPVOID)&stIrcutInfo, sizeof(NETDEV_ICRCUT_INFO_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡƬƬлʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	strOut.Format("(Ƿ),0 ر,1 %d", stIrcutInfo.bIsEnable);
	AfxMessageBox(strOut);

	return;
}

void GetImgEnhance()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_IMAGENHANCE_S stImgEnhance;
	memset(&stImgEnhance, 0, sizeof(NETDEV_IMAGENHANCE_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_IMGENHANCE, (LPVOID)&stImgEnhance, sizeof(NETDEV_IMAGENHANCE_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡͼʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	strOut.Format("ȣ%d\nͶȣ%d\nԱȶȣ%d\nȣ%d\nͼ%d\n2D룺%d\n3D룺%d", stImgEnhance.ulBrightness, stImgEnhance.ulContrast,
		stImgEnhance.ulSaturation, stImgEnhance.ulSharpness, stImgEnhance.ulImageRotation, stImgEnhance.ul2DNoiseReduce, stImgEnhance.ul3DNoiseReduce);
	AfxMessageBox(strOut);

	return;
}

/* ʧ */
void GetImgClarData()
{
	CString strTemp, strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_IMGCLARDATA_S stImgClarData;
	memset(&stImgClarData, 0, sizeof(NETDEV_IMGCLARDATA_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_IMGCLARDATA, (LPVOID)&stImgClarData, sizeof(NETDEV_IMGCLARDATA_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡͼʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	strOut.Format("ͼͨţ%d\nͼݣ\n[", stImgClarData.ulImgChannel);
	for (int i = 0; i < 25; i++)
	{
		strTemp.Format("%d, ", stImgClarData.aulImgClarData[i]);
		strOut += strTemp;
	}
	strOut += "]";

	AfxMessageBox(strOut);

	return;
}

void GetInfoRelease()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_INFORELEASE_CFG_S stInfoReleaseCfg;
	memset(&stInfoReleaseCfg, 0, sizeof(NETDEV_INFORELEASE_CFG_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_INFORELEASE, (LPVOID)&stInfoReleaseCfg, sizeof(NETDEV_INFORELEASE_CFG_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡãвʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	strOut.Format("Чģʽ 0ģʽ 1߿ģʽ 2ģʽ%d\nʶ 0ȫ 1 2ǺУ%d\n"\
		"δʶ 0 1У%d\nuOutputSwitchID%d", stInfoReleaseCfg.uCtrlMode, stInfoReleaseCfg.uReleaseTactics,
		stInfoReleaseCfg.uUnidentifiedRelease, stInfoReleaseCfg.uOutputSwitchID);
	AfxMessageBox(strOut);

	return;
}

void GetInfoWList()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_INFOWLIST_CFG_S stInfoWListCfg;
	memset(&stInfoWListCfg, 0, sizeof(NETDEV_INFOWLIST_CFG_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_INFOWLIST, (LPVOID)&stInfoWListCfg, sizeof(NETDEV_INFOWLIST_CFG_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡãʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	strOut.Format(" 0ѡ 1ѡ%d\nƥģʽ 0ģƥ 1׼ƥ䣺%d\nԺ 0ѡ 1ѡ%d\nַƥ 0λ0 1λ1 2λ2%d",
		stInfoWListCfg.uEnabled, stInfoWListCfg.enMatchRule.uMatchMode, stInfoWListCfg.enMatchRule.uChineseIgnored, stInfoWListCfg.enMatchRule.uLetterFuzzyMatchLevel);
	AfxMessageBox(strOut);

	return;
}

void GetInfoBList()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_INFOBLIST_CFG_S stInfoBListCfg;
	memset(&stInfoBListCfg, 0, sizeof(NETDEV_INFOBLIST_CFG_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_INFOBLIST, (LPVOID)&stInfoBListCfg, sizeof(NETDEV_INFOBLIST_CFG_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡãʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	strOut.Format(" 0ѡ 1ѡ%d\n 0 1ǣ%d\nƥģʽ 0ģƥ 1׼ƥ䣺%d\nԺ 0ѡ 1ѡ%d\n"\
		"ַƥ 0λ0 1λ1 2λ2%d\n", stInfoBListCfg.uEnabled, stInfoBListCfg.LinkSwitchID, stInfoBListCfg.enMatchRule.uMatchMode,
		stInfoBListCfg.enMatchRule.uChineseIgnored, stInfoBListCfg.enMatchRule.uLetterFuzzyMatchLevel);
	AfxMessageBox(strOut);

	return;
}

void GetCarPortLedCtrl()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_CARPORT_CONTROLLED_S stCarPortLedCtrl;
	memset(&stCarPortLedCtrl, 0, sizeof(NETDEV_CARPORT_CONTROLLED_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_CARPORT_LED_CTRL, (LPVOID)&stCarPortLedCtrl, sizeof(NETDEV_CARPORT_CONTROLLED_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡλָʾƿʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	strOut.Format("0 - ܿƣ1 - SDKƣ%d\nǰʵʳλã\n[\nָʾ״̬0-Ϩ1-2-˸%d\nָʾɫ, 1-ɫ2-ɫ3-ɫ%d\n]",
		stCarPortLedCtrl.ulControlMode, stCarPortLedCtrl.stCurrLEDCfg.ulLEDStatus, stCarPortLedCtrl.stCurrLEDCfg.ulLEDColour);
	AfxMessageBox(strOut);

	return;
}

void GetInstallGuideCfg()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_INSTALL_GUIDE_CFG_S stInstallGuideCfg;
	memset(&stInstallGuideCfg, 0, sizeof(NETDEV_INSTALL_GUIDE_CFG_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_INSTALL_GUIDE_CFG, (LPVOID)&stInstallGuideCfg, sizeof(NETDEV_INSTALL_GUIDE_CFG_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡڰװʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	strOut.Format("ģʽ,0:Ȧ, 1:Ƶ⣺%d\nץĵ룺%d\nĬʡݣ%d", stInstallGuideCfg.ulDetectMode, stInstallGuideCfg.ulCapDistance,
		stInstallGuideCfg.ulDefaultProvince);
	AfxMessageBox(strOut);

	return;
}

void CCParkDevParameterDlg::OnBnClickedParkGetcfgButton()
{
	// TODO: ڴӿؼ֪ͨ
	UpdateData(TRUE);
	int iCbIndex = m_ComboxGetConfig.GetCurSel();

	switch (iCbIndex)
	{
	case 0:
		{
			GetDeviceConfig();
			break;
		}
	case 1:
		{
			GetNTPConfig();
			break;
		}
	case 2:
		{
			GetStreamConfig();
			break;
		}
	case 3:
		{
			GetStreamConfigEx();
			break;
		}
	case 4:
		{
			GetVideoModeConfig();
			break;
		}
	/*case 5:
		{
			GetOSDConfig();
			break;
		}*/
	case 5:
		{
			GetOSDContentConfig();
			break;
		}
	case 6:
		{
			GetOSDContentStyleCfg();
			break;
		}
	case 7:
		{
			GetAlarmOutputCfg();
			break;
		}
	case 8:
		{
			GetAlarmInputCfg();
			break;
		}
	case 9:
		{
			GetImageCfg();
			break;
		}
	case 10:
		{
			GetNetworkCfg();
			break;
		}
	case 11:
		{
			GetPrivacyMaskCfg();
			break;
		}
	
	case 12:
		{
			GetFocusInfo();
			break;
		}
	case 13:
		{
			GetIrcutFilterInfo();
			break;
		}
	case 14:
		{
			GetDefoggingInfo();
			break;
		}
	/*case 16:
		{
			GetParkStatusInfo();
			break;
		}
	case 17:
		{
			GetCarportCfg();
			break;
		}*/
	case 15:
		{
			GetOsdStyleCfg();
			break;
		}
	/*case 16:
		{
			GetInfoOsdCfg();
			break;
		}*/
	/*case 18:
		{
			GetAccpLicInfo();
			break;
		}*/
	case 16:
		{
			GetExposureCfg();
			break;
		}
	case 17:
		{
			GetTelentConfig();
			break;
		}
	case 18:
		{
			GetIrcut();
			break;
		}
	case 19:
		{
			GetImgEnhance();
			break;
		}
	/*case 20:
		{
			GetImgClarData();
			break;
		}*/
	case 20:
		{
			GetInfoRelease();
			break;
		}
	case 21:
		{
			GetInfoWList();
			break;
		}
	case 22:
		{
			GetInfoBList();
			break;
		}
	case 23:
		{
			GetCarPortLedCtrl();
			break;
		}
	case 24:
		{
			GetInstallGuideCfg();
			break;
		}
	default:
		break;
	}

	return;
}


/* ʧ */
void SetNTPConfig()
{
	CString strError;
	INT32 dwBytesReturned = 0;
	NETDEV_SYSTEM_NTP_INFO_S stSystemNtpInfo;
	memset(&stSystemNtpInfo, 0, sizeof(NETDEV_SYSTEM_NTP_INFO_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_NTPCFG, &stSystemNtpInfo, sizeof(NETDEV_SYSTEM_NTP_INFO_S), &dwBytesReturned);
	if (TRUE != bRet)
	{
		strError.Format("ȡNTPʧ, :%d", bRet);
		AfxMessageBox(strError);
		return;
	}

	CString strText;
	strText.Format("GetDecdonfig succeed. ");
	AfxMessageBox(strText);

	bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_NTPCFG, &stSystemNtpInfo, sizeof(NETDEV_SYSTEM_NTP_INFO_S));
	if (TRUE != bRet)
	{
		strError.Format("NTPʧ, :%d", NETDEV_GetLastError());
	}
	else
	{
		strError.Format("NTPɹ.");
	}
	AfxMessageBox(strError);

	return;
}

void SetStreamCfg()
{
	CString strError;
	INT32 dwBytesReturned = 0;
	NETDEV_VIDEO_STREAM_INFO_S stVideoStreamInfo;
	memset(&stVideoStreamInfo, 0, sizeof(NETDEV_VIDEO_STREAM_INFO_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_STREAMCFG, &stVideoStreamInfo, sizeof(NETDEV_VIDEO_STREAM_INFO_S), &dwBytesReturned);
	if (TRUE != bRet)
	{
		strError.Format("ȡƵʧ, :%d", NETDEV_GetLastError());
		AfxMessageBox(strError);
		return;
	}

	CString strText;
	strText.Format("GetDecdonfig succeed. ");
	AfxMessageBox(strText);

	bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_STREAMCFG, &stVideoStreamInfo, sizeof(NETDEV_VIDEO_STREAM_INFO_S));
	if (TRUE != bRet)
	{
		strError.Format("Ƶʧ, :%d", NETDEV_GetLastError());
	}
	else
	{
		strError.Format("Ƶɹ.");
	}
	AfxMessageBox(strError);

	return;
}

void SetStreamConfigEx()
{
	CString strError;
	INT32 dwBytesReturned = 0;
	NETDEV_VIDEO_STREAM_INFO_LIST_S stVideoStreamInfoList;
	memset(&stVideoStreamInfoList, 0, sizeof(NETDEV_VIDEO_STREAM_INFO_LIST_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_STREAMCFG_EX, &stVideoStreamInfoList, sizeof(NETDEV_VIDEO_STREAM_INFO_LIST_S), &dwBytesReturned);
	if (TRUE != bRet)
	{
		strError.Format("ȡƵ(չʹ)ʧ, :%d", bRet);
		AfxMessageBox(strError);
		return;
	}

	CString strText;
	strText.Format("GetDecdonfig succeed. ");
	AfxMessageBox(strText);

	bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_STREAMCFG_EX, &stVideoStreamInfoList, sizeof(NETDEV_VIDEO_STREAM_INFO_LIST_S));
	if (TRUE != bRet)
	{
		strError.Format("Ƶ(չʹ)ʧ, :%d", NETDEV_GetLastError());
	}
	else
	{
		strError.Format("Ƶ(չʹ)ɹ.");
	}
	AfxMessageBox(strError);

	return;
}

void SetVideoModeConfig()
{
	CString strError;
	INT32 dwBytesReturned = 0;
	NETDEV_VIDEO_MODE_INFO_S stVideoModeInfo;
	memset(&stVideoModeInfo, 0, sizeof(NETDEV_VIDEO_MODE_INFO_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_VIDEOMODECFG, &stVideoModeInfo, sizeof(NETDEV_VIDEO_MODE_INFO_S), &dwBytesReturned);
	if (TRUE != bRet)
	{
		strError.Format("ȡͼɼʽʧ, :%d", bRet);
		AfxMessageBox(strError);
		return;
	}

	CString strText;
	strText.Format("GetDecdonfig succeed. ");
	AfxMessageBox(strText);

	bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_VIDEOMODECFG, &stVideoModeInfo, sizeof(NETDEV_VIDEO_MODE_INFO_S));
	if (TRUE != bRet)
	{
		strError.Format("ͼɼʽʧ, :%d", NETDEV_GetLastError());
	}
	else
	{
		strError.Format("ͼɼʽɹ.");
	}
	AfxMessageBox(strError);

	return;
}

void SetOSDConfig()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_VIDEO_OSD_CFG_S stVideoOsdConfig;
	memset(&stVideoOsdConfig, 0, sizeof(NETDEV_VIDEO_OSD_CFG_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_OSDCFG, (LPVOID)&stVideoOsdConfig, sizeof(NETDEV_VIDEO_OSD_CFG_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡOSDϢʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	CString strText;
	strText.Format("GetDecdonfig succeed. ");
	AfxMessageBox(strText);

	bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_OSDCFG, &stVideoOsdConfig, sizeof(NETDEV_VIDEO_OSD_CFG_S));
	if (TRUE != bRet)
	{
		strOut.Format("OSDϢʧ, :%d", NETDEV_GetLastError());
	}
	else
	{
		strOut.Format("OSDϢɹ.");
	}
	AfxMessageBox(strOut);

	return;
}

void SetOSDContentConfig()
{
	CString strTemp, strTemp1, strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_OSD_CONTENT_S stOsdContent;
	memset(&stOsdContent, 0, sizeof(NETDEV_OSD_CONTENT_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_OSD_CONTENT_CFG, (LPVOID)&stOsdContent, sizeof(NETDEV_OSD_CONTENT_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡOSDϢ(չʹ)ʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	CString strText;
	strText.Format("GetDecdonfig succeed. ");
	AfxMessageBox(strText);

	bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_OSD_CONTENT_CFG, &stOsdContent, sizeof(NETDEV_OSD_CONTENT_S));
	if (TRUE != bRet)
	{
		strOut.Format("OSDϢ(չʹ)ʧ, :%d", NETDEV_GetLastError());
	}
	else
	{
		strOut.Format("OSDϢ(չʹ)ɹ.");
	}
	AfxMessageBox(strOut);

	return;
}

void SetOSDContentStyleCfg()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_OSD_CONTENT_STYLE_S stOsdContentStyle;
	memset(&stOsdContentStyle, 0, sizeof(NETDEV_OSD_CONTENT_STYLE_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_OSD_CONTENT_STYLE_CFG, (LPVOID)&stOsdContentStyle, sizeof(NETDEV_OSD_CONTENT_STYLE_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡOSDʽʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	CString strText;
	strText.Format("GetDecdonfig succeed. ");
	AfxMessageBox(strText);

	bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_OSD_CONTENT_STYLE_CFG, &stOsdContentStyle, sizeof(NETDEV_OSD_CONTENT_STYLE_S));
	if (TRUE != bRet)
	{
		strOut.Format("OSDʽʧ, :%d", NETDEV_GetLastError());
	}
	else
	{
		strOut.Format("OSDʽɹ.");
	}
	AfxMessageBox(strOut);

	return;
}

void SetAlarmOutputCfg()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_ALARM_OUTPUT_LIST_S stAlarmOutputList;
	memset(&stAlarmOutputList, 0, sizeof(NETDEV_ALARM_OUTPUT_LIST_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_ALARM_OUTPUTCFG, (LPVOID)&stAlarmOutputList, sizeof(NETDEV_ALARM_OUTPUT_LIST_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡϢʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	CString strText;
	strText.Format("GetDecdonfig succeed. ");
	AfxMessageBox(strText);

	bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_ALARM_OUTPUTCFG, &stAlarmOutputList, sizeof(NETDEV_ALARM_OUTPUT_LIST_S));
	if (TRUE != bRet)
	{
		strOut.Format("ÿϢʧ, :%d", NETDEV_GetLastError());
	}
	else
	{
		strOut.Format("ÿϢɹ.");
	}
	AfxMessageBox(strOut);

	return;
}

void TriggerAlarmOutput()
{

	CString strText;
	strText.Format("GetDecdonfig succeed. ");
	AfxMessageBox(strText);

	CString strOut;
	NETDEV_TRIGGER_ALARM_OUTPUT_S stTriggerAlarmOutput;
	memset(&stTriggerAlarmOutput, 0, sizeof(NETDEV_TRIGGER_ALARM_OUTPUT_S));
	strcpy(stTriggerAlarmOutput.szName,"Trgger");
	stTriggerAlarmOutput.enOutputState =NETDEV_BOOLEAN_STATUS_ACTIVE;

	BOOL bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_TRIGGER_ALARM_OUTPUT, &stTriggerAlarmOutput, sizeof(NETDEV_TRIGGER_ALARM_OUTPUT_S));
	if (TRUE != bRet)
	{
		strOut.Format("ÿϢʧ, :%d", NETDEV_GetLastError());
	}
	else
	{
		strOut.Format("ÿϢɹ.");
	}
	AfxMessageBox(strOut);

	return;
}

void SetImageCfg()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_IMAGE_SETTING_S stImageSetting;
	memset(&stImageSetting, 0, sizeof(NETDEV_IMAGE_SETTING_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_IMAGECFG, (LPVOID)&stImageSetting, sizeof(NETDEV_IMAGE_SETTING_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡͼϢʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	CString strText;
	strText.Format("GetDecdonfig succeed. ");
	AfxMessageBox(strText);

	bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_IMAGECFG, &stImageSetting, sizeof(NETDEV_IMAGE_SETTING_S));
	if (TRUE != bRet)
	{
		strOut.Format("ͼϢʧ, :%d", NETDEV_GetLastError());
	}
	else
	{
		strOut.Format("ͼϢɹ.");
	}
	AfxMessageBox(strOut);

	return;
}

void SetNetworkCfg()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_NETWORKCFG_S stNetworkCfg;
	memset(&stNetworkCfg, 0, sizeof(NETDEV_NETWORKCFG_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_NETWORKCFG, (LPVOID)&stNetworkCfg, sizeof(NETDEV_NETWORKCFG_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡϢʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	CString strText;
	strText.Format("GetDecdonfig succeed. ");
	AfxMessageBox(strText);

	bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_NETWORKCFG, &stNetworkCfg, sizeof(NETDEV_NETWORKCFG_S));
	if (TRUE != bRet)
	{
		strOut.Format("Ϣʧ, :%d", NETDEV_GetLastError());
	}
	else
	{
		strOut.Format("Ϣɹ.");
	}
	AfxMessageBox(strOut);

	return;
}

void SetPrivacyMaskCfg()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_PRIVACY_MASK_CFG_S stPrivacyMaskCfg;
	memset(&stPrivacyMaskCfg, 0, sizeof(NETDEV_PRIVACY_MASK_CFG_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_PRIVACYMASKCFG, (LPVOID)&stPrivacyMaskCfg, sizeof(NETDEV_PRIVACY_MASK_CFG_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡ˽ڸϢʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	CString strText;
	strText.Format("GetDecdonfig succeed. ");
	AfxMessageBox(strText);

	bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_PRIVACYMASKCFG, &stPrivacyMaskCfg, sizeof(NETDEV_PRIVACY_MASK_CFG_S));
	if (TRUE != bRet)
	{
		strOut.Format("˽ڸϢʧ, :%d", NETDEV_GetLastError());
	}
	else
	{
		strOut.Format("˽ڸϢɹ.");
	}
	AfxMessageBox(strOut);

	return;
}

void SetTamperAlarm()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_TAMPER_ALARM_INFO_S stTamperAlarmInfo;
	memset(&stTamperAlarmInfo, 0, sizeof(NETDEV_TAMPER_ALARM_INFO_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_TAMPERALARM, (LPVOID)&stTamperAlarmInfo, sizeof(NETDEV_TAMPER_ALARM_INFO_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡڵ澯Ϣʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	CString strText;
	strText.Format("GetDecdonfig succeed. ");
	AfxMessageBox(strText);

	bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_TAMPERALARM, &stTamperAlarmInfo, sizeof(NETDEV_TAMPER_ALARM_INFO_S));
	if (TRUE != bRet)
	{
		strOut.Format("ڵ澯Ϣʧ, :%d", NETDEV_GetLastError());
	}
	else
	{
		strOut.Format("ڵ澯Ϣɹ.");
	}
	AfxMessageBox(strOut);

	return;
}

void SetMotionAlarm()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_MOTION_ALARM_INFO_S stMotionAlarmInfo;
	memset(&stMotionAlarmInfo, 0, sizeof(NETDEV_MOTION_ALARM_INFO_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_MOTIONALARM, (LPVOID)&stMotionAlarmInfo, sizeof(NETDEV_MOTION_ALARM_INFO_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡ˶澯Ϣʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	CString strText;
	strText.Format("GetDecdonfig succeed. ");
	AfxMessageBox(strText);

	bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_MOTIONALARM, &stMotionAlarmInfo, sizeof(NETDEV_MOTION_ALARM_INFO_S));
	if (TRUE != bRet)
	{
		strOut.Format("˶澯Ϣʧ, :%d", NETDEV_GetLastError());
	}
	else
	{
		strOut.Format("˶澯Ϣɹ.");
	}
	AfxMessageBox(strOut);

	return;
}

void SetFocusInfo()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_FOCUS_INFO_S stFocusInfo;
	memset(&stFocusInfo, 0, sizeof(NETDEV_FOCUS_INFO_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_FOCUSINFO, (LPVOID)&stFocusInfo, sizeof(NETDEV_FOCUS_INFO_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡ۽Ϣʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	CString strText;
	strText.Format("GetDecdonfig succeed. ");
	AfxMessageBox(strText);

	bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_FOCUSINFO, &stFocusInfo, sizeof(NETDEV_FOCUS_INFO_S));
	if (TRUE != bRet)
	{
		strOut.Format("þ۽Ϣʧ, :%d", NETDEV_GetLastError());
	}
	else
	{
		strOut.Format("þ۽Ϣɹ.");
	}
	AfxMessageBox(strOut);

	return;
}

void SetIrcutFilterInfo()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_IRCUT_FILTER_INFO_S stIrcutFilterInfo;
	memset(&stIrcutFilterInfo, 0, sizeof(NETDEV_IRCUT_FILTER_INFO_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_IRCUTFILTERINFO, (LPVOID)&stIrcutFilterInfo, sizeof(NETDEV_IRCUT_FILTER_INFO_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡҹģʽϢʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	CString strText;
	strText.Format("GetDecdonfig succeed. ");
	AfxMessageBox(strText);

	bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_IRCUTFILTERINFO, &stIrcutFilterInfo, sizeof(NETDEV_IRCUT_FILTER_INFO_S));
	if (TRUE != bRet)
	{
		strOut.Format("ҹģʽϢʧ, :%d", NETDEV_GetLastError());
	}
	else
	{
		strOut.Format("ҹģʽϢɹ.");
	}
	AfxMessageBox(strOut);

	return;
}

/* PTZ */
void SetDefoggingInfo()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_DEFOGGING_INFO_S stDefoggingInfo;
	memset(&stDefoggingInfo, 0, sizeof(NETDEV_DEFOGGING_INFO_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_DEFOGGINGINFO, (LPVOID)&stDefoggingInfo, sizeof(NETDEV_DEFOGGING_INFO_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡ͸ģʽϢʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	CString strText;
	strText.Format("GetDecdonfig succeed. ");
	AfxMessageBox(strText);

	bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_DEFOGGINGINFO, &stDefoggingInfo, sizeof(NETDEV_DEFOGGING_INFO_S));
	if (TRUE != bRet)
	{
		strOut.Format("͸ģʽϢʧ, :%d", NETDEV_GetLastError());
	}
	else
	{
		strOut.Format("͸ģʽϢɹ.");
	}
	AfxMessageBox(strOut);

	return;
}

void SetCarportCfg()
{
	CString strTemp, strTemp1, strTemp2, strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_CARPORT_CFG_S stCarportCfg;
	memset(&stCarportCfg, 0, sizeof(NETDEV_CARPORT_CFG_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_CARPORTCFG, (LPVOID)&stCarportCfg, sizeof(NETDEV_CARPORT_CFG_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡλϢʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	CString strText;
	strText.Format("GetDecdonfig succeed. ");
	AfxMessageBox(strText);

	bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_CARPORTCFG, &stCarportCfg, sizeof(NETDEV_CARPORT_CFG_S));
	if (TRUE != bRet)
	{
		strOut.Format("óλϢʧ, :%d", NETDEV_GetLastError());
	}
	else
	{
		strOut.Format("óλϢɹ.");
	}
	AfxMessageBox(strOut);

	return;
}

void SetOsdStyleCfg()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_OSDSTYLE_CFG_S stOsdStyleCfg;
	memset(&stOsdStyleCfg, 0, sizeof(NETDEV_OSDSTYLE_CFG_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_OSDSTYLECFG, (LPVOID)&stOsdStyleCfg, sizeof(NETDEV_OSDSTYLE_CFG_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡOSDʽʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	CString strText;
	strText.Format("GetDecdonfig succeed. ");
	AfxMessageBox(strText);

	bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_OSDSTYLECFG, &stOsdStyleCfg, sizeof(NETDEV_OSDSTYLE_CFG_S));
	if (TRUE != bRet)
	{
		strOut.Format("õOSDʽʧ, :%d", NETDEV_GetLastError());
	}
	else
	{
		strOut.Format("õOSDʽóɹ.");
	}
	AfxMessageBox(strOut);

	return;
}

/* ʧ */
void SetInfoOsdCfg()
{
	CString strTemp, strTemp1, strTemp2, strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_INFOOSD_CFG_S stInfoOsdCfg;
	memset(&stInfoOsdCfg, 0, sizeof(NETDEV_INFOOSD_CFG_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_INFOOSDCFG, (LPVOID)&stInfoOsdCfg, sizeof(NETDEV_INFOOSD_CFG_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡOSDʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	CString strText;
	strText.Format("GetDecdonfig succeed. ");
	AfxMessageBox(strText);

	bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_INFOOSDCFG, &stInfoOsdCfg, sizeof(NETDEV_INFOOSD_CFG_S));
	if (TRUE != bRet)
	{
		strOut.Format("õOSDʧ, :%d", NETDEV_GetLastError());
	}
	else
	{
		strOut.Format("õOSDóɹ.");
	}
	AfxMessageBox(strOut);

	return;
}

void SetAccpLicInfo()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_ACCPLIC_INFO_S stAccpLicInfo;
	memset(&stAccpLicInfo, 0, sizeof(NETDEV_ACCPLIC_INFO_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_ACCPLICINFO, (LPVOID)&stAccpLicInfo, sizeof(NETDEV_ACCPLIC_INFO_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡʲʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	CString strText;
	strText.Format("GetDecdonfig succeed. ");
	AfxMessageBox(strText);

	bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_ACCPLICINFO, &stAccpLicInfo, sizeof(NETDEV_ACCPLIC_INFO_S));
	if (TRUE != bRet)
	{
		strOut.Format("÷ʲʧ, :%d", NETDEV_GetLastError());
	}
	else
	{
		strOut.Format("÷ʲԳɹ.");
	}
	AfxMessageBox(strOut);


	return;
}

void SetExposureCfg()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_EXPOSURE_INFO_S stExposureInfo;
	memset(&stExposureInfo, 0, sizeof(NETDEV_EXPOSURE_INFO_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_EXPOSURE_CFG_S, (LPVOID)&stExposureInfo, sizeof(NETDEV_EXPOSURE_INFO_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡͼع̬ʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	CString strText;
	strText.Format("GetDecdonfig succeed. ");
	AfxMessageBox(strText);

	bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_EXPOSURE_CFG_S, &stExposureInfo, sizeof(NETDEV_EXPOSURE_INFO_S));
	if (TRUE != bRet)
	{
		strOut.Format("ͼع̬ʧ, :%d", NETDEV_GetLastError());
	}
	else
	{
		strOut.Format("ͼع̬Ƴɹ.");
	}
	AfxMessageBox(strOut);

	return;
}

void SetTelentConfig()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_TELNET_INFO_S stTelnetInfo;
	memset(&stTelnetInfo, 0, sizeof(NETDEV_TELNET_INFO_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_TELENTCONFIG, (LPVOID)&stTelnetInfo, sizeof(NETDEV_TELNET_INFO_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡͼ̬ʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	CString strText;
	strText.Format("GetDecdonfig succeed. ");
	AfxMessageBox(strText);

	bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_TELENTCONFIG, &stTelnetInfo, sizeof(NETDEV_TELNET_INFO_S));
	if (TRUE != bRet)
	{
		strOut.Format("ͼ̬ʧ, :%d", NETDEV_GetLastError());
	}
	else
	{
		strOut.Format("ͼ̬ɹ.");
	}
	AfxMessageBox(strOut);

	return;
}

void SetIrcut()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_ICRCUT_INFO_S stIrcutInfo;
	memset(&stIrcutInfo, 0, sizeof(NETDEV_ICRCUT_INFO_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_IRCUT, (LPVOID)&stIrcutInfo, sizeof(NETDEV_ICRCUT_INFO_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡƬƬлʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	CString strText;
	strText.Format("GetDecdonfig succeed. ");
	AfxMessageBox(strText);

	bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_IRCUT, &stIrcutInfo, sizeof(NETDEV_ICRCUT_INFO_S));
	if (TRUE != bRet)
	{
		strOut.Format("ðƬƬлʧ, :%d", NETDEV_GetLastError());
	}
	else
	{
		strOut.Format("ðƬƬлɹ.");
	}
	AfxMessageBox(strOut);


	return;
}

void SetImgEnhance()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_IMAGENHANCE_S stImgEnhance;
	memset(&stImgEnhance, 0, sizeof(NETDEV_IMAGENHANCE_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_IMGENHANCE, (LPVOID)&stImgEnhance, sizeof(NETDEV_IMAGENHANCE_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡͼʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	CString strText;
	strText.Format("GetDecdonfig succeed. ");
	AfxMessageBox(strText);

	bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_IMGENHANCE, &stImgEnhance, sizeof(NETDEV_IMAGENHANCE_S));
	if (TRUE != bRet)
	{
		strOut.Format("ͼʧ, :%d", NETDEV_GetLastError());
	}
	else
	{
		strOut.Format("ͼɹ.");
	}
	AfxMessageBox(strOut);

	return;
}

/* ʧ */
void SetImgClarData()
{
	CString strTemp, strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_IMGCLARDATA_S stImgClarData;
	memset(&stImgClarData, 0, sizeof(NETDEV_IMGCLARDATA_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_IMGCLARDATA, (LPVOID)&stImgClarData, sizeof(NETDEV_IMGCLARDATA_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡͼʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	CString strText;
	strText.Format("GetDecdonfig succeed. ");
	AfxMessageBox(strText);

	bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_IMGCLARDATA, &stImgClarData, sizeof(NETDEV_IMGCLARDATA_S));
	if (TRUE != bRet)
	{
		strOut.Format("ͼʧ, :%d", NETDEV_GetLastError());
	}
	else
	{
		strOut.Format("ͼȳɹ.");
	}
	AfxMessageBox(strOut);

	return;
}

void SetImgSwitchChannel()
{
	CString strText;
	strText.Format("GetDecdonfig succeed. ");
	AfxMessageBox(strText);

	CString strOut;
	NETDEV_IMGSWITCHANNEL_S stImgSwitchChannel;
	memset(&stImgSwitchChannel, 0, sizeof(NETDEV_IMGSWITCHANNEL_S));
	stImgSwitchChannel.ulImgChannel = 0;

	BOOL bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_IMGSWITCHCHANNEL, &stImgSwitchChannel, sizeof(NETDEV_IMGSWITCHANNEL_S));
	if (TRUE != bRet)
	{
		strOut.Format("ͼͨлʧ, :%d", NETDEV_GetLastError());
	}
	else
	{
		strOut.Format("ͼͨлɹ.");
	}
	AfxMessageBox(strOut);

	return;
}

void SetInfoRelease()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_INFORELEASE_CFG_S stInfoReleaseCfg;
	memset(&stInfoReleaseCfg, 0, sizeof(NETDEV_INFORELEASE_CFG_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_INFORELEASE, (LPVOID)&stInfoReleaseCfg, sizeof(NETDEV_INFORELEASE_CFG_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡãвʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	CString strText;
	strText.Format("GetDecdonfig succeed. ");
	AfxMessageBox(strText);

	bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_INFORELEASE, &stInfoReleaseCfg, sizeof(NETDEV_INFORELEASE_CFG_S));
	if (TRUE != bRet)
	{
		strOut.Format("ãвʧ, :%d", NETDEV_GetLastError());
	}
	else
	{
		strOut.Format("ãвԳɹ.");
	}
	AfxMessageBox(strOut);

	return;
}

void SetInfoWList()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_INFOWLIST_CFG_S stInfoWListCfg;
	memset(&stInfoWListCfg, 0, sizeof(NETDEV_INFOWLIST_CFG_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_INFOWLIST, (LPVOID)&stInfoWListCfg, sizeof(NETDEV_INFOWLIST_CFG_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡãʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	CString strText;
	strText.Format("GetDecdonfig succeed. ");
	AfxMessageBox(strText);

	bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_INFOWLIST, &stInfoWListCfg, sizeof(NETDEV_INFOWLIST_CFG_S));
	if (TRUE != bRet)
	{
		strOut.Format("ãʧ, :%d", NETDEV_GetLastError());
	}
	else
	{
		strOut.Format("ãɹ.");
	}
	AfxMessageBox(strOut);

	return;
}

void SetInfoBList()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_INFOBLIST_CFG_S stInfoBListCfg;
	memset(&stInfoBListCfg, 0, sizeof(NETDEV_INFOBLIST_CFG_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_INFOBLIST, (LPVOID)&stInfoBListCfg, sizeof(NETDEV_INFOBLIST_CFG_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡãʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	CString strText;
	strText.Format("GetDecdonfig succeed. ");
	AfxMessageBox(strText);

	bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_INFOBLIST, &stInfoBListCfg, sizeof(NETDEV_INFOBLIST_CFG_S));
	if (TRUE != bRet)
	{
		strOut.Format("ãʧ, :%d", NETDEV_GetLastError());
	}
	else
	{
		strOut.Format("ãɹ.");
	}
	AfxMessageBox(strOut);

	return;
}

void SetCarPortLedCtrl()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_CARPORT_CONTROLLED_S stCarPortLedCtrl;
	memset(&stCarPortLedCtrl, 0, sizeof(NETDEV_CARPORT_CONTROLLED_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_CARPORT_LED_CTRL, (LPVOID)&stCarPortLedCtrl, sizeof(NETDEV_CARPORT_CONTROLLED_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡλָʾƿʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	CString strText;
	strText.Format("GetDecdonfig succeed. ");
	AfxMessageBox(strText);

	bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_CARPORT_LED_CTRL, &stCarPortLedCtrl, sizeof(NETDEV_CARPORT_CONTROLLED_S));
	if (TRUE != bRet)
	{
		strOut.Format("óλָʾƿʧ, :%d", NETDEV_GetLastError());
	}
	else
	{
		strOut.Format("óλָʾƿƳɹ.");
	}
	AfxMessageBox(strOut);


	return;
}

void SetInstallGuideCfg()
{
	CString strOut;
	INT32 dwBytesReturned = 0;
	NETDEV_INSTALL_GUIDE_CFG_S stInstallGuideCfg;
	memset(&stInstallGuideCfg, 0, sizeof(NETDEV_INSTALL_GUIDE_CFG_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_INSTALL_GUIDE_CFG, (LPVOID)&stInstallGuideCfg, sizeof(NETDEV_INSTALL_GUIDE_CFG_S), &dwBytesReturned);
	if(TRUE != bRet)
	{
		strOut.Format("ȡڰװʧ, :%d", bRet);
		AfxMessageBox(strOut);
		return;
	}

	CString strText;
	strText.Format("GetDecdonfig succeed. ");
	AfxMessageBox(strText);

	bRet = NETDEV_SetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_SET_INSTALL_GUIDE_CFG, &stInstallGuideCfg, sizeof(NETDEV_INSTALL_GUIDE_CFG_S));
	if (TRUE != bRet)
	{
		strOut.Format("óڰװʧ, :%d", NETDEV_GetLastError());
	}
	else
	{
		strOut.Format("óڰװóɹ.");
	}
	AfxMessageBox(strOut);

	return;
}

void CCParkDevParameterDlg::OnBnClickedParkSetcfgButton()
{
	UpdateData(TRUE);
	int iCbIndex = m_ComboxSetConfig.GetCurSel();

	switch (iCbIndex)
	{
	case 0:
		{
			SetNTPConfig();
			break;
		}
	case 1:
		{
			SetStreamCfg();
			break;
		}
	case 2:
		{
			SetStreamConfigEx();
			break;
		}
	case 3:
		{
			SetVideoModeConfig();
			break;
		}
	case 4:
		{
			SetOSDConfig();
			break;
		}
	case 5:
		{
			SetOSDContentConfig();
			break;
		}
	case 6:
		{
			SetOSDContentStyleCfg();
			break;
		}
	case 7:
		{
			SetAlarmOutputCfg();
			break;
		}
	case 8:
		{
			TriggerAlarmOutput();
			break;
		}
	case 9:
		{
			SetImageCfg();
			break;
		}
	case 10:
		{
			SetNetworkCfg();
			break;
		}
	case 11:
		{
			SetFocusInfo();
			break;
		}
	case 12:
		{
			SetIrcutFilterInfo();
			break;
		}
	case 13:
		{
			SetDefoggingInfo();
			break;
		}
	case 14:
		{
			SetCarportCfg();
			break;
		}
	case 15:
		{
			SetOsdStyleCfg();
			break;
		}
	case 16:
		{
			SetInfoOsdCfg();
			break;
		}
	case 17:
		{
			SetAccpLicInfo();
			break;
		}
	case 18:
		{
			SetExposureCfg();
			break;
		}
	case 19:
		{
			SetTelentConfig();
			break;
		}
	case 20:
		{
			SetIrcut();
			break;
		}
	case 21:
		{
			SetImgEnhance();
			break;
		}
	case 22:
		{
			SetImgClarData();
			break;
		}
	case 23:
		{
			SetImgSwitchChannel();
			break;
		}
	case 24:
		{
			SetInfoRelease();
			break;
		}
	case 25:
		{
			SetInfoWList();
			break;
		}
	case 26:
		{
			SetInfoBList();
			break;
		}
	case 27:
		{
			SetCarPortLedCtrl();
			break;
		}
	case 28:
		{
			SetInstallGuideCfg();
			break;
		}
	default:
		break;
	}

	return;



}

void GetVideoEncodeCapability()
{
	CString strTemp, strTemp1, strOut, strError, strStreamType, strEncodeType;
	INT32 dwBytesReturned = 0;
	NETDEV_VIDEO_STREAM_CAP_S stVideoStreamCap;
	memset(&stVideoStreamCap, 0, sizeof(NETDEV_VIDEO_STREAM_CAP_S));

	BOOL bRet = NETDEV_GetDeviceCapability(m_lpDevHandle, m_lChannelID, NETDEV_CAP_VIDEO_ENCODE, &stVideoStreamCap, sizeof(NETDEV_VIDEO_STREAM_CAP_S), &dwBytesReturned);
	if (TRUE != bRet)
	{
		strError.Format("ȡƵʧ, :%d", bRet);
		AfxMessageBox(strError);
		return;
	}

	switch (stVideoStreamCap.dwStreamType)
	{
	case 0:
		{
			strStreamType = "";
			break;
		}
	case 1:
		{
			strStreamType = "";
			break;
		}
	case 2:
		{
			strStreamType = "";
			break;
		}
	case 3:
		{
			strStreamType = "";
			break;
		}
	default:
		{
			strStreamType = "δ֪";
			break;
		}
	}

	strOut.Format("ͣ%s\n%d\n\n[\n", strStreamType, stVideoStreamCap.dwEncodeCapSize);
	for (int i = 0; (i < stVideoStreamCap.dwEncodeCapSize) && (i < NETDEV_VIDEO_ENCODE_TYPE_MAX); i++)
	{
		switch (stVideoStreamCap.astEncodeCap[i].dwEncodeType)
		{
		case 0:
			{
				strEncodeType = "MJPEG";
				break;
			}
		case 1:
			{
				strEncodeType = "H.264";
				break;
			}
		case 2:
			{
				strEncodeType = "H.265";
				break;
			}
		default:
			{
				strEncodeType = "δ֪";
				break;
			}
		}


		strTemp.Format("(ʽ%s\nֱ%d\nֱʣ%d X %d\nI֡%d-%d\n֡ʣ%d-%d\n%d-%d\nʣ%d-%d)\n", strEncodeType,
			stVideoStreamCap.astEncodeCap[i].dwResolutionSize, stVideoStreamCap.astEncodeCap[i].astResolution->dwWidth, stVideoStreamCap.astEncodeCap[i].astResolution->dwHeight,
			stVideoStreamCap.astEncodeCap[i].stIFrameInterval.dwMin, stVideoStreamCap.astEncodeCap[i].stIFrameInterval.dwMax, stVideoStreamCap.astEncodeCap[i].stFrameRate.dwMin,
			stVideoStreamCap.astEncodeCap[i].stFrameRate.dwMax, stVideoStreamCap.astEncodeCap[i].stEncodingInterval.dwMin, stVideoStreamCap.astEncodeCap[i].stEncodingInterval.dwMax,
			stVideoStreamCap.astEncodeCap[i].stBitRate.dwMin, stVideoStreamCap.astEncodeCap[i].stBitRate.dwMax);
		strOut += strTemp;
	}
	strOut += "]\n";

	strTemp1.Format("ͼΧ%d-%d", stVideoStreamCap.stQuality.dwMin, stVideoStreamCap.stQuality.dwMax);
	strOut += strTemp1;

	AfxMessageBox(strOut);

	return;
}

void GetOsdCapability()
{
	CString strOut, strError, strTemp, strTemp1, strTemp2, strTemp3, strTemp4, strTemp5;
	CString astrDateFormat[NETDEV_OSD_DATE_FORMAT_MAX_NUM];
	INT32 dwBytesReturned = 0;
	NETDEV_OSD_CAP_S stOsdCapability;
	memset(&stOsdCapability, 0, sizeof(NETDEV_OSD_CAP_S));

	BOOL bRet = NETDEV_GetDeviceCapability(m_lpDevHandle, m_lChannelID, NETDEV_CAP_OSD, &stOsdCapability, sizeof(NETDEV_OSD_CAP_S), &dwBytesReturned);
	if (TRUE != bRet)
	{
		strError.Format("ȡOSDʧ, :%d", bRet);
		AfxMessageBox(strError);
		return;
	}

	strOut.Format("Ƿ֧,0֧ 1֧֣%d\nǷ֧OSDСã%d\nǷ֧OSDɫã%d\n֧OSD%d\n֧OSD%d\n"\
		"ÿ֧OSD%d\nֵ֧OSD%d\nֵ֧ʱOSDʽ%d\nֵ֧OSDʽ%d\nOSDʽб\n[\n",
		stOsdCapability.bIsSupportCfg, stOsdCapability.bIsSupportFontSizeCfg, stOsdCapability.bIsSupportFontColorCfg, stOsdCapability.udwMaxAreaNum,
		stOsdCapability.udwMaxOSDNum, stOsdCapability.udwMaxPerAreaOSDNum, stOsdCapability.udwSupportedOSDTypeNum, stOsdCapability.udwSupportedTimeFormatNum,
		stOsdCapability.udwSupportedDateFormatNum);

	for (int i = 0; (i < stOsdCapability.udwSupportedDateFormatNum) && (i < NETDEV_OSD_DATE_FORMAT_MAX_NUM); i++)
	{
		switch (stOsdCapability.aduwSupportedDateFormatList[i])
		{
		case NETDEV_OSD_DATE_FORMAT_YYYY_MMDD:
			{
				strTemp = "yyyy-MM-dd";
				break;
			}
		case NETDEV_OSD_DATE_FORMAT_MMDD_YYYY:
			{
				strTemp = "yyyy-MM-dd";
				break;
			}
		case NETDEV_OSD_DATE_FORMAT_CHINESE_YYYY_MMDD:
			{
				strTemp = "yyyyMMdd yyyy/MM/dd";
				break;
			}
		case NETDEV_OSD_DATE_FORMAT_CHINESE_MMDD_YYYY:
			{
				strTemp = "MMddyyyy MM/dd/yyyy";
				break;
			}
		case NETDEV_OSD_DATE_FORMAT_CHINESE_YYY_MMDD_X:
			{
				strTemp = "yyyyMMdd X dddd yyyy MM dd";
				break;
			}
		case NETDEV_OSD_DATE_FORMAT_CHINESE_MMDD_YYYY_X:
			{
				strTemp = "MMddyyyy X dddd MM dd yyyy";
				break;
			}
		case NETDEV_OSD_DATE_FORMAT_ENGLISH_DDMM_YYYY:
			{
				strTemp = "dd/MM/yyyy";
				break;
			}
		case NETDEV_OSD_DATE_FORMAT_ENGLISH_MMDD_YYYY:
			{
				strTemp = "MM/dd/yyyy";
				break;
			}
		case NETDEV_OSD_DATE_FORMAT_ENGLISH_DDMMMM_YYYY:
			{
				strTemp = "dd MMMM, yyyy";
				break;
			}
		case NETDEV_OSD_DATE_FORMAT_ENGLISH_MMMMDD_YYYY:
			{
				strTemp = "MMMM dd, yyyy";
				break;
			}
		case NETDEV_OSD_DATE_FORMAT_ENGLISH_DDDDDDMMMM_YYYY:
			{
				strTemp = "dddd, dd MMMM, yyyy";
				break;
			}
		case NETDEV_OSD_DATE_FORMAT_ENGLISH_DDDDDDMMMM_DDYYYY:
			{
				strTemp = "dddd, MMMM dd, yyyy";
				break;
			}
		case NETDEV_OSD_DATE_FORMAT_ENGLISH_YYYY_MMDD:
			{
				strTemp = "yyyy/MM/dd";
				break;
			}
		case NETDEV_OSD_DATE_FORMAT_ENGLISH_YYYY_MMMMDD:
			{
				strTemp = "yyyy, MMMM dd";
				break;
			}
		case NETDEV_OSD_DATE_FORMAT_ENGLISH_DDDDYY_MMDD:
			{
				strTemp = "dddd, yy, MM dd";
				break;
			}
		default:
			{
				strTemp = "δ֪";
				break;
			}
		}

		strTemp1.Format("%s\n", strTemp);
		strOut += strTemp1;
	}
	strOut +="]\nʱOSDʽб\n[\n";

	for (int i = 0; (i < stOsdCapability.udwSupportedTimeFormatNum) && (i < NETDEV_OSD_TIME_FORMAT_MAX_NUM); i++)
	{
		switch (stOsdCapability.audwSupportedTimeFormatList[i])
		{
		case NETDEV_OSD_TIME_FORMAT_HHMMSS:
			{
				strTemp2 = "HH:mm:ss";
				break;
			}
		case NETDEV_OSD_TIME_FORMAT_HH_MM_SS_T:
			{
				strTemp2 = "hh:mm:ss t.t.";
				break;
			}
		case NETDEV_OSD_TIME_FORMAT_HH_MM_SS_TT:
			{
				strTemp2 = "hh:mm:ss tt";
				break;
			}
		case NETDEV_OSD_TIME_FORMAT_TT_HH_MM_SS:
			{
				strTemp2 = "tt hh:mm:ss";
				break;
			}
		case NETDEV_OSD_TIME_FORMAT_PM_HH_MM_SS:
			{
				strTemp2 = " hh:mm:ss  P.M. hh:mm:ss";
				break;
			}
		case NETDEV_OSD_TIME_FORMAT_HH_MM_SS_XX:
			{
				strTemp2 = "HH:mm:ss.xxx";
				break;
			}
		case NETDEV_OSD_TIME_FORMAT_HH_MM_SS_XX_TT:
			{
				strTemp2 = "hh:mm:ss.xxx tt";
				break;
			}
		default:
			{
				strTemp2 = "δ֪";
				break;
			}
		}

		strTemp3.Format("%s\n", strTemp2);
		strOut += strTemp3;
	}
	strOut += "]\n֧õOSDб\n[\n";

	for (int i = 0; (i < stOsdCapability.udwSupportedOSDTypeNum) && (i < NETDEV_OSD_TYPE_MAX_NUM); i++)
	{
		switch (stOsdCapability.audwSupportedOSDTypeList[i])
		{
		case NETDEV_OSD_CONTENT_TYPE_NOTUSE:
			{
				strTemp4 = "ʹ";
				break;
			}
		case NETDEV_OSD_CONTENT_TYPE_CUSTOM:
			{
				strTemp4 = "Զ";
				break;
			}
		case NETDEV_OSD_CONTENT_TYPE_DATE_AND_TIME:
			{
				strTemp4 = "ʱ";
				break;
			}
		case NETDEV_OSD_CONTENT_TYPE_PTZ_CONTROLLER:
			{
				strTemp4 = "̨";
				break;
			}
		case NETDEV_OSD_CONTENT_TYPE_PTZ_COORDINATES:
			{
				strTemp4 = "̨";
				break;
			}
		case NETDEV_OSD_CONTENT_TYPE_CRUISE:
			{
				strTemp4 = "ѲϢ";
				break;
			}
		case NETDEV_OSD_CONTENT_TYPE_ZOOM:
			{
				strTemp4 = "䱶Ϣ";
				break;
			}
		case NETDEV_OSD_CONTENT_TYPE_PRESET:
			{
				strTemp4 = "ԤλϢ";
				break;
			}
		case NETDEV_OSD_CONTENT_TYPE_ALARM_INFO:
			{
				strTemp4 = "Ϣ";
				break;
			}
		case NETDEV_OSD_CONTENT_TYPE_ENCODE:
			{
				strTemp4 = "Ϣ";
				break;
			}
		case NETDEV_OSD_CONTENT_TYPE_SERIAL_PORT:
			{
				strTemp4 = "OSD";
				break;
			}
		case NETDEV_OSD_CONTENT_TYPE_PTZ_ORIENTATION:
			{
				strTemp4 = "̨λϢ";
				break;
			}
		case NETDEV_OSD_CONTENT_TYPE_CHN_NAME:
			{
				strTemp4 = "ͨ";
				break;
			}
		case NETDEV_OSD_CONTENT_TYPE_DEBUG:
			{
				strTemp4 = "OSD";
				break;
			}
		case NETDEV_OSD_CONTENT_TYPE_PEOPLE_COUNTING:
			{
				strTemp4 = "ͳOSD";
				break;
			}
		case NETDEV_OSD_CONTENT_TYPE_NETWORK_PORT:
			{
				strTemp4 = "OSD";
				break;
			}
		case NETDEV_OSD_CONTENT_TYPE_TIME:
			{
				strTemp4 = "ʱ";
				break;
			}
		case NETDEV_OSD_CONTENT_TYPE_DATE:
			{
				strTemp4 = "";
				break;
			}
		case NETDEV_OSD_CONTENT_TYPE_SMART_CONTENT:
			{
				strTemp4 = "OSD";
				break;
			}
		case NETDEV_OSD_CONTENT_TYPE_BATTERY:
			{
				strTemp4 = "OSD";
				break;
			}
		case NETDEV_OSD_CONTENT_TYPE_SCROLL_OSD:
			{
				strTemp4 = "ĻOSD";
				break;
			}
		case NETDEV_OSD_CONTENT_TYPE_PICTURE_OVERLAY:
			{
				strTemp4 = "LOGO OSD";
				break;
			}
		case NETDEV_OSD_CONTENT_TYPE_MOTOR_VEHICLE_NUM:
			{
				strTemp4 = "ڻ";
				break;
			}
		case NETDEV_OSD_CONTENT_TYPE_NON_MOTOR_VEHICLE_NUM:
			{
				strTemp4 = "ڷǻ";
				break;
			}
		case NETDEV_OSD_CONTENT_TYPE_PEOPLE_NUM:
			{
				strTemp4 = "";
				break;
			}
		case NETDEV_OSD_CONTENT_TYPE_INFOOSD_NUM:
			{
				strTemp4 = "INFOOSDĿ";
				break;
			}
		default:
			{
				strTemp4 = "δ֪";
				break;
			}
		}

		strTemp5.Format("%s\n", strTemp4);
		strOut += strTemp5;
	}
	strOut += "]";

	AfxMessageBox(strOut);

	return;
}

void GetVideoEncodeExCap()
{
	CString strTemp, strTemp1, strTemp2, strOut, strError;
	INT32 dwBytesReturned = 0;
	NETDEV_VIDEO_STREAM_CAP_EX_S stVideoStreamCapEx;
	memset(&stVideoStreamCapEx, 0, sizeof(NETDEV_VIDEO_STREAM_CAP_EX_S));

	BOOL bRet = NETDEV_GetDeviceCapability(m_lpDevHandle, m_lChannelID, NETDEV_CAP_VIDEO_ENCODE_EX, &stVideoStreamCapEx, sizeof(NETDEV_VIDEO_STREAM_CAP_EX_S), &dwBytesReturned);
	if (TRUE != bRet)
	{
		strError.Format("ȡƵʧ, :%d", bRet);
		AfxMessageBox(strError);
		return;
	}

	strOut.Format("Ƿ֧,0: ֧, 1: ֧֣%d, Ƿ֧ƽ,0: ֧, 1: ֧֣%d, ͼʽǷ,0: ֧, 1: ֧֣%d, ֵ֧Ƶʽ%d, "\
		"ֵ֧Ƶʽб[", stVideoStreamCapEx.bIsSupportCfg, stVideoStreamCapEx.bIsSupportSmoothLevel, stVideoStreamCapEx.bIsSupportImageFormat,
		stVideoStreamCapEx.udwEncodeFormatNum);

	for (int i = 0; i < NETDEV_ENCODE_FORMAT_MAX_NUM; i++)
	{
		switch (stVideoStreamCapEx.audwEncodeFormatList[i])
		{
		case 0:
			{
				strTemp = "MJPEG";
				break;
			}
		case 1:
			{
				strTemp = "H.264";
				break;
			}
		case 2:
			{
				strTemp = "H.265";
				break;
			}
		default:
			break;
		}

		strOut += strTemp + ", ";
	}
	strOut +="], ";
	strTemp.Format("ֵ֧I֡Сֵ%d, ֵ֧Iֵ֡%d\nֵ֧GOP%d, ֵ֧GOPб[", stVideoStreamCapEx.udwMinIFrameInterval,
		stVideoStreamCapEx.udwMaxIFrameInterval, stVideoStreamCapEx.udwGOPTypeNum);
	strOut += strTemp;

	for (int i = 0; i < NETDEV_GOP_TYPE_MAX_NUM; i++)
	{
		switch (stVideoStreamCapEx.audwGOPTypeList[i])
		{
		case NETDEV_GOP_TYPE_IP:
			{
				strTemp = "IP";
				break;
			}
		case NETDEV_GOP_TYPE_IBP:
			{
				strTemp = "IBP";
				break;
			}
		case NETDEV_GOP_TYPE_IBBP:
			{
				strTemp = "IBBP";
				break;
			}
		case NETDEV_GOP_TYPE_I:
			{
				strTemp = "I";
				break;
			}
		default:
			break;
		}

		strOut += strTemp + ", ";
	}
	strOut +="]\n";

	strTemp.Format("ֵ֧Ƶʽ%d, Ƶʽб[", stVideoStreamCapEx.udwVideoModeNum);
	strOut += strTemp;
	for (int i = 0; i < NETDEV_LEN_16; i++)
	{
		strTemp.Format("(ͼȣ%d, ͼ߶ȣ%d, ͼ֡ʣ%d)", stVideoStreamCapEx.astVideoModeList[i].udwWidth, stVideoStreamCapEx.astVideoModeList[i].udwHeight,
			stVideoStreamCapEx.astVideoModeList[i].udwFrameRate);
		strOut += strTemp;
	}
	strOut += "]\n";

	strTemp.Format("ֵ֧%d\nֵ֧б\n[\n", stVideoStreamCapEx.udwStreamCapNum);
	strOut += strTemp;
	for (int i = 0; i < NETDEV_LEN_16; i++)
	{
		switch (stVideoStreamCapEx.astStreamCapList[i].udwstreamID)
		{
		case NETDEV_LIVE_STREAM_INDEX_MAIN:
			{
				strTemp2 = "";
				break;
			}
		case NETDEV_LIVE_STREAM_INDEX_AUX:
			{
				strTemp2 = "";
				break;
			}
		case NETDEV_LIVE_STREAM_INDEX_THIRD:
			{
				strTemp2 = "";
				break;
			}
		case NETDEV_LIVE_STREAM_INDEX_FOUTH:
			{
				strTemp2 = "";
				break;
			}
		default:
			break;
		}

		strTemp.Format("%s, ֵ֧ķֱʸ%d, ֵ֧֡ʸ%d, ǰ֡ʣ%d, ǰMJPEG֡ʣ%d, ֵ֧֡飺[",
			strTemp2, stVideoStreamCapEx.astStreamCapList[i].udwResolutionNum, stVideoStreamCapEx.astStreamCapList[i].udwFrameRateNum,
			stVideoStreamCapEx.astStreamCapList[i].udwMaxFrameRate, stVideoStreamCapEx.astStreamCapList[i].udwMaxMJPEGFrameRate);

		strOut += strTemp;

		for (int j = 0; j < NETDEV_LEN_16; j++)
		{
			strTemp.Format("%d, ", stVideoStreamCapEx.astStreamCapList[i].audwFrameRateList[j]);
			strOut += strTemp;
		}
		strOut += "], ֵ֧ķֱб[";

		for (int j = 0; j < NETDEV_LEN_32; j++)
		{
			strTemp.Format("(ͼȣ%d, ͼ߶ȣ%d, Сʣ%d, ʣ%d, Ĭʣ%d)", stVideoStreamCapEx.astStreamCapList[i].astResolutionCapabilityList[j].udwWidth,
				stVideoStreamCapEx.astStreamCapList[i].astResolutionCapabilityList[j].udwHeight, stVideoStreamCapEx.astStreamCapList[i].astResolutionCapabilityList[j].udwMinBitRate,
				stVideoStreamCapEx.astStreamCapList[i].astResolutionCapabilityList[j].udwMaxBitRate, stVideoStreamCapEx.astStreamCapList[i].astResolutionCapabilityList[j].udwDefaultBitRate);

			strOut += strTemp;
		}
		strOut += "], ";

		strTemp.Format("ͼչģʽֵ֧H.264ͼܱģʽ%d, ֵ֧H.264ͼܱģʽб[", stVideoStreamCapEx.astStreamCapList[i].stSmartEncode.udwH264SmartEncodeModeNum);
		strOut += strTemp;
		for (int j = 0; j < NETDEV_SMART_ENCODE_MODEL_MAX_NUM; j++)
		{
			strTemp.Format("%d, ", stVideoStreamCapEx.astStreamCapList[i].stSmartEncode.audwH264SmartEncodeModeList[j]);
			strOut += strTemp;
		}
		strOut += "], ";

		strTemp.Format("ֵ֧H.265ͼܱģʽ%d, ֵ֧H.265ͼܱģʽб:[",  stVideoStreamCapEx.astStreamCapList[i].stSmartEncode.udwH265SmartEncodeModeNum);
		for (int j = 0; j < NETDEV_SMART_ENCODE_MODEL_MAX_NUM; j++)
		{
			strTemp.Format("%d, ", stVideoStreamCapEx.astStreamCapList[i].stSmartEncode.audwH265SmartEncodeModeList[j]);
			strOut += strTemp;
		}
		strOut += "]\n";
	}
	strOut += "]";

	AfxMessageBox(strOut);

	return;
}


void CCParkDevParameterDlg::OnBnClickedParkGetcapaButton2()
{
	// TODO: ڴӿؼ֪ͨ
	UpdateData(TRUE);
	int iCbIndex = m_ComboxCapability.GetCurSel();

	switch (iCbIndex)
	{
	case 0:
		{
			GetVideoEncodeCapability();
			break;
		}
	case 1:
		{
			GetOsdCapability();
			break;
		}
	case 2:
		{
			GetVideoEncodeExCap();
			break;
		}
	default:
		break;
	}
}

void CCParkDevParameterDlg::OnBnClickedParkSetosdButton()
{
	// TODO: ڴӿؼ֪ͨ
	//OSDݣ
	CString strOsdTest;
	CHAR szTmp[NETDEV_LEN_64] = {0};
	GetDlgItemText(IDC_PARK_OSDCONTENT_EDIT,strOsdTest);
    if (strOsdTest.GetLength() > 0)
    {
	   MBToUTF8(strOsdTest.GetBuffer(0), szTmp, sizeof(szTmp) - 1);
    }


	NETDEV_OSD_CONTENT_S stuInfoOsdCfgs;

	stuInfoOsdCfgs.udwNum = 8;

	//1
	for(int i = 0; i < stuInfoOsdCfgs.udwNum;i++ )
	{
		stuInfoOsdCfgs.astContentList[i].udwOSDID = i;
		if(i == 0)
		{
          stuInfoOsdCfgs.astContentList[i].bEnabled = 1;
		}
		else
		{
          stuInfoOsdCfgs.astContentList[i].bEnabled = 0;
		}
		stuInfoOsdCfgs.astContentList[i].udwAreaOSDNum = 8;

		stuInfoOsdCfgs.astContentList[i].udwTopLeftX = 2;
		stuInfoOsdCfgs.astContentList[i].udwTopLeftY = 3;

		stuInfoOsdCfgs.astContentList[i].udwBotRightX = 12;
		stuInfoOsdCfgs.astContentList[i].udwBotRightY = 13;

		for(int j = 0; j < stuInfoOsdCfgs.astContentList[i].udwAreaOSDNum; j++)
		{
			memset(stuInfoOsdCfgs.astContentList[i].astContentInfo[j].szOSDText,0,NETDEV_OSD_TEXT_MAX_LEN);
			if(i == 0 && j == 0)
			{
			  strncpy(stuInfoOsdCfgs.astContentList[i].astContentInfo[j].szOSDText,szTmp, sizeof(szTmp) - 1);
			  stuInfoOsdCfgs.astContentList[i].astContentInfo[j].udwContentType = NETDEV_OSD_CONTENT_TYPE_CUSTOM;
			}
			else
			{
              stuInfoOsdCfgs.astContentList[i].astContentInfo[j].udwContentType = NETDEV_OSD_CONTENT_TYPE_NOTUSE;
			}
		}
	}
	
	//עҪԼݣҪulInfoTypeΪIMOS_MW_OSD_INFO_TYPE_USERDEFԶ壩
	ULONG ulRealBuffLong = sizeof(NETDEV_OSD_CONTENT_S);
	if (stuInfoOsdCfgs.udwNum > 1)
	{
		ulRealBuffLong += (stuInfoOsdCfgs.udwNum  - 1) * sizeof(NETDEV_OSD_CONTENT_INFO_S);
	}

	INT32 lChannelID = 1;
	UpdateData(TRUE);
	BOOL bRet = NETDEV_SetDevConfig(m_lpDevHandle, lChannelID, NETDEV_SET_OSD_CONTENT_CFG, &stuInfoOsdCfgs, ulRealBuffLong);
	if (TRUE != bRet)
	{
		MessageBox("set OSD text fail.");
	}
	else
	{
		MessageBox("set OSD text succeed.");
	}

	ULONG ulStyleCfgsSize = sizeof(NETDEV_OSD_CONTENT_STYLE_S);
	NETDEV_OSD_CONTENT_STYLE_S stuStyleCfgs;
	int sOsdcolor[4];
	sOsdcolor[0] = 0x000000;            /*Black*/
	sOsdcolor[1] = 0xFF0000;            /*Red*/
	sOsdcolor[2] = 0x0000FF;            /*Blue*/
    sOsdcolor[3] = 0x00FF00;            /**Green*/

	stuStyleCfgs.udwDateFormat = NETDEV_OSD_DATE_FORMAT_CHINESE_YYYY_MMDD;
	stuStyleCfgs.udwTimeFormat = NETDEV_OSD_TIME_FORMAT_PM_HH_MM_SS;

	stuStyleCfgs.audwFontAlignList[0] = NETDEV_OSD_ALIGN_LEFT;
	stuStyleCfgs.audwFontAlignList[1] = NETDEV_OSD_ALIGN_LEFT;
	stuStyleCfgs.audwFontAlignList[2] = NETDEV_OSD_ALIGN_LEFT;
	stuStyleCfgs.audwFontAlignList[3] = NETDEV_OSD_ALIGN_LEFT;
	stuStyleCfgs.audwFontAlignList[4] = NETDEV_OSD_ALIGN_LEFT;
	stuStyleCfgs.audwFontAlignList[5] = NETDEV_OSD_ALIGN_LEFT;
	stuStyleCfgs.audwFontAlignList[6] = NETDEV_OSD_ALIGN_LEFT;
	stuStyleCfgs.audwFontAlignList[7] = NETDEV_OSD_ALIGN_LEFT;

	int index = 0;
	index = m_ComboxOsdFontStytle.GetCurSel();
	stuStyleCfgs.udwFontStyle = index;
	

	index = m_ComboxOsdFontSize.GetCurSel();
	stuStyleCfgs.udwFontSize = index;

	index = m_ComboxOsdMin.GetCurSel();
	stuStyleCfgs.udwMargin = index;

	index = m_ComboxOsdColor.GetCurSel();
	stuStyleCfgs.udwColor = sOsdcolor[index];

	bRet = NETDEV_SetDevConfig(m_lpDevHandle, lChannelID, NETDEV_SET_OSD_CONTENT_STYLE_CFG, &stuStyleCfgs, ulStyleCfgsSize);
	if (TRUE != bRet)
	{
		MessageBox("set OSD cfg fail.");
	}
	else
	{
		MessageBox("set OSD cfg succeed.");
	}

	return;
}


//void CCParkDevParameterDlg::OnBnClickedParkGetcfgsButton()
//{
//	// TODO: ڴӿؼ֪ͨ
//
//}
