// CParkLocalFeaturesDlg.cpp : ʵļ
//

#include "stdafx.h"
#include "NETSDKDemo3.0.3.h"
#include "CParkLocalFeaturesDlg.h"


// CCParkLocalFeaturesDlg Ի

IMPLEMENT_DYNAMIC(CCParkLocalFeaturesDlg, CDialog)

CCParkLocalFeaturesDlg::CCParkLocalFeaturesDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCParkLocalFeaturesDlg::IDD, pParent)
	, m_dwLogSize(10)
	, m_dwLogNum(10)
	, m_strLogDir(_T(""))
	, m_LogRadio(0)
{

}

CCParkLocalFeaturesDlg::~CCParkLocalFeaturesDlg()
{
}

void CCParkLocalFeaturesDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_PARK_PLATEENCODE_COMBO, m_PlateEncodingCom);
	DDX_Text(pDX, IDC_PARK_LOGNUM_EDIT, m_dwLogNum);
	DDX_Text(pDX, IDC_PARK_LOGSIZE_EDIT, m_dwLogSize);
	DDX_Radio(pDX, IDC_PARK_NOWLOG_RADIO, m_LogRadio);
}


BEGIN_MESSAGE_MAP(CCParkLocalFeaturesDlg, CDialog)
	ON_BN_CLICKED(IDC_PARK_GETVERSION_BUTTON, &CCParkLocalFeaturesDlg::OnBnClickedParkGetversionButton)
	ON_BN_CLICKED(IDC_PARK_SETFORMAT_BUTTON, &CCParkLocalFeaturesDlg::OnBnClickedParkSetformatButton)
	ON_BN_CLICKED(IDC_PARK_SETLOG_BUTTON, &CCParkLocalFeaturesDlg::OnBnClickedParkSetlogButton)
	ON_BN_CLICKED(IDC_PARK_SETLOGCFG_BUTTON, &CCParkLocalFeaturesDlg::OnBnClickedParkSetlogcfgButton)
	ON_BN_CLICKED(IDC_PARK_SETLOGPATH_BUTTON, &CCParkLocalFeaturesDlg::OnBnClickedParkSetlogpathButton)
END_MESSAGE_MAP()


// CCParkLocalFeaturesDlg 
BOOL CCParkLocalFeaturesDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	m_PlateEncodingCom.InsertString(0, "UTF-8");
	m_PlateEncodingCom.InsertString(1, "GBK");
	m_PlateEncodingCom.SetCurSel(0);

	return TRUE;  // return TRUE unless you set the focus to a control
}


void CCParkLocalFeaturesDlg::OnBnClickedParkGetversionButton()
{
	CHAR pzSDKVersion[64] = {0};
    BOOL bRet = NETDEV_GetPARKVersion(pzSDKVersion);
	SetDlgItemText(IDC_PARK_SDKVERSION_EDIT,pzSDKVersion);
	UpdateData(TRUE);
}

void CCParkLocalFeaturesDlg::OnBnClickedParkSetformatButton()
{
	INT32 iType = 0;
	INT32 dwIndex = m_PlateEncodingCom.GetCurSel();

	if(0 == dwIndex)
	{
       iType = 1;  /*UTF-8*/
	}
	else if(1 == dwIndex)
	{
       iType = 0;  /*GBK*/
	}

	BOOL bRet = NETDEV_EnableCarplate(iType);
	if (TRUE != bRet)
	{
		MessageBox("EnableCarplate fail.");
	}
	else
	{
		MessageBox("EnableCarplate succeed.");
	}

}

void CCParkLocalFeaturesDlg::OnBnClickedParkSetlogButton()
{
	// TODO: ڴӿؼ֪ͨ
	BOOL bRet = NETDEV_SetWriteLogFlag(m_LogRadio);
	if (TRUE != bRet)
	{
		CString strError;
		strError.Format("Set WriteLogFlag fail:%lu.", bRet);
		AfxMessageBox(strError);
	}
	else
	{
		MessageBox("Set WriteLogFlag succeed.");
	}
	return;	
}

void CCParkLocalFeaturesDlg::OnBnClickedParkSetlogcfgButton()
{
	if ((m_dwLogSize > 0) && (m_dwLogNum > 0))
	{
		BOOL bRet = NETDEV_ConfigLogFile(m_dwLogSize * 1024 * 1024, m_dwLogNum);
		if (TRUE != bRet)
		{
			MessageBox("ConfigLogFile size and num fail.");
		}
		else
		{
            MessageBox("ConfigLogFile size and num succeed.");
		}
	}
}

void CCParkLocalFeaturesDlg::OnBnClickedParkSetlogpathButton()
{
	ULONG ulRet = GetCurrentDirectoryA(MAX_PATH, gszCurrentDir);
	if ((ulRet == 0) || (ulRet >= MAX_PATH))
	{
		return;
	}
	m_strLogDir.Format(_T("%s\\log"),gszCurrentDir);

	BOOL bRet = NETDEV_SetLogPath(m_strLogDir.GetBuffer(0));
	if (TRUE != bRet)
	{
		MessageBox("Set LogPath fail.");
		return;
	} 
	else
	{
		SetDlgItemText(IDC_PARK_LOGPATH_EDIT, m_strLogDir.GetBuffer(0));
        MessageBox("Set LogPath succeed.");
	}
}

