// CParkMaintenanceDlg.cpp : ʵļ
//

#include "stdafx.h"
#include "NETSDKDemo3.0.3.h"
#include "CParkMaintenanceDlg.h"


// CCParkMaintenanceDlg Ի

IMPLEMENT_DYNAMIC(CCParkMaintenanceDlg, CDialog)

CCParkMaintenanceDlg::CCParkMaintenanceDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCParkMaintenanceDlg::IDD, pParent)
	, m_oDevType(_T(""))
	, m_oSoftVer(_T(""))
	, m_oDeviceNam(_T(""))
	, m_oMacAddr(_T(""))
	, m_oDevSerial(_T(""))
	, m_oIpAddr(_T(""))
	, m_oNetMask(_T(""))
	, m_oDhcp(0)
	, m_oMtu(0)
{

}

CCParkMaintenanceDlg::~CCParkMaintenanceDlg()
{
}

void CCParkMaintenanceDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_PARK_FIRMWARE_EDIT, m_oDevType);
	DDX_Text(pDX, IDC_PART_HW_EDIT, m_oSoftVer);
	DDX_Text(pDX, IDC_PARK_BOOT_EDIT, m_oDeviceNam);
	DDX_Text(pDX, IDC_PARK_MACADDR_EDIT, m_oMacAddr);
	DDX_Text(pDX, IDC_PARK_SERIALNO_EDIT, m_oDevSerial);
	DDX_Text(pDX, IDC_PARK_IPADDR_EDIT, m_oIpAddr);
	DDX_Text(pDX, IDC_PARK_SUBNET_EDIT, m_oNetMask);
	DDX_Text(pDX, IDC_PARK_DHCP_EDIT, m_oDhcp);
	DDX_Text(pDX, IDC_PARK_MTU_EDIT, m_oMtu);
}


BEGIN_MESSAGE_MAP(CCParkMaintenanceDlg, CDialog)
	ON_BN_CLICKED(IDC_PARK_GETVERSION_BUTTON, &CCParkMaintenanceDlg::OnBnClickedParkGetversionButton)
	ON_BN_CLICKED(IDC_PARK_GETNETINFO_BUTTON, &CCParkMaintenanceDlg::OnBnClickedParkGetnetinfoButton)
	ON_BN_CLICKED(IDC_PARK_SETNETINFO_BUTTON, &CCParkMaintenanceDlg::OnBnClickedParkSetnetinfoButton)
	ON_BN_CLICKED(IDC_PARK_REBOOT_BUTTON, &CCParkMaintenanceDlg::OnBnClickedParkRebootButton)
	ON_BN_CLICKED(IDC_PARK_BROWSE_BUTTON, &CCParkMaintenanceDlg::OnBnClickedParkBrowseButton)
	ON_BN_CLICKED(IDC_PARK_UPGRADE_BUTTON, &CCParkMaintenanceDlg::OnBnClickedParkUpgradeButton)
END_MESSAGE_MAP()


// CCParkMaintenanceDlg Ϣ

void CCParkMaintenanceDlg::OnBnClickedParkGetversionButton()
{
	// TODO: ڴӿؼ֪ͨ
	if(NULL==m_lpDevHandle)
	{
		return;
	}

	NETDEV_DEVICE_BASICINFO_S stDeviceInfo;
	memset(&stDeviceInfo, 0, sizeof(NETDEV_DEVICE_BASICINFO_S));
	INT32 lChannelID = 1;
	INT32 dwBytesReturned = 0;
	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, lChannelID, NETDEV_GET_DEVICECFG, &stDeviceInfo, sizeof(NETDEV_DEVICE_BASICINFO_S), &dwBytesReturned);
	if (TRUE != bRet)
	{
		MessageBox("Get Device Info failed.");
	}
	else
	{
		int i;
		int iCharPos = -1;
		CString DevModel = stDeviceInfo.szDevModel;
		for (i = 0; i < 64; i++)
		{
			if ('\0' == stDeviceInfo.szDevModel[i])
			{
				break;
			}
		}
		DevModel.Delete(i, 64 - i);
		CString SerialNum = stDeviceInfo.szSerialNum;
		for (i = 0; i < 64; i++)
		{
			if ('\0' == stDeviceInfo.szSerialNum[i])
			{
				break;
			}
		}
		SerialNum.Delete(i, 64 - i);

		CString FirmwareVersion = stDeviceInfo.szFirmwareVersion;
		for (i = 0; i < 64; i++)
		{
			if ('\0' == stDeviceInfo.szFirmwareVersion[i])
			{
				break;
			}
		}
		FirmwareVersion.Delete(i, 64 - i);

		CString DeviceName = stDeviceInfo.szDeviceName;
		for (i = 0; i < 64; i++)
		{
			if ('\0' == stDeviceInfo.szDeviceName[i])
			{
				break;
			}
		}
		DeviceName.Delete(i, 64 - i);

		CString MacAddress = stDeviceInfo.szMacAddress;
		for (i = 0; i < 64; i++)
		{
			if ('\0' == stDeviceInfo.szMacAddress[i])
			{
				break;
			}
		}
		MacAddress.Delete(i, 64 - i);

		/* MACַûа:ָʱӷָ */
		iCharPos = MacAddress.Find(":");
		if (iCharPos < 0)
		{
			for (i = 0; i < 5; i++)
			{
				MacAddress.Insert((i + 1) * 2 + i, ":");
			}
		}

		m_oDevType = DevModel;
		m_oDevSerial = SerialNum;
		m_oSoftVer = FirmwareVersion;
		m_oDeviceNam = DeviceName;
		m_oMacAddr = MacAddress;
		UpdateData(FALSE);
	}
}

void CCParkMaintenanceDlg::OnBnClickedParkGetnetinfoButton()
{
	if (NULL == m_lpDevHandle)
	{
		return;
	}

	NETDEV_NETWORKCFG_S stNetworkcfg;
	memset(&stNetworkcfg, 0, sizeof(NETDEV_NETWORKCFG_S));
	INT32 dwBytesReturned = 0;
	INT32 lChannelID = 1;
	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, lChannelID, NETDEV_GET_NETWORKCFG, &stNetworkcfg, sizeof(NETDEV_NETWORKCFG_S), &dwBytesReturned);
	if (TRUE != bRet)
	{
		MessageBox("Get Network Interfaces failed.");
	}
	else
	{
		int i = 0;
		CString Ipv4Address = stNetworkcfg.szIpv4Address;

		for (i = 0; i < 32; i++)
		{
			if ('\0' == stNetworkcfg.szIpv4Address[i])
			{
				break;
			}
		}
		Ipv4Address.Delete(i, 32 - i);

		CString IPv4SubnetMask =stNetworkcfg.szIPv4SubnetMask;
		for (i = 0; i < 32; i++)
		{
			if ('\0' == stNetworkcfg.szIPv4SubnetMask[i])
			{
				break;
			}
		}
		IPv4SubnetMask.Delete(i, 32 - i);

		INT32 IPV4DHCP =stNetworkcfg.bIPv4DHCP;
		INT32 IPv4MTU =stNetworkcfg.dwMTU;
		m_oIpAddr= Ipv4Address;
		m_oNetMask= IPv4SubnetMask;
		m_oDhcp=IPV4DHCP;
		m_oMtu=IPv4MTU;
		UpdateData(FALSE);
	}

	return; 
}

void CCParkMaintenanceDlg::OnBnClickedParkSetnetinfoButton()
{
	NETDEV_NETWORKCFG_S stNetworkcfg;
	memset(&stNetworkcfg, 0, sizeof(NETDEV_NETWORKCFG_S));
	INT32 lChannelID = 1;
	UpdateData(TRUE);
	if("" != m_oIpAddr)
	{
		strncpy(stNetworkcfg.szIpv4Address, m_oIpAddr, NETDEV_LEN_32  -1);
	}
	if("" != m_oNetMask)
	{
		strncpy(stNetworkcfg.szIPv4SubnetMask, m_oNetMask, NETDEV_LEN_32  -1);
	}

	stNetworkcfg.bIPv4DHCP = (INT32)m_oDhcp;
	stNetworkcfg.dwMTU = (INT32)m_oMtu;
	BOOL bRet = NETDEV_SetDevConfig(m_lpDevHandle, lChannelID, NETDEV_SET_NETWORKCFG, &stNetworkcfg, sizeof(NETDEV_NETWORKCFG_S));
	if (TRUE != bRet)
	{
		MessageBox("Set Network Interfaces failed.");
	}
	else
	{
		MessageBox("Set Network Interfaces succeed.");
	}

	return;
}

void CCParkMaintenanceDlg::OnBnClickedParkRebootButton()
{
	if(NULL == m_lpDevHandle)
	{
		return;
	}

	BOOL bRet = NETDEV_Reboot(m_lpDevHandle);
	if(TRUE != bRet)
	{
		MessageBox("Reboot Failed.");
	}
	else
	{
		MessageBox("Reboot Succeed.");
	}
	m_lpDevHandle = NULL;
}

void CCParkMaintenanceDlg::OnBnClickedParkBrowseButton()
{
	CFileDialog dlg(TRUE, NULL, NULL, OFN_HIDEREADONLY, _T("All files(*.*)|*.*||"), NULL, NULL, FALSE);
	if (IDOK == dlg.DoModal())
	{
		m_strUpdateBinPath = dlg.GetPathName();
		SetDlgItemText(IDC_PARK_UPGRADEPATH_EDIT, m_strUpdateBinPath);
		UpdateData(TRUE);
	}
}

void CCParkMaintenanceDlg::OnBnClickedParkUpgradeButton()
{
	// TODO: ڴӿؼ֪ͨ
	if(NULL == m_lpDevHandle)
	{
		return;
	}

	NETDEV_UPGRADE_DEVICE_S stUpgradeInfo = {0};

	stUpgradeInfo.dwUpgradeType = NETDEV_UPGRADE_TYPE_LOCAL; 
	 strncpy(stUpgradeInfo.szPath, m_strUpdateBinPath.GetBuffer(0), sizeof(stUpgradeInfo.szPath)-1);

    CHAR pszTaskNo[256] = {0};
	 BOOL bRet = NETDEV_UpgradeDevice(m_lpDevHandle, stUpgradeInfo.dwUpgradeType, pszTaskNo);
    if (TRUE != bRet)
    {
       	MessageBox("Upload Device failed.");
        return;
    }

	bRet = NETDEV_UploadDeviceFirmware(m_lpDevHandle, stUpgradeInfo.szPath, pszTaskNo);
	if (TRUE != bRet)
	{
		MessageBox("Upload Device failed.");
	}
	else
	{
		MessageBox("Upload Device succeed.");
	}

}
