// CParkPictureDlg.cpp : ʵļ
//

#include "stdafx.h"
#include "NETSDKDemo3.0.3.h"
#include "CParkPictureDlg.h"
#include "CParkDevDlg.h"


// CCParkPictureDlg Ի
LPVOID glDlg;
CVehicleInfo gstVehicleInfo;

VOID STDCALL MultiPicDataCallBackFun(IN NETDEV_PIC_DATA_S *pstUniviewData, IN LPVOID lpUserParam)
{
	int iSize = sizeof(NETDEV_PIC_DATA_S);
	CHAR szTmp[256] = {0};
	CHAR szTmpFile[256] = {0};
	INT i = 0;
	LONG lLen = 0;
	FILE *fp = NULL;

	CCParkPictureDlg *pDlg = (CCParkPictureDlg*)glDlg;

	sprintf(szTmp, "%s\\pic", gszCurrentDir);
	if (!PathIsDirectory(szTmp))    
	{
		if (!CreateDirectory(szTmp, NULL))
		{   
			CString strError;
			strError.Format("Create file path\"%s\"fail.", szTmp);
			AfxMessageBox(strError);
			return;   
		}   		
	}

	/* Ƭ */
	for (i=0; i< pstUniviewData->ulPicNumber; i++)
	{
		memset(szTmpFile,0,256);
		sprintf(szTmpFile, "%s\\%s_%d.jpg", szTmp,pstUniviewData->szPassTime, i);
		FILE *fp =fopen(szTmpFile,"wb");
		if (NULL != fp)
		{
			fwrite(pstUniviewData->apcData[i],1,pstUniviewData->aulDataLen[i], fp);
			fclose(fp);
		}
	}

	gstVehicleInfo.m_lIndex = pstUniviewData->ulRecordID;
	gstVehicleInfo.m_lLaneID = pstUniviewData->lLaneID;
	gstVehicleInfo.m_lPlateColor = pstUniviewData->lPlateColor;
	gstVehicleInfo.m_strCaptureTime = pstUniviewData->acPassTime[0];
	gstVehicleInfo.m_strCarPlate = pstUniviewData->szCarPlate;

	PostMessage(pDlg->m_hWnd, WM_UPVEHICLEDATA, FALSE, FALSE);

	return ;
}

IMPLEMENT_DYNAMIC(CCParkPictureDlg, CDialog)

CCParkPictureDlg::CCParkPictureDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCParkPictureDlg::IDD, pParent)
{
   m_index = 0;
   glDlg = this;

}

CCParkPictureDlg::~CCParkPictureDlg()
{
}

void CCParkPictureDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_PARK_PIC_LIST, m_ctrlVehicleInfo);
}


BEGIN_MESSAGE_MAP(CCParkPictureDlg, CDialog)
	ON_MESSAGE(WM_UPVEHICLEDATA, &CCParkPictureDlg::OnUpdateData)
	ON_BN_CLICKED(IDC_PARK_STARTPIC_BUTTON, &CCParkPictureDlg::OnBnClickedParkStartpicButton)
	ON_BN_CLICKED(IDC_PARK_CLOSEPIC_BUTTON, &CCParkPictureDlg::OnBnClickedParkClosepicButton)
	ON_BN_CLICKED(IDC_PARK_CAPTURE_BUTTON, &CCParkPictureDlg::OnBnClickedParkCaptureButton)
	ON_BN_CLICKED(IDC_PARK_CAPTURESYS_BUTTON, &CCParkPictureDlg::OnBnClickedParkCapturesysButton)
END_MESSAGE_MAP()


// CCParkPictureDlg Ϣ

LRESULT CCParkPictureDlg::OnUpdateData(WPARAM wParam, LPARAM lParam)
{
	CString tmp;
	char acPlateColor[5][10] = {"white","yellow","blue","black","other"};
	ULONG index = 4;

	m_ctrlVehicleInfo.InsertItem(m_index,"");
	tmp.Format("%d", m_index +1);
	m_ctrlVehicleInfo.SetItemText(m_index,0,tmp);
	m_ctrlVehicleInfo.SetItemText(m_index,1,gstVehicleInfo.m_strCaptureTime);
	tmp.Format("%d", gstVehicleInfo.m_lLaneID);
	m_ctrlVehicleInfo.SetItemText(m_index,2,tmp);

	if (0<= gstVehicleInfo.m_lPlateColor && gstVehicleInfo.m_lPlateColor<=4)
	{
		index = gstVehicleInfo.m_lPlateColor;
	}
	m_ctrlVehicleInfo.SetItemText(m_index,3,acPlateColor[index]);
	m_ctrlVehicleInfo.SetItemText(m_index,4,gstVehicleInfo.m_strCarPlate);
	m_ctrlVehicleInfo.SetItemText(m_index,5,"No");
	m_index++;
	m_ctrlVehicleInfo.EnsureVisible(m_ctrlVehicleInfo.GetItemCount() - 1,FALSE);
	return 0;
}


BOOL CCParkPictureDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ڴӶĳʼ
	CRect rect;  
	m_ctrlVehicleInfo.GetClientRect(&rect);  
	m_ctrlVehicleInfo.SetExtendedStyle(m_ctrlVehicleInfo.GetExtendedStyle() | LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES);  
	m_ctrlVehicleInfo.InsertColumn(0,"Num", LVCFMT_CENTER, rect.Width()/10,0);
	m_ctrlVehicleInfo.InsertColumn(1,"PassTime", LVCFMT_CENTER, 3*rect.Width()/10,1);
	m_ctrlVehicleInfo.InsertColumn(2,"LaneId", LVCFMT_CENTER, rect.Width()/10,2);
	m_ctrlVehicleInfo.InsertColumn(3,"Plate color", LVCFMT_CENTER, 3*rect.Width()/20,3);
	m_ctrlVehicleInfo.InsertColumn(4,"License Plate", LVCFMT_CENTER, rect.Width()/5,4);
	m_ctrlVehicleInfo.InsertColumn(5,"CapatureSys", LVCFMT_CENTER, 3*rect.Width()/20,5);

	return TRUE;  // return TRUE unless you set the focus to a control
	// 쳣: OCX ҳӦ FALSE
}

void CCParkPictureDlg::OnBnClickedParkStartpicButton()
{
	BOOL bRet = FALSE;
	if(NULL != m_lpPicHandle)
	{
		bRet = NETDEV_StopPicStream(m_lpPicHandle);
		if (TRUE == bRet)
		{
			m_lpPicHandle = NULL;
		}
	}

	m_lpPicHandle = NETDEV_StartPicStream(m_lpDevHandle, m_hPic.m_hWnd, FALSE, "", (NETDEV_PIC_UPLOAD_PF)MultiPicDataCallBackFun, NULL);
	if (FALSE == int(m_lpPicHandle))
	{
		CString strError;
		strError.Format("Start PicStream fail.");
		AfxMessageBox(strError);
		return;	
	}
	else
	{
		CCParkDevDlg *pDlg = (CCParkDevDlg*)glParkDlg;
		pDlg->SetDlgItemText(IDC_STATIC_PICSTATUS,"Online");
		UpdateData(TRUE);
		AfxMessageBox("Start PicStream succeed.");
	}

	return;
}

void CCParkPictureDlg::OnBnClickedParkClosepicButton()
{
	if(NULL !=  m_lpPicHandle)
	{
		BOOL ulRet = NETDEV_StopPicStream(m_lpPicHandle);
		if (TRUE != ulRet)
		{
			CString strError;
			strError.Format("Stop PicStream fail:%lu.", ulRet);
			AfxMessageBox(strError);
			return;	
		}
		else
		{
			AfxMessageBox("Stop PicStream succeed.");
		}
	}
	m_lpPicHandle = NULL;
	return;
}

void CCParkPictureDlg::OnBnClickedParkCaptureButton()
{
	BOOL ulRet = NETDEV_Trigger(m_lpDevHandle);
	if (TRUE != ulRet)
	{
		CString strError;
		strError.Format("Trigger fail:%lu.", ulRet);
		AfxMessageBox(strError);
		return;	
	}
}

void CCParkPictureDlg::OnBnClickedParkCapturesysButton()
{
	NETDEV_PIC_DATA_S *pPicDataInfo;
	CString tmp;
	char acPlateColor[5][10] = {"white","yellow","blue","black","other"};
	ULONG index = 4;

	BOOL ulRet = NETDEV_TriggerSync(m_lpDevHandle, &pPicDataInfo);
	if (TRUE != ulRet)
	{
		CString strError;
		strError.Format("Capturesys fail:%lu", ulRet);
		AfxMessageBox(strError);
		return;	
	}

	m_ctrlVehicleInfo.InsertItem(m_index,"");
	tmp.Format("%d", pPicDataInfo->ulRecordID);
	m_ctrlVehicleInfo.SetItemText(m_index,0,tmp);
	m_ctrlVehicleInfo.SetItemText(m_index,1,pPicDataInfo->szPassTime);
	tmp.Format("%d", pPicDataInfo->lLaneID);
	m_ctrlVehicleInfo.SetItemText(m_index,2,tmp);
	//tmp.Format("%d", pPicDataInfo->m_lPlateColor);
	if (0<= pPicDataInfo->lPlateColor && pPicDataInfo->lPlateColor<=4)
	{
		index = pPicDataInfo->lPlateColor;
	}
	m_ctrlVehicleInfo.SetItemText(m_index,3,acPlateColor[index]);
	m_ctrlVehicleInfo.SetItemText(m_index,4,pPicDataInfo->szCarPlate);
	m_ctrlVehicleInfo.SetItemText(m_index,5,"Yes");
	m_index++;
	m_ctrlVehicleInfo.EnsureVisible(m_ctrlVehicleInfo.GetItemCount() - 1,FALSE);
}
