// CParkVoiceIntercomDlg.cpp : ʵļ
//

#include "stdafx.h"
#include "NETSDKDemo3.0.3.h"
#include "CParkVoiceIntercomDlg.h"


// CCParkVoiceIntercomDlg Ի

IMPLEMENT_DYNAMIC(CCParkVoiceIntercomDlg, CDialog)

CCParkVoiceIntercomDlg::CCParkVoiceIntercomDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCParkVoiceIntercomDlg::IDD, pParent)
{
	m_olpTalkHandle = NULL;
	m_dwMicVolume = 0;
	m_dwSoundVolume = 0;
	m_lChannelID = 1;
}

CCParkVoiceIntercomDlg::~CCParkVoiceIntercomDlg()
{
}

void CCParkVoiceIntercomDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_PARK_MIC_SLIDER, m_oSliMicVolume);
	DDX_Control(pDX, IDC_PARK_LOUD_SLIDER, m_oSliSoundVolume);
}


BEGIN_MESSAGE_MAP(CCParkVoiceIntercomDlg, CDialog)
	ON_BN_CLICKED(IDC_PARK_VOICEON_BUTTON, &CCParkVoiceIntercomDlg::OnBnClickedParkVoiceonButton)
	ON_BN_CLICKED(IDC_PARK_VOICEOFF_BUTTON, &CCParkVoiceIntercomDlg::OnBnClickedParkVoiceoffButton)
	ON_NOTIFY(NM_THEMECHANGED, IDC_PARK_MIC_SLIDER, &CCParkVoiceIntercomDlg::OnNMThemeChangedParkMicSlider)
	ON_NOTIFY(NM_THEMECHANGED, IDC_PARK_LOUD_SLIDER, &CCParkVoiceIntercomDlg::OnNMThemeChangedParkLoudSlider)
END_MESSAGE_MAP()


// CCParkVoiceIntercomDlg Ϣ

void CCParkVoiceIntercomDlg::OnBnClickedParkVoiceonButton()
{
	if(NULL != m_olpTalkHandle)
	{
		return;
	}

	if(NULL == m_lpDevHandle)
	{
		CString strError;
		strError.Format("please login Device.");
		AfxMessageBox(strError);
		return;
	}

	m_olpTalkHandle = NETDEV_StartVoiceCom(m_lpDevHandle, m_lChannelID, NULL, NULL);
	if(NULL ==  m_olpTalkHandle)
	{
		CString strError;
		strError.Format("Start VoiceCom fail.");
		AfxMessageBox(strError);
	}
	else
	{
		CString strError;
		strError.Format("Start VoiceCom succeed.");
		AfxMessageBox(strError);
	}

}

void CCParkVoiceIntercomDlg::OnBnClickedParkVoiceoffButton()
{
	if(NULL == m_olpTalkHandle)
	{
		CString strError;
		strError.Format("please start VoiceCom");
		AfxMessageBox(strError);
		return;
	}

	BOOL bRet = NETDEV_StopVoiceCom(m_olpTalkHandle);
	if(TRUE == bRet)
	{
		CString strError;
		strError.Format("Stop VoiceCom succeed");
		AfxMessageBox(strError);
		return;
	}

}


void CCParkVoiceIntercomDlg::OnNMThemeChangedParkMicSlider(NMHDR *pNMHDR, LRESULT *pResult)
{
	INT32 dwMicValue = m_oSliMicVolume.GetPos();

	if(NULL == m_lpPlayHandle)
	{
		CString strError;
		strError.Format("voice not open.");
		AfxMessageBox(strError);
		return;
	}

	if (TRUE == NETDEV_OpenMic(m_lpPlayHandle))
	{  
		BOOL bRet = NETDEV_MicVolumeControl(m_lpPlayHandle, dwMicValue);
		if(TRUE != bRet)
		{
			CString strError;
			strError.Format("MicVolume Control fail.");
			AfxMessageBox(strError);
			return;
		}
		m_dwMicVolume = dwMicValue;
	}
	else
	{
		CString strError;
		strError.Format("OpenSound fail.");
		AfxMessageBox(strError);
	}

	*pResult = 0;
}

void CCParkVoiceIntercomDlg::OnNMThemeChangedParkLoudSlider(NMHDR *pNMHDR, LRESULT *pResult)
{
	INT32 dwSoundValue = m_oSliSoundVolume.GetPos();

	if(NULL == m_olpTalkHandle)
	{
		CString strError;
		strError.Format("voice not open.");
		AfxMessageBox(strError);
		return;
	}

	if (TRUE == NETDEV_OpenSound(m_lpPlayHandle))
	{   
		BOOL bRet = NETDEV_SoundVolumeControl(m_lpPlayHandle, dwSoundValue);
		if(TRUE != bRet)
		{
			CString strError;
			strError.Format("SoundVolume Control fail.");
			AfxMessageBox(strError);
			return;
		}
		m_dwSoundVolume = dwSoundValue;
	}
	else
	{
		CString strError;
		strError.Format("OpenSound fail.");
		AfxMessageBox(strError);
	}

	*pResult = 0;
}
