// CParkingCfgDlg.cpp : ʵļ
//

#include "stdafx.h"
#include "NETSDKDemo3.0.3.h"
#include "CParkingCfgDlg.h"


// CCParkingCfgDlg Ի

IMPLEMENT_DYNAMIC(CCParkingCfgDlg, CDialog)

CCParkingCfgDlg::CCParkingCfgDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCParkingCfgDlg::IDD, pParent)
{

}

CCParkingCfgDlg::~CCParkingCfgDlg()
{
}

void CCParkingCfgDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_PARK_SPACE, m_ParkingSpaceCfgCtrl);
	DDX_Control(pDX, IDC_EDIT_PARKINGCTRL, m_edit);
	DDX_Control(pDX, IDC_COMBO_PARK_CATORMODE, m_ComboxCatorMode);
	DDX_Control(pDX, IDC_COMBO_PARK_CATORCOLOR, m_ComboxCatorColor);
	DDX_Control(pDX, IDC_COMBO_PARK_CATORSTATUS, m_ComboxCatorStatus);
}


BEGIN_MESSAGE_MAP(CCParkingCfgDlg, CDialog)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_PARK_SPACE, &CCParkingCfgDlg::OnNMDblclkListParkSpace)
	ON_EN_KILLFOCUS(IDC_EDIT_PARKINGCTRL, &CCParkingCfgDlg::OnEnKillfocusEditParkingctrl)
ON_BN_CLICKED(IDC_BUTTON_GET_PARKINGCFG, &CCParkingCfgDlg::OnBnClickedButtonGetParkingcfg)
ON_BN_CLICKED(IDC_BUTTON_PARK_CATORCONTROL, &CCParkingCfgDlg::OnBnClickedButtonParkCatorcontrol)
ON_BN_CLICKED(IDC_BUTTON_PARK_CATORSTATUS, &CCParkingCfgDlg::OnBnClickedButtonParkCatorstatus)
END_MESSAGE_MAP()


// CCParkingCfgDlg Ϣ

BOOL CCParkingCfgDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ڴӶĳʼ
	m_edit.ShowWindow(SW_HIDE);

	GetDlgItem(IDC_BUTTON_PARK_ADDSPACE)->ShowWindow(SW_HIDE);
	GetDlgItem(IDC_BUTTON_PARK_DELESPACE)->ShowWindow(SW_HIDE);

	m_ComboxCatorMode.InsertString(0, "Device Control");
	m_ComboxCatorMode.InsertString(1, "SDK Control");
	m_ComboxCatorMode.SetCurSel(0);

	m_ComboxCatorColor.InsertString(0, "Red");
	m_ComboxCatorColor.InsertString(1, "Yellow");
	m_ComboxCatorColor.InsertString(2, "Green");
	m_ComboxCatorColor.InsertString(3, "Blue");
	m_ComboxCatorColor.InsertString(4, "Purple");
	m_ComboxCatorColor.InsertString(5, "Cyan");
	m_ComboxCatorColor.InsertString(6, "White");
	m_ComboxCatorColor.SetCurSel(0);

	m_ComboxCatorStatus.InsertString(0, "Off");
	m_ComboxCatorStatus.InsertString(1, "Steady On");
	m_ComboxCatorStatus.InsertString(2, "Blinks");
	m_ComboxCatorStatus.SetCurSel(0);

	CRect rect;  
	m_ParkingSpaceCfgCtrl.GetClientRect(&rect); 

	m_ParkingSpaceCfgCtrl.SetExtendedStyle(m_ParkingSpaceCfgCtrl.GetExtendedStyle() | LVS_EX_FULLROWSELECT | LVS_EX_GRIDLINES);  
	m_ParkingSpaceCfgCtrl.InsertColumn(0,"No.", LVCFMT_LEFT, rect.Width()/3,0);
	m_ParkingSpaceCfgCtrl.InsertColumn(0,"Area No.", LVCFMT_LEFT, rect.Width()/3,0);
	m_ParkingSpaceCfgCtrl.InsertColumn(0,"Space No.", LVCFMT_LEFT, rect.Width()/3,0);

	return TRUE;  // return TRUE unless you set the focus to a control
	// 쳣: OCX ҳӦ FALSE
}


void CCParkingCfgDlg::OnNMDblclkListParkSpace(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMITEMACTIVATE pNMItemActivate = reinterpret_cast<LPNMITEMACTIVATE>(pNMHDR);
	// TODO: ڴӿؼ֪ͨ
	CRect RcEdit;
	if(pNMItemActivate->iItem != -1)
	{
		m_row = pNMItemActivate->iItem;
		m_colunm = pNMItemActivate->iSubItem;

		m_ParkingSpaceCfgCtrl.GetSubItemRect(pNMItemActivate->iItem,pNMItemActivate->iSubItem,LVIR_LABEL,RcEdit);

		m_edit.SetRect(&RcEdit);
		CRect offset;
        m_ParkingSpaceCfgCtrl.GetWindowRect(&offset);
		ScreenToClient(&offset);
		m_edit.MoveWindow(offset.TopLeft().x + RcEdit.TopLeft().x + 2,offset.TopLeft().y + RcEdit.TopLeft().y + 2, RcEdit.Width(),RcEdit.Height());

		CHAR *szText = new CHAR[128];
		m_ParkingSpaceCfgCtrl.GetItemText(pNMItemActivate->iItem,pNMItemActivate->iSubItem,szText,128);
		m_edit.SetWindowText(szText);
		m_edit.ShowWindow(TRUE);
		m_edit.SetFocus();
		m_edit.CreateSolidCaret(1,RcEdit.Height()-5);
		m_edit.ShowCaret();
		m_edit.SetSel(-1);
	}

	*pResult = 0;
}

void CCParkingCfgDlg::OnEnKillfocusEditParkingctrl()
{
	// TODO: ڴӿؼ֪ͨ
	CString str;
	m_edit.GetWindowText(str);
	m_ParkingSpaceCfgCtrl.SetItemText(m_row,m_colunm,str);
	m_edit.ShowWindow(SW_HIDE);
}

void CCParkingCfgDlg::GetParkingSpacecfg()
{

	m_ParkingSpaceCfgCtrl.DeleteAllItems();

	CString strError;
	INT32 dwBytesReturned = 0;
	NETDEV_ITS_PARKING_DETECTION_S stItsParkingDetectionCfg;
	memset(&stItsParkingDetectionCfg, 0, sizeof(NETDEV_ITS_PARKING_DETECTION_S));

	BOOL bRet = NETDEV_GetDevConfig(m_lpDevHandle, m_lChannelID, NETDEV_GET_CARPORTCFG_EX, &stItsParkingDetectionCfg, sizeof(NETDEV_ITS_PARKING_DETECTION_S), &dwBytesReturned);
	if (TRUE != bRet)
	{
		strError.Format("Get NETDEV_GET_CARPORTCFG_EX fail, error code:%d", bRet);
		AfxMessageBox(strError);
		return;
	}

	INT32 dwId = 0; 
	for(int i = 0; i < stItsParkingDetectionCfg.ulCarParkNums; i++)
	{
		if(1 == stItsParkingDetectionCfg.astParkingSpacesInfo[i].ulParkingDetstaus)
		{
			CString strTmp;
			m_ParkingSpaceCfgCtrl.InsertItem(dwId,"");
			strTmp.Format("%d", stItsParkingDetectionCfg.astParkingSpacesInfo[i].ulParkingLotID + 1);
			m_ParkingSpaceCfgCtrl.SetItemText(dwId,0,strTmp);
			m_ParkingSpaceCfgCtrl.SetItemText(dwId,1,stItsParkingDetectionCfg.astParkingSpacesInfo[i].szAreaDesc);
			m_ParkingSpaceCfgCtrl.SetItemText(dwId,2,stItsParkingDetectionCfg.astParkingSpacesInfo[i].szCustomSpaceDescID);
 
            dwId++;
		}
	}
}


void CCParkingCfgDlg::OnBnClickedButtonGetParkingcfg()
{
	// TODO: ڴӿؼ֪ͨ
    GetParkingSpacecfg();
	return;
}

void CCParkingCfgDlg::OnBnClickedButtonParkCatorcontrol()
{
	// TODO: ڴӿؼ֪ͨ
	CString strTmp;

	NETDEV_CARPORT_CONTROLLED_S stCarportControlled;

    int dwSelectIndex = m_ComboxCatorMode.GetCurSel();
	stCarportControlled.ulControlMode = dwSelectIndex;

	dwSelectIndex = m_ComboxCatorColor.GetCurSel();
	stCarportControlled.stCurrLEDCfg.ulLEDColour = dwSelectIndex + 1;

	dwSelectIndex = m_ComboxCatorStatus.GetCurSel();
	stCarportControlled.stCurrLEDCfg.ulLEDStatus = dwSelectIndex;

	INT32 iRet = NETDEV_SetBuiltinIndicatorCtrl(m_lpDevHandle, (LPNETDEV_CARPORT_CONTROLLED_S)&stCarportControlled);
	if (0 == iRet)
	{
		MessageBox("Set BuiltinIndicator Ctrl succeed.");
	}
	else
	{
		MessageBox("Set BuiltinIndicator Ctrl fail.");
	}



}

void CCParkingCfgDlg::OnBnClickedButtonParkCatorstatus()
{
	// TODO: ڴӿؼ֪ͨ
	NETDEV_CARPORT_CONTROLLED_S stCarportControlled;

	INT32 iRet = NETDEV_GetBuiltinIndicatorCtrl(m_lpDevHandle, (LPNETDEV_CARPORT_CONTROLLED_S)&stCarportControlled);
	if (0 == iRet)
	{
		m_ComboxCatorMode.SetCurSel(stCarportControlled.ulControlMode);
		m_ComboxCatorColor.SetCurSel(stCarportControlled.stCurrLEDCfg.ulLEDColour - 1);
		m_ComboxCatorStatus.SetCurSel(stCarportControlled.stCurrLEDCfg.ulLEDStatus);
	}
	else
	{
		MessageBox("Get BuiltinIndicator Ctrl fail.");
		return;
	}

	 UpdateData(TRUE);

	 return;
}
