
// NETSDKDemo3.0.3.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "NETSDKDemo3.0.3.h"
#include "NETSDKDemo3.0.3Dlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CNETSDKDemo303App
bool MBToUTF8(const CHAR *pszMultiText, CHAR *pszUtf8Text, INT32 dwBufferSize);
bool UTF8ToMB(const CHAR *pszUtf8Text, CHAR *pszMultiText, INT32 dwBufferSize);

BEGIN_MESSAGE_MAP(CNETSDKDemo303App, CWinApp/*Ex*/)
	ON_COMMAND(ID_HELP, &CWinApp::OnHelp)
END_MESSAGE_MAP()

// CNETSDKDemo303App construction

bool UTF8ToMB(const CHAR *pszUtf8Text, CHAR *pszMultiText, INT32 dwBufferSize)
{
	/* UTF-8 -> Unicode */
	INT32 dwSize = ::MultiByteToWideChar(CP_UTF8, 0, pszUtf8Text, dwBufferSize, NULL, 0);
	if (0 == dwSize)
	{
		return false;
	}

	wchar_t* wszBuffer = new wchar_t[dwSize + 1];
	::ZeroMemory(wszBuffer, (dwSize + 1) * sizeof(wchar_t));
	if (0 == ::MultiByteToWideChar(CP_UTF8, 0, pszUtf8Text, -1, wszBuffer, dwSize + 1))
	{
		delete[] wszBuffer;
		return false;
	}

	/* Unicode -> Multi byte */
	dwSize = ::WideCharToMultiByte(CP_ACP, 0, wszBuffer, -1, NULL, 0, NULL, NULL);
	if (0 == dwSize)
	{
		delete[] wszBuffer;
		return false;
	}
	char* szBuffer = new char[dwSize + 1];
	::ZeroMemory(szBuffer, (dwSize + 1) * sizeof(char));
	if (0 == ::WideCharToMultiByte(CP_ACP, 0, wszBuffer, -1, szBuffer, dwSize + 1, NULL, NULL))
	{
		delete[] wszBuffer;
		delete[] szBuffer;
		return false;
	}
	strncpy(pszMultiText, szBuffer, dwBufferSize);
	delete[] wszBuffer;
	delete[] szBuffer;
	return true;
}

bool MBToUTF8(const CHAR *pszMultiText, CHAR *pszUtf8Text, INT32 dwBufferSize)
{
	/* Multi byte -> Unicode*/
	INT32 dwSize = ::MultiByteToWideChar(CP_ACP,  0, pszMultiText, -1, NULL,0);
	if (0 == dwSize)
	{
		return false;
	}

	wchar_t* wszBuffer = new wchar_t[dwSize + 1];
	::ZeroMemory(wszBuffer, (dwSize + 1) * sizeof(wchar_t));
	if (0 == ::MultiByteToWideChar(CP_ACP, 0, pszMultiText, -1, wszBuffer, dwSize + 1))
	{
		delete[] wszBuffer;
		return false;
	}

	/*Unicode->UTF8*/
	dwSize = ::WideCharToMultiByte(CP_UTF8, 0, wszBuffer, -1, NULL,0,NULL,NULL);
	if (0 == dwSize)
	{
		delete[] wszBuffer;
		return false;
	}
	char* szBuffer = new char[dwSize + 1];
	::ZeroMemory(szBuffer, (dwSize + 1) * sizeof(char));
	if (0 == ::WideCharToMultiByte(CP_UTF8,0,wszBuffer,-1,szBuffer, dwSize + 1, NULL, NULL))
	{
		delete[] wszBuffer;
		delete[] szBuffer;
		return false;
	}

	strncpy(pszUtf8Text, szBuffer, dwBufferSize);
	delete[] wszBuffer;
	delete[] szBuffer;
	return true;
}

CNETSDKDemo303App::CNETSDKDemo303App()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}


// The one and only CNETSDKDemo303App object

CNETSDKDemo303App theApp;

LONG m_lChannelID = 1;
LPVOID m_lpDevHandle = NULL;
LPVOID m_lpPlayHandle = NULL;
LPVOID m_lpPicHandle = NULL;
LPVOID m_lpTmsPicHandle = NULL;
LPVOID glParkDlg = NULL;
CStatic m_hVid;
CStatic m_hPic;
extern CHAR gszCurrentDir[MAX_PATH]={0};


// CNETSDKDemo303App initialization

BOOL CNETSDKDemo303App::InitInstance()
{
	// InitCommonControlsEx() is required on Windows XP if an application
	// manifest specifies use of ComCtl32.dll version 6 or later to enable
	// visual styles.  Otherwise, any window creation will fail.
	INITCOMMONCONTROLSEX InitCtrls;
	InitCtrls.dwSize = sizeof(InitCtrls);
	// Set this to include all the common control classes you want to use
	// in your application.
	InitCtrls.dwICC = ICC_WIN95_CLASSES;
	InitCommonControlsEx(&InitCtrls);

	CWinApp/*Ex*/::InitInstance();

	AfxEnableControlContainer();

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	// of your final executable, you should remove from the following
	// the specific initialization routines you do not need
	// Change the registry key under which our settings are stored
	// TODO: You should modify this string to be something appropriate
	// such as the name of your company or organization
	SetRegistryKey(_T("Local AppWizard-Generated Applications"));

	CNETSDKDemoDlg dlg;
	m_pMainWnd = &dlg;
	INT_PTR nResponse = dlg.DoModal();
	if (nResponse == IDOK)
	{
		// TODO: Place code here to handle when the dialog is
		//  dismissed with OK
	}
	else if (nResponse == IDCANCEL)
	{
		// TODO: Place code here to handle when the dialog is
		//  dismissed with Cancel
	}

	// Since the dialog has been closed, return FALSE so that we exit the
	//  application, rather than start the application's message pump.
	return FALSE;
}
