#ifndef _NETDEV_H_
#define _NETDEV_H_

#ifdef  __cplusplus
extern "C"{
#endif

#ifndef STATIC
    #define STATIC                  static NETDEV_ACCESS_PROTOCOL_E
#endif

#ifndef CONST
    #define CONST                   const
#endif

#ifndef EXTERN
    #define EXTERN                  extern
#endif

#ifndef INLINE
    #define INLINE                  __inline
#endif

#ifndef UNION
    #define UNION                   union
#endif

#ifndef IN
    #define IN
#endif

#ifndef OUT
    #define OUT
#endif

#ifndef INOUT
    #define INOUT
#endif

#ifndef NEWINTERFACE
    #define NEWINTERFACE
#endif

#if defined(WIN32)  /* windows */
#define NETDEV_API
#else
#define NETDEV_API
#endif

/* ׼Լ Standard function calling convention */
#ifdef i386
    #ifdef LINUX
        #ifndef STDCALL
        #define STDCALL                 __attribute__((stdcall))__attribute__((visibility ("default")))
        #endif
    #else
        #ifndef STDCALL
        #define STDCALL                 __attribute__((stdcall))
        #endif
    #endif
#else
    #ifdef WIN32
        #ifndef STDCALL
        #define STDCALL                 __stdcall
        #endif
    #else
        #ifdef LINUX
            #ifndef STDCALL
            #define STDCALL                 __attribute__((stdcall))__attribute__((visibility ("default")))
            #endif
        #else
            #ifndef STDCALL
            #define STDCALL
            #endif
        #endif
    #endif
#endif


#ifndef UCHAR_DEF
#define UCHAR_DEF
    typedef unsigned char           UCHAR;
#endif

#ifndef CHAR_DEF
#define CHAR_DEF
    typedef char                    CHAR;
#endif

#ifndef BYTE_DEF
#define BYTE_DEF
    typedef unsigned char           BYTE;
#endif

#ifndef UINT16_DEF
#define UINT16_DEF
    typedef unsigned short          UINT16;
#endif

#ifndef UINT_DEF
#define UINT_DEF
    typedef unsigned int            UINT32;
#endif

#ifndef INT16_DEF
#define INT16_DEF
    typedef  short                  INT16;
#endif

#ifndef INT32_DEF
#define INT32_DEF
    typedef  int                    INT32;
#endif

#ifndef LPVOID_DEF
#define LPVOID_DEF
    typedef void*                   LPVOID;
#endif

#ifndef VOID
#ifndef VOID_DEF
#define VOID_DEF
    typedef void                    VOID;
#endif
#endif

#ifndef INT64_DEF
#define INT64_DEF
    typedef long long               INT64;
#endif

#ifndef BOOL_DEF
#define BOOL_DEF
    #ifndef __OBJC__
        typedef int                 BOOL;
    #else
        #import<objc/objc.h>
    #endif
#endif

#ifndef FLOAT
#ifndef VOID_FLOAT
#define VOID_FLOAT
    typedef float                   FLOAT;
#endif
#endif

#ifndef DOUBLE
#ifndef DOUBLE_DEF
#define DOUBLE_DEF
    typedef double                   DOUBLE;
#endif
#endif

#ifndef FALSE
    #define FALSE                   0
#endif

#ifndef TRUE
    #define TRUE                    1
#endif

#ifndef WIN32
    typedef LPVOID                 HWND;
#endif


/************************************************************************/
/*                     ģ궨                                 */
/************************************************************************/
#ifndef NETDEV_SDK_NO_MEDIA
#define NETDEV_WITH_MEDIA           1           /* ýģ */
#endif

#define NETDEV_WITH_CLOUD           1           /* Ʒģ */
#define NETDEV_WITH_XW              1           /* ǽƴģ */
#define NETDEV_WITH_VMS             1           /* VMSģ */
#define NETDEV_WITH_PTZ             1           /* ̨ģ */
#define NETDEV_WITH_SMART           1           /* ҵģ */
#define NETDEV_WITH_CONFIG          1           /* ҵģ */
#define NETDEV_WITH_BASIC           1           /* ҵģ */
#define NETDEV_ALARM_RECOVER_BASE   1           /* 澯ָ Alarm recover base */
#define NETDEV_WITH_TRANS_CHANEL    1           /* ͸ͨģ */

/********************************** ֵ  Commonly used numerical macros *************** */
#define NETDEV_STREAM_ID_LEN                    32          /* IDʶ  Length of stream ID*/
#define NETDEV_FILE_NAME_LEN                    (256u)      /* ļ  Length of filename */
#define NETDEV_USERNAME_LEN                         (128 + 4)   /* Maximum length of username */
#define NETDEV_PASSWORD_LEN                         128         /* Maximum length of password */
#define NETDEV_DESCRIBE_MAX_LEN                     (512 + 4)   /* 󳤶 128 * 4ַﵽ128 */
#define NETDEV_DOMAIN_LEN                       64          /* 󳤶  Maximum length of domain name */
#define NETDEV_PATH_LEN                         128         /* ·󳤶:ļ  Maximum length of path, including filename */
#define NETDEV_MAX_URL_LEN                      512         /* URL 󳤶  Maximum length of URL */

/* ͨó  Common length */
#define NETDEV_LEN_2                            2
#define NETDEV_LEN_4                            4
#define NETDEV_LEN_6                            6
#define NETDEV_LEN_8                            8
#define NETDEV_LEN_16                           16
#define NETDEV_LEN_32                           32
#define NETDEV_LEN_40                           40
#define NETDEV_LEN_64                           64
#define NETDEV_LEN_128                          128
#define NETDEV_LEN_132                          132
#define NETDEV_LEN_256                          256
#define NETDEV_LEN_260                          260
#define NETDEV_LEN_480                          480
#define NETDEV_LEN_512                          512
#define NETDEV_LEN_1024                         1024
#define NETDEV_LEN_2000                         2000
#define NETDEV_LEN_4096                         4096
#define NETDEV_LEN_8192                         8192

#define NETDEV_IPADDR_STR_MAX_LEN              (64u)        /* IP ַϢַ  Length of IP address string */
#define NETDEV_IPV4_LEN_MAX                     16          /* IPV4ַַ Length of IPV4 address string */
#define NETDEV_IPV6_LEN_MAX                     128         /* IPV6ַַ Length of IPV6 address string */
#define NETDEV_NAME_MAX_LEN                    (256u)       /* ַͨ  Length of common name string */

#define NETDEV_CODE_STR_MAX_LEN                (256u)       /* ͨCODE   Length of common code */
#define NETDEV_MAX_DATE_STRING_LEN             (64u)        /* ַ Maximum length of date string "2008-10-02 09:25:33.001 GMT" */
#define NETDEV_MAX_ALARM_IN_NUM                 64          /* 澯  Maximum number of alarm inputs */
#define NETDEV_MAX_ALARM_OUT_NUM                64          /* 澯  Maximum number of alarm outputs */
#define NETDEV_PLAN_SECTION_NUM                 8           /* һеļƻʱ  Number of scheduled time sections in a day */
#define NETDEV_PLAN_NUM_AWEEK                   8           /* һܹõļƻ,һպͼ  Total number of plans allowed in a week, including Monday to Sunday, and holidays */

#define NETDEV_MAX_PRESET_NUM                   256         /* Ԥλ  Maximum number of presets */
#define NETDEV_MAX_CRUISEPOINT_NUM              32          /* Ѳ·Ԥλ  Maximum number of presets for preset patrol */
#define NETDEV_MAX_CRUISEROUTE_NUM              16          /* ԤλѲ·  Maximum number of routes for preset patrol */
#define NETDEV_MIN_PTZ_SPEED_LEVEL              1           /* ̨ƶСٶ  Maximum PTZ rotating speed */
#define NETDEV_MAX_PTZ_SPEED_LEVEL              9           /* ̨ƶٶ  MinimumPTZ rotating speed */
#define NETDEV_MAX_VIDEO_EFFECT_VALUE           255         /* ͼ Աȶ ɫ Ͷȣֵ  Maximum values for image parameters (brightness, contrast, hue, saturation) */
#define NETDEV_MIN_VIDEO_EFFECT_VALUE           0           /* ͼ Աȶ ɫ ͶȣСֵ  Minimum values for image parameters (brightness, contrast, hue, saturation) */
#define NETDEV_MAX_VIDEO_EFFECT_GAMMA_VALUE     10          /* ͼ٤ֵֵ Minimum values for image parameters (Gama) */

#define NETDEV_MAX_PRIVACY_MASK_AREA_NUM        8           /* ڸ  Maximum number of privacy mask areas allowed */
#define NETDEV_OSD_TEXTOVERLAY_NUM              6           /* ͨ OSD ַ  Number of OSD text overlays */
#define NETDEV_OSD_TEXT_MAX_LEN                 (64 + 4)    /* ͨ OSD ַ  Length of OSD texts */
#define NETDEV_OSD_TYPE_MAX_NUM                 26          /* ͨ OSD ͸  Maximum number of OSD type */
#define NETDEV_OSD_FONT_SIZE_TYPE_MAX_NUM       4           /* ͨ OSD ͸  Maximum number of OSD font size type */
#define NETDEV_OSD_FONT_STYLE_TYPE_MAX_NUM      4           /* ͨ OSD ʽ͸  Maximum number of OSD font style type */
#define NETDEV_OSD_TIME_FORMAT_MAX_NUM          7           /* ͨ OSD ʱʽ  Maximum number of OSD time format type */
#define NETDEV_OSD_DATE_FORMAT_MAX_NUM          15          /* ͨ OSD ڸʽ  Maximum number of OSD date format type */
#define NETDEV_PULL_ALARM_MAX_NUM               8           /* 澯澯  Maximum number of alarms a user can get */
#define NETDEV_TRACK_CRUISE_MAXNUM              1           /* ֵ֧Ĺ켣Ѳ  Maximum number of patrol routes allowed  */
#define NETDEV_AUDIO_SOUND_MIN_VALUE            0           /* Сֵ  Minimum volume */
#define NETDEV_AUDIO_SOUND_MAX_VALUE            255         /* ֵ  Maximum volume */
#define NETDEV_MIC_SOUND_MIN_VALUE              0           /* ˷Сֵ  Minimum volume */
#define NETDEV_MIC_SOUND_MAX_VALUE              255         /* ˷ֵ  Maximum volume */
#define NETDEV_SCREEN_INFO_ROW                  18          /* ĻϢ  Screen Info Row */
#define NETDEV_SCREEN_INFO_COLUMN               22          /* ĻϢ  Screen Info Column */
#define NETDEV_CHANNEL_MAX                      512         /* ͨ Maximum number of channel */
#define NETDEV_RESOLUTION_NUM_MAX               32          /* ֱܸ Maximum number of resolution */
#define NETDEV_MONTH_DAY_MAX                    31          /* ÿֵ Maximum number of days in a month */
#define NETDEV_VIDEO_ENCODE_TYPE_MAX            16          /* ʽܸ Maximum number of encode type */
#define NETDEV_PEOPLE_CNT_MAX_NUM               60          /* ͳֱֵ Maximum number of people count */
#define NETDEV_WIFISNIFFER_MAC_MAX_NUM          64          /* wifi sniffer MACַ󳤶  Length of wifi sniffer MAC */
#define NETDEV_WIFISNIFFER_MAC_ARRY_MAX_NUM     128         /* wifi sniffer MACֵַ Maximum number of wifi sniffer MAC array */
#define NETDEV_DISK_MAX_NUM                     256         /*  Maximum number of Disk */
#define NETDEV_LOCAL_DISK_MAX_NUM               32          /* ش local Maximum number of Disk */
#define NETDEV_SD_CARD_DISK_MAX_NUM             16          /* SD SD Maximum number of Disk */
#define NETDEV_ARRAY_MAX_NUM                    16          /*  array Maximum number of Disk */
#define NETDEV_EXTEND_CABINET_DISK_MAX_NUM      32          /* չӲ extend cabinet Maximum number of Disk */
#define NETDEV_NAS_MAX_NUM                      16          /* NAS NAS Maximum number of Disk */
#define NETDEV_ESATA_MAX_NUM                    4           /* ESATA eSATA Maximum number of Disk */
#define NETDEV_DISK_SMART_MAX_NUM               128         /* ӲSMARTϢ Maximum number of Disk Smart Info */
#define NETDEV_ENCODE_FORMAT_MAX_NUM            3           /* Ƶʽ Maximum number of video compression */
#define NETDEV_SMART_ENCODE_MODEL_MAX_NUM       3           /* ͼչģʽ Maximum number of smart image encoding mode */
#define NETDEV_GOP_TYPE_MAX_NUM                 4           /* GOP Maximum number of GOP type */
#define NETDEV_IPSAN_MAX_NUM                    4           /* IPSAN IPSAN Maximum number of Disk */

#define NETDEV_PHOTO_SERVER_MAX_NUM             4           /* Ƭ Maximum number of Photo Server */

#define NETDEV_INTELLIGENT_SERVER_MAX_NUM       4           /* ܷ Maximum number of Intelligent Server */

#define NETDEV_MANAGER_SERVER_MAX_NUM           4           /*  Maximum number of Manager Server */

#define NETDEV_DEV_OTHER_LEN_MAX                32          /* ֶ */
#define NETDEV_DEV_NAME_LEN_MAX                 64          /* 豸Ƴ */

#define NETDEV_DEV_PASSWORD_LEN_MAX             64          /* 豸볤 */
#define NETDEV_CLOUD_DEV_USER_NAME_LEN          260         /* ƶ豸ID */
#define NETDEV_CLOUD_USER_NAME_LEN              260         /* ƶû */
#define NETDEV_CLOUD_DEV_USER_AUTH_LEN          260         /* ƶ豸ûȨƳ */
#define NETDEV_CLOUD_SHARE_TARGET_NAME_LEN      64          /* ƶ豸Ƴ */
#define NETDEV_CLOUD_SHARE_DESCRIBE_LEN         260         /* ƶ豸 */
#define NETDEV_CLOUD_DEV_NAME_LEN               260         /* ƶ豸Ƴ */
#define NETDEV_XW_MAX_PANE_NUM                  64          /*  */
#define NETDEV_NTP_SERVER_LIST_NUM              5           /* NTPб */

#define NETDEV_TMS_FACE_RECORD_ID_LEN           32          /* ¼ID泤 */
#define NETDEV_TMS_CAMER_ID_LEN                 32          /* ID泤 */
#define NETDEV_TMS_PASSTIME_LEN                 32          /* ͨʱַ泤 */
#define NETDEV_TMS_FACE_TOLLGATE_ID_LEN         32          /* ڱŻ泤 */
#define NETDEV_TMS_HEAT_MAP_DEVID_LEN           32          /*ȶͼDevIDֶγ*/
#define NETDEV_TMS_HEAT_MAP_RECORD_ID_LEN       16          /*ȶͼRecordIDֶγ*/
#define NETDEV_TMS_HEAT_MAP_COllECT_TIME_LEN    18          /*ȶͼCollectTime ֶγ*/
#define NETDEV_TMS_PIC_COMMON_NUM               10          /*ͼƬ޸*/
#define NETDEV_TMS_CAR_PLATE_CAMID_LEN          32          /*ʶCamIDֶγ*/
#define NETDEV_TMS_CAR_PLATE_RECORDID_LEN       32          /*ʶRecordIDֶγ*/
#define NETDEV_TMS_CAR_PLATE_TOLLGATE_LEN       32          /*ʶTollgateIDֶγ*/
#define NETDEV_TMS_CAR_PLATE_PASSTIME_LEN       18          /*ʶPassTimeֶγ*/
#define NETDEV_TMS_CAR_PLATE_LANEID_LEN         18           /*ʶLaneIDֶγ*/
#define NETDEV_TMS_CAR_PLATE_CARPLATE_LEN       32          /*ʶCarPlateֶγ*/
#define NETDEV_USER_NAME_ENCRYPT_LEN            256         /* ܺû */
#define NETDEV_PASSWORD_ENCRYPT_LEN             256         /* ܺ볤 */
#define NETDEV_VIDEO_FORMAT_MAX                 32          /* ֵ֧Ƶʽ */
#define NETDEV_VIDEO_FORMAT_NAME_LEN            32          /* ֵ֧ƵʽƳ */
#define NETDEV_TVWALL_NAME_LEN                  260         /* ǽƳ */
#define NETDEV_FORMAT_SPEC_MAX                  256         /* ʽ */
#define NETDEV_LED_SPEC_MAX                     256         /* ģ */
#define NETDEV_FORMAT_NAME_LEN                  32          /* ʽƳ */
#define NETDEV_VIDEO_OUT_MAX                    64          /* ˿ڵ */
#define NETDEV_SCENE_NAME_LEN                   260         /* Ƴ */
#define NETDEV_TIME_LEN                         16          /* ʱַ */
#define NETDEV_WND_NAME_LEN                     260         /* Ƴ */
#define NETDEV_SEQUENCE_SRC_MAX                 128         /* ѲʱƵԴ */
#define NETDEV_TEXT_LEN                         1024        /* LEDݳ */
#define NETDEV_BMAP_NAME_LEN                    256         /* ͼƳ */
#define NETDEV_SEQ_RES_WIN_MAX                  288         /* ѲԴдڵ */
#define NETDEV_MAX_DAY_NUM                      8           /*  */
#define NETDEV_MAX_TIME_SECTION_NUM             8           /* ʱ */

#define NETDEV_ALARM_SOURCE_MAX_LEN                 (64 + 4)    /* 澯Դַ */
#define NETDEV_MAX_EVENT_RES_SIZE                   1024        /* ¼ϱԴ */

#define NETDEV_VIID_CODE_LEN                        48          /* ͼ볤 */
#define NETDEV_VIDEO_FORMAT_CAP_NUM                 64          /* ʽ */
#define NETDEV_LAYOUT_CAP_NUM                       64          /*  */

#define NETDEV_DA_POINT_CODE_LEN                    48          /* 豸 λ 볤 */
#define NETDEV_DA_AREA_CODE_LEN                     48          /* 豸  볤 */
#define NETDEV_VIRTUAL_MEM_TABLE_MAX                32          /* ڴԪ */
#define NETDEV_EVENT_STORE_TYPE_NUM                 128         /* ʱ洢 */
#define NETDEV_MAX_PANE_NUM                         36          /* DCҵΪ36 */
#define NETDEV_OSD_MAX_NUM_EX                       8           /* ͨ OSD   Maximum Number of OSD */
#define NETDEV_RSA_MAX_VALUE                        3           /* ʾೢԿɴ */

#define NETDEV_MAX_VIDEO_BRIGHT_EFFECT_VALUE        199             /* ͼȣֵ */
#define NETDEV_MAX_VIDEO_CONTRAST_EFFECT_VALUE      199             /* ͼԱȶȣֵ */
#define NETDEV_MAX_VIDEO_SATURATION_EFFECT_VALUE    359             /* ͼͶȣֵ */
#define NETDEV_MAX_VIDEO_HUE_EFFECT_VALUE           359             /* ͼɫȣֵ */
#define NETDEV_MAX_VIDEO_GAMMA_EFFECT_VALUE         99              /* ͼ٤ֵ꣩ */
#define NETDEV_PIXEL_CONVERT_RATIO                  5000            /* ת ,Ŵ */
#define NETDEV_PANES_NUM                            16              /* ͨ */

#define NETDEV_XW_AUDIO_NUM                         16              /* Ƶͨ */
#define NETDEV_IP_ADDRESS_LEN                       64              /* IPַ */

#define NETDEV_TVWALLPLAN_NUM                       4               /* ǽԤ */
#define NETDEV_PLAN_MAX_TVWALL_NUM                  4               /* Ԥµǽ */
#define NETDEV_TVWALL_MAX_WIN_NUM                   81              /* ǽĴ */
#define NETDEV_TVWALL_MAX_LAYOUT_NUM                64              /* ǽķ,ΪӴ */
#define NETDEV_ALARM_LINK_PRESET_NUM                16              /* 澯ԤԤλ  */
#define NETDEV_ALARM_LINK_SWITCHOUT_NUM             16              /* 澯Ԥ澯ͨ */
#define NETDEV_ALARM_LINK_MONITOR_NUM               16              /* 澯Ԥʵ */
#define NETDEV_ALARM_LINK_TVWALL_NUM                32              /* 澯Ԥǽ*/
#define NETDEV_ALARM_LINK_SOUND_LEN                 512             /* 澯ԤϢ󳤶 */
#define NETDEV_ALARM_SOURCE_NUM                     1               /* 澯Դ */
#define NETDEV_ALARM_LINK_NUM                       128             /* 澯Ԥ */

#define NETDEV_TIME_TEMPLATE_NUM                    32              /* ʱģ */
#define NETDEV_DC_SCHEME_RES_CHN_MAX_NUM            256             /* DCѲԴ */
#define NETDEV_VIEW_MAX_WIN_NUM                     100             /* ͼĴ */
#define NETDEV_MAX_ROLE_RIGHT_SIZE                  256             /* ûȨ޲˵ */
#define NETDEV_MAX_ALARM_TASK_SIZE                  128             /* 澯 */
#define NETDEV_MAX_QUERY_CHANNEL_NUM                500             /* βѯͨ */
#define NETDEV_MAX_QUERY_DEV_NUM                    500             /* βѯ豸 */
#define NETDEV_GRID_AREAS_LEN                       256             /* ֵ鳤 */
#define NETDEV_MAX_ORG_ROOT_ID_NUM                  32              /* ֯ڵ */
#define NETDEV_VOICE_BROADCAST_CHANNEL_NUM_MAX      128             /* һ㲥֧ͨ */
#define NETDEV_RECORD_LOCK_ID_LEN                   64              /* ¼ID󳤶 */
#define NETDEV_RECORD_LOCK_DESC_LEN                 64              /* ¼ε󳤶 */
#define NETDEV_NOTIME                               0               /* ʱֵ */
#define NETDEV_WHITE_BALANCE_MODE_MAX_NUM           16              /* ֵ֧İƽģʽ Maximum number of Image white balance mode count */
#define NETDEV_FOCUS_MODE_MAX_NUM                   16              /* ֵ֧ĶԽģʽ Maximum number of Image focus mode count */
#define NETDEV_FOCUS_SCENE_MAX_NUM                  16              /* ֵ֧ĶԽ Maximum number of Image focus scene count */
#define NETDEV_IMAGE_ROTATION_MODE_MAX_NUM          16              /* ֵ֧ͼģʽ Maximum number of Image rotation mode count */
#define NETDEV_LAMP_CTRL_TYPE_MAX_NUM               16              /* ֵֵ֧֧Ĳ͸ Maximum number of lamp ctrl type count */
#define NETDEV_LAMP_CTRL_MODE_MAX_NUM               16              /* ֵ֧Ĳƿտģʽ Maximum number of lamp ctrl mode count */
#define NETDEV_EXPOSURE_MODE_MAX_NUM                16              /* ֵ֧عģʽ Maximum number of exposure mode count */
#define NETDEV_IRIS_RANGE_MAX_NUM                   16              /* ֵ֧ĹȦȡֵ  Maximum number of Iris Range count */
#define NETDEV_METERING_MODE_MAX_NUM                16              /* ֵ֧Ĳģʽ  Maximum number of Metering mode count */
#define NETDEV_SHUTTER_TIME_RANGE_MAX_NUM           28              /* ֵ֧Ŀʱȡֵĸ  Maximum number of shutter Time Range count */
#define NETDEV_SLOW_SHUTTER_TIME_RANGE_MAX_NUM      16              /* ֵ֧ʱȡֵĸ Maximum number of slow shutter Time Range count */
#define NETDEV_WIDE_DYNAMIC_MODE_MAX_NUM            16              /* ֵ֧Ŀ̬ģʽ Maximum number of wide dynamic mode count */
#define NETDEV_DAY_NIGHT_MODE_MAX_NUM               16              /* ֵ֧ҹģʽ͸ Maximum number of slow Day Night Mode count */
#define NETDEV_AUDIO_IN_MAX_NUM                     16              /* ֵ֧Ƶ Maximum number of Audio input count */
#define NETDEV_AUDIO_IN_CHL_MODE_MAX_NUM            8               /* ֵ֧Ƶͨģʽ Maximum number of Audio input mode count */
#define NETDEV_AUDIO_IN_ENCODE_FORMAT_MAX_NUM       16              /* ֵ֧Ƶʽ Maximum number of Audio input encode format count */
#define NETDEV_AUDIO_SAMPLING_RATE_MAX_NUM          8               /* ֵ֧Ƶʸ Maximum number of Audio sampling rate count */
#define NETDEV_SERIAL_IN_MAX_NUM                    16              /* ֵ֧Ĵ Maximum number of serial input count */
#define NETDEV_SERIAL_IN_ENCODE_FORMAT_MAX_NUM      16              /* ֵ֧Ĵʽ Maximum number of serial input encode format count */
#define NETDEV_FACE_FEATURE_SIZE                    512             /* Ϣ 512B */
#define NETDEV_FACE_FEATURE_VERSION_LEN             40              /* ģͰ汾󳤶 */
#define NETDEV_FACE_FEATURE_LIST_FILE_LEN           256             /* ļ󳤶 */
#define NETDEV_FACE_FEATURE_FILE_MD5_LEN            16              /* ļMD5ֵ */
#define NETDEV_FACE_FEATURE_GALLEY_ID_LEN           20              /* ṹID */
#define NETDEV_FACE_FEATURE_MAX_NUM                 3               /* ṹĿ */
#define NETDEV_OBJ_TRACK_MODE_NUM                   8               /* 豸ֵ֧ܸģʽ */
#define NETDEV_STREAM_MAX_NUM                       3               /* ֵ֧ */
#define NETDEV_PLAN_DAY_NUM_AWEEK                   7               /* һܹõļƻһ */
#define NETDEV_PLAN_TIME_SECTION_NUM_ADAY           4               /* һõʱ Total number of plans allowed in a day*/
#define NETDEV_XW_SERIAL_NUM                        16               /*  */
#define NETDEV_DNS_LIST_NUM                         2               /* DNSб */
#define NETDEV_NETWORK_MACNAME_LEN                  48              /* MACַƳ */
#define NETDEV_LOG_QUERY_COND_NUM                   48              /* ־ѯ */
#define NETDEV_FACE_DB_NAME_LEN                     256             /* Ƴֵ */
#define NETDEV_FACE_MEMBER_NAME_LEN                 256             /* ԱƳֵ */
#define NETDEV_FACE_MEMBER_REGION_LEN               256             /* Աڵֵ */
#define NETDEV_FACE_MEMBER_CUSTOM_NUM               5               /* Զб */
#define NETDEV_FACE_MEMBER_CUSTOM_LEN               255             /* Զֵ */
#define NETDEV_FACE_IMAGE_MAX_LEN                   (2*1024*1024)   /* ͼƬݵ󳤶ȣ2M   2097152ֽ*/
#define NETDEV_FACE_DB_TITLE_NAME_LEN               508             /* Զ󳤶 */
#define NETDEV_FACE_MONITOR_RULE_NAME_LEN           508             /*Ĳֵ */
#define NETDEV_FACE_MONITOR_RULE_REASON_LEN         508             /*صĲԭֵ */
#define NETDEV_FACE_ALARM_SRC_LEN                   256             /* ץͨƳ */
#define NETDEV_FACE_ANALYSIS_SKILL_NUM              16              /* 豸ֵ֧ */
#define NETDEV_FACE_MEMBER_BIRTHDAY_LEN             31              /* Աַ󳤶 */
#define NETDEV_FACE_IDNUMBER_LEN                    128             /*֤Χ*/
#define NETDEV_LABEL_ID_MAX_LEN                     32
#define NETDEV_TIME_RANGE_NUM                       8               /* ʱģʱ䷶Χ(һټӼ) */
#define NETDEV_TIME_DURATION_NUM                    8               /* ʱģһ8Ƭ */
#define NETDEV_HOLIDAY_INFO_NUM                     32              /*  */
#define NETDEV_AUDIO_MAX_NUM                        18              /* Ƶҵ */
#define NETDEV_CREATE_CONNECT_NUMBER                1               /*  */
#define NETDEV_EMERGENCY_BRLL_NAME_LEN              128             /*󳤶*/
#define NETDEV_EMERGENCY_BRLL_MAX_NUM               120             /*Ϣ*/
#define NETDEV_VEHICLE_COMP_IMAGE_MAX_LEN           2097152         /* رȶͼƬ󳤶 2M*/
#define NETDEV_VEHICLE_IMAGE_MAX_LEN                4194304         /* ͼƬֽ 4M */
#define NETDEV_PIC_DATA_MAX_LEN                     (1024*1024)     /* ͼƬϢܺС */

#define NETDEV_RES_CHANGE_INFO_LIST_NUM             64              /* LAPI¼ϱϢṹ */

#define NETDEV_OUTPUT_NI_RECV_CARD_MAX_NUM          64              /* µĽտ */
#define NETDEV_IMG_IN_MODE_LIST_MAX_NUM             16              /* ͼģʽ */
#define NETDEV_GAMMA_INFO_LIST_MAX_NUM              1024            /* ٤ֵ */

#define NETDEV_MAX_SERIAL_PROT_NUM                  1               /* 豸ǰֻһ485 */  
#define NETDEV_MAX_TRANS_CHANEL_NUM                 1               /* һ485Ŀǰֻ֧һ͸ͨ */     

#define NETDEV_MAX_NIC_WORK_MODE_NUM                8               /* ֵ֧Ĺģʽ */  
#define NETDEV_MAX_PORT_WORK_MODE_NUM               24              /* ڹģʽ */    
#define NETDEV_MAX_NET_WORK_CARD_NUM                8               /*  */
#define NETDEV_MAX_LINK_ACTION_NUM                  9               /*  */

#define NETDEV_IVA_REPORT_COORD_NUM                 16              /* һ */

/* ͣơͼƬС λֽ*/
#define NETDEV_VEH_PLATE_IMAGE_LEN              (1024*1024)

/* ͣơܺͼƬС λֽ*/
#define NETDEV_VEH_PLATE_ENCODE_IMAGE_LEN       1400000

#define HTTP_BUF_SUCCESS  "\
HTTP/1.1 200 OK\r\n\
Content-Length: %d\r\n\
Content-Type: application/json;charset=UTF-8\r\n\
\r\n\
%s\r\n\
\r\n"

#define HTTP_BUF_SUCCESS_LINUX  "\
\n\
HTTP/1.1 200 OK\n\
Content-Length: %d\n\
Content-Type: application/json;charset=UTF-8\n\
\n\
%s\n\
\n"

/* BITλ */
#ifndef BIT0
#define BIT0  (0x1 << 0)
#define BIT1  (0x1 << 1)
#define BIT2  (0x1 << 2)
#define BIT3  (0x1 << 3)
#define BIT4  (0x1 << 4)
#define BIT5  (0x1 << 5)
#define BIT6  (0x1 << 6)
#define BIT7  (0x1 << 7)
#define BIT8  (0x1 << 8)
#define BIT9  (0x1 << 9)
#define BIT10 (0x1 << 10)
#define BIT11 (0x1 << 11)
#define BIT12 (0x1 << 12)
#define BIT13 (0x1 << 13)
#define BIT14 (0x1 << 14)
#define BIT15 (0x1 << 15)
#define BIT16 (0x1 << 16)
#define BIT17 (0x1 << 17)
#define BIT18 (0x1 << 18)
#define BIT19 (0x1 << 19)
#define BIT20 (0x1 << 20)
#define BIT21 (0x1 << 21)
#define BIT22 (0x1 << 22)
#define BIT23 (0x1 << 23)
#define BIT24 (0x1 << 24)
#define BIT25 (0x1 << 25)
#define BIT26 (0x1 << 26)
#define BIT27 (0x1 << 27)
#define BIT28 (0x1 << 28)
#define BIT29 (0x1 << 29)
#define BIT30 (0x1 << 30)
#define BIT31 (0x1 << 31)

#define BIT(nr)     (1UL << (nr))
#endif  /* BITλ */

#ifndef BIT32_MAX
    #define BIT32_MAX ((UINT32)(~0UL))
#endif



/* BEGIN****************************  Enum ************************************************************/
typedef enum tagNETDEVCommonErrCode
{
    NETDEV_E_FAILED                         = -1,           /* ʧ  Failed*/
    NETDEV_E_SUCCEED                        = 0,            /* ɹ  Succeeded*/
    NETDEV_E_SVC_FAILED                     = 1,            /* ʧܴ  Common Failed*/
    NETDEV_E_NO_USER                        = 5,            /* û User does not exist*/

    NETDEV_E_NO_RESULT                      = 11,           /* ޽ No result */
    NETDEV_E_NOENOUGH_BUF                   = 12,           /* ̫С: 豸ݵĻ  Buffer is too small for receiving device data */
    NETDEV_E_SDK_SOCKET_LSN_FAIL            = 13,           /* socket listenʧ  Failed to create socket listen */
    NETDEV_E_INIT_MUTEX_FAIL                = 14,           /* ʼʧ  Failed to initialize lock */
    NETDEV_E_INIT_SEMA_FAIL                 = 15,           /* ʼźʧ  Failed to initialize semaphore */
    NETDEV_E_ALLOC_RESOURCE_ERROR           = 16,           /* SDKԴ  Error occurred during SDK resource allocation */
    NETDEV_E_HAVEDATA                       = 17,           /*    Data not all sent */
    NETDEV_E_NEEDMOREDATA                   = 18,           /* Ҫ  More data required  */
    NETDEV_E_TRANSFILE_FAIL                 = 19,           /* ļʧ  File transmission failed */
    NETDEV_E_DEVICE_TYPE_ERR                = 20,           /* ֵ֧豸 Device type that are not supported */
    NETDEV_E_NONCE_TIMEOUT                  = 21,           /* nonce Nonce expired */
    NETDEV_E_INNER_ERR                      = 22,           /* ϵͳڲ System internal error */
    NETDEV_E_BINDNOTIFY_FAIL                = 24,           /* 󶨸澯ʧ  Failed to bind alarms*/

    NETDEV_E_SYSCALL_FALIED                 = 100,          /* ϵͳʧܣ鿴errno  Failed to call system function. See errno */
    NETDEV_E_NULL_POINT                     = 101,          /* ָ  Null pointer */
    NETDEV_E_INVALID_PARAM                  = 102,          /* Ч  Invalid parameter */
    NETDEV_E_INVALID_MODULEID               = 103,          /* ЧģID  Invalid module ID */
    NETDEV_E_INVALID_HANDLE                 = 104,          /* Чľ Invalid handle */
    NETDEV_E_NO_MEMORY                      = 105,          /* ڴʧ Memory allocation failed */
    NETDEV_E_FILE_NO_EXIST                  = 106,          /* ļȲ File does not exist */
    NETDEV_E_NO_DEV                         = 107,          /* 豸 Device does not exist*/
    NETDEV_E_NO_FIT_LOG                     = 108,          /* ־ Qualified logs do not exist*/
    NETDEV_E_BUSY                           = 109,          /* busy״̬ busy status */
    NETDEV_E_TIMER_REG_FAILED               = 110,          /* עᶨʱʧ Register timer failed */
    NETDEV_E_COMMON_FAILED                  = 111,          /* ͨô General error */
    NETDEV_E_CMD_NOT_SUPPORT                = 112,          /* ֧ Command does not support */
    NETDEV_E_NOT_SUPPORT                    = 113,          /* 豸ָ֧ù The device does not support this function */
    NETDEV_E_TIMEOUT                        = 114,          /* ʱ Overtime */
    NETDEV_E_MSG_ERR                        = 115,          /* Ϣƥ Message mismatch */
    NETDEV_E_MODULE_INEXIST                 = 116,          /* ģ鲻 Module does not exist */
    NETDEV_E_SOCKET_RECV_ERR                = 117,          /* Ϣʧ Message acceptance failure */
    NETDEV_E_DECODE_IE_FAILED               = 118,          /* ȡϢIEʧ Failure to get message IE */
    NETDEV_E_ENCODE_IE_FAILED               = 119,          /* ϢIEʧ Failed to add message IE */
    NETDEV_E_SDK_NOINTE_ERROR               = 120,          /* SDKδʼ SDK uninitialized */
    NETDEV_E_ALREDY_INIT_ERROR              = 121,          /* SDKѾʼ SDK has been initialized */
    NETDEV_E_DEVICE_FACTURER_ERR            = 122,          /* ֵ֧豸 Unsupported equipment manufacturer */
    NETDEV_E_NAME_EXIST                     = 123,          /* Ѵ Name already exists */
    NETDEV_E_GET_CFG_FAILED                 = 124,          /* ȡϢ Error acquiring configuration information */
    NETDEV_E_SET_CFG_FAILED                 = 125,          /* Ϣ Error setting configuration information */
    NETDEV_E_CHANNEL_OVER_SPEC              = 126,          /* ͨ Channel number exceeding specification */
    NETDEV_E_CALL_DRV_COMMON                = 127,          /* ͨʧ Call driver universal failure */
    NETDEV_E_TOTAL_QUOTA_FULL               = 128,          /* ɷռ䲻 Insufficient allocatable quota space */
    NETDEV_E_CALL_DB_COMMON                 = 129,          /* ݿͨʧ Failure to invoke database universality */
    NETDEV_E_NEED_MORE_MEMORY               = 130,          /* ڴ䲻 Insufficient memory allocation */
    NETDEV_E_T2U_CONNECT_FAILED             = 131,          /* T2Uʧ Failure of T2U connection */
    NETDEV_E_FUNC_IS_INITIALIZING           = 132,          /* ڳʼ Functions are being initialized */

    NETDEV_E_CONNECT_ERROR                  = 200,          /* ʧ  Failed to create connection */
    NETDEV_E_SEND_MSG_ERROR                 = 201,          /* Ϣʧ Failed to send message */
    NETDEV_E_DECODE_RSP_ERROR               = 202,          /* ӦϢʧ  Failed to decode response message */
    NETDEV_E_NONSUPPORT                     = 203,          /* ùܺδʵ  Function not supported */
    NETDEV_E_JSON_ERROR                     = 204,          /* Json ͨô  Json common error */
    NETDEV_E_NORESULT                       = 205,          /* ѯΪ The query result is empty */
    NETDEV_E_SOCKET_RECV_ERROR              = 206,          /* SocketϢʧ  Socket failed to receive message */
    NETDEV_E_CREATE_THREAD_FAIL             = 207,          /* ߳ʧ  Failed to create thread */
    NETDEV_E_RESCODE_NO_EXIST               = 208,          /* Դ벻  Resource code not exist */
    NETDEV_E_MSG_DATA_INVALID               = 209,          /* Ϣݴ  Incorrect message content */
    NETDEV_E_JSON_NO_IMAGE                  = 210,          /* ͼƬΪ Picture data is empty */

    NETDEV_E_PUBLICKEYFAIL                  = 60068        /* Կƥʧ Failed to match publickey*/

}NETDEV_COMMON_ECODE_E;

/* ýش */
typedef enum tagNETDEVMediaErrCode
{
    NETDEV_E_PLAYER_FAIL                        = 1001,     /* ִʧ Execution failure */
    NETDEV_E_PLAYER_INVALID_PARAM               = 1002,     /* Ƿ Illegal input parameters */
    NETDEV_E_PLAYER_NO_MEMORY                   = 1003,     /* ϵͳڴ治 Insufficient system memory */
    NETDEV_E_PLAYER_SOCKET_FAIL                 = 1004,     /* SOCKETʧ Failure to create SOCKET */
    NETDEV_E_PLAYER_RECV_FAIL                   = 1005,     /* ʧ Failure to receive */
    NETDEV_E_PLAYER_RECV_ZERO                   = 1006,     /* Ϊ Receive zero */
    NETDEV_E_PLAYER_NOT_SUPPORT                 = 1007,     /* ݲ֧ Function not supported for the time being */
    NETDEV_E_PLAYER_CREATETHREAD_FAILED         = 1008,     /* ߳ʧ Failed to create thread */
    NETDEV_E_PLAYER_OPENDL_FAILED               = 1009,     /* ض̬ʧ Failure to load dynamic library */
    NETDEV_E_PLAYER_SYMDL_FAILED                = 1010,     /* ȡ̬ʧ Failure to obtain dynamic methods */
    NETDEV_E_PLAYER_SEND_FAILED                 = 1011,     /* ʧ Fail in send */
    NETDEV_E_PLAYER_EACCES                      = 1012,     /* ļȨ޲ Insufficient permission to create files */
    NETDEV_E_PLAYER_FILE_NOT_FIND               = 1013,     /* ļδҵ Reading file not found */
    NETDEV_E_PLAYER_LOG_CLOSE                   = 1014,     /* ־ر Log closes */
    NETDEV_E_PLAYER_MEDIA_EXCEPTION             = 1017,     /* ڲ쳣 Media exception  */

    /*********************** Player Դ********************************/
    NETDEV_E_FAIL_TO_INIT_EZPLAYER              = 1257,     /* ʼʧ Initialization player failed */
    NETDEV_E_FAIL_TO_ALLOC_PORT_RES             = 1258,     /* 䲥ͨԴʧ Failed to allocate playback channel resources */
    NETDEV_E_FAIL_TO_GET_PORT_RES               = 1259,     /* òͨԴʧ Failed to obtain playback channel resources*/
    NETDEV_E_BUFFER_QUEUE_FULL                  = 1260,     /*  Cache queue full */
    NETDEV_E_BUFFER_QUEUE_EMPTY                 = 1261,     /* п Cache queue empty */
    NETDEV_E_OPEN_FILE_FAILED                   = 1262,     /* ļʧ Fail to open file */
    NETDEV_E_FILE_READ_END                      = 1263,     /* ļѾȡ The file has been read out */
    NETDEV_E_FILE_DISKSPACE_FULL                = 1264,     /* ̿ռ Disk space is full */
    NETDEV_E_FILE_READ_FAIL                     = 1265,     /* ȡʧ Read failure */
    NETDEV_E_MCM_MIC_NOT_EXIST                  = 1266,     /* ˷粻 Microphone does not exist */
    NETDEV_E_TS_PACKET_IN_THE_ROUGH             = 1267,     /* TSδ TS packaging not completed */
    NETDEV_E_FILE_RECORD_FINISH                 = 1268,     /* ¼񱣴 The video has been saved.*/
    NETDEV_E_VIDEO_RESOLUTION_CHANGE            = 1269,     /* ֱʷ仯 Resolution changed */

    NETDEV_E_FAIL_TO_OPEN_STREAM                = 1513,     /* ýʧ Failed to start media stream playback */
    NETDEV_E_FAIL_TO_CLOSE_STREAM               = 1514,     /* رýʧ Failed to shut down media stream playback */
    NETDEV_E_FAIL_TO_RECV_DATA                  = 1515,     /* ϵ½ʧ Failure of receiving data due to network failure */
    NETDEV_E_FAIL_TO_PROCESS_MEDIA_DATA         = 1516,     /* ýݴʧ Media data processing failure */
    NETDEV_E_NOT_START_PLAY                     = 1517,     /* ͨδʼŲ Play channel did not start playback operation */
    NETDEV_E_FAIL_TO_INPUT_DATA                 = 1518,     /* ýʧ Input media streaming data failed */
    NETDEV_E_INPUTDATA_BUFFER_FULL              = 1519,     /* ݻ Input data cached full */
    NETDEV_E_FAIL_TO_SET_PROCESS_DATA_CB        = 1520,     /* ýݻصʧ Failed to set media stream data callback function */
    NETDEV_E_VOICE_RUNNING                      = 1521,     /* ҵйг Errors in Voice Service Operation */
    NETDEV_E_FAIL_TO_OPEN_VOICE_SVC             = 1522,     /* ҵʧ Failure to start voice service */
    NETDEV_E_FAIL_TO_CLOSE_VOICE_SVC            = 1523,     /* رҵʧ Failed to shut down voice service */
    NETDEV_E_UNKNOWN_STREAM_TYPE                = 1524,     /* δ֪ý Unknown media stream */
    NETDEV_E_PACKET_LOSE                        = 1525,     /*  Packet loss */
    NETDEV_E_NEED_MORE_PACKET                   = 1526,     /* ƴδɣҪ Packing is not completed, more packages are needed */
    NETDEV_E_FAIL_TO_CREATE_DECODE              = 1527,     /* ʧ Failed to create decoder */
    NETDEV_E_FAIL_TO_DECODE                     = 1528,     /* ʧ Decoding failure */
    NETDEV_E_RECV_DATA_NOTENOUGH                = 1529,     /* ݲ Insufficient data received */
    NETDEV_E_RENDER_RES_FULL                    = 1530,     /* ʾԴ Display full resources */
    NETDEV_E_RENDER_RES_NOT_EXIST               = 1531,     /* ʾԴ Show that resources do not exist */
    NETDEV_E_CREATE_DEV_FAILED                  = 1532,     /* Դʧ Resource creation failed */
    NETDEV_E_AUDIO_RES_NOT_EXIST                = 1533,     /* ƵԴ Audio resources do not exist */
    NETDEV_E_IHW265D_NEED_MORE_BITS             = 1534,     /* Ҫ Decoder needs more data */
    NETDEV_E_FAIL_TO_CREATE_ENCODE              = 1535,     /* ʧ Failure to create encoder */
    NETDEV_E_CAPTURE_RES_EXIST                  = 1536,     /* ɼԴ Collection resources do not exist */
    NETDEV_E_RECORD_STARTED                     = 1537,     /* ¼Ѵ The video has been turned on */
    NETDEV_E_NEED_WAIT_DECODEC                  = 1538,     /* δɣҪȴ Undecoded, need to wait */
    NETDEV_E_MORE_DATA_NEED_PACKET              = 1539,     /* ݹ࣬Ҫ There's too much data to pack. */
    NETDEV_E_AAC_LC_DECODE_FAIL                 = 1540,     /* AAC_LCʧ AAC_LC decode failure*/
    NETDEV_E_RENDER_SURFACELOST                 = 1541,     /* ʾ涪ʧ */
    NETDEV_E_FILE_ENCRYPED                      = 1543,     /* ļѼ */
    NETDEV_E_SCRAMBLING_INFO_FAILED             = 1544,     /* Ϣ쳣 */

    /* ýỰҵ쳣ϱ */
    NETDEV_E_LIVE_EXISTED                       = 2000,     /* ʵҵѾ Live business has been established */
    NETDEV_E_LIVE_INPUT_NOT_READY               = 2001,     /* ýδ׼ Media streaming is not ready */
    NETDEV_E_LIVE_OUTPUT_BUSY                   = 2002,     /* ʵҵʾԴæ Live business display resources busy */
    NETDEV_E_LIVE_CB_NOTEXIST                   = 2003,     /* ʵƿ鲻 Real-time control block does not exist */
    NETDEV_E_LIVE_STREAM_FULL                   = 2004,     /* ʵԴ Real-time flow resources are full */

    NETDEV_E_AUDIO_EXISTED                      = 2100,     /* ԽѴ Speech intercom already exists */
    NETDEV_E_AUDIO_NO_EXISTED                   = 2101,     /* ҵ񲻴 Voice service does not exist */
    NETDEV_E_AUDIO_RESCODE_INVALID              = 2102,     /* ԽԴЧ Invalid encoding of voice intercom resources */
    NETDEV_E_AUDIO_RES_USED_BY_TALK             = 2103,     /* ԴѱԽʹ  Audio resource is being used by two-way audio */
    NETDEV_E_AUDIO_FAILED                       = 2104,     /* Խʧ Speech intercom failure */
    NETDEV_E_AUDIO_AUDIOBCAST_FULL              = 2205,     /* ҵ  No more audio service allowed */

    NETDEV_E_CAPTURE_NO_SUPPORT_FORMAT          = 2200,     /* ץĸʽ֧ Snapshot format does not support  */
    NETDEV_E_CAPTURE_NO_ENOUGH_CAPACITY         = 2201,     /* Ӳ̿ռ䲻 Insufficient hard disk space */
    NETDEV_E_CAPTURE_NO_DECODED_PICTURE         = 2202,     /* ûнͼƬɹץ Undecoded pictures can be captured */
    NETDEV_E_CAPTURE_SINGLE_FAILED              = 2203,     /* ץĲʧ Single snap operation failed */

    NETDEV_E_OVER_ABILITY                       = 2301,     /*  Bit stream excess capability set */

    /* ýҵ쳣ϱ  Cloud media view exception report 2793~2809 */
    NETDEV_E_CLOUD_DOWNLOAD_FINISH              = 2793,     /*  */
    NETDEV_E_CLOUD_PARSE_DOMAIN_FAIL            = 2794,     /* ʧ */
    NETDEV_E_CLOUD_CONNECT_FAIL                 = 2795,     /* ʧ */
    NETDEV_E_CLOUD_CONNECT_TIMEOUT              = 2796,     /* ӳʱ */
    NETDEV_E_CLOUD_DOWNLOAD_TIMEOUT             = 2797,     /* سʱ */
    NETDEV_E_CLOUD_DOWNLOAD_FAIL                = 2798,     /* ʧ */
    NETDEV_E_CLOUD_NETWORK_POOR                 = 2799,     /* ϲ */
    NETDEV_E_CLOUD_PLAY_FINISH                  = 2800,     /*  */
    NETDEV_E_CLOUD_DISK_FULL                    = 2801,     /* ̿ռ */
    NETDEV_E_CLOUD_AUTH_FAIL                    = 2802,     /* Ȩʧ */
    NETDEV_E_CLOUD_CURRENT_TIME                 = 2803,     /* ǰʱ䣬ϱ */
    NETDEV_E_CLOUD_PRIOR_DISK_FULL              = 2804,     /* Ԥֵ */
    NETDEV_E_CLOUD_NODE_NOT_EXIST               = 2805,     /* ʱڵ㲻 */
    NETDEV_E_CLOUD_NO_CACHE_PATH                = 2806,     /* δû· */
    NETDEV_E_CLOUD_MSG_SEND_FAIL                = 2807,     /* Ϣʧ */
    NETDEV_E_CLOUD_TASK_CANCELLED               = 2808,     /* ȡ */
    NETDEV_E_CLOUD_TASK_STREAM_CONTINUE         = 2809,     /*  */

    NETDEV_E_MEDIA_INPUT_NOT_READY              = 10000,    /* ýδ׼ Media streaming is not ready */
    NETDEV_E_CCB_STATR_INVALID                  = 10001,    /* ƿ״̬ Control block state unavailable */
    NETDEV_E_MEDIA_OUTPUT_BUSY                  = 10002,    /* ʵҵʾԴæ Live business display resource busy */
    NETDEV_E_MEDIA_START_LOCAL_LIVE_ERR         = 10003,    /* ʵýδ׼ Live media streams are not ready */
    NETDEV_E_MEDIA_START_LOCAL_REPLAY_ERR       = 10004,    /* طýδ׼ Playback media streams are not ready */

    NETDEV_E_MEDIA_BW_RECV_NOT_ENOUGH           = 10007,    /* մ Insufficient network reception bandwidth */
    NETDEV_E_MEDIA_BW_SEND_NOT_ENOUGH           = 10008,    /* 緢ʹ Insufficient network transmission bandwidth */
    NETDEV_E_MEDIA_AUDIO_BROADCAST_TO_LIMIT     = 10009,    /* 㲥ҵѴ Voice broadcasting service has reached the upper limit */
    NETDEV_E_MEDIA_AUDIO_CHL_BING_USED          = 10010,    /* Ƶͨѱռ Audio channel has been occupied */
    
    NETDEV_E_MEDIA_NOT_SUPPORT_ENCODETYPE       = 10012,    /* ʽ֧ Encode type Not supported */

    NETDEV_E_MEDIA_MAX                          = 10399     /* ýشֵ Maximum Media Related Error Code */
}NETDEV_MEDIA_ECODE_E;

/* ̨ģ */
typedef enum tagNETDEVPtzErrCode
{
    NETDEV_E_SET_PRESET_FAILED                  = 10400,    /* Ԥλʧ Failure of preset setting */
    NETDEV_E_QUERY_PRESET_FAILED                = 10401,    /* Ԥλѯʧ Failure of preset query */
    NETDEV_E_QUERY_TRACK_FAILED                 = 10402,    /* 켣ѯʧ Trajectory Query Failure */
    NETDEV_E_START_RECORD_TRACK_FAILED          = 10403,    /* ʼ¼ƹ켣ʧ Failure to start recording trajectory */
    NETDEV_E_STOP_RECORD_TRACK_FAILED           = 10404,    /* ¼ƹ켣ʧ Failure to end recording trajectory */
    NETDEV_E_QUERY_CRUISE_FAILED                = 10405,    /* Ѳ·ѯʧ Cruise line query failed */
    NETDEV_E_SET_CRUISE_FAILED                  = 10406,    /* Ѳ·ʧ Failure to set up cruise routes */
    NETDEV_E_PTZ_COMMAND_FAILED                 = 10407,    /* ̨ʧ PTZ operation failed */
    NETDEV_E_PRESET_IN_CRUISE                   = 10408,    /* ԤλѲ·ʹ, ޷ɾ Pre-positioning is used in cruise routes and cannot be deleted */
    NETDEV_E_CRUISEPOINT_ER                     = 10409,    /* Ѳ㲻 Setting Cruise Points Discontinuous */
    NETDEV_E_TRACK_ISUSED                       = 10410,    /* 켣ʹã޷ɾ Track is in use and cannot be deleted */
    NETDEV_E_SERIALMODE_MISMATCH                = 10411,    /* ģʽƥ Serial port mode mismatch */
    NETDEV_E_TRACK_NOT_EXIST                    = 10412,    /* 켣 Trajectory does not exist */
    NETDEV_E_MODE_CRUISE_FULL                   = 10413,    /* ģʽ·켣 Number of path trajectory points of patterns is full*/
    NETDEV_E_PTZ_ISUSED                         = 10414,    /* ̨ʹ PTZ in use */
    NETDEV_E_PRESET_IN_GUARD                    = 10415,    /* Ԥλʹ Prepositioning in Watch */
    NETDEV_E_CRUISE_PATH_IN_GUARD               = 10416,    /* Ѳ·ʹ Cruise Path Used in Watch */

    NETDEV_E_PTZ_MAX                            = 10799     /* ̨ģֵ Maximum error code of PTZ module */
}NETDEV_PTZ_ECODE_E;


/* طģ */
typedef enum tagNETDEVVodErrCode
{
    NETDEV_E_VOD_ABEND                          = 10800,    /* ط쳣 Playback abnormal end */
    NETDEV_E_VOD_END                            = 10801,    /* طŽ Playback end */
    NETDEV_E_VOD_CALL_DRV                       = 10802,    /* ӿʧ Failed to call driver interface */
    NETDEV_E_VOD_CB_NOT_FIND                    = 10803,    /* ƿδҵ Control block not found */
    NETDEV_E_VOD_OVER_ABILITY                   = 10804,    /* ط Exceeding playback capability */
    NETDEV_E_VOD_TAG_OVER_LIMIT                 = 10805,    /* ǩ The number of labels exceeds the limit */
    NETDEV_E_VOD_NO_RECORDING                   = 10806,    /* ¼   No recording */
    NETDEV_E_VOD_SMART_NOT_SUPPORT              = 10807,    /* 豸֧ܻط GB device does not support smart playback*/
    NETDEV_E_VOD_NO_REPLAYURL                   = 10808,    /* ޷ȡطŵurl   Cannot get the URL for playback*/

    NETDEV_E_VOD_MAX                            = 10999     /* طģֵ Maximum error code of playback module */
}NETDEV_VOD_ECODE_E;

/* 洢ģ */
typedef enum tagNETDEVStorErrCode
{
    NETDEV_E_STOR_ABEND                         = 101000,   /* 洢쳣 Storage exception termination */
    NETDEV_E_ARRAY_NAME_EXITS                   = 11001,    /* Ѵ Array already exists */
    NETDEV_E_NOT_RAID_MODE                      = 11002,    /* ģʽ Non-array mode */
    NETDEV_E_NO_STORE_PLAN                      = 11003,    /* ͨûù¼ƻ The channel is not equipped with a video plan. */
    NETDEV_E_DISK_ZERO_OR_ABNORMAL              = 11022,    /* Ӳ̻Ӳ쳣 No hard disk or hard disk abnormalities */
    NETDEV_E_SLOT_NOT_NORMAL                    = 11023,    /* λ1״̬ Slot 1 disk is out of order*/
    NETDEV_E_SLOT_RECONNECT                     = 11024,    /* λ1εֲϣҪ After opening the face, slot 1 is pulled out and inserted. It needs to be restarted. */
    NETDEV_E_BATTERY_STATUS_FAULT               = 11034,    /* 豸״̬쳣 Abnormal battery status of equipment */
    NETDEV_E_CHL_QUOTA_EXIST                    = 11035,    /* ͨѴ */
    NETDEV_E_RAIDLUN_ABNORMAL                   = 11036,    /* vms-ipsan޿ */
    NETDEV_E_DATABASE_STATUS_ABNORMAL           = 11037,    /* ݿ״̬쳣 Database status abnormal */

    NETDEV_E_STOR_MAX                           = 11199     /* 洢ģֵ Maximum error code of storage module */
}NETDEV_STOR_ECODE_E;

/* ûģ */
typedef enum tagNETDEVUserErrCode
{
    NETDEV_E_USER_NOT_ONLINE                    = 101200,   /* û Users are not online */
    NETDEV_E_USER_WRONG_PASSWD                  = 11201,    /* û User password error */
    NETDEV_E_USER_NO_SUCH_USER                  = 11202,    /* ûиû No user */
    NETDEV_E_USER_NO_AUTH                       = 11203,    /* ûȨ User has no privilege */
    NETDEV_E_USER_MAX_NUM                       = 11204,    /* û-ٱ User cap - cannot be added */
    NETDEV_E_USER_EXIST                         = 11205,    /* ûѴ User already exists */
    NETDEV_E_USER_LOGIN_MAX_NUM                 = 11206,    /* û¼Ѵ The number of users logged in has reached the upper limit. */
    NETDEV_E_USER_LOCKED                        = 11207,    /* ûѱ The user has been locked */
    NETDEV_E_USER_IS_ADMIN                      = 11208,    /* ˲ûϵͳԱ This operation is not allowed. The user is the system administrator. */
    NETDEV_E_USER_NOT_VALID_PERIOD              = 11209,    /* Ч Not within the validity period */
    NETDEV_E_USER_ROLE_BEYOND_RANGE             = 11210,    /* ûɫ The number of user roles exceeds the upper limit */
    NETDEV_E_USER_SELOG_IP_LOCKED               = 11211,    /* ûȫ¼ User security logon lock*/
    NETDEV_E_ROLE_EXIST                         = 11212,    /* ɫѴ Roles already exist */
    NETDEV_E_USER_NOT_VALID_TIME                = 11213,    /* Чʱ Not in the valid period */
    NETDEV_E_USER_WEAK_PASSWD_LOGIN_FAIL        = 11214,    /* ¼ʧ,ڱ޸ĳǿٴγԶ̵¼ Logon failed. Please try remote login again after changing the local network to a strong password. */
    NETDEV_E_USER_IS_TEMPPASSWD                 = 11217,    /* ûʹʱ¼ Users log in with temporary passwords */
    NETDEV_E_USER_TEMPPASSWD_LOGIN_FAIL         = 11218,    /* ʱֹ½ Temporary password of public network prohibits landing */
    NETDEV_E_USER_WEAK_PASSWD_MODIFY            = 11219,    /* ǿ޸ Force password modification */
    NETDEV_E_USER_IP_NO_AUTH                    = 11221,    /* ¼IPȨ Login IP has no permission */

    NETDEV_E_USER_MAX                           = 11599     /* ûģֵ Maximum error code of user module*/
}NETDEV_USER_ECODE_E;


/* 豸ģ */
typedef enum tagNETDEVDevErrCode
{
    NETDEV_E_DEV_NOT_ONLINE                     = 11600,    /* 豸 The device is not online */
    NETDEV_E_DEV_WRONG_PASSWD                   = 11601,    /* 豸 Device password error */
    NETDEV_E_DEV_REPEAT_DEV                     = 11602,    /* ظ豸 Repetitive equipment */
    NETDEV_E_DEV_NO_SUCH_DEV                    = 11603,    /* ûи豸 No equipment */
    NETDEV_E_DEV_NO_SUCH_CHL                    = 11604,    /* ûиͨ No channel */
    NETDEV_E_DEV_MAX_NUM                        = 11605,    /* һ豸-ٱ VMS equipment upper limit - Can't be added anymore*/
    NETDEV_E_DEV_LOGIN_MAX_NUM                  = 11606,    /* 豸¼ Upper limit of device logon number */
    NETDEV_E_DEV_COMMON_FAILED                  = 11607,    /* 豸صͨô Common errors returned by devices */
    NETDEV_E_DEV_NO_SUCH_DEV_OID                = 11608,    /* 豸ʷID No device history ID exists */
    NETDEV_E_DEV_DEL_FORBID                     = 11609,    /* 豸ɾ Devices are not allowed to be deleted */
    NETDEV_E_CHL_OFFLINE                        = 11610,    /* ͨ Channel not online */
    NETDEV_E_DEV_TYPE_UNMATCHED                 = 11611,    /* 豸Ͳƥ Mismatch of device type added */
    NETDEV_E_DEV_REPEAT_DEV_NAME                = 11612,    /* 豸ظ Duplicate device name */
    NETDEV_E_DEV_CFG_FAILED                     = 11613,    /* 豸ʧ Device configuration failure */
    NETDEV_E_DEV_NO_RESULT                      = 11614,    /* ѯ޽ Inquiries without results */
    NETDEV_E_DEV_DEC_OFFLINE                    = 11617,    /* 豸  1161511616һڲʹãΪ11617 Decoding equipment offline 11615, 11616 error code integration machine has been used, so the new 11617 */

    NETDEV_E_DEV_VCA_ALARM_NO_PIC               = 11661,    /* δȡVCA澯ͼƬ Failed to get VCA alarm picture */

    /* ش */
    NETDEV_E_COMMON_FAIL_STAT                   = 11801,    /* ȡļĿ¼״̬ʧ Failed to read file (directory) status */
    NETDEV_E_COMMON_FILE_NONEXIST               = 11802,    /* ļ File does not exist */
    NETDEV_E_COMMON_MKDIR_ERR                   = 11803,    /* Ŀ¼ʧ Failed to create directory */
    NETDEV_E_SUBSCRIBE_FULL                     = 11804,    /* û, 豸ûĴ벻ܷ This user's subscription is full and the error code of the device side user's subscription is full cannot be returned. */
    NETDEV_E_UPGRADE_NOTADMIN                   = 11805,    /* adminû޷ Non-admin users cannot upgrade */
    NETDEV_E_UPGRADE_INVALID                    = 11806,    /*  δʼ Upgrade not started */
    NETDEV_E_UPGRADE_INPROCESS                  = 11807,    /*   Upgrade processing */
    NETDEV_E_UPGRADE_NOMEMORY                   = 11808,    /*  ڴռ䲻 Insufficient upgrade memory space */
    NETDEV_E_UPGRADE_FILE_OPEN_ERR              = 11809,    /*  򿪾ļ Upgrade error opening mirror file */
    NETDEV_E_UPGRADE_DEVICE_ERR                 = 11810,    /*  FLASH Error upgrading FLASH */
    NETDEV_E_UPGRADE_BUSY                       = 11811,    /* ͬʱض Multiple upgrade processes cannot be loaded at the same time */
    NETDEV_E_UPGRADE_FAIL_TIMEOUT               = 11812,    /* ʱ Upgrade timeout */
    NETDEV_E_INVALID_CONFIGFILE                 = 11813,    /* ļЧ Invalid configuration file */
    NETDEV_E_STOR_RESOURCE_NOTINIT              = 11814,    /* 洢Դδ Unallocated storage resources */

    NETDEV_E_DEV_MAX                            = 11999     /* 豸ģֵ Maximum error code of equipment module */

}NETDEV_DEV_ECODE_E;

/* ֯ģ */
typedef enum tagNETDEVOrgErrCode
{
    NETDEV_E_ORG_MAX_NUM                        = 12000,    /* ֯-ٱ Organizational cap - cannot be added */
    NETDEV_E_ORG_MAX_LEVEL                      = 12001,    /* ֯㼶 Upper limit of organizational hierarchy */
    NETDEV_E_ORG_RESOURCE_EXIST                 = 12002,    /* ֯Դ-ܱɾ Organizational resources - cannot be deleted */
    NETDEV_E_ORG_EXIST                          = 12003,    /* ֧ͬ֯Ѵ Organizations already exist under the same branch*/
    NETDEV_E_ORG_NO_SUCH_ORG                    = 12004,    /* ֯ Organization does not exist */
    NETDEV_E_ORG_IS_ROOT                        = 12005,    /* ˲֯Ǹ֯ This operation is not allowed. The organization is the root organization.*/
    NETDEV_E_ORG_NO_SUCH_PORG                   = 12006,    /* ֯ Paternal organization does not exist */
    NETDEV_E_ORG_SUB_EXIST                      = 12007,    /* ֯֯,ܱɾ Organized, not deleted */

    NETDEV_E_ORG_MAX                            = 12399     /* ֯ģֵ Maximum error code value of organization module*/
}NETDEV_ORG_ECODE_E;


/* ǽģ */
typedef enum tagNETDEVTvwallErrCode
{
    NETDEV_E_TVWALL_WND_NUMLIMITED              = 12400,    /*  The number of windows exceeds the limit */
    NETDEV_E_TVWALL_NUMLIMTED                   = 12401,    /* ǽ The number of TV walls exceeds the limit */
    NETDEV_E_TVWALL_LED_NUMLIMTED               = 12402,    /* LED The number of virtual LEDs exceeds the limit */
    NETDEV_E_TVWALL_LED_LINELIMTED              = 12403,    /* LED Single virtual LED line number exceeding limit */
    NETDEV_E_TVWALL_SCENE_OVER_LIMIT            = 12404,    /* ǽ The number of scenes of single TV Wall exceeds the limit */
    NETDEV_E_TVWALL_BASEPIC_NUMLIMITED          = 12405,    /* 豸ܴ洢ĵͼ The number of base diagrams that the device can store exceeds the limit */
    NETDEV_E_TVWALL_BASEPIC_SCENELIMITED        = 12406,    /* ܰ󶨵ĵͼ The number of backgrounds that a single scene can bind exceeds the limit */
    NETDEV_E_TVWALL_DECODE_OUTRANGE             = 12407,    /* Ŀλѳ Destination position super-decoding capability */
    NETDEV_E_TVWALL_WND_OUTRANGE                = 12408,    /* ѳ The area of window opening has exceeded three times the area of window opening.*/
    NETDEV_E_TVWALL_WND_RANGELIMITED            = 12409,    /* λ/λóΧ Window position/roaming position out of range */
    NETDEV_E_TVWALL_SCROLL_LED_NUMLIMITED       = 12410,    /* LED The number of Rolling virtual LEDs exceeds the limit */

    NETDEV_E_TVWALL_WND_LOCKED                  = 12430,    /* ǰѱ The current window has been locked */
    NETDEV_E_TVWALL_LED_NOTEXIST                = 12431,    /* LED Virtual LED does not exist */
    NETDEV_E_TVWALL_SEQ_EXISTD                  = 12432,    /* Ѿ Rotary cutting already exists */
    NETDEV_E_TVWALL_WND_NOTEXIST                = 12433,    /* ڲ Window does not exist */
    NETDEV_E_TVWALL_WND_EXIST                   = 12434,    /* Ѿ The window already exists */
    NETDEV_E_TVWALL_SPILT_NOTEXIST              = 12435,    /* еķ The split screen in the window does not exist */
    NETDEV_E_TVWALL_WND_NOSPILT                 = 12436,    /* ڲܷ Windows cannot be split */
    NETDEV_E_TVWALL_CHANNEL_UESED               = 12437,    /* ͨǽռ Decoding channel occupied by other TV wall */
    NETDEV_E_TVWALL_WINDEXIST                   = 12438,    /* ǽڴ TV Wall Existence Window */
    NETDEV_E_TVWALL_NOTEXIST                    = 12439,    /* ǽϢ TV wall information does not exist */
    NETDEV_E_TVWALL_SPLIT_INFOERR               = 12440,    /* ķ Error splitting type */
    NETDEV_E_TVWALL_CHANNEL_NUMERR              = 12411,    /* ͨ Error in channel number */
    NETDEV_E_TVWALL_ENC_ERR                     = 12442,    /* ýδ׼ Media streaming is not ready */
    NETDEV_E_TVWALL_PERSCREEN_NUMLIMITED        = 12443,    /* ĻVOڣ The number of windows exceeds the limit*/
    NETDEV_E_TVWALL_FILE_PROCESSING             = 12444,    /* ļڴ */
    NETDEV_E_TVWALL_STREAM_CANNOT_REPEAT        = 12445,    /* ظ */
    NETDEV_E_TVWALL_EXCESS_AREA                 = 12446,    /* 豸صĿ߻,߳ڵĴأ65 */
    NETDEV_E_TVWALL_DISPLAY_MODE_CONFLICT       = 12447,    /* ʾģʽͻ */
    NETDEV_E_TVWALL_SERIAL_MOD_ERR              = 12448,    /* ģʽ뵽豸web޸Ĵ */
    NETDEV_E_TVWALL_MAX                         = 12799     /* ǽģֵ Maximum error code value of tv wall module*/
}NETDEV_TVWALL_ECODE_E;


/* ش */
typedef enum tagNETDEVNetErrCode
{
    NETDEV_E_IPADDR_CONFLICT                    = 12800,    /* IPַͻ IP Address Conflict */
    NETDEV_E_UPNP_PORT_DISCARD                  = 12801,    /* ӳĶ˿ѷ The mapped port is discarded */
    NETDEV_E_UPNP_PORT_EMPLOY                   = 12802,    /* ˿ռ Port occupied */
    NETDEV_E_SET_VMP_PORT_FAILED                = 12803,    /* VMP˿ʧ Failed to set VMP port */
    NETDEV_E_SET_MEDIA_PORT_FAILED              = 12804,    /* ý˿ʧ Failed to set media stream port */
    NETDEV_E_SET_RTSP_PORT_FAILED               = 12805,    /* RTSP˿ʧ Failed to set RTSP port */
    NETDEV_E_SET_ONVIF_PORT_FAILED              = 12806,    /* ONVIF˿ʧ Failed to set ONVIF port */
    NETDEV_E_SET_HTTPS_PORT_FAILED              = 12807,    /* HTTPS˿ʧ Failed to set HTTPS port */
    NETDEV_E_SET_HTTP_PORT_FAILED               = 12808,    /* HTTP˿ʧ Failed to set HTTP port */
    NETDEV_E_TEST_EMAIL                         = 12809,    /* Ͳʼʧ Failed to send test mail */
    NETDEV_E_DDNS_INIT                          = 12810,    /* ʼĬֵ Initialize default values */
    NETDEV_E_DDNS_GOOD                          = 12811,    /*  Update completed*/
    NETDEV_E_DDNS_NOCHG                         = 12812,    /* ,ipַûб仯 The update is complete, but the IP address remains unchanged */
    NETDEV_E_DDNS_BADAUTH                       = 12813,    /* û Error username password */
    NETDEV_E_DDNS_DONATOR                       = 12814,    /* רõѡҪoffline URLķ Special options require service fees similar to offline URLs */
    NETDEV_E_DDNS_NOTFQ                         = 12815,    /* ʽϸ Host name format is not qualified */
    NETDEV_E_DDNS_NOHOST                        = 12816,    /* ڸ˻ The hostname account does not exist */
    NETDEV_E_DDNS_NUMHOST                       = 12817,    /* ¶20 More than 20 hosts are requested to update immediately */
    NETDEV_E_DDNS_ABUSE                         = 12818,    /* ö Host name is disabled due to abuse */
    NETDEV_E_DDNS_BADAGENT                      = 12819,    /* ʹHTTPʽ The proxy sends the wrong HTTP request format */
    NETDEV_E_DDNS_GOOD_127                      = 12820,    /* ǿͻҪ127.0.0.1Ϣhttpз Unless the client wants to update 127.0.0.1, this information indicates an error in the HTTP request specification */
    NETDEV_E_DDNS_DNSERR                        = 12821,    /* DNSϵSupport DNS error, please contact Support*/
    NETDEV_E_DDNS_911                           = 12822,    /* άڴ Service maintenance is being processed */
    NETDEV_E_DDNS_REQ                           = 12823,    /* DDNSʧ DDNS request failed to send */
    NETDEV_E_DDNS_CHECK_KEY                     = 12824,    /* У Check code error */
    NETDEV_E_DDNS_BAD_NAME_FORMAT               = 12825,    /* ʽϸ Domain name format is not qualified */
    NETDEV_E_DDNS_DOMAIN_CONFLICT               = 12826,    /* ͻ Domain name conflict */
    NETDEV_E_DDNS_CLOSE                         = 12827,    /* ddnsأֻڹرddns¼״̬ Non-ddns server returns, only for closing DDNS record status */
    NETDEV_E_CREATE_CERT_FAILD                  = 12828,    /* ֤ļʧ Certificate file generation failed */
    NETDEV_E_GET_CERT_FAILD                     = 12829,    /* ϴ֤ļϷ It is illegal to upload certificate files */
    NETDEV_E_TEST_EMAIL_CHECKSERVER_INFO        = 12830,    /* ֤û Error in username or password of authentication server */
    NETDEV_E_TEST_EMAIL_COMM                    = 12831,    /* ʼʧ,ʼ Mail delivery failed. Check network and mail configuration */
    NETDEV_E_TEST_EMAIL_TIMEOUT                 = 12832,    /* ʼͳʱ Mail Delivery Timeout */
    NETDEV_E_CLOUD_REPEAT_USER                  = 12833,    /* ƶ˺ѵ¼ The cloud account is logged in */
    NETDEV_E_CLOUD_DEV_ADD_FAIL                 = 12834,    /* ƶ豸Ϣʧ Failed to add cloud device information */
    NETDEV_E_CLOUD_ORG_NULL                     = 12835,    /* ƶ֯ϢΪ Cloud organizational information is empty */
    NETDEV_E_GET_CLOUD_ORG                      = 12836,    /* ޷ȡƶϢ Cloud information cannot be obtained. Check network configuration */
    NETDEV_E_NO_SUCH_CLOUD_USER                 = 12837,    /* ƶ˺Ų Cloud account does not exist */

    NETDEV_E_NET_MAX                            = 13199     /* ģֵ Maximum Error Code Value of Network Module */

}NETDEV_NET_ECODE_E;


/* CFGģ - XML */
typedef enum tagNETDEVXMLCfgErrCode
{
    NETDEV_E_CONF_FILE_INVALID                  = 13200,    /* ļϷ Illegal configuration file */
    NETDEV_E_LOAD_XML_FAIL                      = 13201,    /* XMLļʧ Failed to export XML file */
    NETDEV_E_SAVE_XML_FAIL                      = 13202,    /* XMLļʧ Failed to generate XML file */
    NETDEV_E_XML_ATTR_INEXIST                   = 13203,    /* XMLϢ XML attribute information does not exist */
    NETDEV_E_XML_SYNC_CFG_FAILED                = 13204,    /* ͬ,ϵͳʱͬ Configuration area synchronization error to save configuration synchronously when system restart */
    NETDEV_E_SIMPLE_RECOVER_CFG_FAILED          = 13205,    /* 򵥻ָó Simple Recovery Configuration Error */
    NETDEV_E_RECOVER_CFG_FAILED                 = 13206,    /* ȫָó Complete Recovery Configuration Error */
    NETDEV_E_CONF_FORBID_WRITE                  = 13207,    /* ֹд Disable Writing Configuration */

    NETDEV_E_XML_MAX                            = 13599     /* XMLģֵ Maximum Error Code Value of XML Module */

}NETDEV_XML_ECODE_E;


/* planģ */
typedef enum tagNETDEVPlanErrCode
{
    NETDEV_E_PLAN_TEMPLATE_BUSY                 = 13600,    /* ʱģڱʹ Template is being used */
    NETDEV_E_PLAN_TEMPLATE_NOT_EXIST            = 13601,    /* ʱģڵ㲻 Time template node does not exist */
    NETDEV_E_PLAN_INVALID_HOLIDAY_TIME          = 13602,    /* Ƿʱ Illegal Holiday Time */
    NETDEV_E_PLAN_NO_PLAN                       = 13603,    /* ûмƻ No plan */
    NETDEV_E_PLAN_NOT_IN_PLAN                   = 13604,    /* ڼƻ Not planned */
    NETDEV_E_PLAN_IN_PLAN                       = 13605,    /* ڼƻ Within the plan */

    NETDEV_E_PLAN_MAX                           = 13699     /* Planģֵ Maximum Error Code Value of Plan Module */

}NETDEV_PLAN_ECODE_E;


/* MT ģ -  */
typedef enum tagNETDEVMTErrCode
{
    NETDEV_E_UPDATE_VERSION_FAIL                = 13700,    /* 豸汾Ųƥ Equipment upgrade, version number mismatch */
    NETDEV_E_UPDATE_BOARDTYPE_NOT_MATCH         = 13701,    /* 豸豸Ͳƥ Equipment upgrade, equipment type mismatch */
    NETDEV_E_FILE_CHECK_FAILED                  = 13702,    /* ļУ Document Check Error */
    NETDEV_E_EXPORT_CFG_FAILED                  = 13703,    /* ó Export configuration error */
    NETDEV_E_IMPORT_CFG_FAILED                  = 13704,    /* ó Import configuration error */
    NETDEV_E_UPDATE_OTHER_REASON                = 13705,    /* 豸ڴԭʧ Device upgrade, memory application or other reasons may fail */
    NETDEV_E_MAINTAIN_EXPORT_RUNNING            = 13706,    /* άϢڵ Maintenance information is being exported */

    NETDEV_E_MT_MAX                             = 13799     /* MTģֵ Maximum error code value of MT module */

}NETDEV_MT_ECODE_E;

/* LINKAGE ģ -  */
typedef enum tagNETDEVLinkageErrCode
{
    NETDEV_E_LINKAGE_GUARD_PRO_ALREADY_EXIT     = 13800,    /* ԤѴ Preventive clothing plan already exists */
    NETDEV_E_LINKAGE_GUARD_PRO_NOT_EXIST        = 13801,    /* ָĲԤ The designated deployment plan does not exist */
    NETDEV_E_LINKAGE_LINK_RULE_NOT_EXIST        = 13802,    /* ָ򲻴 The specified linkage rule does not exist */

    NETDEV_E_LINKAGE_MAX                        = 13899    /* Linkageģֵ Maximum Error Code Value of Linkage Module */
}NETDEV_LINKAGE_ECODE_E;

/* alarmģ */
typedef enum tagNETDEVAlarmErrCode
{
    NETDEV_E_ALARM_RESTRAIN                     = 13900     /* 澯 Alarm suppression */

}NETDEV_ALARM_ECODE_E;

/* ӵͼģ */
typedef enum tagNETDEVEMaprrCode
{
    NETDEV_E_EMAP_PIC_MAX_NUM                   = 15000,    /* ͼƬﵽޣ޷ The number of pictures reached the upper limit and could not be added. */
    NETDEV_E_EMAP_DIR_EXIST                     = 15001,    /* ӵͼиĿ¼Ѵ The root directory already exists in the electronic map */

    NETDEV_E_EMAP_MAX                           = 15099     /* ӵͼģֵ Maximum Error Code Value of Electronic Map Module */
}NETDEV_EMAP_ECODE_E;

/* ŽԱģ */
typedef enum tagNETDEVPASCErrCode
{
    NETDEV_E_PACS_PERSON_NO_EXIST               = 17000,    /* ŽԱ No entrance guards exist */
    NETDEV_E_PACS_PERSON_EXIST                  = 17001,    /* ŽԱѴ Access guards already exist */
    NETDEV_E_PACS_PERSON_CARD_EXIST             = 17002,    /* ŽѴ Access card already exists */
    NETDEV_E_PACS_PERSON_CARD_NO_EXIST          = 17003,    /* Ž No access card exists*/
    NETDEV_E_PACS_PERSON_CARD_REACH_LIMIT       = 17004,    /* ŽѴ The number of access cards has reached the upper limit. */
    NETDEV_E_PACS_ACCESS_RECORD_NO_EXIST        = 17005,    /* Ա¼ Personnel access records do not exist*/
    NETDEV_E_PACS_CHL_NO_EXIST                  = 17006,    /* Žͨ Access control channel does not exist*/
    NETDEV_E_PACS_PRMISS_ID_EXIST               = 17007,    /* ŽȨԱ  Personnel with access control authority do not exist*/
    NETDEV_E_PACS_PERSON_DEPT_ID_NO_EXIST       = 17008,    /* ŽԱԱID Personnel Departmental ID of Access Control Personnel does not exist*/
    NETDEV_E_PACS_PERSON_RECORD_ID_NO_EXIST     = 17009,    /* Ա¼ID Personnel access record ID does not exist*/
    NETDEV_E_PACS_DEPT_ID_PREMISSIONED          = 17010,    /* ȨѴ  Departmental authority already exists*/
    NETDEV_E_PACS_PERMISSION_EXIT_PERSON        = 17011,    /* ȨԱɾ The permission group has Person and cannot be deleted. */
    NETDEV_E_PACS_BLACKLIST_PERSON_EXIST        = 17012,    /* Ѵںÿ Existing blacklist Persons . */
    NETDEV_E_PACS_BLACKLIST_NOT_ADD             = 17013,    /* ÿͲ Blacklist visitors cannot be added. */
    NETDEV_E_PACS_MAX                           = 17999     /* PACSģֵ Maximum Error Code of PACS Module */
}NETDEV_PACS_ECODE_E;

/* ʶģ */
typedef enum tagFaceSmartModeErrCode
{
    NETDEV_E_FACE_BD_NO_MEMBER                  = 19000,    /* ޳Ա No member in face database */
    NETDEV_E_FACE_GUARD_NO_EXIST                = 19001,    /* 񲻴 Control task does not exist */
    NETDEV_E_FACE_ALARM_LOG_NO_EXIST            = 19002,    /* ʶ澯¼ There is no alarm record for face recognition */
    NETDEV_E_SMART_GET_FACE_IMAGE_FAIL          = 19003,    /* ȡץͼƬʧ Failure in capturing face images */
    NETDEV_E_NO_UID_AVAILABLE                   = 19004,    /* ûпõUid No Uid is available */

    NETDEV_E_FACE_LIB_COUNT_MAX                 = 19005,    /* ﵽֵ Maximum number of face databases */
    NETDEV_E_FACE_GUARD_COUNT_MAX               = 19006,    /* ⲼѴﵽֵ The number of control tasks in the face database has reached the maximum. */
    NETDEV_E_FACE_MEMBER_COUNT_MAX              = 19007,    /* ԱѴﵽֵ The maximum number of face members has been achieved in this face database. */
    NETDEV_E_FACE_IDENTI_NUM_EXIST              = 19008,    /* ֤Ѵ Document number already exists */
    NETDEV_E_FACE_FEAT_VERTION_UNMATCH          = 19009,    /* 豸ʶ㷨汾ƥ Version mismatch of device face recognition algorithm */
    NETDEV_E_VEHICLE_GUARD_NO_EXIST             = 19010,    /* 񲻴 Vehicle control tasks do not exist */
    NETDEV_E_SLAVE_PLATE_IMAGE_GET_FAIL         = 19011,    /* ӻͼƬȡʧ Failure to obtain license plate image */
    NETDEV_E_VEHICLE_LOG_NO_EXIST               = 19012,    /* ¼ Vehicle records do not exist */
    NETDEV_E_GET_SLAVE_PIC_FAIL                 = 19013,    /* ȡӻͼƬʧ Failed to get slave picture */
    NETDEV_E_GUARD_DEV_VIID_OFFLINE             = 19014,    /* 豸ͼ״̬ Out-of-line status of view Library of distribution control equipment */
    NETDEV_E_GUARD_GUARD_DEV_NOW                = 19015,    /* 豸 In Distribution Control Equipment */
    NETDEV_E_GUARD_GUARD_NOT_ENABLE             = 19020,    /* òʹ This control task is not enabled */
    NETDEV_E_GUARD_GUARD_NOW                    = 19021,    /*  In charge control */
    NETDEV_E_GUARD_DIFFERENT_IMAGE_PROTOCOL     = 19022,    /* ÿֻѡͬͼƬЭ豸в */
    NETDEV_E_ROOT_LIB_HAS_MONITORED_MEMBER      = 19023,    /* ׿´ڲسԱ */

    NETDEV_E_SMART_MAX                          = 19999     /* ģֵ Maximum Error Code of Intelligent Module */
}NETDEV_FACE_SMART_ERR_CODE_E;

/* ͼⲼش */
typedef enum tagMonitorErrCode
{
    NETDEV_E_VIID_DISPOSE_DEV_BUSY                  = 25006,  /* ͼⲼش豸æ View library layout control error, equipment busy */
    NETDEV_E_VIID_DISPOSE_DATABASE_FULL             = 25007,  /* ͼⲼش,Ѵ View database layout control error, face database has reached the upper limit */
    NETDEV_E_VIID_DISPOSE_MEMBER_FULL               = 25008,  /* ͼⲼش,ԱѴ View database layout control error, face members have reached the upper limit */
    NETDEV_E_VIID_DISPOSE_NO_SMARTBAR               = 25009,  /* ͼⲼش,豸ܰ View Library Layout Control Error, Device Smart Bar does not exist */
    NETDEV_E_VIID_DISPOSE_VIID_OFFLINE              = 25010   /* ͼⲼش,豸ͼδ View Library Layout Error, Device View Library Not Connected */
}NETDEV_MONITOR_ERR_CODE_E;

/* ƶҵش */
typedef enum tagCloudRemoteErrCode
{
    NETDEV_E_CLOUD_REGISTER_BY_OTHER                = 20000,  /* 豸 Not your device */

    NETDEV_E_CLOUD_CHL_NOT_EXIST                    = 20001,  /* ͨ Channel does not exist */
    NETDEV_E_CLOUD_SREAMID_NOT_EXIST                = 20002,  /* ID Flow ID does not exist */
    NETDEV_E_CLOUD_BITRATE_UNEXPECTED               = 20003,  /* ʹ Excessive request rate */
    NETDEV_E_CLOUD_LIVEID_NOT_EXIST                 = 20004,  /* ֱID Live ID does not exist */
    NETDEV_E_CLOUD_PROTO_TYPE_ILLEGAL               = 20005,  /* Э鲻֧ Request Flow Protocol does not support */
    NETDEV_E_CLOUD_CLIENTID_NOT_EXIST               = 20006,  /* ͻID Client ID does not exist */
    NETDEV_E_CLOUD_REQUESTID_NOT_EXIST              = 20007,  /* RequestID RequestID does not exist */
    NETDEV_E_CLOUD_VISITOR_TOTAL_UNEXPECTED         = 20008,  /* ǰû Too many current online users */
    NETDEV_E_GET_RTMP_URL_FAIL                      = 20009,  /* ȡRTMPURLʧ Failed to obtain RTMP pull URL */
    NETDEV_E_GET_PUSH_STREAM_STATE_FAIL             = 20010,  /* ȡ״̬ʧ Failure to acquire push-flow status*/
    NETDEV_E_START_PULL_STREAM_FAIL                 = 20011,  /* ʧ Start-up pull-out failure */
    NETDEV_E_GET_CLOUD_DEV_LIST_FAIL                = 20012,  /* ȡƶ豸бʧ Failed to get the list of cloud devices */
    NETDEV_E_GET_DEV_INFO_FAILED                    = 20013,  /* ȡƶ豸Ϣʧ Failed to obtain cloud device information */
    NETDEV_E_GET_NAT_TYPE_FAIL                      = 20014,  /* ȡNATʧ Failed to get NAT type */
    NETDEV_E_MODIFT_CLOUD_DEV_NAME_FAIL             = 20015,  /* ƶ豸ʧ Failed to update cloud device name */
    NETDEV_E_DELETE_CLOUD_DEVICE_FAIL               = 20016,  /* ɾƶ豸ʧ Failed to delete cloud devices */
    NETDEV_E_STOP_PULL_STREAM_FAIL                  = 20017,  /* ֹͣʧ Stop pulling and lose */
    NETDEV_E_KEEP_ALIVE_PULL_STREAM_FAIL            = 20018,  /* ʧ Failure of Pushing Flow to Preserve Life */
    NETDEV_E_KEEP_ALIVE_LIST_EMPTY                  = 20019,  /* бΪ The live list is empty */
    NETDEV_E_GET_LIVE_ID_FAIL                       = 20020,  /* ȡֱIDʧ Failed to get live ID */
    NETDEV_E_CLOUD_INVALID_FORMAT                   = 20021,  /* ʽǷ Illegal format */
    NETDEV_E_CLOUD_NOT_REGISTER                     = 20022,  /* 豸δע The device is not registered */
    NETDEV_E_CLOUD_INVALID_REG_CODE                 = 20023,  /* ע벻 Registration code does not exist */
    NETDEV_E_CLOUD_NOT_SHARE_TO_SELF                = 20024,  /* ܹԼ Can't share with oneself */
    NETDEV_E_ADD_CLOUD_DEVICE_FAIL                  = 20025,  /* ƶ豸ʧ Failed to add cloud devices */

    NETDEV_E_GET_CLOUD_DDNS_FAIL                    = 20026,    /* ȡDDNSϢʧ Failed to obtain DDNS information */
    NETDEV_E_GET_CLOUD_ORG_LIST_FAIL                = 20027,    /* ȡƶ֯бʧ Failed to retrieve cloud organization list */
    NETDEV_E_FIND_SHARE_DEVLIST_ERROR               = 20028,    /* ȡ豸бʧ Failed to get shared device list */
    NETDEV_E_START_DEVICE_SHARE_FAIL                = 20029,    /* 豸ʧ Failure to start device sharing */
    NETDEV_E_STOP_DEVICE_SHARE_FAIL                 = 20030,    /* ֹͣƶ豸ʧ Failure to Stop Cloud Device Sharing */
    NETDEV_E_GET_SHARE_RECORD_INFO_FAIL             = 20031,    /* ȡƶ˹¼Ϣʧ Failed to obtain cloud shared record information */
    NETDEV_E_GET_CLOUD_DEV_POPULATION               = 20032,    /* ȡ˻豸ͳϢʧ Failed to obtain cloud account device statistics */
    NETDEV_E_ADD_CLOUD_ORG_FAIL                     = 20033,    /* ƶ֯ʧ Increasing cloud Organizational Failure */
    NETDEV_E_MODIFY_CLOUD_ORG_FAIL                  = 20034,    /* ޸ƶ֯ʧ Failure to modify cloud organization */
    NETDEV_E_DELETE_CLOUD_ORG_FAIL                  = 20035,    /* ɾƶ֯ʧ Failed to delete cloud organizations */
    NETDEV_E_ADD_DEV_TO_CLOUD_ORG_FAIL              = 20036,    /* 豸ƶ֯ʧ Failure to add devices to cloud organizations */
    NETDEV_E_GET_CLOUD_DEV_CHANNEL_LIST_FAIL        = 20037,     /* ȡ豸ͨʧ Failure to access cloud device channel */
    NETDEV_E_GET_CLOUD_VIDEO_TIME_FAIL              = 20038,    /* ȡƶƵʱϢʧ Failed to get cloud video time information */
    NETDEV_E_GET_CLOUD_VIDEO_M3U8_FAIL              = 20039     /* ȡƶƵM3u8Ϣʧ Failed to get cloud video M3u8 information */

}NETDEV_CLOUD_REMOTE_ERR_CODE_E;

/* ץͼģ */
typedef enum tagNETDEVSnapshotErrCode
{
    NETDEV_E_SNAPSHOT_PIC_FAILED                    = 27000,     /* ͼƬ洢쳣 */
    NETDEV_E_SNAPSHOT_QRY_PIC_FAILED                = 27001,     /* ѯͼƬ쳣 */

    NETDEV_E_SNAPSHOT_MAX                           = 27999      /* ץͼģֵ */
}NETDEV_SNAPSHOT_ERR_CODE_E;

/* ش */
typedef enum tagNETDEVSmartLockErrCode
{
    NETDEV_SLOCK_ROOM_DUPLICATE                     = 29006,    /* ظ */
    NETDEV_ROOM_PERSON_DUPLICATE                    = 29007,    /* Աظ */
    NETDEV_SLOCK_DEV_BINDED                         = 29008,    /* ѱ */
    NETDEV_SLOCK_MAX                                = 29999     /* ģֵ */
}NETDEV_SMARTLOCK_ERR_CODE_E;

/* END*********************   Error codes *********************************************************** */

/* BEGIN:****************** öֵ  Enumeration value ***************************************************** */
/**
 * @brief ͨ״̬ öٶ Channel status Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVChannelStatus
{
    NETDEV_CHL_STATUS_OFFLINE   = 0,            /* ͨ  Channel offline */
    NETDEV_CHL_STATUS_ONLINE    = 1,             /* ͨ  Channel online */
    NETDEV_CHL_STATUS_UNBIND    = 2,             /* ͨ  Channel unbind */
    NETDEV_CHL_STATUS_INVALID
}NETDEV_CHANNEL_STATUS_E;

/**
 * @brief ͨ öٶ Channel type Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVChannelType
{
    NETDEV_CHL_TYPE_DIGITAL = 0,            /* ͨ  Digital Channel */
    NETDEV_CHL_TYPE_ANALOG = 1,             /* ģͨ  analog Channel */
    NETDEV_CHL_TYPE_INVALID
}NETDEV_CHANNEL_TYPE_E;

/**
 * @brief ͨ½豸(2018-07-26 ĿǰNVRʹ) öٶ Channel device type Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVChannelCameraType
{
    NETDEV_CHL_CAMERA_TYPE_FIXED        = 0,        /* ̶  fixed camera */
    NETDEV_CHL_CAMERA_TYPE_PTZ          = 1,        /* ̨  PTZ camera */
    NETDEV_CHL_CAMERA_TYPE_FISH_EYE     = 2,        /* ۾ͷ+ܣfish-eye camera */
    NETDEV_CHL_CAMERA_TYPE_WIDE_ANGLE   = 3,        /* ۾ͷӽǵľͷ  ǲ߱ܣwide-Angle camera*/
    
    NETDEV_CHL_CAMERA_TYPE_INVALID      = 0xff
}NETDEV_CHANNEL_CAMERA_TYPE_E;

/**
 * @brief Ƶʽ öٶ
 * @attention  None
 */
typedef enum tagNETDEVVideoStandard
{
    NETDEV_VIDEO_STANDARD_PAL       = 0,        /* PAL */
    NETDEV_VIDEO_STANDARD_NTSC      = 1,        /* NTSC */
    NETDEV_VIDEO_STANDARD_INVALID   = 0xFF      /* Чֵ  Invalid value */
}NETDEV_VIDEO_STANDARD_E;

/**
 * @brief  öٶ Camera type Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVCameraType
{
    NETDEV_CAMERA_TYPE_FIX         = 0,            /* ̶  Fixed camera */
    NETDEV_CAMERA_TYPE_PTZ         = 1,            /* ̨  PTZ camera */

    NETDEV_CAMERA_TYPE_INVALID     = 0xFF          /* Чֵ  Invalid value */
}NETDEV_CAMERA_TYPE_E;

/**
 * @brief ʵҵ öٶ  Live stream index Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVLiveStreamIndex
{
    NETDEV_LIVE_STREAM_INDEX_MAIN       = 0,    /*   Main stream */
    NETDEV_LIVE_STREAM_INDEX_AUX        = 1,    /*   Sub stream */
    NETDEV_LIVE_STREAM_INDEX_THIRD      = 2,    /*   Third stream */
	NETDEV_LIVE_STREAM_INDEX_FOUTH      = 3,    /* Ƭ*

    NETDEV_LIVE_STREAM_INDEX_INVALID    = 0xFF  /* Чֵ  Invalid value */
}NETDEV_LIVE_STREAM_INDEX_E;

/**
 * @brief IPЭ öٶ  Protocol type Enumeration definition
 * @attention  None
 */
typedef enum tagHOSTType
{
    NETDEV_NETWORK_HOSTTYPE_IPV4    = 0,        /* IPv4 */
    NETDEV_NETWORK_HOSTTYPE_IPV6    = 1,        /* IPv6 */
    NETDEV_NETWORK_HOSTTYPE_DNS     = 2,         /*  */

    NETDEV_NETWORK_HOSTTYPE_INVALID     = 0xFF      /* Чֵ  Invalid value */
}NETDEV_HOSTTYPE_E;


/**
 * @brief ý崫Э öٶ  Media transport protocol Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVProtocal
{
    NETDEV_TRANSPROTOCAL_RTPUDP     = 0,    /* UDP */
    NETDEV_TRANSPROTOCAL_RTPTCP     = 1,     /* TCP */
	NETDEV_TRANSPROTOCAL_UNIVIEW1_TCP = 2   /* TCPUniview1 ģʽ */
}NETDEV_PROTOCAL_E;

/**
 * @brief ģʽ öٶ  start stream mode Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVStreamMode
{
    NETDEV_STREAM_MODE_ALL      = 0x0000,   /* Ƶ + Ƶ audio & Video */
    NETDEV_STREAM_MODE_VIDEO    = 0x8000    /* Ƶ only video */
}NETDEV_STREAM_MODE_E;

/**
 * @brief ýļʽ öٶ  Media file format Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVMediaFileFormat
{
    NETDEV_MEDIA_FILE_MP4                   = 0,    /* MP4ʽýļ(Ƶ+Ƶ)  mp4 media file (Audio + Video) */
    NETDEV_MEDIA_FILE_TS                    = 1,    /* TSʽýļ(Ƶ+Ƶ)   TS media file (Audio + Video) */
    NETDEV_MEDIA_FILE_MP4_ADD_TIME          = 2,    /* MP4ʽýļ(Ƶ+Ƶ) ,ļʱ  MP4 media file with time in file name (Audio + Video) */
    NETDEV_MEDIA_FILE_TS_ADD_TIME           = 3,    /* TSʽýļ(Ƶ+Ƶ) ,ļʱ  TS media file with time in file name (Audio + Video) */
    NETDEV_MEDIA_FILE_AUDIO_TS              = 4,    /* TSʽƵļ(Ƶ)   TS audio file (Only audio) */
    NETDEV_MEDIA_FILE_AUDIO_MP4             = 5,    /* MP4ʽƵļ(Ƶ)   MP4 audio file (Only audio) */
    NETDEV_MEDIA_FILE_AUDIO_TS_ADD_TIME     = 6,    /* TSʽƵļ(Ƶ),ļʱ  TS audio file with time in file name (Only audio) */
    NETDEV_MEDIA_FILE_AUDIO_MP4_ADD_TIME    = 7,    /* MP4ʽƵļ(Ƶ),ļʱ  MP4 audio file with time in file name (Only audio) */
    NETDEV_MEDIA_FILE_MP4_ADD_RCD_TIME      = 8,    /* MP4ʽýļ(Ƶ+Ƶ)ļʼʱ  MP4 media file with start and end times in file name (Audio + Video)*/
    NETDEV_MEDIA_FILE_TS_ADD_RCD_TIME       = 9,    /* TSʽýļ(Ƶ+Ƶ)ļʼʱ  TS media file with start and end times in file name (Audio + Video)*/
    NETDEV_MEDIA_FILE_AUDIO_MP4_ADD_RCD_TIME= 10,   /* MP4ʽƵļ(Ƶ)ļʼʱ  MP4 audio file with start and end times in file name (Only audio)*/
    NETDEV_MEDIA_FILE_AUDIO_TS_ADD_RCD_TIME = 11,   /* TSʽƵļ(Ƶ)ļʼʱ  TS audio file with start and end times in file name (Only audio)*/
    NETDEV_MEDIA_FILE_VIDEO_MP4_ADD_RCD_TIME= 12,   /* MP4ʽýļ(Ƶ)  mp4 media file (Only video) */
    NETDEV_MEDIA_FILE_VIDEO_TS_ADD_RCD_TIME = 13,   /* TSʽýļ(Ƶ)  ts media file (Only video) */

    NETDEV_MEDIA_FILE_AVI                   = 14,   /* AVIʽýļ(Ƶ+Ƶ)   AVI media file (Audio + Video) */
    NETDEV_MEDIA_FILE_AVI_ADD_TIME          = 15,   /* AVIʽýļ(Ƶ+Ƶ)ļʼʱ  AVI media file with start and end times in file name (Audio + Video)*/
    NETDEV_MEDIA_FILE_AUDIO_AVI             = 16,   /* AVIʽƵļ(Ƶ)   AVI audio file (Only audio) */
    NETDEV_MEDIA_FILE_AUDIO_AVI_ADD_TIME    = 17,   /* AVI(Ƶ),ļʱ  AVI audio file with time in file name (Only audio)*/
    NETDEV_MEDIA_FILE_AVI_ADD_RCD_TIME      = 18,   /* AVIʽƵļ(Ƶ+Ƶ)ļʼʱ  AVI audio file with start and end times in file name (Audio + Video)*/
    NETDEV_MEDIA_FILE_AUDIO_AVI_ADD_RCD_TIME= 19,   /* AVIʽƵļ(Ƶ)ļʼʱ  AVI audio file with start and end times in file name (Only audio)*/
    NETDEV_MEDIA_FILE_VIDEO_AVI_ADD_RCD_TIME= 20,   /* AVIʽýļ(Ƶ)  AVI media file (Only video) */

    NETDEV_MEDIA_FILE_INVALID
}NETDEV_MEDIA_FILE_FORMAT_E;

/**
 * @brief Ƶʽ öٶ  Player Video encoding format Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVPlayerVideoCodeType
{
    NETDEV_PLAYER_VIDEO_CODE_MPEG2     = 0,          /* MPEG-2 */
    NETDEV_PLAYER_VIDEO_CODE_MPEG4     = 1,          /* MPEG-4 */
    NETDEV_PLAYER_VIDEO_CODE_H264      = 2,          /* H.264 */
    NETDEV_PLAYER_VIDEO_CODE_MJPEG     = 3,          /* MJPEG */
    NETDEV_PLAYER_VIDEO_CODE_H265      = 4,          /* H.265 */

    NETDEV_PLAYER_VIDEO_CODE_INVALID
}NETDEV_PLAYER_VIDEO_CODE_TYPE_E;

/**
 * @brief Ƶʽ öٶ  Video encoding format Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVVideoCodeType
{
    NETDEV_VIDEO_CODE_MJPEG     = 0,          /* MJPEG */
    NETDEV_VIDEO_CODE_H264      = 1,          /* H.264 */
    NETDEV_VIDEO_CODE_H265      = 2,          /* H.265 */
    NETDEV_VIDEO_CODE_INVALID
}NETDEV_VIDEO_CODE_TYPE_E;

/**
 * @brief Ƶ֡ öٶ  Video frame type Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVVideoFrameType
{
    NETDEV_VIDEO_FRAME_I    = 0,               /* I-frame */
    NETDEV_VIDEO_FRAME_P    = 1,               /* P-frame */
    NETDEV_VIDEO_FRAME_B    = 2                /* B-frame */
}NETDEV_VIDEO_FRAME_TYPE_E;

/**
* @brief Ƶʽ Audio encode type
* @attention  None
*/
typedef enum tagNetDEVAudioEncodeType
{
    NETDEV_AUDIO_ENCODE_G711U   = 0,          /* ƵG.711Uɱ׼ Audio up to G.711U-law standard*/
    NETDEV_AUDIO_ENCODE_MP2     = 1,          /* ƵMP2׼ Audio up to MP2 standard */
    NETDEV_AUDIO_ENCODE_AAC     = 2,          /* ƵAAC׼ Audio up to AAC standard*/
    NETDEV_AUDIO_ENCODE_G711A   = 3,          /* ƵG.711Aɱ׼ Audio up to G.711A-law standard*/
    NETDEV_AUDIO_ENCODE_PCM     = 4,          /* ƵPCMɱ׼ Audio up to PCM law standard*/
    NETDEV_AUDIO_ENCODE_NULL    = 5           /* Ƶ No audio */
}NETDEV_AUDIO_ENCODE_TYPE_E;

/**
* @brief Ƶʽ Wave format info
* @attention   None
*/
typedef enum tagNetDEVWaveFormatInfo
{
    NETDEV_WAVE_FORMAT_PCM8M16        = 0,        /* PCM,8K,,16λ PCM,8k sampling rate,16 bit sampling*/
    NETDEV_WAVE_FORMAT_PCM16M16       = 1,        /* PCM,16K,,16λ PCM,16k sampling rate,16 bit sampling*/
    NETDEV_WAVE_FORMAT_PCM441M16      = 2,        /* PCM,44.1K,,16λ PCM,44.1k sampling rate,16 bit sampling*/
    NETDEV_WAVE_FORMAT_PCM11025M16    = 3,        /* PCM,11.025K,,16λ PCM,11.025k sampling rate,16 bit sampling*/
    NETDEV_WAVE_FORMAT_PCM8_RIGHT     = 4,        /* PCM8Kʣ PCM,8k sampling rate,right channel*/
    NETDEV_WAVE_FORMAT_PCM_NORMAL     = 5,        /* PCMͨģʽ PCM,general mode*/
    NETDEV_WAVE_FORMAT_PCM48000M16    = 6,        /* PCM48.0KʣM16λ PCM,48.0k sampling rate,single track,16 bit sampling*/
    NETDEV_WAVE_FORMAT_UNKNOWN
}NETDEV_WAVE_FORMAT_INFO_E;

/**
 * @brief Ƶʾ öٶ  Video display ratio Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVRenderScale
{
    NETDEV_RENDER_SCALE_FULL        = 0,                  /* ͼŴ  Stretch */
    NETDEV_RENDER_SCALE_PROPORTION  = 1,                  /* ͼ񰴱ʾ  Scale */

    NETDEV_RENDER_SCALE_INVALID     = 0xFF
}NETDEV_RENDER_SCALE_E;

/**
 * @brief ͼƬʽ öٶ Picture type Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVPictureFormat
{
    NETDEV_PICTURE_BMP = 0,                  /* ͼƬʽΪbmpʽ  Picture format is bmp */
    NETDEV_PICTURE_JPG = 1,                  /* ͼƬʽΪjpgʽ  Picture format is jpg */

    NETDEV_PICTURE_INVALID
}NETDEV_PICTURE_FORMAT_E;

/**
 * @brief Ƶͼ öٶ  Video image quality Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVVideoQuality
{
    NETDEV_VQ_L0 = 0,                    /*   Highest */
    NETDEV_VQ_L1 = 1,
    NETDEV_VQ_L2 = 4,                    /* ϸ  Higher */
    NETDEV_VQ_L3 = 8,
    NETDEV_VQ_L4 = 12,                   /*   Medium */
    NETDEV_VQ_L5 = 16,
    NETDEV_VQ_L6 = 20,                   /*   Low */
    NETDEV_VQ_L7 = 24,
    NETDEV_VQ_L8 = 28,                   /* ϵ  Lower */
    NETDEV_VQ_L9 = 31,                   /*   Lowest */

    NETDEV_VQ_LEVEL_INVALID = -1         /* Ч  Valid */
}NETDEV_VIDEO_QUALITY_E;

/**
 * @brief ͼֱ öٶ Image resolution Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVPictureSize
{
    NETDEV_PICTURE_SIZE_D1     = 0,           /* D1 */
    NETDEV_PICTURE_SIZE_4CIF   = 1,           /* 4CIF */
    NETDEV_PICTURE_SIZE_2CIF   = 2,           /* 2CIF */
    NETDEV_PICTURE_SIZE_CIF    = 3,           /* CIF */
    NETDEV_PICTURE_SIZE_960H   = 4,           /* 960H */
    NETDEV_PICTURE_SIZE_QCIF   = 5,           /* QCIF */
    NETDEV_PICTURE_SIZE_HALFD1 = 6,           /* HALFD1 */
    NETDEV_PICTURE_SIZE_720    = 7,           /* 720 */
    NETDEV_PICTURE_SIZE_1080   = 8,           /* 1080 */
    NETDEV_PICTURE_SIZE_XGA    = 9,           /* 1024*768 */
    NETDEV_PICTURE_SIZE_SXGA   = 10,          /* 1280*1024 */

    NETDEV_PICTURE_SIZE_INVALID               /* Чֵ  Invalid value */
}NETDEV_PICTURE_SIZE_E;

/**
 * @brief ̨ öٶ PTZ commands Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVPtzCmdEnum
{
    NETDEV_PTZ_IRISCLOSE_STOP       =0x0101,       /* Ȧֹͣ  Iris close stop */
    NETDEV_PTZ_IRISCLOSE            =0x0102,       /* Ȧ  Iris close */
    NETDEV_PTZ_IRISOPEN_STOP        =0x0103,       /* Ȧֹͣ  Iris open stop */
    NETDEV_PTZ_IRISOPEN             =0x0104,       /* Ȧ  Iris open */

    NETDEV_PTZ_FOCUSNEAR_STOP       =0x0201,       /* ۼֹͣ  Focus near stop */
    NETDEV_PTZ_FOCUSNEAR            =0x0202,       /* ۼ  Focus near */
    NETDEV_PTZ_FOCUSFAR_STOP        =0x0203,       /* Զۼֹͣ  Focus far stop */
    NETDEV_PTZ_FOCUSFAR             =0x0204,       /* Զۼ  Focus far */

    NETDEV_PTZ_ZOOMTELE_STOP        = 0x0301,       /* Ŵֹͣ  Zoom in stop */
    NETDEV_PTZ_ZOOMTELE             = 0x0302,       /* Ŵ  Zoom in */
    NETDEV_PTZ_ZOOMWIDE_STOP        = 0x0303,       /* Сֹͣ  Zoom out stop */
    NETDEV_PTZ_ZOOMWIDE             = 0x0304,       /* С  Zoom out */
    NETDEV_PTZ_TILTUP               = 0x0402,       /*   Tilt up */
    NETDEV_PTZ_TILTDOWN             = 0x0404,       /*   Tilt down */
    NETDEV_PTZ_PANRIGHT             = 0x0502,       /*   Pan right */
    NETDEV_PTZ_PANLEFT              = 0x0504,       /*   Pan left */
    NETDEV_PTZ_LEFTUP               = 0x0702,       /*   Move up left */
    NETDEV_PTZ_LEFTDOWN             = 0x0704,       /*   Move down left */
    NETDEV_PTZ_RIGHTUP              = 0x0802,       /*   Move up right */
    NETDEV_PTZ_RIGHTDOWN            = 0x0804,       /*   Move down right */

#if 0
    NETDEV_PTZ_PRESAVE              = 0x0601,       /* Ԥλ  Save preset */
    NETDEV_PTZ_PRECALL              = 0x0602,       /* Ԥλ  Call preset */
    NETDEV_PTZ_PREDEL               = 0x0603,       /* Ԥλɾ  Delete preset */
#endif

    NETDEV_PTZ_ALLSTOP              = 0x0901,       /* ȫͣ  All-stop command word */
    NETDEV_PTZ_FOCUS_AND_IRIS_STOP  = 0x0907,       /* ۽.Ȧֹͣ  Focus & Iris-stop command word */
    NETDEV_PTZ_MOVE_STOP            = 0x0908,       /* ƶֹͣ  move stop command word */
    NETDEV_PTZ_ZOOM_STOP            = 0x0909,       /* 䱶ֹͣ  zoom stop command word */

    NETDEV_PTZ_TRACKCRUISE          = 0x1001,       /* ʼ켣Ѳ  Start route patrol*/
    NETDEV_PTZ_TRACKCRUISESTOP      = 0x1002,       /* ֹͣ켣Ѳ  Stop route patrol*/
    NETDEV_PTZ_TRACKCRUISEREC       = 0x1003,       /* ʼ¼ƹ켣  Start recording route */
    NETDEV_PTZ_TRACKCRUISERECSTOP   = 0x1004,       /* ֹͣ¼ƹ켣  Stop recording route */
    NETDEV_PTZ_TRACKCRUISEADD       = 0x1005,       /* Ѳ켣  Add patrol route */
    NETDEV_PTZ_TRACKCRUISEDEL       = 0x1006,       /* ɾ켣Ѳ  Delete patrol route */

    NETDEV_PTZ_AREAZOOMIN           = 0x1101,       /* Ŵ  Zoom in area */
    NETDEV_PTZ_AREAZOOMOUT          = 0x1102,       /* С  Zoom out area */
    NETDEV_PTZ_AREAZOOM3D           = 0x1103,       /* 3Dλ  3D positioning */

    NETDEV_PTZ_BRUSHON              = 0x0A01,       /* ˢ  Wiper on */
    NETDEV_PTZ_BRUSHOFF             = 0x0A02,       /* ˢ  Wiper off */

    NETDEV_PTZ_LIGHTON              = 0x0B01,       /* ƿ  Lamp on */
    NETDEV_PTZ_LIGHTOFF             = 0x0B02,       /* ƹ  Lamp off */

    NETDEV_PTZ_HEATON               = 0x0C01,       /* ȿ  Heater on */
    NETDEV_PTZ_HEATOFF              = 0x0C02,       /* ȹ  Heater off */

    NETDEV_PTZ_SNOWREMOINGON        = 0x0E01,       /* ѩ  Snowremoval on */
    NETDEV_PTZ_SNOWREMOINGOFF       = 0x0E02,       /* ѩ  Snowremoval off  */

    NETDEV_PTZ_INFRAREDON           = 0x0D01,       /* ⿪  IR on */
    NETDEV_PTZ_INFRAREDOFF          = 0x0D02,       /*   IR off */

    NETDEV_PTZ_SELF_CHECKING        = 0x1801,       /* Լ:dwSpeedΪ1ʱ,ִ̨Լ;Ϊ0ʱ,ִлָ̨Ĭ,ʱ */

#if 0
    NETDEV_PTZ_ABSPOSITION          = 0x0902,       /* ԽǶ  Set absolute position of camera */
    NETDEV_PTZ_GUARD                = 0x0903,       /* ؿλ,̨ģ  Return to home position (this command is not implemented on the PTZ template) */
    NETDEV_PTZ_SPEEDSET             = 0x0904,       /* ٶ  Set speed */

    NETDEV_PTZ_PRESETCRUISE         = 0x1001,       /* ̨ԤλѲ ,ֲ̨ģ  Preset-based PTZ patrol (the command word is not implemented on the PTZ template) */
    NETDEV_PTZ_PRESETCRUISESTOP     = 0x1002,       /* ̨ԤλѲֹͣ,ֲ̨ģ  Preset-based PTZ patrol stop (the command word is not implemented on the PTZ template) */
    NETDEV_PTZ_CRUISEDEL            = 0X1003,       /* ɾ·  Delete route */
    NETDEV_PTZ_CRUISEADDPRESET      = 0x1004,       /* ·Ԥλ  Add preset to route */
    NETDEV_PTZ_CRUISEADDSTART       = 0x1005,       /* ʼ·Ԥλ  Start adding preset to route */
    NETDEV_PTZ_CRUISEADDSTOP        = 0x1006,       /* ·Ԥλ  Stop adding preset to route */
#endif

    NETDEV_PTZ_INVALID

} NETDEV_PTZ_E;

/**
 * @brief ̨Ԥλ öٶ PTZ preset operation commands Enumeration Definition
 * @attention  None
 */
typedef enum tagNETDEVPtzPresetCmd
{
    NETDEV_PTZ_SET_PRESET   = 0,            /* Ԥλ  Set preset */
    NETDEV_PTZ_CLE_PRESET   = 1,            /* Ԥλ  Clear preset */
    NETDEV_PTZ_GOTO_PRESET  = 2             /* תԤλ  Go to preset */
}NETDEV_PTZ_PRESETCMD_E;

/**
 * @brief ̨Ѳ öٶ PTZ patrol operation commands Enumeration Definition
 * @attention  None
 */
typedef enum tagNETDEVPTZCruiseCmd
{
    NETDEV_PTZ_ADD_CRUISE      = 0,         /* Ѳ·   Add patrol route */
    NETDEV_PTZ_MODIFY_CRUISE   = 1,         /* ༭Ѳ·  Edit patrol route */
    NETDEV_PTZ_DEL_CRUISE      = 2,         /* ɾѲ·  Delete patrol route */
    NETDEV_PTZ_RUN_CRUISE      = 3,         /* ʼѲ  Start patrol */
    NETDEV_PTZ_STOP_CRUISE     = 4,          /* ֹͣѲ  Stop patrol */
    NETDEV_PTZ_GET_CRUISE      = 5         /* ȡѲ·  */    /* Get patrol route */
}NETDEV_PTZ_CRUISECMD_E;

/**
 * @brief طſ öٶ Playback control commands Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVPlayControl
{
    NETDEV_PLAY_CTRL_PLAY                       = 0,        /* ʼ  Play */
    NETDEV_PLAY_CTRL_PAUSE                      = 1,        /* ͣ  Pause */
    NETDEV_PLAY_CTRL_RESUME                     = 2,        /* ָ  Resume */
    NETDEV_PLAY_CTRL_GETPLAYTIME                = 3,        /* ȡŽ  Obtain playing time */
    NETDEV_PLAY_CTRL_SETPLAYTIME                = 4,        /* òŽ  Configure playing time */
    NETDEV_PLAY_CTRL_GETPLAYSPEED               = 5,        /* ȡٶ  Obtain playing speed */
    NETDEV_PLAY_CTRL_SETPLAYSPEED               = 6,        /* òٶ  Configure playing speed */
    NETDEV_PLAY_CTRL_SET_SINGLE_FRAME_SPEED     = 7,        /* õ֡  Configure single frame playing speed */
    NETDEV_PLAY_CTRL_UPDATE_M3U8URL             = 8         /* M3u8URL  urlUpdate M3u8 url */
}NETDEV_VOD_PLAY_CTRL_E;

/**
 * @brief ط.״̬ öٶ Playback and download status Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVVodPlayStatus
{
    /** ״̬  Play status */
    NETDEV_PLAY_STATUS_16_BACKWARD          = 0,            /* 16ٺ˲  Backward at 16x speed */
    NETDEV_PLAY_STATUS_8_BACKWARD           = 1,            /* 8ٺ˲  Backward at 8x speed */
    NETDEV_PLAY_STATUS_4_BACKWARD           = 2,            /* 4ٺ˲  Backward at 4x speed */
    NETDEV_PLAY_STATUS_2_BACKWARD           = 3,            /* 2ٺ˲  Backward at 2x speed */
    NETDEV_PLAY_STATUS_1_BACKWARD           = 4,            /* ٶȺ˲  Backward at normal speed */
    NETDEV_PLAY_STATUS_HALF_BACKWARD        = 5,            /* 1/2ٺ˲  Backward at 1/2 speed */
    NETDEV_PLAY_STATUS_QUARTER_BACKWARD     = 6,            /* 1/4ٺ˲  Backward at 1/4 speed */
    NETDEV_PLAY_STATUS_QUARTER_FORWARD      = 7,            /* 1/4ٲ  Play at 1/4 speed */
    NETDEV_PLAY_STATUS_HALF_FORWARD         = 8,            /* 1/2ٲ  Play at 1/2 speed */
    NETDEV_PLAY_STATUS_1_FORWARD            = 9,            /* ٶǰ  Forward at normal speed */
    NETDEV_PLAY_STATUS_2_FORWARD            = 10,           /* 2ǰ  Forward at 2x speed */
    NETDEV_PLAY_STATUS_4_FORWARD            = 11,           /* 4ǰ  Forward at 4x speed */
    NETDEV_PLAY_STATUS_8_FORWARD            = 12,           /* 8ǰ  Forward at 8x speed */
    NETDEV_PLAY_STATUS_16_FORWARD           = 13,           /* 16ǰ  Forward at 16x speed */
    NETDEV_PLAY_STATUS_2_FORWARD_IFRAME     = 14,           /* 2ǰ(I֡) Forward at 2x speed(I frame) */
    NETDEV_PLAY_STATUS_4_FORWARD_IFRAME     = 15,           /* 4ǰ(I֡) Forward at 4x speed(I frame) */
    NETDEV_PLAY_STATUS_8_FORWARD_IFRAME     = 16,           /* 8ǰ(I֡) Forward at 8x speed(I frame) */
    NETDEV_PLAY_STATUS_16_FORWARD_IFRAME    = 17,           /* 16ǰ(I֡) Forward at 16x speed(I frame) */
    NETDEV_PLAY_STATUS_2_BACKWARD_IFRAME    = 18,           /* 2ٺ˲(I֡) Backward at 2x speed(I frame) */
    NETDEV_PLAY_STATUS_4_BACKWARD_IFRAME    = 19,           /* 4ٺ˲(I֡) Backward at 4x speed(I frame) */
    NETDEV_PLAY_STATUS_8_BACKWARD_IFRAME    = 20,           /* 8ٺ˲(I֡) Backward at 8x speed(I frame) */
    NETDEV_PLAY_STATUS_16_BACKWARD_IFRAME   = 21,           /* 16ٺ˲(I֡) Backward at 16x speed(I frame) */
    NETDEV_PLAY_STATUS_INTELLIGENT_FORWARD  = 22,           /* ܲ Intelligent forward */
    NETDEV_PLAY_STATUS_1_FRAME_FORWD        = 23,           /* ֡ǰ  Forward at 1 frame speed */
    NETDEV_PLAY_STATUS_1_FRAME_BACK         = 24,           /* ֡˲ Backward at 1 frame speed */

    NETDEV_PLAY_STATUS_40_FORWARD           = 25,           /* 40ǰ Forward at 40x speed*/

    NETDEV_PLAY_STATUS_32_FORWARD_IFRAME    = 26,           /* 32ٳ֡ǰ Forward at 32x speed(I frame)*/
    NETDEV_PLAY_STATUS_32_BACKWARD_IFRAME   = 27,           /* 32ٳ֡˲ Backward at 32x speed(I frame)*/
    NETDEV_PLAY_STATUS_64_FORWARD_IFRAME    = 28,           /* 64ٳ֡ǰ Forward at 64x speed(I frame)*/
    NETDEV_PLAY_STATUS_64_BACKWARD_IFRAME   = 29,           /* 64ٳ֡˲ Backward at 64x speed(I frame)*/
    NETDEV_PLAY_STATUS_128_FORWARD_IFRAME   = 30,           /* 128ٳ֡ǰ Forward at 128x speed(I frame)*/
    NETDEV_PLAY_STATUS_128_BACKWARD_IFRAME  = 31,           /* 128ٳ֡˲ Backward at 128x speed(I frame)*/
    NETDEV_PLAY_STATUS_256_FORWARD_IFRAME   = 32,           /* 256ٳ֡ǰ Forward at 256x speed(I frame)*/
    NETDEV_PLAY_STATUS_256_BACKWARD_IFRAME  = 33,           /* 256ٳ֡˲ Backward at 256x speed(I frame)*/

    NETDEV_PLAY_STATUS_32_FORWARD           = 34,           /* 32ǰ */
    NETDEV_PLAY_STATUS_32_BACKWARD          = 35,           /* 32ٺ˲ */

    NETDEV_PLAY_STATUS_INVALID
}NETDEV_VOD_PLAY_STATUS_E;

/**
 * @brief ¼ٶ  Recording download speed
 * @attention  None
 */
typedef enum tagNETDEVDownloadSpeed
{
    NETDEV_DOWNLOAD_SPEED_ONE           = 0,            /* һ */
    NETDEV_DOWNLOAD_SPEED_TWO           = 1,            /*  */
    NETDEV_DOWNLOAD_SPEED_FOUR          = 2,            /* ı */
    NETDEV_DOWNLOAD_SPEED_EIGHT         = 3,            /* ˱ */
    NETDEV_DOWNLOAD_SPEED_TWO_IFRAME    = 4,            /* I֡ */
    NETDEV_DOWNLOAD_SPEED_FOUR_IFRAME   = 5,            /* ıI֡ */
    NETDEV_DOWNLOAD_SPEED_EIGHT_IFRAME  = 6,            /* ˱I֡ */
    NETDEV_DOWNLOAD_SPEED_HALF          = 7,            /* 1/2  1/2x */
    NETDEV_DOWNLOAD_SPEED_FORTY         = 8,            /* 40 40x */

    NETDEV_DOWNLOAD_SPEED_INVALID       = 0xFF          /* Чֵ */
}NETDEV_E_DOWNLOAD_SPEED_E;

/**
 * @brief ¼洢 öٶ Recording storage type Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVStoreType
{
    NETDEV_TYPE_STORE_TYPE_ALL                  = 0,            /* 洢  All */

    NETDEV_EVENT_STORE_TYPE_NORMAL              = 1,            /* 洢ЯļС,  All */
    NETDEV_EVENT_STORE_TYPE_MOTIONDETECTION     = 4,            /* ˶¼洢ЯļС  Motion detection */
    NETDEV_EVENT_STORE_TYPE_DIGITALINPUT        = 5,            /* ¼洢ЯļС  Digital input */
    NETDEV_EVENT_STORE_TYPE_VIDEOLOSS           = 7,            /* Ƶʧ¼洢ЯļС  Video loss */

    NETDEV_TYPE_STORE_TYPE_INVALID              = 0xFF          /* Чֵ  Invalid value */
}NETDEV_PLAN_STORE_TYPE_E;

/**
* @brief Ƶλ
* @attention 
*/
typedef enum tagNetDevAudioSampleFormatType
{
    NETDEV_AUDIO_SAMPLE_FMT_NONE = -1,
    NETDEV_AUDIO_SAMPLE_FMT_U8      = 0,            /* ޷8λ */
    NETDEV_AUDIO_SAMPLE_FMT_S16     = 1,            /* з16λ */
    NETDEV_AUDIO_SAMPLE_FMT_S32     = 2,            /* з32λ */
    NETDEV_AUDIO_SAMPLE_FMT_FLT     = 3,            /*  */
    NETDEV_AUDIO_SAMPLE_FMT_DBL     = 4             /* double */
}NETDEV_AUDIO_SAMPLE_FORMAT_E;

/**
 * @brief 쳣صϢ öٶ Exception callback message types Enumeration definition 
 * @attention  None
 */
typedef enum tagNETDEVException
{
    /* طҵ쳣ϱ  Playback exceptions report 300~399 */
    NETDEV_EXCEPTION_REPORT_VOD_END             = 300,          /* طŽ  Playback ended*/
    NETDEV_EXCEPTION_REPORT_VOD_ABEND           = 301,          /* ط쳣  Playback exception occured */
    NETDEV_EXCEPTION_REPORT_BACKUP_END          = 302,          /* ݽ  Backup ended */
    NETDEV_EXCEPTION_REPORT_BACKUP_DISC_OUT     = 303,          /* ̱γ  Disk removed */
    NETDEV_EXCEPTION_REPORT_BACKUP_DISC_FULL    = 304,          /*   Disk full */
    NETDEV_EXCEPTION_REPORT_BACKUP_ABEND        = 305,          /* ԭ±ʧ   Backup failure caused by other reasons */

    NETDEV_EXCEPTION_EXCHANGE                   = 0x8000,       /* ûʱ쳣ûʱ  Exception occurred during user interaction (keep-alive timeout) */
    NETDEV_EXCEPTION_REPORT_ALARM_INTERRUPT     = 0x8001,       /* 澯ϱ쳣 ʧܻ߳ӶϿ Failure to report abnormal termination of life preservation or disconnection of long connection */

    NETDEV_EXCEPTION_REPORT_MAX,                                /* ֵ  Maximum value */
    NETDEV_EXCEPTION_REPORT_NOT_VALID_PERIOD,                   /* Ч Not Valid period */
    NETDEV_EXCEPTION_REPORT_NOT_VALID_TIME,                     /* Чʱ Not Valid Time */

    NETDEV_EXCEPTION_REPORT_INVALID             = 0xFFFF        /* Чֵ  Invalid value */
}NETDEV_EXCEPTION_TYPE_E;

/**
 * @brief 澯ò öٶ  Alarm configuration operation Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVAlarmTypeEn
{
    NETDEV_ALARM_MOVE_DETECT                = 1,        /* ˶澯  Motion detection alarm */
    NETDEV_ALARM_MOVE_DETECT_RECOVER        = 2,        /* ˶澯ָ  Motion detection alarm recover */
    NETDEV_ALARM_VIDEO_LOST                 = 3,        /* Ƶʧ澯  Video loss alarm */
    NETDEV_ALARM_VIDEO_LOST_RECOVER         = 4,        /* Ƶʧ澯ָ  Video loss alarm recover */
    NETDEV_ALARM_VIDEO_TAMPER_DETECT        = 5,        /* ڵ澯  Tampering detection alarm */
    NETDEV_ALARM_VIDEO_TAMPER_RECOVER       = 6,        /* ڵ澯ָ  Tampering detection alarm recover */
    NETDEV_ALARM_INPUT_SWITCH               = 7,        /* 뿪澯  boolean input alarm */
    NETDEV_ALARM_INPUT_SWITCH_RECOVER       = 8,        /* 뿪澯ָ  Boolean input alarm recover */
    NETDEV_ALARM_TEMPERATURE_HIGH           = 9,        /* ¸澯  High temperature alarm */
    NETDEV_ALARM_TEMPERATURE_LOW            = 10,       /* ¸澯  Low temperature alarm */
    NETDEV_ALARM_TEMPERATURE_RECOVER        = 11,       /* ¶ȸ澯ָ  Temperature alarm recover */
    NETDEV_ALARM_AUDIO_DETECT               = 12,       /* Ƶ쳣澯  Audio detection alarm */
    NETDEV_ALARM_AUDIO_DETECT_RECOVER       = 13,       /* Ƶ쳣澯ָ  Audio detection alarm recover */
    NETDEV_ALARM_SERVER_FAULT               = 18,       /*  */
    NETDEV_ALARM_SERVER_NORMAL              = 19,       /* ϻָ */
    

    NETDEV_ALARM_REPORT_DEV_ONLINE          = 201,       /* 豸߸澯 */
    NETDEV_ALARM_REPORT_DEV_OFFLINE         = 202,       /* 豸߸澯 */
    NETDEV_ALARM_REPORT_DEV_REBOOT          = 203,       /* 豸  Device restart */
    NETDEV_ALARM_REPORT_DEV_SERVICE_REBOOT  = 204,       /*   Service restart */
    NETDEV_ALARM_REPORT_DEV_CHL_ONLINE      = 205,       /* Ƶͨ:  */
    NETDEV_ALARM_REPORT_DEV_CHL_OFFLINE     = 206,       /* Ƶͨ:  */
    NETDEV_ALARM_REPORT_DEV_DELETE_CHL      = 207,       /* Ƶͨ: ɾ */

    NETDEV_ALARM_DEVICE_HIGHTEMP            = 246,       /* 쳣ࣺ豸 */
    NETDEV_ALARM_DEVICE_LOWTEMP             = 247,       /* 쳣ࣺ豸 */
    NETDEV_ALARM_FAN_FAULT                  = 248,       /* 쳣ࣺȹ */
    NETDEV_ALARM_LEDBOX_HIGHTEMP            = 249,       /* 쳣ࣺ */
    NETDEV_ALARM_LEDBOX_SMOKE               = 250,       /* 쳣ࣺ澯 */
    NETDEV_ALARM_DEVICE_HIGHTEMP_RECOVER    = 251,       /* 쳣:豸¶Ȼָ */
    NETDEV_ALARM_DEVICE_LOWTEMP_RECOVER     = 252,       /* 쳣:豸¶Ȼָ */
    NETDEV_ALARM_FAN_FAULT_RECOVER          = 253,       /* 쳣:ȹϻָ */
    NETDEV_ALARM_LEDBOX_HIGHTEMP_RECOVER    = 254,       /* 쳣:»ָ */
    NETDEV_ALARM_LEDBOX_SMOKE_RECOVER       = 255,       /* 쳣:澯ָ */

    /* ND ϱ澯ģ */
    NETDEV_ALARM_NET_FAILED                 = 401,      /* Ự Network error */
    NETDEV_ALARM_NET_TIMEOUT                = 402,      /* Ự糬ʱ Network timeout */
    NETDEV_ALARM_SHAKE_FAILED               = 403,      /* Ự Interaction error */
    NETDEV_ALARM_STREAMNUM_FULL             = 404,      /* Ѿ Stream full */
    NETDEV_ALARM_STREAM_THIRDSTOP           = 405,      /* ֹͣ Third party stream stopped */
    NETDEV_ALARM_FILE_END                   = 406,      /* ļ File ended */
    NETDEV_ALARM_RTMP_CONNECT_FAIL          = 407,      /* RTMPʧ */
    NETDEV_ALARM_RTMP_INIT_FAIL             = 408,      /* RTMPʼʧ*/
    NETDEV_ALARM_STREAM_DOWNLOAD_OVER       = 409,      /* һ */
    NETDEV_ALARM_PLAYBACK_FINISH            = 410,      /* طŽ */
    NETDEV_ALARM_VIDEO_RECORD_PART          = 411,      /* ¼ֶ */
    NETDEV_ALARM_FISHEYE_STREAM_EXIST       = 412,      /* ,ϱ */
    NETDEV_ALARM_FISHEYE_STREAM_NOT_EXIST   = 413,      /* ,ϱ */
    NETDEV_ALARM_PTZ_RESOUCE_FAIL           = 414,      /* ĿȫptzԴ */
    NETDEV_ALARM_PTZ_STREAM_EXIST           = 415,      /* Ŀȫptzڣϱ */
    NETDEV_ALARM_STREAM_NOT_EXIST           = 416,      /* Ŀȫptzڣϱ */
    NETDEV_ALARM_INNER_TIMEOUT              = 417,      /* ڲʱ */
    NETDEV_ALARM_STREAM_NOT_READY           = 418,      /* δ */
    NETDEV_ALARM_KEEP_ALIVE_FAILED          = 419,      /* ʧ */
    NETDEV_ALARM_OVER_ABILITY               = 420,      /* ط */
    NETDEV_ALARM_UNAUTHORIZED               = 421,      /* δ֤ͨ */
    NETDEV_ALARM_FORIBIDDEN                 = 422,      /* ֹ */
    NETDEV_ALARM_METHOD_NOT_ALLOWED         = 423,      /* ÷ */
    NETDEV_ALARM_PRECONDITION_FAILED        = 424,      /* Ԥʧ */
    NETDEV_ALARM_SESSION_NOT_FOUND          = 425,      /* ҲỰ */
    NETDEV_ALARM_NOT_ENOUGH_BANDWIDTH2      = 426,      /* (RTSP) */
    NETDEV_ALARM_REALPLAY_ESTABLISHED       = 427,      /* ʵҵѾ */
    NETDEV_ALARM_REALPLAY_RES_BUSY          = 428,      /* ʵҵʾԴæ */
    NETDEV_ALARM_MULTICAST_DISABLED         = 429,      /* 鲥ʹܹر */
    NETDEV_ALARM_MULTICAST_PORT_OCCUPIED    = 430,      /* 鲥˿ѱռ */
    NETDEV_ALARM_MULTICAST_PORT_EXHAUSTED   = 431,      /* 鲥˿Ѻľ */
    NETDEV_ALARM_MULTICAST_USER_NOT_EXIST   = 432,      /* 鲥û */
    NETDEV_ALARM_CHANNEL_NOT_ONLINE         = 433,      /* ͨ */
    NETDEV_ALARM_TALKBACK_ENCODED_INVALID   = 434,      /* ԽԴЧ */
    NETDEV_ALARM_VOICE_RES_USED_BY_TALKBACK = 435,      /* ԴѱԽʹ */
    NETDEV_ALARM_TALKBACK_EXISTS            = 436,      /* ԽѴ */
    NETDEV_ALARM_VOICE_WORK_NOT_EXIST       = 437,      /* ҵ񲻴 */
    NETDEV_ALARM_TALKBACK_TIMEOUT           = 438,      /* Խҵʱ */
    NETDEV_ALARM_TALKBACK_ERROR             = 439,      /* Խʧ */

    NETDEV_ALARM_DISK_ERROR                         = 601,      /* 豸̴  Disk error */
    NETDEV_ALARM_SYS_DISK_ERROR                     = 602,      /* ϵͳ̴  Disk error */
    NETDEV_ALARM_DISK_ONLINE                        = 603,      /* 豸 Disk online */
    NETDEV_ALARM_SYS_DISK_ONLINE                    = 604,      /* ϵͳ Disk online */
    NETDEV_ALARM_DISK_OFFLINE                       = 605,      /* 豸 */
    NETDEV_ALARM_SYS_DISK_OFFLINE                   = 606,      /* ϵͳ */
    NETDEV_ALARM_DISK_ABNORMAL                      = 607,      /* 쳣 Disk abnormal */
    NETDEV_ALARM_DISK_ABNORMAL_RECOVER              = 608,      /* 쳣ָ Disk abnormal recover */
    NETDEV_ALARM_DISK_STORAGE_WILL_FULL             = 609,      /* ̴洢ռ伴 Disk StorageGoingfull */
    NETDEV_ALARM_DISK_STORAGE_WILL_FULL_RECOVER     = 610,      /* ̴洢ռ伴ָ Disk StorageGoingfull recover */
    NETDEV_ALARM_DISK_STORAGE_IS_FULL               = 611,      /* 豸洢ռ StorageIsfull */
    NETDEV_ALARM_SYS_DISK_STORAGE_IS_FULL           = 612,      /* ϵͳ洢ռ StorageIsfull */
    NETDEV_ALARM_DISK_STORAGE_IS_FULL_RECOVER       = 613,      /* 洢ռָ StorageIsfull recover */
    NETDEV_ALARM_DISK_RAID_DISABLED_RECOVER         = 614,      /* 𻵻ָ RAIDDisabled recover */
    NETDEV_ALARM_DISK_RAID_DEGRADED                 = 615,      /* 豸˥ RAIDDegraded */
    NETDEV_ALARM_SYS_DISK_RAID_DEGRADED             = 616,      /* ϵͳ˥ RAIDDegraded */
    NETDEV_ALARM_DISK_RAID_DISABLED                 = 617,      /* 豸 RAIDDisabled */
    NETDEV_ALARM_SYS_DISK_RAID_DISABLED             = 618,      /* ϵͳ RAIDDisabled */
    NETDEV_ALARM_DISK_RAID_DEGRADED_RECOVER         = 619,      /* ˥˻ָ RAIDDegraded recover */
    NETDEV_ALARM_STOR_GO_FULL                       = 620,      /* 豸洢澯 */
    NETDEV_ALARM_SYS_STOR_GO_FULL                   = 621,      /* ϵͳ洢澯 */
    NETDEV_ALARM_ARRAY_NORMAL                       = 622,      /* 豸 */
    NETDEV_ALARM_SYS_ARRAY_NORMAL                   = 623,      /* ϵͳ */
    NETDEV_ALARM_DISK_RAID_RECOVERED                = 624,      /* лָ RAIDDegraded */
    NETDEV_ALARM_STOR_ERR                           = 625,      /* 豸洢  Storage error */
    NETDEV_ALARM_SYS_STOR_ERR                       = 626,      /* ϵͳ洢  Storage error */
    NETDEV_ALARM_STOR_ERR_RECOVER                   = 627,      /* 洢ָ  Storage error recover */
    NETDEV_ALARM_STOR_DISOBEY_PLAN                  = 628,      /* δƻ洢  Not stored as planned */
    NETDEV_ALARM_STOR_DISOBEY_PLAN_RECOVER          = 629,      /* δƻ洢ָ  Not stored as planned recover */

    NETDEV_ALARM_BANDWITH_CHANGE                    = 801,      /* 豸ڴ */
    NETDEV_ALARM_VIDEOENCODER_CHANGE                = 802,      /* 豸ñ澯 */
    NETDEV_ALARM_IP_CONFLICT                        = 803,      /* IPͻ쳣澯 IP conflict exception alarm*/
    NETDEV_ALARM_IP_CONFLICT_CLEARED                = 804,      /* IPͻ쳣澯ָIP conflict exception alarm recovery */
    NETDEV_ALARM_NET_OFF                            = 805,      /* Ͽ쳣澯 */
    NETDEV_ALARM_NET_RESUME_ON                      = 806,      /* Ͽָ澯 */

    NETDEV_ALRAM_CONFLAG_DETECT                     = 920,      /* 澯 Conflagration detection alarm */

    NETDEV_ALARM_ILLEGAL_ACCESS                     = 1001,          /* 豸Ƿ  Illegal access */
    NETDEV_ALARM_SYS_ILLEGAL_ACCESS                 = 1002,          /* ϵͳǷ  Illegal access */
    NETDEV_ALARM_LINE_CROSS                         = 1003,          /* Խ澯  Line cross */
    NETDEV_ALARM_OBJECTS_INSIDE                     = 1004,          /*   Objects inside */
    NETDEV_ALARM_FACE_RECOGNIZE                     = 1005,          /* ʶ  Face recognize */
    NETDEV_ALARM_IMAGE_BLURRY                       = 1006,          /* ͼ齹  Image blurry */
    NETDEV_ALARM_SCENE_CHANGE                       = 1007,          /*   Scene change */
    NETDEV_ALARM_SMART_TRACK                        = 1008,          /* ܸ  Smart track */
    NETDEV_ALARM_LOITERING_DETECTOR                 = 1009,          /* ǻ  Loitering Detector */
    NETDEV_ALARM_BANDWIDTH_CHANGE                   = 1010,          /*   Bandwidth change */
    NETDEV_ALARM_ALLTIME_FLAG_END                   = 1011,          /* ޲澯  End marker of alarm without arming schedule */
    NETDEV_ALARM_MEDIA_CONFIG_CHANGE                = 1012,          /*  media configurationchanged */
    NETDEV_ALARM_REMAIN_ARTICLE                     = 1013,          /*Ʒ澯  Remain article*/
    NETDEV_ALARM_PEOPLE_GATHER                      = 1014,          /* Աۼ澯 People gather alarm*/
    NETDEV_ALARM_ENTER_AREA                         = 1015,          /*  Enter area*/
    NETDEV_ALARM_LEAVE_AREA                         = 1016,          /* 뿪 Leave area*/
    NETDEV_ALARM_ARTICLE_MOVE                       = 1017,          /* Ʒ Article move*/
    NETDEV_ALARM_SMART_FACE_MATCH_LIST                  = 1018,       /* ʶ */
    NETDEV_ALARM_SMART_FACE_MATCH_LIST_RECOVER          = 1019,       /* ʶָ */
    NETDEV_ALARM_SMART_FACE_MISMATCH_LIST               = 1020,       /* ʶƥ䱨 */
    NETDEV_ALARM_SMART_FACE_MISMATCH_LIST_RECOVER       = 1021,       /* ʶƥ䱨ָ */
    NETDEV_ALARM_SMART_VEHICLE_MATCH_LIST               = 1022,       /* ʶƥ䱨 */
    NETDEV_ALARM_SMART_VEHICLE_MATCH_LIST_RECOVER       = 1023,       /* ʶƥ䱨ָ */
    NETDEV_ALARM_SMART_VEHICLE_MISMATCH_LIST            = 1024,       /* ʶƥ䱨 */
    NETDEV_ALARM_SMART_VEHICLE_MISMATCH_LIST_RECOVER    = 1025,       /* ʶƥ䱨ظ */
    NETDEV_ALARM_IMAGE_BLURRY_RECOVER               = 1026,         /* ͼ齹澯ָ  Image blurry recover */
    NETDEV_ALARM_SMART_TRACK_RECOVER                = 1027,         /* ܸٸ澯ָ  Smart track recover */
    NETDEV_ALARM_SMART_READ_ERROR_RATE              = 1028,         /* ײݶȡError reding the underlying data */
    NETDEV_ALARM_SMART_SPIN_UP_TIME                 = 1029,         /* ʱ  Rotation time of spindle */
    NETDEV_ALARM_SMART_START_STOP_COUNT             = 1030,         /* ͣ Rev. Stop counting*/
    NETDEV_ALARM_SMART_REALLOCATED_SECTOR_COUNT     = 1031,         /* ӳ  Remap sector count*/
    NETDEV_ALARM_SMART_SEEK_ERROR_RATE              = 1032,         /* Ѱ Trace error rate*/
    NETDEV_ALARM_SMART_POWER_ON_HOURS               = 1033,         /* ͨʱۼƣͨʱ䣬һСʱ */
    NETDEV_ALARM_SMART_SPIN_RETRY_COUNT             = 1034,         /* Դ */
    NETDEV_ALARM_SMART_CALIBRATION_RETRY_COUNT      = 1035,         /* ͷУ׼Լ */
    NETDEV_ALARM_SMART_POWER_CYCLE_COUNT            = 1036,         /* ͨڼ */
    NETDEV_ALARM_SMART_POWEROFF_RETRACT_COUNT       = 1037,         /* ϵ緵ؼ */
    NETDEV_ALARM_SMART_LOAD_CYCLE_COUNT             = 1038,         /* ͷؼ */
    NETDEV_ALARM_SMART_TEMPERATURE_CELSIUS          = 1039,         /* ¶ */
    NETDEV_ALARM_SMART_REALLOCATED_EVENT_COUNT      = 1040,         /* ӳ¼ */
    NETDEV_ALARM_SMART_CURRENT_PENDING_SECTOR       = 1041,         /* ǰӳ */
    NETDEV_ALARM_SMART_OFFLINE_UNCORRECTABLE        = 1042,         /* ѻ޷У */
    NETDEV_ALARM_SMART_UDMA_CRC_ERROR_COUNT         = 1043,         /* żУ  */
    NETDEV_ALARM_SMART_MULTI_ZONE_ERROR_RATE        = 1044,         /*  */
    NETDEV_ALARM_RESOLUTION_CHANGE                  = 1045,         /* ֱʱ */
    NETDEV_ALARM_MANUAL                             = 1401,         /* ֶ澯 */
    NETDEV_ALARM_ALARMHOST_COMMON                   = 1402,         /* ¼ */
    NETDEV_ALARM_DOORHOST_COMMON                    = 1403,         /* Ž¼ */
    NETDEV_ALARM_FACE_NOT_MATCH                     = 1411,         /* Աʧ */
    NETDEV_ALARM_FACE_MATCH_SUCCEED                 = 1412,         /* Աȳɹ */

    NETDEV_ALARM_VEHICLE_BLACK_LIST                 = 1420,         /* ʶ */
    NETDEV_ALARM_HUMAN_SHAPE_DETECTION              = 1421,         /* μ */
    NETDEV_ALARM_HUMAN_SHAPE_DETECTION_RECOVER      = 1422,         /* μ澯ָ */

    NETDEV_ALARM_INVALID                            = 0xFFFF        /* Чֵ  Invalid value */
}NETDEV_ALARM_TYPE_E;

/**
* @enum tagNETDEVPlayerRunInfoType
* @brief ϱϢ͵öٶ
* @attention 
*/
typedef enum tagNETDEVPlayerRunInfoType
{
    NETDEV_PLAYER_RUN_INFO_RECORD_VIDEO        = 1,        /**< ¼ϱϢ */
    NETDEV_PLAYER_RUN_INFO_MEDIA_PROCESS       = 2,        /**< Ƶý崦еϱϢ */
    NETDEV_PLAYER_RUN_INFO_SERIES_SNATCH       = 3,        /**< ץĹϱϢ */
    NETDEV_PLAYER_RUN_INFO_MEDIA_VOICE         = 4,        /**< ҵϱϢ */
    NETDEV_PLAYER_RUN_INFO_MEDIA_NOT_IDENTIFY  = 5,        /**< ޷ʶ */
    NETDEV_PLAYER_RUN_INFO_RECV_PACKET_NUM     = 6,        /**< ڽյİ */
    NETDEV_PLAYER_RUN_INFO_RECV_BYTE_NUM       = 7,        /**< ڽյֽ */
    NETDEV_PLAYER_RUN_INFO_VIDEO_FRAME_NUM     = 8,        /**< ڽƵ֡ */
    NETDEV_PLAYER_RUN_INFO_AUDIO_FRAME_NUM     = 9,        /**< ڽƵ֡ */
    NETDEV_PLAYER_RUN_INFO_LOST_PACKET_RATIO   = 10,       /**< ڶͳϢλΪ0.01% */
    NETDEV_PLAYER_RUN_INFO_MEDIA_PLAY_PROGRESS = 11,       /**< ýЯĽϢ */
    NETDEV_PLAYER_RUN_INFO_MEDIA_PLAY_END      = 12,       /**< ýЯĲŽ */
    NETDEV_PLAYER_RUN_INFO_MEDIA_ABNORMAL      = 13,       /**< ý崦쳣 */
    NETDEV_PLAYER_RUN_INFO_CODEC               = 14,       /**<  */
    NETDEV_PLAYER_RUN_INFO_STREAM              = 15,       /**<  */
    NETDEV_PLAYER_RUN_INFO_PLAYBACK_FINISH     = 16,       /**< طŽ */
    NETDEV_PLAYER_RUN_INFO_SNATCH              = 17,       /**< ͼеϱϢ */
    NETDEV_PLAYER_RUN_INFO_INVALID             = 0xff
}NETDEV_PLAYER_RUN_INFO_TYPE_E;

/**
 * @brief 澯Դ öٶ  Alarm configuration operation Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVAlarmSrcTypeEn
{
    NETDEV_ALARM_SRC_LOCAL_HARD_DISK                            = 0,        /*Ӳ*/
    NETDEV_ALARM_SRC_EX_CABINET_1_STORAGE_DISK                  = 1,        /*չ-1洢*/
    NETDEV_ALARM_SRC_EX_CABINET_2_STORAGE_DISK                  = 2,        /*չ-2洢*/
    NETDEV_ALARM_SRC_ARRAY_STORAGE_DISK                         = 3,        /*д洢*/
    NETDEV_ALARM_SRC_NAS_STORAGE_DISK                           = 4,        /*NAS洢*/
    NETDEV_ALARM_SRC_SAN_STORAGE_DISK                           = 5,        /*SAN洢*/
    NETDEV_ALARM_SRC_ESATA_STORAGE_DISK                         = 6,        /*eSATA洢*/
    NETDEV_ALARM_SRC_SD_STORAGE_DISK                            = 7,        /*SD洢*/
    NETDEV_ALARM_SRC_VIDEO_CHANNEL                              = 8,        /*Ƶͨ*/
    NETDEV_ALARM_SRC_ALARM_INPUT_CHANNEL                        = 9,        /*ͨ*/
    NETDEV_ALARM_SRC_SYSTEM                                     = 10,       /*ϵͳ*/

    NETDEV_ALARM_SRC_AUDIO_CHANNEL                              = 11,       /*Ƶͨ*/
    NETDEV_ALARM_SRC_DECODE_CHANNEL                             = 12,       /*ͨ*/
    NETDEV_ALARM_SRC_ALARM_OUTPUT_CHANNEL                       = 13,       /*ͨ*/
    NETDEV_ALARM_SRC_ACCESS_CONTROL_CHANNEL                     = 14,       /*Žͨ*/
    NETDEV_ALARM_SRC_ALARM_POINT_CHANNEL                        = 15,       /*ͨ*/
    NETDEV_ALARM_SRC_EMERGENCY_BELL_CHANNEL                     = 16,       /*ͨ(澯)*/
    NETDEV_ALARM_SRC_DEV                                        = 17,       /*豸*/

    NETDEV_ALARM_SRC_INVALID                                    = 0xFFFF    /* Чֵ  Invalid value */
}NETDEV_ALARM_SRC_TYPE_E;

/**
 * @brief Դ¼ öٶ Type of resource change subevent
 * @attention  None
 */
typedef enum tagNETDEVResChangeSubeventType
{
    NETDEV_RES_CHANGE_SUBEVENT_ADD                                  = 0,             /*  */
    NETDEV_RES_CHANGE_SUBEVENT_DELETE                               = 1,             /* ɾ */
    NETDEV_RES_CHANGE_SUBEVENT_MODIFY                               = 2,             /* ޸ */
    NETDEV_RES_CHANGE_SUBEVENT_UP_LINE                              = 3,             /*  */
    NETDEV_RES_CHANGE_SUBEVENT_OFFLINE                              = 4,             /*  */
    NETDEV_RES_CHANGE_SUBEVENT_EMAP_ALARM_REPORT                    = 5,             /* Emap澯ϱ */

    NETDEV_RES_CHANGE_SUBEVENT_INVALID                              = 0xff           /* Чֵ  Invalid value */
}NETDEV_RES_CHANGE_SUBEVENT_TYPE_E;
/**
 * @brief Դ öٶ Type of resource change
 * @attention  None
 */
typedef enum tagNETDEVResType
{
    NETDEV_RES_USER_RESOURCE                                 = 0,             /* ûԴ */
    NETDEV_RES_EQUIPMENT_RESOURCE                            = 1,             /* 豸Դ */
    NETDEV_RES_CHANNEL_RESOURCE                              = 2,             /* ͨԴ */
    NETDEV_RES_USER_PERMISSION_RESOURCES                     = 3,             /* ûȨԴ */
    NETDEV_RES_ROUND_TOUR_RESOURCES                          = 4,             /* ѲԴ */
    NETDEV_RES_HOT_RESOURCES                                 = 5,             /* ȵԴ */
    NETDEV_RES_GEOTHERMAL_RESOURCES                          = 6,             /* Դ */
    NETDEV_RES_ALARM_RESOURCES                               = 7,             /* 澯Դ */
    NETDEV_RES_TIME_TEMPLATE                                 = 8,             /* ʱģ */
    NETDEV_RES_SYSTEM_PERMISSION_RESOURCES                   = 9,             /* ϵͳȨԴ */
    NETDEV_RES_DEVICE_PERMISSION_RESOURCES                   = 10,            /* 豸ȨԴ */
    NETDEV_RES_ORGANIZE_RESOURCES                            = 11,            /* ֯Դ */
    NETDEV_RES_ALARM_TASK_RESOURCES                          = 12,            /* Դ */
    NETDEV_RES_MASTER_SLAVE_RESOURCES                        = 13,            /* Դ */
    NETDEV_RES_TV_WALL_INFO                                  = 14,            /* ǽϢ */
    NETDEV_RES_TV_WALL_SCENE_RESOURCES                       = 15,            /* ǽԴ */
    NETDEV_RES_TV_WALL_WINDOW_RESOURCES                      = 16,            /* ǽԴ */
    NETDEV_RES_TV_WALL_VIRTUAL_LED_RESOURCES                 = 17,            /* ǽLEDԴ */
    NETDEV_RES_BROADCAST_GROUP_INFOR_CHANGES                 = 18,            /* 㲥Ϣ */
    NETDEV_RES_VIRTUAL_ORGANIZATION_RESOURCES                = 19,            /* ֯Դ */
    NETDEV_RES_USER_ROLE_RESOURCES                           = 20,            /* ûɫԴ */
    NETDEV_RES_ROLE_ORGANIZE_SDHOW_TREE_RESOURCES            = 21,            /* ɫ֯չʾԴ */
    NETDEV_RES_IMAGE_RESOURCES                               = 22,            /* ͼƬԴ */
    NETDEV_RES_CRUISE_RESOURCES                              = 23,            /* ѲԴ */
    NETDEV_RES_RECORD_TRACE_RESOURCES                        = 24,            /* ¼ƹ켣Դ */
    NETDEV_RES_ACCESS_CONTROL_PERSONNEL_RESOURCES            = 25,            /* ŽԱԴ */
    NETDEV_RES_ACCESS_CONTROL_CARD_RESOURCES                 = 26,            /* ŽԴ */
    NETDEV_RES_TV_WALL_LIST                                  = 27,            /* ǽб */
    NETDEV_RES_TV_WALL_SCENE_SWITCHING                       = 28,            /* ǽл */
    NETDEV_RES_FACE_DATABASE_RESOURCES                       = 29,            /* Դ */
    NETDEV_RES_FACE_DATABASE_CUSTOM_ATTRIBUTE                = 30,            /* Զ */
    NETDEV_RES_FACE_MEMBER_RESOURCES                         = 31,            /* ԱԴ */
    NETDEV_RES_FACE_CONTROL_RESOURCES                        = 32,            /* Դ */
    NETDEV_RES_INTELLIGENT_DETECTION_RESOURCES               = 33,            /* ܼԴ */
    NETDEV_RES_INVALID                                       = 0xff           /* Чֵ  Invalid value */
}NETDEV_RES_CHANGE_TYPE_E;


/**
 * @brief ־ö öٶ Major types of logs Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVLogMainType
{
    /* NVR֧ */
    NETDEV_LOG_MAIN_TYPE_ALL                                        = 0,                /* ȫ͵־ NVR Logs of all types */
    NETDEV_LOG_MAIN_TYPE_ALARM                                      = 1,                /* 澯  Alarms */
    NETDEV_LOG_MAIN_TYPE_EXCEPTION                                  = 2,                /* 쳣  Exceptions */
    NETDEV_LOG_MAIN_TYPE_OPERATION                                  = 3,                /*   Operations */
    NETDEV_LOG_MAIN_TYPE_MESSAGE                                    = 4,                /* Ϣ  Messages */

    /* VMS־*/
    NETDEV_LOG_MAIN_TYPE_VMS_ALL                                    =  90,              /* ȫ VMS Logs of all types */
    NETDEV_LOG_MAIN_TYPE_LOGIN                                      =  91,              /* ¼ Login */

    NETDEV_LOG_MAIN_TYPE_ORGANIZATION_CONFIG                        = 100,              /* ֯ Organization Config */
    NETDEV_LOG_MAIN_TYPE_USER_CONFIG                                = 101,              /* û User Config */
    NETDEV_LOG_MAIN_TYPE_ROLE_CONFIG                                = 102,              /* ɫ Role Config */
    NETDEV_LOG_MAIN_TYPE_DEVICE_CONFIG                              = 103,              /* 豸 Device Config */
    NETDEV_LOG_MAIN_TYPE_CHANNE_LCONFIG                             = 104,              /* ͨ Channel Config */
    NETDEV_LOG_MAIN_TYPE_SERVER_CONFIG                              = 105,              /* ӷ Server Config */
    NETDEV_LOG_MAIN_TYPE_PTZ_CONFIG                                 = 106,              /* ̨ PTZ Config */
    NETDEV_LOG_MAIN_TYPE_VIDEOWALL_CONFIG                           = 107,              /* ǽ Video Wall Config */
    NETDEV_LOG_MAIN_TYPE_EMAP_CONFIG                                = 108,              /* ͼ EMap Config */
    NETDEV_LOG_MAIN_TYPE_SYSTEM_CONFIG                              = 109,              /* ϵͳ(áӲáúϵͳά) System Config */
    NETDEV_LOG_MAIN_TYPE_SEQUENCE_PLAN_CONFIG                       = 110,              /* ѲԤ Sequence Plan Config */
    NETDEV_LOG_MAIN_TYPE_NETWORK_KEYPAD_CONFIG                      = 111,              /* ͨ Network Keypad Config */
    NETDEV_LOG_MAIN_TYPE_SEQUENCE_RESOURCE_CONFIG                   = 112,              /* ѲԴ Sequence Resource Config */
    NETDEV_LOG_MAIN_TYPE_HOT_SPOT_AND_ZONE_CONFIG                   = 113,              /* ȵ㡢 Hot Spot And Zone Config */
    NETDEV_LOG_MAIN_TYPE_USER_TIME_TEMPLATE_CONFIG                  = 114,              /* ûʱģ User Time Template Config */
    NETDEV_LOG_MAIN_TYPE_SERVER_WORK_MODE                           = 115,              /* ģʽ Server Work Mode */
    NETDEV_LOG_MAIN_TYPE_PERMISSION_TIME_TEMPLATE_CONFIG            = 116,              /* Ȩʱģ Permission Time Template Config */
    NETDEV_LOG_MAIN_TYPE_TIME_CONFIG                                = 117,              /* ֶʱ Time Config */
    NETDEV_LOG_MAIN_TYPE_TIMESYNC_CONFIG                            = 118,              /* ʱͬ Time Sync Config */
    NETDEV_LOG_MAIN_TYPE_HOLIDAY_CONFIG                             = 119,              /* ʱ Holiday Config */
    NETDEV_LOG_MAIN_TYPE_NTPTIME_CONFIG                             = 120,              /* NTPʱ NTP Time Config */
    NETDEV_LOG_MAIN_TYPE_DST_CONFIG                                 = 121,              /* ʱ DST Config */
    NETDEV_LOG_MAIN_TYPE_RESRELATION_CONFIG                         = 122,              /* Դ Resource Relation Config */
    NETDEV_LOG_MAIN_TYPE_DEVICE_TIME_SYNC                           = 123,              /* 豸ʱͬ Device Time Sync */
    NETDEV_LOG_MAIN_TYPE_TCPIP_CONFIG                               = 124,              /* tcp/ip TCP/IP Config */
    NETDEV_LOG_MAIN_TYPE_EZCLOUD_CONFIG                             = 125,              /*  EZCloud Config */
    NETDEV_LOG_MAIN_TYPE_DDNS_CONFIG                                = 126,              /* DDNS DDNS Config */
    NETDEV_LOG_MAIN_TYPE_PORT_CONFIG                                = 127,              /* ˿ Port Config */
    NETDEV_LOG_MAIN_TYPE_PORTMAPPING_CONFIG                         = 128,              /* ˿ӳ Port Mapping Config */
    NETDEV_LOG_MAIN_TYPE_EMAIL_CONFIG                               = 129,              /* ʼ Email Config */
    NETDEV_LOG_MAIN_TYPE_GBSERVER_CONFIG                            = 130,              /*  GB Server Config */
    NETDEV_LOG_MAIN_TYPE_GBT28181_LOCAL_CONFIG                      = 131,              /* ط GBT28181 Local Config */
    NETDEV_LOG_MAIN_TYPE_UNP_CLIENT_CONFIG                          = 132,              /* UNPͻ UNP Client Config */
    NETDEV_LOG_MAIN_TYPE_UNP_SERVER_CONFIG                          = 133,              /* UNP UNP Server Config */
    NETDEV_LOG_MAIN_TYPE_STATIC_ROUTE_CONFIG                        = 134,              /* ̬·ɲ Static Route Config */
    NETDEV_LOG_MAIN_TYPE_802DOT1X_CONFIG                            = 135,              /* 8021X 802Dot1x Config" */
    NETDEV_LOG_MAIN_TYPE_ARP_CONFIG                                 = 136,              /* ARP ARP Config */
    NETDEV_LOG_MAIN_TYPE_HTTPS_CONFIG                               = 137,              /* https HTTPS Config */
    NETDEV_LOG_MAIN_TYPE_TELNET_CONFIG                              = 138,              /* telnet Telnet Config */
    NETDEV_LOG_MAIN_TYPE_SECURITY_PSW_CONFIG                        = 139,              /* ȫ Security Passwd Config */

    NETDEV_LOG_MAIN_TYPE_IP_FILTER_RULE_CONFIG                      = 140,              /* IP˹ IP Filter Rule Config */
    NETDEV_LOG_MAIN_TYPE_MAINTENANCE_CONFIG                         = 141,              /* ϵͳά Maintenance Config */
    NETDEV_LOG_MAIN_TYPE_SET_MAX_LOG_RETENTION_TIME                 = 142,              /* ־ Set Max Log Retention Time */
    NETDEV_LOG_MAIN_TYPE_STREAM_TRANSMISSION_POLICY_CONFIG          = 143,              /* ý Stream Transmission Policy Config */
    NETDEV_LOG_MAIN_TYPE_BATCH_CONFIG                               = 144,              /*  Batch Config */
    NETDEV_LOG_MAIN_TYPE_RAIDMODE_CONFIG                            = 145,              /* RAIDģʽ RAID Mode Config */
    NETDEV_LOG_MAIN_TYPE_ARRAY_CONFIG                               = 146,              /*  Array Config */
    NETDEV_LOG_MAIN_TYPE_DISK_MANAGEMENT_CONFIG                     = 147,              /* Ӳ̹ Disk Management Config */
    NETDEV_LOG_MAIN_TYPE_CHANNEL_SPACE_CONFIG                       = 148,              /* ͨ Channel Space Config */
    NETDEV_LOG_MAIN_TYPE_OVER_WRITE_POLICY_CONFIG                   = 149,              /*  Overwrite Policy Config */
    NETDEV_LOG_MAIN_TYPE_DISKTEST_CONFIG                            = 150,              /* Ӳ̼ Disk Test Config */
    NETDEV_LOG_MAIN_TYPE_NET_DISK_CONFIG                            = 151,              /* Ӳ Net Disk Config */
    NETDEV_LOG_MAIN_TYPE_RECORDING_SCHEDULE_CONFIG                  = 152,              /* ¼ƻ Recording Schedule Config */
    NETDEV_LOG_MAIN_TYPE_RECORDING_TIME_TEMPLATE_CONFIG             = 153,              /* ¼ʱģ Recording Time Template Config */
    NETDEV_LOG_MAIN_TYPE_ALARM_CONFIG                               = 154,              /* 澯 Alarm Config */
    NETDEV_LOG_MAIN_TYPE_ALARM_TIMETEMPLATE_CONFIG                  = 155,              /* 澯ʱģ Alarm Time Template Config */
    NETDEV_LOG_MAIN_TYPE_CONTACT_CONFIG                             = 156,              /* ϵ Contact Config */
    NETDEV_LOG_MAIN_TYPE_ALARM_TO_VIDEO_WALL_CONFIG                 = 157,              /* 澯ǽ Alarmto Video Wall Config */
    NETDEV_LOG_MAIN_TYPE_VIDEO_WALL_SCENE_CONFIG                    = 158,              /* ǽ Video Wall Scene Config */
    NETDEV_LOG_MAIN_TYPE_VIDEO_WALL_WINDOW_CONFIG                   = 159,              /* ǽ Video Wall Window Config */
    NETDEV_LOG_MAIN_TYPE_VIDEO_WALL_VIRTUALLED_CONFIG               = 160,              /* ǽLED Video Wall Virtual LED Config */
    NETDEV_LOG_MAIN_TYPE_EXTERNAL_ALARM_CONFIG                      = 161,              /*   External Alarm Config */
    NETDEV_LOG_MAIN_TYPE_DISK_GROUP_CONFIG                          = 162,              /*  Disk Group Config */
    NETDEV_LOG_MAIN_TYPE_BK_PLAN_CONFIG                             = 163,              /* ݼƻ BK Plan Config */
    NETDEV_LOG_MAIN_TYPE_BK_TASK_CONFIG                             = 164,              /*  BK Task Config */
    NETDEV_LOG_MAIN_TYPE_LOCAL_BK_TASKCONFIG                        = 165,              /* ر Local BK Task Config */
    NETDEV_LOG_MAIN_TYPE_TVWALL_AUDIO_CONFIG                        = 166,              /* ǽƵ Tvwall Audio Config */
    NETDEV_LOG_MAIN_TYPE_LIVEVIEW                                   = 167,              /* ʵԤ Live View */
    NETDEV_LOG_MAIN_TYPE_PLAYBACK                                   = 168,              /* ¼طŲ Playback */
    NETDEV_LOG_MAIN_TYPE_TWO_WAY_AUDIO                              = 169,              /*  Two Way Audio */
    NETDEV_LOG_MAIN_TYPE_PTZ                                        = 170,              /* ̨ PTZ */
    NETDEV_LOG_MAIN_TYPE_DOWNLOAD                                   = 171,              /* ز Download */
    NETDEV_LOG_MAIN_TYPE_LIVEVIEW_ON_VIDEO_WALL                     = 172,              /* ʵǽ Live Viewon Video Wall */
    NETDEV_LOG_MAIN_TYPE_PLAYBACK_ON_VIDEO_WALL                     = 173,              /* طǽ Playback On Video Wall */
    NETDEV_LOG_MAIN_TYPE_EMAP_OPERATION                             = 174,              /* ӵͼ EMap Operation */
    NETDEV_LOG_MAIN_TYPE_DC_SEQUENCE_OPERATION                      = 175,              /* DCѲҵ DC Sequence Operation */
    NETDEV_LOG_MAIN_TYPE_VIDEO_WALL_PLAYING_BY_NETWROK_KEYPAD       = 176,              /* ̲ʵǽ Video Wall Playing by Netwrok Keypad */
    NETDEV_LOG_MAIN_TYPE_ALARM_TO_VIDEO_WALL                        = 177,              /* ǽ Alarm to Video Wall */
    NETDEV_LOG_MAIN_TYPE_ALARM_SUBSCRIPTION                         = 178,              /* 澯 Alarm Subscription */
    NETDEV_LOG_MAIN_TYPE_PRESET_PATROL_CONFIG                       = 179,              /* ԤλѲ Preset Patrol Config */
    NETDEV_LOG_MAIN_TYPE_AUTOGUARD_CONFIG                           = 180,              /*  Auto Guard Config */
    NETDEV_LOG_MAIN_TYPE_RECORDED_PATROL_CONFIG                     = 181,              /* 켣Ѳ Recorded Patrol Config */
    NETDEV_LOG_MAIN_TYPE_ACCESS_CONTROL_PERSONNEL_MANAGEMENT        = 182,              /* ŽԱ Access Control Personnel Management */
    NETDEV_LOG_MAIN_TYPE_ACCESS_CONTROL_CARD_MANAGEMENT             = 183,              /* Ž Access Control Card Management */
    NETDEV_LOG_MAIN_TYPE_ZONE_OPERATION                             = 184,              /*  Zone Operation */
    NETDEV_LOG_MAIN_TYPE_ACCESS_CONTROL_DOOR                        = 185,              /* Ų Access Control Door */
    NETDEV_LOG_MAIN_TYPE_TRIGGER_ALARMOUTPUT                        = 186,              /*  Trigger Alarm Output */
    NETDEV_LOG_MAIN_TYPE_CENTER_RECORD                              = 187,              /* ¼ Center Record */
    NETDEV_LOG_MAIN_TYPE_FACE_LIBRARY_OPERATION                     = 188,              /*  Face Library Operation */
    NETDEV_LOG_MAIN_TYPE_FACE_MEMBER_OPERATION                      = 189,              /* Ա Face Member Operation */
    NETDEV_LOG_MAIN_TYPE_FACE_CUSTOM_OPERATION                      = 190,              /* ԶԲ Face Custom Operation */
    NETDEV_LOG_MAIN_TYPE_FACE_MEMBER_SORT_OPERATION                 = 191,              /* ⻮ Face Member Sort Operation */
    NETDEV_LOG_MAIN_TYPE_FACE_MONITORING_TASKO_PERATION             = 192,              /* ز Face Monitoring Task Operation */
    NETDEV_LOG_MAIN_TYPE_VEHICLE_LIBRARY_OPERATION                  = 193,              /*  Vehicle Library Operation */
    NETDEV_LOG_MAIN_TYPE_VEHICLE_MEMBER_SORT_OPERATION              = 194,              /* ⻮ Vehicle Member Sort Operation */
    NETDEV_LOG_MAIN_TYPE_VEHICLE_MEMBER_OPERATION                   = 195,              /* Ա Vehicle Member Operation */
    NETDEV_LOG_MAIN_TYPE_CAP_PAC_TASK                               = 196,              /* ץ Cap Pac Task */
    NETDEV_LOG_MAIN_TYPE_RECORD_BK_CONFIG                           = 197,              /* ¼񱸷 Record BK Config */
    NETDEV_LOG_MAIN_TYPE_USB_OPERATION                              = 198,              /* U̲ USB Operation */
    NETDEV_LOG_MAIN_TYPE_VEHICLE_MONITORING_TASK_OPERATION          = 199,              /* ز Vehicle Monitoring Task Operation */
    NETDEV_LOG_MAIN_TYPE_PERMISSION_ASSIGNMENT_OPERATION            = 200,              /* Ȩ Permission Assignment Operation */
    NETDEV_LOG_MAIN_TYPE_INVALID                                    = 0xFFFF            /* Чֵ  Invalid value */
}NETDEV_LOG_MAIN_TYPE_E;

/**
 * @brief ־ID öٶ Minor type IDs of logs Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVLogSubType
{
    NETDEV_LOG_ALL_SUB_TYPES                     = 0x0101,          /* Ϣ־  All information logs */

    /* Ϣ־  Information logs */
    NETDEV_LOG_MSG_HDD_INFO                     = 300,              /* ӲϢ  HDD information */
    NETDEV_LOG_MSG_SMART_INFO                   = 301,              /* S.M.A.R.TϢ  S.M.A.R.T information */
    NETDEV_LOG_MSG_REC_OVERDUE                  = 302,              /* ¼ɾ  Expired recording deletion */
    NETDEV_LOG_MSG_PIC_REC_OVERDUE              = 303,              /* ͼƬļɾ  Expired image deletion */

    /* ֪ͨ־  notification logs */
    NETDEV_LOG_NOTICE_IPC_ONLINE                = 310,              /* 豸  Device online */
    NETDEV_LOG_NOTICE_IPC_OFFLINE               = 311,              /* 豸  Device offline */
    NETDEV_LOG_NOTICE_ARRAY_RECOVER             = 312,              /* лָ  arrayRecover */
    NETDEV_LOG_NOTICE_INIT_ARRARY               = 313,              /* гʼ  initializeArray */
    NETDEV_LOG_NOTICE_REBUILD_ARRARY            = 314,              /* ؽ  rebuildArray */
    NETDEV_LOG_NOTICE_POE_PORT_STATUS           = 315,              /* PoE״̬  poePortStatus */
    NETDEV_LOG_NOTICE_NETWORK_PORT_STATUS       = 316,              /* ״̬ networkPortStatus */
    NETDEV_LOG_NOTICE_DISK_ONLINE               = 317,              /*   Disk online */

    /* 澯־־ID  Sub type log ID of alarm logs */
    NETDEV_LOG_ALARM_MOTION_DETECT              = 350,              /* ƶ澯  Motion detection alarm */
    NETDEV_LOG_ALARM_MOTION_DETECT_RESUME       = 351,              /* ƶ澯ָ  Motion detection alarm recover */
    NETDEV_LOG_ALARM_VIDEO_LOST                 = 352,              /* Ƶʧ澯  Video loss alarm */
    NETDEV_LOG_ALARM_VIDEO_LOST_RESUME          = 353,              /* Ƶʧ澯ָ  Video loss alarm recover */
    NETDEV_LOG_ALARM_VIDEO_TAMPER_DETECT        = 354,              /* ڵ澯  Tampering detection alarm */
    NETDEV_LOG_ALARM_VIDEO_TAMPER_RESUME        = 355,              /* ڵ澯ָ  Tampering detection alarm recover */
    NETDEV_LOG_ALARM_INPUT_SW                   = 356,              /* 뿪澯  Boolean input alarm */
    NETDEV_LOG_ALARM_INPUT_SW_RESUME            = 357,              /* 뿪澯ָ  Boolean input alarm recover */
    NETDEV_LOG_ALARM_IPC_ONLINE                 = 358,              /* 豸  Device online */
    NETDEV_LOG_ALARM_IPC_OFFLINE                = 359,              /* 豸  Device offline */
    
    NETDEV_LOG_ALARM_AUDIO_DETECTION_START      = 360,              /* Ƶ⿪ʼ  Audio detection start */
    NETDEV_LOG_ALARM_AUDIO_DETECTION_END        = 361,              /* Ƶ  Audio detection end */
    NETDEV_LOG_ALARM_CROSS_LINE_DETECT          = 362,              /* Խⱨ  CrossLine detection */
    NETDEV_LOG_ALARM_FACE_DETECT                = 363,              /* ⱨ  Face Detection */
    NETDEV_LOG_ALARM_INTRUSION_DETECT           = 364,              /* ֱ  Intrusion Detection */
    NETDEV_LOG_ALARM_POS                        = 365,              /* POS  POS Alarm */
    NETDEV_LOG_ALARM_IMAGETOOBLURRY_ON          = 366,              /* 齹⿪ʼ  Defocus detection started*/
    NETDEV_LOG_ALARM_IMAGETOOBLURRY_OFF         = 367,              /* 齹  Defocus detection ended*/
    NETDEV_LOG_ALARM_GLOBAL_SCENE_CHANGE        = 368,              /*   Scene change detection*/
    NETDEV_LOG_ALARM_AUTO_TRACK_ON              = 369,              /* ܸٿʼ  Auto tracking started*/
    NETDEV_LOG_ALARM_AUTO_TRACK_OFF             = 370,              /* ܸٽ  Auto tracking ended*/
    NETDEV_LOG_ALARM_CONFLAGRATION_ON           = 371,              /* ָ澯 */
    NETDEV_LOG_ALARM_CONFLAGRATION_OFF          = 372,              /* ָ澯 */
    NETDEV_LOG_ALARM_HUMAN_SHAPE_DETECT_ON      = 373,              /* μ澯 */
    NETDEV_LOG_ALARM_HUMAN_SHAPE_DETECT_OFF     = 374,              /* μ澯 */

    /* 쳣־־ID  Sub type log ID of exception logs */
    NETDEV_LOG_EXCEP_DISK_ONLINE                = 400,              /*   Disk online */
    NETDEV_LOG_EXCEP_DISK_OFFLINE               = 401,              /*   Disk offline */
    NETDEV_LOG_EXCEP_DISK_ERR                   = 402,              /* 쳣  Disk exception */
    NETDEV_LOG_EXCEP_STOR_ERR                   = 403,              /* 洢  Storage error */
    NETDEV_LOG_EXCEP_STOR_ERR_RECOVER           = 404,              /* 洢ָ  Storage error recover */
    NETDEV_LOG_EXCEP_STOR_DISOBEY_PLAN          = 405,              /* δƻ洢  Not stored as planned */
    NETDEV_LOG_EXCEP_STOR_DISOBEY_PLAN_RECOVER  = 406,              /* δƻ洢ָ  Not stored as planned recover */
    NETDEV_LOG_EXCEP_ILLEGAL_ACCESS             = 407,              /* Ƿ  Illegal access */
    NETDEV_LOG_EXCEP_IP_CONFLICT                = 408,              /* IPַͻ  IP address conflict */
    NETDEV_LOG_EXCEP_NET_BROKEN                 = 409,              /* Ͽ  Network disconnection */
    NETDEV_LOG_EXCEP_PIC_REC_ERR                = 410,              /* ץͼ,ȡͼƬļʧ  Failed to get captured image */
    NETDEV_LOG_EXCEP_VIDEO_EXCEPTION            = 411,              /* Ƶ쳣(ֻģͨ)  Video input exception (for analog channel only) */
    NETDEV_LOG_EXCEP_VIDEO_MISMATCH             = 412,              /* Ƶʽƥ   Video standards do not match */
    NETDEV_LOG_EXCEP_RESO_MISMATCH              = 413,              /* ֱʺǰ˷ֱʲƥ  Encoding resolution and front-end resolution do not match */
    NETDEV_LOG_EXCEP_TEMP_EXCE                  = 414,              /* ¶쳣  Temperature exception */
    NETDEV_LOG_EXCEP_RUNOUT_RECORD_SPACE        = 415,              /* ¼洢ռ伴  runOutOfRecordSpace */
    NETDEV_LOG_EXCEP_RUNOUT_IMAGE_SPACE         = 416,              /* ͼƬ洢ռ伴  runOutOfImageSpace */
    NETDEV_LOG_EXCEP_OUT_RECORD_SPACE           = 417,              /* ¼洢ռ  recordSpaceUsedUp */
    NETDEV_LOG_EXCEP_OUT_IMAGE_SPACE            = 418,              /* ͼƬ洢ռ  imageSpaceUsedUp */
    NETDEV_LOG_EXCEP_ANRIDISASSEMBLY            = 419,              /* 𱨾  antiDisassembly Alarm */
    NETDEV_LOG_EXCEP_ANRIDISASSEMBLY_RECOVER    = 420,              /* 𱨾ָ antiDisassembly AlarmClear*/
    NETDEV_LOG_EXCEP_ARRAY_DAMAGE               = 421,              /*   arrayDamage */
    NETDEV_LOG_EXCEP_ARRAY_DEGRADE              = 422,              /* ˥  arrayDegrade */
    NETDEV_LOG_EXCEP_RECORD_SNAPSHOT_ABNOR      = 423,              /* ¼/ץͼ쳣  recordSnapshotAbnormal */
    NETDEV_LOG_EXCEP_NET_BROKEN_RECOVER         = 424,              /* Ͽָ  networkDisconnectClear */
    NETDEV_LOG_EXCEP_IP_CONFLICT_RECOVER        = 425,              /* IPַͻָ  ipConflictClear */
    NETDEV_LOG_EXCEP_DEVICE_HIGHTEMP            = 426,              /* 豸±  High Temperature */
    NETDEV_LOG_EXCEP_DEVICE_LOWTEMP             = 427,              /* 豸±  Low Temperature */
    NETDEV_LOG_EXCEP_DEVICE_HIGHTEMP_RECOVER    = 428,              /* 豸±ָ  High Temperature Cleared */
    NETDEV_LOG_EXCEP_DEVICE_LOWTEMP_RECOVER     = 429,              /* 豸±ָ  Low Temperature Cleared */
    NETDEV_LOG_EXCEP_FAN_FAULT                  = 430,              /* 豸ȹ  Fan Failure */
    NETDEV_LOG_EXCEP_FAN_FAULT_RECOVER          = 431,              /* 豸ȹϻָ  Fan Failure Cleared */
    NETDEV_LOG_EXCEP_LEDBOX_HIGHTEMP            = 432,              /* 豸  LED Distribution Box High Temperature */
    NETDEV_LOG_EXCEP_LEDBOX_HIGHTEMP_RECOVER    = 433,              /* 豸»ָ  LED Distribution Box High Temperature Cleared */
    NETDEV_LOG_EXCEP_LEDBOX_SMOKE               = 434,              /* 豸澯  LED Distribution Box Smoke Alarm */
    NETDEV_LOG_EXCEP_LEDBOX_SMOKE_RECOVER       = 435,              /* 豸澯ָ  LED Distribution Box Smoke Alarm Cleared */

    /* ־־ID  Sub type log ID of operation logs */
    /* ҵ  Services */
    NETDEV_LOG_OPSET_LOGIN                      = 450,              /* û¼  User login */
    NETDEV_LOG_OPSET_LOGOUT                     = 451,              /* ע¼  Log out */
    NETDEV_LOG_OPSET_USER_ADD                   = 452,              /* û  Add user */
    NETDEV_LOG_OPSET_USER_DEL                   = 453,              /* ûɾ  Delete user */
    NETDEV_LOG_OPSET_USER_MODIFY                = 454,              /* û޸  Modify user */
    NETDEV_LOG_OPSET_START_REC                  = 455,              /* ʼ¼  Start recording */
    NETDEV_LOG_OPSET_STOP_REC                   = 456,              /* ֹͣ¼  Stop recording */
    NETDEV_LOG_OPSETR_PLAY_DOWNLOAD             = 457,              /* ط/  Playback and download */
    NETDEV_LOG_OPSET_DOWNLOAD                   = 458,              /*   Download */
    NETDEV_LOG_OPSET_PTZCTRL                    = 459,              /* ̨  PTZ control */
    NETDEV_LOG_OPSET_PREVIEW                    = 460,              /* ʵԤ  Live preview */
    NETDEV_LOG_OPSET_REC_TRACK_START            = 461,              /* 켣¼ƿʼ  Start recording route */
    NETDEV_LOG_OPSET_REC_TRACK_STOP             = 462,              /* 켣¼ֹͣ  Stop recording route */
    NETDEV_LOG_OPSET_START_TALKBACK             = 463,              /* ʼԽ  Start two-way audio */
    NETDEV_LOG_OPSET_STOP_TALKBACK              = 464,              /* ֹͣԽ  Stop two-way audio */
    NETDEV_LOG_OPSET_IPC_ADD                    = 465,              /* IPC  Add IP camera */
    NETDEV_LOG_OPSET_IPC_DEL                    = 466,              /* ɾIPC  Delete IP camera */
    NETDEV_LOG_OPSET_IPC_SET                    = 467,              /* IPC  Modify IP camera */
    NETDEV_LOG_OPSET_IPC_QUICK_ADD              = 468,              /* IPC  quickAddIpc*/
    NETDEV_LOG_OPSET_IPC_ADD_BY_NETWORK         = 469,              /* IPC  addIpcByNetwork */
    NETDEV_LOG_OPSET_IPC_MOD_IP                 = 470,              /* ޸IPCַ  modifyIpcAddr */

    /*   Configurations */
    NETDEV_LOG_OPSET_DEV_BAS_CFG                = 500,              /* 豸Ϣ  Basic device information */
    NETDEV_LOG_OPSET_TIME_CFG                   = 501,              /* 豸ʱ  Device time */
    NETDEV_LOG_OPSET_SERIAL_CFG                 = 502,              /* 豸  Device serial port */
    NETDEV_LOG_OPSET_CHL_BAS_CFG                = 503,              /* ͨ  Basic channel configuration */
    NETDEV_LOG_OPSET_CHL_NAME_CFG               = 504,              /* ͨ  Channel name configuration */
    NETDEV_LOG_OPSET_CHL_ENC_VIDEO              = 505,              /* Ƶ  Video encoding configuration */
    NETDEV_LOG_OPSET_CHL_DIS_VIDEO              = 506,              /* ͨƵʾ  Video display configuration */
    NETDEV_LOG_OPSET_PTZ_CFG                    = 507,              /* ̨  PTZ configuration */
    NETDEV_LOG_OPSET_CRUISE_CFG                 = 508,              /* Ѳ·  Patrol route configuration */
    NETDEV_LOG_OPSET_PRESET_CFG                 = 509,              /* Ԥλ  Preset configuration */
    NETDEV_LOG_OPSET_VIDPLAN_CFG                = 510,              /* ¼ƻ  Recording schedule configuration */
    NETDEV_LOG_OPSET_MOTION_CFG                 = 511,              /* ˶  Motion detection configuration */
    NETDEV_LOG_OPSET_VIDLOSS_CFG                = 512,              /* Ƶʧ  Video loss configuration */
    NETDEV_LOG_OPSET_COVER_CFG                  = 513,              /* Ƶڵ  Tampering detection configuration */
    NETDEV_LOG_OPSET_MASK_CFG                   = 514,              /* Ƶڸ  Privacy mask configuration */
    NETDEV_LOG_OPSET_SCREEN_OSD_CFG             = 515,              /* OSD  OSD overlay configuration */
    NETDEV_LOG_OPSET_ALARMIN_CFG                = 516,              /*   Alarm input configuration */
    NETDEV_LOG_OPSET_ALARMOUT_CFG               = 517,              /*   Alarm output configuration */
    NETDEV_LOG_OPSET_ALARMOUT_OPEN_MAN          = 518,              /* ֶ,˻  Manually enable alarm output, GUI */
    NETDEV_LOG_OPSET_ALARMOUT_CLOSE_MAN         = 519,              /* ֶرձ,˻  Manually disable alarm input, GUI */
    NETDEV_LOG_OPSET_ABNORMAL_CFG               = 520,              /* 쳣  Exception configuration */
    NETDEV_LOG_OPSET_HDD_CFG                    = 521,              /* Ӳ  HDD configuration */
    NETDEV_LOG_OPSET_NET_IP_CFG                 = 522 ,             /* TCP/IP  TCP/IP configuration */
    NETDEV_LOG_OPSET_NET_PPPOE_CFG              = 523,              /* PPPOE  PPPOE configuration */
    NETDEV_LOG_OPSET_NET_PORT_CFG               = 524,              /* ˿  Port configuration */
    NETDEV_LOG_OPSET_NET_DDNS_CFG               = 525,              /* DDNS  DDNS configuration */
    NETDEV_LOG_OPSET_AUDIO_DETECT               = 527,              /* չӲ  searchExtendDisk */
    NETDEV_LOG_OPSET_SEARCH_EX_DISK             = 528,              /* չӲ  searchExtendDisk */
    NETDEV_LOG_OPSET_ADD_EX_DISK                = 529 ,             /* չӲ  addExtendDisk */
    NETDEV_LOG_OPSET_DEL_EX_DISK                = 530,              /* ɾչӲ  deleteExtendDisk */
    NETDEV_LOG_OPSET_SET_EX_DISK                = 531,              /* չӲ  setExtendDisk */
    NETDEV_LOG_OPSET_LIVE_BY_MULTICAST          = 532,              /* 鲥ʵ  liveViewByMulticast */
    NETDEV_LOG_OPSET_BISC_DEV_INFO              = 533,              /* 豸Ϣ  setBasicDeviceInfo */
    NETDEV_LOG_OPSET_PREVIEW_CFG                = 534,              /* Ԥ  SetPreviewOnNvr */
    NETDEV_LOG_OPSET_SET_EMAIL                  = 535,              /* ʼ  setEmail */
    NETDEV_LOG_OPSET_TEST_EMAIL                 = 536,              /* ʼ  testEmail */
    NETDEV_LOG_OPSET_SET_IPCONTROL              = 537,              /* IPȨ  setIPControl */
    NETDEV_LOG_OPSET_PORT_MAP                   = 538 ,             /* ˿ӳ  setPortMap */
    NETDEV_LOG_OPSET_ADD_TAG                    = 539,              /* ¼ǩ  addTag */
    NETDEV_LOG_OPSET_DEL_TAG                    = 540,              /* ɾ¼ǩ  deleteTag */
    NETDEV_LOG_OPSET_MOD_TAG                    = 541,              /* ޸¼ǩ  modifyTag */
    NETDEV_LOG_OPSET_LOCK_RECORD                = 542,              /* ¼  lockRecord */
    NETDEV_LOG_OPSET_UNLOCK_RECORD              = 543,              /* ¼  unlockRecord */
    NETDEV_LOG_OPSET_DDNS_UPDATE_SUCCESS        = 545,              /* DDNS³ɹ  DDNSUpdateSuccess */
    NETDEV_LOG_OPSET_DDNS_INCORRECT_ID          = 546,              /* DDNSʧܣû  DDNSUpdateFailedIncorrectUsernamePassword */
    NETDEV_LOG_OPSET_DDNS_DOMAIN_NAME_NOT_EXIST = 547,              /* DDNSʧܣ  DDNSUpdateFailedDomainNameNotExist */
    NETDEV_LOG_OPSET_DDNS_UPDATE_FAIL           = 548,              /* DDNSʧ  DDNSUpdateFailed */
    NETDEV_LOG_OPSET_HTTP_CFG                   = 549,              /* HTTPS  setHttps */
    NETDEV_LOG_OPSET_IP_OFFLINE_ALARM_CFG       = 550,              /* IPC߱  testDDNSDomain */
    NETDEV_LOG_OPSET_TELNET_CFG                 = 551,              /* Telnet  setTelnet */
    NETDEV_LOG_OPSET_TEST_DDNS_DOMAIN           = 552,              /* DDNS  testDDNSDomain */
    NETDEV_LOG_OPSET_DDNS_DOMAIN_CONFLICT       = 553,              /* DDNSͻ  DDNSDomainInvalid */
    NETDEV_LOG_OPSET_DDNS_DOMAIN_INVALID        = 554,              /* DDNSϷ  setDDNS */
    NETDEV_LOG_OPSET_DEL_PRESET                 = 555,              /* ɾԤλ  deletePreset */
    NETDEV_LOG_OPSET_PTZ_3D_POSITION            = 556,              /* ̨3Dλ  ptz3DPosition */
    NETDEV_LOG_OPSET_SNAPSHOT_SCHEDULE_CFG      = 557,              /* ץͼƻ  setSnapshotSchedule */
    NETDEV_LOG_OPSET_IMAGE_UPLOAD_SCHEDULE_CFG  = 558,              /* ͼƬϴƻ  setImageUploadSchedule */
    NETDEV_LOG_OPSET_FTP_CFG                    = 559,              /* FTP  setFtpServer */
    NETDEV_LOG_OPSET_TEST_FTP_SERVER            = 560,              /* FTPӲ  testFtpServer */
    NETDEV_LOG_OPSET_START_MANUAL_SNAPSHOT      = 561,              /* ֶץͼ  startManualSnapshot */
    NETDEV_LOG_OPSET_CLOSE_MANUAL_SNAPSHOT      = 562,              /* ֶץͼر  endManualSnapshot */
    NETDEV_LOG_OPSET_SNAPSHOT_CFG               = 563,              /* ץͼ  setSnapshot */
    NETDEV_LOG_OPSET_ADD_HOLIDAY                = 564,              /* Ӽ  addHoliday */
    NETDEV_LOG_OPSET_DEL_HOLIDAY                = 565,              /* ɾ  deleteHoliday */
    NETDEV_LOG_OPSET_MOD_HOLIDAY                = 566,              /* ޸ļ  modifyHoliday */
    NETDEV_LOG_OPSET_ONOFF_HOLIDAY              = 567,              /* /رռ  enableDisableHoliday */
    NETDEV_LOG_OPSET_ALLOCATE_SPACE             = 568,              /*   allocateSpace */
    NETDEV_LOG_OPSET_HDD_FULL_POLICY_CFG        = 569,              /*   setHddFullPolicy */
    NETDEV_LOG_OPSET_AUDIO_STREAM_CFG           = 570,              /* Ƶ  setAudioStream */
    NETDEV_LOG_OPSET_ARRAY_PROPERTY_CFG         = 571,              /*   setArrayProperty */
    NETDEV_LOG_OPSET_HOT_SPACE_DISK_CFG         = 572,              /* ȱ  setHotSpaceDisk */
    NETDEV_LOG_OPSET_CREAT_ARRAY                = 573,              /* ֶ  createArray */
    NETDEV_LOG_OPSET_ONE_CLICK_CREAT_ARRAY      = 574,              /* һ  oneClickCreateArray */
    NETDEV_LOG_OPSET_REBUILD_ARRAY              = 575,              /* ؽ  rebuildArray */
    NETDEV_LOG_OPSET_DEL_ARRAY                  = 576,              /* ɾ  deleteArray */
    NETDEV_LOG_OPSET_ENABLE_RAID                = 577,              /* RAIDģʽ  enableRaid */
    NETDEV_LOG_OPSET_DISABLE_RAID               = 578,              /* رRAIDģʽ  disableRaid */
    NETDEV_LOG_OPSET_TEST_SMART                 = 579,              /* S.M.A.R.T  testSmart */
    NETDEV_LOG_OPSET_SMART_CFG                  = 580,              /* S.M.A.R.T  setSmart */
    NETDEV_LOG_OPSET_BAD_SECTOR_DETECT          = 581,              /*   badSectorDetect */
    NETDEV_LOG_OPSET_AUDIO_ALARM_DURATION       = 582,              /* ʱ  setAudioAlarmDuration */
    NETDEV_LOG_OPSET_CLR_AUDIO_ALARM            = 583,             /*   clearAudioAlarm */
    NETDEV_LOG_OPSET_IPC_TIME_SYNC_CFG          = 584,              /* ͬʱ  setIpcTimeSync */
    NETDEV_LOG_OPSET_ENABLE_DISK_GROUP          = 585,              /*   enableDiskGroup */
    NETDEV_LOG_OPSET_DISABLE_DISK_GRRUOP        = 586,              /* ر  disableDiskGroup */
    NETDEV_LOG_OPSET_ONVIF_AUTH_CFG             = 587,              /* ONVIF֤  setOnvifAuth */
    NETDEV_LOG_OPSET_8021X_CFG                  = 588,              /* 802.1X  set8021x */
    NETDEV_LOG_OPSET_ARP_PROTECTION_CFG         = 589,              /* ARP  setArpProtection */
    NETDEV_LOG_OPSET_SMART_BASIC_INFO_CFG       = 590 ,             /* ܱϢ  setSmartBasicInfo */
    NETDEV_LOG_OPSET_CROSS_LINE_DETECT_CFG      = 591,              /* Խ  setCrossLineDetection */
    NETDEV_LOG_OPSET_INSTRUSION_DETECT_CFG      = 592,              /*   setIntrusionDetection */
    NETDEV_LOG_OPSET_PEOPLE_COUNT_CFG           = 593,              /*   setPeopleCount */
    NETDEV_LOG_OPSET_FACE_DETECT_CFG            = 594,              /*   setFaceDetection */
    NETDEV_LOG_OPSET_FISHEYE_CFG                = 595,              /*   setFisheye */
    NETDEV_LOG_OPSET_CUSTOM_PROTOCOL_CFG        = 596,              /* ԶЭ  setCustomProtocol */
    NETDEV_LOG_OPSET_BEHAVIOR_SEARCH            = 597,              /* Ϊ  behaviorSearch */
    NETDEV_LOG_OPSET_FACE_SEARCH                = 598,              /*   faceSearch */
    NETDEV_LOG_OPSET_PEOPLE_COUNT               = 599,              /* ͳ  peopleCount */
        
    /* ά Maintenance */
    NETDEV_LOG_OPSET_START_DVR                  = 600,              /*   Start up*/
    NETDEV_LOG_OPSET_STOP_DVR                   = 601,              /* ػ  Shut down */
    NETDEV_LOG_OPSET_REBOOT_DVR                 = 602,              /* 豸  Restart device */
    NETDEV_LOG_OPSET_UPGRADE                    = 603,              /* 汾  Version upgrade */
    NETDEV_LOG_OPSET_LOGFILE_EXPORT             = 604,              /* ־ļ  Export log files */
    NETDEV_LOG_OPSET_CFGFILE_EXPORT             = 605,              /* ļ  Export configuration files */
    NETDEV_LOG_OPSET_CFGFILE_IMPORT             = 606,              /* ļ  Import configuration files */
    NETDEV_LOG_OPSET_CONF_SIMPLE_INIT           = 607,              /* 򵥻ָ  Export configuration files */
    NETDEV_LOG_OPSET_CONF_ALL_INIT              = 608,               /* ָ  Restore to factory settings */

    NETDEV_LOG_OPSET_VCA_BACKUP                 = 700,              /* ܱ  vcaBackup */
    NETDEV_LOG_OPSET_3G4G_CFG                   = 701,              /* 3G/4G  set3g4g */
    NETDEV_LOG_OPSET_MOUNT_EXTENDED_DISK        = 702,              /* չӲ Mount extended disk*/
    NETDEV_LOG_OPSET_UNMOUNT_EXTENDED_DISK      = 703,              /* жչӲ Unmount extended disk*/
    NETDEV_LOG_OPSET_FORCE_USER_OFFLINE         = 704,              /* ǿû Force user off line*/

    NETDEV_LOG_OPSET_AUTO_FUNCTION              = 709,              /* Զά  autoFunction */
    NETDEV_LOG_OPSET_IPC_UPRAGDE                = 710,              /*   ipcUpgrade */
    NETDEV_LOG_OPSET_RESTORE_IPC_DEFAULTS       = 711,              /* ָĬ  restoreIpcDefaults */
    NETDEV_LOG_OPSET_ADD_TRANSACTION            = 712,              /* ӽ  addTransaction */
    NETDEV_LOG_OPSET_MOD_TRANSACTION            = 713,              /* ޸Ľ  modifyTransaction */
    NETDEV_LOG_OPSET_DEL_TRANSACTION            = 714,              /* ɾ  deleteTransaction */
    NETDEV_LOG_OPSET_POS_OSD                    = 715,              /* POSʾ  setPosOsd */
    NETDEV_LOG_OPSET_ADD_HOT_SPACE_DEV          = 716,              /* ӱ  addHotSpaceDevice */
    NETDEV_LOG_OPSET_DEL_HOT_SPACE_DEV          = 717,              /* ɾ  deleteHotSpaceDevice */
    NETDEV_LOG_OPSET_MOD_HOT_SPACE_DEV          = 718,              /* ޸ı  modifyHotSpaceDevice */
    NETDEV_LOG_OPSET_DEL_WORK_DEV               = 719,              /* ɾ  deleteWorkDevice */
    NETDEV_LOG_OPSET_WORKMODE_TO_NORMAL_CFG     = 720,              /* ùģʽ  SetWorkModeToNormal */
    NETDEV_LOG_OPSET_WORKMODE_TO_HOTSPACE_CFG   = 721,              /* ñģʽ  SetWorkModeToHotSpace */
    NETDEV_LOG_OPSET_AUTO_GUARD_CFG             = 723,              /*   setAutoGuard */
    NETDEV_LOG_OPSET_MULTICAST_CFG              = 724,              /* 鲥  SetMulticast */
    NETDEV_LOG_OPSET_DEFOCUS_DETECT_CFG         = 725,              /* 齹 Set defocus detection*/
    NETDEV_LOG_OPSET_SCENECHANGE_CFG            = 726,              /*  Set scene change detection*/
    NETDEV_LOG_OPSET_AUTO_TRCAK_CFG             = 727,              /* ܸ Set auto tracking*/
    NETDEV_LOG_OPSET_SORT_CAMERA_CFG            = 728,              /* ͨ Sort camera*/
    NETDEV_LOG_OPSET_WATER_MARK_CFG             = 729,              /* Ƶˮӡ Set watermark*/

    /* VMS־ */
    NETDEV_LOG_VMS_OPRERATE_SUB_ALL                     = 1000,    /* ȫ All Sub Operate Log */
    NETDEV_LOG_VMS_OPRERATE_SUB_USER_LOGIN              = 1001,    /* û½ User Login */
    NETDEV_LOG_VMS_OPRERATE_SUB_USER_LOGOUT             = 1002,    /* ûǳ User Logout */
    NETDEV_LOG_VMS_OPRERATE_SUB_USER_START_OPERATION    = 1003,    /* û User Start Operation */
    NETDEV_LOG_VMS_OPRERATE_SUB_USER_STOP_OPERATION     = 1004,    /* ûֹͣ User Stop Operation */
    NETDEV_LOG_VMS_OPRERATE_SUB_NEW_CONFIG              = 1005,    /*  New Config */
    NETDEV_LOG_VMS_OPRERATE_SUB_EDIT_CONFIG             = 1006,    /* ޸ Edit Config */
    NETDEV_LOG_VMS_OPRERATE_SUB_DELETE_CONFIG           = 1007,    /* ɾ Delete Config */
    NETDEV_LOG_VMS_OPRERATE_SUB_ENABLE_CONFIG           = 1008,    /*  Enable Config */
    NETDEV_LOG_VMS_OPRERATE_SUB_DISABLE_CONFIG          = 1009,    /* ͣ Disable Config */
    NETDEV_LOG_VMS_OPRERATE_SUB_TEST_CONFIG             = 1010,    /*  Test Config */
    NETDEV_LOG_VMS_OPRERATE_SUB_OPEN_DOOR               = 1011,    /*  Open Door */
    NETDEV_LOG_VMS_OPRERATE_SUB_CLOSE_DOOR              = 1012,    /*  Close Door */
    NETDEV_LOG_VMS_OPRERATE_SUB_SARM                    = 1013,    /*  Arm */
    NETDEV_LOG_VMS_OPRERATE_SUB_DISARM                  = 1014,    /*  Disarm */
    NETDEV_LOG_VMS_OPRERATE_SUB_BYPASS                  = 1015,    /* · Bypass */
    NETDEV_LOG_VMS_OPRERATE_SUB_UNBYPASS                = 1016,    /* · UnBypass */
    NETDEV_LOG_VMS_OPRERATE_SUB_SHARE_DEVICE            = 1017,    /* ƶ豸 Share Device */
    NETDEV_LOG_VMS_OPRERATE_SUB_UN_SHARE_DEVICE         = 1018,    /* ȡ Un Share Device */
    NETDEV_LOG_VMS_OPRERATE_SUB_START_CAP_PAC_TASK      = 1019,    /* ʼץ Start Cap Pac Task */
    NETDEV_LOG_VMS_OPRERATE_SUB_STOP_CAP_PAC_TASK       = 1020,    /* ֹͣץ Stop Cap Pac Task */
    NETDEV_LOG_VMS_OPRERATE_SUB_DELETE_CAPPAC_TASK      = 1021,    /* ɾץ Delete Cap Pac Task */
    NETDEV_LOG_VMS_OPRERATE_SUB_USB_INSERT              = 1022,    /* USB USB Insert */
    NETDEV_LOG_VMS_OPRERATE_SUB_USB_PULL_OUT            = 1023,    /* USBγ USB Pull Out */
    NETDEV_LOG_VMS_OPRERATE_SUB_USB_FORMAT              = 1024,    /* USBʽ USB Format */
    NETDEV_LOG_VMS_OPRERATE_SUB_SYNC_DEV_CHL_INFO       = 1025,    /* ͬ豸ͨϢ Sync Dev Chl Info */
    NETDEV_LOG_VMS_OPRERATE_SUB_PLAYBACK_LOCK           = 1026,    /* ¼ Playback Lock */
    NETDEV_LOG_VMS_OPRERATE_SUB_PLAYBACK_UNLOCK         = 1027     /* ¼ Playback Unlock */

}NETDEV_LOG_SUB_TYPE_E;

typedef enum tagNETDEVDeviceType
{
    NETDEV_DTYPE_UNKNOWN                        = 0,            /* Unknown type */
    NETDEV_DTYPE_IPC                            = 1,            /* IPC range */
    NETDEV_DTYPE_IPC_FISHEYE                    = 2,            /* ǾIPC Certain fisheye camera models*/
    NETDEV_DTYPE_IPC_ECONOMIC_FISHEYE           = 3,            /* IPC Certain fisheye camera models*/
    NETDEV_DTYPE_IPC_ACS                        = 4,            /* ŽIPC Person verification camera models*/
    NETDEV_DTYPE_NVR                            = 101,          /* NVR range */
    NETDEV_DTYPE_NVR_BACKUP                     = 102,          /* NVRݷ  NVR back up */
    NETDEV_DTYPE_HNVR                           = 103,          /* NVR */
    NETDEV_DTYPE_DC                             = 201,          /* DC range */
    NETDEV_DTYPE_DC_ADU                         = 202,          /* ADU range */
    NETDEV_DTYPE_EC                             = 301,          /* EC range */
    NETDEV_DTYPE_VMS                            = 501,          /* VMS range */
    NETDEV_DTYPE_FG                             = 601,          /* FG range */
    NETDEV_DTYPE_IPM                            = 701,          /* IPM range */
    NETDEV_DTYPE_EDU                            = 801,          /* EDU range */
	NETDEV_DTYPE_ITS                            = 801,          /* ITS range */
	NETDEV_DTYPE_PARK                            = 801,          /* PARK range */
    NETDEV_DTYPE_INVALID                        = 0xFFFF        /* Чֵ  Invalid value */
}NETDEV_DEVICE_TYPE_E;

/**
 * @brief  öٶ Parameter configuration command words Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVCfgCmd
{
    NETDEV_GET_DEVICECFG                = 100,              /* ȡ豸Ϣ,μ#NETDEV_DEVICE_BASICINFO_S  Get device information, see #NETDEV_DEVICE_BASICINFO_S */
    NETDEV_SET_DEVICECFG                = 101,              /*  Reserved */

    NETDEV_GET_NTPCFG                   = 110,              /* ȡNTP,μ#NETDEV_SYSTEM_NTP_INFO_S  Get NTP parameter, see #NETDEV_SYSTEM_NTP_INFO_S */
    NETDEV_SET_NTPCFG                   = 111,              /* NTP,μ#NETDEV_SYSTEM_NTP_INFO_S  Set NTP parameter, see #NETDEV_SYSTEM_NTP_INFO_S */

    NETDEV_GET_NTPCFG_EX                = 112,              /* ȡNTP(չʹ),μ#NETDEV_SYSTEM_NTP_INFO_LIST_S  Get NTP parameter, see #NETDEV_SYSTEM_NTP_INFO_LIST_S */
    NETDEV_SET_NTPCFG_EX                = 113,              /* NTP(չʹ),μ#NETDEV_SYSTEM_NTP_INFO_LIST_S  Set NTP parameter, see #NETDEV_SYSTEM_NTP_INFO_LIST_S */

    NETDEV_GET_STREAMCFG                = 120,              /* ȡƵ,μ#NETDEV_VIDEO_STREAM_INFO_S  Get video encoding parameter, see #NETDEV_VIDEO_STREAM_INFO_S */
    NETDEV_SET_STREAMCFG                = 121,              /* Ƶ,μ#NETDEV_VIDEO_STREAM_INFO_S  Set video encoding parameter, see #NETDEV_VIDEO_STREAM_INFO_S */
    NETDEV_GET_STREAMCFG_EX             = 122,              /* ȡƵ(չʹ),μ#NETDEV_VIDEO_STREAM_INFO_LIST_S  Get video encoding parameter, see #NETDEV_VIDEO_STREAM_INFO_LIST_S */
    NETDEV_SET_STREAMCFG_EX             = 123,              /* Ƶ(չʹ),μ#NETDEV_VIDEO_STREAM_INFO_LIST_S  Set video encoding parameter, see #NETDEV_VIDEO_STREAM_INFO_LIST_S */
    NETDEV_GET_VIDEOMODECFG             = 124,              /* ȡͼɼʽμ#NETDEV_VIDEO_MODE_INFO_S */
    NETDEV_SET_VIDEOMODECFG             = 125,              /* ͼɼʽμ#NETDEV_VIDEO_MODE_INFO_S */

    NETDEV_GET_OSDCFG                   = 140,              /* ȡOSDϢ,μ#NETDEV_VIDEO_OSD_CFG_S  Get OSD configuration information, see #NETDEV_VIDEO_OSD_CFG_S */
    NETDEV_SET_OSDCFG                   = 141,              /* OSDϢ,μ#NETDEV_VIDEO_OSD_CFG_S  Set OSD configuration information, see #NETDEV_VIDEO_OSD_CFG_S */
    NETDEV_GET_OSDCFG_EX                = 142,              /* ȡOSDб,μ#NETDEV_CHL_OSD_CFG_LIST_S  Get OSD configuration List, see #NETDEV_CHL_OSD_CFG_LIST_S */
    NETDEV_SET_OSDCFG_EX                = 143,              /* OSDб,μ#NETDEV_CHL_OSD_CFG_LIST_S  Set OSD configuration List, see #NETDEV_CHL_OSD_CFG_LIST_S */
    NETDEV_GET_OSD_CONTENT_CFG          = 144,              /* ȡOSDϢ(չʹ),μ#NETDEV_OSD_CONTENT_S  Get OSD configuration information, see #NETDEV_OSD_CONTENT_S */
    NETDEV_SET_OSD_CONTENT_CFG          = 145,              /* OSDϢ(չʹ),μ#NETDEV_OSD_CONTENT_S  Set OSD configuration information, see #NETDEV_OSD_CONTENT_S */
    NETDEV_GET_OSD_CONTENT_STYLE_CFG    = 146,              /* ȡOSDʽ,μ#NETDEV_OSD_CONTENT_STYLE_S  Get OSD content style, see #NETDEV_OSD_CONTENT_STYLE_S */
    NETDEV_SET_OSD_CONTENT_STYLE_CFG    = 147,              /* OSDʽ,μ#NETDEV_OSD_CONTENT_STYLE_S  Set OSD content style, see #NETDEV_OSD_CONTENT_STYLE_S */

    NETDEV_GET_ALARM_OUTPUTCFG          = 150,              /* ȡϢ,μ#NETDEV_ALARM_OUTPUT_LIST_S  Get boolean configuration information, see #NETDEV_ALARM_OUTPUT_LIST_S */
    NETDEV_SET_ALARM_OUTPUTCFG          = 151,              /* ÿϢ,μ#NETDEV_ALARM_OUTPUT_LIST_S  Set boolean configuration information, see #NETDEV_ALARM_OUTPUT_LIST_S */
    NETDEV_TRIGGER_ALARM_OUTPUT         = 152,              /* ,μ#NETDEV_TRIGGER_ALARM_OUTPUT_S        Trigger boolean, see #NETDEV_TRIGGER_ALARM_OUTPUT_S */
    NETDEV_GET_ALARM_INPUTCFG           = 153,              /* ȡ,μ#NETDEV_ALARM_INPUT_LIST_S   Get the number of boolean inputs, see #NETDEV_ALARM_INPUT_LIST_S */
    NETDEV_GET_MANUAL_ALARM_CFG         = 154,              /* ȡֶ澯Ϣμ#NETDEV_OUTPUT_SWITCH_ALARM_STATUS_LIST_S  Get manual alarm boolean configuration information, see #NETDEV_OUTPUT_SWITCH_ALARM_STATUS_LIST_S*/
    NETDEV_SET_MANUAL_ALARM_CFG         = 155,              /* ֶ澯Ϣμ#NETDEV_OUTPUT_SWITCH_MANUAL_ALARM_INFO_S  Set manual alarm boolean configuration information, see #NETDEV_OUTPUT_SWITCH_MANUAL_ALARM_INFO_S */
    NETDEV_GET_INPUTSWITCH_LIST_CFG     = 156,              /* ȡ뿪ãμ#NETDEV_INPUT_SWITCH_INFO_LIST_S  Get all input switch information, see #NETDEV_INPUT_SWITCH_INFO_LIST_S*/

    NETDEV_GET_IMAGECFG                 = 160,              /* ȡͼϢ,μ#NETDEV_IMAGE_SETTING_S  Get image configuration information, see #NETDEV_IMAGE_SETTING_S */
    NETDEV_SET_IMAGECFG                 = 161,              /* ͼϢ,μ#NETDEV_IMAGE_SETTING_S  Set image configuration information, see #NETDEV_IMAGE_SETTING_S */
    NETDEV_GET_IMAGE_EXPOSURE           = 162,              /* ȡͨͼع,μ#NETDEV_IMAGE_EXPOSURE_S  get image Exposure configuration information, see #NETDEV_IMAGE_EXPOSURE_S */
    NETDEV_SET_IMAGE_EXPOSURE           = 163,              /* ͨͼع,μ#NETDEV_IMAGE_EXPOSURE_S  Set image Exposure configuration information, see #NETDEV_IMAGE_EXPOSURE_S */
    NETDEV_GET_IMAGE_LAMP_CTRLCFG       = 164,              /* ȡƲ,μ#NETDEV_LAMP_CTRL_INFO_S  get channel lampctrl configuration information, see #NETDEV_LAMP_CTRL_INFO_S */
    NETDEV_SET_IMAGE_LAMP_CTRLCFG       = 165,              /* òƲ,μ#NETDEV_LAMP_CTRL_INFO_S  set channel lampctrl configuration information, see #NETDEV_LAMP_CTRL_INFO_S */
    NETDEV_GET_IMAGE_WHITE_BALANCE      = 166,              /* ȡͼƽ,μ#NETDEV_LAMP_CTRL_INFO_S  get channel lampctrl configuration information, see #NETDEV_LAMP_CTRL_INFO_S */
    NETDEV_SET_IMAGE_WHITE_BALANCE      = 167,              /* ͼƽ,μ#NETDEV_LAMP_CTRL_INFO_S  set channel lampctrl configuration information, see #NETDEV_LAMP_CTRL_INFO_S */
    NETDEV_SET_IMAGE_PARAM_RESET        = 168,              /* ͼĬֵset channel image param reset */

    NETDEV_GET_NETWORKCFG               = 170,              /* ȡϢ,μ#NETDEV_NETWORKCFG_S  Get network configuration information, see #NETDEV_NETWORKCFG_S */
    NETDEV_SET_NETWORKCFG               = 171,              /* Ϣ,μ#NETDEV_NETWORKCFG_S  Set network configuration information, see #NETDEV_NETWORKCFG_S */

    NETDEV_GET_VPN_CFG                  = 172,              /* ȡVPNͻָģʽϢ μ#NETDEV_VPN_CLIENT_INFO_S get the VPN client specified mode information, see #NETDEV_VPN_CLIENT_INFO_S*/
    NETDEV_SET_VPN_CFG                  = 173,              /* VPNͻָģʽϢ μ#NETDEV_VPN_CLIENT_INFO_S set the VPN client specified mode information, see #NETDEV_VPN_CLIENT_INFO_S*/
    NETDEV_SET_DNS_CFG                  = 174,              /*DNSַϢ μ#NETDEV_DNS_INFO_S Set DNS info see #NETDEV_DNS_INFO_S*/
    NETDEV_GET_DNS_CFG                  = 175,              /*ȡDNSַϢ μ#NETDEV_DNS_INFO_S Get DNS info see #NETDEV_DNS_INFO_S*/
    NETDEV_SET_NETWORK_CARDS            = 176,              /*豸Ϣ μ#NETDEV_NETWORK_CARD_INFO_S set device networkcards infos see #NETDEV_NETWORK_CARD_INFO_S*/
    NETDEV_GET_NETWORK_CARDS            = 177,              /*ȡ豸Ϣ μ#NETDEV_NETWORK_CARD_INFO_S get device networkcards infos see #NETDEV_NETWORK_CARD_INFO_S*/

    NETDEV_SET_NETWORK_PORTS            = 178,              /*豸˿Ϣ μ#NETDEV_NETWORK_PORTS_INFO_S set device network ports infos see #NETDEV_NETWORK_PORT_INFO_S*/ 
    NETDEV_GET_NETWORK_PORTS            = 179,              /*ȡ豸˿Ϣ μ#NETDEV_NETWORK_PORTS_INFO_S get device network ports infos see #NETDEV_NETWORK_PORT_INFO_S*/ 

    NETDEV_GET_PRIVACYMASKCFG           = 180,              /* ȡ˽ڸϢ,μ#NETDEV_PRIVACY_MASK_CFG_S  Get privacy mask configuration information, see #NETDEV_PRIVACY_MASK_CFG_S */
    NETDEV_SET_PRIVACYMASKCFG           = 181,              /* ˽ڸϢ,μ#NETDEV_PRIVACY_MASK_CFG_S  Set privacy mask configuration information, see #NETDEV_PRIVACY_MASK_CFG_S */
    NETDEV_DELETE_PRIVACYMASKCFG        = 182,              /* ɾ˽ڸϢ  Delete privacy mask configuration information */

    NETDEV_GET_TAMPERALARM              = 190,              /* ȡڵ澯Ϣ  μ#NETDEV_TAMPER_ALARM_INFO_S  Get tamper alarm configuration information, see #NETDEV_TAMPER_ALARM_INFO_S */
    NETDEV_SET_TAMPERALARM              = 191,              /* ڵ澯Ϣ  μ#NETDEV_TAMPER_ALARM_INFO_S  Set tamper alarm configuration information, see #NETDEV_TAMPER_ALARM_INFO_S */

    NETDEV_GET_MOTIONALARM              = 200,              /* ȡ˶澯Ϣ μ#NETDEV_MOTION_ALARM_INFO_S  Get motion alarm configuration information, see #NETDEV_MOTION_ALARM_INFO_S */
    NETDEV_SET_MOTIONALARM              = 201,              /* ˶澯Ϣ μ#NETDEV_MOTION_ALARM_INFO_S  Set motion alarm configuration information, see #NETDEV_MOTION_ALARM_INFO_S */

    NETDEV_GET_CROSSLINEALARM           = 202,              /* ȡԽ澯Ϣ μNETDEV_CROSS_LINE_ALARM_INFO_S Get Cross Line alarm configuration information, see #NETDEV_CROSS_LINE_ALARM_INFO_S*/
    NETDEV_SET_CROSSLINEALARM           = 203,              /* Խ澯Ϣ μNETDEV_CROSS_LINE_ALARM_INFO_S Set Cross Line alarm configuration information, see #NETDEV_CROSS_LINE_ALARM_INFO_S*/

    NETDEV_GET_INTRUSIONALARM           = 204,              /* ȡּ澯Ϣ μNETDEV_INTRUSION_ALARM_INFO_S Get intrusion alarm configuration information, see #NETDEV_INTRUSION_ALARM_INFO_S*/
    NETDEV_SET_INTRUSIONALARM           = 205,              /* ּ澯Ϣ μNETDEV_INTRUSION_ALARM_INFO_S Set intrusion alarm configuration information, see #NETDEV_INTRUSION_ALARM_INFO_S*/

    NETDEV_GET_DISKSINFO                = 210,              /* ȡӲϢ μ#NETDEV_GET_DISKS_INFO_S  Get disks information, see #NETDEV_GET_DISKS_INFO_S */
    NETDEV_SET_DISKSINFO                = 211,              /* ӲϢ  */

    NETDEV_GET_FOCUSINFO                = 230,              /* ȡ۽Ϣ μ#NETDEV_FOCUS_INFO_S Get focus info, see #NETDEV_FOCUS_INFO_S */
    NETDEV_SET_FOCUSINFO                = 231,              /* þ۽Ϣ μ#NETDEV_FOCUS_INFO_S Set focus info, see #NETDEV_FOCUS_INFO_S */
    NETDEV_GET_IRCUTFILTERINFO          = 232,              /* ȡҹģʽϢ μ#NETDEV_IRCUT_FILTER_INFO_S Get IRcut filter info, see #NETDEV_IRCUT_FILTER_INFO_S */
    NETDEV_SET_IRCUTFILTERINFO          = 233,              /* ҹģʽϢ μ#NETDEV_IRCUT_FILTER_INFO_S Set IRcut filter info, see #NETDEV_IRCUT_FILTER_INFO_S */
    NETDEV_GET_DEFOGGINGINFO            = 234,              /* ȡ͸ģʽϢ μ#NETDEV_DEFOGGING_INFO_S Get defogging info, see #NETDEV_DEFOGGING_INFO_S */
    NETDEV_SET_DEFOGGINGINFO            = 235,              /* ͸ģʽϢ μ#NETDEV_DEFOGGING_INFO_S Set defogging info, see #NETDEV_DEFOGGING_INFO_S */
    NETDEV_SET_CHL_IMAGE_ENHANCE        = 236,              /* ͨͼǿset channel image Enhance */
    NETDEV_GET_CHL_IMAGE_ENHANCE        = 237,              /* ȡͨͼǿget channel image Enhance */

    NETDEV_GET_AUDIOIN_CFG              = 240,              /* ȡƵϢ μ#NETDEV_AUDIO_INPUT_CFG_INFO_S get audio input config info see #NETDEV_AUDIO_INPUT_CFG_INFO_S */
    NETDEV_SET_AUDIOIN_CFG              = 241,              /* ƵϢ μ#NETDEV_AUDIO_INPUT_CFG_INFO_S set audio input config info see #NETDEV_AUDIO_INPUT_CFG_INFO_S */

    NETDEV_GET_DST_CFG                  = 260,              /* ȡʱϢ μ#NETDEV_DST_CFG_S Get defogging info, see #NETDEV_DST_CFG_S */
    NETDEV_SET_DST_CFG                  = 261,              /* ʱϢ μ#NETDEV_DST_CFG_S Set defogging info, see #NETDEV_DST_CFG_S */

    NETDEV_GET_RECORDPLANINFO           = 270,              /* ȡ¼ƻϢ ֧NVR VMS μ#NETDEV_RECORD_PLAN_CFG_INFO_S */
    NETDEV_SET_RECORDPLANINFO           = 271,              /* ¼ƻϢ ֧NVR VMS μ#NETDEV_RECORD_PLAN_CFG_INFO_S */
    NETDEV_SET_SNAPSHOT_CFG             = 272,              /* ָͨץͼ μ#NETDEV_VIDEO_SNAPSHOT_S Set snapshot info see #NETDEV_VIDEO_SNAPSHOT_S */
    NETDEV_GET_SNAPSHOT_CFG             = 273,              /* ȡָͨץͼ μ#NETDEV_VIDEO_SNAPSHOT_S Get snapshot info see #NETDEV_VIDEO_SNAPSHOT_S */

    NETDEV_GET_MOTIONDETECTION_WEEKPLAN     = 280,              /* ȡƶⲼƻ,μ#NETDEV_WEEK_PLAN_INFO_S  Get motion detection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_SET_MOTIONDETECTION_WEEKPLAN     = 281,              /* ƶⲼƻ,,μ#NETDEV_WEEK_PLAN_INFO_S  Set motion detection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_GET_CROSSLINEDETECTION_WEEKPLAN  = 282,              /* ȡԽⲼƻ,μ#NETDEV_WEEK_PLAN_INFO_S  Get CrossLine detection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_SET_CROSSLINEDETECTION_WEEKPLAN  = 283,              /* ԽⲼƻ,,μ#NETDEV_WEEK_PLAN_INFO_S  Set CrossLine detection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_GET_INTRUSIONDETECTION_WEEKPLAN  = 284,              /* ȡֲƻ,μ#NETDEV_WEEK_PLAN_INFO_S  Get Intrusion detection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_SET_INTRUSIONDETECTION_WEEKPLAN  = 285,              /* ֲƻ,,μ#NETDEV_WEEK_PLAN_INFO_S  Set Intrusion detection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_GET_AUDIODETECTION_WEEKPLAN      = 286,              /* ȡƵⲼƻ,μ#NETDEV_WEEK_PLAN_INFO_S  Get Audio detection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_SET_AUDIODETECTION_WEEKPLAN      = 287,              /* ƵⲼƻ,,μ#NETDEV_WEEK_PLAN_INFO_S  Set Audio detection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_GET_OBJTRACK_WEEKPLAN            = 288,              /* ȡĿٲƻ,μ#NETDEV_WEEK_PLAN_INFO_S  Get ObjTrack deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_SET_OBJTRACK_WEEKPLAN            = 289,              /* Ŀٲƻ,,μ#NETDEV_WEEK_PLAN_INFO_S  Set ObjTrack deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_GET_VIDEOLOSS_WEEKPLAN           = 290,              /* ȡƵʧĲƻ,μ#NETDEV_WEEK_PLAN_INFO_S  Get VideoLoss deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_SET_VIDEOLOSS_WEEKPLAN           = 291,              /* ƵʧĲƻ,,μ#NETDEV_WEEK_PLAN_INFO_S  Set VideoLoss deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_GET_TAMPERDETECTION_WEEKPLAN     = 292,              /* ȡڵⲼƻ,μ#NETDEV_WEEK_PLAN_INFO_S  Get TamperDetection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_SET_TAMPERDETECTION_WEEKPLAN     = 293,              /* ڵⲼƻ,,μ#NETDEV_WEEK_PLAN_INFO_S  Set TamperDetection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_GET_INPUTSWITCHES_WEEKPLAN       = 294,              /* ȡ뿪ƻ,μ#NETDEV_SWITCH_WEEK_PLAN_INFO_S  Get InputSwitches deployment plan, see #NETDEV_SWITCH_WEEK_PLAN_INFO_S */
    NETDEV_SET_INPUTSWITCHES_WEEKPLAN       = 295,              /* 뿪ƻ,,μ#NETDEV_SWITCH_WEEK_PLAN_INFO_S  Set InputSwitches deployment plan, see #NETDEV_SWITCH_WEEK_PLAN_INFO_S */
    NETDEV_GET_OUTPUTSWITCHES_WEEKPLAN      = 296,              /* ȡƻ,μ#NETDEV_WEEK_PLAN_INFO_S  Get OutputSwitches deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_SET_OUTPUTSWITCHES_WEEKPLAN      = 297,              /* ƻ,,μ#NETDEV_WEEK_PLAN_INFO_S  Set OutputSwitches deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_GET_DEFOCUSDETECTION_WEEKPLAN    = 298,              /* ȡ齹Ⲽƻ,μ#NETDEV_WEEK_PLAN_INFO_S  Get DefocusDetection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_SET_DEFOCUSDETECTION_WEEKPLAN    = 299,              /* 齹Ⲽƻ,,μ#NETDEV_WEEK_PLAN_INFO_S  Set DefocusDetection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_GET_SCENECHANGE_WEEKPLAN         = 300,              /* ȡƻ,μ#NETDEV_WEEK_PLAN_INFO_S  Get SceneChange deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_SET_SCENECHANGE_WEEKPLAN         = 301,              /* óƻ,,μ#NETDEV_WEEK_PLAN_INFO_S  Set SceneChange deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_GET_FACEDETECTION_WEEKPLAN       = 302,              /* ȡⲼƻ,μ#NETDEV_WEEK_PLAN_INFO_S  Get FaceDetection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */
    NETDEV_SET_FACEDETECTION_WEEKPLAN       = 303,              /* Ⲽƻ,,μ#NETDEV_WEEK_PLAN_INFO_S  Set FaceDetection deployment plan, see #NETDEV_WEEK_PLAN_INFO_S */

    NETDEV_GET_RECORD_STATUS                = 320,              /* ȡ¼״̬Ϣ μ#NETDEV_RECORD_STATUS_LIST_S  Get video status information*/

    NETDEV_GET_SERIAL_CFG                   = 330,              /* ȡ μ# NETDEV_SERIAL_PORTS_S Get serail info, see # NETDEV_SERIAL_PORTS_S */
    NETDEV_SET_SERIAL_CFG                   = 331,              /* ô μ# NETDEV_SERIAL_PORTS_S Set serail info, see # NETDEV_SERIAL_PORTS_S */


    NETDEV_GET_AUDIO_DECODE_STATUS              = 340,          /* ȡͨ·Ƶ״̬ μ#NETDEV_AUDIO_DECODE_STATUS_LIST_S */
    NETDEV_SET_AUDIO_DECODE_STATUS              = 341,          /* ͨ·Ƶ״̬ μ#NETDEV_AUDIO_DECODE_STATUS_LIST_S */

    NETDEV_GET_VIDEO_LOSS_RULE_INFO             = 400,          /* ȡƵʧ澯Ϣ μ#NETDEV_VIDEO_LOSS_RULE_INFO_S */
    NETDEV_SET_VIDEO_LOSS_RULE_INFO             = 401,          /* Ƶʧ澯Ϣ μ#NETDEV_VIDEO_LOSS_RULE_INFO_S */
    NETDEV_GET_VIDEO_LOSS_LINKAGE_ACTIONS       = 410,          /* ȡƵʧ澯 μ#NETDEV_VIDEO_LOSS_LINKAGE_ACTIONS */
    NETDEV_SET_VIDEO_LOSS_LINKAGE_ACTIONS       = 411,          /* Ƶʧ澯 μ#NETDEV_VIDEO_LOSS_LINKAGE_ACTIONS */
    NETDEV_GET_TAMPER_DETECTION_RULE_INFO       = 420,          /* ȡƵͨڵ澯 μ#NETDEV_TAMPER_DETECTION_RULE_INFO_S */
    NETDEV_SET_TAMPER_DETECTION_RULE_INFO       = 421,          /* Ƶͨڵ澯 μ#NETDEV_TAMPER_DETECTION_RULE_INFO_S */
    NETDEV_GET_TAMPER_DETECTION_LINKAGE_ACTIONS = 430,          /* ȡڵ澯 μ#NETDEV_TAMPER_DETECTION_LINKAGE_ACTIONS */
    NETDEV_SET_TAMPER_DETECTION_LINKAGE_ACTIONS = 431,          /* ڵ澯 μ#NETDEV_TAMPER_DETECTION_LINKAGE_ACTIONS */

    NETDEV_GET_MOTION_DETECTION_AREA_TYPE       = 440,          /* ȡƵͨ˶ μ#NETDEV_MOTION_DETECTION_AREA_TYPE_S */
    NETDEV_SET_MOTION_DETECTION_AREA_TYPE       = 441,          /* Ƶͨ˶ μ#NETDEV_MOTION_DETECTION_AREA_TYPE_S */
    NETDEV_GET_MOTION_DETECTION_AREA_GRID_INFO  = 442,          /* ȡƵͨ˶кϢ μ#NETDEV_MOTION_DETECTION_AREA_GRID_INFO_S */
    NETDEV_SET_MOTION_DETECTION_AREA_GRID_INFO  = 443,          /* Ƶͨ˶кϢ μ#NETDEV_MOTION_DETECTION_AREA_GRID_INFO_S */
    NETDEV_GET_MOTION_DETECTION_AREA_RECTANGLE_INFO_LIST  = 444,    /* ȡƵͨ˶еоϢ μ#NETDEV_MOTION_DETECTION_AREA_RECTANGLE_INFO_LIST_S */
    NETDEV_SET_MOTION_DETECTION_AREA_RECTANGLE_INFO_LIST  = 445,    /* Ƶͨ˶еоϢ μ#NETDEV_MOTION_DETECTION_AREA_RECTANGLE_INFO_LIST_S */
    NETDEV_GET_MOTION_DETECTION_LINKAGE_ACTIONS = 450,          /* ȡ˶澯 μ#NETDEV_LINKAGE_ACTION_LIST_S */
    NETDEV_SET_MOTION_DETECTION_LINKAGE_ACTIONS = 451,          /* ˶澯 μ#NETDEV_LINKAGE_ACTION_LIST_S */
    NETDEV_GET_INPUT_SWITCHES_LINKAGE_ACTIONS   = 460,          /* ȡ뿪澯 μ#NETDEV_SWITCH_LINKAGE_ACTION_S */
    NETDEV_SET_INPUT_SWITCHES_LINKAGE_ACTIONS   = 461,          /* 뿪澯 μ#NETDEV_SWITCH_LINKAGE_ACTION_S */

    NETDEV_GET_RAID_STATUS                      = 470,          /* ȡ״̬ μ#NETDEV_RAID_STATUS_S */
    NETDEV_GET_RAID_STORAGE_CONTAINER_INFO_LIST = 471,          /* ʹNETDEV_GET_RAID_STATUSȡ״̬״̬ʹʱȡ洢Ϣб μ#NETDEV_HDD_INFO_LIST_S */
    NETDEV_GET_STORAGE_CONTAINER_INFO_LIST      = 472,          /* ʹNETDEV_GET_RAID_STATUSȡ״̬״̬ʹʱȡ洢Ϣб μ#NETDEV_STORAGE_CONTAINER_INFO_LIST_S */
    NETDEV_GET_HDD_SMART_INFO                   = 473,          /* ȡָӲ̵SmartϢ μ#NETDEV_HDD_SMART_INFO_S */
    NETDEV_SET_HDD_SMART_INFO                   = 474,          /* ָӲ̵SmartϢ μ#NETDEV_HDD_SMART_CHECK_INFO_S */
    NETDEV_GET_RAID_STATUS_V30                  = 475,          /* ȡ״̬ ֧VMS/NVR μ#NETDEV_RAID_STATUS_S */
    NETDEV_SET_RAID_STATUS_V30                  = 476,          /* ״̬ ֧VMS/NVR μ#NETDEV_RAID_STATUS_S */

    NETDEV_GET_CLOUD_CONVENIENT_ACCS_STATUS     = 480,          /* ȡEzcloudƶ豸ģʽʹ״̬ ʹ״̬ 0ر 1 */
    NETDEV_SET_CLOUD_CONVENIENT_ACCS_STATUS     = 481,          /* Ezcloudƶ豸ģʽʹ״̬ ʹ״̬ 0ر 1 */
    
    NETDEV_GET_PHOTO_SERVER_INFO                = 482,          /* ȡƬշϢ μ# NETDEV_PHOTO_SERVER_CFG_INFO_S */
    NETDEV_SET_PHOTO_SERVER_INFO                = 483,          /* Ƭշ μ# NETDEV_PHOTO_SERVER_CFG_INFO_S */

    NETDEV_GET_ENHANCED_CONFIG                  = 484,          /* ȡһǿϢ,μ# NETDEV_ENHANCED_CONFIG_INFO_S */
    NETDEV_SET_ENHANCED_CONFIG                  = 485,          /* һǿϢ,μ# NETDEV_ENHANCED_CONFIG_INFO_S */

    NETDEV_GET_INTELLIGENT_SERVER_INFO          = 486,          /* ȡܷ μ# NETDEV_DATA_SERVER_LIST */
    NETDEV_SET_INTELLIGENT_SERVER_INFO          = 487,          /* ܷ μ# NETDEV_DATA_SERVER_LIST */

    NETDEV_GET_MOTION_INTERVAL_INFO             = 490,               /* ѯָƵͨ˶澯ı μ NETDEV_MOTION_INTERVAL_INFO_S */
    NETDEV_SET_MOTION_INTERVAL_INFO             = 491,               /* ָƵͨ˶澯ı μ NETDEV_MOTION_INTERVAL_INFO_S */

    NETDEV_GET_MANAGER_SERVER_INFO              = 492,          /* ȡ μ# NETDEV_MANAGER_SERVER_LIST_S */
    NETDEV_SET_MANAGER_SERVER_INFO              = 493,          /* ù μ# NETDEV_MANAGER_SERVER_LIST_S */

    NETDEV_GET_VISIBLE_RANGE_INFO               = 494,          /* ȡϢ μ# NETDEV_VISIBLE_RANGE_INFO_S */
    NETDEV_SET_VISIBLE_RANGE_INFO               = 495,          /* ÿϢ μ# NETDEV_VISIBLE_RANGE_INFO_S */

    NETDEV_GET_RESET_PWD_VERTIFY_INFO           = 496,          /* ȡһû֤Ϣ */
    NETDEV_SET_RESET_PWD_VERTIFY_INFO           = 497,          /* һû֤Ϣ */

    NETDEV_GET_CHL_STORAGE_QUOTA_INFO           = 498,          /* ȡͨľϢ μ#NETDEV_STORAGE_QUOTA_INFO_S */
    NETDEV_SET_CHL_STORAGE_QUOTA_INFO           = 499,          /* ͨľϢ μ#NETDEV_STORAGE_QUOTA_INFO_S */

    NETDEV_GET_CUSTOM_PROTOCOL_INFO             = 501,          /* ȡԶЭϢ μ# NETDEV_CUSTON_PROTOCOL_INFO_S */
    NETDEV_SET_CUSTOM_PROTOCOL_INFO             = 502,          /* ԶЭϢ μ# NETDEV_CUSTON_PROTOCOL_INFO_S */
    NETDEV_GET_CUSTOM_PROTOCOL_INFOLIST         = 503,          /* ȡԶЭϢб μ# NETDEV_CUSTON_PROTOCOL_SIMPLE_INFO_LIST_S */

    NETDEV_GET_CHL_STORAGE_STRATEGY             = 504,          /* ȡͨ洢Ϣ μ#NETDEV_STORAGE_STRATEGY_S */
    NETDEV_SET_CHL_STORAGE_STRATEGY             = 505,          /* ͨ洢Ϣ μ#NETDEV_STORAGE_STRATEGY_S */

    NETDEV_SET_BACKFOCUS                        = 506,          /* ں IPC֧ μ# NETDEV_BACKFOCUS_INFO_S */

	/*================================================== ITS&PARK  Begin=====================================================*/
	NETDEV_GET_PTZPRESETS               = 130,              /* ȡ̨Ԥλ,μ#NETDEV_PTZ_ALLPRESETS_S  Get PTZ preset, see #NETDEV_PTZ_ALLPRESETS_S */
	NETDEV_GET_PTZSTATUS                = 220,              /* ȡ̨״̬ μ#NETDEV_PTZ_STATUS_S Get PTZ status,  see #NETDEV_PTZ_STATUS_S  */

	NETDEV_GET_PARKSTATUSINFO           = 1000,             /* ȡλ״̬Ϣ μ#NETDEV_PARKSTATUS_INFO_S */

	NETDEV_GET_CARPORTCFG               = 1010,             /* ȡλϢ μ#NETDEV_CARPORT_CFG_S */
	NETDEV_SET_CARPORTCFG               = 1011,             /* óλϢ μ#NETDEV_CARPORT_CFG_S */

	NETDEV_GET_CARPORTCFG_EX            = 1012,             /* ȡλϢ(չʹ), μ#NETDEV_ITS_PARKING_DETECTION_S */
	NETDEV_SET_CARPORTCFG_EX            = 1013,             /* óλϢ(չʹ), μ#NETDEV_ITS_PARKING_DETECTION_S */


	NETDEV_GET_OSDSTYLECFG              = 1020,             /* ȡOSDʽ μ NETDEV_OSDSTYLE_CFG_S */
	NETDEV_SET_OSDSTYLECFG              = 1021,             /* õOSDʽ μ NETDEV_OSDSTYLE_CFG_S */

	NETDEV_GET_INFOOSDCFG               = 1030,             /* ȡOSD μ NETDEV_INFOOSD_CFG_S */
	NETDEV_SET_INFOOSDCFG               = 1031,             /* õOSD μ NETDEV_INFOOSD_CFG_S */

	NETDEV_GET_ACCPLICINFO              = 1040,             /* ȡʲ μ NETDEV_ACCPLIC_INFO_S */             
	NETDEV_SET_ACCPLICINFO              = 1041,             /* ÷ʲ μ NETDEV_ACCPLIC_INFO_S */

	NETDEV_GET_EXPOSURE_CFG_S           = 1050,             /*ͼع̬ */
	NETDEV_SET_EXPOSURE_CFG_S           = 1051,             /*ȡͼع̬ */

	NETDEV_GET_TELENTCONFIG             = 1060 ,            /*ȡͼ̬*/
	NETDEV_SET_TELENTCONFIG             = 1061,             /*ͼ̬*/  

	NETDEV_GET_IRCUT                    = 1070,             /*ȡƬƬл */
	NETDEV_SET_IRCUT                    = 1071,             /*ðƬƬл */

	NETDEV_GET_IMGENHANCE               = 1080,             /*ȡͼ */
	NETDEV_SET_IMGENHANCE               = 1081,             /*ͼ */ 

	NETDEV_GET_IMGCLARDATA              = 1090,             /*ȡͼ */
	NETDEV_SET_IMGCLARDATA              = 1091,             /*ͼ*/ 

	NETDEV_SET_IMGSWITCHCHANNEL         = 2000,             /*ͼͨл */

	NETDEV_GET_INFORELEASE              = 2010,             /* ȡãв μ  */
	NETDEV_SET_INFORELEASE              = 2011,             /* ãв μ  */

	NETDEV_GET_INFOWLIST                = 2020,             /* ȡã μ  */
	NETDEV_SET_INFOWLIST                = 2021,             /* ã μ  */

	NETDEV_GET_INFOBLIST                = 2030,             /* ȡã μ  */
	NETDEV_SET_INFOBLIST                = 2031,             /* ã μ  */

	NETDEV_GET_CARPORT_LED_CTRL         = 2040,              /* ȡλָʾƿ μ NETDEV_CARPORT_CONTROLLED_S (رhttpȨ)*/
	NETDEV_SET_CARPORT_LED_CTRL         = 2041,              /* óλָʾƿ μ NETDEV_CARPORT_CONTROLLED_S (رhttpȨ)*/

	NETDEV_GET_INSTALL_GUIDE_CFG        = 2050,              /* ȡڰװ μ NETDEV_INSTALL_GUIDE_CFG_S */
	NETDEV_SET_INSTALL_GUIDE_CFG        = 2051,              /* óڰװ μ NETDEV_INSTALL_GUIDE_CFG_S */

	/*================================================== ITS&PARK  End=====================================================*/

    NETDEV_CFG_INVALID                          = 0xFFFF                /* Чֵ  Invalid value */

}NETDEV_CONFIG_COMMAND_E;


/**
 * @brief ڸʽ öٶ OSD date format capabilities enumeration 
 * @attention  None
 */
typedef enum tagNETDEVDateOSDFormateCap
{
    NETDEV_OSD_DATE_FORMAT_CAP_MD_YYYY          = 0,        /* M/d/yyyy */
    NETDEV_OSD_DATE_FORMAT_CAP_MMDD_YYYY        = 1,        /* MM/dd/yyyy */
    NETDEV_OSD_DATE_FORMAT_CAP_DDMM_YYYY        = 2,        /* dd/MM/yyyy */
    NETDEV_OSD_DATE_FORMAT_CAP_YYYY_MMDD        = 3,        /* yyyy/MM/dd */
    NETDEV_OSD_DATE_FORMAT_CAP_YYYYMMDDB        = 4,        /* yyyy-MM-dd */
    NETDEV_OSD_DATE_FORMAT_CAP_XX_MMDD_YYYY     = 5,        /* dddd, MMMM dd, yyyy */
    NETDEV_OSD_DATE_FORMAT_CAP_MMMMDD_YYYY      = 6,        /* MMMM dd, yyyy */
    NETDEV_OSD_DATE_FORMAT_CAP_DDMMMM_YYYY      = 7         /* dd MMMM, yyyy */
}NETDEV_OSD_DATE_FORMAT_CAP_E;

/**
 * @brief OSDʱʽö OSD time format capabilities enumeration
 * @attention  None
 */
typedef enum tagNETDEVTimeOSDFormateCap
{
    NETDEV_OSD_TIME_FORMAT_CAP_HHMMSS = 0,                  /* HH:mm:ss */
    NETDEV_OSD_TIME_FORMAT_CAP_HH_MM_SS_PM                  /* hh:mm:ss tt */
}NETDEV_OSD_TIME_FORMAT_CAP_E;

/**
 * @brief 뿪ģʽ Boolean input operation mode
 * @attention  None
 */
typedef enum tagNETDEVBooleanMode
{
    NETDEV_BOOLEAN_MODE_OPEN   = 1,                         /*   Always open */
    NETDEV_BOOLEAN_MODE_CLOSE  = 2,                         /*   Always closed */
    NETDEV_BOOLEAN_MODE_INVALID
}NETDEV_BOOLEAN_MODE_E;

/**
 * @brief ״̬ Boolean input operation mode
 * @attention  None
 */
typedef enum tagNETDEVRelayOutPutState
{
    NETDEV_BOOLEAN_STATUS_ACTIVE    = 0,                /* ״̬  Triggered */
    NETDEV_BOOLEAN_STATUS_INACTIVE  = 1                 /* Ǵ״̬ Not triggered */
}NETDEV_RELAYOUTPUT_STATE_E;

/**
 * @brief ֶ澯״̬
 * @attention  None
 */
typedef enum tagNETDEVOutPutManualAlarmCmd
{
    NETDEV_MANUAL_ALARM_CMD_CLOSE    = 0,                /* ر close */
    NETDEV_MANUAL_ALARM_CMD_TRIGGER  = 1                 /*   Triggered */
}NETDEV_MANUAL_ALARM_CMD_E;

/**
* @brief ýʽ
* @attention 
*/
typedef enum tagNETDEVMediaDataFormat
{
    NETDEV_MEDIA_DATA_TS            = 0,            /* TS */
    NETDEV_MEDIA_DATA_RTP_ES        = 3             /* RTP + ES */
}NETDEV_MEDIA_DATA_FORMAT_E;

/**
* @brief Э
* @attention 
*/
typedef enum tagNETDEVProtocolType
{
    NETDEV_PROTOCOL_TYPE_HTTP  = 0,
    NETDEV_PROTOCOL_TYPE_HTTPS = 1,
    NETDEV_PROTOCOL_TYPE_RTSP  = 2
}NETDEV_PROTOCOL_TYPE_E;

/**
* @brief ʱ Time Zone
* @attention  None
*/
typedef enum tagNETDEVTimeZone
{
    NETDEV_TIME_ZONE_W1200 = 0,              /* W12 */
    NETDEV_TIME_ZONE_W1100 = 1,              /* W11 */
    NETDEV_TIME_ZONE_W1000 = 2,              /* W10 */
    NETDEV_TIME_ZONE_W0900 = 3,              /* W9 */
    NETDEV_TIME_ZONE_W0800 = 4,              /* W8 */
    NETDEV_TIME_ZONE_W0700 = 5,              /* W7 */
    NETDEV_TIME_ZONE_W0600 = 6,              /* W6 */
    NETDEV_TIME_ZONE_W0500 = 7,              /* W5 */
    NETDEV_TIME_ZONE_W0430 = 8,              /* W4:30 */
    NETDEV_TIME_ZONE_W0400 = 9,              /* W4 */
    NETDEV_TIME_ZONE_W0330 = 10,             /* W3:30 */
    NETDEV_TIME_ZONE_W0300 = 11,             /* W3 */
    NETDEV_TIME_ZONE_W0200 = 12,             /* W2 */
    NETDEV_TIME_ZONE_W0100 = 13,             /* W1 */
    NETDEV_TIME_ZONE_0000  = 14,             /* W0 */
    NETDEV_TIME_ZONE_E0100 = 15,             /* E1 */
    NETDEV_TIME_ZONE_E0200 = 16,             /* E2 */
    NETDEV_TIME_ZONE_E0300 = 17,             /* E3 */
    NETDEV_TIME_ZONE_E0330 = 18,             /* E3:30 */
    NETDEV_TIME_ZONE_E0400 = 19,             /* E4 */
    NETDEV_TIME_ZONE_E0430 = 20,             /* E4:30 */
    NETDEV_TIME_ZONE_E0500 = 21,             /* E5 */
    NETDEV_TIME_ZONE_E0530 = 22,             /* E5:30 */
    NETDEV_TIME_ZONE_E0545 = 23,             /* E5:45 */
    NETDEV_TIME_ZONE_E0600 = 24,             /* E6 */
    NETDEV_TIME_ZONE_E0630 = 25,             /* E6:30 */
    NETDEV_TIME_ZONE_E0700 = 26,             /* E7 */
    NETDEV_TIME_ZONE_E0800 = 27,             /* E8 */
    NETDEV_TIME_ZONE_E0900 = 28,             /* E9 */
    NETDEV_TIME_ZONE_E0930 = 29,             /* E9:30 */
    NETDEV_TIME_ZONE_E1000 = 30,             /* E10 */
    NETDEV_TIME_ZONE_E1100 = 31,             /* E11 */
    NETDEV_TIME_ZONE_E1200 = 32,             /* E12 */
    NETDEV_TIME_ZONE_E1300 = 33,             /* E13 */
    NETDEV_TIME_ZONE_W0930 = 34,             /* W9:30 */
    NETDEV_TIME_ZONE_E0830 = 35,             /* E8:30 */
    NETDEV_TIME_ZONE_E0845 = 36,             /* E8:45 */
    NETDEV_TIME_ZONE_E1030 = 37,             /* E10:30 */
    NETDEV_TIME_ZONE_E1245 = 38,             /* E12:45 */
    NETDEV_TIME_ZONE_E1400 = 39,             /* E14 */

    NETDEV_TIME_ZONE_INVALID = 0xFF          /* Invalid value */
}NETDEV_TIME_ZONE_E;

/**
* @brief Week emnu
* @attention 
*/
typedef enum tagNetDEVDayInWeek
{
    NETDEV_WEEK_SUNDAY                  = 0,                  /*   Sunday */
    NETDEV_WEEK_MONDAY                  = 1,                  /* һ  Monday */
    NETDEV_WEEK_TUESDAY                 = 2,                  /* ڶ  Tuesday */
    NETDEV_WEEK_WEDNESDAY               = 3,                  /*   Wednesday */
    NETDEV_WEEK_THURSDAY                = 4,                  /*   Thursday */
    NETDEV_WEEK_FRIDAY                  = 5,                  /*   Friday */
    NETDEV_WEEK_SATURDAY                = 6,                  /*   Saturday */
    NETDEV_WEEK_INVALID               = 0xff                  /* Чֵ Invalid value */
}NETDEV_DAY_IN_WEEK_E;

/**
* @brief ʱƫʱ DST offset time
* @attention 
*/
typedef enum tagNetDEVDSTOffsetTime
{
    NETDEV_DST_OFFSET_TIME_30MIN                 = 30,          /* 30  30Minutes */
    NETDEV_DST_OFFSET_TIME_60MIN                 = 60,          /* 60  60Minutes */
    NETDEV_DST_OFFSET_TIME_90MIN                 = 90,          /* 90  90Minutes */
    NETDEV_DST_OFFSET_TIME_120MIN                = 120,         /* 120  120Minutes */
    NETDEV_DST_OFFSET_TIME_INVALID               = 0xff         /* Чֵ Invalid value */
}NETDEV_DST_OFFSET_TIME;



/**
 * @brief ̹״̬ö Disk work status 
 * @attention  None
 */
typedef enum tagNETDEVDiskWorkStatus
{
    NETDEV_DISK_WORK_STATUS_EMPTY       = 0,            /* ״̬ Empty */
    NETDEV_DISK_WORK_STATUS_UNFORMAT    = 1,            /* δʽ״̬ Unformat */
    NETDEV_DISK_WORK_STATUS_FORMATING   = 2,            /* ʽ״̬ Formating */
    NETDEV_DISK_WORK_STATUS_RUNNING     = 3,            /* ״̬ Running */
    NETDEV_DISK_WORK_STATUS_HIBERNATE   = 4,            /* ״̬ Hibernate */
    NETDEV_DISK_WORK_STATUS_ABNORMAL    = 5,            /* 쳣״̬ Abnormal */
    NETDEV_DISK_WORK_STATUS_UNKNOWN     = 6,            /* δ֪״̬ Unknown */

    NETDEV_DISK_WORK_STATUS_INVALID                     /* Чֵ Invalid value */
}NETDEV_DISK_WORK_STATUS_E;

/**
* @enum tagNETDEVHDDType
* @brief 
* @attention  None
*/
typedef enum tagNETDEVHDDType
{
    NETDEV_HDD_TYPE_LOCAL_HDD       = 0,            /* LocalHDD */
    NETDEV_HDD_TYPE_NO1_EXTEND_HDD  = 1,            /* No1ExtendCabinetHDD */
    NETDEV_HDD_TYPE_NO2_EXTEND_HDD  = 2,            /* No2ExtendCabinetHDD */

    NETDEV_HDD_TYPE_INVALID = 0xFF                  /* Invalid value */
}NETDEV_HDD_TYPE_E;

/**
* @enum tagNETDEVHDDWorkMode
* @brief ̹ģʽ
* @attention  None
*/
typedef enum tagNETDEVHDDWorkMode
{
    NETDEV_HDD_WORK_MODE_COMMON     = 0,        /* ͨ */
    NETDEV_HDD_WORK_MODE_RAID       = 1,        /*  */
    NETDEV_HDD_WORK_MODE_HOT_BACKUP = 2,        /* ȱ */

    NETDEV_HDD_WORK_MODE_INVALID    = 0xFF      /* Invalid value */
}NETDEV_HDD_WORK_MODE_E;

/**
* @enum tagNETDEVHDDStatus
* @brief ״̬
* @attention  None
*/
typedef enum tagNETDEVHDDStatus
{
    NETDEV_HDD_STATUS_NO        = 0,            /* Ӳ */
    NETDEV_HDD_STATUS_NORMAL    = 1,            /*  */
    NETDEV_HDD_STATUS_ABNORMAL  = 2,            /* 쳣 */

    NETDEV_HDD_STATUS_INVALID = 0xFF            /* Invalid value */
}NETDEV_HDD_STATUS_E;

/**
* @enum tagNETDEVStorageContainerStatus
* @brief 洢״̬
* @attention  None
*/
typedef enum tagNETDEVStorageContainerStatus
{
    NETDEV_STORAGE_CONTAINER_STATUS_NO                      = 0,            /* Ӳ/ */
    NETDEV_STORAGE_CONTAINER_STATUS_UNFORMATTED             = 1,            /* δʽ */
    NETDEV_STORAGE_CONTAINER_STATUS_FORMATTING       = 2,            /* ڸʽ */
    NETDEV_STORAGE_CONTAINER_STATUS_NORMAL           = 3,            /* Ӳ״̬ */
    NETDEV_STORAGE_CONTAINER_STATUS_SLEEP            = 4,            /*  */
    NETDEV_STORAGE_CONTAINER_STATUS_ABNORMAL                = 5,            /* 쳣 */
    NETDEV_STORAGE_CONTAINER_STATUS_SWITCH           = 6,            /* л */
    NETDEV_STORAGE_CONTAINER_STATUS_UNINSTALLED      = 7,            /* ж */

    NETDEV_STORAGE_CONTAINER_STATUS_INVALID                 = 0xFF          /* Invalid value */
}NETDEV_STORAGE_CONTAINER_STATUS_E;

/**
* @enum tagNETDEVStorageContainerProperty
* @brief 洢
* @attention  None
*/
typedef enum tagNETDEVStorageContainerProperty
{
    NETDEV_STORAGE_CONTAINER_PROPERTY_RW                = 0,            /* д */
    NETDEV_STORAGE_CONTAINER_PROPERTY_R                 = 1,            /* ֻ */
    NETDEV_STORAGE_CONTAINER_PROPERTY_REDUNDANT         = 2,            /*  */

    NETDEV_STORAGE_CONTAINER_PROPERTY_INVALID           = 0xFF          /* Invalid value */
}NETDEV_STORAGE_CONTAINER_PROPERTY_E;

/**
* @enum tagNETDEVStorageContainerUsageType
* @brief 洢;
* @attention  None
*/
typedef enum tagNETDEVStorageContainerUsageType
{
    NETDEV_STORAGE_CONTAINER_USAGE_TYPE_RECORD_CAPTURE   = 0,        /* ¼/ץͼ */
    NETDEV_STORAGE_CONTAINER_USAGE_TYPE_BACKUP           = 1,        /*  */

    NETDEV_STORAGE_CONTAINER_USAGE_TYPE_INVALID          = 0xFF      /* Invalid value */
}NETDEV_STORAGE_CONTAINER_USAGE_TYPE_E;

/**
* @enum tagNETDEVHDDSmartCheckType
* @brief ӲSmart
* @attention  None
*/
typedef enum tagNETDEVHDDSmartCheckType
{
    NETDEV_HDD_SMART_CHECK_TYPE_BRIEF          = 0,        /*  */
    NETDEV_HDD_SMART_CHECK_TYPE_EXTEND         = 1,        /* չ */
    NETDEV_HDD_SMART_CHECK_TYPE_TRANSMISSION   = 2,        /*  */

    NETDEV_HDD_SMART_CHECK_TYPE_INVALID        = 0xFF      /* Invalid value */
}NETDEV_HDD_SMART_CHECK_TYPE_E;

/**
* @enum tagNETDEVPhotoServerProType
* @brief ƬͨЭ
* @attention  None
*/
typedef enum tagNETDEVPhotoServerProType
{
    NETDEV_PHOTO_SERVER_PRO_TYPE_PRO1          = 0,        /* TCP: V1Ӧ̣ */
    NETDEV_PHOTO_SERVER_PRO_TYPE_PRO2          = 1,        /* TCP: V2Ӧǰtms */
    NETDEV_PHOTO_SERVER_PRO_TYPE_PRO3          = 2,        /* TCP: ȴ */
    NETDEV_PHOTO_SERVER_PRO_TYPE_PRO4          = 3,        /* FTP: Ȫͨ */
    NETDEV_PHOTO_SERVER_PRO_TYPE_PRO5          = 4,        /* FTP: ͨFTP */
    NETDEV_PHOTO_SERVER_PRO_TYPE_PRO6          = 5,        /* FTP: ֱ */
    NETDEV_PHOTO_SERVER_PRO_TYPE_PRO7          = 6,        /* webserver: Э */
    NETDEV_PHOTO_SERVER_PRO_TYPE_PRO8          = 7,        /* FTP: ͨ */
    NETDEV_PHOTO_SERVER_PRO_TYPE_PRO9          = 8,        /* FTP: Ȫͨ2 */
    NETDEV_PHOTO_SERVER_PRO_TYPE_PRO10          = 9,       /* ƬϢwebserver ƬFTP */
    NETDEV_PHOTO_SERVER_PRO_TYPE_PRO11          = 10,      /* TCP:Ԫ */
    NETDEV_PHOTO_SERVER_PRO_TYPE_PRO12          = 11,      /* ѶƬϢTCP ƬFTP */
    NETDEV_PHOTO_SERVER_PRO_TYPE_PRO31          = 12,      /* TCP: V2Ӧǰtmsӣ */
    NETDEV_PHOTO_SERVER_PRO_TYPE_PRO34          = 13,      /* HTTP:  */

    NETDEV_PHOTO_SERVER_PRO_TYPE_INVALID        = 0xFF      /* Invalid value */
}NETDEV_PHOTO_SERVER_PRO_TYPE_E;

/**
* @enum tagNETDEVPhotoServerSubProtocolType
* @brief ƬͨЭ
* @attention  None
*/
typedef enum tagNETDEVPhotoServerSubProType
{
    NETDEV_PHOTO_SERVER_SUBPRO_TYPE_2011          = 0,        /* ǻ2011 */
    NETDEV_PHOTO_SERVER_SUBPRO_TYPE_2025          = 1,        /* ǻ2025 */
    NETDEV_PHOTO_SERVER_SUBPRO_TYPE_6130          = 2,        /* ǻ6130 */
    

    NETDEV_PHOTO_SERVER_SUBPRO_TYPE_INVALID        = 0xFF      /* Invalid value */
}NETDEV_PHOTO_SERVER_SUBPRO_TYPE_E;

/**
* @enum tagNETDEVHDDHealthAssessmentStatus
* @brief Ӳ̽״̬
* @attention  None
*/
typedef enum tagNETDEVHDDHealthAssessmentStatus
{
    NETDEV_HDD_HEALTH_ASSESSMENT_STATUS_NORMAL           = 0,        /* ״̬ */
    NETDEV_HDD_HEALTH_ASSESSMENT_STATUS_PART_DAMAGE      = 1,        /* ڻ */
    NETDEV_HDD_HEALTH_ASSESSMENT_STATUS_FAULT            = 2,        /*  */

    NETDEV_HDD_HEALTH_ASSESSMENT_STATUS_INVALID        = 0xFF      /* Invalid value */
}NETDEV_HDD_HEALTH_ASSESSMENT_STATUS_E;

/**
* @enum tagNETDEVHDDSmartAssessmentStatus
* @brief ӲSmart״̬
* @attention  None
*/
typedef enum tagNETDEVHDDSmartAssessmentStatus
{
    NETDEV_HDD_SMART_ASSESSMENT_STATUS_NORMAL       = 0,        /*  */
    NETDEV_HDD_SMART_ASSESSMENT_STATUS_WARNING      = 1,        /*  */
    NETDEV_HDD_SMART_ASSESSMENT_STATUS_FAULT        = 2,        /*  */

    NETDEV_HDD_SMART_ASSESSMENT_STATUS_INVALID      = 0xFF      /* Invalid value */
}NETDEV_HDD_SMART_ASSESSMENT_STATUS_E;

/**
* @enum tagNETDEVHDDSmartCheckStatus
* @brief ӲSmart״̬
* @attention  None
*/
typedef enum tagNETDEVHDDSmartCheckStatus
{
    NETDEV_HDD_SMART_CHECK_STATUS_NOT                = 0,        /* δ */
    NETDEV_HDD_SMART_CHECK_STATUS_IN_PORGRESS        = 1,        /* Լ */
    NETDEV_HDD_SMART_CHECK_STATUS_SUCCESS            = 2,        /* Լɹ */
    NETDEV_HDD_SMART_CHECK_STATUS_RECOGNITION_FAIL   = 3,        /* Ӳʶʧ */
    NETDEV_HDD_SMART_CHECK_STATUS_FAIL               = 4,        /* SMARTԼʧ */
    NETDEV_HDD_SMART_CHECK_STATUS_NOT_SUPPORT        = 5,        /* Ӳּ̲֧ */

    NETDEV_HDD_SMART_CHECK_STATUS_INVALID            = 0xFF      /* Invalid value */
}NETDEV_HDD_SMART_CHECK_STATUS_E;

/**
* @brief ͼ񲥷 Picture fluency
* @attention 
*/
typedef enum tagNetDEVPictureFluency
{
    NETDEV_PICTURE_REAL                 = 0,                /* ʵʱ Real-time first */
    NETDEV_PICTURE_FLUENCY              = 1,                /*  Fluency first */
    NETDEV_PICTURE_BALANCE_NEW          = 3,                /*  Balance */
    NETDEV_PICTURE_RTMP_FLUENCY         = 4,                /* RTMP RTMP fluency first */

    NETDEV_PICTURE_FLUENCY_INVALID      = 0xff              /* Чֵ Invalid value */
}NETDEV_PICTURE_FLUENCY_E;

/**
* @brief ̨λ öٶ PTZ home position operation commands Enumeration Definition
* @attention  None
*/
typedef enum tagNETDEVPtzHomePositionCmd
{
    NETDEV_PTZ_SET_HOMEPOSITION   = 0,            /* ÿλ  Set home position */
    NETDEV_PTZ_GOTO_HOMEPOSITION  = 1             /* תλ  Go to home position */
}NETDEV_PTZ_HOMEPOSITIONCMD_E;

/**
* @brief ۽״̬ PTZ Move status
* @attention  None
*/
typedef enum tagNETDEVPTZMoveStatus
{
    NETDEV_PTZ_MOVE_STATUS_IDLE     = 0,             /*  Free */
    NETDEV_PTZ_MOVE_STATUS_MOVING   = 1,             /* ھ۽ Moving */

    NETDEV_PTZ_MOVE_STATUS_INVALID  = 0xff           /* Чֵ Invalid value */
}NETDEV_PTZ_MOVE_STATUS_E;

/**
 * @brief ҹģʽ IRCut filter mode
 * @attention  None
 */
typedef enum  tagNETDEVIrCutFilterMode
{
    NETDEV_IR_CUT_FILTER_ON     = 0,            /* ģʽ On */
    NETDEV_IR_CUT_FILTER_OFF    = 1,            /* ҹģʽ Off */
    NETDEV_IR_CUT_FILTER_AUTO   = 2             /* Զģʽ Auto */
}NETDEV_IR_CUT_FILTER_MODE_E;

/**
 * @brief ͸ģʽö Defogging mode
 * @attention  None
 */
typedef enum  tagNETDEVDefoggingMode
{
    NETDEV_DEFOGGING_ON = 0,            /*  On */
    NETDEV_DEFOGGING_OFF                /*  Off */
}NETDEV_DEFOGGING_MODE_E;

/**
 * @brief ۽ģʽö Focus mode
 * @attention  None
 */
typedef enum tagNETDEVFocusMode
{
    NETDEV_FOCUS_AUTO           = 1,            /* Զ۽ Auto */
    NETDEV_FOCUS_MANUAL         = 2             /* ֶ۽ Manual */
}NETDEV_FOCUS_MODE_E;

/**
 * @brief С۽ö Focus near limit
 * @attention  None
 */
typedef enum tagNETDEVFocusNearlimit
{
    NETDEV_FOCUS_NEARLIMIT_10       = 1,            /* 10cm */
    NETDEV_FOCUS_NEARLIMIT_100      = 2,            /* 100cm */
    NETDEV_FOCUS_NEARLIMIT_300      = 3,            /* 300cm */
    NETDEV_FOCUS_NEARLIMIT_1000     = 4,            /* 1000cm */

    NETDEV_FOCUS_NEARLIMI_INVALID   = 0xff          /* Чֵ  Invalid value */
}NETDEV_FOCUS_NEARLIMIT_E;

/**
* @brief ¼ Record Type
* @attention 
*/
typedef enum tagNETDEVRecordType
{
    NETDEV_RECORD_TYPE_MANUAL  = 0,
    NETDEV_RECORD_TYPE_NORMAL = 1
}NETDEV_RECORD_TYPE_E;


/**
 * @brief ¼ѯλ Video Position
 * @attention  None
 */
typedef enum tagNETDEVVideoPosition
{
    NETDEV_POSITION_LOCAL       = 1,            /* 豸¼ */
    NETDEV_POSITION_CHANNEL     = 2,            /* 豸µͨ¼ */
    NETDEV_POSITION_INVALID
}NETDEV_VIDEO_POSITION_E;

/**
 * @brief ¼״̬ Video Status
 * @attention  None
 */
typedef enum tagNETDEVVideoStatus
{
    NETDEV_VIDEO_NONE       = 0,        /* ¼ No video */
    NETDEV_VIDEO_EVENT      = 1,        /* ¼¼ Event video */
    NETDEV_VIDEO_NORMAL     = 2,        /* ͨ¼ Normal video */
    NETDEV_VIDEO_INVALID
}NETDEV_VIDEO_STATUS_E;


/**
* @brief  Device capability commond
* @attention 
*/
typedef enum tagNETDEVCapabilityCommond
{
    NETDEV_CAP_VIDEO_ENCODE         = 1,            /* Ƶ μ# NETDEV_VIDEO_STREAM_CAP_S Video encoding capability. See # NETDEV_VIDEO_STREAM_CAP_S for reference*/
    NETDEV_CAP_OSD                  = 2,            /* OSD μ# NETDEV_OSD_CAP_S OSD parameter capability. See # NETDEV_OSD_CAP_S for reference*/
    NETDEV_CAP_SMART                = 3,            /*  μ# NETDEV_SMART_CAP_S Smart capability. See # NETDEV_SMART_CAP_S for reference */
    NETDEV_CAP_VIDEO_ENCODE_EX      = 4,            /* Ƶչ μ# NETDEV_VIDEO_STREAM_CAP_EX_S Video encoding capability. See # NETDEV_VIDEO_STREAM_CAP_EX_S for reference */
    NETDEV_CAP_IMAGE                = 5,            /* ͼ μ#NETDEV_IMAGE_CAP_S Image capability See # NETDEV_IMAGE_CAP_S for reference*/
    NETDEV_CAP_AUDIO                = 6,            /* Ƶ μ NETDEV_AUDIO_CAPABILITY_INFO_S */
    NETDEV_CAP_VIDEO_SNAPSHOT       = 7,            /* Ƶͨץͼ μ#NETDEV_VIDEO_SNAP_CAP_S Video snapshot capability. See # NETDEV_VIDEO_SNAP_CAP_S for reference   ĿǰIPC֧*/
    NETDEV_CAP_FACE_RECOGNAZE       = 10,           /* ʶ ĿǰNVR֧, μNETDEV_DEV_FACE_CAP_INFO_S */
    NETDEV_CAP_DEV_NIC              = 11,           /* 豸, μNETDEV_NIC_CAP_INFO_S */
    NETDEV_CAP_DEV_EXCEPTION_ALARM  = 12,           /* 豸쳣澯, μ# NETDEV_EXCP_ALARM_CAP_INFO_S */
    NETDEV_CAP_CHANNELS_ALARM       = 13,           /* ͨ澯, μ NETDEV_CHN_ALARM_CAP_INFO_S */

    NETDEV_CAP_INVALID              = 0Xff
}NETDEV_CAPABILITY_COMMOND_E;

/**
* @brief ʽ
* @attention 
*/
typedef enum tagNETDEVVideoEncodeType
{
    NETDEV_VIDEO_ENCODE_H264    = 1,
    NETDEV_VIDEO_ENCODE_MPEG4   = 2,
    NETDEV_VIDEO_ENCODE_JPEG    = 3,

    NETDEV_VIDEO_ENCODE_INVALID = 0XFF
}NETDEV_ENCODE_TYPE_E;


/**
* @brief ͳģʽ öٶ
* @attention  None
*/
typedef enum tagNETDEVTrafficStatisticsType
{
    NETDEV_TRAFFIC_STATISTICS_TYPE_IN   = 0,        /* ͳͣ Statistics type : Enter */
    NETDEV_TRAFFIC_STATISTICS_TYPE_OUT  = 1,        /* ͳͣ뿪 Statistics type : Exit */
    NETDEV_TRAFFIC_STATISTICS_TYPE_ALL  = 2,        /* ͳͣ Statistics type : All */
    NETDEV_TRAFFIC_STATISTICS_TYPE_BUTT
}NETDEV_TRAFFIC_STATISTICS_TYPE_E;

/**
* @brief ͳƱ öٶ
* @attention  None
*/
typedef enum tagNETDEVFormType
{
    NETDEV_FORM_TYPE_DAY    = 0,            /* ձ Form type : Day */
    NETDEV_FORM_TYPE_WEEK   = 1,            /* ܱ Form type : Week */
    NETDEV_FORM_TYPE_MONTH  = 2,            /* ± Form type : Month */
    NETDEV_FORM_TYPE_YEAR   = 3,            /* 걨 Form type : Year */
    NETDEV_FORM_TYPE_BUTT
}NETDEV_FORM_TYPE_E;

/**
* @brief ַ öٶ
* @attention  None
*/
typedef enum tagNETDEVAddrType
{
    NETDEV_ADDR_TYPE_IPV4       = 0,             /* IPV4 */
    NETDEV_ADDR_TYPE_IPV6       = 1,             /* IPV6 */
    NETDEV_ADDR_TYPE_DOMAIN     = 2,             /*  */
    NETDEV_ADDR_TYPE_IPV4_IPV6  = 3,             /* IPV4IPV6Ҫ */
    NETDEV_ADDR_TYPE_INVALID    = 0XFFFF         /* Чֵ */
}NETDEV_ADDR_TYPE_E;

/**
* @brief ͼչģʽ öٶ Enumeration of smart image encoding mode
* @attention  None
*/
typedef enum tagNETDEVSmartEncodeMode
{
    NETDEV_SMART_ENCODE_MODE_OFF      = 0,      /* ر Off*/
    NETDEV_SMART_ENCODE_MODE_BASIC    = 1,      /* ܱģʽ Basic mode*/
    NETDEV_SMART_ENCODE_MODE_ADVANCED           /* ߼ܱģʽ Advanced mode*/
}NETDEV_SMART_ENCODE_MODE_E;
/**
* @brief ģʽ öٶ Enumeration of bit rate mode
* @attention  None
*/
typedef enum tagNETDEVBitRateType
{
    NETDEV_BIT_RATE_TYPE_CBR      = 0,         /* CBRģʽ CBR mode*/
    NETDEV_BIT_RATE_TYPE_VBR      = 1          /* VBRģʽ VBR mode*/
}NETDEV_BIT_RATE_TYPE_E;

/**
* @brief  öٶ Enumeration of main stream type
* @attention  None
*/
typedef enum tagNETDEVMainStreamType
{
    NETDEV_MAIN_STREAM_TYPE_TIME     = 0,      /* ʱ Scheduled main stream*/
    NETDEV_MAIN_STREAM_TYPE_EVENT    = 1       /* ¼ Event main stream*/
}NETDEV_MAIN_STREAM_TYPE_E;

/**
* @brief GOP öٶ Enumeration of GOP type
* @attention  None
*/
typedef enum tagNETDEVGopType
{
    NETDEV_GOP_TYPE_IP       = 0,      /* IP */
    NETDEV_GOP_TYPE_IBP      = 1,      /* IBP */
    NETDEV_GOP_TYPE_IBBP     = 2,      /* IBBP */
    NETDEV_GOP_TYPE_I        = 3       /* I */
}NETDEV_GOP_TYPE_E;

/**
* @brief OSD öٶ Enumeration of content type
* @attention  None
*/
typedef enum tagNETDEVOSDContentType
{
    NETDEV_OSD_CONTENT_TYPE_NOTUSE                      = 0,                    /* ʹ Not used*/
    NETDEV_OSD_CONTENT_TYPE_CUSTOM                      = 1,                    /* Զ Custom*/
    NETDEV_OSD_CONTENT_TYPE_DATE_AND_TIME               = 2,                    /* ʱ Time and date*/
    NETDEV_OSD_CONTENT_TYPE_PTZ_CONTROLLER              = 3,                    /* ̨ PTZ controller*/
    NETDEV_OSD_CONTENT_TYPE_PTZ_COORDINATES             = 4,                    /* ̨ PTZ Coordinates*/
    NETDEV_OSD_CONTENT_TYPE_CRUISE                      = 5,                    /* ѲϢ Patrol*/
    NETDEV_OSD_CONTENT_TYPE_ZOOM                        = 6,                    /* 䱶Ϣ Zoom*/
    NETDEV_OSD_CONTENT_TYPE_PRESET                      = 7,                    /* ԤλϢ  Preset*/
    NETDEV_OSD_CONTENT_TYPE_ALARM_INFO                  = 8,                    /* Ϣ Alarm */
    NETDEV_OSD_CONTENT_TYPE_ENCODE                      = 9,                    /* Ϣ Encoding*/
    NETDEV_OSD_CONTENT_TYPE_SERIAL_PORT                 = 10,                   /* OSD Serial Port OSD*/
    NETDEV_OSD_CONTENT_TYPE_PTZ_ORIENTATION             = 11,                   /* ̨λϢ PZT direction*/
    NETDEV_OSD_CONTENT_TYPE_CHN_NAME                    = 12,                   /* ͨ Channel name*/
    NETDEV_OSD_CONTENT_TYPE_DEBUG                       = 13,                   /* OSD  Debug OSD*/
    NETDEV_OSD_CONTENT_TYPE_PEOPLE_COUNTING             = 14,                   /* ͳOSD People counting OSD*/
    NETDEV_OSD_CONTENT_TYPE_NETWORK_PORT                = 15,                   /* OSD Network Port OSD*/
    NETDEV_OSD_CONTENT_TYPE_TIME                        = 16,                   /* ʱ Time*/
    NETDEV_OSD_CONTENT_TYPE_DATE                        = 17,                   /*  Date*/
    NETDEV_OSD_CONTENT_TYPE_SMART_CONTENT               = 18,                   /* OSD Sensing OSD*/
    NETDEV_OSD_CONTENT_TYPE_BATTERY                     = 19,                   /* OSD Battery OSD*/
    NETDEV_OSD_CONTENT_TYPE_SCROLL_OSD                  = 20,                   /* ĻOSD Scroll text OSD*/
    NETDEV_OSD_CONTENT_TYPE_PICTURE_OVERLAY             = 21,                   /* LOGO OSD */
    NETDEV_OSD_CONTENT_TYPE_MOTOR_VEHICLE_NUM           = 22,                   /* ڻ Vehicle flow of LPR*/
    NETDEV_OSD_CONTENT_TYPE_NON_MOTOR_VEHICLE_NUM       = 23,                   /* ڷǻ Non-vehicle flow of LPR*/
    NETDEV_OSD_CONTENT_TYPE_PEOPLE_NUM                  = 24,                   /*  Pedestrian flow of LPR*/
    NETDEV_OSD_CONTENT_TYPE_INFOOSD_NUM                 = 25                    /* INFOOSDĿ Number of INFOOSDtype*/
}NETDEV_OSD_CONTENT_TYPE_E;

/**
 * @brief ڸʽ öٶ Enumeration of date format
 * @attention  None
 */
typedef enum tagNETDEVDateOSDFormate
{
    NETDEV_OSD_DATE_FORMAT_YYYY_MMDD                = 0,           /* yyyy-MM-dd */
    NETDEV_OSD_DATE_FORMAT_MMDD_YYYY                = 1,           /* MM-dd-yyyy */
    NETDEV_OSD_DATE_FORMAT_CHINESE_YYYY_MMDD        = 2,           /* yyyyMMdd yyyy/MM/dd*/
    NETDEV_OSD_DATE_FORMAT_CHINESE_MMDD_YYYY        = 3,           /* MMddyyyy MM/dd/yyyy*/
    NETDEV_OSD_DATE_FORMAT_CHINESE_YYY_MMDD_X       = 4,           /*  yyyyMMdd X dddd yyyy MM dd*/
    NETDEV_OSD_DATE_FORMAT_CHINESE_MMDD_YYYY_X      = 5,           /* MMddyyyy X dddd MM dd yyyy*/
    NETDEV_OSD_DATE_FORMAT_ENGLISH_DDMM_YYYY        = 100,         /* dd/MM/yyyy */
    NETDEV_OSD_DATE_FORMAT_ENGLISH_MMDD_YYYY        = 101,         /* MM/dd/yyyy */
    NETDEV_OSD_DATE_FORMAT_ENGLISH_DDMMMM_YYYY      = 102,         /* dd MMMM, yyyy */
    NETDEV_OSD_DATE_FORMAT_ENGLISH_MMMMDD_YYYY      = 103,         /* MMMM dd, yyyy */
    NETDEV_OSD_DATE_FORMAT_ENGLISH_DDDDDDMMMM_YYYY  = 104,         /* dddd, dd MMMM, yyyy  */
    NETDEV_OSD_DATE_FORMAT_ENGLISH_DDDDDDMMMM_DDYYYY = 105,        /* dddd, MMMM dd, yyyy */
    NETDEV_OSD_DATE_FORMAT_ENGLISH_YYYY_MMDD        = 106,         /*  yyyy/MM/dd */
    NETDEV_OSD_DATE_FORMAT_ENGLISH_YYYY_MMMMDD      = 107,         /*  yyyy, MMMM dd */
    NETDEV_OSD_DATE_FORMAT_ENGLISH_DDDDYY_MMDD      = 108         /*  dddd, yy, MM dd */
}NETDEV_OSD_DATE_FORMAT_E;

/**
 * @brief OSDʱʽö Enumeration of OSD time format
 * @attention  None
 */
typedef enum tagNETDEVTimeOSDFormate
{
    NETDEV_OSD_TIME_FORMAT_HHMMSS         = 0,                  /* HH:mm:ss */
    NETDEV_OSD_TIME_FORMAT_HH_MM_SS_T     = 1,                  /* hh:mm:ss t.t. */
    NETDEV_OSD_TIME_FORMAT_HH_MM_SS_TT    = 2,                  /* hh:mm:ss tt */
    NETDEV_OSD_TIME_FORMAT_TT_HH_MM_SS    = 3,                  /*  tt hh:mm:ss */
    NETDEV_OSD_TIME_FORMAT_PM_HH_MM_SS    = 4,                  /*  hh:mm:ss  P.M. hh:mm:ss*/
    NETDEV_OSD_TIME_FORMAT_HH_MM_SS_XX    = 5,                  /* HH:mm:ss.xxx */
    NETDEV_OSD_TIME_FORMAT_HH_MM_SS_XX_TT = 6                   /* hh:mm:ss.xxx tt */

}NETDEV_OSD_TIME_FORMAT_E;

/**
 * @brief OSDʽö Enumeration of OSD font style
 * @attention  None
 */
typedef enum tagNETDEVOSDFontStyle
{
    NETDEV_OSD_FONT_STYLE_BACKGROUND    = 0,                  /*  Background*/
    NETDEV_OSD_FONT_STYLE_STROKE        = 1,                  /*  Stroke*/
    NETDEV_OSD_FONT_STYLE_HOLLOW        = 2,                  /*  Hollow*/
    NETDEV_OSD_FONT_STYLE_NORMAL        = 3                   /*  Normal*/
}NETDEV_OSD_FONT_STYLE_E;

/**
 * @brief OSDСö Enumeration of OSD font size
 * @attention  None
 */
typedef enum tagNETDEVOSDFontSize
{
    NETDEV_OSD_FONT_SIZE_LARGE      = 0,                  /* ش X-large*/
    NETDEV_OSD_FONT_SIZE_BIG        = 1,                  /*  Large*/
    NETDEV_OSD_FONT_SIZE_MEDIUM     = 2,                  /*  Medium*/
    NETDEV_OSD_FONT_SIZE_SMALL      = 3                   /* С Small*/
}NETDEV_OSD_FONT_SIZE_E;

/**
 * @brief OSDСö Enumeration of OSD font size
 * @attention  None
 */
typedef enum tagNETDEVOSDMinMargin
{
    NETDEV_OSD_MIN_MARGIN_NONE    = 0,               /*  None*/
    NETDEV_OSD_MIN_MARGIN_SINGLE  = 1,               /* һַ One char width*/
    NETDEV_OSD_MIN_MARGIN_DOUBLE  = 2                /* ַ Two char width*/
}NETDEV_OSD_MIN_MARGIN_E;

/**
 * @brief OSDڶö Enumeration of OSD align
 * @attention  None
 */
typedef enum tagNETDEVOSDAlign
{
    NETDEV_OSD_ALIGN_LEFT       = 0,               /*  Left*/
    NETDEV_OSD_ALIGN_RIGHT      = 1                /* Ҷ Right*/
}NETDEV_OSD_ALIGN_E;

/**
*@brief ģʽö
*@attention 
*/
typedef enum tagNETDEVPullStreamMode
{
    NETDEV_STREAM_MODE_SERVER_DISTRIBUTE    = 0,   /*  */
    NETDEV_STREAM_MODE_FORCE_CDN            = 1    /* ǿƷַ */
}NETDEV_PULL_STREAM_MODE_E;


/**
*@brief ַģʽö
*@attention 
*/
typedef enum tagNETDEVDistributeMode
{
    NETDEV_DISTRIBUTE_MODE_AUTO       = 0,            /* Զ */
    NETDEV_DISTRIBUTE_MODE_FORCE      = 1             /* ǿ */
}NETDEV_DISTRIBUTE_MODE_E;

/**
*@brief ö
*@attention 
*/
typedef enum tagNETDEVListenType
{
    NETDEV_FACE_SNAPSHOT_TYPE       = 1,    //ץ

    NETDEV_LISTEN_TYPE_INVALID      = 0xffff
}NETDEV_LISTEN_TYPE_E;


/**
*@brief ¼ö
*@attention 
*/
typedef enum tagNETDEVLoginType
{
    NETDEV_LOGIN_TYPE_LOCAL             = 0,          /* ص¼ */
    NETDEV_LOGIN_TYPE_DYNAMIC           = 1,          /* ̬¼ */
    NETDEV_LOGIN_TYPE_LOCAL_ALL         = 2,          /* ֵ֧豸 */
    NETDEV_LOGIN_TYPE_CLOUD_DEVICE      = 3,          /* 豸¼ */
    NETDEV_LOGIN_TYPE_CLOUD_DEVICE_SN   = 4           /* 豸SN¼ */
}NETDEV_LOGIN_TYPE_E;

/**
*@brief Эö
*@attention 
*/
typedef enum tagNETDEVLoginProto
{
    NETDEV_LOGIN_PROTO_ONVIF             = 0,           /* ONVIFЭ */
    NETDEV_LOGIN_PROTO_PRIVATE           = 1            /* ˽Э */
}NETDEV_LOGIN_PROTO_E;


/**
* @brief 澯Э öٶ
 * @attention  None
 */
typedef enum tagNETDEVAlarmProtocol
{
    NETDEV_ALARM_PROTOCOL_ONVIF   = 0X01,                   /* ONVIF */
    NETDEV_ALARM_PROTOCOL_PRIVATE = 0X02,                   /* private */

    NETDEV_ALARM_PROTOCOL_INVALID = 0XFF                    /* Чֵ*/
}NETDEV_ALARM_PROTOCOL_E;

/**
* @brief ĸ澯¼BITλ öٶ
 * @attention  None
 */
typedef enum tagNETDEVSubscribeAlarmType
{
    NETDEV_SUBSCRIBE_ALARM_TYPE_COM             = 0X01,     /* ͨø澯 */
    NETDEV_SUBSCRIBE_ALARM_TYPE_SMART           = 0X02,     /* ܸ澯 */
    NETDEV_SUBSCRIBE_ALARM_TYPE_INTELLIGENTIPC  = 0X04      /* IPC */
}NETDEV_SUBSCRIBE_ALARM_TYPE_E;


/* طſ */
typedef enum tagNETDEVCtrlType
{
    NETDEV_CTRL_TYPE_SPEED = 1,                                     /* طű */ 
    NETDEV_CTRL_TYPE_INVALID
}NETDEV_XW_CTRL_TYPE_E;

/* LED */
typedef enum tagNETDEVLEDType
{
    NETDEV_LED_TYPE_STRING = 0                                   /* ַ */
}NETDEV_XW_LED_TYPE_E;

/* LED */
typedef enum tagNETDEVLEDFontFormat
{
    NETDEV_LED_FONT_SONG                    = 0,                            /*  */
    NETDEV_LED_FONT_FORMAT_SIMHEI           = 1,                            /*  */
    NETDEV_LED_FONT_FORMAT_KAITI            = 2,                            /*  */
    NETDEV_LED_FONT_FORMAT_Arial            = 3,                            /* Arial */
    NETDEV_LED_FONT_FORMAT_FANGSONG         = 4,                            /*  */
    NETDEV_LED_FONT_FORMAT_LISHU            = 5,                            /*  */
    NETDEV_LED_FONT_FORMAT_YOUYUAN          = 6                             /* Բ */
}NETDEV_XW_LED_FONT_FORMAT_E;
/* LEDС */
typedef enum tagNETDEVXWLEDFontSize
{
    NETDEV_LED_FONT_SIZE_48X48      = 0,                            /* 48X48 */
    NETDEV_LED_FONT_SIZE_64X64      = 1,                            /* 64X64 */
    NETDEV_LED_FONT_SIZE_96X96      = 2,                            /* 96X96 */
    NETDEV_LED_FONT_SIZE_128X128    = 3,                            /* 128X128 */
    NETDEV_LED_FONT_SIZE_192X192    = 4,                            /* 192X192 */
    NETDEV_LED_FONT_SIZE_256X256    = 5,                            /* 256X256 */
    NETDEV_LED_FONT_SIZE_512X512    = 6,                            /* 512X512 */
    NETDEV_FONT_SIZE_SELF_ADAPTION  = 7                             /* Ӧ */
}NETDEV_XW_LED_FONT_SIZE_E;

/* LEDּ һռ2ַ*/
typedef enum tagNETDEVXWLEDFontGap
{
    NETDEV_LED_FONT_GAP_NORMAL         = 0,         /*  */
    NETDEV_LED_FONT_GAP_ONE            = 1,         /* 2/4 */
    NETDEV_LED_FONT_GAP_TWO            = 2,         /* 4/4 */
    NETDEV_LED_FONT_GAP_THREE          = 3,         /* 6/4 */
    NETDEV_LED_FONT_GAP_FOUR           = 4,         /* 8/4 */
    NETDEV_LED_FONT_GAP_FIVE           = 5,         /* 1/4 */
    NETDEV_LED_FONT_GAP_SIX            = 6,         /* 3/4 */
    NETDEV_LED_FONT_GAP_SEVEN          = 7,         /* 5/4 */
    NETDEV_LED_FONT_GAP_EIGHT          = 8,         /* 7/4 */
    NETDEV_LED_FONT_GAP_NINE           = 9,         /* 10/4 */
    NETDEV_LED_FONT_GAP_INVALID        = 0xFF       /* Чֵ(Ӧ)  Invalid value */
}NETDEV_XW_LED_FONT_GAP_E;

/* ֹʽ */
typedef enum tagNETDEVLEDScrollingMode
{
    NETDEV_LED_SCROLL_STATIC            = 0,        /* ֹ */
    NETDEV_LED_SCROLL_RIGHT_TO_LEFT     = 1,        /* ҵ */
    NETDEV_LED_SCROLL_LEFT_TO_RIGHT     = 2,        /*  */
    NETDEV_LED_SCROLL_BOTTOM_TO_TOP     = 3,        /* µ */
    NETDEV_LED_SCROLL_TOP_TO_BOTTOM     = 4         /* ϵ */
}NETDEV_XW_LED_SCROLLING_MODE_E;

/* ֱִ뷽ʽ */
typedef enum tagNETDEVVerticalAlignMode
{
    NETDEV_VERTICAL_ALIGN_TOP           = 0,        /* ϶ */
    NETDEV_VERTICAL_ALIGN_MIDDLE        = 1,        /* ж */
    NETDEV_VERTICAL_ALIGN_BOTTOM        = 2         /* ¶*/
}NETDEV_XW_VERTICAL_ALIGN_MODE_E;

/* ˮƽ뷽ʽ */
typedef enum tagNETDEVHorizontalAlignMode
{
    NETDEV_HORIZONTAL_ALIGN_LEFT        = 0,        /*  */
    NETDEV_HORIZONTAL_ALIGN_MIDDLE      = 1,        /* ж */
    NETDEV_HORIZONTAL_ALIGN_RIGHT       = 2         /* Ҷ*/
}NETDEV_XW_HORIZONTAL_ALIGN_MODE_E;

/* λ */
typedef enum tagNETDEVContentPosition
{
    NETDEV_XW_CONTENT_POSITION_TOP           = 0,        /*  */
    NETDEV_XW_CONTENT_POSITION_MIDDLE        = 1,        /*  */
    NETDEV_XW_CONTENT_POSITION_BOTTOM        = 2         /* */
}NETDEV_XW_CONTENT_POSITION_E;

/* LED޸Ŀѡ */
typedef enum tagNETDEVLedCmd
{
    NETDEV_LED_ENABLE               = 0x0001,                   /* ģʽ udwEnable */
    NETDEV_LED_TYPE                 = 0x0002,                   /* LED dwType */
    NETDEV_LED_AREA                 = 0x0004,                   /* LEDλϢ stArea */
    NETDEV_LED_BACKGROUND           = 0x0008,                   /* ɫ stBackground */
    NETDEV_LED_FONTINFO             = 0x0010,                   /* Ϣ stFontInfo */
    NETDEV_LED_TEXT                 = 0x0020,                   /*  udwTestLineNum szText*/
    NETDEV_LED_ALL                  = 0x00FF                    /* ȫ all*/
} NETDEV_XW_LED_CMD_E;

/* ͼ */
typedef enum tagNETDEVBaseType
{
    NETDEV_BASE_TYPE_JPEG = 1                                    /* JPEG */
}NETDEV_XW_BASE_TYPE_E;

/* Э */
typedef enum tagNETDEVTransportProtocol
{
    NETDEV_TRANSPORT_PROTOCOL_UDP = 0,             /* UDP */
    NETDEV_TRANSPORT_PROTOCOL_TCP,                 /* TCP */
    NETDEV_TRANSPORT_PROTOCOL_RTSP,                /* RTSP */
    NETDEV_TRANSPORT_PROTOCOL_HTTP                 /* HTTP */
}NETDEV_TRANSPORT_PROTOCOL_E;

/**
* @brief Ѳ״̬ öٶ
* @attention  None
*/
typedef enum tagNETDEVXWSequenceResStatus
{
    NETDEV_XW_SEQUENCE_RES_STATUS_RUNNING   = 0,            /*  */
    NETDEV_XW_SEQUENCE_RES_STATUS_PAUSE     = 1,            /* ͣ */
    NETDEV_XW_SEQUENCE_RES_STATUS_STOP      = 2,            /* ֹͣ */

    NETDEV_XW_SEQUENCE_RES_STATUS_INVALID = 0xFF           /* Чֵ */
}NETDEV_XW_SEQUENCE_RES_STATUS_E;

/**
 * @brief ͼƬö
 * @attention  None
 */
typedef enum  tagNETDEVTMSPersionImageType
{
    NETDEV_TMS_PERSION_IMAGE_TYPE_FULL_VIEW = 1,         /* ȫͼ */
    NETDEV_TMS_PERSION_IMAGE_TYPE_FACE = 2,              /* ͼ */
    NETDEV_TMS_PERSION_IMAGE_TYPE_INVALID
}NETDEV_TMS_PERSION_IMAGE_TYPE_E;

/**
 * @brief ͼƬʽö
 * @attention  None
 */
typedef enum  tagNETDEVTMSPersionImageFormatType
{
    NETDEV_TMS_PERSION_IMAGE_FORMAT_JPG  = 1,            /* JPEG */
    NETDEV_TMS_PERSION_IMAGE_FORMAT_BMP  = 2,            /* BMP */
    NETDEV_TMS_PERSION_IMAGE_FORMAT_PNG  = 3,            /* PNG */
    NETDEV_TMS_PERSION_IMAGE_FORMAT_GIF  = 4,            /* GIF */
    NETDEV_TMS_PERSION_IMAGE_FORMAT_TIFF = 5,            /* TIFF */
    NETDEV_TMS_PERSION_IMAGE_FORMAT_INVALID
}NETDEV_TMS_PERSION_IMAGE_FORMAT_E;

/**
 * @brief Ʒʽ
 * @attention
 */
typedef enum tagNETDEVXWScreenCtrlType
{
    NETDEV_XW_SCREEN_CTRL_TYPE_TCP              = 0,          /* TCP */
    NETDEV_XW_SCREEN_CTRL_TYPE_UDP              = 1,          /* UDP */
    NETDEV_XW_SCREEN_CTRL_TYPE_COM              = 2,          /*  */

    NETDEV_XW_SCREEN_CTRL_TYPE_INVALID          = 0xFF        /* Чֵ */
}NETDEV_XW_SCREEN_CTRL_TYPE_E;

/**
 * @brief Э
 * @attention
 */
typedef enum tagNETDEVXWScreenCtrlProtocolType
{
    NETDEV_XW_SCREEN_CTRL_PROT_LCD          = 0,          /* LCD˽Э */
    NETDEV_XW_SCREEN_CTRL_PROT_LED          = 1,          /* LED˽Э */
    NETDEV_XW_SCREEN_CTRL_PROT_MODBUS       = 2,          /* MODBUS */

    NETDEV_XW_SCREEN_CTRL_PROT_INVALID      = 0xFF        /* Чֵ */
}NETDEV_XW_SCREEN_CTRL_PROTOCOL_TYPE_E;

/**
 * @brief ĻŴ
 * @attention
 */
typedef enum tagNETDEVXWScreenZoomdType
{
    NETDEV_XW_SCREEN_ZOOM_TYPE_PANE           = 0,           /*Ŵ*/
    NETDEV_XW_SCREEN_ZOOM_TYPE_WIN            = 1,           /*ڷŴ*/

    NETDEV_XW_SCREEN_ZOOM_TYPE_INVALID        = 0xFF         /* Чֵ */
}NETDEV_XW_SCREEN_ZOOM_TYPE_E;

/**
 * @brief ĻŴģʽ
 * @attention
 */
typedef enum tagNETDEVXWScreenZoomdMode
{
    NETDEV_XW_SCREEN_ZOOM_MODE_OFF             = 0,          /*ָ*/
    NETDEV_XW_SCREEN_ZOOM_MODE_ON              = 1,          /*Ŵ*/

    NETDEV_XW_SCREEN_ZOOM_MODE_INVALID         = 0xFF        /* Чֵ */
}NETDEV_XW_SCREEN_ZOOM_MODE_E;

/*  */
typedef enum tagNETDEVPaneCap
{
    NETDEV_PANE_UNSUPPORT   = 0,        /* ֧ */
    NETDEV_PANE_SAME_WND    = 1,        /* ֵ֧ͬС&λõĴڷ */
    NETDEV_PANE_ANY_WND     = 2,        /* ֧ⴰڵķ */

    NETDEV_PANE_INVALID     = 0xFF      /* Чֵ */
}NETDEV_XW_PANE_CAP_E;

/*  */
typedef enum tagNETDEVRoamingCap
{
    NETDEV_ROAMING_UNSUPPORT    = 0,        /* ֧ */
    NETDEV_ROAMING_SINGLE_WND   = 1,        /* ֵ֧ */
    NETDEV_ROAMING_PANE_WND     = 2,        /* ֶ֧ */

    NETDEV_ROAMING_INVALID      = 0xFF      /* Чֵ */
}NETDEV_XW_ROAMING_CAP_E;

/*  */
typedef enum tagNETDEVWndCap
{
    NETDEV_WINDOWS_UNSUPPORT    = 0,        /* ֧ */
    NETDEV_WINDOWS_SINGLE_WND   = 1,        /* ֵ֧ͬС&λõĴ */
    NETDEV_WINDOWS_MULTI_WND    = 2,        /* ֿ֧ڿ */
    NETDEV_WINDOWS_ANY_WND      = 3,        /* ⿪ */
    NETDEV_WINDOWS_INVALID      =0xff       /* Чֵ */
}NETDEV_XW_WND_CAP_E;

typedef enum tagNETDEVXWSceneModifyType
{
    NETDEV_XW_SCENE_MODIFY_TYPE_NAME        = 0,            /* ޸ĳ modify scene name */
    NETDEV_XW_SCENE_MODIFY_TYPE_SAVE_AS     = 1,            /* һϢ浽һ,Ϊǰ scene Saved as */

    NETDEV_XW_SCENE_MODIFY_TYPE_INVALID     = 0xff          /* Чֵ */
}NETDEV_XW_SCENE_MODIFY_TYPE_E;

/* ڼ */
typedef enum tagNETDEVWeekInfo
{
    NETDEV_LAPI_WEEK_MONDAY                  = 1,                  /* һ  Monday */
    NETDEV_LAPI_WEEK_TUESDAY                 = 2,                  /* ڶ  Tuesday */
    NETDEV_LAPI_WEEK_WEDNESDAY               = 3,                  /*   Wednesday */
    NETDEV_LAPI_WEEK_THURSDAY                = 4,                  /*   Thursday */
    NETDEV_LAPI_WEEK_FRIDAY                  = 5,                  /*   Friday */
    NETDEV_LAPI_WEEK_SATURDAY                = 6,                  /*   Saturday */
    NETDEV_LAPI_WEEK_SUNDAY                  = 7,                  /*   Sunday */
    NETDEV_LAPI_WEEK_HOLIDAY                 = 8,                  /*  Holiday */
    NETDEV_LAPI_WEEK_INVALID                 = 0xff                  /* Чֵ */
}NETDEV_LAPI_WEEK_INFO_E;

/* ޸Ŀѡ */
typedef enum tagNETDEVWndCommond
{
    NETDEV_WND_PANE_MOD         = 0x0001,       /* ģʽ udwPaneMod */
    NETDEV_WND_LAYER            = 0x0002,       /* ͼ udwLayer */
    NETDEV_WND_TRANSPARENCY     = 0x0004,       /* ͸ udwTransparency */
    NETDEV_WND_AREA             = 0x0008,       /* λϢ stArea */
    NETDEV_WND_NAME             = 0x0010,       /*  name */
    NETDEV_WND_STATUS           = 0x0020,       /* Ƿ */
    NETDEV_WND_WND_TYPE         = 0x0040,       /*  */
    NETDEV_WND_DC_CHI_ID        = 0x0080,       /* DCͨID */
    NETDEV_WND_ZOOM_TYPE        = 0x0100,       /* Ŵ */
    NETDEV_WND_SPLIT_INDEX      = 0x0200,       /*  */
    NETDEV_WND_SCHEME_RES_ID    = 0x0400,       /* ѲԴ */
    NETDEV_WND_SEQ_STATUS       = 0x0800,       /* Ѳ״̬μ */
    NETDEV_WND_PANE_INFO_NUM    = 0x1000,       /*  */
    NETDEV_WND_SCALE_STATUS     = 0x2000,       /* ״̬ */
    NETDEV_WND_ALL              = 0xFFFF        /* ȫ all */
} NETDEV_XW_WND_CMD_E;

/* ڷŴ */
typedef enum tagNETDEVZoomType
{
    NETDEV_XW_ZOOM_TYPE_NO          = 0x00,     /* ûŴ NO enlarge */
    NETDEV_XW_ZOOM_TYPE_SPLIT       = 0x01,     /* Ŵ split enlarge */
    NETDEV_XW_ZOOM_TYPE_WND         = 0x02,     /* ڷŴ window enlarge */
    NETDEV_XW_ZOOM_TYPE_INVALID     = 0xFF      /* Чֵ invalid vule */
}NETDEV_XW_ZOOM_TYPE_E;


/* ʽ */
typedef enum tagNETDEVVideoEncoding
{
    NETDEV_VIDEOENCODING_H264 = 0,
    NETDEV_VIDEOENCODING_H265 = 1,
    NETDEV_VIDEOENCODING_MPEG4 = 2,
    NETDEV_VIDEOENCODING_MPEG2 = 3,
    NETDEV_VIDEOENCODING_MJPEG = 4
}NETDEV_XW_VIDEOENCODING_E;

/**/
typedef enum tagNetDevAuthModel
{
    NETDEV_AUTH_MODEL_RSA_10       = 0,    /* RSA EԿ10*/
    NETDEV_AUTH_MODEL_PRI          = 1,    /* ַͨ */
    NETDEV_AUTH_MODEL_RSA_16       = 2     /* RSAܣEԿ16 */
}NETDEV_AUTH_MODEL_E;

/**
* @brief Э öٶ
* @attention  None
*/
typedef enum tagNETDEVTransProtocol
{
    NETDEV_TRANS_PROTOCOL_TCP = 0,              /* TCP */
    NETDEV_TRANS_PROTOCOL_UDP = 1             /* UDP */
}NETDEV_TRANS_PROTOCOL_E;

/**
 * @brief  
 * @attention
 */
typedef enum tagNETDEVDecodeType
{
    NETDEV_DECODE_TYPE_CLIENT = 0,      /* Ϊͻ  */
    NETDEV_DECODE_TYPE_SERVER = 1       /* Ϊ  */
    
}NETDEV_XW_DECODE_TYPE_E;

/* ʵҵ */
typedef enum tagNETDEVRealPlayType
{
    NETDEV_TYPE_NORMAL  = 0,        /* Ĭͨʵ */
    NETDEV_TYPE_ALARM   = 1,        /* 澯ʵ */
    NETDEV_TYPE_LOCAL   = 2         /* ʵ */
}NETDEV_XW_REALPLAY_TYPE_E;

 /**
 * @brief Ƶͨ˿ö öٶ
 * @attention  None
 */
typedef enum tagNETDEVAudioPortType
{
    NETDEV_AUDIO_PORT_SINGLE            = 0,                /*  */
    NETDEV_AUDIO_PORT_DOUBLE            = 1,                /* ˫ */
    NETDEV_AUDIO_PORT_INVALID           = 0xff               /* Чֵ */
}NETDEV_AUDIO_PORT_TYPE_E;

/**
 * @brief Ƶ˿ö öٶ
 * @attention  None
 */
typedef enum tagNETDEVVideoPortType
{
    NETDEV_VIDEO_PORT_BNC            = 0,                /* ˿ BNC */
    NETDEV_VIDEO_PORT_VGA            = 1,                /* ˿ VGA */
    NETDEV_VIDEO_PORT_HDMI           = 2,                /* ˿ HDMI */
    NETDEV_VIDEO_PORT_DVI_D          = 3,                /* ˿ DVI_D */
    NETDEV_VIDEO_PORT_DVI_I          = 4,                /* ˿ DVI_D */
    NETDEV_VIDEO_PORT_DP             = 5,                /* ˿ DVI_D */
    NETDEV_VIDEO_PORT_SDI            = 6,                /* ˿ DVI_D */
    NETDEV_VIDEO_PORT_RJ45           = 7,                /* ˿ RJ45 */
    NETDEV_VIDEO_PORT_INVALID        = 0xff               /* Чֵ */
}NETDEV_VIDEO_PORT_TYPE_E;

/**
* @brief ֱ Ļʽ
* @attention DC&&XWö
*/
typedef enum tagNETDEVXWLayoutNum
{
    NETDEV_XW_LAYOUT_TYPE__SELF_ADAPT    = 0,                  /* Ӧ */
    NETDEV_XW_LAYOUT_TYPE_01             = 100,                /* 1 */
    NETDEV_XW_LAYOUT_TYPE_02             = 200,                /* 2 */
    NETDEV_XW_LAYOUT_TYPE_03             = 300,                /* 3 */
    NETDEV_XW_LAYOUT_TYPE_03_1           = 301,                /* 3 21*/
    NETDEV_XW_LAYOUT_TYPE_04             = 400,                /* 4 */
    NETDEV_XW_LAYOUT_TYPE_04_1           = 401,                /* 41+1+2 */
    NETDEV_XW_LAYOUT_TYPE_05             = 500,                /* 51+3+1 */
    NETDEV_XW_LAYOUT_TYPE_05_1           = 501,                /* 51+1+3 */
    NETDEV_XW_LAYOUT_TYPE_05_2           = 502,                /* 51+3+1 ˳ͬ500 */
    NETDEV_XW_LAYOUT_TYPE_05_3           = 503,                /* 51+1+3 ˳ͬ501 */
    NETDEV_XW_LAYOUT_TYPE_05_4           = 504,                /* 53+1+1*/
    NETDEV_XW_LAYOUT_TYPE_05_5           = 505,                /* 51+4*/
    NETDEV_XW_LAYOUT_TYPE_06             = 600,                /* 61+5 */
    NETDEV_XW_LAYOUT_TYPE_07             = 700,                /* 71+6 */
    NETDEV_XW_LAYOUT_TYPE_07_1           = 701,                /* 73+1+3 */
    NETDEV_XW_LAYOUT_TYPE_07_2           = 702,                /* 73+1+3(3Ϊ21) */
    NETDEV_XW_LAYOUT_TYPE_08             = 800,                /* 81+7 */
    NETDEV_XW_LAYOUT_TYPE_09             = 900,                /* 9 */
    NETDEV_XW_LAYOUT_TYPE_10             = 1000,               /* 101+9 */
    NETDEV_XW_LAYOUT_TYPE_10_1           = 1001,               /* 102+8 */
    NETDEV_XW_LAYOUT_TYPE_13             = 1300,               /* 131+12 */
    NETDEV_XW_LAYOUT_TYPE_13_1           = 1301,               /* 131+12 ˳ͬ1300 */
    NETDEV_XW_LAYOUT_TYPE_16             = 1600,               /* 16 */
    NETDEV_XW_LAYOUT_TYPE_17             = 1700,               /* 171+16 */
    NETDEV_XW_LAYOUT_TYPE_25             = 2500,               /* 25 */
    NETDEV_XW_LAYOUT_TYPE_32             = 3200,               /* 323+1+28 */
    NETDEV_XW_LAYOUT_TYPE_36             = 3600,               /* 36 */
    NETDEV_XW_LAYOUT_TYPE_64             = 6400,               /* 64 */
    NETDEV_XW_LAYOUT_TYPE_10001          = 10001,              /* Զһ */
    NETDEV_XW_LAYOUT_TYPE_10002          = 10002,              /* Զ */
    NETDEV_XW_LAYOUT_TYPE_10003          = 10003,              /* Զ */
    NETDEV_XW_LAYOUT_TYPE_10004          = 10004,              /* Զ */
    NETDEV_XW_LAYOUT_TYPE_10005          = 10005,              /* Զ */
    NETDEV_XW_LAYOUT_TYPE_10006          = 10006,              /* Զ */
    NETDEV_XW_LAYOUT_TYPE_10007          = 10007,              /* Զ */
    NETDEV_XW_LAYOUT_TYPE_10008          = 10008,              /* Զ */

    NETDEV_XW_LAYOUT_TYPE_INVALID  = 0xffff
}NETDEV_XW_LAYOUT_NUM_E;

/**
* @brief ֱ Ļʽ
* @attention DC&&XWö
*/
typedef enum tagNETDEVVideoFormat
{
    NETDEV_VIDEO_FORMAT_720P24          = 2,            /* 1280x720@24 */
    NETDEV_VIDEO_FORMAT_720P25          = 3,            /* 1280x720@25 */
    NETDEV_VIDEO_FORMAT_720P30          = 4,            /* 1280x720@30 */
    NETDEV_VIDEO_FORMAT_720P50          = 5,            /* 1280x720@50 */
    NETDEV_VIDEO_FORMAT_720P60          = 6,            /* 1280x720@60 */
    NETDEV_VIDEO_FORMAT_1080P24         = 10,           /* 1920x1080@24 */
    NETDEV_VIDEO_FORMAT_1080P25         = 11,           /* 1920x1080@25 */
    NETDEV_VIDEO_FORMAT_1080P30         = 12,           /* 1920x1080@30 */
    NETDEV_VIDEO_FORMAT_1080P50         = 13,           /* 1920x1080@50 */
    NETDEV_VIDEO_FORMAT_1080P60         = 14,           /* 1920x1080@60 */
    NETDEV_VIDEO_FORMAT_XGA60           = 15,           /* 1024x768@60 */
    NETDEV_VIDEO_FORMAT_SXGA60          = 16,           /* 1280x1024@60 */
    NETDEV_VIDEO_FORMAT_UXGA60          = 17,           /* 1600x1200@60 */
    NETDEV_VIDEO_FORMAT_SXGAP60HZ       = 18,           
    NETDEV_VIDEO_FORMAT_WXGAP60HZ       = 19,           /* 1366x768@60 */
    NETDEV_VIDEO_FORMAT_WSXGA60HZ       = 20,           /* 1440x900@60 */
    NETDEV_VIDEO_FORMAT_4K30            = 21,           /* 3840x2160@30 */
    NETDEV_VIDEO_FORMAT_4K60            = 22,           /* 3840x2160@60 */
    NETDEV_VIDEO_FORMAT_MUXGA60HZ       = 23,           /* 1920x1200@60 */
    NETDEV_VIDEO_FORMAT_INVALID         = 0xFF
}NETDEV_VIDEO_FORMAT_E;

/**
* @brief  öٶ
* @attention  None
*/
typedef enum tagNETDEVStreamType
{
    NETDEV_STREAM_TYPE_RTP_UNICAST = 0,         /*  */
    NETDEV_STREAM_TYPE_RTP_MULTICAST = 1,        /* 鲥 */

    NETDEV_STREAM_TYPE_RTP_INVALID         = 0xFF
}NETDEV_STREAM_TYPE_E;

typedef enum tagNETDEVAlarmSnapShotType
{
    NETDEV_ALARM_SNAPSHOT_MOTION_DETECT                     = 0,            /* ƶ澯 */
    NETDEV_ALARM_SNAPSHOT_VIDEO_LOST                        = 1,            /* Ƶʧ澯 */
    NETDEV_ALARM_SNAPSHOT_AUDIO_DETECTION                   = 2,            /* 澯 */
    NETDEV_ALARM_SNAPSHOT_INPUT_SWITCH                      = 3,            /* 澯 */
    NETDEV_ALARM_SNAPSHOT_IPC_OFFLINE                       = 4,            /* IPC */
    NETDEV_ALARM_SNAPSHOT_TAMPER_DETECT                     = 5,            /* ڵ */

    NETDEV_ALARM_SNAPSHOT_CROSS_LINE                        = 6,            /* Խ⣬һ֧ */
    NETDEV_ALARM_SNAPSHOT_INTROSION_ZONE                    = 7,            /* ֣һ֧ */
    NETDEV_ALARM_SNAPSHOT_FACE_DETECT                       = 8,            /* ⣬һ֧ */
    NETDEV_ALARM_SNAPSHOT_SCENCECHANGE                      = 9,            /* һ֧ */
    NETDEV_ALARM_SNAPSHOT_OUT_FOCUS                         = 10,           /* 齹⣬һ֧ */
    NETDEV_ALARM_SNAPSHOT_FACE_MATCH                        = 11,           /* ʶƥ澯һ֧ */
    NETDEV_ALARM_SNAPSHOT_FACE_NOT_MATCH                    = 12,           /* ʶƥ䱨һ֧ */
    NETDEV_ALARM_SNAPSHOT_GATHER                            = 13,           /* Աۼһ֧ */
    NETDEV_ALARM_SNAPSHOT_REMAIN_ARTICLE                    = 14,           /* Ʒһ֧ */
    NETDEV_ALARM_SNAPSHOT_SMART_TRACK                       = 15,           /* ܸ٣һ֧ */
    NETDEV_ALARM_SNAPSHOT_LOITERING_DETECTOR                = 16,           /* ǻ⣬һ֧ */
    NETDEV_ALARM_SNAPSHOT_VEHICLE_MATCH                     = 17,           /* ʶƥ䱨һ֧ */
    NETDEV_ALARM_SNAPSHOT_VEHICLE_NOT_MATCH                 = 18,           /* ʶƥ䱨һ֧ */
    NETDEV_ALARM_SNAPSHOT_ENTER_AREA                        = 19,           /* 򣬽һ֧ */
    NETDEV_ALARM_SNAPSHOT_LEAVE_AREA                        = 20,           /* 뿪򣬽һ֧ */
    NETDEV_ALARM_SNAPSHOT_ARTICLE_MOVE                      = 21,           /* Ʒƣһ֧ */
    NETDEV_ALARM_SNAPSHOT_DURESS                            = 22,           /* Юֱһ֧ */
    NETDEV_ALARM_SNAPSHOT_ANRIDISASSEMBLY                   = 23,           /* 𱨾һ֧ */
    NETDEV_ALARM_SNAPSHOT_ANRIDISASSEMBLY_RECOVER           = 24,           /* 𱨾ָһ֧ */
    NETDEV_ALARM_SNAPSHOT_BYPASS_OPERATION                  = 25,           /* ·һ֧ */
    NETDEV_ALARM_SNAPSHOT_CF_BJ_EMBNAM_ZONE                 = 26,           /* 걨ģ.һ֧ */
    NETDEV_ALARM_SNAPSHOT_CONFLAGRATION                     = 27,           /* 澯 */

    NETDEV_ALARM_SNAPSHOT_INVALID                        = 0xFFFF        /* Чֵ  Invalid value */
}NETDEV_ALARM_SNAPSHOT_TYPE_E;

/**
* @brief ǰԤ¼ʱöٶ          PreRecordTime Enumeration definition
* @attention 
*/
typedef enum tagNETDEVPreRecordTime
{
    NETDEV_PRE_RECORD_TIME_ZERO =  0,            /* 0 */
    NETDEV_PRE_RECORD_TIME_FIVE =  5,            /* 5 */
    NETDEV_PRE_RECORD_TIME_TEN =   10,           /* 10 */
    NETDEV_PRE_RECORD_TIME_TWENTY =20,           /* 20 */
    NETDEV_PRE_RECORD_TIME_THIRTY =30,           /* 30 */
    NETDEV_PRE_RECORD_TIME_SIXTY = 60            /* 60 */
}NETDEV_PRE_RECORD_TIME_E;

/**
* @brief Ԥ¼ʱöٶ          PostRecordTime Enumeration definition
* @attention 
*/
typedef enum tagNETDEVPostRecordTime
{
    NETDEV_POST_RECORD_TIME_FIVE =                   5,             /* 5 */
    NETDEV_POST_RECORD_TIME_TEN =                    10,            /* 10 */
    NETDEV_POST_RECORD_TIME_THIRTY =                 30,            /* 30 */
    NETDEV_POST_RECORD_TIME_SIXTY =                  60,            /* 60 */
    NETDEV_POST_RECORD_TIME_ONE_HUNDRED_AND_TWENTY = 120,           /* 120 */
    NETDEV_POST_RECORD_TIME_THREE_HUNDRED =          300,           /* 300 */
    NETDEV_POST_RECORD_TIME_SIX_HUNDRED =            600            /* 600 */
}NETDEV_POST_RECORD_TIME_E;

/**
* @brief ƻʹ öٶ          Defence Plan Enable Enumeration definition
* @attention  None
*/
typedef enum tagNETDEVDefencePlanEnable
{
    NETDEV_DEFENCE_PLAN_DISABLE     = 0,        /* ʹ */
    NETDEV_DEFENCE_PLAN_ENABLE      =  1        /* ʹ */
}NETDEV_DEFENCE_PLAN_ENABLE_E;

/**
* @brief 澯öٶ          Alarm And Defence Type Enumeration definition
* @attention 澯ֶֻ֧ʱͣ¼/ץͼƻȫ֧֣IPCֶֻ֧ʱҪֶΣĬǶʱ
*/
typedef enum tagNETDEVArmingType
{
    NETDEV_ARMING_TYPE_TIMING                   = 0,        /* ʱ */
    NETDEV_ARMING_TYPE_MOTIONDETEC              = 1,        /*  */
    NETDEV_ARMING_TYPE_ALARM                    = 2,        /*  */
    NETDEV_ARMING_TYPE_MOTIONDETEC_AND_ALARM    = 3,        /* ͱ */
    NETDEV_ARMING_TYPE_MOTIONDETEC_OR_ALARM     = 4,        /* 򱨾 */
    NETDEV_ARMING_TYPE_NO_PLAN                  = 5,        /* ޼ƻ */
    NETDEV_ARMING_TYPE_EVENT                    = 10        /* ¼ */
}NETDEV_ARMING_TYPE_E;



/**
*@brief ö
*@attention 
*/
typedef enum tagNETDEVStreamProtocol
{
    NETDEV_STREAM_PRO_RTMP         = 1,          /* RTP */
    NETDEV_STREAM_PRO_HLS          = 2,          /* HLS */
    NETDEV_STREAM_PRO_FLV          = 3           /* FLV */
}NETDEV_CLOUD_STREAM_PROTOCAL_E;

/**
*@brief ַģʽö
*@attention 
*/
typedef enum tagNETDEVDistributeCloud
{
    NETDEV_DISTRIBUTE_CLOUD_NONE      = 0,            /* ÷ַ */
    NETDEV_DISTRIBUTE_CLOUD_KS        = 1,            /* ýɽƷַ */
    NETDEV_DISTRIBUTE_CLOUD_UN        = 2,            /* Ʒַ */
    NETDEV_DISTRIBUTE_CLOUD_TEN       = 3            /* ѶƷַ */
}NETDEV_DISTRIBUTE_CLOUD_SRV_E;

/**
*@brief ģʽö
*@attention 
*/
typedef enum tagNETDevNetWorkMode
{
    NETDEV_NETMODE_LAN          = 0,        /* LAN ģʽ,ڱؼ˿ӳ */
    NETDEV_NETMODE_WAN          = 1,        /* WAN ģʽ,ڵNAT */
    NETDEV_NETMODE_MULTINAT     = 2,        /* NATģʽ,ڴ򶴴 תʹδ֣*/
    NETDEV_NETMODE_P2P          = 3,        /* NATģʽ,ڴ򶴴 */
    NETDEV_NETMODE_TURN         = 4         /* NATģʽ,ת */

}NETDEV_NETWORK_MODE_E;


/**
 * @enum tagNETDEVReportType
 * @brief 澯/¼ϱ
 * @attention  None
 */
typedef enum tagNETDEVReportType
{
    NETDEV_REPORT_TYPE_ALARM            = 0,                /* ϱͣ澯 */
    NETDEV_REPORT_TYPE_EVENT            = 1,                /* ϱͣ¼ */

    NETDEV_REPORT_TYPE_INVALID          = 0xFF              /* Чֵ */
}NETDEV_REPORT_TYPE_E;


/**
* @enum tagNETDEVAlarmSubType
* @brief 澯
* @attention 
*/
typedef enum tagNETDEVAlarmSubType
{
    NETDEV_ALARM_SUB_TYPE_NOT_CONFIGURED       = 0,                                         /*δñ*/

    NETDEV_DEV_TYPE_BASE                       = (100000UL),                                /*  */
    NETDEV_DEV_TROUBLE                         = (NETDEV_DEV_TYPE_BASE + 1),                /* 豸 */
    NETDEV_DEV_ALARM_EMERGENCY                 = (NETDEV_DEV_TYPE_BASE + 2),                /*  */

    /* 豸Ͷ */
    NETDEV_ALARM_EVENT_BASE                    = (100200UL),                                /* Ͷʼλ */
    NETDEV_ALARM_EVENT_FIRE_ALARM              = (NETDEV_ALARM_EVENT_BASE + 1),             /*  */
    NETDEV_ALARM_EVENT_KEYPADFIRE              = (NETDEV_ALARM_EVENT_BASE + 2),             /* ̻𾯱 */
    NETDEV_ALARM_EVENT_KEYPADEMERGENCY         = (NETDEV_ALARM_EVENT_BASE + 3),             /* ̽ */
    NETDEV_ALARM_EVENT_KEYPADMEDICAL           = (NETDEV_ALARM_EVENT_BASE + 4),             /*  */
    NETDEV_ALARM_EVENT_DURESSCODEUSED          = (NETDEV_ALARM_EVENT_BASE + 5),             /* в */
    NETDEV_ALARM_EVENT_UNAUTHORIZEDENTRY       = (NETDEV_ALARM_EVENT_BASE + 6),             /* δȨ */
    NETDEV_ALARM_EVENT_BURGLARPOINTALARM       = (NETDEV_ALARM_EVENT_BASE + 7),             /*  */
    NETDEV_ALARM_EVENT_SUPERVISORY             = (NETDEV_ALARM_EVENT_BASE + 8),             /*  */
    NETDEV_ALARM_EVENT_FIRETROUBLE             = (NETDEV_ALARM_EVENT_BASE + 9),             /* 𾯹 */
    NETDEV_ALARM_EVENT_FIREPOINTTROUBLE        = (NETDEV_ALARM_EVENT_BASE + 10),            /* 𾯷 */
    NETDEV_ALARM_EVENT_BURGLARPOINTTROUBLE     = (NETDEV_ALARM_EVENT_BASE + 11),            /*  */
    NETDEV_ALARM_EVENT_CANCELALARM             = (NETDEV_ALARM_EVENT_BASE + 12),            /*  */
    NETDEV_ALARM_EVENT_DISARM                  = (NETDEV_ALARM_EVENT_BASE + 13),            /* ɹ */
    NETDEV_ALARM_EVENT_ARM                     = (NETDEV_ALARM_EVENT_BASE + 14),            /* ɹ */
    NETDEV_ALARM_EVENT_FORCEDBYPASS            = (NETDEV_ALARM_EVENT_BASE + 15),            /* ǿ· */
    NETDEV_ALARM_EVENT_BYPASS                  = (NETDEV_ALARM_EVENT_BASE + 16),            /* · */
    NETDEV_ALARM_EVENT_POINTRESTORAL           = (NETDEV_ALARM_EVENT_BASE + 17),            /* ָ */
    NETDEV_ALARM_EVENT_FAILTOCLOSE             = (NETDEV_ALARM_EVENT_BASE + 18),            /* ʧ */
    NETDEV_ALARM_EVENT_FAILTOOPEN              = (NETDEV_ALARM_EVENT_BASE + 19),            /* ʧ */
    NETDEV_ALARM_EVENT_HISTORYBUFFERDUMP       = (NETDEV_ALARM_EVENT_BASE + 20),            /* ¼¼ */
    NETDEV_ALARM_EVENT_TESTMSG                 = (NETDEV_ALARM_EVENT_BASE + 21),            /*  */
    NETDEV_ALARM_EVENT_ZONETROUBLE             = (NETDEV_ALARM_EVENT_BASE + 22),            /*  */
    NETDEV_ALARM_EVENT_ZONETROUBLERESTORE      = (NETDEV_ALARM_EVENT_BASE + 23),            /* ϻָ */
    NETDEV_ALARM_EVENT_ZONESHORT               = (NETDEV_ALARM_EVENT_BASE + 24),            /* · */
    NETDEV_ALARM_EVENT_ZONEOPEN                = (NETDEV_ALARM_EVENT_BASE + 25),            /* · */
    NETDEV_ALARM_EVENT_ZONENORMAL              = (NETDEV_ALARM_EVENT_BASE + 26),            /*  */
    NETDEV_ALARM_EVENT_MXDEVCLOSE              = (NETDEV_ALARM_EVENT_BASE + 27),            /* MX豸 */
    NETDEV_ALARM_EVENT_MXDEVOPEN               = (NETDEV_ALARM_EVENT_BASE + 28),            /* MX豸 */
    NETDEV_ALARM_EVENT_MXDEV1ZONEALARM         = (NETDEV_ALARM_EVENT_BASE + 29),            /* MX豸1 */
    NETDEV_ALARM_EVENT_MXDEV2ZONEALARM         = (NETDEV_ALARM_EVENT_BASE + 30),            /* MX豸2 */
    NETDEV_ALARM_EVENT_MXDEV3ZONEALARM         = (NETDEV_ALARM_EVENT_BASE + 31),            /* MX豸3 */
    NETDEV_ALARM_EVENT_MXDEV1ZONERESTAORE      = (NETDEV_ALARM_EVENT_BASE + 32),            /* MX豸1ָ */
    NETDEV_ALARM_EVENT_MXDEV2ZONERESTAORE      = (NETDEV_ALARM_EVENT_BASE + 33),            /* MX豸2ָ */
    NETDEV_ALARM_EVENT_MXDEV3ZONERESTAORE      = (NETDEV_ALARM_EVENT_BASE + 34),            /* MX豸3ָ */
    NETDEV_ALARM_EVENT_TROUBLE_AC              = (NETDEV_ALARM_EVENT_BASE + 35),            /* Դ */
    NETDEV_ALARM_EVENT_TROUBLE_BATTERY         = (NETDEV_ALARM_EVENT_BASE + 36),            /* õԴ */
    NETDEV_ALARM_EVENT_TROUBLE_SNDREPORT       = (NETDEV_ALARM_EVENT_BASE + 37),            /* 淢͹ */
    NETDEV_ALARM_EVENT_TROUBLE_CONTROL         = (NETDEV_ALARM_EVENT_BASE + 38),            /* ƹ */
    NETDEV_ALARM_EVENT_TROUBLE_MXBUS           = (NETDEV_ALARM_EVENT_BASE + 39),            /* MPX߹ */
    NETDEV_ALARM_EVENT_TROUBLE_RADIOSND        = (NETDEV_ALARM_EVENT_BASE + 40),            /* ߽չ */
    NETDEV_ALARM_EVENT_TROUBLE_ASSISTPOWER     = (NETDEV_ALARM_EVENT_BASE + 41),            /* Դ */
    NETDEV_ALARM_EVENT_TROUBLE_OPTION          = (NETDEV_ALARM_EVENT_BASE + 42),            /* option豸 */
    NETDEV_ALARM_EVENT_LINK_BREAK              = (NETDEV_ALARM_EVENT_BASE + 43),            /* Ͽ */
    NETDEV_ALARM_EVENT_LINK_RESUME             = (NETDEV_ALARM_EVENT_BASE + 44),            /*  */
    NETDEV_ALARM_EVENT_VOLTAGE_ALARM           = (NETDEV_ALARM_EVENT_BASE + 45),            /* ֱǷѹ */
    NETDEV_ALARM_EVENT_EXTERNDEV_TROUBLE       = (NETDEV_ALARM_EVENT_BASE + 46),            /* չ豸ϱ */
    NETDEV_ALARM_EVENT_EXTERNDEV_RESUME        = (NETDEV_ALARM_EVENT_BASE + 47),            /* չ豸ָ */
    NETDEV_ALARM_EVENT_POINT_DISARM            = (NETDEV_ALARM_EVENT_BASE + 48),            /* λ */
    NETDEV_ALARM_EVENT_POINT_ARM               = (NETDEV_ALARM_EVENT_BASE + 49),            /* λ */
    NETDEV_ALARM_EVENT_FORCE_OPEN              = (NETDEV_ALARM_EVENT_BASE + 50),            /* ǿƴ */
    NETDEV_ALARM_EVENT_BYPASS_FAILED           = (NETDEV_ALARM_EVENT_BASE + 51),            /* ·ʧ */
    NETDEV_ALARM_EVENT_RESET_FAILED            = (NETDEV_ALARM_EVENT_BASE + 52),            /* λʧ */
    NETDEV_ALARM_EVENT_POINT_FIRETROUBLE       = (NETDEV_ALARM_EVENT_BASE + 53),            /* λ */
    NETDEV_ALARM_EVENT_POINT_SEPARATE          = (NETDEV_ALARM_EVENT_BASE + 54),            /* λ */
    NETDEV_ALARM_EVENT_POINT_ACTION            = (NETDEV_ALARM_EVENT_BASE + 55),            /* λ */
    NETDEV_ALARM_EVENT_POINT_RESUME            = (NETDEV_ALARM_EVENT_BASE + 56),            /* λָ */
    NETDEV_ALARM_EVENT_ROB_ACTION              = (NETDEV_ALARM_EVENT_BASE + 57),            /* پ */

    /* ¼ */
    NETDEV_ALARM_EVENT_MISSED_ARM              = (NETDEV_ALARM_EVENT_BASE + 60),            /* ûв */
    NETDEV_ALARM_EVENT_MISSED_DISARM           = (NETDEV_ALARM_EVENT_BASE + 61),            /* ûг */
    NETDEV_ALARM_EVENT_AUXILARY_RST            = (NETDEV_ALARM_EVENT_BASE + 62),            /* ָ */
    NETDEV_ALARM_EVENT_AUXILARY                = (NETDEV_ALARM_EVENT_BASE + 63),            /*  */
    NETDEV_ALARM_EVENT_BURGLARY_RST            = (NETDEV_ALARM_EVENT_BASE + 64),            /* Ծָ */
    NETDEV_ALARM_EVENT_BURGLARY                = (NETDEV_ALARM_EVENT_BASE + 65),            /* Ծ */
    NETDEV_ALARM_EVENT_BYPASS_RST              = (NETDEV_ALARM_EVENT_BASE + 66),            /* ·ָ */
    NETDEV_ALARM_EVENT_CANCEL                  = (NETDEV_ALARM_EVENT_BASE + 67),            /* ȡ */
    NETDEV_ALARM_EVENT_DUPLICATE               = (NETDEV_ALARM_EVENT_BASE + 68),            /* ظ */
    NETDEV_ALARM_EVENT_DURESS_RST              = (NETDEV_ALARM_EVENT_BASE + 69),            /* Юֱָ */
    NETDEV_ALARM_EVENT_DURESS                  = (NETDEV_ALARM_EVENT_BASE + 70),            /* Юֱ */
    NETDEV_ALARM_EVENT_FIRE_RST                = (NETDEV_ALARM_EVENT_BASE + 71),            /* 𾯻ָ */
    NETDEV_ALARM_EVENT_FIRE_TROUBLE            = (NETDEV_ALARM_EVENT_BASE + 72),            /* ̽ͷ */
    NETDEV_ALARM_EVENT_FIRE_TRB_RST            = (NETDEV_ALARM_EVENT_BASE + 73),            /* ̽ͷϻָ */
    NETDEV_ALARM_EVENT_MED_RST                 = (NETDEV_ALARM_EVENT_BASE + 74),            /* ҽƾλ */
    NETDEV_ALARM_EVENT_PANIC                   = (NETDEV_ALARM_EVENT_BASE + 75),            /*  */
    NETDEV_ALARM_EVENT_PANIC_RST               = (NETDEV_ALARM_EVENT_BASE + 76),            /* ָ */
    NETDEV_ALARM_EVENT_RESET                   = (NETDEV_ALARM_EVENT_BASE + 77),            /* λ */
    NETDEV_ALARM_EVENT_RELAY_SHORTED           = (NETDEV_ALARM_EVENT_BASE + 78),            /* ̵· */
    NETDEV_ALARM_EVENT_RELAY_RST               = (NETDEV_ALARM_EVENT_BASE + 79),            /* ̵ָ */
    NETDEV_ALARM_EVENT_RELAY_TROUBLE           = (NETDEV_ALARM_EVENT_BASE + 80),            /* ̵ */
    NETDEV_ALARM_EVENT_TAMPER                  = (NETDEV_ALARM_EVENT_BASE + 81),            /* 𱨾 */
    NETDEV_ALARM_EVENT_TAMPER_RST              = (NETDEV_ALARM_EVENT_BASE + 82),            /* 𱨾ָ */
    NETDEV_ALARM_EVENT_TROUBLE                 = (NETDEV_ALARM_EVENT_BASE + 83),            /*  */
    NETDEV_ALARM_EVENT_TROUBLE_RST             = (NETDEV_ALARM_EVENT_BASE + 84),            /* ϻָ */

    /* ԽӶDF8900ۺԶϵͳ */
    NETDEV_ALARM_EVENT_DFE_REMOTE_CONTROL      = (NETDEV_ALARM_EVENT_BASE + 90),            /* ң */
    NETDEV_ALARM_EVENT_DFE_SYNC                = (NETDEV_ALARM_EVENT_BASE + 91),            /* ͬ */
    NETDEV_ALARM_EVENT_DFE_LIFTING             = (NETDEV_ALARM_EVENT_BASE + 92),            /*  */
    NETDEV_ALARM_EVENT_DFE_SWITCH_NORMAL       = (NETDEV_ALARM_EVENT_BASE + 93),            /* λ */
    NETDEV_ALARM_EVENT_DFE_SWITCH_ACCIDENT     = (NETDEV_ALARM_EVENT_BASE + 94),            /* ¹ʱλ */
    NETDEV_ALARM_EVENT_DFE_KINFE_GATE          = (NETDEV_ALARM_EVENT_BASE + 95),            /* բλ */

    /* ѻӥλ䱨 */
    NETDEV_ALARM_EVENT_ESCAPE                  = (NETDEV_ALARM_EVENT_BASE + 96),            /* ӥλ¼ */
    NETDEV_ALARM_EVENT_ESCAPE_END              = (NETDEV_ALARM_EVENT_BASE + 97),            /* ӥλ¼ܽ */
    NETDEV_ALARM_EVENT_VIOLENCE                = (NETDEV_ALARM_EVENT_BASE + 98),            /* ӥλ¼˱ */
    NETDEV_ALARM_EVENT_VIOLENCE_END            = (NETDEV_ALARM_EVENT_BASE + 99),            /* ӥλ¼˱ */
    NETDEV_ALARM_EVENT_ATTACKED                = (NETDEV_ALARM_EVENT_BASE + 100),           /* ӥλ¼ĿϮ */
    NETDEV_ALARM_EVENT_ATTACKED_END            = (NETDEV_ALARM_EVENT_BASE + 101),           /* ӥλ¼ĿϮ */
    NETDEV_ALARM_EVENT_NATURAL_DISASTER        = (NETDEV_ALARM_EVENT_BASE + 102),           /* ӥλ¼Ȼֺ */
    NETDEV_ALARM_EVENT_NATURAL_DISASTER_END    = (NETDEV_ALARM_EVENT_BASE + 103),           /* ӥλ¼Ȼֺ */
    NETDEV_ALARM_EVENT_ONE_KEY_ALARM           = (NETDEV_ALARM_EVENT_BASE + 104),           /* ӥλ¼һ */
    NETDEV_ALARM_EVENT_ONE_KEY_ALARM_END       = (NETDEV_ALARM_EVENT_BASE + 105),           /* ӥλ¼һ */

    /* Ϋеѹ */
    NETDEV_ALARM_EVENT_CERC_NORMAL             = (NETDEV_ALARM_EVENT_BASE + 106),           /* е¼ѹ */
    NETDEV_ALARM_EVENT_CERC_TOUCH              = (NETDEV_ALARM_EVENT_BASE + 107),           /* е¼ѹ */
    NETDEV_ALARM_EVENT_CERC_BREAK              = (NETDEV_ALARM_EVENT_BASE + 108),           /* е¼ѹ· */
    NETDEV_ALARM_EVENT_CERC_SHORT              = (NETDEV_ALARM_EVENT_BASE + 109),           /* е¼ѹ· */
    NETDEV_ALARM_EVENT_CERC_COMMU_ERR          = (NETDEV_ALARM_EVENT_BASE + 110),           /* е¼ѹͨŴ */

    /* Ϋ״ͺդ */
    NETDEV_ALARM_EVENT_HYPERSEE_DDR_ALARM      = (NETDEV_ALARM_EVENT_BASE + 111),           /* ¼״ﱨ */
    NETDEV_ALARM_EVENT_HYPERSEE_DDR_ALARM_RST  = (NETDEV_ALARM_EVENT_BASE + 112),           /* ¼״ﱨָ */
    NETDEV_ALARM_EVENT_HYPERSEE_IR_ALARM       = (NETDEV_ALARM_EVENT_BASE + 113),           /* ¼դ */
    NETDEV_ALARM_EVENT_HYPERSEE_IR_ALARM_RST   = (NETDEV_ALARM_EVENT_BASE + 114),           /* ¼դָ */

    /* ΫпͨǱ */
    NETDEV_ALARM_EVENT_UBI_ALARM               = (NETDEV_ALARM_EVENT_BASE + 115),           /* пͨ¼Ǳ */

    /* ½̩԰пƻѶܽ𶯵± */
    NETDEV_ALARM_EVENT_HXTECH_CABLE_ALARM      = (NETDEV_ALARM_EVENT_BASE + 116),           /* Ѷܽ¼𶯵± */

    /*¡*/
    NETDEV_ALARM_EVENT_DEVICE_UNDER_VOLTAGE_RST            = (NETDEV_ALARM_EVENT_BASE + 117),               /* 豸Ƿѹָģʽ */
    NETDEV_ALARM_EVENT_ZONE_NOT_READY                      = (NETDEV_ALARM_EVENT_BASE + 118),               /* δ׼ */
    NETDEV_ALARM_EVENT_ZONE_NOT_READY_RST                  = (NETDEV_ALARM_EVENT_BASE + 119),               /* δ׼ָ */
    NETDEV_ALARM_EVENT_TELEPHONE_CABLE_FAULT               = (NETDEV_ALARM_EVENT_BASE + 120),               /* 绰߹ */
    NETDEV_ALARM_EVENT_TELEPHONE_CABLE_FAULT_RST           = (NETDEV_ALARM_EVENT_BASE + 121),               /* 绰߹ϻָ */
    NETDEV_ALARM_EVENT_AC_POWER_FAULT                      = (NETDEV_ALARM_EVENT_BASE + 122),               /*  */

    /* һԽӰ澯 */
    NETDEV_ALARM_EVENT_ZONE_TOUCH                          = (NETDEV_ALARM_EVENT_BASE + 123),    /*  */
    NETDEV_ALARM_EVENT_ZONE_TOUCH_RESTORE                  = (NETDEV_ALARM_EVENT_BASE + 124),    /* ָ */
    NETDEV_ALARM_EVENT_CAPTIVE                             = (NETDEV_ALARM_EVENT_BASE + 125),    /*  */
    NETDEV_ALARM_EVENT_CAPTIVE_RST                         = (NETDEV_ALARM_EVENT_BASE + 126),    /* ˻ָ */
    NETDEV_ALARM_EVENT_UNDERVOLTAGE                        = (NETDEV_ALARM_EVENT_BASE + 127),    /* Ƿѹ */
    NETDEV_ALARM_EVENT_UNDERVOLTAGE_RST                    = (NETDEV_ALARM_EVENT_BASE + 128),    /* Ƿѹָ */
    NETDEV_ALARM_EVENT_TROUBLE_BATTERY_RST                 = (NETDEV_ALARM_EVENT_BASE + 129),    /* õعϻָ */
    NETDEV_ALARM_EVENT_DEV_POWER_REBOOT                    = (NETDEV_ALARM_EVENT_BASE + 130),    /* 豸ϵ */
    NETDEV_ALARM_EVENT_TEST_FAILURE                        = (NETDEV_ALARM_EVENT_BASE + 131),    /* 豸ʧ */
    NETDEV_ALARM_EVENT_OPERATOR_TOUCH_LONG                 = (NETDEV_ALARM_EVENT_BASE + 132),    /*   */
    NETDEV_ALARM_EVENT_REMOTE_ARM                          = (NETDEV_ALARM_EVENT_BASE + 133),    /* ңز  */
    NETDEV_ALARM_EVENT_REMOTE_DISARM                       = (NETDEV_ALARM_EVENT_BASE + 134),    /* ңس  */
    NETDEV_ALARM_EVENT_REMOTE_STAY_ARM                     = (NETDEV_ALARM_EVENT_BASE + 135),    /* ңز  */
    NETDEV_ALARM_EVENT_PWD_ARM                             = (NETDEV_ALARM_EVENT_BASE + 136),    /* 벼豸  */
    NETDEV_ALARM_EVENT_PWD_DISARM                          = (NETDEV_ALARM_EVENT_BASE + 137),    /* 볷豸  */
    NETDEV_ALARM_EVENT_PWD_STAY_DEV                        = (NETDEV_ALARM_EVENT_BASE + 138),    /* ز豸  */
    NETDEV_ALARM_EVENT_PWD_ARM_PART                        = (NETDEV_ALARM_EVENT_BASE + 139),    /* 벼  */
    NETDEV_ALARM_EVENT_PWD_DISARM_PART                     = (NETDEV_ALARM_EVENT_BASE + 140),    /* 볷  */
    NETDEV_ALARM_EVENT_PWD_STAY_PART                       = (NETDEV_ALARM_EVENT_BASE + 141),    /* ز  */
    NETDEV_ALARM_EVENT_PWD_ARM_ZONE                        = (NETDEV_ALARM_EVENT_BASE + 142),    /* 벼  */
    NETDEV_ALARM_EVENT_PWD_DISARM_ZONE                     = (NETDEV_ALARM_EVENT_BASE + 143),    /* 볷  */
    NETDEV_ALARM_EVENT_USER_ARM                            = (NETDEV_ALARM_EVENT_BASE + 144),    /* û豸  */
    NETDEV_ALARM_EVENT_USER_DISARM                         = (NETDEV_ALARM_EVENT_BASE + 145),    /* û豸  */
    NETDEV_ALARM_EVENT_USER_STAY_DEV                       = (NETDEV_ALARM_EVENT_BASE + 146),    /* ûز豸  */
    NETDEV_ALARM_EVENT_USER_CLEAN_ALARM                    = (NETDEV_ALARM_EVENT_BASE + 147),    /* ûʾ  */
    NETDEV_ALARM_EVENT_PWD_OPEN_DOOR                       = (NETDEV_ALARM_EVENT_BASE + 148),    /* 뿪  */
    NETDEV_ALARM_EVENT_KEY_OPEN_DOOR                       = (NETDEV_ALARM_EVENT_BASE + 149),    /* Կ׿  */
    NETDEV_ALARM_EVENT_REMOTE_OPEN_DOOR                    = (NETDEV_ALARM_EVENT_BASE + 150),    /* ңؿ  */
    NETDEV_ALARM_EVENT_SWIPE_ARM                           = (NETDEV_ALARM_EVENT_BASE + 151),    /* ˢ  */
    NETDEV_ALARM_EVENT_SWIPE_DISARM                        = (NETDEV_ALARM_EVENT_BASE + 152),    /* ˢ  */
    NETDEV_ALARM_EVENT_SWIPE_LOCK                          = (NETDEV_ALARM_EVENT_BASE + 153),    /* ˢ  */
    NETDEV_ALARM_EVENT_SWIPE_UNLOCK                        = (NETDEV_ALARM_EVENT_BASE + 154),    /* ˢ  */
    NETDEV_ALARM_EVENT_SWIPE_RECORD                        = (NETDEV_ALARM_EVENT_BASE + 155),    /* ˢ¼  */
    NETDEV_ALARM_EVENT_SWIPE_ATTENDANCE_IN                 = (NETDEV_ALARM_EVENT_BASE + 156),    /* ˢ  */
    NETDEV_ALARM_EVENT_SWIPE_ATTENDANCE_OUT                = (NETDEV_ALARM_EVENT_BASE + 157),    /* ˢڳ  */
    NETDEV_ALARM_EVENT_SWIPE_TURNON_LIGHT                  = (NETDEV_ALARM_EVENT_BASE + 158),    /* ˢ  */
    NETDEV_ALARM_EVENT_SWIPE_OFF_LIGHT                     = (NETDEV_ALARM_EVENT_BASE + 159),    /* ˢص  */
    NETDEV_ALARM_EVENT_SWIPE_CARD_NUM                      = (NETDEV_ALARM_EVENT_BASE + 160),    /* ˢϱ  */
    NETDEV_ALARM_EVENT_MANUAL_OPEN                         = (NETDEV_ALARM_EVENT_BASE + 161),    /* ֶ/  */
    NETDEV_ALARM_EVENT_ZONE_OPEN_DOOR                      = (NETDEV_ALARM_EVENT_BASE + 162),    /*   */
    NETDEV_ALARM_EVENT_ZONE_DOOR_LONGTIME                  = (NETDEV_ALARM_EVENT_BASE + 163),    /* ʱδ  */
    NETDEV_ALARM_EVENT_ZONE_ARM                            = (NETDEV_ALARM_EVENT_BASE + 164),    /*   */
    NETDEV_ALARM_EVENT_ZONE_DISARM                         = (NETDEV_ALARM_EVENT_BASE + 165),    /*   */
    NETDEV_ALARM_EVENT_TIMER_ARM                           = (NETDEV_ALARM_EVENT_BASE + 166),    /* ʱ  */
    NETDEV_ALARM_EVENT_TIMER_DISARM                        = (NETDEV_ALARM_EVENT_BASE + 167),    /* ʱ  */
    NETDEV_ALARM_EVENT_CENTRAL_COMM_NORMAL                 = (NETDEV_ALARM_EVENT_BASE + 168),    /* ͨѶ  */
    NETDEV_ALARM_EVENT_CENTRAL_HANDSHAKE_FAILED            = (NETDEV_ALARM_EVENT_BASE + 169),    /* ʧ  */
    NETDEV_ALARM_EVENT_CENTRAL_RESPONSE_FAILED             = (NETDEV_ALARM_EVENT_BASE + 170),    /* Ӧʧ  */
    NETDEV_ALARM_EVENT_USER_CONFIRMATION                   = (NETDEV_ALARM_EVENT_BASE + 171),    /* ûӾȷ  */
    NETDEV_ALARM_EVENT_USER_TIMEOUT                        = (NETDEV_ALARM_EVENT_BASE + 172),    /* ûӾʱ  */
    NETDEV_ALARM_EVENT_TELEP_RINGING                       = (NETDEV_ALARM_EVENT_BASE + 173),    /* 绰ģյź  */
    NETDEV_ALARM_EVENT_TELEP_ARM                           = (NETDEV_ALARM_EVENT_BASE + 174),    /* 绰ģյԶ̳һλ  */
    NETDEV_ALARM_EVENT_TELEP_STATUS_OFFLINE                = (NETDEV_ALARM_EVENT_BASE + 175),    /* 绰ߵ  */
    NETDEV_ALARM_EVENT_TELEP_STATUS_ONLINE                 = (NETDEV_ALARM_EVENT_BASE + 176),    /* 绰  */
    NETDEV_ALARM_EVENT_MSG_SEND_SUCC                       = (NETDEV_ALARM_EVENT_BASE + 177),    /* ŷͳɹ  */
    NETDEV_ALARM_EVENT_MSG_SEND_FAILED                     = (NETDEV_ALARM_EVENT_BASE + 178),    /* ŷʧ  */
    NETDEV_ALARM_EVENT_SWITCH_CLOSE                        = (NETDEV_ALARM_EVENT_BASE + 179),    /* غ  */
    NETDEV_ALARM_EVENT_SWITCH_OFF                          = (NETDEV_ALARM_EVENT_BASE + 180),    /* ضϿ  */
    NETDEV_ALARM_EVENT_TEMPER_CHANGE                       = (NETDEV_ALARM_EVENT_BASE + 181),    /* ¶ȱ仯ϱ  */
    NETDEV_ALARM_EVENT_HUMIDITY_CHANGE                     = (NETDEV_ALARM_EVENT_BASE + 182),    /* ʪȱ仯ϱ  */
    NETDEV_ALARM_EVENT_DEVID_WRONG                         = (NETDEV_ALARM_EVENT_BASE + 183),    /* 豸ID  */
    NETDEV_ALARM_EVENT_ELEC_HIGH_ARM                       = (NETDEV_ALARM_EVENT_BASE + 184),    /* Χѹ  */
    NETDEV_ALARM_EVENT_ELEC_LOW_ARM                        = (NETDEV_ALARM_EVENT_BASE + 185),    /* Χѹ  */
    NETDEV_ALARM_EVENT_ELEC_ALARM_RST                      = (NETDEV_ALARM_EVENT_BASE + 186),    /* Χλ  */
    NETDEV_ALARM_EVENT_ELEC_DISARM                         = (NETDEV_ALARM_EVENT_BASE + 187),    /* Χ  */
    NETDEV_ALARM_EVENT_ELEC_ARM                            = (NETDEV_ALARM_EVENT_BASE + 188),    /* Χѹֵ  */
    NETDEV_ALARM_EVENT_KEY_ALARM_OVER                      = (NETDEV_ALARM_EVENT_BASE + 189),    /* б  */
    NETDEV_ALARM_EVENT_KEY_PROL_TYPE                       = (NETDEV_ALARM_EVENT_BASE + 190),    /* ϱЭͣҪԵΧ  */
    NETDEV_ALARM_EVENT_MOD_DEV_ADDR                        = (NETDEV_ALARM_EVENT_BASE + 191),    /* ޸豸ַҪԵΧ  */
    NETDEV_ALARM_EVENT_FORWARD_CMD                         = (NETDEV_ALARM_EVENT_BASE + 192) ,   /* ͨѶ豸ת  */

    NETDEV_ALARM_EVENT_BASE_VALUE                          = (110000UL),                                    /* Ͷʼλ */
    NETDEV_ALARM_EVENT_IMMEDIATELY_DEFEND_ALARM            = (NETDEV_ALARM_EVENT_BASE_VALUE + 1),           /* ʱ */
    NETDEV_ALARM_EVENT_IMMEDIATELY_DEFEND_ALARM_RST        = (NETDEV_ALARM_EVENT_BASE_VALUE + 2),           /* ʱָ */
    NETDEV_ALARM_EVENT_ALL_DAY_NO_VOICE_ALARM              = (NETDEV_ALARM_EVENT_BASE_VALUE + 3),           /* 24Сʱ */
    NETDEV_ALARM_EVENT_ALL_DAY_NO_VOICE_ALARM_RST          = (NETDEV_ALARM_EVENT_BASE_VALUE + 4),           /* 24Сʱָ */
    NETDEV_ALARM_EVENT_ALL_DAY_VOICE_ALARM                 = (NETDEV_ALARM_EVENT_BASE_VALUE + 5),           /* 24Сʱ */
    NETDEV_ALARM_EVENT_ALL_DAY_VOICE_ALARM_RST             = (NETDEV_ALARM_EVENT_BASE_VALUE + 6),           /* 24Сʱָ */
    NETDEV_ALARM_EVENT_BOARD_DEFEND_ALARM                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 7),           /* ܽ */
    NETDEV_ALARM_EVENT_BOARD_DEFEND_ALARM_RST              = (NETDEV_ALARM_EVENT_BASE_VALUE + 8),           /* ָܽ */
    NETDEV_ALARM_EVENT_INNER_DELAY_DEFEND_ALARM            = (NETDEV_ALARM_EVENT_BASE_VALUE + 9),           /* ڲʱ */
    NETDEV_ALARM_EVENT_INNER_DELAY_DEFEND_ALARM_RST        = (NETDEV_ALARM_EVENT_BASE_VALUE + 10),          /* ڲʱָ */
    NETDEV_ALARM_EVENT_DELAY_DEFEND_ALARM                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 11),          /* ʱ */
    NETDEV_ALARM_EVENT_DELAY_DEFEND_ALARM_RST              = (NETDEV_ALARM_EVENT_BASE_VALUE + 12),          /* ʱָ */
    NETDEV_ALARM_EVENT_EXPAND_MODEL_FAULT_ALARM            = (NETDEV_ALARM_EVENT_BASE_VALUE + 13),          /* չģ */
    NETDEV_ALARM_EVENT_EXPAND_MODEL_FAULT_ALARM_RST        = (NETDEV_ALARM_EVENT_BASE_VALUE + 14),          /* չģϻָ */
    NETDEV_ALARM_EVENT_OUTER_DISARMED                      = (NETDEV_ALARM_EVENT_BASE_VALUE + 15),          /*  */
    NETDEV_ALARM_EVENT_OUTER_ARMED                         = (NETDEV_ALARM_EVENT_BASE_VALUE + 16),          /*  */
    NETDEV_ALARM_EVENT_KEY_DISARMED                        = (NETDEV_ALARM_EVENT_BASE_VALUE + 17),          /* Կ׷ */
    NETDEV_ALARM_EVENT_KEY_ARMED                           = (NETDEV_ALARM_EVENT_BASE_VALUE + 18),          /* Կ׷ */
    NETDEV_ALARM_EVENT_WIRELESS_NET_WORK_EXCEPTION         = (NETDEV_ALARM_EVENT_BASE_VALUE + 19),          /* 쳣 */
    NETDEV_ALARM_EVENT_WIRELESS_NET_WORK_EXCEPTION_RST     = (NETDEV_ALARM_EVENT_BASE_VALUE + 20),          /* 쳣ָ */
    NETDEV_ALARM_EVENT_WIRED_NET_WORK_BREAK                = (NETDEV_ALARM_EVENT_BASE_VALUE + 21),          /*  */
    NETDEV_ALARM_EVENT_WIRED_NET_WORK_BREAK_RST            = (NETDEV_ALARM_EVENT_BASE_VALUE + 22),          /* ϻָ */
    NETDEV_ALARM_EVENT_SOFT_DEFEND_URGENCY_ALARM           = (NETDEV_ALARM_EVENT_BASE_VALUE + 23),          /*  */
    NETDEV_ALARM_EVENT_ARMED_STAY                          = (NETDEV_ALARM_EVENT_BASE_VALUE + 24),          /* ز */
    NETDEV_ALARM_EVENT_IMMEDIATELY_ARMED                   = (NETDEV_ALARM_EVENT_BASE_VALUE + 25),          /* ʱ */

    /* ԽشУ̸Сˮ̵ */
    NETDEV_ALARM_EVENT_SMOKE_ALARM                         = (NETDEV_ALARM_EVENT_BASE_VALUE + 26),          /* ش ̸б */
    NETDEV_ALARM_EVENT_SMOKE_ALARM_END                     = (NETDEV_ALARM_EVENT_BASE_VALUE + 27),          /* ش ̸бֹͣ */
    NETDEV_ALARM_EVENT_WATER_ALARM                         = (NETDEV_ALARM_EVENT_BASE_VALUE + 28),          /* ش ˮ */
    NETDEV_ALARM_EVENT_WATER_ALARM_END                     = (NETDEV_ALARM_EVENT_BASE_VALUE + 29),          /* ش ˮֹͣ */
    NETDEV_ALARM_EVENT_IO_ON                               = (NETDEV_ALARM_EVENT_BASE_VALUE + 30),          /* ش. */
    NETDEV_ALARM_EVENT_IO_OFF                              = (NETDEV_ALARM_EVENT_BASE_VALUE + 31),          /* ش. */

    /* 񶯹ֵ */
    NETDEV_ALARM_EVENT_TOUNCH_ALARM                        = (NETDEV_ALARM_EVENT_BASE_VALUE + 32),          /*  */
    NETDEV_ALARM_EVENT_INVADE_ALARM                        = (NETDEV_ALARM_EVENT_BASE_VALUE + 33),          /* ֱ */
    NETDEV_ALARM_EVENT_BROKEN_ALARM                        = (NETDEV_ALARM_EVENT_BASE_VALUE + 34),          /* ѱ */
    NETDEV_ALARM_EVENT_HELP                                = (NETDEV_ALARM_EVENT_BASE_VALUE + 36),          /*  */
    NETDEV_ALARM_EVENT_DESTROY                             = (NETDEV_ALARM_EVENT_BASE_VALUE + 37),          /* ƻ */
    NETDEV_ALARM_EVENT_ACS                                 = (NETDEV_ALARM_EVENT_BASE_VALUE + 38),          /* Ž */
    NETDEV_ALARM_EVENT_OTHERS                              = (NETDEV_ALARM_EVENT_BASE_VALUE + 39),          /*  */
    NETDEV_ALARM_EVENT_ZONE_ALARM                          = (NETDEV_ALARM_EVENT_BASE_VALUE + 40),          /* 걨ģ. */
    NETDEV_ALARM_EVENT_ZONE_ALARM_RST                      = (NETDEV_ALARM_EVENT_BASE_VALUE + 41),          /* 걨ģ.ָ */
    NETDEV_ALARM_EVENT_GATO_ALARM_FENCE                    = (NETDEV_ALARM_EVENT_BASE_VALUE + 42),          /* Χ */
    NETDEV_ALARM_EVENT_GATO_ALARM_HOST                     = (NETDEV_ALARM_EVENT_BASE_VALUE + 43),          /*  */
    NETDEV_ALARM_EVENT_GATO_ALARM_ETCZONE                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 44),          /* չ */
    NETDEV_ALARM_EVENT_GATO_ALARM_OFFLINE                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 45),          /* ͨŵ */
    NETDEV_ALARM_EVENT_GATO_ALARM_SWITCH1                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 46),          /* 1 */
    NETDEV_ALARM_EVENT_GATO_ALARM_SWITCH2                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 47),          /* 2 */
    NETDEV_ALARM_EVENT_STEAL                               = (NETDEV_ALARM_EVENT_BASE_VALUE + 48),          /* Ե */
    NETDEV_ALARM_EVENT_GAS                                 = (NETDEV_ALARM_EVENT_BASE_VALUE + 49),          /* ȼ */
    NETDEV_ALARM_EVENT_SAVE                                = (NETDEV_ALARM_EVENT_BASE_VALUE + 50),          /* Ȼ */
    NETDEV_ALARM_EVENT_INVADE_TROUBLE                      = (NETDEV_ALARM_EVENT_BASE_VALUE + 51),          /* ּӹϱ */
    NETDEV_ALARM_EVENT_SYS_TROUBLE                         = (NETDEV_ALARM_EVENT_BASE_VALUE + 52),          /* ϵͳ */
    NETDEV_ALARM_EVENT_OPTICAL_FIBER_TROUBLE               = (NETDEV_ALARM_EVENT_BASE_VALUE + 53),          /* ˹ */

    /* Ƽ */
    NETDEV_ALARM_EVENT_MOTION_DETECTION                    = (NETDEV_ALARM_EVENT_BASE_VALUE + 62),          /* ˶ⱨ */
    NETDEV_ALARM_EVENT_CALL_REMOVE                         = (NETDEV_ALARM_EVENT_BASE_VALUE + 63),          /* н */
    NETDEV_ALARM_EVENT_NOISE                               = (NETDEV_ALARM_EVENT_BASE_VALUE + 64),          /*  */
    NETDEV_ALARM_EVENT_DELAYED                             = (NETDEV_ALARM_EVENT_BASE_VALUE + 65),          /* ʱ */
    NETDEV_ALARM_EVENT_ALARM_INPUT_ONE                     = (NETDEV_ALARM_EVENT_BASE_VALUE + 66),          /* 1 */
    NETDEV_ALARM_EVENT_ALARM_INPUT_TWO                     = (NETDEV_ALARM_EVENT_BASE_VALUE + 67),          /* 2 */
    NETDEV_ALARM_EVENT_ALARM_CALL_EMERGENCY                = (NETDEV_ALARM_EVENT_BASE_VALUE + 68),          /*   */
    NETDEV_ALARM_EVENT_ALARM_CALL_CONSULTANT               = (NETDEV_ALARM_EVENT_BASE_VALUE + 69),          /* ѯ */
    NETDEV_ALARM_EVENT_DOOR_MAGNET_OPEN                    = (NETDEV_ALARM_EVENT_BASE_VALUE + 70),          /* ŴŴ */
    NETDEV_ALARM_EVENT_DOOR_MAGNET_CLOSE                   = (NETDEV_ALARM_EVENT_BASE_VALUE + 71),          /* ŴŹر */
    NETDEV_ALARM_EVENT_DOOR_LOCK_OPEN                      = (NETDEV_ALARM_EVENT_BASE_VALUE + 72),          /*  */
    NETDEV_ALARM_EVENT_DOOR_LOCK_CLOSE                     = (NETDEV_ALARM_EVENT_BASE_VALUE + 73),          /* ر */

    /**/
    NETDEV_ALARM_EVENT_ALARM_PORT_ONE             = (NETDEV_ALARM_EVENT_BASE_VALUE + 74),          /* ˿1  Port 1 Alarm */
    NETDEV_ALARM_EVENT_ALARM_PORT_TWO             = (NETDEV_ALARM_EVENT_BASE_VALUE + 75),          /* ˿2  Port 2 Alarm */
    NETDEV_ALARM_EVENT_ALARM_PORTEX               = (NETDEV_ALARM_EVENT_BASE_VALUE + 76),          /* չ˿ڱ  Expansion Port Alarm */
    NETDEV_ALARM_EVENT_ALARM_TUMULT               = (NETDEV_ALARM_EVENT_BASE_VALUE + 77),          /*   Tumult Alarm */
    NETDEV_ALARM_EVENT_ALARM_110                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 78),          /* 110  110 Alarm */
    NETDEV_ALARM_EVENT_ALARM_119                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 79),          /* 119  119 Alarm */
    NETDEV_ALARM_EVENT_ALARM_120                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 80),          /* 120  120 Alarm */

    /* Ǳ */
    NETDEV_ALARM_EVENT_ALARM_FINDERCONNECT_FAILED = (NETDEV_ALARM_EVENT_BASE_VALUE + 81),          /* ̽ͨѶʧ */
    NETDEV_ALARM_EVENT_ALARM_OUTAGE               = (NETDEV_ALARM_EVENT_BASE_VALUE + 82),          /* ϵ籨 */
    NETDEV_ALARM_EVENT_ALARM_DISASSEMBLE          = (NETDEV_ALARM_EVENT_BASE_VALUE + 83),          /*  */
    NETDEV_ALARM_EVENT_ALARM_CIRCUIT              = (NETDEV_ALARM_EVENT_BASE_VALUE + 84),          /* · */
    NETDEV_ALARM_EVENT_ALARM_TOUCHNET             = (NETDEV_ALARM_EVENT_BASE_VALUE + 85),          /*  */
    NETDEV_ALARM_EVENT_ALARM_PREVENTCUT           = (NETDEV_ALARM_EVENT_BASE_VALUE + 86),          /*  */
    NETDEV_ALARM_EVENT_ALARM_COCKING              = (NETDEV_ALARM_EVENT_BASE_VALUE + 87),          /*  */
    NETDEV_ALARM_EVENT_ALARM_SLACK                = (NETDEV_ALARM_EVENT_BASE_VALUE + 88),          /* ɳڱ */
    NETDEV_ALARM_EVENT_ALARM_ZONE_FORBIDDEN       = (NETDEV_ALARM_EVENT_BASE_VALUE + 89),          /*  */

    /* ʿ */
    NETDEV_ALARM_EVENT_HIGH_TEMP                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 90),           /* ¶ȳޱ */
    NETDEV_ALARM_EVENT_LOW_TEMP                   = (NETDEV_ALARM_EVENT_BASE_VALUE + 91),           /* ¶ȳޱ */
    NETDEV_ALARM_EVENT_HIGH_HUMI                  = (NETDEV_ALARM_EVENT_BASE_VALUE + 92),           /* ʪȳޱ */
    NETDEV_ALARM_EVENT_LOW_HUMI                   = (NETDEV_ALARM_EVENT_BASE_VALUE + 93),           /* ʪȳޱ */
    NETDEV_ALARM_MONITOR_DEVICE_ONLINE            = (NETDEV_ALARM_EVENT_BASE_VALUE + 94),           /* ص豸 */
    NETDEV_ALARM_MONITOR_DEVICE_OFFLINE           = (NETDEV_ALARM_EVENT_BASE_VALUE + 95),           /* ص豸 */

    /* Žϱ¼Ͷ*/
    NETDEV_DOOR_EVENT_BASE                         = (100400UL),                          /* Ž¼Ͷʼλ */

    NETDEV_DOOR_EVENT_DISCONNECT                   = (NETDEV_DOOR_EVENT_BASE + 1),        /* ͨж(Ž֮) */
    NETDEV_DOOR_EVENT_INFRARED_ALARM               = (NETDEV_DOOR_EVENT_BASE + 2),        /* ⱨ */
    NETDEV_DOOR_EVENT_ILLICIT_OPEN_DOOR            = (NETDEV_DOOR_EVENT_BASE + 3),        /* Ƿ */
    NETDEV_DOOR_EVENT_COERCE_ALARM                 = (NETDEV_DOOR_EVENT_BASE + 4),        /* вȱ */
    NETDEV_DOOR_EVENT_OPEN_TIMEOUT                 = (NETDEV_DOOR_EVENT_BASE + 5),        /* ʱδ */
    NETDEV_DOOR_EVENT_CLOSE_TIMEOUT                = (NETDEV_DOOR_EVENT_BASE + 6),        /* ʱδ */
    NETDEV_DOOR_EVENT_ANOMALOUS_CARD               = (NETDEV_DOOR_EVENT_BASE + 7),        /* 쳣ˢ */
    NETDEV_DOOR_EVENT_CARD_OPEN_DOOR               = (NETDEV_DOOR_EVENT_BASE + 8),        /* ˢ */
    NETDEV_DOOR_EVENT_REMOTE_OPEN_DOOR             = (NETDEV_DOOR_EVENT_BASE + 9),        /* Զ̿ */
    NETDEV_DOOR_EVENT_MANUAL_OPEN_DOOR             = (NETDEV_DOOR_EVENT_BASE + 10),       /* ֶ */
    NETDEV_DOOR_EVENT_EMERGENCY_START              = (NETDEV_DOOR_EVENT_BASE + 11),       /* ¼ʼ */
    NETDEV_DOOR_EVENT_EMERGENCY_STOP               = (NETDEV_DOOR_EVENT_BASE + 12),       /* ¼ */
    NETDEV_DOOR_EVENT_OPEN_SUCCESS                 = (NETDEV_DOOR_EVENT_BASE + 13),       /* ųɹ */
    NETDEV_DOOR_EVENT_OPEN_FAILED                  = (NETDEV_DOOR_EVENT_BASE + 14),       /* ʧ */
    NETDEV_DOOR_EVENT_CLOSE                        = (NETDEV_DOOR_EVENT_BASE + 15),       /* ¼ */
    NETDEV_DOOR_EVENT_CLOSE_FAILED                 = (NETDEV_DOOR_EVENT_BASE + 16),       /* ʧ */
    NETDEV_DOOR_EVENT_CARD_NO_AUTH                 = (NETDEV_DOOR_EVENT_BASE + 17),       /* Ȩ */
    NETDEV_DOOR_EVENT_NO_DATE_LIMIT                = (NETDEV_DOOR_EVENT_BASE + 18),       /*  */
    NETDEV_DOOR_EVENT_CARD_ILLEGAL                 = (NETDEV_DOOR_EVENT_BASE + 19),       /* Ƿ */
    NETDEV_DOOR_EVENT_FIREPORTECT_ALRAM            = (NETDEV_DOOR_EVENT_BASE + 20),       /*  */
    NETDEV_DOOR_EVENT_CANCEL_FIREPORTECT           = (NETDEV_DOOR_EVENT_BASE + 21),       /* ȡ */
    NETDEV_DOOR_EVENT_PRYING_RESIST_ALRAM          = (NETDEV_DOOR_EVENT_BASE + 22),       /* ˱ */
    NETDEV_DOOR_EVENT_SUPERPASSWD_OPEN_DOOR        = (NETDEV_DOOR_EVENT_BASE + 23),       /* 뿪 */
    NETDEV_DOOR_EVENT_COERCECODE_IN                = (NETDEV_DOOR_EVENT_BASE + 24),       /* в */
    NETDEV_DOOR_EVENT_DOOR_STATUS_OPEN             = (NETDEV_DOOR_EVENT_BASE + 25),       /* Ŵ */
    NETDEV_DOOR_EVENT_DOOR_STATUS_CLOSE            = (NETDEV_DOOR_EVENT_BASE + 26),       /* Źر */
    NETDEV_DOOR_EVENT_DOOR_FORCED_OPEN             = (NETDEV_DOOR_EVENT_BASE + 27),       /* ǿ */
    NETDEV_DOOR_EVENT_DOOR_KEEP_OPEN               = (NETDEV_DOOR_EVENT_BASE + 28),       /* űִ */
    NETDEV_DOOR_EVENT_LOCK_FAILURE                 = (NETDEV_DOOR_EVENT_BASE + 29),       /* ʧЧ */
    NETDEV_DOOR_EVENT_LOST_STOLEN_CARD             = (NETDEV_DOOR_EVENT_BASE + 30),       /* ʧ򱻵 */

    /* ʵŽԽ */
    NETDEV_DOOR_EVENT_PASSWD_WRONG                 = (NETDEV_DOOR_EVENT_BASE + 31),       /*  */
    NETDEV_DOOR_EVENT_ALWAYS_CLOSED                = (NETDEV_DOOR_EVENT_BASE + 32),       /* δͨ */
    NETDEV_DOOR_EVENT_CARD_PASSWD_ENTER            = (NETDEV_DOOR_EVENT_BASE + 33),       /*  */
    NETDEV_DOOR_EVENT_CARD_PASSWD_WRONG            = (NETDEV_DOOR_EVENT_BASE + 34),       /*  */
    NETDEV_DOOR_EVENT_MORE_CARD_OPEN               = (NETDEV_DOOR_EVENT_BASE + 35),       /* ࿨ */
    NETDEV_DOOR_EVENT_FIRST_CARD_OPEN              = (NETDEV_DOOR_EVENT_BASE + 36),       /* ׿ */
    NETDEV_DOOR_EVENT_CARD_OUT_DATE                = (NETDEV_DOOR_EVENT_BASE + 37),       /*  */
    NETDEV_DOOR_EVENT_CARD_WATCH                   = (NETDEV_DOOR_EVENT_BASE + 38),       /* Ѳ */

    /*ŽԽ */ 
    NETDEV_DOOR_EVENT_REMOTE_CLOSE_DOOR            = (NETDEV_DOOR_EVENT_BASE + 39),       /* Զ̹ */
    NETDEV_DOOR_EVENT_REMOTE_ALWAYS_OPEN           = (NETDEV_DOOR_EVENT_BASE + 40),       /* Զ̳ */
    NETDEV_DOOR_EVENT_REMOTE_ALWAYS_CLOSE          = (NETDEV_DOOR_EVENT_BASE + 41),       /* Զ̳ */
    NETDEV_DOOR_EVENT_LEGAL_CARD_PASS              = (NETDEV_DOOR_EVENT_BASE + 42),       /* Ϸ֤ͨ */
    NETDEV_DOOR_EVENT_CARD_AND_PSW_PASS            = (NETDEV_DOOR_EVENT_BASE + 43),       /* ˢ֤ͨ */
    NETDEV_DOOR_EVENT_CARD_AND_PSW_FAIL            = (NETDEV_DOOR_EVENT_BASE + 44),       /* ˢ֤ʧܣ */
    NETDEV_DOOR_EVENT_CARD_AND_PSW_TIMEOUT         = (NETDEV_DOOR_EVENT_BASE + 45),       /* ֤ʱ */
    NETDEV_DOOR_EVENT_CARD_AND_PSW_OVER_TIME       = (NETDEV_DOOR_EVENT_BASE + 46),       /* ˢ볬 */
    NETDEV_DOOR_EVENT_INVALID_CARD                 = (NETDEV_DOOR_EVENT_BASE + 47),       /* ޴˿ */
    NETDEV_DOOR_EVENT_DOOR_BUTTON_PRESS            = (NETDEV_DOOR_EVENT_BASE + 48),       /* Űť */
    NETDEV_DOOR_EVENT_DOOR_BUTTON_RELEASE          = (NETDEV_DOOR_EVENT_BASE + 49),       /* Űťɿ */
    NETDEV_DOOR_EVENT_CARD_READER_DESMANTLE_ALARM  = (NETDEV_DOOR_EVENT_BASE + 50),       /* 𱨾 */
    NETDEV_DOOR_EVENT_CARD_READER_DESMANTLE_RESUME = (NETDEV_DOOR_EVENT_BASE + 51),       /* ָ */
    NETDEV_DOOR_EVENT_DOOR_MAGNET_OPEN             = (NETDEV_DOOR_EVENT_BASE + 52),       /* ŴŴ򿪣ţ */
    NETDEV_DOOR_EVENT_DOOR_MAGNET_CLOSE            = (NETDEV_DOOR_EVENT_BASE + 53),       /* ŴŹرգ */
    NETDEV_DOOR_EVENT_DOOR_MAGNET_OPEN_ABNORMAL    = (NETDEV_DOOR_EVENT_BASE + 54),       /* Ŵ쳣򿪣쳣򿪣 */
    NETDEV_DOOR_EVENT_DOOR_MAGNET_OPEN_TIMEOUT     = (NETDEV_DOOR_EVENT_BASE + 55),       /* ŴŴ򿪳ʱ(Ŵ򿪳ʱ) */
    NETDEV_DOOR_EVENT_ANTI_SNEAK_FAIL              = (NETDEV_DOOR_EVENT_BASE + 56),       /* Ǳ֤ʧ */
    NETDEV_DOOR_EVENT_INTERLOCK_DOOR_NOT_CLOSE     = (NETDEV_DOOR_EVENT_BASE + 57),       /* δر */
    NETDEV_DOOR_EVENT_MULTI_VERIFY_SUCCESS         = (NETDEV_DOOR_EVENT_BASE + 58),       /* ֤ɹ */
    NETDEV_DOOR_EVENT_LEADER_CARD_OPEN_BEGIN       = (NETDEV_DOOR_EVENT_BASE + 59),       /* ׿ſʼ */
    NETDEV_DOOR_EVENT_LEADER_CARD_OPEN_END         = (NETDEV_DOOR_EVENT_BASE + 60),       /* ׿Ž */
    NETDEV_DOOR_EVENT_ALWAYS_OPEN_BEGIN            = (NETDEV_DOOR_EVENT_BASE + 61),       /* ״̬ʼ */
    NETDEV_DOOR_EVENT_ALWAYS_OPEN_END              = (NETDEV_DOOR_EVENT_BASE + 62),       /* ״̬ */
    NETDEV_DOOR_EVENT_ALWAYS_CLOSE_BEGIN           = (NETDEV_DOOR_EVENT_BASE + 63),       /* ״̬ʼ */
    NETDEV_DOOR_EVENT_ALWAYS_CLOSE_END             = (NETDEV_DOOR_EVENT_BASE + 64),       /* ״̬ */
    NETDEV_DOOR_EVENT_KEYPRESS_OPEN_DOOR           = (NETDEV_DOOR_EVENT_BASE + 65),       /*  */

    /* ŦŽЭԽ¼ */
    NETDEV_DOOR_EVENT_COMMU_INTERRUPT              = (NETDEV_DOOR_EVENT_BASE + 81),       /* ͨѶж */
    NETDEV_DOOR_EVENT_COMMU_RESTORE                = (NETDEV_DOOR_EVENT_BASE + 82),       /* ͨѶָ */
    NETDEV_DOOR_EVENT_LEGAL_CREDIT_CARD            = (NETDEV_DOOR_EVENT_BASE + 83),       /* Ϸˢ */
    NETDEV_DOOR_EVENT_LEGAL_USER_ID                = (NETDEV_DOOR_EVENT_BASE + 84),       /* ϷûID */
    NETDEV_DOOR_EVENT_CARD_NO_REG                  = (NETDEV_DOOR_EVENT_BASE + 85),       /* δע */
    NETDEV_DOOR_EVENT_CARD_UNAUTH                  = (NETDEV_DOOR_EVENT_BASE + 86),       /* δȨ */
    NETDEV_DOOR_EVENT_CARD_DISABLED                = (NETDEV_DOOR_EVENT_BASE + 87),       /* ͣ */
    NETDEV_DOOR_EVENT_CARD_EXPIRED                 = (NETDEV_DOOR_EVENT_BASE + 88),       /* ѹ */
    NETDEV_DOOR_EVENT_INVALID_TIME                 = (NETDEV_DOOR_EVENT_BASE + 89),       /* Чʱ */
    NETDEV_DOOR_EVENT_PSW_ERROR                    = (NETDEV_DOOR_EVENT_BASE + 90),       /*  */
    NETDEV_DOOR_EVENT_PROHIBITED                   = (NETDEV_DOOR_EVENT_BASE + 91),       /* ֹͨ */
    NETDEV_DOOR_EVENT_REQ_CENTER_OPEN_DOOR         = (NETDEV_DOOR_EVENT_BASE + 92),       /* Ŀ */
    NETDEV_DOOR_EVENT_LEGAL_CARD_OPEN_DOOR         = (NETDEV_DOOR_EVENT_BASE + 93),       /* Ϸ */
    NETDEV_DOOR_EVENT_SUPER_CARD_OPEN_DOOR         = (NETDEV_DOOR_EVENT_BASE + 94),       /*  */
    NETDEV_DOOR_EVENT_CENTER_OPEN_DOOR             = (NETDEV_DOOR_EVENT_BASE + 96),       /* Ŀ */
    NETDEV_DOOR_EVENT_LINK_OPEN_DOOR               = (NETDEV_DOOR_EVENT_BASE + 97),       /*  */
    NETDEV_DOOR_EVENT_FORCE_OPEN_DOOR              = (NETDEV_DOOR_EVENT_BASE + 98),       /* ǿп */
    NETDEV_DOOR_EVENT_DOOR_IS_OPEN                 = (NETDEV_DOOR_EVENT_BASE + 99),       /* ű */
    NETDEV_DOOR_EVENT_DOOR_IS_CLOSE                = (NETDEV_DOOR_EVENT_BASE + 100),      /* űر */
    NETDEV_DOOR_EVENT_STRESS_ALARM                 = (NETDEV_DOOR_EVENT_BASE + 103),      /* вȱ */
    NETDEV_DOOR_EVENT_TRAILING_ALARM               = (NETDEV_DOOR_EVENT_BASE + 105),      /* β汨 */
    NETDEV_DOOR_EVENT_DOOR_LOCK                    = (NETDEV_DOOR_EVENT_BASE + 106),      /*  */
    NETDEV_DOOR_EVENT_LIFT_DOOR_LOCK               = (NETDEV_DOOR_EVENT_BASE + 107),      /* Ž */
    NETDEV_DOOR_EVENT_DOOR_NOT_CLOSE               = (NETDEV_DOOR_EVENT_BASE + 108),      /* δغ */
    NETDEV_DOOR_EVENT_NEED_PSW                     = (NETDEV_DOOR_EVENT_BASE + 109),      /* Ҫ */
    NETDEV_DOOR_EVENT_NEED_FINGERPRINT             = (NETDEV_DOOR_EVENT_BASE + 110),      /* Ҫָ */
    NETDEV_DOOR_EVENT_REQ_INTERCOM                 = (NETDEV_DOOR_EVENT_BASE + 111),      /* Խ */
    NETDEV_DOOR_EVENT_EMERGENCY                    = (NETDEV_DOOR_EVENT_BASE + 112),      /* ¼ */
    NETDEV_DOOR_EVENT_PATROL_LEGAL_CREDIT_CARD     = (NETDEV_DOOR_EVENT_BASE + 113),      /* ѲϷˢ */
    NETDEV_DOOR_EVENT_PATROL_LEGAL_FINGERPRINT     = (NETDEV_DOOR_EVENT_BASE + 114),      /* ѲϷָ */
    NETDEV_DOOR_EVENT_PATROL_CARD_NOT_REG          = (NETDEV_DOOR_EVENT_BASE + 115),      /* Ѳδע */
    NETDEV_DOOR_EVENT_NOT_PATROL_CARD              = (NETDEV_DOOR_EVENT_BASE + 116),      /* ѲԱˢ */
    NETDEV_DOOR_EVENT_NORMAL_PATROL                = (NETDEV_DOOR_EVENT_BASE + 117),      /* Ѳ */
    NETDEV_DOOR_EVENT_ADVANCE_PATROL               = (NETDEV_DOOR_EVENT_BASE + 118),      /* ǰѲ */
    NETDEV_DOOR_EVENT_TIMEOUT_PATROL               = (NETDEV_DOOR_EVENT_BASE + 119),      /* ʱѲ */
    NETDEV_DOOR_EVENT_INVALID_PATROL               = (NETDEV_DOOR_EVENT_BASE + 120),      /* ЧѲ */
    NETDEV_DOOR_EVENT_NOT_PATROL                   = (NETDEV_DOOR_EVENT_BASE + 121),      /* δѲ */
    NETDEV_DOOR_EVENT_TH_ALARM                     = (NETDEV_DOOR_EVENT_BASE + 122),      /* ʪȱ */
    NETDEV_DOOR_EVENT_TH_RESTORE                   = (NETDEV_DOOR_EVENT_BASE + 123),      /* ʪȻָ */
    NETDEV_DOOR_EVENT_TH_RECORD                    = (NETDEV_DOOR_EVENT_BASE + 124),      /* ʪȼ¼ */
    NETDEV_DOOR_EVENT_SMOKE_ALARM                  = (NETDEV_DOOR_EVENT_BASE + 125),      /* ̸б */
    NETDEV_DOOR_EVENT_SMOKE_RESTORE                = (NETDEV_DOOR_EVENT_BASE + 126),      /* ̸лָ */
    NETDEV_DOOR_EVENT_SMOKE_RECORD                 = (NETDEV_DOOR_EVENT_BASE + 127),      /* ̸м¼ */

    /* ΢ŽЭԽ¼ */
    NETDEV_DOOR_EVENT_PC_CONTROL                   = (NETDEV_DOOR_EVENT_BASE + 128),      /* ˢͨԿ */
    NETDEV_DOOR_EVENT_LIMITED_CARD_NUM             = (NETDEV_DOOR_EVENT_BASE + 129),      /* ˢͨˢ */
    NETDEV_DOOR_EVENT_REASON_UNKNOWN               = (NETDEV_DOOR_EVENT_BASE + 130),      /* ˢͨԭ */
    NETDEV_DOOR_EVENT_CONTROLLER_ON                = (NETDEV_DOOR_EVENT_BASE + 131),      /* ϵ */
    NETDEV_DOOR_EVENT_CONTROLLER_RESERT            = (NETDEV_DOOR_EVENT_BASE + 132),      /* λ */
    NETDEV_DOOR_EVENT_DOOR_FORCE_CLOSE             = (NETDEV_DOOR_EVENT_BASE + 133),      /* ǿƹ */
    NETDEV_DOOR_EVENT_DOOR_OFFLINE                 = (NETDEV_DOOR_EVENT_BASE + 134),      /* Ų */
    NETDEV_DOOR_EVENT_FIRE                         = (NETDEV_DOOR_EVENT_BASE + 135),      /*  */
    NETDEV_DOOR_EVENT_CALL_EMERGENCY               = (NETDEV_DOOR_EVENT_BASE + 136),      /* н */
    NETDEV_DOOR_PERSON_FACE_DOOR                   = (NETDEV_DOOR_EVENT_BASE + 137),      /* ˢ */
    NETDEV_DOOR_PERSON_INVALE_DOOR                 = (NETDEV_DOOR_EVENT_BASE + 138),      /* Ƿˢ */

    /* пŽԽ¼ */
    NETDEV_DOOR_EVENT_FINGERPRINT_OPEN_DOOR        = (NETDEV_DOOR_EVENT_BASE + 153),      /* ָƿ */
    NETDEV_DOOR_EVENT_ANTI_SUBMARINE               = (NETDEV_DOOR_EVENT_BASE + 154),      /* Ǳ */
    NETDEV_DOOR_EVENT_PRESS_MISTAKE                = (NETDEV_DOOR_EVENT_BASE + 155),      /*  */
    NETDEV_DOOR_EVENT_PF_PW_RF_OPEN_DOOR           = (NETDEV_DOOR_EVENT_BASE + 156),      /* ָơ֤ */

    /* ̩ŽԽ¼ */
    NETDEV_DOOR_EVENT_DOOR_FORCED_OPEN_CLEARED     = (NETDEV_DOOR_EVENT_BASE + 157),      /* ǿƴ򿪻ָ */

    /* ͨŽԽп¼ */
    NETDEV_DOOR_EVENT_BLACKLIST                    = (NETDEV_DOOR_EVENT_BASE + 158),      /*  */
    NETDEV_DOOR_EVENT_FAILED_SEND_CMD              = (NETDEV_DOOR_EVENT_BASE + 159),      /* ʧ */
    NETDEV_DOOR_EVENT_FAILED_OPEN_DOOE_MU_CARD     = (NETDEV_DOOR_EVENT_BASE + 160),      /* ࿨ʧ */
    NETDEV_DOOR_EVENT_CARD_INVALID_PERIOD          = (NETDEV_DOOR_EVENT_BASE + 161),      /* Чʱˢ */ 
    NETDEV_DOOR_EVENT_CARD_REPORT_LOST             = (NETDEV_DOOR_EVENT_BASE + 162),      /* ѹʧ */
    NETDEV_DOOR_EVENT_TAMPER_ALARM                 = (NETDEV_DOOR_EVENT_BASE + 163),      /* 𱨾 */ 
    NETDEV_DOOR_EVENT_SWIPE_CARD_WHEN_NORMAL_OPEN  = (NETDEV_DOOR_EVENT_BASE + 164),      /* ʱˢ */ 
    NETDEV_DOOR_EVENT_OPEN_DOOR_BY_EMERGENCY_PWD   = (NETDEV_DOOR_EVENT_BASE + 165),      /* 뿪 */ 
    NETDEV_DOOR_EVENT_OPEN_DOOR_WHEN_NORMAL_OPEN   = (NETDEV_DOOR_EVENT_BASE + 166),      /* ʱο */ 
    NETDEV_DOOR_EVENT_EXIT_BUTTON_DURING_ILLEGAL_PERIOD  = (NETDEV_DOOR_EVENT_BASE + 167),/* ЧʱΰŰť */ 
    NETDEV_DOOR_EVENT_DOOR_ALREADY_OPEN            = (NETDEV_DOOR_EVENT_BASE + 168),      /* Ѵ */ 
    NETDEV_DOOR_EVENT_DOOR_ALREADY_CLOSE           = (NETDEV_DOOR_EVENT_BASE + 169),      /* ѹر */ 
    NETDEV_DOOR_EVENT_ILLEGAL_PERIOD               = (NETDEV_DOOR_EVENT_BASE + 170),      /* Ƿʱ */ 
    NETDEV_DOOR_EVENT_OPEN_DOOR_BY_DURESS_PWD      = (NETDEV_DOOR_EVENT_BASE + 171),      /* в뿪 */ 

    NETDEV_DOOR_EVENT_END                          = (NETDEV_DOOR_EVENT_BASE + 599),      /* Ž¼Ͷλ */

#define NETDEV_IS_DOOR_EVENT(x)    (NETDEV_DOOR_EVENT_BASE <= (x) && (x) < NETDEV_DOOR_EVENT_END)

}NETDEV_ALARM_SUBTYPE_E;

/**
 * @enum tagNETDEVEventResType
 * @brief ¼Դö öٶ
 * @attention  None
 */
typedef enum tagNETDEVEventResType
{
    NETDEV_EVENT_RES_TYPE_USER              = 0,                /* ûԴû߶Ӧ¼Ӧû */
    NETDEV_EVENT_RES_TYPE_DEVICE            = 1,                /* 豸ԴӦ豸 */
    NETDEV_EVENT_RES_TYPE_CHANNEL           = 2,                /* ͨԴӦͨ */
    NETDEV_EVENT_RES_TYPE_LOGOUT            = 3,                /* ǿû˳Ӧ¼ */
    NETDEV_EVENT_RES_TYPE_SEQUENCE          = 4,                /* ѲԴӦԴID */
    NETDEV_EVENT_RES_TYPE_EMAP_HOTPOT       = 5,                /* ӵͼȵԴӦԴID */
    NETDEV_EVENT_RES_TYPE_EMAP_HOTAREA      = 6,                /* ӵͼԴӦԴID */
    NETDEV_EVENT_RES_TYPE_EMAP_ALARM        = 7,                /* ӵͼ澯ԴӦԴID */
    NETDEV_EVENT_RES_TYPE_TIMETEMPLATE      = 8,                /* 澯Ԥģ壬ӦģID */
    NETDEV_EVENT_RES_TYPE_SYSRIGHT          = 9,                /* ϵͳȨԴӦû¼ */
    NETDEV_EVENT_RES_TYPE_DEVRIGHT          = 10,               /* 豸ȨԴӦͨ */
    NETDEV_EVENT_RES_TYPE_ORG               = 11,               /* ֯ԴӦ֯ */
    NETDEV_EVENT_RES_TYPE_ALARM_TASK        = 12,               /* ԴӦ */
    NETDEV_EVENT_RES_TYPE_SLAVE             = 13,               /* Դ(˱һ) */
    NETDEV_EVENT_RES_TYPE_TVWALL            = 14,               /* ǽԴӦǽID */
    NETDEV_EVENT_RES_TYPE_TVWALL_SCENE      = 15,               /* ǽԴӦǽID */
    NETDEV_EVENT_RES_TYPE_WND               = 16,               /* ǽԴӦID */
    NETDEV_EVENT_RES_TYPE_VIRTUAL_LED       = 17,               /* ǽLEDԴӦLED ID */
    NETDEV_EVENT_RES_TYPE_BROADCAST_CHANGE  = 18,               /* 㲥Ϣ(ֵ˱һ) */
    NETDEV_EVENT_RES_TYPE_LOGIC_ORG         = 19,               /* ֯ԴӦ֯ţɾ֯ͨʱʹ */
    NETDEV_EVENT_RES_TYPE_USER_ROLE         = 20,               /* ûɫԴӦû¼*/
    NETDEV_EVENT_RES_TYPE_ROLE_ORG          = 21,               /* ɫ֯չʾԴӦû¼ */
    NETDEV_EVENT_RES_TYPE_EMAP_PIC          = 22,               /* ͼƬԴӦ */
    NETDEV_EVENT_RES_TYPE_PATROL            = 23,               /* ѲԴ */
    NETDEV_EVENT_RES_TYPE_RECORD            = 24,               /* ¼ƹ켣Դ */
    NETDEV_EVENT_RES_TYPE_ACS_PERSON        = 25,               /* ŽԱԴӦŽԱID */
    NETDEV_EVENT_RES_TYPE_ACS_PERSON_CARD   = 26,               /* ŽԴӦŽԱID */
    NETDEV_EVENT_RES_TYPE_TVWALL_LIST       = 27,               /* ǽбȨ޵ǽ */
    NETDEV_EVENT_RES_TYPE_TVWALL_SCENE_SWITCH = 28,             /* ǽл */

    NETDEV_EVENT_RES_TYPE_FACE_LIB          = 29,               /* ԴӦID */
    NETDEV_EVENT_RES_TYPE_FACE_CUSTOM       = 30,               /* ԶԣӦID */
    NETDEV_EVENT_RES_TYPE_FACE_MEMBER       = 31,               /* ԱԴӦID */
    NETDEV_EVENT_RES_TYPE_FACE_GUARD        = 32,               /* ԴӦID */
    NETDEV_EVENT_RES_TYPE_SMART_DETECT      = 33,               /* ܼԴӦܼͣʶ:0 */
    NETDEV_EVENT_RES_TYPE_MANUAL_STATUS     = 34,               /* ֶ¼״̬ */
    NETDEV_EVENT_RES_TYPE_VEHICLE_GUARD     = 38,               /* ƲԴӦƲID */
    NETDEV_EVENT_RES_TYPE_CDN_CHANNEL       = 39,               /* CDNͨԴϱӦϢͻյ¼ѯͨб */
    NETDEV_EVENT_RES_TYPE_FACE_MEMBER_SORT  = 40,               /* ԱԴӦID */
    NETDEV_EVENT_RES_TYPE_VEHICLE_LIB       = 41,               /* ԴӦID */
    NETDEV_EVENT_RES_TYPE_VEHICLE_MEMBER_SORT = 42,             /* ԱԴӦID */
    NETDEV_EVENT_RES_TYPE_VEHICLE_MEMBER      = 43,             /* ԱԴӦԱID */

    NETDEV_EVENT_RES_TYPE_REMAIN_PARK_SPACE = 44,               /* ͣʣ೵λԴ */
    NETDEV_EVENT_RES_TYPE_ABNORMAL_CHARGE   = 45,               /* 쳣շѹԴ */
    NETDEV_EVENT_RES_TYPE_PARK_RES_CHANGE   = 46,               /* ͣԴ */
    NETDEV_EVENT_RES_TYPE_SMART_COMMUNITY_PERSON   = 47,        /* ǻԱԴ */
    NETDEV_EVENT_RES_TYPE_SMART_COMMUNITY_CAR      = 48,        /* ǻԴ */
    NETDEV_EVENT_RES_TYPE_SMART_COMMUNITY_BUILDING = 49,        /* ǻ¥Դ */
    NETDEV_EVENT_RES_TYPE_SMART_COMMUNITY_UNIT     = 50,        /* ǻԪԴ */
    NETDEV_EVENT_RES_TYPE_SMART_COMMUNITY_ROOM     = 51,        /* ǻԴ */
    NETDEV_EVENT_RES_TYPE_SMART_COMMUNITY_ORG      = 52,        /* ǻ֯(С)Դ */
    NETDEV_EVENT_RES_TYPE_TEMP_VEHICLE_PAY_CHANGE = 53,         /* ʱɷϢ */
    NETDEV_EVENT_RES_TYPE_THIRDPART_PAYMENT       = 54,         /* ֧ͣԴ */
    NETDEV_EVENT_RES_TYPE_PAYMENT_WAIT            = 55,         /* ֧Уȴ */
    NETDEV_EVENT_RES_TYPE_ENTRANCE_LIST           = 56,         /* бȨ޵ */
    NETDEV_EVENT_RES_TYPE_VIEWPLAN_RES      = 57,               /* ͼƻӦƻID */
    NETDEV_EVENT_RES_TYPE_SCENESPLAN_RES    = 58,               /* ƻӦƻID */
    NETDEV_EVENT_RES_TYPE_ACS_PERMISSION    = 59,               /* ȨԴ,  ȨϢ*/
    NETDEV_EVENT_RES_TYPE_ACS_GROUP         = 60,               /* ŽȨԴŽȨ飨֯ı */
    NETDEV_EVENT_RES_TYPE_TVWALL_AUDIO      = 61,               /* Ƶ¼ */
    NETDEV_EVENT_RES_TYPE_PAYMENT_RRULE     = 62,               /* ֶշѹԴ  */
    NETDEV_EVENT_RES_TYPE_GIS               = 63,               /* ӵͼԴ */
    NETDEV_EVENT_RES_TYPE_INVALID           = 0xFF              /* Чֵ */
}NETDEV_EVENT_RES_TYPE_E;

/**
* @enum tagNETDEVRecordSearchType
* @brief λѯ¼ö٣LAPIӿĵ
*/
typedef enum tagNETDEVRecordSearchType
{
    NETDEV_RECORD_SEARCH_TYPE_ALL                    = 0x00000000,               /* ʱʹãȫ¼ */
    NETDEV_RECORD_SEARCH_TYPE_MANUL                  = 0x00000001,               /* ֶ¼ */
    NETDEV_RECORD_SEARCH_TYPE_EVENT                  = 0x00000002,               /* ͨ澯NVRݲ֧֣ */
    NETDEV_RECORD_SEARCH_TYPE_MOTION                 = 0x00000004,               /* ˶ */
    NETDEV_RECORD_SEARCH_TYPE_ALARMIN                = 0x00000008,               /* 뿪 */
    NETDEV_RECORD_SEARCH_TYPE_VIDEO_LOSS             = 0x00000010,               /* Ƶʧ */
    NETDEV_RECORD_SEARCH_TYPE_AUDIO_DETECT           = 0x00000020,               /* Ƶ */

    NETDEV_RECORD_SEARCH_TYPE_COMMON                 = 0x00000080,              /* ƻ¼(¼) */
    NETDEV_RECORD_SEARCH_TYPE_FACE_DETECT            = 0x00000100,              /*  */
    NETDEV_RECORD_SEARCH_TYPE_LINE_DETECT            = 0x00000200,              /* Խ */
    NETDEV_RECORD_SEARCH_TYPE_FIELD_DETECT           = 0x00000400,              /*  */
    NETDEV_RECORD_SEARCH_TYPE_FOCUS_DETECT           = 0x00000800,              /* 齹 */
    NETDEV_RECORD_SEARCH_TYPE_SCENE_CHANGE           = 0x00001000,              /*  */
    NETDEV_RECORD_SEARCH_TYPE_SMART_TRACK            = 0x00002000,              /* ˶¼ */

    NETDEV_RECORD_SEARCH_TYPE_URGENT_BELL            = 0x00004000,              /*  */
    NETDEV_RECORD_SEARCH_TYPE_REMAIN_ARTICLE         = 0x00020000,              /* Ʒ */
    NETDEV_RECORD_SEARCH_TYPE_MOVE_ARTICLE           = 0x00040000,              /* Ʒ */

    NETDEV_RECORD_SEARCH_TYPE_HUMAN_DETECT           = 0x00200000,              /* μ */
    NETDEV_RECORD_SEARCH_TYPE_SMART_RECORD           = 0x00263F20,              /* 澯  10 0110 0011 1111 0010 0000*/

    NETDEV_RECORD_SEARCH_TYPE_INVALID                = 0XFFFFFFFF             /* Чֵ */
}NETDEV_RECORD_SEARCH_TYPE_E;

/* IPַ */
typedef enum tagNETDEVAddressType
{
    NETDEV_ADDRESS_TYPE_IPV4                    = 0,               /* IPV4 */
    NETDEV_ADDRESS_TYPE_IPV6                    = 1,               /* IPV6 */
    NETDEV_ADDRESS_TYPE_DOMAIN                  = 2,               /*  */
    NETDEV_ADDRESS_TYPE_IPV4_IPV6               = 3,               /* IPV4IPV6 */

    NETDEV_ADDRESS_TYPE_INVALID                 = 0xFF             /* Чֵ */
}NETDEV_ADDRESS_TYPE_E;

/**
* @enum tagNETDEVVehicleMonitorType
* @brief  öٶ monitor type Enumeration definition
* @attention  None
*/
typedef enum tagNETDEVVehicleMonitorType
{
    NETDEV_VEHICLE_MONITOR_TYPE_ROB_E         = 0,           /*  */
    NETDEV_VEHICLE_MONITOR_TYPE_STEAL_E       = 1,           /*  */
    NETDEV_VEHICLE_MONITOR_TYPE_SUSPICION_E   = 2,           /* ɳ */
    NETDEV_VEHICLE_MONITOR_TYPE_ILLEGAL_E     = 3,           /* ͨΥ */
    NETDEV_VEHICLE_MONITOR_TYPE_SUREILLANCE_E = 4,           /* س */

    NETDEV_VEHICLE_MONITOR_TYPE_ALL_E         = 255,         /* вس */

    NETDEV_VEHICLE_MONITOR_TYPE_INVALID = 0xFFFF             /* Чֵ  Invalid value */
}NETDEV_VEHICLE_MONITOR_TYPE_E;

/**
* @enum tagNETDEVPlateColor
* @brief ɫ öٶ plate color Enumeration definition
* @attention  None
*/
typedef enum tagNETDEVPlateColor
{
    NETDEV_PLATE_COLOR_BLACK_E           = 0,           /* ɫ */
    NETDEV_PLATE_COLOR_WHITE_E           = 1,           /* ɫ */
    NETDEV_PLATE_COLOR_GRAY_E            = 2,           /* ɫ */
    NETDEV_PLATE_COLOR_RED_E             = 3,           /* ɫ */
    NETDEV_PLATE_COLOR_BLUE_E            = 4,           /* ɫ */
    NETDEV_PLATE_COLOR_YELLOW_E          = 5,           /* ɫ */
    NETDEV_PLATE_COLOR_ORANGE_E          = 6,           /* ɫ */
    NETDEV_PLATE_COLOR_BROWN_E           = 7,           /* ɫ */
    NETDEV_PLATE_COLOR_GREEN_E           = 8,           /* ɫ */
    NETDEV_PLATE_COLOR_PURPLE_E          = 9,           /* ɫ */
    NETDEV_PLATE_COLOR_CYAN_E            = 10,          /* ɫ */
    NETDEV_PLATE_COLOR_PINK_E            = 11,          /* ɫ */
    NETDEV_PLATE_COLOR_TRANSPARENT_E     = 12,          /* ͸ */
    NETDEV_PLATE_COLOR_SILVERYWHITE_E    = 13,          /*  */
    NETDEV_PLATE_COLOR_DARK_E            = 14,          /* ɫ */
    NETDEV_PLATE_COLOR_LIGHT_E           = 15,          /* ǳɫ */
    NETDEV_PLATE_COLOR_COLOURLESS        = 16,          /* ɫ */
    NETDEV_PLATE_COLOR_YELLOWGREEN       = 17,          /* ˫ɫ */
    NETDEV_PLATE_COLOR_GRADUALGREEN      = 18,          /* ɫ */
    NETDEV_PLATE_COLOR_OTHER_E           = 99,          /*  */
    NETDEV_PLATE_COLOR_UNKNOW_E          = 100,         /* δ֪ */
    NETDEV_PLATE_COLOR_INVALID           = 0xFF         /* Чֵ  Invalid value */
}NETDEV_PLATE_COLOR_E;

/**
* @enum tagNETDEVPlateType
* @brief  öٶ plate type Enumeration definition
* @attention  None
*/
typedef enum tagNETDEVPlateType
{
    NETDEV_PLATE_TYPE_BIG_CAR_E = 0,                     /*  */
    NETDEV_PLATE_TYPE_MINI_CAR_E = 1,                    /* С */
    NETDEV_PLATE_TYPE_EMBASSY_CAR_E = 2,                 /* ʹ */
    NETDEV_PLATE_TYPE_CONSULATE_CAR_E = 3,               /*  */
    NETDEV_PLATE_TYPE_OVERSEAS_CAR_E = 4,                /*  */
    NETDEV_PLATE_TYPE_FOREIGN_CAR_E = 5,                 /* ⼮ */
    NETDEV_PLATE_TYPE_COMMON_MOTORBIKE_E = 6,            /* ͨĦг */
    NETDEV_PLATE_TYPE_HANDINESS_MOTORBIKE_E = 7,         /* Ħг */
    NETDEV_PLATE_TYPE_EMBASSY_MOTORBIKE_E = 8,           /* ʹĦг */
    NETDEV_PLATE_TYPE_CONSULATE_MOTORBIKE_E = 9,         /* Ħг */
    NETDEV_PLATE_TYPE_OVERSEAS_MOTORBIKE_E = 10,         /* Ħг */
    NETDEV_PLATE_TYPE_FOREIGN_MOTORBIKE_E = 11,          /* ⼮Ħг */
    NETDEV_PLATE_TYPE_LOW_SPEED_CAR_E = 12,              /* ٳ */
    NETDEV_PLATE_TYPE_TRACTOR_E = 13,                    /*  */
    NETDEV_PLATE_TYPE_TRAILER_E = 14,                    /* ҳ */
    NETDEV_PLATE_TYPE_COACH_CAR_E = 15,                  /*  */
    NETDEV_PLATE_TYPE_COACH_MOTORBIKE_E = 16,            /* Ħг */
    NETDEV_PLATE_TYPE_TEMPORARY_ENTRY_CAR_E = 17,        /* ʱ뾳 */
    NETDEV_PLATE_TYPE_TEMPORARY_ENTRY_MOTORBIKE_E = 18,  /* ʱ뾳Ħг */
    NETDEV_PLATE_TYPE_TEMPORARY_DRIVING_E = 19,          /* ʱʻ */
    NETDEV_PLATE_TYPE_POLICE_CAR_E = 20,                 /*  */
    NETDEV_PLATE_TYPE_POLICE_MOTORBIKE_E = 21,           /* Ħг */
    NETDEV_PLATE_TYPE_AGRICULTURAL_E = 22,               /* ԭũ */
    NETDEV_PLATE_TYPE_HONGKONG_ENTRY_EXIT_E = 23,        /*  */
    NETDEV_PLATE_TYPE_MACAO_ENTRY_EXIT_E = 24,           /*  */
    NETDEV_PLATE_TYPE_ARMED_POLICE_E = 25,               /* 侯 */
    NETDEV_PLATE_TYPE_ARMY_E = 26,                       /* Ӻ */

    NETDEV_PLATE_TYPE_OTHER_E = 99,                      /*  */


    NETDEV_PLATE_TYPE_INVALID = 0xFF                     /* Чֵ  Invalid value */
}NETDEV_PLATE_TYPE_E;

/**
* @enum tagNETDEVVehicleColor
* @brief ɫ öٶ plate color Enumeration definition
* @attention  None
*/
typedef enum tagNETDEVVehicleColor
{
    NETDEV_VEHICLE_COLOR_BLACK_E          = 0,        /* ɫ */
    NETDEV_VEHICLE_COLOR_WHITE_E          = 1,        /* ɫ */
    NETDEV_VEHICLE_COLOR_GRAY_E           = 2,        /* ɫ */
    NETDEV_VEHICLE_COLOR_RED_E            = 3,        /* ɫ */
    NETDEV_VEHICLE_COLOR_BLUE_E           = 4,        /* ɫ */
    NETDEV_VEHICLE_COLOR_YELLOW_E         = 5,        /* ɫ */
    NETDEV_VEHICLE_COLOR_ORANGE_E         = 6,        /* ɫ */
    NETDEV_VEHICLE_COLOR_BROWN_E          = 7,        /* ɫ */
    NETDEV_VEHICLE_COLOR_GREEN_E          = 8,        /* ɫ */
    NETDEV_VEHICLE_COLOR_PURPLE_E         = 9,        /* ɫ */
    NETDEV_VEHICLE_COLOR_CYAN_E           = 10,       /* ɫ */
    NETDEV_VEHICLE_COLOR_PINK_E           = 11,       /* ɫ */
    NETDEV_VEHICLE_COLOR_TRANSPARENT_E    = 12,       /* ͸ */
    NETDEV_VEHICLE_COLOR_OTHER_E          = 99,       /*  */

    NETDEV_VEHICLE_COLOR_INVALID        = 0xFF      /* Чֵ  Invalid value */
}NETDEV_VEHICLE_COLOR_E;

/**
* @enum tagNETDEVVehicleType
* @brief  öٶ plate type Enumeration definition
* @attention  None
*/
typedef enum tagNETDEVVehicleType
{
    NETDEV_VEHICLE_TYPE_TRICYCLE_E       = 0,                /* ֳ */
    NETDEV_VEHICLE_TYPE_MOTOR_BUS_E      = 1,                /* ͳ */
    NETDEV_VEHICLE_TYPE_MIDDLE_E         = 2,                /* ͳ */
    NETDEV_VEHICLE_TYPE_SMALL_E          = 3,                /* Сͳ */
    NETDEV_VEHICLE_TYPE_BIG_E            = 4,                /* ͳ */
    NETDEV_VEHICLE_TYPE_TWOWHEELVEH      = 5,                /* ֳ */
    NETDEV_VEHICLE_TYPE_MOTORCYCLE_E     = 6,                /* Ħг */
    NETDEV_VEHICLE_TYPE_TRACTOR_E        = 7,                /*  */
    NETDEV_VEHICLE_TYPE_AGRICULTURAL_E   = 8,                /* ũû */
    NETDEV_VEHICLE_TYPE_SEADAN           = 9,                /* γ */
    NETDEV_VEHICLE_TYPE_SUV_E            = 10,               /* SUV */
    NETDEV_VEHICLE_TYPE_VAN_E            = 11,               /*  */
    NETDEV_VEHICLE_TYPE_SMALLTRUCK_E     = 12,               /* С */
    NETDEV_VEHICLE_TYPE_MEDIUMCAR_E      = 13,               /* аͳ/Ϳͳ */
    NETDEV_VEHICLE_TYPE_LARGEBUS_E       = 14,               /* ͳ/Ϳͳ */
    NETDEV_VEHICLE_TYPE_LARGETRUCK_E     = 15,               /* /ͻ */
    NETDEV_VEHICLE_TYPE_PICKUPTRUCK_E    = 16,               /* Ƥ */
    NETDEV_VEHICLE_TYPE_BUSINESSVEH_E    = 17,               /* MPV  */
    NETDEV_VEHICLE_TYPE_SPORTSCAR_E      = 18,               /* ܳ */
    NETDEV_VEHICLE_TYPE_MINICAR_E        = 19,               /* ΢ͽγ */
    NETDEV_VEHICLE_TYPE_HATCHBACKCAR_E   = 20,               /* γ */
    NETDEV_VEHICLE_TYPE_THREEBOX_E       = 21,               /* γ */
    NETDEV_VEHICLE_TYPE_LIGHTBUS_E       = 22,               /* Ϳͳ */
    NETDEV_VEHICLE_TYPE_MEDIUNTRUCK_E    = 23,               /* ͻ */
    NETDEV_VEHICLE_TYPE_TRAILER_E        = 24,               /* ҳ */
    NETDEV_VEHICLE_TYPE_TANK_E           = 25,               /* ۹޳ */
    NETDEV_VEHICLE_TYPE_WATERCAR_E       = 26,               /* ˮ */
    NETDEV_VEHICLE_TYPE_OTHER_E          = 998,              /*  */
    NETDEV_VEHICLE_TYPE_UNKNOW_E         = 999,              /* δ֪ */
    NETDEV_VEHICLE_TYPE_INDISTINGUISH_E  = 1000,             /* ֳ */
    NETDEV_VEHICLE_TYPE_INVALID          = 0xFFFF            /* Чֵ  Invalid value */
}NETDEV_VEHICLE_TYPE_E;


/**
* @enum tagNETDEVVehicleSpeedUnit
* @brief ٶȵλ öٶ vehicle speed unit Enumeration definition
* @attention  None
*/
typedef enum tagNETDEVVehicleSpeedUnit
{
    NETDEV_VEHICLE_SPEED_UNIT_KPH_E = 0,                /* /ÿСʱ */
    NETDEV_VEHICLE_SPEED_UNIT_MPH_E = 1,                /* Ӣ/ÿСʱ */

    NETDEV_VEHICLE_SPEED_UNIT_INVALID = 0xFF            /* Чֵ  Invalid value */
}NETDEV_VEHICLE_SPEED_UNIT_E;


/**
 * @enum tagNETDEVAlarmType
 * @brief  澯 öٶ Alarm Type Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVAlarmTypeLAPI
{
/*               IPC&VMS                                           */
  NETDEV_MOTION_ALARM_ON                        = 0,    /* ˶澯 */
  NETDEV_MOTION_ALARM_OFF                       = 1,    /* ˶澯ָ */
  NETDEV_MASK_IMAGE_ALARM_ON                    = 2,    /* ڵ澯 */
  NETDEV_MASK_IMAGE_ALARM_OFF                   = 3,    /* ڵ澯ָ */
  NETDEV_ABNORMAL_AUDIO_ON                      = 4,    /* Ƶ쳣澯 */
  NETDEV_ABNORMAL_AUDIO_OFF                     = 5,    /* Ƶ쳣澯ָ */
  NETDEV_LINE_DETECTOR_CROSSED                  = 6,    /* Խ澯 */
  NETDEV_FIELD_DETECTOR_OBJECTS_INSIDE          = 7,    /*  */
  NETDEV_OBJECT_IS_RECOGNIZED                   = 8,    /* ʶ */
  NETDEV_GLOBAL_SCENE_CHANGE                    = 9,    /*  */
  NETDEV_IMAGE_TOO_BLURRY_ON                    = 10,   /* ͼ齹 */
  NETDEV_IMAGE_TOO_BLURRY_OFF                   = 11,   /* ͼ齹澯ָ */
  NETDEV_INPUT_ALARM_ON                         = 12,   /* 뿪澯 */
  NETDEV_INPUT_ALARM_OFF                        = 13,   /* 뿪澯ָ */

  NETDEV_ENTER_AREA                             = 100,  /*  */
  NETDEV_LEAVE_AREA                             = 101,  /* 뿪 */
  NETDEV_LOITERING                              = 102,  /* ǻ */
  NETDEV_FENCE_CROSSING                         = 103,  /* ԽΧ */
  NETDEV_OBJECT_REMOVED                         = 104,  /* Ʒ */
  NETDEV_OBJECT_LEFT_BEHIND                     = 105,  /* Ʒ */
  NETDEV_PEOPLE_GATHERING                       = 106,  /* Աۼ */
  NETDEV_PEOPLE_GATHERING_CLEARED               = 107,  /* Աۼָ */
  NETDEV_FAST_MOVING                            = 108,  /* ƶ */
  NETDEV_PARKING                                = 109,  /* ͣ */
  NETDEV_HEAT_MAP                               = 110,  /* ȶͼ */
  NETDEV_AUTO_SMART_TRACK_ON                    = 111,  /* ܸٸ澯 */
  NETDEV_AUTO_SMART_TRACK_OFF                   = 112,  /* ܸٸ澯ָ */

  NETDEV_DISK_OFFLINE                           = 201,  /* ߸澯 */
  NETDEV_DISK_ABNORMAL                          = 202,  /* ̴쳣澯 */
  NETDEV_ILLEGAL_LOGIN                          = 203,  /* Ƿ */
  NETDEV_NETWORK_DISCONNECTED                   = 204,  /* Ͽ쳣澯 */
  NETDEV_NETWORK_DISCONNECTED_CLEARED           = 205,  /* Ͽָ澯 */
  NETDEV_IP_CONFLICT                            = 206,  /* IPͻ쳣澯 */
  NETDEV_IP_CONFLICT_CLEARED                    = 207,  /* IPͻ쳣澯ָ */
  NETDEV_STORAGE_FAILURE                        = 208,  /* 洢澯 */
  NETDEV_RUNNING_OUT_OF_RECORDING_SPACE         = 209,  /* 洢澯 */
  NETDEV_RECORDING_SAPCE_USED_UP                = 210,  /* 洢澯 */
  NETDEV_DEVICE_ONLINE                          = 211,  /* 豸߸澯 */
  NETDEV_DEVICE_OFFLINE                         = 212,  /* 豸߸澯 */
  NETDEV_RAID_DISABLED                          = 213,  /* 𻵸澯 */
  NETDEV_DISK_ONLINE                            = 214,  /* ߸澯 */
  NETDEV_RAID_DEGRADED                          = 215,  /* ˥˸澯 */
  NETDEV_RAID_RECOVERED                         = 216,  /* лָ */
  NETDEV_MANUAL_ALARM                           = 217,  /* ֶ澯 */
  NETDEV_VIDEO_LOSS_ALARM_ON                    = 218,  /* Ƶʧ澯 */
  NETDEV_VIDEO_LOSS_ALARM_OFF                   = 219,  /* Ƶʧ澯ָ */
  NETDEV_SCHEDULED_RECORDING_FAILURE            = 220,  /* δƻ洢 */
  NETDEV_SCHEDULED_RECORDING_FAILURE_CLEARED    = 221,  /* δƻ洢ָ */
  NETDEV_IPC_ONLINE                             = 222,  /*  */
  NETDEV_IPC_OFFLINE                            = 223,  /*  */
  NETDEV_CHANNEL_DELETED                        = 224,  /* ɾ*/
  NETDEV_CONTROL_PANEL_ALARM                    = 225,  /* 澯澯 */
  NETDEV_ACCESS_CONTROL_ALARM                   = 226,  /* Ž澯 */

  /* SmartϢ */
  NETDEV_SMART_READ_ERROR_RATE                  = 227,  /* ײݶȡ */
  NETDEV_SMART_SPIN_UP_TIME                     = 228,  /*  ʱ  */
  NETDEV_SMART_START_STOP_COUNT                 = 229,  /* ͣ */
  NETDEV_SMART_REALLOCATED_SECTOR_COUNT         = 230,  /* ӳ  */
  NETDEV_SMART_SEEK_ERROR_RATE                  = 231,  /* Ѱ */
  NETDEV_SMART_POWER_ON_HOURS                   = 232,  /* ͨʱۼƣͨʱ䣬һСʱ */
  NETDEV_SMART_SPIN_RETRY_COUNT                 = 233,  /* Դ */
  NETDEV_SMART_CALIBRATION_RETRY_COUNT          = 234,  /* ͷУ׼Լ */
  NETDEV_SMART_POWER_CYCLE_COUNT                = 235,  /* ͨڼ */
  NETDEV_SMART_POWEROFF_RETRACT_COUNT           = 236,  /* ϵ緵ؼ */
  NETDEV_SMART_LOAD_CYCLE_COUNT                 = 237,  /* ͷؼ */
  NETDEV_SMART_TEMPERATURE_CELSIUS              = 238,  /* ¶ */
  NETDEV_SMART_REALLOCATED_EVENT_COUNT          = 239,  /* ӳ¼ */
  NETDEV_SMART_CURRENT_PENDING_SECTOR           = 240,  /* ǰӳ */
  NETDEV_SMART_OFFLINE_UNCORRECTABLE            = 241,  /* ѻ޷У */
  NETDEV_SMART_UDMA_CRC_ERROR_COUNT             = 242,  /* żУ  */
  NETDEV_SMART_MULTI_ZONE_ERROR_RATE            = 243,  /*  */

  NETDEV_SMART_FACE_NOT_MATCH_ALARM             = 244,  /* Աʧ */
  NETDEV_SMART_FACE_MATCH_ALARM                 = 245,  /* Աȳɹ */

  NETDEV_DEVICE_HIGHTEMP_ALARM                  = 246,  /* 쳣ࣺ豸 */
  NETDEV_DEVICE_LOWTEMP_ALARM                   = 247,  /* 쳣ࣺ豸 */
  NETDEV_FAN_FAULT_ALARM                        = 248,  /* 쳣ࣺȹ */
  NETDEV_LEDBOX_HIGHTEMP_ALARM                  = 249,  /* 쳣ࣺ */
  NETDEV_LEDBOX_SMOKE_ALARM                     = 250,  /* 쳣ࣺ澯 */
  NETDEV_DEVICE_HIGHTEMP_RECOVER_ALARM          = 251,  /* 쳣:豸¶Ȼָ */
  NETDEV_DEVICE_LOWTEMP_RECOVER                 = 252,  /* 쳣:豸¶Ȼָ */
  NETDEV_FAN_FAULT_RECOVER                      = 253,  /* 쳣:ȹϻָ */
  NETDEV_LEDBOX_HIGHTEMP_RECOVER                = 254,  /* 쳣:»ָ */
  NETDEV_LEDBOX_SMOKE_RECOVER                   = 255,  /* 쳣:澯ָ */

  NETDEV_UNKOWN_TYPE_ALARM                      =0xFFFF /* δ֪澯 */

}NETDEV_ALARM_TYPE_LAPI_E;

/**
* @enum tagNETDEVVideoCodeMode
* @brief Ƶģʽ öٶ  Video encoding Mode Enumeration definition
* @attention  None
*/
typedef enum tagNETDEVVideoCodeMode
{
    NETDEV_VIDEO_CODE_MODE_CBR = 0,             /* 㶨 */
    NETDEV_VIDEO_CODE_MODE_VBR = 1              /* ɱ */
}NETDEV_VIDEO_CODE_MODE_E;

/**
* @enum tagNETDEVRecordPlanEnable
* @brief NVR ¼ƻʹ öٶ   NVR Record Plan Enable Enumeration definition
* @attention  None
*/
typedef enum tagNETDEVRecordPlanEnable
{
    NETDEV_RECORD_Plan_DISABLE = 0,             /* ʹ */
    NETDEV_RECORD_Plan_ENABLE = 1               /* ʹ */
}NETDEV_RECORD_Plan_ENABLE_E;

/**
* @enum tagNETDEVRedundantStorage
* @brief NVR 洢ƻʹ öٶ   NVR Redundant Storage Plan Enable Enumeration definition
* @attention  None
*/
typedef enum tagNETDEVRedundantStorage
{
    NETDEV_REDUNDANT_STORAGE_DISABLE = 0,             /* ʹ */
    NETDEV_REDUNDANT_STORAGE_ENABLE = 1               /* ʹ */
}NETDEV_REDUNDANT_STORAGE_ENABLE_E; 

/**
* @enum tagResolution
* @brief ֱ
* @attention  Ҫ player_sdk_func.hе PLAYER_DECODE_RESOLUTION_E һһӦ 
*/
typedef enum tagNETDEVMemResolution
{
    NETDEV_MEM_RESOLUTION_CIF       = 0,                        /* CIF */
    NETDEV_MEM_RESOLUTION_2CIF      = 1,                        /* 2CIF */
    NETDEV_MEM_RESOLUTION_D1        = 2,                        /* D1 */
    NETDEV_MEM_RESOLUTION_720P      = 3,                        /* 720P */
    NETDEV_MEM_RESOLUTION_1080P     = 4,                        /* 1080P */
    NETDEV_MEM_RESOLUTION_4M        = 5,                        /* 4M */
    NETDEV_MEM_RESOLUTION_8M        = 6,                        /* 8M */
    NETDEV_MEM_RESOLUTION_12M       = 7,                        /* 12M */
    NETDEV_MEM_RESOLUTION_MAX
}NETDEV_MEM_RESOLUTION_E;

/**
* @enum tagDecodePayload
* @brief ֱ
* @attention Ҫ player_sdk_func.hе PLAYER_DECODE_PAYLOAD_E һһӦ 
*/
typedef enum tagNETDEVMemPayload
{
    NETDEV_MEM_PAYLOAD_H264         = 0,                           /* H264 */
    NETDEV_MEM_PAYLOAD_H265         = 1,                           /* H265 */
    NETDEV_MEM_PAYLOAD_INVALID      = 0xff
}NETDEV_MEM_PAYLOAD_E;


/**
 * @enum tagNETDEVPLanStoreType
 * @brief ¼洢 öٶ Recording storage type Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVPLanStoreType
{
    NETDEV_STORE_TYPE_COMMON                        = 0,                /* 洢 */  
    NETDEV_STORE_TYPE_DIGITIALINPUT                 = 1,                /* 澯洢 */
    NETDEV_STORE_TYPE_MANUL                         = 2,                /* ֶ洢 */
    NETDEV_STORE_TYPE_AUDIODETECT                   = 3,                /* Ƶ澯洢 */
    NETDEV_STORE_TYPE_MOTION                        = 4,                /* ˶澯洢 */
    NETDEV_STORE_TYPE_DIGITALINPUT                  = 5,                /* ¼洢  Digital input */
    NETDEV_STORE_TYPE_FACEDETECT                    = 6,                /* 澯洢 */
    NETDEV_STORE_TYPE_VIDEO_LOSS                    = 7,                /* Ƶʧ洢 */
    NETDEV_STORE_TYPE_LINEDETECT                    = 8,                /* Խ澯洢 */
    NETDEV_STORE_TYPE_FIELDDETECT                   = 9,                /* ּ澯洢 */
    NETDEV_STORE_TYPE_FOCUSDETECT                   = 10,               /* ͼ齹澯洢 */
    NETDEV_STORE_TYPE_SCENECHANGE                   = 11,               /* 澯洢 */
    NETDEV_STORE_TYPE_ALARM                         = 12,               /* 澯 */
    NETDEV_STORE_TYPE_ALARM_AND_MOTION              = 13,               /* ˶  澯 */
    NETDEV_STORE_TYPE_ALARM_OR_MOTION               = 14,               /* ˶  澯 */
    NETDEV_STORE_TYPE_CAMERA_DISCONNECT             = 15,               /* ص */
    NETDEV_STORE_TYPE_THIRD_STREAM                  = 16,               /* 洢 */
    NETDEV_STORE_TYPE_EVENT_ALL_ALARM               = 17,               /* ¼¼񣬰и澯 */
    NETDEV_STORE_TYPE_EVENT_ALL_TYPE                = 18,               /* ¼¼񣬰¼ */
    NETDEV_PLAN_STORE_TYPE_EVENT_WITHOUT_RESUME     = 19,               /* ûлָ¼ʹ洢 */
    NETDEV_STORE_TYPE_SMART_TRACK                   = 20,               /* ܸ */
    NETDEV_STORE_TYPE_URGENT_BELL                   = 21,               /*  */
    NETDEV_STORE_TYPE_REMAIN_ARTICLE                = 22,               /* Ʒ */
    NETDEV_STORE_TYPE_MOVE_ARTICLE                  = 23,               /* Ʒ */
    NETDEV_STORE_TYPE_SMART_RECORD                  = 24,               /* 澯 */
    NETDEV_PLAN_STORE_TYPE_MAX                      = 25,               /* 洢ֵ */
    NETDEV_STORE_TYPE_HUMAN_DETECT                  = 26,               /* μ */

    NETDEV_STORE_TYPE_INVALID                       = 0xFF              /* Чֵ */
}NETDEV_STORE_TYPE_E;

/**
* @struct tagSysType
* @brief ϵͳ͡
* @attention Ҫ player_sdk_func.hе PLAYER_DECODE_SYSTYPE_E һһӦ 
*/
typedef enum tagNETDEVMenSystem
{
    NETDEV_SYSTEM_WIN7      = 0,                    /* WIN7 */
    NETDEV_SYSTEM_WIN8      = 1,                    /* WIN8 */
    NETDEV_SYSTEM_WIN10     = 2                     /* WIN10 */
}NETDEV_MEM_SYSTEM_E;

/**
* @enum tagNETDEVEventStoreType
* @brief ¼¼洢 öٶ
* @attention öʱעȫֱgaRecordType
*/
typedef enum tagNETDEVEventStoreType
{
    NETDEV_EVENT_STORE_FIND_TYPE_NORMAL             = 1,      /* 洢 */
    NETDEV_EVENT_STORE_FIND_TYPE_MOTIONDETEC        = 2,      /* ˶澯洢 */
    NETDEV_EVENT_STORE_FIND_TYPE_DIGITIALINPUT      = 3,      /* 澯洢 */
    NETDEV_EVENT_STORE_FIND_TYPE_MANUAL             = 4,      /* ֶ洢 */
    NETDEV_EVENT_STORE_FIND_TYPE_SIGNALLOSS         = 5,      /* Ƶʧ洢 */
    NETDEV_EVENT_STORE_FIND_TYPE_AUDIODETECT        = 6,      /* Ƶ澯洢 */
    NETDEV_EVENT_STORE_FIND_TYPE_FACEDETECT         = 7,      /* 澯洢 */
    NETDEV_EVENT_STORE_FIND_TYPE_LINEDETECT         = 8,      /* Խ澯洢 */
    NETDEV_EVENT_STORE_FIND_TYPE_FIELDDETECT        = 9,      /* ּ澯洢 */
    NETDEV_EVENT_STORE_FIND_TYPE_FOCUSDETECT        = 10,     /* ͼ齹澯洢 */
    NETDEV_EVENT_STORE_FIND_TYPE_SCENECHANGE        = 11,     /* 澯洢 */
    NETDEV_EVENT_STORE_FIND_TYPE_SMARTTRACK         = 12,     /* ܸٸ澯洢 */
    NETDEV_EVENT_STORE_FIND_TYPE_REMAIN_ARTICLE     = 13,     /* Ʒ澯洢 */
    NETDEV_EVENT_STORE_FIND_TYPE_ARTICLE_MOVE       = 14,     /* ƷƸ澯洢 */

    NETDEV_EVENT_STORE_FIND_TYPE_BUTT
}NETDEV_EVENT_STORE_TYPE_E;

/**
* @enum tagNETDEVSmartStoreType
* @brief ¼¼洢 öٶ
* @attention öֵܹNETDEV_EVENT_STORE_TYPE_Eеöظ
*/
typedef enum tagNETDEVSmartStoreType
{
    NETDEV_SMART_STORE_FIND_TYPE_MOTIONSMART      = 100,   /* ˶ݴ洢 */
    NETDEV_SMART_STORE_FIND_TYPE_BUTT
}NETDEV_SMART_STORE_TYPE_E;


/**
* @enum tagNETDEVEventFindLogic
* @brief ¼¼澯ѯ öٶ
* @attention  None
*/
typedef enum tagNETDEVEventFindLogic
{
    NETDEV_EVENT_FIND_LOGIC_AND = 0,     /* ߼ */
    NETDEV_EVENT_FIND_LOGIC_OR  = 1,     /* ߼ */
    NETDEV_EVENT_FIND_LOGIC_BUTT
}NETDEV_EVENT_FIND_LOGIC_E;



/**
* @enum tagNETDEVTransportModeType
* @brief ģʽ öٶ
* @attention 
*/
typedef enum tagNETDEVTransportModeType
{
    NETDEV_TRANSPROTOCAL_RTP_UNICAST    = 0,
    NETDEV_TRANSPROTOCAL_RTP_MULTICAST  = 1,
    NETDEV_TRANSPROTOCAL_RTP_STORE      = 2

}NETDEV_TRANSPORTMODE_E;

/**
* @enum tagNETDEVAudioFlag
* @brief Ƶ öٶ Audio data type Enumeration definition
* @attention  None
*/
typedef enum tagNETDEVAudioFlag
{
    NETDEV_AUDIO_LOCAL_GATHERED = 0,               /* زɼ  Locally collected data*/
    NETDEV_AUDIO_DEVICE_SEND    = 1                /* 豸͹  Audio data sent from device */
} NETDEV_AUDIO_FLAG_E;

/**
* @enum tagNETDEVEventTypeMajor
* @brief ¼ öٶ Major types of event Enumeration definition
* @attention  None
*/
typedef enum tagNETDEVEventTypeMajor
{
    NETDEV_EVENT_TYPE_MAJOR_ALARM      = 0,          /* 澯 ¼ COREģCORE澯ģ鶩 */
    NETDEV_EVENT_TYPE_MAJOR_SYS        = 1,          /* ϵͳ¼ */
    NETDEV_EVENT_TYPE_MAJOR_PERI_WARN  = 2,          /* ¼ CORE澯ģ鵥 */
    NETDEV_EVENT_TYPE_MAJOR_MEDIA      = 3,          /* ý崦¼ */
    NETDEV_EVENT_TYPE_MAJOR_BUTT
}NETDEV_EVENT_TYPE_MAJOR_E;

/**
* @enum tagNETDEVDecPaneNum
* @brief DCַ֧ 
* @attention DC&&XWö None
*/
typedef enum tagNETDEVDecPaneNum
{
    NETDEV_DEC_PANE_ONE             = 1,                /* 1 */
    NETDEV_DEC_PANE_TWO             = 2,                /* 2 */
    NETDEV_DEC_PANE_THREE           = 3,                /* 3 */
    NETDEV_DEC_PANE_FOUR            = 4,                /* 4 */
    NETDEV_DEC_PANE_FIVE            = 5,                /* 5 */
    NETDEV_DEC_PANE_SIX             = 6,                /* 6 */
    NETDEV_DEC_PANE_SEVEN           = 7,                /* 7 */
    NETDEV_DEC_PANE_EIGHT           = 8,                /* 8 */
    NETDEV_DEC_PANE_NINE            = 9,                /* 9 */
    NETDEV_DEC_PANE_SIXTEEN         = 16,               /* 16 */
    NETDEV_DEC_PANE_TWENTYFIVE      = 25,               /* 25 */
    NETDEV_DEC_PANE_THIRTYSIX       = 36,               /* 36 */
    NETDEV_DEC_PANE_SIXTYFOUR       = 64,               /* 64 */

    NETDEV_DEC_PANE_INVALID         = 0xffff
}NETDEV_PANE_NUM_E;


/**
 * @enum tagNETDEVOSDTextType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVOSDTextType
{
    NETDEV_OSD_TEXT_DATAANDTIME = 0,            /* .ʱ, yyyy-MM-dd.HH:mm:ss, ڸʽμ#NETDEV_OSD_DATE_FORMAT_CAP_E, ʱʽμ#NETDEV_OSD_TIME_FORMAT_CAP_E */
    NETDEV_OSD_TEXT_PLAIN
}NETDEV_OSD_TEXT_TYPE_E;


/**
 * @enum tagNETDEVAlarmPortType
 * @brief 澯˿
 * @attention  None
 */
typedef enum tagNETDEVAlarmPortType
{
    NETDEV_ALARM_PORT_TYPE_LOCAL = 0,            /* ؼ˿ */
    NETDEV_ALARM_PORT_TYPE_NAT = 1               /* ˿ӳ¼˿ */
}NETDEV_ALARM_PORT_TYPE_E;



/**
* @enum tagNETDEVFaceAnalysisSkill
* @brief  öٶ
* @attention 
*/
typedef enum tagNETDEVFaceAnalysisSkill
{
    NETDEV_FACE_ANALYSIS_SKILL_AGE                 = 0,            /*  */
    NETDEV_FACE_ANALYSIS_SKILL_GENGER              = 1,            /* Ա */
    NETDEV_FACE_ANALYSIS_SKILL_RACE                = 2,            /*  */
    NETDEV_FACE_ANALYSIS_SKILL_GLASSES             = 3,            /* ۾ */
    NETDEV_FACE_ANALYSIS_SKILL_MASK                = 4,            /*  */
    NETDEV_FACE_ANALYSIS_SKILL_MUSTACHE            = 5,            /*  */
    NETDEV_FACE_ANALYSIS_SKILL_HAT                 = 6,            /* ñ */
    NETDEV_FACE_ANALYSIS_SKILL_HAIRSTYLE           = 7,            /*  */
    NETDEV_FACE_ANALYSIS_SKILL_EXPRESSION          = 8,            /*  */
    NETDEV_FACE_ANALYSIS_SKILL_FACE                = 9             /* ֵ */
}NETDEV_FACE_ANALYSIS_SKILL_E;

/**
* @enum tagNETDEVFaceRecognitionType
* @brief ʶ öٶ
* @attention 
*/
typedef enum tagNETDEVFaceRecognitionType
{
    NETDEV_FACE_RECOGNITION_TYPE_FRONT              = 0,            /* ǰʶ */
    NETDEV_FACE_RECOGNITION_TYPE_CENTER             = 1            /* ʶ */

}NETDEV_FACE_RECOGNITION_TYPE_E;



/**
* @enum tagNETDEVObjTracktModeType
* @brief ģʽ öٶ
* @attention 
*/
typedef enum tagNETDEVObjTracktModeType
{
    NETDEV_OBJ_TRACK_MODE_FULLVIEW  = 1,                /* ȫģʽ */
    NETDEV_OBJ_TRACK_MODE_CRUISE    = 2                /* Ѳ */
}NETDEV_OBJ_TRACK_MODE_E;


/* ״̬ */
typedef enum tagNETDEVDeviceUpgradeStatus
{
    NETDEV_UPGRADE_STATUS_INITING        = 0,       /* ʼ */
    NETDEV_UPGRADE_STATUS_QUERYING       = 1,       /* ѯ */
    NETDEV_UPGRADE_STATUS_DOWNLOADING    = 2,       /*  */
    NETDEV_UPGRADE_STATUS_TRANSMITTING   = 3,       /*  */
    NETDEV_UPGRADE_STATUS_UPGRATING      = 4,       /*  */
    NETDEV_UPGRADE_STATUS_UPGRATEERROR   = 5,       /*  */
    NETDEV_UPGRADE_STATUS_NEWEST         = 6,       /* °汾 */
    NETDEV_UPGRADE_STATUS_HAVEHIGHTER    = 7,       /* и߰汾 */
    NETDEV_UPGRADE_STATUS_UPGRADEOVER    = 8,       /*  */
    NETDEV_UPGRADE_STATUS_GETSTATUSFAIL  = 9,       /* ȡʧ */
    NETDEV_UPGRADE_STATUS_NOTMATCH       = 10,      /* 汾ƥ */
    NETDEV_UPGRADE_STATUS_NOTMUTIPROCESS = 11,      /* ͬʱض */
    NETDEV_UPGRADE_STATUS_UPGRADETIMEOUT = 12,      /* ȡȳʱ*/
    NETDEV_UPGRADE_STATUS_BUTT
}NETDEV_UPGRADE_STATUS_E;

/* ״̬ */
typedef enum tagNETDEVUpgradeType
{
    NETDEV_UPGRADE_TYPE_CLOUD    = 1,               /*  */
    NETDEV_UPGRADE_TYPE_UDISK    = 2,               /* U */
    NETDEV_UPGRADE_TYPE_LOCAL    = 3,               /*  */
    NETDEV_UPGRADE_TYPE_BUTT
}NETDEV_UPGRADE_TYPE_E;



/* Ƶʽö */
typedef enum tagNETDEVAudioEncodeFormatType
{
    NETDEV_AUDIO_ENCODE_FORMAT_TYPE_MPEG1           = 0,       /* MPEG1 */
    NETDEV_AUDIO_ENCODE_FORMAT_TYPE_G711A           = 1,       /* G.711A */
    NETDEV_AUDIO_ENCODE_FORMAT_TYPE_G711U           = 2,       /* G.711U */
    NETDEV_AUDIO_ENCODE_FORMAT_TYPE_ADPCM           = 3,       /* ADPCM */
    NETDEV_AUDIO_ENCODE_FORMAT_TYPE_OGG             = 4,       /* OGG */
    NETDEV_AUDIO_ENCODE_FORMAT_TYPE_Auto            = 5,       /* Auto */
    NETDEV_AUDIO_ENCODE_FORMAT_TYPE_AACLC           = 6,       /* AAC-LC */
    NETDEV_AUDIO_ENCODE_FORMAT_TYPE_INVALID         = 0xFF     /* Чֵ */
}NETDEV_AUDIO_ENCODE_FORMAT_TYPE_E;

/* Ƶö */
typedef enum tagNETDEVAudioSamplingRate
{
    NETDEV_AUDIO_SAMPLING_RATE_8KHZ             = 0,       /* 8KHz */
    NETDEV_AUDIO_SAMPLING_RATE_16KHZ            = 1,       /* 16KHZ */
    NETDEV_AUDIO_SAMPLING_RATE_22_05KHZ         = 2,       /* 22.05KHZ */
    NETDEV_AUDIO_SAMPLING_RATE_24KHZ            = 3,       /* 24KHZ */
    NETDEV_AUDIO_SAMPLING_RATE_32KHZ            = 4,       /* 32KHZ */
    NETDEV_AUDIO_SAMPLING_RATE_44_1KHZ          = 5,       /* 44.1KHZ */
    NETDEV_AUDIO_SAMPLING_RATE_48KHZ            = 6,       /* 48KHZ */
    NETDEV_AUDIO_SAMPLING_RATE_96KHZ            = 7,       /* 96KHZ */
    NETDEV_AUDIO_SAMPLING_RATE_INVALID          = 0xFF     /* Чֵ */
}NETDEV_AUDIO_SAMPLING_RATE_E;

/* Ƶģʽö */
typedef enum tagNETDEVAudioInChlMode
{
    NETDEV_AUDIO_CHL_MODE_LINE              = 0,        /* LINE */
    NETDEV_AUDIO_CHL_MODE_MIC               = 1,        /*  MIC */
    NETDEV_AUDIO_CHL_MODE_RS485             = 2,        /* RS485ʰ */
    NETDEV_AUDIO_CHL_MODE_INVALID           = 0xFF      /* Чֵ */
}NETDEV_AUDIO_CHL_MODE_E;

/* Ƶɼö */
typedef enum tagNETDEVAudioCollectionPortType
{
    NETDEV_AUDIO_COLLECTION_PORT_TYPE_AUDIO_IN              = 0,        /* Ƶ */
    NETDEV_AUDIO_COLLECTION_PORT_TYPE_SERIAL_IN             = 1,        /*  */
    NETDEV_AUDIO_COLLECTION_PORT_TYPE_INVALID               = 0xFF      /* Чֵ */
}NETDEV_AUDIO_COLLECTION_PORT_TYPE_E;


/**
 * @enum tagNETDEVWeekPlanEvent
 * @brief ܼƻ¼ö
 * @attention  None
 */
typedef enum tagNETDEVWeekPlanEvent
{
    NETDEV_WEEK_PLAN_EVENT_MOTION_DETECT    = 1,               /* ˶ */
    NETDEV_WEEK_PLAN_EVENT_AUDIO_DETECT     = 2,               /*  */
    NETDEV_WEEK_PLAN_EVENT_TAMPER_DETECT    = 3,               /* ڵ */
    NETDEV_WEEK_PLAN_EVENT_INPUT_SWITCH     = 4,               /*  */
    NETDEV_WEEK_PLAN_EVENT_OUTPUT_SWITCH    = 5,               /*  */
    NETDEV_WEEK_PLAN_EVENT_CROSS_LINE       = 6,               /* Խ */
    NETDEV_WEEK_PLAN_EVENT_INTROSION_ZONE   = 7,               /*  */
    NETDEV_WEEK_PLAN_EVENT_ACCESS_ZONE      = 8,               /*  */
    NETDEV_WEEK_PLAN_EVENT_LEAVE_ZONE       = 9,               /* 뿪 */
    NETDEV_WEEK_PLAN_EVENT_HOVER_ZONE       = 10,              /* ǻ */
    NETDEV_WEEK_PLAN_EVENT_CARE_ARTICLE     = 11,              /* Ʒ */
    NETDEV_WEEK_PLAN_EVENT_REMAIN_ARTICLE   = 12,              /* Ʒ */
    NETDEV_WEEK_PLAN_EVENT_GATHER           = 13,              /* Աۼ */
    NETDEV_WEEK_PLAN_EVENT_FASTMOVE         = 14,              /* ƶ */
    NETDEV_WEEK_PLAN_EVENT_CAR_STOP         = 15,              /* ͣ */
    NETDEV_WEEK_PLAN_EVENT_OUT_FOCUS        = 16,              /* 齹 */
    NETDEV_WEEK_PLAN_EVENT_SCENCECHANGE     = 17,              /*  */
    NETDEV_WEEK_PLAN_EVENT_FACE_DETECT      = 18,              /*  */
    NETDEV_WEEK_PLAN_EVENT_ROAD_DETECT      = 19,              /* · */
    NETDEV_WEEK_PLAN_EVENT_PEOPLE_COUNT     = 20,              /*  */
    NETDEV_WEEK_PLAN_EVENT_HEATMAP          = 21,              /* ȶͼ */
    NETDEV_WEEK_PLAN_EVENT_SD_STORAGE       = 22               /* SD洢 */
}NETDEV_WEEK_PLAN_EVENT_E;


/**
* @enum tagNetDEVFishEyePtzMode
* @brief 豸ģʽöٱ
* @attention 
*/
typedef enum tagNetDEVFishEyePtzMode
{
    NETDEV_FISHEYE_MODE_ORIGINAL            = 0,                /* ԭʼͼ */
    NETDEV_FISHEYE_MODE_180                 = 1,                /* 2*180ģʽ */
    NETDEV_FISHEYE_MODE_360_1PTZ            = 2,                /* 360+1PTZģʽ */
    NETDEV_FISHEYE_MODE_360_6PTZ            = 3,                /* 360+6PTZģʽ */
    NETDEV_FISHEYE_MODE_3PTZ                = 4,                /* +3PTZģʽ */
    NETDEV_FISHEYE_MODE_MID_ON_4PTZ         = 5,                /* ͼмʾ+4PTZģʽ */
    NETDEV_FISHEYE_MODE_MID_OFF_4PTZ        = 6,                /* ͼм䵫ʾ+4PTZģʽ */
    NETDEV_FISHEYE_MODE_LEFT_4PTZ           = 7,                /* +4PTZģʽ */
    NETDEV_FISHEYE_MODE_8PTZ                = 8,                /* +8PTZģʽ */
    NETDEV_FISHEYE_MODE_PANORAMA            = 9,                /* ȫģʽ */
    NETDEV_FISHEYE_MODE_PR_3PTZ             = 10,               /* ȫ+3PTZģʽ */
    NETDEV_FISHEYE_MODE_PR_4PTZ             = 11,               /* ȫ+4PTZģʽ */
    NETDEV_FISHEYE_MODE_PR_8PTZ             = 12,               /* ȫ+8PTZģʽ */

    NETDEV_FISHEYE_MODE_INVALID             = 0xFF             /* Ƿֵ */
}NETDEV_FISHEYE_PTZ_MODE_E;

/**
* @enum tagNETDEVfInstallMode
* @brief 豸װģʽ
* @attention 
*/
typedef enum tagNETDEVfInstallMode
{
    NETDEV_INSTALL_MODE_TOP             = 0,            /* װ */
    NETDEV_INSTALL_MODE_BOTTOM          = 1,            /* ײװ */
    NETDEV_INSTALL_MODE_SIDE            = 2,            /* 氲װ */

    NETDEV_INSTALL_MODE_INVALID         = 0xFF          /* Ƿֵ */
}NETDEV_INSTALL_MODE_E;

/**
* @enum tagNETDEVfMouseMoveMode
* @brief ƶģʽ
* @attention 
*/
typedef enum tagNETDEVfMouseMoveMode
{
    NETDEV_MOUSE_MOVE                   = 0,            /* λ */
    NETDEV_MOUSE_LEFT_BTN_DOWN          = 1,            /*  */
    NETDEV_MOUSE_LEFT_BTN_UP            = 2,            /*  */
    NETDEV_MOUSE_WHEEL                  = 3,            /* ֲ */

    NETDEV_MOUSE_INVALID                = 0xFF          /* Ƿֵ */
}NETDEV_MOUSE_MOVE_MODE_E;

/**
 * @enum tagNETDEVFindAlarmTypeEn
 * @brief 澯ò öٶ  Alarm configuration operation Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVFindAlarmTypeEn
{
    NETDEV_FIND_ALARM_DISK_STORAGE_IS_FULL               = 1,            /* 洢 */
    NETDEV_FIND_ALARM_DISK_STORAGE_WILL_FULL             = 2,            /* 洢 */
    NETDEV_FIND_ALARM_STOR_ERR                           = 3,            /* 洢 */
    NETDEV_FIND_ALARM_STOR_ERR_RECOVER                   = 4,            /* 洢ָ */
    NETDEV_FIND_ALARM_MOVE_DETECT                        = 5,            /* ˶澯 */
    NETDEV_FIND_ALARM_MOVE_DETECT_RECOVER                = 6,            /* ˶澯ָ */
    NETDEV_FIND_ALARM_VIDEO_TAMPER_DETECT                = 7,            /* ڵ澯 */
    NETDEV_FIND_ALARM_VIDEO_TAMPER_RECOVER               = 8,            /* ڵ澯ָ */
    NETDEV_FIND_ALARM_INPUT_SWITCH                       = 9,            /* 뿪澯 */
    NETDEV_FIND_ALARM_INPUT_SWITCH_RECOVER               = 10,           /* 뿪澯ָ*/
    NETDEV_FIND_ALARM_BAND_CHANGE                        = 11,           /* 豸ڴ */
    NETDEV_FIND_ALARM_IMAGE_BLURRY                       = 12,           /* ͼ齹 */
    NETDEV_FIND_ALARM_IMAGE_BLURRY_RECOVER               = 13,           /*  */
    NETDEV_FIND_ALARM_SCENE_CHANGE                       = 14,           /* ˥ */
    NETDEV_FIND_ALARM_ILLEGAL_ACCESS                     = 15,           /* лָ */
    NETDEV_FIND_ALARM_REPORT_DEV_ONLINE                  = 16,           /* 豸 */
    NETDEV_FIND_ALARM_REPORT_DEV_OFFLINE                 = 17,           /* 豸 */
    NETDEV_FIND_ALARM_REPORT_DEV_VIDEO_LOSS              = 18,           /* Ƶʧ */
    NETDEV_FIND_ALARM_REPORT_DEV_VIDEO_LOSS_RECOVER      = 19,           /* Ƶʧָ */
    NETDEV_FIND_ALARM_COUNT_PEOPLE                       = 20,           /* ͳ */
    NETDEV_FIND_ALARM_HEAT_MAP                           = 21,           /* ȶͼ */
    NETDEV_FIND_ALARM_LINE_DETECTOR                      = 22,           /* ߸澯 */
    NETDEV_FIND_ALARM_CELL_MOTION                        = 23,           /* ˶ */
    NETDEV_FIND_ALARM_LINE_CROSS                         = 24,           /* Խ澯 */
    NETDEV_FIND_ALARM_OBJECTS_INSIDE                     = 25,           /*  */
    NETDEV_FIND_ALARM_ACCESSZONE                         = 26,           /* 澯 */
    NETDEV_FIND_ALARM_LEAVE_ZONE                         = 27,           /* 뿪澯 */
    NETDEV_FIND_ALARM_HOVER_ZONE                         = 28,           /* ǻ澯 */
    NETDEV_FIND_ALARM_OVER_ZONE                          = 29,           /* ԽΧ澯 */
    NETDEV_FIND_ALARM_CARE_ARTICLE                       = 30,           /* Ʒ澯 */
    NETDEV_FIND_ALARM_REMAIN_ARTICLE                     = 31,           /* Ʒ澯 */
    NETDEV_FIND_ALARM_FACE_DETECTOR                      = 32,           /*  */
    NETDEV_FIND_ALARM_GATHER                             = 33,           /* Աۼ澯 */
    NETDEV_FIND_ALARM_GATHER_RECOVER                     = 34,           /* Աۼ澯ָ */
    NETDEV_FIND_ALARM_FAST_MOVE                          = 35,           /* ƶ */
    NETDEV_FIND_ALARM_ILLEGAL_PARKED                     = 36,           /* Υͣ澯 */
    NETDEV_FIND_ALARM_HUMAN_SHAPE_ON                     = 37,           /* μ澯 */
    NETDEV_FIND_ALARM_HUMAN_SHAPE_OFF                    = 38,           /* μ澯ָ */

    NETDEV_FIND_ALARM_INVALID                            = 0xFFFF        /* Чֵ  Invalid value */
}NETDEV_FIND_ALARM_TYPE_E;


/**
* @enum tagNETDEVWndNameDisplay
* @brief ʾ öٶ
* @attention  None
*/
typedef enum tagNETDEVWndNameDisplay
{
    NETDEV_WND_NAME_HIDE    = 0,        /*  */
    NETDEV_WND_NAME_SHOW    = 1     /* ʾ */
} NETDEV_WND_NAME_DISPLAY_E;

/**
* @enum tagNETDEVOperatedMode
* @brief ģʽ öٶ
* @attention  None
*/
typedef enum tagNETDEVOperatedMode
{
    NETDEV_SPLIT_SCREEN_RECOVER    = 0,               /* ָʾ */
    NETDEV_SPLIT_SCREEN_ZOOM       = 1                /* ĳŴȫڴС */
} NETDEV_OPERATED_MODE_E;

 /**
 * @enum tagNETDEVNATType
 * @brief NATö öٶ
 * @attention  None
 */
typedef enum tagNETDEVNATType
{
    NETDEV_STUN_TYPE_UNKNOWN                 = 0,       /* δʶ */
    NETDEV_STUN_TYPE_FAILURE                 = 1,       /* ʧ */
    NETDEV_STUN_TYPE_OPEN                    = 2,       /* ûNATIPûзǽ */
    NETDEV_STUN_TYPE_BLOCKED                 = 3,       /* UDP */
    NETDEV_STUN_TYPE_CONE_NAT                = 4,       /* ȫNAT */
    NETDEV_STUN_TYPE_RESTRICTED_NAT          = 5,       /* NAT */
    NETDEV_STUN_TYPE_PORT_RESTRICTED_NAT     = 6,       /* ˿NAT */
    NETDEV_STUN_TYPE_SYM_NAT                 = 7,       /* ԳNAT */
    NETDEV_STUN_TYPE_SYM_FIREWALL            = 8        /* ûNATIPǶԳƵUDPǽ */
}NETDEV_NAT_TYPE_E;


/**
* @enum tagNetDevFaceIDLengthType
* @brief ʶIDݽṹ
* @attention 
*/
typedef enum tagNetDevFaceIDLengthType
{
    NETDEV_FACE_IDLENGTH_TYPE_0      = 0,            /*  0 */
    NETDEV_FACE_IDLENGTH_TYPE_2      = 2,            /*  2 */
    NETDEV_FACE_IDLENGTH_TYPE_4      = 4,            /*  4 */
    NETDEV_FACE_IDLENGTH_TYPE_8      = 8             /*  8 */

}NETDEV_FACE_IDLENGTH_TYPE_E;

/**
 * @enum tagNETDEVFaceDBType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVFaceDBType
{
    NETDEV_FACE_DB_TYPE_BLACK       = 0,        /*  */
    NETDEV_FACE_DB_TYPE_WHITE       = 1,        /*  */
    NETDEV_FACE_DB_TYPE_GRAY        = 2,        /*  */

    NETDEV_FACER_DB_TYPE_INVALID    = 0xFF      /* Чֵ */
}NETDEV_FACE_DB_TYPE_E;


/**
* @enum tagNETDEVImageRotationMode
* @brief ͼģʽ öٶ
* @attention  None
*/
typedef enum tagNETDEVImageRotationMode
{
    NETDEV_IMAGE_ROTATION_MODE_NORMAL       = 0,            /*  */
    NETDEV_IMAGE_ROTATION_MODE_V_FLIPPING   = 1,            /* ֱת */
    NETDEV_IMAGE_ROTATION_MODE_H_FLIPPING   = 2,            /* ˮƽת */
    NETDEV_IMAGE_ROTATION_MODE_HV           = 3,            /* ˮƽ+ֱ (˳ʱ180) */
    NETDEV_IMAGE_ROTATION_MODE_SPIN90_RIGHT = 4,            /* 90(˳ʱ90) */
    NETDEV_IMAGE_ROTATION_MODE_SPIN90_LEFT  = 5,            /* 90(˳ʱ270) */

    NETDEV_IMAGE_ROTATION_MODE_INVALID      = 0xFF          /* Чֵ */
}NETDEV_IMAGE_ROTATION_MODE_E;

/**
* @enum tagNETDEVExposureMode
* @brief عģʽ öٶ
* @attention  None
*/
typedef enum tagNETDEVExposureMode
{
    NETDEV_EXPOSURE_MODE_AUTOMATIC          = 0,               /* Զع */
    NETDEV_EXPOSURE_MODE_CUSTOM             = 1,               /* Զع */
    NETDEV_EXPOSURE_MODE_SHUTTER_PRIORITY   = 2,               /*  */
    NETDEV_EXPOSURE_MODE_APERTURE_PRIORITY  = 3,               /* Ȧ */
    NETDEV_EXPOSURE_MODE_GAIN_PRIORITY      = 4,               /*  */
    NETDEV_EXPOSURE_MODE_INDOOR_50_HZ       = 5,               /* 50Hz */
    NETDEV_EXPOSURE_MODE_INDOOR_60_HZ       = 6,               /* 60Hz */
    NETDEV_EXPOSURE_MODE_MANUAL_OPERATION   = 7,               /* ֶع */
    NETDEV_EXPOSURE_MODE_LOWER_GHOSTING     = 8,               /* Ӱ */

    NETDEV_EXPOSURE_MODE_INVALID            = 0xFF              /* Чֵ */
}NETDEV_EXPOSURE_MODE_E;

/**
* @enum tagNETDEVLampType
* @brief  öٶ
* @attention  None
*/
typedef enum tagNETDEVLampType
{
    NETDEV_LAMP_TYPE_WITHOUT            = 0,        /* ޲*/
    NETDEV_LAMP_TYPE_WHITE              = 1,        /* ׹ */
    NETDEV_LAMP_TYPE_INFRARED           = 2,        /*  */
    NETDEV_LAMP_TYPE_LASER_DEVICE       = 3,        /* */
    NETDEV_LAMP_TYPE_INFRARED_SHIELD    = 4,        /* ⻤ֵ*/

    NETDEV_LAMP_TYPE_INVALID            = 0xFF      /* Чֵ */
}NETDEV_LAMP_TYPE_E;

/**
* @enum tagNETDEVLampCtrlMode
* @brief ֵ֧Ŀģʽ öٶ
* @attention  None
*/
typedef enum tagNETDEVLampCtrlMode
{
    NETDEV_LCM_GLOBAL_ATTENTION_AC      = 0,        /* ȫּԶ*/
    NETDEV_LCM_OVEREXPOSE_INHIBIT_AC    = 1,        /* Զ */
    NETDEV_LCM_PRESET_RCM               = 2,        /* Ԥÿ-·ģʽ */
    NETDEV_LCM_MANUAL_CM                = 3,        /* ֶģʽ*/
    NETDEV_LCM_PRESET_PCM               = 4,        /* Ԥÿ-԰ģʽ*/
    NETDEV_LCM_PHOTOSENS_AM             = 5,        /* Զģʽ*/
    NETDEV_LCM_INDOOR_AM                = 6,        /* Զģʽ*/
    NETDEV_LCM_MANUAL_FOM               = 7,        /* ֶ-ǿƿģʽ*/
    NETDEV_LCM_NIGHT_VIDEO_DET_MODE     = 8,        /* ҹƵģʽ*/

    NETDEV_LCM_INVALID                  = 0xFF      /* Чֵ */
}NETDEV_LAMP_CTRL_MODE_E;


/**
* @enum tagNETDEVShutterTimeRange
* @brief ʱֵ֧ȡֵ öٶ
* @attention  None
*/
typedef enum tagNETDEVShutterTimeRange
{
    NETDEV_SHUTTER_TIME_AUTOMATIC   = 0,            /* ʱΪԶ*/
    NETDEV_SHUTTER_TIME_1           = 1,            /* 1/1 */
    NETDEV_SHUTTER_TIME_1_2         = 2,            /* 1/2 */
    NETDEV_SHUTTER_TIME_1_3         = 3,            /* 1/3 */
    NETDEV_SHUTTER_TIME_1_4         = 4,            /* 1/4 */
    NETDEV_SHUTTER_TIME_1_6         = 6,            /* 1/6 */
    NETDEV_SHUTTER_TIME_1_8         = 8,            /* 1/8 */
    NETDEV_SHUTTER_TIME_1_10        = 10,           /* 1/10*/
    NETDEV_SHUTTER_TIME_1_12        = 12,           /* 1/12*/
    NETDEV_SHUTTER_TIME_1_15        = 15,           /* 1/15*/
    NETDEV_SHUTTER_TIME_1_20        = 20,           /* 1/20*/
    NETDEV_SHUTTER_TIME_1_25        = 25,           /* 1/25*/
    NETDEV_SHUTTER_TIME_1_30        = 30,           /* 1/30*/
    NETDEV_SHUTTER_TIME_1_50        = 50,           /* 1/50*/
    NETDEV_SHUTTER_TIME_1_60        = 60,           /* 1/60*/
    NETDEV_SHUTTER_TIME_1_100       = 100,          /* 1/100*/
    NETDEV_SHUTTER_TIME_1_120       = 120,          /* 1/120*/
    NETDEV_SHUTTER_TIME_1_150       = 150,          /* 1/150*/
    NETDEV_SHUTTER_TIME_1_180       = 180,          /* 1/180*/
    NETDEV_SHUTTER_TIME_1_200       = 200,          /* 1/200*/
    NETDEV_SHUTTER_TIME_1_250       = 250,          /* 1/250*/
    NETDEV_SHUTTER_TIME_1_500       = 500,          /* 1/500*/
    NETDEV_SHUTTER_TIME_1_1000      = 1000,         /* 1/1000*/
    NETDEV_SHUTTER_TIME_1_2000      = 2000,         /* 1/2000*/
    NETDEV_SHUTTER_TIME_1_4000      = 4000,         /* 1/4000*/
    NETDEV_SHUTTER_TIME_1_8000      = 8000,         /* 1/8000*/
    NETDEV_SHUTTER_TIME_1_50000     = 50000,        /* 1/50000*/
    NETDEV_SHUTTER_TIME_1_100000    = 100000,       /* 1/100000*/

    NETDEV_SHUTTER_TIME_INVALID = 0xFF                  /* Чֵ */
}NETDEV_SHUTTER_TIME_RANGE_E;

/**
* @enum tagNETDEVWideDynamicMode
* @brief ģʽ öٶ
* @attention  None
*/
typedef enum tagNETDEVWideDynamicMode
{
    NETDEV_WDM_CLOSED   = 0,    /* ر*/
    NETDEV_WDM_OPEN     = 1,    /* */
    NETDEV_WDM_AUTO     = 2,    /* Զ*/

    NETDEV_WDM_INVALID  = 0xFF  /* Чֵ */
}NETDEV_WIDE_DYNAMIC_MODE_E;

/**
* @enum tagNETDEVMeteringMode
* @brief ģʽ öٶ
* @attention  None
*/
typedef enum tagNETDEVMeteringMode
{
    NETDEV_METER_MODE_CENTRAL_WEIGHT    = 0,        /* Ȩ*/
    NETDEV_METER_MODE_AREA_METER        = 1,        /* */
    NETDEV_METER_MODE_SLIGHT_INHIBIT    = 2,        /* ǿ*/
    NETDEV_METER_MODE_VEHICLE_METER     = 3,        /* */
    NETDEV_METER_MODE_FACE_METER        = 4,        /* */
    NETDEV_METER_MODE_SPOT_METER        = 5,        /* */

    NETDEV_METER_MODE_INVALID           = 0xFF      /* Чֵ */
}NETDEV_METER_MODE_E;

/**
* @enum tagNETDEVLampType
* @brief ҹģʽ öٶ
* @attention  None
*/
typedef enum tagNETDEVDayNightMode
{
    NETDEV_DNM_AUTO                     = 0,        /* Զģʽ*/
    NETDEV_DNM_DAY_COLOR                = 1,        /* --ɫ */
    NETDEV_DNM_NIGHT_BAW                = 2,        /* ҹ--ڰ */
    NETDEV_DNM_LINK_COLOR_TO_BLACK      = 3,        /* ת*/

    NETDEV_DNM_INVALID                  = 0xFF      /* Чֵ */
}NETDEV_DAY_NIGHT_MODE_E;

/**
* @enum tagNETDEVFocusModel
* @brief Խģʽ öٶ
* @attention  None
*/
typedef enum tagNETDEVFocusModel
{
    NETDEV_FOCUS_MODEL_AUTO             = 0,        /* ԶԽ*/
    NETDEV_FOCUS_MODEL_MANUAL           = 1,        /* ֶԽ */
    NETDEV_FOCUS_MODEL_A_KEY_FOCUS      = 2,        /* һԽ豸̨ת䱶ԤλȲʱһԶ۽ */
    NETDEV_FOCUS_MODEL_INFRARED_NIGHT   = 3,        /* һԽҹ⣩ɼ΢ĵջҹڵյȣƺʹô˶ԽģʽЧϺá*/
    NETDEV_FOCUS_MODEL_LOCK             = 4,        /* һԽֻ豸䱶һԶ۽޷Խ*/
    NETDEV_FOCUS_MODEL_INVALID          = 0xFF      /* Чֵ */
}NETDEV_FOCUS_MODEL_E;

/**
* @enum tagNETDEVFocusScene
* @brief Խ öٶ
* @attention  None
*/
typedef enum tagNETDEVFocusScene
{
    NETDEV_FOCUS_SCENE_ROUTINE          = 0,        /* */
    NETDEV_FOCUS_SCENE_LONG_OBJDIST     = 1,        /* Զ */
    NETDEV_FOCUS_SCENE_INDOOR_MODEL     = 2,        /* ģʽ */
    NETDEV_FOCUS_SCENE_INVALID          = 0xFF      /* Чֵ */
}NETDEV_FOCUS_SCENE_E;

/**
* @enum tagNETDEVWhiteBalance
* @brief ƽģʽ öٶ
* @attention  None
*/
typedef enum tagNETDEVWhiteBalance
{
    NETDEV_WBM_AUTO                         = 0,        /*Զģʽ*/
    NETDEV_WBM_TRIMMING                     = 1,        /*΢ģʽ*/
    NETDEV_WBM_INDOOR                       = 2,        /*ģʽ*/
    NETDEV_WBM_OUTDOOR                      = 3,        /*ģʽ*/
    NETDEV_WBM_AUTO_MERCURY_LAMP            = 4,        /*Զˮģʽ*/
    NETDEV_WBM_NIGHT_TRIMMING               = 5,        /*ҹ΢ģʽ*/
    NETDEV_WBM_AUTO_NA_LAMP                 = 6,        /*ԶƵģʽ*/
    NETDEV_WBM_LOCK                         = 7,        /*ģʽ*/
    NETDEV_WBM_SELF_ADAPT_NIGHT_TRIMMING    = 8,        /*Ӧҹ΢ģʽ*/
    NETDEV_WBM_AUTO_SECOND                  = 9,        /*Զģʽ2*/
    NETDEV_WBM_INVALID                      = 0xFF      /* Чֵ */
}NETDEV_WHITE_BALANCE_MODE_E;

/**
 * @enum tagNETDEVXWComType
 * @brief 
 * @attention  None      Ŀǰ֧ʹ0  4
 */
typedef enum tagNETDEVXWComType
{
    NETDEV_XW_COM_TYPE_RS232                    = 0,               /* 232 */
    NETDEV_XW_COM_TYPE_RS422HALFDUPLEX          = 1,               /* 422 Ŀǰ֧ */
    NETDEV_XW_COM_TYPE_RS422FULLDUPLEX          = 2,               /* 422 Ŀǰ֧ */
    NETDEV_XW_COM_TYPE_RS485HALFDUPLEX          = 3,               /* 485 Ŀǰ֧ */
    NETDEV_XW_COM_TYPE_RS485FULLDUPLEX          = 4,
    NETDEV_XW_COM_TYPE_GENERIC                  = 5,               /* Ŀǰ֧ */

    NETDEV_XW_COM_TYPE_INVALID                  = 0xFF             /* Чֵ */
}NETDEV_XW_COM_TYPE_E;

/* ҵ */
typedef enum tagNETDEVVideoType
{
    NETDEV_PLAYBACK_REMOTE  = 0,        /* Զ˻ط */
    NETDEV_REALPLAY_REMOTE  = 1,        /* Զʵ */
    NETDEV_REALPLAY_LOCAL   = 2,        /* ʵ */
    NETDEV_SEQUENCE_PANE    = 3,        /* Ѳ δʵ*/
    NETDEV_SEQUENCE_WND     = 4,        /* Ѳ */
    NETDEV_REALPLAY_ALARM   = 5         /* 澯ʵ */
}NETDEV_XW_VIDEO_TYPE_E;

typedef enum tagNETDEV_PASSIVEDECODE_CMD
{
    PASSIVE_DEC_PAUSE       = 1,   /* ͣ(ļЧ) */
    PASSIVE_DEC_RESUME      = 2,   /* ָ(ļЧ) */
    PASSIVE_DEC_FAST        = 3,   /* ٱ(ļЧ) */
    PASSIVE_DEC_SLOW        = 4,   /* ٱ(ļЧ) */
    PASSIVE_DEC_NORMAL      = 5,   /* (ļЧ) */
    PASSIVE_DEC_ONEBYONE    = 6,   /* 뵥֡() */
    PASSIVE_DEC_AUDIO_ON    = 7,   /* Ƶ */
    PASSIVE_DEC_AUDIO_OFF   = 8,   /* Ƶر */
    PASSIVE_DEC_RESETBUFFER = 9    /* ջ */
}NETDEV_PASSIVEDECODE_CMD_E;

/* Ѳ״̬ */
typedef enum tagNETDEVXWSequenceStatusType
{
    NETDEV_SEQUENCE_STATUS_RUNNING  = 0,        /*  */ 
    NETDEV_SEQUENCE_STATUS_PAUSE    = 1,        /* ͣ */ 
    NETDEV_SEQUENCE_STATUS_INVALID  = 0xff
}NETDEV_XW_SEQUENCE_STATUS_E;

/* Ѳ */
typedef enum tagNETDEVXWSequenceCtrlCmd
{
    NETDEV_SEQUENCE_CTRL_CMD_STOP       = 0,        /* ֹͣ */ 
    NETDEV_SEQUENCE_CTRL_CMD_START      = 1,        /*  */ 
    NETDEV_SEQUENCE_CTRL_CMD_PAUSE      = 2,        /* ͣ */ 
    NETDEV_SEQUENCE_CTRL_CMD_RECOVER    = 3,        /* ָ */ 
    NETDEV_SEQUENCE_CTRL_CMD_PREVIOUS   = 4,        /* һ */ 
    NETDEV_SEQUENCE_CTRL_CMD_NEXT       = 5,        /* һ */ 
    NETDEV_SEQUENCE_CTRL_CMD_INVALID    = 0xff
}NETDEV_XW_SEQUENCE_CTRL_CMD_E;

/**
 * @enum tagNETDEVXWWndStreamStatus
 * @brief ״̬
 * @attention
 */
typedef enum tagNETDEVXWWndStreamStatus
{
    NETDEV_XW_STREAM_STATUS_NO                  = 0,          /*δ*/
    NETDEV_XW_STREAM_STATUS_SUCCESS             = 1,          /*ɹ*/
    NETDEV_XW_STREAM_STATUS_STREAMING           = 2,          /**/
    NETDEV_XW_STREAM_STATUS_RESTREAM            = 3,          /*ؽ*/
    NETDEV_XW_STREAM_STATUS_FAILED              = 4,          /*ʧ*/
    NETDEV_XW_STREAM_STATUS_CAP_NOT_ENOUGHT     = 5,          /**/

    NETDEV_XW_STREAM_STATUS_INVALID             = 0xFF        /* Чֵ */
}NETDEV_XW_WND_STREAM_STATUS_E;

/**
* @enum tagNETDEVXWSequencePlayControlCmd
* @brief Ѳſ öٶ
* @attention  None
*/
typedef enum tagNETDEVXWSequencePlayControlCmd
{
    NETDEV_XW_SEQUENCE_PLAY_CTRL_CMD_STOP       = 0,        /* ֹͣ */
    NETDEV_XW_SEQUENCE_PLAY_CTRL_CMD_START      = 1,        /*  */
    NETDEV_XW_SEQUENCE_PLAY_CTRL_CMD_PAUSE      = 2,        /* ͣ */
    NETDEV_XW_SEQUENCE_PLAY_CTRL_CMD_RESUME     = 3,        /* ָ */
    NETDEV_XW_SEQUENCE_PLAY_CTRL_CMD_PAGEUP     = 4,        /* һ */
    NETDEV_XW_SEQUENCE_PLAY_CTRL_CMD_PAGEDOWN   = 5,        /* һ */

    NETDEV_XW_SEQUENCE_PLAY_CTRL_CMD_INVALID    = 0xFF      /* Чֵ */
}NETDEV_XW_SEQUENCE_PLAY_CTRL_CMD_E;

/**
* @enum tagNETDEVXWScenesPlanMode
* @brief Ѳƻģʽ öٶ
* @attention  None
*/
typedef enum tagNETDEVXWScenesPlanMode
{
    NETDEV_XW_SCENES_PLAN_MODE_TIMER       = 0,            /* ʱл */
    NETDEV_XW_SCENES_PLAN_MODE_TIME_TABLE  = 1,            /* ʱл 24Сʱƻ */

    NETDEV_XW_SCENES_PLAN_MODE_INVALID     = 0xFF          /* Чֵ */
}NETDEV_XW_SCENES_PLAN_MODE_E;


/**
* @enum tagNETDEVHDDStorageFullStrategy
* @brief Ӳ̴洢֮õĲ
* @attention 
*/
typedef enum tagNETDEVHDDStorageFullStrategy
{
    NETDEV_HDD_STORAGE_FULL_STRATEGY_COVER      = 0,        /*  */
    NETDEV_HDD_STORAGE_FULL_STRATEGY_STOP       = 1,        /* ֹͣ */

    NETDEV_HDD_STORAGE_FULL_STRATEGY_INVALID    = 0XFF      /* Чֵ */
}NETDEV_HDD_STORAGE_FULL_STRATEGY_E;



/**
* @enum tagNETDEVCertificateType
* @brief ֤
* @attention  None
*/
typedef enum tagNETDEVCertificateType
{
    NETDEV_CERTIFICATE_TYPE_ID                  = 0,        /*0:֤ */
    NETDEV_CERTIFICATE_TYPE_IC                  = 1,        /* 1:IC */
    NETDEV_CERTIFICATE_TYPE_PASSPORT            = 2,        /* 2: */
    NETDEV_CERTIFICATE_TYPE_DRIVING_LICENSE     = 3,        /* 3:ʻ֤ */
    NETDEV_CERTIFICATE_TYPE_OTHER               = 99,       /* 99: */
    NETDEV_CERTIFICATE_TYPE_INVALID             = 0xFF      /* Чֵ */
}NETDEV_ID_TYPE_E;

/**
* @enum tagNETDEVModelStatus
* @brief ģ״̬ö
* @attention  None
*/
typedef enum tagNETDEVModelStatus
{
    NETDEV_MODEL_STATUS_TYPE_UNMODELED                      = 0,        /*0:δģ */
    NETDEV_MODEL_STATUS_TYPE_SUCCEED                        = 1,        /* 1:ѽģ */
    NETDEV_MODEL_STATUS_TYPE_FAILED                         = 2,        /* 2:ģʧ */

    NETDEV_MODEL_STATUS_TYPE_INVALID                         = 0xFF      /* Чֵ */
}NETDEV_MODEL_STATUS_E;

/**
* @enum tagNETDEVPeopleLibType
* @brief Ա
* @attention  None
*/
typedef enum tagNETDEVPeopleLibType
{
    NETDEV_PEOPLE_LIB_TYPE_DEFAULT      = 0,        /* ĬЧֵ */
    NETDEV_PEOPLE_LIB_TYPE_BLACKLIST    = 1,        /*  */
    NETDEV_PEOPLE_LIB_TYPE_STRANGER     = 2,        /* /İ */
    NETDEV_PEOPLE_LIB_TYPE_STAFF        = 3,        /* Ա */
    NETDEV_PEOPLE_LIB_TYPE_VISITOR      = 4,        /* ÿ */
    NETDEV_PEOPLE_LIB_TYPE_INVALID      = 0xFF      /* Чֵ */
}NETDEV_PEOPLE_LIB_TYPE_E;

/**
* @enum tagNETDEVSubType
* @brief 
* @attention  None
*/
typedef enum tagNETDEVSubType
{
    NETDEV_SUB_TYPE_FACE_COLLECTION = 0,                             /* ɼ */
    NETDEV_SUB_TYPE_PERSON_CHECK    = 1,                             /* Ա */
    NETDEV_SUB_TYPE_TYPE_INVALID    = 0xFF                           /* Чֵ */
}NETDEV_SUB_TYPE_E;

/**
* @enum tagNETDEVSmartAlarmType
* @brief ܸ澯
* @attention 
*/
typedef enum tagNETDEVSmartAlarmType
{
    NETDEV_SMART_ALARM_TYPE_FACE_SNAP         = 0,             /* ʶץͼ */
    NETDEV_SMART_ALARM_TYPE_VEHICLE_SNAP      = 1,             /* ʶץͼ */
    NETDEV_SMART_ALARM_TYPE_VIDEO_STRUCT_SNAP = 3,             /* Ƶṹץͼ */
    NETDEV_SMART_ALARM_TYPE_INVALID           = 0xFF           /* Чֵ */
}NETDEV_SMART_ALARM_TYPE_E;

/**
* @enum tagNETDEVSearchType
* @brief 
* @attention 
*/
typedef enum tagNETDEVSearchType
{
    NETDEV_SEARCH_TYPE_FACE        = 0,             /*  */
    NETDEV_SEARCH_TYPE_FACE_COMPARE_SUCCESS = 1,    /* ȶԳɹ  */
    NETDEV_SEARCH_TYPE_FACE_COMPARE_FAIL    = 2,    /* ȶʧ  */

    NETDEV_SEARCH_TYPE_INVALID              = 0xff  /* Чֵ */
}NETDEV_SEARCH_TYPE_E;


/**
 * @enum tagNETDEVQueryCondType
 * @brief ѯ
 * @attention  None
 */
typedef enum tagNETDEVQueryCondType
{
    NETDEV_QUERYCOND_USERNAME          = 0,                /* ѯû */
    NETDEV_QUERYCOND_ORGNAME           = 1,                /* ѯ֯ */
    NETDEV_QUERYCOND_DEVNAME           = 2,                /* ѯ豸 */
    NETDEV_QUERYCOND_CHNNAME           = 3,                /* ѯͨ */
    NETDEV_QUERYCOND_TIME              = 4,                /* ѯʱ */
    NETDEV_QUERYCOND_BUSINESSTYPE      = 5,                /* ѯҵ */
    NETDEV_QUERYCOND_OPERATETYPE       = 6,                /* ѯ */
    NETDEV_QUERYCOND_OPEROBJECT        = 7,                /* ѯ */
    NETDEV_QUERYCOND_ALARMTYPE         = 8,                /* ѯ澯 μöNETDEV_ALARM_TYPE_E*/
    NETDEV_QUERYCOND_ALARMSRCNAME      = 9,                /* ѯ澯Դ */
    NETDEV_QUERYCOND_ALARMLEVEL        = 10,               /* ѯ澯 */
    NETDEV_QUERYCOND_ALARMCHECKED      = 11,               /* ѯ澯Ƿȷ */
    NETDEV_QUERYCOND_ALARMCHECKUSER    = 12,               /* ѯ澯ȷû */
    NETDEV_QUERYCOND_ALARMCHECKTIME    = 13,               /* ѯ澯ȷʱ */
    NETDEV_QUERYCOND_ALARM_DEVID       = 14,               /* ѯ澯豸ID */
    NETDEV_QUERYCOND_ALARM_CHNID       = 15,               /* ѯ澯ͨID */
    NETDEV_QUERYCOND_ALARM_SUBTYPE     = 16,               /* ѯ澯 */
    NETDEV_QUERYCOND_ALARM_SERVER      = 17,               /* ѯ */
    NETDEV_QUERYCOND_DOOR_NUM          = 18,               /* ѯű */
    NETDEV_QUERYCOND_CARD_NUM          = 19,               /* ѯ */
    NETDEV_QUERYCOND_ALARM_GENDER      = 20,               /* ѯԱ */
    NETDEV_QUERYCOND_ALARM_BIRTHDAY    = 21,               /* ѯ */
    NETDEV_QUERYCOND_MONITOY_REASON    = 22,               /* ѯԭ */
    NETDEV_QUERYCOND_PLATE_NUM         = 23,               /* ѯƺ */
    NETDEV_QUERYCOND_VEHICLE_TYPE      = 24,               /* ѯ */
    NETDEV_QUERYCOND_PLATE_COLOR       = 25,               /* ѯɫ */
    NETDEV_QUERYCOND_VEHICLE_COLOR     = 26,               /* ѯɫ */
    NETDEV_QUERYCOND_PERSON_NUMBER     = 27,               /* ѯԱ*/
    NETDEV_QUERYCOND_PERSON_TYPE       = 28,               /* ѯԱ*/
    NETDEV_QUERYCOND_DIRECT            = 29,               /* ѯ*/
    NETDEV_QUERYCOND_ORGID             = 30,               /* ֯ID */
    NETDEV_QUERYCOND_ORGPID            = 31,               /* ֯PID */
    NETDEV_QUERYCOND_DEVICEID          = 32,               /* 豸ID */
    NETDEV_QUERYCOND_DEVICE_TYPE       = 33,               /* 豸 */
    NETDEV_QUERYCOND_DEVICE_SUBTYPE    = 34,               /* 豸 */
    NETDEV_QUERYCOND_CHANNELID         = 35,               /* ͨID */
    NETDEV_QUERYCOND_CHANNEL_TYPE      = 36,               /* ͨ */
    NETDEV_QUERYCOND_ONLINE_STATE      = 37,               /* ״̬ */
    NETDEV_DATABASE_ID                 = 38,               /* ѯID */
    NETDEV_QUERY_TYPE_PLATECLASS       = 39,               /* ѯ */ 
    NETDEV_QUERYCOND_RANGE             = 40,               /* ѯ澯ѯΧ 0豸1Ƿ*/
    NETDEV_QUERYCOND_BEGIN_TIME          = 41,             /* ѯÿԤԼʼʱ*/
    NETDEV_QUERYCOND_END_TIME            = 42,             /* ѯÿԤԼʱ*/
    NETDEV_QUERYCOND_INTERVIEWEE_NAME    = 43,             /* ѯܷ*/
    NETDEV_QUERYCOND_INTERVIEWEE_STATUS  = 44,             /* ѯܷ״̬*/
    NETDEV_QUERYCOND_PARK_NAME         = 45,               /* ѯͣ */
    NETDEV_QUERYCOND_CONFIDENCE_LEVEL  = 46,               /* ѯŶ */
    NETDEV_QUERYCOND_PARK_TIME         = 47,               /* ѯͣʱ */
    NETDEV_QUERYCOND_CONTRACT_RULE     = 48,               /* ѯڹ */
    NETDEV_QUERYCOND_PAYMENT_METHOD    = 49,               /* ѯʽ */
    NETDEV_QUERYCOND_PASSING_DIRECTION = 50,               /* ѯ */
    NETDEV_QUERYCOND_VEHICLE_ATTR      = 51,               /* ѯ */
    NETDEV_QUERYCOND_STATISTICS_UNITS  = 52,               /* ѯͳƵλ */
    NETDEV_QUERYCOND_EXITENTRANCE_NAME = 53,               /* ѯ */
    NETDEV_QUERYCOND_PICTURE_DATA      = 54,               /* ѯͼƬ */
    NETDEV_QUERYCOND_PERSON_NAME       = 55,               /* ѯԱ */
    NETDEV_QUERYCOND_SIMILARITY        = 56,               /* ѯƶ */
    NETDEV_QUERYCOND_SEARCH_TYPE       = 57,               /* ѯͣμöֵNETDEV_SEARCH_TYPE_E */
    NETDEV_QUERYCOND_ID_NUMBER         = 58,               /* ѯ֤ */
    NETDEV_QUERYCOND_AGERANGE          = 59,               /* ѯ */
    NETDEV_QUERYCOND_ETHIC             = 60,               /* ѯ */
    NETDEV_QUERYCOND_GLASSES_STYLE     = 61,               /* ѯ۾ʽ */
    NETDEV_QUERYCOND_SLEEVES_LENGTH    = 62,               /* ѯ³̿ʽ */
    NETDEV_QUERYCOND_COAT_COLOR        = 63,               /* ѯɫ */
    NETDEV_QUERYCOND_TROUSERS_STYLE    = 64,               /* ѯ³̿ʽ */
    NETDEV_QUERYCOND_TROUSERS_COLOR    = 65,               /* ѯɫ */
    NETDEV_QUERYCOND_SNAP_TOWARD       = 66,               /* ѯץĳ */
    NETDEV_QUERYCOND_SHOES_TUBE_LENGTH = 67,               /* ѯЬӳ̿ʽ */
    NETDEV_QUERYCOND_HAIR_LENGTH       = 68,               /* ѯͳ */
    NETDEV_QUERYCOND_BAG_FLAG          = 69,               /* ѯǷЯ */
    NETDEV_QUERYCOND_SPEED_TYPE        = 70,               /* ѯٶ */
    NETDEV_QUERYCOND_NON_VEH_TYPE      = 71,               /* ѯǻ */
    NETDEV_QUERYCOND_VEH_BRAND         = 72,               /* ѯƷ */
    NETDEV_QUERYCOND_VEH_DATA_TYPE     = 73,               /* ѯͣ0ͨץݣ1ṹץݣ */
    NETDEV_QUERYCOND_PROTOCOL_TYPE             = 74,       /* ѯ豸Э */
    NETDEV_QUERYCOND_RELEVANT_ROOM             = 75,       /* ѯ */
    NETDEV_QUERYCOND_LOCK_SIGNAL               = 76,       /* ѯź */
    NETDEV_QUERYCOND_BIND_RELATION_DOORLOCK    = 77,       /* ѯ󶨹ϵ */
    NETDEV_QUERYCOND_BIND_RELATION_PERSON_CARD = 78,       /* ѯ˿󶨹ϵ */
    NETDEV_QUERYCOND_PERSONID                  = 79,       /* ѯԱID */
    NETDEV_QUERYCOND_PARKINGLOTID              = 80,       /* ѯͣID */
    NETDEV_QUERYCOND_ENTREXITID                = 81,       /* ѯID */
    NETDEV_QUERYCOND_RECORDID                  = 82,       /* ѯ¼ID */
    NETDEV_QUERYCOND_VEH_GROUPINGID            = 83,       /* ѯID */
    NETDEV_QUERYCOND_KEYWORD                   = 84,       /* ѯؼ */
    NETDEV_QUERYCOND_PUBULISH_TYPE             = 85,       /* ѯ (0ʱ, 1ų̷) */
    NETDEV_QUERYCOND_PROGRAM_NAME              = 86,       /* ѯĿ */
    NETDEV_QUERYCOND_ORG_TYPE                  = 87,       /* ѯ֯  NETDEV_ORG_TYPE_E */
    NETDEV_QUERYCOND_VALID_DATE                = 88,       /* ѯЧ */
    NETDEV_QUERYCOND_VALID_TIME                = 89,       /* ѯЧʱ */
    NETDEV_QUERYCOND_VALID_WEEK                = 90,       /* ѯЧ */
    NETDEV_QUERYCOND_MASK_FLAG                 = 92,       /* ѯֱ־(0δ֪12) */
    NETDEV_QUERYCOND_TEMPERATURE               = 93,       /* ѯԱ */
	
	NETDEV_QUERYCOND_MODEL_STATUS_TYPE         = 91,        /* ѯģ״̬, μ NETDEV_MODEL_STATUS_E */
	
    NETDEV_QUERYCOND_INVALID           = 0xFF              /* Ч */
}NETDEV_QUERYCOND_TYPE_E;

/**
 * @enum tagNETDEVQueryCondLogic
 * @brief ѯ߼
 * @attention  None
 */
typedef enum tagNETDEVQueryCondLogic
{
    NETDEV_QUERYCOND_LOGIC_EQUAL             = 0,                /* ѯ߼ͣ */
    NETDEV_QUERYCOND_LOGIC_GREATER           = 1,                /* ѯ߼ͣ */
    NETDEV_QUERYCOND_LOGIC_LESS              = 2,                /* ѯ߼ͣС */
    NETDEV_QUERYCOND_LOGIC_NO_LESS           = 3,                /* ѯ߼ͣС */
    NETDEV_QUERYCOND_LOGIC_NO_GREATER        = 4,                /* ѯ߼ͣ */
    NETDEV_QUERYCOND_LOGIC_NO_EQUAL          = 5,                /* ѯ߼ͣ */
    NETDEV_QUERYCOND_LOGIC_DIM_QUERY         = 6,                /* ѯ߼ͣģѯ */
    NETDEV_QUERYCOND_LOGIC_CONTAIN           = 7,                /* ѯ߼ͣ */
    NETDEV_QUERYCOND_LOGIC_ASC_ORDER         = 8,                /* ѯ߼ͣ */
    NETDEV_QUERYCOND_LOGIC_DESC_ORDER        = 9                 /* ѯ߼ͣ */
}NETDEV_QUERYCOND_LOGICTYPE_E;

/**
* @enum tagNETDEVFaceMatchAlarmType
* @brief ץƥ澯ö
* @attention 
*/
typedef enum tagNETDEVFaceMatchAlarmType
{
    NETDEV_FACE_MATCH_TYPE_SNAPSHOT      = 1,               /* ץ */
    NETDEV_FACE_MATCH_ALARM              = 2,               /* ƥ澯 */
    NETDEV_FACE_NOT_MATCH_ALARM          = 4,               /* ƥ澯 */

    NETDEV_FACET_MATCH_TYPE_INVALID     = 0xFF              /* Чֵ */
}NETDEV_FACE_MATCH_ALARM_TYPE_E;

/* ¼ǩ */
typedef enum tagNETDEVRecodeLabelResult
{
    NETDEV_RECODE_LABEL_SUCCESS     = 0,        /* ɹ */
    NETDEV_RECODE_LABEL_FAIL_MAX    = 1,        /* ǩﵽﵽֵ */
    NETDEV_RECODE_LABEL_FAIL_OTHER  = 2         /*  */
}NETDEV_RECODE_LABEL_RESULT_E;


typedef enum tagNETDEVAccessProtocol
{
    NETDEV_ACCESS_PROTOCOL_ONVIF                = 1,                /* onvifЭ */
    NETDEV_ACCESS_PROTOCOL_UNV                  = 2,                /* ˽Э */
    NETDEV_ACCESS_PROTOCOL_GB                   = 3,                /*  */
    NETDEV_ACCESS_PROTOCOL_RTSP                 = 4,                /* RTSP */

    NETDEV_ACCESS_PROTOCOL_INVALID              = 0xFF              /* Чֵ */
}NETDEV_ACCESS_PROTOCOL_E;

/**
 * @enum tagNETDEVChnOffReason
 * @brief 豸ԭö
 * @attention  None
 */
typedef enum tagNETDEVChnOffReason
{
    NETDEV_CHN_OFF_REASON_CONNECTING                = 0,                /*  */
    NETDEV_CHN_OFF_REASON_ONLINE                    = 1,                /*  */
    NETDEV_CHN_OFF_REASON_WRONG_PWD                 = 2,                /* û */
    NETDEV_CHN_OFF_REASON_NETWORK_ERROR             = 3,                /* 粻ͨ */
    NETDEV_CHN_OFF_REASON_SET_LIVE_STREAM_ERROR     = 4,                /* ʵʧ */
    NETDEV_CHN_OFF_REASON_START_LIVE_STREAM_ERROR   = 5,                /* ʵʧ */
    NETDEV_CHN_OFF_REASON_STREAM_INTERUP            = 6,                /* ýж */
    NETDEV_CHN_OFF_REASON_TIMEOUT                   = 7,                /* ʱ */
    NETDEV_CHN_OFF_REASON_WAIT_REGIST               = 8,                /* IPCȴעᱨ */
    NETDEV_CHN_OFF_REASON_MODIFY_LIVE_STREAM_ERROR  = 9,                /* IPC޸Э */
    NETDEV_CHN_OFF_REASON_POE_POWER_ERROR           = 10,               /* PoEڹ쳣 */
    NETDEV_CHN_OFF_REASON_BW_RECV_NOT_ENOUGH        = 11,               /*  */
    NETDEV_CHN_OFF_REASON_WEAK_PWD_ERROR            = 12,               /* ܾ */

    NETDEV_CHN_OFF_REASON_INVALID                   = 0xFF              /* Чֵ */
}NETDEV_CHN_OFF_REASON_E;


/**
 * @enum tagNETDEVPoEStatus
 * @brief POE״̬ö
 * @attention  None
 */
typedef enum tagNETDEVPoEStatus
{
    NETDEV_POE_STATUS_NORMAL                = 1,                /*  */
    NETDEV_POE_STATUS_POWER_SHORTAGE        = 2,                /* ʲ */
    NETDEV_POE_STATUS_POWER_OVERLOAP        = 4,                /* ˿ڸعʳ */
    NETDEV_POE_STATUS_NONEED_POWER          = 8,                /* ˿蹩*/

    NETDEV_POE_STATUS_INVALID               = 0xFF              /* Чֵ */
}NETDEV_POE_STATUS_E;

/**
 * @enum tagNETDEVVideoChnFindType
 * @brief ƵͨϢö
 * @attention  None
 */
typedef enum tagNETDEVVideoChnFindType
{
    NETDEV_VIDEO_CHN_FIND_TYPE_ALL              = 0,         /*  */
    NETDEV_VIDEO_CHN_FIND_TYPE_DEV_ORG_ID       = 1,         /* ָ֯IDָ豸ID */
    NETDEV_VIDEO_CHN_FIND_TYPE_DEV_ID           = 2,         /* ָ豸ID */
    NETDEV_VIDEO_CHN_FIND_TYPE_ORG_ID           = 3,         /* ָ֯ID */


    NETDEV_VIDEO_CHN_FIND_TYPE_INVALID          = 0XFF       /* Чֵ */
}NETDEV_VIDEO_CHN_FIND_TYPE_E;

/**
 * @enum tagNETDEVOrgFindMode
 * @brief ֯ģʽö
 * @attention  None
 */
typedef enum tagNETDEVOrgFindMode
{
    NETDEV_ORG_FIND_MODE_ID          = 0,            /* ֯ID */
    NETDEV_ORG_FIND_MODE_TYPE        = 1,            /* ֯ */


    NETDEV_ORG_FIND_MODE_INVALID            = 0XFF       /* Чֵ */
}NETDEV_ORG_FIND_MODE_E;

/**
 * @brief 豸
 * @attention  None
 */
typedef enum tagNETDEVDeviceSubType
{
    NETDEV_DTYPE_SUB_NVR                = 0,                /* NVR */
    NETDEV_DTYPE_SUB_IPC                = 1,                /* IPC */
    NETDEV_DTYPE_SUB_DC_INNER           = 2,                /* DC */ 
    NETDEV_DTYPE_SUB_DC_EXT             = 3,                /* DC */
    NETDEV_DTYPE_SUB_EC                 = 4,                /* EC */
    NETDEV_DTYPE_SUB_VMS                = 5,                /* һ */ 
    NETDEV_DTYPE_SUB_DA                 = 6,                /* 豸 */ 
    NETDEV_DTYPE_SUB_ADU                = 7,                /* ADUƴ豸 */
    NETDEV_DTYPE_SUB_FISHEYE_IPC        = 8,                /* 豸 */
    NETDEV_DTYPE_SUB_DECARD             = 9,                /* 뿨豸 */
    NETDEV_DTYPE_SUB_FACE_IPC           = 10,               /* ʶ */
    NETDEV_DTYPE_SUB_ALARMHOST          = 11,               /* 豸 */
    NETDEV_DTYPE_SUB_ACS                = 12,               /* Ž豸 */
    NETDEV_DTYPE_SUB_FG                 = 13,               /* ͨ豸*/
    NETDEV_DTYPE_SUB_FACE_ACS           = 14,               /* Ž豸 */
    NETDEV_DTYPE_SUB_UNV_GENERAL_ACS    = 15,               /* ͨŽ豸 */
    NETDEV_DTYPE_SUB_UNV_ALARMHOST      = 16,               /* ӱ豸 */
    NETDEV_DTYPE_SUB_LOCK_DEV           = 17,               /* 豸 */

    NETDEV_DTYPE_SUB_UNKNOW             = 0xFF              /* δ֪豸 */
}NETDEV_DEVICE_SUB_TYPE_E;

/**
 * @enum tagNETDEVLayoutType
 * @brief /ģʽ
 * @attention  None
 */
typedef enum tagNETDEVLayoutType
{
    /* Layout=aabb, aa bbͬ²ͬķ */

    NETDEV_LAYOUT_TYPE_01          =  100, /* 1      */
    NETDEV_LAYOUT_TYPE_02          =  200, /* 2      */
    NETDEV_LAYOUT_TYPE_03          =  300, /* 3      */
    NETDEV_LAYOUT_TYPE_04_1        =  400, /* 4      */
    NETDEV_LAYOUT_TYPE_04_2        =  401, /* 1+1+2  */
    NETDEV_LAYOUT_TYPE_05_1        =  500, /* 1+3+1   */
    NETDEV_LAYOUT_TYPE_05_2        =  501, /* 1+1+3   */
    NETDEV_LAYOUT_TYPE_06          =  600, /* 1+5    */
    NETDEV_LAYOUT_TYPE_07          =  700, /* 1+6    */
    NETDEV_LAYOUT_TYPE_08          =  800, /* 1+7    */
    NETDEV_LAYOUT_TYPE_09          =  900, /* 9      */
    NETDEV_LAYOUT_TYPE_10_1        = 1000, /* 1+9    */
    NETDEV_LAYOUT_TYPE_10_2        = 1001, /* 2+9    */
    NETDEV_LAYOUT_TYPE_13          = 1300, /* 1+12   */
    NETDEV_LAYOUT_TYPE_16          = 1600, /* 16     */
    NETDEV_LAYOUT_TYPE_17          = 1700, /* 1+16   */
    NETDEV_LAYOUT_TYPE_25          = 2500, /* 25     */
    NETDEV_LAYOUT_TYPE_32          = 3200, /* 3+1+28 */
    NETDEV_LAYOUT_TYPE_36          = 3600, /* 36     */
    NETDEV_LAYOUT_TYPE_64          = 6400, /* 64     */
    NETDEV_LAYOUT_TYPE_10001       = 10001,/* Զ1 */
    NETDEV_LAYOUT_TYPE_10002       = 10002,/* Զ2 */
    NETDEV_LAYOUT_TYPE_10003       = 10003,/* Զ3 */
    NETDEV_LAYOUT_TYPE_10004       = 10004,/* Զ4 */
    NETDEV_LAYOUT_TYPE_10005       = 10005,/* Զ5 */
    NETDEV_LAYOUT_TYPE_10006       = 10006,/* Զ6 */
    NETDEV_LAYOUT_TYPE_10007       = 10007,/* Զ7 */
    NETDEV_LAYOUT_TYPE_10008       = 10008,/* Զ8 */


    NETDEV_LAYOUT_TYPE_INVALID
}NETDEV_LAYOUT_TYPE_E;


/**
* @enum tagNETDEVDCSeqStatus
* @brief DCѲ״̬
* @attention  None
*/
typedef enum tagNETDEVDCSeqStatus
{
    NETDEV_DC_SEQSTATUS_START           = 0,            /* Ѳִ״̬ */
    NETDEV_DC_SEQSTATUS_PAUSE           = 1,            /* Ѳִ״̬ͣ */
    NETDEV_DC_SEQSTATUS_STOP            = 2,            /* Ѳִ״ֹ̬ͣ */

    NETDEV_DC_SEQSTATUS_INVALID         = 0xff          /* Чֵ */
}NETDEV_DC_SEQ_STATUS_E;


/**
 * @enum tagNETDEVDCVideoFormat
 * @brief DC Ƶʽ
 * @attention  None
 */
typedef enum tagNETDEVDCVideoFormat
{
    NETDEV_DC_VF_PAL        = 0,
    NETDEV_DC_VF_NTSC       = 1,
    NETDEV_DC_VF_720P24     = 2,
    NETDEV_DC_VF_720P25     = 3,
    NETDEV_DC_VF_720P30     = 4,
    NETDEV_DC_VF_720P50     = 5,
    NETDEV_DC_VF_720P60     = 6,
    NETDEV_DC_VF_1080I48    = 7,
    NETDEV_DC_VF_1080I50    = 8,
    NETDEV_DC_VF_1080I60    = 9,
    NETDEV_DC_VF_1080P24    = 10,
    NETDEV_DC_VF_1080P25    = 11,
    NETDEV_DC_VF_1080P30    = 12,
    NETDEV_DC_VF_1080P50    = 13,
    NETDEV_DC_VF_1080P60    = 14,
    NETDEV_DC_VF_XGA60      = 15,
    NETDEV_DC_VF_SXGA60     = 16,
    NETDEV_DC_VF_UXGA60     = 17,
    NETDEV_DC_VF_SXGAP60HZ  = 18,
    NETDEV_DC_VF_WXGAP60HZ  = 19,
    NETDEV_DC_VF_WSXGA60HZ  = 20,
    NETDEV_DC_VF_4K30       = 21,
    NETDEV_DC_VF_4K60       = 22,
    NETDEV_DC_VF_MUXGA60HZ  = 23,

    NETDEV_DC_VF_QXGA60     = 41,
    NETDEV_DC_VF_WQXGA60    = 42,
    NETDEV_DC_VF_4M60       = 43,
    
    NETDEV_DC_VF_INVALID    = 0xff
}NETDEV_DC_VIDEOFORMAT_E;

/**
 * @enum tagNETDEVAlarmPlanType
 * @brief 澯Ԥ
 * @attention  None
 */
typedef enum tagNETDEVAlarmPlanType
{
    NETDEV_ALARM_PLAN_TYPE_STORE        = 0,            /* 洢ƻ */
    NETDEV_ALARM_PLAN_TYPE_BS           = 1,            /* B/S */
    NETDEV_ALARM_PLAN_TYPE_CS           = 2,            /* C/S */

    NETDEV_ALARM_PLAN_TYPE_INVALID      = 0xff          /* Чֵ */
}NETDEV_ALARM_PLAN_TYPE_E;
/**
 * @enum tagNETDEVPaneOperateType
 * @brief 澯Ԥ
 * @attention  None
 */
typedef enum tagNETDEVPaneOperateType
{
    NETDEV_PANE_OPERATE_TYPE_BIND_CHANNEL        = 0,            /* ͨ */
    NETDEV_PANE_OPERATE_TYPE_UNBIND_CHANNEL      = 1,            /* ͨ */

    NETDEV_PANE_OPERATE_TYPE_INVALID             = 0xff          /* Чֵ */
}NETDEV_PANE_OPERATE_TYPE_E;

/**
 * @enum tagNETDEVTimeTemplateType
 * @brief ʱģ
 * @attention  None
 */
typedef enum tagNETDEVTimeTemplateType
{
    NETDEV_TIMETEMPLATE_TYPE_RECORD     = 0,                /* ¼ƻ */
    NETDEV_TIMETEMPLATE_TYPE_ALARM      = 1,                /* 澯ƻ */
    /* 23CSݲʹãwebʹ 2ûʱģ壬 3΢Сʹ */
    NETDEV_TIMETEMPLATE_TYPE_SEQUENCE   = 4,                /* Ѳ */
    NETDEV_TIMETEMPLATE_TYPE_ACS        = 5,                /* Ž */
    NETDEV_TIMETEMPLATE_TYPE_INVALID    = 0xFF              /* Ч */
}NETDEV_TIME_TEMPLATE_TYPE_E;

/**
 * @enum tagNETDEVAlarmLinkType
 * @brief 澯
 * @attention  None
 */
typedef enum tagNETDEVAlarmLinkType
{
    NETDEV_ALARM_LINK_TYPE_STORE        = 0X01,         /* 洢 */
    NETDEV_ALARM_LINK_TYPE_PRESET       = 0X02,         /* Ԥλ */
    NETDEV_ALARM_LINK_TYPE_MONITOR      = 0X04,         /* ʵ */
    NETDEV_ALARM_LINK_TYPE_SWITCHOUT    = 0X08,         /*  */
    NETDEV_ALARM_LINK_TYPE_EMAIL        = 0X10,         /* ʼ */
    NETDEV_ALARM_LINK_TYPE_WALL         = 0X20,         /* ǽ */
    NETDEV_ALARM_LINK_TYPE_BUZZER       = 0X40,         /* һ豸 */
    NETDEV_ALARM_LINK_TYPE_LOCALAUDIO   = 0X80,         /* 澯 */

    NETDEV_ALARM_LINK_TYPE_INVALID      = 0xFF          /* Ч */
}NETDEV_ALARM_LINK_TYPE_E;



/**
 * @enum tagNETDEVEMapPicType
 * @brief ӵͼͼƬ
 * @attention  None
 */
typedef enum tagNETDEVEMapPicType
{
    NETDEV_EMAP_PIC_TYPE_MAP        = 0,                    /* ͼ */
    NETDEV_EMAP_PIC_TYPE_MARKER     = 1,                    /* ͼ */

    NETDEV_EMAP_PIC_TYPE_INVALID    = 0xFF                  /* Чֵ */
}NETDEV_EMAP_PIC_TYPE;

/**
 * @enum tagNETDEVEMapPicSubType
 * @brief ӵͼͼƬ
 * @attention  None
 */
typedef enum tagNETDEVEMapPicSubType
{
    NETDEV_EMAP_PIC_SUBTYPE_HOTAREA        = 0,                    /* ͼ */
    NETDEV_EMAP_PIC_SUBTYPE_PTZ_IPC        = 1,                    /* ̨ȵͼ */
    NETDEV_EMAP_PIC_SUBTYPE_NON_PTZ_IPC    = 2,                    /* ̨ȵͼ */
    NETDEV_EMAP_PIC_SUBTYPE_ALARM          = 3,                    /* ȵͼ */
    NETDEV_EMAP_PIC_SUBTYPE_ACS            = 4,                    /* Žȵͼ */
    NETDEV_EMAP_PIC_SUBTYPE_INVALID        = 0xFF                  /* Чֵ */
}NETDEV_EMAP_PIC_SUBTYPE;

/**
 * @enum tagNETDEVEMapMarkerType
 * @brief ӵͼ
 * @attention  None
 */
typedef enum tagNETDEVEMapMarkerType
{
    NETDEV_EMAP_MARKER_TYPE_HOTAREA       = 0,                    /*  */
    NETDEV_EMAP_MARKER_TYPE_VIDEO         = 1,                    /* Ƶȵ */
    NETDEV_EMAP_MARKER_TYPE_ALARMIN       = 2,                    /* ȵ */
    NETDEV_EMAP_MARKER_TYPE_ACS           = 3,                    /* Žȵ */
    NETDEV_EMAP_MARKER_TYPE_INVALID       = 0xFF                  /* Чֵ */
}NETDEV_EMAP_MARKER_TYPE_E;

/**
 * @enum tagNETDEVEMapMarkerColor
 * @brief ӵͼɫ
 * @attention  None
 */
typedef enum tagNETDEVEMapMarkerColor
{
    NETDEV_EMAP_MARKER_COLOR_GREEN       = 0,                    /* ɫ */
    NETDEV_EMAP_MARKER_COLOR_WHITE       = 1,                    /* ɫ */
    NETDEV_EMAP_MARKER_COLOR_RED         = 2,                    /* ɫ */
    NETDEV_EMAP_MARKER_COLOR_YELLOW      = 3,                    /* ɫ */
    NETDEV_EMAP_MARKER_COLOR_BLUE        = 4,                    /* ɫ */
    NETDEV_EMAP_MARKER_COLOR_GRAY        = 5,                    /* ɫ */
    NETDEV_EMAP_MARKER_COLOR_BLACK       = 6,                    /* ɫ */
    NETDEV_EMAP_MARKER_COLOR_INVALID     = 0xFF                  /* Чֵ */
}NETDEV_EMAP_MARKER_COLOR_E;

/**
 * @enum tagNETDEVViewResType
 * @brief ͼԴ
 * @attention  None
 */
typedef enum tagNETDEVViewResType
{
    NETDEV_VIEW_TYPE_SCHEME     = 0,                        /* Ѳ */
    NETDEV_VIEW_TYPE_REALPLAY   = 1,                        /* ʵ*/

    NETDEV_VIEW_TYPE_INVALID    = 0xFF                      /* Ч */
}NETDEV_VIEW_TYPE_E;

/* һȨ */
typedef enum tagNETDEVRoleMajorRight
{
    /* 豸Ȩ */
    NETDEV_MAJOR_DEV_VIDEO_CHANNEL                  = 1,               /* ƵͨȨ     NETDEV_MINOR_RIGHT_VIDEO_CHANNEL_E */
    NETDEV_MAJOR_DEV_AUDIO_CHANNEL                  = 2,               /* ƵͨȨ     NETDEV_MINOR_RIGHT_AUDIO_CHANNEL_E */
    NETDEV_MAJOR_DEV_ALARM_POINT_CHANNEL            = 5,               /* Ȩ     NETDEV_MINOR_RIGHT_ALARM_POINT_CHANNEL_E */
    NETDEV_MAJOR_DEV_DOOR_CHANNEL                   = 6,               /* ŽͨȨ     NETDEV_MINOR_RIGHT_DOOR_CHANNEL_E */
    NETDEV_ROLE_MAJOR_DEV_TVWALL_RIGHT              = 7,               /* ǽȨ       NETDEV_MINOR_RIGHT_TVWALL_E */
    NETDEV_ROLE_MAJOR_DEV_PARKINGLOT_RIGHT          = 8,               /* ͣȨ       NETDEV_MINOR_RIGHT_PARKINGLOT_E */
    NETDEV_MAJOR_DEV_MAX                            = 9,

    /* Ȩ */
    NETDEV_MAJOR_OPER_PREVIEW                       = 100,              /* Ԥ      NETDEV_MINOR_RIGHT_OPER_PREVIEW_E */
    NETDEV_MAJOR_OPER_ALARM                         = 101,              /* ˸澯      NETDEV_MINOR_RIGHT_OPER_ALARM_E */
    NETDEV_MAJOR_OPER_EMAP                          = 102,              /* ˵ӵͼ  NETDEV_MINOR_RIGHT_OPER_EMAP_E */
    NETDEV_MAJOR_OPER_VOICE                         = 103,              /*       NETDEV_MINOR_RIGHT_OPER_VOICE_E */
    NETDEV_MAJOR_OPER_TVWALL                        = 104,              /* ˵ǽ    NETDEV_MINOR_RIGHT_OPER_TVWALL_E */
    NETDEV_MAJOR_OPER_MONITOR_SCHEME                = 105,              /* ѲԤ  NETDEV_MINOR_RIGHT_OPER_MONITOR_SCHEME_E */
    NETDEV_MAJOR_OPER_SEQUENCE_RESOURCE             = 106,              /* ѲԴ  NETDEV_MINOR_RIGHT_OPER_SEQUENCE_RESOURCE_E */
    NETDEV_MAJOR_OPER_INTELLIGENT                   = 107,              /*       NETDEV_MINOR_RIGHT_OPER_INTELLIGENT_E */
    NETDEV_MAJOR_OPER_ALARM_POINT_CONFIG            = 108,              /* ˱ */
    NETDEV_MAJOR_OPER_DOOR_CONFIG                   = 109,              /* Ž  NETDEV_MINOR_RIGHT_OPER_DOOR_CONFIG_E */
    NETDEV_MAJOR_OPER_FACE_RECOGNITION              = 110,              /* ʶ  NETDEV_MINOR_RIGHT_OPER_FACE_RECOGNITION_E */
    NETDEV_MAJOR_OPER_VEHICLE_RECOGNITION           = 111,              /* ˳ʶ  NETDEV_MINOR_RIGHT_OPER_VEHICLE_RECOGNITION_E */
    NETDEV_MAJOR_OPER_MONITOR_VIEWPLAN              = 112,              /* ͼƻ  NETDEV_MINOR_RIGHT_OPER_VIEWPLAN_E */
    NETDEV_MAJOR_OPER_PARKINGLOT                    = 113,              /* ͣ    NETDEV_MINOR_RIGHT_OPER_PARKINGLOT */
    NETDEV_MAJOR_OPER_MONITOR_MIXEDDETECTION        = 114,              /* ˻м  NETDEV_MINOR_RIGHT_OPER_MIXEDDETECTION_E */
    NETDEV_MAJOR_OPER_MAX                           = 115,

    /*  */
    NETDEV_MAJOR_MGR_BAS_CONFIG                     = 200,              /* ˻  NETDEV_MINOR_RIGHT_MGR_BASE_E */
    NETDEV_MAJOR_MGR_SVC_CONFIG                     = 201,              /* ҵ  NETDEV_MINOR_RIGHT_MGR_SVC_E */
    NETDEV_MAJOR_MGR_SYS_CONFIG                     = 202,              /* ϵͳ  NETDEV_MINOR_RIGHT_MGR_SYS_E */
    NETDEV_MAJOR_MGR_STATISTICS                     = 203,              /* άͳ  NETDEV_MINOR_RIGHT_MGR_STAT_E */
    NETDEV_ROLE_MAJOR_MGR_VIDEO_APPLICATION         = 204,              /* ƵӦ  NETDEV_MINOR_RIGHT_MGR_VIDEO_E */
    NETDEV_ROLE_MAJOR_MGR_ACS_CONFIG                = 205,              /* Ž  NETDEV_MINOR_RIGHT_MGR_ACS_E */
    NETDEV_ROLE_MAJOR_MGR_PARKING_LOT               = 206,              /* ͣ    NETDEV_MINOR_RIGHT_MGR_PARK_LOT_CFG_E */
    NETDEV_MAJOR_MGR_MAX                            = 207,

    NETDEV_MAJOR_BULT                               = 300
}NETDEV_MAJOR_RIGHT_E;

/* 豸ƵͨȨ */
typedef enum tagNETDEVDevVChlRight
{
    NETDEV_MINOR_VIDEO_CHANNEL_LIVE          = BIT0,            /* ʵԤ */
    NETDEV_MINOR_VIDEO_CHANNEL_PLAYBACK      = BIT1,            /* ¼ط */
    NETDEV_MINOR_VIDEO_CHANNEL_DOWNLOAD      = BIT2,            /* ¼ */
    NETDEV_MINOR_VIDEO_CHANNEL_PTZ           = BIT3,            /* ̨ */
    NETDEV_MINOR_VIDEO_CHANNEL_CENTER_RECORD = BIT4,            /* ¼ */

    NETDEV_MINOR_VIDEO_CHANNEL_ALL           = ((UINT32)(~0UL))
}NETDEV_MINOR_RIGHT_VIDEO_CHANNEL_E;

/* 豸ƵͨȨ */
typedef enum tagNETDEVDevAChlRight
{
    NETDEV_MINOR_AUDIO_CHANNEL_TALK             = BIT0,        /* Խ */
    NETDEV_MINOR_AUDIO_CHANNEL_BROADCAST        = BIT1,        /* 㲥 */
    NETDEV_MINOR_AUDIO_CHANNEL_ASSOCIATEAUDIO   = BIT2,        /* ·Ƶ */

    NETDEV_MINOR_AUDIO_CHANNEL_ALL              = BIT32_MAX
}NETDEV_MINOR_RIGHT_AUDIO_CHANNEL_E;

/* 豸ͨȨ */
typedef enum tagNETDEVDevAPChlRightE
{
    NETDEV_MINOR_ALARM_POINT_CHANNEL_CONTROL = BIT0, /* ֶͨ */

    NETDEV_MINOR_ALARM_POINT_CHANNEL_ALL     = BIT32_MAX
}NETDEV_MINOR_RIGHT_ALARM_POINT_CHANNEL_E;

/* 豸ŽͨȨ */
typedef enum tagNETDEVDevDoorChlRightE
{
    NETDEV_MINOR_DOOR_CHANNEL_CONTROL = BIT0, /* Žֶͨ */

    NETDEV_MINOR_DOOR_CHANNEL_ALL     = BIT32_MAX
}NETDEV_MINOR_RIGHT_DOOR_CHANNEL_E;

/* ǽȨ */
typedef enum tagNetDevTvwallRightE
{
    NETDEV_ROLE_MINOR_TVWALL_CHANNEL_CONTROL         = BIT0, /* ǽ */
    NETDEV_ROLE_MINOR_TVWALL_CHANNEL_ALL             = BIT32_MAX
}NETDEV_MINOR_RIGHT_TVWALL_E;

/* ͣȨ */
typedef enum tagNetDevParkingLotRightE
{
    NETDEV_ROLE_MINOR_PARKINGLOT_ENTRANCE_BIND = BIT0, /* ڰ */
    NETDEV_ROLE_MINOR_PARKINGLOT_ALL = BIT32_MAX
}NETDEV_MINOR_RIGHT_PARKINGLOT_E;

/* ԤȨ */
typedef enum tagNETDEVOperPreviewRight
{
    NETDEV_MINOR_OPER_PREVIEW_LIVE          = BIT0,            /* ʵ */
    NETDEV_MINOR_OPER_PREVIEW_PLAYBACK      = BIT1,            /* ط */

    NETDEV_MINOR_OPER_PREVIEW_ALL           = BIT32_MAX
}NETDEV_MINOR_RIGHT_OPER_PREVIEW_E;

/* ˸澯Ȩ */
typedef enum tagNETDEVOperAlarmRight
{
    NETDEV_MINOR_OPER_ALARM_CONFIG          = BIT0,            /* Ԥ */

    NETDEV_MINOR_OPER_ALARM_ALL             = BIT32_MAX
}NETDEV_MINOR_RIGHT_OPER_ALARM_E;

/* ˵ӵͼȨ */
typedef enum tagNETDEVOperEmapRight
{
    NETDEV_MINOR_OPER_EMAP_CONFIG           = BIT0,            /*  */
    NETDEV_MINOR_OPER_EMAP_OPERATE          = BIT1,            /*  */

    NETDEV_MINOR_OPER_EMAP_ALL              = BIT32_MAX
}NETDEV_MINOR_RIGHT_OPER_EMAP_E;

/* Ȩ */
typedef enum tagNETDEVOperVoiceRight
{
    NETDEV_MINOR_OPER_VOICE_TALK            = BIT0,            /* Խ */
    NETDEV_MINOR_OPER_VOICE_BROADCAST       = BIT1,            /* 㲥 */

    NETDEV_MINOR_OPER_VOICE_ALL             = BIT32_MAX
}NETDEV_MINOR_RIGHT_OPER_VOICE_E;

/* ˵ǽȨ */
typedef enum tagNETDEVOperTvwallRight
{
    NETDEV_MINOR_OPER_TVWALL_CONFIG         = BIT0,            /*  */
    NETDEV_MINOR_OPER_TVWALL_OPERATE        = BIT1,            /*  */

    NETDEV_MINOR_OPER_TVWALL_ALL            = BIT32_MAX
}NETDEV_MINOR_RIGHT_OPER_TVWALL_E;

/* ѲԤȨ */
typedef enum tagNETDEVOperMonitorSchemeRight
{
    NETDEV_MINOR_OPER_MONITOR_SCHEME_CONFIG  = BIT0,           /*  */
    NETDEV_MINOR_OPER_MONITOR_SCHEME_OPERATE = BIT1,           /*  */

    NETDEV_MINOR_OPER_MONITOR_SCHEME_ALL     = BIT32_MAX
}NETDEV_MINOR_RIGHT_OPER_MONITOR_SCHEME_E;

/* ѲԴȨ */
typedef enum tagNETDEVOperSequenceResourceRight
{
    NETDEV_MINOR_OPER_SEQUENCE_RESOURCE_CONFIG  = BIT0,        /*  */
    NETDEV_MINOR_OPER_SEQUENCE_RESOURCE_OPERATE = BIT1,        /*  */

    NETDEV_MINOR_OPER_SEQUENCE_RESOURCE_ALL     = BIT32_MAX
}NETDEV_MINOR_RIGHT_OPER_SEQUENCE_RESOURCE_E;

/* ܶȨ */
typedef enum tagNETDEVOperIntelligentRight
{
    NETDEV_MINOR_OPER_INTELLIGENT_PASSENGER_RFLOW   = BIT0,    /* ѯ */
    NETDEV_MINOR_OPER_INTELLIGENT_VCA_ALARM_PIC     = BIT1,    /* ܸ澯ͼƬѯ */

    NETDEV_MINOR_OPER_INTELLIGENT_ALL = BIT32_MAX
}NETDEV_MINOR_RIGHT_OPER_INTELLIGENT_E;

/* ŽȨ */
typedef enum tagNETDEVOperDoorConfigRightE
{
    NETDEV_MINOR_OPER_DOOR_CONFIG                              = BIT0,     /* Ž */
    NETDEV_MINOR_OPER_DOOR_ACCESS_RECORD_AND_ATTENDANCE_RECORD = BIT1,     /* ¼Ϳͳ */
    NETDEV_MINOR_OPER_DOOR_PEOPLE_MANAGEMENT                   = BIT2,     /* Ա */
    NETDEV_MINOR_OPER_PERMISSION_GROUP_AND_VISITOR_BLACKLIST   = BIT3,     /* Ȩͺ */

    NETDEV_MINOR_OPER_DOOR_ALL                                 = BIT32_MAX
}NETDEV_MINOR_RIGHT_OPER_DOOR_CONFIG_E;

/* ʶȨ */
typedef enum tagNETDEVOperFaceRecognitionE
{
    NETDEV_MINOR_OPER_REAL_TIME_MONITORING      = BIT0,     /* ʵʱ */
    NETDEV_MINOR_OPER_DATABASE_MANAGE           = BIT1,     /*  */
    NETDEV_MINOR_OPER_DISPATCH_TASK             = BIT2,     /*  */
    NETDEV_MINOR_OPER_ALARM_RECORD              = BIT3,     /* 澯¼ */
    NETDEV_MINOR_OPER_SMARTNVR_CONFIG           = BIT4,     /* NVR */
    NETDEV_MINOR_OPER_HISTORY_RECORD            = BIT5,     /* ˼¼ */

    NETDEV_MINOR_OPER_FACE_RECOGNITION_ALL      = BIT32_MAX
}NETDEV_MINOR_RIGHT_OPER_FACE_RECOGNITION_E;

/* ˳ʶȨ */
typedef enum tagNETDEVOperVehicleRecognitionE
{
    NETDEV_MINOR_OPER_VEHICLE_REAL_TIME_MONITORING   = BIT0,          /* ʵʱ */
    NETDEV_MINOR_OPER_VEHICLE_PASSING_RECORD         = BIT1,          /* ¼ */
    NETDEV_MINOR_OPER_VEHICLE_DISPATCH_TASK          = BIT2,          /*  */
    NETDEV_MINOR_OPER_VEHICLE_HISTORY_RECORD         = BIT3,          /* ʷ澯¼ */
    NETDEV_MINOR_OPER_VEHICLE_DATABASE_MANAGE        = BIT4,          /* ƿ */

    NETDEV_MINOR_OPER_VEHICLE_RECOGNITION_ALL = BIT32_MAX
}NETDEV_MINOR_RIGHT_OPER_VEHICLE_RECOGNITION_E;

/* ͼƻȨ */
typedef enum tagNetDevOperSequencePlanRightE
{
    NETDEV_ROLE_MINOR_OPER_VIEWPLAN_CONFIG  = BIT0,             /*  */
    NETDEV_ROLE_MINOR_OPER_VIEWPLAN_OPERATE = BIT1,             /*  */
    NETDEV_ROLE_MINOR_OPER_VIEWPLAN_ALL     = BIT32_MAX
} NETDEV_MINOR_RIGHT_OPER_VIEWPLAN_E;

/* ͣȨ */
typedef enum tagNetDevOperParkingLotRightE
{
    NETDEV_ROLE_MINOR_OPER_PARKINGLOT_ENTRANCE_CHARGE     = BIT0,    /* շ */
    NETDEV_ROLE_MINOR_OPER_PARKINGLOT_CHARGE_RECORD       = BIT1,    /* շѼ¼ */
    NETDEV_ROLE_MINOR_OPER_PARKINGLOT_PASSING_RECORD      = BIT2,    /* ¼ */
    NETDEV_ROLE_MINOR_OPER_PARKINGLOT_ALL   = BIT32_MAX
}NETDEV_MINOR_RIGHT_OPER_PARKINGLOT;

/* ˻мȨ */
typedef enum tagNetDevOperMixDetectionRightE
{
    NETDEV_ROLE_MINOR_OPER_MIXEDDETECTION_REAL_TIME_MONITORING   = BIT0,    /* ʵʱ */
    NETDEV_ROLE_MINOR_OPER_MIXEDDETECTION_PASSING_RECORD         = BIT1,    /* ͨм¼ */
    NETDEV_ROLE_MINOR_OPER_MIXEDDETECTION_ALL   = BIT32_MAX
}NETDEV_MINOR_RIGHT_OPER_MIXEDDETECTION_E;

/* ˻öȨ */
typedef enum tagNETDEVMgrBaseRight
{
    NETDEV_MINOR_MGR_ORG                 = BIT0,             /* ֯ */
    NETDEV_MINOR_MGR_USER                = BIT1,             /* û */
    NETDEV_MINOR_MGR_USER_ROLE           = BIT2,             /* ɫ */
    NETDEV_MINOR_MGR_DEV                 = BIT3,             /* 豸 */
    NETDEV_MINOR_MGR_DEV_CHANNEL         = BIT4,             /* ͨ */
    NETDEV_MINOR_MGR_SERVER              = BIT5,             /*  */
    NETDEV_MINOR_MGR_LOGICORG            = BIT6,             /* ֯ */
    NETDEV_MINOR_MGR_MGR_RES_RELATION    = BIT7,             /* Դ */
    NETDEV_MINOR_MGR_THIRD_ALARM         = BIT8,             /* 澯 */
    NETDEV_MINOR_MGR_USER_TEMPLATE       = BIT9,             /* ûģ */

    NETDEV_MINOR_MGR_BASE_ALL            = BIT32_MAX
}NETDEV_MINOR_RIGHT_MGR_BASE_E;

/* ҵöȨ */
typedef enum tagNETDEVMgrSvcRight
{
    NETDEV_MINOR_MGR_RECORD_PLAN               = BIT0,          /* ¼ƻ */
    NETDEV_MINOR_MGR_RECORD_PLAN_TEMPLATE      = BIT1,          /* ¼ģ */
    NETDEV_MINOR_MGR_ALARM_CONFIG              = BIT2,          /* 澯 */
    NETDEV_MINOR_MGR_ALARM_PLAN_TEMPLATE       = BIT3,          /* 澯ģ */
    NETDEV_MINOR_MGR_ALARM_CONTACTS            = BIT4,          /* ͨѶ¼ */
    NETDEV_MINOR_MGR_ALARM_NOTIFY_CONFIG       = BIT5,          /* 澯֪ͨ */
    NETDEV_MINOR_MGR_ALARM_LEVEL_CUSTOM        = BIT6,          /* Զ澯 */
    NETDEV_MINOR_MGR_BACKUP_PLAN               = BIT7,          /* ݼƻ */
    NETDEV_MINOR_MGR_USB_RECORD_BACKUP         = BIT8,          /* ¼񱸷 */

    NETDEV_MINOR_MGR_SVC_ALL                   = BIT32_MAX
}NETDEV_MINOR_RIGHT_MGR_SVC_E;

/* ϵͳöȨ */
typedef enum tagNETDEVMgrSysRight
{
    NETDEV_MINOR_MGR_SYS_BASIC              = BIT0,            /*  */
    NETDEV_MINOR_MGR_SYS_DISK               = BIT1,            /* Ӳ */
    NETDEV_MINOR_MGR_SYS_NETWORK            = BIT2,            /*  */
    NETDEV_MINOR_MGR_SYS_MAINTAIN           = BIT3,            /* ϵͳά */
    NETDEV_MINOR_MGR_SYS_SECURITY           = BIT4,            /* ȫ */
    NETDEV_MINOR_MGR_SYS_BATCH              = BIT5,            /*  */
    NETDEV_MINOR_MGR_SYS_ALL                = BIT32_MAX
}NETDEV_MINOR_RIGHT_MGR_SYS_E;

/* άͳƶȨ */
typedef enum tagNETDEVMgrStatRight
{
    NETDEV_MINOR_MGR_STAT_SERVER_DISK       = BIT0,         /* Ӳ״̬ */
    NETDEV_MINOR_MGR_STAT_SERVER_NETWORK    = BIT1,         /* ״̬ */
    NETDEV_MINOR_MGR_STAT_SERVER_USER       = BIT2,         /* û״̬ */
    NETDEV_MINOR_MGR_STAT_DEVICE            = BIT3,         /* 豸״̬ */
    NETDEV_MINOR_MGR_STAT_SYS_ALARM_LOG     = BIT4,         /* ־*/
    NETDEV_MINOR_MGR_STAT_DEVICE_RECORD     = BIT5,         /* ¼״̬ */
    NETDEV_MINOR_MGR_STAT_DEV_ALARM_LOG     = BIT6,         /* 豸־ */
    NETDEV_MINOR_MGR_STAT_OPER_LOG          = BIT7,         /* ־ */
    NETDEV_MINOR_MGR_STAT_PKTLOSS_RATE      = BIT8,         /*  */
    NETDEV_MINOR_MGR_STAT_DEVICE_RESOURCE   = BIT9,         /*  */
    NETDEV_MINOR_MGR_STAT_BACKUP_CAP        = BIT10,        /* ݴ洢 */
    NETDEV_MINOR_MGR_STAT_OVERVIEW          = BIT11,        /*  */
    NETDEV_MINOR_MGR_STAT_ALL               = BIT32_MAX

}NETDEV_MINOR_RIGHT_MGR_STAT_E;

/* ƵӦöȨ */
typedef enum tagNetDevMgrVideoRightE
{
    NETDEV_ROLE_MINOR_MGR_PREVIEW_LIVE        = BIT0,       /* ʵ */
    NETDEV_ROLE_MINOR_MGR_PREVIEW_PLAYBACK    = BIT1,       /* ط */
    NETDEV_ROLE_MINOR_MGR_PREVIEW_ALL         = BIT32_MAX
} NETDEV_MINOR_RIGHT_MGR_VIDEO_E;

/* ŽȨ */
typedef enum tagNetDevMgrAcsMgrRightE
{
    NETDEV_ROLE_MINOR_MGR_PEOPLE_MANAGEMENT          = BIT0,     /* Ա */
    NETDEV_ROLE_MINOR_MGR_ROLETIME_TEMPLATE          = BIT1,     /* ʱģ */
    NETDEV_ROLE_MINOR_MGR_ACCESSROLE_GROUP           = BIT2,     /* ŽȨ */
    NETDEV_ROLE_MINOR_MGR_AUTHORIZED_BY_PERSON       = BIT3,     /* Ȩ */
    NETDEV_ROLE_MINOR_MGR_AUTHORIZED_BY_DOOR         = BIT4,     /* Ȩ */
    NETDEV_ROLE_MINOR_MGR_CARD_MANAGEMENT            = BIT5,     /* ſ */
    NETDEV_ROLE_MINOR_MGR_ACS_ALL                    = BIT32_MAX
} NETDEV_MINOR_RIGHT_MGR_ACS_E;

/* ˳ڲȨ */
typedef enum tagNetDevMgrParkLotCfgRightE
{
    NETDEV_ROLE_MINOR_MGR_PARKING_LOT             = BIT0,    /* ͣ*/
    NETDEV_ROLE_MINOR_MGR_REGULAR_VEHICLE         = BIT1,    /* ̶ */
    NETDEV_ROLE_MINOR_MGR_VEHICLE_BLACK           = BIT2,    /*  */
    NETDEV_ROLE_MINOR_MGR_VEHICLE_FLOW            = BIT3,    /* ͳ  */
    NETDEV_ROLE_MINOR_MGR_CHARGE_STATISTIC        = BIT4,    /* շͳ */
    NETDEV_ROLE_MINOR_MGR_PAYMENT_CONF            = BIT5,    /* -֧*/
    NETDEV_ROLE_MINOR_MGR_PARAM_CONF              = BIT6,    /* -*/
    NETDEV_ROLE_MINOR_MGR_GATE_SHIFT              = BIT7,    /*  */
    NETDEV_ROLE_MINOR_MGR_VEHICLE_INPARKINGLOT    = BIT8,    /* ڳ¼ */
    NETDEV_ROLE_MINOR_MGR_PARKING_PAY             = BIT9,    /* ֵ¼ */
    NETDEV_ROLE_MINOR_MGR_CHARGE_RULE             = BIT10,   /* շѹ */
    NETDEV_ROLE_MINOR_MGR_TMP_CHARGE_RULE         = BIT11,   /* ʱշѹ */    
    NETDEV_ROLE_MINOR_MGR_REG_CHARGE_RULE         = BIT12,   /* ̶շѹ */
    NETDEV_ROLE_MINOR_MGR_ABNORMAL_CHARGE_RULE    = BIT13,   /* 쳣շѹ */
    NETDEV_ROLE_MINOR_MGR_VEHICLE_PASSRECORD      = BIT14,   /* ¼ */
    NETDEV_ROLE_MINOR_MGR_TMPVEHICLE_CHARGE       = BIT15,   /* ʱɷѼ¼ */
    NETDEV_ROLE_MINOR_MGR_ALL                     = BIT32_MAX
}NETDEV_MINOR_RIGHT_MGR_PARK_LOT_CFG_E;

/* ˻мȨ */
typedef enum tagNETDEVMinorOperViewplan
{
    NETDEV_MONOR_OPER_MIXEDDETECTION_REAL_TIME_MONITORING   = 1,           /* ʵʱ */
    NETDEV_MONOR_OPER_MIXEDDETECTION_PASSING_RECORD         = 2,           /* ͨм¼ */
    NETDEV_MONOR_OPER_MIXEDDETECTION_MIXEDDETECTION_ALL     = 0xff
}NETDEV_MONOR_OPER_VIEWPLAN_E;

/* ȱģʽ(ĬΪ0) */
typedef enum tagNETDEVVmsHotStandbyModeE
{
    NETDEV_HOTSTANDBY_MODE_DISABLE            = 0,    /*  */
    NETDEV_HOTSTANDBY_MODE_ACTIVITE           = 1,    /* ģʽ */
    NETDEV_HOTSTANDBY_MODE_BACKUP             = 2     /* ģʽ */
}NETDEV_VMS_HOTSTANDBYMODE_E;

/* ӷ״̬ */
typedef enum tagNETDEVVmsStatusE
{
    NETDEV_VMS_OFFLINE               = 0,      /*  */
    NETDEV_VMS_ONLINE                = 1,      /*  */
    NETDEV_VMS_VERSION_INCONSISTENT  = 2,      /* 汾һ */
    NETDEV_VMS_SLAVE_REACH_LIMIT     = 3,      /* ӻﵽ */
    NETDEV_VMS_SLAVE_UNREGISTER      = 4,      /* ӻδע */
    NETDEV_VMS_IN_STANDBY_MODE       = 5       /* ڱ״̬ */
}NETDEV_VMS_STATUS_E;

/* һģʽ */
typedef enum tagNETDEVVmsModeE
{
    NETDEV_VMS_MASTER      = 0,    /* һ */
    NETDEV_VMS_SLAVE       = 1     /* һ */
}NETDEV_VMS_MODE_E;

/* ־־,ĬΪ1 */
typedef enum tagNETDEVAlarmLogCleanupFlagE
{
    NETDEV_ALARM_LOG_CLEANUP      = 0,    /*  */
    NETDEV_ALARM_LOG_NOT_CLEANUP  = 1     /*  */
}NETDEV_ALARM_LOG_CLEANUP_FLAG_E;

/**
 * @enum tagNETDEVPTZCruiseCmd
 * @brief ̨Ѳ öٶ PTZ patrol operation commands Enumeration Definition
 * @attention  None
 */
typedef enum tagNETDEVPTZTRACKCmd
{
    NETDEV_PTZ_TRACKCRUISE_START     = 0,      /* ʼ켣Ѳ  Start route patrol*/
    NETDEV_PTZ_TRACKCRUISE_STOP      = 1,      /* ֹͣ켣Ѳ  Stop route patrol*/
    NETDEV_PTZ_TRACKCRUISE_REC       = 2,      /* ʼ¼ƹ켣  Start recording route */
    NETDEV_PTZ_TRACKCRUISE_RECSTOP   = 3,      /* ֹͣ¼ƹ켣  Stop recording route */
    NETDEV_PTZ_TRACKCRUISE_ADD       = 4,      /* Ѳ켣  Add patrol route  һݲָ֧ýӿڣ켣ѲIDдΪ16 */
    NETDEV_PTZ_TRACKCRUISE_DEL       = 5       /* ɾ켣Ѳ  Delete patrol route */
}NETDEV_PTZ_TRACKCMD_E;

typedef enum tagNETDEVPTZGuardMode
{
    NETDEV_PTZ_GUARD_MODE_PRESET    = 0,       /* Ԥλģʽ */
    NETDEV_PTZ_GUARD_MODE_CRUISE    = 1,       /* ԤλѲģʽ */
    NETDEV_PTZ_GUARD_MODE_TRACK     = 2         /* 켣Ѳģʽ */
}NETDEV_PTZ_GUARD_MODE_E;

/**
 * @enum tagNETDEVPTZTrackStatus
 * @brief Ѳ״̬ öٶ
 * @attention  None
 */
typedef enum tagNETDEVPTZTrackStatus
{
    NETDEV_PTZ_TRACK_STATUS_FREE           = 0,                        /* УδѲδ¼ƣ */
    NETDEV_PTZ_TRACK_STATUS_RUN            = 1,                        /* Ѳ*/
    NETDEV_PTZ_TRACK_STATUS_START_RECORD   = 2                         /*¼*/
}NETDEV_PTZ_TRACK_STATUS_E;

/**
 * @struct tagNETDEVPTZGuardCmd
 * @brief ̨
 * @attention  None
 */
typedef enum tagNETDEVPTZGuardCmd
{
    NETDEV_PTZ_GUARD_CMD_GET = 0,       /* ȡָ̨ͨϢ */
    NETDEV_PTZ_GUARD_CMD_SET = 1        /* ָ̨ͨϢ */
}NETDEV_PTZ_GUARD_CMD_E;


/* Ӧ״̬ö */
typedef enum tagNETDEVOrgResponseStatus
{
    NETDEV_ORG_RESPONSE_SUCCESS           = 0,            /* Ӧɹ */
    NETDEV_ORG_RESPONSE_FAIL              = 1             /* Ӧʧ */
}NETDEV_ORG_RESPONSE_STAUTE_E;

/* ֯ö */
typedef enum tagNETDEVOrgType
{
    NETDEV_ORG_TYPE_GENERAL            = 0,            /* ͨ֯ */
    NETDEV_ORG_TYPE_CLOUD              = 1,            /* ƶ֯ */
    NETDEV_ORG_TYPE_VIRTUAL            = 2,            /* ߼֯ */
    NETDEV_ORG_TYPE_FAVORITES          = 3,            /* ղؼ */
    NETDEV_ORG_TYPE_DOMAIN             = 4,            /* ֯ */
    NETDEV_ORG_TYPE_DOORGROUP          = 5,            /*  */
    NETDEV_ORG_TYPE_DEPT               = 6,            /* ֯ */
    NETDEV_ORG_TYPE_APARTMENT          = 7,            /* Ԣ֯ */

    NETDEV_ORG_TYPE_INVALID            = 0XFF          /* Чֵ */
}NETDEV_ORG_TYPE_E;

/* Ѳƻʽö */
typedef enum tagNETDEVPlansMode
{
    NETDEV_PLANS_MODE_TIMING            = 0,             /* ʱл */
    NETDEV_PLANS_MODE_24HOUR            = 1,             /* 24Сʱƻ */
    NETDEV_PLANS_MODE_INVALID           = 0XFF           /* Чֵ */
}NETDEV_PLANS_MODE_E;


/**
 * @enum tagNETDEVTimeTemplatePlanType
 * @brief ʱģƻ
 */
typedef enum tagNETDEVTimeTemplatePlanType
{
    NETDEV_TIME_TEMPLATE_PLAN_COMMON                        = 0,                /* 洢 */  
    NETDEV_TIME_TEMPLATE_PLAN_MOTION                        = 1,                /* ˶洢 */
    NETDEV_TIME_TEMPLATE_PLAN_ALARM                         = 2,                /* 澯洢 */
    NETDEV_TIME_TEMPLATE_PLAN_MOTION_AND_ALARM              = 3,                /* ˶͸澯洢 */
    NETDEV_TIME_TEMPLATE_PLAN_MOTION_OR_ALARM               = 4,                /* ˶澯洢 */
    NETDEV_TIME_TEMPLATE_PLAN_MANUL                         = 5,                /* ֶ洢 */
    NETDEV_TIME_TEMPLATE_PLAN_DISCONNECT                    = 6,                /*  */
    NETDEV_TIME_TEMPLATE_PLAN_THIRD_STREAM                  = 7,                /* 洢 */
    NETDEV_TIME_TEMPLATE_PLAN_VIDEO_LOSS                    = 8,                /* Ƶʧ澯 */
    NETDEV_TIME_TEMPLATE_PLAN_AUDIODETECT                   = 9,                /* Ƶ */
    NETDEV_TIME_TEMPLATE_PLAN_EVENT_ALL_ALARM               = 10,               /* ¼ͣи澯 */
    NETDEV_TIME_TEMPLATE_PLAN_ALL_RECORD_TYPE               = 11,               /* ¼ */

    NETDEV_TIME_TEMPLATE_PLAN_INVALID                       = 0xFF              /* Чֵ */
}NETDEV_TIME_TEMPLATE_PLAN_TYPE_E;


/**
 * @brief XW豸ö
 * @attention
 */
typedef enum tagNETDEVTVWallType
{
    NETDEV_TVWALL_TYPE_DECODER = 0,                                 /* ǽ */
    NETDEV_TVWALL_TYPE_SPLICER = 1,                                 /* ƴǽ */
    NETDEV_TVWALL_TYPE_DECARD  = 2                                  /* 뿨ǽ */
}NETDEV_TVWALL_TYPE_E;



/**
 * @enum tagNETDEVLeftRightAlignment
 * @brief Ҷ뷽ʽö
 * @attention
 */
typedef enum tagNETDEVLeftRightAlignment
{
    NETDEV_FONT_LR_ALIGNMENT_LEFT     = 1,                  /*  */
    NETDEV_FONT_LR_ALIGNMENT_MID      = 2,                  /* ж */
    NETDEV_FONT_LR_ALIGNMENT_RIGHT    = 3                   /* Ҷ */
}NETDEV_XW_LEFT_RIGHT_ALIGNMENT_E;

/**
 * @enum tagNETDEVUpDownAlignment
 * @brief ¶뷽ʽö
 * @attention
 */
typedef enum tagNETDEVUpDownAlignment
{
    NETDEV_FONT_UD_ALIGNMENT_UP      = 1,                   /* ϶ */
    NETDEV_FONT_UD_ALIGNMENT_MID     = 2,                   /* ж */
    NETDEV_FONT_UD_ALIGNMENT_DOWN    = 3                    /* ¶ */
}NETDEV_XW_UP_DOWN_ALIGNMENT_E;



/**
 * @enum tagNETDEVXWVirtualLEDInfo
 * @brief Ѳ״̬ö
 * @attention
 */
typedef enum tagNETDEVSeqStatus
{
    NETDEV_SEQ_STATUS_EMPTY    = 0,                          /* δѲ */
    NETDEV_SEQ_STATUS_RUNNING = 1,                           /* Ѳ */
    NETDEV_SEQ_STATUS_STOP   = 2,                            /* ֹͣѲ */

    NETDEV_SEQ_STATUS_INVALID = 0xFF                         /* Ч״̬ */
}NETDEV_SEQ_STATUS_E;

/**
 * @enum tagNETDEVLapiTransProtocal
 * @brief ý崫Э öٶ  Media transport protocol Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVLapiTransProtocal
{
    NETDEV_LAPI_TRANS_PROTOCAL_TCP     = 0,              /* TCP */
    NETDEV_LAPI_TRANS_PROTOCAL_UDP     = 1               /* UDP */
}NETDEV_LAPI_TRANS_PROTOCAL_E;


 /**
 * @enum tagNETDEVXWVirtualLEDInfo
 * @brief Ѳ״̬ö
 * @attention
 */
typedef enum tagNETDEVTVWallWndType
{
    NETDEV_WINDOWS_TYPE_NORMAL    = 0,                          /* ͨ */
    NETDEV_WINDOWS_TYPE_ALARM = 1,                              /* 澯 */

    NETDEV_WINDOWS_TYPE_INVALID = 0xFF                          /* Ч״̬ */
}NETDEV_TVWALL_WND_TPYE_E;


/**
 * @enum tagNETDEVXWPlayBackCond
 * @brief Ѳö
 * @attention
 */
typedef enum tagNETDEVXWSeqCmd
{
    NETDEV_XW_SEQ_CMD_STOP = 0,                            /* ֹͣѲҵ */
    NETDEV_XW_SEQ_CMD_START  = 1,                          /* Ѳҵ */
    NETDEV_XW_SEQ_CMD_PAUSE  = 2,                          /* Ѳͣ */
    NETDEV_XW_SEQ_CMD_CONTINUE = 3,                        /* ͣ */

    NETDEV_XW_SEQ_CMD_INVALID = 0xFF                       /* Ч */
}NETDEV_XW_SEQ_CMD_E;

/**
 * @enum tagNETDEVXWSeqResourceType
 * @brief ѲԴö
 * @attention
 */
typedef enum tagNETDEVXWSeqResourceType
{
    NETDEV_XW_SEQ_RESOURCE_WND = 0,                                /* Դ */
    NETDEV_XW_SEQ_RESOURCE_GROUP_WND = 1,                          /* ѲԴ */

    NETDEV_XW_SEQ_RESOURCE_INVALID = 0xFF                          /* Ч */
}NETDEV_XW_SEQ_RESOURCE_TYPE_E;

/**
 * @enum tagNETDEVLangType
 * @brief ö
 * @attention
 */
typedef enum tagNETDEVLangType
{
    NETDEV_LANG_TYPE_CHINESE             = 0,                           /*  */
    NETDEV_LANG_TYPE_ENGLISH             = 1,                           /* Ӣ */
    NETDEV_LANG_TYPE_TRADITIONAL_CHINESE = 2,                           /*  */
    NETDEV_LANG_TYPE_FRENCH              = 3,                           /*  */
    NETDEV_LANG_TYPE_GERMAN              = 4,                           /*  */
    NETDEV_LANG_TYPE_SPANISH             = 5,                           /*  */
    NETDEV_LANG_TYPE_ITALIAN             = 6,                           /*  */
    NETDEV_LANG_TYPE_PORTUGUESE          = 7,                           /*  */
    NETDEV_LANG_TYPE_RUSSIAN             = 8,                           /*  */
    NETDEV_LANG_TYPE_UKRAINIAN           = 9,                           /* ڿ */
    NETDEV_LANG_TYPE_GRUANIAN            = 10,                          /* ³ */
    NETDEV_LANG_TYPE_DUTCH               = 11,                          /*  */
    NETDEV_LANG_TYPE_DANISH              = 12,                          /*  */
    NETDEV_LANG_TYPE_FINNISH             = 13,                          /*  */
    NETDEV_LANG_TYPE_SWEDISH             = 14,                          /*  */
    NETDEV_LANG_TYPE_NORWEGIAN           = 15,                          /* Ų */
    NETDEV_LANG_TYPE_LCELANDIC           = 16,                          /*  */
    NETDEV_LANG_TYPE_POLISH              = 17,                          /*  */
    NETDEV_LANG_TYPE_LITHUANIAN          = 18,                          /*  */
    NETDEV_LANG_TYPE_GREEK               = 19,                          /* ϣ */
    NETDEV_LANG_TYPE_CZECH               = 20,                          /* ݿ */
    NETDEV_LANG_TYPE_SLOVAK              = 21,                          /* ˹工 */
    NETDEV_LANG_TYPE_HUNGARIAN           = 22,                          /*  */
    NETDEV_LANG_TYPE_ROMAN               = 23,                          /*  */
    NETDEV_LANG_TYPE_SERBIAN             = 24,                          /* ά */
    NETDEV_LANG_TYPE_CROATIAN            = 25,                          /* ޵ */
    NETDEV_LANG_TYPE_SLOVENIAN           = 26,                          /* ˹ */
    NETDEV_LANG_TYPE_BULGARIAN           = 27,                          /*  */
    NETDEV_LANG_TYPE_BELARUSIAN          = 28,                          /* ׶˹ */
    NETDEV_LANG_TYPE_TURKISH             = 29,                          /*  */
    NETDEV_LANG_TYPE_ARABIC              = 30,                          /*  */
    NETDEV_LANG_TYPE_HEBREW              = 31,                          /* ϣ */
    NETDEV_LANG_TYPE_HINDI               = 32,                          /* ӡ */
    NETDEV_LANG_TYPE_BENGALI             = 33,                          /* ϼ */
    NETDEV_LANG_TYPE_PERSIAN             = 34,                          /* ˹ */
    NETDEV_LANG_TYPE_JAPANESE            = 35,                          /*  */
    NETDEV_LANG_TYPE_KOREAN              = 36,                          /*  */
    NETDEV_LANG_TYPE_THAI                = 37,                          /* ̩ */
    NETDEV_LANG_TYPE_MALAYSIAN           = 38,                          /*  */
    NETDEV_LANG_TYPE_INDONESIAN          = 39,                          /* ӡ */
    NETDEV_LANG_TYPE_FILIPINO            = 40,                          /* ɱ */
    NETDEV_LANG_TYPE_LAO                 = 41,                          /*  */
    NETDEV_LANG_TYPE_VIETNAMESE          = 42,                          /* Խ */
    NETDEV_LANG_TYPE_MONGOLIAN           = 43,                          /* ɹŹ */
    NETDEV_LANG_TYPE_ALBANIAN            = 44,                          /*  */
    NETDEV_LANG_TYPE_AZERBAIJANI         = 45,                          /* ݽ */
    NETDEV_LANG_TYPE_GAELIC              = 46,                          /* Ƕ */
    NETDEV_LANG_TYPE_ESTONIAN            = 47,                          /* ɳ */
    NETDEV_LANG_TYPE_BOSNIAN             = 48,                          /* ˹ */
    NETDEV_LANG_TYPE_LOWLAND_SAXON       = 49,                          /* ͵ѷ */
    NETDEV_LANG_TYPE_PERUVIAN            = 50,                          /* ³ */
    NETDEV_LANG_TYPE_LATVIAN             = 51,                          /* ά */

    NETDEV_LANG_TYPE_INVALID             = 0xFF                         /* Ч */
}NETDEV_LANG_TYPE_E;


/**
 * @enum tagNETDEVRegionType
 * @brief ö
 * @attention
 */
typedef enum tagNETDEVRegionType
{
    NETDEV_REGION_TYPE_ENGINEERING  = 0,                          /*  */
    NETDEV_REGION_TYPE_DISTRIBUTION = 1,                          /*  */
    NETDEV_REGION_TYPE_OVERSEAS     = 2,                          /*  */

    NETDEV_REGION_TYPE_INVALID      = 0xFF                        /* Ч */
}NETDEV_REGION_TYPE_E;

/**
 * @enum tagNETDEVCustomType
 * @brief ö
 * @attention
 */
typedef enum tagNETDEVCustomType
{
    NETDEV_CUSTOM_TYPE_GUARD   = 0,                               /*  */
    NETDEV_CUSTOM_TYPE_UNV_OLD = 1,                               /* ϰ汾 */
    NETDEV_CUSTOM_TYPE_UNV_NEW = 2,                               /* °汾 */
    NETDEV_CUSTOM_TYPE_CUSTOM  = 3,                               /*  */

    NETDEV_CUSTOM_TYPE_INVALID = 0xFF                             /* Ч */
}NETDEV_CUSTOM_TYPE_E;

/**
 * @enum tagNETDEVManualRecordStatus
 * @brief ֶ¼״̬
 * @attention
 */
typedef enum tagNETDEVManualRecordStatus
{
    NETDEV_MANUAL_RECORD_STATUS_FREE = 0,                            /* δ¼ */
    NETDEV_MANUAL_RECORD_STATUS_RECORDING  = 1,                      /* ¼ */

    NETDEV_MANUAL_RECORD_STATUS_INVALID = 0xFF                       /* Ч */
}NETDEV_MANUAL_RECORD_STATUS_E;



/**
 * @enum tagNETDEVXWSerialType
 * @brief 
 * @attention  None      
 */
typedef enum tagNETDEVXWSerialType
{
    NETDEV_XW_SERIAL_TYPE_RS232                    = 0,               /* 232 */
    NETDEV_XW_SERIAL_TYPE_RS422                    = 1,               /* 422 */
    NETDEV_XW_SERIAL_TYPE_RS485                    = 2,               /* 485 */

    NETDEV_XW_SERIAL_TYPE_INVALID                  = 0xFF             /* Чֵ */
}NETDEV_XW_SERIAL_TYPE_E;

/**
 * @enum tagNETDEVXWSerialMode
 * @brief ģʽ
 * @attention  None      
 */
typedef enum tagNETDEVXWSerialMode
{
    NETDEV_XW_SERIAL_MODE_BIG_CONTROL              = 0,               /*  */
    NETDEV_XW_SERIAL_MODE_CENTER_CONTROL           = 1,               /* пؿ */
    NETDEV_XW_SERIAL_MODE_CONSOLE                  = 2,               /* Console */

    NETDEV_XW_SERIAL_MODE_INVALID                  = 0xFF             /* Чֵ */
}NETDEV_XW_SERIAL_MODE_E;

/**
 * @enum tagNETDEVXWWorkMode
 * @brief ģʽ
 * @attention  None      
 */
typedef enum tagNETDEVXWWorkMode
{
    NETDEV_XW_WORK_MODE_ALL                       = 0,               /* ȫ˫ģʽ */
    NETDEV_XW_WORK_MODE_SINGLE                    = 1,               /* ˫ģʽ */

    NETDEV_XW_WORK_MODE_INVALID                   = 0xFF             /* Чֵ */
}NETDEV_XW_WORK_MODE_E;


/**
 * @enum tagNETDEVXWParityType
 * @brief Уλ У鷽ʽ
 * @attention  None      
 */
typedef enum tagNETDEVXWParityType
{
    NETDEV_XW_PARITY_TYPE_NONE                    = 0,               /*  */
    NETDEV_XW_PARITY_TYPE_ODD                     = 1,               /* У */
    NETDEV_XW_PARITY_TYPE_EVEN                    = 2,               /* żУ */

    NETDEV_XW_PARITY_TYPE_INVALID                 = 0xFF             /* Чֵ */
}NETDEV_XW_PARITY_TYPE_E;

/**
 * @enum tagNETDEVXWFlowCtrl
 * @brief λ
 * @attention  None      
 */
typedef enum tagNETDEVXWFlowCtrl
{
    NETDEV_XW_FLOW_CTRL_NONE                        = 0,               /*  */
    NETDEV_XW_FLOW_CTRL_SOFTWARE                    = 1,               /*  */
    NETDEV_XW_FLOW_CTRL_HARDWARE                    = 2,               /* Ӳ */

    NETDEV_XW_FLOW_CTRL_INVALID                     = 0xFF             /* Чֵ */
}NETDEV_XW_FLOW_CTRL_E;



/**
 * @enum tagNETDEVAlarmPointActionType
 * @brief ͨ
 * @attention
 */
typedef enum tagNETDEVAlarmPointActionType
{
    NETDEV_ALARMPOINT_ACTION_TYPE_ARM             = 0,                /*  */
    NETDEV_ALARMPOINT_ACTION_TYPE_DISARM          = 1,                /*  */
    NETDEV_ALARMPOINT_ACTION_TYPE_BYPASS          = 2,                /* · */
    NETDEV_ALARMPOINT_ACTION_TYPE_DISBYPASS       = 3,                /* ·ָ */

    NETDEV_ALARMPOINT_ACTION_TYPE_INVALID         = 0xFF              /* Чֵ */
}NETDEV_ALARMPOINT_ACTION_TYPE_E;


/**
 * @enum tagNETDEVAlarmPointActionType
 * @brief ͨ
 * @attention
 */
typedef enum tagNETDEVDoorCtrlActionType
{
    NETDEV_DOORCTRL_ACTION_TYPE_OPEN             = 0,                /*  */
    NETDEV_DOORCTRL_ACTION_TYPE_CLOSE            = 1,                /*  */

    NETDEV_DOORCTRL_ACTION_TYPE_INVALID          = 0xFF              /* Чֵ */
}NETDEV_DOORCTRL_ACTION_TYPE_E;

/**
 * @enum tagNETDEVACSPersonCommondType
 * @brief ŽԱ(Ӻɾʹӿ)
 * @attention
 */
typedef enum tagNETDEVACSPersonCommondType
{
    NETDEV_ACS_PERSON_COMMOND_TYPE_GET            = 0,                /* ȡ */
    NETDEV_ACS_PERSON_COMMOND_TYPE_MOD            = 1,                /* ޸ */

    NETDEV_ACS_PERSON_COMMOND_TYPE_INVALID        = 0xFF              /* Чֵ */
}NETDEV_ACS_PERSON_COMMOND_TYPE_E;

/**
 * @enum tagNETDEVGenderType
 * @brief ԱԱ
 * @attention  None
 */
typedef enum tagNETDEVGenderType
{
    NETDEV_GENDER_TYPE_UNKNOW       = 0,        /* 0-δ֪Ա */
    NETDEV_GENDER_TYPE_MAN          = 1,        /* 1- */
    NETDEV_GENDER_TYPE_WOMAN        = 2,        /* 2-Ů */
    NETDEV_GENDER_TYPE_UNEXPLAINED  = 9,        /* 9-δ˵Ա */
    NETDEV_GENDER_TYPE_INVALID      = 0xFF      /* Чֵ */
}NETDEV_GENDER_TYPE_E;

/**
 * @enum tagNETDEVFaceMemberIDType
 * @brief Ա֤
 * @attention  None
 */
typedef enum tagNETDEVFaceMemberIDType
{
    NETDEV_FACE_MEMBER_ID_TYPE_ID_CARD                 = 0,               /* ֤ */
    NETDEV_FACE_MEMBER_ID_TYPE_IC_CARD                 = 1,               /* IC */
    NETDEV_FACE_MEMBER_ID_TYPE_PASSPORT                = 2,               /*  */
    NETDEV_FACE_MEMBER_ID_TYPE_DRIVING                 = 3,               /*  */
    NETDEV_FACE_MEMBER_ID_TYPE_OTHER                   = 99,              /*  */

    NETDEV_FACE_MEMBER_ID_TYPE_INVALID                 = 0xFF             /* Чֵ */
}NETDEV_FACE_MEMBER_ID_TYPE_E;


/**
 * @enum tagNETDEVACSPersonType
 * @brief Ա
 * @attention  None
 */
typedef enum tagNETDEVACSPersonType
{
    NETDEV_ACS_PERSON_TYPE_STAFF                      = 0,               /* Ա */
    NETDEV_ACS_PERSON_TYPE_VISITOR                    = 1,               /* ÿ */
    NETDEV_ACS_PERSON_TYPE_STRANGER                   = 2,               /* İ */

    NETDEV_ACS_PERSON_TYPE_INVALID                    = 0xFF             /* Чֵ */
}NETDEV_ACS_PERSON_TYPE_E;

/**
 * @enum tagNETDEVACSVisitStaus
 * @brief ÿ״̬
 * @attention  None
 */
typedef enum tagNETDEVACSVisitStaus
{
    NETDEV_ACS_VISIT_STATUS_SCHEDULE                 = 0,               /* ԤԼ */
    NETDEV_ACS_VISIT_STATUS_VISITING                 = 1,               /* ڷ */
    NETDEV_ACS_VISIT_STATUS_LEAVE                    = 2,               /*  */
    NETDEV_ACS_VISIT_STATUS_SCHEDULE_CANCEL          = 3,               /* ԤԼȡ */
    NETDEV_ACS_VISIT_STATUS_TIMEOUT                  = 4,               /* ʱ */

    NETDEV_ACS_VISIT_STATUS_INVALID                  = 0xFF             /* Чֵ */
}NETDEV_ACS_VISIT_STATUS_E;


/**
 * @enum tagNETDEVAlarmActionType
 * @brief 
 * @attention
 */
typedef enum tagNETDEVAlarmActionType
{
    NETDEV_ALARM_ACTION_TYPE_CLOSE            = 0,                /* رո澯 */
    NETDEV_ALARM_ACTION_TYPE_OPEN             = 1,                /* 澯 */

    NETDEV_ALARM_ACTION_TYPE_INVALID          = 0xFF              /* Чֵ */
}NETDEV_ALARM_ACTION_TYPE_E;

/**
 * @enum tagNETDEVAlarmStatusType
 * @brief 澯״̬
 * @attention
 */
typedef enum tagNETDEVAlarmStatusType
{
    NETDEV_ALARM_STATUS_TYPE_INACTIVE           = 0,                /* δ澯 */
    NETDEV_ALARM_STATUS_TYPE_ACTIVE             = 1,                /* 澯 */

    NETDEV_ALARM_STATUS_TYPE_INVALID            = 0xFF              /* Чֵ */
}NETDEV_ALARM_STATUS_TYPE_E;

/**
 * @enum tagNETDEVEmergencyBellType
 * @brief 
 * @attention
 */
typedef enum tagNETDEVEmergencyBellType
{
    NETDEV_EMERGENCY_BELL_TYPE_SEHO    = 0,                          /*  */
    NETDEV_EMERGENCY_BELL_TYPE_HITEC   = 1,                          /* Hitec */

    NETDEV_EMERGENCY_BELL_TYPE_INVALID = 0xFF                        /* Ч ѯͨʱ·ֵ*/
}NETDEV_EMERGENCY_BELL_TYPE_E; 


/**
 * @enum tagNETDEVMonitorType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVMonitorType
{
    NETDEV_MONITOR_TYPE_FACE                       = 0,                /*  */
    NETDEV_MONITOR_TYPE_VEHICLE                    = 1,                /*  */
    NETDEV_MONITOR_TYPE_INVALID                    = 0xFF              /* Чֵ*/
}NETDEV_MONITOR_TYPE_E;


/**
 * @enum tagNETDEVDiskModeType
 * @brief Ӳģʽ
 * @attention  None
 */
typedef enum tagNETDEVDiskModeType
{
    NETDEV_DISK_MODE_TYPE_OLD            = 0,                /* ɴ洢ʽӲ */
    NETDEV_DISK_MODE_TYPE_NEW            = 1,                /* ´洢ʽӲ */

    NETDEV_DISK_MODE_TYPE_INVALID        = 0xFF              /* Чֵ */
}NETDEV_DISK_MODE_TYPE_E;


/**
 * @enum tagNETDEVEncodeChnStatus
 * @brief ͨ״̬
 * @attention  None
 */
typedef enum tagNETDEVChnStatus
{
    NETDEV_CHN_STATUS_OFFLINE          = 0,                /*  offline */
    NETDEV_CHN_STATUS_ONLINE           = 1,                /*  online */
    NETDEV_CHN_STATUS_VIDEO_LOSE       = 2,                /* Ƶʧ video lose */

    NETDEV_CHN_STATUS_INVALID       = 0xFF
}NETDEV_CHN_STATUS_E;


/**
 * @enum tagNETDEVAlarmInChnStatus
 * @brief 澯ͨ״̬
 * @attention  None
 */
typedef enum tagNETDEVAlarmRunode
{
    NETDEV_ALARM_RUNMODE_OPEN       = 0,                /*   Always open */
    NETDEV_ALARM_RUNMODE_CLOSE      = 1,                /*   Always closed */
    NETDEV_ALARM_RUNMODE_INVALID    = 0xFF
}NETDEV_ALARM_RUNMODE_E;

/**
 * @enum tagNETDEVAlarmOutChnStatus
 * @brief 澯ͨ״̬
 * @attention  None
 */
typedef enum tagNETDEVAlarmOutChnStatus
{
    NETDEV_ALARMOUT_CHN_ACTIVE      = 0,
    NETDEV_ALARMOUT_CHN_INACTIVE    = 1,
    NETDEV_ALARMOUT_CHN_INVALID     = 0xFF
}NETDEV_ALARMOUT_CHN_STATUS_E;

/**
 * @enum tagNETDEVRecordLocation
 * @brief ¼洢 öٶ Record location Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVRecordLocation
{
    NETDEV_RECORD_LOCATION_ALL                        = 0,                /* 洢λã */  
    NETDEV_RECORD_LOCATION_VMS                        = 1,                /* 洢λãVMS */  
    NETDEV_RECORD_LOCATION_NVR                        = 2,                /* 洢λãNVR */
    NETDEV_RECORD_LOCATION_BACKUP                     = 3,                /* 洢λã */

    NETDEV_RECORD_LOCATION_INVALID                    = 0xFF              /* Чֵ */
}NETDEV_RECORD_LOCATION_E;

/**
 * @enum tagNETDEVDeviceMainType
 * @brief 豸öٶ
 * @attention  None
 */
typedef enum tagNETDEVDeviceMainType
{
    NETDEV_DTYPE_MAIN_ENCODE            = 0,                /* 豸 */
    NETDEV_DTYPE_MAIN_DECODE            = 1,                /* 豸 */
    NETDEV_DTYPE_MAIN_VMS               = 2,                /* һ豸 */
    NETDEV_DTYPE_MAIN_DA                = 3,                /* 豸 */
    NETDEV_DTYPE_MAIN_CLOUD             = 4,                /* ƶ˱豸  */
    NETDEV_DTYPE_MAIN_BAYONET           = 5,                /* 豸 */
    NETDEV_DTYPE_MAIN_ACS               = 6,                /* Ž豸 */
    NETDEV_DTYPE_MAIN_ALARMHOST         = 7,                /* 豸 */
    NETDEV_DTYPE_MAIN_EXITENTRANCE      = 8,                /* 豸 */
    NETDEV_DTYPE_MAIN_LOCK              = 9,                /* 豸 */

    NETDEV_DTYPE_MAIN_PLAYER_MANAGER    = 10,               /* źй豸 */
    NETDEV_DTYPE_MAIN_PLAYER            = 11,               /* ź */
    NETDEV_DTYPE_MAIN_UNKNOWN           = 0XFF              /* δ֪豸 */
}NETDEV_DEVICE_MAIN_TYPE_E;

typedef enum tagNETDEVDeviceStatus
{
    NETDEV_DEV_STATUS_OFFLINE                   = 0,                /*  */
    NETDEV_DEV_STATUS_ONLINE                    = 1,                /*  */
    NETDEV_DEV_STATUS_CONNECTING                = 2,                /*  */
    NETDEV_DEV_STATUS_PWD_ERROR                 = 3,                /* û */
    NETDEV_DEV_STATUS_NOT_SUPPORT               = 4,                /* 豸֧ */
    NETDEV_DEV_STATUS_TIMEOUT                   = 5,                /* 豸ӳʱ */
    NETDEV_DEV_STATUS_WEAK_PWD_ERROR            = 6,                /* Զû */
    NETDEV_DEV_STATUS_NO_DYNAMIC_PWD            = 7,                /* 豸ֶ֧̬ */

    NETDEV_DEV_STATUS_INVALID                   = 0XFF              /* Чֵ */
}NETDEV_DEVICE_STATUS_E;

typedef enum tagNETDEVDeviceAccessMode
{
    NETDEV_DEV_ACCESS_MODE_IP_DOMAIN            = 0,                /* IP */ 
    NETDEV_DEV_ACCESS_MODE_P2P                  = 1,                /* P2P */
    NETDEV_DEV_ACCESS_MODE_UNP                  = 2,                /* UNP */

    NETDEV_DEV_ACCESS_MODE_INVALID              = 0XFF              /* Чֵ */
}NETDEV_DEVICE_ACCESS_MODE_E;

typedef enum tagNETDEVChlType
{
    NETDEV_CHN_TYPE_ENCODE              = 0,                /* ͨ, ͨ״̬μNETDEV_CHN_STATUS_E */
    NETDEV_CHN_TYPE_ALARMIN             = 1,                /* 澯ͨ, ͨ״̬μNETDEV_ALARM_RUNMODE_E */
    NETDEV_CHN_TYPE_ALARMOUT            = 2,                /* 澯ͨ, ͨ״̬μNETDEV_ALARMOUT_CHN_STATUS_E */
    NETDEV_CHN_TYPE_DECODE              = 3,                /* ͨ */
    NETDEV_CHN_TYPE_AUDIO               = 4,                /* Ƶͨ */
    NETDEV_CHN_TYPE_NIC                 = 5,                /* ͨ */
    NETDEV_CHN_TYPE_ALARMPOINT          = 6,                /*  */
    NETDEV_CHN_TYPE_DOOR                = 7,                /*  */
    NETDEV_CHN_TYPE_ADU_ENCODE          = 8,                /* ADUرͨ, ͨ״̬μNETDEV_CHN_STATUS_E ȡϸϢ#NETDEV_DEV_CHN_XW_ENCODE_INFO_S */
    NETDEV_CHN_TYPE_EMERGENCY           = 9,                /* ͨ */

    NETDEV_CHN_TYPE_INVALID             = 0xFF              /* Чֵ */
}NETDEV_CHN_TYPE_E;


/**
 * @enum tagNETDEVAlarmPointStatusType
 * @brief 澯λ״̬ö öٶ
 * @attention  None
 */
typedef enum tagNETDEVAlarmPointStatusType
{
    NETDEV_ALARM_POINT_STATUS_TYPE_UNKNOWN     = 0,             /* δ֪ */
    NETDEV_ALARM_POINT_STATUS_TYPE_ARM         = 1,             /*  */
    NETDEV_ALARM_POINT_STATUS_TYPE_DISARM      = 2,             /*  */
    NETDEV_ALARM_POINT_STATUS_TYPE_DISBYPASS   = 3,             /* · */
    NETDEV_ALARM_POINT_STATUS_TYPE_BYPASS      = 4,             /* · */
    NETDEV_ALARM_POINT_STATUS_TYPE_ZONEFAILURE = 5,             /* ʧЧ */

    NETDEV_ALARM_POINT_STATUS_TYPE_INVALID     = 0xFF           /* Чֵ */
}NETDEV_ALARM_POINT_STATUS_TYPE_E;

/**
 * @enum tagNETDEVDoorStatusType
 * @brief 澯λ״̬ö öٶ
 * @attention  None
 */
typedef enum tagNETDEVDoorStatusType
{
    NETDEV_DOOR_STATUS_TYPE_UNKNOWN     = 0,             /* δ֪ */
    NETDEV_DOOR_STATUS_TYPE_CLOSE       = 1,             /*  */
    NETDEV_DOOR_STATUS_TYPE_OPEN        = 2,             /*  */

    NETDEV_DOOR_STATUS_TYPE_INVALID     = 0xFF           /* Чֵ */
}NETDEV_DOOR_STATUS_TYPE_E;


 /**
 * @enum tagNETDEVVideoSrcType
 * @brief Ƶö öٶ
 * @attention  None
 */
typedef enum tagNETDEVVideoSrcType
{
    NETDEV_VIDEO_SRC_TYPE_BNC            = 0,                /* BNC*/
    NETDEV_VIDEO_SRC_TYPE_VGA            = 1,                /* VGA*/
    NETDEV_VIDEO_SRC_TYPE_HDMI           = 2,                /* HDMI */
    NETDEV_VIDEO_SRC_TYPE_DVI_D          = 3,                /* DVI_D*/
    NETDEV_VIDEO_SRC_TYPE_DVI_I          = 4,                /* DVI_I*/
    NETDEV_VIDEO_SRC_TYPE_DP             = 5,                /* DP*/
    NETDEV_VIDEO_SRC_TYPE_SDI            = 6,                /* SDI*/
    NETDEV_VIDEO_SRC_TYPE_INVALID      = 0xFF                /* Чֵ */
}NETDEV_VIDEO_SRC_TYPE_E;

/**
 *@enum tagNETDEVTrafficStatisticsFormType
 *@brief  öٶ
 *@attention  None
 */
typedef enum tagNETDEVTrafficStatisticsFormType
{
    NETDEV_TRAFFIC_STAT_FORM_BY_MINUTE = 0,                  /* */
    NETDEV_TRAFFIC_STAT_FORM_BY_HOUR = 1,                    /* Сʱ*/
    NETDEV_TRAFFIC_STAT_FORM_BY_DAY = 2,                     /* */
    NETDEV_TRAFFIC_STAT_FORM_BY_MONTH = 3,                   /* */
    NETDEV_TRAFFIC_STAT_FORM_BY_BUTT
}NETDEV_TRAFFIC_STATIC_FORM_TYPE_E;



/* ¼ϱ */
typedef enum tagNETDEVVehicleEventType
{
    NETDEV_VEHCILE_EVENT_TYPE_SNAPSHOT        = 0,       /* ץ */
    NETDEV_VEHCILE_EVENT_TYPE_MATCHALARM      = 1,       /* ƥ澯 */
    NETDEV_VEHCILE_EVENT_TYPE_MISMATCHALARM   = 2,       /* ƥ澯 */
    NETDEV_VEHCILE_EVENT_TYPE_BUTT            = 0xFF     /* Чֵ */
}NETDEV_VEHICLE_EVENT_TYPE_E;

/* ¼ϱ */
typedef enum tagNETDEVFaceEventType
{
    NETDEV_FACE_EVENT_TYPE_SNAPSHOT       = 0,        /* ץ */
    NETDEV_FACE_EVENT_TYPE_MATCH_ALARM    = 1,        /* ƥ澯 */
    NETDEV_FACE_EVENT_TYPE_MISMATCH_ALARM = 2,        /* ƥ澯 */
    NETDEV_FACE_EVENT_TYPE_BUTT           = 0xFF      /* Чֵ */
}NETDEV_FACE_EVENT_TYPE_E;

/**
 * @enum tagNETDEVEventActionType
 * @brief ¼ö öٶ
 * @attention  None
 */
typedef enum tagNETDEVEventActionType
{
    NETDEV_EVENT_ACTION_TYPE_ADD            = 0,                /* ¼ͣ */
    NETDEV_EVENT_ACTION_TYPE_DELETE         = 1,                /* ¼ͣɾ */
    NETDEV_EVENT_ACTION_TYPE_MODIFY         = 2,                /* ¼ͣ޸ */
    NETDEV_EVENT_ACTION_TYPE_ONLINE         = 3,                /* ¼ͣ */
    NETDEV_EVENT_ACTION_TYPE_OFFLINE        = 4,                /* ¼ͣ */
    NETDEV_EVENT_ACTION_TYPE_EMAP_ALARM     = 5,                /* ¼ͣӵͼ澯 */

    NETDEV_EVENT_ACTION_TYPE_INVALID        = 0xFF              /* Чֵ */
}NETDEV_EVENT_ACTION_TYPE_E;


/**
 * @enum tagNETDEVProtocal
 * @brief ý崫Э öٶ  Media transport protocol Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVTransProtocal
{
    NETDEV_TRANS_PROTOCAL_UDP     = 0,            /* UDP */
    NETDEV_TRANS_PROTOCAL_TCP     = 1             /* TCP */
}NETDEV_TRANS_PROTOCAL_E;

/**
 * @enum tagNETDEVSessionType
 * @brief ҵ öٶ 
 * @attention  None
 */
typedef enum tagNETDEVSessionType
{
    NETDEV_SESSION_TYPE_FREE             = 0,             /*  */
    NETDEV_SESSION_TYPE_LIVE_ON_WALL     = 1,             /* ʵǽ */ 
    NETDEV_SESSION_TYPE_PLAYBACK_ON_WALL = 2,             /* طǽ */ 
    NETDEV_SESSION_TYPE_TURNING_ON_WALL  = 3             /* Ѳǽ */ 
}NETDEV_SESSION_TYPE_E;


/*  */
typedef enum tagNETDEVTransType
{
    NETDEV_TRANS_TYPE_FORWORD     = 0,                        /* һת */
    NETDEV_TRANS_TYPE_STRAIGHT    = 1                         /* 豸ֱ*/
}NETDEV_TRANS_TYPE_E;


/**
 * @enum tagNETDEVCloudConnectMode
 * @brief ƶ豸ģʽ 
 * @attention  None
 */
typedef enum tagNETDEVCloudConnectMode
{
    NETDEV_CLOUD_CONNECT_MODE_ALL       = 0,         /* ֱ->ֱ->->ת */
    NETDEV_CLOUD_CONNECT_MODE_P2P_TURN  = 1,         /* ֱ->ֱ->+ת(תӳ500ms) */
    NETDEV_CLOUD_CONNECT_MODE_P2P       = 2,         /* ֱӴ */
    NETDEV_CLOUD_CONNECT_MODE_TURN      = 3          /* ֱת */
}NETDEV_CLOUD_CONNECT_MODE_E;


/**
*@enum tagNETDEVMyCloudOffErr
*@brief ԭö
*@attention 
*/
typedef enum tagNETDEVMyCloudOffErr
{
    NETDEV_MYCLOUD_OFF_ERR_OK                 = 0,      /* MyCloud */
    NETDEV_MYCLOUD_OFF_ERR_NOT_REGISTER       = 1,      /* δMyCloudվ豸 */
    NETDEV_MYCLOUD_OFF_ERR_NET_UNREACHABLE    = 2,      /* 粻ɴ */

    NETDEV_MYCLOUD_OFF_ERR_MAPPING_ON_MSG_NO_RETURN           = 3,      /* ϣ˿ӳãUDPϢ޷ͨ·أ· */
    NETDEV_MYCLOUD_OFF_ERR_MAPPING_ON_MSG_NO_SEND             = 4,      /* ϣ˿ӳãUDPϢ޷ͨ·· */
    NETDEV_MYCLOUD_OFF_ERR_MAPPING_OFF_MSG_NO_RETURN          = 5,      /* ϣ˿ӳδãUDPϢ޷ͨ·أ· */
    NETDEV_MYCLOUD_OFF_ERR_MAPPING_OFF_MSG_NO_SEND            = 6,      /* ϣ˿ӳδãUDPϢ޷ͨ·· */
    NETDEV_MYCLOUD_OFF_ERR_MAPPING_EXCP_MSG_NO_RETURN         = 7,      /* ϣ˿ӳ쳣UDPϢ޷ͨ·أ· */
    NETDEV_MYCLOUD_OFF_ERR_MAPPING_EXCP_MSG_NO_SEND           = 8       /* ϣ˿ӳ쳣UDPϢ޷ͨ·· */

}NETDEV_MYCLOUD_OFF_ERR_E;

typedef enum tagNETDEVRegisterStatus
{
    NETDEV_REGISTER_STATUS_OFFLINE            = 0,      /*  */
    NETDEV_REGISTER_STATUS_ONLINE             = 1,      /*  */
    NETDEV_REGISTER_STATUS_CANCELING          = 2,      /* ע */

    NETDEV_REGISTER_STATUS_INVALID            = 0XFF    /* Чֵ */
}NETDEV_REGISTER_STATUS_E;

/**
* @brief ͨȨö
* @attention λʾ ӵиͨʵͶԽȨ޺̨Ȩޣֶ3
*/
typedef enum tagNETDEVChnPermission
{
    NETDEV_CHN_PERMISSION_LIVE                  = BIT0,                 /* ʵԽ */
    NETDEV_CHN_PERMISSION_PTZ                   = BIT1,                 /* ̨ */
    NETDEV_CHN_PERMISSION_PLAYBACK              = BIT2,                 /* ط */
    NETDEV_CHN_PERMISSION_MANU_RECORD           = BIT3,                 /* ֶ¼ */
    NETDEV_CHN_PERMISSION_LOCAL_BACK            = BIT4,                 /* ر */

    NETDEV_CHN_PERMISSION_INVALID               = 0XFFFFFFFF        /* Чֵ */
}NETDEV_CHN_PERMISSION_TYPE_E;

/**
* @brief û,Աû޸Ȩ
* @attention 
*/
typedef enum tagNETDEVUserLevel
{
    NETDEV_USER_LEVEL_ADMINISTRATOR  = 0,           /* Ա */
    NETDEV_USER_LEVEL_OPERATOR       = 1,           /* Ա */
    NETDEV_USER_LEVEL_USER           = 2,           /* ͨû */
    NETDEV_USER_LEVEL_Default        = 3,           /* Ĭû  */
    NETDEV_USER_LEVEL_PUBLISH        = 4            /* ĿԱ */
}NETDEV_USER_LEVEL_E;

/**
* @brief Ȩ
* @attention  
*/
typedef enum tagNETDEVUserBasePermission
{
    NETDEV_USER_BASE_PER_CONFIG           = BIT0,           /* */
    NETDEV_USER_BASE_PER_UPGRADE          = BIT1,           /*  */
    NETDEV_USER_BASE_PER_LOG              = BIT2,           /* ־鿴͵ */
    NETDEV_USER_BASE_PER_REBOOT           = BIT3            /*  */
}NETDEV_USER_BASE_PERMISSION_E;

/**
* @enum tagNETDEVFactoryResetModeType
* @brief ûָģʽöٶ
 * @attention  None
 */
typedef enum tagNETDEVFactoryResetModeType
{
    NETDEV_FACTORY_RESET_SOFT             = 0,              /* ָģʽ򵥻ָúûã*/
    NETDEV_FACTORY_RESET_HARD             = 1,              /* Ӳָģʽȫָָã*/

    NETDEV_FACTORY_RESET_INVALID          = 0xFF            /* Чֵ */
}NETDEV_FACTORY_RESET_MODE_TYPE_E;


/**
 * @enum tagNETDEVCloudDeviceType
 * @brief ƶ豸
 * @attention  None
 */
typedef enum tagNETDEVCloudDeviceType
{
    NETDEV_CLOUD_DEV_TYPE_IPC                 = 0,          /* IPC豸 */
    NETDEV_CLOUD_DEV_TYPE_NVR                 = 1,          /* NVR豸 */
    NETDEV_CLOUD_DEV_TYPE_VMS                 = 2,          /* һ豸 */
    NETDEV_CLOUD_DEV_TYPE_DVR                 = 3,          /* DVR豸 */
    NETDEV_CLOUD_DEV_TYPE_EC                  = 4,          /* 豸 */
    NETDEV_CLOUD_DEV_TYPE_DC                  = 5,          /* 豸 */
    NETDEV_CLOUD_DEV_TYPE_INVALID            = 0xff         /* Чֵ */
}NETDEV_CLOUD_DEVICE_TYPE;

/**
 * @brief ƵַЭ
 * @attention
 */
typedef enum tagNETDEVCDNProt
{
    NETDEV_CDN_PROT_PRIVATE     = 0,       /* ˽ */
    NETDEV_CDN_PROT_RTMP        = 1        /* RTMPЭ */

}NETDEV_CDN_PROT_E;

/**
* @enum tagNETDEVFileType
* @brief ļϢ
* @attention  None
*/
typedef enum tagNETDEVFileType
{
    NETDEV_TYPE_FOLDER  = 0,    /* ļ */
    NETDEV_TYPE_FILE    = 1,    /* ļ */
    NETDEV_TYPE_INVALID = 0xff  /* ļ */
}NETDEV_FILE_TYPE_E;

/**
 * @brief ѯԴҵ
 * @attention
 */
typedef enum tagNETDEVSeqResType
{
    NETDEV_TYPE_SEQ_RES_REMOTE = 0,                                      /* Զʵ */
    NETDEV_TYPE_SEQ_RES_LOCAL  = 1,                                      /* ʵ */

    NETDEV_TYPE_SEQ_RES_INVALID                         = 0xff           /* Чֵ */
}NETDEV_SEQ_RES_TYPE_E;

/**
* @struct tagNETDEVFacePassRecordType
* @brief ͨм¼
* @attention  None
*/
typedef enum tagNETDEVFacePassRecordType
{
    NETDEV_TYPE_FACE_PASS_COM_SUCCESS       = 1,                /* ȶԳɹ澯 */
    NETDEV_TYPE_FACE_PASS_COM_FAIL          = 2,                /* ȶʧܸ澯 */
    NETDEV_TYPE_FACE_PASS_INVALID           = 0xff              /* Чֵ */
}NETDEV_FACE_PASS_RECORD_TYPE_E;

/**
* @enum tagNETDEVPersonResultCode
* @brief ״̬
* @attention  None
*/
typedef enum tagNETDEVPersonResultCode
{
    NETDEV_PERSON_CODE_SUCCEED                        = 0,               /* ɹ */
    NETDEV_PERSON_CODE_COMMON_FAIL                    = 1,               /* ִͨʧ */
    NETDEV_PERSON_CODE_SENDING                        = 2,               /* · */
    NETDEV_PERSON_CODE_DEV_NOT_SUPPORT                = 4,               /* 豸֧ */
    NETDEV_PERSON_CODE_ARGORITHM_INIT_FAIL            = 1000,            /* 㷨ʼʧ */
    NETDEV_PERSON_CODE_FACE_DETECT_FAIL               = 1001,            /* ʧ */
    NETDEV_PERSON_CODE_PICTURE_NO_FACE                = 1002,            /* ͼƬδ⵽ */
    NETDEV_PERSON_CODE_JPEG_DECODE_FAIL               = 1003,            /* jpegƬʧ */
    NETDEV_PERSON_CODE_PICTURE_QUALITY_LOW            = 1004,            /* ͼƬ */
    NETDEV_PERSON_CODE_PICTURE_ZOOM_FAIL              = 1005,            /* ͼƬʧ */
    NETDEV_PERSON_CODE_INTELLECT_DISABLE              = 1006,            /* δ */
    NETDEV_PERSON_CODE_PICTURE_TOO_SMALL              = 1007,            /* ͼƬС */
    NETDEV_PERSON_CODE_PICTURE_TOO_LARGE              = 1008,            /* ͼƬ */
    NETDEV_PERSON_CODE_RESOLUTION_TOO_LARGE           = 1009,            /* ͼƬֱʳ1920*1080 */
    NETDEV_PERSON_CODE_PICTURE_NON_EXISTENT           = 1010,            /* ͼƬ */
    NETDEV_PERSON_CODE_FACE_ELEMENTS_LIMIT            = 1011,            /* ԪظѴﵽ */
    NETDEV_PERSON_CODE_INTELLECT_MODULE_MISMATCH      = 1012,            /* ܰ㷨ģͲƥ */
    NETDEV_PERSON_CODE_DOCUMENT_ID_INVLID             = 1013,            /* Ա֤ŷǷ */
    NETDEV_PERSON_CODE_PICTURE_FORMAT_ERROR           = 1014,            /* ԱͼƬʽ */
    NETDEV_PERSON_CODE_MONITOR_DEVICE_LIMIT           = 1015,            /* ͨѴ豸 */
    NETDEV_PERSON_CODE_FACE_LIBRARY_LOCKED            = 1016,            /* ͻڽв */
    NETDEV_PERSON_CODE_FACE_LIBRARY_UPDATING          = 1017,            /* ļڸ */
    NETDEV_PERSON_CODE_JSON_DESERIALIZE_FAIL          = 1018,            /* Jsonлʧ */
    NETDEV_PERSON_CODE_BASE64_DECODE_FAIL             = 1019,            /* Base64ʧ */
    NETDEV_PERSON_CODE_PICTURE_SIZE_MISMATCH          = 1020,            /* ƬĴСʵʽյĳȲһ */
    NETDEV_PERSON_CODE_DEV_PROTOCOL_DIFFER            = 1021,            /* ֻѡͬͼƬЭ豸 */
    NETDEV_PERSON_CODE_INVALID                        = 0xff             /* Чֵ */
}NETDEV_PERSON_RESULT_CODE_E;

/**
 * @enum tagNETDEVPersonMonitorOptResCode
 * @brief ز
 * @attention VMS֧
 */
typedef enum tagNETDEVPersonMonitorOptResCode
{
    NETDEV_PERSON_MONITOR_CODE_INIT_DETECT_FAIL             = 11702,           /* ʼʧ */
    NETDEV_PERSON_MONITOR_CODE_FACE_DETECT_FAIL             = 11703,           /* ʧ */
    NETDEV_PERSON_MONITOR_CODE_IMAGE_NOT_FIND_FACE          = 11704,           /* ͼƬδ⵽ */
    NETDEV_PERSON_MONITOR_CODE_JPEG_PARSE_FAIL              = 11705,           /* jpegƬʧ */
    NETDEV_PERSON_MONITOR_CODE_IMAGE_MASS_NOT_ENOUGH        = 11706,           /* ͼƬ */
    NETDEV_PERSON_MONITOR_CODE_IMAGE_ZOOM_FAIL              = 11707,           /* ͼƬʧ */
    NETDEV_PERSON_MONITOR_CODE_NOT_START_SMART              = 11708,           /* δ */
    NETDEV_PERSON_MONITOR_CODE_PICTURE_TOO_SMALL            = 11709,           /* ͼƬС */
    NETDEV_PERSON_MONITOR_CODE_CREATE_FACE_LIB_FAIL         = 11710,           /* ʧ */
    NETDEV_PERSON_MONITOR_CODE_CREATE_MONITOR_FAIL          = 11711,           /* ʧ */
    NETDEV_PERSON_MONITOR_CODE_PICTURE_TOO_LARGE            = 11714,           /* ͼƬ */
    NETDEV_PERSON_MONITOR_CODE_RESOLUTION_TOO_LARGE         = 11715,           /* ͼƬֱʳ1920*1080 */
    NETDEV_PERSON_MONITOR_CODE_PICTURE_NON_EXISTENT         = 11716,           /* ͼƬ */
    NETDEV_PERSON_MONITOR_CODE_FACE_ELEMENTS_LIMIT          = 11717,           /* ԪظѴﵽ */
    NETDEV_PERSON_MONITOR_CODE_INTELLECT_MODULE_MISMATCH    = 11718,           /* ܰ㷨ģͲƥ */
    NETDEV_PERSON_MONITOR_CODE_DOCUMENT_ID_INVLID           = 11719,           /* Ա֤ŷǷ */
    NETDEV_PERSON_MONITOR_CODE_PICTURE_FORMAT_ERROR         = 11720,           /* ԱͼƬʽ */
    NETDEV_PERSON_MONITOR_CODE_MONITOR_DEVICE_LIMIT         = 11721,           /* ͨѴ豸 */
    NETDEV_PERSON_MONITOR_CODE_FACE_LIBRARY_LOCKED          = 11722,           /* ͻڽв */
    NETDEV_PERSON_MONITOR_CODE_FACE_LIBRARY_UPDATING        = 11723,           /* ļڸ */
    NETDEV_PERSON_MONITOR_CODE_JSON_DESERIALIZE_FAIL        = 11724,           /* Jsonлʧ */
    NETDEV_PERSON_MONITOR_CODE_BASE64_DECODE_FAIL           = 11725,           /* Base64ʧ */
    NETDEV_PERSON_MONITOR_CODE_PICTURE_SIZE_MISMATCH        = 11726            /* ƬĴСʵʽյĳȲһ */
}NETDEV_PERSON_MONITOR_OPT_RES_CODE_E;

/**
 * @brief 5ePTZʾģʽ öٶ  5ePTZ display mode Enumeration definition
 * @attention  None
 */
typedef enum tagNETDEVPTZDisplayMode
{
    NETDEV_PTZ_DISPLAY_ORIGINAL = 0,    /*ԭʼͼ*/
    NETDEV_PTZ_DISPLAY_5PTZ     = 1,    /*ȫ+5ePTZģʽ*/

    NETDEV_PTZ_DISPLAY_INVALID  = 0xff  /* Чֵ */
}NETDEV_PTZ_DISPLAY_MODE_E;

/**
 * @enum tagNETDEVVehLaneType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVVehLaneType
{
    NETDEV_VEH_LANE_TYPE_ENTRANCE                = 0,               /*  */
    NETDEV_VEH_LANE_TYPE_EXIT_NOCHARGE           = 1,               /* ڣշ */
    NETDEV_VEH_LANE_TYPE_EXITE_CHARGE            = 2,               /* ڣշ */
    NETDEV_VEH_LANE_TYPE_INVALID                 = 0xFF             /* Чֵ */
}NETDEV_VEH_LANE_TYPE_E;

/**
 * @enum tagNETDEVChgRuleType
 * @brief շѹ
 * @attention  None
 */
typedef enum tagNETDEVChgRuleType
{
    NETDEV_CHG_RULE_TYPE_E_TEMPCHARGE              = 0,             /* ʱշѹ */
    NETDEV_CHG_RULE_TYPE_E_RECHARGE                = 1,             /* ̶ֵ */
    NETDEV_CHG_RULE_TYPE_E_ABNCHARGE               = 2,             /* 쳣շѹ */
    NETDEV_CHG_RULE_TYPE_E_INVALID                 = 0xFF           /* Чֵ */
}NETDEV_CHG_RULE_TYPE_E;

/**
 * @enum tagNETDEVVehReleaseType
 * @brief 
 * @attention  None
 */
typedef enum tagNETDEVVehReleaseType
{
    NETDEV_VEH_RELEASE_TYPE_AUTO                 = 0,               /* Զ */
    NETDEV_VEH_RELEASE_TYPE_MANUAL               = 1,               /* ֶ */
    NETDEV_VEH_RELEASE_TYPE_INVALID              = 0xFF             /* Чֵ */
}NETDEV_VEH_RELEASE_TYPE_E;

/**
 * @enum tagNETDEVVehAttrType
 * @brief (ͣר)
 * @attention  None
 */
typedef enum tagNETDEVVehAttrType
{
    NETDEV_VEH_ATTR_FIXED                         = 0,                /* ̶ */
    NETDEV_VEH_ATTR_TEMPORARY                     = 1,                /* ʱ */
    NETDEV_VEH_ATTR_FIXEDOVERDUE                  = 2,                /* ̶ */
    NETDEV_VEH_ATTR_INVALID                       = 0xFF              /* Чֵ */
}NETDEV_VEH_ATTR_TYPE_E;

/**
 * @enum tagNETDEVChgType
 * @brief շ
 * @attention  None
 */
typedef enum tagNETDEVChgType
{
    NETDEV_CHG_TYPE_CASH                             = 0,                /* ֽշ */
    NETDEV_CHG_TYPE_ALIPY                            = 1,                /* ֧շ */
    NETDEV_CHG_TYPE_WECHAT                           = 2,                /* ΢շ */
    NETDEV_CHG_TYPE_UNIONPAY                         = 3,                /* շ */
    NETDEV_CHG_TYPE_INVALID                          = 0xFF              /* Чֵ */
}NETDEV_CHG_TYPE_E;

/**
 * @enum tagNETDEVDateFormatType
 * @brief ڸʽ
 * @attention  None
 */
typedef enum tagNETDEVDateFormatType
{
    NETDEV_DATE_FORMAT_TYPE_YMD                     = 0,                /*  */
    NETDEV_DATE_FORMAT_TYPE_MDY                     = 1,                /*  */
    NETDEV_DATE_FORMAT_TYPE_DMY                     = 2,                /*  */
    NETDEV_DATE_FORMAT_TYPE_INVALID                 = 0xFF              /* Чֵ */
}NETDEV_DATE_FORMAT_TYPE_E;

/**
 * @enum tagNETDEVAgeRange
 * @brief 
 * @attention 
 */
typedef enum tagNETDEVAgeRange
{
    NETDEV_AGE_RANGE_UNKNOW                                = 0,                /* δ֪ */
    NETDEV_AGE_RANGE_CHILD                                 = 1,                /* ͯ */
    NETDEV_AGE_RANGE_JUVENILE                              = 2,                /*  */
    NETDEV_AGE_RANGE_Youth                                 = 3,                /*  */
    NETDEV_AGE_RANGE_MIDDLEAGE                             = 4,                /*  */
    NETDEV_AGE_RANGE_OLDAGE                                = 5,                /*  */
    NETDEV_AGE_RANGE_INVALID                               = 0xFF              /* Ч */
}NETDEV_AGE_RANGE_E;

/**
 * @enum tagNETDEVEthicCode
 * @brief 
 * @attention 
 */
typedef enum tagNETDEVEthicCode
{
    NETDEV_ETHIC_CODE_UNKNOW                               = 0,                /* δ֪ */
    NETDEV_ETHIC_CODE_UYGUR                                = 1,                /* ά */
    NETDEV_ETHIC_CODE_OTHER                                = 2,                /*  */
    NETDEV_ETHIC_CODE_INVALID                              = 0xFF              /* Чֵ */
}NETDEV_ETHIC_CODE_E;

/**
 * @enum tagNETDEVGlassFlag
 * @brief Ƿ۾־
 * @attention 
 */
typedef enum tagNETDEVGlassFlag
{
    NETDEV_GLASS_FLAG_UNKNOW                              = 0,                 /* δ֪ */
    NETDEV_GLASS_FLAG_NO                                  = 1,                 /*  */
    NETDEV_GLASS_FLAG_YES                                 = 2,                 /*  */
    NETDEV_GLASS_FLAG_INVALID                             = 0xFF               /* Чֵ */
}NETDEV_GLASS_FLAG_E;

/**
 * @enum tagNETDEVGlassesStyle
 * @brief ۾ʽ
 * @attention 
 */
typedef enum tagNETDEVGlassesStyle
{
    NETDEV_GLASSES_STYLE_UNKNOW                            = 0,                 /* δ֪ */
    NETDEV_GLASSES_STYLE_GENERAL                           = 1,                 /* ͨ۾ */
    NETDEV_GLASSES_STYLE_SUNLIGHT                          = 2,                 /* ̫۾ */
    NETDEV_GLASSES_STYLE_OTHER                             = 99,                /*  */
    NETDEV_GLASSES_STYLE_INVALID                           = 0xFF               /* Чֵ */
}NETDEV_GLASSES_STYLE_E;

/**
 * @enum tagNETDEVMaskFlag
 * @brief Ƿ
 * @attention 
 */
typedef enum tagNETDEVMaskFlag
{
    NETDEV_MASK_FLAG_UNKNOW                        = 0,                 /* δ֪ */
    NETDEV_MASK_FLAG_NOT_WEAR                      = 1,                 /*  */
    NETDEV_MASK_FLAG_WEAR                          = 2,                 /*  */
    NETDEV_MASK_FLAG_INVALID                       = 0xFF               /* Чֵ */
}NETDEV_MASK_FLAG_E;

/**
 * @enum tagNETDEVSleevesLength
 * @brief ³̿ʽ
 * @attention 
 */
typedef enum tagNETDEVSleevesLength
{
    NETDEV_SLEEVES_LENGTH_UNKNOW                           = 0,                 /* δ֪ */
    NETDEV_SLEEVES_LENGTH_SHORT                            = 1,                 /*  */
    NETDEV_SLEEVES_LENGTH_LONG                             = 2,                 /*  */
    NETDEV_SLEEVES_LENGTH_INVALID                          = 0xFF               /* Чֵ */
}NETDEV_SLEEVES_LENGTH_E;

/**
 * @enum tagNETDEVTrousersLength
 * @brief ³̿ʽ
 * @attention 
 */
typedef enum tagNETDEVTrousersLength
{
    NETDEV_TROUSERS_LENGTH_UNKNOW                           = 0,                 /* δ֪ */
    NETDEV_TROUSERS_LENGTH_SHORT                            = 1,                 /* ̿ */
    NETDEV_TROUSERS_LENGTH_LONG                             = 2,                 /*  */
    NETDEV_TROUSERS_LENGTH_INVALID                          = 0xFF               /* Чֵ */
}NETDEV_TROUSERS_LENGTH_E;

/**
 * @enum tagNETDEVBodyToward
 * @brief ץĳ
 * @attention 
 */
typedef enum tagNETDEVBodyToward
{
    NETDEV_BODY_TOWARD_UNKNOW                              = 0,                 /* δ֪ */
    NETDEV_BODY_TOWARD_POSITIVE                            = 1,                 /*  */
    NETDEV_BODY_TOWARD_SIDE                                = 2,                 /*  */
    NETDEV_BODY_TOWARD_BACK                                = 3,                 /*  */
    NETDEV_BODY_TOWARD_INVALID                             = 0xFF               /* Чֵ */
}NETDEV_BODY_TOWARD_E;

/**
 * @enum tagNETDEVShoesTubeLength
 * @brief Ьӳ̿ʽ
 * @attention 
 */
typedef enum tagNETDEVShoesTubeLength
{
    NETDEV_SHOES_TUBE_LENGTH_UNKNOW                       = 0,                  /* δ֪ */
    NETDEV_SHOES_TUBE_LENGTH_LONG                         = 1,                  /* Ͳѥ */
    NETDEV_SHOES_TUBE_LENGTH_SHORT                        = 2,                  /* Ͳѥ/ͨЬ */
    NETDEV_SHOES_TUBE_LENGTH_INVALID                      = 0xFF                /* Чֵ */
}NETDEV_SHOES_TUBE_LENGTH_E;

/**
 * @enum tagNETDEVHairLength
 * @brief ͳ
 * @attention 
 */
typedef enum tagNETDEVHairLength
{
    NETDEV_HAIR_LENGTH_UNKNOW                            = 0,                   /* δ֪ */
    NETDEV_HAIR_LENGTH_LONG                              = 1,                   /*  */
    NETDEV_HAIR_LENGTH_SHORT                             = 2,                   /* ̷ */
    NETDEV_HAIR_LENGTH_INVALID                           = 0xFF                 /* Чֵ */
}NETDEV_HAIR_LENGTH_E;

/**
 * @enum tagNETDEVBagFlag
 * @brief ǷЯ־
 * @attention 
 */
typedef enum tagNETDEVBagFlag
{
    NETDEV_BAG_FLAG_NO                                   = 0,                   /* δ */
    NETDEV_BAG_FLAG_CARRY                                = 1,                   /*  */
    NETDEV_BAG_FLAG_BACK                                 = 2,                   /*  */
    NETDEV_BAG_FLAG_INVALID                              = 0xFF                 /* Чֵ */
}NETDEV_BAG_FLAG_E;

/**
 * @enum tagNETDEVSpeedType
 * @brief ṹзǻٶ
 * @attention 
 */
typedef enum tagNETDEVSpeedType
{
    NETDEV_SPEED_TYPE_UNKNOW                             = 0,                   /* δ֪ */
    NETDEV_SPEED_TYPE_STATIC                             = 1,                   /* ֹ */
    NETDEV_SPEED_TYPE_SLOW                               = 2,                   /*  */
    NETDEV_SPEED_TYPE_MEDIUM                             = 3,                   /*  */
    NETDEV_SPEED_TYPE_FAST                               = 4,                   /*  */
    NETDEV_SPEED_TYPE_INVALID                            = 0xFF                 /* Чֵ */
}NETDEV_SPEED_TYPE_E;

/**
 * @enum tagNETDEVImageDirection
 * @brief ṹзǻԻ˶
 * @attention 
 */
typedef enum tagNETDEVImageDirection
{
    NETDEV_IMAGE_DIRECTION_UNKNOW                        = 0,                   /* δ֪ */
    NETDEV_IMAGE_DIRECTION_STATIC                        = 1,                   /* ֹ */
    NETDEV_IMAGE_DIRECTION_UP                            = 2,                   /*  */
    NETDEV_IMAGE_DIRECTION_DOWN                          = 3,                   /*  */
    NETDEV_IMAGE_DIRECTION_LEFT                          = 4,                   /*  */
    NETDEV_IMAGE_DIRECTION_RIGHT                         = 5,                   /*  */
    NETDEV_IMAGE_DIRECTION_LEFTUP                        = 6,                   /*  */
    NETDEV_IMAGE_DIRECTION_LEFTDOWN                      = 7,                   /*  */
    NETDEV_IMAGE_DIRECTION_RIGHTUP                       = 8,                   /*  */
    NETDEV_IMAGE_DIRECTION_RIGHTDOWN                     = 9,                   /*  */
    NETDEV_IMAGE_DIRECTION_INVALID                       = 0xFF                 /* Чֵ */
}NETDEV_IMAGE_DIRECTION_E;

/**
 * @enum tagNETDEVNonVehType
 * @brief ǻ
 * @attention 
 */
typedef enum tagNETDEVNonVehType
{
    NETDEV_NON_VEH_TYPE_UNKNOW                           = 0,                   /* δ֪ */
    NETDEV_NON_VEH_TYPE_BICYCLE                          = 1,                   /* г */
    NETDEV_NON_VEH_TYPE_TRIYCLE                          = 2,                   /* ֳ */
    NETDEV_NON_VEH_TYPE_MOTORCYCLE                       = 3,                   /* Ħг */
    NETDEV_NON_VEH_TYPE_ELECTRIC_BICYCLE                 = 4,                   /* 綯г */
    NETDEV_NON_VEH_TYPE_TWOWHEEL_VEHICLE                 = 5,                   /* ֳĦг/г/綯г) */
    NETDEV_NON_VEH_TYPE_INVALID                          = 0xFF                 /* Чֵ */
}NETDEV_NON_VEH_TYPE_E;

/**
 * @enum tagNETDEVImageFormat
 * @brief ͼʽ
 * @attention 
 */
typedef enum tagNETDEVImageFormat
{
    NETDEV_IMAGE_FORMAT_JPG                              = 0,                   /* JPG */
    NETDEV_IMAGE_FORMAT_BMP                              = 1,                   /* BMP */
    NETDEV_IMAGE_FORMAT_PNG                              = 2,                   /* PNG */
    NETDEV_IMAGE_FORMAT_GIF                              = 3,                   /* GIF */
    NETDEV_IMAGE_FORMAT_TIFF                             = 4,                   /* TIFF */
    NETDEV_IMAGE_FORMAT_INVALID                          = 0xFF                 /* Чֵ */
}NETDEV_IMAGE_FORMAT_E;

/**
* @enum tagNETDEVClothesColor
* @brief ·ɫ 
* @attention  None
*/
typedef enum tagNETDEVClothesColor
{
    NETDEV_CLOTHES_COLOR_BLACK_E          = 0,            /* ɫ */
    NETDEV_CLOTHES_COLOR_WHITE_E           = 1,           /* ɫ */
    NETDEV_CLOTHES_COLOR_GRAY_E            = 2,           /* ɫ */
    NETDEV_CLOTHES_COLOR_RED_E             = 3,           /* ɫ */
    NETDEV_CLOTHES_COLOR_BLUE_E            = 4,           /* ɫ */
    NETDEV_CLOTHES_COLOR_YELLOW_E          = 5,           /* ɫ */
    NETDEV_CLOTHES_COLOR_ORANGE_E          = 6,           /* ɫ */
    NETDEV_CLOTHES_COLOR_BROWN_E           = 7,           /* ɫ */
    NETDEV_CLOTHES_COLOR_GREEN_E           = 8,           /* ɫ */
    NETDEV_CLOTHES_COLOR_PURPLE_E          = 9,           /* ɫ */
    NETDEV_CLOTHES_COLOR_CYAN_E            = 10,          /* ɫ */
    NETDEV_CLOTHES_COLOR_PINK_E            = 11,          /* ɫ */
    NETDEV_CLOTHES_COLOR_TRANSPARENT_E     = 12,          /* ͸ */
    NETDEV_CLOTHES_COLOR_SILVERYWHITE_E    = 13,          /*  */
    NETDEV_CLOTHES_COLOR_DARK_E            = 14,          /* ɫ */
    NETDEV_CLOTHES_COLOR_LIGHT_E           = 15,          /* ǳɫ */
    NETDEV_CLOTHES_COLOR_COLOURLESS        = 16,          /* ɫ */
    NETDEV_CLOTHES_COLOR_YELLOWGREEN       = 17,          /* ˫ɫ */
    NETDEV_CLOTHES_COLOR_GRADUALGREEN      = 18,          /* ɫ */
    NETDEV_CLOTHES_COLOR_OTHER_E           = 99,          /*  */
    NETDEV_CLOTHES_COLOR_UNKNOW_E          = 100,         /* δ֪ */
    NETDEV_CLOTHES_COLOR_INVALID           = 0xFF         /* Чֵ  Invalid value */
}NETDEV_CLOTHES_COLOR_E;

/**
* @enum tagNETDEVSupBoxDomeLinkage
* @brief Ƿ֧ǹ
* @attention  None
*/
typedef enum tagNETDEVSupBoxDomeLinkage
{
    NETDEV_SUP_BOX_DOME_LINKAGE_NO        = 0,          /* ֧ */
    NETDEV_SUP_BOX_DOME_LINKAGE_GUN       = 1,          /* ǹǹ */
    NETDEV_SUP_BOX_DOME_LINKAGE_DOME      = 2,          /* ǹ */
    NETDEV_SUP_BOX_DOME_LINKAGE_INVALID   = 0xFF        /* Чֵ */
}NETDEV_SUP_BOX_DOME_LINKAGE_E;

/**
* @enum tagNETDEVlinkageType
* @brief ֶ
* @attention  None
*/
typedef enum tagNETDEVlinkageType
{
    NETDEV_LINKAGE_TYPE_CLICK_TRACK           = 0,          /*  */
    NETDEV_LINKAGE_TYPE_ENLARGE_FRAME         = 1,          /* Ŵ */
    NETDEV_LINKAGE_TYPE_3D_LOCATE             = 2,          /* 3Dλ */
    NETDEV_LINKAGE_TYPE_INVALID               = 0xFF        /* Чֵ */
}NETDEV_LINKAGE_TYPE_E;

/**
* @enum tagNETDEVMasterSlaveLinkage
* @brief ֧ģʽ
* @attention  None
*/
typedef enum tagNETDEVMasterSlaveLinkage
{
    NETDEV_MASTER_SLAVE_LINKAGE_NO           = 0,           /* ֧ */
    NETDEV_MASTER_SLAVE_LINKAGE_HOST         = 1,           /*  */
    NETDEV_MASTER_SLAVE_LINKAGE_SLAVE        = 2,           /* ӻ */
    NETDEV_MASTER_SLAVE_LINKAGE_INVALID      = 0xFF         /* Чֵ */
}NETDEV_MASTER_SLAVE_LINKAGE_E;

/**
* @enum  tagNETDEVMotionDetectAreaType
* @brief ˶ö motion detection area type emnu
* @attention 
*/
typedef enum tagNETDEVMotionDetectAreaType
{
    NETDEV_MOTION_DETECTION_AREA_TYPE_RECTANGLE         = 0,        /*   rectangle */
    NETDEV_MOTION_DETECTION_AREA_TYPE_MB                = 1,        /*   macro block */
    NETDEV_MOTION_DETECTION_AREA_TYPE_INVALID           = 0xff      /* Чֵ Invalid value */
}NETDEV_MOTION_DETECTION_AREA_TYPE_E;

/**
* @enum tagNETDEVNotificationType
* @brief ֪ͨ
* @attention  None
*/
typedef enum tagNETDEVNotificationType
{
    NETDEV_NOTIFICATION_TYPE_REALTIME        = 0,           /* ʵʱ֪ͨ */
    NETDEV_NOTIFICATION_TYPE_HISTORY         = 1,           /* ʷ֪ͨ */
    NETDEV_NOTIFICATION_TYPE_EARLYWARN       = 2            /* Ԥ֪ͨ */
}NETDEV_NOTIFICATION_TYPE_E;

/**
* @enum  tagNETDEVNICWorkMode
* @brief ģʽö
* @attention 
*/
typedef enum tagNETDEVNICWorkMode
{
    NETDEV_NIC_WORK_MODE_MULTI_ADDR_SET                 = 0,        /* ַ趨 */
    NETDEV_NIC_WORK_MODE_LOAD_BALANCE                   = 1,        /* ؾ */
    NETDEV_NIC_WORK_MODE_NETWORK_FAULT_TOLERANCE        = 2,        /* ݴ */
    NETDEV_NIC_WORK_MODE_INVALID                        = 0xff      /* Чֵ */
}NETDEV_NIC_WORK_MODE_E;

/**
* @enum  tagNETDEVPortWorkMode
* @brief ڹģʽö
* @attention 
*/
typedef enum tagNETDEVPortWorkMode
{
    NETDEV_PORT_WORK_MODE_SELF_NEGOTIATION           = 0,        /* Э */
    NETDEV_PORT_WORK_MODE_10M_FULL                   = 1,        /* 10M FULL */
    NETDEV_PORT_WORK_MODE_10M_HALF                   = 2,        /* 10M HALF */
    NETDEV_PORT_WORK_MODE_100M_FULL                  = 3,        /* 100M FULL */
    NETDEV_PORT_WORK_MODE_100M_HALF                  = 4,        /* 100M HALF */
    NETDEV_PORT_WORK_MODE_1000M_FULL                 = 5,        /* 1000M FULL */
    NETDEV_PORT_WORK_MODE_10M_AUTO                   = 6,        /* 10M AUTO */
    NETDEV_PORT_WORK_MODE_100M_AUTO                  = 7,        /* 100M AUTO */
    NETDEV_PORT_WORK_MODE_1000M_AUTO                 = 8,        /* 1000M AUTO */

    NETDEV_PORT_WORK_MODE_WIFI_NORMAL                = 20,       /* WiFi normal */
    NETDEV_PORT_WORK_MODE_WIFI_SOFTAP                = 21,       /* WiFi softAP */
    NETDEV_PORT_WORK_MODE_WIFI_SNIFFER               = 22,       /* WiFi sniffer */

    NETDEV_PORT_WORK_MODE_4G_NORMAL                  = 31,       /* 4G normal */

    NETDEV_PORT_WORK_MODE_INVALID                    = 0xff      /* Чֵ */
}NETDEV_PORT_WORK_MODE_E;

/**
* @enum tagNETDEVCapSrc
* @brief ɼԴ
* @attention  None
*/
typedef enum tagNETDEVCapSrc
{
    NETDEV_CAP_SRC_FACE                      = 1,          /* ʶն˲ɼϢ */
    NETDEV_CAP_SRC_ENTRANCE_GUARDCARD        = 2,          /* ɼŽϢ */
    NETDEV_CAP_SRC_ID                        = 3,          /* ɼ֤Ϣ */
    NETDEV_CAP_SRC_GATE                      = 4,          /* բɼբϢ */
    NETDEV_CAP_SRC_INVALID                   = 0xff        /* Чֵ Invalid value */
}NETDEV_CAP_SRC_E;

/**
* @enum tagNETDEVMatchStatus
* @brief ƥ״̬
* @attention  None
*/
typedef enum tagNETDEVMatchStatus
{
    NETDEV_MATCH_STATUS_SUCCESS               = 1,          /* ɹ */
    NETDEV_MATCH_STATUS_FAIL                  = 2,          /* ʧܣȶʧ) */
    NETDEV_MATCH_STATUS_NO_MONITOR_TIME       = 3,          /* ʧܣԱȳɹڲʱ䣩*/
    NETDEV_MATCH_STATUS_BASE_MAP_COLLECT_SUCC = 4,          /* ͼɼɹ */
    NETDEV_MATCH_STATUS_BASE_MAP_COLLECT_FAIL = 5,          /* ͼɼʧ */
    NETDEV_MATCH_STATUS_INVALID               = 0xff        /* Чֵ Invalid value */
}NETDEV_MATCH_STATUS_E;

/**
* @enum tagNETDEVScaleEnabled
* @brief ״̬
* @attention  None
*/
typedef enum tagNETDEVScaleEnabled
{
    NETDEV_SCALE_ENABLED_NO                  = 0,           /*  */
    NETDEV_SCALE_ENABLED_IN                  = 1,           /*  */
    NETDEV_SCALE_ENABLED_FULL                = 2,           /*  */
    NETDEV_SCALE_ENABLED_INVALID             = 0xFF         /* Чֵ */
}NETDEV_SCALE_ENABLED_E;

/**
* @enum  tagNETDEVRecordTypeEx
* @brief ¼
* @attention 
*/
typedef enum tagNETDEVRecordTypeEx
{
    NETDEV_RECORD_TYPE_MANUALEX                     = 0x01,            /* ֶ¼ */
    NETDEV_RECORD_TYPE_COMON                        = 0x02,            /* ͨ澯(NVRݲ֧) */
    NETDEV_RECORD_TYPE_MOVE_DETECT                  = 0x04,            /* ˶ */
    NETDEV_RECORD_TYPE_INPUT_SWITCH                 = 0x08,            /* 뿪 */
    NETDEV_RECORD_TYPE_VIDEO_LOSS                   = 0x10,            /* Ƶʧ */
    NETDEV_RECORD_TYPE_AUDIO_DETECTION              = 0x20,            /* Ƶ */
    NETDEV_RECORD_TYPE_TRADEINFO                    = 0x40,            /* Ϣ(NVRݲ֧) */
    NETDEV_RECORD_TYPE_PLANNED                      = 0x80,            /* ƻ¼ */
    NETDEV_RECORD_TYPE_FACE_DETECTION               = 0x100,           /*  */
    NETDEV_RECORD_TYPE_CROSS_LINE_DETECT            = 0x200,           /* Խ */
    NETDEV_RECORD_TYPE_INTRUSION_DETECT             = 0x400,           /*  */
    NETDEV_RECORD_TYPE_IMAGE_BLURRY                 = 0x800,           /* ͼ齹 */
    NETDEV_RECORD_TYPE_GLOBAL_SCENE_CHANGE          = 0x1000,          /*  */
    NETDEV_RECORD_TYPE_INTE_MOTION                  = 0x2000,          /* ˶¼ */
    NETDEV_RECORD_TYPE_EMERGENCYBELL                = 0x4000,          /* 澯 */
    NETDEV_RECORD_TYPE_FACEMATCH_BAACKLIST          = 0x8000,          /* ʶ澯(NVRݲ֧) */
    NETDEV_RECORD_TYPE_FACEMATCH_WHITELIST          = 0x10000,         /* ʶ澯(NVRݲ֧) */
    NETDEV_RECORD_TYPE_REMAIN_ARTICLE               = 0x20000,         /* Ʒ */
    NETDEV_RECORD_TYPE_ARTICLE_MOVE                 = 0x40000,         /* Ʒ */
    NETDEV_RECORD_TYPE_PLATEMATCH_BAACKLIST         = 0x80000,         /* ʶ澯(NVRݲ֧) */
    NETDEV_RECORD_TYPE_PLATEMATCH_WHITELIST         = 0x100000,        /* ʶڰ澯(NVRݲ֧) */
    NETDEV_RECORD_TYPE_HUMAN_DETECTION              = 0x200000,        /* μ */
    NETDEV_RECORD_TYPE_INVALID                      = 0xffffffff       /* Чֵ */
}NETDEV_RECORD_TYPE_EX_E;

/**
* @enum  tagstNETDEVEventRecordType
* @brief ¼¼
* @attention 
*/
typedef enum tagstNETDEVEventRecordType
{
    NETDEV_EVENT_RECORD_TYPE_MOVE_DETECT               = 1,         /* ˶ */
    NETDEV_EVENT_RECORD_TYPE_ALARM_INPUT               = 2,         /*  */
    NETDEV_EVENT_RECORD_TYPE_MA                        = 3,         /* ˶͸澯洢(NVRݲ֧) */
    NETDEV_EVENT_RECORD_TYPE_M_A                       = 4,         /* ˶澯洢(NVRݲ֧) */
    NETDEV_EVENT_RECORD_TYPE_MANUAL_STORAGE            = 5,         /* ֶ洢(NVRݲ֧) */
    NETDEV_EVENT_RECORD_TYPE_BROKENNET                 = 6,         /* IPC(NVRݲ֧) */
    NETDEV_EVENT_RECORD_TYPE_THIRDSTREAM_STORAGE       = 7,         /* 洢(NVRݲ֧) */
    NETDEV_EVENT_RECORD_TYPE_VIDEO_LOSS                = 8,         /* Ƶʧ */
    NETDEV_EVENT_RECORD_TYPE_AUDIO_DETECTION           = 9,         /* Ƶ */
    NETDEV_EVENT_RECORD_TYPE_FACE_DETECTION            = 12,        /*  */
    NETDEV_EVENT_RECORD_TYPE_CROSS_LINE_DETECT         = 13,        /* Խ */
    NETDEV_EVENT_RECORD_TYPE_INTRUSION_DETECT          = 14,        /*  */
    NETDEV_EVENT_RECORD_TYPE_ALL_ALARM                 = 15,        /* ܸ澯(Ƶ⡢⡢Խ⡢) */
    NETDEV_EVENT_RECORD_TYPE_POS_EVENT                 = 16,        /* POS¼(NVRݲ֧) */
    NETDEV_EVENT_RECORD_TYPE_IMAGETOOBLURR             = 17,        /* 齹 */
    NETDEV_EVENT_RECORD_TYPE_GLOBAL_SCENE_CHANGE       = 18,        /*  */
    NETDEV_EVENT_RECORD_TYPE_INTE_MOTION               = 19,        /* ˶¼ */
    NETDEV_EVENT_RECORD_TYPE_EMERGENCYBELL             = 20,        /*  */
    NETDEV_EVENT_RECORD_TYPE_FACEMATCH_BAACKLIST       = 21,        /* ʶ(NVRݲ֧) */
    NETDEV_EVENT_RECORD_TYPE_FACEMATCH_WHITELIST       = 22,        /* ʶ(NVRݲ֧) */
    NETDEV_EVENT_RECORD_TYPE_REMAIN_ARTICLE            = 23,        /* Ʒ */
    NETDEV_EVENT_RECORD_TYPE_ARTICLE_MOVE              = 24,        /* Ʒ */
    NETDEV_EVENT_RECORD_TYPE_PLATEMATCH_BAACKLIST      = 25,        /* ʶ(NVRݲ֧) */
    NETDEV_EVENT_RECORD_TYPE_PLATEMATCH_WHITELIST      = 26,        /* ʶ(NVRݲ֧) */
    NETDEV_EVENT_RECORD_TYPE_NO_LIST_PLAN              = 27,        /* ƻ(NVRݲ֧) */
    NETDEV_EVENT_RECORD_TYPE_HUMAN_DETECTION           = 28,        /* μ */
    NETDEV_EVENT_RECORD_TYPE_INVALID                   = 0xff       /* Чֵ */
}NETDEV_EVENT_RECORD_TYPE_E;

/**
* @enum tagNETDEVMapType
* @brief ͼ
* @attention  None
*/
typedef enum tagNETDEVMapType
{
    NETDEV_MAP_TYPE_PICTURE        = 0,           /* ͼƬͼ */
    NETDEV_MAP_TYPE_ONLINE         = 1,           /* ߵͼ */
    NETDEV_MAP_TYPE_OFFLINE        = 2,           /* ߵͼ (ݲ֧) */
    NETDEV_MAP_TYPE_INVALID        = 0xFF         /* Чֵ */
}NETDEV_MAP_TYPE_E;

/**
* @enum  tagNETDEVExcpAlarmCapType
* @brief 豸쳣澯ö
* @attention 
*/
typedef enum tagNETDEVExcpAlarmCapType
{
    NETDEV_ALARM_TYPE_STOR_ERR                        = 201,          /* 洢 */

    NETDEV_ALARM_TYPE_PREVENT_REMOVE                  = 203,          /* 𱨾 */
    NETDEV_ALARM_TYPE_IP_CONFLICT                     = 204,          /* IPͻ */
    NETDEV_ALARM_TYPE_NET_OFF                         = 205,          /* Ͽ */
    NETDEV_ALARM_TYPE_DISK_OFFLINE                    = 206,          /* Ӳ */

    NETDEV_ALARM_TYPE_CPU_HIGHTEMP                    = 208,          /* CPU */
    NETDEV_ALARM_TYPE_MAINBOARD_HIGHTEMP              = 209,          /*  */
    NETDEV_ALARM_TYPE_DEVICE_HIGHTEMP                 = 210,          /* 豸 */
    NETDEV_ALARM_TYPE_DEVICE_LOWTEMP                  = 211,          /* 豸 */
    NETDEV_ALARM_TYPE_FAN_FAULT                       = 212,          /* ȹ */
    NETDEV_ALARM_TYPE_LEDBOX_HIGHTEMP                 = 213,          /*  */
    NETDEV_ALARM_TYPE_LEDBOX_SMOKE                    = 214,          /* 澯 */

    NETDEV_ALARM_TYPE_DISK_ABNORMAL                   = 403,          /* Ӳ쳣 */
    NETDEV_ALARM_TYPE_ILLEGAL_ACCESS                  = 404,          /* Ƿ */

    NETDEV_ALARM_TYPE_STORAGE_WILL_FULL               = 410,          /* 洢 */
    NETDEV_ALARM_TYPE_STORAGE_IS_FULL                 = 411,          /* 洢 */

    NETDEV_ALARM_TYPE_VIDEO_CAPTURE_ABNORMAL          = 417           /* ¼/ץͼ쳣 */
}NETDEV_EXCP_ALARM_CAP_TYPE_E;

/**
* @enum tagNETDEVOrderStatus
* @brief ֧״̬
* @attention  None
*/
typedef enum tagNETDEVOrderStatus
{
    NETDEV_ORDER_STATUS_FINISH            = 0,        /* δ֧ */
    NETDEV_ORDER_STATUS_UNFINISH          = 1,        /* ֧ */
    NETDEV_ORDER_STATUS_PREPAYMENT        = 2,        /* Ԥ֧ */
    NETDEV_ORDER_STATUS_INVALID           = 0xff      /* Чֵ Invalid value */
}NETDEV_ORDER_STATUS_E;

/**
* @enum tagNETDEVPayType
* @brief ֧
* @attention  None
*/
typedef enum tagNETDEVPayType
{
    NETDEV_PAY_TYPE_CASH              = 0,        /* ֽ֧ */
    NETDEV_PAY_TYPE_ALIPAY            = 1,        /* ֧֧ */
    NETDEV_PAY_TYPE_WECHAT            = 2,        /* ΢֧ */
    NETDEV_PAY_TYPE_INVALID           = 0xff      /* Чֵ Invalid value */
}NETDEV_PAY_TYPE_E;

/**
* @enum tagNETDEVLAPISubType
* @brief LAPIЭ鶩
* @attention  None
*/
typedef enum tagNETDEVLAPISubType
{
    NETDEV_LAPI_SUB_TYPE_PARKRECOGNIZE           = 2048,      /* ͣʶץ */
    NETDEV_LAPI_SUB_TYPE_INVALID                 = 0xffffffff /* Чֵ Invalid value */
}NETDEV_LAPI_SUB_TYPE_E;

/**
* @enum  tagNETDEVAlarmSrcBelongType
* @brief 澯
* @attention 
*/
typedef enum tagNETDEVAlarmSrcBelongType
{
    NETDEV_ALARM_SRC_BELONG_TYPE_OTHER                     = 0,            /*  */
    NETDEV_ALARM_SRC_BELONG_TYPE_CHL                       = 1,            /* ͨ澯 */
    NETDEV_ALARM_SRC_BELONG_TYPE_DEV                       = 2,            /* 豸澯 */
    NETDEV_ALARM_SRC_BELONG_TYPE_INVALID                   = 0xffff        /* Чֵ */
}NETDEV_ALARM_SRC_BELONG_TYPE_E;

/**
 * @brief ɫ
 * @attention
 */
typedef enum tagNETDEVColorTemperature
{
    NETDEV_COLOR_TEMPERATURE_STANDARD               = 0,           /* ׼ */
    NETDEV_COLOR_TEMPERATURE_COOL                   = 1,           /* ɫ */
    NETDEV_COLOR_TEMPERATURE_WARM                   = 2,           /* ůɫ */
    NETDEV_COLOR_TEMPERATURE_INVALID                = 0xff         /* Чֵ */
}NETDEV_COLOR_TEMPERATURE_E;

/**
 * @brief 
 * @attention
 */
typedef enum tagNETDEVCascadeDirection
{
    NETDEV_CASCADE_DIRECTION_RIGHT_TO_LEFT     = 1,        /* ҵ */
    NETDEV_CASCADE_DIRECTION_LEFT_TO_RIGHT     = 2,        /*  */
    NETDEV_CASCADE_DIRECTION_BOTTOM_TO_TOP     = 3,        /* µ */
    NETDEV_CASCADE_DIRECTION_TOP_TO_BOTTOM     = 4,        /* ϵ */
    NETDEV_CASCADE_DIRECTION_INVALID           = 0xff         /* Чֵ */
}NETDEV_CASCADE_DIRECTION_E;

/**
 * @brief Ӱģʽ
 * @attention
 */
typedef enum tagNETDEVBlankingMode
{
    NETDEV_BLANKING_MODE_ENHANCE     = 0,        /* ǿ */
    NETDEV_BLANKING_MODE_CLOSE       = 1,        /* ر */
    NETDEV_BLANKING_MODE_DEFAULT     = 2,        /* Ĭ */
    NETDEV_BLANKING_MODE_WEAKEN      = 3,        /*  */
    NETDEV_BLANKING_MODE_WEAKEST     = 4,        /*  */

    NETDEV_BLANKING_MODE_INVALID     = 0xff         /* Чֵ */
}NETDEV_BLANKING_MODE_E;

/**
 * @brief У״̬
 * @attention
 */
typedef enum tagNETDEVPointCalStatus
{
    NETDEV_POINT_CAL_STATUS_CLOSE      = 0,           /* ر */
    NETDEV_POINT_CAL_STATUS_BRIGHT     = 1,           /* У */
    NETDEV_POINT_CAL_STATUS_CHROMA     = 2,           /* ɫУ */
    NETDEV_POINT_CAL_STATUS_INVALID    = 0xff         /* Чֵ */
}NETDEV_POINT_CAL_STATUS_E;

/**
 * @brief оƬ
 * @attention
 */
typedef enum tagNETDEVRecvCardChipType
{
    NETDEV_RECV_CARD_CHIP_TYPE_LS9929  = 0,           /* LS9929 */
    NETDEV_RECV_CARD_CHIP_TYPE_ICN2153 = 1,           /* ICN2153 */
    NETDEV_RECV_CARD_CHIP_TYPE_ICN2065 = 2,           /* ICN2065 */
    NETDEV_RECV_CARD_CHIP_TYPE_ICN2069 = 3,           /* ICN2069 */

    NETDEV_RECV_CARD_CHIP_TYPE_INVALID = 0xff         /* Чֵ */
}NETDEV_RECV_CARD_CHIP_TYPE_E;

/**
 * @brief ƴУʾģʽ
 * @attention
 */
typedef enum tagNETDEVSeamCalDisplayMode
{
    NETDEV_SEAM_CAL_DISPLAY_MODE_NORMAL    = 0,           /* ģʽ */
    NETDEV_SEAM_CAL_DISPLAY_MODE_PIECE     = 1,           /* ƴģʽ */

    NETDEV_SEAM_CAL_DISPLAY_MODE_INVALID = 0xff           /* Чֵ */
}NETDEV_SEAM_CAL_DISPLAY_MODE_E;

/**
 * @brief ҵģʽ
 * @attention
*/
typedef enum tagNETDEVSceneSessionMode
{
    NETDEV_SCENE_SESSION_MODE_CLASSICS = 0,               /* ģʽ */
    NETDEV_SCENE_SESSION_MODE_ADAPTIVE_IN_SIGNAL_SRC = 1, /* ӦźԴģʽ */

    NETDEV_SCENE_SESSION_MODE_INVALID = 0xff              /* Чֵ */
}NETDEV_SCENE_SESSION_MODE_E;

/**
 * @brief 
 * @attention
*/
typedef enum tagNETDEVClearBadPointType
{
    NETDEV_CLEAR_BAD_POINT_TYPE_CUSTOMED         = 0,     /* Զ */
    NETDEV_CLEAR_BAD_POINT_TYPE_COMMON           = 1,     /* ͨģʽ */
    NETDEV_CLEAR_BAD_POINT_TYPE_ENHANCED         = 2,     /* ǿģʽ */

    NETDEV_CLEAR_BAD_POINT_TYPE_INVALID = 0xff              /* Чֵ */
}NETDEV_CLEAR_BAD_POINT_TYPE_E;

/**
 * @enum tagNETDEVStorageCapUnit
 * @brief 洢λ öٶ
 * @attention  None
 */
typedef enum tagNETDEVStorageCapUnit
{
    NETDEV_TYPE_STORAGE_CAP_UNIT_GB               = 0,        /* GB */
    NETDEV_TYPE_STORAGE_CAP_UNIT_MB               = 1,        /* MB */
    NETDEV_TYPE_STORAGE_CAP_UNIT_INVALID          = 0xff      /* Чֵ */
}NETDEV_STORAGE_CAP_UNIT_E;

/**
 * @enum tagNETDEVStorageResType
 * @brief 洢Դ öٶ
 * @attention  None
 */
typedef enum tagNETDEVStorageResType
{
    NETDEV_STORAGE_RES_TYPE_SD        = 0,     /* SD */
    NETDEV_STORAGE_RES_TYPE_NAS       = 1,     /* NAS */
    NETDEV_STORAGE_RES_TYPE_INVALID   = 0xff   /* Чֵ */
}NETDEV_STORAGE_RES_TYPE_E;

/**
 * @enum tagNETDEVPicStorageMode
 * @brief ͼƬ洢ģʽ öٶ
 * @attention  None
 */
typedef enum tagNETDEVPicStorageMode
{
    NETDEV_PIC_STORAGE_MODE_NORMAL             = 0,     /* ϴɹɾSDеļ */
    NETDEV_PIC_STORAGE_MODE_PERMANENT          = 1,     /* 棬ϴǷɹᱣSDеļ */
    NETDEV_PIC_STORAGE_MODE_RETAIN             = 2,     /* ϴʧܺSDϵļ */
    NETDEV_PIC_STORAGE_MODE_INVALID            = 0xff   /* Чֵ */
}NETDEV_PIC_STORAGE_MODE_E;

/**
 * @enum tagNETDEVFullStrategyType
 * @brief 洢 öٶ
 * @attention  None
 */
typedef enum tagNETDEVFullStrategyType
{
    NETDEV_FULL_STRATEGY_TYPE_FULL_COVERAGE              = 0,       /*  */
    NETDEV_FULL_STRATEGY_TYPE_FULL_STOP                  = 1,       /* ͣ */
    NETDEV_FULL_STRATEGY_TYPE_INVALIDP                   = 0xff     /* Чֵ */
}NETDEV_FULL_STRATEGY_TYPE_E;

/**
* @struct tagNETDEVIVAShowRule
 * @brief Ԫʾ
* @attention 
*/
typedef enum tagNETDEVIVAShowRule
{
    NETDEV_IVA_SHOW_RULE                    = 0x00000001,          /* ʾ߿ */
    NETDEV_IVA_SHOW_RESULT_TOUTH_RULE       = 0x00000002,          /* ʾĿ */
    NETDEV_IVA_SHOW_RESULT_UNTOUTH_RULE     = 0x00000004,          /* ʾδĿ */
    NETDEV_IVA_SHOW_TRACK                   = 0x00000008           /* ʾĿ켣 */
}NETDEV_IVA_SHOW_RULE_E;

/**
* @brief 󽹿Ʋ öٶ
 * @attention  None
 */
typedef enum tagNETDEVBackFocusCmd
{
    NETDEV_BACKFOCUS_CMD_RESET              = 0,     /* Զ󽹸λ Para1ѡ  */
    NETDEV_BACKFOCUS_CMD_AUTO               = 1,     /* ʾԶ Para1:Զʱ(ms) */
    NETDEV_BACKFOCUS_CMD_MANUAL             = 2,     /* ʾֶ Para1:0-ֹͣ, 1-MBF+, 2-MBF- */
    NETDEV_BACKFOCUS_CMD_INVALID            = 0xffff /* Чֵ */
}NETDEV_BACKFOCUS_CMD_E;

/* END************* öֵ  Enumeration value *************************** */

/* BEGIN*********** ṹ  Structure *********************************** */
/**
 * @brief 豸Ϣ ṹ嶨 Device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVDeviceInfo
{
    INT32   dwDevType;                          /* 豸,μö#NETDEV_DEVICE_TYPE_E  Device type, see enumeration #NETDEV_DEVICE_TYPE_E */
    INT16   wAlarmInPortNum;                    /*   Number of alarm inputs */
    INT16   wAlarmOutPortNum;                   /*   Number of alarm outputs */
    INT32   dwChannelNum;                       /* ͨ  Number of Channels */
    BYTE    byRes[48];                          /* ֶ  Reserved */
}NETDEV_DEVICE_INFO_S,*LPNETDEV_DEVICE_INFO_S;

/**
 * @brief 豸Ϣ ṹ嶨 Basic device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVDeviceBasicInfo
{ 
    CHAR szDevModel[NETDEV_LEN_64];                     /* 豸ͺ  Device model */
    CHAR szSerialNum[NETDEV_LEN_64];                    /* Ӳк  Hardware serial number */
    CHAR szFirmwareVersion[NETDEV_LEN_64];              /* 汾  Software version */
    CHAR szMacAddress[NETDEV_LEN_64];                   /* IPv4Macַ  MAC address of IPv4 */
    CHAR szDeviceName[NETDEV_LEN_64];                   /* 豸  Device name */
    CHAR szManufacturer[NETDEV_LEN_64];                 /* Ϣ  Manufacturer */

    BYTE byRes[384];                                    /* ֶ  Reserved */
}NETDEV_DEVICE_BASICINFO_S, *LPNETDEV_DEVICE_BASICINFO_S;

/**
 * @brief Ϣ ṹ嶨 Network configuration information
 * @attention  None
 */
typedef struct tagNETDEVNetworkInterfaces
{
    INT32   dwMTU;                              /* MTUֵ  MTU value */
    BOOL    bIPv4DHCP;                          /* IPv4DHCP  DHCP of IPv4 */
    CHAR    szIpv4Address[NETDEV_LEN_32];       /* IPv4IPַ  IP address of IPv4 */
    CHAR    szIPv4GateWay[NETDEV_LEN_32];       /* IPv4صַ  Gateway of IPv4 */
    CHAR    szIPv4SubnetMask[NETDEV_LEN_32];    /* IPv4  Subnet mask of IPv4 */
    BYTE    byRes[480];                         /* ֶ  Reserved */
}NETDEV_NETWORKCFG_S, *LPNETDEV_NETWORKCFG_S;

/**
 * @brief VPNͻָģʽϢ
 * @attention  None
 */
typedef struct tagNETDEVVPNClientInfo
{
    UINT32   udwEnabled;                                     /* Ƿ Ӧݸʽһ0: ر 1:  Support UNP or nota switch that corresponds to a compatible format, enable 0:unable  1:enable*/
    UINT32   udwCompatibilityMode;                         /* Ӧõļģʽ 0: Unp1.0unp 1: Unp2.0 (softvpn). Corresponds to the set compatibility mode.0: Unp1.0unp 1: Unp2.0 (softvpn) */
    UINT32   udwAuthEnabled;                                 /* ȨǷΪUnp2.0һȨΪ״̬0ر 1 Authentication open or close, if is Unp2.0, must authentication and open. 0:close 1:open  */
    UINT32   udwEncryptEnabled;                              /* Ƿģʽ, ǰģʽΪUnp1.0 ֶΪʹܹرա0ر 1 */
    UINT32   udwInterface;                                 /* ѡIPC ҪNVRVMSҪڣ0 ,4G ڣ1Χ[0,1]*/
    CHAR     szLoginName[NETDEV_DOMAIN_LEN];               /* ѡAuthEnableʱֶΡû֧Χ[0-63]*/
    CHAR     szPIN[NETDEV_LEN_256];                        /* ѡAuthEnableʱֶηû뷶Χ[0,256],޸Ľ¼ʱЯ޸Ľ¼ʱЯ*/
    UINT32   udwAddressType;
    CHAR     szAddress[NETDEV_IPADDR_STR_MAX_LEN];         /* AddressTypeIPַ͡ 0: IPv4 1: IPv6 2: 3: IPv4IPv6Ҫ.ǰ֧IPv4*/
    UINT32   udwPort;                                      /* ѡ;NVR VMSҪֶΣӦݸʽķ˿ڣΧ[1-65535]Unp1.0Ĭֵ1701Unp2.0 Ĭ5555*/ 
    UINT32   udwUNPSuccessd;                               /* UNPɹ ʶ (ѯرʾǰӦUNP޷Ӧip,,·)1 ɹ0 ʧܣȡʱЯ*/
    CHAR     szUNPShareIPAddr[NETDEV_IPADDR_STR_MAX_LEN];  /* UNPɹ ĶӦַ (ѯӳɹŷ,) */
    CHAR     szUNPShareMask[NETDEV_IPADDR_STR_MAX_LEN];    /* UNPɹ ĶӦ(鲢ӳɹŷ,) */ 
    CHAR     szUNPShareWayAddr[NETDEV_IPADDR_STR_MAX_LEN]; /* UNPɹ ĶӦ·(ѯӳɹŷ,) */
    BYTE     byRes[256];                                   /* ֽ  Reserved*/
}NETDEV_VPN_CLIENT_INFO_S, *LPNETDEV_VPN_CLIENT_INFO_S;

/**
 * @brief ַ ṹ嶨 Address Structure definition 
 * @attention  None
 */
typedef struct tagSysemIPAddr
{
    INT32   eIPType;                            /* ЭͲμö#NETDEV_HOSTTYPE_E  Protocol type, see enumeration #NETDEV_HOSTTYPE_E */
    CHAR    szIPAddr[NETDEV_LEN_132];           /* IPַ  IP address */
}NETDEV_SYSTEM_IPADDR_S, *LPNETDEV_SYSTEM_IPADDR_S;

/**
 * @brief  NTP NTP parameter
 * @attention  None
 */
typedef struct tagNETDEVSystemNTPInfo
{
    BOOL bSupportDHCP;                      /* Ƿ֧DHCP  Support DHCP or not */
    NETDEV_SYSTEM_IPADDR_S stAddr;          /* NTP Ϣ  NTP information */
}NETDEV_SYSTEM_NTP_INFO_S, *LPNETDEV_SYSTEM_NTP_INFO_S;


typedef struct tagSysemIPAddrInfo
{
    BOOL         bEnabled;                      /*NTPʹ 0  1  NTP Server enable 0:unable  1:enable */
    INT64        ulAddressType;                    /*ַ 0IPv4  1IPv6(ݲ֧)  2: NVRһ֧֣ Address type  0:IPv4  1:IPv6(Temporary does not support)  2:domain name(NVR and AIO support)*/
    CHAR         szIPAddress[NETDEV_LEN_64];     /* NTPIPַַȷΧ[0, 64] AddressType Ϊ0ʱýڵѡ
                                                 The IP address of the NTP server ,character length range [0,64]. When address type is 0,the node must be selected. */
    CHAR         szDomainName[NETDEV_LEN_64];    /*NTPַȷΧ[ [0 64] AddressType Ϊ2ʱýڵѡ
                                                 The domain name of the NTP server ,character length range [0,64]. When address type is 2,the node must be selected.*/
    INT64        ulPort;                        /*NTP˿ڣΧ[1-65535]  IPC֧á NTP Port ,the range of [1-65535]. IPC does not support this configuration. */
    INT64        ulSynchronizeInterval;         /*¼ NVRVMSַ֧Χ 5/10/15/30ӣ1/2/3/6/12h1죬1ܡIPCַ֧Χ30-3600sʱڣҪתΪΪλʱֵ
                                                 Synchronize Interval: The support range of NVR and VMS is 5/10/15/30 minutes ,1/2/3/6/12 hours ,1 day ,and 1 week.The support range of IPC is 30-3600 seconds.
                                                 All of the above time periods need to be converted to a time value in seconds.*/
    BYTE         byRes[128];                    /*ֶ  Reserved*/
}NETDEV_SYSTEM_IPADDR_INFO_S, *LPNETDEV_SYSTEM_IPADDR_INFO_S;

typedef struct tagNETDEVSystemNTPInfoList
{
    INT64                              ulNum;                                             /*NTP  NTP Server Number*/
    NETDEV_SYSTEM_IPADDR_INFO_S        astNTPServerInfoList[NETDEV_NTP_SERVER_LIST_NUM];  /*NTPбǰֻ֧һNTP The NTP server list currently supports only one NTP server.*/
    BYTE                               byRes[128];                                          /*ֶ   Reserved*/
}NETDEV_SYSTEM_NTP_INFO_LIST_S, *LPNETDEV_SYSTEM_NTP_INFO_LIST_S;

typedef enum tagNETDEVStartStreamProt
{
    NETDEV_START_STREAM_PROT_UDP      =1,
    NETDEV_START_STREAM_PROT_TCP      =2,
    NETDEV_START_STREAM_PROT_RTSP     =3,
    NETDEV_START_STREAM_PROT_HTTP     =4,
    NETDEV_START_STREAM_PROT_INVALID  =0xff
}NETDEV_START_STREAM_PROT_E;


/**
 * @brief ʵԤ ṹ嶨 Live view parameter Structure definition
 * @attention  None
 */
typedef struct tagNETDEVPriviewInfo
{
    INT32   dwChannelID;                 /* ͨID  Channel ID */
    INT32   dwStreamType;                /* ,μö#NETDEV_LIVE_STREAM_INDEX_E  Stream type, see enumeration #NETDEV_LIVE_STREAM_INDEX_E */
    INT32   dwLinkMode;                  /* Э,μö#NETDEV_PROTOCAL_E  Transport protocol, see enumeration #NETDEV_PROTOCAL_E */
    LPVOID  hPlayWnd;                    /* Ŵھ Play window handle */ 
    INT32   dwFluency;                   /* ͼ񲥷,μö#NETDEV_PICTURE_FLUENCY_E */
    INT32   dwStreamMode;                /* ģʽ μö#NETDEV_STREAM_MODE_E  start stream mode see #NETDEV_STREAM_MODE_E*/
    INT32   dwLiveMode;                  /* ģʽ μö#NETDEV_PULL_STREAM_MODE_E */
    INT32   dwDisTributeCloud;           /* ַ μö#NETDEV_DISTRIBUTE_CLOUD_SRV_E */
    BOOL    dwallowDistribution;         /* ͨǷַַ֧*/
    INT32   dwTransType;                 /* ͣμö#NETDEV_TRANS_TYPE_E */
    INT32   dwStreamProtocol;            /* Э飬μö# NETDEV_START_STREAM_PROT_E*/
    BYTE    byRes[236];                  /* ֶ  Reserved */
}NETDEV_PREVIEWINFO_S, *LPNETDEV_PREVIEWINFO_S;

/**
 * @brief ʵӰϢ ṹ嶨 Live image information Structure definition
 * @attention ٤Χ0-10,ȡֵΧ0-255 Gamma parameter range: 0-10, other parameters: 0-255
 */
typedef struct tagNETDEVVideoEffect
{
    INT32 dwContrast;                   /* Աȶ  Contrast */
    INT32 dwBrightness;                 /*   Brightness */
    INT32 dwSaturation;                 /* Ͷ  Saturation */
    INT32 dwHue;                        /* ɫ  Hue */
    INT32 dwGamma;                      /* ٤ֵ  Gamma */
    BYTE  byRes[16];                    /* ֶ  Reserved */
}NETDEV_VIDEO_EFFECT_S, *LPNETDEV_VIDEO_EFFECT_S;

/**
 * @brief 豸ͼ ṹ嶨    Device image settings Structure definition
 * @attention ȡֵΧ0-255     parameter range: 0-255
 */
typedef struct tagNETDEVImagingSetting
{
    INT32 dwContrast;                   /* Աȶ  Contrast */
    INT32 dwBrightness;                 /*   Brightness */
    INT32 dwSaturation;                 /* Ͷ  Saturation */
    INT32 dwSharpness;                  /*   Sharpness */
    BYTE  byRes[252];                   /* ֶ  Reserved */
}NETDEV_IMAGE_SETTING_S, *LPNETDEV_IMAGE_SETTING_S;

/************ طҵ Playback services***********************************************/

/**
 * @brief ¼ ṹ嶨 Recording query Structure definition
 *        ļ.ʱ豸¼ļ Query recording files according to file type and time
 * @attention  None
 */
typedef struct tagNETDEVFindCond
{
    CHAR    szFileName[NETDEV_LEN_64];      /* ¼ļ  Recording file name */
    INT32   dwChannelID;                    /* ͨ  Channel ID */
    INT32   dwStreamType;                   /* ,μö#NETDEV_LIVE_STREAM_INDEX_E  Stream type, see enumeration #NETDEV_LIVE_STREAM_INDEX_E */
    INT32   dwFileType;                     /* ¼洢,μö# NETDEV_STORE_TYPE_E  Recording storage type, see enumeration #NETDEV_STORE_TYPE_E */
    INT64   tBeginTime;                     /* ʼʱ  Start time */
    INT64   tEndTime;                       /* ʱ  End time */
    INT32   dwRecordLocation;               /* ¼洢λ Record Position, μö#NETDEV_RECORD_LOCATION_E */
    UINT32  udwServerID;                    /* ¼ID Video server ID */
    BYTE    byRes[28];                      /* ֶ  Reserved */
}NETDEV_FILECOND_S, *LPNETDEV_FILECOND_S;

/**
 * @brief ¼ ṹ嶨 Recording query data Structure definition
 *        ȡҵļϢ Get the information of found files one by one
 * @attention  None
 */
typedef struct tagNETDEVFindData
{
    CHAR    szFileName[NETDEV_FILE_NAME_LEN];               /* ¼ļ  Recording file name */
    INT64   tBeginTime;                                     /* ʼʱ  Start time */
    INT64   tEndTime;                                       /* ʱ  End time */
    BYTE    byFileType;                                     /* ¼洢  μö#NETDEV_STORE_TYPE_E Recording storage type #NETDEV_STORE_TYPE_E */
    UINT32  udwServerID;                                    /* ¼ID */
    UINT32  udwFileSize;                                    /* ¼ļС Recording file size */
    BYTE    byRes[163];                                     /* ֶ  Reserved */
}NETDEV_FINDDATA_S,*LPNETDEV_FINDDATA_S;

/**
 * @brief ļط¼ ṹ嶨 Parameters of play back recordings by file name Structure definition
 * @attention  None
 */
typedef struct tagNETDEVPlayBackInfo
{
    char    szName[NETDEV_LEN_260];         /* طŵĿƿ  Playback control block name*/
    INT64   tBeginTime;                     /* طſʼʱ  Playback start time */
    INT64   tEndTime;                       /* طŽʱ  Playback end time */
    INT32   dwLinkMode;                     /* Э,μö#NETDEV_PROTOCAL_E  Transport protocol, see enumeration #NETDEV_PROTOCAL_E */
    LPVOID  hPlayWnd;                       /* Ŵھ  Play window handle */
    INT32   dwFileType;                     /* ¼洢,μö#NETDEV_PLAN_STORE_TYPE_E  Recording storage type, see enumeration #NETDEV_PLAN_STORE_TYPE_E */
    INT32   dwDownloadSpeed;                /* ٶ μö#NETDEV_E_DOWNLOAD_SPEED_E  Download speed, see enumeration #NETDEV_E_DOWNLOAD_SPEED_E */
    INT32   dwStreamMode;                   /*  ģʽμö#NETDEV_STREAM_MODE_E  stream mode see #NETDEV_STREAM_MODE_E */
    BYTE    byRes[252];                     /* ֶ  Reserved */
}NETDEV_PLAYBACKINFO_S, *LPNETDEV_PLAYBACKINFO_S;

/**
 * @brief ͼ ṹ嶨 Image data Structure definition
 *        ŽͼݵָͳȵϢ Storing pointer and length of decoded picture data
 * @attention  None
 */
typedef struct tagNETDEVPictureData
{
    BYTE    *pucData[4];                /* pucData[0]:Y ƽָ,pucData[1]:U ƽָ,pucData[2]:V ƽָ  pucData[0]: Y plane pointer, pucData[1]: U plane pointer, pucData[2]: V plane pointer */
    INT32   dwLineSize[4];              /* ulLineSize[0]:Yƽÿп, ulLineSize[1]:Uƽÿп, ulLineSize[2]:Vƽÿп  ulLineSize[0]: Y line spacing, ulLineSize[1]: U line spacing, ulLineSize[2]: V line spacing */
    INT32   dwPicHeight;                /* ͼƬ߶  Picture height */
    INT32   dwPicWidth;                 /* ͼƬ  Picture width */
    INT32   dwRenderTimeType;           /* Ⱦʱ  Time data type for rendering */
    INT64   tRenderTime;                /* Ⱦʱ  Time data for rendering */
}NETDEV_PICTURE_DATA_S, *LPNETDEV_PICTURE_DATA_S;

/**
 * @struct tagNETDEVRecordFindCond
 * @brief ¼ѯ
 * @attention  None
 */
typedef struct tagNETDEVRecordFindCond
{
    UINT32 udwChannelID;                    /* ͨ */
    UINT32 udwBegin;                        /* ¼ʼʱ䣬UTCʱʽλ롣пʼʱ䣬ʱ */
    UINT32 udwEnd;                          /* ¼ʱ䣬UTCʱʽλ롣нʱ䣬ʼʱ */
    UINT32 udwTypes;                        /* ѯ¼ BITλ ÿBITλ Ӧһ¼ ҵΪ0λ-31λ  NETDEV_RECORD_TYPE_EX_E*/
    UINT32 udwRelationOfTypes;              /* ¼͹ϵ 0: 1:TypesֶΣֻһ¼ֶͣβ ¼ּϣֶα */
    UINT32 udwPosition;                     /* ¼񲥷ŵλ 1:¼ 2:豸¼ ֶĿǰVMS */
    UINT32 udwSessionID;                    /* һ·طͻһӦĻỰIDֶĿǰVMS */
    UINT32 udwTransType;                    /* 0:ת 1:ֱ */
    BYTE    byRes[256];                     /* ֶ  Reserved */
}NETDEV_RECORD_FIND_COND_S,*LPNETDEV_RECORD_FIND_COND_S;

/**
* Ƶݻصָ  Type of pointer to callback function for decoded video stream data 
* @param [IN] lpPlayHandle      ǰʵž Current live playing handle
* @param [IN] pstPictureData    ŽƵϢָ Pointer to buffer that stores decoded video stream data
* @param [IN] lpUserParam       ûò,ûڵ#NDPlayer_SetDecodeVideoDataCBʱָû User-set parameters, specified by users when they call the #NDPlayer_SetDecodeVideoDataCB function
* @return . None.
* @note
* -     1.ûӦʱƵ,ȷ췵,Ӱ첥ڵý.
* -     1. Users should handle output stream data in a timely manner so that functions can be returned quickly. Otherwise, stream processing in the player will be affected.
* -     2.Ƶyv12ʽ.˳Y0-Y1-......,U0-U1-......,V0-V1-......
* -     2. Video data is in yv12 format in sequence of Y0-Y1-......, U0-U1-......, V0-V1-......
*/
typedef void (STDCALL* NETDEV_DECODE_VIDEO_DATA_CALLBACK_PF)(IN LPVOID lpPlayHandle,
                                                             IN const NETDEV_PICTURE_DATA_S *pstPictureData,
                                                             IN LPVOID lpUserParam);

/**
 * @brief ʱط¼ ṹ嶨 Parameters of play back by time Structure definition
 * @attention  None
 */
typedef struct tagNETDEVPlayBackCondition
{
    INT32   dwChannelID;                /* طŵͨ  Playback channel */
    INT64   tBeginTime;                 /* طſʼʱ  Playback start time */
    INT64   tEndTime;                   /* طŽʱ  Playback end time */
    INT32   dwLinkMode;                 /* Э飬μö#NETDEV_TRANS_PROTOCAL_E */
    LPVOID  hPlayWnd;                   /* Ŵھ  Play window handle */
    INT32   dwFileType;                 /* ¼洢ͣμö#NETDEV_STORE_TYPE_E  */
    INT32   dwDownloadSpeed;            /* ٶ μö#NETDEV_E_DOWNLOAD_SPEED_E  Download speed, see enumeration #NETDEV_E_DOWNLOAD_SPEED_E */
    INT32   dwStreamMode;               /* ģʽμö#NETDEV_STREAM_MODE_E  stream mode see #NETDEV_STREAM_MODE_E */
    INT32   dwStreamIndex;              /* 洢, μö#NETDEV_LIVE_STREAM_INDEX_E */
    INT32   dwRecordLocation;           /* ¼洢λ Record Position, μö#NETDEV_RECORD_LOCATION_E */
    INT32   dwTransType;                /* ͣμö#NETDEV_TRANS_TYPE_E */
    BOOL    bCloudStorage;              /* Ƿƴ洢طģʽ */
    BOOL    bOneFrameEnable;            /* Ƿ֡ģʽԽЧӰ */
    INT32   dwPlaySpeed;                /* طŲٶȣοö#NETDEV_VOD_PLAY_STATUS_E  Playback speed, see enumeration #NETDEV_VOD_PLAY_STATUS_E*/
    NETDEV_DECODE_VIDEO_DATA_CALLBACK_PF cbPlayDecodeVideoCALLBACK;       /* ݻص Decode data callback function */
    INT64   tPlayTime;                  /* ʱ  Playback time */
    UINT32  udwServerID;                /* ¼ID Video server ID */
    BYTE    byRes[212];                 /* ֶ   */
}NETDEV_PLAYBACKCOND_S, *LPNETDEV_PLAYBACKCOND_S;

/**
 * @brief ̨ԤλϢ ṹ嶨 PTZ preset information Structure definition
 * @attention  None
 */
typedef struct tagstNETDEVPtzPreset
{
    INT32   dwPresetID;                                 /* ԤλID  Preset ID */
    CHAR    szPresetName[NETDEV_LEN_32];                /* Ԥλ  Preset name */
}NETDEV_PTZ_PRESET_S, *LPNETDEV_PTZ_PRESET_S;

/**
 * @brief ̨Ԥλ ṹ嶨 All PTZ presets Structure definition
 * @attention  None
 */
typedef struct tagstNETDEVPtzAllPresets
{
    INT32               dwSize;                             /* Ԥλ  Total number of presets */
    NETDEV_PTZ_PRESET_S astPreset[NETDEV_MAX_PRESET_NUM];   /* ԤλϢṹ  Structure of preset information */
}NETDEV_PTZ_ALLPRESETS_S, *LPNETDEV_PTZ_ALLPRESETS_S;

/**
 * @brief ̨ԤλѲ켣Ϣ ṹ嶨 PTZ preset patrol point information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVCruisePoint
{
    INT32   dwPresetID;     /* ԤλID  Preset ID */
    INT32   dwStayTime;     /* ͣʱ  Stay time */
    INT32   dwSpeed;        /* תٶ,Χ[1-10]  Speed [1-10] */
    INT32   dwID;           /* ѲID */
}NETDEV_CRUISE_POINT_S, *LPNETDEV_CRUISE_POINT_S;

/**
 * @brief ̨ԤλѲ·ϸϢ ṹ嶨 PTZ preset patrol route information Structure definition 
 * @attention  None
 */
typedef struct tagNETDEVCruiseInfo
{
    INT32                   dwCuriseID;                                     /* 켣ID  Route ID */
    CHAR                    szCuriseName[NETDEV_LEN_32];                    /* 켣  Route name */
    INT32                   dwSize;                                         /* ·Ĺ켣  Number of presets included in the route */
    NETDEV_CRUISE_POINT_S   astCruisePoint[NETDEV_MAX_CRUISEPOINT_NUM];     /* ·Ĺ켣Ϣ   Information of presets included in the route */
}NETDEV_CRUISE_INFO_S, *LPNETDEV_CRUISE_INFO_S;

/**
 * @brief ̨ԤλѲ·б ṹ嶨 PTZ preset patrol route list Structure definition
 * @attention  None
 */
typedef struct tagNETDEVCruiseList
{
    INT32                   dwSize;                                         /* Ѳ·  Number of patrol routes */
    NETDEV_CRUISE_INFO_S    astCruiseInfo[NETDEV_MAX_CRUISEROUTE_NUM];      /* Ѳ·Ϣ  Information of patrol routes */
}NETDEV_CRUISE_LIST_S, *LPNETDEV_CRUISE_LIST_S;

/**
 * @brief ̨켣Ѳ·Ϣ ṹ嶨 Route information of PTZ route patrol Structure definition
 * @attention  None
 */
typedef struct tagNETDEVPtzTrackinfo
{
    INT32 dwTrackNum;                                               /* ѴڵѲ켣  Number of existing patrol routes */
    CHAR  aszTrackName[NETDEV_TRACK_CRUISE_MAXNUM][NETDEV_LEN_64];  /* 켣  Route name */
}NETDEV_PTZ_TRACK_INFO_S, *LPNETDEV_PTZ_TRACK_INFO_S;

/**
 * @brief ̨켣Ѳ·Ϣ ṹ嶨 Route information of PTZ route patrol Structure definition
 * @attention  None
 */
typedef struct tagNETDEVPtzTrackInfoV30
{
    UINT32 udwTrackID;                                                   /* Ѳ켣ID */
    CHAR   szTrackName[NETDEV_LEN_64];                                   /* 켣  RouteID */
    BYTE   byRes[64];                                                    /* ֶ */
}NETDEV_PTZ_TRACK_INFO_V30_S, *LPNETDEV_PTZ_TRACK_INFO_V30_S;

/**
 * @brief ̨켣Ѳ·Ϣб
 * @attention  None
 */
typedef struct tagNETDEVPtzTrackListV30
{
    INT32 dwTrackNum;                                                           /* ѴڵѲ켣  Number of existing patrol routes */
    NETDEV_PTZ_TRACK_INFO_V30_S astTrackInfo[NETDEV_TRACK_CRUISE_MAXNUM];       /* 켣  RouteID */
}NETDEV_PTZ_TRACK_LIST_V30_S, *LPNETDEV_PTZ_TRACK_LIST_V30_S;

/**
 * @brief ̨״̬ ṹ嶨 PTZ status Structure definition
 * @attention ˮƽǶȶӦϵ01Ӧ0180ȣ-10Ӧ180360  Absolute horizontal coordinates correspond to angles: 0 to 1 correspond to 0 to 180 degrees, and -1 to 0 correspond 180 to 360 degrees 
              ֱǶȶӦϵ01Ӧ090  Absolute vertical coordinates correspond to angles: 0 to 1 correspond to 0 to 90 degrees 
              Ծ۽ʵʱӦϵ01Ӧ0  Absolute multiples correspond to the actual multiples: 0 to 1, correspond to 0 to maximum multiples 
 */
typedef struct tagNETDEVPTZStatus
{
    FLOAT                       fPanTiltX;              /* ˮƽ  Absolute horizontal coordinates*/
    FLOAT                       fPanTiltY;              /* ֱ  Absolute vertical coordinates*/
    FLOAT                       fZoomX;                 /* Ծ۽  Absolute multiples*/
    NETDEV_PTZ_MOVE_STATUS_E    enPanTiltStatus;        /* ̨״̬  PTZ Status*/
    NETDEV_PTZ_MOVE_STATUS_E    enZoomStatus;           /* ۽״̬  Focus Status*/
}NETDEV_PTZ_STATUS_S, *LPNETDEV_PTZ_STATUS_S;

/**
 * @brief ƶ ṹ嶨  Absolute coodinates Structure definition
 * @attention  ˮƽǶȶӦϵ01Ӧ0180ȣ-10Ӧ180360  Absolute horizontal coordinates correspond to angles: 0 to 1 correspond to 0 to 180 degrees, and -1 to 0 correspond 180 to 360 degrees 
               ֱǶȶӦϵ01Ӧ090  Absolute vertical coordinates correspond to angles: 0 to 1 correspond to 0 to 90 degrees 
               Ծ۽ʵʱӦϵ01Ӧ0  Absolute multiples correspond to the actual multiples: 0 to 1, correspond to 0 to maximum multiples 
 */
typedef struct tagNETDEVPTZAbsoluteMove
{
    FLOAT                       fPanTiltX;                          /* ˮƽ Absolute horizontal coordinates*/
    FLOAT                       fPanTiltY;                          /* ֱ Absolute vertical coordinates*/
    FLOAT                       fZoomX;                             /* Ծ۽ Absolute multiples*/
}NETDEV_PTZ_ABSOLUTE_MOVE_S, *LPNETDEV_PTZ_ABSOLUTE_MOVE_S;

/**
 * @brief  ṹ嶨 Rectangle Area  Structure definition
 * @attention  None
 */
typedef struct tagNETDEVRect
{
    INT32   dwLeft;                               /* xֵ[0,10000]  X axis left point value [0,10000] */
    INT32   dwTop;                                /* yᶥֵ[0,10000]  Y axis top point value [0,10000] */
    INT32   dwRight;                              /* xҵֵ[0,10000]  X axis right point value [0,10000] */
    INT32   dwBottom;                             /* y׵ֵ[0,10000]  Y axis bottom point value [0,10000] */
}NETDEV_RECT_S, *LPNETDEV_RECT_S;

/**
 * @brief ͼϢ ṹ嶨 Image area information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVPtzOperateAreaInfo
{
    INT32   dwBeginPointX;      /* ʼXֵ[0,10000]  Area start point X value [0,10000] */
    INT32   dwBeginPointY;      /* ʼYֵ[0,10000]  Area start point Y value [0,10000] */
    INT32   dwEndPointX;        /* Xֵ[0,10000]  Area end point X value [0,10000] */
    INT32   dwEndPointY;        /* Yֵ[0,10000]  Area end point Y value [0,10000] */
}NETDEV_PTZ_OPERATEAREA_S, *LPNETDEV_PTZ_OPERATEAREA_S;


/**
 * @brief ̨Žṹ
 * @attention  None
 */
typedef struct tagNETDEVPTZZoomAreaInfo
{
    UINT32      udwMidPointX;      /* ĺ */
    UINT32      udwMidPointY;      /*  */
    UINT32      udwLengthX;        /* 򳤶 */
    UINT32      udwLengthY;        /*  */
    UINT32      udwWidth;          /* ʵʲŴڳ */
    UINT32      udwHeight;         /* ʵʲŴڿ */
    BYTE        byRes[64];         /* ֶ   */
}NETDEV_PTZ_ZOOM_AREA_INFO_S, *LPNETDEV_PTZ_ZOOM_AREA_INFO_S;


/**
 * @brief ̨켣Ѳ״̬Ϣ
 * @attention  None
 */
typedef struct tagNETDEVPTZTrackStatusInfo
{
    INT32 dwStatus;         /* ͨѲ״̬  μNETDEV_PTZ_TRACK_STATUS_E*/
    INT32 dwPatrolID;       /*¼ƻѲ·*/
}NETDEV_PTZ_TRACK_STATUS_INFO_S, *LPNETDEV_PTZ_TRACK_STATUS_INFO_S;

/**
 * @brief ̨Ϣṹ
 * @attention  None
 */
typedef struct tagNETDEVPTZGuardInfo
{
    BOOL             bEnabled;                          /* ̨ʹ */
    UINT32           udwMode;                           /* ̨ģʽοö NETDEV_PTZ_GUARD_MODE_E */
    UINT32           udwParam;                          /* ,ModeΪ0ʱParamʾԤλţ1ʼ; ModeΪ1ʱParamʾѲ·0ʼ;ModeΪ2ʱParamʾ켣Ѳ·0ʼ */
    UINT32           udwTime;                           /* ʱ䣬̨ĬʱԶλs */
    BYTE             byRes[32];                         /* ֶ */
}NETDEV_PTZ_GUARD_INFO_S, *LPNETDEV_PTZ_GUARD_INFO_S;

/**
 * @enum tagNETDEVPTZDireection
 * @brief ̨λ 
 * @attention  None
 */
typedef enum tagNETDEVPTZDirection
{
    NETDEV_PTZ_DIRECTION_EAST           = 0,            /*  east */
    NETDEV_PTZ_DIRECTION_SOUTHEAST      = 1,            /*  southeast */
    NETDEV_PTZ_DIRECTION_SOUTH          = 2,            /*  south */
    NETDEV_PTZ_DIRECTION_SOUTHWEST      = 3,            /*  southwest */
    NETDEV_PTZ_DIRECTION_WEST           = 4,            /*  west */
    NETDEV_PTZ_DIRECTION_NORTHWEST      = 5,            /*  northwest */
    NETDEV_PTZ_DIRECTION_NORTH          = 6,            /*  north */
    NETDEV_PTZ_DIRECTION_NORTHEAST      = 7,            /*  northeast  */
    NETDEV_PTZ_DIRECTION_AUTO           = 8,            /* Զ auto */

    NETDEV_PTZ_DIRECTION_INVALID        = 0xFFFF        /* Чֵ invalid value */
}NETDEV_PTZ_DIRECTION_E;

/**
 * @struct tagNETDEVPTZOrientationInfo
 * @brief ̨λ궨Ϣ ṹ嶨
 * @attention  
 */
typedef struct tagNETDEVPTZOrientationInfo
{
    INT32   dwDirection;                /* ̨λϢ μöNETDEV_PTZ_DIRECTION_E Direction Info see enumeration #NETDEV_PTZ_DIRECTION_E */
    BYTE    byRes[252];                 /* ֶ  Reserved */

}NETDEV_PTZ_ORIENTATION_INFO_S, *LPNETDEV_PTZ_ORIENTATION_INFO_S;

/**
 * @struct tagNETDEVPTPositionInfo
 * @brief ̨γϢ λ: ȷСλ
 * @attention
 */
typedef struct tagNETDEVPTZPtPositionInfo
{
    FLOAT   fLongitude;                /* ̨ȣ̨ˮƽƶǶȣΧ[0.00, 360.00] */
    FLOAT   fLatitude;                 /* ̨γȣ̨·תǶȣ */
    BYTE    byRes[128];                /* ֶ  Reserved */
}NETDEV_PTZ_PT_POSITION_INFO_S, *LPNETDEV_PTZ_PT_POSITION_INFO_S;

/**
 * @struct tagNETDEVPTZLensAngle
 * @brief ̨ͷǰӳ ṹ嶨
 * @attention  None
 */
typedef struct tagNETDEVPTZLensAngle
{
    FLOAT    fHorizontalAngle;         /* ˮƽӳ ȡֵΧ[0.180] HorizontalAngle */
    FLOAT    fVerticalAngle;           /* ֱӳ ȡֵΧ[0.180] VerticalAnglr */
    BYTE     byRes[256];               /* ֶ  Reserved */
}NETDEV_PTZ_LENSANGLE_S, *LPNETDEV_PTZ_LENSANGLE_S;

/**
* @brief Ƶ
* @attention 
*/
typedef struct tagNETDEVAudioSampleParamType
{
    INT32 dwChannels;                               /* ,Ϊ1,Ϊ2 */
    INT32 dwSampleRate;                             /*  */
    NETDEV_AUDIO_SAMPLE_FORMAT_E enSampleFormat;    /* λ */
}NETDEV_AUDIO_SAMPLE_PARAM_S, *LPNETDEV_AUDIO_SAMPLE_PARAM_S;

/**
 * @brief Ƶ ṹ嶨 Audio data Structure definition
 *        ŽƵݵָͳȵϢ Storing pointer and length of decoded picture data
 * @attention  None
 */
typedef struct tagNETDEVWaveData
{
    CHAR  *pcData;                      /* Ƶָ  Audio data pointer */
    INT32 dwDataLen;                    /* Ƶݳ  Audio data length */
    INT32 dwWaveFormat;                 /* Ƶʽ  Format of decoded audio*/
}NETDEV_WAVE_DATA_S, *LPNETDEV_WAVE_DATA_S;

/**
* @brief ƴ֡ƵݵָͳȵϢĽṹ嶨
* @attention 
*/
typedef struct tagNETDEVParseAudioData
{
    BYTE *pucData;                  /* Ƶָ Audio data pointer */
    UINT32 udwDataLen;              /* Ƶݳ Audio data length */
    UINT32 udwAudioCodeFormat;      /* Ƶʽ,μ#NETDEV_AUDIO_ENCODE_TYPE_E */
    UINT32 udwWaveFormat;           /* ƵݽƵʽ, μ#NETDEV_WAVE_FORMAT_INFO_E */
    INT64 tTimeStamp;               /* ʱ Time stamp (ms)*/
    BYTE  byRes[8];                 /* ֶ  Reserved */
}NETDEV_PARSE_AUDIO_DATA_S, *LPNETDEV_PARSE_AUDIO_DATA_S;

/**
 * @brief Ƶ ṹ嶨 Video analytic data Structure definition
 *        ƴ֡ƵݵָͳȵϢ Storing pointer and length of framed video data
 * @attention  None
 */
typedef struct tagNETDEVParseVideoData
{
    BYTE   *pucData;             /* Ƶָ  Pointer to video data */
    INT32  dwDataLen;            /* Ƶݳ  Video data length */
    INT32  dwVideoFrameType;     /* Ƶ֡,οö#NETDEV_VIDEO_FRAME_TYPE_E  Frame type, see enumeration #NETDEV_VIDEO_FRAME_TYPE_E */
    INT32  dwVideoCodeFormat;    /* Ƶʽ,οö#NETDEV_VIDEO_CODE_TYPE_E  Video encoding format, see enumeration #NETDEV_VIDEO_CODE_TYPE_E  */
    INT32  dwHeight;             /* Ƶͼ߶  Video image height */
    INT32  dwWidth;              /* Ƶͼ  Video image width */
    INT64  tTimeStamp;           /* ʱ룩 Time stamp (ms) */
    INT64  tAbTime;              /* ʱ(unixʱ)ǰط */
}NETDEV_PARSE_VIDEO_DATA_S, *LPNETDEV_PARSE_VIDEO_DATA_S;

/*  */
typedef enum tagNETDEVIVAReportRuleType
{
    NETDEV_IVA_REPORT_RULE_LINE = 0,           /* ιֱߡߣ */
    NETDEV_IVA_REPORT_RULE_POLY,               /* ι򣨶ΡΣ */
    NETDEV_IVA_REPORT_RULE_BUT
}NETDEV_IVA_REPORT_RULE_TYPE_E;

/* 򴥷 */
typedef enum tagNETDEVIVAReportTrigType
{
    NETDEV_IVA_REPORT_TRIG_NONE = 0,           /* ޴ */
    NETDEV_IVA_REPORT_TRIG_BOTH,               /* ˫򴥷 */
    NETDEV_IVA_REPORT_TRIG_CW,                 /* ˳ʱ봥 */
    NETDEV_IVA_REPORT_TRIG_CCW,                /* ʱ봥 */
    NETDEV_IVA_REPORT_TRIG_IN,                 /* 봥 */
    NETDEV_IVA_REPORT_TRIG_OUT,                /* 뿪 */
    NETDEV_IVA_REPORT_TRIG_BUT
}NETDEV_IVA_REPORT_TRIG_TYPE_E;

/* ɫ */
typedef enum tagNETDEVIVAReportColorType
{
    NETDEV_IVA_REPORT_COLOR_NONE = 0,          /* ɫ ͼ */
    NETDEV_IVA_REPORT_COLOR_DEEP,              /* ɫ */
    NETDEV_IVA_REPORT_COLOR_LIGHT,             /* ǳɫ */
    NETDEV_IVA_REPORT_COLOR_WHITE,             /* ɫ */
    NETDEV_IVA_REPORT_COLOR_BLACK,             /* ɫ */
    NETDEV_IVA_REPORT_COLOR_RED,               /* ɫ */
    NETDEV_IVA_REPORT_COLOR_GREEN,             /* ɫ */
    NETDEV_IVA_REPORT_COLOR_BLUE,              /* ɫ */
    NETDEV_IVA_REPORT_COLOR_ORANGE,            /* ɫ */
    NETDEV_IVA_REPORT_COLOR_PURPLE,            /* ɫ */
    NETDEV_IVA_REPORT_COLOR_PINK,              /* ɫ */
    NETDEV_IVA_REPORT_COLOR_YELLOW,            /* ɫ */
    NETDEV_IVA_REPORT_COLOR_BROWN,             /* ɫ */
    NETDEV_IVA_REPORT_COLOR_GRAY,              /* ɫ */
    NETDEV_IVA_REPORT_COLOR_BUT
}NETDEV_IVA_REPORT_COLOR_E;

/* V2汾Ϣͷ */
typedef struct tagNETDEVIVAReportRuleHeadV2S
{
    UINT32      udwChannel;                     /* ͨ */
    BOOL        bEnable;                        /* ʹ״̬ */
    UINT16      uwRuleNum;                      /*  */
    UINT16      uwDisplayHoldTime;              /* ʾʱ ms */
}NETDEV_IVA_REPORT_RULE_HEAD_V2_S, *LPNETDEV_IVA_REPORT_RULE_HEAD_V2_S;

/* V2汾Ϣͷ */
typedef struct tagNETDEVIVAReportResultHeadV2S
{
    UINT32              udwChannel;             /* ͨ */
    BOOL                bEnable;                /* ʹ״̬ */
    UINT16              uwTargetNum;            /* Ŀ */
    UINT16              uwDisplayHoldTime;      /* ʾʱ ms */
}NETDEV_IVA_REPORT_RESULT_HEAD_V2_S, *LPNETDEV_IVA_REPORT_RESULT_HEAD_V2_S;

/* ṹ */
typedef struct tagNETDEVIVAReportCoordInfo
{
    UINT16              uwX;                    /* X  0-10000 ֱ */
    UINT16              uwY;                    /* Y  0-10000 ֱ */
}NETDEV_IVA_REPORT_COORD_S, *LPNETDEV_IVA_REPORT_COORD_S;

/* V2汾Ϣ */
typedef struct tagNETDEVIVAReportRuleInfoV2S
{
    UINT32                          udwRuleID;                              /* ID */
    UINT32                          udwTriggered;                           /* Ƿ񱻴 */
    NETDEV_IVA_REPORT_RULE_TYPE_E   enRuleType;                             /*  */
    NETDEV_IVA_REPORT_TRIG_TYPE_E   enTrigType;                             /* 򴥷 */
    NETDEV_IVA_REPORT_COORD_S       astCoord[NETDEV_IVA_REPORT_COORD_NUM];  /* */
    UINT32                          udwCoordNum;                            /*  */
    NETDEV_IVA_REPORT_COLOR_E       enLineColor;                            /* ɫ */
    NETDEV_IVA_REPORT_COLOR_E       enFillColor;                            /* ɫ */
    UINT32                          udwLineAlpha;                           /* ͸ 0-100 */
    UINT32                          udwFillAlpha;                           /* ͸ 0-100 */
    UINT32                          udwAttachLen;                           /* Ϣ  */
    UINT32                          udwAttachType;                          /* Ϣ  */
}NETDEV_IVA_REPORT_RULE_INFO_V2_S, *LPNETDEV_IVA_REPORT_RULE_INFO_V2_S;

/* V2汾Ϣ չȫṹ */
typedef struct tagNETDEVIVAReportResultInfoV2ExS
{
    UINT32                          udwTargetID;                        /* ĿID*/
    UINT32                          udwlTrigRule;                       /* Ϣ 1bit1 */
    NETDEV_IVA_REPORT_COORD_S       stStart;                            /* Ŀʼ꣬ʼͽ궼Ϊ0,0ʱʾٽ*/
    NETDEV_IVA_REPORT_COORD_S       stEnd;                              /* Ŀ */
    NETDEV_IVA_REPORT_COLOR_E       enLineColor;                        /* ɫ */
    UINT32                          udwLineAlpha;                       /* ͸ 0-100 */ 
    UINT32                          udwTrailHoldTime;                   /* ʷ켣ʾʱ ms */
    UINT32                          udwAttachLen;                       /* Ϣ  */
    UINT32                          udwAttachType;                      /* Ϣ -0x01ȫṹϢ */
    CHAR                            szMsgData[0];                       /* Ϣ- */
}NETDEV_IVA_REPORT_RESULT_INFO_V2_EX_S, *LPNETDEV_IVA_REPORT_RESULT_INFO_V2_EX_S;

/**
 * @brief ƵͨϸϢ ṹ嶨  Structure definition
 * @attention  None
 */
typedef struct tagNETDEVVideoChlDetailInfo
{
    INT32                       dwChannelID;                        /* ͨID  Channel ID */
    BOOL                        bPtzSupported;                      /* Ƿ̨֧ Whether ptz is supported */
    NETDEV_CHANNEL_STATUS_E     enStatus;                           /* ͨ״̬  Channel status NETDEV_CHANNEL_STATUS_E*/
    INT32                       dwStreamNum;                        /*   Number of streams enStatusΪNETDEV_CHL_STATUS_UNBINDʱֵЧ*/
    CHAR                        szChnName[NETDEV_LEN_64];           /* ͨ Channel Name */
    BYTE                        byRes[4];                           /* ֶ  Reserved field*/
}NETDEV_VIDEO_CHL_DETAIL_INFO_S, *LPNETDEV_VIDEO_CHL_DETAIL_INFO_S;

/**
 * @brief ƵͨϸϢչ ṹ嶨  Structure definition
 * @attention  None
 */
typedef struct tagNETDEVVideoChlDetailExtendInfo
{
    UINT32                                      udwIsPoEPort;                                 /* Ƿ֧PoE, 0-, 1- */
    UINT32                                      udwPoEStatus;                                   /* PoE״̬ μ NETDEV_POE_STATUS_E */
    CHAR                                        szAccessAddress[NETDEV_IPADDR_STR_MAX_LEN];     /* 豸ʵַ, Χ[0, 63]NVRҪ */
    CHAR                                        szMACAddress[NETDEV_IPADDR_STR_MAX_LEN];        /* 豸MACַ, ȷΧ[0, 63], NVR֧ */
    CHAR                                        szDDNSAddress[NETDEV_IPADDR_STR_MAX_LEN];       /* DDNSַΧ[0,64] */
    UINT32                                      udwOffReason;                                   /* 豸ԭ μ NETDEV_CHN_OFF_REASON_E */
    UINT32                                      udwRemoteIndex;                                 /* Զͨ(ͨ豸ͨ) */
    CHAR                                        szGBID[NETDEV_LEN_32];                          /* Դ룬Χ[0, 31] */
    UINT32                                      udwAddType;                                     /* ӷʽ, 0-ֶ, 1-弴*/
    UINT32                                      udwOrgID;                                       /* ֯ID, һҪ*/
    UINT32                                      udwDevID;                                       /* 豸ID, һҪ*/
    CHAR                                        szDevName[NETDEV_LEN_64];                       /* 豸ƣΧ[0, 64] һҪ*/
    UINT32                                      udwChlIndex;                                    /* ͨID, һҪ*/
    UINT32                                      udwAudioResID;                                  /* ӦƵͨID, һҪ*/

    BYTE                        byRes[512];                          /* ֶ  Reserved field*/
}NETDEV_VIDEO_CHL_DETAIL_EXTEND_INFO_S, *LPNETDEV_VIDEO_CHL_DETAIL_EXTEND_INFO_S;

/**
 * @brief ƵͨϸϢ ṹ嶨  Structure definition
 * @attention  None
 */
typedef struct tagNETDEVVideoChlDetailInfoEx
{
    INT32                                       dwChannelID;                        /* ͨID  Channel ID */
    BOOL                                        bPtzSupported;                      /* Ƿ̨֧ Whether ptz is supported */
    NETDEV_CHANNEL_STATUS_E                     enStatus;                           /* ͨ״̬  Channel status NETDEV_CHANNEL_STATUS_E */
    INT32                                       dwStreamNum;                        /*   Number of streams enStatusΪNETDEV_CHL_STATUS_UNBINDʱֵЧ*/
    NETDEV_CHANNEL_TYPE_E                       enChannelType;                      /* ͨͣ(note: ֶνԻNVRЧ) */
    NETDEV_VIDEO_STANDARD_E                     enVideoFormat;                      /* ƵʽChannelTypeΪNETDEV_CHL_TYPE_DIGITALʱֵЧ (note: ֶνԻNVRЧ) */
    NETDEV_HOSTTYPE_E                           enAddressType;                      /* IPַ */
    CHAR                                        szIPAddr[NETDEV_IPADDR_STR_MAX_LEN];/* IPַ IP address*/
    INT32                                       dwPort;                             /* ˿ں */
    CHAR                                        szChnName[NETDEV_LEN_64];           /* ͨ Channel Name */
    BOOL                                        allowDistribution;                  /* Ƿַ*/
    INT32                                       dwDeviceType;                       /* ͨ豸ͣμö NETDEV_CHANNEL_CAMERA_TYPE_E. Channel device Type see#NETDEV_CHANNEL_CAMERA_TYPE_E */
    CHAR                                        szManufacturer[NETDEV_LEN_32];      /* ̣Χ[0,31] */
    CHAR                                        szDeviceModel[NETDEV_LEN_32];       /* 豸ͺţΧ[0,31]  */
    UINT32                                      udwAccessProtocol;                  /* Э,ONVIFЭ:1 ,˽Э:2, :3 ,ԶЭ:ʹԶЭ, ҪʹNETDEV_GetDevConfig/NETDEV_SetDevConfigͻȡԶЭϢ  */
    LPNETDEV_VIDEO_CHL_DETAIL_EXTEND_INFO_S     pstExtendedInformation ;            /* , Ҫڴ*/

    BYTE                        byRes[16];                          /* ֶ  Reserved field*/
}NETDEV_VIDEO_CHL_DETAIL_INFO_EX_S, *LPNETDEV_VIDEO_CHL_DETAIL_INFO_EX_S;


/**
* @brief ƵԴֱϢ Video resolution
* @attention 
*/
typedef struct tagNETDEVVideoResolution
{
    INT32 dwWidth;
    INT32 dwHeight;
}NETDEV_VIDEO_RESOLUTION_S, *LPNETDEV_VIDEO_RESOLUTION_S;


/**
* @brief ȡֵΧ Range
* @attention 
*/
typedef struct tagNETDEVRange
{
    INT32   dwMin;
    INT32   dwMax;
}NETDEV_RANGE_S, *LPNETDEV_RANGE_S;

/**
* @brief Ƶѡ Video encode option
* @attention 
*/
typedef struct tagNETDEVVideoEncodeOption
{
    INT32                       dwEncodeType;                                       /* ʽ NETDEV_VIDEO_CODE_TYPE_E*/
    INT32                       dwResolutionSize;                                   /* ֱ Resolution size */
    NETDEV_VIDEO_RESOLUTION_S   astResolution[NETDEV_RESOLUTION_NUM_MAX];           /* ֱ Resolution */
    NETDEV_RANGE_S              stIFrameInterval;                                   /* I֡ I frame interval */
    NETDEV_RANGE_S              stFrameRate;                                        /* ֡ Frame rate */
    NETDEV_RANGE_S              stEncodingInterval;                                 /*  Encode interval */
    NETDEV_RANGE_S              stBitRate;                                          /*  Bit rate */
}NETDEV_VIDEO_ENCODE_OPTION_S, *LPNETDEV_VIDEO_ENCODE_OPTION_S;

/**
* @brief Ƶ Video stream Cap
* @attention 
*/
typedef struct tagNETDEVVideoStreamCap
{
    INT32                           dwStreamType;                                   /*   μ NETDEV_LIVE_STREAM_INDEX_E */
    INT32                           dwEncodeCapSize;                                /*  Encode capability size */
    NETDEV_VIDEO_ENCODE_OPTION_S    astEncodeCap[NETDEV_VIDEO_ENCODE_TYPE_MAX];     /*  Encode capability */
    NETDEV_RANGE_S                  stQuality;                                      /* ͼΧ Quality range */
}NETDEV_VIDEO_STREAM_CAP_S, *LPNETDEV_VIDEO_STREAM_CAP_S;

/**
 * @brief ־ѯ ṹ嶨 Log query condition Structure definition
 * @attention  None
 */
typedef struct tagNETDEVFindLogCond
{
    INT32      dwMainType;         /* ־, ο#NETDEV_LOG_MAIN_TYPE_E Log type. See #NETDEV_LOG_MAIN_TYPE_E for reference */
    INT32      dwSubType;          /* ־, ο#NETDEV_LOG_SUB_TYPE_E Sub type. See #NETDEV_LOG_SUB_TYPE_E for reference */
    INT64      tBeginTime;         /* ʼʱ  Start time */
    INT64      tEndTime;           /* ʱ  End time */
    INT32      dwLimitNum;         /* ÿβѯ Number of each query*/
    INT32      dwOffset;           /* żʼѯŴ0ʼ Start search from No. X. X starts from 0*/
}NETDEV_FIND_LOG_COND_S, *LPNETDEV_FIND_LOG_COND_S;

/**
* @brief ־Ϣ ṹ嶨 Definition of log info structure
* @attention 
*/
typedef struct tagNETDEVOptLogInfo
{
    INT64       tTime;                                  /* ־ʱ Log time*/
    INT32       dwMainType;                             /* ־, ο #NETDEV_LOG_MAIN_TYPE_E Main Type.See #NETDEV_LOG_MAIN_TYPE_E for reference*/
    INT32       dwSubType;                              /* ־, ο #NETDEV_LOG_SUB_TYPE_E Sub Type.See #NETDEV_LOG_SUB_TYPE_E for reference*/
    INT32       dwChannelID;                            /* ־Դ Log source*/
    CHAR        szUserName[NETDEV_NAME_MAX_LEN];        /* û Username*/
    CHAR        szUserAddr[NETDEV_IPADDR_STR_MAX_LEN];  /* ûIPַ User IP address*/
    CHAR        szDetailInfo[NETDEV_LEN_256];           /* ϸϢ[1,64] NVR֧ Detail info[1,64] NVR Only */
    CHAR        szOperObject[NETDEV_LEN_256];           /* [1,64] VMS֧ Opera object[1,64] VMS Only */
    UINT32      udwOperResult;                          /*  VMS֧ Opera result VMS Only */
    CHAR        szDevName[NETDEV_LEN_256];              /* 豸[1,64] Device name of operation[1,64] VMS Only*/
    CHAR        szOrgName[NETDEV_LEN_256];              /* ֯[1,64] Org Name of operation[1,64] VMS Only */
    BYTE        bRes[256];                              /* ֶ Reserved */
}NETDEV_LOG_INFO_S,*LPNETDEV_LOG_INFO_S;

/***************** 澯ҵ  Alarm services**************************************************/
/**
 * @brief 澯Ϣ ṹ嶨 Alarm information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVAlarmInfo
{
    INT32   dwAlarmType;                    /* 澯,μö# NETDEV_ALARM_TYPE_E  Alarm type, see enumeration #NETDEV_ALARM_TYPE_E */
    INT64   tAlarmTime;                     /* 澯ʱ  Alarm time */
    INT32   dwChannelID;                    /* ͨ,NVR  Channel ID for NVR */
    UINT16  wIndex;                         /*   Index number,  index number */
    CHAR    *pszName;                       /* 澯Դ, Alarm source name, alarm input/output name */
    INT32   dwTotalBandWidth;               /* ǰ,λΪMBps  Current total bandwidth (in MBps) */
    INT32   dwUnusedBandwidth;              /* δʹõĴ,λΪMBps  Bandwidth left (in MBps)*/
    INT32   dwTotalStreamNum;               /* · Total cameras*/
    INT32   dwFreeStreamNum;                /* δʹ· Cameras left */
    INT32   dwMediaMode;                    /* ,μö#NETDEV_MEDIA_MODE_E Stream type. For enumerations, see#NETDEV_MEDIA_MODE_E*/
    INT32   dwReserved;                     /* 쳣ϱϱ㱣 */
    INT32   dwEventCode;                    /* ¼ͣϱ¼ͣμö#NETDEV_PLAYER_RUN_INFO_TYPE_E */
    BYTE    byRes[2];                       /* ֶ  Reserved */
}NETDEV_ALARM_INFO_S, *LPNETDEV_ALARM_INFO_S;

/**
 * @brief 澯Ϣ ṹ嶨 Alarm subscribe information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVAlarmSubscribeInfo
{
    INT32   dwAlarmType;                    /* ĵĸ澯 μ NETDEV_SUBSCRIBE_ALARM_TYPE_E ʹû */
    BYTE    byRes[44];                      /* ֶ  Reserved */
}NETDEV_ALARM_SUB_INFO_S, *LPNETDEV_ALARM_SUB_INFO_S;

/**
 * @brief  澯Ϣ ṹ嶨 Get alarm information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVPullAlarmInfo
{
    NETDEV_ALARM_TYPE_E   enAlarm;         /* 澯  Alarm type */
    INT32   dwChancelId;                   /* ͨ,NVR  Channel ID for NVR */
}NETDEV_PULLALARM_INFO_S, *LPNETDEV_PULLALARM_INFO_S;

/********************** ͳ Passenger flow statistic **************************/
/**
 * @brief  ͳϢ ṹ嶨 Passenger flow statistic infomation Sturcture definition
 * @attention  None
 */
typedef struct tagNETDEVPassengerFlowStatisticData
{
    INT32   dwChannelID;            /* ͨ Channel ID */
    INT64   tReportTime;            /* ϱʱ䣨unixʱ Report time */
    INT32   tInterval;              /* ʱ Interval time */
    INT32   dwEnterNum;             /*  Enter num */
    INT32   dwExitNum;              /* 뿪 Exit num */
    INT32   dwTotalEnterNum;        /* н Total enter num */
    INT32   dwTotalExitNum;         /* 뿪 Total exit num */
}NETDEV_PASSENGER_FLOW_STATISTIC_DATA_S, *LPNETDEV_PASSENGER_FLOW_STATISTIC_DATA_S;


/**
 * @brief ӼsocketϢ
 * @attention
 */
typedef struct tagNETDEVTmsConnectInfo
{ 
    UINT32   udwPktVer;          /* İ汾 */ 
    UINT32   udwTmsProtoCmd;     /* TmsЭ */
    CHAR     *pcRecvBuf;         /* socketݻ */
    UINT32   udwBufMaxLen;       /* RecvBufܳ */
    UINT32   udwPktTotalLen;     /* ͨЭݰܳȣͬͷͬβ */
    BOOL     bHdrParsed;         /* ͷɱ־ */
    BYTE     bRes[32];           /* ֶ Reserved */
}NETDEV_TMS_CONNECT_INFO_S, *LPNETDEV_TMS_CONNECT_INFO_S;

/**
 * @brief ԱϢ
 * @attention
 */
typedef  struct tagNETDEVTMSPersonInfo
{
    UINT32 udwFaceId;                                      /* IDΪ0ʾxmlӦԪ */
    CHAR   szCamerID[NETDEV_TMS_CAMER_ID_LEN];             /*  */
    CHAR   szRecordID[NETDEV_TMS_FACE_RECORD_ID_LEN];      /* ¼ID */
    CHAR   szTollgateID[NETDEV_TMS_FACE_TOLLGATE_ID_LEN];  /* ڱ */
    CHAR   szPassTime[NETDEV_TMS_PASSTIME_LEN];            /* ʱ */
    BOOL   bFinishFlag;                                    /* ɱ־ */
    BYTE   bRes[128];                                      /* ֶ Reserved */

}NETDEV_TMS_PERSION_INFO_S, *LPNETDEV_TMS_PERSION_INFO_S;

/**
 * @brief λϢ
 * @attention
 */
typedef struct tagNETDEVFacePositionInfo
{
    INT32   dwTopLeftX;           /* ϽX [0, 10000]  Upper left corner X [0, 10000]  */
    INT32   dwTopLeftY;           /* ϽY [0, 10000]  Upper left corner Y [0, 10000]  */
    INT32   dwBottomRightX;       /* ½X [0, 10000]  Lower right corner x [0, 10000] */
    INT32   dwBottomRightY;       /* ½Y [0, 10000]  Lower right corner y [0, 10000] */
    BYTE     bRes[32];           /* ֶ Reserved */
}NETDEV_FACE_POSITION_INFO_S, *LPNETDEV_FACE_POSITION_INFO_S;

/**
 * @brief СͼϢ
 * @attention
 */
typedef struct tagNETDEVTMSPersionFaceInfo
{ 
    UINT32 udwFaceId;                                /* ID */
    NETDEV_FACE_POSITION_INFO_S stFacePos;           /* ---һ0-10000 ;  Ϻµ㣺"138,315,282,684" */
    BYTE   bRes[64];                                 /* ֶ Reserved */

}NETDEV_TMS_PERSION_FACE_INFO_S, *LPNETDEV_TMS_PERSION_FACE_INFO_S;

/**
 * @brief ͼƬϸ
 * @attention
 */
typedef struct tagNETDEVTMSPersionPicInfo
{
    UINT32                              udwFaceId;                                  /* ID(Faceڵ) Ϊ0 */
    UINT32                              udwPiclen;                                  /* ϢͼƬ */
    CHAR                                szPassTime[NETDEV_TMS_PASSTIME_LEN];        /* ʱ */
    NETDEV_TMS_PERSION_FACE_INFO_S      stFaceInfo;                                 /* СͼϢ */
    NETDEV_TMS_PERSION_IMAGE_TYPE_E     enImgType;                                  /* ͼ */
    NETDEV_TMS_PERSION_IMAGE_FORMAT_E   enImgFormat;                                /* ͼʽ */
    UINT32                              udwImageWidth;                              /* ͼ*/
    UINT32 udwImageHeight;                                                          /* ͼ߶*/ 
    UINT32 udwFaceNum;                                   /*  ȫͼʱЧ*/
    BYTE   bRes[252];                                                               /* ֶ Reserved*/
}NETDEV_TMS_PERSION_PIC_INFO_S, *LPNETDEV_TMS_PERSION_PIC_INFO_S;

/**
 * @brief ʶϢ
 * @attention
 */
typedef struct tagNETDEVTMSFaceParseInfo
{ 
    UINT32                          udwFaceNum;                 /*  */
    UINT32                          udwImageNum;                /* pstTMSPersonPicInfo ĸ */
    CHAR                            *pcPktPicDataPtr;           /* ͼƬʼָ */
    NETDEV_TMS_PERSION_INFO_S       stTMSPersonInfo;            /* ԱϢ */
    LPNETDEV_TMS_PERSION_PIC_INFO_S pstTMSPersonPicInfo;        /* ͼƬϸ */
    BYTE                            bRes[64];                   /* ֶ Reserved */
}NETDEV_TMS_FACE_PARSE_INFO_S, *LPNETDEV_TMS_FACE_XML_INFO_S;

/**
 * @brief ȶͼXMLϢ
 * @attention
 */
typedef struct tagNETDEVTMSHeatMapXmlInfo
{
    CHAR  szDevID[NETDEV_TMS_HEAT_MAP_DEVID_LEN];                           /* 豸 */
    CHAR  szRecordID[NETDEV_TMS_HEAT_MAP_RECORD_ID_LEN];                    /* ¼ID */
    CHAR  szCollectTime[NETDEV_TMS_HEAT_MAP_COllECT_TIME_LEN];              /* ɼʱ */
    INT32 dwColumns;                                                        /*  */
    INT32 dwRows;                                                           /*  */
    INT32 dwIntervalTime;                                                   /*  λmin*/
    CHAR  szIPAddr[NETDEV_IPV4_LEN_MAX];                                    /* 豸IPַ */
    BYTE  bRes[240];                                                        /* ֶ Reserved */
}NETDEV_TMS_HEAT_MAP_XML_INFO_S, *LPNETDEV_TMS_HEAT_MAP_XML_INFO_S;

/**
 * @brief ȶͼϢ
 * @attention
 */
typedef struct tagNETDEVTMSHeatMapPicInfo
{
    UINT32  udwPicSize;                                                     /* С */
    CHAR    *pcPicData;                                                     /*  */
}NETDEV_TMS_HEAT_MAP_PIC_INFO_S,*LPNETDEV_TMS_HEAT_MAP_PIC_INFO_S;

/**
 * @brief ȶͼϢ
 * @attention
 */
typedef struct tagNETDEVTMSHeatMapInfo
{
    UINT32                            udwPicNum;                                /*  Picture Number */
    NETDEV_TMS_HEAT_MAP_XML_INFO_S    stTmsXmlInfo;                             /* XMLϢ XML Information */
    NETDEV_TMS_HEAT_MAP_PIC_INFO_S    stTmsPicInfo[NETDEV_TMS_PIC_COMMON_NUM];  /* Ϣ Picture Message */
}NETDEV_TMS_HEAT_MAP_INFO_S,*LPNETDEV_TMS_HEAT_MAP_INFO_S;

/**
 * @brief ʶXMLϢ
 * @attention
 */
typedef struct tagNETDEVTMSCarPlateXmlInfo
{
    CHAR szCamID[NETDEV_TMS_CAR_PLATE_CAMID_LEN];                               /*  */
    CHAR szRecordID[NETDEV_TMS_CAR_PLATE_RECORDID_LEN];                         /* ¼ID */
    CHAR szTollgateID[NETDEV_TMS_CAR_PLATE_TOLLGATE_LEN];                       /* ڱ */
    CHAR szPassTime[NETDEV_TMS_CAR_PLATE_PASSTIME_LEN];                         /* ʱ */
    CHAR szLaneID[NETDEV_TMS_CAR_PLATE_LANEID_LEN];                             /*  */
    CHAR szCarPlate[NETDEV_TMS_CAR_PLATE_CARPLATE_LEN];                         /* ƺ */
    CHAR szIPAddr[NETDEV_IPV4_LEN_MAX];                                         /* 豸IPַ */
    BYTE bRes[496];                                                             /* ֶ Reserved */

}NETDEV_TMS_CAR_PLATE_XML_INFO_S, *LPNETDEV_TMS_CAR_PLATE_XML_INFO_S;

/**
 * @brief ʶͼƬϢ
 * @attention
 */
typedef struct tagNETDEVTMSCarPlatePicInfo
{
    UINT32  udwPicSize;                                                      /* ͼƬС */
    CHAR    *pcPicData;                                                      /* ͼƬ */
}NETDEV_TMS_CAR_PLATE_PIC_INFO_S,*LPNETDEV_TMS_CAR_PLATE_PIC_INFO_S;

/**
 * @brief ʶϢ
 * @attention
 */
typedef struct tagNETDEVTMSCarPlateInfo
{
    UINT32                             udwPicNum;                                   /* ͼƬ Picture Number */
    NETDEV_TMS_CAR_PLATE_XML_INFO_S    stTmsXmlInfo;                                /* XMLϢ XML Information */
    NETDEV_TMS_CAR_PLATE_PIC_INFO_S    stTmsPicInfo[NETDEV_TMS_PIC_COMMON_NUM];     /* ͼƬϢ Picture Message */
}NETDEV_TMS_CAR_PLATE_INFO_S,*LPNETDEV_TMS_CAR_PLATE_INFO_S;

/**
 * @brief ץϢṹ壨ϱã
 * @attention
 */
typedef struct tagNETDEVTMSFaceSnapshotPicInfo
{
    UINT32   udwFaceId;                                      /* ID */
    CHAR    *pcPicBuff;                                      /* ͼƬ */
    UINT32   udwPicBuffLen;                                  /* ͼƬ泤 */
    NETDEV_TMS_PERSION_IMAGE_TYPE_E    enImgType;            /* ͼͣοöNETDEV_TMS_PERSION_IMAGE_TYPE_E */
    NETDEV_TMS_PERSION_IMAGE_FORMAT_E  enImgFormat;          /* ͼʽοöNETDEV_TMS_PERSION_IMAGE_FORMAT_E */
    NETDEV_FACE_POSITION_INFO_S        stFacePos;            /* ---һ0-10000 ;  Ϻµ㣺"138,315,282,684" */
    UINT32   udwImageWidth;                                  /* ͼ */
    UINT32   udwImageHeight;                                 /* ͼ߶ */
    CHAR     szCamerID[NETDEV_TMS_CAMER_ID_LEN];             /*  */
    CHAR     szRecordID[NETDEV_TMS_FACE_RECORD_ID_LEN];      /* ¼ID */
    CHAR     szTollgateID[NETDEV_TMS_FACE_TOLLGATE_ID_LEN];  /* ڱ */
    CHAR     szPassTime[NETDEV_TMS_PASSTIME_LEN];            /* ʱ,YYYYMMDDHHMMSSMMMʱ䰴24СʱơһMMʾ£ڶMMʾ֣MMMʾ */
    UINT32   udwFaceNum;                                     /*  ȫͼʱЧ*/
    CHAR     szIPAddr[NETDEV_IPV4_LEN_MAX];                  /* 豸IPַ */
    BYTE     bRes[76];                                       /* ֶ Reserved */
}NETDEV_TMS_FACE_SNAPSHOT_PIC_INFO_S, *LPNETDEV_TMS_FACE_SNAPSHOT_PIC_INFO_S;


/**
 * @brief ӳٿػϢ
 * @attention
 */
typedef struct tagNETDEVXWDelaySwitchPower
{
    UINT32            udwOperateType;                    /* ʽ 0:ӳٿݲʵ֣   1:ӳٹػ*/
    UINT32            udwDelayTime;                      /* ӳٹػʱ λ:min   Χ1~720*/

    BYTE              bRes[128];                         /* Ԥֶ */
}NETDEV_XW_DELAY_SWITCH_POWER_S, *LPNETDEV_XW_DELAY_SWITCH_POWER_S;

/**
 * @brief ʱػϢ
 * @attention
 */
typedef struct tagNETDEVXWTimingSwitchPower
{
    CHAR            szTVWallCode[NETDEV_LEN_64];         /* ǽ루ѡֶΣ豸˷䣬ַȷΧ[1,64]*/
    BOOL            bPowerOnEnabled;                     /* ʹܣǷʱܣ0:ʹ 1:ʹ*/
    BOOL            bPowerOffEnabled;                    /* ʹܣǷʱػܣ0:ʹ 1:ʹ*/
    CHAR            szPowerOnTime[NETDEV_LEN_16];        /* ʱʽHH:MM:SSСʱ:: )*/
    CHAR            szPowerOffTime[NETDEV_LEN_16];       /* ʱʽHH:MM:SSСʱ:: )*/

    BYTE            bRes[64];                           /* Ԥֶ */
}NETDEV_XW_TIMING_SWITCH_POWER_S, *LPNETDEV_XW_TIMING_SWITCH_POWER_S;

/**
 * @brief ֶػϢ
 * @attention
 */
typedef struct tagNETDEVXWManualSwitchPower
{
    CHAR              szTVWallCode[NETDEV_LEN_64];       /* ǽ루ѡֶΣ豸˷䣬ַȷΧ[1,64] */
    UINT32            udwOperateType;                    /* ʽ 0:   1:ػ*/

    BYTE               bRes[64];                        /* Ԥֶ */
}NETDEV_XW_MANUAL_SWITCH_POWER_S, *LPNETDEV_XW_MANUAL_SWITCH_POWER_S;

/**
 * @brief ƴƲϢ
 * @attention
 */
typedef struct tagNETDEVXWScreenCtrlParamInfo
{
    CHAR        szTVWallCode[NETDEV_LEN_64];              /* ǽ루ѡֶΣ豸˷䣬ַȷΧ[1,64] */
    UINT32      udwCtrlType;                              /* Ʒʽ,μ NETDEV_XW_SCREEN_CTRL_TYPE_S */
    UINT32      udwAddressType;                           /* IPַ,μNETDEV_ADDR_TYPE_E  CtrlTypeΪ01ʱýڵѡ*/
    CHAR        szIPV4Address[NETDEV_IPADDR_STR_MAX_LEN];             /* IPV4ַ ƷʽΪTCPUDPIPַΪIPv4ʱýڵѡ*/
    CHAR        szIPV6Address[NETDEV_IPADDR_STR_MAX_LEN];             /* IPV6ַ ƷʽΪTCPUDPIPַΪIPv6ʱýڵѡ*/
    CHAR        szDomainAddress[NETDEV_DOMAIN_LEN];       /*  ƷʽΪTCPUDPIPַΪʱýڵѡ*/
    UINT32      udwPort;                                  /* ˿ ƷʽΪTCPUDPʱýڵѡ*/
    UINT32      udwComID;                                 /* ID ƷʽΪʱýڵѡ*/
    UINT32      udwProtocolType;                          /* Э μNETDEV_XW_SCREEN_CTRL_PROTOCOL_TYPE_S*/
    BYTE        bRes[192];                                /* Ԥֶ */
}NETDEV_XW_SCREEN_CTRL_PARAM_INFO_S, *LPNETDEV_XW_SCREEN_CTRL_PARAM_INFO_S;


/**
 * @brief ĻŴϢ
 * @attention
 */
typedef struct tagNETDEVXWScreenZoomInfo
{
    UINT32            uOperatedType;                    /* Ļ,μNETDEV_XW_SCREEN_ZOOM_TYPE_E */
    UINT32            uOperatedMode;                    /* Ļģʽ,μNETDEV_XW_SCREEN_ZOOM_MODE_E */
    UINT32            uSplitScreenIndex;                /* ҪŴȫķ,uOperatedType0 & uOperatedMode=1ʱЧ */
}NETDEV_XW_SCREEN_ZOOM_INFO_S, *LPNETDEV_XW_SCREEN_ZOOM_INFO_S;

/**
 * @brief Ϣ
 * @attention
 */
typedef struct tagNETDEVXWArea
{
    UINT32  udwX;       /* X */
    UINT32  udwY;       /* Y */
}NETDEV_XW_COORD_S, *LPNETDEV_XW_COORD_S;

/**
 * @brief ڵǽλϢ
 * @attention
 */
typedef struct tagNETDEVXWVirtualLEDArea
{
    NETDEV_XW_COORD_S   stTopLeft;          /* Ͻǵ */
    NETDEV_XW_COORD_S   stBottomRight;      /* ½ǵ */
}NETDEV_XW_AREA_S, *LPNETDEV_XW_AREA_S;

/**
 * @brief ֱϢ
 * @attention
 */
typedef struct tagNETDEVXWVideoResolution
{
    UINT32  udwWidth;       /*  */
    UINT32  udwHeight;      /*  */
}NETDEV_XW_RESOLUTION_S, *LPNETDEV_XW_RESOLUTION_S;

/**
 * @brief "XW"豸ǽ
 * @attention
 */
typedef struct tagNETDEVXWTVWallCap
{
    UINT32      udwNumMax;              /* ǽ */
    UINT32      udwSceneMax;            /* ǽ󳡾 */
    UINT32      udwRowMax;              /* ǽ */
    UINT32      udwColumnMax;           /* ǽ */
    UINT32      udwScenesPlanMax;       /* ǽ󳡾ƻ */
    BYTE        byRes[60];              /* ֶ */
}NETDEV_XW_TVWALL_CAP_S, *LPNETDEV_XW_TVWALL_CAP_S;

/**
 * @brief ֵ֧Ƶʽб
 * @attention
 */
typedef struct tagNETDEVXWFormatList
{
    UINT32      udwSize;                                    /* ֵ֧Ƶʽ */
    UINT32      adwFormatList[NETDEV_VIDEO_FORMAT_MAX];     /* ֵ֧Ƶʽ NETDEV_VIDEO_FORMAT_E */
    BYTE        byRes[64];                                  /* ֶ */
}NETDEV_XW_FORMAT_LIST_S, *LPNETDEV_XW_FORMAT_LIST_S;

/**
 * @brief "XW"豸
 * @attention
 */
typedef struct tagNETDEVXWWndCap
{
    UINT32                  udwWndMaxPerScene;      /* 󴰿 */
    UINT32                  udwAreaMax;             /* ڵĴ */
    UINT32                  udwPaneMax;             /* ڵ */
    NETDEV_XW_RESOLUTION_S  stResolutionMin;        /* Сڵ */
    BYTE                    byRes[64];              /* ֶ */
}NETDEV_XW_Wnd_CAP_S, *LPNETDEV_XW_Wnd_CAP_S;

/**
 * @brief "XW"豸ͼ
 * @attention
 */
typedef struct tagNETDEVXWBaseMapCap
{
    UINT32                      udwNumMax;              /* "ADU"豸ͼ */
    UINT32                      udwNumMaxPerScene;      /* ͼ */
    UINT32                      udwBytesMax;            /* ŵͼֽ */
    NETDEV_XW_RESOLUTION_S      stResolutionMax;        /* ͼֱ */
    BYTE                        byRes[64];              /* ֶ */
}NETDEV_XW_BASEMAP_CAP_S, *LPNETDEV_XW_BASEMAP_CAP_S;

/**
 * @brief "XW"豸LED
 * @attention
 */
typedef struct tagNETDEVXWVirtualLEDCap
{
    UINT32  udwNumMaxPerScene;           /* LED */
    UINT32  udwRowMax;                   /* LED */
    UINT32  udwCharMaxPerRow;            /* ֵ */
    UINT32  udwRollingNumPerSceneMax;    /* LED */
    UINT32  udwTextHightMax;             /* ֵָ */
    UINT32  udwGapMax;                   /* Ӧ */
    UINT32  udwCharsMax;                 /* ַ */
    UINT32  udwSupVirtualLEDDifColors;   /* ֧LEDʾͬɫ 0֧ 1֧ */
    BYTE    byRes[44];                   /* ֶ */
}NETDEV_XW_VIRTUALLED_CAP_S, *LPNETDEV_XW_VIRTUALLED_CAP_S;

/**
 * @brief "XW"豸Ѳ
 * @attention
 */
typedef struct tagNETDEVXWSequenceCap
{
    UINT32  udwSrcNumMax;                /* ѵԴ */
    UINT32  udwPaneNumMax;               /* Ѳ */
    UINT32  udwWndNumMax;                /* Ѳ */
    UINT32  udwSceneNumMax;              /* Ѳ */

    UINT32  udwVideoSourceMax;           /* ѲԴص */
    UINT32  udwSeqResourceInSceneMax;    /* ѲԴ */
    BYTE    byRes[56];                   /* ֶ */
}NETDEV_XW_SEQUENCE_CAP_S, *LPNETDEV_XW_SEQUENCE_CAP_S;

/**
 * @brief "XW"ֵ֧ķ
 * @attention
 */
typedef struct tagNETDEVXWPaneType
{
    UINT32                          udwSize;                     /* ֵ֧ķ */
    UINT32                          *pudwPaneType;               /* ֵ֧ķ NETDEV_XW_LAYOUT_NUM_E */
}NETDEV_XW_PANE_TYPE_S, *LPNETDEV_XW_PANE_TYPE_S;

/**
 * @brief ԴͣԿ豸ԴҪֶΣ
 * @attention
 */
typedef enum tagNETDEVXWManageType
{
    NETDEV_XW_MANAGE_TYPE_OTHER = 0,                                /*  */
    NETDEV_XW_MANAGE_TYPE_XWARE = 1,                                /* Կ豸 */

    NETDEV_XW_MANAGE_TYPE_INVALID = 0XFF                            /* Чֵ invalid */
    
}NETDEV_XW_MANAGE_TYPE_E;

/**
 * @brief "XW"豸
 * @attention
 */
typedef struct tagNETDEVXWSupportCap
{
    UINT32                  udwPane;                      /*  NETDEV_PANE_CAP_E*/
    UINT32                  udwWndRoaming;                /*  NETDEV_ROAMING_CAP_E*/
    UINT32                  udwWnd;                       /*  NETDEV_XW_WND_CAP_E*/        
    BOOL                    bBackToShow;                  /*  0:֧ 1:֧ */
    BOOL                    bWndOverlay;                  /* ڵ 0:֧ 1:֧ */
    BOOL                    bTopWndSetTransp;             /* 㴰͸ 0:֧ 1:֧ */
    UINT32                  udwMaxWinNumPerScreen;        /* ֵ֧󴰿 */
    NETDEV_XW_PANE_TYPE_S   stPaneType;                   /* ֵ֧ķ */
    UINT32                  udwMaxEncodeDevicesNum;       /* 豸 */
    UINT32                  udwMaxVideoSourceNum;         /* ͨ */
    UINT32                  udwSupportWindowTypeNum;      /* ֵ֧Ŀģʽ */
    UINT32                  *paudwWindowType;             /* Ŀģʽö οöٶ#NETDEV_XW_LAYOUT_NUM_E ,ֵ֧Ŀģʽ̬ڴ*/
    BOOL                    bAutoSelectSignalSrc;         /* ԶѡźԴ 0:֧ 1:֧ */
    BYTE                    byRes[44];                    /* ֶ */
}NETDEV_XW_SUPPORT_CAP_S, *LPNETDEV_XW_SUPPORT_CAP_S;

/**
 * @brief "XW"豸չƵʽ
 * @attention
 */
typedef struct tagNETDEVXWFormatListEx
{
    UINT32      udwVideoOutID;                             /*ƵͨID,ƵͨڵΨһʶͨȡ豸Դӿڻȡʹǽͨӿ·VideoOutIDһ¡*/
    UINT32      udwFormatNum;                              /* Ƶֵ֧ͨƵʽ */
    UINT32      adwFormatList[NETDEV_VIDEO_FORMAT_MAX];    /* ֵ֧Ƶʽ NETDEV_VIDEO_FORMAT_E */

    BYTE        byRes[64];                                  /* ֶ */
}NETDEV_XW_FORMAT_EX_LIST_S, *LPNETDEV_XW_FORMAT_EX_LIST_S;

/**
 * @brief "XW"豸
 * @attention
 */
typedef struct tagNETDEVXWCAPINFO
{
    NETDEV_XW_TVWALL_CAP_S          stTVWall;               /* ǽ */
    NETDEV_XW_FORMAT_LIST_S         stVideoFormats;         /* Ƶʽб */
    NETDEV_XW_Wnd_CAP_S             stWnd;                  /*  */
    NETDEV_XW_BASEMAP_CAP_S         stBaseMap;              /* ͼ */
    NETDEV_XW_VIRTUALLED_CAP_S      stVirtualLED;           /* LED */
    NETDEV_XW_SEQUENCE_CAP_S        stSequence;             /* Ѳ */
    NETDEV_XW_SUPPORT_CAP_S         stSupport;              /*  */
    BOOL                            bIsRSASupported;        /* ǷʹRSA */
    BOOL                            bIsDevMgrSupported;     /* Ƿֹ֧豸 */
    BOOL                            bIsDecodeSupported;     /* Ƿֽ֧ */
    BOOL                            bIsChromaCalSupported;  /* Ƿ֧ɫУ */
    UINT32                          udwSuggestVideoFormat;  /* Ƽֱ μ#NETDEV_VIDEO_FORMAT_E*/
    UINT32                          udwSupportExVideoFormatNum;/* ֵ֧չƵʽ */
    LPNETDEV_XW_FORMAT_EX_LIST_S    pstVideoFormatsEx;      /* ֵ֧չƵʽб ,udwSupportExVideoFormatNum̬ڴ*/
    UINT32                          udwBatchCapabilities;   /* Bitλ Bit1:ش Bit2: Bit3: Bit4: */
    BOOL                            bIsOrderNOSupported;    /* Ƿֿ֧ */
    BYTE                            byRes[32];              /* ֶ */
}NETDEV_XW_CAP_INFO_S, *LPNETDEV_XW_CAP_INFO_S;

/**
 * @brief ǽĻ
 * @attention
 */
typedef struct tagNETDEVTVWallScreen
{
    UINT32                          udwRowNum;                          /* ǽеԪ */
    UINT32                          udwColNum;                          /* ǽеԪ */
    UINT32                          udwFormat;                          /* Ļʽ NETDEV_VIDEO_FORMAT_E */
    CHAR                            szFormat[NETDEV_FORMAT_NAME_LEN];   /*  Ļʽ */
    NETDEV_XW_RESOLUTION_S          stResolution;                       /* Ļ */
    BYTE                            byRes[64];                          /* ֶ */
}NETDEV_TVWALL_SCREEN_S, *LPNETDEV_TVWALL_SCREEN_S;

/**
 * @brief ʽ
 * @attention
 */
typedef struct tagNETDEVTVWallFORMATSPECList
{
    UINT32                          udwScreenID;                        /* Ļ(1ʼ) */
    UINT32                          udwFormat;                          /* Ļʽ NETDEV_VIDEO_FORMAT_E */
    CHAR                            szFormat[NETDEV_FORMAT_NAME_LEN];   /*  Ļʽ */
    BYTE                            byRes[32];                          /* ֶ */
}NETDEV_TVWALL_FORMAT_SPEC_S, *LPNETDEV_TVWALL_FORMAT_SPEC_S;

/**
 * @brief ģ
 * @attention
 */
typedef struct tagNETDEVTVWallLEDSPECList
{
    UINT32                  udwScreenID;        /* Ļ(1ʼ) */
    NETDEV_XW_RESOLUTION_S  stResolution;       /* Ļ */
    BYTE                    byRes[32];          /* ֶ */
}NETDEV_TVWALL_LED_SPEC_S, *LPNETDEV_TVWALL_LED_SPEC_S;

/**
 * @brief ˿
 * @attention
 */
typedef struct tagNETDEVTVWallVOUTList
{
    UINT32  udwScreenID;        /* Ļ(1ʼ) */
    UINT32  udwVideoOutID;      /* ˿ID */
    BYTE    byRes[32];          /* ֶ */
}NETDEV_TVWALL_VIDED_OUT_S, *LPNETDEV_TVWALL_VIDED_OUT_S;

/**
 * @brief "XW"ƵͨϢ
 * @attention
 */
typedef struct tagNETDEVXWVideoOutInfo
{
    INT32   dwChannelID;                   /* ͨID */
    INT32   dwSlotID;                      /* λID */
    INT32   dwIndex;                       /*  */
    UINT32  udwVideoPortType;              /* ͨ NETDEV_VIDEO_PORT_TYPE_E */
    UINT32  udwStatus;                     /* ͨ״̬ μ NETDEV_CHN_STATUS_E */
}NETDEV_XW_VIDEO_OUT_INFO_S, *LPNETDEV_XW_VIDEO_OUT_INFO_S;

/**
 * @brief ǽĻ
 * @attention
 */
typedef struct tagNETDEVXWTVWallCfg
{
    UINT32                          udwTVWallID;                                    /* ǽID */
    CHAR                            szTVWallCode[NETDEV_LEN_64];                    /* ǽ루ѡֶΣ豸˷䣬ַȷΧ[1,64] */
    CHAR                            szName[NETDEV_TVWALL_NAME_LEN];                 /* ǽ */
    UINT32                          udwOrderNo;                                     /* ǽ */
    NETDEV_TVWALL_SCREEN_S          stScreenInfo;                                   /* ǽĻ */
    UINT32                          udwFormatSpecNum;                               /* ʽ */
    NETDEV_TVWALL_FORMAT_SPEC_S     astFormatSpec[NETDEV_FORMAT_SPEC_MAX];          /* ʽ */
    UINT32                          udwLedSpecNum;                                  /* ģ */
    NETDEV_TVWALL_LED_SPEC_S        astLedSpec[NETDEV_LED_SPEC_MAX];                /* ģ */
    UINT32                          udwVideoOutNum;                                 /* ˿ */
    NETDEV_TVWALL_VIDED_OUT_S       astVideoOut[NETDEV_VIDEO_OUT_MAX];              /* ˿б */
    UINT32                          udwTVWallType;                                  /* ǽ */
    INT32                           dwXWDeviceID;                                   /* -1ʾDC豸>0ʾADU豸ID */
    UINT32                          udwZoomEnabled;                                 /* Ƿţ0:ţ1: */
    BYTE                            byRes[176];                                     /* ֶ */
}NETDEV_XW_TVWALL_CFG_S, *LPNETDEV_XW_TVWALL_CFG_S;

/**
 * @brief Ϣ
 * @attention
 */
typedef struct tagNETDEVXWSceneInfoBase
{
    UINT32  udwSceneID;                         /* ID */
    CHAR    szName[NETDEV_SCENE_NAME_LEN];      /*  */
    UINT32  udwOrderNo;                         /*  */
    UINT32  udwTVWallID;                        /* ǽID */
    UINT32  udwStatus;                          /* 0ʾã1ʾ */
    BYTE    byRes[20];                          /* ֶ */
}NETDEV_XW_SCENE_INFO_BASE_S, *LPNETDEV_XW_SCENE_INFO_BASE_S;

/**
 * @brief ޸Ϣ
 * @attention
 */
typedef struct tagNETDEVXWSceneModifyInfo
{
    NETDEV_XW_SCENE_INFO_BASE_S     stSceneBaseInfo;             /* Ϣ */
    INT32                           dwModifyType;                /* ޸ͣμNETDEV_XW_SCENE_MODIFY_TYPE_E modify type see #NETDEV_XW_SCENE_MODIFY_TYPE_E */
    BYTE                            byRes[128];                  /* ֶ */
}NETDEV_XW_SCENE_MODIFY_INFO_S, *LPNETDEV_XW_SCENE_MODIFY_INFO_S;

/**
 * @brief ҪϢ
 * @attention
 */
typedef struct tagNETDEVXWSceneInfoShort
{
    NETDEV_XW_SCENE_INFO_BASE_S     stSceneBase;        /*  */
    UINT32                          udwIsCurrent;       /* Ƿǰ 0:ǵǰ 1:ǰ */
    BYTE                            byRes[64];          /* ֶ */
}NETDEV_XW_SCENE_INFO_BASIC_S, *LPNETDEV_XW_SCENE_INFO_BASIC_S;

/**
 * @brief ƻϢ
 * @attention
 */
typedef struct tagNETDEVXWCfgTime
{
    CHAR    szBeginTime[NETDEV_TIME_LEN];   /* ʼʱ ȫ00:00:00 */
    CHAR    szEndTime[NETDEV_TIME_LEN];     /* ʱ ȫ24:00:00 */
    UINT32  udwSceneID;                     /* ID */
}NETDEV_XW_CFG_TIME_S, *LPNETDEV_XW_CFG_TIME_S;

/**
 * @brief ܼƻϢ
 * @attention
 */
typedef struct tagNETDEVXWPlanCfg
{
    UINT32                  udwDayOfWeek;                       /* ܼ NETDEV_WEEK_INFO */
    UINT32                  udwSize;                            /* ʱ */
    NETDEV_XW_CFG_TIME_S    stTime[NETDEV_PLAN_SECTION_NUM];    /* ʱϢ */
}NETDEV_XW_PLAN_CFG_S, *LPNETDEV_XW_PLAN_CFG_S;

/**
 * @brief ƻ
 * @attention
 */
typedef struct tagNETDEVXWScenePlan
{
    UINT32                  udwPlanID;                          /* ƻID */
    BOOL                    bIsEnabled;                         /* ƻǷ */
    NETDEV_XW_PLAN_CFG_S    astConfig[NETDEV_PLAN_NUM_AWEEK];   /* ƻϢ */
    BYTE                    byRes[64];                          /* ֶ */
}NETDEV_XW_SCENE_PLAN_S, *LPNETDEV_XW_SCENE_PLAN_S;


/**
 * @brief XWڷϢ
 * @attention
 */
typedef struct tagNETDEVXWPaneInfo
{
    UINT32      udwPaneID;              /*  */
    INT32       dwChannelID;            /* ͨID */
    UINT32      udwStreamIndex;         /*  */
    UINT32      udwTaskNo;              /* ҵ */
    UINT32      udwTransProtocal;       /* Э μ NETDEV_TRANS_PROTOCAL_E */
    UINT32      udwSessionType;         /* ҵ μ NETDEV_SESSION_TYPE_E */
}NETDEV_XW_PANE_INFO_S, *LPNETDEV_XW_PANE_INFO_S;

/**
 * @brief Ϣ
 * @attention
 */
typedef struct tagNETDEVXWSceneWndInfo
{
    UINT32                  udwWndID;                           /* ID */
    UINT32                  udwModifyCmd;                       /* ޸Ŀѡ NETDEV_XW_WND_CMD */
    CHAR                    szWndName[NETDEV_WND_NAME_LEN];     /*  */
    UINT32                  udwPaneMod;                         /* ģʽ,Ĭ1 NETDEV_XW_LAYOUT_NUM_E */
    UINT32                  udwLayer;                           /* ͼ㣬ִϲ*/
    UINT32                  udwTransparency;                    /* ͸ȣĬ0 ͸,100 ȫ͸ 0-100ֵ͸*/
    NETDEV_XW_AREA_S        stArea;                             /* λϢ */
    UINT32                  udwZoomType;                        /* Ŵ μNETDEV_XW_ZOOM_TYPE_E zoom Type see NETDEV_XW_ZOOM_TYPE_E */
    UINT32                  udwSplitIndex;                      /*  udwZoomTypeΪNETDEV_XW_ZOOM_TYPE_SPLITʱЧ */
    UINT32                  udwSchemeResID;                      /* ѲԴID */
    UINT32                  udwSeqStatus;                        /* Ѳ״̬μNETDEV_SEQ_STATUS_E */
    UINT32                  udwPaneSize;                         /* */
    NETDEV_XW_PANE_INFO_S   astPaneInfoList[NETDEV_XW_MAX_PANE_NUM];      /* зϢ*/
    UINT32                  udwWndType;                          /*  μöNETDEV_TVWALL_WND_TPYE*/
    UINT32                  udwDChlID;                           /* DCͨID */
    UINT32                  udwStatus;                           /* 0ʾ1ʾ */
    UINT32                  udwScaleEnabled;                     /* ״̬  NETDEV_SCALE_ENABLED_E ֶνLEDͿ豸ʹãĬΪ */
    BYTE                    byRes[240];                          /* ֶ */
}NETDEV_XW_SCENE_WND_INFO_S, *LPNETDEV_XW_SCENE_WND_INFO_S;

/**
 * @brief ȨϢ
 * @attention
 */
typedef struct tagNETDEVAuthentication
{
    BOOL                            bIsNeedAuthentication;                 /* ǷҪȨ */
    CHAR                            szUserName[NETDEV_USER_NAME_ENCRYPT_LEN];/* ƵԴû */
    CHAR                            szPassword[NETDEV_PASSWORD_ENCRYPT_LEN]; /* ƵԴ */
    NETDEV_AUTH_MODEL_E            enAuthModel;                           /* ֶΣݲʹá οö#NETDEV_XW_AUTH_MODEL_E */
    BYTE                            byRes[64];                            /* ֶ */
}NETDEV_AUTHENTICATION_S, *LPNETDEV_AUTHENTICATION_S;

/**
 * @brief Զ˻طŵƵԴϢ
 * @attention
 */
typedef struct tagNETDEVXWChannels
{
    UINT32                      udwVideoInID;                       /* ƵԴID */
    CHAR                        szReplayURL[NETDEV_MAX_URL_LEN];    /* طURL */
    NETDEV_AUTHENTICATION_S     stAuthentication;                   /* ȨϢ */
    UINT32                      udwTransProtocol;                   /* Э NETDEV_LAPI_TRANS_PROTOCOL_E ʱ*/
    UINT32                      udwMulticast;                       /* 鲥 NETDEV_STREAM_TYPE_E ʱ*/
    INT64                       tBeginTime;                         /* ʼʱ */
    INT64                       tEndTime;                           /* ʱ */
    UINT32                      udwManageType;                      /* ԴͣμöNETDEV_XW_MANAGE_TYPE_E  */
    UINT32                      udwSessionID;                       /* طǽǰԤʱͻ˺XwareRTSPЭЭ̵SessionIDManageType=1ʱʹøֶΡ */
    BYTE                        byRes[56];                          /* ֶ */
}NETDEV_XW_CHANNELS_S, *LPNETDEV_XW_CHANNELS_S;

/**
 * @brief "XW"豸IDϢ
 * @attention
 */
typedef struct tagNETDEVXWDisplayerID
{
    UINT32  udwTVWallID;    /* ǽID */
    UINT32  udwWndID;       /* ID */
    UINT32  udwPaneID;      /*  */
    BYTE    byRes[16];      /* ֶ */
}NETDEV_XW_DISPLAYER_ID_S, *LPNETDEV_XW_DISPLAYER_ID_S;

/**
 * @brief ԶʵƵԴϢ
 * @attention
 */
typedef struct tagNETDEVXWVideoSourceBase
{
    UINT32                      udwVideoInID;                       /* ƵԴID */
    CHAR                        szRealplayURL[NETDEV_MAX_URL_LEN];  /* ýURL ʱ*/
    UINT32                      udwStreamID;                        /* ý */
    NETDEV_AUTHENTICATION_S     stAuthentication;                   /* ȨϢ */
    UINT32                      udwTransProtocol;                   /* Э NETDEV_LAPI_TRANS_PROTOCOL_E ʱ*/
    UINT32                      udwMulticast;                       /* 鲥 NETDEV_STREAM_TYPE_E ʱ*/
    UINT32                      udwType;                            /* ʵ ο NETDEV_XW_REALPLAY_TYPE_E */
    UINT32                      udwManageType;                      /* ԴͣμöNETDEV_XW_MANAGE_TYPE_E  */
    BYTE                        byRes[28];                         /* ֶ */
}NETDEV_XW_VIDEO_SOURCE_BASE_S, *LPNETDEV_XW_VIDEO_SOURCE_BASE_S;

/**
 * @brief Ϣ
 * @attention
 */
typedef struct tagNETDEVXWContentInfo
{
    CHAR  szContent[NETDEV_LEN_260];   /*  */
    UINT32  udwFontType;               /*  μöٶ# NETDEV_XW_LED_FONT_FORMAT_E */
    UINT32  udwFontSize;               /* ִС 0Ӧ48-1024:ָظ߶ */
    UINT32  udwColor;                  /* ɫɫRGBķʽ 0xABCDEFABʾRֵ00~FFCDʾGֵ00~FFEFʾBֵ00~FFĬϣ0xFF0000ɫ*/
    UINT32  udwPosition;               /* λ μöٶ# NETDEV_XW_CONTENT_POSITION_E*/
    BYTE    byRes[128];                /* ֶ */
}NETDEV_XW_CONTENT_INFO_S, *LPNETDEV_XW_CONTENT_INFO_S;

/**
 * @brief ԶʵƵԴϢ
 * @attention
 */
typedef struct tagNETDEVXWVideoSource
{
    NETDEV_XW_DISPLAYER_ID_S    stDisplayerID;                      /* 豸IDϢ */
    UINT32                      udwVideoInID;                       /* ƵԴID */
    CHAR                        szRealplayURL[NETDEV_MAX_URL_LEN];  /* ýURL ʱ*/
    UINT32                      udwStreamID;                        /* ý */
    NETDEV_AUTHENTICATION_S     stAuthentication;                   /* ȨϢ */
    UINT32                      udwTransProtocol;                   /* Э NETDEV_LAPI_TRANS_PROTOCOL_E ʱ*/
    UINT32                      udwMulticast;                       /* 鲥 NETDEV_STREAM_TYPE_E ʱ*/
    UINT32                      udwType;                            /* ʵ ο NETDEV_XW_REALPLAY_TYPE_E */
    UINT32                      udwDecodeType;                      /*  οNETDEV_XW_DECODE_TYPE_E */
    UINT32                      udwManageType;                      /* ԴͣμöNETDEV_XW_MANAGE_TYPE_E  */
    LPNETDEV_XW_CONTENT_INFO_S  pstContentInfo;                     /* Ϣ */
    BYTE                        byRes[56];                          /* ֶ */
}NETDEV_XW_VIDEO_SOURCE_S, *LPNETDEV_XW_VIDEO_SOURCE_S;

/**
 * @brief طſϢ
 * @attention
 */
typedef struct tagNETDEVXWPlaybackParam
{
    UINT32                          udwTaskNo;                   /* طҵ */
    UINT32                          udwControlType;              /* طſ ο NETDEV_XW_CTRL_TYPE_E */
    UINT32                          udwControlParam;             /* Ƶľֵٶȵ */
    BYTE                            byRes[64];                  /* ֶ */
}NETDEV_XW_PLAYBACK_PARAM_S, *LPNETDEV_XW_PLAYBACK_PARAM_S;

/**
 * @brief ҵƵԴϢ
 * @attention
 */
typedef struct tagNETDEVXWVideoInSource
{
    UINT32                      udwVideoInChlID;            /* ƵԴID */
    UINT32                      udwStreamID;                /* ý */
    CHAR                        szURL[NETDEV_MAX_URL_LEN];  /* ýURL */
    NETDEV_AUTHENTICATION_S     stAuthentication;           /* ȨϢ */
    UINT32                      udwSeqIntervalSec;          /* Ѳλ ֻѲʱҪ */
    UINT32                      udwPreset;                  /* Ԥλ ֻѲʱҪ */
    BYTE                        byRes[32];                  /* ֶ */
}NETDEV_XW_VIDEO_IN_SOURCE_S, *LPNETDEV_XW_VIDEO_IN_SOURCE_S;

/**
 * @brief ҵϢ
 * @attention
 */
typedef struct tagNETDEVXWVideoInChannelInfo
{
    UINT32                          udwWndID;                                   /* ID */
    UINT32                          udwPaneID;                                  /*  0ʾѲ*/
    UINT32                          udwSourceSize;                              /* ҵƵԴ */
    NETDEV_XW_VIDEO_IN_SOURCE_S     astVideoInSource[NETDEV_SEQUENCE_SRC_MAX];        /* ҵƵԴϢ */
    BYTE                            byRes[32];                                  /* ֶ */
}NETDEV_XW_VIDEO_IN_CHANNEL_INFO_S, *LPNETDEV_XW_VIDEO_IN_CHANNEL_INFO_S;

/**
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWBackground
{
    UINT32  udwTransparency;    /* ͸ 0ȫ͸ Ĭ,100͸ */
    UINT32  udwBaseColor;       /* ɫ RGBʽ:0xABCDEF ABʾR 00~FF;CDʾG 00~FF;EFʾB 00~FF;Ĭϣ0xFFFFFFɫ*/
    BYTE    byRes[16];          /* ֶ */
}NETDEV_XW_BACKGROUND_S, *LPNETDEV_XW_BACKGROUND_S;

/**
 * @brief Ϣ
 * @attention
 */
typedef struct tagNETDEVXWFontInfo
{
    UINT32  udwFont;                /*  NETDEV_XW_LED_FONT_FORMAT_E */
    UINT32  udwSize;                /* С 07ö٣NETDEV_XW_LED_FONT_SIZE_E,ȡֵΧ[48,1024]ʾʵظ߶  */
    UINT32  udwReferFontSize;       /* οС udwSizeѡӦֶαѡ ֵΧSizeֶ*/ 
    UINT32  udwGap;                 /* ּ  μö NETDEV_XW_LED_FONT_GAP_E */
    UINT32  udwHorizontalAlign;     /* ˮƽ뷽ʽ NETDEV_XW_HORIZONTAL_ALIGN_MODE_E */
    UINT32  udwVerticalAlign;       /* ֱ뷽ʽ NETDEV_XW_VERTICAL_ALIGN_MODE_E */
    UINT32  udwColor;               /* ɫ RGBʽ:0xABCDEF ABʾR 00~FF;CDʾG 00~FF;EFʾB 00~FF;Ĭϣ0xFFFFFFɫ*/
    UINT32  udwScrollMode;          /* ֹʽ NETDEV_XW_LED_SCROLLING_MODE_E  */
    UINT32  udwScrollRateSec;       /* ٶȣλ,ѡ񣬵ScrollingModeΪ1ֵʱѡĬ1 1x10xѡ1x ֹΪ2/3/4/5ʱѡ*/
    UINT32  udwReferFontGap;        /* οּС,udwGapѡӦʱֶЧȡֵΧ0~1024ʵؿȣ */
    BOOL    bBold;                  /*   0:Ӵ, 1:Ӵ */
    BOOL    bSlope;                 /* б  0:б, 1:б */ 
    BOOL    bUnderline;             /* »  0:», 1:» */
    UINT32  udwLineSpace;           /* ָм */
    BYTE   byRes[12];               /* ֶ */
}NETDEV_XW_FONT_INFO_S, *LPNETDEV_XW_FONT_INFO_S;/* LEDϢ */

/**
 * @brief LEDϢ
 * @attention
 */
typedef struct tagNETDEVXWVirtualLEDInfo
{
    UINT32                  udwLEDID;                    /* LEDID */
    UINT32                  udwModifyCmd;                /* ޸Ŀѡ NETDEV_XW_LED_CMD_E */
    UINT32                  udwEnable;                   /* LEDǷ 0ʹ 1ʹ */
    UINT32                  udwType;                     /* LED NETDEV_XW_LED_TYPE_E */
    NETDEV_XW_AREA_S        stArea;                      /* LEDλϢ */
    NETDEV_XW_BACKGROUND_S  stBackground;                /*  */
    NETDEV_XW_FONT_INFO_S   stFontInfo;                  /* Ϣ */
    CHAR                   szText[NETDEV_TEXT_LEN];     /*  */
    BYTE                   byRes[32];                   /* ֶ */
}NETDEV_XW_VIRTUAL_LED_INFO_S, *LPNETDEV_XW_VIRTUAL_LED_INFO_S;

/*******************************شBegin*****************************/
/**
* @brief Ϣ
* @attention
*/
typedef struct tagNETDEVXWSenceBatchWnd
{
    UINT32                          udwReqSeq;              /*  */
    NETDEV_XW_SCENE_WND_INFO_S      stSenceWndInfo;         /* Ϣ */
    BYTE                            byRes[32];              /* ֶ */
}NETDEV_XW_SENCE_BATCH_WND_S, *LPNETDEV_XW_SENCE_BATCH_WND_S;

/**
 * @brief Ϣб
 * @attention
 */
typedef struct tagNETDEVXWBatchWindowInfoList
{
    UINT32                          udwOperation;                 /* 0 1÷ */
    UINT32                          udwNum;                       /**/
    LPNETDEV_XW_SENCE_BATCH_WND_S   pstSceneWinInfo;              /*ϸϢб*/
    BYTE                            byRes[256];                   /* ֶ */
}NETDEV_XW_WND_INFO_LIST_S,*LPNETDEV_XW_WND_INFO_LIST_S;

/**
* @brief ڷϢ
* @attention
*/
typedef struct tagNETDEVXWSenceBatchResultWnd
{
    UINT32  udwReqSeq;      /*  */
    UINT32  udwResuleCode;  /* ش */
    UINT32  udwWinID;       /* ID */
}NETDEV_XW_BATCH_RESULT_WND_S, *LPNETDEV_XW_BATCH_RESULT_WND_S;

/**
* @brief ڷϢб
* @attention
*/
typedef struct tagNETDEVXWSenceBatchResultList
{
    UINT32                              udwSize;            /*  */
    UINT32                              udwLastChange;      /* ժҪ */
    LPNETDEV_XW_BATCH_RESULT_WND_S      pstResultInfo;      /* Ϣ,ݴ̬ڴ */
    BYTE                                byRes[32];          /* ֶ */
}NETDEV_XW_BATCH_RESULT_LIST_S, *LPNETDEV_XW_BATCH_RESULT_LIST_S;

/**
 * @brief ѯԴϢ
 * @attention
 */
typedef struct tagNETDEVXWSequenceSource
{
    UINT32                          udwInterval;                                /* Ѳ λ */
    UINT32                          udwPreset;                                 /* Ԥλ */
    NETDEV_XW_VIDEO_SOURCE_BASE_S   stVideoSourceBase;                          /* ҵƵԴϢ */
    BYTE                            byRes[32];                                 /* ֶ */
}NETDEV_XW_SEQUENCE_SOURCE_S, *LPNETDEV_XW_SEQUENCE_SOURCE_S;

/**
 * @brief ѯԴбϢ
 * @attention
 */
typedef struct tagNETDEVXWSequenceSourceList
{
    UINT32                          udwWndID;                                   /* ID */
    UINT32                          udwSourceSize;                              /* ҵƵԴ */
    NETDEV_XW_SEQUENCE_SOURCE_S     astSequenceSource[NETDEV_SEQUENCE_SRC_MAX]; /* ҵƵԴϢ */
    BYTE                            byRes[32];                                  /* ֶ */
}NETDEV_XW_SEQUENCE_SOURCE_LIST_S, *LPNETDEV_XW_SEQUENCE_SOURCE_LIST_S;

/**
 * @brief еͼϢ
 * @attention
 */
typedef struct tagNETDEVXWBaseMapInfo
{
    UINT32                      udwID;                              /* ͼID豸Ψһ */
    CHAR                        szName[NETDEV_BMAP_NAME_LEN];       /* ͼ */
    UINT32                      udwFormat;                          /* ͼʽ NETDEV_XW_BASE_TYPE_E */
    NETDEV_XW_RESOLUTION_S      stResolution;                       /* ͼֱ */
    UINT32                      udwThumbnailData;                   /* ͼ */
    BYTE                        byRes[300];                         /* ֶ */
}NETDEV_XW_BASE_MAP_INFO_S, *LPNETDEV_XW_BASE_MAP_INFO_S;

/**
 * @brief ѲԴϢ
 * @attention
 */
typedef struct tagNETDEVXWSequenceResourceBindBaseInfo
{
    UINT32          udwID;                                  /* ѲԴϢID,ʱѡ */
    UINT32          udwSequenceResID;                       /* ѲԴID */
    UINT32          udwIntervalTime;                        /* ҵʱλ */
    UINT32          udwStatus;                              /* Ѳ״̬μöNETDEV_XW_SEQUENCE_RES_STATUS_E */
    UINT32          udwWndNum;                              /*  */
    UINT32          audwWndIDList[NETDEV_SEQ_RES_WIN_MAX];  /* IDбڴûάӿڻȡ */
    BYTE            byRes[256];                             /* ֶ */
}NETDEV_XW_SEQUENCE_RES_BIND_INFO_S, *LPNETDEV_XW_SEQUENCE_RES_BIND_INFO_S;

/**
 * @brief ϸϢ
 * @attention
 */
typedef struct tagNETDEVXWSceneInfoDetail
{
    CHAR                                    szName[NETDEV_SCENE_NAME_LEN];      /*  */
    UINT32                                  udwTVWallID;                        /* ǽID */
    CHAR                                    szTVWallCode[NETDEV_LEN_64];        /* ǽ루ѡֶΣ豸˷䣬ַȷΧ[1,64] */
    NETDEV_XW_BASE_MAP_INFO_S               stBaseMapInfo;                      /* ͼϢ */
    UINT32                                  udwVirtualLedNum;                   /* LED */
    LPNETDEV_XW_VIRTUAL_LED_INFO_S          pstVirtualLedInfo;                  /* LEDϢ */
    UINT32                                  udwWndNum;                          /*  */
    LPNETDEV_XW_SCENE_WND_INFO_S            pstWndInfo;                         /* Ϣ */
    UINT32                                  udwLiveBindNum;                     /* ʵҵ */
    LPNETDEV_XW_VIDEO_SOURCE_S              pstVideoSource;                     /* ʵҵϢ */
    UINT32                                  udwSequenceBindNum;                 /* Ѳҵ */
    LPNETDEV_XW_SEQUENCE_SOURCE_LIST_S      pstSequenceSourceList;              /* ѲҵϢ */
    UINT32                                  udwWindowsSequenceBindNum;          /* 󶨴ҵ */
    LPNETDEV_XW_SEQUENCE_RES_BIND_INFO_S    pstWindowsSequenceBindList;         /* 󶨴ѲҵϸϢ */
    UINT32                                  udwLinkedSceneID;                   /* ID */
    UINT32                                  udwLinkedSceneOrderNo;              /*  */
    UINT32                                  udwSceneSessionMode;                /* ҵģʽ μöٶ# NETDEV_SCENE_SESSION_MODE_E*/

    BYTE                                    byRes[172];                         /* ֶ */
}NETDEV_XW_SCENE_INFO_DETAIL_S, *LPNETDEV_XW_SCENE_INFO_DETAIL_S;

/**
 * @brief "XW"ͨϢ
 * @attention
 */
typedef struct tagNETDEVXWChannelsNum
{
    UINT32  udwVideoInNum;               /* Ƶͨ */
    UINT32  udwVideoOutNum;              /* Ƶͨ */
    UINT32  udwAudioInNum;               /* Ƶͨ */
    UINT32  udwAudioOutNum;              /* Ƶͨ */
    BYTE    byRes[64];                  /* ֶ */
}NETDEV_XW_CHANNELS_NUM_S, *LPNETDEV_XW_CHANNELS_NUM_S;

/**
 * @brief "XW"ƵͨϢ
 * @attention
 */
typedef struct tagNETDEVXWVideoInInfo
{
    INT32   dwChannelID;            /* ͨID */
    INT32   dwIndex;                /*  */
    UINT32  udwVideoPortType;       /* ͨ NETDEV_VIDEO_PORT_TYPE_E */
    UINT32  udwStatus;              /* ͨ״̬ μ NETDEV_CHN_STATUS_E */
    BYTE    byRes[60];              /* ֶ */
}NETDEV_XW_VIDEO_IN_INFO_S, *LPNETDEV_XW_VIDEO_IN_INFO_S;

/**
 * @brief "XW"ƵͨϢ
 * @attention
 */
typedef struct tagNETDEVXWAudioOutInfo
{
    INT32   dwChannelID;            /* ͨID */
    UINT32  udwAudioPortType;       /* ͨ NETDEV_AUDIO_PORT_TYPE_E */
    UINT32  udwIndex;               /* ţ豸˿ӡűһ */
    UINT32  udwStatus;              /* ͨ״̬ μ NETDEV_CHN_STATUS_E */
    BYTE    byRes[56];              /* ֶ */
}NETDEV_XW_AUDIO_OUT_INFO_S, *LPNETDEV_XW_AUDIO_OUT_INFO_S;

/**
 * @brief "XW"ƵͨϢ
 * @attention
 */
typedef struct tagNETDEVXWAudioInInfo
{
    INT32   dwChannelID;            /* ͨID */
    UINT32  udwAudioPortType;       /* ͨ NETDEV_AUDIO_PORT_TYPE_E */
    UINT32  udwIndex;               /* ţ豸˿ӡűһ */
    UINT32  udwStatus;              /* ͨ״̬ μ NETDEV_CHN_STATUS_E */
    BYTE    byRes[56];              /* ֶ */
}NETDEV_XW_AUDIO_IN_INFO_S, *LPNETDEV_XW_AUDIO_IN_INFO_S;

/**
 * @brief "XW"ͨϢ
 * @attention
 */
typedef struct tagNETDEVXWSerialInfo
{
    INT32   dwChannelID;            /* ͨID */
    INT32   dwIndex;                /*  */
    UINT32  udwSerialPortType;      /* ͨ NETDEV_XW_SERIAL_TYPE_E */
    UINT32  udwStatus;              /* ͨ״̬ μ NETDEV_CHN_STATUS_E */
    BYTE    byRes[60];              /* ֶ */
}NETDEV_XW_SERIAL_INFO_S, *LPNETDEV_XW_SERIAL_INFO_S;

/**
 * @brief "XW"ͨϢ
 * @attention
 */
typedef struct tagNETDEVXWChannelsList
{
    UINT32                          udwVideoInNum;                  /* Ƶͨ ҪADU/CDUֵ֧ͨ */
    LPNETDEV_XW_VIDEO_IN_INFO_S     pstVideoIn;                     /* ƵͨϢ,udwVideoInNum̬ڴ  */
    UINT32                          udwVideoOutNum;                 /* Ƶͨ ҪADU/CDUֵ֧ͨ*/
    LPNETDEV_XW_VIDEO_OUT_INFO_S    pstVideoOut;                    /* ƵͨϢ,udwVideoOutNum̬ڴ  */
    UINT32                          udwAudioInNum;                  /* Ƶͨ ҪADU/CDUֵ֧ͨ*/
    LPNETDEV_XW_AUDIO_IN_INFO_S     pstAudioIn;                     /* ƵͨϢ,udwAudioInNum̬ڴ  */
    UINT32                          udwAudioOutNum;                 /* Ƶͨ ҪADU/CDUֵ֧ͨ*/
    LPNETDEV_XW_AUDIO_OUT_INFO_S    pstAudioOut;                    /* ƵͨϢ,udwAudioOutNum̬ڴ */
    UINT32                          udwSerialNum;                   /* ͨ ҪADU/CDUֵ֧ͨ*/
    LPNETDEV_XW_SERIAL_INFO_S       pstSerialInfo;                  /* ͨϢ,udwSerialNum̬ڴ */
    BYTE                            byRes[56];                      /* ֶ */
}NETDEV_XW_CHANNELS_LIST_S, *LPNETDEV_XW_CHANNELS_LIST_S;

/**
* @brief 뷢ͿƲϢ   
* @attention  None
*/
typedef struct tagNETDEVPassiveDecodeSend
{
    INT32 dwTransType;          /*䷽ʽ */
    INT32 dwBufSize;            /* ݴС */
    CHAR *pszBuffer;            /*  */
    BYTE byRes[128];            /* ֶ */
}NETDEV_PASSIVE_SEND_S, *LPNETDEV_PASSIVE_SEND_S;

/**
 * @brief ͼչģʽ Smart image encoding mode
 * @attention
 */
typedef struct tagNETDEVSmartEncodeInfo 
{
    UINT32 udwH264SmartEncodeModeNum;                                              /* ֵ֧H.264ͼܱģʽ Number of smart image encoding in H.264*/
    UINT32 audwH264SmartEncodeModeList[NETDEV_SMART_ENCODE_MODEL_MAX_NUM];         /* ֵ֧H.265ͼܱģʽбμNETDEV_SMART_ENCODE_MODE_E List of smart image encoding in H.265. See NETDEV_SMART_ENCODE_MODE_E for reference*/
    UINT32 udwH265SmartEncodeModeNum;                                              /* ֵ֧H.264ͼܱģʽ Number of smart image encoding in H.264*/
    UINT32 audwH265SmartEncodeModeList[NETDEV_SMART_ENCODE_MODEL_MAX_NUM];         /* ֵ֧H.265ͼܱģʽбμNETDEV_SMART_ENCODE_MODE_E List of smart image encoding in H.265. See NETDEV_SMART_ENCODE_MODE_E for reference */
}NETDEV_SMART_ENCODE_S,*LPNETDEV_SMART_ENCODE_S;


/**
 * @brief ֱʾϢ Resolution details
 * @attention
 */
typedef struct tagNETDEVResolutionCapability
{
    UINT32 udwWidth;                                                                  /* ͼ Image width*/
    UINT32 udwHeight;                                                                 /* ͼ߶ Image height*/
    UINT32 udwMinBitRate;                                                             /* С Minimum bit rate*/
    UINT32 udwMaxBitRate;                                                             /*  Maximum bit rate*/
    UINT32 udwDefaultBitRate;                                                         /* Ĭ Default bit rate*/
}NETDEV_RESOLUTION_CAPABILITY_S,*LPNETDEV_RESOLUTION_CAPABILITY_S;

/**
 * @brief Ϣ Stream capability
 * @attention
 */
typedef struct tagNETDEVStreamCapability
{
    UINT32 udwstreamID;                                                             /* μöNETDEV_LIVE_STREAM_INDEX_E Stream index. For enumeration, seeNETDEV_LIVE_STREAM_INDEX_E */
    UINT32 udwResolutionNum;                                                        /* ֵ֧ķֱʸ Number of resolution*/
    UINT32 udwFrameRateNum;                                                         /* ֵ֧֡ʸ Number of frame rate*/
    UINT32 udwMaxFrameRate;                                                         /* ǰ֡ Number of frame rate*/
    UINT32 udwMaxMJPEGFrameRate;                                                    /* ǰMJPEG֡ Maximum MJPEG frame rate of current stream*/
    UINT32 audwFrameRateList[NETDEV_LEN_16];                                        /* ֵ֧֡ Frame rate array*/
    NETDEV_RESOLUTION_CAPABILITY_S astResolutionCapabilityList[NETDEV_LEN_32];      /* ֵ֧ķֱб  List of resolution*/
    NETDEV_SMART_ENCODE_S stSmartEncode;                                            /* ͼչģʽ Smart image encoding mode*/
}NETDEV_STREAM_CAP_S,*LPNETDEV_STREAM_CAPABILITY_S;

/**
 * @brief Ƶʽ Video mode capability
 * @attention
 */
typedef struct tagNETDEVVideoModeInfo 
{
    UINT32 udwWidth;                                      /* ͼ Image width*/
    UINT32 udwHeight;                                     /* ͼ߶ Image height*/
    UINT32 udwFrameRate;                                  /* ͼ֡ Image frame rate*/
}NETDEV_VIDEO_MODE_INFO_S,*LPNETDEV_VIDEO_MODE_INFO_S;

/**
* @struct tagNETDEVRecordStatus
* @brief ¼״̬Ϣ
* @attention 
*/
typedef struct tagNETDEVRecordStatus
{
    INT32   dwChannelID;                    /* ͨ  Channel ID */
    INT32   dwRecordType;                   /* ¼ 0:ֶ¼1:¼¼2:¼3:ʱ¼4:*/
    INT32   dwRecordStatus;                 /* ¼״̬ 0:¼1:δ洢2:ûӲ̻Ӳ̻3:ͨ*/
    BYTE    byRes[128];                     /* ֽ */
}NETDEV_RECORD_STATUS, *LPNETDEV_RECORD_STATUS;

/**
* @struct tagNETDEVRecordStatusList
* @brief ¼״̬Ϣб
* @attention 
*/
typedef struct tagNETDEVRecordStatusList
{
    UINT32                  udwSize;                                 /* ¼״̬ */
    NETDEV_RECORD_STATUS    astRecordStatus[NETDEV_CHANNEL_MAX];      /* ¼״̬Ϣ */
}NETDEV_RECORD_STATUS_LIST_S, *LPNETDEV_RECORD_STATUS_LIST_S;

/**
 * @brief ƵͨƵ Encoding parameter capability
 * @attention
 */
typedef struct tagNETDEVVideoCapInfo
{
    BOOL bIsSupportCfg;                                                             /* Ƿ֧,0: ֧, 1: ֧ Support configuration or not. 0-No, 1-Yes*/
    BOOL bIsSupportSmoothLevel;                                                     /* Ƿ֧ƽ,0: ֧, 1: ֧ Support smoothing or not. 0-No, 1-Yes*/
    BOOL bIsSupportImageFormat;                                                     /* ͼʽǷ,0: ֧, 1: ֧ Support configuration of image mode or not. 0-No, 1-Yes*/
    UINT32 udwEncodeFormatNum;                                                      /* ֵ֧Ƶʽ Number of video compression*/
    UINT32 audwEncodeFormatList[NETDEV_ENCODE_FORMAT_MAX_NUM];                      /* ֵ֧ƵʽбμNETDEV_VIDEO_CODE_TYPE_E Video compression list. See NETDEV_VIDEO_CODE_TYPE_E for reference */
    UINT32 udwMinIFrameInterval;                                                    /* ֵ֧I֡Сֵ Minimum value of I Frame Interval*/
    UINT32 udwMaxIFrameInterval;                                                    /* ֵ֧Iֵ֡ Maximum value of I Frame Interval*/
    UINT32 udwGOPTypeNum;                                                           /* ֵ֧GOP Number of GOP type*/
    UINT32 audwGOPTypeList[NETDEV_GOP_TYPE_MAX_NUM];                                /* ֵ֧GOPб List of GOP type*/
    UINT32 udwVideoModeNum;                                                         /* ֵ֧Ƶʽ Number of video mode*/
    NETDEV_VIDEO_MODE_INFO_S astVideoModeList[NETDEV_LEN_16];                       /* Ƶʽб List of video mode capability*/
    UINT32 udwStreamCapNum;                                                         /* ֵ֧ Number of stream*/
    NETDEV_STREAM_CAP_S astStreamCapList[NETDEV_LEN_16];                            /* ֵ֧б List of stream capability*/
    BOOL bIsSupportScrambled;                                                       /* Ƿ֧ţ0: ֧, 1: ֧ */
    BYTE    byRes[256];                                                             /* ֶ */
}NETDEV_VIDEO_STREAM_CAP_EX_S,*LPNETDEV_VIDEO_STREAM_CAP_EX_S;

/**
 * @brief ƵϢ Video encoding parameter
 * @attention
 */
typedef struct tagNETDEVVideoEncodeInfo
{
    BOOL bEnableSVCMode;                        /* SVC,0ر,1 SVC configuration. 0-Off, 1-On*/
    UINT32 udwEncodeFormat;                     /* ƵʽϢμöNETDEV_VIDEO_CODE_TYPE_E  Video Compression. For enumeration, seeNETDEV_VIDEO_CODE_TYPE_E*/
    UINT32 udwWidth;                            /* ͼ Image width*/
    UINT32 udwHeight;                           /* ͼ߶ Image height*/
    UINT32 udwBitrate;                          /*  Bit rate*/
    UINT32 udwBitrateType;                      /* ͣμNETDEV_BIT_RATE_TYPE_E Bitrate type. See NETDEV_BIT_RATE_TYPE_E for reference */
    UINT32 udwFrameRate;                        /* ֡ Frame rate*/
    UINT32 udwGopType;                          /* Gopģʽ,μNETDEV_GOP_TYPE_E GOP mode. See NETDEV_GOP_TYPE_E for reference */
    UINT32 udwIFrameInterval;                   /* I֡Χ I Frame Interval. The range depends on capability*/
    UINT32 udwImageQuality;                     /* ͼΧ[1, 9]9ͼ Image quality, ranges from 1 to 9. 9 means the highest quality*/
    UINT32 udwSmoothLevel;                      /* ƽȼΧ[1,9]1ƽ Smoothing level, ranges from 1 to 9. 1 means the lowest level*/
    UINT32 udwSmartEncodeMode;                  /* ܱģʽμNETDEV_SMART_ENCODE_MODE_E Smart encoding mode. See NETDEV_SMART_ENCODE_MODE_E for reference*/
}NETDEV_VIDEO_ENCODE_INFO_S,*LPNETDEV_VIDEO_ENCODE_INFO_S;

/**
 * @brief ƵϢ(LAPI) Video stream info(LAPI)
 * @attention
 */
typedef struct tagNETDEVVideoStreamInfoLapi 
{
    BOOL bEnabled;                                                                  /* ƵǷñ Enable encoding for video stream or not*/
    UINT32 udwStreamID;                                                             /* μöNETDEV_LIVE_STREAM_INDEX_E Stream index. For enumeration, seeNETDEV_LIVE_STREAM_INDEX_E*/
    UINT32 udwMainStreamType;                                                       /* ͣμNETDEV_MAIN_STREAM_TYPE_E Main stream. See NETDEV_MAIN_STREAM_TYPE_E for reference */
    NETDEV_VIDEO_ENCODE_INFO_S stVideoEncodeInfo;                                   /* ƵϢ Video encoding parameter*/
}NETDEV_VIDEO_STREAM_INFO_EX_S,*LPNETDEV_VIDEO_STREAM_INFO_EX_S;

/**
 * @brief ƵϢб Video stream list
 * @attention
 */
typedef struct tagNETDEVVideoStreamInfoList 
{
    UINT32 udwNum;                                                              /* Ƶ Number of video stream*/
    NETDEV_VIDEO_STREAM_INFO_EX_S astVideoStreamInfoList[NETDEV_LEN_16];        /* ƵϢб Video stream list*/
}NETDEV_VIDEO_STREAM_INFO_LIST_S,*LPNETDEV_VIDEO_STREAM_INFO_LIST_S;



/***********************   Boolean configuration***************************** */

/**
 * @brief  澯Ϣ ṹ嶨  Alarm boolean inputs info Structure definition
 * @attention  None
 */
typedef struct tagNETDEVAlarmInputInfo
{
    CHAR  szName[NETDEV_LEN_64];                /* 뿪   Name of input alarm */
}NETDEV_ALARM_INPUT_INFO_S, *LPNETDEV_ALARM_INPUT_INFO_S;

/**
 * @brief  и澯Ϣ ṹ嶨  All Alarm boolean inputs info Structure definition
 * @attention  None
 */
typedef struct tagNETDEVAlarmInputInfoList
{
    INT32                        dwSize;                                           /* 뿪  Number of input alarms */
    NETDEV_ALARM_INPUT_INFO_S    astAlarmInputInfo[NETDEV_MAX_ALARM_IN_NUM];       /* 뿪Ϣ  Configuration information of input alarms */
}NETDEV_ALARM_INPUT_LIST_S, *LPNETDEV_ALARM_INPUT_LIST_S;

/**
 * @brief  뿪澯Ϣ ṹ嶨  input switch quantity alert information
 * @attention  None
 */
typedef struct tagNETDEVInputSwitchesInfo
{
    INT32                        dwChancelId;                   /* ͨ Channel ID */
    INT32                        dwInputSwitchIndex;            /*   Input Switch Index*/
    CHAR                         szName[NETDEV_LEN_64];         /* 뿪   Name of input alarm */
    CHAR                         szGBID[NETDEV_LEN_32];         /* Դ,IPC֧   International Standard Resource Coding, supported by IPC only */
    INT32                        dwRunMode;                     /*  1: 2  Alarm Type 1: Open 2: Closed*/
    INT32                        dwEnabled;                     /* ʹ 0:ʹ 1ʹ  Alarm Enabling 0: No Enabling 1: Enabling*/
    INT32                        dwVideoResID;                  /* ӦƵͨID,VMS֧ */
    BYTE                         bRes[124];                     /* ֶ Reserved */
}NETDEV_INPUT_SWITCH_INFO_S, *LPNETDEV_INPUT_SWITCH_INFO_S;


/**
 * @brief  뿪澯Ϣб ṹ嶨  enter switch quantity alert configuration information list
 * @attention  None
 */
typedef struct tagNETDEVInputSwitchesInfoList
{
    INT32                        udwNum;                                /* 뿪澯   Number of input switches  */
    NETDEV_INPUT_SWITCH_INFO_S   astInputSwitchesInfo[NETDEV_LEN_1024]; /* 뿪澯Ϣ  input switches configuration information */
}NETDEV_INPUT_SWITCH_INFO_LIST_S, *LPNETDEV_INPUT_SWITCH_INFO_LIST_S;

/**
 * @brief  澯Ϣ ṹ嶨 Alarm boolean outputs info Structure definition
 * @attention  None
 */
typedef struct tagNETDEVAlarmOutputInfo
{   
    CHAR    szName[NETDEV_LEN_64];                  /*   Boolean name */
    INT32   dwChancelId;                            /* ͨ Channel ID */
    INT32   enDefaultStatus;                        /* Ĭ״̬ μ#NETDEV_BOOLEAN_MODE_E  Default status of boolean output, see enumeration #NETDEV_BOOLEAN_MODE_E */
    INT32   dwDurationSec;                          /* 澯ʱ λ S  Alarm duration (s) */
    INT32   dwOutputNum;                            /* 澯 Alarm output serial number */
} NETDEV_ALARM_OUTPUT_INFO_S, *LPNETDEV_ALARM_OUTPUT_INFO_S;

/**
 * @brief  и澯Ϣ ṹ嶨 All Alarm boolean outputs info Structure definition
 * @attention  None
 */
typedef struct tagNETDEVAlarmOutputList
{   
    INT32                       dwSize;                                                 /*    Number of booleans  */
    NETDEV_ALARM_OUTPUT_INFO_S  astAlarmOutputInfo[NETDEV_MAX_ALARM_OUT_NUM];           /* Ϣ  Boolean configuration information */
} NETDEV_ALARM_OUTPUT_LIST_S, *LPNETDEV_ALARM_OUTPUT_LIST_S;

/**
 * @brief  ߼״̬(ֶ澯)
 * @attention  None
 */
typedef struct tagNETDEVOutputSwitchesAlarmStatus
{
    INT32   dwBooleanId;                            /*   Boolean ID */
    INT32   dwChannelId;                            /* ͨID,豸Ϊ0 */
    INT32   enAlarmStatus;                          /* ״̬ μ#NETDEV_RELAYOUTPUT_STATE_E */
} NETDEV_OUTPUT_SWITCH_ALARM_STATUS_S, *LPNETDEV_OUTPUT_SWITCH_ALARM_STATUS_S;

/**
 * @brief  ߼״̬б(ֶ澯)
 * @attention  None
 */
typedef struct tagNETDEVOutputSwitchesAlarmStatusList
{   
    INT32                                dwSize;                                                       /* 豸ͨ   Number of booleans  */
    NETDEV_OUTPUT_SWITCH_ALARM_STATUS_S  astOutputAlarmStatusInfo[NETDEV_MAX_ALARM_OUT_NUM];           /* ״̬б Output switches alarm status list*/
    BYTE                                 bRes[128];                                                    /* ֶ Reserved */
} NETDEV_OUTPUT_SWITCH_ALARM_STATUS_LIST_S, *LPNETDEV_OUTPUT_SWITCH_ALARM_STATUS_LIST_S;

/**
 * @brief  ߼״̬ṹ(ֶ澯)
 * @attention  None
 */
typedef struct tagNETDEVOutputSwitchesManualAlarmInfo
{   
    INT32                               dwSize;                                    /* Ҫõı   Number of booleans  */
    INT32                               dwIDList[NETDEV_MAX_ALARM_OUT_NUM];        /* Ҫõб booleans ID list */
    NETDEV_MANUAL_ALARM_CMD_E           dwAlarmAction;                             /* ִеμNETDEV_MANUAL_ALARM_CMD_E*/
    BYTE                                 bRes[128];                                /* ֶ Reserved */
} NETDEV_OUTPUT_SWITCH_MANUAL_ALARM_INFO_S, *LPNETDEV_OUTPUT_SWITCH_MANUAL_ALARM_INFO_S;

/**
 * @brief  澯 ṹ嶨 Trigger boolean output alarm Structure definition
 * @attention  None
 */
typedef struct tagNETDEVTriggerAlarmOutput
{   
    CHAR                        szName[NETDEV_LEN_64];          /*   Boolean name */
    NETDEV_RELAYOUTPUT_STATE_E  enOutputState;                  /* ״̬,οö#NETDEV_RELAYOUTPUT_STATE_E  Trigger status, see enumeration #NETDEV_RELAYOUTPUT_STATE_E */
} NETDEV_TRIGGER_ALARM_OUTPUT_S, *LPNETDEV_TRIGGER_ALARM_OUTPUT_S;


/**
 * @brief ʱ ṹ嶨 Time Sections Structure definition
 * @attention  None
 */
typedef struct tagNETDEVTimeSectionInfo
{
    CHAR    szBeginTime[NETDEV_LEN_32];              /* ʼʱ  Begin time */
    CHAR    szEndTime[NETDEV_LEN_32];                /* ʱ  End time */
    UINT32  udwArmingType;                           /* 0: ʱ 1:  2:  3: ͱ 4: 򱨾5: ޼ƻ10: ¼  Distribution Type 0: Timing 1: Motive Inspection 2: Alarm 3: Motive Inspection and Alarm 4: Motive Inspection or Alarm 5: Unplanned 10: Event*/
}NETDEV_TIME_SECTION_INFO_S, *LPNETDEV_TIME_SECTION_INFO_S;

/**
 * @brief ƻ죩 ṹ嶨 Play (Day) Structure definition
 * @attention  None
 */
typedef struct tagNETDEVDayPlanInfo
{
    UINT32                      udwID;                                           /*1һ;2ܶ34ģ5壻67գ8գ  Weekly Index 1: Monday; 2: Tuesday; 3: Wednesday; 4: Thursday; 5: Friday; 6: Saturday; 7: Sunday; 8: Holidays;*/
    UINT32                      udwNum;                                          /*ÿʱθ NVRΪ8ΣIPCΪ4  The maximum number of NVRs per day is 8; IPC maximum 4 paragraphs*/
    NETDEV_TIME_SECTION_INFO_S  astTimeSection[NETDEV_MAX_TIME_SECTION_NUM];     /* ʱ ͬһʱ䲻غ Time Sections */
}NETDEV_DAY_PLAN_INFO_S, *LPNETDEV_DAY_PLAN_INFO_S;


/**
 * @brief ƻܣ ṹ嶨 Play (Week) Structure definition
 * @attention  None
 */
typedef struct tagNETDEVPlanWeekInfo
{
    BOOL                        bEnabled;                                           /* ʹ,IPC֧  Enabling,IPC only*/
    UINT32                      udwNum;                                             /* ƻNVRΪ8(һͼ)IPCΪ7(һ)  Planned days, NVR up to 8(7 days a week and holidays) IPC up to 7(7 days a week)*/
    NETDEV_DAY_PLAN_INFO_S      astDayPlanInfo[NETDEV_MAX_DAY_NUM];                 /* һÿĲƻб  List of deployment plans for each day of the week*/

    BYTE                        byRes[512];                                         /* ֶ  Reserved */
}NETDEV_WEEK_PLAN_INFO_S, *LPNETDEV_WEEK_PLAN_INFO_S;

/**
 * @brief ƻܣ ṹ嶨 Plan (Week) Structure definition
 * @attention  None
 */
typedef struct tagNETDEVSwitchWeekPlanInfo
{
    UINT32                      udwSwitchIndex;                 /*  */
    NETDEV_WEEK_PLAN_INFO_S     astWeekPlanInfo;                /* ܼƻϢ */
    BYTE                        byRes[128];                     /* ֶ  Reserved */
}NETDEV_SWITCH_WEEK_PLAN_INFO_S, *LPNETDEV_SWITCH_WEEK_PLAN_INFO_S;

/************************************************ OSD********************************************************/

/**
 * @brief   Area
 * @attention  None
 */
typedef struct tagNETDEVAreaScope
{
    INT32  dwLocateX;             /** xֵ[0,10000] * Coordinates of top point x [0,10000] */
    INT32  dwLocateY;             /** yֵ[0,10000] * Coordinates of top point y [0,10000] */
}NETDEV_AREA_SCOPE_S, *LPNETDEV_AREA_SCOPE_S;

/**
 * @brief OSDʱϢ OSD time configuration information
 * @attention  None
 */
typedef struct tagNETDEVOsdTime
{
    BOOL                    bEnableFlag;        /** ʱOSDʹ, BOOL_TRUEΪʹ,BOOL_FALSEΪʹ * Enable time OSD, BOOL_TRUE means enable and BOOL_FALSE means disable */
    BOOL                    bWeekEnableFlag;    /** Ƿʾ(Ԥ) * Display week or not (reserved) */
    NETDEV_AREA_SCOPE_S     stAreaScope;        /**  * Area coordinates */
    UINT32                  udwTimeFormat;      /** ʱOSDʱʽ,NETDEV_OSD_TIME_FORMAT_CAP_E * Time OSD format, see NETDEV_OSD_TIME_FORMAT_E */
    UINT32                  udwDateFormat;      /** OSDʱʽ,NETDEV_OSD_DATE_FORMAT_CAP_E * Date OSD format, see NETDEV_OSD_TIME_FORMAT_E */
}NETDEV_OSD_TIME_S, *LPNETDEV_OSD_TIME_S;

/**
 * @brief OSDַϢ OSD text overlay information
 * @attention
 */
typedef struct tagNETDEVOsdTextOverlay
{
    BOOL                    bEnableFlag;                /** OSDַʹ, BOOL_TRUEΪʹ,BOOL_FALSEΪʹ * Enable OSD text overlay, BOOL_TRUE means enable and BOOL_FALSE means disable */
    NETDEV_AREA_SCOPE_S     stAreaScope;                /** OSDַ * OSD text overlay area coordinates */
    CHAR                    szOSDText[NETDEV_OSD_TEXT_MAX_LEN];    /** OSDַַ * OSD text overlay name strings */
    BYTE                    byRes[4];                               /* ֶ  Reserved */
}NETDEV_OSD_TEXT_OVERLAY_S, *LPNETDEV_OSD_TEXT_OVERLAY_S;

/**
 * @brief ͨOSDĻϢ Basic channel OSD information
 * @attention
 */
typedef struct tagNETDEVOsdCfgInfo
{
    NETDEV_OSD_TIME_S         stTimeOSD;        /* ͨʱOSDϢ  Information of channel time OSD */
    NETDEV_OSD_TEXT_OVERLAY_S stNameOSD;        /* ͨOSDϢ  Information of channel name OSD */
    INT16                     wTextNum;         /* ַOSD  Text OSD number */
    NETDEV_OSD_TEXT_OVERLAY_S astTextOverlay[NETDEV_OSD_TEXTOVERLAY_NUM];   /* ͨOSDַϢ  Information of channel OSD text overlay */
}NETDEV_VIDEO_OSD_CFG_S, *LPNETDEV_VIDEO_OSD_CFG_S;

/**
 * @brief ýṹ嶨 Definition of area configuration structure 
 * @attention
 */
typedef struct tagAreaInfo
{
    INT32   bIsEanbled;           /* Ƿ  Enable or not. */
    INT32   dwTopLeftX;           /* ϽX [0, 10000]  Upper left corner X [0, 10000]  */
    INT32   dwTopLeftY;           /* ϽY [0, 10000]  Upper left corner Y [0, 10000]  */
    INT32   dwBottomRightX;       /* ½X [0, 10000]  Lower right corner x [0, 10000] */
    INT32   dwBottomRightY;       /* ½Y [0, 10000]  Lower right corner y [0, 10000] */
    INT32   dwIndex;              /*   Index. */
}NETDEV_PRIVACY_MASK_AREA_INFO_S;

/**
 * @brief ˽ڸϢ Privacy mask configuration information
 * @attention
 */
typedef struct tagPrivacyMaskPara
{
    INT32                                  dwSize;                                     /*   Mask area number */ 
    NETDEV_PRIVACY_MASK_AREA_INFO_S        astArea[NETDEV_MAX_PRIVACY_MASK_AREA_NUM];  /* ڸ  Mask area parameters */
}NETDEV_PRIVACY_MASK_CFG_S, *LPNETDEV_PRIVACY_MASK_CFG_S;

/**
 * @brief ͨOSD OSD Capabilities
 * @attention
 */
typedef struct tagNETDEVOsdCapabilities
{
    BOOL     bIsSupportCfg;                                                     /* Ƿ֧,0֧ 1֧ Support configuration or not. 0-No, 1-Ye*/
    BOOL     bIsSupportFontSizeCfg;                                             /* Ƿ֧OSDС Support configuration of OSD size or not*/ 
    BOOL     bIsSupportFontColorCfg;                                            /* Ƿ֧OSDɫ upport configuration of OSD color or not*/ 
    UINT32   udwMaxAreaNum;                                                     /* ֧OSD Maximum number of OSD area*/ 
    UINT32   udwMaxOSDNum;                                                      /* ֧OSD Maximum number of OSD*/ 
    UINT32   udwMaxPerAreaOSDNum;                                               /* ÿ֧OSD Maximum number of OSD in each area*/ 
    UINT32   udwSupportedOSDTypeNum;                                            /* ֵ֧OSD Number of OSD content type*/ 
    UINT32   udwSupportedTimeFormatNum;                                         /* ֵ֧ʱOSDʽ Number of OSD time format*/ 
    UINT32   udwSupportedDateFormatNum;                                         /* ֵ֧OSDʽ Number of OSD date format*/ 
    UINT32   aduwSupportedDateFormatList[NETDEV_OSD_DATE_FORMAT_MAX_NUM];       /* OSDʽбμöNETDEV_OSD_DATE_FORMAT_E */ 
    UINT32   audwSupportedTimeFormatList[NETDEV_OSD_TIME_FORMAT_MAX_NUM];       /* ʱOSDʽбμöNETDEV_OSD_TIME_FORMAT_E */ 
    UINT32   audwSupportedOSDTypeList[NETDEV_OSD_TYPE_MAX_NUM];                 /* ֧õOSDбμöNETDEV_OSD_CONTENT_TYPE_E */ 
    UINT32   udwSupportedFontSizeNum;                                           /* ֵ֧OSDС Number of OSD font size */ 
    UINT32   udwSupportedFontStyleNum;                                          /* ֵ֧OSDʽ Number of OSD font style */ 
    UINT32   audwSupportedFontSizeList[NETDEV_OSD_FONT_SIZE_TYPE_MAX_NUM];      /* ֵ֧OSDСбμö NETDEV_OSD_FONT_SIZE_E */ 
    UINT32   audwSupportedFontStyleList[NETDEV_OSD_FONT_STYLE_TYPE_MAX_NUM];    /* ֵ֧OSDʽбμö NETDEV_OSD_FONT_STYLE_E */ 
    BYTE     byRes[512];                                                        /* ֶ  Reserved */
}NETDEV_OSD_CAP_S, *LPNETDEV_OSD_CAP_S;

/**
 * @brief ͨOSDʽ Display Style of channel OSD
 * @attention
 */
typedef struct tagNETDEVOsdContentStyle
{
    UINT32 udwFontStyle;                         /* ʽμöNETDEV_OSD_FONT_STYLE_E  Font style. For enumeration, seeNETDEV_OSD_FONT_STYLE_E*/
    UINT32 udwFontSize;                          /* СμöNETDEV_OSD_FONT_SIZE_E  Font Size. For enumeration, seeNETDEV_OSD_FONT_SIZE_E*/
    UINT32 udwColor;                             /* ɫɫRGBķʽ 0xABCDEFABʾRֵ00~FFCDʾGֵ00~FFEFʾBֵ00~FFĬϣ0xFF0000ɫ*/
    UINT32 udwDateFormat;                        /* ڸʽμöNETDEV_OSD_DATE_FORMAT_E  Date Format. For enumeration, seeNETDEV_OSD_DATE_FORMAT_E */
    UINT32 udwTimeFormat;                        /* ʱʽμöNETDEV_OSD_TIME_FORMAT_E  Date Format. For enumeration, seeNETDEV_OSD_DATE_FORMAT_E */
    UINT32 audwFontAlignList[NETDEV_LEN_8];      /* 룬̶8IPC֧,μöNETDEV_OSD_ALIGN_E  Font align in area, 8 areasfixed, IPcamera supported. For enumeration, seeNETDEV_OSD_ALIGN_E */
    UINT32 udwMargin;                            /* ԵյַIPC֧֣μöNETDEV_OSD_MIN_MARGIN_E  Number of character with margin, IP camera supported. For enumeration, seeNETDEV_OSD_MIN_MARGIN_E */
}NETDEV_OSD_CONTENT_STYLE_S,*LPNETDEV_OSD_CONTENT_STYLE_S;

/**
 * @brief Ϣ Content
 * @attention
 */
typedef struct tagNETDEVContentInfo
{

    UINT32 udwContentType;                        /* OSD,μöNETDEV_OSD_CONTENT_TYPE_E OSD content type. For enumeration, see NETDEV_OSD_CONTENT_TYPE_E*/
    CHAR   szOSDText[NETDEV_OSD_TEXT_MAX_LEN];    /* OSDıϢ OSD text*/
}NETDEV_CONTENT_INFO_S,*LPNETDEV_CONTENT_INFO_S;

/**
 * @brief ͨOSDϢ Channel OSD content
 * @attention
 */
typedef struct tagNETDEVOSDContentInfo
{
    BOOL   bEnabled;                                        /* OSDʹ Enable OSD area*/
    UINT32 udwOSDID;                                        /* OSDţΧ[0,7] Area No., ranges from 0 to 7.*/
    UINT32 udwAreaOSDNum;                                   /* ǰOSDĿ Number of OSD in current area*/
    UINT32 udwTopLeftX;                                     /* OSD,Χ[0,9999] X-axis of OSD area, ranges from 0 to 999*/
    UINT32 udwTopLeftY;                                     /* OSD,Χ[0,9999] Y-axisof OSD area, ranges from 0 to 999*/
	UINT32 udwBotRightX;                                    /* old޴˲OSD,Χ[0,9999] X-axis of OSD area, ranges from 0 to 999*/
	UINT32 udwBotRightY;                                    /* old޴˲OSD,Χ[0,9999] Y-axisof OSD area, ranges from 0 to 999*/
    NETDEV_CONTENT_INFO_S astContentInfo[NETDEV_LEN_8];     /* ǰOSDϢ OSD content in current area*/
}NETDEV_OSD_CONTENT_INFO_S,*LPNETDEV_OSD_CONTENT_INFO_S;

/**
 * @brief ͨOSD All contents of channel OSD
 * @attention
 */
typedef struct tagNETDEVOsdContent
{
    UINT32                    udwNum;                          /* OSD Number of OSD area*/
    NETDEV_OSD_CONTENT_INFO_S astContentList[NETDEV_LEN_32];   /* OSDϢб Content list of OSD area*/
}NETDEV_OSD_CONTENT_S,*LPNETDEV_OSD_CONTENT_S;

/************************************************ Ƶ********************************************************/

/**
 * @brief ڵϢ Tampering detection analysis info
 * @attention  None
 */
typedef struct tagNETDEVTamperAlarmInfo
{
    INT32  dwSensitivity;                               /*   Sensitivity */
    BYTE   byRes[256];                                  /* ֶ  Reserved */
}NETDEV_TAMPER_ALARM_INFO_S, *LPNETDEV_TAMPER_ALARM_INFO_S;

/**
 * @brief ˶Ϣ Motion detection analysis info
 * @attention  None
 */
typedef struct tagNETDEVMotionAlarmInfo
{
    INT32  dwSensitivity;                                                     /*   Sensitivity */
    INT32  dwObjectSize;                                                      /* С  Objection Size */
    INT32  dwHistory;                                                         /* ʱ  History */
    INT16  awScreenInfo[NETDEV_SCREEN_INFO_ROW][NETDEV_SCREEN_INFO_COLUMN];   /* ĻϢ  Screen Info */
    BYTE   byRes[64];                                                         /* ֶ  Reserved */
}NETDEV_MOTION_ALARM_INFO_S, *LPNETDEV_MOTION_ALARM_INFO_S;

/**
 * @struct tagNETDEVMotionDetectionAreaGridInfo
 * @brief ˶Ϣ Motion detection area grid info
 * @attention  None
 */
typedef struct tagNETDEVMotionDetectionAreaGridInfo
{
    BOOL    bEnabled;                                                        /* ʹܱʶ */
    UINT32  udwSensitivity;                                                  /* ˶ȣֵԽԽΧ[1,100]  Sensitivity */
    INT16   awGridInfo[NETDEV_SCREEN_INFO_ROW][NETDEV_SCREEN_INFO_COLUMN];  /* ĻϢ  Grid Info */
    BYTE    byRes[256];                                                         /* ֶ  Reserved */
}NETDEV_MOTION_DETECTION_AREA_GRID_INFO_S, *LPNETDEV_MOTION_DETECTION_AREA_GRID_INFO_S;

/**
 * @struct tagNETDEVRectAreaInfo
 * @brief Ϣ ṹ嶨 Rectangle Area info  Structure definition
 * @attention  None
 */
typedef struct tagNETDEVRectAreaInfo
{
    UINT32   udwTopLeftX;                       /* xֵ X axis left point value */
    UINT32   udwTopLeftY;                       /* yᶥֵ Y axis top point value */
    UINT32   udwBottomRightX;                   /* xҵֵ X axis right point value */
    UINT32   udwBottomRightY;                   /* y׵ֵ Y axis bottom point value */
}NETDEV_RECT_AREA_INFO_S, *LPNETDEV_RECT_AREA_INFO_S;

/**
 * @struct tagNETDEVMotionDetectionAreaRectangleInfo
 * @brief ˶Ϣ Motion detection area rectangle info
 * @attention  None
 */
typedef struct tagNETDEVMotionDetectionAreaRectangleInfo
{
    UINT32  udwID;                              /*  */
    BOOL    bEnabled;                           /* ʹܱʶ */
    UINT32  udwSensitivity;                     /* ˶ȣֵԽԽΧ[1,100]  Sensitivity */
    UINT32  udwDuration;                        /* ʱ䣬Χ[1,100] */
    UINT32  udwTargetSize;                      /* СΧ[1,100] */
    NETDEV_RECT_AREA_INFO_S   stRectAreaInfo;   /* Ϣ,ֵΧ[0,9999]  rectangle area Info [0,9999] */
    BYTE    byRes[128];                                                         /* ֶ  Reserved */
}NETDEV_MOTION_DETECTION_AREA_RECTANGLE_INFO_S, *LPNETDEV_MOTION_DETECTION_AREA_RECTANGLE_INFO_S;

/**
 * @struct tagNETDEVMotionDetectionAreaRectangleInfoList
 * @brief ˶Ϣб Motion detection area rectangle info
 * @attention  None
 */
typedef struct tagNETDEVMotionDetectionAreaRectangleInfoList
{
    UINT32                                          udwNum;                                 /*  */
    NETDEV_MOTION_DETECTION_AREA_RECTANGLE_INFO_S   astRectangleAreaInfoList[NETDEV_LEN_8]; /* Ϣб */
    BYTE    byRes[128];                                                                     /* ֶ  Reserved */
}NETDEV_MOTION_DETECTION_AREA_RECTANGLE_INFO_LIST_S, *LPNETDEV_MOTION_DETECTION_AREA_RECTANGLE_INFO_LIST_S;

/**
* @enum tagNETDEVMotionDetectionAreaType
* @brief ˶Ϣ motion detection area type
* @attention 
*/
typedef struct tagNETDEVMotionDetectionAreaType
{
    UINT32  udwAreaType;                    /*  μö#NETDEV_MOTION_DETECTION_AREA_TYPE_E */
    BYTE    byRes[128];                     /* ֽ */
}NETDEV_MOTION_DETECTION_AREA_TYPE_S, *LPNETDEV_MOTION_DETECTION_AREA_TYPE_S;

typedef struct tagNETDEVCrossLinePointInfo
{
    BOOL    bEnable;                /* Ƿ  Supported or not */
    INT32   dwSensitivity;        /*   Sensitivity */
    INT32   dwDirection;          /*  trigger Direction */
    INT32   dwTopLeftX;           /* ϽX [0, 10000]  Upper left corner X [0, 10000]  */
    INT32   dwTopLeftY;           /* ϽY [0, 10000]  Upper left corner Y [0, 10000]  */
    INT32   dwBottomRightX;       /* ½X [0, 10000]  Lower right corner x [0, 10000] */
    INT32   dwBottomRightY;       /* ½Y [0, 10000]  Lower right corner y [0, 10000] */
}NETDEV_CROSS_LINE_POINT_INFO_S, *LPNETDEV_CROSS_LINE_POINT_INFO_S;

/**
* @brief ԽϢ
* @attention  None
*/
typedef struct tagNETDEVCrossLineAlarmInfo
{
    BOOL    bEnable;                                                  /* Ƿ  Supported or not */
    NETDEV_CROSS_LINE_POINT_INFO_S stAreaInfo[4];                       /* Ϣ area info */
    BYTE   byRes[64];                                                   /* ֶ  Reserved */
}NETDEV_CROSS_LINE_ALARM_INFO_S, *LPNETDEV_CROSS_LINE_ALARM_INFO_S;

/**
* @brief ּ
* @attention  None
*/
typedef struct tagNETDEVIntrusionPointInfo
{

    INT32   dwPointX;           /* X [0, 10000]*/
    INT32   dwPointY;           /* Y [0, 10000]*/
}NETDEV_INTRUSION_POINT_INFO_S, *LPNETDEV_INTRUSION_POINT_INFO_S;


/**
* @brief ּϢ
* @attention  None
*/
typedef struct tagNETDEVIntrusionAreaInfo
{
    BOOL    bEnable;                                            /* Ƿ  Supported or not */
    INT32   dwSensitivity;                                      /* ȣΧ1-100  Sensitivity */
    INT32   dwTimeThreshold;                                    /* ʱֵ Χ1-10*/
    INT32   percentage;                                         /*  Χ1-100 */
    INT32   dwPointCount;                                       /* Χ3-6ø򣬵ԣ*/
    NETDEV_INTRUSION_POINT_INFO_S   stPointInfo[NETDEV_LEN_6];  /* Ϣ */
    BYTE   byRes[64];                                           /* ֶ  Reserved */

}NETDEV_INTRUSION_AREA_INFO_S, *LPNETDEV_INTRUSION_AREA_INFO_S;

/**
* @brief ּϢ
* @attention  None
*/
typedef struct tagNETDEVIntrusionAlarmInfo
{
    BOOL    bEnable;                                                  /* Ƿ  Supported or not */
    NETDEV_INTRUSION_AREA_INFO_S stAreaInfo[NETDEV_LEN_4];            /* Ϣ ֧4ÿι area info */
    BYTE   byRes[64];                                                   /* ֶ  Reserved */
}NETDEV_INTRUSION_ALARM_INFO_S, *LPNETDEV_INTRUSION_ALARM_INFO_S;

/**
 * @brief ЭϢ  Protocol info
 * @attention  None
 */
typedef struct tagNETDEVUpnpPortState
{
    NETDEV_PROTOCOL_TYPE_E   eType;                            /* ЭͲμö# NETDEV_PROTOCOL_TYPE_E  Protocol type, see enumeration #NETDEV_PROTOCOL_TYPE_E */
    BOOL                     bEnbale;                          /* Ƿ֧  Supported or not */
    INT32                    dwPort;                           /* ˿ں  Port number */
    BYTE                     byRes[128];                       /* ֶ  Reserved */
}NETDEV_UPNP_PORT_STATE_S, *LPNETDEV_UPNP_PORT_STATE_S;


/**
 * @brief ЭϢб  Protocol info list
 * @attention  None
 */
typedef struct tagNETDEVUpnpNatState
{
    INT32   dwSize;                                            /* Э  Number of protocols */
    NETDEV_UPNP_PORT_STATE_S  astUpnpPort[NETDEV_LEN_16];      /* ЭϢ  Protocol info */
}NETDEV_UPNP_NAT_STATE_S, *LPNETDEV_UPNP_NAT_STATE_S;


/**
 * @brief 豸ֵ豸Ϣ  Info of discovered device
 * @attention  None
 */
typedef struct tagNetDEVDiscoveryDevInfo
{
    CHAR    szDevAddr[NETDEV_LEN_64];                            /* 豸ַ  Device address */
    CHAR    szDevModule[NETDEV_LEN_64];                          /* 豸ͺ  Device model */
    CHAR    szDevSerailNum[NETDEV_LEN_64];                       /* 豸к  Device serial number */
    CHAR    szDevMac[NETDEV_LEN_64];                             /* 豸MACַ  Device MAC address */
    CHAR    szDevName[NETDEV_LEN_64];                            /* 豸  Device name */
    CHAR    szDevVersion[NETDEV_LEN_64];                         /* 豸汾  Device version */
    NETDEV_DEVICE_TYPE_E  enDevType;                              /* 豸  Device type */
    INT32   dwDevPort;                                           /* 豸˿ں  Device port number */
    CHAR    szManuFacturer[NETDEV_LEN_64];                       /*  Device manufacture */
    CHAR    szActiveCode[NETDEV_LEN_64];                         /*  activeCode */
    CHAR    szCloudUserName[NETDEV_LEN_64];                       /* û cloudUserName */
    BYTE    byRes[68];                                              /* ֶ  Reserved */
}NETDEV_DISCOVERY_DEVINFO_S, *LPNETDEV_DISCOVERY_DEVINFO_S;

/**
* @brief ʱ ṹ嶨 Time parameter Structure definition
* @attention  None
*/
typedef struct tagNETDEVTime
{
    INT32   dwYear;                       /*   Year */
    INT32   dwMonth;                      /*   Month */
    INT32   dwDay;                        /*   Day */
    INT32   dwHour;                       /* ʱ  Hour */
    INT32   dwMinute;                     /*   Minute */
    INT32   dwSecond;                     /*   Second */
}NETDEV_TIME_S, *LPNETDEV_TIME_S;

/**
* @brief ʱ ṹ嶨 Time configuration structure definition
* @attention
*/
typedef struct tagNETDEVSystemTimeDST
{
    INT32 dwMonth;              /* (1~12)  Month(1~12)*/
    INT32 dwWeekInMonth;        /* ÿµĵNܣ1~5  1 for the first week and 5 for the last week in the month */
    INT32 dwDayInWeek;          /* ÿܵڼ μ#NETDEV_DAY_IN_WEEK_E  0 for Sunday and 6 for Saturday see enumeration NETDEV_DAY_IN_WEEK_E */
    INT32 dwHour;               /* ʱ  Hour */
}NETDEV_TIME_DST_S, *LPNETDEV_TIME_DST_S;

/**
* @brief ʱ ṹ嶨 Time configuration structure definition
* @attention
*/
typedef struct tagNETDEVSystemTimeDSTCfg
{
    NETDEV_TIME_DST_S   stBeginTime;        /* ʱʼʱ μö#NETDEV_TIME_DST_S  DST begin time see enumeration NETDEV_TIME_DST_S */
    NETDEV_TIME_DST_S   stEndTime;          /* ʱʱ μö#NETDEV_TIME_DST_S  DST end time see enumeration NETDEV_TIME_DST_S */
    INT32               dwOffsetTime;       /* ʱԼʱ μö# NETDEV_DST_OFFSET_TIME  DST saving time see enumeration NETDEV_DST_OFFSET_TIME */
}NETDEV_TIME_DST_CFG_S, *LPNETDEV_TIME_DST_CFG_S;

/**
* @brief ʱ ṹ嶨 Time configuration structure definition
* @attention
*/
typedef struct tagNETDEVSystemTimeInfo
{
    NETDEV_TIME_ZONE_E      dwTimeZone;             /* ʱ μö# NETDEV_TIME_ZONE_E  Time zone, see enumeration #NETDEV_TIME_ZONE_E */
    NETDEV_TIME_S           stTime;                 /* ʱ  Time */
    BOOL                    bEnableDST;             /* ʱʹ DST enable */
    NETDEV_TIME_DST_CFG_S   stTimeDSTCfg;           /* ʱ DST time config*/
    UINT32                  udwDateFormat;          /* ڸʽ 0YYYY-MM-DD  1MM-DD-YYYY  2DD-MM-YYYY */
    UINT32                  udwHourFormat;          /* ʱʽ 0 12Сʱ  1:24 Сʱ*/
    BYTE                    byRes[212];             /* ֶ  Reserved */
}NETDEV_TIME_CFG_S, *LPNETDEV_TIME_CFG_S;

/**
* @brief ʱϢ ṹ嶨 DST configuration structure definition
* @attention
*/
typedef struct tagNETDEVDSTCfgInfo
{
    BOOL                    bEnableDST;             /* ʱʹ DST enable */
    NETDEV_TIME_DST_CFG_S   stTimeDSTCfg;           /* ʱ DST time config*/
    BYTE                    byRes[128];             /* ֶ  Reserved */
}NETDEV_DST_CFG_S, *LPNETDEV_DST_CFG_S;

/**
* @brief ʱʱ ṹ嶨  Timeout structure definition
* @attention
*/
typedef struct tagNETDEVRevTimeout
{
    INT32   dwRevTimeOut;                 /* ýճʱʱ Set timeout for receiving */
    INT32   dwFileReportTimeOut;          /* ļʱʱ Set timeout for file operation */
    BYTE    byRes[128];                   /* ֶ  Reserved */
}NETDEV_REV_TIMEOUT_S, *LPNETDEV_REV_TIMEOUT_S;




/**
 * @brief ӲϸϢ Disk info
 * @attention  None
 */
typedef struct tagNETDEVDiskInfo
{
    INT32 dwDiskCabinetIndex;
    INT32 dwSlotIndex;                          /* Ӳڲλ Slot Index */
    INT32 dwTotalCapacity;                      /* Ӳ Total Capacity */
    INT32 dwUsedCapacity;                       /* Ѿʹ Used Capacity */
    NETDEV_DISK_WORK_STATUS_E enStatus;         /* ״̬ Status */
    CHAR szManufacturer[NETDEV_LEN_32];         /*  Manufacturer */
}NETDEV_DISK_INFO_S,*LPNETDEV_DISK_INFO_S;

/**
 * @brief ӲϢб Disk info list
 * @attention  None
 */
typedef struct tagNETDEVDiskInfoList
{
    INT32 dwSize;                                       /* Ӳ̸ Disk number */
    NETDEV_DISK_INFO_S astDisksInfo[NETDEV_DISK_MAX_NUM];     /* ӲϢ Disk info */
}NETDEV_DISK_INFO_LIST_S,*LPNETDEV_DISK_INFO_LIST_S;

/**
* @brief ͸Ϣ Defogging info
* @attention
*/
typedef struct tagNETDEVDefoggingInfo
{
    NETDEV_DEFOGGING_MODE_E  enDefoggingMode;           /* ģʽ Defogging mode */
    FLOAT                    fDefoggingLevel;           /* ȼ Defogging level (0.0, 1.0) */
    BYTE                     bRes[64];                  /* ֶ Reserved */
}NETDEV_DEFOGGING_INFO_S, *LPNETDEV_DEFOGGING_INFO_S;

/**
* @brief ۽Ϣ Focus Info
* @attention
*/
typedef struct tagNETDEVFocusInfo
{
    NETDEV_FOCUS_MODE_E     enFocusMode;                /* ۽ģʽ Defogging mode */
    BYTE                    bRes[16];                   /* ֶ Reserved */
}NETDEV_FOCUS_INFO_S, *LPNETDEV_FOCUS_INFO_S;


/**
* @brief ҹģʽϢ IrCut filter info
* @attention
*/
typedef struct tagNETDEVIrFilterInfo
{
    NETDEV_IR_CUT_FILTER_MODE_E enIrCutFilterMode;      /* ҹģʽ IrCut Filter mode */
    BYTE                        bRes[16];               /* ֶ Reserved */
}NETDEV_IRCUT_FILTER_INFO_S, *LPNETDEV_IRCUT_FILTER_INFO_S;

/**
* @brief ֶ¼ ṹ嶨 Manual Record structure definition
* @attention
*/
typedef struct tagNETDEVManualRecordcfg
{
    INT32                   dwChannelID;        /* ͨ  ChannelID */
    NETDEV_RECORD_TYPE_E    enRecordType;       /* ¼ Record type ο#NETDEV_RECORD_TYPE_E */
    BYTE                    byRes[64];          /* ֶ  Reserved */
}NETDEV_MANUAL_RECORD_CFG_S, *LPNETDEV_MANUAL_RECORD_CFG_S;


/**
 * @brief ²ѯ¼ֲϢ ṹ嶨 get video by Month Structure definition
 * @attention  None
 */
typedef struct tagNETDEVMonthInfo
{
    UINT32  udwYear;        /*   year*/
    UINT32  udwMonth;       /* ·  month */
    UINT32  udwPosition;    /* ¼ѯλ NETDEV_VIDEO_POSITION_E video query location */
}NETDEV_MONTH_INFO_S, *LPNETDEV_MONTH_INFO_S;

/**
 * @brief ¼ֲ״̬ ṹ嶨 video status Structure definition
 * @attention  None
 */
typedef struct tagNETDEVMonthStatus
{
    UINT32  udwDayNumInMonth;                       /* ĳµʵ The number of a month's days */
    UINT32  szVideoStatus[NETDEV_MONTH_DAY_MAX];    /* ¼״̬б video status list, see in NETDEV_VIDEO_STATUS_E */
}NETDEV_MONTH_STATUS_S, *LPNETDEV_MONTH_STATUS_S;


/**
 * @brief ͨ ṹ嶨 multichannel Structure definition
 * @attention  None
 */
typedef struct tagNETDEVChannels
{
    UINT32  udwSize;                            /* ͨ Channel size */
    INT32   dwChannelIDs[NETDEV_CHANNEL_MAX];   /* ҪѯƵͨб Channel ID list[1,2,3,4] */
}NETDEV_CHANNELS_S, *LPNETDEV_CHANNELS_S;


/**
* @brief ͳ ṹ嶨 Command of Passenger flow statistic Structure definition
* @attention  None
*/
typedef struct tagNETDEVTrafficStatisticsCond
{
    INT32       dwChannelID;            /* ͨ Channel ID */
    INT32       dwStatisticsType;       /* ͳģʽ ο# NETDEV_TRAFFIC_STATISTICS_TYPE_E Statistics type */
    INT32       dwFormType;             /* ͳƱ ο# NETDEV_FORM_TYPE_E Form type */
    INT64       tBeginTime;             /* ʼʱ Begin time */
    INT64       tEndTime;               /* ʱ End time */
}NETDEV_TRAFFIC_STATISTICS_COND_S, *LPNETDEV_TRAFFIC_STATISTICS_COND_S;

/**
* @brief ͳ ṹ嶨 Passenger flow statistic Structure definition
* @attention  None
*/
typedef struct tagNETDEVTrafficStatisticsData
{
    INT32  dwSize;                                          /*  ݲͬͳȲͬ */
    INT32  adwEnterCount[NETDEV_PEOPLE_CNT_MAX_NUM];        /* ֵ */
    INT32  adwExitCount[NETDEV_PEOPLE_CNT_MAX_NUM];         /* 뿪ֵ */
}NETDEV_TRAFFIC_STATISTICS_DATA_S, *LPNETDEV_TRAFFIC_STATISTICS_DATA_S;


/**
* @brief λϢ ṹ嶨 Geolocation info Structure definition
* @attention  None
*/
typedef struct tagNETDEVGeolocationInfo 
{
    FLOAT fLongitude;       /*  Longitude */
    FLOAT fLatitude;        /* γ Latitude */
}NETDEV_GEOLACATION_INFO_S, *LPNETDEV_GEOLACATION_INFO_S;

/**
* @brief WIFISnifferMacϢ ṹ嶨  WIFISnifferMac info Structure definition 
* @attention  None
*/
typedef struct tagNETDEVWiFiSnifferMacInfo
{
    CHAR  aszMACInfo[NETDEV_WIFISNIFFER_MAC_MAX_NUM];     /* WiFi sniffer mac ַ WiFi sniffer mac address*/
    INT16 wMaxSig;                                        /* MacַӦźǿ,λdBm Mac address corresponding max signal strength (in dBm) */
    CHAR  aszMaxSigTime[NETDEV_MAX_DATE_STRING_LEN];      /* MacַӦźǿȻȡʱ Time to obtain Mac address corresponding max signal strength*/
}NETDEV_WIFISNIFFER_MAC_INFO_S, *LPNETDEV_WIFISNIFFER_MAC_INFO_S;

/**
* @brief WIFISnifferMacϢ ṹ嶨 WIFISnifferMac array Structure definition  
* @attention  None
*/
typedef struct tagNETDEVWiFiSnifferMacList
{
    INT32 dwSize;
    NETDEV_WIFISNIFFER_MAC_INFO_S  astMACList[NETDEV_WIFISNIFFER_MAC_ARRY_MAX_NUM];
}NETDEV_WIFISNIFFER_MAC_LIST_S, *LPNETDEV_WIFISNIFFER_MAC_LIST_S;


typedef struct tagNETDEVAlarmSnapShotCond
{
    INT32                           dwChannelID;                                /* ͨ  Channel number  澯ţΪͨ*100+ţ豸ͨΪ0*/
    INT64                           tAlarmTime;                                 /* 澯ʱ */
    NETDEV_ALARM_SNAPSHOT_TYPE_E    enAlarmType;                                /* 澯 */
    BYTE                            byRes[244];                                 /* ֶ  Reserved */
}NETDEV_ALARM_SNAPSHOT_COND_S,*LPNETDEV_ALARM_SNAPSHOT_COND_S;

typedef struct tagNETDEVAlarmSnapShotPicInfo
{
    CHAR    szURL[NETDEV_MAX_URL_LEN];  /* ͼƬURL */
    CHAR    szName[NETDEV_LEN_64];      /* ͼƬ */
    INT32   dwSize;                     /* ͼƬС */
    BYTE    byRes[256];                 /* ֶ  Reserved */
}NETDEV_ALARM_SNAPSHOT_PIC_S,*LPNETDEV_ALARM_SNAPSHOT_PIC_S;

typedef struct tagNETDEVSnapShotFileInfo
{
    CHAR    szURL[NETDEV_MAX_URL_LEN];         /* ͼƬURL */
    BOOL    bSaveLocal;                        /* Ƿ񱣴ڱأTUREʾ汾أFALSEʾд뻺 */
    CHAR    szFileName[NETDEV_LEN_260];        /* ͼƬı· */
    CHAR*   pcBuffer;                          /* ͼƬ,ͻڴ棬СΪdwSizeС */
    INT32   dwSize;                            /* С */
    INT32   dwCaptureMode;                     /* ͼʽ,μ#NETDEV_PICTURE_FORMAT_E*/
    BYTE    byRes[252];                        /* ֶ  Reserved */
}NETDEV_PIC_FILE_INFO_S, *LPNETDEV_PIC_FILE_INFO_S;

/************************************************************************/
/*                       NVRܼƻ                                  */
/************************************************************************/

/**
 * @brief ʱ ṹ嶨 Time Sections Structure definition
 * @attention  None
 */
typedef struct tagNETDEVVideoTimeSection
{
    CHAR    szBeginTime[NETDEV_LEN_64];              /* ʼʱ  Begin time */
    CHAR    szEndTime[NETDEV_LEN_64];                /* ʱ  End time */
    UINT32  udArmingType;                            /*    ArmingType οNETDEV_ARMING_TYPE_E */
}NETDEV_VIDEO_TIME_SECTION_S, *LPNETDEV_VIDEO_TIME_SECTION_S;

/**
 * @brief ƻ죩 ṹ嶨 Play (Day) Structure definition
 * @attention  None
 */
typedef struct tagNETDEVVideoDayPlan
{
    UINT32                         udwIndex;                                                  /* ,μNETDEV_LAPI_WEEK_INFO_E  day index */
    UINT32                         udwSectionNum;                                             /* ÿʱθ  Section Num NVRΪ8,IPCΪ4 */
    NETDEV_VIDEO_TIME_SECTION_S    astTimeSection[NETDEV_MAX_TIME_SECTION_NUM];   /* ʱ  Time Sections */
}NETDEV_VIDEO_DAY_PLAN_S, *LPNETDEV_VIDEO_DAY_PLAN_S;

/**
 * @brief  ƻܣ ṹ嶨  Plan (Week) Structure definition
 * @attention  None
 */
typedef struct tagNETDEVVideoPlanWeek
{
    BOOL                        bEnabled;                                            /* ƻǷʹ,IPC֧ʹܿ VMS NVRĬʹ;οNETDEV_DEFENCE_PLAN_ENABLE_E */
    UINT32                      udwDayNum;                                           /* ƻ,NVRΪ8(һͼ);IPCΪ7(һ) */
    NETDEV_VIDEO_DAY_PLAN_S     astDayPlan[NETDEV_MAX_DAY_NUM];                      /* һÿĲƻб */
    BYTE                        byRes[32];                                           /* ֶ */
}NETDEV_VIDEO_WEEK_PLAN_S, *LPNETDEV_VIDEO_WEEK_PLAN_S;

/**
 * @brief  ¼ƻ ṹ嶨   Record Rule Structure definition
 * @attention  None
 */
typedef struct tagNETDEVRecordRule
{
    UINT32                      udwPreRecordTime;                                  /* ǰԤ¼ʱ,οNETDEV_PRE_RECORD_TIME_E */
    UINT32                      udwPostRecordTime;                                 /* ¼ʱ,οNETDEV_POST_RECORD_TIME_E */
    BYTE                        byRes[32];                                         /* ֶ */
}NETDEV_RECORD_RULE_S, *LPNETDEV_RECORD_RULE_S;

/**
 * @struct tagstNETDEVTimeTemplate
 * @brief ʱģϢ
 * @attention
 */
typedef struct tagstNETDEVTimeTemplate
{
    CHAR    szTamplateName[NETDEV_NAME_MAX_LEN];        /* ģ */
    CHAR    szTamplateDesc[NETDEV_DESCRIBE_MAX_LEN];    /* ģ */
    INT32   dwTamplateID;                               /* ģID */
}NETDEV_TIME_TEMPLATE_S, *LPNETDEV_TIME_TEMPLATE_S;

/**
 * @brief  ¼ƻϢ ṹ嶨   Record plan config info Structure definition
 * @attention  None
 */
typedef struct tagNETDEVRecordPlanCfgInfo
{
    BOOL                       bPlanEnable;                                        /* ƻʹ */
    BOOL                       bRedundantStorage;                                  /* ¼ʹ NVR֧ */
    NETDEV_RECORD_RULE_S       stRecordRule;                                       /* ¼ƻ NVR֧ */
    NETDEV_VIDEO_WEEK_PLAN_S   stWeekPlan;                                         /* ƻ NVR֧ */
    UINT32                     udwChlID;                                           /* Ƶͨ ȡ/ʱʹ */
    UINT32                     udwReqSeq;                                          /*  [1, 50] VMS֧ ¼ƻPostѡ */
    UINT32                     udwTamplateID;                                      /* ʱģID VMS֧ */
    CHAR                       szTamplateName[NETDEV_NAME_MAX_LEN];                /* ʱģ VMS֧ Getӿڷ */
    BYTE                       byRes[116];                                         /* ֶ */
}NETDEV_RECORD_PLAN_CFG_INFO_S, *LPNETDEV_RECORD_PLAN_CFG_INFO_S;

/**
 * @brief  ¼ƻϢб ṹ嶨   Record plan config info Structure definition list
 * @attention  None
 */
typedef struct tagNETDEVRecordPlanCfgList
{
    UINT32                              udwNum;                             /* ͨ¼ƻ */
    LPNETDEV_RECORD_PLAN_CFG_INFO_S     pstRecordScheduleList;              /* ͨ¼ƻб Mallocڴ */
    BYTE                                byRes[256];                         /* ֶ */
}NETDEV_RECORD_PLAN_CFG_LIST_S, *LPNETDEV_RECORD_PLAN_CFG_LIST_S;

/**
 * @brief  澯Ϣ ṹ嶨 Alarm infomation Sturcture definition
 * @attention  None
 note:
 1. dwAlarmSrcTypeΪNETDEV_ALARM_SRC_LOCAL_HARD_DISKNETDEV_ALARM_SRC_SD_STORAGE_DISK֮䣬dwChannelID洢
 2. dwAlarmSrcTypeΪ8dwChannelIDƵͨţ
 3. dwAlarmSrcTypeΪ9dwChannelIDͨţԴdwInputSwitchIDֶΡ
 4. dwAlarmSrcTypeΪ10,dwChannelIDĬΪ0,ϵͳ
 */
typedef struct tagNETDEVAlarmInfoEx
{ 
    INT32   dwAlarmType;                        /* 澯,μö# NETDEV_ALARM_TYPE_E  Alarm type, see enumeration #NETDEV_ALARM_TYPE_E */
    INT64   tAlarmTime;                         /* 澯ʱ  Alarm time */
    INT32   dwChannelID;                        /* ͨ */
    INT32   dwAlarmSrcType;                     /* 澯Դ μö#NETDEV_ALARM_SRC_TYPE_E */
    CHAR    szAlarmSrcName[NETDEV_LEN_132];     /* 澯Դ,澯ԴЧNETDEV_ALARM_SRC_INVALIDʱЧ */
    UINT16  wIndex;                             /*   Index number, index number */
    INT32   dwTotalBandWidth;                   /* ǰ,λΪMBps  Current total bandwidth (in MBps) */
    INT32   dwUnusedBandwidth;                  /* δʹõĴ,λΪMBps  Bandwidth left (in MBps)*/
    INT32   dwTotalStreamNum;                   /* · Total cameras*/
    INT32   dwFreeStreamNum;                    /* δʹ· Cameras left */
    INT32   dwMediaMode;                        /* ,μö# NETDEV_MEDIA_MODE_E Stream type. For enumerations, see#NETDEV_MEDIA_MODE_E*/
    INT32   dwAlarmLevel;                       /* 澯ȼ0:һ 1: 2: 3:ļ 4:弶  һ,һ弶س̶ȵݼ */
    INT32   dwAlarmSeq;                         /* 澯 */
    INT32   dwEventCode;                        /* ¼ͣϱ¼,μö#NETDEV_PLAYER_RUN_INFO_TYPE_E */
    BYTE    byRes[244];                         /* ֶ */
}NETDEV_ALARM_INFO_EX_S, *LPNETDEV_ALARM_INFO_EX_S;

/**
* @enum tagNETDEVLapiSubInfo
* @brief Lapi澯Ϣ
* @attention  None
*/
typedef struct tagNETDEVLapiSubInfo
{
    UINT32 udwType;                          /*  λʾ 
                                                Bit0豸״̬͸澯
                                                Bit1ҵ澯
                                                Bit2ܸ澯
                                                Bit3澯
                                                Bit4ʶ
                                                Bit5ṹ ·0ȫ
                                                Bit6ʶ
                                                Bit7ͨ
                                                Bit8
                                                Bit9Դ
                                                Bit10Ա 
                                                Bit10Ա 
                                                BIT11:ͣʶץ ö NETDEV_LAPI_SUB_TYPE_E
                                                Bit12澯 */
    UINT32 udwLibIDNum;                      /* ĵĿIDĿ LibIDNumΪ0xffffʱ ʾп */
    UINT32 audwLibIDList[NETDEV_LEN_32];     /* ĵĿIDб */
    BYTE   byRes[132];                       /* ֽ */
}NETDEV_LAPI_SUB_INFO_S,*LPNETDEV_LAPI_SUB_INFO_S;

/**
* @enum tagNETDEVSubscribeSuccInfo
* @brief ϢɹϢ
* @attention  None
*/
typedef struct tagNETDEVSubscribeSuccInfo
{
    UINT32 udwID;                      /* ID */
    UINT32 udwCurrrntTime;             /* ǰʱ䣬UTCʽ1970110㿪ʼ */
    UINT32 udwTerminationTime;         /* ʱ䣬UTCʽ1970110㿪ʼ */
    UINT32 udwSupportAlarmType;        /* ϢЯĸ澯ʱֵЯ˲0˵ӦδЯ */
    CHAR   szReference[NETDEV_LEN_260];/* Ϣ URLʽ */
    BYTE   byRes[124];                 /* ֽ */
}NETDEV_SUBSCRIBE_SUCC_INFO_S,*LPNETDEV_SUBSCRIBE_SUCC_INFO_S;

/**
* @struct tagNETDEVResInfo
* @brief ԴݱϢ ṹ嶨
* @attention 
*/
typedef struct tagNETDEVResInfo
{
    UINT32   udwResType;                              /* Դ, ο# NETDEV_RES_TYPE_E */
    UINT32   udwResID;                                /* ԴID */
    BYTE     byRes[256];                              /* ֶ  Reserved */
}NETDEV_RES_CHANGE_INFO_S, *LPNETDEV_RES_CHANGE_INFO_S;

/**
* @struct tagNETDEVResChangeEventInfo
* @brief Դ¼ ṹ嶨
* @attention 
*/
typedef struct tagNETDEVResChangeEventInfo
{
    CHAR     szReference[NETDEV_LEN_260];                           /* ڿͻȷ͸澯¼Ϣurl
                                                                    <SubscribersID>:ͬһIPportû½ʱֲͬĶĿͻ*/
    UINT32   udwAction;                                             /* Դ¼, ο# NETDEV_RES_CHANGE_SUBEVENT_TYPE_E */
    UINT32   udwNum;                                                /* Դ*/
    NETDEV_RES_CHANGE_INFO_S   audwResInfos[NETDEV_CHANNEL_MAX];    /* ԴݱϢ*/
    BYTE     byRes[256];                                            /* ֶ  Reserved */
}NETDEV_RES_CHANGE_EVENT_INFO_S, *LPNETDEV_RES_CHANGE_EVENT_INFO_S;


/**
 * @brief ƶ豸¼Ϣ    Cloud Device information Structure definition
 * @attention  None
 */
typedef struct tagNetDEVCloudDevLoginInfo
{

    CHAR    szDeviceName[NETDEV_LEN_260];       /* 豸 Device name */
    CHAR    szDevicePassword[NETDEV_LEN_64];    /* 豸¼ (ѡ) Device login password (optional) */
    INT32   dwT2UTimeout;                       /* P2Pʱʱ, ĬΪ15s P2P timeout (default: 15s) */
    INT32   dwConnectMode;                      /* ģʽ Connect Mode  μö NETDEV_CLOUD_CONNECT_MODE   NETDEV_CLOUD_CONNECT_MODE_ALLʱ޷׼ȷȡյ½ɵģʽʱ򶴻ת*/
    NETDEV_LOGIN_PROTO_E dwLoginProto;          /* ¼Э, μNETDEV_LOGIN_PROTO_E */
    BYTE  byRes[252];                           /* ֶ */
} NETDEV_CLOUD_DEV_LOGIN_INFO_S, *LPNETDEV_CLOUD_DEV_LOGIN_INFO_S;


/**¼ٶŻ
 * @brief ¼Ϣ ṹ嶨 Device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVLoginInfo
{
    UINT32 LoginType;                               /* ¼ οö#NETDEV_LOGIN_TYPE_E */
    LPVOID lpUserID;                                /* ƶ˻¼ID User login ID */
    LPNETDEV_CLOUD_DEV_LOGIN_INFO_S pstCloudInfo;   /* pstCloudInfoƶ豸¼Ϣ */
    INT32 dwCloudFunVersion;                        /* ڲ,ƶ˽ӿڰ汾, μNETDEV_CLOUD_FUN_VERSION_E */
    INT32 dwShareSrcType;                           /* ڲ,Դ, μNETDEV_CLOUD_SHARE_SRC_TYPE_E */
    CHAR szDevIP[NETDEV_LEN_64];                    /* 豸IP Device IP */
    CHAR szUserName[NETDEV_LEN_64];                 /* û User Name */
    CHAR szPassword[NETDEV_LEN_64];                 /*  Password */
    INT32 dwDevPort;                                /* 豸˿ Device Server Port */
    INT32   dwDevType;                              /* 豸,μö#NETDEV_DEVICETYPE_E  Device type, see enumeration #NETDEV_DEVICETYPE_E */
    INT32   dwChannelNum;                           /* ͨ  Number of Channels */
    CHAR szRegisterCode[NETDEV_LEN_64];             /* 豸ע */
    CHAR szDeviceSN[NETDEV_LEN_64];                 /* 豸SN Device SN */
    UINT32 udwAccessType;                           /* Э μNETDEV_ACCESS_PROTOCOL_E */ 
    UINT32 udwRemainLockTimes;                      /* ûȫ¼ */
    UINT32 udwRemainUnlockTime;                     /* ûȫ¼ʱ */
    BYTE byRes[356];                                /* ֶ  Reserved */
}NETDEV_LOGIN_INFO_S,*LPNETDEV_LOGIN_INFO_S;

/**
* @brief  豸ͨӦ ṹ嶨
* @attention  None
*/
typedef struct tagNETDEVResponse
{
    CHAR szUserName[NETDEV_CLOUD_SHARE_TARGET_NAME_LEN];                   /*  */
    CHAR szDescription[NETDEV_CLOUD_SHARE_DESCRIBE_LEN];                   /* ʧԭ */
    BYTE byRes[128];                                                       /* ֶ */
}NETDEV_RESPONSE_S,*LPNETDEV_RESPONSE_S;

/**
* @brief  Ϣ
* @attention  None
*/
typedef struct tagNETDEVLimitInfo
{
    INT64   tValidTimeSecond;                                             /* Чʱ λ */
    CHAR    szPermission[NETDEV_CLOUD_DEV_USER_AUTH_LEN];                   /* Ȩ */
    CHAR    szChannelNum[NETDEV_DEV_OTHER_LEN_MAX];                         /* ͨ */
    CHAR    szChannelName[NETDEV_CLOUD_SHARE_TARGET_NAME_LEN];              /* ͨ */
    CHAR    szDescription[NETDEV_CLOUD_SHARE_DESCRIBE_LEN];                 /*  */
    BYTE    byRes[128];                                                     /* ֶ */
}NETDEV_LIMIT_INFO_S,*LPNETDEV_LIMIT_INFO_S;

/**
* @brief  豸ͨϢ ṹ嶨
* @attention  None
*/
typedef struct tagNETDEVChannelShareInfo
{
    CHAR                    szDevName[NETDEV_DEV_NAME_LEN_MAX];             /* 豸 */
    CHAR                    szUserName[NETDEV_CLOUD_USER_NAME_LEN];         /* û */
    NETDEV_LIMIT_INFO_S     stLimitInfo;                                    /* Ϣ */
    CHAR                    szEZPassword[NETDEV_DEV_PASSWORD_LEN_MAX];      /* EZCloud */
    CHAR                    szEZUserName[NETDEV_CLOUD_USER_NAME_LEN];       /* EZCloudû */
    BYTE                    byRes[128];                                     /* ֶ */
}NETDEV_CHANNEL_SHARE_INFO_S,*LPNETDEV_CHANNEL_SHARE_INFO_S;

/**
* @brief   Ϣ ṹ嶨
* @attention  None
*/
typedef struct tagNETDEVShareLimitInfo
{
    CHAR    szUserName[NETDEV_CLOUD_USER_NAME_LEN];             /* û */
    CHAR    szUserPhone[NETDEV_DEV_OTHER_LEN_MAX];              /* ֻ */
    CHAR    szUserMail[NETDEV_DEV_OTHER_LEN_MAX];               /* ַ */
    INT64   tValidTimeSecond;                                   /* Чʱ λ */
    INT64   tVaildTimeSlot;                                     /* Чʱ λ */
    CHAR    szPermission[NETDEV_CLOUD_DEV_USER_AUTH_LEN];       /* Ȩ */
    INT64   dwChannelNum;                                       /* ͨ */
    CHAR    szDescription[NETDEV_CLOUD_SHARE_DESCRIBE_LEN];     /*  */
    CHAR    szChannelName[NETDEV_CLOUD_SHARE_TARGET_NAME_LEN];  /* ͨ */
    BYTE    byRes[64];                                          /* ֶ */
}NETDEV_SHARE_LIMIT_INFO_S,*LPNETDEV_SHARE_LIMIT_INFO_S;

/**
* @brief ƶ˹豸Ϣ ṹ嶨
* @attention  None
*/
typedef struct tagNETDEVDevInfo
{
    CHAR    szDevName[NETDEV_DEV_NAME_LEN_MAX];     /* 豸 */
    CHAR    szDevAlias[NETDEV_DEV_OTHER_LEN_MAX];   /* 豸 */
    INT32   dwSize;                                 /* Ƽ¼ */
    BYTE    byRes[128];                             /* ֶ */
}NETDEV_DEV_INFO_S,*LPNETDEV_DEV_INFO_S;

/**
* @brief ȡ豸/ͨ ṹ嶨
* @attention  None
*/
typedef struct tagNETDEVDeleteShareChannelInfo
{
    CHAR szDevOwner[NETDEV_DEV_OTHER_LEN_MAX];          /* 豸߱ʶλ */
    CHAR szDevName[NETDEV_DEV_NAME_LEN_MAX];            /* 豸 */
    CHAR szChannelNum[NETDEV_DEV_OTHER_LEN_MAX];        /* ͨ */
    CHAR szUserName[NETDEV_DEV_OTHER_LEN_MAX];          /* ȡʶλ */
    CHAR szEZPassword[NETDEV_DEV_PASSWORD_LEN_MAX];     /* EZCloud */
    CHAR szEZUserName[NETDEV_CLOUD_USER_NAME_LEN];      /* EZCloudû */
    BYTE byRes[128];                                    /* ֶ */
}NETDEV_DELETE_SHARE_CHANNEL_INFO_S,*LPNETDEV_DELETE_SHARE_CHANNEL_INFO_S;



/**
 * @brief ƶ豸Ϣ ṹ嶨 Cloud Device information Structure definition
 * @attention ,ʹ
 */
typedef struct tagNETDEVCloudDevInfo
{
    CHAR    szIPAddr[NETDEV_IPADDR_STR_MAX_LEN];            /* 豸IP */
    CHAR    szDevUserName[NETDEV_LEN_260];                  /* 豸û */
    CHAR    szDevName[NETDEV_LEN_260];                      /* 豸 */
    CHAR    szDevModel[NETDEV_LEN_64];                      /* 豸ͺ */
    CHAR    szDevSerialNum[NETDEV_LEN_64];                  /* 豸к */
    INT32   dwOrgID;                                        /* ֯ID */
    INT32   dwDevPort;                                      /* 豸˿ */
    BOOL    bIsOnline;                                      /* 豸Ƿ */
    INT32   dwConnectMode;                                  /* ģʽ Connect Mode*/
    INT32   dwDisTributeCloud;                               /* ַģʽ  μö NETDEV_DISTRIBUTE_CLOUD_SRV_E*/
    BYTE    byRes[256];
}NETDEV_CLOUD_DEV_INFO_S,*LPNETDEV_CLOUD_DEV_INFO_S;

/**
 * @brief ƶ豸Ϣ ṹ嶨 
 * @attention  None
 */
typedef struct tagNETDEVCloudDevUserAuthority
{
    CHAR    szDevUserAuth[NETDEV_CLOUD_DEV_USER_AUTH_LEN];            /* 豸ûȨ */
    BYTE    byRes[512];
}NETDEV_CLOUD_DEV_USER_AUTH_S, *LPNETDEV_CLOUD_DEV_USER_AUTH_S;

/**
 * @brief ƶ豸Ϣ ṹ嶨 Cloud Device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVCloudDevShareInfo
{
    BOOL    bIsShareDev;                                    /* 豸־λ */
    INT64   tValidTimeSecond;                               /* Ч λ */
    CHAR    szDevUserName[NETDEV_CLOUD_DEV_USER_NAME_LEN];  /* 豸ID */
    CHAR    szCloudUserName[NETDEV_CLOUD_USER_NAME_LEN];    /* 豸˺ */
    INT32   dwUserAuthSize;                                 /* 豸ûȨ޸ */
    LPNETDEV_CLOUD_DEV_USER_AUTH_S pstUserAuth;             /* 豸ûȨб ȨбڴdwUserAuthoritySizeӦٷ128 */
}NETDEV_CLOUD_DEV_SHARE_INFO_S,*LPNETDEV_CLOUD_DEV_SHARE_INFO_S;


 /**
 * @brief ƶ豸 
 * @attention  None
 */
typedef struct tagNETDEVCloudDevShareTarget
{
    CHAR    szName[NETDEV_CLOUD_SHARE_TARGET_NAME_LEN];     /*  */
    INT32   dwResultCode;                                   /*  0:ɹ, :ʧ(ƶ豸ش NETDEV_E_CLOUD_INVALID_REG_CODE) */
    BYTE    byRes[128];                                     /* ֶ */
}NETDEV_CLOUD_DEV_SHARE_TARGET_S, *LPNETDEV_CLOUD_DEV_SHARE_TARGET_S;

 /**
 * @brief ƶ豸б 
 * @attention  None
 */
typedef struct tagNETDEVCloudDevShareTargetList
{
    INT32                               dwSize;         /*  */
    LPNETDEV_CLOUD_DEV_SHARE_TARGET_S   pstTarget;      /*  ûsizeڴ */
    BYTE                                byRes[128];
}NETDEV_CLOUD_DEV_SHARE_TARGET_LIST_S, *LPNETDEV_CLOUD_DEV_SHARE_TARGET_LIST_S;

 /**
 * @brief ƶ˹豸Ϣ
 * @attention  None
 */
typedef struct tagNETDEVCloudDevShareCfg
{
    INT64 tValidTimeSecond;                                /* Чʱ λ */
    CHAR  szDevUserAuth[NETDEV_CLOUD_DEV_USER_AUTH_LEN];   /* 豸ûȨ */
    CHAR  szDescribe[NETDEV_CLOUD_SHARE_DESCRIBE_LEN];     /*  */
    CHAR  szDevUserName[NETDEV_CLOUD_DEV_USER_NAME_LEN];   /* 豸ID */
    NETDEV_CLOUD_DEV_SHARE_TARGET_LIST_S  stTargetList;    /* б */
}NETDEV_CLOUD_DEV_SHARE_CFG_S,*LPNETDEV_CLOUD_DEV_SHARE_CFG_S;

 /**
 * @brief ƶ豸¼Ϣ 
 * @attention  None
 */
typedef struct tagNETDEVCloudDevShareRecord
{
    INT64 tValidTimeSecond;                                                /* Чʱ λ */
    CHAR  szTargetUserName[NETDEV_CLOUD_SHARE_TARGET_NAME_LEN];            /* û */
    CHAR  szTargetPhoneNum[NETDEV_CLOUD_SHARE_TARGET_NAME_LEN];            /* ֻ */
    CHAR  szTargetMailNum[NETDEV_CLOUD_SHARE_TARGET_NAME_LEN];             /*  */
    CHAR  szDevName[NETDEV_CLOUD_DEV_NAME_LEN];                            /* 豸 */
    CHAR  szDevUserName[NETDEV_CLOUD_DEV_USER_NAME_LEN];                   /* 豸û */
    CHAR  szDevUserAuth[NETDEV_CLOUD_DEV_USER_AUTH_LEN];                   /* 豸ûȨ */
    CHAR  szDescribe[NETDEV_CLOUD_SHARE_DESCRIBE_LEN];                     /*  */
}NETDEV_CLOUD_DEV_SHARE_RECORD_S, *LPNETDEV_CLOUD_DEV_SHARE_RECORD_S;

 /**
 * @brief ƶ豸 
 * @attention  None
 */
typedef struct tagNETDEVBatchCloudDevInfo
{
    CHAR  szDevUserName[NETDEV_CLOUD_DEV_NAME_LEN];              /* 豸 */
    INT32 dwResultCode;                                       /*  0:ɹ, :ȡ豸ʧ(ƶ豸ش NETDEV_E_CLOUD_INVALID_REG_CODE) */
}NETDEV_BATCH_CLOUD_DEV_INFO_S, *LPNETDEV_BATCH_CLOUD_DEV_INFO_S;

/**
 * @brief ƶ豸б
 * @attention  None
 */
typedef struct tagNETDEVBatchCloudDevList
{
    UINT32                              udwSize;            /* ƶ豸64 */
    LPNETDEV_BATCH_CLOUD_DEV_INFO_S     pstBatchDevInfo;    /* ƶ豸ָ룬û̬ڴ,ڴСudwSizeӦ */
}NETDEV_BATCH_CLOUD_DEV_LIST_S, *LPNETDEV_BATCH_CLOUD_DEV_LIST_S;

 /**
 * @brief رƶ˹豸Ϣ
 * @attention  None
 */
typedef struct tagNETDEVBatchDevShareInfo
{
    CHAR szDevUserName[NETDEV_CLOUD_DEV_NAME_LEN];                /* ƶ豸ID */
    NETDEV_CLOUD_DEV_SHARE_TARGET_LIST_S  stTargetList;           /* б  */
 }NETDEV_BATCH_DEV_SHARE_INFO_S,*LPNETDEV_BATCH_DEV_SHARE_INFO_S;

 /**
 * @brief رƶ˹豸Ϣб
 * @attention  None
 */
typedef struct tagNETDEVBatchDevShareList
{
    BOOL    bIsStopedByOwner;                                   /* Ƿ豸߹رչ bIsStopedByOwnerFALSEʱһpstTargetΪգ */
    UINT32  udwSize;                                            /* 豸 */
    LPNETDEV_BATCH_DEV_SHARE_INFO_S  pstBatchDevShareInfo;      /* رƶ˹豸Ϣ */
}NETDEV_BATCH_DEV_SHARE_LIST_S,*LPNETDEV_BATCH_DEV_SHARE_LIST_S;



/**
 * @brief ƶ豸֯Ϣ ṹ嶨 
 * @attention  None
 */
typedef struct tagNETDEVCloudOrgInfoEx
{
    INT32   dwOrgID;                        /* ֯ID */
    INT32   dwOrgParentID;                  /* ڸ豸ID */
    CHAR    szOrgName[NETDEV_LEN_260];      /* ֯ */
    BYTE    byRes[128];                     /* ֶ */
}NETDEV_CLOUD_ORG_INFO_S,*LPNETDEV_CLOUD_ORG_INFO_S;


/**
 * @brief ƶ豸֯Ϣ ṹ嶨 
 * @attention  None
 */
typedef struct tagNETDEVCloudDevBindInfo
{
    CHAR szDevRegisterCode[NETDEV_LEN_64];      /* 豸ע */
    CHAR szDevAlias[NETDEV_LEN_64];             /* 豸 */
    CHAR szDevCloudUsername[NETDEV_LEN_64];     /* 豸û */
    CHAR szDevSerialNum[NETDEV_LEN_64];         /* 豸к */
    CHAR szDevModel[NETDEV_LEN_64];             /* 豸ͺ Device model */
    BYTE byRes[256];                            /* ֶ */
}NETDEV_CLOUD_DEV_BASE_INFO_S,*LPNETDEV_CLOUD_DEV_BASE_INFO_S;


/**
 * @brief 豸ַϢṹ
 * @attention None
 */
typedef struct tagNETDEVCloudDevDistributeInfo
{
    INT32   dwDistributeCloud;                          /* ֵ֧ķַ̣οöNETDEV_DISTRIBUTE_CLOUD_SRV_E */
    INT32   dwBitrateLimit;                             /* (λKbps) */
    INT32   dwDistributeMode;                           /* ַģʽοöNETDEV_DISTRIBUTE_MODE_E */
    CHAR    szDevDistributeCap[NETDEV_LEN_64];          /* 豸ַ */
    BYTE    byRes[128];                                 /* ֶ Reserved */
}NETDEV_CLOUD_DEV_DISTRIBUTE_INFO_S,*LPNETDEV_CLOUD_DEV_DISTRIBUTE_INFO_S;

/**
 * @brief ͨƵϢ ṹ嶨 Channel video stream information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVVideoStreamInfo
{
    NETDEV_LIVE_STREAM_INDEX_E  enStreamType;       /*   Stream index */
    INT32                       bEnableFlag;        /* Ƿ  Enable or not */
    INT32                       dwHeight;           /* Ƶֱ-Height  Video encoding resolution - Height */
    INT32                       dwWidth;            /* Ƶֱ-Width  Video encoding resolution - Width */
    INT32                       dwFrameRate;        /* Ƶ֡  Video encoding configuration frame rate */
    INT32                       dwBitRate;          /*   Bit rate */
    NETDEV_VIDEO_CODE_TYPE_E    enCodeType;         /* Ƶʽ  Video encoding format */
    NETDEV_VIDEO_QUALITY_E      enQuality;          /* ͼ  Image quality */
    INT32                       dwGop;              /* I֡  I-frame interval */
    BOOL                        bConstantBitRate;   /* ǷΪ 0: 1: Constant Bit Rate or Variable bit rate;0:Variable 1:Constant*/
    BYTE                        byRes[28];          /* ֶ  Reserved */
}NETDEV_VIDEO_STREAM_INFO_S, *LPNETDEV_VIDEO_STREAM_INFO_S;

/**
 * @brief ƶ豸ͨϢṹ嶨
 * @attention None
 */
 typedef struct tagNETDEVCloudDevChlInfo
{
    INT32                          dwChannelID;                         /* ͨID */
    CHAR                           szChannelSN[NETDEV_LEN_260];         /* ͨIPCк */
    CHAR                           szChannelName[NETDEV_LEN_260];       /* ͨ */
    NETDEV_VIDEO_STREAM_INFO_S     astStreamInfo[NETDEV_LEN_8];         /* Ϣб */
    BOOL                           bChannelStatus;                      /* ͨ״̬ */
    BYTE                           byRes[128];                          /* ֶ */
}NETDEV_CLOUD_DEV_CHL_INFO_S,*LPNETDEV_CLOUD_DEV_CHL_INFO_S;

/**
 * @brief ҳѯϢṹ
 * @attention None
 */
typedef struct tagNETDEVPageQueryCond
{
    INT32   dwQueryCond;        /* ѯ0豸״̬1豸֯ */
    INT32   dwSubQueryCond;     /* ǰѯֵ,ڲ˵ѯ豸״̬:0ʾߣ1ʾ */
    INT32   dwLogicalType;      /* ѯ߼:μö#NETDEV_QUERYCOND_LOGICTYPE_E */
    BYTE    byRes[128];         /* ֶ */
}NETDEV_PAGE_FIND_LOGIC_S,*LPNETDEV_PAGE_FIND_LOGIC_S;


/** 
 * @brief ҳѯϢṹ
 * @attention None
 */
typedef struct tagNETDEVPageQueryInfo
{
    INT32   dwLimitNum;                                          /* ҳѯ豸ο#NETDEV_PAGE_QUERY_CAP_INFO_SṹdwSuggestSinglePageQuantilyֵС*/
    INT32   dwStartID;                                           /* ҳѯ豸ʼid,ѯпϴηҳѯȡһ豸еidֶ+1Ϊ˴βѯĿʼid*/
    INT32   dwCondNum;                                           /* ѯ */
    NETDEV_PAGE_FIND_LOGIC_S  astFindCond[NETDEV_LEN_16];        /* ѯϢб,ѯΪ16,ѯΪ0ʱ,˽ڵѡ */
    BYTE    byRes[128];                                          /* ֶ*/
}NETDEV_PAGE_FIND_COND_S,*LPNETDEV_PAGE_FIND_COND_S;

/**
 * @brief ҳѯϢṹ
 * @attention None
 */
typedef struct tagNETDEVCloudDevPopulationInfo
{
    INT32   dwDevTotalNum;          /* ǰ˺е豸 */
    INT32   dwDevOfflineNum;        /* ǰ˺豸 */
    BYTE    byRes[128];             /* ֶ */
}NETDEV_CLOUD_DEV_POPUL_INFO_S,*LPNETDEV_CLOUD_DEV_POPUL_INFO_S;

/**
 * @struct tagNETDEVCloudMobileInfo
 * @brief նϢ
 * @attention  None
 */
typedef struct tagNETDEVCloudMobileInfo
{
    CHAR    szMobileModule[NETDEV_LEN_32];                      /* նź Module of Terminal */
    CHAR    szSystemType[NETDEV_LEN_16];                        /* ϵͳ System Type of Terminal */
    CHAR    szSystemVersion[NETDEV_LEN_16];                     /* ϵͳ汾 System Version of Terminal */
    BOOL    bDonotDisturb;                                      /* ű־ Flag of Do Not Disturb */
    BOOL    bPushBuiltFlag;                                     /* ӽʶ Flag of push connected,Ture means Long Link*/
    CHAR    szAppName[NETDEV_LEN_32];                           /* App App Name */
    CHAR    szAppLanguage[NETDEV_LEN_32];                       /* AppԻ App Language. ex:en-us|zh-cn */
    CHAR    szAppVersion[NETDEV_LEN_16];                        /* App汾Ϣ App Version */
    BOOL    bIosEnvir;                                          /* IOSĻ־ environment of IOS, True:Production False:Development*/
    BYTE    byRes[256];                                         /* ֶ Reserved */
}NETDEV_CLOUD_MOBILE_INFO_S,*LPNETDEV_CLOUD_MOBILE_INFO_S;

/**
 * @struct tagNETDEVCloudLimitInfo
 * @brief նϢ
 * @attention  None
 */
typedef struct tagNETDEVCloudLimitInfo
{
    UINT32  udwMaxDeviceNum;                                    /* 豸 Max Num of Online Device */
    UINT32  udwMaxAppTimeS;                                     /* Appʹʱ() Max Time of App Cost */
    UINT32  udwMaxRTSNum;                                       /* ʵ Max Num of Real Time Stream */
    BYTE    byRes[256];                                         /* ֶ Reserved */
}NETDEV_CLOUD_LIMIT_INFO_S,*LPNETDEV_CLOUD_LIMIT_INFO_S;

/**
 * @struct tagNETDEVCloudNoAccountInfo
 * @brief ˻Ϣ
 * @attention szDeviceName is Not Required Using for Cancel Binding
 */
typedef struct tagNETDEVCloudNoAccountInfo
{
    CHAR    szDeviceSN[NETDEV_LEN_260];                         /* 豸к SN of Device */
    CHAR    szDeviceName[NETDEV_LEN_260];                       /* 豸 Device Name Named By User */
    BYTE    byRes[256];                                         /* ֶ Reserved */
}NETDEV_CLOUD_NOACCOUNT_INFO_S, *LPNETDEV_CLOUD_NOACCOUNT_INFO_S;

/**
 * @struct tagNETDEVCloudFindVideoTimeCond
 * @brief ƴ洢ʱϢѯ
 * @attention  None
 */
typedef struct tagNETDEVCloudFindVideoTimeCond
{
    INT32    dwChannelID;                       /* ͨID  ChannelID */
    DOUBLE   tBeginTime;                        /* ʼʱ Begin time */
    DOUBLE   tEndTime;                          /* ʱ End time */
    BYTE     byRes[256];                        /* ֶ */
}NETDEV_CLOUD_FIND_VIDEO_TIME_COND_S,*LPNETDEV_CLOUD_FIND_VIDEO_TIME_COND_S;

/**
 * @struct tagNETDEVCloudVideoTimeBlock
 * @brief ƶƵʱϢѯ
 * @attention  None
 */
typedef struct tagNETDEVCloudVideoTimeBlock
{
    DOUBLE   tBeginTime;                         /* ʼʱ Begin time */
    DOUBLE   tEndTime;                           /* ʱ End time */
    BYTE    byRes[128];                          /* ֶ */
}NETDEV_CLOUD_VIDEO_TIME_BLOCK_S,*LPNETDEV_CLOUD_VIDEO_TIME_BLOCK_S;

/**
 * @struct tagNETDEVCloudVideoInfo
 * @brief ҵƵƴ洢Ϣ
 * @attention  None
 */
typedef struct tagNETDEVCloudVideoInfo
{
    DOUBLE   tBeginTime;                         /* ʼʱ Begin time */
    DOUBLE   tEndTime;                           /* ʱ End time */
    DOUBLE   tExpireTime;                        /* ʱ Expiration time */
    UINT32   udwM3u8AvailSize;                   /* M3u8ռôС */
    CHAR*    pszM3u8;                            /* M3u8Ϣ,ݽϴ󣬽Ӷ */
    BYTE     byRes[256];                         /* ֶ */
}NETDEV_CLOUD_VIDEO_INFO_S,*LPNETDEV_CLOUD_VIDEO_INFO_S;

/**
*@enum tagNETDEVCloudStorageType
*@brief ƴ洢֧
*@attention 
*/
typedef enum tagNETDEVCloudStorageType
{
    NETDEV_CLOUD_STORAGE_TYPE_PIC                 = 1,            /* ƴ洢ͼƬ澯 */
    NETDEV_CLOUD_STORAGE_TYPE_VIDEO               = 2,            /* Ƶطƴ洢 */
    NETDEV_CLOUD_STORAGE_TYPE_PIC_AND_VIDEO       = 3,            /* ƴ洢ͼƬ澯Ƶطƴ洢*/
    NETDEV_CLOUD_STORAGE_TYPE_INVALID
}NETDEV_CLOUD_STORAGE_TYPE_E;


/**
 * @brief ƶ豸Ϣ ṹ嶨 Cloud Device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVCloudDevBasicInfo
{
    CHAR    szIPAddr[NETDEV_IPV4_LEN_MAX];              /* 豸IP Device IP */
    CHAR    szDevUserName[NETDEV_LEN_260];              /* 豸û Device username */
    CHAR    szDevName[NETDEV_LEN_260];                  /* 豸 Device name */
    CHAR    szDevModel[NETDEV_LEN_64];                  /* 豸ͺ Device model */
    CHAR    szDevSerialNum[NETDEV_LEN_64];              /* 豸к Device serial number */
    INT32   dwOrgID;                                    /* ֯ID Home organization ID */
    INT32   dwDevPort;                                  /* 豸˿ Device port */
    INT32   dwDevID;                                    /* 豸ID豸豸бе */
    CHAR    szDevSubName[NETDEV_LEN_260];               /* 豸豸 */
    INT32   dwDevType;                                  /* 豸ͣμö#NETDEV_CLOUD_DEVICE_TYPE  Device type, see enumeration #NETDEV_CLOUD_DEVICE_TYPE */
    BOOL    bKeepLiveStatus;                            /* 豸״̬߷true߷false */
    BOOL    bIsShareDev;                                /* 豸־λǹ豸ΪtrueԼµ豸Ϊfalse */
    INT32   dwValidityShareTime;                        /* Чڣλ롣緵ء3600.0000000ͻ˵ǰʱ2014-2-27 9:22-2-27 10:22ǰӡ豸־λΪtrueʱЧ*/
    CHAR    szShareDevUserName[NETDEV_LEN_260];         /* 豸ûbIsShareDevΪtrueʱЧ */
    INT32   dwConnectMode;                              /* ģʽ Connect Mode*/
    INT32   dwDisTributeCloud;                          /* ַģʽ  μö NETDEV_DISTRIBUTE_CLOUD_SRV_E*/
    INT32   dwCloudStorageType;                         /* 豸ƴ洢 οö NETDEV_CLOUD_STORAGE_TYPE_E*/
    BYTE    byRes[120];                                 /* ֶ */
}NETDEV_CLOUD_DEV_BASIC_INFO_S,*LPNETDEV_CLOUD_DEV_BASIC_INFO_S;


/**
 * @struct tagstNETDEVSELogInfo
 * @brief ȫ¼Ϣ
 * @attention
 */
typedef struct tagstNETDEVSELogInfo
{
    INT32  dwSELogCount;    /* ȫ¼ */
    INT32  dwSELogTime;     /* ȫ¼ʱ */
    BYTE   byRes[64];       /* ֶ */
}NETDEV_SELOG_INFO_S, *LPNETDEV_SELOG_INFO_S;

/**
 * @struct tagstNETDEVLoginInfo
 * @brief 豸¼Ϣ
 * @attention
 */
typedef struct tagstNETDEVDeviceLoginInfo
{    
    CHAR    szIPAddr[NETDEV_LEN_260];       /* IPַ/ */
    INT32   dwPort;                         /* ˿ں */
    CHAR    szUserName[NETDEV_LEN_132];     /* û */
    CHAR    szPassword[NETDEV_LEN_128];     /*  */
    INT32   dwLoginProto;                   /* ¼Э, μNETDEV_LOGIN_PROTO_E */
    INT32   dwDeviceType;                   /* 豸, μNETDEV_DEVICE_TYPE_E */
    BYTE    byRes[256];                     /* ֶ */
}NETDEV_DEVICE_LOGIN_INFO_S, *LPNETDEV_DEVICE_LOGIN_INFO_S;


/**
 * @struct tagNETDEVAlarmInfo
 * @brief 澯Ϣ ṹ嶨 Alarm information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVAlarmInfoV30
{
    INT32 dwAlarmType;                                  /* 澯ͣμö#NETDEV_ALARM_TYPE_E  Alarm type, see enumeration #NETDEV_ALARM_TYPE_E */
    INT32 dwAlarmSubType;                               /* 澯ͣμNETDEV_ALARM_SUBTYPE_E */
    INT32 dwAlarmLevel;                                 /* 澯ȼ151 */
    INT64 tAlarmTimeStamp;                              /* 澯ʱ  Alarm occurrence time */
    INT32 dwChannelID;                                  /* ͨID,һ豸ʹ  Channel ID */
    INT32 dwAlarmID;                                    /* 澯IDһ豸ʹ */
    INT32 dwAlarmSrcID;                                 /* 澯ԴID μö# NETDEV_ALARM_SRC_TYPE_E */
    CHAR  szAlarmSrc[NETDEV_ALARM_SOURCE_MAX_LEN];      /* 澯ԴϢƣ */
    BOOL IsAlarmSnapExisted;                            /* 澯Ƿץͼ 0ûץͼ 1ץͼ  vmsʹ*/
    UINT16  wIndex;                                     /*   Index number, index number */
    INT32   dwTotalBandWidth;                           /* ǰ,λΪMBps  Current total bandwidth (in MBps) */
    INT32   dwUnusedBandwidth;                          /* δʹõĴ,λΪMBps  Bandwidth left (in MBps)*/
    INT32   dwTotalStreamNum;                           /* · Total cameras*/
    INT32   dwFreeStreamNum;                            /* δʹ· Cameras left */
    INT32   dwMediaMode;                                /* ,μö#NETDEV_MEDIA_MODE_E Stream type. For enumerations, see#NETDEV_MEDIA_MODE_E*/
    INT32   dwEventCode;                                /* ¼ͣϱ¼ͣμö# NETDEV_PLAYER_RUN_INFO_TYPE_E */
    INT32   dwReserved;                                 /* 쳣ϱϱ㱣 */
    CHAR    szFileName[NETDEV_LEN_256];                 /* NDϱַϢ */
    BYTE    byRes[248];                                 /* ֶ */
}NETDEV_ALARM_INFO_V30_S, *LPNETDEV_ALARM_INFO_V30_S;


/**
 * @struct tagNETDEVEventRes
 * @brief ¼ԴϢ ṹ嶨
 * @attention  None
 */
typedef struct tagNETDEVEventRes
{
    INT32   dwResType;                          /* Դͣμö# NETDEV_EVENT_RES_TYPE_E */
    INT32   dwResID;                            /* ԴID */
    INT32   dwFirstSubResID;                    /* һԴID */
    INT32   dwSecondSubResID;                   /* ڶԴID ͬԴͶӦ岻ͬ磺ǽԴԴIDǵǽIDһԴIDǴIDڶԴIDǷID*/

    BYTE    byRes[16];                          /* ֶ */
}NETDEV_EVENT_RES_S, *LPNETDEV_EVENT_RES_S;


/**
 * @struct tagNETDEVEventInfo
 * @brief ¼Ϣ ṹ嶨 Alarm information Structure definition
 * @attention  ¼NETDEV_MAX_EVENT_RES_SIZEʱʹôָpstEventResУָڴж̬
 */
typedef struct tagNETDEVEventInfo
{
    INT32                   dwSize;                                     /* Դ */
    NETDEV_EVENT_RES_S      astEventRes[NETDEV_MAX_EVENT_RES_SIZE];     /* ¼ԴϢ */
    INT32                   dwEventActionType;                          /* ¼ͣμö# NETDEV_EVENT_ACTION_TYPE_E */
    LPNETDEV_EVENT_RES_S    pstEventRes;                                /* NETDEV_MAX_EVENT_RES_SIZE¼ԴϢ Ҫ̬*/
    BYTE                    byRes[28];                                  /* ֶ */
}NETDEV_EVENT_INFO_S, *LPNETDEV_EVENT_INFO_S;

/**
 * @struct tagNETDEVReportInfo
 * @brief 澯/¼ϱϢ ṹ嶨 
 * @attention  None
 */
typedef struct tagNETDEVReportInfo
{
    INT32                       dwReportType;       /* ϱͣμö#NETDEV_REPORT_TYPE_E */
    NETDEV_ALARM_INFO_V30_S     stAlarmInfo;        /* 澯ϢdwReportTypeΪNETDEV_REPORT_TYPE_ALARMʱЧ */
    NETDEV_EVENT_INFO_S         stEventInfo;        /* ¼ϢdwReportTypeΪNETDEV_REPORT_TYPE_EVENTʱЧ */
}NETDEV_REPORT_INFO_S, *LPNETDEV_REPORT_INFO_S;

/**
 * @struct tagstNETDEVUserSimpleInfo
 * @brief û˺Ϣû룩
 * @attention
 */
typedef struct tagstNETDEVUserSimpleInfo
{    
    CHAR szUserName[NETDEV_USERNAME_LEN];       /* û */
    CHAR szPassword[NETDEV_PASSWORD_LEN];       /*  */
    BYTE byRes[64];                             /* ֶ */
}NETDEV_USER_SIMPLE_INFO_S, *LPNETDEV_USER_SIMPLE_INFO_S;

/**
 * @struct tagstNETDEVIPAddrInfo
 * @brief IPַϢ
 * @attention
 */
typedef struct tagstNETDEVIPAddrInfo
{
    INT32   dwType;                            /* ַͣμöNETDEV_IP_ADDRESS_TYPE_E */
    CHAR    szIPAddr[NETDEV_MAX_URL_LEN];      /* IPַ/ */
    INT32   dwPort;                            /* ˿ں */
    BYTE    byRes[60];                         /* ֶ */
}NETDEV_IPADDR_INFO_S, *LPNETDEV_IPADDR_INFO_S;

/**
* @brief OnvifϢ
* @attention
*/
typedef struct tagstNETDEVOnvifInfo
{   
    UINT32   udwTransportMode;                          /* ģʽμöNETDEV_TRANS_PROTOCOL_E */

    BYTE  byRes[128];                                   /* ֶ  Reserved field*/
}NETDEV_ONVIF_INFO_S, *LPNETDEV_ONVIF_INFO_S;

/**
 * @struct tagNETDEVGBInfo
 * @brief Ϣ
 * @attention  None
 */
typedef struct tagNETDEVGBInfo
{
    CHAR     szUniCode[NETDEV_LEN_32];      /* Դ룬Χ[1, 32]*/
    UINT32   udwTransport;                  /* ģʽ 0: TCP 1: UDP*/
    BYTE   byRes[128];                      /* ֽ */
}NETDEV_GBINFO_S, *LPNETDEV_GBINFO_S;

/**
 * @struct tagNETDEVSmartLockInfo
 * @brief Ϣ
 * @attention  None
 */
typedef struct tagNETDEVSmartLockInfo
{
    UINT32 udwType;                         /*  0: WIFI 1: NBIoT */
    UINT32 udwSignal;                       /* ź  NETDEV_LOCK_SIGNAL_E */
    UINT32 udwStatus;                       /* ״̬ 0  1*/
    UINT32 udwBatteryPercent;               /* ȡֵΧ[0,100] */
    CHAR   szSN[NETDEV_LEN_64];             /* 豸кţַΧ[0,20] */
    CHAR   szIMEI[NETDEV_LEN_64];           /* ƶ豸ʶ TypeΪ1ʱЯ,ַȷΧ[1,16] */
    CHAR   szVersion[NETDEV_LEN_256];       /* 汾Ϣ ַȷΧ[1,64] */
    CHAR   szRoomName[NETDEV_LEN_480];      /* 󶨷 ַȷΧ[1, 128]*/
    BYTE   byRes[128];                      /* ֽ */
}NETDEV_SMART_LOCK_INFO_S,*LPNETDEV_SMART_LOCK_INFO_S;

/*
 * @struct tagNETDEVPlayerBasicInfo
 * @brief źϢ ṹ嶨
 * @attention  None
*/
typedef struct tagNETDEVIPMPlayerBasicInfo
{
    UINT32                          udwPlayerID;                            /* źID */
    UINT32                          udwVendor;                              /*  Ӳźʱѡ  NETDEV_DEVICE_IPM_VENDORS_ID_E */
    UINT32                          udwModel;                               /* ͺ Ӳźʱѡ  NETDEV_DEVICE_IPM_MODEL_ID_E */
    CHAR                            szPlayerName[NETDEV_LEN_128];           /* ź [1,64] */
    UINT32                          udwOrgID;                               /* ֯ID źϢѯʱѡ */
    CHAR                            szOrgName[NETDEV_LEN_128];              /* ֯ [1,64] źϢѯʱѡ */
    CHAR                            szPlayerMngtServerName[NETDEV_LEN_128]; /* źй豸 [1, 64] źϢѯʱѡ */
    CHAR                            szPlayerMngtServerIP[NETDEV_LEN_32];    /* źй豸IP źϢѯʱѡ */
    NETDEV_XW_RESOLUTION_S          stResolution;                           /* Ļ */
    BYTE                            byRes[256];                             /* ֶ */
}NETDEV_IPM_PLAYER_BASIC_INFO_S,*LPNETDEV_IPM_PLAYER_BASIC_INFO_S;

/**
 * @struct tagstNETDEVDeviceBasicInfo
 * @brief 豸Ϣ
 * @attention
 */
typedef struct tagstNETDEVDeviceBasicInfo
{
    NETDEV_IPADDR_INFO_S stDevAddr;                         /* 豸IPַϢ */
    NETDEV_USER_SIMPLE_INFO_S stDevUserInfo;                /* 豸û */
    CHAR szDevName[NETDEV_NAME_MAX_LEN];                    /* 豸 */
    CHAR szDevDesc[NETDEV_DESCRIBE_MAX_LEN];                /* 豸 */
    CHAR szDevModel[NETDEV_CODE_STR_MAX_LEN];               /* 豸ͺ */
    INT32 dwDevID;                                          /* 豸ID */
    INT32 dwDevStatus;                                      /* 豸״̬, ο# NETDEV_DEVICE_STATUS_E */
    INT32 dwDevType;                                        /* 豸ͣο# NETDEV_DEVICE_MAIN_TYPE_E */
    INT32 dwDevSubType;                                     /* 豸ͣο# NETDEV_DEVICE_SUB_TYPE_E */
    INT32 dwOrgID;                                          /* ֯ */
    INT32 dwAccessProtocol;                                 /* Э ο# NETDEV_ACCESS_PROTOCOL_E */
    INT32 dwAccessMode;                                     /* 뷽ʽ ο# NETDEV_DEVICE_ACCESS_MODE_E*/
    INT32 dwServerID;                                       /* ID */
    INT32 dwAudioResID;                                     /* ƵͨID */
    INT32 dwIsPTZNeeded ;                                   /* ǷҪ̨ 0:  Ҫ 1:  Ҫ 255: Ӧ */
    CHAR  szVIIDCode[NETDEV_VIID_CODE_LEN];                 /* ͼ,豸ʱЧ */
    INT32 dwVIIDStatus;                                     /* ͼ״̬ʶǰ豸ǷͨͼЭӣ0 1 */
    CHAR szSerialNum[NETDEV_LEN_64];                        /* 豸к*/
    CHAR szSoftVersion[NETDEV_LEN_128];                     /* 汾*/
    CHAR szMacAddr[NETDEV_LEN_32];                          /* MACַ*/
    INT32 dwStoreStatus;                                    /* 豸洢״̬0:  1: δʽ 2: ʽ3: */
    NETDEV_ONVIF_INFO_S stOnvifInfo;                        /* onvifϢ */
    NETDEV_GBINFO_S stGBInfo;                               /* Ϣ AccessProtocolֵΪ3ʱýڵѡѡ*/
    LPNETDEV_SMART_LOCK_INFO_S pstSmartLockInfo;            /* 豸Ϣ ߷ڴ */
    CHAR szManufacture[NETDEV_LEN_64];                      /*  */
    CHAR szDeviceCode[NETDEV_LEN_32];                       /* 豸 [1,32] Ӳźʱѡ  */
    LPNETDEV_IPM_PLAYER_BASIC_INFO_S  pstPlayerInfo;        /* źϢ TypeΪ11ʱѡ Ҫmallocڴ */
    UINT32  udwCustomProtocolID;                            /* ԶЭIDAccessProtocolֵΪ4ʱýڵѡ */
    UINT32  udwChlMaxNum;                                   /* 豸ͨAccessProtocolֵΪ4ʱýڵѡ */
    UINT32  udwChlIndexNum;                                 /* 豸ͨAccessProtocolֵΪ4ʱýڵѡ256 */
    UINT32* pudwChlIndexList;                               /* ͨб趯̬ڴ棬256 */
    BYTE byRes[4];                                         /* ֶ */
}NETDEV_DEV_BASIC_INFO_S, *LPNETDEV_DEV_BASIC_INFO_S;


/**
 * @struct tagstNETDEVDeviceFirmwareInfo
 * @brief 豸̼Ϣ
 * @attention
 */
typedef struct tagstNETDEVDeviceFirmwareInfo
{    
    CHAR szDevModel[NETDEV_CODE_STR_MAX_LEN];       /* 豸ͺ */
    CHAR szFireVersion[NETDEV_CODE_STR_MAX_LEN];    /* 汾 */
    CHAR szSerialNum[NETDEV_CODE_STR_MAX_LEN];      /* 豸к */
    BYTE byRes[128];                                /* ֶ */
}NETDEV_DEV_FIREWARE_INFO_S, *LPNETDEV_DEV_FIREWARE_INFO_S;

/**
 * @struct tagstNETDEVDeviceDetailInfo
 * @brief 豸ϸϢ
 * @attention
 */
typedef struct tagstNETDEVDeviceDetailInfo
{    
    NETDEV_DEV_BASIC_INFO_S stDevBasicInfo;             /* 豸Ϣ */
    NETDEV_DEV_FIREWARE_INFO_S stDevFirewareInfo;       /* 豸̼Ϣ */
}NETDEV_DEV_INFO_V30_S, *LPNETDEV_DEV_INFO_V30_S;


/**
 * @struct tagstNETDEVEncodeChnProperty
 * @brief ͨ
 * @attention
 */
typedef struct tagstNETDEVEncodeChnProperty
{
    INT32   dwMaxStream;        /* ֵ֧ */
    BOOL    bSupportPTZ;        /* Ƿ̨֧ */
    INT32   dwAudioResID;       /* ƵԴID */
    BYTE    byRes[64];          /* ֶ */
}NETDEV_ENCODE_CHN_PROPERTY_S, *LPNETDEV_ENCODE_CHN_PROPERTY_S;

/**
 * @struct tagstNETDEVDecodeChnProperty
 * @brief ͨ
 * @attention
 */
typedef struct tagstNETDEVDecodeChnProperty
{
    INT32 dwVideoFmtCapSize;                                    /* ʽѡ */
    INT32 adwVideoFormatCap[NETDEV_VIDEO_FORMAT_CAP_NUM];       /* ʽ */
    INT32 dwLayoutCapSize;                                      /* ѡ */
    INT32 adwLayoutCap[NETDEV_LAYOUT_CAP_NUM];                  /*  */
    BYTE  byRes[64];                                            /* ֶ */
}NETDEV_DECODE_CHN_PROPERTY_S, *LPNETDEV_DECODE_CHN_PROPERTY_S;

/**
 * @struct tagstNETDEVAlarmOutChnProperty
 * @brief 澯ͨ
 * @attention
 */
typedef struct tagstNETDEVAlarmOutChnProperty
{
    INT32 dwRunMode;        /* ģʽ/գμ#NETDEV_ALARM_STATUS_E */
    INT32 dwDuration;       /* ʱ䣺(ms) */
    BYTE byRes[64];         /* ֶ */
}NETDEV_ALARMOUT_CHN_PROPERTY_S, *LPNETDEV_ALARMOUT_CHN_PROPERTY_S;

/**
 * @struct tagstNETDEVAlarmInChnProperty
 * @brief 澯ͨ
 * @attention
 */
typedef struct tagstNETDEVAlarmInChnProperty
{
    INT32 dwRunMode;        /* ģʽ/գμ#NETDEV_ALARM_STATUS_E */
    BOOL  bEnable;          /* ʹܿأʹܿ/ʹܹأ */
    BYTE byRes[64];         /* ֶ */
}NETDEV_ALARMIN_CHN_PROPERTY_S, *LPNETDEV_ALARMIN_CHN_PROPERTY_S;


/**
 * @struct tagstNETDEVDAProperty
 * @brief 豸ͨ
 * @attention
 */
typedef struct tagstNETDEVDAProperty
{
    CHAR   szPointCode[NETDEV_DA_POINT_CODE_LEN];         /* λű */
    CHAR   szAreaCode[NETDEV_DA_AREA_CODE_LEN];           /*  */
    UINT32 udwPointStatus;                                /* 澯λ״̬ο#NETDEV_ALARM_POINT_STATUS_TYPE_E ״̬ ο#NETDEV_DOOR_STATUS_TYPE_E */
    BYTE   byRes[64];                                     /* ֶ */
}NETDEV_DA_CHN_PROPERTY_S, *LPNETDEV_DA_CHN_PROPERTY_S;



/**
* @struct tagNETDEVTrafficStatisticsInfo
* @brief ͳ ṹ嶨
* @attention  None
*/
typedef struct tagNETDEVTrafficStatisticsInfo
{
    BOOL    bIsSuccess;                                    /* ѯǷɹ */
    INT32   dwChannelID;                                   /* ͨ */
    UINT32  udwSize;                                       /* ʱθ */
    UINT32  audwEnterCount[NETDEV_PEOPLE_CNT_MAX_NUM];     /* ͳ */
    UINT32  audwExitCount[NETDEV_PEOPLE_CNT_MAX_NUM];      /* 뿪ͳ */
    BYTE    byRes[6];                                      /* ֶ   */
}NETDEV_TRAFFIC_STATISTICS_INFO_S, *LPNETDEV_TRAFFIC_STATISTICS_INFO_S;

/**
 * @struct tagstNETDEVOrgChnInfo
 * @brief ֯ͨϢ
 * @attention
 */
typedef struct tagstNETDEVOrgChnInfo
{
    INT32 dwOrgID;                              /* ֯ID */
    INT32 dwChannelID;                          /* ͨID */
    CHAR szChnName[NETDEV_NAME_MAX_LEN];        /* ͨ */
    INT32 dwChnIndex;                           /* ͨ */
    INT32 dwChnType;                            /* ͨ */
    INT32 dwChnStatus;                          /* ͨ״̬ */
    INT32 dwDevID;                              /* 豸ID */
    CHAR szDevName[NETDEV_NAME_MAX_LEN];        /* 豸 */
    BYTE  byRes[128];                           /* ֶ   */
}NETDEV_ORG_CHN_INFO_S, *LPNETDEV_ORG_CHN_INFO_S;


/**
 * @struct tagstNETDEVOrgDetailInfo
 * @brief ֯ϸϢ
 * @attention
 */
typedef struct tagstNETDEVOrgDetailInfo
{    
    INT32 dwOrgID;                               /* ֯ID */
    INT32 dwParentID;                            /* ֯ڵID */
    INT32 dwType;                                /*  μ NETDEV_ORG_TYPE_E */
    CHAR  szNodeName[NETDEV_NAME_MAX_LEN];       /* ڵ */
    CHAR  szDesc[NETDEV_DESCRIBE_MAX_LEN];       /* ע */
    UINT32 udwTime;                              /* ʱ䣬UTCʱ */
    CHAR  szUserName[NETDEV_LEN_64];             /*  [1,64] */
    BYTE  byRes[60];                             /* ֶ   */
}NETDEV_ORG_INFO_S, *LPNETDEV_ORG_INFO_S;


/**
* @struct tagNETDEVMemSize
* @brief ڴϢ
* @attention 
*/
typedef struct tagNETDEVMemSize
{
    UINT32 udwDecodePayload;        /* ʽ NETDEV_MEM_PAYLOAD_E */
    UINT32 udwResolution;           /* ֱ NETDEV_MEM_RESOLUTION_E  */
    UINT32 udwMemSize;              /* ҪԴС */
}NETDEV_MEM_SIZE_S, *LPNETDEV_MEM_SIZE_S;

/**
* @struct tagMallocInfo
* @brief ڴϢ
* @attention 
*/
typedef struct tagNETDEVMemTable
{
    UINT32 udwSize;                                                     /* ԴԪظ*/
    NETDEV_MEM_SIZE_S szVirtualMem[NETDEV_VIRTUAL_MEM_TABLE_MAX];       /* ԴڴϢ */
}NETDEV_MEM_TABLE_S, *LPNETDEV_MEM_TABLE_S;

/**
 * @struct tagNETDEVTMSStrutPicInfo
 * @brief ṹͼƬϢ
 * @attention
 */
typedef struct tagNETDEVTMSStrutPicInfo
{
    UINT32  udwPicSize;         /* ͼƬС */
    CHAR    *pcPicData;         /* ͼƬ */
    BYTE bRes[256];             /* ֶ Reserved */
}NETDEV_TMS_STRUT_PIC_INFO_S,*LPNETDEV_TMS_STRUT_PIC_INFO_S;

/**
 * @struct tagstNETDEVStructCommonInfo
 * @brief ṹϢ
 * @attention
 */
typedef struct tagstNETDEVStructCommonInfo
{
    CHAR szPlaceCode[NETDEV_LEN_32];            /* ص */
    CHAR szPlaceName[NETDEV_LEN_128];           /* ص */
    CHAR szLaneDirection[NETDEV_LEN_32];        /* ʻ */
    CHAR szDirection[NETDEV_LEN_32];            /*  */
    CHAR szDirectionName[NETDEV_LEN_32];        /*  */
    CHAR szDevID[NETDEV_LEN_32];                /* 豸 */
    CHAR szLaneID[NETDEV_LEN_32];               /*  */
    CHAR szLaneType[NETDEV_LEN_32];             /*  */
    CHAR szLaneDescription[NETDEV_LEN_128];     /*  */
    BYTE bRes[128];                             /* ֶ Reserved */
}NETDEV_STRUCT_COMMON_INFO_S,*LPNETDEV_STRUCT_COMMON_INFO_S;

/**
 * @struct tagstNETDEVStructVeh
 * @brief ṹϢ
 * @attention
 */
typedef struct tagstNETDEVStructVehInfo
{
    CHAR szAppearTime[NETDEV_LEN_32];           /* ʱ */
    CHAR szDisAppearTime[NETDEV_LEN_32];        /* ʧʱ */
    CHAR szRedLightStartTime[NETDEV_LEN_32];    /* ƿʼʱ */
    CHAR szRedLightEndTime[NETDEV_LEN_32];      /* ƽʱ */
    CHAR szRedLightTime[NETDEV_LEN_32];         /* ʱ */
    CHAR szIdentifyTime[NETDEV_LEN_32];         /* ʶʱ */
    CHAR szCorrectTime[NETDEV_LEN_32];          /* Уʱ */
    CHAR szLimitedSpeed[NETDEV_LEN_32];         /* ִ */
    CHAR szMarkedSpeed[NETDEV_LEN_32];          /* ʶ */
    CHAR szVehicleSpeed[NETDEV_LEN_32];         /* ٶ */
    CHAR szVehicleType[NETDEV_LEN_32];          /*  */
    CHAR szLogoAreaPosition[NETDEV_LEN_32];     /* 궨λ */
    CHAR szVehicleColor[NETDEV_LEN_32];         /* ɫ */
    CHAR szDriSunVisStat[NETDEV_LEN_32];        /* ʻ״̬ */
    CHAR szCodriSunVisStat[NETDEV_LEN_32];      /* ʻ״̬ */
    CHAR szDriSeatBeltStat[NETDEV_LEN_32];      /* ʻȫ״̬ */
    CHAR szCodriSeatBeltStat[NETDEV_LEN_32];    /* ʻȫ״̬ */
    CHAR szDriMobileStat[NETDEV_LEN_32];        /* ʻ绰״̬ */
    CHAR szYlwPlateMarkStat[NETDEV_LEN_32];     /* Ʊ공־״̬ */
    CHAR szPendantStatus[NETDEV_LEN_32];        /* ׹״̬ */
    CHAR szAimStatus[NETDEV_LEN_32];            /* ״̬ */
    CHAR szDangerGoodsMarkStat[NETDEV_LEN_32];  /* ΣƷ־״̬ */
    CHAR szLaneQueueLength[NETDEV_LEN_32];      /* Ŷӳ */
    BYTE bRes[128];                             /* ֶ Reserved */
}NETDEV_STRUCT_VEH_INFO_S,*LPNETDEV_STRUCT_VEH_INFO_S;

/**
 * @struct tagstNETDEVStructNonVeh
 * @brief ṹǳϢ
 * @attention
 */
typedef struct tagstNETDEVStructNonVehInfo
{
    CHAR szAppearTime[NETDEV_LEN_32];       /* ǻʱ */
    CHAR szDisAppearTime[NETDEV_LEN_32];    /* ǻʧʱ */
    CHAR szDirectionType[NETDEV_LEN_32];    /* ǻ˶ */
    CHAR szSpeed[NETDEV_LEN_32];            /* ǻ˶ٶ */
    BYTE bRes[128];                         /* ֶ Reserved */
}NETDEV_STRUCT_NON_VEH_INFO_S,*LPNETDEV_STRUCT_NON_VEH_INFO_S;

/**
 * @struct tagstNETDEVStructPerson
 * @brief ṹԱϢ
 * @attention
 */
typedef struct tagstNETDEVStructPersonInfo
{
    CHAR szAppearTime[NETDEV_LEN_32];           /* Աʱ */
    CHAR szDisAppearTime[NETDEV_LEN_32];        /* Աʧʱ */
    CHAR szMovingDirection[NETDEV_LEN_32];      /* Ա˶ */
    BYTE bRes[128];                             /* ֶ Reserved */
}NETDEV_STRUCT_PERSON_INFO_S,*LPNETDEV_STRUCT_PERSON_INFO_S;

/**
 * @struct tagstNETDEVStructFace
 * @brief ṹϢ
 * @attention
 */
typedef struct tagstNETDEVStructFaceInfo
{
    CHAR szAppearTime[NETDEV_LEN_32];       /* ʱ */
    CHAR szDisAppearTime[NETDEV_LEN_32];    /* ʧʱ */
    BYTE bRes[128];                         /* ֶ Reserved */
}NETDEV_STRUCT_FACE_INFO_S,*LPNETDEV_STRUCT_FACE_INFO_S;

/**
 * @struct tagstNETDEVStructInfo
 * @brief ṹXMLϢ
 * @attention
 */
typedef struct tagstNETDEVStructInfo
{
    NETDEV_STRUCT_COMMON_INFO_S stCommonInfo;           /* Ϣ */
    UINT32 udwVehicleNum;                               /* Ŀ */
    LPNETDEV_STRUCT_VEH_INFO_S pstVehInfo;              /* Ϣ */
    UINT32 udwNonVehicleNum;                            /* ǻĿ */
    LPNETDEV_STRUCT_NON_VEH_INFO_S pstNonVehInfo;       /* ǻϢ */
    UINT32 udwPersonNum;                                /* ԱĿ */
    LPNETDEV_STRUCT_PERSON_INFO_S pstPersonInfo;        /* ԱϢ */
    UINT32 udwFaceNum;                                  /* Ŀ */
    LPNETDEV_STRUCT_FACE_INFO_S pstFaceInfo;            /* Ϣ */
    CHAR szIPAddr[NETDEV_IPV4_LEN_MAX];                 /* 豸IPַ */
    BYTE bRes[112];                                     /* ֶ Reserved */
}NETDEV_STRUCT_INFO_S,*LPNETDEV_STRUCT_INFO_S;

/**
 * @struct tagNETDEVTMSStrutInfo
 * @brief ṹϢ
 * @attention
 */
typedef struct tagNETDEVTMSStrutInfo
{
    UINT32                             udwPicNum;                                   /* ͼƬ Picture Number */
    NETDEV_STRUCT_INFO_S               stTmsXmlInfo;                                /* XMLϢ XML Information */
    NETDEV_TMS_STRUT_PIC_INFO_S        stTmsPicInfo[NETDEV_TMS_PIC_COMMON_NUM];     /* ͼƬϢ Picture Message */

}NETDEV_TMS_STRUT_INFO_S,*LPNETDEV_TMS_STRUT_INFO_S;

/**
 * @struct tagNETDEVTMSInterface 
 * @brief TMSϢԭʼݣ
 * @attention
 */
typedef struct tagNETDEVTMSInterface
{
    NETDEV_TMS_CONNECT_INFO_S stTmsConnectInfo;         /* SocketϢ */
    NETDEV_TMS_FACE_PARSE_INFO_S stTmsFaceParseInfo;    /* ʶϢ */
    NETDEV_TMS_HEAT_MAP_INFO_S stTmsHeatMapInfo;        /* ȶͼϢ */
    NETDEV_TMS_CAR_PLATE_INFO_S stTmsCarPlateInfo;      /* ʶ */
    NETDEV_TMS_STRUT_INFO_S     stTmsStrutInfo;         /* ṹϢ */
    CHAR        szIPAddr[NETDEV_IPV4_LEN_MAX];          /* 豸IPַ */
    BYTE     bRes[240];                                 /* ֶ Reserved */
}NETDEV_TMS_INTERFACE_S, *LPNETDEV_TMS_INTERFACE_S;

/**
* @struct tagNETDEVBaseFindCond
* @brief ¼Ϣ ṹ嶨
* @attention  None
*/
typedef struct tagNETDEVBaseFindCond
{
    INT32   dwChannelID;    /* ͨ  Channel number */
    INT64   tBeginTime;     /* ʼʱ  Start time */
    INT64   tEndTime;       /* ʱ  End time */
    INT32   dwStreamType;   /*  μö#NETDEV_STREAM_TYPE_E*/
    BYTE    byRes[32];      /* ֶ  Reserved */
}NETDEV_BASE_FIND_COND_S, *LPNETDEV_BASE_FIND_COND_S;

/**
* @struct tagNETDEVEventFindCond
* @brief ¼¼ ṹ嶨
* @attention  None
*/
typedef struct tagNETDEVEventFindCond
{
    INT32   dwFindLogic;                                        /* ¼߼ μö#NETDEV_EVENT_FIND_LOGIC_E */
    INT32   dwEventFileTypeSize;                                /* ͸ */
    INT32   adwEventFileType[NETDEV_EVENT_STORE_TYPE_NUM];      /* ܲ,μö#NETDEV_EVENT_STORE_TYPE_E */
    NETDEV_BASE_FIND_COND_S stBaseCond;                         /* ѯҪϢ */
    INT32   dwStreamType;                                       /*  μö#NETDEV_STREAM_TYPE_E*/
    BYTE    byRes[128];                                         /* ֶ  Reserved */
}NETDEV_EVENT_FIND_COND_S, *LPNETDEV_EVENT_FIND_COND_S;

/**
* @struct tagNETDEVSmartFindCond
* @brief ܲ¼ ṹ嶨
* @attention  None
*/
typedef struct tagNETDEVSmartFindCond
{
    INT32   dwSensitivity;                                                      /* ,ȡֵΧ1-8 */
    NETDEV_BASE_FIND_COND_S stBaseCond;                                         /* ѯҪϢ */
    UCHAR   awSmartBlock[NETDEV_SCREEN_INFO_ROW][NETDEV_SCREEN_INFO_COLUMN];    /* ܲҿ,ѡ1,ѡ0  */
    BYTE    byRes[124];                                                         /* ֶ  Reserved */
}NETDEV_SMART_FIND_COND_S, *LPNETDEV_SMART_FIND_COND_S;

/**
* @struct tagNETDEVSmartEventFindCond
* @brief ¼¼ ṹ嶨
* @attention  None
*/
typedef struct tagNETDEVSmartEventFindCond
{
    INT32   dwColumn;                                                           /*  */
    INT32   dwRow;                                                              /*  */
    INT32   dwSensitivity;                                                      /*   */
    UCHAR   awSmartBlock[NETDEV_SCREEN_INFO_ROW][NETDEV_SCREEN_INFO_COLUMN];    /* ܲҿ,ѡ1,ѡ0 */
    INT32   dwFindLogic;                                                        /* ¼߼ μö#NETDEV_EVENT_FIND_LOGIC_E */
    INT32   dwEventFileTypeSize;                                                /* ͸ */
    INT32   adwEventFileType[NETDEV_EVENT_STORE_TYPE_NUM];                      /* ܲ,μö#NETDEV_EVENT_STORE_TYPE_E */
    NETDEV_BASE_FIND_COND_S stBaseCond;                                         /* ѯҪϢ */
    BYTE    byRes[128];                                                         /* ֶ  Reserved */
}NETDEV_SMART_EVENT_FIND_COND_S, *LPNETDEV_SMART_EVENT_FIND_COND_S;

/**
 * @struct tagNETDEVEventFindData
 * @brief ¼ ṹ嶨 
 *        ȡҵļϢ 
 * @attention  None
 */
typedef struct tagNETDEVEventFindData
{
    INT32   dwEventFileTypeSize;                                /* ͸ */
    INT32   adwEventFileType[NETDEV_EVENT_STORE_TYPE_NUM];      /* ¼,μö#NETDEV_EVENT_STORE_TYPE_E */
    INT64   tBeginTime;                                         /* ʼʱ  Start time */
    INT64   tEndTime;                                           /* ʱ  End time */
    CHAR    szFileName[NETDEV_LEN_64];                          /* ļ */
    UINT32  udwFileSize;                                        /* ļС */
    BYTE    byRes[124];                                         /* ֶ  Reserved */
}NETDEV_EVENT_FIND_DATA_S,*LPNETDEV_EVENT_FIND_DATA_S;



/**
* @struct tagNETDEVQueryPageInfo
* @brief ҳϢ ṹ嶨
* @attention
* ҳѯÿҳĿ, Ϊ0, Ҳܴ#NETDEV_PAGE_QUERY_ROW_MAX_NUM
*/
typedef struct tagNETDEVQueryPageInfo
{
    INT32   dwPageRowNum;           /* ҳѯÿҳĿ */
    INT32   dwPageCnt;              /* ʾڼҳ */
}NETDEV_QUERY_PAGE_INFO_S;

/**
* @struct tagNETDEVQueryPageInfo
* @brief ҳӦϢ ṹ嶨
* @attention 
*/
typedef struct tagNETDEVRspPageInfo
{
    INT32   dwRowNum;           /* ʵʷصĿ */
    INT32   dwTotalRowNum;      /* Ŀ */
}NETDEV_RSP_PAGE_INFO_S;


/**
* @struct tagNETDEVPortMappingInfo
* @brief ӳ˿Ϣ ṹ嶨
* @attention
* ֶ,Ϊ0
*/
typedef struct tagNETDEVPortMappingInfo
{
    INT32   dwHttpLocal;                /* ӳǰHTTP˿ */
    INT32   dwHttpNat;                  /* ӳHTTP˿ */
    INT32   dwSdkLocal;                 /* ӳǰSDK˿ */
    INT32   dwSdkNat;                   /* ӳSDK˿ */
    INT32   dwMediaLocal;               /* ӳǰMedia˿ */
    INT32   dwMediaNat;                 /* ӳMedia˿ */
    INT32   dwRTSPLocal;                /* ӳǰRTSP˿ */
    INT32   dwRTSPNat;                  /* ӳRTSP˿ */

    INT32   dwRes[8];                   /* ֶ */
}NETDEV_PORT_MAPPING_INFO_S, *LPNETDEV_PORT_MAPPING_INFO_S;

/**
* @struct tagNETDEVStreamInfo
* @brief IDϢ ṹ嶨
* @attention
* ID,0
*/
typedef struct tagNETDEVStreamInfo
{
    INT32   dwChannelID;                    /* 豸ͨ */
    INT32   dwSize;                         /* ṹС */
    BYTE    byID[NETDEV_STREAM_ID_LEN];     /* ID */
    BYTE    byRes[NETDEV_LEN_32];           /* ֶ */
}NETDEV_STREAM_INFO_S,*LPNETDEV_STREAM_INFO_S;

/**
* @struct tagNETDEVParseVideoData
* @brief ýչϢ ṹ嶨
*        ƴ֡ǰýչϢ
* @attention 
*/
typedef struct tagNETDEVSourceDataExInfo
{
    BYTE szDecoderTag[NETDEV_CODE_STR_MAX_LEN];         /* ǩ */
    BYTE szReserved[64];                                /* ֶ */
}NETDEV_SOURCE_DATA_EX_INFO_S;

/**
* @struct tagNETDEVSdkAblity
* @brief ǰSDKĹϢ ṹ嶨
* @attention
* ֶΪ0.
*/
typedef struct tagNETDEVSdkAblity
{
    INT32   dwMaxLoginNum;              /* עû */
    INT32   dwMaxRealPlayNum;           /* ʵʱԤ· */
    INT32   dwMaxPlayBackNum;           /* طŻص· */
    INT32   dwMaxAlarmChanNum;          /* ͨ· */
    INT32   dwMaxFormatNum;             /* Ӳ̸ʽ· */
    INT32   dwMaxFileSearchNum;         /* ļ· */
    INT32   dwMaxLogSearchNum;          /* ־· */
    INT32   dwMaxSerialNum;             /* ͸ͨ· */
    INT32   dwMaxUpgradeNum;            /* · */
    INT32   dwMaxVoiceComNum;           /* ת· */
    INT32   dwMaxBroadCastNum;          /* 㲥· */
    INT32   dwRes[10];                  /* ֶ */
}NETDEV_SDKABILITY_S,*LPNETDEV_SDKABILITY_S;

/**
* @struct tagNETDEVSdkState
* @brief ǰSDK״̬Ϣ ṹ嶨
* @attention
* ֶΪ0.
*/
typedef struct tagNETDEVSdkState
{
    INT32   dwTotalLoginNum;                /* ǰעû */
    INT32   dwTotalRealPlayNum;             /* ǰʵʱԤ· */
    INT32   dwTotalPlayBackNum;             /* ǰطŻص· */
    INT32   dwTotalAlarmChanNum;            /* ǰͨ· */
    INT32   dwTotalFormatNum;               /* ǰӲ̸ʽ· */
    INT32   dwTotalFileSearchNum;           /* ǰļ· */
    INT32   dwTotalLogSearchNum;            /* ǰ־· */
    INT32   dwTotalSerialNum;               /* ǰ͸ͨ· */
    INT32   dwTotalUpgradeNum;              /* ǰ· */
    INT32   dwTotalVoiceComNum;             /* ǰת· */
    INT32   dwTotalBroadCastNum;            /* ǰ㲥· */
    INT32   dwRes[10];                      /* ֶ */
}NETDEV_SDKSTATE_S,*LPNETDEV_SDKSTATE_S;

/**
* @struct tagPrivacyMaskPara
* @brief ˽ Privacy mask capabilities
* @attention
*/
typedef struct tagPrivacyMaskAbility
{
    INT32 dwSupportCnt;             /* ֵ֧ڸ Number of supported privacy mask areas */
}NETDEV_PRIVACY_MASK_ABILITY_S, *LPNETDEV_PRIVACY_MASK_ABILITY_S;


/* ͨOSD */
typedef struct tagNETDEVOsdAbilityInfo
{
    INT32   bIsSupportTimeOSD;          /* Ƿ֧ʱ */
    INT32   bIsSupportNameOSD;          /* Ƿ֧ */
    UINT32  u32OSDMaxNum;               /* ֵ֧OSD */
    UINT32  u32NameMLen;                /* ַ֧ */
    UINT32  u32TimeOSDFormat;           /* ʱOSDʽ μNETDEV_OSD_TIME_FORMAT_CAP_E */
    UINT32  u32DateOSDFormat;           /* OSDʽ μNETDEV_OSD_DATE_FORMAT_CAP_E */
    BYTE    byRes[32];                  /* ֶ */
}NETDEV_VIDEO_OSD_ABILITY_S, *LPNETDEV_VIDEO_OSD_ABILITY_S;

/**
* @struct tagNETDEVVideoOutChlprofiles
* @brief VideoOutͨ
* @attention None
*/
typedef struct tagNETDEVVideoOutChlprofiles
{
    INT32   dwDefaultPane;                              /* ĬϷ*/
    INT32   dwSupportedMaxPane;                         /* */
    INT32   adwSupportedPane[NETDEV_LEN_32];            /* ֵ֧ķ,μ#NETDEV_PANE_NUM_E */
    INT32   dwDefaultVideoFormat;                       /* ĬϷֱ*/
    INT32   dwSupportedPaneNum;                         /* ֵ֧ķֱʸ */
    INT32   adwSupportedVideoFormat[NETDEV_LEN_32];     /* ֵ֧ķֱ,μ#NETDEV_VIDEO_FORMAT_E */
}NETDEV_VIDEOOUT_CHL_PROFILES_S, *LPNETDEV_VIDEOOUT_CHL_PROFILES_S;

/**
* @struct tagNETDEVVideoOutALLprofiles
* @brief VideoOutͨ
* @attention None
*/
typedef struct tagNETDEVVideoOutALLprofiles
{
    INT32 dwChlNum;                                     /* ͨ */
    LPNETDEV_VIDEOOUT_CHL_PROFILES_S pstDCProfiles;     /* ͨ */
}NETDEV_VIDEOOUT_ALL_PROFILES_S, *LPNETDEV_VIDEOOUT_ALL_PROFILES_S;

/**
* @struct tagNETDEVPriviewTVWallInfo
* @brief ʵǽ
* @attention  None
*/
typedef struct tagNETDEVPriviewTVWallInfo
{
    UINT16  dwChannelID;                /* ͨID  Channel ID */
    UINT16  dwPaneIndex;                /* (1ʼ) */
    INT32   dwStreamType;               /* ,#μNETDEV_STREAM_TYPE_E */
    CHAR    szUrl[NETDEV_LEN_260];      /* ʵUrl */
    INT32   dwTransProto;               /* Э,#μNETDEV_TRANSPORT_PROTOCOL_E */
    BYTE    byRes[256];                 /* ֶ  Reserved */
}NETDEV_PREVIEW_TVWALLINFO_S, *LPNETDEV_PREVIEW_TVWALLINFO_S;


/**
 * @struct tagNETDEVReceiverInfo
 * @brief ǽҵϢ
 * @attention 
 */
typedef struct tagNETDEVReceiverInfo
{
    UINT16 dwPaneIndex;             /* receiverӦķ(1ʼ) */
    INT32 dwReceiverMode;           /* receiverϢ */
    INT32 dwStreamType;             /*  */
    INT32 dwTransportProtocol;      /* Э */
    CHAR  szUrl[NETDEV_LEN_260];    /* ʵطurl */
    BYTE  byRes[64];                /* ֶ */
}NETDEV_RECEIVER_INFO_S, *LPNETDEV_RECEIVER_INFO_S;

/**
 * @struct tagNETDEVReceiverInfoList
 * @brief ĳһͨIDҵϢ
 * @attention 
 */
typedef struct tagNETDEVReceiverInfoList
{
    INT32                   dwSize;                                         /* ҵϢ */
    NETDEV_RECEIVER_INFO_S  astReceiverInfoList[NETDEV_MAX_PANE_NUM];       /* ҵϢ */
}NETDEV_RECEIVER_INFO_LIST_S, *LPNETDEV_RECEIVER_INFO_LIST_S;


/**
 * @struct tagNETDEVDevLoginParamInfo
 * @brief 豸½ɹĻϢ ṹ嶨 Device information Structure definition
 * @attention  None   ڻȡ豸½ɹһЩģʽ
 */
typedef struct tagNETDEVDevLoginParamInfo
{
    NETDEV_NETWORK_MODE_E   eNetWorkMode;   /* ģʽ,μö#NETDEV_NETWORK_MODE_E */
    BYTE                    byRes[48];      /* ֶ  Reserved */
}NETDEV_DEV_LOGIN_PARAM_INFO_S,*LPNETDEV_DEV_LOGIN_PARAM_INFO_S;


/**
 * @struct tagNETDEVChlOsdCfg
 * @brief ͨOSD
 * @attention
 */
typedef struct tagNETDEVChlOsdCfg
{
    INT32 dwOsdID;                                      /* OSD ID */
    NETDEV_OSD_TEXT_TYPE_E enOsdTextType;               /* OSD */
    NETDEV_AREA_SCOPE_S stAreaScope;                    /* OSD */
    CHAR szTextInfo[NETDEV_OSD_TEXT_MAX_LEN];           /* OSD */
}NETDEV_CHL_OSD_CFG_S, *LPNETDEV_CHL_OSD_CFG_S;

/**
 * @struct tagNETDEVChlOsdCfgList
 * @brief ͨOSDб
 * @attention
 */
typedef struct tagNETDEVChlOsdCfgList
{
    INT32 dwSize;                                               /* OSD */
    NETDEV_CHL_OSD_CFG_S stChlOsdCfg[NETDEV_OSD_MAX_NUM_EX];    /* OSD */
}NETDEV_CHL_OSD_CFG_LIST_S, *LPNETDEV_CHL_OSD_CFG_LIST_S;

/**
 * @struct tagNETDEVNetworkInfo
 * @brief Ϣ
 * @attention  None
 */
typedef struct tagNETDEVNetworkInfo
{
    CHAR    szIPAddress[NETDEV_LEN_32];         /* IPַ  */
    INT32   dwHttpPort;                         /* Http˿ */
    INT32   dwRtspPort;                         /* Rtsp˿ */

}NETDEV_NETWORKINFO_S, *LPNETDEV_NETWORKINFO_S;

 /**
 * @struct tagNETDEVNetworkPortsInfo
 * @brief ˿Ϣ
 * @attention  None
 */
typedef struct tagNETDEVNetworkPortsInfo
{
    UINT32   udwHttpPort;                         /* Http˿ */
    UINT32   udwHttpsPort;                        /* Https˿ */
    UINT32   udwRtspPort;                         /* Rtsp˿ */

    BYTE    byRes[64];              /* ֶ  Reserved field */
}NETDEV_NETWORK_PORTS_INFO_S, *LPNETDEV_NETWORK_PORTS_INFO_S;

/**
 * @struct tagstNETDEVBandWith
 * @brief ״̬
 * @attention 
 */
typedef struct tagstNETDEVBandWith
{
    UINT32 udwTotal;                /*ܴ*/
    UINT32 udwLive;                 /*ʵռô*/
    UINT32 udwReplayAndDown;        /*ط/ռô*/
    UINT32 udwResidual;             /*ʣ*/
}NETDEV_NETWORK_BANDWIDTH_S, *LPNETDEV_NETWORK_BANDWIDTH_S;

/**
* @struct tagsNETDEVStreamNum
* @brief ·
* @attention
*/
typedef struct tagNETDEVStreamNum
{
    INT32   dwCurrent;              /* ʵ·,· */
    INT32   dwTotal;                /* · */
}NETDEV_STREAM_NUM_S, *LPNETDEV_STREAM_NUM_S;

/**
 * @struct tagstNETDEVBandWithInfo
 * @brief ״̬
 * @attention 
 */
typedef struct tagstNETDEVBandWithInfo
{
    NETDEV_NETWORK_BANDWIDTH_S stInputBandWidth;
    NETDEV_NETWORK_BANDWIDTH_S stOutputBandWidth;
    NETDEV_STREAM_NUM_S stStreamNum;
}NETDEV_NETWORK_BANDWIDTH_INFO_S, *LPNETDEV_NETWORK_BANDWIDTH_INFO_S;


/**
 * @struct tagstNETDEVOperateInfo
 * @brief Ϣ
 * @attention dwIDΪΣdwReturnCodeΪ
 */
typedef struct tagNETDEVOperateInfo
{
    INT32   dwID;                   /* ID */
    INT32   dwReturnCode;           /* */
    BYTE    byRes[64];              /* ֶ  Reserved field */
}NETDEV_OPERATE_INFO_S, *LPNETDEV_OPERATE_INFO_S;

/**
 * @struct tagstNETDEVOperateList
 * @brief б
 * @attention
 */
typedef struct tagNETDEVOperateList
{
    INT32   dwSize;                                 /*  */
    LPNETDEV_OPERATE_INFO_S   pstOperateInfo;       /* Ϣ */
}NETDEV_OPERATE_LIST_S, *LPNETDEV_OPERATE_LIST_S;


/**
* @struct tagNETDEVTrafficStatisticsCondEx
* @brief ͨͳ ṹ嶨
* @attention  None
*/
typedef struct tagNETDEVMultiTrafficStatisticsCond
{
    NETDEV_OPERATE_LIST_S   stChannelIDs;               /* ͨIDб */
    UINT32                  udwStatisticsType;          /* μ NETDEV_TRAFFIC_STATISTICS_TYPE_E */
    UINT32                  udwFormType;                /* μ NETDEV_TRAFFIC_STATIC_FORM_TYPE_E */
    INT64                   tBeginTime;                 /* ʼʱ */
    INT64                   tEndTime;                   /* ʱ */
    BYTE                    byRes[256];
}NETDEV_MULTI_TRAFFIC_STATISTICS_COND_S, *LPNETDEV_MULTI_TRAFFIC_STATISTICS_COND_S;

/**
* @struct tagNETDEVFaceDetectionCapInfo
* @brief  ṹ嶨
* @attention  None
*/
typedef struct tagNETDEVFaceDetectionCapInfo 
{
    BOOL bIsSupport;                                                    /* Ƿ֧Smart */
    BOOL bQualityAnalysisIsSupport;                                     /* ǷȣϱͼƬ */
    INT32 dwFaceQualityAnalysisType;                                    /* , οöNETDEV_FACE_ANALYSIS_SKILL_E */
    BOOL bAttributeAnalysisIsSupport;                                   /* 豸߱ǷԷϱ */
    INT32 adwAttributeAnalysisSkills[NETDEV_FACE_ANALYSIS_SKILL_NUM];   /* 豸οö Ϊ0ʱöԲ */
    BOOL bFeatureIsSupport;                                             /* 豸Ƿȡϱ */
    BOOL bRecognitionIsSupport;                                         /* 豸Ƿʶ */
    INT32 dwFaceRecognitionType;                                        /*ʶ, οöNETDEV_FACE_RECOGNITION_TYPE_E */
    BOOL bPersonSnapshotSupport;                                        /* 豸߱Ƿץģϱ 0: ָ֧ 1: ָ֧ */
    BYTE byRes[256];                                                    /* ֽ */
}NETDEV_FACE_DETEC_CAP_S, *LPNETDEV_FACE_DETEC_CAP_S;

/**
* @struct tagNETDEVIntrusionDetectionCapInfo
* @brief  ṹ嶨
* @attention  None
*/
typedef struct tagNETDEVIntrusionDetectionCapInfo 
{
    BOOL bIsSupport;                        /* Ƿ֧ */
    INT32 dwPecentMin;                      /* Уͼռ(Percentages)Сֵ, ֧ʱֶοѡ */
    INT32 dwPecentMax;                      /* Уͼռ(Percentages)ֵ, ֧ʱֶοѡ */
    INT32 dwTimeThresholdMin;               /* Уʱֵ(TimeThreshold)Сֵ, ֧ʱֶοѡ */
    INT32 dwTimeThresholdMax;               /* Уʱֵ(TimeThreshold)ֵ, ֧ʱֶοѡ */
    BYTE bRes[32];                          /* ֶ */
}NETDEV_INTRUSION_DETEC_CAP_S, *LPNETDEV_INTRUSION_DETEC_CAP_S;

/**
* @struct tagNETDEVCrossLineDetectionCapInfo
* @brief Խ ṹ嶨
* @attention  None
*/
typedef struct tagNETDEVCrossLineDetectionCapInfo
{
    BOOL bIsSupport;                /* Ƿ֧Խ */
    BYTE bRes[32];                  /* ֶ */
}NETDEV_CROSS_LINE_DETEC_CAP_S, *LPNETDEV_CROSS_LINE_DETEC_CAP_S;

/**
* @struct tagNETDEVPassengerFlowCapInfo
* @brief  ṹ嶨
* @attention  None
*/
typedef struct tagNETDEVPassengerFlowCapInfo
{
    BOOL bIsSupport;                /* Ƿֿ֧ */
    BYTE bRes[32];                  /* ֶ */
}NETDEV_PASSENGER_FLOW_CAP_S, *LPNETDEV_PASSENGER_FLOW_CAP_S;


/**
* @struct tagNETDEVAudioDetectionCapInfo
* @brief Ƶ ṹ嶨
* @attention  None
*/
typedef struct tagNETDEVAudioDetectionCapInfo
{
    BOOL bIsSupport;    /* Ƿ֧Ƶ */
    INT32 dwDiffMin;    /* ƵУֵ/ֵСֵ, ֧Ƶʱֶοѡ */
    INT32 dwDiffMax;    /* ƵУֵ/ֵֵ, ֧Ƶʱֶοѡ  */
}NETDEV_AUDIO_DETEC_CAP_S, *LPNETDEV_AUDIO_DETEC_CAP_S;

/**
* @struct tagNETDEVObjTrackCapInfo
* @brief ܸ ṹ嶨
* @attention  None
*/
typedef struct tagNETDEVObjTrackCapInfo
{
    BOOL bIsSupport;                                /* Ƿ֧ܸ */
    INT32 adwMode[NETDEV_OBJ_TRACK_MODE_NUM];       /* ģʽ,οöNETDEV_OBJ_TRACK_MODE_E֧ܸʱѡ */
    INT32 dwTrackTimeMin;                           /* Сʱ䣨λsģʽNETDEV_OBJ_TRACK_MODE_FULLVIEWʱѡ */
    INT32 dwTrackTimeMax;                           /* ʱ䣨λsģʽNETDEV_OBJ_TRACK_MODE_FULLVIEWʱѡ */
}NETDEV_OBJ_TRACK_CAP_S, *LPNETDEV_OBJ_TRACK_CAP_S;

/**
* @struct tagNETDEVMixDetectionCapInfo
* @brief м
* @attention  None
*/
typedef struct tagNETDEVMixDetectionCapInfo
{
    BOOL bIsSupported;                               /* Ƿֻ֧м 0: ֧ 1: ֧ */
    BYTE bRes[128];                                  /* ֶ */
}NETDEV_MIX_DETECTION_INFO_S,*LPNETDEV_MIX_DETECTION_INFO_S;

/**
* @struct tagNETDEVMasterSlaveLinkCapInfo
* @brief ֧ģʽ
* @attention  None
*/
typedef struct tagNETDEVMasterSlaveLinkCapInfo
{
    UINT32 udwSupportMode;                          /* ֧ģʽ  NETDEV_MASTER_SLAVE_LINKAGE_E*/
    BYTE bRes[32];                                  /* ֶ */
}NETDEV_MASTER_SLAVE_LINK_CAP_S,*LPNETDEV_MASTER_SLAVE_LINK_CAP_S;

/**
* @struct tagNETDEVObjAttrOverlayCapInfo
* @brief Ϣ
* @attention  None
*/
typedef struct tagNETDEVObjAttrOverlayCap
{
    BOOL bSupportAttrOverlay;                       /* Ƿ֧ϢӣFALSE:֧֣TRUE:֧ */
    BYTE bRes[32];                                  /* ֶ */
}NETDEV_OBJ_ATTR_OVERLAY_CAP_S,*LPNETDEV_OBJ_ATTR_OVERLAY_CAP_S;

/**
* @struct tagNETDEVSmartCapInfo
* @brief smart ṹ嶨
* @attention  None
*/
typedef struct tagNETDEVSmartCapInfo
{
    NETDEV_FACE_DETEC_CAP_S         stFaceDetecCap;                 /*  */
    NETDEV_INTRUSION_DETEC_CAP_S    stIntrusionDetecCap;            /*  */
    NETDEV_CROSS_LINE_DETEC_CAP_S   stCrossLineDetecCap;            /* Խ */
    NETDEV_PASSENGER_FLOW_CAP_S     stPassengerFlowCap;             /*  */
    NETDEV_AUDIO_DETEC_CAP_S        stAudioDetecCap;                /* Ƶ */
    NETDEV_OBJ_TRACK_CAP_S          stObjTrackCap;                  /* ܸ */
    NETDEV_MIX_DETECTION_INFO_S     stMixDetectionCap;              /* м */
    NETDEV_MASTER_SLAVE_LINK_CAP_S  stMasterSlaveCap;               /*  */
    NETDEV_OBJ_ATTR_OVERLAY_CAP_S   stObjAttrOverlayCap;            /* Ϣ */
    BYTE byRes[476];                                                /* ֶ */
}NETDEV_SMART_CAP_S, *LPNETDEV_SMART_CAP_S;

/**
* @struct tagNETDEVTrafficStatisticsReportTime
* @brief ÿϱʱṹ
* @attention  None
*/
typedef struct tagNETDEVTrafficStatisticsReportTime
{
    UINT32  udwReportTimeInterval;      /*ʱ λ*/
    BOOL    bEnable;                    /*ʹ*/
}NETDEV_TRAFFIC_STATISTICS_REPORT_TIME_S, *LPNETDEV_TRAFFIC_STATISTICS_REPORT_TIME_S;

/**
 * @struct tagNETDEVChlDeviceInfo
 * @brief 豸ͨϢ ṹ嶨 Basic device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVChlDeviceInfo
{
    INT32 dwChannelID;                                  /* ͨ */
    CHAR szDevModel[NETDEV_LEN_64];                     /* 豸ͺ  Device model */
    CHAR szSerialNum[NETDEV_LEN_64];                    /* Ӳк  Hardware serial number */
    CHAR szFirmwareVersion[NETDEV_LEN_64];              /* 汾  Software version */
    CHAR szHardewareID[NETDEV_LEN_64];                  /* Ӳʶ */
    CHAR szUbootVersion[NETDEV_LEN_64];                 /* UBOOT汾 */
    BYTE byRes[512];                                    /*   Reserved */
}NETDEV_DEVICE_CHL_INFO_S, *LPNETDEV_DEVICE_CHL_INFO_S;


/**
 * @struct tagNETDEVNewVersionDateInfo
 * @brief °汾ʱ ṹ嶨 
 * @attention  None
 */
typedef struct tagNETDEVNewVersionDateInfo
{
    UINT32 udwYear;         /*   Year */
    UINT32 udwMonth;        /*   Month */
    UINT32 udwDay;          /*   Day */
    UINT32 udwHour;         /* ʱ  Hour */
    UINT32 udwMinute;       /*   Minute */
    BYTE   byRes[64];       /* ֶ */
}NETDEV_NEW_VERSION_DATE_INFO_S, *LPNETDEV_NEW_VERSION_DATE_INFO_S;


/**
 * @struct tagNETDEVUpgradeInfo
 * @brief 豸汾Ϣ ṹ嶨 
 * @attention  None
 */
typedef struct tagNETDEVUpgradeInfo
{
    BOOL                            bHasNewVersion;                             /* Ƿ°汾 0:û°汾 1:°汾*/
    CHAR                            szNewFirmwareVersion[NETDEV_LEN_64];        /* µ汾 bHasNewVersionΪ0ʱýڵѡ*/
    UINT32                          udwID;                                      /* IDΪ0Ĭ豸*/
    NETDEV_NEW_VERSION_DATE_INFO_S  stNewVersionDateInfo;                       /* °汾ķʱ䣬HasNewVersionΪ0ʱýڵѡNVRҪ#NETDEV_NEW_VERSION_DATE_INFO_S*/
    CHAR                            szVersionDescription[NETDEV_LEN_1024];      /* 汾*/
    BYTE                            byRes[256];                                 /* ֶ */
}NETDEV_UPGRADE_INFO_S, *LPNETDEV_UPGRADE_INFO_S;

/**
 * @struct tagNETDEVUpgradeDevice
 * @brief 豸Ϣ ṹ嶨 Basic device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVUpgradeDevice
{
    INT32 dwUpgradeType;                    /*  οö#NETDEV_UPGRADE_TYPE_E */
    INT32 dwSize;                           /* ͨ ,Ϊ0ʱĬϸNVR */
    INT32 adwChannelID[NETDEV_CHANNEL_MAX]; /* ͨ */
    CHAR  szPath[NETDEV_PATH_LEN];          /* ļ· */
    BYTE  byRes[256];                       /*   Reserved */
}NETDEV_UPGRADE_DEVICE_S, *LPNETDEV_UPGRADE_DEVICE_S;

/**
 * @struct tagNETDEVUpgradeStatus
 * @brief 豸״̬Ϣ ṹ嶨 Basic device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVUpgradeStatus
{
    INT32 dwStatus;             /* ״̬,οö#NETDEV_UPGRADE_STATUS_E */
    INT32 dwPercent;            /* ٷֱ */
    INT32 dwChannelID;          /* ͨ */
    BYTE  byRes[256];           /* ֶ */
}NETDEV_UPGRADE_STATUS_S, *LPNETDEV_UPGRADE_STATUS_S;

/**
* @enum tagNETDEVAddChnType
* @brief  öٶ
* @attention  None
*/
typedef enum tagNETDEVAddChnType
{
    NETDEV_ADDCHN_ADDR_TYPE_IP                   = 0,           /* IP */
    NETDEV_ADDCHN_ADDR_TYPE_PLUG_PLAY            = 1,           /* 弴 */
    NETDEV_ADDCHN_ADDR_TYPE_EZDDNS               = 2,           /* EZDDNS */
    NETDEV_ADDCHN_ADDR_TYPE_DOMAIN_NAME          = 3,           /* ͨ */

    NETDEV_ADDCHN_ADDR_TYPE_INVALID           = 0xFF         /* Чֵ  Invalid value */
}NETDEV_ADDCHN_ADD_TYPE_E;

/**
 * @struct tagNETDEVChannelsBasicInfo
 * @brief ͨϢ
 * @attention  None
 */
typedef struct tagNETDEVChannelsBasicInfo
{
    UINT32                      udwAddType;                                     /* , μö NETDEV_ADDCHN_ADD_TYPE_E */
    UINT32                      udwAddressType;                                 /* IPַ, .udwAddTypeΪ23ʱ, ˴2.μö NETDEV_HOSTTYPE_E */
    CHAR                        szAddress[NETDEV_IPADDR_STR_MAX_LEN];           /* IPַ, Χ[0,64]*/
    CHAR                        szDDNSAdress[NETDEV_DOMAIN_LEN];                /* DDNSַ, Χ[0,64], udwAddTypeΪ2ʱ, ѡѡ. */
    UINT32                      udwPort;                                        /* ˿ں,Χ[1, 65535]udwAddTypeΪ03ʱ, ѡѡ*/ 
    CHAR                        szLoginName[NETDEV_NAME_MAX_LEN];               /* 豸ĵ¼û, Χ[0,20]*/
    CHAR                        szPIN[NETDEV_LEN_256];                          /* 豸ĵ¼, ʱ, û޸, Բ·ֶ; ʱ, Ϊ, ·ֶ*/
    UINT32                      udwAccessProtocol;                              /* Э, μö 1-ONVIF, 2-˽, 3-, [100-131]-ԶЭ */
    UINT16                      udwNum;                                         /* 豸ͨ, Χ[0, 16] */
    UINT32                      audwRemoteIndexList[NETDEV_CHANNEL_MAX];        /* 豸ͨб, NumΪ0ʱ˽ڵѡ */
    UINT32                      udwRemoteIndex;                                 /* ͨ豸ͨ(޸Ϣʱʹ)*/ 
    NETDEV_GBINFO_S             stGBInfo;                                       /* Ϣ udwAccessProtocolֵΪ3ʱýڵѡ, ѡ*/
    UINT32                      udwIsPTZNeeded;                                 /* ǷҪ̨: 0-Ӧ, 1-Ҫ, 2-Ҫ */
    BOOL                        bLongHaulEnabled;                               /* 봫ʹܣ0: ʹ; 1: ʹ; udwAddTypeֵΪ1ʱ, ˽ڵѡ(޸Ϣʱʹ)*/
    BYTE                        byRes[256];                                     /* ֽ */
}NETDEV_CHANNEL_BASIC_INFO_S, *LPNETDEV_CHANNEL_BASIC_INFO_S;

/**
 * @struct tagNETDEVChannelsInfos
 * @brief ͨϢ
 * @attention  None
 */
typedef struct tagNETDEVChannelsInfos
{
    UINT32   udwNum;                                    /* ͨ, Ϊ0*/
    UINT32   audwChannelList[NETDEV_CHANNEL_MAX];       /* ͨб*/
    BYTE     byRes[128];                                /* ֽ */
}NETDEV_CHANNEL_LIST_S, *LPNETDEV_CHANNEL_LIST_S;

/**
 * @struct tagNETDEVAudioDecodeStatus
 * @brief ·Ƶ״̬Ϣ
 * @attention  None
 */
typedef struct tagNETDEVAudioDecodeStatus
{
    INT32 dwStreamID;       /* Ƶ */
    BOOL  bDecodeAudio;     /* Ƿ·Ƶ */
}NETDEV_AUDIO_DECODE_STATUS_S, *LPNETDEV_AUDIO_DECODE_STATUS_S;

/**
 * @struct tagNETDEVAudioDecodeStatusList
 * @brief ·Ƶ״̬Ϣб
 * @attention  None
 */
typedef struct tagNETDEVAudioDecodeStatusList
{
    INT32 dwSize;   /*  */
    NETDEV_AUDIO_DECODE_STATUS_S astAudioDecStatus[NETDEV_STREAM_MAX_NUM];  /* ·Ƶ״̬Ϣ */
}NETDEV_AUDIO_DECODE_STATUS_LIST_S, *LPNETDEV_AUDIO_DECODE_STATUS_LIST_S;


/**
* @struct tagNETDEVAudioInputEncodeFormatInfo
* @brief ƵʽϢ
* attention None
*/
typedef struct tagNETDEVAudioInputEncodeFormatInfo
{
    UINT32 udwType;                                                         /* Ƶʽͣμö#NETDEV_AUDIO_ENCODE_FORMAT_TYPE_E */
    UINT32 udwSamplingRateNum;                                              /* ֵ֧ĲĿ */
    UINT32 audwSamplingRateList[NETDEV_AUDIO_SAMPLING_RATE_MAX_NUM];        /* ֵ֧Ĳб μö#NETDEV_AUDIO_SAMPLING_RATE_E */
    BYTE   byRes[128];                                                      /* ֽ */
}NETDEV_AUDIO_IN_ENCODE_FORMAT_INFO_S, *LPNETDEV_AUDIO_IN_ENCODE_FORMAT_INFO_S;

/**
* @struct tagNETDEVAudioInputModeInfo
* @brief ƵģʽϢ
* attention None
*/
typedef struct tagNETDEVAudioInputModeInfo
{
    INT32  dwChannelID;                                         /* Ƶͨ */
    UINT32 udwModeNum;                                          /* Ƶģʽ */
    UINT32 audwModeList[NETDEV_AUDIO_IN_CHL_MODE_MAX_NUM];      /* ֵ֧Ƶͨģʽб μö#NETDEV_AUDIO_CHL_MODE_E */
    BYTE   byRes[128];                                          /* ֽ */
}NETDEV_AUDIO_IN_MODE_INFO_S, *LPNETDEV_AUDIO_IN_MODE_INFO_S;

/**
 * @struct tagNETDEVAudioCapInfo
 * @brief ƵͨƵϢ
 * @attention  None
 */
typedef struct tagNETDEVAudioCapInfo
{
    INT32                                   dwAudioInNum;                                                   /* ֵ֧ƵĿ */
    NETDEV_AUDIO_IN_MODE_INFO_S             astAudioInModeList[NETDEV_AUDIO_IN_MAX_NUM];                    /* Ƶģʽб */
    INT32                                   dwAudioInEncFmtNum;                                             /* ֵ֧Ƶʽ */
    NETDEV_AUDIO_IN_ENCODE_FORMAT_INFO_S    astAudioInEncFmtList[NETDEV_AUDIO_IN_ENCODE_FORMAT_MAX_NUM];    /* ֵ֧Ƶʽб */
    INT32                                   dwSerialInNum;                                                  /* ֵ֧ĴĿʰ */
    NETDEV_AUDIO_IN_MODE_INFO_S             astSerialInModeList[NETDEV_SERIAL_IN_MAX_NUM];                  /* ģʽб */
    INT32                                   dwSerialInEncFmtNum;                                      /* ֵ֧ıʽ */
    NETDEV_AUDIO_IN_ENCODE_FORMAT_INFO_S    astSerialInEncFmtList[NETDEV_SERIAL_IN_ENCODE_FORMAT_MAX_NUM];  /* ֵ֧ıʽб */
    BYTE                                    byRes[256];                                                     /* ֶ */
}NETDEV_AUDIO_CAP_S, *LPNETDEV_AUDIO_CAP_S;

/**
* @struct tagNETDEVAudioInputInfo
* @brief ƵͨϢ
* attention None
*/
typedef struct tagNETDEVAudioInputInfo
{
    INT32  dwChannelID;     /* Ƶͨ */
    UINT32 udwEnabled;      /* ƵͨǷ */
    UINT32 udwMode;         /* Ƶͨģʽ μö#NETDEV_AUDIO_CHL_MODE_E */
    BYTE   byRes[128];      /* ֽ */
}NETDEV_AUDIO_INPUT_INFO_S, *LPNETDEV_AUDIO_INPUT_INFO_S;

/**
 * @struct tagNETDEVAudioInputCfgInfo
 * @brief ƵϢ
 * @attention  None
 */
typedef struct tagNETDEVAudioInputCfgInfo
{
    BOOL bIsMute;                                                                   /* Ƿ 01  */
    UINT32 udwType;                                                                 /* ɼ μö#NETDEV_AUDIO_COLLECTION_PORT_TYPE_E */
    UINT32 udwEncodeFormat;                                                         /* Ƶʽ μö#NETDEV_AUDIO_ENCODE_FORMAT_TYPE_E */
    UINT32 udwSampleRate;                                                           /* Ƶ μö#NETDEV_AUDIO_SAMPLING_RATE_E */
    UINT32 udwInputGain;                                                            /* Ƶ棬Χ[0,255] */
    BOOL bNoiseReductionEnabled;                                                    /* Ƿý 0ã1 */
    INT32 dwAudioInNum;                                                             /* Ƶ */
    NETDEV_AUDIO_INPUT_INFO_S astAudioInputInfoList[NETDEV_AUDIO_IN_MAX_NUM];       /* ƵɼϢбɼΪNETDEV_AUDIO_COLLECTION_PORT_TYPE_AUDIO_INʱЧ */
    INT32 dwSerialInNum;                                                            /*  */
    NETDEV_AUDIO_INPUT_INFO_S astSerialInputInfoList[NETDEV_SERIAL_IN_MAX_NUM];     /* ƵɼϢб */
    BYTE  byRes[256];                                                               /* ֶ */
}NETDEV_AUDIO_INPUT_CFG_INFO_S, *LPNETDEV_AUDIO_INPUT_CFG_INFO_S;


/**
 * @struct tagNETDEVTimeSection
 * @brief ʱ ṹ嶨 Time Sections Structure definition
 * @attention  None
 */
typedef struct tagNETDEVTimeSection
{
    CHAR    szBeginTime[NETDEV_LEN_64];              /* ʼʱ  Begin time */
    CHAR    szEndTime[NETDEV_LEN_64];                /* ʱ  End time */
}NETDEV_TIME_SECTION_S, *LPNETDEV_TIME_SECTION_S;

/**
 * @struct tagNETDEVDayPlan
 * @brief ƻ죩 ṹ嶨 Play (Day) Structure definition
 * @attention  None
 */
typedef struct tagNETDEVDayPlan
{
    UINT32                       udwIndex;                                                  /*   day index */
    UINT32                       udwSectionNum;                                             /* ʱθ  Section Num */
    NETDEV_TIME_SECTION_S        astTimeSection[NETDEV_PLAN_TIME_SECTION_NUM_ADAY];         /* ʱ  Time Sections */
}NETDEV_DAY_PLAN_S, *LPNETDEV_DAY_PLAN_S;

/**
 * @struct tagNETDEVPlanWeek
 * @brief ƻܣ ṹ嶨 Play (Week) Structure definition
 * @attention  None
 */
typedef struct tagNETDEVPlanWeek
{
    UINT32              udwDayNum;                                  /*   day num*/
    NETDEV_DAY_PLAN_S   astDayPlan[NETDEV_PLAN_DAY_NUM_AWEEK];      /*   days */
}NETDEV_WEEK_PLAN_S, *LPNETDEV_WEEK_PLAN_S;


/**
 * @struct tagNETDEVPointS
 * @brief 
 * @attention
 */
typedef struct tagNETDEVPointS
{
    INT32 dwPointX;     /* ,ֱ */
    INT32 dwPointY;     /* ,ֱ */
}NETDEV_POINT_S, *LPNETDEV_POINT_S;

/**
 * @struct tagNETDEVCustomFileInfo
 * @brief 豸Ϣ ṹ嶨 Basic device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVCustomFileInfo
{
    CHAR  szCustomFilePath[NETDEV_PATH_LEN];              /* ļ· */
    CHAR  szMd5Data[NETDEV_LEN_64];                       /* ļMd5ֵ */
    BYTE  byRes[256];                                     /*   Reserved */
}NETDEV_CUSTOM_FILE_INFO_S, *LPNETDEV_CUSTOM_FILE_INFO_S;

/**
 * @struct tagNETDEVNetworkDiagnosis
 * @brief Ϣ Network Diagnosis
 * @attention  None
 */  
typedef struct tagNETDEVNetworkDiagnosis
{
    UINT32    dwPacketSize;             /* ĴС(λ:byte) */
    UINT32    dwPacketNum;              /*  */
    UINT32    dwDuration;               /* ʱ(λ:s) */
    CHAR      szUrl[NETDEV_LEN_260];    /* ϱķURL */
} NETDEV_NETWORK_DIAGNOSIS_S, *LPNETDEV_NETWORK_DIAGNOSIS_S;

/**
* @struct tagNETDEVAlarmFindConds
* @brief 澯Ϣ ṹ嶨
* @attention 
*/
typedef struct tagNETDEVAlarmFindConds
{
    INT32   dwChannelID;      /* ͨID */
    INT64   tBeginTime;       /* ʼʱ */
    INT64   tEndTime;         /* ʱ */
    BYTE    byRes[128];       /* ֶ  Reserved */
}NETDEV_FIND_ALARM_COND_S, *LPNETDEV_FIND_ALARM_COND_S;

/**
* @struct tagNETDEVFindAlarmInfo
* @brief 澯Ϣ ṹ嶨
* @attention 
*/
typedef struct tagNETDEVFindAlarmInfo
{
    INT64    tAlarmTime;        /* 澯ʱ */
    INT32    dwAlarmType;       /* 澯, ο#NETDEV_FIND_ALARM_TYPE_E */
    BYTE     byRes[256];        /* ֶ  Reserved */
}NETDEV_FIND_ALARM_INFO_S, *LPNETDEV_FIND_ALARM_INFO_S;


/**
 * @struct tagNETDEVSDKInfo
 * @brief SDKϢ
 * @attention  None
 */
typedef struct tagNETDEVSDKInfo
{
    CHAR szSDKType[NETDEV_LEN_64];                   /* SDK */
    CHAR szSDKVersion[NETDEV_LEN_64];                /* SDK汾 */
}NETDEV_SDK_INFO_S, *LPNETDEV_SDK_INFO_S;

/**
 * @struct tagNETDEVSplitScreenInfo
 * @brief Ϣ
 * @attention  None
 */
typedef struct tagNETDEVSplitScreenInfo
{
    INT32 dwOperatedMode;           /* ģʽ, NETDEV_OPERATED_MODE_E*/
    INT32 dwSplitScreenIndex;       /*  */

}NETDEV_SPLIT_SCREEN_INFO_S, *LPNETDEV_SPLIT_SCREEN_INFO_S;

/**
 * @struct tagNETDEVAlarmDeviceInfo
 * @brief 澯豸Ϣ ṹ嶨 Alarm device information Structure definition
 * @attention   
 1.ͨŽڸ澯ԴƵͨͺͱͨʱ,dwChannelIDĬΪ0,
 2.澯ԴͲμNETDEV_ALARM_SRC_TYPE_E ҪȡϢɲμNETDEV_ALARM_LISTEN_INFO_SеdwAlarmSrcIDֶΡ
 */
typedef struct tagNETDEVAlarmDeviceInfo
{
    CHAR    pszIP[16];      /* 豸IP device IP */
    INT32   dwChannelID;    /* ͨ */
    BYTE    byRes[128];     /* ֶ  Reserved */

}NETDEV_ALARM_DEVICE_INFO_S, *LPNETDEV_ALARM_DEVICE_INFO_S;

/**
 * @struct tagNETDEVAlarmListenInfo
 * @brief 澯Ϣ ṹ嶨 Alarm device information Structure definition
 * @attention  
 澯ԴID ʹù
 1. AlarmSrcTypeΪ0-7AlarmSrcID洢
 2. AlarmSrcTypeΪ8AlarmSrcIDƵͨš
 3. AlarmSrcTypeΪ9AlarmSrcIDͨš
 4.AlarmSrcTypeΪ10,AlarmSrcIDĬΪ0,ϵͳ 
 */
typedef struct tagNETDEVAlarmListenInfo
{
    INT32   dwAlarmType;                /*澯 μö#NETDEV_ALARM_TYPE_E */
    INT32   dwAlarmSrcType;             /*澯Դ μö#NETDEV_ALARM_SRC_TYPE_E*/
    INT64   tAlarmTime;                 /* 澯ʱ  Alarm time */
    INT32   dwAlarmSrcID;               /* 澯ԴID */
    CHAR    szAlarmSrcName[128];        /*澯Դ VMSʹ*/
    INT32   dwAlarmSeq;                 /*澯 IPC & VMSʹ*/
    BYTE    byRes[128];                 /* ֶ  Reserved */
}NETDEV_ALARM_LISTEN_INFO_S,*LPNETDEV_ALARM_LISTEN_INFO_S;

/**
 * @struct tagNETDEVDiagnosisInfoURL
 * @brief ϢURL
 * @attention
 */
typedef struct tagNETDEVDiagnosisInfoURL
{
    CHAR   szURL[NETDEV_LEN_256];      /* ϢURL */
}NETDEV_DIAGNOSIS_INFO_URL_S, *LPNETDEV_DIAGNOSIS_INFO_URL_S;


/**
 * @struct tagNETDEVDiagnosisInfo
 * @brief Ϣ
 * @attention
 */
typedef struct tagNETDEVDiagnosisInfo
{
    INT32    dwTime;                          /* ļʱ */
    CHAR     szFileName[NETDEV_LEN_64];       /* ļ */
    INT32    dwSize;                          /* ļС */
}NETDEV_DIAGNOSIS_INFO_S, *LPNETDEV_DIAGNOSIS_INFO_S;
/**
 * @struct tagNETDEVDownDiagnosisFileInfo
 * @brief ļϢ
 * @attention
 */
typedef struct tagNETDEVDownDiagnosisFileInfo
{
    CHAR    szURL[NETDEV_MAX_URL_LEN];         /* ϢURL */
    BOOL    bSaveLocal;                        /* Ƿ񱣴ڱأTUREʾ汾أFALSEʾд뻺*/
    CHAR    szFileName[NETDEV_LEN_260];        /* Ϣı·*/
    CHAR*   pcBuffer;                          /* Ϣ,ͻڴ棬СΪdwSizeС*/
    INT32   dwSize;                            /* С*/
    BYTE    byRes[256];                        /* ֶ Reserved */
}NETDEV_DIAGNOSIS_FILE_INFO_S, *LPNETDEV_DIAGNOSIS_FILE_INFO_S;


/**
* @struct tagNETDEVFaceGalleyInfo
* @brief Ϣ
* @attention
*/
typedef struct tagNETDEVFaceGalleyInfo
{
    CHAR    szGalleyID[NETDEV_FACE_FEATURE_GALLEY_ID_LEN];          /* ID */
    UINT32  udwGalleyType;                                          /*  μö NETDEV_FACE_DB_TYPE_E*/
    UINT32  udwFeatureDataLen;                                      /* ⾻ܳ λֽ*/
    CHAR    szFeatureVersion[NETDEV_FACE_FEATURE_VERSION_LEN];      /* ģͰ汾 Ϊchar[40]*/
    CHAR    szFeatureFileMD5[NETDEV_FACE_FEATURE_FILE_MD5_LEN];     /* ⾻ɵMD5ֵ 128*/
    BYTE    byRes[128];                                             /* ֶ  Reserved */
}NETDEV_FACE_GALLEY_INFO_S, *LPNETDEV_FACE_GALLEY_INFO_S;

/**
* @struct tagNETDEVFaceDBImportNumInfo
* @brief ϵͳ⵼Ϣ
* @attention
*/
typedef struct tagNETDEVFaceDBImportNumInfo
{
    UINT32  udwMaxNum;      /* ϵͳԱ*/
    UINT32  udwImportSum;   /* ѵԱ*/
    UINT32  udwFaceDBNum;   /* */

    BYTE    byRes[128];     /* ֶ  Reserved */
}NETDEV_FACE_DB_IMPORT_NUM_INFO_S, *LPNETDEV_FACE_DB_IMPORT_NUM_INFO_S;

/**
* @struct tagNETDEVFaceDBMemberImportInfo
* @brief ԱϢ
* @attention
*/
typedef struct tagNETDEVFaceDBMemberImportInfo
{
    UINT32  udwFaceDBID;            /* ID*/
    UINT32  udwFaceDBMemberNum;     /* ѵԱ*/

    BYTE    byRes[128];             /* ֶ  Reserved */
}NETDEV_FACEDB_MEMBER_IMPORT_INFO_S, *LPNETDEV_FACEDB_MEMBER_IMPORT_INFO_S;

/**
 * @struct tagNETDEVModifyPasswordInfo
 * @briefû
 * @attention 
 */
typedef struct tagNETDEVModifyPasswordInfo
{
    CHAR szUserName[NETDEV_LEN_260];    /* û */
    CHAR szNewPIN[NETDEV_LEN_256];      /* û */
    CHAR szCurrentPIN[NETDEV_LEN_256];  /* ûԭ */
    BYTE byRes[128];                    /* ֶ */
}NETDEV_MODIFY_PASSWORD_INFO_S,*LPNETDEV_MODIFY_PASSWORD_INFO_S;

/**
 * @enum tagNETDEVDevManageInfo
 * @brief 豸Ϣ
 * @attention  None
 */
typedef struct tagNETDEVDevManageInfo
{
    CHAR    szSerailNum[NETDEV_LEN_64];     /* к */
    CHAR    szActiveCode[NETDEV_LEN_64];    /*  */
}NETDEV_DEV_MANAGE_INFO_S, *LPNETDEV_DEV_MANAGE_INFO_S;

/**
 * @struct tagNETDEVImagingEnhance
 * @brief ָͨͼǿ ṹ嶨    Device image settings Structure definition
 * @attention udwBrightness,udwContrast,udwSaturation,udwSharpness,udw2DNoiseReduce ȡֵΧ0-255    
              udwBrightness,udwContrast,udwSaturation,udwSharpness,udw2DNoiseReduce parameter range: 0-255
 */
typedef struct tagNETDEVImagingEnhance
{
    UINT32 udwBrightness;                 /*   Brightness */
    UINT32 udwContrast;                   /* Աȶ  Contrast */
    UINT32 udwSaturation;                 /* Ͷ  Saturation */
    UINT32 udwSharpness;                  /*   Sharpness */
    UINT32 udwImageRotation;              /* ͼģʽ */
    UINT32 udw2DNoiseReduce;              /* 2D */
    UINT32 udw3DNoiseReduce;              /* 3D */
    BYTE  byRes[252];                     /* ֶ  Reserved */
}NETDEV_IMAGE_ENHANCE_S, *LPNETDEV_IMAGE_ENHANCE_S;


/**
 * @struct tagNETDEVEnhanceCapabilitiesInfo
 * @brief ͼǿ ṹ嶨
 * @attention
 */
typedef struct tagNETDEVEnhanceCapabilitiesInfo
{
    UINT32 udwImageRotationModeNum;                                          /* ֵ֧ͼģʽ */
    UINT32 udwImageRotationModeList[NETDEV_IMAGE_ROTATION_MODE_MAX_NUM];     /* ֵ֧ͼģʽб,μö#NETDEV_IMAGE_ROTATION_MODE_E*/
    BOOL bSupportSharpness;                                                  /* 豸Ƿ֧ȣ0,֧֣1,֧*/
    BOOL bSupport2DNoiseReduce;                                              /* 豸Ƿ֧2D룬0,֧֣1,֧ */
    BOOL bSupport3DNoiseReduce;                                              /* 豸Ƿ֧3D룬0,֧֣1,֧ */
    BYTE  byRes[512];                                                        /* ֶ  Reserved */
}NETDEV_IMAGE_ENHANCE_CAP_INFO_S, *LPNETDEV_IMAGE_ENHANCE_CAP_INFO_S;

/**
 * @struct tagNETDEVFocusCapabilitiesInfo
 * @brief Խ IPC֧֣ ṹ嶨
 * @attention
 */
typedef struct tagNETDEVFocusCapabilitiesInfo 
{
    BOOL bSupportFocusCfg;                                                   /* Ƿֶ֧Խã0,֧֣1,֧*/
    UINT32 udwFocusModeNum;                                                  /* ֵ֧ĶԽģʽ*/
    UINT32 udwFocusModeList[NETDEV_FOCUS_MODE_MAX_NUM];                      /* ֵ֧ĶԽģʽб,μö#NETDEV_FOCUS_MODEL_E*/
    UINT32 udwFocusSceneNum;                                                 /* ֵ֧ĶԽ*/
    UINT32 udwFocusSceneList[NETDEV_FOCUS_SCENE_MAX_NUM];                    /* ֵ֧ĶԽб,μö#NETDEV_FOCUS_SCENE_E*/
    BYTE  byRes[512];                                                        /* ֶ  Reserved */
}NETDEV_FOCUS_CAP_INFO_S, *LPNETDEV_FOCUS_CAP_INFO_S;

/**
 * @struct tagNETDEVWhiteBalanceCapabilitiesInfo
 * @brief ƽ IPC֧֣ ṹ嶨
 * @attention
 */
typedef struct tagNETDEVWhiteBalanceCapabilitiesInfo 
{
    UINT32 udwWhiteBalanceModeNum;                                           /* ֵ֧İƽģʽ*/
    UINT32 audwWhiteBalanceModeList[NETDEV_WHITE_BALANCE_MODE_MAX_NUM];       /* ֵ֧İƽģʽϢб,μö#NETDEV_WHITE_BALANCE_MODE_E*/
    BYTE  byRes[512];                                                        /* ֶ  Reserved */
}NETDEV_WHITE_BALANCE_CAP_INFO_S, *LPNETDEV_WHITE_BALANCE_CAP_INFO_S;

/**
 * @struct tagNETDEVLampInfo
 * @brief Ϣ ṹ嶨
 * @attention
 */
typedef struct tagNETDEVLampInfo
{
    UINT32 udwLampType;                                             /*  μöNETDEV_LAMP_TYPE_E*/
    UINT32 udwLampCtrlModeListNum;                                  /* ֵ֧Ŀģʽ*/
    UINT32 audwLampCtrlModeList[NETDEV_LAMP_CTRL_MODE_MAX_NUM];     /* ֵ֧Ŀģʽμö#NETDEV_LAMP_CTRL_MODE_E*/
    BOOL   bSupportNearLampCfg;                                     /* Ƿֽ֧Ƽã0֧ 1֧*/
    BOOL   bSupportMiddleLampCfg;                                   /* Ƿ֧йƼã0֧ 1֧*/
    BOOL   bSupportFarLampCfg;                                      /* Ƿ֧ԶƼã0֧ 1֧*/
    BOOL   bSupportSuperFarLampCfg;                                 /* Ƿֳ֧ԶԶƼã0֧ 1֧*/
    BOOL   bSupportLaserAngleCfg;                                   /* Ƿּ֧Ƕȿã0֧ 1֧*/
    UINT32 udwLaserAngleMin;                                        /* ǶСֵbSupportLaserAngleCfgΪ0ʱ˽ڵѡ*/
    UINT32 udwLaserAngleMax;                                        /* ǶֵbSupportLaserAngleCfgΪ0ʱ˽ڵѡ*/
    BYTE   byRes[512];                                              /* ֶ  Reserved */
}NETDEV_LAMP_INFO_S, *LPNETDEV_LAMP_INFO_S;

/**
 * @struct tagNETDEVLampCtrlCapabilitiesInfo
 * @brief  IPC֧֣ ṹ嶨
 * @attention
 */
typedef struct tagNETDEVLampCtrlCapabilitiesInfo
{
    UINT32              udwLampNum;                                     /* ֵ֧Ĳ͸Ϊ0ʱʾ豸ֲ֧ơ*/
    NETDEV_LAMP_INFO_S  astLampInfos[NETDEV_LAMP_CTRL_TYPE_MAX_NUM];    /* Ϣб,ϢбLampNumΪ0ʱýڵѡ*/
    BYTE                byRes[512];                                     /* ֶ  Reserved */
}NETDEV_LAMPCTRL_CAP_INFO_S, *LPNETDEV_LAMPCTRL_CAP_INFO_S;

/**
 * @struct tagNETDEVShutterCapabilitiesInfo
 * @brief  ṹ嶨
 * @attention
 */
typedef struct tagNETDEVShutterCapabilitiesInfo
{
    BOOL   bSupportShutterTimeCfg;                                                  /* Ƿֿ֧ʱã0֧ 1֧*/
    UINT32 udwShutterTimeUnit;                                                      /* ʱ䵥λ  0΢ 1*/
    UINT32 udwShutterTimeRangeNum;                                                  /* ֵ֧Ŀʱȡֵĸ*/
    UINT32 audwShutterTimeRangeList[NETDEV_SHUTTER_TIME_RANGE_MAX_NUM];             /* ʱֵ֧ȡֵб öٲμ#NETDEV_SHUTTER_TIME_RANGE_E*/
    BOOL   bSupportSlowShutterCfg;                                                  /* Ƿ֧ſã0֧ 1֧*/
    UINT32 udwSlowShutterTimeRangeNum;                                              /* ֵ֧ʱȡֵĸ*/
    UINT32 audwSlowShutterTimeRangeList[NETDEV_SLOW_SHUTTER_TIME_RANGE_MAX_NUM];    /* ʱֵ֧ȡֵб öٲμ#NETDEV_SHUTTER_TIME_RANGE_Eע⣬ʱֵ֧ȡֵ1/25*/
    BYTE   byRes[512];                                                              /* ֶ  Reserved */
}NETDEV_SHUTTER_CAP_INFO_S, *LPNETDEV_SHUTTER_CAP_INFO_S;

/**
 * @struct tagNETDEVWideDynamicCapabilitiesInfo
 * @brief ̬ ṹ嶨
 * @attention
 */
typedef struct tagNETDEVWideDynamicCapabilitiesInfo
{
    BOOL   bSupportWideDynamicCfg;                                              /* Ƿֿ֧̬ã0֧ 1֧*/
    UINT32 udwWideDynamicModeNum;                                               /* ֵ֧Ŀ̬ģʽ*/
    UINT32 audwWideDynamicModeList[NETDEV_SHUTTER_TIME_RANGE_MAX_NUM];          /* ̬ģʽб öٲμ#NETDEV_WIDE_DYNAMIC_MODE_E*/
    BYTE   byRes[512];                                                          /* ֶ  Reserved */
}NETDEV_WIDE_DYNAMIC_CAP_INFO_S, *LPNETDEV_WIDE_DYNAMIC_CAP_INFO_S;

/**
 * @struct tagNETDEVDayNightCapabilitiesInfo
 * @brief ҹģʽ ṹ嶨
 * @attention
 */
typedef struct tagNETDEVDayNightCapabilitiesInfo
{
    BOOL   bSupportDayNightCfg;                                              /* Ƿ֧ҹģʽã0֧ 1֧*/
    UINT32 udwDayNightModeNum;                                               /* ֧ҹģʽ͸*/
    UINT32 audwDayNightModeList[NETDEV_DAY_NIGHT_MODE_MAX_NUM];              /* ҹģʽб öٲμ#NETDEV_DAY_NIGHT_MODE_E*/
    BOOL   bSupportSensibilityCfg;                                           /* Ƿ֧ҹģʽȿã0֧ 1֧*/
    BOOL   bSupportSwitchingCfg;                                             /* Ƿ֧ҹģʽлʱã0֧ 1֧*/
    BYTE   byRes[512];                                                       /* ֶ  Reserved */
}NETDEV_DAY_NIGHT_CAP_INFO_S, *LPNETDEV_DAY_NIGHT_CAP_INFO_S;


/**
 * @struct tagNETDEVExposureCapabilitiesInfo
 * @brief عIPC֧֣ ṹ嶨
 * @attention
 */
typedef struct tagNETDEVExposureCapabilitiesInfo
{
    BOOL   bSupportCompensationCfg;                                          /* Ƿ֧عⲹá0֧ 1֧*/
    UINT32 udwExposureModeNum;                                               /* ֵ֧عģʽ*/
    UINT32 audwExposureModeList[NETDEV_EXPOSURE_MODE_MAX_NUM];               /* ֵ֧عģʽμö#NETDEV_EXPOSURE_MODE_E*/
    BOOL   bSupportIrisCfg;                                                  /* Ƿֹ֧Ȧá0֧ 1֧*/
    UINT32 udwIrisRangeNum;                                                  /* ֵ֧ĹȦȡֵ*/
    UINT32 audwIrisRangeList[NETDEV_IRIS_RANGE_MAX_NUM];                     /* Ȧֵ֧ȡֵ:16020024028034040048056068080096011001400,1600,2200 IrisRangeNumΪ0ʱýڵѡ*/
    UINT32 udwMinGain;                                                       /* ֵ֧Сֵ*/
    UINT32 udwMaxGain;                                                       /* ֵֵ֧*/
    BOOL   bSupportHLCCfg;                                                   /* Ƿ֧ǿȿã0֧ 1֧*/
    BOOL   bSupportMeteringCfg;                                              /* Ƿֲ֧ƿã0֧ 1֧*/
    BOOL   bSupportSuperFarLampCfg;                                          /* Ƿֳ֧ԶԶƼã0֧ 1֧*/
    UINT32 udwMeteringModeNum;                                               /* ֵ֧Ĳģʽ*/
    UINT32 audwMeteringModeList[NETDEV_METERING_MODE_MAX_NUM];               /* ģʽ μö#NETDEV_METERING_MODE_E*/
    NETDEV_SHUTTER_CAP_INFO_S  stShutterCapInfo;                             /* Ϣ*/
    NETDEV_WIDE_DYNAMIC_CAP_INFO_S  stWideDynamicCapInfo;                    /* ̬Ϣ*/
    NETDEV_DAY_NIGHT_CAP_INFO_S  stDayNightCapInfo;                          /* ҹģʽϢ*/
    BYTE  byRes[512];                                                        /* ֶ  Reserved */
}NETDEV_EXPOSURE_CAP_INFO_S, *LPNETDEV_EXPOSURE_CAP_INFO_S;

/**
 * @struct tagNETDEVImageCapabilities
 * @brief ָͨͼ ṹ嶨    Device image Capabilities Structure definition
 * @attention
 */
typedef struct tagNETDEVImageCapabilities
{
    BOOL bSupportCfg;                                                       /* 豸Ƿ֧ͼ 0,֧֣1,֧ */
    BOOL bIsSupportCorrectCfg;                                              /* 豸Ƿ֧ͼ 0֧֣1֧ */
    INT32 udwImageRotationModeNum;                                          /* ֵ֧ͼģʽ */
    INT32 udwImageRotationModeList[NETDEV_IMAGE_ROTATION_MODE_MAX_NUM];     /* ֵ֧ͼģʽб,μö#NETDEV_IMAGE_ROTATION_MODE_E*/
    BOOL bSupportSharpness;                                                 /* 豸Ƿ֧ȣ0,֧֣1,֧*/
    BOOL bSupport2DNoiseReduce;                                             /* 豸Ƿ֧2D룬0,֧֣1,֧ */
    BOOL bSupport3DNoiseReduce;                                             /* 豸Ƿ֧3D룬0,֧֣1,֧ */
    BOOL bSupportIlluminationCfg;                                           /* 豸Ƿֻ֧ȡնȵȼֵ(IPC֧) 0,֧֣1,֧ */
    BOOL bIsSupportEPTZ;                                                    /* 豸Ƿֵ̨֧ܸٹܣ0,֧֣1,֧ */
    NETDEV_FOCUS_CAP_INFO_S stFocusCapInfo;                                 /* Խ,IPC֧֡*/
    NETDEV_LAMPCTRL_CAP_INFO_S stLampCtrlCapInfo;                           /* ,IPC֧֡*/
    NETDEV_EXPOSURE_CAP_INFO_S stExposureCapInfo;                           /* ع,IPC֧֡*/
    NETDEV_WHITE_BALANCE_CAP_INFO_S  stWhiteBalanceCapInfo;                 /* ƽϢ,IPC֧*/
    BYTE  byRes[504];                                                       /* ֶ  Reserved */
}NETDEV_IMAGE_CAP_S, *LPNETDEV_IMAGE_CAP_S;


/**
 * @struct tagNETDEVIrisInfo
 * @brief  ȦϢ  ṹ嶨    IrisInfo
 * @attention
 */
typedef struct tagNETDEVIrisInfo
{
    UINT32 udwIris;         /* Ȧ,ڹȦȡֶعģʽ¿ѡȦֵ֧ȡֵ:160 200 240 280 340 400 480 560 680 800 960 11001400,  1600,  2200*/
    UINT32 udwMinIris;      /* СȦֵ Զعģʽ¿ãöͬ IrisôڹȦֵͼָ֧ùܣֶαѡ*/
    UINT32 udwMaxIris;      /* Ȧֵ Զعģʽ¿ãöͬ IrisСڹȦСֵͼָ֧ùܣֶαѡ*/
    BYTE  byRes[128];       /* ֶ  Reserved */
}NETDEV_IRIS_INFO_S, *LPNETDEV_IRIS_INFO_S;


/**
 * @struct tagNETDEVShutterInfo
 * @brief  Ϣ  ṹ嶨    ShutterInfo
 * @attention
 */
typedef struct tagNETDEVShutterInfo
{
    UINT32 udwShutterTime;                  /* ʱ öټ#NETDEV_SHUTTER_TIME_RANGE_E,ʱ䵥λ  0΢ 1*/
    UINT32 udwMinShutterTime;               /* ʱСֵ MinShutter öټ#NETDEV_SHUTTER_TIME_RANGE_E*/
    UINT32 udwMaxShutterTime;               /* ʱֵ MaxShutter öټ#NETDEV_SHUTTER_TIME_RANGE_E*/
    UINT32 udwIsEnableSlowShutter;          /* ʹܡǹȦģʽ¿ã0ʹ  1ʹ*/
    UINT32 udwSlowestShutter;               /* ,ʹܺá*/
    BYTE   byRes[128];                      /* ֶ  Reserved */
}NETDEV_SHUTTER_INFO_S, *LPNETDEV_SHUTTER_INFO_S;

/**
 * @struct tagNETDEVGainInfo
 * @brief  Ϣ  ṹ嶨    GainInfo
 * @attention
 */
typedef struct tagNETDEVGainInfo
{
    UINT32 udwGain;         /* ֵλ:dbֶعģʽ¿áΧ[1,100]*/
    UINT32 udwMinGain;      /* Сֵ ,Զعģʽ¿ãôֵСֵΪ1*/
    UINT32 udwMaxGain;      /* ֵ , Զعģʽ¿ãССֵֵΪ100*/
    BYTE  byRes[128];       /* ֶ  Reserved */
}NETDEV_GAIN_INFO_S, *LPNETDEV_GAIN_INFO_S;

/**
 * @struct tagNETDEVWideDynamicInfo
 * @brief  ̬Ϣ  ṹ嶨    WideDynamicInfo
 * @attention
 */
typedef struct tagNETDEVWideDynamicInfo
{
    UINT32 udwWideDynamicMode;              /* ̬ģʽ WideDynamicMode ö#NETDEV_WIDE_DYNAMIC_MODE_E*/
    UINT32 udwWideDynamicLevel;             /* ̬ã̬عģʽΪԶģʽԶ塢ȡ50HZ60HZӰ¿áΧ[1, 9]*/
    UINT32 udwOpenSensitivity;              /* ̬ȡ̬ģʽΪԶ¿áΧ[1, 9]*/
    UINT32 udwCloseSensitivity;             /* ̬رյȡ̬ģʽΪԶ¿áΧ[1, 9]*/
    UINT32 udwAntiFlicker;                    /* ̬ƣ0ر 1ùܿ󣬿ͼеЧӦ*/
    BYTE   byRes[128];                      /* ֶ  Reserved */
}NETDEV_WIDE_DYNAMIC_INFO_S, *LPNETDEV_WIDE_DYNAMIC_INFO_S;

/**
 * @struct tagNETDEVAreaTopLeft
 * @brief  Ͻ  ṹ嶨    Upper left Area
 * @attention
 */
typedef struct tagNETDEVAreaTopLeft
{
    UINT32  dwTopLeftX;     /* ϽǺ()ģʽΧ: [0, 100]Upper left corner X [0, 100]  */
    UINT32  dwTopLeftY;     /* Ͻ()ģʽΧ: [0, 100]Upper left corner Y [0, 100]  */
    BYTE    byRes[128];     /* ֶ  Reserved */
}NETDEV_AREA_TOP_LEFT_S, *LPNETDEV_AREA_TOP_LEFT_S;

/**
 * @struct tagNETDEVAreaBotRight
 * @brief  ½  ṹ嶨    Lower right Area
 * @attention
 */
typedef struct tagNETDEVAreaBotRight
{
    UINT32  dwBottomRightX;     /* ϽǺ()ģʽΧ: [0, 100]  Lower right corner x [0, 100] */
    UINT32  dwBottomRightY;     /* Ͻ()ģʽΧ: [0, 100]  Lower right corner y [0, 100] */
    BYTE    byRes[128];         /* ֶ  Reserved */
}NETDEV_AREA_BOT_RIGHT_S, *LPNETDEV_AREA_BOT_RIGHT_S;

/**
 * @struct tagNETDEVMeteringArea
 * @brief    ṹ嶨   MeteringArea
 * @attention
 */
typedef struct tagNETDEVMeteringArea
{
    NETDEV_AREA_TOP_LEFT_S    stAreaTopLeft;           /* Ͻ  ṹ#NETDEV_AREA_TOP_LEFT_S*/
    NETDEV_AREA_BOT_RIGHT_S   stAreaBotRight;          /* ½  ṹ#NETDEV_AREA_BOT_RIGHT_S*/
    BYTE  byRes[128];                                  /* ֶ  Reserved */
}NETDEV_METERING_AREA_S, *LPNETDEV_METERING_AREA_S;

/**
 * @struct tagNETDEVMeteringInfo
 * @brief  Ϣ  ṹ嶨    MeteringInfo
 * @attention
 */
typedef struct tagNETDEVMeteringInfo
{
    UINT32 udwMeteringMode;                 /* ģʽ,ֶڷֶعģʽ¿áö#NETDEV_DAY_NIGHT_MODE_E*/
    UINT32 udwRefBrightness;                /* ȡģʽ¿áΧ[0, 100]*/
    UINT32 udwHoldTime;                     /* ̳ʱ䡣ģʽ¿áλӡΧ[0, 60]*/
    NETDEV_METERING_AREA_S stMeteringArea;  /*  ,ڲģʽΪ⼰ʱֶο*/
    BYTE  byRes[128];                       /* ֶ  Reserved */
}NETDEV_METERING_INFO_S, *LPNETDEV_METERING_INFO_S;

/**
 * @struct tagNETDEVDayNightInfo
 * @brief  ҹģʽϢ  ṹ嶨    MeteringInfo
 * @attention
 */
typedef struct tagNETDEVDayNightInfo
{
    UINT32 udwDayNightMode;                 /* ҹģʽ DayNightMode öٲμ#NETDEV_DAY_NIGHT_MODE_E*/
    UINT32 udwDayNightSensitivity;          /* ҹģʽ DayNightSensitivity ҹģʽΪԶģʽ¿ãΧ[0, 9]ͼָ֧ùܣֶαѡ*/
    UINT32 udwDayNightTime;                 /* ҹģʽлʱ䣬ҹģʽΪԶģʽ¿áΧ[3, 120]λ롣ͼָ֧ùܣֶαѡ*/
    BYTE  byRes[128];                       /* ֶ  Reserved */
}NETDEV_DAY_NIGHT_INFO_S, *LPNETDEV_DAY_NIGHT_INFO_S;

/**
 * @struct tagNETDEVImagingExposure
 * @brief ͼع ṹ嶨    Device image Exposure Structure definition
 * @attention
 */
typedef struct tagNETDEVImagingExposure
{
    UINT32                      udwMode;                /* عģʽ  Exposure Mode ö#NETDEV_EXPOSURE_MODE_E*/
    INT32                       dwCompensationLevel;    /* عⲹ,عģʽΪֶعģʽʱáΧ[-100,100].ͼָ֧ùܣֶαѡ */
    UINT32                      udwHLCSensitivity;      /* ǿȣǰΪ·ǿƼ԰ǿʱ,Χ[1,9] ͼָ֧ùܣֶαѡ */
    NETDEV_IRIS_INFO_S          stIrisInfo;             /* ȦϢͼָ֧ùܣֶαѡ*/
    NETDEV_SHUTTER_INFO_S       stShutterInfo;          /* Ϣͼָ֧ùܣֶαѡ*/
    NETDEV_GAIN_INFO_S          stGainInfo;             /* Ϣ*/
    NETDEV_WIDE_DYNAMIC_INFO_S  stWideDynamicInfo;      /* ̬Ϣͼָ֧ùܣֶαѡ*/
    NETDEV_METERING_INFO_S      stMeteringInfo;         /* Ϣǰǵ·ǿƼ԰ǿʱáͼָ֧ùܣֶαѡ*/
    NETDEV_DAY_NIGHT_INFO_S     stDayNightInfo;         /* ҹģʽϢͼָ֧ùܣֶαѡ*/
    BYTE                        byRes[256];             /* ֶ  Reserved */
}NETDEV_IMAGE_EXPOSURE_S, *LPNETDEV_IMAGE_EXPOSURE_S;


/**
 * @struct tagNETDEVLampCtrlInfo
 * @brief  Ϣ
 * @attention
 */
typedef struct tagNETDEVLampCtrlInfo
{
    UINT32 udwEnabled;          /* ʹܿأ0ر 1 */
    UINT32 udwType;             /*  ö #NETDEV_LAMP_TYPE_E*/
    UINT32 udwMode;             /* ƿģʽ ö #NETDEV_LAMP_CTRL_MODE_E*/
    UINT32 udwNearLevel;        /* Ƽ,ںģʽΪֶƼֶ-ǿƿģʽ,ֶοáָ֧ùܣֶαѡΧ[0-1000]ԽߣǿԽ*/
    UINT32 udwMiddleLevel;      /* йƼ,ںģʽΪֶƼֶ-ǿƿģʽ¿áָ֧ùܣֶαѡΧ[0-1000]ԽߣǿԽ*/
    UINT32 udwFarLevel;         /* ԶƼ,ںģʽΪֶƼֶ-ǿƿģʽ¿áָ֧ùܣֶαѡΧ[0-1000]ԽߣǿԽ*/
    UINT32 udwSuperFarLevel;    /* ԶƼ,ںģʽΪֶƼֶ-ǿƿģʽ¿áָ֧ùܣֶαѡΧ[0-1000]ԽߣǿԽ*/
    UINT32 udwLaserAngle;       /* ǶȣΪңںģʽΪֶƼֶ-ǿƿģʽ¿áָ֧ùܣֶαѡΧǶԽСԽУǶԽԽɢ*/
    BYTE  byRes[256];           /* ֶ  Reserved */
}NETDEV_LAMP_CTRL_INFO_S, *LPNETDEV_LAMP_CTRL_INFO_S;

/**
 * @struct tagNETDEVWhiteBalanceInfo
 * @brief  ƽϢ
 * @attention
 */
typedef struct tagNETDEVWhiteBalanceInfo
{
    UINT32 udwMode;             /* ƽģʽ ö #NETDEV_WHITE_BALANCE_MODE_E*/
    INT32 dwRedOffset;          /* RedƫֵֻModeΪ[1,5,8]΢ģʽ¿*/
    INT32 dwBlueOffset;         /* BlueƫֵֻModeΪ[1,5,8]΢ģʽ¿*/
    BYTE  byRes[256];           /* ֶ  Reserved */
}NETDEV_WHITE_BALANCE_INFO_S, *LPNETDEV_WHITE_BALANCE_INFO_S;


/* ԴýϢ */
typedef struct tagNETDEVXWSteamInfoSrc
{
    UINT32  udwVideoInChlID;                /* ƵԴID */
    UINT32  udwStreamID;                    /* ý */
    CHAR    szIPAddr[NETDEV_IPV4_LEN_MAX];  /* ƵԴIPַ */
    UINT32  udwPort;                        /* ˿ں */
    BYTE    byRes[64];                      /* ֶ */
}NETDEV_XW_STREAM_INFO_SRC_S, *LPNETDEV_XW_STREAM_INFO_SRC_S;

/* ĿĶýϢ */
typedef struct tagNETDEVXWSteamInfoDest
{
    UINT32  udwWndID;                       /* ID */
    UINT32  udwPaneID;                      /*  */
    CHAR    szIPAddr[NETDEV_IPV4_LEN_MAX];  /* ĿĶIPַ */
    UINT32  udwPort;                        /* ˿ں */
    BYTE    byRes[64];                      /* ֶ */
}NETDEV_XW_STREAM_INFO_DEST_S, *LPNETDEV_XW_STREAM_INFO_DEST_S;

/* ýϢ */
typedef struct tagNETDEVXWStreamInfoMsg
{
    UINT32                  udwTransProtocol;           /* Э NETDEV_LAPI_TRANS_PROTOCOL_E */
    UINT32                  udwIsMulticast;             /* 鲥 NETDEV_STREAM_TYPE_E */
    NETDEV_XW_RESOLUTION_S  stResolution;               /* ֱ */
    UINT32                  udwFrame;                   /* ֡ */
    UINT32                  udwEncodeFormat;            /* ʽ NETDEV_VIDEOENCODING_E */
    UINT32                  udwIsInvalidAfterReboot;    /* ǷҪָ 0 "XW"豸ָ1 "XW"豸ָ*/
    BYTE                    byRes[64];                  /* ֶ */
}NETDEV_XW_STREAM_INFO_MSG_S, *LPNETDEV_XW_STREAM_INFO_MSG_S;

/* ҵϸϢ */
typedef struct tagNETDEVXWSteamInfo
{
    UINT32                          udwTaskNo;          /* ҵ */
    UINT32                          udwType;            /* ҵ NETDEV_XW_VIDEO_TYPE_E */
    NETDEV_XW_STREAM_INFO_SRC_S     stStreamInfoSrc;    /* ԴýϢ */
    NETDEV_XW_STREAM_INFO_DEST_S    stStreamInfoDest;   /* ĿĶýϢ */
    NETDEV_XW_STREAM_INFO_MSG_S     stStreamInfoMsg;    /* ýϢ */
}NETDEV_XW_STREAM_INFO_S, *LPNETDEV_XW_STREAM_INFO_S;



/**
 * @enum tagNETDEVXWAudioOutInfoList
 * @brief ƵͨϢб
 * @attention  None
 */
typedef struct tagNETDEVXWAudioOutInfoList
{
    UINT32                      udwAudioSize;                           /* Ƶͨ */
    NETDEV_XW_AUDIO_OUT_INFO_S  stAudioIDList[NETDEV_XW_AUDIO_NUM];     /* ƵͨϢ */
    BYTE                        byRes[128];                             /* Ԥֶ */
}NETDEV_XW_AUDIO_OUT_INFO_LIST_S, *LPNETDEV_XW_AUDIO_OUT_INFO_LIST_S;


typedef struct tagNETDEVPassiveDecodeCtrl
{
    UINT32    udwSize;
    UINT32    dwPlayCmd;        /*  ļ */
    UINT32    dwCmdParam;       /*  */
    BYTE      byRes[16];        /* ֶ */
}NETDEV_PASSIVE_DECODE_CTRL_S,*LPNETDEV_PASSIVE_DECODE_CTRL_S;


/* ѯ״̬бϢ */
typedef struct tagNETDEVXWSequenceStatus
{
    UINT32  udwWndID;       /* ID */
    UINT32  udwStatus;      /* Ѳ״̬ NETDEV_XW_SEQUENCE_STATUS_E */
    BYTE    byRes[64];      /* ֶ */
}NETDEV_XW_SEQUENCE_STATUS_S, *LPNETDEV_XW_SEQUENCE_STATUS_S;


/* ѲԴϢ */
typedef struct tagNETDEVXWSequenceResourceBaseInfo
{
    UINT32  udwID;                          /* ѲԴΨһID */
    CHAR    szName[NETDEV_LEN_64];          /* ѲԴ */
    CHAR    szDescription[NETDEV_LEN_256];  /* ѲԴϢ */
    BOOL    bEnabled;                       /* ѲԴǷ */
    UINT32  udwOrderNO;                     /* ѲԴԴ,ѯʱѡ */
    BYTE    byRes[124];                     /* ֶ */
}NETDEV_XW_SEQUENCE_RES_BASE_INFO_S, *LPNETDEV_XW_SEQUENCE_RES_BASE_INFO_S;

/* ѲƵԴϢ */
typedef struct tagNETDEVXWSeqVideoSrcInfo
{
    UINT32                              udwVideoSrcIndex;               /* ƵԴ */
    NETDEV_XW_VIDEO_SOURCE_BASE_S       stVideoSrcBaseInfo;             /* ƵԴϢ */
    UINT32                              udwPresetIndex;                 /* ̨ԤλţֻѲʱҪ */
    BYTE                                byRes[64];                      /* ֶ */
}NETDEV_XW_SEQ_RES_VIDEO_SRC_INFO_S, *LPNETDEV_XW_SEQ_RES_VIDEO_SRC_INFO_S;

/* ѲԴϸϢ
Ѳʱ䣬λ룬ֻѲʱҪõǰֻ֧ѲóһģֻȡһѲΪѲʱ
*/
typedef struct tagNETDEVXWSequenceResDeTailInfo
{
    NETDEV_XW_SEQUENCE_RES_BASE_INFO_S      stSeqResBaseInfo;   /* ѲԴϢ */
    UINT32                                  udwIntervalTime;    /* Ѳʱ䣬λ */
    UINT32                                  udwVideoSrcNum;     /* ѲƵԴ */
    LPNETDEV_XW_SEQ_RES_VIDEO_SRC_INFO_S    pstVideoInList;     /* ѲƵԴбϢ,ڴɵά, ӿڻȡ */
    UINT32                                  udwManageType;      /* ԴͣμöNETDEV_XW_MANAGE_TYPE_E  */
    BYTE                                    byRes[124];         /* ֶ */
}NETDEV_XW_SEQUENCE_RES_DETAIL_INFO_S, *LPNETDEV_XW_SEQUENCE_RES_DETAIL_INFO_S;

/* ѲſϢ */
typedef struct tagNETDEVXWSequencePlayControlInfo
{
    UINT32  udwSequenceResBindID;   /* ѲԴϢID */
    UINT32  udwOperation;           /*  μöNETDEV_XW_SEQUENCE_PLAY_CTRL_CMD_E */
    BYTE    byRes[128];             /* ֶ */
}NETDEV_XW_SEQUENCE_PLAY_CTRL_INFO_S, *LPNETDEV_XW_SEQUENCE_PLAY_CTRL_INFO_S;

/* ѲżϢ */
typedef struct tagNETDEVXWSequenceIntervalInfo
{
    UINT32  udwSequenceResBindID;   /* ѲԴϢID */
    UINT32  udwIntervalTime;        /* ż λ */
    BYTE    byRes[128];             /* ֶ */
}NETDEV_XW_SEQUENCE_INTERVAL_INFO_S, *LPNETDEV_XW_SEQUENCE_INTERVAL_INFO_S;


/* ƻʱлģʽϢ */
typedef struct tagNETDEVXWScenesPlanTimerInfo
{
    UINT32  udwIntervalTime;        /* ʱ λ */
    UINT32  udwSceneNum;            /*  */
    UINT32* pudwSceneIDList;        /* IDбڴûά */
    BYTE    byRes[64];              /* ֶ */
}NETDEV_XW_SCENES_PLAN_TIMER_INFO_S, *LPNETDEV_XW_SCENES_PLAN_TIMER_INFO_S;

/* 24СʱʱϢ */
typedef struct tagNETDEVXWTimeTableInfo
{
    UINT32  udwSceneID;                     /* ID */
    CHAR    szStartTime[NETDEV_LEN_16];     /* ʱ hh:mm:ss */
    BYTE    byRes[64];                      /* ֶ */
}NETDEV_XW_TIME_TABLE_INFO_S, *LPNETDEV_XW_TIME_TABLE_INFO_S;

/* ƻʱģʽϢ,24Сʱƻ */
typedef struct tagNETDEVXWScenesPlanTimeTableInfo
{
    UINT32                          udwTimePeriodNum;               /* ʱֶθ */
    LPNETDEV_XW_TIME_TABLE_INFO_S   pstTimeTableList;               /* ƻʱϢڴûάСudwTimePeriodNumָ */
    BYTE                            byRes[64];                      /* ֶ */
}NETDEV_XW_SCENES_PLAN_TIME_TABLE_INFO_S, *LPNETDEV_XW_SCENES_PLAN_TIME_TABLE_INFO_S;

/* ѲƻϢ */
typedef struct tagNETDEVXWScenesPlanInfo
{
    UINT32                                      udwID;                          /* ƻID */
    CHAR                                        szName[NETDEV_LEN_64];          /* ƻ */
    UINT32                                      udwOrderNo;                     /* ƻ */
    CHAR                                        szDescription[NETDEV_LEN_256];  /* ƻϢ */
    UINT32                                      udwStatus;                      /* ƻ״̬ μNETDEV_XW_SEQUENCE_RES_STATUS_E */
    UINT32                                      udwMode;                        /* ƻʽ μNETDEV_XW_SCENES_PLAN_MODE_E */
    NETDEV_XW_SCENES_PLAN_TIMER_INFO_S          stTimerInfo;                    /* ʱлģʽϢ */
    NETDEV_XW_SCENES_PLAN_TIME_TABLE_INFO_S     stTimeTableInfo;                /* ʱģʽлϢ */
    BYTE                                        byRes[124];                     /* ֶ */
}NETDEV_XW_SCENES_PLAN_INFO_S, *LPNETDEV_XW_SCENES_PLAN_INFO_S;

/* ѲƻſϢ */
typedef struct tagNETDEVXWScenesSeqPlanPlayCtrlInfo
{
    UINT32  udwScenesSeqPlanID;     /* ѲƻID */
    UINT32  udwOperation;           /*  μöNETDEV_XW_SEQUENCE_PLAY_CTRL_CMD_E */
    BYTE    byRes[128];             /* ֶ */
}NETDEV_XW_SCENES_PLAN_PLAY_CTRL_INFO_S, *LPNETDEV_XW_SCENES_PLAN_PLAY_CTRL_INFO_S;

/**
 * @struct tagNETDEVDevFaceCapInfo
 * @brief ʶ ṹ嶨
 * @attention  None
 */
typedef struct tagNETDEVDevFaceCapInfo
{
    BOOL   bIsFaceRecognitionSupported;     /* Ƿ֧ʶ 0֧ 1֧ */
    BYTE   byRes[255];                      /* ֶ */
}NETDEV_DEV_FACE_CAP_INFO_S, *LPNETDEV_DEV_FACE_CAP_INFO_S;


/**
 * @struct tagNETDEVCIQuotaChannelInfoList
 * @brief Ӳ  
 * @attention None
 */
typedef struct tagNETDEVCIQuotaChannelInfoList
{
    UINT32 udwNums;                         /* ƵƵͨĿ*/
    UINT32 audwChannels[NETDEV_LEN_1024];      /*ƵƵͨIDб*/

}NETDEV_QUOTA_CHANNE_INFO_S,*LPNETDEV_QUOTA_CHANNE_INFO_S;

/**
 * @struct tagNETDEVCISetQuotaInfo
 * @brief Ӳ    
 * @attention None
 */
typedef struct tagNETDEVCISetQuotaInfo
{
    UINT32 udwRecordQuota;                  /* ͨ¼(GB)*/
    UINT32 udwPictureQuota;                 /*ͨץͼ(GB)*/
    UINT32 udwGroupID;                      /*ID*/
    NETDEV_QUOTA_CHANNE_INFO_S stCopyTo;    /*ƵƵͨб*/
}NETDEV_SET_QUOTA_INFO_S,*LPNETDEV_SET_QUOTA_INFO_S;

/**
 * @struct tagNETDEVCIGetQuotainolist
 * @brief Ӳ  
 * @attention None
 */
typedef struct tagNETDEVCIGetQuotaInfo
{
    UINT32 udwChannelID;                    /* ͨID*/  
    CHAR   szChannelName[NETDEV_LEN_64];    /* ͨ */
    CHAR   szDeviceName[NETDEV_LEN_64];     /* 豸 */
    UINT32 udwRecordQuota;                  /* ͨ¼(GB)*/       
    UINT32 udwPictureQuota;                 /*ͨץͼ(GB)*/
    UINT32 udwGroupID;                      /*ID*/
    UINT32 udwOrgID;                        /*֯ID*/
}NETDEV_QUOTA_INFO_S,*LPNETDEV_QUOTA_INFO_S;

/**
 * @struct tagNETDEVCIGetQuotainolist
 * @brief Ӳ    
 * @attention None
 */
typedef struct tagNETDEVCIGetQuotainolist
{
    UINT32                  udwNums;                        /* Ϣ*/
    NETDEV_QUOTA_INFO_S     astQuotas[NETDEV_LEN_1024];     /* Ϣб*/
}NETDEV_GET_QUOTA_INFOLIST_S,*LPNETDEV_GET_QUOTA_INFOLIST_S;

/**
* @enum tagNETDEVRAIDStatus
* @brief ״̬Ϣ
* @attention 
*/
typedef struct tagNETDEVRAIDStatus
{
    BOOL    bEnabled;                   /* ״̬ʹ 0:ʹ 1:ʹ */
    BYTE    byRes[128];                 /* ֽ */
}NETDEV_RAID_STATUS_S, *LPNETDEV_RAID_STATUS_S;

/**
 * @struct tagNETDEVHDDInfo
 * @brief ӲϢ HDD info
 * @attention  None
 */
typedef struct tagNETDEVHDDInfo
{
    UINT32  udwID;                          /* ̱ */
    UINT32  udwType;                        /*  μö#NETDEV_HDD_TYPE_E */
    UINT32  udwWorkMode;                    /* ̹ģʽ μö#NETDEV_HDD_WORK_MODE_E */
    UINT32  udwTotalCapacity;               /* Ӳ(MB) Total Capacity */
    CHAR    szRAIDName[NETDEV_LEN_64];      /*  */
    UINT32  udwStatus;                      /* ״̬ μö#NETDEV_HDD_STATUS_E */
    CHAR    szManufacturer[NETDEV_LEN_64];  /*  */
    BYTE    byRes[128];                     /* ֽ */
}NETDEV_HDD_INFO_S,*LPNETDEV_HDD_INFO_S;

/**
 * @struct tagNETDEVHDDInfoList
 * @brief Ϣб Disk info list
 * @attention  None
 */
typedef struct tagNETDEVHDDInfoList
{
    INT32               dwSize;                             /* Ӳ̸ Disk number */
    NETDEV_HDD_INFO_S   astHDDInfo[NETDEV_LEN_32];          /* ӲϢ Disk info */
    BYTE                byRes[128];                         /* ֽ */
}NETDEV_HDD_INFO_LIST_S,*LPNETDEV_HDD_INFO_LIST_S;

/**
 * @struct tagNETDEVStorageContainerInfo
 * @brief 洢Ϣ Storage Container info
 * @attention  None
 */
typedef struct tagNETDEVStorageContainerInfo
{
    UINT32  udwID;                              /* ̱ */
    UINT32  udwRemainCapacity;                  /* 洢ʣ(MB) */
    UINT32  udwTotalCapacity;                   /* 洢(MB) */
    CHAR    szManufacturer[NETDEV_LEN_64];      /*  */
    UINT32  udwStatus;                          /* 洢״̬ μö#NETDEV_STORAGE_CONTAINER_STATUS_E */
    UINT32  udwProperty;                        /* 洢,udwStatusΪ0ʱЧ μö#NETDEV_STORAGE_CONTAINER_PROPERTY_E */
    UINT32  udwFormatProgress;                  /* ʽȣٷֱ */
    UINT32  udwGroupID;                         /*  */
    UINT32  udwTemperature;                     /* Ӳ¶(϶) */
    BYTE    byRes[124];                         /* ֽ */
}NETDEV_STORAGE_CONTAINER_INFO_S,*LPNETDEV_STORAGE_CONTAINER_INFO_S;

/**
 * @struct tagNETDEVExtendStorageContainerInfo
 * @brief չ洢Ϣ extend Storage Container info
 * @attention  None
 */
typedef struct tagNETDEVExtendStorageContainerInfo
{
    UINT32  udwID;                              /* ̱ */
    UINT32  udwRemainCapacity;                  /* 洢ʣ(MB) */
    UINT32  udwTotalCapacity;                   /* 洢(MB) */
    UINT32  udwAddressType;                     /* IPַ,μö#NETDEV_ADDR_TYPE_E */
    CHAR    szIPAddress[NETDEV_LEN_64];         /* IPַ */
    CHAR    szPath[NETDEV_LEN_256];             /* NAS洢· */
    UINT32  udwUsageType;                       /* ;,μö#NETDEV_STORAGE_CONTAINER_USAGE_TYPE_E */
    UINT32  udwStatus;                          /* 洢״̬ μö#NETDEV_STORAGE_CONTAINER_STATUS_E */
    UINT32  udwProperty;                        /* 洢,udwStatusΪ0ʱЧ μö#NETDEV_STORAGE_CONTAINER_PROPERTY_E */
    UINT32  udwFormatProgress;                  /* ʽȣٷֱ */
    UINT32  udwGroupID;                         /*  */
    BYTE    byRes[128];                         /* ֽ */
}NETDEV_EXTEND_STORAGE_CONTAINER_INFO_S,*LPNETDEV_EXTEND_STORAGE_CONTAINER_INFO_S;

/**
 * @struct tagNETDEVStorageContainerInfoList
 * @brief 洢Ϣб Storage Container info List
 * @attention  None
 */
typedef struct tagNETDEVStorageContainerInfoList
{
    UINT32                                  udwLocalHDDNum;                                                 /* Ӳ */
    NETDEV_STORAGE_CONTAINER_INFO_S         astLocalHDDList[NETDEV_LOCAL_DISK_MAX_NUM];                     /* ش洢Ϣб */
    UINT32                                  udwSDNum;                                                       /* SD */
    NETDEV_STORAGE_CONTAINER_INFO_S         astSDList[NETDEV_SD_CARD_DISK_MAX_NUM];                         /* SDϢб */
    UINT32                                  udwArrayNum;                                                    /*  */
    NETDEV_STORAGE_CONTAINER_INFO_S         astArrayList[NETDEV_ARRAY_MAX_NUM];                             /* Ϣб */
    UINT32                                  udwExtendCabinet1HDDNum;                                        /* չ-1洢 */
    NETDEV_STORAGE_CONTAINER_INFO_S         astExtendCabinet1HDDList[NETDEV_EXTEND_CABINET_DISK_MAX_NUM];   /* չ-1 Ϣб */
    UINT32                                  udwExtendCabinet2HDDNum;                                        /* չ-2洢 */
    NETDEV_STORAGE_CONTAINER_INFO_S         astExtendCabinet2HDDList[NETDEV_EXTEND_CABINET_DISK_MAX_NUM];   /* չ-2 Ϣб */
    UINT32                                  udwNASNum;                                                      /* NAS */
    NETDEV_EXTEND_STORAGE_CONTAINER_INFO_S  astNASList[NETDEV_NAS_MAX_NUM];                                 /* NASϢб */
    UINT32                                  udweSATANum;                                                    /* eSATAӲ */
    NETDEV_EXTEND_STORAGE_CONTAINER_INFO_S  asteSATAList[NETDEV_ESATA_MAX_NUM];                             /* eSATAϢб */
    UINT32                                  udwIPSANNum;                                                    /* IPSAN */
    NETDEV_EXTEND_STORAGE_CONTAINER_INFO_S  astIPSANList[NETDEV_IPSAN_MAX_NUM];                             /* IPSANϢб */
    BYTE                                    byRes[256];                                                     /* ֽ */
}NETDEV_STORAGE_CONTAINER_INFO_LIST_S,*LPNETDEV_STORAGE_CONTAINER_INFO_LIST_S;

/**
 * @struct tagNETDEVHDDSmartDetailsInfo
 * @brief ӲSmartϸϢ
 * @attention  None
 */
typedef struct tagNETDEVHDDSmartDetailsInfo
{
    UINT32  udwAttributeID;                     /* ID */
    CHAR    szAttributeName[NETDEV_LEN_64];     /*  */
    UINT32  udwStatus;                          /* ״̬ μö#NETDEV_HDD_SMART_ASSESSMENT_STATUS_E */
    UINT32  udwHex;                             /* ʾΪʮ */
    UINT32  udwThresh;                          /* ֵ */
    UINT32  udwCurrentValue;                    /* ǰֵ */
    UINT32  udwWorstValue;                      /* ֵ */
    UINT32  udwActualValue;                     /* ʵֵ */
    BYTE    byRes[128];                         /* ֽ */
}NETDEV_HDD_SMART_DETAILS_INFO_S,*LPNETDEV_HDD_SMART_DETAILS_INFO_S;

/**
 * @struct tagNETDEVHDDSmartCheckInfo
 * @brief ӲSmartϢ
 * @attention  None
 */
typedef struct tagNETDEVHDDSmartCheckInfo
{
    UINT32                          udwID;                                  /* 洢 */
    UINT32                          udwType;                                /*  μö# NETDEV_HDD_SMART_CHECK_TYPE_E */
    BYTE                            byRes[128];                             /* ֽ */
}NETDEV_HDD_SMART_CHECK_INFO_S,*LPNETDEV_HDD_SMART_CHECK_INFO_S;

/**
 * @struct tagNETDEVPhotoServerCfgInfo
 * @brief ƬշϢ
 * @attention  None
 */
typedef struct tagNETDEVPhotoServerCfgInfo
{
    UINT32                          udwProtocol;                                          /* ͨЭ μNETDEV_PHOTO_SERVER_PRO_TYPE_E*/
    UINT32                          udwSubProtocol;                                       /* ͨЭ μNETDEV_PHOTO_SERVER_SUBPRO_TYPE_EudwProtocolΪ131ʱЧ*/
    UINT32                          udwPort;                                              /* TMS˿ں [0,65535] */
    CHAR                            szIPV4Address[NETDEV_IPADDR_STR_MAX_LEN];             /* TMSIPv4ַ*/
    CHAR                            szTollgateID[NETDEV_LEN_64];                          /* ڱ(0, 36]; ѡֶΣӿڲЯֶʱʾ¸ֶ */
    CHAR                            szCameraID[NETDEV_LEN_64];                            /* (0, 36];ѡֶΣӿڲЯֶʱʾ¸ֶ*/

    BYTE                            byRes[128];                                           /* ֽ */
}NETDEV_PHOTO_SERVER_CFG_INFO_S,* LPNETDEV_PHOTO_SERVER_CFG_INFO_S;

/**
 * @struct tagNETDEVPhotoServerCfgInfoList
 * @brief ƬշϢб
 * @attention  None
 */
typedef struct tagNETDEVPhotoServerCfgInfoList
{
    UINT32                          udwNum;                                               /* Ƭ ǰ֧Ϊ2 */
    NETDEV_PHOTO_SERVER_CFG_INFO_S    astPhotoServerList[NETDEV_PHOTO_SERVER_MAX_NUM];    /* Ƭб */

    BYTE                            byRes[512];                                           /* ֽ */
}NETDEV_PHOTO_SERVER_CFG_INFO_LIST_S,* LPNETDEV_PHOTO_SERVER_CFG_INFO_LIST_S;

/**
* @enum tagNETDEVDataServerProtocolType
* @brief ܷЭ öٶ
 * @attention  None
 */
typedef enum tagNETDEVDataServerProtocolType
{
    NETDEV_DATA_SERVER_PROTOCOL_TYPE_TCP_UNVV1   = 1,   /* TCP: V2Ӧǰtms */

    NETDEV_DATA_SERVER_PROTOCOL_TYPE_TFTP_COMMOM = 4,   /* FTP: ͨFTP  */

    NETDEV_DATA_SERVER_PROTOCOL_TYPE_HTTP_GA     = 51   /* HTTP: ͼ */

}NETDEV_DATA_SERVER_PROTOCOL_TYPE_E;

/**
* @enum tagNETDEVManagerServerProtocolType
* @brief Э öٶ
 * @attention  None
 */
typedef enum tagNETDEVManagerServerProtocolType
{
    NETDEV_MANAGER_SERVER_PROTOCOL_TYPE_IMOS   = 0,  /* IMOS */
    NETDEV_MANAGER_SERVER_PROTOCOL_TYPE_GB     = 1,  /*  */
    NETDEV_MANAGER_SERVER_PROTOCOL_TYPE_NONE   = 2,  /*  */
    NETDEV_MANAGER_SERVER_PROTOCOL_TYPE_VISS   = 3,  /* VISS */
    NETDEV_MANAGER_SERVER_PROTOCOL_TYPE_LY     = 4   /* Ԫ */
}NETDEV_MANAGER_SERVER_PROTOCOL_TYPE_E;

/**
 * @struct tagNETDEVServerUserInfo
 * @brief ûϢ
 * @attention 
 */
typedef struct tagNETDEVServerUserInfo
{
    CHAR                            szUserName[NETDEV_USERNAME_LEN];    /* û[1,32] */
    BOOL                            bModifyPasswd;                      /* Ƿ޸ 0:޸ 1:޸*/
    CHAR                            szPasswd[NETDEV_PASSWORD_LEN];      /* ƽ̨ [0,32] ·ַ */
    BYTE                            byRes[256];                         /* ֶ */
}NETDEV_SERVER_USER_INFO_S, *LPNETDEV_SERVER_USER_INFO_S;

/**
 * @struct tagNETDEVDataServerInfo
 * @brief ܷϢ
 * @attention 
 */
typedef struct tagNETDEVDataServerInfo
{
    UINT32                          udwIndex;                                           /* ܷ 0ʼ */
    BOOL                            bEnable;                                            /* ܷʹܿ */
    UINT32                          udwProtocol;                                        /* ͨЭ Ŀǰֻ֧֣ 1:TCP(V2 TMS) # NETDEV_DATA_SERVER_PROTOCOL_TYPE_E */
    CHAR                            szCameraID[NETDEV_LEN_128];                         /* (0, 36] Ϊ0޸*/
    CHAR                            szTollgateID[NETDEV_LEN_128];                       /* ڱ(0, 36] Ϊ0޸ */
    CHAR                            szServerAddr[NETDEV_LEN_32];                        /* IPv4ַ */
    UINT32                          udwServerPort;                                      /* ˿ */
    CHAR                            szDrivewayID[NETDEV_LEN_64];                        /* · IPC֧ */
    CHAR                            szDirectionID[NETDEV_LEN_64];                       /*  IPC֧ */
    CHAR                            szDeviceID[NETDEV_LEN_64];                          /* 豸 IPC֧ */
    CHAR                            szAreaId[NETDEV_LEN_64];                            /* Ͻ IPC֧ */
    NETDEV_SERVER_USER_INFO_S       stServerUserInfo;                                   /* ûϢ */
    BYTE                            byRes[256];                                         /* ֶ */
}NETDEV_DATA_SERVER_INFO, *LPNETDEV_DATA_SERVER_INFO;

/**
 * @struct tagNETDEVDataServerList
 * @brief ܷб
 * @attention 
 */
typedef struct tagNETDEVDataServerList
{
    UINT32                          udwNum;                                               /* ܷ ǰ֧Ϊ2 */
    NETDEV_DATA_SERVER_INFO         astDataServerList[NETDEV_INTELLIGENT_SERVER_MAX_NUM]; /* ܷб */
    BYTE                            byRes[128];                                           /* ֶ */
}NETDEV_DATA_SERVER_LIST, *LPNETDEV_DATA_SERVER_LIST;

/**
 * @struct tagNETDEVManagerServerInfo
 * @brief Ϣ
 * @attention 
 */
typedef struct tagNETDEVManagerServerInfo
{
    UINT32                          udwIndex;                                           /*  0ʼ */
    UINT32                          udwMngProtocol;                                     /* ͨЭ # NETDEV_MANAGER_SERVER_PROTOCOL_TYPE_E */
    CHAR                            szDeviceID[NETDEV_LEN_64];                          /* ǰ豸豸ID[1, 32] */
    CHAR                            szServerID[NETDEV_LEN_64];                          /* עID [1, 32] */
    CHAR                            szDeviceName[NETDEV_DEV_NAME_LEN_MAX];              /* 豸[0, 20] */
    CHAR                            szRegPassword[NETDEV_LEN_32];                       /* ע(0, 16] */
    CHAR                            szVideoChlID[NETDEV_LEN_64];                        /* ƵͨID[0,32] */
    CHAR                            szAudioChlID[NETDEV_LEN_64];                        /* ƵͨID[0,32] */
    UINT32                          udwExpire;                                          /* עЧ[3600,36000] */
    CHAR                            szAddress[NETDEV_IPADDR_STR_MAX_LEN];               /* IPv4ַ */
    UINT32                          udwPort;                                            /* ˿ */
    BYTE                            byRes[256];                                         /* ֶ */
}NETDEV_MANAGER_SERVER_INFO_S, *LPNETDEV_MANAGER_SERVER_INFO_S;

/**
 * @struct tagNETDEVManagerServerList
 * @brief б
 * @attention 
 */
typedef struct tagNETDEVManagerServerList
{
    UINT32                          udwNum;                                               /*  ǰ֧Ϊ2 */
    NETDEV_MANAGER_SERVER_INFO_S    astManagerServerList[NETDEV_MANAGER_SERVER_MAX_NUM];  /* б */
    BYTE                            byRes[128];                                           /* ֶ */
}NETDEV_MANAGER_SERVER_LIST_S, *LPNETDEV_MANAGER_SERVER_LIST_S;

/**
 * @struct tagNETDEVVisibleRangeInfo
 * @brief Ϣ
 * @attention 
 */
typedef struct tagNETDEVVisibleRangeInfo
{
    DOUBLE                          dAzimuthHorizontal;                                 /* ˮƽλǶȣˮƽͶӰļнǵˮƽ׼ĽǵĽǶȣλ:ȱʾ Χ:[-1.0000,+1.0000] */
    DOUBLE                          dAzimuthVertical;                                   /* ֱλǶȣڴֱͶӰļнǵ봹ֱϻ׼ĽǵĽǶȣλ:ȱʾȷС4λ Χ:[-1.0000,+1.0000] */
    DOUBLE                          dInclinationHorizontal;                             /* ˮƽбǶȣ豸ˮƽ׼ˮƽļнǣ λ:ȱʾȷС4λ Χ:[-1.0000,+1.0000] */
    DOUBLE                          dAngelHorizontal;                                   /* ˮƽӽǶ λ:ȾȷС4λ */
    DOUBLE                          dAngelVertical;                                     /* ֱӽǶ λ:ȾȷС4λ */
    DOUBLE                          dDistance;                                          /* Ӿ λ:׾ȷС4λ */
    DOUBLE                          dInstallationHeight;                                /* װ߶ λףȷС4λ */
    BYTE                            byRes[248];                                         /* ֶ */
}NETDEV_VISIBLE_RANGE_INFO_S, *LPNETDEV_VISIBLE_RANGE_INFO_S;


/**
 * @struct tagNETDEVCustomProSimpleInfo
 * @brief ԶЭϢ
 * @attention  None
 */
typedef struct tagNETDEVCustomProSimpleInfo
{
    UINT32                                          udwProID;                                       /* ԶЭ,  */
    CHAR                                            szProName[NETDEV_LEN_64];                       /* ԶЭ[0, 64] */
    BYTE                                            byRes[128];                                     /* ֽ */
}NETDEV_CUSTON_PROTOCOL_SIMPLE_INFO_S,* LPNETDEV_CUSTON_PROTOCOL_SIMPLE_INFO_S;

/**
 * @struct tagNETDEVCustomProSimpleInfoList
 * @brief ԶЭõϢб
 * @attention  None
 */
typedef struct tagNETDEVCustomProSimpleInfoList
{
    UINT32                                          udwNum;                                         /* ԶЭ, ǰ֧64 */
    NETDEV_CUSTON_PROTOCOL_SIMPLE_INFO_S            astCustomProSimpleList[NETDEV_LEN_64];          /* ԶЭб */
    BYTE                                            byRes[512];                                     /* ֽ */
}NETDEV_CUSTON_PROTOCOL_SIMPLE_INFO_LIST_S,* LPNETDEV_CUSTON_PROTOCOL_SIMPLE_INFO_LIST_S;

/*
 * @struct tagNETDEVCustomStreamInfo
 * @brief ԶЭϢ
 * @attention  None
 */
typedef struct tagNETDEVCustomStreamInfo
{
    UINT32                                          udwEnable;                                      /* 1:ʹ; 0:ʹ */
    CHAR                                            szProName[NETDEV_LEN_128];                      /* URLַ[0, 128] */

    BYTE                                            byRes[512];                                     /* ֽ */
}NETDEV_CUSTON_STREAM_INFO_S,* LPNETDEV_CUSTON_STREAM_INFO_S;

/**
 * @struct tagNETDEVCustomProInfo
 * @brief ԶЭϢ
 * @attention  None
 */
typedef struct tagNETDEVCustomProInfo
{
    UINT32                                          udwTransport;                                   /* ģʽ, μö NETDEV_TRANS_PROTOCOL_E */
    UINT32                                          udwPort;                                        /* ˿ */
    NETDEV_CUSTON_PROTOCOL_SIMPLE_INFO_S            stCustomProSimpleInfo;                          /* ԶЭϢ */
    NETDEV_CUSTON_STREAM_INFO_S                     stMainStream;                                   /* ЭϢ */
    NETDEV_CUSTON_STREAM_INFO_S                     stSubStream;                                    /* ЭϢ */
    NETDEV_CUSTON_STREAM_INFO_S                     stThirdStream;                                  /* ЭϢ */

    BYTE                                            byRes[512];                                     /* ֽ */
}NETDEV_CUSTON_PROTOCOL_INFO_S,* LPNETDEV_CUSTON_PROTOCOL_INFO_S;

/**
 * @struct tagNETDEVHDDSmartInfo
 * @brief ӲSmartϢ
 * @attention  None
 */
typedef struct tagNETDEVHDDSmartInfo
{
    UINT32                          udwID;                                  /* IN 洢 */
    CHAR                            szManufacturer[NETDEV_LEN_64];          /*  */
    UINT32                          udwTemperature;                         /* ¶() */
    CHAR                            szDeviceModel[NETDEV_LEN_64];           /* Ӳͺ */
    UINT32                          udwUsedDays;                            /* ʹ */
    UINT32                          udwHealthAssessment;                    /*  μö#NETDEV_HDD_HEALTH_ASSESSMENT_STATUS_E */
    CHAR                            szFirmware[NETDEV_LEN_64];              /* Ӳ̹̼汾 */
    UINT32                          udwSmartNum;                            /* Smart */
    NETDEV_HDD_SMART_DETAILS_INFO_S SmartDetailsInfoList[NETDEV_DISK_SMART_MAX_NUM];    /* Smartб */
    BOOL                            bCheckResult;                           /* , TRUE ͨFALSE δͨ */
    UINT32                          udwCheckPrograss;                       /*  [0,100] */
    UINT32                          udwCheckStatus;                         /* ״̬ μö#NETDEV_HDD_SMART_CHECK_STATUS_E */
    UINT32                          udwCheckType;                           /*  μö#NETDEV_HDD_SMART_CHECK_TYPE_E */
    BYTE                            byRes[128];                             /* ֽ */
}NETDEV_HDD_SMART_INFO_S,*LPNETDEV_HDD_SMART_INFO_S;

/*
* @struct tagDNSAddress
* @brief DNSַ
* @attention  None
*/
typedef struct tagDNSAddress
{
    UINT32  udwAddressType;                 /*IPַ 0: IPv4  1: IPv6 3: IPv4IPv6Ҫ ǰ֧IPv4 */
    CHAR   szIPAddress[NETDEV_LEN_64];      /*IPv4ַ*/
    CHAR   szIPv6Address[NETDEV_LEN_64];    /*IPv6ַ*/
    BYTE   byRes[128];                      /*   Reserved */
}NETDEV_DNS_ADDRESS_S, *LPNETDEV_DNS_ADDRESS_S;


/*
* @struct tagNETDEVDNSInfo
* @brief 豸DNSϢ device DNS Info
* @attention  None
*/
typedef struct tagNETDEVDNSInfo
{
    UINT32                  udwNum;                             /*DNSַ*/
    NETDEV_DNS_ADDRESS_S    astDNSList[NETDEV_DNS_LIST_NUM];    /*DNSַб1ΪҪַ2Ϊѡַǰֻ֧2*/
    BYTE                    byRes[128];                         /*   Reserved */
}NETDEV_DNS_INFO_S, *LPNETDEV_DNS_INFO_S;

/*
* @struct tagIpv6Addressinfo
* @brief IPV6ϸַϢ
* @attention  None
*/
typedef struct tagIpv6Addressinfo
{
    UINT32  udwPrefixLenth;             /*ǰ׺ȣΧΪ[3,127]*/
    CHAR    szAddress[NETDEV_LEN_64];   /*IPַ*/
    CHAR    szGateway[NETDEV_LEN_64];   /*Ĭ*/

}NETDEV_IPV6_ADDRESS_INFO_S, *LPNETDEV_IPV6_ADDRESS_INFO_S;
/*
* @struct tagNetWorkIpv6info
* @brief ϢIPV6Ϣ
* @attention  None
*/
typedef struct tagNetWorkIpv6info
{
    UINT32                      udwIPGetType;                           /*IPȡʽ*/
    UINT32                      udwAddressNum;                          /*IPַ*/
    NETDEV_IPV6_ADDRESS_INFO_S  astIPv6AddressInfo[NETDEV_LEN_8];       /*IPv6Ϣ֧IPv6ýڵѡ*/

}NETDEV_NETWORK_IPV6_INFO_S, *LPNETDEV_NETWORK_IPV6_INFO_S;

/*
* @struct tagIpv4Addressinfo
* @brief IPV4ϸַϢ
* @attention  None
*/
typedef struct tagIpv4Addressinfo
{
    CHAR   szAddress[NETDEV_LEN_64];                /*IPַ*/
    CHAR   szNetmask[NETDEV_LEN_64];                /**/
    CHAR   szGateway[NETDEV_LEN_64];                /*Ĭ*/

}NETDEV_IPV4_ADDRESS_INFO_S, *LPNETDEV_IPV4_ADDRESS_INFO_S;
/*
* @struct tagIpv4info
* @brief ϢIPV4Ϣ
* @attention  None
*/
typedef struct tagNetWorkIpv4info
{
    UINT32                      udwIPGetType;                       /*IPȡʽ 0for static 1for PPPOE2for DHCP*/
    CHAR                        szLoginName[NETDEV_LEN_64];         /*PPPoE˺*/
    CHAR                        szPIN[NETDEV_LEN_128];              /*PPPOE루MD5ܣ*/
    UINT32                      udwAddressNum;                      /*IPַ*/
    NETDEV_IPV4_ADDRESS_INFO_S  astIPv4AddressInfo[NETDEV_LEN_8];   /*IPv4Ϣ֧IPv4ýڵѡ*/

}NETDEV_NETWORK_IPV4_INFO_S, *LPNETDEV_NETWORK_IPV4_INFO_S;

/*
* @struct tagNETDEVNetworkInterfaceInfo
* @brief ϸϢ
* @attention  None
*/
typedef struct tagNETDEVNetworkInterfaceInfo
{
    UINT32              udwID;                                             /*ŶVMSIPC1ʼ NVRֶԴ*/
    CHAR                szName[NETDEV_NAME_MAX_LEN];                       /*ƣNVRIPC֧*/
    UINT32              udwWorkMode;                                       /*ģʽ 0ַ趨 1ؾ  2ݴ*/
    BOOL                bIsInnerNIC;                                       /*ǷΪڲ*/
    CHAR                szInnerNICIPAddress[NETDEV_IPADDR_STR_MAX_LEN];    /*ڲIPַ*/
    CHAR                szInnerNICNetmask[NETDEV_IPADDR_STR_MAX_LEN];      /*ڲ룻ֶβãѯ*/
    CHAR                szInnerNICName[NETDEV_NAME_MAX_LEN];               /*ڲƣֶβãѯ*/
    UINT32              udwMTU;                                            /*MTUȣΧ[576,1500]*/
    CHAR                szMAC[NETDEV_NETWORK_MACNAME_LEN];                 /*MACַֻԣַȷΧ[0, 48]*/
    UINT32              udwNegotiationMode;                                /*ڹģʽ*/
    NETDEV_NETWORK_IPV4_INFO_S stIPV4Infos;                                /*IPv4Ϣ֧IPv4ýڵѡ*/
    NETDEV_NETWORK_IPV6_INFO_S stIPV6Infos;                                /*IPv6Ϣ֧IPv6ýڵѡ*/
    BYTE                byRes[128];                                        /*   Reserved */
}NETDEV_NETWORK_INTERFACE_INFO_S, *LPNETDEV_NETWORK_INTERFACE_INFO_S;

/*
* @struct tagNETDEVNetworkCardsInfo
* @brief ѯ豸Ϣ
* @attention  None
*/
typedef struct tagNETDEVNetworkCardsInfo
{
    UINT32                              udwNum;                                     /**/
    UINT32                              udwDefaultRouteNIC;                         /*Ĭ·ɵIDڶڲʱѡ*/
    UINT32                              udwWorkMode;                                /*ģʽ 0ַ趨 1ؾ  2ݴ*/
    NETDEV_NETWORK_INTERFACE_INFO_S     astNetworkInterfaceList[NETDEV_LEN_8];      /*ϢбNumֵΪ0ʱýڵѡ*/
    BYTE                                byRes[128];                                 /*   Reserved */
}NETDEV_NETWORK_CARD_INFO_S, *LPNETDEV_NETWORK_CARD_INFO_S;



/**
* @struct tagNETDEVFGSubInfo
* @brief ͨŶϢ
* @attention  None
*/
typedef struct tagNETDEVFGSubInfo
{
    UINT32 udwType;                         /*  öNETDEV_SUB_TYPE_E*/
    UINT32 udwLibIDNum;                     /* ĵĿIDĿ LibIDNumΪ16ʱ ʾп */
    UINT32 audwLibIDList[NETDEV_LEN_32];    /* ĵĿIDб */
    BYTE   byRes[128];                      /* ֽ */
}NETDEV_FG_SUB_INFO_S,*LPNETDEV_FG_SUB_INFO_S;

/**
* @struct tagNETDEVFGSubSuccInfo
* @brief ͨŶϢɹϢ
* @attention  None
*/
typedef struct tagNETDEVFGSubSuccInfo
{
    UINT32 udwID;                   /* ID */
    UINT32 udwCurrrntTime;          /* ǰʱ䣬UTCʽλ */
    UINT32 udwTerminationTime;      /* ʱ䣬UTCʽλ */
    BYTE   byRes[128];              /* ֽ */
}NETDEV_FG_SUB_SUCC_INFO_S,*LPNETDEV_FG_SUB_SUCC_INFO_S;

/**
* @struct tagNETDEVFileInfo
* @brief ļϢ
* @attention udwSizeΪ0pcDataΪ,ͨszUrlȡͼƬ
*/
typedef struct tagNETDEVFileInfo
{
    CHAR   szName[NETDEV_LEN_64];   /* ļ Χ[1, 16]*/
    UINT32 udwSize;                 /* ļС[dataͨszurlȡͼƬС(Base64)] */
    UINT32 dwFileType;              /* ļͣöֵNETDEV_FILE_TYPE_E */
    UINT32 udwLastChange;           /* ޸ʱ䣬UTCʱ䣬λΪs */
    CHAR   *pcData;                 /* ļ Base64 udwSize ̬ڴ*/
    CHAR   szUrl[NETDEV_LEN_512];   /* ͼƬURLȷΧ[0,256] */
    BYTE   byRes[128];              /* ֽ */
}NETDEV_FILE_INFO_S,*LPNETDEV_FILE_INFO_S;

/**
* @struct tagNETDEVFeatureInfo
* @brief ṹϢ
* @attention  None
*/
typedef struct tagNETDEVFeatureInfo
{
    CHAR    szFeatureVersion[NETDEV_LEN_32];        /* ṹȡ㷨汾 [0, 20] */
    CHAR    szFeature[NETDEV_FACE_FEATURE_SIZE];    /* ȡϢ Ŀǰǰ512B */
    BYTE    byRes[128];                             /* ֽ */
}NETDEV_FEATURE_INFO_S,*LPNETDEV_FEATURE_INFO_S;

/**
* @struct tagNETDEVRegionInfo
* @brief ԱϢ
* @attention  None
*/
typedef struct tagNETDEVRegionInfo
{
    CHAR szNation[NETDEV_LEN_128];          /* Χ[1-63] */
    CHAR szProvince[NETDEV_LEN_128];        /* ʡݣΧ[1-63] */
    CHAR szCity[NETDEV_LEN_128];            /* УΧ[1-63] */
    BYTE byRes[256];

}NETDEV_REGION_INFO_S, *LPNETDEV_REGION_INFO_S;

/**
* @enum tagNETDEVPersonTimeTemplateInfo
* @brief ʱģϢ
* @attention  None
*/
typedef struct tagNETDEVPersonTimeTemplateInfo
{
    UINT32 udwBeginTime;    /* ʱģЧʼʱ δãд0 */
    UINT32 udwEndTime;      /* ʱģЧʱ δãд4294967295(0xFFFFFFFF)*/
    UINT32 udwIndex;        /* ʱģ */
    BYTE   byRes[128];      /* ֽ */
}NETDEV_PERSON_TIME_TEMPLATE_INFO_S,*LPNETDEV_PERSON_TIME_TEMPLATE_INFO_S;

/**
* @struct tagNETDEVIdentificationInfo
* @brief Ա֤Ϣ
* @attention  None
*/
typedef struct tagNETDEVIdentificationInfo
{
    UINT32 udwType;                     /* ֤ μö NETDEV_ID_TYPE_E*/
    CHAR   szNumber[NETDEV_LEN_128];    /* ֤ţΧ:[1, 127] */
    BYTE   byRes[32];                  /* ֽ */
}NETDEV_IDENTIFICATION_INFO_S,*LPNETDEV_IDENTIFICATION_INFO_S;

/**
* @struct tagNETDEVImageInfo
* @brief ͼƬϢб
* @attention  None
*/
typedef struct tagNETDEVImageInfo
{
    UINT32 udwFaceID;                   /* ƬID */
    NETDEV_FILE_INFO_S stFileInfo;      /* ƬϢ */
    UINT32 udwModelStatus;              /* ģ״̬,öֵ: NETDEV_MODEL_STATUS_E  ModelStatus,See NETDEV_MODEL_STATUS_E for details*/
    
    BYTE   byRes[124];                  /* ֽ */
}NETDEV_IMAGE_INFO_S,*LPNETDEV_IMAGE_INFO_S;

/**
 * @struct tagNETDEVCustomValue
 * @brief ԶϢ
 * @attention  None
 */
typedef struct tagNETDEVCustomValue
{
    UINT32  udwID;                                         /* Զ 0ʼ*/
    CHAR    szValue[NETDEV_FACE_MEMBER_CUSTOM_LEN];        /* Զֵ Χ[1,63]*/
    UINT32  udwModelStatus;                                /* ģ״̬,öֵ: NETDEV_MODEL_STATUS_E  ModelStatus,See NETDEV_MODEL_STATUS_E for details*/
    BYTE    byRes[124];                                    /* ֶ  Reserved */
}NETDEV_CUSTOM_VALUE_S,*LPNETDEV_CUSTOM_VALUE_S;

/**
 * @struct tagNETDEVStaffInfo
 * @brief ԱϢ
 * @attention  None
 */
typedef struct tagNETDEVStaffInfo
{
    CHAR   szNumber[NETDEV_LEN_32];                       /* Ա ַȷΧ[1, 16] */
    CHAR   szBirthday[NETDEV_LEN_32];                     /*  ַȷΧ[1,31] */
    UINT32 udwDeptID;                                     /* ID */
    CHAR   szDeptName[NETDEV_LEN_256];                    /*  ʱɲЯ ַȷΧ[1, 64] */
    BYTE   byRes[256];                                    /* ֶ  Reserved */
}NETDEV_STAFF_INFO_S,*LPNETDEV_STAFF_INFO_S;

/**
 * @struct tagNETDEVVisitorInfo
 * @brief ÿϢ
 * @attention  None
 */
typedef struct tagNETDEVVisitorInfo
{
    UINT32 udwVisitorCount;                               /* ÿ */
    CHAR   szCompany[NETDEV_LEN_256];                     /* ÿ͵λ ַȷΧ[1, 64] */
    UINT32 udwIntervieweeID;                              /* ID */
    BYTE   byRes[256];                                    /* ֶ  Reserved */
}NETDEV_VISITOR_INFO_S,*LPNETDEV_VISITOR_INFO_S;

/**
* @struct tagNETDEVPersonInfo
* @brief ԱϢ
* @attention  None
*/
typedef struct tagNETDEVPersonInfo
{
    UINT32                                  udwPersonID;                         /* ԱID */
    UINT32                                  udwLastChange;                       /* ԱϢ޸ʱ */
    CHAR                                    szPersonName[NETDEV_LEN_256];        /* Ա Χ:[1, 63] */
    UINT32                                  udwGender;                           /* ԱԱ μöNETDEV_GENDER_TYPE_E*/
    CHAR                                    szBirthday[NETDEV_LEN_64];           /* ԱڣʽYYYYMMDDΧ[1,31] */
    NETDEV_REGION_INFO_S                    stRegionInfo;                        /* ԱϢ */
    UINT32                                  udwTimeTemplateNum;                  /* ʱģ */
    LPNETDEV_PERSON_TIME_TEMPLATE_INFO_S    pstTimeTemplateList;                 /* ʱģϢ 趯̬ */
    UINT32                                  udwIdentificationNum;                /* ֤Ϣ Χ:[0, 6]*/
    NETDEV_IDENTIFICATION_INFO_S            stIdentificationInfo[NETDEV_LEN_8];  /* Ա֤Ϣ */
    UINT32                                  udwImageNum;                         /* ͼƬ Χ:[0, 6] */
    NETDEV_IMAGE_INFO_S                     stImageInfo[NETDEV_LEN_8];           /* ͼƬϢб */
    UINT32                                  udwReqSeq;                           /* кţֶλڷؽдᣬЯֶ */
    BOOL                                    bIsMonitored;                        /* ǷѲأȡʱشVMS֧ */
    UINT32                                  udwBelongLibNum;                     /* ԱVMS֧ */
    UINT32                                 *pudwBelongLibList;                   /* ԱIDб趯̬ڴ棬VMS֧ */
    UINT32                                  udwCustomNum;                        /* Զֵ5VMS֧ */
    LPNETDEV_CUSTOM_VALUE_S                 pstCustomValueList;                  /* Զֵб趯̬ڴ棬NumΪ0ʱԲ */
    CHAR                                    szTelephone[NETDEV_LEN_64];          /* ϵ绰 ַ[1,64] */
    CHAR                                    szAddress[NETDEV_LEN_256];           /* ַ ַȷΧ[1, 64] */
    UINT32                                  udwCardNum;                          /* Ž ȡֵΧ[0,6],GetʱЯ */
    UINT32                                  udwFingerprintNum;                   /* ָƸȡֵΧ[0,10] */
    UINT32                                  udwType;                             /* Ա 0Ա 1ÿ 2İ */
    NETDEV_STAFF_INFO_S                     stStaff;                             /* ԱϢ TypeΪԱʱ */
    NETDEV_VISITOR_INFO_S                   stVisitor;                           /* ÿϢ TypeΪÿʱ */
    CHAR                                    szDesc[NETDEV_LEN_480];              /* עϢ ַȷΧ[1, 128] */
    CHAR                                    szPersonCode[NETDEV_LEN_16];         /* Ա룬дѧŻ򹤺ţΧ:[1, 15] PTS֧ */
    CHAR                                    szRemarks[NETDEV_LEN_64];            /* עϢ Χ:[1-63] PTS֧ */
    BYTE                                    byRes[176];                          /* ֽ */
}NETDEV_PERSON_INFO_S,*LPNETDEV_PERSON_INFO_S;

/**
* @struct tagNETDEVCtrlFaceInfo
* @brief Ϣ
* @attention  None
*/
typedef struct tagNETDEVCtrlFaceInfo
{
    UINT32 udwID;                                           /* ¼ID */
    UINT32 udwTimestamp;                                    /* ɼʱ UTCʽλ */
    UINT32 udwCapSrc;                                       /* ɼԴ  NETDEV_CAP_SRC_E FaceInfoѡ1 */
    UINT32 udwFeatureNum;                                   /* ṹĿ Χ[0, 2] */
    LPNETDEV_FEATURE_INFO_S pstFeatureInfo;                 /* ṹб 趯̬ڴ */
    NETDEV_FILE_INFO_S stPanoImage;                         /* ȫͼ */
    NETDEV_FILE_INFO_S stFaceImage;                         /* Сͼ */
    NETDEV_FACE_POSITION_INFO_S stFaceArea;                 /* ȫͼ */
    FLOAT  fTemperature;                                    /* Ա λ϶ȣעС1λ */
    UINT32 udwMaskFlag;                                     /* Ƿ֣0δ֪δü⣻1δ֣2 */
    BYTE   byRes[120];                                      /* ֽ */
}NETDEV_CTRL_FACE_INFO_S,*LPNETDEV_CTRL_FACE_INFO_S;

/**
* @enum tagNETDEVCtrlGateInfo
* @brief բϢ
* @attention  None
*/
typedef struct tagNETDEVCtrlGateInfo
{
    UINT32 udwID;               /* ¼ID */
    UINT32 udwTimestamp;        /* ɼʱ */
    UINT32 udwCapSrc;           /* ɼԴ  NETDEV_CAP_SRC_E GateInfoѡ4 */
    UINT32 udwInPersonCnt;      /* Ա */
    UINT32 udwOutPersonCnt;     /* 뿪Ա */
    BYTE   byRes[128];          /* ֽ */
}NETDEV_CTRL_GATE_INFO_S,*LPNETDEV_CTRL_GATE_INFO_S;

/**
* @struct tafNETDEVCtrlCardInfo
* @brief Ϣ
* @attention  None
*/
typedef struct tafNETDEVCtrlCardInfo
{
    UINT32 udwID;                                       /* ¼ID */
    UINT32 udwTimestamp;                                /* ɼʱ UTCʽλ */
    UINT32 udwCapSrc;                                   /* ɼԴ  NETDEV_CAP_SRC_E CardInfoѡ23*/
    UINT32 udwCardType;                                 /* 0֤1Ž*/
    CHAR   szCardID[NETDEV_LEN_32];                     /* ŽֶΣ 18λ*/
    UINT32 udwCardStatus;                               /* ŽֶΣ״̬ */
    CHAR   szName[NETDEV_LEN_256];                      /* ֶ֤Σ Χ[1,63] */
    UINT32 udwGender;                                   /* ֶ֤ΣԱ μöNETDEV_GENDER_TYPE_E*/
    UINT32 udwEthnicity;                                /* ֶ֤Σ 01*/
    CHAR   szBirthday[NETDEV_LEN_16];                   /* ֶ֤Σ YYYYMMDD */
    CHAR   szResidentialAddress[NETDEV_LEN_128];        /* ֶ֤Σסַ */
    CHAR   szIdentityNo[NETDEV_LEN_32];                 /* ֶ֤Σ֤ */
    CHAR   szIssuingAuthority[NETDEV_LEN_128];          /* ֶ֤Σ֤ */
    CHAR   szIssuingDate[NETDEV_LEN_16];                /* ֶ֤Σ֤ YYYYMMDD */
    CHAR   szValidDateStart[NETDEV_LEN_16];             /* ֶ֤Σ֤Чڿʼʱ */
    CHAR   szValidDateEnd[NETDEV_LEN_16];               /* ֶ֤Σ֤Чڽʱ */
    NETDEV_FILE_INFO_S stIDImage;                       /* ֤Ƭ */
    BYTE   byRes[128];                                  /* ֽ */
}NETDEV_CTRL_CARD_INFO_S,*LPNETDEV_CTRL_CARD_INFO_S;

/**
* @struct tagNETDEVMatchPersonInfo
* @brief ƥԱϢ
* @attention  None
*/
typedef struct tagNETDEVMatchPersonInfo
{
    CHAR   szPersonName[NETDEV_LEN_256];        /* Ա Χ[1,63] */
    UINT32 udwGender;                           /* ԱԱ μöNETDEV_DENDER_TYPE_E */
    CHAR   szCardID[NETDEV_LEN_32];             /* Ž */
    CHAR   szIdentityNo[NETDEV_LEN_32];         /* ֤ */
    CHAR   szPersonCode[NETDEV_LEN_64];         /* Ա дѧŻ򹤺 Χ:[1, 15] */
    BYTE   byRes[64];                           /* ֽ */
}NETDEV_MATCH_PERSON_INFO_S,*LPNETDEV_MATCH_PERSON_INFO_S;

/**
* @struct tagNETDEVCtrlLibMatchInfo
* @brief ȶϢ
* @attention  None
*/
typedef struct tagNETDEVCtrlLibMatchInfo
{
    UINT32 udwID;                                   /* ¼ID */
    UINT32 udwLibID;                                /* ID */
    UINT32 udwLibType;                              /*  */
    UINT32 udwMatchStatus;                          /* ƥ״̬ NETDEV_MATCH_STATUS_E */
    UINT32 udwMatchPersonID;                        /* ƥԱID */
    UINT32 udwMatchFaceID;                          /* ƥID */
    NETDEV_MATCH_PERSON_INFO_S stMatchPersonInfo;   /* ƥԱϢ */
    BYTE   byRes[128];                              /* ֽ */
}NETDEV_CTRL_LIB_MATCH_INFO_S,*LPNETDEV_CTRL_LIB_MATCH_INFO_S;

/**
* @struct tagNETDEVPersonVerification
* @brief Ա
* @attention  None
*/
typedef struct tagNETDEVPersonVerification
{
    CHAR   szReference[NETDEV_LEN_128];                                      /* ڿͻȷϢurl */
    UINT32 udwSeq;                                                           /* ֪ͨ¼ */
    UINT32 udwChannelID;                                                     /* ͨID VMS֧*/
    CHAR   szChannelName[NETDEV_LEN_256];                                    /* ͨƣ [1,64]VMS֧ */
    UINT32 udwTimestamp;                                                     /* ֪ͨϱʱ UTCʽλ*/
    UINT32 udwNotificationType;                                              /* ֪ͨ 0ʵʱ֪ͨ1ʷ֪ͨ */
    UINT32 udwFaceInfoNum;                                                   /* ϢĿ Χ[0, 1] */
    LPNETDEV_CTRL_FACE_INFO_S pstCtrlFaceInfo;                               /* Ϣ 趯̬ڴ*/
    UINT32 udwCardInfoNum;                                                   /* ϢĿ Χ[0, 1] */
    LPNETDEV_CTRL_CARD_INFO_S pstCtrlCardInfo;                               /* Ϣ 趯̬ڴ*/
    UINT32 udwGateInfoNum;                                                   /* բϢĿ Χ[0, 1] */
    LPNETDEV_CTRL_GATE_INFO_S pstCtrlGateInfo;                               /* բϢ 趯̬ڴ*/
    UINT32 udwLibMatInfoNum;                                                 /* ȶϢĿ Χ[0, 16] */
    LPNETDEV_CTRL_LIB_MATCH_INFO_S pstLibMatchInfo;                          /* ȶϢ 趯̬ڴ*/
    BYTE   byRes[128];                                                       /* ֽ */
}NETDEV_PERSON_VERIFICATION_S,*LPNETDEV_PERSON_VERIFICATION_S;


/**
* @struct tagNETDEVPersonCompareInfo
* @brief  ȶϢ
* @attention  None
*/
typedef struct tagNETDEVPersonCompareInfo
{
    UINT32                      udwSimilarity;                                  /* ƶ */
    NETDEV_PERSON_INFO_S        stPersonInfo;                                   /* ԱϢ */
    NETDEV_FILE_INFO_S          stPanoImage;                                    /* ͼ  */
    NETDEV_FILE_INFO_S          stFaceImage;                                    /* Сͼ */
    NETDEV_FACE_POSITION_INFO_S stFaceArea;                                     /*  */
    UINT32                      udwCapSrc;                                      /* ɼԴ */
    UINT32                      udwFeatureNum;                                  /* ṹĿ ûаṹɲֶ PTSش */
    LPNETDEV_FEATURE_INFO_S     pstFeatureInfo;                                 /* ṹб ûаṹɲֶ  PTSش */
    BYTE                        byRes[248];                                     /* ֶ */
}NETDEV_PERSON_COMPARE_INFO_S, *LPNETDEV_PERSON_COMPARE_INFO_S;

/**
* @struct tagNETDEVFacePassRecordInfo
* @brief  ͨ¼Ϣ
* @attention  None
*/
typedef struct tagNETDEVFacePassRecordInfo
{
    UINT32                              udwRecordID;                        /* ͨм¼ID */
    UINT32                              udwType;                            /* ͨͣμöNETDEV_FACE_PASS_RECORD_TYPE_E */
    INT64                               tPassingTime;                       /* ʱ䣬UTCʽλ */
    UINT32                              udwChannelID;                       /* ͨID */
    CHAR                                szChlName[NETDEV_LEN_128];          /* ץͨƣΧ[1,63] */
    NETDEV_PERSON_COMPARE_INFO_S        stCompareInfo;                      /* ȶϢ */
    BYTE                                byRes[256];                         /* ֶ */
}NETDEV_FACE_PASS_RECORD_INFO_S, *LPNETDEV_FACE_PASS_RECORD_INFO_S;

/**
* @struct tagNETDEVPersonEventInfo
* @brief ԱϢ
* @attention  None
*/
typedef struct tagNETDEVPersonEventInfo
{
    UINT32                          udwID;                                   /* ֪ͨ¼ID */
    UINT32                          udwTimestamp;                            /* ֪ͨϱʱ UTCʽλ*/
    UINT32                          udwNotificationType;                     /* ֪ͨ 0ʵʱ֪ͨ1ʷ֪ͨ */
    UINT32                          udwFaceInfoNum;                          /* ϢĿ Χ[0, 1] */
    NETDEV_FACE_PASS_RECORD_INFO_S  stCtrlFaceInfo[NETDEV_LEN_2];            /* ϢбɼϢûʱɲFaceInfoֶ */
    UINT32                          udwFinishFaceNum;                        /*  Χ[0, 40] */
    UINT32                          audwFinishFaceList[NETDEV_LEN_40];       /* б */
    BYTE                            byRes[92];                               /* ֶ */
}NETDEV_PERSON_EVENT_INFO_S, *LPNETDEV_PERSON_EVENT_INFO_S;

/**
* @struct tagNETDEVUpdateInfo
* @brief Ϣ
* @attention  None
*/
typedef struct tagNETDEVUpdateInfo
{
    UINT32 udwID;               /* ʱģID */
    UINT32 udwLastChange;       /* ʱģ޸ʱ */
    BYTE   byRes[128];          /* ֽ */
}NETDEV_UPDATE_INFO_S,*LPNETDEV_UPDATE_INFO_S;

/**
* @struct tagNETDEVTimeTemplateUdateInfo
* @brief ʱģĸϢ
* @attention  None
*/
typedef struct tagNETDEVTimeTemplateUpdateInfo
{
    UINT32 udwNum;                                          /* Чʱģ [0, 32] */
    NETDEV_UPDATE_INFO_S stUpdateInfo[NETDEV_LEN_64];       /* Ϣ */
    BYTE   byRes[128];                                      /* ֽ */
}NETDEV_TIME_TEMPLATE_UPDATE_INFO_S,*LPNETDEV_TIME_TEMPLATE_UPDATE_INFO_S;

/**
* @struct tagNETDEVExceptionDayInfo
* @brief ÿĲƻϢ
* @attention  None
*/
typedef struct tagNETDEVExceptionDayInfo
{
    UINT32 udwID;                                                            /*  */
    BOOL   bEnabled;                                                         /* Ƿʹ */
    CHAR   szDate[NETDEV_LEN_16];                                            /*  year-month-day */
    UINT32 udwNum;                                                           /* ʱθ NVRΪ8 IPC/PTSΪ4*/
    NETDEV_TIME_SECTION_INFO_S stTimeSectionInfo[NETDEV_LEN_16];             /* þϢ */
    BYTE   byRes[128];                                                       /* ֽ */
}NETDEV_EXCEPTION_DAY_INFO_S,*LPNETDEV_EXCEPTION_DAY_INFO_S;

/**
* @struct tagNETDEVExceptionInfo
* @brief ƻ
* @attention  None
*/
typedef struct tagNETDEVExceptionInfo
{
    BOOL   bEnabled;                                                         /* Ƿʹ 0:ʹ 1ʹ */
    UINT32 udwNum;                                                           /* ڸ [0, 16] */
    NETDEV_EXCEPTION_DAY_INFO_S stExceptionDayInfo[NETDEV_LEN_32];           /* ÿĲƻϢ */
    BYTE   byRes[128];                                                       /* ֽ */
}NETDEV_EXCEPTION_INFO_S,*LPNETDEV_EXCEPTION_INFO_S;

/**
* @struct tagNETDEVTimeTemplateInfo
* @brief ʱģ
* @attention  None
*/
typedef struct tagNETDEVTimeTemplateInfo
{
    UINT32 udwID;                                   /* Աʱģ岼 */
    CHAR   szName[NETDEV_LEN_256];                  /* ʱģ [1, 63] */
    UINT32 udwLastChange;                           /* ʱģ޸ʱ */
    NETDEV_WEEK_PLAN_INFO_S stWeekPlanInfo;         /* 񲼷ƻ */
    NETDEV_EXCEPTION_INFO_S stExceptionInfo;        /* ƻ */
    BYTE   byRes[128];                              /* ֽ */
}NETDEV_TIME_TEMPLATE_INFO_S,*LPNETDEV_TIME_TEMPLATE_INFO_S;

/**
* @struct tagNETDEVSystemTimeTemplate
* @brief ʱģ(PTS VMS)
* @attention  None
*/
typedef struct tagNETDEVSystemTimeTemplate
{
    UINT32                  udwTemplateID;                           /* ʱģID */
    CHAR                    szTemplateName[NETDEV_LEN_256];          /* ʱģ [1, 63] */
    CHAR                    szTemplateDesc[NETDEV_LEN_512];          /* ʱģ [1, 128] */
    UINT32                  udwLastChange;                           /* ʱģ޸ʱ */
    NETDEV_WEEK_PLAN_INFO_S stWeekPlanInfo;                          /* 񲼷ƻ */
    NETDEV_EXCEPTION_INFO_S stExceptionInfo;                         /* ƻ */
    BOOL                    bIsBuiltin;                              /* ǷΪʱģ VMS֧ 1: 0: */
    UINT32                  udwTemplateType;                         /* ʱģ VMS֧ 0:¼ʱģ 1:ʱģ 2:ûʱģ */
    BYTE                    byRes[128];                              /* ֽ */
}NETDEV_SYSTEM_TIME_TEMPLATE_S,*LPNETDEV_SYSTEM_TIME_TEMPLATE_S;

/**
* @struct tagNETDEVSinglePersonUpdateInfo
* @brief ָԱĸϢ
* @attention  None
*/
typedef struct tagNETDEVSinglePersonUpdateInfo
{
    BOOL   bPersonExisted;      /* ԱǷ */
    UINT32 udwLastChange;       /* ޸ʱ */
    BYTE   byRes[128];          /* ֽ */
}NETDEV_SINGLE_PERSON_UPDATE_INFO_S,*LPNETDEV_SINGLE_PERSON_UPDATE_INFO_S;

/**
* @struct tagNETDEVPagedQueryInfo
* @brief ѯ
* @attention  None
*/
typedef struct tagNETDEVPagedQueryInfo
{
    UINT32 udwLimit;        /* ÿβѯ */
    UINT32 udwOffset;       /* ӵǰſʼѯ */
    BYTE   byRes[128];      /* ֽ */
}NETDEV_PAGED_QUERY_INFO_S,*LPNETDEV_PAGED_QUERY_INFO_S;

/**
* @struct tagNETDEVPersonUpdateInfo
* @brief ԱϢ
* @attention  None
*/
typedef struct tagNETDEVPersonUpdateInfo
{
    UINT32 udwPersonID;         /* ԱID */
    UINT32 udwLastChange;       /* Աѯб */
    BYTE   byRes[128];          /* ֽ */
}NETDEV_PERSON_UPDATE_INFO_S,*LPNETDEV_PERSON_UPDATE_INFO_S;

/**
* @struct tagNETDEVPersonUpdateInfoList
* @brief Աѯб
* @attention  None
*/
typedef struct tagNETDEVPersonUpdateInfoList
{
    UINT32 udwTotal;                                                /* Ա */
    UINT32 udwOffset;                                               /* Աѯʼ */
    UINT32 udwNum;                                                  /* Աѯ 1000 */
    NETDEV_PERSON_UPDATE_INFO_S stPersonList[NETDEV_LEN_1024];      /* Աѯб */
    BYTE   byRes[128];                                              /* ֽ */
}NETDEV_PERSON_UPDATE_INFO_LIST_S,*LPNETDEV_PERSON_UPDATE_INFO_LIST_S;

/**
* @struct tagNETDEVPersonInfoList
* @brief ԱϢб
* @attention  None
*/
typedef struct tagNETDEVPersonInfoList
{
    UINT32 udwNum;                                          /* ԱԱ */
    LPNETDEV_PERSON_INFO_S              pstPersonInfo;      /* ԱϢб,趯̬ڴ */
    BYTE   byRes[128];                                      /* ֽ */
}NETDEV_PERSON_INFO_LIST_S,*LPNETDEV_PERSON_INFO_LIST_S;

/**
* @struct tagNETDEVFaceInfo
* @brief Ϣ
* @attention  None
*/
typedef struct tagNETDEVFaceInfo
{
    UINT32 udwFaceID;           /* ԱID */
    UINT32 udwResultCode;       /* ״̬룬#NETDEV_PERSON_RESULT_CODE_E */
    BYTE   byRes[128];          /* ֽ */
}NETDEV_FACE_INFO_S,*LPNETDEV_FACE_INFO_S;

/**
* @struct tagNETDEVPersonList
* @brief ԱϢб
* @attention  None
*/
typedef struct tagNETDEVPersonList
{
    UINT32 udwPersonID;                                 /* ԱID */
    UINT32 udwFaceNum;                                  /*  6 */
    NETDEV_FACE_INFO_S stFaceInfo[NETDEV_LEN_8];        /* Ϣб */
    UINT32 udwReqseq;                                   /* ,VMS֧ */
    BYTE   byRes[128];                                  /* ֽ */
}NETDEV_PERSON_LIST_S,*LPNETDEV_PERSON_LIST_S;

/**
* @struct tagNETDEVPersonResultList
* @brief ԱϢб
* @attention  None
*/
typedef struct tagNETDEVPersonResultList
{
    UINT32 udwNum;                                          /* Ա */
    LPNETDEV_PERSON_LIST_S pstPersonList;                   /* ԱϢִнб,趯̬ڴ malloc by caller */
    BYTE   byRes[128];                                      /* ֽ */
}NETDEV_PERSON_RESULT_LIST_S,*LPNETDEV_PERSON_RESULT_LIST_S;

/**
* @struct tagNETDEVLibInfo
* @brief Ϣ
* @attention Աͳ
*/
typedef struct tagNETDEVLibInfo
{
    UINT32 udwID;                           /* ID */
    CHAR   szName[NETDEV_LEN_256];          /*  Χ[1,63] */
    UINT32 udwType;                         /* Ա μöNETDEV_PEOPLE_LIB_TYPE_E*/
    UINT32 udwPersonNum;                    /* ԱϢ */
    UINT32 udwFaceNum;                      /* Ƭ */
    UINT32 udwMemberNum;                    /* гԱ */
    UINT32 udwLastChange;                   /* Ϣ޸ʱ */
    CHAR   szBelongIndex[NETDEV_LEN_256];   /* Ψһ */
    BOOL   bIsMonitored;                    /* ǷѲأȡϢʱش */
    BYTE   byRes[128];                      /* ֽ */
}NETDEV_LIB_INFO_S,*LPNETDEV_LIB_INFO_S;

/**
* @struct tagNETDEVPersonLibList
* @brief ԱϢ
* @attention  None
*/
typedef struct tagNETDEVPersonLibList
{
    UINT32              udwNum;                     /* 豸ѴĿ */
    LPNETDEV_LIB_INFO_S pstLibInfo;                 /* бϢ,趯̬ڴ */
    BYTE                byRes[128];                 /* ֽ */
}NETDEV_PERSON_LIB_LIST_S,*LPNETDEV_PERSON_LIB_LIST_S;


/**
 * @struct tagstNETDEVSmartInfo
 * @brief ¼Ϣ
 * @attention
 */
typedef struct tagstNETDEVSmartInfo
{
    INT32      dwChannelID;         /* ͨID */
    UINT32     udwSubscribeID;      /* ID */
    UINT32     udwSubscribeType;      /*  */
    UINT32     udwCurrrntTime;      /* ǰʱ䣬UTCʽλ */
    UINT32     udwEndTime;          /* ʱ䣬UTCʽλ */
    BYTE       byRes[124];          /* ֶ  Reserved */
}NETDEV_SMART_INFO_S, *LPNETDEV_SMART_INFO_S;

/**
 * @struct tagstNETDEVSubscribeSmartInfo
 * @brief ¼Ϣ
 * @attention
 */
typedef struct tagstNETDEVSubscribeSmartInfo
{
    UINT32   udwNum;                /* ܸ澯 */
    UINT32   *pudwSmartType;        /* ĵܸ澯 μö NETDEV_SMART_ALARM_TYPE_E udwNum̬ */
    BYTE     byRes[128];            /* ֶ  Reserved */
}NETDEV_SUBSCRIBE_SMART_INFO_S, *LPNETDEV_SUBSCRIBE_SMART_INFO_S;


/**
 * @struct tagstNETDEVAlarmLogCond
 * @brief 澯־ѯ
 * @attention  ѯ澯͡ʱЯĸ澯ͻܳ16
 */
typedef struct tagstNETDEVQueryInfo
{
    INT32   dwQueryType;                                /* ѯͣμ# NETDEV_QUERYCOND_TYPE_E */
    INT32   dwLogicFlag;                                /* ѯ߼ͣμ#NETDEV_QUERYCOND_LOGICTYPE_E */
    CHAR    szConditionData[NETDEV_CODE_STR_MAX_LEN];   /* ѯֵ */
}NETDEV_QUERY_INFO_S, *LPNETDEV_QUERY_INFO_S;

/**
 * @struct tagstNETDEVAlarmLogCondList
 * @brief 澯־вѯ
 * @attention
 */
typedef struct tagstNETDEVAlarmLogCondList
{
    INT32   dwPageRow;                                                      /* ÿҳ */
    INT32   dwFirstRow;                                                     /* ҳѯеһݵ */
    INT32   dwCondSize;                                                     /* ѯ */
    NETDEV_QUERY_INFO_S astCondition[NETDEV_LOG_QUERY_COND_NUM];            /* ѯֵ */
}NETDEV_ALARM_LOG_COND_LIST_S, *LPNETDEV_ALARM_LOG_COND_LIST_S;

/**
 * @struct tagstNETDEVAlarmLogInfo
 * @brief 澯־Ϣ
 * @attention
 */
typedef struct tagstNETDEVAlarmLogInfo
{
    INT32 dwAlarmID;                                            /* 澯ID */
    INT32 dwAlarmType;                                          /* 澯 μ# NETDEV_ALARM_TYPE_E*/
    INT32 dwAlarmSubType;                                       /* 澯,μ#NETDEV_ALARM_SUBTYPE_E */
    INT32 dwAlarmLevel;                                         /* 澯 */
    INT32 dwServerID;                                           /*  */
    INT32 dwDevID;                                              /* 豸ID */
    INT32 dwChannelID;                                          /* ͨID */
    CHAR szAlarmSrc[NETDEV_NAME_MAX_LEN];                       /* 澯ԴϢ */
    INT64 tAlarmTime;                                           /* 澯ʱ */
    BOOL bAlarmChecked;                                         /* 澯Ƿȷ */
    CHAR szAlarmCheckUser[NETDEV_USERNAME_LEN];                 /* 澯ȷû */
    INT64 tAlarmCheckTime;                                      /* 澯ȷʱ */
    CHAR szAlarmCheckDesc[NETDEV_DESCRIBE_MAX_LEN];             /* 澯ȷ */
    INT32 dwAlarmLinkType;                                      /* 澯 */
    BOOL IsAlarmSnapExisted;                                    /* 澯Ƿץͼ 0ûץͼ 1ץͼ*/
    INT32 dwAlarmSrcBelong;                                     /* 澯μ#NETDEV_ALARM_SRC_BELONG_TYPE_E */
    BYTE byRes[248];                                            /* ֶ */
}NETDEV_ALARM_LOG_INFO_S, *LPNETDEV_ALARM_LOG_INFO_S;

/**
 * @struct tagstNETDEVAlarmLogChecked
 * @brief 澯־ȷϢ
 * @attention
 */
typedef struct tagstNETDEVAlarmLogChecked
{
    INT32  dwSize;                                               /* 澯Դ */
    INT32* pdwAlarmID;                                           /* 澯IDsize̬ڴ  */
    CHAR   szAlarmDesc[NETDEV_DESCRIBE_MAX_LEN];                 /* 澯 */

    BYTE     byRes[128];                                        /* ֶ  Reserved */
}NETDEV_ALARMLOG_CHECKED_S, *LPNETDEV_ALARMLOG_CHECKED_S;

/**
 * @struct tagstNETDEVAlarmLogCheckedList
 * @brief 澯־ȷϢб
 * @attention
 */
typedef struct tagstNETDEVAlarmLogCheckedList
{
    INT32    dwSize;                                             /* 澯־ȷ */
    LPNETDEV_ALARMLOG_CHECKED_S pstAlarmLogChecked;              /* 澯־ȷϢsize̬ڴ */

    BYTE     byRes[128];                                         /* ֶ  Reserved */
}NETDEV_ALARMLOG_CHECKED_LIST_S, *LPNETDEV_ALARMLOG_CHECKED_LIST_S;

/**
 * @struct tagNETDEVDatabaseInfo
 * @brief Ϣͳ ṹ嶨 face and Vehicle database information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVDatabaseInfo
{
    UINT32   udwFaceDBID;                               /*  */
    UINT32   udwFaceDBType;                             /*  μö#NETDEV_FACE_DB_TYPE_E */
    CHAR     szFaceDBName[NETDEV_FACE_DB_NAME_LEN];     /*  */
    BOOL     bMonitored;                                /* ǷѲ*/
    UINT32   udwMemberNum;                              /* Ա*/
    BYTE     byRes[128];                                /* ֶ  Reserved */

}NETDEV_DATABASE_INFO_S,*LPNETDEV_DATABASE_INFO_S;

/**
 * @struct tagstNETDEVAlarmPlanInfo
 * @brief 澯ԤϢ
 * @attention
 */
typedef struct tagstNETDEVAlarmPlanInfo
{
    INT32   dwPlanType;                                         /* 澯Ԥͣμ#NETDEV_ALARM_PLAN_TYPE_E */
    INT32   dwPlanID;                                           /* ԤID */
    CHAR    szPlanName[NETDEV_NAME_MAX_LEN];                    /* Ԥ */
    INT32   dwTimeTamplateID;                                   /* ʱģID */
    CHAR    szTimeTamplateName[NETDEV_NAME_MAX_LEN];            /* ʱģ */
    CHAR    szDesc[NETDEV_DESCRIBE_MAX_LEN];                    /* Ԥ */
    BOOL    bEnable;                                            /* ǷԤ */
}NETDEV_ALARM_PLANINFO_S, *LPNETDEV_ALARM_PLANINFO_S;

/**
 * @struct tagNETDEVCustomAttrInfo
 * @brief Զ ṹ嶨 Device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVCustomAttrInfo
{
    UINT32   udwID;                                         /* Զ */
    BOOL     bEnabled;                                      /* Զʹ 0ʹܡ1ʹ*/
    CHAR     szName[NETDEV_FACE_DB_TITLE_NAME_LEN];    /* Զ*/

    BYTE     byRes[128];                                    /* ֶ  Reserved */

}NETDEV_CUSTOM_ATTR_INFO_S,*LPNETDEV_CUSTOM_ATTR_INFO_S;


/**
 * @struct tagNETDEVMemberInfo
 * @brief /ԱϢб ṹ嶨
 * @attention  None
 */
typedef struct tagNETDEVMemberInfo
{
    UINT32 udwMemberID;                                             /* /ԱID */
    CHAR szMemberName[NETDEV_LEN_260];                              /* /ԱƣΧ[1,63] */
    BYTE     byRes[128];                                            /* ֶ  Reserved */
}NETDEV_MEMBER_INFO_S,*LPNETDEV_MEMBER_INFO_S;

/**
 * @struct tagNETDEVMonitorRuleInfo
 * @brief Ϣ ṹ嶨 
 * @attention  None
 */
typedef struct tagNETDEVMonitorRuleInfo
{
    BOOL                    bEnabled;                                              /* ʹ */
    CHAR                    szName[NETDEV_FACE_MONITOR_RULE_NAME_LEN];             /* Ĳ */
    CHAR                    szReason[NETDEV_FACE_MONITOR_RULE_REASON_LEN];         /* صĲԭ */
    UINT32                  udwLibNum;                                             /* ӦĿ,16 */
    UINT32                  audwLibList[NETDEV_LEN_32];                            /* IDб */
    UINT32                  udwMonitorType;                                        /* ظ澯ͣ0ƥ澯,1ƥ澯 */
    UINT32                  udwMultipleValue;                                      /* 1NȽŶȷֵ */
    UINT32                  udwMonitorReason;                                      /*  ԭ0 1 2ɳ 3ͨΥ 4س*/
    CHAR                    szMatchSucceedMsg[NETDEV_LEN_512];                     /* ȶԳɹʾ */
    CHAR                    szMatchFailedMsg[NETDEV_LEN_512];                      /* ȶʧʾ */
    UINT32                  udwMemberNum;                                          /* Ա [0-32] */
    NETDEV_MEMBER_INFO_S    stMemberInfo[NETDEV_LEN_64];                           /* ԱϢб */
    UINT32                  udwChannelNum;                                         /* Ĳͨ ȡʱش */
    UINT32                  *pudwMonitorChlIDList;                                 /* Ĳͨб udwChannelNum̬ȷ ϲڴ */
    UINT32                  udwDevNum;                                             /* Ĳ豸 ĸ,VMS֧ */
    UINT32                  audwMonitorDevIDList[NETDEV_LEN_16];                   /* Ĳ豸б DevNum̬ȷ,VMS֧*/
    UINT32                  udwMonitorRuleType;                                    /* ͣ0ܲ,1ǰܲ */
    
	BYTE                    byRes[240];                                            /* ֶ  Reserved */
}NETDEV_MONITION_RULE_INFO_S,*LPNETDEV_MONITION_RULE_INFO_S;

/**
 * @struct tagNETDEVMonitorChlInfo
 * @brief ӲطصĲϢ
 * @attention  None
 */
typedef struct tagNETDEVMonitorChlInfo
{
    UINT32                          udwChannelID;                       /* ضӦͨID IPCVMSֶβ */ 
    UINT32                          udwResultCode;                      /*  NETDEV_PERSON_RESULT_CODE_E */
    UINT32                          udwMonitorID;                       /* ӦͨӦĲID */ 
}NETDEV_MONITION_CHL_INFO_S,*LPNETDEV_MONITION_CHL_INFO_S;

/**
 * @struct tagNETDEVMonitorResultInfo
 * @brief ӲطصĲϢ Device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVMonitorResultInfo
{
    UINT32                              udwChannelNum;                  /* ӳɹʵͨ 踳ֵڴС*/
    LPNETDEV_MONITION_CHL_INFO_S        pstMonitorChlInfos;             /* طϢб ڴϲ ӦС·ͨ malloc by caller*/
    BYTE                                byRes[250];                     /* ֶ  Reserved */
}NETDEV_MONITOR_RESULT_INFO_S,*LPNETDEV_MONITOR_RESULT_INFO_S;

/**
 * @struct tagNETDEVVideoLossRuleInfo
 * @briefƵʧ澯Ϣ
 * @attention 
 */
typedef struct tagNETDEVVideoLossRuleInfo
{
    BOOL         bEnabled;            /* ʹ, 0:ʹ 1:ʹ*/
    BYTE         byRes[256];          /* ֶ */
}NETDEV_VIDEO_LOSS_RULE_INFO_S, *LPNETDEV_VIDEO_LOSS_RULE_INFO_S;

/**
 * @struct tagNETDEVTamperDetectionRuleInfo
 * @briefڵ澯Ϣ
 * @attention 
 */
typedef struct tagNETDEVTamperDetectionRuleInfo
{
    BOOL         bEnabled;              /* ʹ, 0:ʹ 1:ʹ*/
    UINT32       udwSensitivity;        /* ȣΧ[1,100] */
    UINT32       udwDuration;           /* ʱ䣬λ롣ȷΧ[0, 10]IPCҪ */
    BYTE         byRes[256];            /* ֶ */
}NETDEV_TAMPER_DETECTION_RULE_INFO_S, *LPNETDEV_TAMPER_DETECTION_RULE_INFO_S;

/**
 * @struct tagNETDEVOutputSwitchActParamInfo
 * @brief 
 * @attention
 */
typedef struct tagNETDEVOutputSwitchActParamInfo
{
    UINT32 udwNum;                                                                                 /* Ŀ*/
    NETDEV_OUTPUT_SWITCH_ALARM_STATUS_S astOutputAlarmStatusInfo[NETDEV_MAX_ALARM_OUT_NUM];        /* Ŀб*/
}NETDEV_OUTPUT_SWITCH_ACT_PARAM_INFO_S,*LPNETDEV_OUTPUT_SWITCH_ACT_PARAM_INFO_S;

/**
 * @struct tagNETDEVChannelActParamInfo
 * @brief ͨ
 * @attention
 */
typedef struct tagNETDEVChannelActParamInfo
{
    UINT32 udwNum;                                 /* ͨ*/
    INT32 adwChannelID[NETDEV_CHANNEL_MAX];        /* ͨIDб*/
}NETDEV_CHANNEL_ACT_PARAM_INFO_S,*LPNETDEV_CHANNEL_ACT_PARAM_INFO_S;

/**
 * @struct tagNETDEVChannelPreset
 * @brief ̨Ԥλ
 * @attention
 */
typedef struct tagNETDEVChannelPreset
{
    INT32 dwChannelID;                              /* ͨ*/
    INT32 dwPresetID;                               /* Ԥλ*/
    BYTE  byRes[128];                               /* ֶ */
}NETDEV_CHANNEL_PRESET_S,*LPNETDEV_CHANNEL_PRESET_S;

/**
 * @struct tagNETDEVPresetActParamInfo
 * @brief ̨Ԥλ
 * @attention
 */
typedef struct tagNETDEVPresetActParamInfo
{
    UINT32 udwNum;                                                      /* */
    NETDEV_CHANNEL_PRESET_S stChannelPreset[NETDEV_CHANNEL_MAX];        /* ԤλϢб*/
}NETDEV_PRESET_ACT_PARAM_INFO_S,*LPNETDEV_PRESET_ACT_PARAM_INFO_S;

/**
 * @struct tagNETDEVEnabledActParamInfo
 * @brief ʹ
 * @attention
 */
typedef struct tagNETDEVEnabledActParamInfo
{
    BOOL    bEnabled;       /* ʹܱ */
    BYTE    byRes[64];      /* ֶ */
}NETDEV_ENABLED_ACT_PARAM_INFO_S, *LPNETDEV_ENABLED_ACT_PARAM_INFO_S;

/**
 * @enum tagNETDEVAlarmActID
 * @brief ʹ
 * @attention
 */
typedef enum tagNETDEVAlarmActID
{
    ALARM_ACTION_TYPE_NVR_PREVIEW                = 0,                    /* NVRԤActParamNETDEV_CHANNEL_ACT_PARAM_INFO_S */
    ALARM_ACTION_TYPE_BUZZER                     = 1,                    /* IPCݲ֧,NVR ActParamNETDEV_ENABLED_ACT_PARAM_INFO_S */
    ALARM_ACTION_TYPE_E_MAIL                     = 2,                    /* E-MailIPCݲ֧֣NVR ActParamNETDEV_ENABLED_ACT_PARAM_INFO_S */
    ALARM_ACTION_TYPE_RECORD                     = 3,                    /* 洢IPCݲ֧֣NVR ActParamNETDEV_CHANNEL_ACT_PARAM_INFO_S */
    ALARM_ACTION_TYPE_PRESET                     = 4,                    /* ̨ԤλActParamNETDEV_PRESET_ACT_PARAM_INFO_S */
    ALARM_ACTION_TYPE_OUTPUT_SWITCH              = 5,                    /* ActParamNETDEV_OUTPUT_SWITCH_ACT_PARAM_INFO_S */
    ALARM_ACTION_TYPE_SNAP                       = 6,                    /* ץģIPCдActParam NVR ActParamNETDEV_CHANNEL_ACT_PARAM_INFO_S*/
    ALARM_ACTION_TYPE_BOX                        = 7,                    /* 澯IPCݲ֧֣NVR ActParamNETDEV_ENABLED_ACT_PARAM_INFO_S */
    ALARM_ACTION_TYPE_CENTER_RECORD              = 8,                    /* Ĵ洢IPCдActParamNVR֧ */
    ALARM_ACTION_TYPE_START_LOCAL_RECORD         = 9,                    /* ش洢IPCдActParamNVR֧ */
    ALARM_ACTION_TYPE_STOP_LOCAL_RECORD          = 10,                   /* ֹͣش洢IPCдActParamNVR֧ */
    ALARM_ACTION_TYPE_SNAP_UP_FTP                = 11,                   /* ץϴFTPIPCдActParamNVR֧ */
    ALARM_ACTION_TYPE_SNAP_UP_EMAIL              = 12,                   /* ץϴEMailIPCдActParamNVR֧ */
    ALARM_ACTION_TYPE_SNAP_UP_FTP_AND_EMAIL      = 13,                   /* ץϴFTPEMailIPCдActParamNVR֧ */
    ALARM_ACTION_TYPE_SMART_SNAP_UP              = 14,                   /* ץϴIPCдActParamNVR֧ */
    ALARM_ACTION_TYPE_FACE_PIC_SNAP_UP           = 15,                   /* СͼץϴIPCдActParamNVR֧ */
    ALARM_ACTION_TYPE_ALARM_REPORT               = 16,                   /* 澯ϱIPCдActParamNVR֧ */
    ALARM_ACTION_TYPE_PTZ_ZOOM                   = 17,                   /* ̨䱶 */
    ALARM_ACTION_TYPE_INVALID                    = 0xff                  /* Ч */
}NETDEV_ALARM_ACT_ID_E;


/**
 * @struct tagNETDEVLinkageActionList
 * @brief б
 * @attention
 */
typedef struct tagNETDEVLinkageActionInfo 
{
    UINT32  udwActID;                                                   /* IDμöֵNETDEV_ALARM_ACT_ID_E */
    NETDEV_ENABLED_ACT_PARAM_INFO_S  stEnabledInfo;                     /* ʹܱǣEMail澯 */
    NETDEV_OUTPUT_SWITCH_ACT_PARAM_INFO_S stOutputSwitchActParamInfo;   /* */
    NETDEV_CHANNEL_ACT_PARAM_INFO_S stChannelActParamInfo;              /* NVRԤ洢ץ */
    NETDEV_PRESET_ACT_PARAM_INFO_S  stPresetActParamInfo;               /* ̨Ԥλ */
    BYTE  byRes[512];                                                   /* ֶ */
}NETDEV_LINKAGE_ACTION_INFO_S,*LPNETDEV_LINKAGE_ACTION_INFO_S;

/**
 * @struct tagNETDEVLinkageActionList
 * @brief б ṹ嶨
 * @attention  None
 */
typedef struct tagNETDEVLinkageActionList
{
    UINT32          udwNum;
    NETDEV_LINKAGE_ACTION_INFO_S stActionInfo[NETDEV_MAX_LINK_ACTION_NUM];
    BYTE            byRes[256];
}NETDEV_LINKAGE_ACTION_LIST_S,*LPNETDEV_LINKAGE_ACTION_LIST_S;

/**
 * @struct tagNETDEVSwitchLinkageAction
 * @brief  ṹ嶨
 * @attention  None
 */
typedef struct tagNETDEVSwitchLinkageAction
{
    UINT32                          udwSwitchIndex; /*  */
    NETDEV_LINKAGE_ACTION_LIST_S    stLinkageActionList;
    BYTE                            byRes[256];
}NETDEV_SWITCH_LINKAGE_ACTION_S,*LPNETDEV_SWITCH_LINKAGE_ACTION_S;

/**
 * @enum tagLinkageStrategy
 * @brief 澯Ϣ ṹ嶨
 * @attention  None
 */
typedef enum tagPersonCompareResult
{
    NETDEV_TYPE_COMPARE_SUCCESS = 1,
    NETDEV_TYPE_COMPARE_FAILED = 2,
    NETDEV_TYPE_COMPARE_INVALID = 0xff
}NETDEV_PERSON_COMPARE_RESULT_TYPE_E;

/**
 * @struct tagLinkageStrategy
 * @brief 澯Ϣ ṹ嶨
 * @attention  None
 */
typedef struct tagLinkageStrategy
{
    UINT32                          udwType;                /* 澯,NETDEV_PERSON_COMPARE_RESULT_TYPE_E */
    NETDEV_LINKAGE_ACTION_LIST_S    stLintageActions;       /*  */
    BYTE                            byRes[512];             /* ֶ */
}NETDEV_LINKAGE_STRATEGY_S, *LPNETDEV_LINKAGE_STRATEGY_S;

/**
 * @struct tagNETDEVMonitorDefenceInfo
 * @brief Ϣ ṹ嶨
 * @attention PTS VMSʹ
 */
typedef struct tagNETDEVMonitorDefenceInfo
{
    INT64      tBegin;                  /* ʱģЧʼʱ(unixʱ) */
    INT64      tEnd;                    /* ʱģЧʱ(unixʱ) */
    UINT32     udwTimeTemplateID;       /* ʱģδãд0 */
    BYTE       byRes[128];              /* ֶ */
}NETDEV_MONITOR_DEFENCE_INFO_S, *LPNETDEV_MONITOR_DEFENCE_INFO_S;

/**
 * @struct tagNETDEVFaceMonitorInfo
 * @brief Ϣ ṹ嶨 Device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVMonitorInfo
{
    UINT32                              udwID;                        /*  Ӳزٷظֶ */
    NETDEV_MONITION_RULE_INFO_S         stMonitorRuleInfo;            /* Ϣ */
    UINT32                              udwLinkStrategyNum;           /* 澯 */
    LPNETDEV_LINKAGE_STRATEGY_S         pstLinkStrategyList;          /* 澯Ϣ趯̬ڴ*/
    NETDEV_VIDEO_WEEK_PLAN_S            stWeekPlan;                   /* 񲼷ƻ,NVR IPCʹ */
    NETDEV_MONITOR_DEFENCE_INFO_S       stMonitorDefenceInfo;         /* ϢPTS VMSʹ */
    BYTE                                byRes[250];                   /* ֶ  Reserved */
}NETDEV_MONITION_INFO_S,*LPNETDEV_MONITION_INFO_S;

/**
 * @struct tagNETDEVFaceMonitorList
 * @brief б ṹ嶨 Device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVFaceMonitorList
{
    UINT32 udwNum;                                                    /*  */
    LPNETDEV_MONITION_INFO_S pstMonitorList;                     /* б ָָڴ߷*/
}NETDEV_FACE_MONITOR_LIST_S,*LPNETDEV_FACE_MONITOR_LIST_S;

/**
 * @struct tagstNETDEVFaceAlarmImageArea
 * @brief 
 * @attention
 */
typedef struct tagstNETDEVFaceAlarmImageArea
{
    UINT32   udwLeft;          /*  */
    UINT32   udwTop;           /*  */
    UINT32   udwRight;         /*  */
    UINT32   udwButtom;        /*  */

    BYTE     byRes[128];       /* ֶ  Reserved */
}NETDEV_FACE_ALARM_IMAGE_AREA_S, *LPNETDEV_FACE_ALARM_IMAGE_AREA_S;

/**
 * @struct tagstNETDEVFaceAlarmLogSnapImage
 * @brief ץͼƬϢ
 * @attention
 */
typedef struct tagstNETDEVFaceAlarmSnapImage
{
    NETDEV_FILE_INFO_S   stBigImage;                /* ͼ */
    NETDEV_FILE_INFO_S   stSmallImage;              /* Сͼ */
    NETDEV_FACE_ALARM_IMAGE_AREA_S   stArea;        /*  */
    BYTE    byRes[128];                             /* ֶ  Reserved */
}NETDEV_FACE_ALARM_SNAP_IMAGE_S, *LPNETDEV_FACE_ALARM_SNAP_IMAGE_S;


/**
* @struct tagNETDEVVehicleMonitorRuleInfo
* @brief Ϣ ṹ嶨
* @attention  None
*/
typedef struct tagNETDEVVehicleMonitorRuleInfo
{
    CHAR                        szName[NETDEV_LEN_260];                              /* Ĳ */
    BOOL                        bEnabled;                                            /* ʹ */
    INT64                       tBegin;                                              /* ʼʱ */
    INT64                       tEnd;                                                /* ʱ */
    UINT32                      udwMonitorReason;                                    /*  μö NETDEV_VEHICLE_MONITOR_TYPE_E */
    CHAR                        szDescription[NETDEV_FACE_MONITOR_RULE_REASON_LEN];  /* Ĳ */
    UINT32                      udwMonitorAlarmType;                                 /* ظ澯 ֻǸ澯¼ҪЯ 0ƥ澯 1ƥ澯*/
    UINT32                      udwDatabaseID;                                       /* ID */
    UINT32                      udwMemberNum;                                        /* Ա[0~32] */
    NETDEV_MEMBER_INFO_S        stMemberInfo[NETDEV_LEN_64];                         /* ԱϢ */
    BYTE                        byRes[128];                                          /* ֶ  Reserved */
}NETDEV_VEHICLE_MONITION_RULE_INFO_S, *LPNETDEV_VEHICLE_MONITION_RULE_INFO_S;

/**
* @struct tagNETDEVVehicleMonitorInfo
* @brief Ϣ ṹ嶨 Vehicle monitoring task information Structure definition
* @attention  None
*/
typedef struct tagNETDEVVehicleMonitorInfo
{
    UINT32   udwMonitorID;                                            /*  */
    NETDEV_VEHICLE_MONITION_RULE_INFO_S stMonitorRuleInfo;            /* Ϣ */

    BYTE    byRes[128];                                               /* ֶ  Reserved */

}NETDEV_VEHICLE_MONITION_INFO_S, *LPNETDEV_VEHICLE_MONITION_INFO_S;

/**
* @struct tagstNETDEVPlateAttrInfo
* @brief Ϣ
* @attention
*/
typedef struct tagstNETDEVPlateAttrInfo
{
    CHAR     szPlateNo[NETDEV_LEN_16];                        /* ƺ */
    UINT32   udwColor;                                        /* ɫ μNETDEV_PLATE_COLOR_E */
    UINT32   udwType;                                         /* ͣμNETDEV_PLATE_TYPE_E */
    BYTE     byRes[64];                                       /* ֶ  Reserved */
}NETDEV_PLATE_ATTR_INFO_S, *LPNETDEV_PLATE_ATTR_INFO_S;

/**
* @struct tagstNETDEVVehicleAttrInfo
* @brief Ϣ
* @attention
*/
typedef struct tagstNETDEVVehicleAttrInfo
{
    UINT32   udwColor;          /* ɫ μNETDEV_VEHICLE_COLOR_E */
    UINT32   udwType;           /* ͣμNETDEV_VEHICLE_TYPE_E */
    FLOAT    udwSpeedValue;     /* ٶ double */
    UINT32   udwSpeedUnit;      /* ٶȵλ μö NETDEV_VEHICLE_SPEED_UNIT_E */

    BYTE     byRes[64];         /* ֶ  Reserved */
}NETDEV_VEHICLE_ATTR_INFO_S, *LPNETDEV_VEHICLE_ATTR_INFO_S;

/**
 * @struct tagNETDEVVehAttr
 * @brief Ϣ
 * @attention  None
 */
typedef struct tagNETDEVVehAttr
{
    UINT32 udwType;                                       /*   NETDEV_VEHICLE_TYPE_E */
    UINT32 udwColor;                                      /* ɫ  NETDEV_PLATE_COLOR_E */
    UINT32 udwSpeedUnit;                                  /* ٶȵλ 0/ÿСʱ 1Ӣ/ÿСʱ */
    FLOAT  fSpeedValue;                                   /* ٶ */
    UINT32 udwSpeedType;                                  /* ṹеĻٶ  NETDEV_SPEED_TYPE_E */
    CHAR   szVehicleBrand[NETDEV_LEN_64];                 /* 루б) */
    UINT32 udwImageDirection;                             /* ṹеĻڻϵеʻ  NETDEV_IMAGE_DIRECTION_E */
    BYTE   byRes[128];                                    /* ֶ */
}NETDEV_VEH_ATTR_S,*LPNETDEV_VEH_ATTR_S;

/**
 * @struct tagNETDEVVehicleMemberAttr
 * @brief Ϣ(ԤᵼNETDEV_VEHICLE_DETAIL_INFO_SԤ)
 * @attention  None
 */
typedef struct tagNETDEVVehicleMemberAttr
{
    UINT32 udwColor;                                      /* ɫ öNETDEV_PLATE_COLOR_E*/
    NETDEV_FILE_INFO_S stVehicleImage;                    /* ͼƬ ͼƬܺС4M */
}NETDEV_VEHICLE_MEMBER_ATTR_S,*LPNETDEV_VEHICLE_MEMBER_ATTR_S;

/**
* @struct tagstNETDEVVehicleDetailInfo
* @brief ԱϢ
* @attention
*/
typedef struct tagstNETDEVVehicleDetailInfo
{
    UINT32                       udwReqSeq;                         /* к */
    UINT32                       udwMemberID;                       /* ԱID */
    NETDEV_PLATE_ATTR_INFO_S     stPlateAttr;                       /* Ϣ */
    NETDEV_VEHICLE_MEMBER_ATTR_S stVehicleAttr;                     /* Ϣ */
    BOOL                         bIsMonitored;                      /* ǷѲ 0δ 1Ѳ */
    UINT32                       udwDBNum;                          /*  */
    UINT32                       audwDBIDList[NETDEV_LEN_16];       /* ID */
    BYTE                         byRes[124];                        /* ֶ  Reserved */
}NETDEV_VEHICLE_DETAIL_INFO_S, *LPNETDEV_VEHICLE_DETAIL_INFO_S;

/**
* @struct tagstNETDEVMonitorAlarmInfo
* @brief Ƹ澯Ϣ(޷ԤᵼNETDEV_VEHICLE_RECORD_INFO_SԤ)
* @attention
*/
typedef struct tagstNETDEVMonitorAlarmInfo
{
    UINT32 udwMonitorReason;                          /* ԭ */
    UINT32 udwMonitorAlarmType;                       /* ظ澯 0ƥ澯 1ƥ澯 */
    UINT32 udwMemberID;                               /* ԱID */
}NETDEV_MONITOR_ALARM_INFO_S,*LPNETDEV_MONITOR_ALARM_INFO_S;

/**
* @struct tagstNETDEVVehicleRcordInfo
* @brief ʶ¼Ϣ
* @attention
*/
typedef struct tagstNETDEVVehicleRcordInfo
{
    UINT32   udwRecordID;                                       /* ʶ¼ID */
    UINT32   udwChannelID;                                      /* ͨIDץʱЧ */
    UINT32   udwPassingTime;                                    /* ʱ䣬UTCʽλ*/
    CHAR     szChannelName[NETDEV_LEN_260];                     /*  */
    NETDEV_PLATE_ATTR_INFO_S    stPlateAttr;                    /* ץϢ */
    NETDEV_VEH_ATTR_S           stVehAttr;                      /* ץϢ */
    NETDEV_FILE_INFO_S          stPlateImage;                   /* ץͼƬ ͼƬܺС1M*/
    NETDEV_FILE_INFO_S          stVehicleImage;                 /* ץͼƬ ṹѯʱЯ ͼƬܺС1M*/
    NETDEV_FILE_INFO_S          stPanoImage;                    /* ȫͼ ṹѯʱЯ ЯͼƬURLsizeͼƬҪͨ/LAPI/V1.0/System/Pictureӿڻȡ*/
    NETDEV_MONITOR_ALARM_INFO_S stMonitorAlarmInfo;             /* Ƹ澯Ϣ */
    BYTE     byRes[132];                                        /* ֶ  Reserved */
}NETDEV_VEHICLE_RECORD_INFO_S, *LPNETDEV_VEHICLE_RECORD_INFO_S;

/**
* @struct tagstVehicleEventInfo
* @brief ȶԱϢ
* @attention
*/
typedef struct tagstVehicleEventInfo
{
    UINT32 udwID;                                              /* ֪ͨ¼ID */
    UINT32 udwTimestamp;                                       /* ֪ͨϱʱ䣬UTCʽλ */
    UINT32 udwNotificationType;                                /* ֪ͨ  NETDEV_NOTIFICATION_TYPE_E*/
    UINT32 udwVehicleInfoNum;                                  /* ϢĿ [0, 1] */
    LPNETDEV_VEHICLE_RECORD_INFO_S pstVehicleRecordInfo;       /* Ϣб */
    BYTE     byRes[256];                                       /* ֶ  Reserved */
}NETDEV_VEHICLE_EVENT_INFO_S,*LPNETDEV_VEHICLE_EVENT_INFO_S;

/**
* @struct tagstNETDEVVehRecognitionEvent
* @brief ʶ¼
* @attention
*/
typedef struct tagstNETDEVVehRecognitionEvent
{
    CHAR   szReference[NETDEV_LEN_480];                        /* Ϣ */
    UINT32 udwSrcID;                                           /* 澯ԴID */
    NETDEV_VEHICLE_EVENT_INFO_S stVehicleEventInfo;            /* ȶԱϢ 趯̬ڴ */
    BYTE     byRes[256];                                       /* ֶ  Reserved */
}NETDEV_VEH_RECOGNITION_EVENT_S, *LPNETDEV_VEH_RECOGNITION_EVENT_S;

/**
 * @struct tagNETDEVFaceMemberRegionInfo
 * @brief ԱϢ 
 * @attention  None
 */
typedef struct tagNETDEVFaceMemberRegionInfo
{
    CHAR   szNation[NETDEV_FACE_MEMBER_REGION_LEN];                       /*  */
    CHAR   szProvince[NETDEV_FACE_MEMBER_REGION_LEN];                     /* ʡ */
    CHAR   szCity[NETDEV_FACE_MEMBER_REGION_LEN];                         /*  */
    BYTE   byRes[256];                                                    /* ֶ  Reserved */

}NETDEV_FACE_MEMBER_REGION_INFO_S,*LPNETDEV_FACE_MEMBER_REGION_INFO_S;
/**
 * @struct tagNETDEVFaceMemberIDInfo
 * @brief Ա֤Ϣ 
 * @attention  None
 */
typedef struct tagNETDEVFaceMemberIDInfo
{
    UINT32   udwType;                                       /*֤ μö NETDEV_FACE_MEMBER_ID_TYPE_E */
    CHAR     szNumber[NETDEV_FACE_IDNUMBER_LEN];            /* ֤ */

    BYTE    byRes[128];                                     /* ֶ  Reserved */
}NETDEV_FACE_MEMBER_ID_INFO_S,*LPNETDEV_FACE_MEMBER_ID_INFO_S;

/**
 * @struct tagNETDEVFaceMemberInfo
 * @brief ԱϢ ṹ嶨 Device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVFaceMemberInfo
{
    UINT32   udwReqSeq;                                                   /*  */
    UINT32   udwMemberID;                                                 /*ԱID   ֻ postϢʱ*/
    CHAR     szMemberName[NETDEV_FACE_MEMBER_NAME_LEN];                   /* Ա */
    UINT32   udwMemberGender;                                             /* ԱԱ μö NETDEV_GENDER_TYPE_E */
    CHAR     szMemberBirthday[NETDEV_FACE_MEMBER_BIRTHDAY_LEN];           /* Ա */
    NETDEV_FACE_MEMBER_REGION_INFO_S   stMemberRegionInfo;                /* ԱϢ */
    NETDEV_FACE_MEMBER_ID_INFO_S       stMemberIDInfo;                    /* Ա֤Ϣ */
    NETDEV_FILE_INFO_S                 stMemberImageInfo;                 /* ͼƬϢ */
    NETDEV_FILE_INFO_S                 stMemberSemiInfo;                  /* ṹϢ */
    UINT32   udwCustomNum;                                                /* Զֵ */
    NETDEV_CUSTOM_VALUE_S   stCustomValue[NETDEV_FACE_MEMBER_CUSTOM_NUM];        /* Զֵб */    
    BOOL      bIsMonitored;                                               /* ǷѲ  0δأ1Ѳ */
    UINT32    udwDBNum;                                                   /*  */
    UINT32    audwDBIDList[NETDEV_LEN_16];                                /* IDб */
    BYTE      byRes[128];                                                 /* ֶ  Reserved */

}NETDEV_FACE_MEMBER_INFO_S,*LPNETDEV_FACE_MEMBER_INFO_S;

/**
 * @struct tagstNETDEVFaceAlarmCmpInfo
 * @brief ץĸ澯¼ȶϢ
 * @attention
 */
typedef struct tagstNETDEVFaceAlarmCmpInfo
{
    UINT32                           udwSimilarity;               /* ƶ */
    NETDEV_FACE_MEMBER_INFO_S        stMemberInfo;                /* ԱϢ */
    NETDEV_FACE_ALARM_SNAP_IMAGE_S   stSnapshotImage;             /* ץͼƬ */
    LPNETDEV_PERSON_INFO_S           pstPersonInfo;               /* ԱϢ(NVR֧) ѯƥɹ/ʧܼ¼Я mallocڴ */
    BYTE    byRes[124];                                           /* ֶ  Reserved */
}NETDEV_FACE_ALARM_CMP_INFO_S, *LPNETDEV_FACE_ALARM_CMP_INFO_S;


/**
 * @struct tagstNETDEVFaceRecordSnapshotInfo
 * @brief ʶ¼
 * @attention
 */
typedef struct tagstNETDEVFaceRecordSnapshotInfo
{
    UINT32   udwRecordID;                                       /* ʶ¼ID */
    UINT32   udwRecordType;                                     /* ʶ¼ μ# NETDEV_FACE_PASS_RECORD_TYPE_E */
    UINT32   udwPassTime;                                       /* ʱ UTCʽ */
    UINT32   udwEventType;                                      /* ¼ BITλӦBITΪ1ʾڸͣΪ0ʾڸ͡BIT0:ץBIT1:ƥ澯BIT2:ƥ澯*/
    UINT32   udwChannelID;                                      /* ͨID */
    UINT32   udwMonitorRuleID;                                  /* 澯ӦĲID */
    CHAR     szChannelName[NETDEV_LEN_260];                     /* ץͨ */
    NETDEV_FACE_ALARM_CMP_INFO_S  stCompareInfo;                /* ȶϢ */
    BYTE     byRes[124];                                        /* ֶ  Reserved */
}NETDEV_FACE_RECORD_SNAPSHOT_INFO_S, *LPNETDEV_FACE_RECORD_SNAPSHOT_INFO_S;

/**
 * @struct tagstNETDEVFaceAlarmLogResultInfo
 * @brief 澯¼Ϣʶͳʶ
 * @attention
 */
typedef struct tagstNETDEVSmartAlarmLogResultInfo
{
    UINT32   udwTotal;                     /* 澯¼ */
    UINT32   udwOffset;                    /* ¼ƫ */
    UINT32   udwNum;                       /* ˴ηظ澯¼ */
    BYTE     byRes[128];                   /* ֶ  Reserved */
}NETDEV_SMART_ALARM_LOG_RESULT_INFO_S, *LPNETDEV_SMART_ALARM_LOG_RESULT_INFO_S;

/**
* struct tagNETDEVSmartRecordCond
* @brief ܻط¼ѯ
* @attention 
*/
typedef struct tagNETDEVSmartRecordCond
{
    INT32       dwChannelID;                              /* ͨ */
    UINT32      udwPosition;                              /* ¼λ μö#NETDEV_RECORD_LOCATION_E */
    UINT32      udwGridEnable;                            /* 1ʾǺ飬0ʾ */
    BYTE        awGridAreas[NETDEV_GRID_AREAS_LEN];       /* ֵ */
    INT64       tBeginTime;                               /* ʼʱ(unixʱ) */
    INT64       tEndTime;                                 /* ʱ(unixʱ) */
    UINT32      udwSensitivity;                           /* ȣΧ1~8 */
    UINT32      udwServerID;                              /* ¼ID Video server ID */
    BYTE        byRes[128];                               /* ֶ  Reserved */      
}NETDEV_SMART_RECORD_COND_S, *LPNETDEV_SMART_RECORD_COND_S;


/**
 * @struct tagstNETDEV_VoiceBroadcastChlInfo
 * @brief 㲥ͨϢ
 * @attention
 */
typedef struct tagstNETDEV_VoiceBroadcastChlInfo
{
    UINT32  dwChannelID;               /* ƵͨID */
    UINT32  dwResultCode;              /* 㲥ͨ״̬ */
    UINT32  dwStatus;                  /* 㲥ͨ״̬ */
}NETDEV_VOICE_BROADCAST_CHL_INFO_S, *LPNETDEV_VOICE_BROADCAST_CHL_INFO_S;

/**
 * @struct tagstNETDEV_VoiceBroadcastGroupInfo
 * @brief 㲥Ϣ
 * @attention
 */
typedef struct tagstNETDEV_VoiceBroadcastGroupInfo
{
    INT32                                  dwSize;                                                        /* 㲥ͨ */
    NETDEV_VOICE_BROADCAST_CHL_INFO_S      astChlInfoList[NETDEV_VOICE_BROADCAST_CHANNEL_NUM_MAX];        /* ͨϢ */
}NETDEV_VOICE_BROADCAST_GROUP_INFO_S, *LPNETDEV_VOICE_BROADCAST_GROUP_INFO_S;

/**
 * @struct tagstNETDEV_ModifyVoiceBroadcastInfo
 * @brief ޸㲥Ϣ
 * @attention
 */
typedef struct NETDEV_ModifyVoiceBroadcastInfo
{
    LPNETDEV_OPERATE_LIST_S     pstAddChannelList;      /* ͨб */
    LPNETDEV_OPERATE_LIST_S     pstDelChannelList;      /* ɾͨб */
}NETDEV_MODIFY_VOICE_BROADCAST_INFO_S, *LPNETDEV_MODIFY_VOICE_BROADCAST_INFO_S;

/**
 * @struct tagstNETDEV_VoiceBroadcastCtrlInfo
 * @brief 㲥Ϣ
 * @attention
 */
typedef struct tagstNETDEV_VoiceBroadcastCtrlInfo
{
    INT32   dwChannelID;             /* ͨID */
    UINT32  udwStatus;               /* ״̬,(1),(0) */
}NETDEV_VOICE_BROADCAST_CTRL_INFO_S, *LPNETDEV_VOICE_BROADCAST_CTRL_INFO_S;


/**
 * @struct tagNETDEVRecordLabel
 * @brief ¼ǩϢ
 * @attention
 */
typedef struct tagNETDEVRecordLabel
{
    INT32   dwChannelID;                            /* ͨID */
    UINT32  udwTime;                                /* ǩʱ */
    CHAR    szLabelID[NETDEV_LABEL_ID_MAX_LEN];     /* ǩID */
    CHAR    szDesc[NETDEV_DESCRIBE_MAX_LEN];        /* ǩ */
    UINT32  udwServerID;                            /* ǩID */
    BYTE    byRes[256];                             /* ֶ Reserved */
}NETDEV_RECOED_LABEL_S, *LPNETDEV_RECOED_LABEL_S;

/**
 * @struct tagNETDEVLabelDelete
 * @brief ¼ǩϢ
 * @attention
 */
typedef struct tagNETDEVLabelBase
{
    INT32   dwChannelID;                            /* ͨID */
    CHAR    szLabelID[NETDEV_LABEL_ID_MAX_LEN];     /* ǩID */
    UINT32  udwResult;                              /* 豸ؽ μ NETDEV_RECODE_LABEL_RESULT_E */
    UINT32  udwServerID;                            /* ǩID */
    BYTE    byRes[256];                             /* ֶ Reserved */
}NETDEV_LABEL_BASE_S, *LPNETDEV_LABEL_BASE_S;

/**
 * @struct tagNETDEVLabelBase
 * @brief ¼ǩϢ
 * @attention
 */
typedef struct tagNETDEVLabelBaseList
{
    UINT32                  udwPosition;              /* ǩλ μ NETDEV_RECORD_LOCATION_E */
    UINT32                  udwSize;                  /* ǩ */
    LPNETDEV_LABEL_BASE_S   pstLabelBase;             /* ǩϢ */
    UINT32                  udwLabelFailNum;           /* ʧܵıǩ */
}NETDEV_LABEL_BASE_LIST_S, *LPNETDEV_LABEL_BASE_LIST_S;

 /**
 * @struct tagNETDEVLabelFindData
 * @brief ¼ǩѯϢ
 * @attention
 */
typedef struct tagNETDEVLabelFindData
{
    UINT32  udwPosition;               /* ǩλ μ NETDEV_RECORD_LOCATION_E */
    UINT32  udwChannelNum;             /* ѯͨ */
    INT32   *pdwChannelID;             /* ѯͨ ûڴ */
    INT64   tBeginTime;               /* ʼʱ  Start time */
    INT64   tEndTime;                 /* ʱ  End time */
    CHAR    szDesc[NETDEV_DESCRIBE_MAX_LEN]; /* ǩؼ */
}NETDEV_LABEL_FINDDATA_S, *LPNETDEV_LABEL_FINDDATA_S;

/**
 * @struct tagRecordSectionInfo
 * @brief ¼Ϣ
 * @attention
 */
typedef struct tagRecordSectionInfo
{
    CHAR    szLockDecs[NETDEV_RECORD_LOCK_DESC_LEN];                 /* ¼ε */
    INT64   tBeginTime;                                              /* ʼʱ  Start time */
    INT64   tEndTime;                                                /* ʱ  End time */
    UINT32  udwServerID;                                             /* ǩID */
    BYTE    byRes[256];                                              /* ֶ */
}NETDEV_RECORD_SECTION_INFO_S,* LPNETDEV_RECORD_SECTION_INFO_S;

/**
 * @struct tagstNETDEVLockIDInfo
 * @brief ID
 * @attention
 */
typedef struct tagstNETDEVLockIDInfo
{
    CHAR    szLockIDInfo[NETDEV_RECORD_LOCK_ID_LEN];                  /* ID */
    UINT32  udwServerID;                                              /* ǩID */
    BYTE    byRes[256];                                               /* ֶ */
}NETDEV_LOCK_ID_INFO_S, *LPNETDEV_LOCK_ID_INFO_S;

/**
 * @struct tagstNETDEVLockIDList
 * @brief IDб
 * @attention
 */
typedef struct tagstNETDEVLockIDList
{
    INT32                       dwSize;             /* ID */
    LPNETDEV_LOCK_ID_INFO_S     pszLockIDInfo;      /* IDб̬dwsizeڴ*/
}NETDEV_LOCK_ID_LIST_S, *LPNETDEV_LOCK_ID_LIST_S;




/**
 * @struct tagRecordLockQryInfo
 * @brief ¼ѯϢ
 * @attention
 */
typedef struct tagNETDEVRecordLockQryInfo
{
    UINT32              udwPosition;        /* ¼ѯλ */
    INT64               tBeginTime;         /* ʼʱ  Start time */
    INT64               tEndTime;           /* ʱ  End time */
    NETDEV_CHANNELS_S   stChannels;         /* ͨID */
    BYTE                byRes[256];         /* ֶ */
}NETDEV_RECORD_LOCK_FIND_COND_S,* LPNETDEV_RECORD_LOCK_FIND_COND_S;

/**
 * @struct tagRecordLockInfo
 * @brief ¼Ϣ
 * @attention
 */
typedef struct tagNETDEVRecordLockInfo
{
    NETDEV_LOCK_ID_INFO_S           stLockIDInfo;               /* ¼ID */
    INT32                           dwChannelID;                /* ͨID */
    NETDEV_RECORD_SECTION_INFO_S    stRecordSectionInfo;        /*¼Ϣ*/
    BYTE                            byRes[256];                 /* ֶ */
}NETDEV_RECORD_LOCK_INFO_S,* LPNETDEV_RECORD_LOCK_INFO_S;

/** 
 * @struct tagNETDEVAddress
 * @brief ַ ṹ嶨 
 * @attention  None
 */
typedef struct tagNETDEVAddress
{
    UINT32  udwAddressType;                     /* ַ,μö#NETDEV_ADDRESS_TYPE_E */
    CHAR    szAddress[NETDEV_IP_ADDRESS_LEN];   /* ַ */
    BYTE    byRes[256];                         /* ֶ  Reserved */
}NETDEV_ADDRESS_S,*LPNETDEV_ADDRESS_S;

/** 
 * @struct tagNETDEVHotStandbyParam
 * @brief ȱò ṹ嶨 
 * @attention  None
 */
typedef struct tagNETDEVHotStandbyParam
{
    UINT32              udwVirtualRouterID;                              /* ·ID */
    CHAR                szVirtualNETMask[NETDEV_IP_ADDRESS_LEN];         /*  */
    UINT32              udwCleanupFlag;                                  /* ־־,μö#NETDEV_ALARM_LOG_CLEANUP_FLAG_E */
    NETDEV_ADDRESS_S    stMasterAddress;                                 /* ַ */
    NETDEV_ADDRESS_S    stBackupAddress;                                 /* ַ */
    NETDEV_ADDRESS_S    stVirtualAddress;                                /* ַ */
    BYTE                byRes[256];                                      /* ֶ  Reserved */
}NETDEV_HOTSTANDBY_PARAM_S,*LPNETDEV_HOTSTANDBY_PARAM_S;

/**
 * @struct tagNETDEVMasterSlaveState
 * @brief һ״̬ ṹ嶨 VMS Master_Slave State Structure definition
 * @attention  None
 */
typedef struct tagNETDEVMasterSlaveState
{
    UINT32                      udwMode;                             /* ģʽ,μö#NETDEV_VMS_MODE_E */
    UINT32                      udwStatus;                           /* ӷ״̬,μö#NETDEV_VMS_STATUS_E */
    NETDEV_ADDRESS_S            stVMSAddress;                        /* һַ */
    UINT32                      udwHotStandbyMode;                   /* ȱģʽ,μö#NETDEV_VMS_HOTSTANDBYMODE_E */
    NETDEV_HOTSTANDBY_PARAM_S   stHotStandbyParam;                   /* ȱúͻȡĲ */
    UINT32                      udwOldHotStandbyMode;                /* ԭļеģʽ,μö#NETDEV_VMS_HOTSTANDBYMODE_E */
    BYTE                        byRes[256];                          /* ֶ */
}NETDEV_MASTER_SLAVE_STATE_S,*LPNETDEV_MASTER_SLAVE_STATE_S;




/**
 * @struct tagNETDEVVodFile
 * @brief ¼ļ ṹ嶨 Recording file Structure definition
 * @attention  None
 */
typedef struct tagNETDEVVodFile
{
    CHAR                    szFileName[NETDEV_NAME_MAX_LEN];        /* ¼ļ  Recording file name */
    NETDEV_STORE_TYPE_E     enType;                                 /* ¼洢  Recording storage type */
    INT64                   tBeginTime;                             /* ʼʱ  Start time */
    INT64                   tEndTime;                               /* ʱ  End time */
}NETDEV_VOD_FILE_S, *LPNETDEV_VOD_FILE_S;


/**
 * @struct tagNETDEVPictureDataEx
 * @brief ͼ ṹ嶨 Image data Structure definition
 *        ŽͼݵָͳȵϢ Storing pointer and length of decoded picture data
 * @attention  None
 */
typedef struct tagNETDEVPictureDataEx
{
    BYTE    *pucData[4];                /* pucData[0]:Y ƽָ,pucData[1]:U ƽָ,pucData[2]:V ƽָ  pucData[0]: Y plane pointer, pucData[1]: U plane pointer, pucData[2]: V plane pointer */
    INT32   dwLineSize[4];              /* ulLineSize[0]:Yƽÿп, ulLineSize[1]:Uƽÿп, ulLineSize[2]:Vƽÿп  ulLineSize[0]: Y line spacing, ulLineSize[1]: U line spacing, ulLineSize[2]: V line spacing */
    INT32   dwPicHeight;                /* ͼƬ߶  Picture height */
    INT32   dwPicWidth;                 /* ͼƬ  Picture width */
    INT32   dwRenderTimeType;           /* Ⱦʱ  Time data type for rendering */
    INT64   tRenderTime;                /* Ⱦʱ  Time data for rendering */
    INT32   dwFrameRate;                /* ֡ */
    BYTE    byRes[32];                  /* ֶ */
}NETDEV_PICTURE_DATA_EX_S, *LPNETDEV_PICTURE_DATA_EX_S;



/**
* @struct tagstNETDEVGpuAbleState
* @brief GPUʹ״̬ṹ
* @attention 
*/
typedef struct tagstNETDEVGpuAbleState
{
    BOOL bGpuAbleH264;            /* GPUʹ-H.264׼*/
    BOOL bGpuAbleH265;            /* GPUʹ-H.265׼ */
    BOOL bGpuAbleMJPEG;           /* GPUʹ-MJEGP׼ */
    BOOL bGpuAbleMPEG2;           /* GPUʹ-MPEG-2׼ */
    BOOL bGpuAbleMPEG4;           /* GPUʹ-MPEG-4׼ */
    BOOL bReserved1;              /* Ԥ1 */
    BOOL bReserved2;              /* Ԥ2 */
    BOOL bReserved3;              /* Ԥ3 */
}NETDEV_GPU_ABLESTATE_S,*LPNETDEV_GPU_ABLESTATE_S;

/**
 * @struct tagstNETDEVXWEncodeChnProperty
 * @brief رͨͨ
 * @attention
 */
typedef struct tagstNETDEVXWEncodeChnProperty
{
    INT32 dwVideoSrc;                                     /* Ƶʽ NETDEV_VIDEO_SRC_TYPE_E */
    BYTE   byRes[512];
}NETDEV_XW_ENCODE_CHN_PROPERTY_S, *LPNETDEV_XW_ENCODE_CHN_PROPERTY_S;



/**
 * @struct tagNETDEVLogFindCondV30
 * @brief ־ѯ ṹ嶨 Log query condition Structure definition
 * @attention  None
 */
typedef struct tagNETDEVLogFindCondV30
{
    NETDEV_LOG_MAIN_TYPE_E  enMainType;         /*   Main type */
    NETDEV_LOG_SUB_TYPE_E   enSubType;          /*   Sub type */
    INT64                   tBeginTime;         /* ʼʱ  Start time */
    INT64                   tEndTime;           /* ʱ  End time */
}NETDEV_LOG_FIND_COND_V30_S, *LPNETDEV_LOG_FIND_V30_COND_S;


/**
 * @struct tagstNETDEVUserLogInfo
 * @brief û¼Ϣ
 * @attention
 */
typedef struct tagstNETDEVUserLogInfo
{
    CHAR   szUserName[NETDEV_USERNAME_LEN];                     /* û */
    INT32  dwUserHandle;                                        /* ûID(¼) */
    NETDEV_IPADDR_INFO_S   stUserIPAddr;                        /* ûIPַ */
}NETDEV_USER_LOG_INFO_S, *LPNETDEV_USER_LOG_INFO_S;

/**
 * @struct tagstNETDEVUserEventType
 * @brief û¼
 * @attention
 */
typedef struct tagstNETDEVUserEventType
{
    INT32 dwMajorType;                                  /*  */
    INT32 dwMinorType;                                  /*  */
}NETDEV_USER_EVENT_TYPE_S, *LPNETDEV_USER_EVENT_TYPE_S;

/**
 * @struct tagstNETDEVEventNotifyInfo
 * @brief ¼Ϣ
 * @attention
 */
typedef struct tagstNETDEVEventNotifyInfo
{    
    NETDEV_USER_EVENT_TYPE_S    stEventType;            /* ¼ */
    INT32 dwParamLen;                                   /*  */
}NETDEV_EVENT_NOTIFY_TYPE_S, *LPNETDEV_EVENT_NOTIFY_TYPE_S;

/**
 * @struct tagstNETDEVDateInfo
 * @brief ʱϢ
 * @attention
 */
typedef struct tagstNETDEVDateInfo
{
    INT32     dwYear;                               /*  */
    INT32     dwMonth;                              /* · */
    INT32     dwDay;                                /*  */
    INT32     dwHour;                               /* Сʱ */
    INT32     dwMinute;                             /*  */
    BYTE      byRes[32];                            /* ֶ */
}NETDEV_DATE_INFO_S, *LPNETDEV_DATE_INFO_S;

/**
 * @enum tagClientType
 * @brief ͻ
 * @attention  None
 */
typedef enum tagClientType
{
    NETDEV_CLIENT_TYPE_EZVMS    = 0,
    NETDEV_CLIENT_TYPE_EZGATE   = 1,
    NETDEV_CLIENT_TYPE_EZASSIST = 2,

    NETDEV_CLIENT_TYPE_IVALID   = 0xff
}NETDEV_CLIENT_TYPE_E;

/**
 * @struct tagstNETDEVClientVersionsInfo
 * @brief ͻ˰汾Ϣ
 * @attention
 */
typedef struct tagstNETDEVClientVersionsInfo
{
    UINT32                              udwType;                                            /* ͻ μö# NETDEV_CLIENT_TYPE_E */
    CHAR                                szVersion[NETDEV_LEN_256];                          /* ͻ˶汾ţ Χ[0, 255] */

    BYTE                                byRes[32];                                          /* ֶ */
}NETDEV_CLIENT_VERSION_INFO_S, *LPNETDEV_CLIENT_VERSION_INFO_S;

/**
 * @struct tagstNETDEVClientVersionsInfoList
 * @brief ͻ˰汾Ϣб
 * @attention
 */
typedef struct tagstNETDEVClientVersionsInfoList
{
    UINT32                                  udwNum;                                          /*  */
    LPNETDEV_CLIENT_VERSION_INFO_S          pstClientVersionsInfo;                           /* ͻ˰汾Ϣб */

    BYTE                                    byRes[32];                                       /* ֶ */
}NETDEV_CLIENT_VERSION_INFO_LIST_S, *LPNETDEV_CLIENT_VERSION_INFO_LIST_S;

/**
 * @struct tagNETDEVDeviceBaseInfo
 * @brief 豸Ϣ
 * @attention 
 */
typedef struct tagNETDEVDeviceBaseInfo
{
    INT32 dwChlID;                                              /* Ƶͨ  Video input channel ID */
    INT32 dwDeviceType;                                         /* 豸  Device Type */
    INT32 dwDevCode;                                            /* 豸  Device code */
    INT32 dwCurrentLang;                                        /* 豸ǰ μö#NETDEV_LANG_TYPE_E Current language NETDEV_LANG_TYPE_E*/
    NETDEV_DATE_INFO_S stBuildDate;                             /* ʱ  Release time */
    CHAR szSerialNum[NETDEV_LEN_32];                            /* 豸к  Device serial number */
    CHAR szMacAddress[NETDEV_LEN_64];                           /* IPv4Macַ  MAC address of IPv4 */
    CHAR szDevName[NETDEV_CODE_STR_MAX_LEN];                    /* 豸  Device name */
    CHAR szDevModel[NETDEV_CODE_STR_MAX_LEN];                   /* 豸ͺ  Device model */
    CHAR szVIIDVersion[NETDEV_CODE_STR_MAX_LEN];                /* ͼ汾  VIIDVersion version */
    CHAR szSoftwareVersion[NETDEV_CODE_STR_MAX_LEN];            /* ڲ汾 Internal software version */
    CHAR szFirmwareVersion[NETDEV_CODE_STR_MAX_LEN];            /* 汾  Software version */
    CHAR szHardewareID[NETDEV_CODE_STR_MAX_LEN];                /* Ӳʶ  Hardware ID */
    CHAR szUbootVersion[NETDEV_CODE_STR_MAX_LEN];               /* UBOOT汾  UBOOT version */
    CHAR szManufacturer[NETDEV_LEN_64];                         /* ƣַ[1,64]  Manufacturer */
    NETDEV_CLIENT_VERSION_INFO_LIST_S stClientVersionsInfo;     /* 汾Ϣѡһ֧  Client Versions Infos */

    BYTE byRes[472];                                        /* ֶ Reserved */
}NETDEV_DEVICE_BASE_INFO_S, *LPNETDEV_DEVICE_BASE_INFO_S;

/**
 * @struct tagNETDEVNetWorkCardDetailInfo
 * @brief ϸϢ
 * @attention 
 */
typedef struct tagNETDEVNetWorkCardDetailInfo
{
    CHAR                          szNetCardName[NETDEV_LEN_32];                           /* ƣΧ[0,16] */
    UINT32                        udwInBoundRate;                                         /* մʹλKbps */
    UINT32                        udwOutBoundRate;                                        /* ʹʹλKbps */

    BYTE byRes[256];                                        /* ֶ Reserved */
}NETDEV_NETWORK_CARD_DETAIL_INFO_S, *LPNETDEV_NETWORK_CARD_DETAIL_INFO_S;

/**
 * @struct tagNETDEVDeviceRunInfo
 * @brief 豸Ϣ
 * @attention 
 */
typedef struct tagNETDEVDeviceRunInfo
{
    UINT32                        udwRuntime;                                                /* 豸ʱ䣬λs */
    UINT32                        udwCPUUsage;                                               /* 豸CPUʹʣٷֱȣVMS֧ */
    UINT32                        udwMemUsage;                                               /* 豸ڴʹʣٷֱȣVMS֧ */
    UINT32                        udwNetInterfaceNum;                                        /* VMS֧ */
    NETDEV_NETWORK_CARD_DETAIL_INFO_S astNetInterfaceInfoList[NETDEV_MAX_NET_WORK_CARD_NUM]; /* ϢбNetCardNumֵΪ0ʱýڵѡ */

    BYTE byRes[512];                                        /* ֶ Reserved */
}NETDEV_DEVICE_RUN_INFO_S, *LPNETDEV_DEVICE_RUN_INFO_S;

/**
 * @struct tagNETDEVMotionIntervalInfo
 * @brief ˶澯 Motion Interval Info
 * @attention  None
 */
typedef struct tagNETDEVMotionIntervalInfo
{
    UINT32    udwSuppressTime;                                     /* Ƽʱ,λ:,Χ[5, 3600] */
    UINT32    udwClearTime;                                        /* ָʱ,λ:,Χ[1,600] */

    BYTE    byRes[512];                                            /* ֶ  Reserved */
}NETDEV_MOTION_INTERVAL_INFO_S, *LPNETDEV_MOTION_INTERVAL_INFO_S;
/************************************************************************/
/*                            ֯ ORG                                 */
/************************************************************************/

/**
 * @struct tagstNETDEVOrgChnShortInfo
 * @brief ֯ͨϢ
 * @attention
 */
typedef struct tagstNETDEVOrgChnShortInfo
{
    INT32 dwOrgID;              /* ֯ID */
    INT32 dwChannelsNum;        /* ͨ */
    INT32 *pdwChnIDs;           /* ͨID ָ ̬ͨڴ */

    BYTE  byRes[68];            /* ֶ  Reserved field*/
}NETDEV_ORG_CHN_SHORT_INFO_S, *LPNETDEV_ORG_CHN_SHORT_INFO_S;


/**
 * @struct tagstNETDEVOrgDetailInfo
 * @brief ɾ֯ϸϢ
 * @attention
 */
typedef struct tagstNETDEVDelOrgDetailInfo
{    
    INT32 dwOrgNum;     /* ֯ */
    INT32 *pdwOrgIDs;   /* Ҫɾ֯IDdwOrgNum ̬ */
    INT32 dwOrgType;    /* ֯  NETDEV_ORG_TYPE_E */
    BYTE  byRes[64];    /* ֶ  Reserved field*/
}NETDEV_DEL_ORG_INFO_S, *LPNETDEV_DEL_ORG_INFO_S;

/**
 * @struct tagstNETDEVOrgDelDetailInfo
 * @brief ɾ֯Ϣ
 * @attention
 */
typedef struct tagstNETDEVOrgDelDetailInfo
{    
    INT32 dwStatus;                             /* Ӧ״̬ μ NETDEV_ORG_RESPONSE_STAUTE_E */
    INT32 dwNum;                                /* Ӧ */
    LPNETDEV_OPERATE_INFO_S pstResultInfo;      /*ɾϢɾ̬*/

    BYTE  byRes[68];                            /* ֶ  Reserved field*/
}NETDEV_ORG_BATCH_DEL_INFO_S, *LPNETDEV_ORG_BATCH_DEL_INFO_S;


/**
 * @struct tagNETDEVDCPlaybackCond
 * @brief DC¼طŲ ṹ嶨
 * @attention  None
 */
typedef struct tagNETDEVDCPlaybackCond
{
    INT32   dwChannelID;                    /* ͨID  Channel ID */
    INT32   dwTVWallID;                     /* ǽID */
    INT32   dwWinIndex;                     /*  */
    INT32   dwSubWinIndex;                  /* Ӵ */
    INT32   dwStreamType;                   /* ,#μNETDEV_STREAM_TYPE_E */
    INT64   tBeginTime;                     /* ʼʱ */
    INT64   tEndTime;                       /* ʱ */
    INT32   dwTransProto;                   /* Э,#μNETDEV_TRANSPORT_PROTOCOL_E */
    INT32   dwRecordType;                   /* ¼,.μ#NETDEV_STORE_TYPE_E */
    INT32   dwRecordLocation;               /* ¼洢λãμ#NETDEV_RECORD_LOCATION_E */
    BOOL    bRealtimeSync;                  /* ǷʱЧ */
    CHAR    szUrl[NETDEV_LEN_260];          /* طUrl */
    BYTE    byRes[196];                     /* ֶ  Reserved */
}NETDEV_DC_PLAYBACK_COND_S, *LPNETDEV_DC_PLAYBACK_COND_S;

/**
 * @struct tagNETDEVDCPlaybackCond
 * @brief DC¼طתԲ ṹ嶨
 * @attention  None
 */
typedef struct tagNETDEVDCTransWinCond
{
    INT32   dwChannelID;                /* 󶨵ıͨID */
    UINT32  udwSessionID;               /* طŵҵ */
    INT64   tBeginTime;                 /* طſʼʱ */
    INT64   tEndTime;                   /* طŽʱ */
    INT32   dwLinkMode;                 /* Э飬μö#NETDEV_TRANS_PROTOCAL_E */
    LPVOID  hPlayWnd;                   /* ԵĴ */
    INT32   dwTransType;                /* ͣμö#NETDEV_TRANS_TYPE_E */
    BYTE    byRes[124];                 /* ֶ */
}NETDEV_DC_TRANS_WIN_COND_S, *LPNETDEV_DC_TRANS_WIN_COND_S;




/**
 * @struct tagstNETDEVAlarmPlanAlarmSrcInfo
 * @brief 澯Ԥ澯ԴϢ
 * @attention
 */
typedef struct tagstNETDEVAlarmPlanAlarmSrcInfo
{
    INT32 dwAlarmType;          /* 澯 */
    INT32 dwAlarmSubType;       /* 澯 */
    INT32 dwAlarmSrcID;         /* 澯ԴID */
}NETDEV_ALARM_PLAN_ALARMSRCINFO_S, *LPNETDEV_ALARM_PLAN_ALARMSRCINFO_S;

/**
 * @struct tagstNETDEVAlarmPlanLinkPreset
 * @brief 澯ԤԤλϢ
 * @attention
 */
typedef struct tagstNETDEVAlarmPlanLinkPreset
{
    INT32 dwChnID;      /* ԤλͨID */
    INT32 dwPresetID;   /* Ԥλ */
}NETDEV_ALARM_PLAN_LINKPRESET_S, *LPNETDEV_ALARM_PLAN_LINKPRESET_S;

/**
 * @struct tagstNETDEVAlarmPlanLinkSwitchOut
 * @brief 澯ԤϢ
 * @attention
 */
typedef struct tagstNETDEVAlarmPlanLinkSwitchOut
{
    INT32   dwSwitchOutChnID; /* ͨID */
    BYTE    byRes[256];
}NETDEV_ALARM_PLAN_LINKSWITCHOUT_S, *LPNETDEV_ALARM_PLAN_LINKSWITCHOUT_S;

/**
 * @struct tagstNETDEVAlarmPlanLinkMonitor
 * @brief 澯ԤʵϢ
 * @attention
 */
typedef struct tagstNETDEVAlarmPlanLinkMonitor
{
    INT32 dwChnID;                          /* ʵͨID */
    INT32 dwMonitorDelay;                   /* ʵʱ λs */
}NETDEV_ALARM_PLAN_LINKMONITOR_S, *LPNETDEV_ALARM_PLAN_LINKMONITOR_S;

/**
 * @struct tagstNETDEVAlarmPlanLinkTvwall
 * @brief ǽϢ
 * @attention
 */
typedef struct tagstNETDEVAlarmPlanLinkTvwall
{
    INT32 dwTaskID;                          /* ǽID */
    INT32 dwTaskDelayTime;                   /* ʱ */
}NETDEV_ALARM_PLAN_LINKTVWALL_S, *LPNETDEV_ALARM_PLAN_LINKTVWALL_S;

/**
 * @struct tagstNETDEVAlarmPlanLinkRuleInfo
 * @brief 澯ԤϢ
 * @attention
 */
typedef struct tagstNETDEVAlarmPlanLinkRuleInfo
{
    INT32 dwLinkType;                                                                   /* (λ)μ#NETDEV_ALARM_LINK_TYPE_E */
    INT32 dwLinkPresetSize;                                                             /* Ԥλ*/
    NETDEV_ALARM_PLAN_LINKPRESET_S astLinkPreset[NETDEV_ALARM_LINK_PRESET_NUM];         /* ԤλϸϢ*/
    INT32 dwSwitchOutSize;                                                              /* 澯ͨ*/
    NETDEV_ALARM_PLAN_LINKSWITCHOUT_S astSwitchOut[NETDEV_ALARM_LINK_SWITCHOUT_NUM];    /* 澯ͨϢ*/
    INT32 dwLinkMonitorSize;                                                            /* ʵ*/
    BOOL bIsMonitorLinkScr;                                                             /* Ƿ澯Դ 0澯Դ 1澯Դ */
    NETDEV_ALARM_PLAN_LINKMONITOR_S astLinkMonitor[NETDEV_ALARM_LINK_MONITOR_NUM];      /* ʵϢ*/
    INT32 dwLinkTVWallSize;                                                             /* ǽ*/
    NETDEV_ALARM_PLAN_LINKTVWALL_S astLinkTVWall[NETDEV_ALARM_LINK_TVWALL_NUM];         /* ǽϢ*/
    CHAR szLinkSoundInfo[NETDEV_ALARM_LINK_SOUND_LEN];                                  /* Ϣ */

    BYTE    byRes[512];                                                                 /* ֶ  Reserved */
}NETDEV_ALARM_PLAN_LINKRULEINFO_S, *LPNETDEV_ALARM_PLAN_LINKRULEINFO_S;

/**
 * @struct tagstNETDEVAlarmPlanLinkInfo
 * @brief 澯ԤϢ
 * @attention
 */
typedef struct tagstNETDEVAlarmPlanLinkInfo
{
    INT32 dwLinkRuleID;                                                         /* ID */
    INT32 dwAlarmSrcSize;                                                       /* 澯Դ */
    NETDEV_ALARM_PLAN_ALARMSRCINFO_S astAlarmSrc[NETDEV_ALARM_SOURCE_NUM];      /* 澯ԴϢ */
    NETDEV_ALARM_PLAN_LINKRULEINFO_S stLinkRuleInfo;                            /* Ϣ */
}NETDEV_ALARM_PLAN_LINKINFO_S, *LPNETDEV_ALARM_PLAN_LINKINFO_S;

/**
 * @struct tagstNETDEVAlarmPlanDetailInfo
 * @brief 澯ԤϸϢ
 * @attention
 */
typedef struct tagstNETDEVAlarmPlanDetailInfo
{
    INT32   dwPlanType;                                                 /* 澯Ԥ */
    INT32   dwPlanID;                                                   /* ԤID */
    CHAR    szPlanName[NETDEV_NAME_MAX_LEN];                            /* Ԥ */
    INT32   dwTimeTamplateID;                                           /* ʱģID */
    CHAR    szPlanDesc[NETDEV_DESCRIBE_MAX_LEN];                        /* Ԥ */
    BOOL    bEnable;                                                    /* ǷԤ */
    INT32   dwLinkInfoSize;                                             /* ԤϢ */
    NETDEV_ALARM_PLAN_LINKINFO_S astLinkInfo[NETDEV_ALARM_LINK_NUM];    /* ԤϢ */
}NETDEV_ALARM_PLAN_DETAILINFO_S, *LPNETDEV_ALARM_PLAN_DETAILINFO_S;

/**
 * @struct tagstNETDEVTimeTemplateList
 * @brief ʱģб
 * @attention
 */
typedef struct tagstNETDEVTimeTemplateList
{
    INT32   dwSize;                                                         /* ģС */
    NETDEV_TIME_TEMPLATE_S astTimeTemplate[NETDEV_TIME_TEMPLATE_NUM];       /* ʱģϢ */
}NETDEV_TIME_TEMPLATE_LIST_S, *LPNETDEV_TIME_TEMPLATE_LIST_S;


/**
 * @struct tagstNETDEVViewBasicInfo
 * @brief ѲԤϢ
 * @attention
 */
typedef struct tagstNETDEVViewBasicInfo
{
    INT32   dwPlanID;                                           /* ԤID */
    CHAR    szPlanName[NETDEV_NAME_MAX_LEN];                    /* Ԥ */
    INT32   dwOrderNo;                                          /* ƻ */
    CHAR    szPlanDesc[NETDEV_DESCRIBE_MAX_LEN];                /* Ԥ */
    INT32   dwLayout;                                           /* ģʽ, μ#NETDEV_LAYOUT_TYPE_E */
    BYTE    byRes[124];                                         /* ֶ  Reserved */
}NETDEV_VIEW_BASIC_INFO_S, *LPNETDEV_VIEW_BASIC_INFO_S;

/**
 * @struct tagstNETDEVScenesTimeTable
 * @brief ѲƻʱģʽϢ
 * @attention
 */
typedef struct tagstNETDEVScenesTimeTable
{
    UINT32   udwScenseID;                             /* ID */
    CHAR     szStartTime[NETDEV_LEN_16];              /* ʼʱ HH:MM     󳤶: 8*/
    BYTE     byRes[128];                              /* ֶ  Reserved */
}NETDEV_SCENES_TIME_TABLE_INFO_S, *LPNETDEV_SCENES_TIME_TABLE_INFO_S;

/**
 * @struct tagstNETDEVScenesPlanInfo
 * @brief ѲƻϢ
 * @attention
 */
typedef struct tagstNETDEVScenesPlanInfo
{
    NETDEV_VIEW_BASIC_INFO_S         stScenesBasicInfo;                  /* ѲԤϢ */
    UINT32   udwStatus;                                                  /* ƻ״̬ μ NETDEV_DC_SEQ_STATUS_E */
    UINT32   udwPlanMode;                                                /* ƻʽ  0ʱл 124Сʱƻ μöNETDEV_PLANS_MODE_E */
    UINT32   udwInterval;                                                /* ʱڶʱлģʽϢ, λ룬 PlanModeΪ0ʱѡ */
    UINT32   udwSceneNum;                                                /* ڶʱлģʽϢ   PlanModeΪ0ʱѡ*/
    UINT32   audwSceneID[NETDEV_LEN_1024];                               /* IDбڶʱлģʽϢ  PlanModeΪ0ʱѡ*/
    UINT32   udwTimeTableNum;                                            /*ʱģʽԱ*/
    NETDEV_SCENES_TIME_TABLE_INFO_S   astTimeTable[NETDEV_LEN_1024];     /* ʱģʽϢб  PlanModeΪ1ʱѡ*/
    BYTE     byRes[128];                                                 /* ֶ  Reserved */
}NETDEV_SCENES_PLAN_INFO_S, *LPNETDEV_SCENES_PLAN_INFO_S;

/**
 * @struct tagstNETDEVResInfo
 * @brief ѲԴϢ
 * @attention
 */
typedef struct tagstNETDEVResInfo
{
    INT32   dwWinIndex;                                                 /*  */
    INT32   dwResType;                                                  /* Դ οö#NETDEV_VIEW_TYPE_E*/
    INT32   dwResID;                                                    /* ԴID */
    INT32   dwStreamIndex;                                              /*  */
    INT32   dwPresetID;                                                 /* ԤλID */
}NETDEV_RES_INFO_S, *LPNETDEV_RES_INFO_S;

/**
 * @struct tagstNETDEVViewDetailInfo
 * @brief ͼϸϢ
 * @attention
 */
typedef struct tagstNETDEVViewDetailInfo
{
    NETDEV_VIEW_BASIC_INFO_S       stBasicInfo;                                      /* Ϣ */
    INT32                          dwViewResSize;                                    /* ͼԴ */
    NETDEV_RES_INFO_S              astViewResInfo[NETDEV_VIEW_MAX_WIN_NUM];          /* ͼԴϸϢ */
}NETDEV_VIEW_DETAIL_INFO_S, *LPNETDEV_VIEW_DETAIL_INFO_S;


/**
 * @struct tagstNETDEVViewPlanModeInfo
 * @brief ͼƻģʽϸϢ
 * @attention
 */
typedef struct tagstNETDEVViewPlanModeInfo
{
    UINT32   udwViewID;                                                  /* ͼID*/
    UINT32   udwInterval;                                                /* ʱ ģʽΪʱлģʽʱѡλ*/
    CHAR     szStartTime[NETDEV_LEN_16];                                 /* ʼʱʱ ģʽΪʱģʽʱѡHH:MM ȷΧ[1, 8]*/
    BYTE     byRes[128];                                                 /* ֶ  Reserved */
}NETDEV_VIEW_PLAN_MODE_INFO_S, *LPNETDEV_VIEW_PLAN_MODE_INFO_S;

/**
 * @struct tagstNETDEVViewPlanInfo
 * @brief ͼƻϢ
 * @attention
 */
typedef struct tagstNETDEVViewPlanInfo
{
    NETDEV_VIEW_BASIC_INFO_S         stScenesBasicInfo;                     /* ѲԤϢ */
    UINT32   udwStatus;                                                     /* ƻ״̬ μ NETDEV_DC_SEQ_STATUS_E*/
    UINT32   udwPlanMode;                                                   /* ƻʽ  0ʱл 124Сʱƻ, μöNETDEV_PLANS_MODE_E*/
    NETDEV_VIEW_PLAN_MODE_INFO_S    astViewPlanInfoList[NETDEV_LEN_1024];                   /*ƻϢб udwPlanMode жӦݵ*/
    UINT32   udwPlanNum;                                                    /* ƻϢбмƻĸ*/
    BYTE     byRes[128];                                                    /* ֶ  Reserved */
}NETDEV_VIEW_PLAN_INFO_S, *LPNETDEV_VIEW_PLAN_INFO_S;

/**
 * @struct tagstNETDEVEMapPicInfo
 * @brief ӵͼ ͼƬϢ
 * @attention 
 */
typedef struct tagstNETDEVEMapPicInfo
{
    UINT32  udwID;                                /* ͼƬID */
    CHAR    szName[NETDEV_LEN_128];               /* ͼƬƣΧ[0,127]ַ */
    UINT32  udwType;                              /* ͼƬ μ NETDEV_EMAP_PIC_TYPE */
    UINT32  udwSubType;                           /* ͼͣͼƬΪ1ʱSubTypeش μ NETDEV_EMAP_PIC_SUBTYPE */
    BOOL    bIsBuiltin;                           /* ǷΪͼƬֻ 1 0 */
    CHAR    szURL[NETDEV_LEN_128];                /* ͼƬURL */
    BYTE    byRes[128];                           /* ֶ */
}NETDEV_EMAP_PIC_INFO_S, *LPNETDEV_EMAP_PIC_INFO_S;

/**
 * @struct tagstNETDEVEEmapMarkerStyle
 * @brief ӵͼʽ
 * @attention 
 */
typedef struct tagstNETDEVEEmapMarkerStyle
{
    UINT32  udwColor;       /* ɫ μ NETDEV_EMAP_MARKER_COLOR_E */
    UINT32  udwPicID;       /* ȵͼӦͼƬID */
}NETDEV_EMAP_MARKER_STYLE_S;
/**
 * @struct tagstNETDEVEMapMarkerInfo
 * @brief ӵͼϢ
 * @attention 
 */
typedef struct tagstNETDEVEMapMarkerInfo
{
    UINT32  udwID;                                 /* ȵID ȵʱЯֶΡ */
    UINT32  udwPID;                                /* ID ޸ıͼƬȵʱЯֶΡ */
    UINT32  udwType;                               /* ͣμ# NETDEV_EMAP_MARKER_TYPE_E */
    UINT32  udwLinkID;                             /* ʱΪͼIDȵΪͨID */
    NETDEV_EMAP_MARKER_STYLE_S stMarkerStyle;      /* ʽ */
    DOUBLE  fPosX;                                 /* ˮƽ */
    DOUBLE  fPosY;                                 /* ֱ */
    CHAR    szName[NETDEV_LEN_128];                /* ȵ/ */
}NETDEV_EMAP_MARKER_INFO_S, *LPNETDEV_EMAP_MARKER_INFO_S;

/**
 * @struct tagstNETDEVDCSchemeResInfo
 * @brief DCѲԴϢ
 * @attention 
 */
typedef struct tagstNETDEVDCSchemeResInfo
{
    INT32   dwResID;                                    /* ԴID ʱҪ */
    BOOL    bEnable;                                    /* ѲǷʹ */
    CHAR    szName[NETDEV_NAME_MAX_LEN];                /* ѲԴ */
    CHAR    szDesc[NETDEV_DESCRIBE_MAX_LEN];            /* ѲԴ */
}NETDEV_DC_SCHEME_RES_INFO_S, *LPNETDEV_DC_SCHEME_RES_INFO_S;

/**
 * @struct tagstNETDEVDCSchemeResChnInfo
 * @brief DCѲԴͨϢ
 * @attention
 */
typedef struct tagstNETDEVDCSchemeResChnInfo
{
    INT32   dwIndex;                                            /*  */
    INT32   dwChannelID;                                        /* ͨID */
    INT32   dwStreamIndex;                                      /*  */
    INT32   dwPresetID;                                         /* ԤλID */
}NETDEV_DC_SCHEME_RES_CHN_INFO_S, *LPNETDEV_DC_SCHEME_RES_CHN_INFO_S;

/**
 * @struct tagstNETDEVDCSchemeRes
 * @brief DCѲԴϢ
 * @attention 
 */
typedef struct tagstNETDEVDCSchemeResource
{
    NETDEV_DC_SCHEME_RES_INFO_S         stResInfo;                                          /* ѲԴϢ */
    INT32                               dwIntervalTime;                                     /* Ѳʱ(s) */
    INT32                               dwSize;                                             /* ѲͨԴ */
    NETDEV_DC_SCHEME_RES_CHN_INFO_S     astChnInfo[NETDEV_DC_SCHEME_RES_CHN_MAX_NUM];       /* ѲͨԴϢ */
}NETDEV_DC_SCHEME_RESOURCE_S, *LPNETDEV_DC_SCHEME_RESOURCE_S;

/**
 * @struct tagstNETDEVRoleRight
 * @brief ûɫȨϢ
 * @attention 
 */

typedef struct tagstNETDEVRoleRight
{
    UINT32 udwMajorRight;
    UINT32 udwMinorRight;     /* ö#NETDEV_MINOR_OPER_DOOR_CONFIG_E*/
}NETDEV_ROLE_RIGHT_S, *LPNETDEV_ROLE_RIGHT_S;

/**
 * @struct tagstNETDEVOrgTreeList
 * @brief ûɫȨб
 * @attention 
 */
typedef struct tagstNETDEVOrgTreeList
{
    INT32 dwSize;                                               /* ֯ */
    INT32 adwOrgRootID[NETDEV_MAX_ORG_ROOT_ID_NUM];              /* ֯ڵID */
}NETDEV_ORG_TREE_S, *LPNETDEV_ORG_TREE_S;

/**
 * @struct tagstNETDEVRoleRightList
 * @brief ûɫȨб
 * @attention 
 */
typedef struct tagstNETDEVRoleRightList
{
    INT32 dwSize;                                                   /*  */
    NETDEV_ROLE_RIGHT_S astRoleRight[NETDEV_MAX_ROLE_RIGHT_SIZE];        /* ûȨϢ */
    NETDEV_ORG_TREE_S stOrgTreeInfo;                                 /* ֯Ϣ */
}NETDEV_RIGHT_LIST_S, *LPNETDEV_RIGHT_LIST_S;



/**
 * @struct tagstNETDEVTimeDuration
 * @brief ÿʱϢ
 */
typedef struct tagstNETDEVTimeDuration
{
    INT64    tBeginTime;                              /* ʼʱ */
    INT64    tEndTime;                                /* ʱ */
    INT32    dwPlanType;                              /* μ NETDEV_TIME_TEMPLATE_PLAN_TYPE */
}NETDEV_TIME_DURATION_S, *LPNETDEV_TIME_DURATION_S;

/**
 * @struct tagstNETDEVTimeDurationList
 * @brief ÿʱϢбһ24ʱ
 */
typedef struct tagstNETDEVTimeDurationList
{
    INT32                     dwSize;                                                      /* ʱθ */
    NETDEV_TIME_DURATION_S    astTimeDurationList[NETDEV_TIME_DURATION_NUM];               /* ʱϢб */
}NETDEV_TIME_DURATION_LIST_S, *LPNETDEV_TIME_DURATION_LIST_S;

/**
 * @struct tagstNETDEVTimeRange
 * @brief ʱ䷶ΧϢһʱģɰ8ʱ䷶Χһպͼ
 * @attention
 */
typedef struct tagstNETDEVTimeRange
{
    INT32                            dwSize;                                         /* ʱ䷶Χ */
    NETDEV_TIME_DURATION_LIST_S      astTimeRangeList[NETDEV_TIME_RANGE_NUM];        /* ʱ䷶Χб */
}NETDEV_TIME_RANGE_S, *LPNETDEV_TIME_RANGE_S;

/**
 * @struct tagstNETDEVTimeTemplateInfo
 * @brief ʱģϸϢ
 * @attention
 */
typedef struct tagstNETDEVTimeTemplateInfoV30
{
    CHAR    szTamplateName[NETDEV_NAME_MAX_LEN];                            /* ģ */
    CHAR    szTamplateDesc[NETDEV_DESCRIBE_MAX_LEN];                        /* ģ */
    INT32   dwTemplateType;                                                 /* ʱģ μNETDEV_TIME_TEMPLATE_TYPE_E */
    NETDEV_TIME_RANGE_S    stTimeRange;                                     /* 8ʱ䷶Χ */
}NETDEV_TIME_TEMPLATE_INFO_V30_S, *LPNETDEV_TIME_TEMPLATE_INFO_V30_S;

/**
 * @struct tagstNETDEVHolidayTimeInfo
 * @brief ʱϢ
 * @attention
 */
typedef struct tagstNETDEVHolidayTimeInfo
{
    INT32     dwYear;                               /*  */
    INT32     dwMonth;                              /* · */
    INT32     dwDay;                                /*  */
    INT32     dwWeekOfMonth;                        /* µĵڼ */
    INT32     dwWeekDay;                            /* ܼ */
}NETDEV_HOLIDAY_TIME_INFO_S, *LPNETDEV_HOLIDAY_TIME_INFO_S;

/**
 * @struct tagstNETDEVHolidayInfo
 * @brief Ϣ
 * @attention
 */
typedef struct tagstNETDEVHolidayInfo
{
    INT32      dwHolidayID;                            /* Ϣ */
    CHAR       szHolidayName[NETDEV_NAME_MAX_LEN];           /*  */
    INT32      dwStatus;                               /* ״̬(0ʾδã1ʾ) */
    INT32      dwRepeatType;                           /* ظʽ(0ʾ꣬1ʾ) */
    INT32      dwHolidayType;                          /* ڼʱʶʽ(0ʾգ1ʾ) */
    NETDEV_HOLIDAY_TIME_INFO_S    stBeginTime;         /* տʼʱ */
    NETDEV_HOLIDAY_TIME_INFO_S    stEndTime;           /* սʱ */
}NETDEV_HOLIDAY_INFO_S, *LPNETDEV_HOLIDAY_INFO_S;

/**
 * @struct tagstNETDEVHolidayInfoList
 * @brief мϢ
 * @attention
 */
typedef struct tagstNETDEVHolidayInfoList
{
    INT32                        dwSize;                                        /*  */
    NETDEV_HOLIDAY_INFO_S        astHolidayInfoList[NETDEV_HOLIDAY_INFO_NUM];      /* мϢ */
}NETDEV_HOLIDAY_INFO_LIST_S, *LPNETDEV_HOLIDAY_INFO_LIST_S;

/**
 * @struct tagNETDEVPaneBindInfo
 * @brief ҵϢ
 * @attention
 */
typedef struct tagNETDEVPaneBindInfo
{
    UINT32  udwVideoInChannelID;              /* ƵԴID */
    UINT32  udwStreamID;                      /* ýID */
}NETDEV_PANE_BIND_INFO_S, *LPNETDEV_PANE_BIND_INFO_S;


/**
 * @struct tagNETDEVPaneBindService
 * @brief ҵ
 * @attention
 */
typedef struct tagNETDEVPaneBindService
{
    UINT32                       udwTVWallID;                 /* ǽID */
    UINT32                       udwWindowID;                 /* ID */
    UINT32                       udwPaneID;                   /* ID */
    UINT32                       udwPaneOperateType;          /*  μNETDEV_PANE_OPERATE_TYPE_E*/
    NETDEV_PANE_BIND_INFO_S      udwPaneBindInfo;             /* 󶨵ҵϢ */
}NETDEV_PANE_BIND_SERVICE_S, *LPNETDEV_PANE_BIND_SERVICE_S;


/**
 * @struct tagNETDEVXWPaneInfo
 * @brief XWڷϢ
 * @attention
 */
typedef struct tagNETDEVVideoInSource
{
    UINT32  udwPaneID;          /*  */
    INT32   dwChannelID;        /* ͨID */
    UINT32  udwStreamIndex;     /*  */
    UINT32  udwTaskNo;          /* ҵ */
    UINT32  udwTransProtocal;   /* Э μ NETDEV_LAPI_TRANS_PROTOCAL_E */
    UINT32  udwSessionType;     /* ҵ μ NETDEV_SESSION_TYPE_E */
}NETDEV_VIDEO_IN_SOURCE_INFO_S, *LPNETDEV_VIDEO_IN_SOURCE_INFO_S;


/**
 * @struct tagNETDEVXWSceneWndInfo
 * @brief Ϣ
 * @attention
 */
typedef struct tagNETDEVVideoInChnInfo
{
    UINT32                              udwWndID;                             /* ID */
    UINT32                              udwSeqResID;                          /* ѲԴID */
    UINT32                              udwSeqStatus;                         /* Ѳ״̬ μ NETDEV_SEQ_STATUS_E */
    NETDEV_VIDEO_IN_SOURCE_INFO_S       stVideoInSourceInfo;                  /* ڷϢ */
}NETDEV_VIDEO_IN_CHN_INFO_S, *LPNETDEV_VIDEO_IN_CHN_INFO_S;


typedef struct tagNETDEVSceneWndInfo
{
    UINT32              udwWndID;                            /* ID */
    UINT32              udwDChlID;                           /* DCͨID */
    CHAR                szName[NETDEV_WND_NAME_LEN];         /*  */
    UINT32              udwWndType;                          /*  NETDEV_TVWALL_WND_TPYE */
    UINT32              udwStatus;                           /* 0ʾ1ʾ */
    UINT32              udwPaneMod;                          /* ģʽ μNETDEV_LAYOUT_TYPE_E */
    UINT32              udwZoomType;                         /* Ŵ μNETDEV_WINDOWS_ZOOM_TYPE_E zoom Type see NETDEV_WINDOWS_ZOOM_TYPE_E */
    UINT32              udwSplitIndex;                       /*   ZoomTypeֵֶ1ʱѡ*/
    UINT32              udwLayer;                            /* ͼ */
    UINT32              udwTransparency;                     /* ͸ */
    NETDEV_XW_AREA_S    stArea;                              /* Χ */
}NETDEV_SCENE_WND_INFO_S, *LPNETDEV_SCENE_WND_INFO_S;

/**
 * @struct tagstNETDEVResInfo
 * @brief ѲԴϢ
 * @attention
 */
typedef struct tagstNETDEVGroupSeqInfo
{
    UINT32                      udwSeqID;           /* ѲID */
    BOOL                        bEnabled;           /* Ѳ״̬ */
    UINT32                      udwResourceID;      /* ѲԴID */
    UINT32                      udwStatus;          /* Ѳ״̬ μ NETDEV_SEQ_STATUS_E */
    UINT32                      udwWndNum;          /* Ѳ */
    LPNETDEV_SCENE_WND_INFO_S   audwWndIDList;      /* Ϣ */
}NETDEV_GROUP_SEQ_INFO_S, *LPNETDEV_GROUP_SEQ_INFO_S;

/**
 * @struct tagNETDEVXWSceneDetailInfo
 * @brief ϸϢ
 * @attention
 */
typedef struct tagNETDEVXWSceneDetailInfoEx
{
    UINT32                              udwVirtualLedNum;       /* LED */
    LPNETDEV_XW_VIRTUAL_LED_INFO_S      pstVirtualLedInfo;      /* LEDϢ */
    UINT32                              udwWndNum;              /*  */
    LPNETDEV_SCENE_WND_INFO_S           pstWndInfo;             /* Ϣ */
    UINT32                              udwGroupSeqNums;        /* Ѳ */
    LPNETDEV_GROUP_SEQ_INFO_S           pstGroupSeqInfo;        /* ѲϢ */
    UINT32                              udwVideoChnNums;        /* ҵ */
    LPNETDEV_VIDEO_IN_CHN_INFO_S        pstVideoInChnInfo;      /* ҵϢ */
}NETDEV_XW_SCENE_DETAIL_INFO_EX_S, *LPNETDEV_XW_SCENE_DETAIL_INFO_EX_S;


/**
 * @struct tagNETDEVXWWndIndex
 * @brief 
 * @attention
 */
typedef struct tagNETDEVXWWndIndex
{
    UINT32  udwTVWallID;    /* ǽID */
    UINT32  udwWndID;       /* ID */
}NETDEV_XW_WND_INDEX_S, *LPNETDEV_XW_WND_INDEX_S;

/**
 * @struct tagNETDEVXWLEDIndex
 * @brief LED 
 * @attention
 */
typedef struct tagNETDEVXWLEDIndex
{
    UINT32  udwTVWallID;        /* ǽID */
    UINT32  udwVirtualLEDID;    /* LED ID */
}NETDEV_XW_LED_INDEX_S, *LPNETDEV_XW_LED_INDEX_S;

/**
 * @struct tagNETDEVXWBatchResuleInfo
 * @brief ӷϢ
 * @attention
 */
typedef struct tagNETDEVXWBatchResuleInfo
{
    UINT32  udwReqSeq;          /**/
    UINT32  udwResuleCode;      /*ش*/
    UINT32  udwID;              /*ID*/
}NETDEV_XW_BATCH_RESULT_INFO_S,*LPNETDEV_XW_BATCH_RESULT_INFO_S;

/**
 * @struct tagNETDEVXWAudioOutputInfo
 * @brief ƵϢ ṹ嶨
 * @attention  None
 */
typedef struct tagNETDEVXWAudioOutputInfo
{
    UINT32  udwID;          /* ƵͨID */
    UINT32  udwVolum;       /*  */
    UINT32  udwIsMute;      /* ״̬ */
    BYTE    byRes[64];      /* ֶ */
}NETDEV_XW_AUDIO_OUTPUT_INFO_S,*LPNETDEV_XW_AUDIO_OUTPUT_INFO_S;

/**
 * @struct tagNETDEVXWWinAudioOutputInfo
 * @brief ƵҵϢ ṹ嶨
 * @attention  None
 */
typedef struct tagNETDEVXWWinAudioOutputInfo
{
    UINT32 udwWindowID;                                         /* ID */
    UINT32 udwPanelID;                                          /*  */
    NETDEV_XW_AUDIO_OUTPUT_INFO_S stXWAudioOutputInfo;          /* ƵϢṹ */
    BYTE byRes[64];                                             /* ֶ */
}NETDEV_XW_WIN_AUDIO_OUTPUT_INFO_S,*LPNETDEV_XW_WIN_AUDIO_OUTPUT_INFO_S;

/**
 * @struct tagNETDEVXWWinAudioOutputList
 * @brief ƵҵбϢ ṹ嶨
 * @attention  None
 */
typedef struct tagNETDEVXWWinAudioOutputList
{
    UINT32 udwNum;                                                                          /* Ƶҵ */
    NETDEV_XW_WIN_AUDIO_OUTPUT_INFO_S stXWWinAudioOutputInfo[NETDEV_AUDIO_MAX_NUM];       /* Ƶҵб */
    BYTE byRes[64];                                                                         /* ֶ */
}NETDEV_XW_WIN_AUDIO_OUTPUT_LIST_S,*LPNETDEV_XW_WIN_AUDIO_OUTPUT_LIST_S;

/**
 * @struct tagNETDEVXWPriviewInfo
 * @brief ʵԤ
 * @attention
 */
typedef struct tagNETDEVXWPriviewInfo
{
    UINT32  udwTVWallID;        /* ǽID */
    UINT32  udwWndID;           /* ID */
    UINT32  udwPaneID;          /* ID */
    INT32   dwChannelID;        /* ͨID */
    UINT32  udwStreamIndex;     /*  */
    UINT32  udwTransProtocal;   /* Э */
    UINT32  udwTransType;       /* ֱ(0)ת(1) */
}NETDEV_XW_PRIVIEW_INFO_S, *LPNETDEV_XW_PRIVIEW_INFO_S;

/**
 * @struct tagNETDEVXWPlayBackCond
 * @brief طŲ
 * @attention
 */
typedef struct tagNETDEVXWPlayBackCond
{
    UINT32  udwTVWallID;            /* ǽID */
    UINT32  udwWndID;               /* ID */
    UINT32  udwPaneID;              /* ID */
    INT32   dwChannelID;            /* ͨID */
    UINT32  udwBeginTime;           /* ʼʱ */
    UINT32  udwEndTime;             /* ʱ */
    UINT32  udwStoreType;           /* ¼洢 μ NETDEV_STORE_TYPE_E */
    UINT32  udwRecordLocation;      /* ¼λ */
    UINT32  udwSessionID;           /* session id */
}NETDEV_XW_PLAY_BACK_COND_S, *LPNETDEV_XW_PLAY_BACK_COND_S;


/**
 * @struct tagNETDEVXWPlayBackCond
 * @brief Ѳö
 * @attention
 */
typedef struct tagNETDEVXWSequenceCond
{
    UINT32  udwTVWallID;        /* ǽID */
    UINT32  udwSeqID;           /* ѲID */
    UINT32  udwResourceType;    /* Դ μNETDEV_XW_SEQ_RESOURCE_TYPE_E */
    UINT32  udwResourceID;      /* ԴID */
    UINT32  udwSeqCmd;          /* Ѳ,μNETDEV_XW_SEQ_CMD_E */
}NETDEV_XW_SEQUENCE_COND_S, *LPNETDEV_XW_SEQUENCE_COND_S;

/**
 * @struct tagstNETDEVVersionInfo
 * @brief һ豸汾Ϣ
 * @attention 
 */
typedef struct tagstNETDEVVersionInfo
{
    UINT32  udwDefaultLang;                         /* Ĭ μö NETDEV_LANG_TYPE_E */
    UINT32  udwNum;                                 /* ֵ֧ */
    UINT32  audwLangType[NETDEV_LEN_16];            /* ֵ֧ μö NETDEV_LANG_TYPE_E ,Ŀǰ֧*/
    UINT32  udwRegionType;                          /*  μö NETDEV_REGION_TYPE_E */
    UINT32  udwCustomType;                          /*   μö NETDEV_CUSTOM_TYPE_E */
    CHAR    szWin32ClientVision[NETDEV_LEN_64];     /* 32λC/Sͻ˰汾·Χ[1,32]] */
    CHAR    szWin64ClientVision[NETDEV_LEN_64];     /* 64λC/Sͻ˰汾·Χ[1,32]] */
    CHAR    szAgentClientVision[NETDEV_LEN_64];     /* agentͻ˰汾·Χ[1,32] */
    CHAR    szEztoolClientVision[NETDEV_LEN_64];    /* Eztoolͻ˰汾Χ[1,32] */
    CHAR    szUNPClientVision[NETDEV_LEN_64];       /* UNPͻ˰汾Χ[1,32] */
    CHAR    szGateClientVersion[NETDEV_LEN_64];     /* EZGateͻ˰汾Χ[1,32] */
    BYTE    byRes[192];                             /* ֶ */
}NETDEV_VERSION_INFO_S, *LPNETDEV_VERSION_INFO_S;



/**
 * @struct tagNETDEVXWDecodeInfo
 * @brief ڽϢ
 * @attention
 */
typedef struct tagNETDEVXWDecodeInfo
{
    UINT32         udwTvWallID;                               /* ǽID*/
    CHAR           szTVWallCode[NETDEV_LEN_64];               /* ǽ루ѡֶΣ豸˷䣬ַȷΧ[1,64] */
    UINT32         udwWndID;                                  /* ID*/
    UINT32         udwWndIndex;                               /* */
    UINT32         udwPaneID;                                 /* */
    UINT32         udwChnCode;                                /* ͨ룬0x01000100ʾһƵͨΪ2豸ĵ1λĵ1Ƶͨ*/
    UINT32         udwStreamStatus;                           /* ״̬ μö NETDEV_XW_WND_STREAM_STATUS_E */
    CHAR           szCameraCode[NETDEV_LEN_64];               /* */
    CHAR           szCameraIP[NETDEV_LEN_64];                 /* ַ [0,64]*/
    CHAR           szSourceAddress[NETDEV_LEN_64];            /* Դַ [0,64]*/
    UINT32         udwSourcePort;                             /* Դ˿*/
    CHAR           szDestAddress[NETDEV_LEN_64];              /* Ŀĵַdspַ[0,64]*/
    UINT32         udwDestPort;                               /* ĿĶ˿*/
    CHAR           szTransport[NETDEV_LEN_16];                /* ģʽ[0,16], 磺TCP*/
    NETDEV_XW_RESOLUTION_S stResolution;                      /* ֱʽڵ */
    UINT32         udwFrameRate;                              /* ֡*/
    CHAR           szVideoEncodeType[NETDEV_LEN_8];           /* ʽ[0,8], 磺H.264*/
    CHAR           szAudioEncodeType[NETDEV_LEN_8];           /* Ƶʽ[0,8], 磺G.711U*/
    CHAR           szFormatType[NETDEV_LEN_16];               /* װʽ[0,16], 磺RTP+PSPS*/
    FLOAT          fPacketDorpRate;                           /* Ӷʣʣ*/
    UINT32         udwPacketDropCnt;                          /* */
    UINT32         udwTotalPacketNum;                         /* ܰ*/
    BYTE           bRes[64];                                  /* Ԥֶ */
}NETDEV_XW_DECODE_INFO_S, *LPNETDEV_XW_DECODE_INFO_S;


/**
 * @enum tagNETDEVXWSerialCfgInfo
 * @brief XWIDϢ
 * @attention  None
 */
typedef struct tagNETDEVXWSerialCfgInfo
{
    UINT32      udwSerialID;                       /* ID */
    UINT32      udwSerialType;                     /*  μö NETDEV_XW_SERIAL_TYPE_E*/
    UINT32      udwIndex;                          /*  */
    UINT32      udwSerialMode;                     /* ģʽ μöNETDEV_XW_SERIAL_MODE_E*/
    UINT32      udwWorkMode;                       /* ģʽ RS232ڲЯ μöNETDEV_XW_SERIAL_MODE_E*/
    UINT32      udwBaudRate;                       /*  ȡֵΧ1200240048009600192003840057600115200*/
    UINT32      udwDataBits;                       /* λ ȡֵΧ5678*/
    UINT32      udwStopBits;                       /* ֹͣλ ȡֵΧ12*/
    UINT32      udwParity;                         /* Уλ μö NETDEV_XW_PARITY_TYPE_E*/
    UINT32      udwFlowCtrl;                       /* λ μö NETDEV_XW_PARITY_TYPE_E*/
    BYTE        byRes[128];                        /* Ԥֶ μö NETDEV_XW_FLOW_CTRL_E*/
}NETDEV_XW_SERIAL_CFG_INFO_S, *LPNETDEV_XW_SERIAL_CFG_INFO_S;

/**
 * @enum tagNETDEVXWSerialList
 * @brief XWIDб
 * @attention  None
 */
typedef struct tagNETDEVXWSerialList
{
    UINT32                          udwNum;                                     /*  */
    NETDEV_XW_SERIAL_CFG_INFO_S     stSerialCfgInfo[NETDEV_XW_SERIAL_NUM];      /*  μö NETDEV_XW_COM_TYPE_E*/
    BYTE                            byRes[128];                                 /* Ԥֶ */
}NETDEV_XW_DEVICE_SERIAL_LIST_S, *LPNETDEV_XW_DEVICE_SERIAL_LIST_S;

/*
* @struct tagNETDEVDiscoverCondInfo
* @brief 豸Ϣ
* @attention  None
*/
typedef struct tagNETDEVDiscoverCondInfo
{
    CHAR                szBeginIP[NETDEV_LEN_128];    /* ʼIPַ,ָʱΪ0 */
    CHAR                szEndIP[NETDEV_LEN_128];      /* IPַ,ָʱΪ0 */
    UINT32              udwServiceID;                 /* ID,Χ[0-255],0ʾֵӻ豸 */
    UINT32              udwAccessMode;                /* 뷽ʽμöNETDEV_DEVICE_ACCESS_MODE_E */
    BYTE                byRes[128];                   /*   Reserved */
}NETDEV_DISCOVER_COND_INFO_S, *LPNETDEV_DISCOVER_COND_INFO_S;

/*
* @struct tagNETDEVDeviceFindCond
* @brief ȡ豸Ϣ
* @attention  None
*/
typedef struct tagNETDEVDeviceFindCond
{
    UINT32              udwDeviceType;                  /* 豸 μöNETDEV_DEVICE_MAIN_TYPE_E */
    UINT32              udwServiceID;                   /* ID,Χ[0-255],0ʾֵӻ豸 */
    BYTE                byRes[128];                     /*   Reserved */
}NETDEV_DEVICE_FIND_COND_S, *LPNETDEV_DEVICE_FIND_COND_S;

/*
* @struct tagNETDEVDiscoverDeviceInfo
* @brief ֵ豸Ϣ
* @attention  None
*/
typedef struct tagNETDEVDiscoverDeviceInfo
{
    UINT32              udwDeviceType;                      /* 豸 μöNETDEV_DEVICE_MAIN_TYPE_E */
    UINT32              udwDeviceSubType;                   /* 豸 μöNETDEV_DEVICE_SUB_TYPE_E */
    UINT32              udwPort;                            /* ˿ */
    BOOL                bIsAdded;                           /* Ƿ,FALSEδӣTRUE */
    CHAR                szIPAddress[NETDEV_LEN_64];         /* IPַ */
    CHAR                szDevModel[NETDEV_LEN_64];          /* 豸ͺ */
    CHAR                szSerialNumber[NETDEV_LEN_64];      /* 豸к */
    CHAR                szFirmwareVersion[NETDEV_LEN_64];   /* 汾 */
    CHAR                szDevMac[NETDEV_LEN_64];            /* MACַ */
    CHAR                szManufacturer[NETDEV_LEN_64];      /* 豸 */
    CHAR                szUniCode[NETDEV_LEN_64];           /* 豸 */
    UINT32              udwProtocolType;                    /* ЭͣμöNETDEV_ACCESS_PROTOCOL_E */
    BYTE                byRes[128];                         /*   Reserved */
}NETDEV_DISCOVER_DEV_INFO_S, *LPNETDEV_DISCOVER_DEV_INFO_S;

typedef struct tagstNETDEVDevChnCommonInfo
{    
    UINT32 udwDevID;                                          /* 豸ID */
    UINT32 udwOrgID;                                          /* ֯ID */
    UINT32 udwChnIndex;                                       /* ͨ */
    CHAR  szDevName[NETDEV_LEN_256];                        /* 豸 */
    UINT32 udwRight;                                        /* ͨȨ */
    BYTE   byRes[128];                                      /* ֶ */
}NETDEV_DEV_CHN_COMMON_INFO_S, *LPNETDEV_DEV_CHN_COMMON_INFO_S;

/**
 * @brief ͨϢ
 * @attention
 */
typedef struct tagstNETDEVChnInfo
{    
    UINT32                          udwChannelID;               /* ͨID */
    CHAR                            szChnName[NETDEV_LEN_256];  /* ͨ */

    BYTE                            byRes[128];                 /* ֶ */
}NETDEV_CHN_INFO_S, *LPNETDEV_CHN_INFO_S;

/**
 * @struct tagNETDEVStreamFormatInfo
 * @brief ƵʽϢ
 * @attention
 */
typedef struct tagNETDEVStreamFormatInfo
{
    UINT32                           udwStreamIndex;             /* Ƶ ο NETDEV_LIVE_STREAM_INDEX_E */
    UINT32                           udwEncodeFormat;            /* ʽ ο NETDEV_VIDEO_CODE_TYPE_E */
    BYTE                             byRes[128];                 /* ֶ */
}NETDEV_STREAM_FORMAT_INFO_S, *LPNETDEV_STREAM_FORMAT_INFO_S;

/**
 * @struct tagstNETDEVDevVideoChnInfo
 * @brief 豸ƵͨϢ
 * @attention
 */
typedef struct tagstNETDEVDevVideoChnInfo
{    
    UINT32                           udwChannelID;                                  /* ͨID */
    CHAR                             szChnName[NETDEV_LEN_256];                     /* ͨ */
    UINT32                           udwChnStatus;                                  /* ͨ״̬, μ NETDEV_CHN_STATUS_E */
    CHAR                             szGBID[NETDEV_LEN_32];                         /* Դ */
    NETDEV_DEV_CHN_COMMON_INFO_S     stCommonInfo;                                  /* ͨϢ */
    UINT32                           udwMaxStream;                                  /* ֵ֧ */
    BOOL                             bSupportPTZ;                                   /* Ƿ̨֧ */
    UINT32                           udwAudioResID;                                 /* ƵԴID */
    LPNETDEV_STREAM_FORMAT_INFO_S    pastStreamFormatList;                          /* ýʽб,趯̬ڴ */

    BYTE                             byRes[124];                                    /* ֶ */
}NETDEV_VIDEO_CHN_INFO_S, *LPNETDEV_VIDEO_CHN_INFO_S;

/**
 * @struct tagstNETDEVVideoChnFindCond
 * @brief ƵͨϢб
 * @attention
 */
typedef struct tagstNETDEVVideoChnFindCond
{    
    UINT32                           udwDevID;                /* 豸ID */
    UINT32                           udwOrgID;                /* ֯ID */
    UINT32                           udwLimit;                /* ÿβѯΧ[1,500] */
    UINT32                           udwOffset;               /* ʼѯţ0ʼ */
    UINT32                           udwFindType;             /* ģʽμNETDEV_VIDEO_CHN_FIND_TYPE_E */
    
    BYTE                            byRes[128];             /* ֶ */
}NETDEV_VIDEO_CHN_FIND_COND_S, *LPNETDEV_VIDEO_CHN_FIND_COND_S;

/**
 * @struct tagstNETDEVOrgFindCond
 * @brief ֯Ϣб
 * @attention
 */
typedef struct tagstNETDEVOrgFindCond
{    
    UINT32                           udwOrgType;              /* ֯ μNETDEV_ORG_TYPE_E */
    UINT32                           udwRootOrgID;            /* ڵ֯ID */
    UINT32                           udwFindType;             /* ģʽμNETDEV_ORG_FIND_MODE_E */
    
    BYTE                            byRes[128];             /* ֶ */
}NETDEV_ORG_FIND_COND_S, *LPNETDEV_ORG_FIND_COND_S;

/**
* @struct tagstNETDEVModifyDevInfo
* @brief ޸豸Ϣ
* @attention
*/
typedef struct tagstNETDEVModifyDevInfo
{
    UINT32                            udwID;                              /* 豸ID */
    CHAR                              szDevName[NETDEV_LEN_64];           /* 豸 */
    NETDEV_IPADDR_INFO_S              stDevIPAddress;                     /* IPַ */
    CHAR                              szLoginName[NETDEV_LEN_64];         /* ¼û */
    CHAR                              szPasswd[NETDEV_LEN_64];            /* ¼룬޸Ľ¼ʱΪ"" */
    UINT32                            udwAccessProtocol;                  /* Э μöNETDEV_ACCESS_PROTOCOL_E */
    UINT32                            udwDevSubType;                      /* 豸ͣμöNETDEV_DEVICE_SUB_TYPE_E */
    UINT32                            udwServerID;                        /* IDΧ[0,255] */
    UINT32                            udwOrgID;                           /* ֯ */
    CHAR                              szDescription[NETDEV_LEN_256];      /* 豸 */
    NETDEV_ONVIF_INFO_S               stOnvifInfo;                        /* onvifϢ */
    NETDEV_GBINFO_S                   stGBInfo;                           /* Ϣ */
    UINT32                            uwdIsPTZNeeded;                     /*  0:  Ҫ 1:  Ҫ 255: Ӧ */
    UINT32                            udwDeviceType;                      /* 豸 ο NETDEV_DEVICE_MAIN_TYPE_E */
    UINT32                            udwCustomProtocolID;                /* ԶЭIDudwAccessProtocolֵΪ4ʱѡѡ32 */
    LPNETDEV_IPM_PLAYER_BASIC_INFO_S  pstPlayerInfo;                      /* źϢ TypeΪ11ʱѡ Ҫmallocڴ */
    UINT32                            udwChlMaxNum;                       /* 豸ͨAccessProtocolֵΪ4ʱýڵѡ */
    UINT32                            udwChlIndexNum;                     /* 豸ͨAccessProtocolֵΪ4ʱýڵѡ256 */
    UINT32*                           pudwChlIndexList;                   /* ͨб趯̬ڴ */
    BYTE                              byRes[100];                         /* ֶ  Reserved field*/
}NETDEV_MODIFY_DEV_INFO_S, *LPNETDEV_MODIFY_DEV_INFO_S;

/**
* @struct tagstNETDEVAddDevBasicInfo
* @brief 豸Ϣ
* @attention
*/
typedef struct tagstNETDEVAddDevBasicInfo
{    
    UINT32                            udwReqSeq;                          /* ţΧ[1, 50]ֶλڷؽд */
    CHAR                              szDevName[NETDEV_LEN_64];           /* 豸 */
    NETDEV_IPADDR_INFO_S              stDevIPAddress;                     /* IPַ */
    CHAR                              szLoginName[NETDEV_LEN_64];         /* ¼û */
    CHAR                              szPasswd[NETDEV_LEN_64];            /* ¼룬޸Ľ¼ʱΪ"" */
    UINT32                            udwAccessProtocol;                  /* Э μöNETDEV_ACCESS_PROTOCOL_E */
    UINT32                            udwDevType;                         /* 豸ͣμöNETDEV_DEVICE_MAIN_TYPE_E */
    UINT32                            udwDevSubType;                      /* 豸ͣμöNETDEV_DEVICE_SUB_TYPE_E */
    UINT32                            udwServerID;                        /* IDΧ[0,255] */
    UINT32                            udwOrgID;                           /* ֯ */
    CHAR                              szDescription[NETDEV_LEN_256];      /* 豸 */
    NETDEV_ONVIF_INFO_S               stOnvifInfo;                        /* onvifϢ */
    NETDEV_GBINFO_S                   stGBInfo;                           /* Ϣ */
    UINT32                            udwIsPTZNeeded;                     /* ǷҪ̨ 0:  Ҫ 1:  Ҫ 255:  Ӧ */
    CHAR                              szSN[NETDEV_LEN_32];                /* 豸кţTypeΪ9SubTypeΪ7ʱЯַȷΧ[1,20] */
    CHAR                              szIMEI[NETDEV_LEN_32];              /* ƶ豸ʶ룬TypeΪ9SubTypeΪ8ʱЯ,ַȷΧ[1,16] */
    CHAR                              szDeviceCode[NETDEV_LEN_32];        /* 豸 [1,32] Ӳźʱѡ  */
    UINT32                            udwCustomProtocolID;                /* ԶЭIDudwAccessProtocolֵΪ4ʱѡѡ32 */
    LPNETDEV_IPM_PLAYER_BASIC_INFO_S  pstPlayerInfo;                      /* źϢ TypeΪ11ʱѡ Ҫmallocڴ */
    UINT32                            udwChlMaxNum;                       /* 豸ͨAccessProtocolֵΪ4ʱýڵѡ */
    UINT32                            udwChlIndexNum;                     /* 豸ͨAccessProtocolֵΪ4ʱýڵѡ256 */
    UINT32*                           pudwChlIndexList;                   /* ͨб趯̬ڴ */
    BYTE                              byRes[12];                          /* ֶ  Reserved field*/
}NETDEV_ADD_DEV_BASIC_INFO_S, *LPNETDEV_ADD_DEV_BASIC_INFO_S;

/**
 * @struct tagstNETDEVXWAddDevInfo
 * @brief 豸Ϣб
 * @attention
 */
typedef struct tagstNETDEVXWAddDevInfo
{
    UINT32                              udwNum;                     /* 豸 */
    UINT32                              udwDevType;                 /* 豸ͣμö NETDEV_DEVICE_MAIN_TYPE_E */
    LPNETDEV_ADD_DEV_BASIC_INFO_S       pstAddDevBasicInfoList;     /* 豸Ϣбָ룬ݴ豸ڴɵά */

    BYTE                                byRes[128];                 /* ֶ  Reserved field */
}NETDEV_ADD_DEV_INFO_S, *LPNETDEV_ADD_DEV_INFO_S;

/**
 * @struct tagNETDEVBatchOperatorInfo
 * @brief Ϣ ṹ嶨 Device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVBatchOperatorInfo
{
    UINT32   udwReqSeq;                          /*  */
    UINT32   udwResultCode;                      /* ش,ز# NETDEV_PERSON_MONITOR_OPT_RES_CODE_E */
    UINT32   udwID;                              /*  */
    CHAR     szName[NETDEV_LEN_260];             /* ԱƣȷΧ[1,63] */
    BYTE     byRes[128];                         /* ֶ  Reserved */
}NETDEV_BATCH_OPERATOR_INFO_S,*LPNETDEV_BATCH_OPERATOR_INFO_S;

/**
 * @struct tagstNETDEVXWAddDevResultInfo
 * @brief 豸Ϣ
 * @attention
 */
typedef struct tagstNETDEVXWAddDevResultInfo
{    
    UINT32 udwStatus;                                               /* Ӧ״̬Ͳμ NETDEV_ORG_RESPONSE_STAUTE_E */
    UINT32 udwNum;                                                  /* Ӧ */
    LPNETDEV_BATCH_OPERATOR_INFO_S pstResultInfoList;               /* ӷϢ豸̬ */

    BYTE  byRes[128];                                               /* ֶ  Reserved field */
}NETDEV_ADD_DEV_RESULT_INFO_S, *LPNETDEV_ADD_DEV_RESULT_INFO_S;

/**
 * @struct tagstNETDEVDelDevInfo
 * @brief ɾ豸ϸϢ
 * @attention
 */
typedef struct tagstNETDEVDelDevInfo
{    
    UINT32 udwDevNum;                                         /* 豸 */
    UINT32 udwDevType;                                        /* 豸ͣμöNETDEV_DEVICE_MAIN_TYPE_E */
    UINT32 *pudwIDs;                                          /* Ҫɾ豸IDdwDevNum ̬ */
    BYTE  byRes[128];                                         /* ֶ  Reserved field*/
}NETDEV_DEL_DEV_INFO_S, *LPNETDEV_DEL_DEV_INFO_S;

/**
 * @struct tagstNETDEVDelDevResultInfo
 * @brief ɾ豸Ϣ
 * @attention
 */
typedef struct tagstNETDEVDelDevResultInfo
{
    UINT32 udwNum;                                              /* Ӧ */
    LPNETDEV_OPERATE_INFO_S pstResultInfoList;                  /* ɾϢɾ豸̬ */

    BYTE  byRes[128];                                           /* ֶ  Reserved field */
}NETDEV_DEL_DEV_RESULT_INFO_S, *LPNETDEV_DEL_DEV_RESULT_INFO_S;


/************************************************************************/
/*                           ۽                        */
/************************************************************************/
/**
 * @struct tagNETDEVACSFaceImage
 * @brief ͼƬϢ
 * @attention
 */
typedef struct tagNETDEVACSFaceImage
{
    UINT32               udwNum;                            /* Ƭ */
    NETDEV_FILE_INFO_S   stImageList[NETDEV_LEN_16];        /* Ƭб */
    UINT32               udwMajorImageIndex;                /* Ƭ */

    BYTE                 byRes[128];                        /* ֶ */
}NETDEV_ACS_FACE_IMAGE_S, *LPNETDEV_ACS_FACE_IMAGE_S;

/**
 * @struct tagNETDEVACSStaffInfo
 * @brief ԱϢ
 * @attention
 */
typedef struct tagNETDEVACSStaffInfo
{
    CHAR     szNumber[NETDEV_LEN_16];                               /* Ա */
    CHAR     szBirthday[NETDEV_FACE_MEMBER_BIRTHDAY_LEN];           /*  */
    CHAR     szDeptName[NETDEV_LEN_260];                            /* */
    UINT32   udwDeptID;                                             /* ID */

    BYTE     byRes[128];                                            /* ֶ */
}NETDEV_ACS_STAFF_INFO_S, *LPNETDEV_ACS_STAFF_INFO_S;

 /**
 * @struct tagACSTimeSection
 * @brief ʱϢ
 * @attention
 */
typedef struct tagACSTimeSection
{
    INT64   tStartTime;                                      /* ʼʱ UTCʱ λs */
    INT64   tEndTime;                                        /* ʱ UTCʱ λs */

    BYTE    byRes[32];                                       /* ֶ */
}NETDEV_ACS_TIME_SECTION_S, *LPNETDEV_ACS_TIME_SECTION_S;

 /**
 * @struct tagNETDEVACSVisitorInfo
 * @brief ÿϢ
 * @attention
 */
typedef struct tagNETDEVACSVisitorInfo
{
    CHAR   szVisitorCompany[NETDEV_LEN_260];       /* ÿ͹˾ [1,64]ַ */
    UINT32 udwVisitorCount;                        /* ÿ */
    UINT32 udwIntervieweeID;                       /* ID */
    CHAR   szIntervieweeName[NETDEV_LEN_260];      /*  [1,64]ַ */
    CHAR   szIntervieweeDept[NETDEV_LEN_260];      /* ߲ [1,64]ַ */
    NETDEV_ACS_TIME_SECTION_S   tScheduleTime;     /* ԤԼʱ */
    NETDEV_ACS_TIME_SECTION_S   tRealTime;         /* ʵʵʱ */
    UINT32 udwStatus;                              /* ״̬ μöNETDEV_ACS_VISIT_STATUS_E */

    BYTE   byRes[128];                             /* ֶ */
}NETDEV_ACS_VISITOR_INFO_S, *LPNETDEV_ACS_VISITOR_INFO_S;


/**
 * @struct tagACSPersonCard
 * @brief ԱŽϢ
 * @attention
 */
typedef struct tagACSPersonCard
{
    UINT32                      udwCardID;                      /* ID */
    UINT32                      udwCardType;                    /* Ƭ */
    UINT32                      udwCardStatus;                  /* Ƭ״̬  0:հ 1: 2: 3:ע  */
    CHAR                        szCardNo[NETDEV_LEN_64];        /*  */
    UINT32                      udwReqSeq;                      /*  */
    NETDEV_ACS_TIME_SECTION_S   stValidTime;                    /* Чʱ */


    BYTE                        byRes[256];                     /* ֶ */
}NETDEV_ACS_PERSON_CARD_INFO_S,* LPNETDEV_ACS_PERSON_CARD_INFO_S;

/**
 * @struct tagNETDEVACSPersonInfo
 * @brief ŽԱϢ
 * @attention
 */
typedef struct tagNETDEVACSPersonInfo
{
    UINT32                          udwReqSeq;                          /*  */
    UINT32                          udwPersonID;                        /* Ա */
    CHAR                            szName[NETDEV_LEN_260];             /*  */
    UINT32                          udwGender;                          /* Ա μö NETDEV_GENDER_TYPE_E*/
    NETDEV_FACE_MEMBER_ID_INFO_S    stMemberIDInfo;                     /* ֤Ϣ */
    CHAR                            szTelephone[NETDEV_LEN_64];         /* ϵ绰 */
    CHAR                            szAddress[NETDEV_LEN_260];          /* ַ */
    CHAR                            szDesc[NETDEV_LEN_480];             /* ע */

    UINT32                          udwCardNum;                         /* ŽȡֵΧ[1,6] */
    NETDEV_ACS_PERSON_CARD_INFO_S   stACSPersonCardList[NETDEV_LEN_6];    /* ŽϢ */
    NETDEV_ACS_FACE_IMAGE_S         stFaceImage;                        /* ͼƬ */
    UINT32                          udwType;                            /* Ա  μNETDEV_ACS_PERSON_TYPE_E*/
    NETDEV_ACS_STAFF_INFO_S         stStaffInfo;                        /* ԱϢ */
    NETDEV_ACS_VISITOR_INFO_S       stVisitor;                          /* ÿϢ */
    BYTE                            byRes[256];                         /* ֶ */
}NETDEV_ACS_PERSON_INFO_S, *LPNETDEV_ACS_PERSON_INFO_S;

/**
 * @struct tagNETDEVACSPersonList
 * @brief Աб
 * @attention
 */
typedef struct tagNETDEVACSPersonList
{
    UINT32                      udwNum;                 /* Ա */
    LPNETDEV_ACS_PERSON_INFO_S  pstPersonInfoList;      /* ԱϢб udwNum̬*/
    BYTE                        byRes[128];             /* ֶ */
}NETDEV_ACS_PERSON_LIST_S, *LPNETDEV_ACS_PERSON_LIST_S;

/**
 * @struct tagNETDEVFaceBatchInfo
 * @brief ʶģϢ ṹ嶨 Device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVFaceBatchInfo
{
    UINT32   udwReqSeq;         /*  */
    UINT32   udwResultCode;     /* ش */
    UINT32   udwID;             /*  */
    BYTE    byRes[128];         /* ֶ  Reserved */
}NETDEV_FACE_BATCH_INFO_S,*LPNETDEV_FACE_BATCH_INFO_S;

/**
 * @struct tagNETDEVFaceBatchList
 * @brief ʶģб ṹ嶨 
 * @attention  None
 */
typedef struct tagNETDEVFaceBatchList
{
    UINT32                      udwNum;         /*  */
    LPNETDEV_FACE_BATCH_INFO_S  pstBatchList;   /* Ϣ udwNumж̬ */
    BYTE                        byRes[128];     /* ֶ  Reserved */
}NETDEV_FACE_BATCH_LIST_S,*LPNETDEV_FACE_BATCH_LIST_S;

/**
 * @struct tagNETDEVACSPersonBaseInfo
 * @brief ŽԱϢ
 * @attention
 */
typedef struct tagNETDEVACSPersonBaseInfo
{
    UINT32                          udwPersonID;                    /* Ա */
    CHAR                            szName[NETDEV_LEN_260];         /*  */
    UINT32                          udwGender;                      /* Ա μö NETDEV_GENDER_TYPE_E*/
    NETDEV_FACE_MEMBER_ID_INFO_S    stMemberIDInfo;                 /* ֤Ϣ */
    CHAR                            szTelephone[NETDEV_LEN_64];     /* ϵ绰 */
    UINT32                          udwCardID;                      /* Ƭ */
    CHAR                            szCardNo[NETDEV_LEN_16];        /* Ƭ*/
    UINT32                          udwType;                        /* Ա  0Ա  1ÿ*/
    NETDEV_ACS_STAFF_INFO_S         stStaffInfo;                    /* ԱϢ */
    NETDEV_ACS_VISITOR_INFO_S       stVisitor;                      /* ÿϢ */
    BYTE                            byRes[256];                     /* ֶ */
}NETDEV_ACS_PERSON_BASE_INFO_S, *LPNETDEV_ACS_PERSON_BASE_INFO_S;

/**
 * @struct tagNETDEVACSPersonQueryCond
 * @brief ŽԱϢѯ
 * @attention
 */
typedef struct tagNETDEVACSPersonQueryCond
{
    CHAR     szName[NETDEV_LEN_260];                         /*  */
    CHAR     szNumber[NETDEV_FACE_IDNUMBER_LEN];             /* ֤ */
    UINT32   udwType;                                        /* Ա  0Ա  1ÿ*/
    UINT32   udwOffset;                                      /* ӵǰſʼѯ Ŵ0ʼ*/
    UINT32   udwLimit;                                       /* ÿβѯΪ200 */

    BYTE     byRes[128];                                     /* ֶ */
}NETDEV_ACS_PERSON_QUERY_COND_S, *LPNETDEV_ACS_PERSON_QUERY_COND_S;

/**
 * @struct tagNETDEVBatchOperateBasicInfo
 * @brief ѯصĻϢ ṹ嶨 Device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVBatchOperateBasicInfo
{
    UINT32   udwTotal;       /*  */
    UINT32   udwOffset;      /* ѯʼ */
    UINT32   udwNum;         /* ѯ */
    BYTE     byRes[128];     /* ֶ  Reserved */
}NETDEV_BATCH_OPERATE_BASIC_S,*LPNETDEV_BATCH_OPERATE_BASIC_S;


/**
 * @struct tagNETDEVACSPersonPermissionInfo
 * @brief ԱȨϢ
 * @attention
 */
typedef struct tagNETDEVACSPersonPermissionInfo
{
    NETDEV_OPERATE_LIST_S        stPersonList;                    /* ȨԱIDб */
    UINT32                       udwTemplateID;                   /* ʱģID  ԱȨʱЯ*/
    NETDEV_ACS_TIME_SECTION_S    stValidTime;                     /* Чʱ䣬ÿȨʱЯ */
    NETDEV_OPERATE_LIST_S        stDoorList;                      /* ȨͨбͨȨʱЯ */
    NETDEV_OPERATE_LIST_S        stDoorGroupList;                 /* ȨбȨʱЯ */
    BYTE                         byRes[256];                      /* ֶ */
}NETDEV_ACS_PERSON_PERMISSION_INFO_S, *LPNETDEV_ACS_PERSON_PERMISSION_INFO_S;


/**
 * @struct tagNETDEVACSPermissionGroupInfo
 * @brief ȨϢ
 * @attention
 */
typedef struct tagNETDEVACSPermissionGroupInfo
{
    UINT32                       udwPermissionGroupID ;                  /* ȨID */
    CHAR                         szPermissionGroupName[NETDEV_LEN_260];  /* Ȩ */

    BYTE                         byRes[256];                             /* ֶ */
}NETDEV_ACS_PERMISSION_GROUP_INFO_S, *LPNETDEV_ACS_PERMISSION_GROUP_INFO_S;

/**
 * @struct tagNETDEVACSDoorPermissionInfo
 * @brief ȨϢ
 * @attention
 */
typedef struct tagNETDEVACSDoorPermissionInfo
{
    UINT32                                  udwPermissionNum;                  /* Ȩ */
    NETDEV_ACS_TIME_SECTION_S               stValidTime;                       /* Чʱ */
    LPNETDEV_ACS_PERMISSION_GROUP_INFO_S    pstPermissionGroupList;            /* ȨϢб.NumΪ0ʱѡ */
    BYTE                                    byRes[256];                         /* ֶ */
}NETDEV_ACS_DOOR_PERMISSION_INFO_S, *LPNETDEV_ACS_DOOR_PERMISSION_INFO_S;

/**
 * @struct tagNETDEVACSPermissionInfo
 * @brief ȨϢ
 * @attention
 */
typedef struct tagNETDEVACSPermissionInfo
{
    UINT32                       udwPermissionID;                   /* ȨID     */
    CHAR                         szPermissionName[NETDEV_LEN_260];  /* Ȩ */
    UINT32                       udwPermissionType;                 /* Ȩͣ0ʾԱȨ飬1ʾÿȨ */
    NETDEV_OPERATE_LIST_S        stPersonList;                      /* ԱIDбdwSizeΪԱ*/
    UINT32                       udwTemplateID;                     /* ʱģID */
    NETDEV_ACS_TIME_SECTION_S    stValidTime;                       /* Чʱ */
    NETDEV_OPERATE_LIST_S        stDoorList;                        /* ͨб, dwSizeΪͨ*/
    
    BYTE                         byRes[256];                      /* ֶ */
}NETDEV_ACS_PERMISSION_INFO_S, *LPNETDEV_ACS_PERMISSION_INFO_S;

/**
 * @struct tagNETDEVACSPersonBlacklistInfo
 * @brief Ϣ
 * @attention
 */
typedef struct tagNETDEVACSPersonBlacklistInfo
{
    UINT32                               udwBlackListID;                    /* ID */
    NETDEV_FACE_MEMBER_ID_INFO_S         stIdentificationInfo;               /* Ϣ */

    BYTE                                byRes[256];                        /* ֶ */
}NETDEV_ACS_PERSON_BLACKLIST_INFO_S, *LPNETDEV_ACS_PERSON_BLACKLIST_INFO_S;



/**
 * @struct tagNETDEVACSPersonPermissionBasicInfo
 * @brief ԱȨϢ
 * @attention
 */
typedef struct tagNETDEVACSPersonPermissionBasicInfo
{
    UINT32   udwPermissionID;                    /* Ȩޱ */
    UINT32   udwPersonID;                        /* Ա */
    CHAR     szPersonName[NETDEV_LEN_260];       /* Ա */
    CHAR     szPersonNumber[NETDEV_LEN_16];      /* Ա */
    UINT32   udwDeptID;                          /* ű */
    CHAR     szDeptName[NETDEV_LEN_260];         /*  */
    UINT32   udwTemplateID;                      /* ģID */
    CHAR     szTemplateName[NETDEV_LEN_260];     /* ģ */
    UINT32   udwCardID;                          /*  Ѱ󶨿ʱЯ*/
    CHAR     szCardNo[NETDEV_LEN_64];            /*  */
    UINT32   udwCardStatus;                      /* ״̬*/
    UINT32   udwAuthStatus;                      /* Ȩ״̬ 0δȨ  1Ȩ*/
    BYTE     byRes[256];                         /* ֶ */
}NETDEV_ACS_PERSON_PERMISSION_BASIC_INFO_S, *LPNETDEV_ACS_PERSON_PERMISSION_BASIC_INFO_S;

/**
 * @struct tagNETDEVPermissionGroupInfo
 * @brief ȨϢ
 * @attention
 */
typedef struct tagNETDEVPermissionGroupInfo
{
    UINT32 udwPermissionGroupID;                                   /* PermissionGroupID */
    CHAR   szPermissionGroupName[NETDEV_LEN_260];                  /* Ȩ */
    BYTE   byRes[256];                                              /* ֶ */
}NETDEV_PERMISSION_GROUP_INFO_S, *LPNETDEV_PERMISSION_GROUP_INFO_S;

/**
 * @struct tagNETDEVFaceAttr
 * @brief Ϣ
 * @attention  None
 */
typedef struct tagNETDEVFaceAttr
{
    UINT32 udwGender;                                     /* Ա  NETDEV_GENDER_TYPE_E */
    UINT32 udwAgeRange;                                   /*   NETDEV_AGE_RANGE_E */
    UINT32 udwEthicCode;                                  /*   NETDEV_ETHIC_CODE_E */
    UINT32 udwGlassFlag;                                  /* Ƿ۾־  NETDEV_GLASS_FLAG_E */
    UINT32 udwGlassesStyle;                               /* ۾ʽ  NETDEV_GLASSES_STYLE_E */
    UINT32 udwMaskFlag;                                   /* Ƿ δʱѡ  NETDEV_MASK_FLAG_E */
    FLOAT  fTemperature;                                  /* Ա λ϶ */
    BYTE   byRes[120];                                    /* ֶ */
}NETDEV_FACE_ATTR_S,*LPNETDEV_FACE_ATTR_S;

/**
 * @struct tagNETDEVCompareInfo
 * @brief ԱϢ
 * @attention
 */
typedef struct tagNETDEVCompareInfo
{
    NETDEV_FILE_INFO_S  stPersonImage;                    /* ԱͼƬ */
    NETDEV_FILE_INFO_S  stSnapshotImage;                  /* ץͼƬ */
    BYTE                byRes[128];                       /* ֶ */
}NETDEV_COMPARE_INFO_S, *LPNETDEV_COMPARE_INFO_S;

/**
 * @struct tagNETDEVACSAttendanceLogInfo
 * @brief ¼Ϣ
 * @attention
 */
typedef struct tagNETDEVACSAttendanceLogInfo
{
    UINT32 udwAlarmType;                    /* 澯 */
    INT64  tTimeStamp;                      /* 澯ʱ */
    CHAR   szDoorName[NETDEV_LEN_260];      /*  */
    CHAR   szDoorNo[NETDEV_LEN_64];         /* ű */
    UINT32 udwDoorDirect;                   /*  0:,1: */
    CHAR   szCardNo[NETDEV_LEN_64];         /* ˢ*/
    CHAR   szPersonName[NETDEV_LEN_260];    /* ˢ */
    UINT32 udwPersonType;                   /* Ա  μNETDEV_ACS_PERSON_TYPE_E*/
    CHAR   szPersonPhone[NETDEV_LEN_64];    /* ˢ˵绰 */
    CHAR   szPersonDept[NETDEV_LEN_260];    /* ˢ˲ */
    NETDEV_COMPARE_INFO_S stCompareInfo;    /* ԱϢͨŻЯϢ */
    NETDEV_FACE_ATTR_S    stFaceAttr;       /* Ϣ */
    BYTE   byRes[104];                      /* ֶ */
}NETDEV_ACS_ATTENDANCE_LOG_INFO_S, *LPNETDEV_ACS_ATTENDANCE_LOG_INFO_S;

 /**
 * @struct tagACSVisitLogInfo
 * @brief ÿͼ¼Ϣ
 * @attention
 */
typedef struct tagACSVisitLogInfo
{
    UINT32 udwLogID;                                /* ID */
    UINT32 udwVisitorID;                            /* ÿID */
    CHAR   szVisitorName[NETDEV_LEN_260];           /* ÿ [1,64]ַ */
    CHAR   szVisitorCompany[NETDEV_LEN_260];        /* ÿ͹˾ [1,64]ַ */
    CHAR   szVisitorPhone[NETDEV_LEN_64];           /* ÿ͵绰 */
    CHAR   szCardNo[NETDEV_LEN_16];                 /* ÿͿ */
    UINT32 udwIntervieweeID;                        /* ID */
    CHAR   szIntervieweeName[NETDEV_LEN_260];       /*  [1,64]ַ */
    CHAR   szIntervieweeDept[NETDEV_LEN_260];       /* ߲ [1,64]ַ */
    INT64  tScheduleStartTime;                      /* ԤԼʱ UTCʱ λs */
    INT64  tRealStartTime;                          /* ʵʱ UTCʱ λs */
    UINT32 udwStatus;                               /* ״̬ μöNETDEV_ACS_VISIT_STATUS_E */
    BYTE   byRes[256];                              /* ֶ */
}NETDEV_ACS_VISIT_LOG_INFO_S, *LPNETDEV_ACS_VISIT_LOG_INFO_S;


/**
 * @enum tagNETDEVAlarmActionType
 * @brief ı״̬
 * @attention
 */
typedef struct tagNETDEVSwitchOutputAlarmStatus
{
    UINT32 udwID;               /*  */
    INT32  dwAlarmStatus;       /* 澯״̬ */
    BYTE   bRes[32];            /* ֶ */
}NETDEV_ALARM_STATUS_S,* LPNETDEV_ALARM_STATUS_S;

/*************************************************************************************************************
************************************ȡͨбBegin******************************************************
***************************************************************************************************************/
/**
 * @struct tagstNETDEVDevChnBaseInfo
 * @brief 豸ͨϢ
 * @attention
 */
typedef struct tagstNETDEVDevChnBaseInfo
{    
    INT32 dwChannelID;                                      /* ͨID */
    INT32 dwDevID;                                          /* 豸ID */
    INT32 dwOrgID;                                          /* ֯ID */
    INT32 dwChnType;                                        /* ͨͣμ NETDEV_CHN_TYPE_E */
    INT32 dwChnStatus;                                      /* ͨ״̬, μ NETDEV_CHN_STATUS_E */
    INT32 dwChnIndex;                                       /* ͨ */
    CHAR szChnName[NETDEV_NAME_MAX_LEN];                    /* ͨ */
    UINT32 udwRight;                                        /* ͨȨ */
    BYTE   byRes[128];                                      /* ֶ */
}NETDEV_DEV_CHN_BASE_INFO_S, *LPNETDEV_DEV_CHN_BASE_INFO_S;

/**
 * @struct tagstNETDEVDevChnEncodeInfo
 * @brief 豸ͨϢ
 * @attention
 */
typedef struct tagstNETDEVDevChnEncodeInfo
{
    NETDEV_DEV_CHN_BASE_INFO_S  stChnBaseInfo;                                  /* ͨϢ */
    INT32                       dwMaxStream;                                    /* ֵ֧ */
    NETDEV_STREAM_FORMAT_INFO_S astStreamFormatList[NETDEV_STREAM_MAX_NUM];     /* ýʽб */
    BOOL                        bSupportPTZ;                                    /* Ƿ̨֧ */
    BOOL                        bScrambleEnable;                                /* Ƿʹ */
    INT32                       dwAudioResID;                                   /* ƵԴID */
    CHAR                        szGBResID[NETDEV_LEN_32];                                      /* ԴID */
    BYTE                        byRes[224];                                     /* ֶ */
}NETDEV_DEV_CHN_ENCODE_INFO_S, *LPNETDEV_DEV_CHN_ENCODE_INFO_S;

/**
 * @struct tagQueryCondition
 * @brief ѯͨϢṹ
 * @attention
 */
typedef struct tagQueryCondition
{
    INT32                   dwLimit;
    INT32                   dwOffset;

    INT32                   dwQryInfoNum;
    LPNETDEV_QUERY_INFO_S   pstQueryInfo;
    INT32                   dwRecursion;

    BYTE   byRes[260];                                          /* ֶ */
}NETDEV_QUERY_CHN_CONDITION_S, *LPNETDEV_QUERY_CHN_CONDITION_S;

/**
 * @struct tagstNETDEVDevChnDecodeInfo
 * @brief 豸ͨϢ
 * @attention
 */
typedef struct tagstNETDEVDevChnDecodeInfo
{    
    NETDEV_DEV_CHN_BASE_INFO_S      stChnBaseInfo;              /* ͨϢ */
    INT32 dwVideoFmtCapSize;                                    /* ʽѡ */
    INT32 adwVideoFormatCap[NETDEV_VIDEO_FORMAT_CAP_NUM];       /* ʽ μöNETDEV_DC_VIDEOFORMAT_E*/
    INT32 dwLayoutCapSize;                                      /* ѡ */
    INT32 adwLayoutCap[NETDEV_LAYOUT_CAP_NUM];                  /*  */
    INT32 dwResolutionDefault;                                  /* ĬϷֱʽ μöNETDEV_DC_VIDEOFORMAT_E */

    BYTE   byRes[260];                                          /* ֶ */
}NETDEV_DEV_CHN_DECODE_INFO_S, *LPNETDEV_DEV_CHN_DECODE_INFO_S;

/**
 * @struct tagstNETDEVDevChnAlarmOutInfo
 * @brief 澯ͨϢ
 * @attention
 */
typedef struct tagstNETDEVDevChnAlarmOutInfo
{
    NETDEV_DEV_CHN_BASE_INFO_S  stChnBaseInfo;    /* ͨϢ */
    INT32                       dwRunMode;        /* ģʽ/գμ#NETDEV_ALARM_STATUS_E */
    INT32                       dwDuration;       /* ʱ䣺(ms) */
    UINT32                      udwRelayMode;     /* мģʽ 1̬ 2˫̬ */
    UINT32                      udwAlarmOutputNum;/*  */
    BYTE                        byRes[252];       /* ֶ */
}NETDEV_DEV_CHN_ALARMOUT_INFO_S, *LPNETDEV_DEV_CHN_ALARMOUT_INFO_S;

/**
 * @struct tagstNETDEVDevChnAlarmInInfo
 * @brief 澯ͨϢ
 * @attention
 */
typedef struct tagstNETDEVDevChnAlarmInInfo
{
    NETDEV_DEV_CHN_BASE_INFO_S  stChnBaseInfo;  /* ͨϢ */
    INT32                       dwRunMode;      /* ģʽ/գμ#NETDEV_ALARM_STATUS_E */
    BOOL                        bEnable;        /* ʹܿأʹܿ/ʹܹأ */
    BYTE                        byRes[260];     /* ֶ */
}NETDEV_DEV_CHN_ALARMIN_INFO_S, *LPNETDEV_DEV_CHN_ALARMIN_INFO_S;

/**
 * @struct tagstNETDEVDevChnAudioInfo
 * @brief ƵͨϢ
 * @attention
 */
typedef struct tagstNETDEVDevChnAudioInfo
{
    NETDEV_DEV_CHN_BASE_INFO_S      stChnBaseInfo;         /* ͨϢ */
    INT32                           dwAssociatedResID;     /* ƵͨĹԴID */

    BYTE   byRes[256];                                      /* ֶ */
}NETDEV_DEV_CHN_AUDIO_INFO_S, *LPNETDEV_DEV_CHN_AUDIO_INFO_S;

/**
 * @struct tagstNETDEVDevChnDaInfo
 * @brief 豸ͨϢ(Ž)
 * @attention
 */
typedef struct tagstNETDEVDevChnDaInfo
{    
    NETDEV_DEV_CHN_BASE_INFO_S  stChnBaseInfo;                          /* ͨϢ */
    CHAR                        szPointCode[NETDEV_DA_POINT_CODE_LEN];  /* λű */
    CHAR                        szAreaCode[NETDEV_DA_AREA_CODE_LEN];    /*  */
    UINT32                      udwPointStatus;                         /* 澯λ״̬ο#NETDEV_ALARM_POINT_STATUS_TYPE_E ״̬ ο#NETDEV_DOOR_STATUS_TYPE_E */

    BYTE                        byRes[260];                             /* ֶ */
}NETDEV_DEV_CHN_DA_INFO_S, *LPNETDEV_DEV_CHN_DA_INFO_S;

/**
 * @struct tagstNETDEVDevChnXWEncodeInfo
 * @brief 豸XWźԴͨϢ
 * @attention
 */
typedef struct tagstNETDEVDevChnXWEncodeInfo
{
    NETDEV_DEV_CHN_BASE_INFO_S  stChnBaseInfo;  /* ͨϢ */
    INT32                       dwVideoSrc;     /* Ƶʽ NETDEV_VIDEO_SRC_TYPE_E */
    BYTE                        byRes[260];     /* ֶ */
}NETDEV_DEV_CHN_XW_ENCODE_INFO_S, *LPNETDEV_DEV_CHN_XW_ENCODE_INFO_S;


/**
 * @struct tagNETDEVEmergencyBellInfo
 * @brief Ϣ ṹ嶨
 * @attention  None
 */
typedef struct tagNETDEVEmergencyBellInfo
{
    UINT32   udwID;                                            /*  */
    BOOL     bEnable;                                          /* ʹܱ*/
    CHAR     szName[NETDEV_EMERGENCY_BRLL_NAME_LEN];           /*  ֧ */
    UINT32   udwRegionCode;                                    /*  */
    UINT32   udwDistrictCode;                                  /*  */
    UINT32   udwAddressCode;                                   /* ַ */
    BYTE     byRes[108];                                       /* ֶ */
}NETDEV_EMERGENCY_BELL_INFO_S, *LPNETDEV_EMERGENCY_BELL_INFO_S;

/**
 * @struct tagNETDEVEmergencyBellInfoList
 * @brief бϢ ṹ嶨
 * @attention  None
 */
typedef struct tagNETDEVEmergencyBellInfoList
{
    UINT32   udwNum;                                           /*  ûĽֽ׶ι̶NETDEV_EMERGENCY_BRLL_MAX_NUM*/
    LPNETDEV_EMERGENCY_BELL_INFO_S pstEmergencyBellList;       /*Ϣ ̬룬һNETDEV_EMERGENCY_BRLL_MAX_NUM*/

    BYTE     byRes[16];                                       /* ֶ */
}NETDEV_EMERGENCY_BELL_INFO_LIST_S, *LPNETDEV_EMERGENCY_BELL_INFO_LIST_S;


/**
 * @struct tagNETDEVPtzCapabilityInfo
 * @brief Ƶ̨ͨ ṹ嶨
 * @attention  None
 */
typedef struct tagNETDEVPtzCapabilityInfo
{
    BOOL   bIsSupportPtz;       /* Ƿ̨֧ 0֧ 1֧ */
    BOOL   bIsSupportTrack;     /* Ƿ֧¼Ѳ 0֧ 1֧ */

    BYTE   byRes[128];          /* ֶ */
}NETDEV_PTZ_CAPABILITY_INFO_S, *LPNETDEV_PTZ_CAPABILITY_INFO_S;

/**
 * @struct tagNETDEVVideoCapabilityInfo
 * @brief Ƶͨʵ ṹ嶨
 * @attention  None
 */
typedef struct tagNETDEVVideoCapabilityInfo
{
    BOOL   bIsSupportImageSettings;     /* Ƿֻ֧ 0֧ 1֧ */
    BOOL   bIsSupportCorrectCfg;        /* Ƿ֧ͼ 0֧ 1֧ */
    BOOL   bIsSupportEPTZ;              /* Ƿֵ̨֧ܸٹ 0֧ 1֧ */

    BYTE   byRes[120];                  /* ֶ */
}NETDEV_VIDEO_CAPABILITY_INFO_S, *LPNETDEV_VIDEO_CAPABILITY_INFO_S;

/**
 * @struct tagNETDEVPlayBackCapabilityInfo
 * @brief Ƶͨط ṹ嶨
 * @attention  None
 */
typedef struct tagNETDEVPlayBackCapabilityInfo
{
    BOOL   bIsSupportStep;      /* Ƿֵ֧֡ 0֧ 1֧ */
    BOOL   bIsSupportIntgVod;   /* Ƿ֧ܻط 0֧ 1֧ */

    BYTE   byRes[128];          /* ֶ */
}NETDEV_PLAYBACK_CAPABILITY_INFO_S, *LPNETDEV_PLAYBACK_CAPABILITY_INFO_S;

/**
 * @struct tagNETDEVSmartCapabilityInfo
 * @brief Ƶͨʵ ṹ嶨
 * @attention  None
 */
typedef struct tagNETDEVSmartCapabilityInfo
{
    BOOL   bIsSupportPassengerFlow;     /* Ƿֿ֧ͳ 0:֧ 1:֧ */
    BOOL   bIsVehicleDetection;         /* Ƿֳ֧ʶ 0:֧ 1:֧ */
    BOOL   bIsCrossLineSupported;       /* Ƿ֧Խ 0:֧ 1:֧ */
    BOOL   bIsIntrusionSupported;       /* Ƿ֧ 0:֧ 1:֧ */
    BOOL   bIsStructRecognitionSupport; /* Ƿ֧Ƶṹʶ 0֧ 1֧ */
    BOOL   bIsFaceRecognitionSupported; /* Ƿ֧ʶ 0: ֧ 1: ֧*/
    BOOL   bIsFaceDetectionSupported;   /* Ƿ֧⹦ 0: ֧ 1: ֧ */
    UINT32 udwSupportBoxDomeLinkage;    /* Ƿ֧ǹ  NETDEV_SUP_BOX_DOME_LINKAGE_E */
    UINT32 udwSupportAttrOverlay;       /* Ƿֽ֧ṹԵʾܣ0֧֣1֧ */
    BYTE   byRes[223];                  /* ֶ */
}NETDEV_SMART_CAPABILITY_INFO_S, *LPNETDEV_SMART_CAPABILITY_INFO_S;


/**
 * @struct tagNETDEVVideoDetailCapabilityInfo
 * @brief Ƶͨ ṹ嶨
 * @attention  None
 */
typedef struct tagNETDEVVideoDetailCapabilityInfo
{
    INT32                             dwChannelID;                     /* ͨID  */
    NETDEV_PTZ_CAPABILITY_INFO_S      stPtzCapabilityInfo;             /* ̨ */
    NETDEV_VIDEO_CAPABILITY_INFO_S    stVideoCapabilityInfo;           /* ʵ */
    NETDEV_PLAYBACK_CAPABILITY_INFO_S stPlayBackCapabilityInfo;        /* ط */
    NETDEV_SMART_CAPABILITY_INFO_S    stSmartCapabilityInfo;           /*  */
    BYTE                              byRes[128];                      /* ֶ */
}NETDEV_VIDEO_DETAIL_CAPABILITY_INFO_S, *LPNETDEV_VIDEO_DETAIL_CAPABILITY_INFO_S;

/**
 * @struct tagNETDEVDevSmartCapabilityInfo
 * @brief 豸 ṹ嶨
 * @attention  None
 */
typedef struct tagNETDEVDevSmartCapabilityInfo
{
    BOOL   bIsFaceRecognitionSupported;     /* Ƿ֧ʶ 0֧ 1֧ */
    BOOL   bIsFaceDetectionSupported;       /* Ƿ֧⹦ 0֧ 1֧ */
    BOOL   bIsVehicleRecognitionSupported;  /* Ƿֳ֧ʶ 0֧ 1֧ */

    BYTE   byRes[255];                      /* ֶ */
}NETDEV_DEV_SMART_CAPABILITY_INFO_S, *LPNETDEV_DEV_SMART_CAPABILITY_INFO_S;

 /**
 * @struct tagNETDEVDevCapabilityInfo
 * @brief 豸Ϣ ṹ嶨
 * @attention  None
 */
typedef struct tagNETDEVDevCapabilityInfo
{
    UINT32                              udwDevID;                          /* 豸ID  */
    NETDEV_DEV_SMART_CAPABILITY_INFO_S  stSmartCapabilityInfo;          /*  */
    BYTE                                byRes[256];                         /* ֶ */
}NETDEV_DEV_CAPABILITY_INFO_S, *LPNETDEV_DEV_CAPABILITY_INFO_S;


 /**
 * @struct tagNETDEVSystemCapabilityInfo
 * @brief ϵͳϢ ṹ嶨
 * @attention  None
 */
typedef struct tagNETDEVSystemCapabilityInfo
{
    UINT32  udwSize;                             /* ļС */
    CHAR    *pcData;                             /* ļ Size̬*/
    BYTE    byRes[256];                         /* ֶ */
}NETDEV_SYSTEM_CAPABILITY_INFO_S, *LPNETDEV_SYSTEM_CAPABILITY_INFO_S;

/**
 * @struct tagNETDEVVideoSnapCapInfo
 * @brief Ƶͨץͼ Snap parameter capability
 * @attention
 */
typedef struct tagNETDEVVideoSnapCapInfo
{
    BOOL bIsSupportSnapshotCfg;                                                  /* 豸Ƿ֧ץͼ,0: ֧, 1: ֧ Support configuration or not. 0-No, 1-Yes*/
    UINT32 udwPictureMaxSize;                                                    /* ץͼֵ֧ͼƬСֵ */
    UINT32 udwResolutionNum;                                                     /* ֵ֧ķֱʸ */
    NETDEV_VIDEO_RESOLUTION_S astResolutionCapList[NETDEV_LEN_16];               /* ֵ֧ץͼֱϢб */

    BYTE   byRes[255];                                                           /* ֶ */
 
}NETDEV_VIDEO_SNAP_CAP_S,*LPNETDEV_VIDEO_SNAP_CAP_S;

/**
 * @struct tagNETDEVVideoSnapshotInfo
 * @brief ƵͨץͼϢ Snap parameter info
 * @attention
 */
typedef struct tagNETDEVVideoSnapshotInfo
{
    BOOL bIsEnabled;                                                             /* ץͼʹ,0: ر, 1:  Support configuration or not. 0-close, 1-open*/
    UINT32 udwPictureMaxSize;                                                    /* ͼƬС */
    UINT32 udwSnapshotInterval;                                                  /* ץͼΧ[1, 60],λ:롣ץͼSnapshotNumΪ23ʱЧ */
    UINT32 udwSnapshotNum;                                                       /* ץͼΧ[1,3] */
    NETDEV_VIDEO_RESOLUTION_S stResolution;                                      /* ץͼֱ */

    BYTE   byRes[255];                                                           /* ֶ */
}NETDEV_VIDEO_SNAPSHOT_S,*LPNETDEV_VIDEO_SNAPSHOT_S;


/**
 * @struct tagstNETDEVAlarmLevelInfo
 * @brief 澯Ϣ
 * @attention 
 */
typedef struct tagstNETDEVAlarmLevelInfo
{
    INT32   dwAlarmType;                    /* 澯 μNETDEV_ALARM_TYPE_E*/
    INT32   dwAlarmSubType;                 /* 澯 μNETDEV_ALARM_SUBTYPE_E*/
    INT32   dwAlarmLevel;                   /* 澯 */
}NETDEV_ALARM_LEVEL_INFO_S, *LPNETDEV_ALARM_LEVEL_INFO_S;

/**
 * @struct tagstNETDEVAlarmLevelInfoList
 * @brief 澯Ϣб
 * @attention
 */
typedef struct tagstNETDEVAlarmLevelInfoList
{
    INT32                           dwSize;                 /* 澯Ϣ */
    LPNETDEV_ALARM_LEVEL_INFO_S     pstAlarmLevelInfo;      /* 澯Ϣб*/
}NETDEV_ALARM_LEVEL_INFO_LIST_S, *LPNETDEV_ALARM_LEVEL_INFO_LIST_S;

/**
 * @struct tagNETDEVBatchOperateList
 * @brief б ṹ嶨 
 * @attention  None
 */
typedef struct tagNETDEVBatchOperateList
{
    UINT32                          udwNum;         /*  */
    UINT32                          udwStatus;      /* ״̬ */
    LPNETDEV_BATCH_OPERATOR_INFO_S  pstBatchList;   /* Ϣ 2000,趯̬ */
    BYTE                            byRes[128];     /* ֶ  Reserved */
}NETDEV_BATCH_OPERATOR_LIST_S,*LPNETDEV_BATCH_OPERATOR_LIST_S;

/**
 * @struct tagNETDEVMonitorDevResultInfo
 * @brief 豸ؽϢ ṹ嶨 
 * @attention  None
 */
typedef struct tagNETDEVMonitorDevResultInfo
{
    UINT32                          udwDevID;           /* 豸ID */
    NETDEV_BATCH_OPERATOR_LIST_S    stMonitorResult;    /* 豸ؽϢ */
    BYTE                            byRes[128];         /* ֶ  Reserved */
}NETDEV_MONITOR_DEV_RESULT_INFO_S,*LPNETDEV_MONITOR_DEV_RESULT_INFO_S;

/**
 * @struct tagNETDEVMonitorDevResultList
 * @brief 豸ؽб ṹ嶨 
 * @attention  None
 */
typedef struct tagNETDEVMonitorDevResultList
{
    UINT32                              udwDevNum;                                  /* 豸 */
    NETDEV_MONITOR_DEV_RESULT_INFO_S    astMonitorDevResultInfo[NETDEV_LEN_16];     /* 豸Ϣб Ŀǰ5̨豸*/
    BYTE                                byRes[128];                                 /* ֶ  Reserved */
}NETDEV_MONITOR_DEV_RESULT_LIST_S,*LPNETDEV_MONITOR_DEV_RESULT_LIST_S;

/**
 * @struct tagNETDEVBatchOperateMemberList
 * @brief Աб ṹ嶨 Device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVBatchOperateMemberList
{
    UINT32  udwTaskNo;             /* ţNVR֧ */
    UINT32  udwMemberNum;          /* Ա */
    UINT32* pstMemberIDList;       /* Աб udwNumж̬ */
    BYTE    byRes[128];             /* ֶ  Reserved */

}NETDEV_BATCH_OPERATE_MEMBER_LIST_S,*LPNETDEV_BATCH_OPERATE_MEMBER_LIST_S;

/**
* @struct tagNETDEVMonitorCapacityInfo
* @brief Ϣṹ嶨
* @attention None
*/
typedef struct tagNETDEVMonitorCapacityInfo
{
    UINT32  udwMonitorType;         /*  0   1 */
    UINT32  udwNum;                 /* 豸 */
    UINT32  *pudwDevIDList;         /* 豸IDб udwNum̬*/
    BYTE    byRes[128];             /* ֶ  Reserved */
}NETDEV_MONITOR_CAPACITY_INFO_S, *LPNETDEV_MONITOR_CAPACITY_INFO_S;

/**
* @struct tagNETDEVDevCapacityInfo
* @brief 豸Ϣṹ嶨
* @attention None
*/
typedef struct tagNETDEVDevCapacityInfo
{
    UINT32  udwDevID;               /* 豸ID */
    UINT32  udwCapacity;            /* 豸 */
    UINT32  udwMonitoredNum;        /* Ѳ */
    BYTE    byRes[128];             /* ֶ  Reserved */
}NETDEV_DEV_CAPACITY_INFO_S, *LPNETDEV_DEV_CAPACITY_INFO_S;

/**
* @struct tagNETDEVMonitorCapacityList
* @brief زбṹ嶨
* @attention None
*/
typedef struct tagNETDEVMonitorCapacityList
{
    UINT32                          udwDevNum;              /* 豸 */
    LPNETDEV_DEV_CAPACITY_INFO_S    pstDevCapacityList;     /* б DevNum̬ */
    BYTE                            byRes[64];              /* ֶ  Reserved */
}NETDEV_MONITOR_CAPACITY_LIST_S, *LPNETDEV_MONITOR_CAPACITY_LIST_S;



/**
* @struct tagNETDEVDevMonitorInfo
* @brief Ա豸Ϣṹ嶨
* @attention None
*/
typedef struct tagNETDEVDevMonitorInfo
{
    UINT32  udwDevID;               /* 豸ID */
    UINT32  udwMonitorStatus;       /* 豸״̬ */
    BYTE    byRes[64];              /* ֽ */
}NETDEV_DEV_MONITOR_INFO_S,*LPNETDEV_DEV_MONITOR_INFO_S;

/**
* @struct tagNETDEVMonitorMemberInfo
* @brief Ա״̬Ϣṹ嶨
* @attention None
*/
typedef struct tagNETDEVMonitorMemberInfo
{
    UINT32                      udwMemberID;                        /* ԱID */
    CHAR                        szName[NETDEV_LEN_260];             /* Ա */
    UINT32                      udwDevNum;                          /* 豸 */
    UINT32                      udwMonitorStatus;                   /* ״̬ 0:ʧ   1:سɹ*/
    NETDEV_DEV_MONITOR_INFO_S   stDevMonitorInfo[NETDEV_LEN_16];    /* Ա豸Ϣб Ŀǰ豸Ϊ5*/
    BYTE                        byRes[64];                          /* ֶ  Reserved */
}NETDEV_MONITOR_MEMBER_INFO_S,*LPNETDEV_MONITOR_MEMBER_INFO_S;

/**
* @struct tagNETDEVMonitorFaceVehicle
* @brief ³/Ա
* @attention None
*/
typedef struct tagNETDEVMonitorFaceVehicle
{
    UINT32                          udwMemberNum;                           /* Ա */
    NETDEV_MONITOR_MEMBER_INFO_S    stMonitorMemberInfo[NETDEV_LEN_32];     /* Ա״̬Ϣ */
    BYTE                            byRes[64];                              /* ֶ  Reserved */
}NETDEV_MONITOR_FACE_VEHICLE_S,*LPNETDEV_MONITOR_FACE_VEHICLE_S;


/**
 * @struct tagNETDEVDeleteDBFlagInfo
 * @brief ɾϢ־λ
 * @attention  None
 */
typedef struct tagNETDEVDeleteDBFlagInfo
{
    BOOL     bIsDeleteMember;       /* ǷɾĳԱϢ0:ɾ 1:ɾ */
    BYTE     byRes[128];            /* ֶ  Reserved */

}NETDEV_DELETE_DB_FLAG_INFO_S,*LPNETDEV_DELETE_DB_FLAG_INFO_S;

/**
 * @struct tagNETDEVFaceDBMemberCond
 * @brief Աѯ ṹ嶨 
 * @attention  None
 */
typedef struct tagNETDEVFaceDBMemberCond
{
    UINT32   udwOffset;     /* ҳѯеһݵ */
    UINT32   udwLimit;      /* ÿҳ */
    BYTE    byRes[128];     /* ֶ  Reserved */
}NETDEV_FACE_DB_MEMBER_COND_S,*LPNETDEV_FACE_DB_MEMBER_COND_S;


/**
 * @struct tagNETDEVFaceAddMemberList
 * @brief Աб ṹ嶨 Device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVFaceAddMemberList
{
    UINT32                      udwTaskNo;              /* ţNVR֧ */
    UINT32                      udwNum;                 /* Ա */
    LPNETDEV_FACE_MEMBER_INFO_S pstMemberInfoList;      /* бԱ udwNumж̬ */
    BYTE                        byRes[128];             /* ֶ  Reserved */

}NETDEV_FACE_ADD_MEMBER_LIST_S,*LPNETDEV_FACE_ADD_MEMBER_LIST_S;



/**
 * @struct tagstNETDEVFaceSnapFeature
 * @brief ʶץ
 * @attention
 */
typedef struct tagstNETDEVFaceSnapFeature
{
    UINT32   udwAge;                            /*  */
    UINT32   udwGender;                         /* Ա μöNETDEV_FACE_MEMBER_GENDER_TYPE_E*/
    BOOL     bWithGlasses;                     /* Ƿ۾ */
    BOOL     bWithSmile;                       /* Ƿ΢Ц */
    UINT32   udwHappyIndex;                     /* ָ */

    BYTE     byRes[128];                        /* ֶ  Reserved */
}NETDEV_FACE_SNAP_FEATURE_INFO_S, *LPNETDEV_FACE_SNAP_FEATURE_INFO_S;

/**
 * @struct tagstNETDEVFaceSnapLog
 * @brief ʶץ¼
 * @attention
 */
typedef struct tagstNETDEVFaceSnapLog
{
    UINT32                          udwID;                                  /* ץļ¼ID */
    UINT32                          udwTimestamp;                           /* ʱ */
    CHAR                            szAlarmSrc[NETDEV_FACE_ALARM_SRC_LEN];  /* ץ */
    NETDEV_FACE_SNAP_FEATURE_INFO_S stSnapFeature;                          /* ץ */
    NETDEV_FACE_ALARM_SNAP_IMAGE_S  stSnapImage;                            /* ץͼƬϢ */

    BYTE                            byRes[128];                             /* ֶ  Reserved */
}NETDEV_FACE_SNAP_LOG_INFO_S, *LPNETDEV_FACE_SNAP_LOG_INFO_S;


/**
 * @struct tagNETDEVVehicleInfoList
 * @brief Ϣб ṹ嶨 Device information Structure definition
 * @attention  None
 */
typedef struct tagNETDEVVehicleInfoList
{
    UINT32                          udwVehicleNum;          /* Ա */
    LPNETDEV_VEHICLE_DETAIL_INFO_S  pstMemberInfoList;      /* Աб udwNumж̬ */
    BYTE                            byRes[132];             /* ֶ  Reserved */
}NETDEV_VEHICLE_INFO_LIST_S,*LPNETDEV_VEHICLE_INFO_LIST_S;

/**
 * @struct tagDSTCfgTimeInfo
 * @brief ʱʱ
 * @attention
 */
typedef struct tagDSTCfgTimeInfo
{
    UINT32    udwMonth;                   /* ʼ· 1:һ  2:.....12:ʮ*/
    UINT32    udwWeekNum;                 /* ʼµĵڼ 1:һ 2:ڶ 1:һ 3: 4: 5:һ */
    UINT32    udwWeekDay;                 /* ʼµXܼܵ 1:һ  2:ܶ  3:  4:  5:  6:  7:*/
    UINT32    udwHour;                    /* ʼʱ䣬λСʱ24Сʱƣ000:00     101:00     202:00   303:00     2222:00      2323:00 */
    BYTE      byRes[256];                 /* ֶ */
}NETDEV_DST_CFG_TIME_INFO_S,* LPNETDEV_DST_CFG_TIME_INFO_S;


/**
* @brief ͨȨϢ ṹ嶨
* @attention 
*/
typedef struct tagNETDEVChnPermissionInfo
{
    INT32    dwChannelID;               /* ͨ */
    INT32    dwPermission;              /* ͨȨ, ο#NETDEV_CHN_PERMISSION_TYPE_E */
    BYTE     byRes[256];                /* ֶ  Reserved */
}NETDEV_CHN_PERMISSION_INFO_S, *LPNETDEV_CHN_PERMISSION_INFO_S;


/**
 * @briefûϸϢ
 * @attention 
 */
typedef struct tagNETDEVUserDetailInfo
{
    UINT32                         udwLevel;                                          /* ûȼ  μö NETDEV_USER_LEVEL_E*/
    CHAR                           szUserName[NETDEV_LEN_64];                         /* û ֧޸ģȡϢʱΪ Χ1~18*/
    CHAR                           szPassword[NETDEV_LEN_256];                        /*  ʹ Χ0~256 ȡʱظֶ*/
    UINT32                         udwBasePermission;                                 /* ȨޣμöNETDEV_USER_BASE_PERMISSION_E BITλȨӦBITΪ1ʾȨЧΪ0ʾȨ޲Ч*/
    UINT32                         udwNum;                                            /* Ƶͨ */
    NETDEV_CHN_PERMISSION_INFO_S   astChnPermission[NETDEV_CHANNEL_MAX];              /* ͨȨб */
    BYTE                           byRes[256];                                        /* ֶ */
}NETDEV_USER_DETAIL_INFO_S, *LPNETDEV_USER_DETAIL_INFO_S;

/**
 * @brief޸ûϸϢ
 * @attention 
 */
typedef struct tagNETDEVUserModifyDetailInfo
{
    NETDEV_USER_DETAIL_INFO_S      stUserInfo;
    BOOL                           bIsModifyPassword;                       /* Ƿ޸, ޸ʱֵ */
    BOOL                           bIsModifyOther;                          /* ǷԱ޸û, ޸ʱֵ */
    CHAR                           szNewPassword[NETDEV_LEN_256];           /* (޸ʱʹ)Χ0~256 漰޸ ôֶοɲ·ʱΪգ·ֶ*/
    CHAR                           szCurrentPassword[NETDEV_LEN_256];       /* /ǰʹõ ޸ʱЯ Χ0~256 Ա޸ûֻҪɣʱΪգ·ֶ*/
    BYTE                           byRes[256];                              /* ֶ */
}NETDEV_USER_MODIFY_DETAIL_INFO_S, *LPNETDEV_USER_MODIFY_DETAIL_INFO_S;

/**
 * @briefûϢб
 * @attention 
 */
typedef struct tagNETDEVUserDetailList
{
    UINT32                      udwNum;                          /* û */
    NETDEV_USER_DETAIL_INFO_S   astUserInfo[NETDEV_LEN_64];     /* ûб */
    BYTE                        byRes[128];                      /* ֶ */
}NETDEV_USER_DETAIL_LIST_S, *LPNETDEV_USER_DETAIL_LIST_S;

/**
 * @struct tagNetWorkCloudInfo
 * @brief MyCloudϢ
 * @attention
 */
typedef struct tagNetWorkCloudInfo
{
    BOOL        bEnable;                                  /* Ƿʹ 0 ʹ 1ʹ */
    UINT32      udwType;                                  /* ͣʱΪ0 */
    UINT32      udwConStatus;                             /* ״̬ 0δ 1 */
    CHAR        szDomainAddress[NETDEV_DOMAIN_LEN];       /*  */
    CHAR        szDevName[NETDEV_LEN_64];                 /* 豸  Device name */
    CHAR        szUserName[NETDEV_LEN_64];                /* û  User name */
    CHAR        szPassWord[NETDEV_LEN_64];                /*  */
    UINT32      udwOffLineErrCode;                        /* ԭ μö#NETDEV_MYCLOUD_OFF_ERR_E */
    CHAR        szRegisterCode[NETDEV_LEN_64];            /* ע */
    CHAR        szRandomCode[NETDEV_LEN_32];              /* ע,ƷкŹͬע */
    UINT32      udwRegisterStatus;                         /* ע״̬ μö#NETDEV_REGISTER_STATUS_E*/
    CHAR        szActiveCode[NETDEV_LEN_64];              /*  */
    CHAR        szRedirectServer[NETDEV_LEN_128];         /* ƷضϢ, ǰע/ַ(/IP), ⶨλû޸ */

    BYTE        byRes[28];                                /* ֶ */
}NETDEV_NETWORK_CLOUD_INFO_S,* LPNETDEV_NETWORK_CLOUD_INFO_S;


/**
 * @brief ƵַϢ
 * @attention
 */
typedef struct tagstNETDEVCDNSrvInfo
{
    UINT32  udwState;                           /* ַ״̬:01 */
    FLOAT   fSurplusFlux;                       /* ʣ(λGB) */
    CHAR    szServerDomain[NETDEV_LEN_256];     /*  */
    BYTE    byRes[256];
}NETDEV_CDN_SRV_INFO_S, *LPNETDEV_CDN_SRV_INFO_S;

/**
 * @brief Ƶַ
 * @attention
 */
typedef struct tagstNETDEVCDNRule
{
    BOOL    bEnable;        /* ַǷ */
    UINT32  ProtocolType;   /* ַЭ, μNETDEV_CDN_PROT_E */
    BYTE    byRes[256];
}NETDEV_CDN_RULE_S, *LPNETDEV_CDN_RULE_S;

/**
 * @brief ƵַͨϢϢ
 * @attention
 */
typedef struct tagstNETDEVCDNChnInfo
{
    UINT32  udwChannelID;                   /* ͨ */
    UINT32  udwStreamType;                  /*  */
    CHAR    szStreamUrl[NETDEV_LEN_260];    /* ַ */
    BYTE    byRes[256];
}NETDEV_CDN_CHL_INFO_S, *LPNETDEV_CDN_CHL_INFO_S;

/**
* @struct tagNETDEVLoginNatInfo
* @brief 豸¼Ϣ
* @attention  None
*/
typedef struct tagNETDEVLoginNatInfo
{
    CHAR szDeviceUsername[NETDEV_LEN_260];      /* 豸¼û */
    CHAR szDeviceIP[NETDEV_IPV4_LEN_MAX];       /* IPַ */
    INT32 dwDevicePort;                         /* ˿ */
    BYTE byRes[236];                            /* ֶ Reserved */
} NETDEV_CLOUD_NAT_LOGIN_INFO_S, *LPNETDEV_CLOUD_NAT_LOGIN_INFO_S;

/**
 * @struct tagNETDEVPersonLibCapInfo
 * @brief Ϣ
 * @attention  None
 */
typedef struct tagNETDEVPersonLibCapInfo
{
    UINT32          udwLibID;            /* ID */
    UINT32          udwCapacity;         /* Ϣλ */
    BYTE            byRes[128];          /* ֶ */
}NETDEV_PERSON_LIB_CAP_INFO_S, *LPNETDEV_PERSON_LIB_CAP_INFO_S;

/**
 * @struct tagNETDEVPersonLibCapList
 * @brief ԱϢ
 * @attention  None
 */
typedef struct tagNETDEVPersonLibCapList
{
    UINT32                      udwMaxPerpleMun;                         /* ܿλK */
    UINT32                      udwFreePerpleNum;                        /* ʣλ */
    UINT32                      udwMaxLibNum;                            /* ɽ */
    UINT32                      udwFreeLibNum;                           /* ʣɽ */
    UINT32                      udwNum;                                  /* ѽ Χ:[0, 16] */
    NETDEV_PERSON_LIB_CAP_INFO_S  stLibCapInfoList[NETDEV_LEN_16];         /* Ϣ */
    BYTE                        byRes[256];                              /* ֶ */
}NETDEV_PERSON_LIB_CAP_LIST_S, *LPNETDEV_PERSON_LIB_CAP_LIST_S;

/**
 * @struct tagNETDEVPersonQueryInfo
 * @brief ԱϢѯ
 * @attention  None
 */
typedef struct tagNETDEVPersonQueryInfo
{
    UINT32                      udwNum;             /* ѯ */
    LPNETDEV_QUERY_INFO_S       pstQueryInfos;      /* ѯбNumΪ0ʱֶ*/
    UINT32                      udwLimit;           /* ÿβѯ20 */
    UINT32                      udwOffset;          /* ӵǰſʼѯŴ0ʼ */
    BYTE                        byRes[256];         /* ֶ */
}NETDEV_PERSON_QUERY_INFO_S, *LPNETDEV_PERSON_QUERY_INFO_S;

/**
 * @struct tagNETDEVMonitorQueryInfo
 * @brief Ϣѯ
 * @attention  None
 */
typedef struct tagNETDEVMonitorQueryInfo
{
    UINT32                      udwLimit;           /* ÿβѯ20 */
    UINT32                      udwOffset;          /* ӵǰſʼѯŴ0ʼ */
    BOOL                        bIsQueryAll;        /* ǷѯУ:TRUE,:FALSE */
    BYTE                        byRes[128];         /* ֶ */
}NETDEV_MONITOR_QUERY_INFO_S, *LPNETDEV_MONITOR_QUERY_INFO_S;

/**
 * @struct tagNETDEVPersonQueryResultInfo
 * @brief ϢѯϢ
 * @attention  None
 */
typedef struct tagNETDEVPersonQueryResultInfo
{
    UINT32                          udwTotal;           /* ϲѯ */
    UINT32                          udwOffset;          /* ǰţŴ0ʼ */
    NETDEV_PERSON_INFO_LIST_S       stPersonInfoList;   /* Ϣб */
    BYTE                            byRes[256];         /* ֶ */
}NETDEV_PERSON_QUERY_RESULT_INFO_S, *LPNETDEV_PERSON_QUERY_RESULT_INFO_S;

/*
* @struct tagNETDEVStartInfo
* @brief ѯʼϢ
* @attention  None
*/
typedef struct tagNETDEVStartInfo
{
    UINT32 udwNum;                             /* ѯͨ */
    UINT32 *pudwID;                            /* ѯͨIDб ,趯̬ڴ*/
    UINT32 udwBegin;                           /* ҿʼʱ䣬UTCʱ */
    UINT32 udwEnd;                             /* ҽʱ䣬UTCʱ */
    BYTE   byRes[128];                         /*   Reserved */
}NETDEV_START_INFO_S,*LPNETDEV_START_INFO_S;

/*
* @struct tagNETDEVPicDataInfo
* @brief ͼƬϢ
* @attention  None
*/
typedef struct tagNETDEVPicDataInfo
{
    UINT32 udwID;                              /* ͨ */
    UINT32 udwTime;                            /* ʱUTC */
    UINT32 udwSize;                            /* ͼƬСλֽ */
    CHAR   szName[NETDEV_LEN_256];             /* ͼƬƣ[1,64] */
    CHAR*  pcData;                             /* ͼƬbase64 趯̬ڴ*/
    BYTE   byRes[128];                         /*   Reserved */
}NETDEV_PIC_DATA_INFO_S,*LPNETDEV_PIC_DATA_INFO_S;

/*
* @struct tagNETDEVPicQueryCond
* @brief ͼƬѯ
* @attention  None
*/
typedef struct tagNETDEVPicQueryCond
{
    UINT32 udwSearchID;                        /* ҵ */
    UINT32 udwLimit;                           /* ÿβѯ */
    UINT32 udwOffset;                          /* ӵǰſʼѯŴ0ʼ */
    BYTE   byRes[128];                         /*   Reserved */
}NETDEV_PIC_QUERY_COND_S,*LPNETDEV_PIC_QUERY_COND_S;

/*
* @struct tagNETDEVPicQueryResult
* @brief ͼƬѯ
* @attention  None
*/
typedef struct tagNETDEVPicQueryResult
{
    UINT32 udwTotal;                           /* ѯܸ */
    UINT32 udwNum;                             /* ǰ */
    BYTE   byRes[128];                         /*   Reserved */
}NETDEV_PIC_QUERY_RESULT_S,*LPNETDEV_PIC_QUERY_RESULT_S;

/**
 * @struct tagstNETDEVTmSectInfo
 * @brief Զʱ
 * @attention
 */
typedef struct tagstNETDEVTmSectInfo
{
    CHAR   szBegin[NETDEV_LEN_64];                                                  /* ʼʱ, ʽhh:mm:ss ȷΧ[0,31] */
    CHAR   szEnd[NETDEV_LEN_64];                                                    /* ʱ䣬ʽhh:mm:ss ȷΧ[0,31] */
    BYTE   byRes[128];                                                              /* ֶ */
}NETDEV_TM_SECT_INFO_S,*LPNETDEV_TM_SECT_INFO_S;

/**
 * @struct tagstNETDEVVehThroughInfo
 * @brief Ϣ
 * @attention
 */
typedef struct tagstNETDEVVehThroughInfo
{
    UINT32 udwType;                                                                 /* зʽ NETDEV_VEH_RELEASE_TYPE_E */
    UINT32 udwNum;                                                                  /* Զʱб 4*/
    NETDEV_TM_SECT_INFO_S astTmSectInfo[NETDEV_LEN_4];                              /* ԶʱϢ */
    BYTE   byRes[128];                                                              /* ֶ */
}NETDEV_VEH_THROUGH_INFO_S,*LPNETDEV_VEH_THROUGH_INFO_S;

/**
 * @struct tagstNETDEVVehLaneInfo
 * @brief Ϣ
 * @attention
 */
typedef struct tagstNETDEVVehLaneInfo
{
    UINT32 udwVehLaneID;                                                            /* ID */
    CHAR   szName[NETDEV_LEN_128];                                                  /*  */
    UINT32 udwType;                                                                 /*   NETDEV_VEH_LANE_TYPE_E */
    UINT32 udwNum;                                                                  /* Զʱθ4 */
    NETDEV_TM_SECT_INFO_S astEnTmSectInfo[NETDEV_LEN_4];                            /* Զʱб */
    NETDEV_VEH_THROUGH_INFO_S stTmpVehThrough;                                      /* ʱ */
    NETDEV_VEH_THROUGH_INFO_S stRegVehThrough;                                      /* ̶ */
    UINT32 udwDevNum;                                                               /* 豸 4*/
    UINT32 audwDevID[NETDEV_LEN_4];                                                 /* ĳ豸IDб */
    BYTE   byRes[128];                                                              /* ֶ */
}NETDEV_VEH_LANE_INFO_S,*LPNETDEV_VEH_LANE_INFO_S;

/**
 * @struct tagstNETDEVVehLaneInfoList
 * @brief Ϣб
 * @attention
 */
typedef struct tagstNETDEVVehLaneInfoList
{
    UINT32 udwNum;                                                                   /* 2 */
    NETDEV_VEH_LANE_INFO_S astVehLaneInfo[NETDEV_LEN_4];                             /* Ϣ */
    BYTE   byRes[128];                                                               /* ֶ */
}NETDEV_VEH_LANE_INFO_LIST_S,*LPNETDEV_VEH_LANE_INFO_LIST_S;

/**
 * @struct tagstNETDEVParkEntrLaneInfo
 * @brief ͣڡбϢ
 * @attention
 */
typedef struct tagstNETDEVParkEntrLaneInfo
{
    UINT32 udwParkingLotID;                                                          /* ͣID */
    UINT32 udwEntranceID;                                                            /* ID */
    NETDEV_VEH_LANE_INFO_LIST_S stVehLaneInfoList;                                   /* Ϣб */
    BYTE   byRes[128];                                                               /* ֶ */
}NETDEV_PARK_ENTR_LANE_INFO_S,*LPNETDEV_PARK_ENTR_LANE_INFO_S;

/**
 * @struct tagstNETDEVParkInfo
 * @brief ͣϢ
 * @attention
 */
typedef struct tagstNETDEVParkInfo
{
    UINT32 udwParkingLotID;                                                          /* ͣID */
    CHAR   szParkingLotName[NETDEV_LEN_260];                                         /* ͣƣȷΧ[1,64] */
    UINT32 udwTotalSpaceNum;                                                         /* ܳλ */
    UINT32 udwRmnSpaceNum;                                                           /* ʣ೵λ */
    UINT32 udwReserveSpaceNum;                                                       /* ̶λ */
    UINT32 udwRmnReserveSpaceNum;                                                    /* ʣ̶λ */
    UINT32 udwMainParkingLotID;                                                      /* ͣID ûʱɲЯֶ */
    BYTE   byRes[256];                                                               /* ֶ */
}NETDEV_PARK_INFO_S,*LPNETDEV_PARK_INFO_S;

/**
 * @struct tagstNETDEVParkInfoList
 * @brief ͣϢб
 * @attention
 */
typedef struct tagstNETDEVParkInfoList
{
    UINT32 udwNum;                                                                   /* ͣ */
    NETDEV_PARK_INFO_S   astParkInfo[NETDEV_LEN_16];                                 /* ͣϢ һVMS֧8ͣ */
    BYTE   byRes[512];                                                               /* ֶ */
}NETDEV_PARK_INFO_LIST_S, *LPNETDEV_PARK_INFO_LIST_S;

/**
 * @struct tagstNETDEVParkEntranceInfo
 * @brief ͣϢ
 * @attention
 */
typedef struct tagstNETDEVParkEntranceInfo
{
    UINT32 udwParkEntranceID;                                                        /* ID ӳǲЯ */
    CHAR   szName[NETDEV_LEN_260];                                                   /* ƣȷΧ[1,64] */
    UINT32 udwVehicleLaneNum;                                                        /* 2 */
    BYTE   byRes[256];                                                               /* ֶ */
}NETDEV_PARK_ENTRANCE_INFO_S, *LPNETDEV_PARK_ENTRANCE_INFO_S;

/**
 * @struct tagstNETDEVParkEntranceInfoList
 * @brief ͣϢб
 * @attention
 */
typedef struct tagstNETDEVParkEntranceInfoList
{
    UINT32 udwNum;                                                                   /*  */
    NETDEV_PARK_ENTRANCE_INFO_S   astParkEntranceInfo[NETDEV_LEN_32];                /* Ϣ һ֧ͣ16 */
    BYTE   byRes[512];                                                               /* ֶ */
}NETDEV_PARK_ENTRANCE_INFO_LIST_S,*LPNETDEV_PARK_ENTRANCE_INFO_LIST_S;

/**
 * @struct tagstNETDEVParkEntranceID
 * @brief ͣID
 * @attention
 */
typedef struct tagstNETDEVParkEntranceID
{
    UINT32 udwParkID;                                                                /* ͣID */
    UINT32 udwEntranceID;                                                            /* ID */
    BYTE   byRes[256];                                                               /* ֶ */
}NETDEV_PARK_ENTRANCE_ID_S,*LPNETDEV_PARK_ENTRANCE_ID_S;

/**
 * @struct tagstNETDEVParkSpaceInfo
 * @brief ͣλϢ
 * @attention
 */
typedef struct tagstNETDEVParkSpaceInfo
{
    UINT32 udwTotalSpaceNum;                                                         /* ܳλ */
    UINT32 udwRmnSpaceNum;                                                           /* ʣ೵λ */
    UINT32 udwReserveSpaceNum;                                                       /* ̶λ */
    UINT32 udwRmnReserveSpaceNum;                                                    /* ʣ̶λ */
    BYTE   byRes[256];                                                               /* ֶ */
}NETDEV_PARK_SPACE_INFO_S,*LPNETDEV_PARK_SPACE_INFO_S;

/**
 * @struct tagstNETDEVChgRuleInfo
 * @brief շѹϢ
 * @attention
 */
typedef struct tagstNETDEVChgRuleInfo
{
    UINT32 udwNum;                                                                   /*  */
    UINT32 udwType;                                                                  /*   NETDEV_CHG_RULE_TYPE_E*/
    BYTE   byRes[256];                                                               /* ֶ */
}NETDEV_CHG_RULE_INFO_S,*LPNETDEV_CHG_RULE_INFO_S;

/**
 * @struct tagstNETDEVChgRuleQueryCond
 * @brief շѹѯ
 * @attention
 */
typedef struct tagstNETDEVChgRuleQueryCond
{
    UINT32 udwParkingLotID;                                                          /* ͣID */
    UINT32 udwChargeRuleType;                                                        /* շѹ  NETDEV_CHG_RULE_TYPE_E */
    BYTE   byRes[256];                                                               /* ֶ */
}NETDEV_CHG_RULE_QUERY_COND_S,*LPNETDEV_CHG_RULE_QUERY_COND_S;

/**
 * @struct tagstNETDEVAbnChgRuleInfo
 * @brief 쳣շѹ
 * @attention
 */
typedef struct tagstNETDEVAbnChgRuleInfo
{
    UINT32 udwID;                                                                    /* ID */
    CHAR   szName[NETDEV_LEN_128];                                                   /*  */
    UINT32 udwChgAmount;                                                             /* շѽ(Ԫ) */
    CHAR   szDescription[NETDEV_LEN_512];                                            /* Χ[1,128] */
    UINT32 udwIsDefaultRule;                                                         /* ǷΪĬϹ 0: 1:*/
    BYTE   byRes[128];                                                               /* ֶ */
}NETDEV_ABN_CHG_RULE_INFO_S,*LPNETDEV_ABN_CHG_RULE_INFO_S;

/**
 * @struct tagNETDEVEntrVehSnapInfo
 * @brief 볡ץϢ
 * @attention
 */
typedef struct tagNETDEVEntrVehSnapInfo
{
    UINT32 udwID;                                                                    /* 볡¼ID */
    UINT32 udwChannelID;                                                             /* ͨID */
    CHAR   szPlateNo[NETDEV_LEN_16];                                                 /* ƺ룬Χ[1,16] */
    UINT32 udwVehType;                                                               /*   NETDEV_PARK_VEH_TYPE_E */
    UINT32 udwVehColor;                                                              /* ɫ  NETDEV_VEHICLE_COLOR_E*/
    UINT32 udwVehAttr;                                                               /*   NETDEV_VEH_ATTR_TYPE_E */
    UINT32 udwIsBlackList;                                                           /* ǷǺ 0: 1: */
    UINT32 udwEnterTime;                                                             /* 볡ʱ䣬UTCʱ䣬λ */
    UINT32 udwIsAutoOpenGate;                                                        /* ǷԶբ 0: 1: */
    NETDEV_FILE_INFO_S stPlateImage;                                                 /* ͼƬ */
    NETDEV_FILE_INFO_S stVehImage;                                                   /* ͼƬ */
    BYTE   byRes[128];                                                               /* ֶ */
}NETDEV_ENTR_VEH_SNAP_INFO_S,*LPNETDEV_ENTR_VEH_SNAP_INFO_S;

/**
 * @struct tagNETDEVEntrInfo
 * @brief 볡ץϢ
 * @attention
 */
typedef struct tagNETDEVEntrInfo
{
    UINT32 udwEnterTime;                                                             /* 볡ʱ䣬UTCʱ䣬λ */
    NETDEV_FILE_INFO_S stPlateImage;                                                 /* ͼƬ */
    NETDEV_FILE_INFO_S stVehImage;                                                   /* ͼƬ */
    BYTE   byRes[256];                                                               /* ֶ */
}NETDEV_ENTR_INFO_S,*LPNETDEV_ENTR_INFO_S;

/**
 * @struct tagstNETDEVExitInfo
 * @brief ץϢ
 * @attention
 */
typedef struct tagstNETDEVExitInfo 
{
    UINT32 udwExitTime;                                                              /* ʱ(UTCʱ䣬λ) */
    UINT32 udwTotalAmount;                                                           /* ͣ(λ) */
    UINT32 udwIsAlreadyPaid;                                                         /* Ƿѽɷ 0: 1:*/
    UINT32 udwChargeRecordID;                                                        /* ɷѼ¼ID */
    NETDEV_FILE_INFO_S stPlateImage;                                                 /* ͼƬ */
    NETDEV_FILE_INFO_S stVehImage;                                                   /* ͼƬ */
    CHAR   szOperatorName[NETDEV_LEN_128];                                           /* Ա */
    BYTE   byRes[256];                                                               /* ֶ */
}NETDEV_EXIT_INFO_S,*LPNETDEV_EXIT_INFO_S;

/**
 * @struct tagstNETDEVEntrExitMatchInfo
 * @brief 볡¼Ϣ
 * @attention
 */
typedef struct tagstNETDEVEntrExitMatchInfo
{
    UINT32 udwIsWhiteList;                                                           /* Ƿǰ 0 1 */
    UINT32 udwIsBlackList;                                                           /* ǷǺ 0: 1: */
    UINT32 udwParkingTime;                                                           /* ͣʱλ֣ʱЯ */
    LPNETDEV_ENTR_INFO_S pstEntrInfo;                                                /* ƥ볡Ϣ */
    LPNETDEV_EXIT_INFO_S pstExitInfo;                                                /* ƥϢ */
    BYTE   byRes[128];                                                               /* ֶ */
}NETDEV_ENTR_EXIT_MATCH_INFO_S,*LPNETDEV_ENTR_EXIT_MATCH_INFO_S;

/**
 * @struct tagstNETDEVParkEventInfo
 * @brief ͣ¼Ϣ
 * @attention
 */
typedef struct tagstNETDEVParkEventInfo
{
    UINT32 udwID;                                                                    /* ¼ID */
    UINT32 udwParkID;                                                                /* ͣID */
    CHAR   szPlateNo[NETDEV_LEN_32];                                                 /* ƺ */
    NETDEV_VEH_ATTR_S stVehAttr;                                                     /* Ϣ */
    UINT32 udwVehRemainNum;                                                          /* ڳ */
    UINT32 udwIsWhiteList;                                                           /* Ƿǰ 0 1 */
    UINT32 udwIsBlackList;                                                           /* ǷǺ 0 1 */
    CHAR   szEntranceName[NETDEV_LEN_128];                                           /* ͤ */
    CHAR   szLaneName[NETDEV_LEN_128];                                               /*  */
    UINT32 udwCrossDirection;                                                        /*  0볡 1 */
    LPNETDEV_ENTR_INFO_S pstEnterInfo;                                               /* 볡Ϣ */
    LPNETDEV_EXIT_INFO_S pstExitInfo;                                                /* Ϣ */
    BYTE   byRes[256];                                                               /* ֶ */
}NETDEV_PARK_EVENT_INFO_S,*LPNETDEV_PARK_EVENT_INFO_S;

/**
 * @struct tagstNETDEVParkPayOrderInfo
 * @brief ֧ͣϢ
 * @attention
 */
typedef struct tagstNETDEVParkPayOrderInfo
{
    CHAR   szOrderNo[NETDEV_LEN_128];                                               /* ţɵ */
    UINT32 udwOrderStatus;                                                          /* ֧״̬ ö NETDEV_ORDER_STATUS_E*/
    CHAR   szPlateNo[NETDEV_LEN_128];                                               /* ƺ */
    UINT32 udwPayType;                                                              /* ֧  ö NETDEV_PAY_TYPE_E*/
    CHAR   szPayTradeNo[NETDEV_LEN_128];                                            /* ֧ */
    UINT32 udwTotalAmount;                                                          /* ͣܽλ */
    UINT32 udwDiscountAmount;                                                       /* ŻݼĽλ */
    BYTE   byRes[256];                                                              /* ֶ */
}NETDEV_PARK_PAY_ORDER_INFO_S,*LPNETDEV_PARK_PAY_ORDER_INFO_S;

/**
 * @struct tagstNETDEVParkCost
 * @brief ͣ
 * @attention
 */
typedef struct tagstNETDEVParkCost
{
    UINT32 udwTotalAmount;                                                          /* ŻݼĽλ */
    UINT32 udwEnterTime;                                                            /* ʱ䣬UTCʱ䣬λ */
    UINT32 udwExitLimitTime;                                                        /* 涨볡ʱ䣬λ */
    BYTE   byRes[256];                                                              /* ֶ */
}NETDEV_PARK_COST_S, *LPNETDEV_PARK_COST_S;

/**
 * @struct tagstNETDEVPassRecordInfo
 * @brief ¼Ϣ
 * @attention
 */
typedef struct tagstNETDEVPassRecordInfo
{
    UINT32 udwRecordID;                                                              /* ¼ID */
    NETDEV_FILE_INFO_S stPlateImage;                                                 /* ͼƬ */
    CHAR   szPlateNo[NETDEV_LEN_16];                                                 /* ƺ룬Χ[1,16] */
    CHAR   szName[NETDEV_LEN_128];                                                   /* Χ[1,32] */
    UINT32 udwVehType;                                                               /*  NETDEV_VEHICLE_TYPE_E */
    UINT32 udwVehColor;                                                              /* ɫ  NETDEV_VEHICLE_COLOR_E */
    UINT32 udwIsBlackList;                                                           /* ǷǺ 0: 1: */
    UINT32 udwIsWhiteList;                                                           /* Ƿǰ 0 1 */
    CHAR   szParkName[NETDEV_LEN_260];                                               /* ͣƣΧ[1,64] */
    UINT32 udwCrossDirection;                                                        /*  0: 1: */
    UINT32 udwPassTime;                                                              /* ʱ䣬UTCʱ䣬λ */
    CHAR   szEntrName[NETDEV_LEN_260];                                               /* ƣΧ[1,64] */
    BYTE   byRes[128];                                                               /* ֶ */
}NETDEV_PASS_RECORD_INFO_S,*LPNETDEV_PASS_RECORD_INFO_S;

/**
 * @struct tagstNETDEVTmpVehChgRecord
 * @brief ʱɷѼ¼ϸϢ
 * @attention
 */
typedef struct tagstNETDEVTmpVehChgRecord
{
    UINT32 udwRecordID;                                                              /* ¼ID */
    CHAR   szPlateNo[NETDEV_LEN_16];                                                 /* ƺ룬Χ[1,16] */
    UINT32 udwVehicleType;                                                           /*  NETDEV_VEHICLE_TYPE_E */
    UINT32 udwChargeTime;                                                            /* ɷʱ䣬UTCʱ䣬λ */
    INT64    tParkTime;                                                              /* ͣʱλ */
    UINT32 udwAmount;                                                                /* շѽλԪ */
    CHAR   szAbnRuleName[NETDEV_LEN_128];                                            /* 쳣շѹƣΧ[1,32] */
    UINT32 udwChgType;                                                               /* շ  NETDEV_CHG_TYPE_E */
    CHAR   szParkName[NETDEV_LEN_260];                                               /* ͣƣΧ[1,64] */
    CHAR   szOperatorName[NETDEV_LEN_260];                                           /* ԱƣΧ[1,64] */
    BYTE   byRes[128];                                                               /* ֶ */
}NETDEV_TMP_VEH_CHG_RECORD_S,*LPNETDEV_TMP_VEH_CHG_RECORD_S;

/**
 * @struct tagstNETDEVTmpVehChgAmount
 * @brief ʱɷѽ
 * @attention
 */
typedef struct tagstNETDEVTmpVehChgAmount
{
    UINT32 udwAmount;                                                                /* շѽϼƣλԪ */
    UINT32 udwManualPayment;                                                         /* ˹ɷѣλԪ */
    UINT32 udwSelfhelpPayment;                                                       /* ɷѣλԪ */
    BYTE   byRes[128];                                                               /* ֶ */
}NETDEV_TMP_VEH_CHG_AMOUNT_S,*LPNETDEV_TMP_VEH_CHG_AMOUNT_S;

/**
 * @struct tagstNETDEVShiftInfo
 * @brief Ϣ
 * @attention
 */
typedef struct tagstNETDEVShiftInfo
{
    CHAR   szName[NETDEV_LEN_260];                                                   /* û */
    UINT32 udwAmount;                                                                /* շѽλԪ */
    BYTE   byRes[128];                                                               /* ֶ */
}NETDEV_SHIFT_INFO_S,*LPNETDEV_SHIFT_INFO_S;

/**
 * @struct tagstNETDEVEntrExitSnapRecordID
 * @brief 볡ץļ¼ID
 * @attention
 */
typedef struct tagstNETDEVEntrExitSnapRecordID
{
    UINT32 udwEnterID;                                                               /* 볡ץļ¼ID */
    UINT32 udwExitID;                                                                /* ץļ¼ID */
    BYTE   byRes[128];                                                               /* ֶ */
}NETDEV_ENTR_EXIT_SNAP_RECORDID_S,*LPNETDEV_ENTR_EXIT_SNAP_RECORDID_S;

/**
 * @struct tagstNETDEVChgInfo
 * @brief շϢ
 * @attention
 */
typedef struct tagstNETDEVChgInfo
{
    CHAR   szPlateNo[NETDEV_LEN_16];                                                 /* ƺ Χ[1,16] */
    UINT32 udwAmount;                                                                /* շѽλԪ */
    UINT32 udwAbnRuleID;                                                             /* 쳣շѹID */
    UINT32 udwIsFree;                                                                /* Ƿ 0:1:*/
    INT64  tParkingTime;                                                             /* ͣʱλ */
    BYTE   byRes[128];                                                               /* ֶ */
}NETDEV_CHG_INFO_S,*LPNETDEV_CHG_INFO_S;

 /**
 * @struct tagNETDEVStructAlarmInfo
 * @brief ṹ澯ϱϢ
 * @attention  None
 */
typedef struct tagNETDEVStructAlarmInfo
{
    CHAR   szReference[NETDEV_LEN_260];                   /* Ϣ */
    UINT32 udwTimeStamp;                                  /* 澯ʱ 1970110㿪ʼ */
    UINT32 udwSeq;                                        /* 澯 */
    UINT32 udwSrcID;                                      /* 澯ԴID */
    CHAR   szSrcName[NETDEV_LEN_260];                     /* 澯Դ */
    UINT32 udwNotificationType;                           /* ֪ͨ 0ʵʱ֪ͨ 1ʷ֪ͨ */
    BYTE   byRes[128];                                    /* ֶ */
}NETDEV_STRUCT_ALARM_INFO_S,*LPNETDEV_STRUCT_ALARM_INFO_S;

/**
 * @struct tagNETDEVFaceStructInfo
 * @brief Ϣ
 * @attention  None
 */
typedef struct tagNETDEVFaceStructInfo
{
    UINT32 udwFaceID;                                     /* ID */
    UINT32 udwFaceDoforPersonID;                          /* ԱID */
    CHAR   szPosition[NETDEV_LEN_64];                     /* λϢ */
    UINT32 udwSmallPicAttachIndex;                        /* ӦСͼͼбе */
    UINT32 udwLargePicAttachIndex;                        /* ӦĴͼͼбе */
    CHAR   szFeaturVersion[NETDEV_LEN_64];                /* ṹͰ汾 */
    CHAR   szFeature[NETDEV_LEN_1024];                    /* ȡϢ base64 ǰǰ512 Bytes */
    NETDEV_FACE_ATTR_S stFaceAttr;                        /* Ϣ */
    BYTE   byRes[128];                                    /* ֶ */
}NETDEV_FACE_STRUCT_INFO_S,*LPNETDEV_FACE_STRUCT_INFO_S;

/**
 * @struct tagNETDEVPersonAttr
 * @brief Ա
 * @attention  None
 */
typedef struct tagNETDEVPersonAttr
{
    UINT32 udwGender;                                     /* Ա  NETDEV_GENDER_TYPE_E */
    UINT32 udwAgeRange;                                   /*   NETDEV_AGE_RANGE_E */
    UINT32 udwSleevesLength;                              /* ³̿ʽ  NETDEV_SLEEVES_LENGTH_E */
    UINT32 udwCoatColor;                                  /* ɫ  NETDEV_CLOTHES_COLOR_E */
    UINT32 udwTrousersLength;                              /* ³̿ʽ  NETDEV_TROUSERS_STYLE_E */
    UINT32 udwTrousersColor;                              /* ɫ  NETDEV_CLOTHES_COLOR_E */
    UINT32 udwBodyToward;                                 /* ץ³  NETDEV_BODY_TOWARD_E */
    UINT32 udwShoesTubeLength;                            /* Ьӳ̿ʽ  NETDEV_SHOES_TUBE_LENGTH_E */
    UINT32 udwHairLength;                                 /* ͳ  NETDEV_HAIR_LENGTH_E */
    UINT32 udwBagFlag;                                    /* ǷЯ־  NETDEV_BAG_FLAG_E */
    BYTE   byRes[128];                                    /* ֶ  */
}NETDEV_PERSON_ATTR_S,*LPNETDEV_PERSON_ATTR_S;

/**
 * @struct tagNETDEVPersonStructInfo
 * @brief ԱϢ
 * @attention  None
 */
typedef struct tagNETDEVPersonStructInfo
{
    UINT32 udwPersonID;                                   /* ԱID */
    UINT32 udwPersonDoforFaceID;                          /* ԱID */
    CHAR   szPosition[NETDEV_LEN_64];                     /* ԱλϢ */
    UINT32 udwSmallPicAttachIndex;                        /* ԱӦСͼͼбе */
    UINT32 udwLargePicAttachIndex;                        /* ԱӦĴͼͼбе */
    CHAR   szFeaturVersion[NETDEV_LEN_64];                /* ṹͰ汾 */
    CHAR   szFeature[NETDEV_LEN_1024];                    /* ṹϢ base64 ǰ512 Bytes */
    NETDEV_PERSON_ATTR_S stPersonAttr;                    /* ԱϢ */
    BYTE   byRes[128];                                    /* ֶ */
}NETDEV_PERSON_STRUCT_INFO_S,*LPNETDEV_PERSON_STRUCT_INFO_S;

/**
 * @struct tagNETDEVNonMotorVehicleAttr
 * @brief ǻϢ
 * @attention  None
 */
typedef struct tagNETDEVNonMotorVehAttr
{
    UINT32 udwSpeedType;                                  /* ṹзǻٶ  NETDEV_SPEED_TYPE_E */
    UINT32 udwImageDirection;                             /* ṹзǻԻ˶  NETDEV_IMAGE_DIRECTION_E */
    UINT32 udwNonVehicleType ;                            /* ǻ  NETDEV_NON_VEH_TYPE_E */
    BYTE   byRes[128];                                    /* ֶ */
}NETDEV_NO_MOTOR_VEH_ATTR_S,*LPNETDEV_NO_MOTOR_VEH_ATTR_S;

/**
 * @struct tagNETDEVNonMotorVehInfo
 * @brief ǻϢ
 * @attention  None
 */
typedef struct tagNETDEVNonMotorVehInfo
{
    UINT32 udwID;                                         /* ǻID */
    CHAR   szPosition[NETDEV_LEN_64];                     /* ǻλϢ */
    UINT32 udwSmallPicAttachIndex;                        /* ǻӦСͼͼбе */
    UINT32 udwLargePicAttachIndex;                        /* ǻӦĴͼͼбе */
    NETDEV_NO_MOTOR_VEH_ATTR_S stNoMotorVehAttr;          /* ǻϢ */
    UINT32 udwPersonOnNoVehiNum;                          /* ݳԱĿ */
    LPNETDEV_PERSON_ATTR_S pstPersonAttr;                 /* Ա 趯̬ڴ */
    BYTE   byRes[128];                                    /* ֶ */
}NETDEV_NON_MOTOR_VEH_INFO_S,*LPNETDEV_NON_MOTOR_VEH_INFO_S;

/**
 * @struct tagNETDEVPlateAttr
 * @brief Ϣ
 * @attention  None
 */
typedef struct tagNETDEVPlateAttr
{
    CHAR   szPlateNo[NETDEV_LEN_64];                      /* ƺ */
    UINT32 udwColor;                                      /* ɫ  NETDEV_PLATE_COLOR_E */
    UINT32 udwType;                                       /*   NETDEV_PLATE_TYPE_E */
    BYTE   byRes[128];                                    /* ֶ */
}NETDEV_PLATE_ATTR_S,*LPNETDEV_PLATE_ATTR_S;

/**
 * @struct tagNETDEVVehicleInfo
 * @brief Ϣ
 * @attention  None
 */
typedef struct tagNETDEVVehicleInfo
{
    UINT32 udwID;                                         /* ID */
    CHAR   szPosition[NETDEV_LEN_64];                     /* λϢ */
    UINT32 udwSmallPicAttachIndex ;                       /* ӦСͼͼбе */
    UINT32 udwLargePicAttachIndex;                        /* ӦĴͼͼбе */
    UINT32 udwPlatePicAttachIndex;                        /* ƶӦСͼͼбе */
    CHAR   szFeatureVersion[NETDEV_LEN_64];               /* ṹͰ汾 */
    CHAR   szFeature[NETDEV_LEN_1024];                    /* ȡϢ base64 ǰ512 Bytes */
    NETDEV_VEH_ATTR_S stVehAttr;                          /* Ϣ */
    NETDEV_PLATE_ATTR_S stPlateAttr;                      /* Ϣ */
    BYTE   byRes[128];                                    /* ֶ */
}NETDEV_VEH_INFO_S, *LPNETDEV_VEH_INFO_S;

/**
 * @struct tagNETDEVObjectInfo
 * @brief ĿϢ
 * @attention  None
 */
typedef struct tagNETDEVObjectInfo
{
    UINT32 udwFaceNum;                                    /*  */
    LPNETDEV_FACE_STRUCT_INFO_S pstFaceInfo;              /* Ϣ 趯̬ڴ */
    UINT32 udwPersonNum;                                  /* Ա */
    LPNETDEV_PERSON_STRUCT_INFO_S pstPersonInfo;          /* ԱϢ 趯̬ڴ */
    UINT32 udwNonMotorVehNum;                             /* ǻ */
    LPNETDEV_NON_MOTOR_VEH_INFO_S pstNonMotorVehInfo;     /* ǻϢ 趯̬ڴ */
    UINT32 udwVehicleNum;                                 /*  */
    LPNETDEV_VEH_INFO_S pstVehInfo;                       /* Ϣ 趯̬ڴ */
    BYTE   byRes[128];                                    /* ֶ */
}NETDEV_OBJECT_INFO_S,*LPNETDEV_OBJECT_INFO_S;

/**
 * @struct tagNETDEVStructImageInfo
 * @brief ͼϢ
 * @attention  None
 */
typedef struct tagNETDEVStructImageInfo
{
    UINT32 udwIndex;                                      /* ͼ */
    UINT32 udwType;                                       /* ͼ */
    UINT32 udwFormat;                                     /* ͼʽ  NETDEV_IMAGE_FORMAT_E*/
    UINT32 udwWidth;                                      /* ͼĿ */
    UINT32 udwHeight;                                     /* ͼĸ߶ */
    UINT32 udwCaptureTime;                                /* ͼƬɼʱ */
    CHAR   szUrl[NETDEV_LEN_260];                         /* ͼƬURL */
    UINT32 udwSize;                                       /* ͼ񾭹base64֮ĳ 3M */
    CHAR*  pszData;                                       /* ͼbase64 */
    BYTE   byRes[128];                                    /* ֶ */
}NETDEV_STRUCT_IMAGE_INFO_S, *LPNETDEV_STRUCT_IMAGE_INFO_S;

/**
 * @struct tagNETDEVStructDataInfo
 * @brief ṹϢ
 * @attention  None
 */
typedef struct tagNETDEVStructDataInfo
{
    NETDEV_OBJECT_INFO_S stObjectInfo;                    /* ĿϢ */
    UINT32 udwImageNum;                                   /* ͼ */
    LPNETDEV_STRUCT_IMAGE_INFO_S pstImageInfo;            /* ͼϢ 趯̬ڴ */
    BYTE   byRes[128];                                    /* ֶ */
}NETDEV_STRUCT_DATA_INFO_S,*LPNETDEV_STRUCT_DATA_INFO_S;

/**
 * @struct tagNETDEVNonMotorVehRecord
 * @brief ǻͨм¼
 * @attention  None
 */
typedef struct tagNETDEVNonMotorVehRecord
{
    UINT32 udwRecordID;                                   /* ṹǻ¼ID */
    UINT32 udwPassingTime;                                /* ʱ UTCʽ λ */
    CHAR   szChannelName[NETDEV_LEN_260];                 /*  Χ[1,63] */
    NETDEV_NON_MOTOR_VEH_INFO_S stNonMotorVehInfo;        /* ǻϢ */
    NETDEV_FILE_INFO_S stNoMotorVehImage;                 /* ǻץͼƬ ͼƬܺĴС500K */
    NETDEV_FILE_INFO_S stPanoImage;                       /* ȫͼ ЯͼƬURLsize ͼƬҪͨ/LAPI/V1.0/System/Pictureӿڻȡ*/
    BYTE   byRes[256];                                    /* ֶ */
}NETDEV_NON_MOTOR_VEH_RECORD_S,*LPNETDEV_NON_MOTOR_VEH_RECORD_S;

/**
 * @struct tagNETDEVPersonPassRecord
 * @brief Աͨм¼ϸϢ
 * @attention  None
 */
typedef struct tagNETDEVPersonPassRecord
{
    UINT32 udwRecordID;                                   /* ṹԱ¼ID */
    UINT32 udwPassingTime;                                /* ʱ UTCʽ λ */
    CHAR   szChannelName[NETDEV_LEN_260];                 /* ץͨ Χ[1,63] */
    NETDEV_FACE_ATTR_S   stFaceAttr;                      /* Ϣ */
    NETDEV_PERSON_ATTR_S stPersonAttr;                    /* ԱϢ */
    NETDEV_FILE_INFO_S   stFaceImage;                     /* ץͼƬ ͼƬܺĴС500K */
    NETDEV_FILE_INFO_S   stPersonImage;                   /* ץͼƬ ͼƬܺĴС500K */
    NETDEV_FILE_INFO_S   stPanoImage;                     /* ȫͼ ЯͼƬURLsize ͼƬҪͨ/LAPI/V1.0/System/Pictureӿڻȡ*/
    BYTE   byRes[256];                                    /* ֶ */
}NETDEV_PERSON_PASS_RECORD_S,*LPNETDEV_PERSON_PASS_RECORD_S;

/**
 * @struct tagNETDEVRectanglePoint
 * @brief 
 * @attention  None
 */
typedef struct tagNETDEVRectanglePoint
{
    NETDEV_POINT_S   stTopLeft;          /* Ͻǵ */
    NETDEV_POINT_S   stBottomRight;      /* ½ǵ */
    BYTE             byRes[256];         /* ֶ */
}NETDEV_RECTANGLE_POINT_S, *LPNETDEV_RECTANGLE_POINT_S;

/**
 * @struct tagNETDEVManualLink
 * @brief ֶ
 * @attention  None
 */
typedef struct tagNETDEVManualLink
{
    UINT32 udwType;                                       /*   NETDEV_LINKAGE_TYPE_E*/
    NETDEV_POINT_S stPoint;                               /*  TypeΪ02ʱЧ */
    NETDEV_RECTANGLE_POINT_S stRectangle;                 /*  TypeΪ1ʱЧ */
    BYTE   byRes[128];                                    /* ֶ */
}NETDEV_MANUAL_LINK_S,*LPNETDEV_MANUAL_LINK_S;

/**
 * @struct tagstNETDEVNICCapInfo
 * @brief 豸Ϣ
 * @attention 
 */
typedef struct tagstNETDEVNICCapInfo
{
    UINT32   udwWorkModeNum;                                      /* ֵ֧Ĺģʽ NVRVMS֧ */
    UINT32   audwWorkModeList[NETDEV_MAX_NIC_WORK_MODE_NUM];      /* ֵ֧Ĺģʽб,öٲοģʽ#NETDEV_NIC_WORK_MODE_E  */
    UINT32   udwNICNum;                                           /*  */
    UINT32   udwPortWorkModeNum;                                  /* ڹģʽ IPC֧ */
    UINT32   audwPortWorkModeList[NETDEV_MAX_PORT_WORK_MODE_NUM]; /* ڹģʽб,öٲοڹģʽ#NETDEV_PORT_WORK_MODE_E */

    BYTE    byRes[512];                                           /* ֶ  Reserved field */
}NETDEV_NIC_CAP_INFO_S, *LPNETDEV_NIC_CAP_INFO_S;

/**
 * @brief 豸ַϢ ṹ嶨 
 * @attention  None
 */
typedef struct tagNETDEVDevAddrInfo
{
    CHAR    szUserName[NETDEV_LEN_64];          /* û User Name */
    CHAR    szPassword[NETDEV_LEN_64];          /*  Password */
    CHAR    szIPv4Address[NETDEV_LEN_32];       /* IPv4IPַ  IP address of IPv4 */
    CHAR    szIPv4GateWay[NETDEV_LEN_32];       /* IPv4صַ  Gateway of IPv4 */
    CHAR    szIPv4SubnetMask[NETDEV_LEN_32];    /* IPv4  Subnet mask of IPv4 */
    CHAR    szDevSerailNum[NETDEV_LEN_64];      /* 豸к  Device serial number */
    CHAR    szDevMac[NETDEV_LEN_64];            /* 豸MACַ  Device MAC address */
    BYTE    byRes[512];                         /* ֶ  Reserved */
}NETDEV_DEV_ADDR_INFO_S, *LPNETDEV_DEV_ADDR_INFO_S;

/**
 * @struct tagstEventRecordParam
 * @brief ¼¼
 * @attention 
 */
typedef struct tagstEventRecordParam
{
    UINT32  udwNum;                                                /* ͨ */
    UINT32* pudwChannels;                                         /* ͨż */
    UINT32  udwRecordType;                                        /* ¼  NETDEV_EVENT_RECORD_TYPE_E*/
    INT64   tBegin;                                               /* ѯʱ¼Ŀʼʱ䡣UTCʱ䣬λs */
    INT64   tEnd;                                                 /* ѯʱ¼Ľʱ䡣UTCʱ䣬λs */
    UINT32  udwLimit;                                             /* ÿһҳݵĸڶԲѯʱ¼ҳ */
    UINT32  udwPage;                                              /* ҳţLimitȷβѯȡ¼¼¼Limitҳ󣬵Pageҳ */
    BYTE    byRes[256];                                           /* ֶ  */
}NETDEV_EVENT_RECORD_PARAM_S,*LPNETDEV_EVENT_RECORD_PARAM_S;

/**
 * @struct tagstEventRecordInfo
 * @brief ¼¼Ϣ
 * @attention 
 */
typedef struct tagstEventRecordInfo
{
    UINT32 udwChannelID;                                          /* ¼¼ͨͨ */
    UINT32 udwRecordType;                                         /* ¼  NETDEV_EVENT_RECORD_TYPE_E*/
    UINT32 udwBegin;                                              /* ¼¼Ŀʼʱ䣬ΪUTCʱ */
    UINT32 udwEnd;                                                /* ¼¼ĽΪUTCʱ */
    BYTE    byRes[256];                                           /* ֶ  */
}NETDEV_EVENT_RECORD_INFO_S,*LPNETDEV_EVENT_RECORD_INFO_S;

/**
 * @brief ǿϢ ṹ嶨 
 * @attention  None
 */
typedef struct tagNETDEVEnhancedConfigInfo
{
    BOOL    bEnabledStorage;        /* UNP/豸洢ʹ״̬0:رգ1: */
    BYTE    byRes[512];                         /* ֶ  Reserved */
}NETDEV_ENHANCED_CONFIG_INFO_S, *LPNETDEV_ENHANCED_CONFIG_INFO_S;

/**
 * @struct tagNETDEVGISMapInfo
 * @brief GISͼϢ
 * @attention  None
 */
typedef struct tagNETDEVGISMapInfo
{
    DOUBLE dlLatitude;                                       /* ľ Χ[-180.00, +180.00] */
    DOUBLE dlLongitude;                                      /* γ Χ[-90.00,+90.00] */
    UINT32 udwInitZoomLevel;                                  /* ʼż Χ[3,999] */
    BYTE   byRes[128];                                       /* ֶ */
}NETDEV_GIS_MAP_INFO_S, *LPNETDEV_GIS_MAP_INFO_S;

/**
 * @struct tagNETDEVMapConfigInfo
 * @brief ͼϢ
 * @attention  None
 */
typedef struct tagNETDEVMapConfigInfo
{
    UINT32 udwType;                                       /* ͼ  NETDEV_MAP_TYPE_E*/
    NETDEV_GIS_MAP_INFO_S stGisMapInfo;                   /* GISͼϢͼƬͼʱýڵѡ */
    BYTE   byRes[128];                                    /* ֶ */
}NETDEV_MAP_CONFIG_INFO_S, *LPNETDEV_MAP_CONFIG_INFO_S;

/**
 * @struct tagNETDEVExcpAlarmCapInfo
 * @brief 豸쳣Ϣ
 * @attention 
 */
typedef struct tagNETDEVExcpAlarmCapInfo
{
    UINT32   udwSupportTypeNum;                                    /* ֵ֧쳣 */
    UINT32   audwSupportType[NETDEV_LEN_64];                       /* ֵ֧쳣,öٲο# NETDEV_EXCP_ALARM_CAP_TYPE_E  */

    BYTE    byRes[512];                                            /* ֶ */
}NETDEV_EXCP_ALARM_CAP_INFO_S, *LPNETDEV_EXCP_ALARM_CAP_INFO_S;

/**
* @struct tagNETDEVPositionInfo
* @brief λϢ
* @attention  None
*/
typedef struct tagNETDEVPositionInfo
{
    UINT32 udwChannelId;    /* ͨID */
    NETDEV_POINT_S stPoint; /* λͨеϢ,ͼлλֱȱʾ,Χ[0,9999) */

    BYTE    byRes[128];     /* ֶ */
}NETDEV_POSTION_INFO_S, *LPNETDEV_POSTION_INFO_S;

/**
* @struct tagNETDEVFirePointInfo
* @brief Ϣ
* @attention  None
*/
typedef struct tagNETDEVFirePointInfo
{
    UINT32 udwChannelNum;                                 /* ͨ */
    NETDEV_POSTION_INFO_S stPositionList[NETDEV_LEN_16];  /* ڲͬͨµλбChannelNumΪ0ʱѡ */

    BYTE    byRes[256];                                           /* ֶ */
}NETDEV_FIRE_POINT_INFO, *LPNETDEV_FIRE_POINT_INFO;

/**
* @struct tagNETDEVConflagrationAlarmInfo
* @brief ϱϢ
* @attention  None
*/
typedef struct tagNETDEVConflagrationAlarmInfo
{
    CHAR   szReference[NETDEV_LEN_260];                           /* Ϣ */
    UINT32 udwTimeStamp;                                          /* 澯ʱ UTCʱ λ */
    UINT32 udwAlarmSeq;                                           /* 澯 */
    NETDEV_GEOLACATION_INFO_S stPTPosition;                       /* ֻλʱ̨λ */
    FLOAT fLensView;                                              /* ֻλʱľͷӳǽǶȣȷСλ */
    UINT32 udwNum;                                                /*  */
    NETDEV_FIRE_POINT_INFO stFirePointInfoList[NETDEV_LEN_16];    /* ͬλϢбNumΪ0ʱѡ */
    BYTE   byRes[128];                                            /* ֶ */
}NETDEV_CONFLAGRATION_ALARM_INFO_S, *LPNETDEV_CONFLAGRATION_ALARM_INFO_S;

/**
 * @struct tagNETDEVMotionDetectionInfo
 * @brief ˶Ϣ
 * @attention 
 */
typedef struct tagNETDEVMotionDetectionInfo
{
    BOOL    bIsSupportCfg;                           /* Ƿֿ֧,0֧ 1֧ */
    UINT32  udwRectangleAreaNum;                     /* ֧־μ,֧־ʱѡ,IPC֧ */
    UINT32  udwBlockWidth;                           /* ֵ */
    UINT32  udwBlockHeight;                          /* ߶ֵ */

    BYTE    byRes[256];                              /* ֶ */
}NETDEV_MOTION_DETECTION_INFO_S, *LPNETDEV_MOTION_DETECTION_INFO_S;

/**
 * @struct tagNETDEVTamperDetectionInfo
 * @brief ڵϢ
 * @attention 
 */
typedef struct tagNETDEVTamperDetectionInfo
{
    BOOL    bIsSupportCfg;                           /* 豸Ƿֿ֧,0֧ 1֧ */
    UINT32  udwTamperRectangleAreaNum;               /* ڵɻĿǰ̶1 */

    BYTE    byRes[256];                              /* ֶ */
}NETDEV_TAMPER_DETECTION_INFO_S, *LPNETDEV_TAMPER_DETECTION_INFO_S;

/**
 * @struct tagNETDEVHumanShapeDetectionInfo
 * @brief μϢ
 * @attention 
 */
typedef struct tagNETDEVHumanShapeDetectionInfo
{
    BOOL    bIsSupportCfg;                           /* 豸Ƿֿ֧,0֧ 1֧ */
    UINT32  udwRectangleAreaNum;                     /* μɻĿǰ̶1 */

    BYTE    byRes[256];                              /* ֶ */
}NETDEV_HUMAN_SHAPE_DETECTION_INFO_S, *LPNETDEV_HUMAN_SHAPE_DETECTION_INFO_S;

/**
 * @struct tagNETDEVAudioDetectionInfo
 * @brief ƵϢ
 * @attention 
 */
typedef struct tagNETDEVAudioDetectionInfo
{
    BOOL    bIsSupportCfg;                           /* Ƿֿ֧,0֧ 1֧ */

    BYTE    byRes[256];                              /* ֶ */
}NETDEV_AUDIO_DETECTION_INFO_S, *LPNETDEV_AUDIO_DETECTION_INFO_S;

/**
* @struct tagNETDEVConflagDetectInfo
* @brief Ϣ
* @attention  None
*/
typedef struct tagNETDEVConflagDetectInfo
{
    BOOL   bIsSupportCfg;                                 /* Ƿֿ֧ 0:֧ 1:֧ */
    BYTE   byRes[52];                                     /* ֶ */
}NETDEV_CONFLAG_DETECT_INFO_S, *LPNETDEV_CONFLAG_DETECT_INFO_S;

/**
 * @struct tagNETDEVChannelsAlarmCapInfo
 * @brief 豸ͨ澯Ϣ
 * @attention 
 */
typedef struct tagNETDEVChannelsAlarmCapInfo
{
    NETDEV_MOTION_DETECTION_INFO_S         stMotionDetectionInfo;                /* ˶Ϣ */
    NETDEV_TAMPER_DETECTION_INFO_S         stTamperDetectionInfo;                /* ڵϢ */
    NETDEV_HUMAN_SHAPE_DETECTION_INFO_S    stHumanShapeDetectionInfo;            /* μϢ */
    NETDEV_AUDIO_DETECTION_INFO_S          stAudioDetectionInfo;                 /* ƵϢ */
    NETDEV_CONFLAG_DETECT_INFO_S           stConfiagDetectInfo;                  /* Ϣ */
    BYTE    byRes[456];                                                          /* ֶ */
}NETDEV_CHN_ALARM_CAP_INFO_S, *LPNETDEV_CHN_ALARM_CAP_INFO_S;

/**
 * @struct tagNETDEVVertifyInfo
 * @brief ֤Ϣ
 * @attention
 */
typedef struct tagNETDEVResetPwdVertifyInfo
{
    CHAR                          szEMail[NETDEV_LEN_256];   /*  */
    CHAR                          szPhone[NETDEV_LEN_256];   /* 绰 */
    BYTE                          byRes[256];                /* ֶ */
}NETDEV_RESET_PWD_VERTIFY_INFO_S, *LPNETDEV_RESET_PWD_VERTIFY_INFO_S;

/**
 * @struct tagNETDEVStorageQuotaInfo
 * @brief 洢Ϣ ṹ嶨
 * @attention  None
 */
typedef struct tagNETDEVStorageQuotaInfo
{
    INT32      dwStorageCapUnit;             /* 洢λ(ĬΪGB),μ#NETDEV_STORAGE_CAP_UNIT_E */
    INT32      dwRecUsedCap;                 /* ͨ¼ */
    INT32      dwPicUsedCap;                 /* ͨץͼ */
    INT32      dwAIPicUsedCap;               /* ͨץƬIPCѡ */
    INT32      dwUsedCap;                    /* ͨ洢ռʹIPCѡ */
    INT32      dwTotalCap;                   /* ͨ洢ռ */
    INT32      dwRecQuota;                   /* ͨ¼ */
    INT32      dwPicQuota;                   /* ͨץͼ */
    INT32      dwAIPicQuota;                 /* ͨץͼƬIPCѡ */
    INT32      dwGroupID;                    /* ID */
    INT32      dwGroupTotalCap;              /* ѡ */
    BYTE       byRes[256];                   /* ֶ */
}NETDEV_STORAGE_QUOTA_INFO_S, *LPNETDEV_STORAGE_QUOTA_INFO_S;

/**
 * @struct tagNETDEVPicStorageStrategyInfo
 * @brief ͼƬ洢Ϣ ṹ嶨
 * @attention  None
 */
typedef struct tagNETDEVPicStorageStrategyInfo
{
    INT32     dwStorageMode;        /* 洢ģʽμö#NETDEV_PIC_STORAGE_MODE_E */
    INT32     dwFullStrategy;       /* ԲĬǣμö#NETDEV_FULL_STRATEGY_TYPE_E */
    BYTE      byRes[256];           /* ֶ */
}NETDEV_PIC_STORAGE_STRATEGY_INFO_S, *LPNETDEV_PIC_STORAGE_STRATEGY_INFO_S;

/**
 * @struct tagNETDEVRecStorageStrategyInfo
 * @brief Ƶ洢Ϣ ṹ嶨
 * @attention ֻ֧
 */
typedef struct tagNETDEVRecStorageStrategyInfo
{
    BOOL      bStoregeEnabled;      /* 洢ʹ,0:,1:ر */
    INT32     dwFullStrategy;       /* ԲĬǣμö#NETDEV_FULL_STRATEGY_TYPE_E */
    INT32     dwPlanStreamType;     /* ƻ洢ͣμ#NETDEV_LIVE_STREAM_INDEX_E */
    INT32     dwManualStreamType;   /* ֶ洢ͣμ#NETDEV_LIVE_STREAM_INDEX_E */
    INT32     dwEventStreamType;    /* 澯洢ͣμ#NETDEV_LIVE_STREAM_INDEX_E */
    BYTE      byRes[256];           /* ֶ */
}NETDEV_REC_STORAGE_STRATEGY_INFO_S, *LPNETDEV_REC_STORAGE_STRATEGY_INFO_S;

/**
 * @struct tagNETDEVStorageStrategy
 * @brief 洢Ϣ ṹ嶨
 * @attention  None
 */
typedef struct tagNETDEVStorageStrategy
{
    INT32                                     dwStorageRes;               /* 洢Դ, IPCѡ,μ#NETDEV_STORAGE_RES_TYPE_E */
    NETDEV_REC_STORAGE_STRATEGY_INFO_S        stRecStoreStrategyInfo;     /* Ƶ洢Ϣ */
    NETDEV_PIC_STORAGE_STRATEGY_INFO_S        stPicStoreStrategyInfo;     /* ͨץͼƬ洢Ϣ */
    NETDEV_PIC_STORAGE_STRATEGY_INFO_S        stAIPicStoreStrategyInfo;   /* ץͼƬ洢Ϣ */
    BYTE                                      byRes[512];                 /* ֶ */
}NETDEV_STORAGE_STRATEGY_S, *LPNETDEV_STORAGE_STRATEGY_S;

/** struct tagNETDEVBackFocusInfo
 * @brief 󽹵ڲϢ
 * @attention
 */
typedef struct tagNETDEVBackFocusInfo
{
    UINT32                  udwCmd;                     /*  # NETDEV_BACKFOCUS_CMD_E */
    UINT32                  udwPara1;                   /*  # NETDEV_BACKFOCUS_CMD_E */
    BYTE                    byRes[256];                 /* ֶ */
}NETDEV_BACKFOCUS_INFO_S, *LPNETDEV_BACKFOCUS_INFO_S;

////////////////////////////ָ/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/************************************************************************/
/*                                                            */
/************************************************************************/
/**
* SDK ʼ  SDK initialization
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note ̲߳ȫ Thread not safe
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_Init(void);

/**
* SDK   SDK cleaning
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_Cleanup(void);

/**
* ȡSDKİ汾Ϣ Get SDK version information 
* @return SDK汾Ϣ SDK version information
* @note
* - ֽи8λʾ汾,Ͱλʾΰ汾.ֽڱʾӰ汾0x01080000ʾ汾Ϊ1.8.0.0.
* - The two high bytes,The high-8-bit indicate the major version, and the low-8-bytes indicate the minor version.Two low bytes for additional version numbers For example, 0x01080000 means version 1.8.0.0
*/
NETDEV_API NEWINTERFACE INT32 STDCALL NETDEV_GetSDKVersion(void);

/**
* ȡ  Get error codes
* @return  Error codes
*/
NETDEV_API NEWINTERFACE INT32 STDCALL NETDEV_GetLastError();

/**
* ־·ҵ Set log path
* @param [IN]   pszLogPath  ־·(ļ)  Log path (file name not included)
* @return TRUEʾɹ,ʾʧ  TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetLogPath(IN CHAR *pszLogPath);

/**
* ־ļС Set log file size and number
* @param [IN] dwLogFileSize     ־ļС(λֽ) The size of single log file
* @param [IN] dwLogFileNum      ־ļ  Log file number
* @return TRUEʾɹ,ʾʧ TRUE means success, any other value indicates failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_ConfigLogFile(IN INT32 dwLogFileSize,
                                                          IN INT32 dwLogFileNum);

/**
* д־ı Set write log flag
* @param [IN]   bWriteLogFlag  д־ı  TRUE:д־,FALSEд־
* @return VOID
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetWriteLogFlag(IN BOOL bWriteLogFlag);

/**
* óʱʱ Set timeout
* @param [IN]  pstRevTimeout         ʱʱָ Pointer to timeout
* @return TRUEʾɹ,ʾʧ    TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetRevTimeOut(IN LPNETDEV_REV_TIMEOUT_S pstRevTimeout);

/**
* ñ Set keep-alive parameters
* @param [IN]  dwWaitTime            ȴʱ  Waiting time
* @param [IN]  dwTrytimes            Ӵ  Connecting attempts
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetConnectTime(IN INT32 dwWaitTime,
                                                           IN INT32 dwTrytimes);

/**
* ÿͻΨһʶ
* @param [IN] pszClientID                              ͻID 
* @return TRUEʾɹʾʧ
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetClientID(IN CHAR *pszClientID);


/**
* ·
* @param [IN]  dwMaxdecNum        ͨ
* @return TRUEʾɹʾʧ
* @note 
*    1ýӿڵʧܣʾ·Ϊ128·
*    2·ʵ·ط·¼·ܺ
*    3ýӿڵñSDKʼ֮ǰ
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetMaxDecChlNum(IN UINT32 dwMaxdecNum);

/**
* 豸ֻص Device discovery callback function
* @param [IN] pstDevInfo                豸Ϣ Device info
* @param [IN] lpUserData                û User data
* @note
*/
typedef void(STDCALL *NETDEV_DISCOVERY_CALLBACK_PF)(IN LPNETDEV_DISCOVERY_DEVINFO_S pstDevInfo,
                                                    IN LPVOID lpUserData);

/**
* ע豸ֻص Registered device discovery callback function
* @param [IN] cbDiscoveryCallBack   ص Callback function
* @param [IN] lpUserData            û User data
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetDiscoveryCallBack(IN NETDEV_DISCOVERY_CALLBACK_PF cbDiscoveryCallBack,
                                                                 IN LPVOID lpUserData);

/**
* 豸 ע豸صĻص,ٵô˽ӿڷ豸,ֵ豸Ϣڻصзӳ
* This interface is used for device discovery. Please first register callback functions related to device discovery and use this interface for device discovery. Discovered device info will be included in the callback function.
* @param [IN]   pszBeginIP                 ʼIPַ
* @param [IN]   pszEndIP                   IPַ
* @return TRUEʾɹ,ʾʧ
* @note pszBeginIPpszEndIP"0.0.0.0",豸
*/
NETDEV_API NEWINTERFACE BOOL  STDCALL NETDEV_Discovery(IN CHAR *pszBeginIP,
                                                       IN CHAR *pszEndIP);

/**
* ޸豸IPַ¼
* @param [IN]   pstDevAddrInfo         Ҫ޸ĵ豸ַϢ
* @return TRUEʾɹ,ʾʧ
* @note 
*/
NETDEV_API NEWINTERFACE BOOL  STDCALL NETDEV_ModifyDeviceAddr(IN LPNETDEV_DEV_ADDR_INFO_S pstDevAddrInfo);

/**
* û¼  User login
* @param [IN]  pszDevIP         豸IP Device IP
* @param [IN]  wDevPort         豸˿ Device server port
* @param [IN]  pszUserName      û Username
* @param [IN]  pszPassword       Password
* @param [OUT] pstDevInfo       豸Ϣṹָ Pointer to device information structure
* @return صû¼, 0 ʾʧ,ֵʾصû¼ֵ. Returned user login ID. 0 indicates failure, and other values indicate the user ID.
* @note
*/
NETDEV_API NEWINTERFACE LPVOID STDCALL NETDEV_Login(IN char *pszDevIP,
                                                    IN INT16 wDevPort,
                                                    IN char *pszUserName,
                                                    IN char *pszPassword,
                                                    OUT LPNETDEV_DEVICE_INFO_S pstDevInfo);

/**
* ½ٶŻ û¼  User login
* @param  [INOUT]  pstLoginInfo         ¼Ϣ Login Info
* @return صû¼, 0 ʾʧ,ֵʾصû¼ֵ. Returned user login ID. 0 indicates failure, and other values indicate the user ID.
* @note
*/
NETDEV_API NEWINTERFACE LPVOID STDCALL NETDEV_LoginV2(INOUT LPNETDEV_LOGIN_INFO_S pstLoginInfo);

/**
* 豸¼
* @param [IN]  pstDevLoginInfo  豸¼Ϣ
* @param [OUT] pstSELogInfo     ȫ¼Ϣ¼ʧܴ´ε¼ʱ
* @return ֵΪûID
* @note ȫ¼ϢֶνʹLAPIЭ¼豸
* -
*/
NETDEV_API NEWINTERFACE LPVOID STDCALL NETDEV_Login_V30(IN LPNETDEV_DEVICE_LOGIN_INFO_S pstDevLoginInfo, 
                                                        OUT LPNETDEV_SELOG_INFO_S pstSELogInfo);

/**
* ûע  User logout
* @param [IN] lpUserID    û¼ User login ID
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_Logout(IN LPVOID lpUserID);

/**
* ո澯ϢĻص  Callback function to receive alarm information
* @param [IN] lpUserID              û¼ User login ID
* @param [IN] dwChannelID           ͨ Channel ID
* @param [IN] LPNETDEV_ALARM_INFO_S 澯Ϣ Alarm information
* @param [IN] lpBuf                 ָ Pointer to buffer
* @param [IN] dwBufLen              澯ϢӦṹĳ Length of structure for alarm information
* @param [IN] lpUserData            û User data
* @note
*/
typedef void(STDCALL *NETDEV_AlarmMessCallBack_PF)(IN LPVOID lpUserID,
                                                   IN INT32 dwChannelID,
                                                   IN NETDEV_ALARM_INFO_S stAlarmInfo,
                                                   IN LPVOID lpBuf,
                                                   IN INT32 dwBufLen,
                                                   IN LPVOID lpUserData);

/**
* עص,ձϢȣͬʱص¼ID,ֲͬ豸 Register callback function and receive alarm information, etc. (Call back login ID at the same time to distinguish different devices)
* @param [IN] lpUserID              û¼ User login ID
* @param [IN] cbAlarmMessCallBack   ص Callback function
* @param [IN] lpUserData            û User data
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetAlarmCallBack(IN LPVOID lpUserID,
                                                             IN NETDEV_AlarmMessCallBack_PF cbAlarmMessCallBack,
                                                             IN LPVOID lpUserData);

/**
* ո澯ϢĻص  Callback function to receive alarm information
* @param [IN] lpUserID                   û¼ User login ID
* @param [IN] LPNETDEV_ALARM_INFO_V2_S   澯Ϣ Alarm information
* @param [IN] lpUserData                 û User data
* @note
*/
typedef void(STDCALL *NETDEV_AlarmMessCallBackV2_PF)(IN LPVOID lpUserID,
                                                     IN NETDEV_ALARM_INFO_EX_S stAlarmInfo,
                                                     IN LPVOID lpUserData);

/**
* עص,ձϢȣͬʱص¼ID,ֲͬ豸
* @param [IN] lpUserID              û¼
* @param [IN] cbAlarmMessCallBack   ص
* @param [IN] pstSubscribeInfo      澯Ϣ
* @param [IN] lpUserData            û
* @return TRUEʾɹ,ʾʧ
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetAlarmCallBackV2(IN LPVOID lpUserID, 
                                                               IN NETDEV_AlarmMessCallBackV2_PF cbAlarmMessCallBack,
                                                               IN LPNETDEV_ALARM_SUB_INFO_S pstSubscribeInfo, 
                                                               IN LPVOID lpUserData);

/**
* ո澯ϢĻص Callback function to receive alarm information
* @param [IN] lpUserID              û¼ID
* @param [IN] pstReportInfo         ϱϢ Alarm information
* @param [IN] lpBuf                 ָ Pointer to buffer
* @param [IN] dwBufLen              澯ϢӦṹĳ Length of structure for alarm information
* @param [IN] dwBufLen              û User data
* @note
*/
typedef void(STDCALL *NETDEV_AlarmMessCallBack_PF_V30)(IN LPVOID lpUserID,
                                                       IN LPNETDEV_REPORT_INFO_S pstReportInfo,
                                                       IN LPVOID    lpBuf,
                                                       IN INT32     dwBufLen,
                                                       IN LPVOID    lpUserData);


/**
* עصձϢ
* Register callback function and receive alarm information, etc.
* @param [IN] lpUserID              û¼ID User login ID
* @param [IN] cbAlarmMessCallBack   ص Callback function
* @param [IN] lpUserData            û User data
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetAlarmCallBack_V30(IN LPVOID lpUserID,
                                                                 IN NETDEV_AlarmMessCallBack_PF_V30 cbAlarmMessCallBack,
                                                                 IN LPVOID lpUserData);

/**
 * @struct tagstNETDEVExceptionOutputInfo
 * @brief 쳣Ϣ
 * @attention
 */
typedef struct tagstNETDEVExceptionOutputInfo
{
    INT32    dwEventCode;                                      /* ¼루NDϱ쳣ʹã */
    INT64    tPlayBackTime;                                    /* طžʱ(NDϱ쳣ʹ) */
    CHAR     szFileName[NETDEV_LEN_256];                       /* ַ */
    BYTE     byRes[128];                                       /* ֶ */
}NETDEV_EXCEPTION_OUTPUT_INFO_S, *LPNETDEV_EXCEPTION_OUTPUT_INFO_S;

/**
* 쳣.ϢĻص  Callback function to receive exception and reconnection messages
* @param [IN] lpUserID     û¼ User login ID
* @param [IN] dwType       쳣Ϣ:NETDEV_EXCEPTION_TYPE_E Type of exception or reconnection message: NETDEV_EXCEPTION_TYPE_E
* @param [IN] lpExpHandle  쳣Ӧ͵ľ Exception type handle
* @param [IN] lpUserData   û User data
* @param [OUT] pstExceptionOutputInfo   쳣Ϣ Exception output information
* @note
*/
typedef void(STDCALL *NETDEV_ExceptionCallBack_PF)(IN LPVOID lpUserID,
                                                   IN INT32 dwType,
                                                   IN LPVOID lpExpHandle,
                                                   IN LPVOID lpUserData,
                                                   IN LPNETDEV_EXCEPTION_OUTPUT_INFO_S pstExceptionOutputInfo
                                                   );

/**
* עsdk쳣.ϢĻص  Callback function to register SDK, receive exception and reconnection messages, etc.
* @param [IN] cbExceptionCallBack       쳣ϢĻص,صǰ쳣Ϣ Callback function to receive exception messages, used to call back information about current exceptions
* @param [IN] lpUserData                û User data
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetExceptionCallBack(IN NETDEV_ExceptionCallBack_PF cbExceptionCallBack,
                                                                 IN LPVOID lpUserData);

/**
* Ϣ
* @param [IN] lpUserID          û¼ID
* @param [IN] dwAlarmType   ĸ澯 μNETDEV_SUBSCRIBE_ALARM_TYPE_Eʹû
* @return TRUEʾɹʾʧ
* @note   ǰҪȵNETDEV_SetAlarmCallBackӿעص
* -
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_Subscribe(IN LPVOID lpUserID,
                                                      IN INT32 dwAlarmType);

/**
* ȡϢ
* @param [IN] lpUserID          û¼ID
* @return TRUEʾɹʾʧ
* @note
* -
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_Unsubscribe(IN LPVOID lpUserID);


/**
* ȡ豸Ϣ        GetDeviceInfos
* @param [IN] lpUserID          û¼ User login handle
* @param [OUT] pstDevInfo       豸Ϣṹָ Pointer to device information structure
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_GetDeviceInfo(IN LPVOID lpUserID ,
                                                          OUT LPNETDEV_DEVICE_INFO_S pstDevInfo);

/**
* ȡ豸Ϣ
* @param [IN] lpUserID                 û¼ID
* @param [OUT] pstDeviceInfo         豸Ϣ
* @return TRUEʾɹʾʧ
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_GetDeviceBaseInfo(IN LPVOID lpUserID, 
                                                              OUT LPNETDEV_DEVICE_BASE_INFO_S pstDeviceInfo);

/**
* ѯ豸ϸϢ
* @param [IN] lpUserID              û¼ID
* @param [IN] dwDevID               豸ID
* @param [OUT]  pstDevDetailInfo    豸ϸϢ
* @return TRUEʾɹʾʧ
* @note
* -
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_GetDeviceInfo_V30(IN LPVOID lpUserID,
                                                              IN INT32 dwDevID,
                                                              OUT LPNETDEV_DEV_INFO_V30_S pstDevDetailInfo);

/**
* ȡ豸Ϣ
* @param [IN] lpUserID                 û¼ID
* @param [OUT] pstDeviceInfo           豸Ϣ
* @return TRUEʾɹʾʧ
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_GetDeviceRunInfo(IN LPVOID lpUserID,
                                                             OUT LPNETDEV_DEVICE_RUN_INFO_S pstDeviceRunInfo);
/***********************************ԿضͻStart**************************************************/

/**
* 豸
* @param [IN] lpUserID                  û¼
* @param [IN]   stDiscoverCondInfo                    豸Ϣ Discover Device Condition Info
* @return TRUEʾɹ,ʾʧ
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_DiscoverDevice(IN LPVOID lpUserID,
                                                           IN LPNETDEV_DISCOVER_COND_INFO_S pstDiscoverCondInfo);

/**
* ȡ豸Ϣб
* @param [IN] lpUserID                  û¼
* @param [IN] pstFindCond               ȡ豸
* @return ֵΪNULLʾʧܡֵΪѯţΪNETDEV_FindNextDiscoverDeviceInfoNETDEV_FindCloseDiscoverDeviceInfoListΡ
* @note 
*/
NETDEV_API NEWINTERFACE LPVOID STDCALL NETDEV_FindDiscoverDeviceInfoList(IN LPVOID lpUserID,
                                                                         IN LPNETDEV_DEVICE_FIND_COND_S pstFindCond);

/**
* ȡһ豸Ϣ
* @param [IN]  lpFindHandle                    Ҿ   Search handle
* @param [OUT] pstDiscoverDeviceInfo           豸Ϣָ   Pointer to saved device info
* @return TRUEʾɹ,ʾʧ
* @note ʧ˵ѯ
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_FindNextDiscoverDeviceInfo(IN LPVOID lpFindHandle,
                                                                       OUT LPNETDEV_DISCOVER_DEV_INFO_S pstDiscoverDeviceInfo);

/*
* رղ豸ϢͷԴ
* @param [IN] lpFindHandle  Ҿ File search handle
* @return TRUEʾɹ,ʾʧ
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_FindCloseDiscoverDeviceInfoList(IN LPVOID lpFindHandle);

/**
* ȡƵͨϢб
* @param [IN] lpUserID          û¼ID
* @param [IN] pstFindCond           ѯ
* @return ѯ,0ʾʧܣֵΪNETDEV_FindNextVideoChnNETDEV_FindCloseVideoChnListȺĲ
* @note
*/
NETDEV_API NEWINTERFACE LPVOID STDCALL NETDEV_FindVideoChnList(IN LPVOID lpUserID,
                                                               IN LPNETDEV_VIDEO_CHN_FIND_COND_S pstFindCond);

/**
* ȡҵ 豸ͨ Ϣ
* @param [IN]  lpFindHandle         Ҿ 
* @param [OUT] pstVideoChannelInfo  ƵͨϢ
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note ʧ˵ѯ A returned failure indicates the end of search.
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_FindNextVideoChn(IN LPVOID lpFindHandle, 
                                                             OUT LPNETDEV_VIDEO_CHN_INFO_S pstVideoChannelInfo);

/**
* رղ 豸ͨϢͷԴ
* @param [IN] lpFindHandle  ļҾ 
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_FindCloseVideoChnList(IN LPVOID lpFindHandle);


/**
* ȡͨϸϢ
* @param [IN] lpUserID              û¼ID
* @param [INOUT] pstDevChnDetailInfo        豸ͨϢ
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note 
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_GetChnDetailInfo(IN LPVOID lpUserID, 
                                                             INOUT LPNETDEV_VIDEO_CHN_INFO_S pstDevChnDetailInfo);

/**
* ޸ͨϢ
* @param [IN] lpUserID              û¼ID
* @param [INOUT] pstChnInfo         ͨϢ
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note 
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_ModifyChnInfo(IN LPVOID lpUserID, 
                                                          IN LPNETDEV_CHN_INFO_S pstChnInfo);

/**
* ȡָ֯Ϣ
* @param [IN] lpUserID              û¼ID
* @param [IN] pstOrgInfo            ֯Ϣָ
* @return TRUE           ʾɹʾʧ TRUE means success, and any other value means failure.
* @note 
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_GetOrgInfo(IN LPVOID lpUserID,
                                                       INOUT LPNETDEV_ORG_INFO_S pstOrgInfo);


/**
* 豸
* @param [IN] lpUserID             û¼ID
* @param [IN] pstAddDevInfo        豸Ϣָ
* @param [OUT] pstAddResultInfo    豸ӦϢָ
* @return TRUE           ʾɹʾʧ TRUE means success, and any other value means failure.
* @note 
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_BatchAddDevice(IN LPVOID lpUserID,
                                                           IN LPNETDEV_ADD_DEV_INFO_S pstAddDevInfo, 
                                                           OUT LPNETDEV_ADD_DEV_RESULT_INFO_S pstAddResultInfo);

/**
* ɾ豸
* @param [IN] lpUserID             û¼ID
* @param [IN] pstDelDevInfo        ɾ豸Ϣָ
* @param [OUT] pstDelResultInfo    ɾ豸ӦϢָ
* @return TRUE           ʾɹʾʧ TRUE means success, and any other value means failure.
* @note 
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_BatchDelDevice(IN LPVOID lpUserID,
                                                           IN LPNETDEV_DEL_DEV_INFO_S pstDelDevInfo, 
                                                           OUT LPNETDEV_DEL_DEV_RESULT_INFO_S pstDelResultInfo);

/**
* ޸Ľ豸Ϣ
* @param [IN] lpUserID             û¼ID
* @param [OUT] pstDeviceInfo    豸Ϣָ
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note 
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_ModifyDeviceInfo(IN LPVOID lpUserID,
                                                                IN LPNETDEV_MODIFY_DEV_INFO_S pstDeviceInfo);


/**
* ȡ豸Ϣ
* @param [IN] lpUserID             û¼ID
* @param [INOUT] pstDeviceInfo    豸Ϣָ
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note 
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_XW_GetDeviceInfo(IN LPVOID lpUserID,
                                                             INOUT LPNETDEV_DEV_BASIC_INFO_S pstDeviceInfo);

/**
* ɾ豸
* @param [IN] lpUserID             û¼ID
* @param [IN] dwDevID    豸ID
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note 
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_XW_DeleteDeviceInfo(IN LPVOID lpUserID,
                                                                IN INT32 dwDevID);

/***********************************ԿضͻEnd*******************************************************/

/**
* Ƶͨ
* @param [IN]   lpUserID                û¼ID User login ID
* @param [IN]   pstChannelsBasicInfo    ƵͨĻϢ  add video ChannelsBasicInfo
* @param [OUT]  pstChannelsInfos        ͨϢ    channel infos
* @return TRUEʾɹ,ʾʧ
* @note 
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_AddVideoChannel(IN LPVOID lpUserID, 
                                                            IN LPNETDEV_CHANNEL_BASIC_INFO_S pstChannelBasicInfo,
                                                            OUT LPNETDEV_CHANNEL_LIST_S pstChannelInfo);

/**
* ޸Ƶͨ
* @param [IN]   lpUserID                û¼ID User login ID
* @param [IN]   dwChannelID             ͨ  Channel ID
* @param [IN]   pstChannelsBasicInfo    ƵͨĻϢ  video ChannelsBasicInfo
* @return TRUEʾɹ,ʾʧ
* @note 
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_ModifyVideoChannel(IN LPVOID lpUserID, 
                                                               IN INT32 dwChannelID, 
                                                               IN LPNETDEV_CHANNEL_BASIC_INFO_S pstChannelsBasicInfo);

/**
* ɾƵͨ
* @param [IN]   lpUserID                û¼ID User login ID
* @param [IN]   pstChannelsInfos        ͨϢChannel infos
* @return TRUEʾɹ,ʾʧ
* @note 
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_DeleteVideoChannel(IN LPVOID lpUserID,
                                                               IN LPNETDEV_CHANNEL_LIST_S pstChannelInfo);

/**
* ȡƵͨ
* @param [IN]   lpUserID                û¼ID User login ID
* @param [OUT]  pstChannelsBasicInfo    ƵͨĻϢ  add video ChannelsBasicInfo
* @return TRUEʾɹ,ʾʧ
* @note 
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_GetVideoChannel(IN LPVOID lpUserID, 
                                                            IN INT32 dwChannelID,
                                                            OUT LPNETDEV_CHANNEL_BASIC_INFO_S pstChannelsBasicInfo);


/**
* ѯƵͨϢб  Query channel info list
* @param [IN]    lpUserID           û¼ User login ID
* @param [INOUT] pdwChlCount        ͨ Number of channels
* @param [OUT]   pstVideoChlList    ͨб List of channel info list
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_QueryVideoChlDetailList(IN LPVOID lpUserID, 
                                                                    INOUT INT32 *pdwChlCount, 
                                                                    OUT LPNETDEV_VIDEO_CHL_DETAIL_INFO_S pstVideoChlList);

/**
* ѯƵͨϢб  Query channel info list
* @param [IN]    lpUserID           û¼ User login ID
* @param [INOUT] pdwChlCount        ͨ Number of channels
* @param [OUT]   pstVideoChlList    ͨб List of channel info list
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_QueryVideoChlDetailListEx(IN LPVOID lpUserID,
                                                                      INOUT INT32 *pdwChlCount,
                                                                      OUT LPNETDEV_VIDEO_CHL_DETAIL_INFO_EX_S pstVideoChlList);

/**
* ѯƵͨϢ  Query video channel info
* @param [IN]   lpUserID           û¼ User login ID
* @param [IN]   dwChannelID        ͨ Channel ID
* @param [OUT]  pstVideoChlInfo    ƵͨϢ video channel info
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_QueryVideoChlInfo(IN LPVOID lpUserID,
                                                              IN INT32 dwChannelID,
                                                              OUT LPNETDEV_VIDEO_CHL_DETAIL_INFO_S pstVideoChlInfo);

/**
* ͨ 豸 ѯ 豸б
* @param [IN] lpUserID              û¼ID
* @param [IN] dwDevType             豸 μ#NETDEV_DEVICE_MAIN_TYPE_E
* @return ѯ,0ʾʧܣֵΪNETDEV_FindNextOrgInfoNETDEV_FindCloseOrgInfoȺĲ
* @note
*/
NETDEV_API NEWINTERFACE LPVOID STDCALL NETDEV_FindDevList(IN LPVOID lpUserID, 
                                                          IN INT32 dwDevType);

/**
* ȡҵ 豸Ϣ
* @param [IN]  lpFindHandle                 Ҿ 
* @param [OUT] pstDevBasicInfo               豸ϸϢָ
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note ʧ˵ѯ A returned failure indicates the end of search.
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_FindNextDevInfo(IN LPVOID lpFindHandle, 
                                                            OUT LPNETDEV_DEV_BASIC_INFO_S pstDevBasicInfo);

/**
* رղ 豸ϢͷԴ
* @param [IN] lpFindHandle  ļҾ 
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_FindCloseDevInfo(IN LPVOID lpFindHandle);

/**
* ȡͨ豸Ϣб
* @param [IN]   lpUserID                û¼ID User login ID
* @return ҵ,0ʾʧ,ֵΪNETDEV_FindNextChlDeviceInfoȺĲ.
* @note ˺ֵΪͨ豸Ϣбҵ,ֵΪ0,ѯͨ豸Ϣбɹ
*         һ.ҵΪNETDEV_FindNextDeviceChlInfolpFindHandle,εNETDEV_FindNextDeviceChlInfo,ȡϸͨ豸Ϣ.
*         .ѯ,ҵΪNETDEV_FindCloseDeviceChlListlpFindHandle,NETDEV_FindCloseDeviceChlList,ͷԴ,رղ.
*/
NETDEV_API NEWINTERFACE LPVOID STDCALL NETDEV_FindDevChlBasicInfoList(IN LPVOID lpUserID);

/**
* ȡͨ豸Ϣ
* @param [IN]   lpFindHandle                ѯHandle
* @param [OUT]  pstDeviceInfo               豸Ϣṹָ
* @return TRUEʾɹ,ʾʧ
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_FindNextDevChlBasicInfo(IN LPVOID lpFindHandle,
                                                                    OUT LPNETDEV_DEVICE_CHL_INFO_S pstDeviceInfo);

/**
* رջȡͨ豸Ϣ
* @param [IN]   lpFindHandle                ѯHandle
* @return TRUEʾɹ,ʾʧ
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_FindCloseDevChlBasicInfo(IN LPVOID lpFindHandle);

/**
* ͨ豸IDͨ ѯͨϢб
* @param [IN] lpUserID          û¼ID
* @param [IN] dwDevID           豸ID
* @param [IN] dwChnType         ͨͣμ# NETDEV_CHN_TYPE_E
* @return ѯ,0ʾʧܣֵΪNETDEV_FindNextDevChnNETDEV_FindCloseDevChnȺĲ
* @note     1ֻͨͲѯʱ豸IDΪ0.
*/
NETDEV_API NEWINTERFACE LPVOID STDCALL NETDEV_FindDevChnList(IN LPVOID lpUserID,
                                                             IN INT32 dwDevID,
                                                             IN INT32 dwChnType);

/**
* ȡҵ 豸ͨ Ϣ
* @param [IN]  lpFindHandle         Ҿ 
* @param [OUT] lpOutBuffer          ݵĻָ
* @param [IN] dwOutBufferSize       ݵĻ峤(ֽΪλ)Ϊ0
* @param [OUT] pdwBytesReturned     ʵյݳָ룬ΪNUL
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note ʧ˵ѯ A returned failure indicates the end of search.
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_FindNextDevChn(IN LPVOID lpFindHandle, 
                                                           OUT LPVOID lpOutBuffer, 
                                                           IN INT32  dwOutBufferSize,
                                                           OUT INT32  *pdwBytesReturned);

/**
* رղ 豸ͨϢͷԴ
* @param [IN] lpFindHandle  ļҾ 
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_FindCloseDevChn(IN LPVOID lpFindHandle);

/**
* ȡͨ豸Ϣ
* @param [IN]   lpUserID                û¼ID User login ID
* @param [IN]   dwChannelID             ͨID 
* @param [OUT]  pstDeviceChlInfo        豸Ϣμṹ#NETDEV_DEVICE_CHL_INFO_S
* @return TRUEʾɹ,ʾʧ
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_GetDevChlBasicInfo(IN LPVOID lpUserID, 
                                                               IN INT32 dwChannelID,
                                                               OUT LPNETDEV_DEVICE_CHL_INFO_S pstDeviceChlInfo);

/**
* ȡͨ
* @param [IN] lpUserID              û¼ID
* @param [IN] dwChnID               ͨID
* @param [OUT] pdwChnType           豸ͨ μ# NETDEV_CHN_TYPE_E
* @return TRUEʾɹʾʧ TRUE means success, and any other value means failure.
* @note 
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_GetChnType(IN LPVOID lpUserID,
                                                       IN INT32 dwChnID,
                                                       OUT INT32 *pdwChnType);

/**
* ȡ豸澯Ϣ  Get alarm information from the device
* @param [IN]  lpUserID        û¼ User login ID
* @param [IN]  dwPullWaitTime  澯ȴʱ,λs Alarm wait time (s)
* @param [INOUT] pdwListCnt     澯,ʱʾ澯ϢбС,ʱʾʵʸ澯Maximum number of alarms. When working as an input parameter, it indicates the length of alarm information list; when working as an output parameter, it indicates the actual number of alarms.
* @param [OUT]   pstPullAlarmList   澯Ϣб,ڴԤȷ List of alarm information. The memory should be allocated in advance.
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* note: ûlogin,logout, 鳤ʱȴ Calling the function will block login and logout. It is not recommended to wait for a long time.
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_PullAlarm(IN LPVOID lpUserID, 
                                                      IN INT32 dwPullWaitTime, 
                                                      INOUT INT32 *pdwListCnt, 
                                                      OUT LPNETDEV_PULLALARM_INFO_S pstPullAlarmList);

/**
* Ԥץ  Snapshot without preview
* @param [IN]  lpUserID             û¼ User login ID
* @param [IN]  dwChannelID          ͨ Channel ID
* @param [IN]  dwStreamType;        ,μö#NETDEV_LIVE_STREAM_INDEX_E  Stream type, see enumeration #NETDEV_LIVE_STREAM_INDEX_E 
* @param [IN]  pszFileName          ͼļ·ļ File path to save images (including file name)
* @param [IN]  dwCaptureMode        ͼʽ,μ#NETDEV_PICTURE_FORMAT_E   Image saving format, see #NETDEV_PICTURE_FORMAT_E
* @return  TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
        ֧JPGʽ.
        Only JPG format is supported.
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_CaptureNoPreview(IN LPVOID lpUserID,
                                                             IN INT32 dwChannelID,
                                                             IN INT32 dwStreamType,
                                                             IN CHAR *pszFileName,
                                                             IN INT32 dwCaptureMode);

/**
* Ԥץ  Snapshot without preview
* @param [IN]  lpUserID             û¼ User login ID
* @param [IN]  dwChannelID          ͨ Channel ID
* @param [IN]  dwStreamType;        ,μö#NETDEV_LIVE_STREAM_INDEX_E  Stream type, see enumeration #NETDEV_LIVE_STREAM_INDEX_E 
* @param [IN]  dwCaptureMode        ͼʽ,μ#NETDEV_PICTURE_FORMAT_E   Image saving format, see #NETDEV_PICTURE_FORMAT_E
* @param [IN]  dwPicBufferSize      ͼƬݵBufferС
* @param [OUT]  pszPicBuffer        ͼƬݵBuffer
* @param [OUT]  pdwPicRealSize      ͼƬݵʵʴС
* @return  TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
        ֧JPGʽ. Only JPG format is supported.
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_CaptureNoPreviewV2(IN LPVOID lpUserID,
                                                               IN INT32 dwChannelID,
                                                               IN INT32 dwStreamType,
                                                               IN INT32 dwCaptureMode, 
                                                               IN INT32 dwPicBufferSize, 
                                                               OUT CHAR *pszPicBuffer, 
                                                               OUT INT32 *pdwPicRealSize);

/**
* ̬һؼ֡ Dynamically create an I frame 
* @param [IN] lpUserID       û¼  User login ID
* @param [IN] dwChannelID    ͨ  Channel ID
* @param [IN] dwStreamType   οöNETDEV_LIVE_STREAM_INDEX_E  See enumeration NETDEV_LIVE_STREAM_INDEX_E
* @return NETDEV_E_SUCCEED   ʾɹ,ʾʧ  NETDEV_E_SUCCEED means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_MakeKeyFrame(IN LPVOID lpUserID,
                                                         IN INT32 dwChannelID,
                                                         IN INT32 dwStreamType);

/**
* ѯָ·ݵ¼ֲϢ Query video distribution information by month 
* @param [IN]   lpUserID            û¼ User login ID
* @param [IN]   dwChannelID         ͨ  Channel ID
* @param [IN]   pstMonthInfo        ·Ϣ  Month information
* @param [OUT]   pstMonthStatus     ¼ֲ״̬  Video status in the month
* @return TRUEʾɹ,ʾʧ TRUE means success, any other value indicates failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_QuickSearch(IN LPVOID lpUserID, 
                                                        IN INT32 dwChannelID, 
                                                        IN LPNETDEV_MONTH_INFO_S pstMonthInfo,
                                                        OUT LPNETDEV_MONTH_STATUS_S pstMonthStatus);

/**
* ѯָͨ·ݵ¼ֲϢ   Query video distribution information by month with multichannel
* @param [IN]   lpUserID            û¼ User login ID
* @param [IN]   pstChannels         ͨϢ  Multichannel information
* @param [IN]   pstMonthInfo        ·Ϣ  Month information
* @param [OUT]  pstMonthStatus     ¼ֲ״̬  Video status in the month
* @return TRUEʾɹ,ʾʧ TRUE means success, any other value indicates failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_QuickSearchMultiChl(IN LPVOID lpUserID, 
                                                                IN LPNETDEV_CHANNELS_S pstChannels, 
                                                                IN LPNETDEV_MONTH_INFO_S pstMonthInfo,
                                                                OUT LPNETDEV_MONTH_STATUS_S pstMonthStatus);

/**
* ȡʵURL Obtain Live view stream url
* @param [IN]  lpUserID             û¼ID User login ID
* @param [IN]  dwChannelID          ͨ Channel number
* @param [IN]  dwStreamType          μ#NETDEV_LIVE_STREAM_INDEX_E   Stream type see enumeration#NETDEV_LIVE_STREAM_INDEX_E
* @param [OUT] pszStreamUrl         URL Stream URL,ڴ泤ҪڵNETDEV_LEN_260 The length must exceed NETDEV_LEN_260
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_GetStreamUrl(IN LPVOID lpUserID, 
                                                         IN INT32 dwChannelID,
                                                         IN INT32 dwStreamType,
                                                         OUT CHAR *pszStreamUrl);

/**
* ȡطURL Obtain replay url
* @param [IN]  lpUserID             û¼ID User login ID
* @param [IN]  dwChannelID          ͨ Channel number
* @param [IN]  dwStreamType          μ#NETDEV_LIVE_STREAM_INDEX_E   Stream type see enumeration#NETDEV_LIVE_STREAM_INDEX_E
* @param [OUT] pszReplayUrl  URL,ڴ泤ҪڵNETDEV_LEN_260 The length must exceed NETDEV_LEN_260
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_GetReplayUrl(IN LPVOID lpUserID, 
                                                         IN INT32 dwChannelID,
                                                         IN INT32 dwStreamType, 
                                                         OUT CHAR *pszReplayUrl);

/**
* ļ.ʱ豸¼ļ  Query recording files according to file type and time
* @param [IN]  lpUserID     û¼ User login ID
* @param [IN]  pstFindCond    ¼ѯ Search condition
* @return ¼ѯҵ,0ʾʧ,ֵΪNETDEV_FindCloseȺĲ.
Recording search service number. 0 means failure. Other values are used as the handle parameters of functions like NETDEV_FindClose.
* @note ˺ֵΪ¼ѯҵ,ֵΪ0,ѯ¼ļɹ
*         һ.ҵΪNETDEV_FindNextFilelpFindHandle,εNETDEV_FindNextFile,ȡϸ¼ļϢ.
*         .ѯ,ҵΪNETDEV_FindCloselpFindHandle,NETDEV_FindClose,ͷԴ,رղ.
*/
NETDEV_API NEWINTERFACE LPVOID STDCALL NETDEV_FindFile(IN LPVOID lpUserID,
                                                       IN LPNETDEV_FILECOND_S pstFindCond);

/**
* ȡҵļϢ  Obtain the information of found files one by one.
* @param [IN]  lpFindHandle     ļҾ File search handle
* @param [OUT] pstFindData       ļϢָ Pointer to save file information
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note ʧ˵ѯ A returned failure indicates the end of search.
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_FindNextFile(IN LPVOID lpFindHandle,
                                                         OUT LPNETDEV_FINDDATA_S pstFindData);

/**
* رļ,ͷԴ  Close file search and release resources
* @param [IN] lpFindHandle  ļҾ File search handle
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_FindClose(IN LPVOID lpFindHandle);

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#ifdef NETDEV_WITH_MEDIA
/************************************************************************/
/*                  ýģ                                   */
/************************************************************************/

/**
* ƴ֡ǰýݻصָ  Type of pointer to media stream data callback function before being framed 
* @param [IN] lpPlayHandle      ǰʵž Current live playing handle
* @param [IN] pucBuffer         ƴ֡ǰýݻָ Pointer to buffer that stores stream data that is not framed
* @param [IN] dwBufSize         С Buffer size
* @param [IN] dwMediaDataType   ý,μýöٶ#NETDEV_MEDIA_DATA_FORMAT_E Media data type, see definitions of enumeration #NETDEV_MEDIA_DATA_TYPE_E
* @param [IN] lpUserParam       ûò,ûڵ#NDPlayer_SetSourceMediaDataCBʱָû User-set parameters, specified by users when they call the #NDPlayer_SetSourceMediaDataCB function
* @return . None.
* @note  ûӦʱý,ȷ췵,Ӱ첥ڵý. Users should handle output stream data in a timely manner so that functions can be returned quickly. Otherwise, stream processing in the player will be affected.
*/
typedef void (STDCALL *NETDEV_SOURCE_DATA_CALLBACK_PF)(IN LPVOID        lpPlayHandle,
                                                       IN const BYTE    *pucBuffer,
                                                       IN INT32         dwBufSize,
                                                       IN INT32         dwMediaDataType,
                                                       IN LPVOID        lpUserParam);

/**
* עص:ԭʼ  Callback function to register streams (original stream)
* @param [IN]  lpPlayHandle               ʵʱԤ Live preview handle
* @param [IN]  cbSourceDataCallBack       ݻص Callback function for stream data
* @param [IN]  bContinue                  Ƿкƴ֡.ʾ Whether to continue to following framing, decoding and displaying operations.
* @param [IN]  lpUser                     û User data
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE  BOOL STDCALL NETDEV_SetPlayDataCallBack(IN LPVOID lpPlayHandle,
                                                                 IN NETDEV_SOURCE_DATA_CALLBACK_PF cbPlayDataCallBack,
                                                                 IN INT32 bContinue,
                                                                 IN LPVOID lpUser);

/**
* ƴ֡Ƶݻصָ  Type of pointer to callback function for framed stream data 
* @param [IN] lpPlayHandle          ǰʵž Current live playing handle
* @param [IN] pstParseVideoData     ƴ֡ƵϢָ Pointer to buffer that stores framed video stream data
* @param [IN] lUserParam            ûò,ûڵ#NDPlayer_SetParseVideoDataCBʱָû User-set parameters, specified by users when they call the #NDPlayer_SetParseVideoDataCB function
* @return . None.
* @note
* -     ûӦʱ,ȷ췵,Ӱ첥ڵý. Users should handle output stream data in a timely manner so that functions can be returned quickly. Otherwise, stream processing in the player will be affected.
*/
typedef void (STDCALL *NETDEV_PARSE_VIDEO_DATA_CALLBACK_PF)(IN LPVOID lpPlayHandle,
                                                            IN const NETDEV_PARSE_VIDEO_DATA_S *pstParseVideoData,
                                                            IN LPVOID lpUserParam);

/**
* עʵص:ƴ֡  Callback function to register live stream (framed stream data)
* @param [IN]  lpPlayHandle              Ԥ\طž Preview\playback handle
* @param [IN]  cbParsePlayDataCallBack   ݻص Data callback function
* @param [IN]  bContinue                 ǷкĽʾ Whether to continue to following decoding and displaying operations.
* @param [IN]  lpUserData                û User data
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
* - رջص,ڶΪNULL.
* - To shut the callback function, set the second parameter as NULL.
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetPlayParseCB(IN LPVOID lpPlayHandle, 
                                                           IN NETDEV_PARSE_VIDEO_DATA_CALLBACK_PF cbParsePlayDataCallBack,
                                                           IN INT32 bContinue, 
                                                           IN LPVOID lpUserData);

/**
* עʵʱصƵý  Callback function to register live stream (decoded media stream data)
* @param [IN]  lpPlayHandle                 Ԥ\طž Preview\playback handle
* @param [IN]  cbPlayDecodeVideoCALLBACK    ݻص Data callback function
* @param [IN]  bContinue                    Ƿкʾ Whether to continue to following displaying operations.
* @param [IN]  lpUserData                   û User data
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
* - رջص,ڶΪNULL.
* - To shut the callback function, set the second parameter as NULL.
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetPlayDecodeVideoCB(IN LPVOID  lpPlayHandle,
                                                                 IN NETDEV_DECODE_VIDEO_DATA_CALLBACK_PF cbPlayDecodeVideoCALLBACK,
                                                                 IN INT32 bContinue,
                                                                 IN LPVOID lpUserData);

/**
* ƴ֡Ƶݻصָ  Type of pointer to callback function for framed stream data 
* @param [IN] lpPlayHandle   ǰʵž Current live playing handle
* @param [IN] pstWaveData    ŽƵϢָ Pointer to buffer that stores decoded audio stream data
* @param [IN] lpUserParam    ûò,ûڵ#NDPlayer_SetDecodeAudioDataCBʱָû User-set parameters, specified by users when they call the #NDPlayer_SetDecodeAudioDataCB function
* @return . None.
* @note
* -     ûӦʱƵ,ȷ췵,Ӱ첥ڵý.
* -     Users should handle output stream data in a timely manner so that functions can be returned quickly. Otherwise, stream processing in the player will be affected.
*/
typedef void (STDCALL* NETDEV_PARSE_AUDIO_DATA_CALLBACK_PF)(IN LPVOID lpPlayHandle,
                                                            IN const NETDEV_PARSE_AUDIO_DATA_S *pstParseAudioData,
                                                            IN LPVOID lpUserParam);

/**
* עصƴ֡Ƶý Callback function to register audio stream (framed stream data)
* @param [IN]  lpPlayHandle                Ԥ\طž Preview\playback handle
* @param [IN]  cbPlayParseAudioCallBack    ݻص Data callback function
* @param [IN]  bContinue                   ǷвŲ Whether to continue to playing operations.
* @param [IN]  lpUserData                  û User data
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
* - رջص,ڶΪNULL.
* - To shut the callback function, set the second parameter as NULL.
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetPlayParseAudioCB(IN LPVOID lpPlayHandle, 
                                                                IN NETDEV_PARSE_AUDIO_DATA_CALLBACK_PF cbPlayParseAudioCallBack,
                                                                IN INT32 bContinue, 
                                                                IN LPVOID lpUserData);

/**
* Ƶݻصָ  Type of pointer to callback function for decoded audio stream data 
* @param [IN] lpPlayHandle   ǰʵž Current live playing handle
* @param [IN] pstWaveData    ŽƵϢָ Pointer to buffer that stores decoded audio stream data
* @param [IN] lpUserParam    ûò,ûڵ#NDPlayer_SetDecodeAudioDataCBʱָû User-set parameters, specified by users when they call the #NDPlayer_SetDecodeAudioDataCB function
* @return . None.
* @note
* -     ûӦʱƵ,ȷ췵,Ӱ첥ڵý.
* -     Users should handle output stream data in a timely manner so that functions can be returned quickly. Otherwise, stream processing in the player will be affected.
*/
typedef void (STDCALL* NETDEV_DECODE_AUDIO_DATA_CALLBACK_PF)(IN LPVOID lpPlayHandle,
                                                             IN const NETDEV_WAVE_DATA_S *pstWaveData,
                                                             IN LPVOID lpUserParam);

/**
* עصƵý Callback function to register audio stream (decoded media stream data)
* @param [IN]  lpPlayHandle                 Ԥ\طž Preview\playback handle
* @param [IN]  cbPlayDecodeAudioCallBack    ݻص Data callback function
* @param [IN]  bContinue                    ǷвŲ Whether to continue to playing operations.
* @param [IN]  lpUserData                   û User data
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
* - رջص,ڶΪNULL.
* - To shut the callback function, set the second parameter as NULL.
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetPlayDecodeAudioCB(IN LPVOID lpPlayHandle, 
                                                                 IN NETDEV_DECODE_AUDIO_DATA_CALLBACK_PF cbPlayDecodeAudioCallBack,
                                                                 IN INT32 bContinue,
                                                                 IN LPVOID lpUserData);

/**
* ʾݻصָ Type of pointer to display data callback function
* @param [IN] lpHandle       ǰʵž Current live playing handle
* @param [IN] hdc            ʾhdc,ûhdc ͼ Display superficial hdc which can be used for drawing graphics.
* @param [IN] lpUserParam    ûò,ûڵ#NETDEV_SetPlayDisplayCBʱָû User-set parameters, specified by users when they call the #NETDEV_SetPlayDisplayCB
* @return .
* @note
* -     ûӦʱƵ,ȷ췵,Ӱ첥ڵý.
* -     Users should handle output stream data in a timely manner so that functions can be returned quickly. Otherwise, stream processing in the player will be affected.
*/
typedef void (STDCALL* NETDEV_DISPLAY_CALLBACK_PF)(IN LPVOID lpHandle,
                                                   IN LPVOID hdc,
                                                   IN LPVOID lpUserParam);

/**
* ʾݻص  Modify displayed data callback
* @param [IN]  lpPlayHandle             Ԥ\طž Preview\playback handle
* @param [IN]  cbPlayDisplayCallBack    ݻص Data callback function
* @param [IN]  lpUserData               û User data
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
* - رջص,ڶΪNULL.
* - To shut the callback function, set the second parameter as NULL.
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetPlayDisplayCB(IN LPVOID lpPlayHandle,
                                                             IN NETDEV_DISPLAY_CALLBACK_PF cbPlayDisplayCallBack,
                                                             IN LPVOID lpUserData);


/**
* ʵʱԤ  Start live preview
* @param [IN]  lpUserID             û¼ User login ID
* @param [IN]  pstPreviewInfo       Ԥ,οö٣NETDEV_PROTOCAL_E,NETDEV_LIVE_STREAM_INDEX_E. Preview parameter, see enumeration: NETDEV_PROTOCAL_E, NETDEV_LIVE_STREAM_INDEX_E.
* @param [IN]  cbRealDataCallBack   ݻصָ Pointer to callback function of stream data
* @param [IN]  lpUserData           û User data
* @return صû¼, 0 ʾʧ,ֵʾصû¼ֵ. Returned user login ID. 0 indicates failure, and other values indicate the user ID.
* @note
*/
NETDEV_API NEWINTERFACE LPVOID STDCALL NETDEV_RealPlay(IN LPVOID lpUserID,
                                                       IN LPNETDEV_PREVIEWINFO_S pstPreviewInfo,
                                                       IN NETDEV_SOURCE_DATA_CALLBACK_PF cbPlayDataCallBack,
                                                       IN LPVOID lpUserData);


/**
* urlʵʱԤ
* @param [IN]  lpUserID             û¼ID
* @param [IN]  pszUrl...............URL
* @param [IN]  pstPreviewInfo       Ԥ,οö٣NETDEV_PROTOCAL_E,NETDEV_LIVE_STREAM_INDEX_E.
* @param [IN]  cbRealDataCallBack   ݻصָ
* @param [IN]  lpUserData           û
* @return صû¼ID, 0 ʾʧ,ֵʾصûIDֵ.
* @note
*/
NETDEV_API NEWINTERFACE LPVOID STDCALL NETDEV_FastRealPlayByUrl(IN LPVOID lpUserID, 
                                                                IN CHAR *pszUrl,
                                                                IN LPNETDEV_PREVIEWINFO_S pstPreviewInfo,
                                                                IN NETDEV_SOURCE_DATA_CALLBACK_PF cbPlayDataCallBack,
                                                                IN LPVOID lpUserData);

/**
* UrlʵʱԤ
* Start live preview
* @param [IN]  lpUserID             û¼ID User login ID
* @param [IN]  pszUrl               URL
* @param [IN]  pszUserName          û
* @param [IN]  pszPassword            
* @param [IN]  pstPreviewInfo       Ԥοö٣NETDEV_PROTOCAL_ENETDEV_LIVE_STREAM_INDEX_E Preview parameter, see enumeration: NETDEV_PROTOCAL_E, NETDEV_LIVE_STREAM_INDEX_E.
* @param [IN]  cbPlayDataCallBack   ݻصָ Pointer to callback function of stream data
* @param [IN]  lpUserData           û User data
* @return  0 ʾʧܣֵʾصԤΪNETDEV_StopRealPlayȺľ  Returned user login ID. 0 indicates failure, and other values indicate the user ID.
* @note
*/
NETDEV_API NEWINTERFACE LPVOID STDCALL NETDEV_FastRealPlayByUrl_V30(IN LPVOID lpUserID,
                                                                    IN CHAR* pszUrl,
                                                                    IN CHAR*pszUserName,
                                                                    IN CHAR*pszPassword,
                                                                    IN LPNETDEV_PREVIEWINFO_S pstPreviewInfo,
                                                                    IN NETDEV_SOURCE_DATA_CALLBACK_PF cbPlayDataCallBack,
                                                                    IN LPVOID lpUserData
                                                                    );

/**
* ͨURLȡƶ豸Ƶ
* @param [IN]  pszUrl...............URL
* @param [IN]  cbRealDataCallBack   ݻصָ
* @param [IN]  lpUserData           û
* @return صû¼ID, 0 ʾʧ,ֵʾصûIDֵ.
* @note
*/
NETDEV_API NEWINTERFACE LPVOID STDCALL NETDEV_GetCloudLiveByUrl(IN CHAR *pszUrl,
                                                                IN NETDEV_SOURCE_DATA_CALLBACK_PF cbPlayDataCallBack,
                                                                IN LPVOID lpUserData);

/**
* ֹͣʵʱԤ  Stop live preview
* @param [IN]  lpPlayHandle     Ԥ Preview handle
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note ӦرNETDEV_RealPlayʵ Stop the live view started by NETDEV_RealPlay
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_StopRealPlay(IN LPVOID lpPlayHandle);

/**
* ¼  Local recording
* @param [IN]  lpPlayHandle         Ԥ Preview handle
* @param [IN]  pszSaveFileName      ļ Name of saved file
* @param [IN]  dwFormat             Format of saved file, see #NETDEV_MEDIA_FILE_FORMAT_E 
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SaveRealData(IN LPVOID lpPlayHandle, 
                                                         IN CHAR *pszSaveFileName,
                                                         IN INT32   dwFormat);

/**
* ֹͣ¼ Stop local recording
* @param [IN]  lpPlayHandle     Ԥ Preview handle
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_StopSaveRealData(IN LPVOID lpPlayHandle);


/**
* ȡ  Get window bit rate
* @param [IN]  lpPlayHandle     Ԥ\طž Preview\playback handle
* @param [OUT] pdwBitRate       ȡָ Pointer to obtained bit rate
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_GetBitRate(IN LPVOID lpPlayHandle,
                                                       OUT INT32 *pdwBitRate);

/*
* ȡ֡  Get window frame rate
* @param [IN]  lpPlayHandle     Ԥ\طž Preview\playback handle
* @param [OUT] pdwFrameRate     ȡָ֡ Pointer to obtained frame rate
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_GetFrameRate(IN LPVOID lpPlayHandle,
                                                         OUT INT32 *pdwFrameRate);

/**
* ȡڱʽ  Get window encoding format
* @param [IN]  lpPlayHandle         Ԥ\طž Preview\playback handle
* @param [OUT] pdwVideoEncFmt       ȡƵʽָ,μNETDEV_VIDEO_CODE_TYPE_E  Pointer to obtained encoding format, see NETDEV_VIDEO_CODE_TYPE_E
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_GetVideoEncodeFmt(IN LPVOID lpPlayHandle,
                                                              OUT INT32 *pdwVideoEncFmt);


/**
* ȡƵֱ  Get video resolution
* @param [IN]  lpPlayHandle     Ԥ\طž Preview\playback handle
* @param [OUT] pdwWidth         ȡķֱ-ָ Pointer to obtained resolution C width
* @param [OUT] pdwHeight        ȡķֱ-߶ָ Pointer to obtained resolution C height
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_GetResolution(IN LPVOID lpPlayHandle,
                                                          OUT INT32 *pdwWidth,
                                                          OUT INT32 *pdwHeight);

/**
* ȡڶ  Get window packet loss rate
* @param [IN]  lpPlayHandle     Ԥ\طž Preview\playback handle
* @param [OUT] pulRecvPktNum    յݰָ Pointer to number of received packets
* @param [OUT] pulLostPktNum    ʧݰָ Pointer to number of lost packets
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_GetLostPacketRate(IN LPVOID lpPlayHandle,
                                                              OUT INT32 *pulRecvPktNum,
                                                              OUT INT32 *pulLostPktNum);

/**
* ôڶ  Reset window packet loss rate
* @param [IN]  lpPlayHandle   Ԥ\طž Preview\playback handle
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_ResetLostPacketRate(IN LPVOID lpPlayHandle);

/**
* ʵץ  Live view snapshot
* @param [IN]  lpPlayHandle     Ԥ\طž Preview\playback handle
* @param [IN]  pszFileName      ͼļ·ļ File path to save images (including file name)
* @param [IN]  dwCaptureMode    ͼʽ,μ#NETDEV_PICTURE_FORMAT_E   Image saving format, see #NETDEV_PICTURE_FORMAT_E
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note ļпԲЯץĸʽĺ׺ File format suffix is not required in the file name
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_CapturePicture(IN LPVOID lpPlayHandle, 
                                                           IN char *pszFileName, 
                                                           IN INT32 dwCaptureMode);

/**
* Ƶͼʾ  Modify image display ratio
* @param [IN]  lpPlayHandle   Ԥ\طž Preview\playback handle
* @param [IN]  enRenderScale  Ƶͼʾ Image display ratio
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetRenderScale(IN LPVOID lpPlayHandle,
                                                           IN NETDEV_RENDER_SCALE_E enRenderScale);

/**
* Ӱȡ,ֻȡǰ  Get the current image info
* @param [IN]  lpPlayHandle   Ԥ\طž Preview\playback handle
* @param [IN]  pstImageInfo   ͼϢб Image information list
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_GetVideoEffect(IN LPVOID lpPlayHandle, 
                                                           OUT LPNETDEV_VIDEO_EFFECT_S pstImageInfo);

/**
* Ӱ,ֻı䵱ǰ  Adjust the current image
* @param [IN]  lpPlayHandle   Ԥ\طž Preview\playback handle
* @param [IN]  pstImageInfo   ͼϢб Image information list
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetVideoEffect(IN LPVOID lpPlayHandle, 
                                                           IN LPNETDEV_VIDEO_EFFECT_S pstImageInfo);

/**
* ַŴ  Set Digital zoom
* @param [IN] lpPlayHandle   Ԥ\طž Preview\playback handle
* @param [IN] hWnd           ھ  window handle 
* @param [IN] pstRect         Rectangle Area
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note pstRectΪʱ,ʾȫ,˳ַŴ All images will be displayed with digital zoom disabled when pstRect is null
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetDigitalZoom(IN LPVOID lpPlayHandle, 
                                                           IN LPVOID hWnd,
                                                           IN LPNETDEV_RECT_S pstRect);

/**
*  Set pictuer fluency
* @param [IN] lpPlayHandle         Ԥ\طž Preview\playback handle
* @param [IN] dwFluency           ͼ񲥷,μö#NETDEV_PICTURE_FLUENCY_E
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetPictureFluency(IN LPVOID lpPlayHandle,
                                                              IN INT32 dwFluency);


/**
* Խ Start two-way audio
* @param [IN]  lpUserID                 û¼  User ID
* @param [IN]  dwChannelID              ͨ  Channel ID
* @param [IN]  cbRealDataCallBack       ݻصָ  Pointer to callback function of the stream data 
* @param [IN]  lpUserData               û   User data
* @return صû¼, 0 ʾʧ,ֵʾصû¼ֵ Returned user ID. 0 means failure, and any other value is a user ID.
* @note
*/
NETDEV_API NEWINTERFACE LPVOID STDCALL NETDEV_StartVoiceCom(IN LPVOID lpUserID,
                                                            IN INT32 dwChannelID,
                                                            IN NETDEV_DECODE_AUDIO_DATA_CALLBACK_PF cbPlayDataCallBack,
                                                            IN LPVOID lpUserData);

/**
* رԽ Stop two-way audio
* @param [IN]  lpPlayHandle   Խ Two-way audio handle
* @return TRUEʾɹ,ʾʧ TRUE means success, any other value indicates failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_StopVoiceCom(IN LPVOID lpPlayHandle);

/**
* ˷ Turn on microphone
* @param [IN]  lpPlayHandle   Ԥ Preview handle
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_OpenMic(IN LPVOID lpPlayHandle);

/**
* ر˷ Turn off microphone
* @param [IN]  lpPlayHandle   Ԥ Preview handle
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_CloseMic(IN LPVOID lpPlayHandle);

/**
* ˷  Adjust sound volume of microphone
* @param [IN]  lpPlayHandle     Ԥ Preview handle 
* @param [IN]  dwVolume              Sound volume
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_MicVolumeControl(IN LPVOID lpPlayHandle,
                                                             IN INT32 dwVolume);

/**
* ȡ˷ Get mic volume
* @param [IN]  lpPlayHandle     Ԥ Preview handle
* @param [IN]  pdwVolume         Volume
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_GetMicVolume(IN LPVOID lpPlayHandle, 
                                                         OUT INT32* pdwVolume);

/**
* ȡ״̬ Get mute status
* @param [IN]  lpPlayHandle     Ԥ Preview handle
* @param [OUT]  pbMute           ״̬ Mute status
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_GetMuteStatus(IN LPVOID lpPlayHandle, 
                                                          OUT BOOL* pbMute);

/**
* þ״̬ Set mute status
* @param [IN]  lpPlayHandle     Ԥ Preview handle
* @param [IN]  bMute            ״̬ Mute status
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetMuteStatus(IN LPVOID lpPlayHandle, 
                                                          IN BOOL bMute);


/**
*   Enable sound
* @param [IN]  lpPlayHandle   Ԥ Preview handle
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_OpenSound(IN LPVOID lpPlayHandle);

/**
*  Control sound volume
* @param [IN]  lpPlayHandle   Ԥ Preview handle
* @param [IN]  dwVolume        Volume
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SoundVolumeControl(IN LPVOID lpPlayHandle, 
                                                               IN INT32 dwVolume);

/**
* ȡ Get sound volume
* @param [IN]  lpPlayHandle     Ԥ Preview handle
* @param [IN]  pdwVolume         Volume
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_GetSoundVolume(IN LPVOID lpPlayHandle, 
                                                           OUT INT32* pdwVolume);

/**
* ر Mute
* @param [IN]  lpPlayHandle   Ԥ Preview handle
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_CloseSound(IN LPVOID lpPlayHandle);

/**
* ݷ
* @param [IN]  lpUserID                 ûID
* @param [IN]  dwChannelID              ͨ
* @param [IN]  cbRealDataCallBack       ݻصָ
* @param [IN]  lpUserData               û
* @return صԽ, 0 ʾʧ
* @note
*/
NETDEV_API NEWINTERFACE LPVOID STDCALL NETDEV_StartInputVoiceSrv(IN LPVOID lpUserID,
                                                                 IN INT32 dwChannelID);

/**
* رݷ
* @param [IN]  lpVoiceComHandle   Խ
* @return TRUEʾɹ,ʾʧ
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_StopInputVoiceSrv(IN LPVOID lpVoiceComHandle);

/**
* 
* @param [IN]  lpVoiceComHandle         Խ
* @param [IN] lpDataBuf                 ݵַ
* @param [IN] dwDataLen                 ݳ
* @param [IN] pstVoiceParam             
* @return TRUEʾɹ,ʾʧ
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_InputVoiceData(IN LPVOID lpVoiceComHandle,
                                                           IN LPVOID lpDataBuf,
                                                           IN INT32 dwDataLen,
                                                           IN LPNETDEV_AUDIO_SAMPLE_PARAM_S pstVoiceParam);

/**
* Խݻصָ.
* @param [IN] lpVoiceComHandle      Խ
* @param [IN] lpWaveData            ŽϢָ
* @param [IN] lpUserParam           ûò
* @param [IN] dwReserved            ƵݴС
* @return .
* @note
* -     ûӦʱ,ȷ췵,Ӱ첥ڵý.
*/
typedef VOID (STDCALL *NETDEV_PARSE_VOICE_DATA_CALLBACK_PF)(IN LPVOID lpVoiceComHandle,
                                                            IN const LPNETDEV_WAVE_DATA_S lpWaveData,
                                                            IN LPVOID lpUserParam,
                                                            IN INT32 dwReserved);

/**
* ýݻص
* @param [IN]  lpPlayHandle                 Ԥ\طž Preview\playback handle
* @param [IN]  cbPlayDecodeVideoCALLBACK    ݻص Data callback function
* @param [IN]  bContinue                    Ƿ Continue or not
* @param [IN]  lpUserData                   û User data
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
* - رջص,ڶΪNULL.
* - To shut the callback function, set the second parameter as NULL.
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetParseVoiceDataCB(IN LPVOID  lpPlayHandle,
                                                                IN NETDEV_PARSE_VOICE_DATA_CALLBACK_PF cbDecodeVideoCB,
                                                                IN INT32 bContinue,
                                                                IN LPVOID lpUserParam);

/**
* ƻط¼ļ  Play back recording files by name
* @param [IN] lpUserID          û¼ User login ID
* @param [IN] pstPlayBackInfo   ¼طŽṹָ,ο LPNETDEV_PLAYBACKINFO_S Pointer to recording playback structure, see LPNETDEV_PLAYBACKINFO_S
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE LPVOID STDCALL NETDEV_PlayBackByName(IN LPVOID lpUserID,
                                                             IN LPNETDEV_PLAYBACKINFO_S pstPlayBackInfo);

/**
* ʱط¼ļ  Play back recording by time. 
* @param [IN] lpUserID          û¼ User login ID
* @param [IN] pstPlayBackCond   ʱ¼طŽṹָ  ο LPNETDEV_PLAYBACKCOND_S Pointer to playback-by-time structure, see LPNETDEV_PLAYBACKCOND_S
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE LPVOID STDCALL NETDEV_PlayBackByTime(IN LPVOID lpUserID,
                                                             IN LPNETDEV_PLAYBACKCOND_S pstPlayBackInfo);


/**
* ʹURLط
* @param [IN]  lpUserID             û¼
* @param [IN]  pszUrl               URL
* @param [IN]  pstPlayBackCond      ¼طŽṹָ,ο LPNETDEV_PLAYBACKCOND_S
* @return 0ʾʧ,ֵΪNETDEV_StopPlayBackȺľ
* @note
*/
NETDEV_API NEWINTERFACE LPVOID STDCALL NETDEV_PlayBackByUrl(IN LPVOID lpUserID, 
                                                            IN CHAR *pszUrl, 
                                                            IN LPNETDEV_PLAYBACKCOND_S pstPlayBackCond
                                                            );

/**
* urlٻط¼ Play back recording by url. 
* @param [IN] lpUserID          û¼ User login ID
* @param [IN]  pszUrl...........URL
* @param [IN] pstPlayBackParam   url¼طŽṹָ  ο LPNETDEV_PLAYBACKCOND_S Pointer to playback-by-time structure, see LPNETDEV_PLAYBACKCOND_S
* @return صû¼ID, 0 ʾʧ,ֵʾصûIDֵ.
* @note
*/
NETDEV_API NEWINTERFACE LPVOID STDCALL NETDEV_FastPlayBackByUrl(IN LPVOID lpUserID,
                                                                IN CHAR *pszUrl,
                                                                IN LPNETDEV_PLAYBACKCOND_S pstPlayBackParam);

/**
* ֹͣطҵ  Stop playback service
* @param [IN] lpPlayHandle  طž Playback handle
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_StopPlayBack(IN LPVOID lpPlayHandle);

/**
* ļ¼ļ Download recordings by file name
* @param [IN]  lpUserID             û¼ User login ID
* @param [IN]  pstPlayBackInfo      ¼طŽṹָ,ο LPNETDEV_PLAYBACKINFO_S Pointer to recording playback structure, see LPNETDEV_PLAYBACKINFO_S
* @param [IN]  *pszSaveFileName     غ󱣴浽PCļ·,Ϊ·ļ Downloaded file save path on PC, must be an absolute path (including file name)
* @param [IN]  dwFormat             ¼ļʽ Recording file saving format
* @return ؾ, 0ʾʧ,ֵΪNETDEV_StopGetFileȺĲ. Download handle. 0 means failure. Other values are used as the handle parameters of functions like NETDEV_StopGetFile.
* @note
*/
NETDEV_API NEWINTERFACE LPVOID STDCALL NETDEV_GetFileByName(IN LPVOID  lpUserID,
                                                            IN LPNETDEV_PLAYBACKINFO_S pstPlayBackInfo,
                                                            IN CHAR *pszSaveFileName,
                                                            IN INT32 dwFormat);

/**
* ʱ¼ļ Download recordings by time
* @param [IN]  lpUserID                û¼ User login ID
* @param [IN]  pstPlayBackCond   ʱ¼طŽṹָ,ο LPNETDEV_PLAYBACKCOND_S Pointer to playback-by-time structure, see LPNETDEV_PLAYBACKCOND_S
* @param [IN]  *pszSaveFileName        غ󱣴浽PCļ·,Ϊ·ļ Downloaded file save path on PC, must be an absolute path (including file name)
* @param [IN]  dwFormat                ¼ļʽ Recording file saving format
* @return ؾ, 0ʾʧ,ֵΪNETDEV_StopGetFileȺĲ. Download handle. 0 means failure. Other values are used as the handle parameters of functions like NETDEV_StopGetFile.
* @note
*/
NETDEV_API NEWINTERFACE LPVOID STDCALL NETDEV_GetFileByTime(IN LPVOID lpUserID, 
                                                            IN LPNETDEV_PLAYBACKCOND_S pstPlayBackCond, 
                                                            IN CHAR *pszSaveFileName,
                                                            IN INT32 dwFormat);

/**
* ֹͣ¼ļ Stop downloading recording files
* @param [IN]  lpPlayHandle  طž Playback handle
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_StopGetFile(IN LPVOID lpPlayHandle);


/**
* ¼طŵ״̬  Control recording playback status.
* @param [IN]  lpPlayHandle     طŻؾ Playback or download handle
* @param [IN]  dwControlCode    ¼ط״̬ οö٣NETDEV_VOD_PLAY_CTRL_E Command for controlling recording playback status, see NETDEV_VOD_PLAY_CTRL_E
* @param [INOUT]  lpBuffer     ָ/ָ, ٶȲοö٣NETDEV_VOD_PLAY_STATUS_E,ʱΪINT64 Pointer to input/output parameters. For playing speed, see NETDEV_VOD_PLAY_STATUS_E. The type of playing time: INT64.
* @return TRUEʾɹ,ʾʧ TRUE means success, and any other value means failure.
* @note ʼ.ͣ.ָʱ,lpBufferΪNULL When playing, pause or resume videos, set IpBuffer as NULL.
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_PlayBackControl(IN LPVOID lpPlayHandle, 
                                                            IN INT32 dwControlCode, 
                                                            INOUT LPVOID lpBuffer);

/**
* ضʱ㵥֡ط
* @param [IN]  lpPlayHandle    طž
* @param [IN]  IN INT64 dwPlayTime ضʱ
* @return TRUEʾɹ,ʾʧ
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetOneFramePlayWithTime(IN LPVOID lpPlayHandle, IN INT64 dwPlayTime);


/**
* ȡ㲥ͨ״̬
* @param [IN] lpPlayHandle           㲥
* @param [OUT] pstGroupInfo          ͨ״̬б
* @return TRUEʾɹʾʧ
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_GetVoiceBroadcastChlStatus(IN LPVOID lpPlayHandle,
                                                                       OUT LPNETDEV_VOICE_BROADCAST_GROUP_INFO_S pstGroupInfo);

/**
* ½㲥
* @parma [IN] lpUserID              û¼ID
* @param [IN] pstChnList            ͨб
* @return 㲥NULLʾʧ
*/
NETDEV_API NEWINTERFACE LPVOID STDCALL NETDEV_CreateVoiceBroadcastGroup(IN LPVOID lpUserID,
                                                                        IN LPNETDEV_OPERATE_LIST_S pstChnList);


/**
* ޸㲥
* @param [IN] lpPlayHandle          㲥
* @param [IN] pstModifyInfo         ޸㲥Ϣ
* @return TRUEʾɹʾʧ
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_ModifyVoiceBroadcastGroup(IN LPVOID lpPlayHandle,
                                                                      IN LPNETDEV_MODIFY_VOICE_BROADCAST_INFO_S pstModifyInfo);

/**
* 㲥 Start voice broadcast
* @param [IN]  lpUserID         û¼ User login ID
* @param [IN]  dwChannelID      ͨ  Channel ID
* @return صû¼, 0 ʾʧ,ֵʾصû¼ֵ Returned user ID. 0 means failure, and any other value is a user ID.
* @note ʵ㲥,һ·Խ Voice broadcast and two-way audio for one channel are available.
*/
NETDEV_API NEWINTERFACE LPVOID STDCALL NETDEV_StartVoiceBroadcast(IN LPVOID lpUserID, 
                                                                  IN INT32 dwChannelID);

/**
* ر㲥 Stop voice broadcast
* @param [IN]  lpPlayHandle   㲥 voice broadcast handle
* @return TRUEʾɹ,ʾʧ TRUE means success, any other value indicates failure.
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_StopVoiceBroadcast(IN LPVOID lpPlayHandle);

/**
* /رĳ㲥ͨ
* @param [IN] lpPlayHandle          㲥
* @param [IN] pstCtrlInfo           Ϣ
* @return TRUEʾɹʾʧ
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_ModifyVoiceBroadcastStatus(IN LPVOID lpPlayHandle,
                                                                       IN LPNETDEV_VOICE_BROADCAST_CTRL_INFO_S pstCtrlInfo);


/**
* 򿪱ļ
* @param [IN] pszFilename           ļ
* @return 0ʾʧ,ֵΪNETDEV_PlayMediaFile.NETDEV_StopPlayMediaFileȺľ
* @note
*/
NETDEV_API NEWINTERFACE LPVOID STDCALL NETDEV_OpenMediaFile(IN CHAR *pszFilename);

/**
* űļ
* @param [IN] lpPlayHandle       ļ,NETDEV_OpenMediaFileķֵ
* @param [IN] dwPlayWnd          Ŵھ
* @return TRUEʾɹ,ʾʧ
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_StartPlayMediaFile(IN LPVOID lpPlayHandle,
                                                               IN LPVOID lpPlayWnd);

/**
* ֹͣűļҵ
* @param [IN] lpPlayHandle  طž
* @return TRUEʾɹ,ʾʧ
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_StopPlayMediaFile(IN LPVOID lpPlayHandle);

/**
* ȡýļʱܳ
* @param [IN] lpPlayHandle  طž
* @param [IN] pdwTotalTime  ýļʱܳȣs
* @return TRUEʾɹ,ʾʧ
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_GetMediaFileTime(IN LPVOID lpPlayHandle,
                                                             OUT INT32* pdwTotalTime);


/**
* Ԫݴ
* @param [IN] lpPlayHandle              ž
* @param [IN] bEnableIVA                ǷԪ
* @return TRUEʾɹ,ʾʧ
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetIVAEnable(IN LPVOID lpPlayHandle,
                                                         IN BOOL bEnableIVA);

/**
* ԪݻͼʾͲ
* @param [IN] dwShowParam              ԪʾͲμ# NETDEV_IVA_SHOW_RULE_E
* @return TRUEʾɹ,ʾʧ
* @note
* -    1.ýӿں֧Windows.
* -    2.뽫,ʾ߿ʹĿ,·ulShowParam = NETDEV_IVA_SHOW_RULE|NETDEV_IVA_SHOW_RESULT_TOUTH_RULEԴ
* -    3.һõʾΪ׼,֮ǰõʾȡ
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetIVAShowParam(IN INT32 dwShowParam);


/**
* жǷΪ
* @param [IN] lpPlayHandle              ž
* @param [OUT] pbFishEyeStream          ǷΪ
* @return TRUEʾɹ,ʾʧ
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_IsFishEyeStream(IN LPVOID lpPlayHandle,
                                                            OUT BOOL *pbFishEyeStream);

/**
* ȡ۽
* @param [IN] lpPlayHandle                  ž
* @param [OUT] pstCenterPoint               ͼԲԲ
* @param [OUT] pudwRadius                   ͼԲİ뾶
* @param [OUT] lpParm                       Ԥ۾ͷ
* @return TRUEʾɹ,ʾʧ
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_GetFishEyeParam(IN LPVOID lpPlayHandle,
                                                            OUT LPNETDEV_POINT_S pstCenterPoint, 
                                                            OUT UINT32 *pudwRadius,
                                                            OUT LPVOID lpParm);

/**
* 5ePTZʾģʽ
* @param [IN] lpPlayHandle                  ž
* @param [IN] udwPtzMode                    5ePTZʾģʽ  ο# NETDEV_PTZ_DISPLAY_MODE
* @return TRUEʾɹ,ʾʧ
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetPtzDisplayMode(IN LPVOID lpPlayHandle,
                                                              IN UINT32 udwPtzMode);

/**
* ģʽͰװλ
* @param [IN] lpPlayHandle                  ž
* @param [IN] dwPtzMode                     PTZģʽ,ο# NETDEV_FISHEYE_PTZ_MODE_E
* @param [IN] dwInstallMode                 װλ,ο# NETDEV_INSTALL_MODE_E
* @return TRUEʾɹ,ʾʧ
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetPtzAndFixMode(IN LPVOID lpPlayHandle,
                                                             IN INT32 dwPtzMode, 
                                                             IN INT32 dwInstallMode);

/**
* ȡģʽͰװλ
* @param [IN] lpPlayHandle                   ž
* @param [OUT] pdwPtzMode                    PTZģʽ,ο# NETDEV_FISHEYE_PTZ_MODE_E
* @param [OUT] pdwInstallMode                װλ,ο# NETDEV_INSTALL_MODE_E
* @return TRUEʾɹ,ʾʧ
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_GetPtzAndFixMode(IN LPVOID lpPlayHandle,
                                                             OUT INT32 *pdwPtzMode,
                                                             OUT INT32 *pdwInstallMode);

/**
* 
* @param [IN] lpPlayHandle          ž
* @param [IN] dwOperateMode         ʽ,μ#NETDEV_MOUSE_MOVE_MODE_E
* @param [IN] udwFlag               ʵʱ־λ,ʱ
* @param [IN] wDelta                ƫƶ(ѡ)
* @param [IN] pstPoint              λ
* @return TRUEʾɹ,ʾʧ
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetMouseMoveMode(IN LPVOID lpPlayHandle,
                                                             IN INT32 dwOperateMode, 
                                                             IN UINT32 udwFlag, 
                                                             IN INT16 wDelta,
                                                             IN LPNETDEV_POINT_S pstPoint);

/**
* ¼ļС
* @param [IN]   lpPlayHandle                    ûž
* @param [IN]   ulFileSize                      ¼ļСλMBΧ10MB1024MB
* @return TRUEʾɹ,ʾʧ
* @note
*/
NETDEV_API NEWINTERFACE BOOL STDCALL NETDEV_SetRecordSize(IN LPVOID lpPlayHandle,
                                                          IN UINT32 ulFileSize);

/**
* Ԫݻصָ
* @param [IN] lpPlayHandle   ž
* @param [IN] pstRuleHead    ŹϢͷ
* @param [IN] lpRuleData     ŹϢָ룬NETDEV_IVA_REPORT_RULE_INFO_V2_SͣοŹϢͷ
* @param [IN] udwlRuleLen    Ϣ
* @param [IN] pstResultHead  ŽϢͷ
* @param [IN] lpResultData   ŽϢָ룬NETDEV_IVA_REPORT_RESULT_INFO_V2_EX_SͣοŽϢͷ
* @param [IN] udwResultLen   Ϣ
* @param [IN] lpUserParam    ûòûڵ# NETDEV_SetDecodeAudioMediaDataCB ʱָû
* @param [IN] dwReserved     Ԥֶ
* @return ޡ
* @note
* -     1) ûӦʱݣȷ췵أӰ첥ڵý
*/
typedef VOID (STDCALL *NETDEV_IVA_DATA_CALLBACK_PF)(IN LPVOID lpPlayHandle,
                                                    IN LPNETDEV_IVA_REPORT_RULE_HEAD_V2_S pstRuleHead,
                                                    IN const LPVOID lpRuleData,
                                                    IN UINT32 udwlRuleLen,
                                                    IN LPNETDEV_IVA_REPORT_RESULT_HEAD_V2_S pstResultHead,
  