/*
 * @Copyright (c) 2018 缪聪(mcg-helper@qq.com)
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");  
 * you may not use this file except in compliance with the License.  
 * You may obtain a copy of the License at  
 *     
 *     http://www.apache.org/licenses/LICENSE-2.0  
 *     
 * Unless required by applicable law or agreed to in writing, software  
 * distributed under the License is distributed on an "AS IS" BASIS,  
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  
 * See the License for the specific language governing permissions and  
 * limitations under the License.
 */

package com.mcg.entity.flow.text;

import java.util.ArrayList;

import javax.validation.Valid;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.hibernate.validator.constraints.NotBlank;

import com.mcg.common.sysenum.EletypeEnum;
import com.mcg.entity.flow.FlowBase;
import com.mcg.entity.generate.ExecuteStruct;
import com.mcg.entity.generate.RunResult;
import com.mcg.plugin.execute.ProcessContext;
import com.mcg.plugin.execute.strategy.FlowTextStrategy;

@XmlAccessorType(XmlAccessType.NONE)
@XmlRootElement
public class FlowText extends FlowBase {

	private static final long serialVersionUID = 1950493018293020319L;
	@NotBlank(message = "{flowText.textId.notBlank}")
	@XmlAttribute
	private String textId;
	@Valid
	@XmlElement
	private TextProperty textProperty;
	@Valid
	@XmlElement
	private TextCore textCore;
	
	@Override
	public void prepare(ArrayList<String> sequence, ExecuteStruct executeStruct) throws Exception {
    	this.setFlowId(executeStruct.getFlowId());
    	this.setMcgWebScoketCode(executeStruct.getMcgWebScoketCode());
    	this.setOrderNum(executeStruct.getOrderNum());
    	this.setEletypeEnum(EletypeEnum.TEXT);
        ProcessContext processContext = new ProcessContext();
        processContext.setProcessStrategy(new FlowTextStrategy());
        processContext.prepare(sequence, this, executeStruct);
	}

	@Override
	public RunResult execute(ExecuteStruct executeStruct) throws Exception {
        ProcessContext processContext = new ProcessContext();
        processContext.setProcessStrategy(new FlowTextStrategy());
        RunResult runResult = processContext.run(this, executeStruct);
        return runResult;
	}

	public String getTextId() {
		return textId;
	}

	public void setTextId(String textId) {
		this.textId = textId;
	}

	public TextProperty getTextProperty() {
		return textProperty;
	}

	public void setTextProperty(TextProperty textProperty) {
		this.textProperty = textProperty;
	}

	public TextCore getTextCore() {
		return textCore;
	}

	public void setTextCore(TextCore textCore) {
		this.textCore = textCore;
	}

}
