/*
 * Decompiled with CFR 0.152.
 */
package cech12.usefulhats.init;

import cech12.usefulhats.item.AbstractHatItem;
import cech12.usefulhats.item.AquanautHelmetItem;
import cech12.usefulhats.item.ChoppingHatItem;
import cech12.usefulhats.item.HaloItem;
import cech12.usefulhats.item.IAttackTargetChanger;
import cech12.usefulhats.item.IBreakSpeedChanger;
import cech12.usefulhats.item.IEquipmentChangeListener;
import cech12.usefulhats.item.IItemFishedListener;
import cech12.usefulhats.item.ILivingDropsListener;
import cech12.usefulhats.item.IMobEntityChanger;
import cech12.usefulhats.item.LuckyHatItem;
import cech12.usefulhats.item.MiningHatItem;
import cech12.usefulhats.item.PostmanHatItem;
import cech12.usefulhats.item.StockingCapItem;
import cech12.usefulhats.item.StrawHatItem;
import cech12.usefulhats.item.WingHelmetItem;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="usefulhats", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModItems {
    private static final Item[] items = new Item[]{new AquanautHelmetItem(), new ChoppingHatItem(), new HaloItem(), new LuckyHatItem(), new MiningHatItem(), new PostmanHatItem(), new StockingCapItem(), new StrawHatItem(), new WingHelmetItem()};

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        for (Item item : items) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerColors(ColorHandlerEvent.Item event) {
        ItemColors itemcolors = event.getItemColors();
        for (Item item : items) {
            itemcolors.func_199877_a((itemStack, layer) -> layer > 0 ? -1 : ((IDyeableArmorItem)itemStack.func_77973_b()).func_200886_f(itemStack), new IItemProvider[]{item});
        }
    }

    public static void addEventListeners() {
        MinecraftForge.EVENT_BUS.addListener(ModItems::onBreakSpeedEvent);
        MinecraftForge.EVENT_BUS.addListener(ModItems::onBreakEvent);
        MinecraftForge.EVENT_BUS.addListener(ModItems::onEntityJoinWorldEvent);
        MinecraftForge.EVENT_BUS.addListener(ModItems::onItemFishedEvent);
        MinecraftForge.EVENT_BUS.addListener(ModItems::onLivingDropsEvent);
        MinecraftForge.EVENT_BUS.addListener(ModItems::onLivingEquipmentChangeEvent);
        MinecraftForge.EVENT_BUS.addListener(ModItems::onLivingSetAttackTargetEvent);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addClientEventListeners() {
        MinecraftForge.EVENT_BUS.addListener(ModItems::onItemToolTipEvent);
    }

    private static void onBreakSpeedEvent(PlayerEvent.BreakSpeed event) {
        ItemStack headSlotItemStack = event.getPlayer().func_184582_a(EquipmentSlotType.HEAD);
        for (Item item : items) {
            if (!(item instanceof IBreakSpeedChanger) || headSlotItemStack.func_77973_b() != item) continue;
            ((IBreakSpeedChanger)item).onBreakSpeedEvent(event, headSlotItemStack);
        }
    }

    private static void onBreakEvent(BlockEvent.BreakEvent event) {
        ItemStack headSlotItemStack = event.getPlayer().func_184582_a(EquipmentSlotType.HEAD);
        for (Item item : items) {
            if (!(item instanceof IBreakSpeedChanger) || headSlotItemStack.func_77973_b() != item) continue;
            ((IBreakSpeedChanger)item).onBreakEvent(event, headSlotItemStack);
        }
    }

    private static void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof MobEntity) {
            MobEntity entity = (MobEntity)event.getEntity();
            for (Item item : items) {
                if (!(item instanceof IMobEntityChanger)) continue;
                ((IMobEntityChanger)item).onEntityJoinWorldEvent(entity, event);
            }
        }
    }

    private static void onItemFishedEvent(ItemFishedEvent event) {
        ItemStack headSlotItemStack = event.getPlayer().func_184582_a(EquipmentSlotType.HEAD);
        for (Item item : items) {
            if (!(item instanceof IItemFishedListener) || headSlotItemStack.func_77973_b() != item) continue;
            ((IItemFishedListener)item).onItemFishedListener(event, headSlotItemStack);
        }
    }

    private static void onItemToolTipEvent(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        for (Item item : items) {
            if (stack.func_77973_b() != item) continue;
            ((AbstractHatItem)item).onItemToolTipEvent(stack, event.getToolTip());
        }
    }

    private static void onLivingDropsEvent(LivingDropsEvent event) {
        if (event.getSource().func_76364_f() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getSource().func_76364_f();
            ItemStack headSlotItemStack = player.func_184582_a(EquipmentSlotType.HEAD);
            for (Item item : items) {
                if (!(item instanceof ILivingDropsListener) || item != headSlotItemStack.func_77973_b()) continue;
                ((ILivingDropsListener)item).onLivingDropsEvent(event, player, headSlotItemStack);
            }
        }
    }

    private static void onLivingEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        if (event.getSlot() == EquipmentSlotType.HEAD && event.getEntityLiving() instanceof PlayerEntity) {
            Item fromItem = event.getFrom().func_77973_b();
            Item toItem = event.getFrom().func_77973_b();
            for (Item item : items) {
                if (!(item instanceof IEquipmentChangeListener) || fromItem != item && toItem != item) continue;
                ((IEquipmentChangeListener)item).onEquipmentChangeEvent(event);
            }
        }
    }

    private static void onLivingSetAttackTargetEvent(LivingSetAttackTargetEvent event) {
        if (event.getEntity() instanceof MobEntity && event.getTarget() instanceof PlayerEntity) {
            MobEntity mob = (MobEntity)event.getEntity();
            PlayerEntity player = (PlayerEntity)event.getTarget();
            Item headSlotItem = player.func_184582_a(EquipmentSlotType.HEAD).func_77973_b();
            for (Item item : items) {
                if (!(item instanceof IAttackTargetChanger) || item != headSlotItem) continue;
                ((IAttackTargetChanger)item).onLivingSetAttackTarget(mob, player);
            }
        }
    }
}

