/*
 * Decompiled with CFR 0.152.
 */
package cech12.usefulhats.item;

import cech12.usefulhats.config.Config;
import cech12.usefulhats.item.AbstractHatItem;
import cech12.usefulhats.item.HatArmorMaterial;
import cech12.usefulhats.item.IEquipmentChangeListener;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;

public class AquanautHelmetItem
extends AbstractHatItem
implements IEquipmentChangeListener {
    private static final ResourceLocation AQUANAUT_GUI_TEX_PATH = new ResourceLocation("usefulhats", "textures/misc/aquanautblur.png");

    public AquanautHelmetItem() {
        super("aquanaut_helmet", HatArmorMaterial.AQUANAUT, AquanautHelmetItem.rawColorFromRGB(71, 191, 74), Config.AQUANAUT_HELMET_ENABLED, Config.AQUANAUT_HELMET_DAMAGE_ENABLED);
    }

    private int getEffectTimeConfig(int enchantmentLevel) {
        if (enchantmentLevel <= 0) {
            return Config.AQUANAUT_HELMET_EFFECT_TIME_WITH_RESPIRATION_0.getValue();
        }
        switch (enchantmentLevel) {
            case 1: {
                return Config.AQUANAUT_HELMET_EFFECT_TIME_WITH_RESPIRATION_1.getValue();
            }
            case 2: {
                return Config.AQUANAUT_HELMET_EFFECT_TIME_WITH_RESPIRATION_2.getValue();
            }
        }
        return Config.AQUANAUT_HELMET_EFFECT_TIME_WITH_RESPIRATION_3.getValue();
    }

    @Override
    public void onItemToolTipEvent(ItemStack stack, List<ITextComponent> tooltip) {
        super.onItemToolTipEvent(stack, tooltip);
        int effectTime = this.getEffectTimeConfig(EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185298_f, (ItemStack)stack));
        tooltip.add(new TranslationTextComponent("item.usefulhats.aquanaut_helmet.desc.conduit_power", new Object[]{effectTime}).func_211708_a(TextFormatting.BLUE));
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        int maxDuration = this.getEffectTimeConfig(EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185298_f, (ItemStack)stack)) * 20;
        if (!player.func_208600_a(FluidTags.field_206959_a)) {
            player.func_195064_c(new EffectInstance(Effects.field_205136_C, maxDuration, 0, false, false, true));
        } else {
            EffectInstance conduitPowerEffect = player.func_70660_b(Effects.field_205136_C);
            if (conduitPowerEffect != null && conduitPowerEffect.func_76459_b() <= maxDuration && field_77697_d.nextInt(20) == 0) {
                this.damageHatItemByOne(stack, player);
            }
        }
    }

    @Override
    public void onEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            ItemStack oldItemStack = event.getFrom();
            ItemStack newItemStack = event.getTo();
            if (oldItemStack.func_77973_b() == this && newItemStack.func_77973_b() != this) {
                int maxDuration = (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185298_f, (ItemStack)oldItemStack) + 1) * 1200;
                EffectInstance conduitPowerEffect = player.func_70660_b(Effects.field_205136_C);
                if (conduitPowerEffect != null && conduitPowerEffect.func_76459_b() <= maxDuration) {
                    player.func_195063_d(Effects.field_205136_C);
                }
            }
        }
    }

    public void renderHelmetOverlay(ItemStack stack, PlayerEntity player, int width, int height, float partialTicks) {
        GlStateManager.func_227731_j_();
        GlStateManager.func_227667_a_((boolean)false);
        GlStateManager.func_227644_a_((int)GlStateManager.SourceFactor.SRC_ALPHA.field_225655_p_, (int)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA.field_225654_o_, (int)GlStateManager.SourceFactor.ONE.field_225655_p_, (int)GlStateManager.DestFactor.ZERO.field_225654_o_);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(AQUANAUT_GUI_TEX_PATH);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_(0.0, (double)height, -90.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)width, (double)height, -90.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)width, 0.0, -90.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_(0.0, 0.0, -90.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_227667_a_((boolean)true);
        GlStateManager.func_227734_k_();
    }
}

