/*
 * Decompiled with CFR 0.152.
 */
package cech12.usefulhats.item;

import cech12.usefulhats.config.Config;
import cech12.usefulhats.item.AbstractMiningHatItem;
import cech12.usefulhats.item.HatArmorMaterial;
import cech12.usefulhats.item.IBreakSpeedChanger;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;

public class ChoppingHatItem
extends AbstractMiningHatItem
implements IBreakSpeedChanger {
    public ChoppingHatItem() {
        super("chopping_hat", HatArmorMaterial.CHOPPING, ChoppingHatItem.rawColorFromRGB(91, 91, 91), Config.CHOPPING_HAT_ENABLED, Config.CHOPPING_HAT_DAMAGE_ENABLED);
    }

    private double[] getSpeedConfig() {
        double[] speedConfig = new double[]{Config.CHOPPING_HAT_SPEED_WITH_EFFICIENCY_0.getValue(), Config.CHOPPING_HAT_SPEED_WITH_EFFICIENCY_1.getValue(), Config.CHOPPING_HAT_SPEED_WITH_EFFICIENCY_2.getValue(), Config.CHOPPING_HAT_SPEED_WITH_EFFICIENCY_3.getValue(), Config.CHOPPING_HAT_SPEED_WITH_EFFICIENCY_4.getValue(), Config.CHOPPING_HAT_SPEED_WITH_EFFICIENCY_5.getValue()};
        return speedConfig;
    }

    @Override
    public void onItemToolTipEvent(ItemStack stack, List<ITextComponent> tooltip) {
        super.onItemToolTipEvent(stack, tooltip);
        int value = (int)(this.getEnchantmentValue(stack, this.getSpeedConfig()) * 100.0);
        tooltip.add(new TranslationTextComponent("item.usefulhats.chopping_hat.desc.chopping_speed", new Object[]{value}).func_211708_a(TextFormatting.BLUE));
    }

    @Override
    public void onBreakSpeedEvent(PlayerEvent.BreakSpeed event, ItemStack headSlotItemStack) {
        if (!event.isCanceled() && event.getPlayer().func_184614_ca().getToolTypes().contains(ToolType.AXE) && event.getState().isToolEffective(ToolType.AXE)) {
            event.setNewSpeed(event.getOriginalSpeed() * (1.0f + (float)this.getEnchantmentValue(headSlotItemStack, this.getSpeedConfig())));
        }
    }

    @Override
    public void onBreakEvent(BlockEvent.BreakEvent event, ItemStack headSlotItemStack) {
        if (!event.isCanceled() && event.getPlayer().func_184614_ca().getToolTypes().contains(ToolType.AXE) && event.getState().isToolEffective(ToolType.AXE)) {
            this.damageHatItemByOne(headSlotItemStack, event.getPlayer());
        }
    }
}

