/*
 * Decompiled with CFR 0.152.
 */
package cech12.usefulhats.item;

import cech12.usefulhats.config.Config;
import cech12.usefulhats.item.AbstractHatItem;
import cech12.usefulhats.item.HatArmorMaterial;
import cech12.usefulhats.item.IAttackTargetChanger;
import cech12.usefulhats.item.IMobEntityChanger;
import java.util.List;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.ZombiePigmanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

public class HaloItem
extends AbstractHatItem
implements IAttackTargetChanger,
IMobEntityChanger {
    public HaloItem() {
        super("halo", HatArmorMaterial.HALO, HaloItem.rawColorFromRGB(255, 236, 142), Config.HALO_ENABLED, Config.HALO_DAMAGE_ENABLED);
    }

    @Override
    public void onItemToolTipEvent(ItemStack stack, List<ITextComponent> tooltip) {
        super.onItemToolTipEvent(stack, tooltip);
        tooltip.add(new TranslationTextComponent("item.usefulhats.halo.desc.no_attack", new Object[0]).func_211708_a(TextFormatting.BLUE));
        tooltip.add(new TranslationTextComponent("item.usefulhats.halo.desc.beware_of_nether", new Object[0]).func_211708_a(TextFormatting.RED));
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        if (player.field_71093_bK != DimensionType.field_223228_b_) {
            Vec3d playerPos = player.func_213303_ch();
            int range = Config.HALO_DETECTING_RANGE.getValue();
            AxisAlignedBB radius = new AxisAlignedBB(playerPos.func_82615_a() - (double)range, playerPos.func_82617_b() - (double)range, playerPos.func_82616_c() - (double)range, playerPos.func_82615_a() + (double)range, playerPos.func_82617_b() + (double)range, playerPos.func_82616_c() + (double)range);
            List mobsInRange = player.field_70170_p.func_175647_a(MobEntity.class, radius, entity -> entity instanceof MobEntity && entity.func_184222_aU());
            if (!mobsInRange.isEmpty() && field_77697_d.nextInt(20) == 0) {
                this.damageHatItemByOne(stack, player);
            }
        }
    }

    @Override
    public void onEntityJoinWorldEvent(MobEntity entity, EntityJoinWorldEvent event) {
        if (entity instanceof ZombiePigmanEntity) {
            entity.field_70715_bh.func_75776_a(1, (Goal)new NearestHaloTargetGoal(entity, this));
        }
    }

    @Override
    public void onLivingSetAttackTarget(MobEntity entity, PlayerEntity targetPlayer) {
        if (entity.func_184222_aU() && targetPlayer.field_71093_bK != DimensionType.field_223228_b_) {
            entity.func_70624_b(null);
        }
    }

    private static class NearestHaloTargetGoal
    extends NearestAttackableTargetGoal<PlayerEntity> {
        NearestHaloTargetGoal(MobEntity mobEntity, IMobEntityChanger hatItem) {
            super(mobEntity, PlayerEntity.class, 0, true, false, entity -> entity instanceof PlayerEntity && entity.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == hatItem && entity.field_71093_bK == DimensionType.field_223228_b_);
        }
    }
}

