/*
 * Decompiled with CFR 0.152.
 */
package cech12.usefulhats.item;

import cech12.usefulhats.UsefulHatsUtils;
import cech12.usefulhats.config.Config;
import cech12.usefulhats.item.AbstractHatItem;
import cech12.usefulhats.item.HatArmorMaterial;
import cech12.usefulhats.item.IUsefulHatModelOwner;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class PostmanHatItem
extends AbstractHatItem
implements IUsefulHatModelOwner {
    public PostmanHatItem() {
        super("postman_hat", HatArmorMaterial.POSTMAN, PostmanHatItem.rawColorFromRGB(57, 99, 150), Config.POSTMAN_HAT_ENABLED, Config.POSTMAN_HAT_DAMAGE_ENABLED);
        this.addAllowedEnchantment(Enchantments.field_185305_q);
    }

    @Override
    public void onItemToolTipEvent(ItemStack stack, List<ITextComponent> tooltip) {
        super.onItemToolTipEvent(stack, tooltip);
        int enchantmentLevel = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)stack) + 1;
        tooltip.add(new TranslationTextComponent("item.usefulhats.postman_hat.desc.speed", new Object[]{UsefulHatsUtils.getRomanNumber(enchantmentLevel, false)}).func_211708_a(TextFormatting.BLUE));
        if (Config.POSTMAN_HAT_HUNGER_ENABLED.getValue()) {
            tooltip.add(new TranslationTextComponent("item.usefulhats.postman_hat.desc.hunger", new Object[0]).func_211708_a(TextFormatting.RED));
        }
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        if (player.func_70051_ag() && player.func_70660_b(Effects.field_76424_c) == null) {
            player.func_195064_c(new EffectInstance(Effects.field_76424_c, 0, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)stack), false, false, true));
            if (Config.POSTMAN_HAT_HUNGER_ENABLED.getValue()) {
                player.func_195064_c(new EffectInstance(Effects.field_76438_s));
            }
            if (field_77697_d.nextInt(20) == 0) {
                this.damageHatItemByOne(stack, player);
            }
        }
    }
}

