/*
 * Decompiled with CFR 0.152.
 */
package cech12.usefulhats.item;

import cech12.usefulhats.config.Config;
import cech12.usefulhats.item.AbstractHatItem;
import cech12.usefulhats.item.HatArmorMaterial;
import cech12.usefulhats.item.IEquipmentChangeListener;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;

public class WingHelmetItem
extends AbstractHatItem
implements IEquipmentChangeListener {
    private static final int LEVITATION_AMPLIFIER = 2;
    private static final int LEVITATION_DURATION = 200;

    public WingHelmetItem() {
        super("wing_helmet", HatArmorMaterial.WING, WingHelmetItem.rawColorFromRGB(255, 255, 255), Config.WING_HELMET_ENABLED, Config.WING_HELMET_DAMAGE_ENABLED);
    }

    @Override
    public void onItemToolTipEvent(ItemStack stack, List<ITextComponent> tooltip) {
        super.onItemToolTipEvent(stack, tooltip);
        tooltip.add(new TranslationTextComponent("item.usefulhats.wing_helmet.desc.slow_falling", new Object[0]).func_211708_a(TextFormatting.BLUE));
        if (Config.WING_HELMET_LEVITATION_ENABLED.getValue()) {
            tooltip.add(new TranslationTextComponent("item.usefulhats.wing_helmet.desc.scared", new Object[0]).func_211708_a(TextFormatting.RED));
        }
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        if (!player.field_70122_E && !player.func_70090_H()) {
            if (player.func_70660_b(Effects.field_188424_y) == null && player.func_70660_b(Effects.field_204839_B) == null) {
                player.func_195064_c(new EffectInstance(Effects.field_204839_B));
                if (field_77697_d.nextInt(20) == 0) {
                    this.damageHatItemByOne(stack, player);
                }
            }
            if (Config.WING_HELMET_LEVITATION_ENABLED.getValue() && player.func_189748_bU() != null && player.func_189748_bU().func_76346_g() instanceof LivingEntity && field_77697_d.nextInt(100) == 0) {
                player.func_195064_c(new EffectInstance(Effects.field_188424_y, 200, 2));
            }
        }
    }

    @Override
    public void onEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            EffectInstance levitationEffect;
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            ItemStack oldItemStack = event.getFrom();
            ItemStack newItemStack = event.getTo();
            if (Config.WING_HELMET_LEVITATION_ENABLED.getValue() && oldItemStack.func_77973_b() == this && newItemStack.func_77973_b() != this && (levitationEffect = player.func_70660_b(Effects.field_188424_y)) != null && levitationEffect.func_76459_b() <= 200 && levitationEffect.func_76458_c() == 2) {
                player.func_195063_d(Effects.field_188424_y);
            }
        }
    }
}

