/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.blocks;

import com.tiviacz.pizzacraft.PizzaCraft;
import com.tiviacz.pizzacraft.init.ModBlocks;
import com.tiviacz.pizzacraft.init.ModItems;
import com.tiviacz.pizzacraft.tileentity.TileEntityMortarAndPestle;
import com.tiviacz.pizzacraft.util.Bounds;
import com.tiviacz.pizzacraft.util.IHasModel;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlockMortarAndPestle
extends BlockContainer
implements IHasModel {
    private static final PropertyInteger PESTLE = PropertyInteger.func_177719_a((String)"pestle", (int)0, (int)3);
    private static final AxisAlignedBB MORTAR_AND_PESTLE_AABB = new Bounds(4, 0, 4, 12, 4, 12).toAABB();

    public BlockMortarAndPestle(String name, Material material) {
        super(material);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149647_a(PizzaCraft.PIZZACRAFTTAB);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149752_b(10.0f);
        this.func_149711_c(2.0f);
        ModBlocks.BLOCKS.add((Block)this);
        ModItems.ITEMS.add((Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.MAIN_HAND) {
            FluidStack fluid;
            ItemStack stack = playerIn.func_184586_b(hand);
            TileEntityMortarAndPestle tile = (TileEntityMortarAndPestle)worldIn.func_175625_s(pos);
            IItemHandler inv = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            IFluidHandlerItem container = FluidUtil.getFluidHandler((ItemStack)stack);
            if (container != null && (fluid = FluidUtil.getFluidContained((ItemStack)stack)) != null && fluid.amount > 0) {
                int amount = fluid.amount;
                ItemStack stackOut = FluidUtil.tryEmptyContainer((ItemStack)stack, (IFluidHandler)tile.getTank(), (int)amount, (EntityPlayer)playerIn, (boolean)false).getResult();
                if (tile.getTank().getFluidAmount() + amount < tile.getTank().getCapacity() && tile.getTank().getFluid().isFluidEqual(fluid)) {
                    FluidUtil.tryEmptyContainer((ItemStack)stack, (IFluidHandler)tile.getTank(), (int)amount, (EntityPlayer)playerIn, (boolean)true);
                    tile.func_70296_d();
                    if (playerIn.func_191521_c(stackOut)) {
                        playerIn.func_145779_a(stackOut.func_77973_b(), stackOut.func_190916_E());
                    }
                    return true;
                }
            }
            if (stack.func_190926_b() && !playerIn.func_70093_af()) {
                int value = (Integer)state.func_177229_b((IProperty)PESTLE);
                if (value == 3) {
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)PESTLE, (Comparable)Integer.valueOf(0)));
                } else {
                    worldIn.func_175656_a(pos, state.func_177226_a((IProperty)PESTLE, (Comparable)Integer.valueOf(value + 1)));
                }
                tile.craft();
                return true;
            }
            if (!stack.func_190926_b() && inv.getStackInSlot(3).func_190926_b()) {
                playerIn.func_184611_a(hand, inv.insertItem(tile.getProperSlotForStack(), playerIn.func_184586_b(hand), false));
                return true;
            }
            if (stack.func_190926_b() && playerIn.func_70093_af()) {
                playerIn.func_184611_a(hand, inv.extractItem(tile.getProperSlotForTake(), 64, false));
                return true;
            }
        }
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityMortarAndPestle tile = (TileEntityMortarAndPestle)worldIn.func_175625_s(pos);
        IItemHandler inv = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            BlockMortarAndPestle.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) ? this.canBlockStay(worldIn, pos) : false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(worldIn, pos)) {
            worldIn.func_175698_g(pos);
        }
    }

    private boolean canBlockStay(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos, EnumFacing.UP);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return MORTAR_AND_PESTLE_AABB;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PESTLE});
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)PESTLE);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)PESTLE, (Comparable)Integer.valueOf(meta));
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityMortarAndPestle();
    }

    @Override
    public void registerModel() {
        PizzaCraft.proxy.registerItemRenderer(Item.func_150898_a((Block)this), 0, "inventory");
    }
}

