/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.blocks;

import com.tiviacz.pizzacraft.PizzaCraft;
import com.tiviacz.pizzacraft.init.ModBlocks;
import com.tiviacz.pizzacraft.init.ModItems;
import com.tiviacz.pizzacraft.tileentity.TileEntityPizzaBag;
import com.tiviacz.pizzacraft.util.Bounds;
import com.tiviacz.pizzacraft.util.IHasModel;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPizzaBag
extends BlockContainer
implements IHasModel {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private static final AxisAlignedBB PIZZA_BAG_AABB = new Bounds(0, 0, 0, 16, 5, 16).toAABB();

    public BlockPizzaBag(String name, Material materialIn) {
        super(materialIn);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149647_a(PizzaCraft.PIZZACRAFTTAB);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149711_c(0.5f);
        this.func_149752_b(2.5f);
        this.setHarvestLevel("hand", 0);
        ModBlocks.BLOCKS.add((Block)this);
        ModItems.ITEMS.add((Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!playerIn.func_70093_af()) {
            if (!worldIn.field_72995_K) {
                playerIn.openGui((Object)PizzaCraft.instance, 1, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        } else {
            TileEntityPizzaBag tile = (TileEntityPizzaBag)worldIn.func_175625_s(pos);
            tile.dropAsItem(worldIn, pos);
            worldIn.func_175698_g(pos);
        }
        return true;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.005f);
        if (this.canSilkHarvest(worldIn, pos, state, player) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            ItemStack itemstack = this.func_180643_i(state);
            if (!itemstack.func_190926_b()) {
                items.add(itemstack);
            }
            ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
            for (ItemStack item : items) {
                BlockPizzaBag.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
            }
        } else {
            this.harvesters.set(player);
            int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
            if (te instanceof TileEntityPizzaBag) {
                TileEntityPizzaBag tile = (TileEntityPizzaBag)te;
                if (!player.field_71075_bZ.field_75098_d) {
                    tile.dropAsItem(worldIn, pos);
                }
            }
            this.harvesters.set(null);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityPizzaBag) {
            ((TileEntityPizzaBag)tileentity).loadData(stack.func_77978_p());
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PIZZA_BAG_AABB;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityPizzaBag();
    }

    @Override
    public void registerModel() {
        PizzaCraft.proxy.registerItemRenderer(Item.func_150898_a((Block)this), 0, "inventory");
    }
}

