/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.blocks;

import com.tiviacz.pizzacraft.blocks.BlockPizza;
import com.tiviacz.pizzacraft.handlers.ConfigHandler;
import com.tiviacz.pizzacraft.init.ModBlocks;
import com.tiviacz.pizzacraft.init.ModItems;
import com.tiviacz.pizzacraft.util.Bounds;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockPizzaBoardBase
extends BlockPizza {
    public static final AxisAlignedBB[] PIZZA_BOARD_AABB = new AxisAlignedBB[]{new Bounds(0, 0, 0, 16, 2, 16).toAABB(), new Bounds(0, 0, 0, 16, 2, 16).toAABB(), new Bounds(0, 0, 0, 16, 2, 16).toAABB(), new Bounds(0, 0, 0, 16, 2, 16).toAABB(), new Bounds(0, 0, 0, 16, 2, 16).toAABB(), new Bounds(0, 0, 0, 16, 2, 16).toAABB()};
    private float saturation;
    private int foodstats;
    private Item pizzaslice;

    public BlockPizzaBoardBase(String name, Material material, int foodstats, Float saturation, Item pizzaslice) {
        super(name, material, foodstats, saturation, pizzaslice);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(2.0f);
        this.func_149752_b(15.0f);
        this.saturation = saturation.floatValue();
        this.foodstats = foodstats;
        this.pizzaslice = pizzaslice;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PIZZA_BOARD_AABB[(Integer)state.func_177229_b((IProperty)BITES)];
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack helditem = playerIn.func_184586_b(hand);
        int i = (Integer)state.func_177229_b((IProperty)BITES);
        if (!worldIn.field_72995_K) {
            if (helditem.func_190926_b() && playerIn.func_70093_af() && i == 0 && (playerIn.func_71043_e(true) || playerIn.func_71043_e(false))) {
                BlockPizzaBoardBase.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((Block)this));
                worldIn.func_175698_g(pos);
            }
            if (ConfigHandler.isKnifeNeeded) {
                if (helditem.func_77973_b() == ModItems.KNIFE) {
                    BlockPizzaBoardBase.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(this.pizzaslice));
                    helditem.func_77972_a(1, (EntityLivingBase)playerIn);
                    if (i < 5) {
                        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
                    } else {
                        worldIn.func_180501_a(pos, ModBlocks.PIZZA_BOARD.func_176223_P(), 3);
                    }
                }
            } else if (playerIn.func_70093_af()) {
                BlockPizzaBoardBase.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(this.pizzaslice));
                if (i < 5) {
                    worldIn.func_180501_a(pos, state.func_177226_a((IProperty)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
                } else {
                    worldIn.func_180501_a(pos, ModBlocks.PIZZA_BOARD.func_176223_P(), 3);
                }
            }
            return this.eatCake(worldIn, pos, state, playerIn);
        }
        return true;
    }

    private boolean eatCake(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!player.func_71043_e(false) || player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() == ModItems.KNIFE || player.func_70093_af()) {
            return false;
        }
        player.func_71029_a(StatList.field_188076_J);
        player.func_71024_bL().func_75122_a(this.foodstats, this.saturation);
        int i = (Integer)state.func_177229_b((IProperty)BITES);
        if (i < 5) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)BITES, (Comparable)Integer.valueOf(i + 1)), 3);
        } else {
            worldIn.func_180501_a(pos, ModBlocks.PIZZA_BOARD.func_176223_P(), 3);
        }
        return true;
    }

    @Override
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        int i = (Integer)state.func_177229_b((IProperty)BITES);
        if (!this.canBlockStay(worldIn, pos)) {
            if (i == 0) {
                this.func_176226_b(worldIn, pos, state, 1);
                worldIn.func_175698_g(pos);
            } else {
                ModBlocks.PIZZA_BOARD.func_176226_b(worldIn, pos, state, 1);
                worldIn.func_175698_g(pos);
            }
        }
    }

    @Override
    public int func_149745_a(Random random) {
        return 1;
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        int i = (Integer)state.func_177229_b((IProperty)BITES);
        if (i == 0) {
            return Item.func_150898_a((Block)this);
        }
        return Item.func_150898_a((Block)ModBlocks.PIZZA_BOARD);
    }
}

