/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.crafting.bakeware;

import com.google.common.collect.Lists;
import com.tiviacz.pizzacraft.crafting.bakeware.BaseShapelessRecipe;
import com.tiviacz.pizzacraft.crafting.bakeware.CraftingUtils;
import com.tiviacz.pizzacraft.crafting.bakeware.IBakewareRecipe;
import com.tiviacz.pizzacraft.crafting.bakeware.PizzaRecipes;
import com.tiviacz.pizzacraft.gui.inventory.InventoryCraftingImproved;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public abstract class PizzaCraftingManager {
    public static final PizzaCraftingManager PIZZA_CRAFTING = new PizzaCraftingManager(3, "PizzaCrafting"){

        @Override
        public void setRecipes() {
            new PizzaRecipes().addRecipes(this);
        }
    };
    private final List<IBakewareRecipe> recipes = Lists.newArrayList();
    private int xy;
    private String name;

    public static PizzaCraftingManager getPizzaCraftingInstance() {
        return PIZZA_CRAFTING;
    }

    public PizzaCraftingManager(int xy, String name) {
        this.xy = xy;
        this.name = name;
        this.recipes.sort((pCompare1, pCompare2) -> Integer.compare(pCompare2.getRecipeSize(), pCompare1.getRecipeSize()));
        this.setRecipes();
    }

    public abstract void setRecipes();

    public String getName() {
        return this.name;
    }

    public void addShapelessRecipe(ItemStack stack, Object ... recipeComponents) {
        NonNullList list = NonNullList.func_191196_a();
        CraftingUtils.addShapelessRecipe((NonNullList<ItemStack>)list, recipeComponents);
        this.recipes.add(new BaseShapelessRecipe(stack, (NonNullList<ItemStack>)list));
    }

    public void addRecipe(IBakewareRecipe recipe) {
        this.recipes.add(recipe);
    }

    public void addRecipes(IBakewareRecipe ... recipes) {
        Arrays.stream(recipes).forEach(this::addRecipe);
    }

    public void removeRecipe(IBakewareRecipe recipe) {
        this.recipes.remove(recipe);
    }

    public ItemStack findMatchingRecipe(InventoryCraftingImproved craftMatrix, World worldIn) {
        return CraftingUtils.findMatchingRecipe(this.recipes, craftMatrix, worldIn);
    }

    public NonNullList<ItemStack> getRemainingItems(InventoryCraftingImproved craftMatrix, World worldIn) {
        return CraftingUtils.getRemainingItems(this.recipes, craftMatrix, worldIn);
    }

    public List<IBakewareRecipe> getRecipeList() {
        return this.recipes;
    }
}

