/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.crafting.mortar;

import com.tiviacz.pizzacraft.crafting.bakeware.ItemStackUtils;
import com.tiviacz.pizzacraft.tileentity.TileEntityMortarAndPestle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ShapelessMortarOreRecipeUtils {
    public static void createRecipe(ItemStack output, List<Object> input, Object ... recipe) {
        Arrays.stream(recipe).forEachOrdered(in -> {
            if (in instanceof ItemStack) {
                input.add(((ItemStack)in).func_77946_l());
            } else if (in instanceof Item || in instanceof Block) {
                input.add(ItemStackUtils.getItemStack(in));
            } else if (in instanceof String) {
                input.add(OreDictionary.getOres((String)((String)in)));
            } else {
                StringBuilder ret = new StringBuilder("Invalid shapeless ore recipe: ");
                Arrays.stream(recipe).forEachOrdered(tmp -> ret.append(tmp).append(", "));
                ret.append(output);
                throw new RuntimeException(ret.toString());
            }
        });
    }

    public static boolean matches(List<Object> input, TileEntityMortarAndPestle tile) {
        ArrayList<Object> required = new ArrayList<Object>();
        required.addAll(input);
        for (int x = 0; x < tile.getInventory().getSlots(); ++x) {
            ItemStack slot = tile.getInventory().getStackInSlot(x);
            if (slot.func_190926_b()) continue;
            boolean inRecipe = false;
            for (Object e : required) {
                boolean match = false;
                if (e instanceof ItemStack) {
                    match = OreDictionary.itemMatches((ItemStack)((ItemStack)e), (ItemStack)slot, (boolean)false);
                } else if (e instanceof List) {
                    Iterator itr = ((List)e).iterator();
                    while (itr.hasNext() && !match) {
                        match = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)slot, (boolean)false);
                    }
                }
                if (!match) continue;
                inRecipe = true;
                required.remove(e);
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }
}

