/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.handlers;

import com.tiviacz.pizzacraft.init.ModBlocks;
import com.tiviacz.pizzacraft.init.ModItems;
import com.tiviacz.pizzacraft.init.ModPotions;
import com.tiviacz.pizzacraft.items.ItemPizzaShield;
import com.tiviacz.pizzacraft.util.IHasModel;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionType;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class CommonEventHandler {
    @SubscribeEvent
    public static void onItemRegister(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModItems.ITEMS.toArray(new Item[0]));
    }

    @SubscribeEvent
    public static void onBlockRegister(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModBlocks.BLOCKS.toArray(new Block[0]));
    }

    @SubscribeEvent
    public static void onPotionRegister(RegistryEvent.Register<Potion> event) {
        event.getRegistry().register((IForgeRegistryEntry)ModPotions.EYE_IRRITATION_EFFECT);
    }

    @SubscribeEvent
    public static void onPotionTypeRegister(RegistryEvent.Register<PotionType> event) {
        event.getRegistry().register((IForgeRegistryEntry)ModPotions.EYE_IRRITATION_POTION);
        event.getRegistry().register((IForgeRegistryEntry)ModPotions.LONG_EYE_IRRITATION_POTION);
    }

    @SubscribeEvent
    public static void onModelRegister(ModelRegistryEvent event) {
        for (Item item : ModItems.ITEMS) {
            if (!(item instanceof IHasModel)) continue;
            ((IHasModel)item).registerModel();
        }
        for (Block block : ModBlocks.BLOCKS) {
            if (!(block instanceof IHasModel)) continue;
            ((IHasModel)block).registerModel();
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("pizzacraft")) {
            ConfigManager.sync((String)"pizzacraft", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public static void furnaceFuelBurnTime(FurnaceFuelBurnTimeEvent event) {
        Item item = event.getItemStack().func_77973_b();
        if (item == ModItems.PAPER_MASS) {
            event.setBurnTime(50);
        }
        if (item == ModItems.CARDBOARD || item == ModItems.RED_CLOTH) {
            event.setBurnTime(100);
        }
        if (item == Item.func_150898_a((Block)ModBlocks.PIZZA_BOX)) {
            event.setBurnTime(800);
        }
        if (item == ModItems.PIZZA_BOARD_SHIELD || item == ModItems.PIZZA_BURNT_SHIELD) {
            event.setBurnTime(200);
        }
        if (item == Item.func_150898_a((Block)ModBlocks.PIZZA_BOARD) || item == Item.func_150898_a((Block)ModBlocks.PIZZA_BURNT)) {
            event.setBurnTime(400);
        }
    }

    @SubscribeEvent
    public static void getMilk(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        EntityPlayer player = event.getEntityPlayer();
        ItemStack helditem = player.func_184614_ca();
        if (entity instanceof EntityCow && helditem.func_77973_b() == Items.field_151069_bo) {
            player.func_184185_a(SoundEvents.field_187615_H, 1.0f, 1.0f);
            if (!event.getWorld().field_72995_K && event.getHand() == EnumHand.MAIN_HAND) {
                helditem.func_190918_g(1);
                if (!player.field_71071_by.func_70441_a(new ItemStack(ModItems.MILK_BOTTLE, 1))) {
                    player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, (double)entity.func_180425_c().func_177958_n(), (double)entity.func_180425_c().func_177956_o(), (double)entity.func_180425_c().func_177952_p(), new ItemStack(ModItems.MILK_BOTTLE, 1)));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving().func_70644_a(ModPotions.EYE_IRRITATION_EFFECT)) {
            Vec3d eyesPosition = event.getEntityLiving().func_174824_e(Minecraft.func_71410_x().func_184121_ak());
            Vec3d normalizedVec = event.getEntityLiving().func_70040_Z().func_72432_b().func_186678_a(0.25);
            Vec3d newVec = eyesPosition.func_178787_e(normalizedVec);
            if (event.getEntityLiving().field_70170_p instanceof WorldServer) {
                WorldServer worldServer = (WorldServer)event.getEntityLiving().field_70170_p;
                worldServer.func_175739_a(EnumParticleTypes.WATER_SPLASH, newVec.field_72450_a, newVec.field_72448_b, newVec.field_72449_c, 3, 0.0, 0.0, 0.0, 1.0, new int[]{1});
            }
        }
    }

    @SubscribeEvent
    public static void onShieldBlock(LivingAttackEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        if (player.func_184607_cu() == null) {
            return;
        }
        ItemStack activeItemStack = player.func_184607_cu();
        float damage = event.getAmount();
        if (damage > 0.0f && activeItemStack != null && activeItemStack.func_77973_b() instanceof ItemPizzaShield) {
            int i = 1 + MathHelper.func_76141_d((float)damage);
            activeItemStack.func_77972_a(i, (EntityLivingBase)player);
            if (activeItemStack.func_190916_E() <= 0) {
                EnumHand enumhand = player.func_184600_cs();
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)activeItemStack, (EnumHand)enumhand);
                if (enumhand == EnumHand.MAIN_HAND) {
                    player.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                } else {
                    player.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                }
                activeItemStack = ItemStack.field_190927_a;
                if (player.field_70170_p.field_72995_K) {
                    player.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + player.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerBlockColourHandlers(ColorHandlerEvent.Block event) {
        BlockColors blockColors = event.getBlockColors();
        IBlockColor grassColourHandler = (state, blockAccess, pos, tintIndex) -> {
            if (blockAccess != null && pos != null) {
                return BiomeColorHelper.func_180286_a((IBlockAccess)blockAccess, (BlockPos)pos);
            }
            return ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
        };
        blockColors.func_186722_a(grassColourHandler, new Block[]{ModBlocks.OLIVE_LEAVES});
        blockColors.func_186722_a(grassColourHandler, new Block[]{ModBlocks.OLIVE_LEAVES_GROWING});
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerItemColourHandlers(ColorHandlerEvent.Item event) {
        BlockColors blockColors = event.getBlockColors();
        ItemColors itemColors = event.getItemColors();
        IItemColor itemBlockColourHandler = (stack, tintIndex) -> {
            IBlockState state = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
            return blockColors.func_186724_a(state, null, null, tintIndex);
        };
        itemColors.func_186731_a(itemBlockColourHandler, new Block[]{ModBlocks.OLIVE_LEAVES});
        itemColors.func_186731_a(itemBlockColourHandler, new Block[]{ModBlocks.OLIVE_LEAVES_GROWING});
    }
}

