/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.tileentity;

import com.tiviacz.pizzacraft.crafting.mortar.MortarRecipeManager;
import com.tiviacz.pizzacraft.crafting.mortar.MortarRecipeUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityMortarAndPestle
extends TileEntity {
    private FluidTank tank = new FluidTank(1000);
    private ItemStackHandler inventory = new ItemStackHandler(4){

        protected void onContentsChanged(int slot) {
            TileEntityMortarAndPestle.this.resetProgress();
        }
    };
    private int craftingProgress;

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.inventory : super.getCapability(capability, facing));
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        compound.func_74768_a("craftingProgress", this.craftingProgress);
        this.tank.writeToNBT(compound);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        this.craftingProgress = compound.func_74762_e("craftingProgress");
        this.tank.readFromNBT(compound);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public int getSizeInventory() {
        return 4;
    }

    public ItemStack decrStackSize(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.getActualInputs(), (int)index, (int)count);
        return itemstack;
    }

    public int getProperSlotForStack() {
        for (int x = 0; x < this.inventory.getSlots(); ++x) {
            if (!this.inventory.getStackInSlot(x).func_190926_b()) continue;
            return x;
        }
        return 0;
    }

    public int getProperSlotForTake() {
        for (int x = 3; x > -1; --x) {
            if (this.inventory.getStackInSlot(x).func_190926_b()) continue;
            return x;
        }
        return 0;
    }

    public void resetProgress() {
        this.craftingProgress = 0;
    }

    public boolean canCraft(MortarRecipeManager manager) {
        return !manager.findMatchingRecipe(this, this.field_145850_b).func_190926_b();
    }

    public void craft() {
        MortarRecipeManager manager = MortarRecipeManager.getMortarManagerInstance();
        if (this.canCraft(manager)) {
            ItemStack result = manager.findMatchingRecipe(this, this.field_145850_b);
            int duration = manager.getRecipeDuration(this, this.field_145850_b);
            ++this.craftingProgress;
            if (this.craftingProgress == duration) {
                this.craftingProgress = 0;
                List<ItemStack> list = manager.getRemainingItems(this, this.field_145850_b);
                MortarRecipeUtils.onTake(this, list);
                if (!this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, result));
                }
            }
        }
    }

    public List<ItemStack> getActualInputs() {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            inputs.add(stack);
        }
        return inputs;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        tag.func_74768_a("craftingProgress", this.craftingProgress);
        this.tank.writeToNBT(tag);
        return tag;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
        this.craftingProgress = tag.func_74762_e("craftingProgress");
        this.tank.readFromNBT(tag);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v(), this.func_174877_v().func_177982_a(1, 1, 1));
    }
}

