/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.util;

import net.minecraft.block.Block;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Triple;

public class RenderUtils {
    private static final double OFFSET = 0.01;
    private static final double MINY = 0.01;
    private static final double MIN = 0.135;
    private static final double MAX = 0.515;
    private static double[][][] coordinates = new double[][][]{new double[][]{{0.135, 0.01, 0.135}, {0.135, 0.01, 0.515}, {0.515, 0.01, 0.515}, {0.515, 0.01, 0.135}}, new double[][]{{0.135, 0.515, 0.135}, {0.135, 0.515, 0.515}, {0.515, 0.515, 0.515}, {0.515, 0.515, 0.135}}, new double[][]{{0.135, 0.01, 0.135}, {0.135, 0.515, 0.135}, {0.515, 0.515, 0.135}, {0.515, 0.01, 0.135}}, new double[][]{{0.135, 0.01, 0.515}, {0.135, 0.515, 0.515}, {0.515, 0.515, 0.515}, {0.515, 0.01, 0.515}}, new double[][]{{0.135, 0.01, 0.135}, {0.135, 0.515, 0.135}, {0.135, 0.515, 0.515}, {0.135, 0.01, 0.515}}, new double[][]{{0.515, 0.01, 0.135}, {0.515, 0.515, 0.135}, {0.515, 0.515, 0.515}, {0.515, 0.01, 0.515}}};

    public static void renderFluidSides(double height, int color, int brightness) {
        int l2 = brightness >> 16 & 0xFFFF;
        int i3 = brightness & 0xFFFF;
        Triple<Float, Float, Float> colorParts = RenderUtils.getFluidVertexBufferColor(color);
        float r = ((Float)colorParts.getLeft()).floatValue();
        float g = ((Float)colorParts.getMiddle()).floatValue();
        float b = ((Float)colorParts.getRight()).floatValue();
        float a = 1.0f;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            TextureAtlasSprite icon = RenderUtils.getFluidIcon(new FluidStack(FluidRegistry.WATER, 250), side);
            Tessellator t = Tessellator.func_178181_a();
            BufferBuilder worldRenderer = t.func_178180_c();
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            double[][] c = coordinates[side.ordinal()];
            double replacedMaxV = side == EnumFacing.UP || side == EnumFacing.DOWN ? (double)icon.func_94207_b(8.0) : (double)(icon.func_94210_h() - icon.func_94206_g()) * height + (double)icon.func_94206_g();
            double replacedU1 = side == EnumFacing.UP || side == EnumFacing.DOWN ? (double)icon.func_94214_a(4.0) : (double)icon.func_94214_a(7.0);
            double replacedU2 = side == EnumFacing.UP || side == EnumFacing.DOWN ? (double)icon.func_94214_a(12.0) : (double)icon.func_94214_a(8.0);
            worldRenderer.func_181662_b(c[0][0], RenderUtils.getHeight(side, c[0][1], height), c[0][2]).func_187315_a(replacedU1, replacedMaxV).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(c[1][0], RenderUtils.getHeight(side, c[1][1], height), c[1][2]).func_187315_a(replacedU1, (double)icon.func_94206_g()).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(c[2][0], RenderUtils.getHeight(side, c[2][1], height), c[2][2]).func_187315_a(replacedU2, (double)icon.func_94206_g()).func_181666_a(r, g, b, a).func_181675_d();
            worldRenderer.func_181662_b(c[3][0], RenderUtils.getHeight(side, c[3][1], height), c[3][2]).func_187315_a(replacedU2, replacedMaxV).func_181666_a(r, g, b, a).func_181675_d();
            t.func_78381_a();
        }
    }

    private static double getHeight(EnumFacing side, double height, double replaceHeight) {
        if (height == 0.515) {
            return replaceHeight;
        }
        return height;
    }

    public static void renderFluidInTank(final int color, double x, double y, double z) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderUtils.renderFluidContext(x, y, z, new IFluidContextRender(){

            @Override
            public void renderFluid() {
                double height = 0.0309375;
                RenderUtils.renderFluidSides(height, color, 100);
            }
        });
        GlStateManager.func_179121_F();
    }

    public static TextureAtlasSprite getFluidIcon(FluidStack fluid, EnumFacing side) {
        TextureAtlasSprite icon;
        BlockStaticLiquid defaultBlock;
        BlockStaticLiquid block = defaultBlock = Blocks.field_150355_j;
        if (fluid.getFluid().getBlock() != null) {
            block = fluid.getFluid().getBlock();
        }
        if (side == null) {
            side = EnumFacing.UP;
        }
        if ((icon = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getFluid().getFlowing(fluid).toString())) == null || side == EnumFacing.UP || side == EnumFacing.DOWN) {
            icon = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluid.getFluid().getStill(fluid).toString());
        }
        if (icon == null && (icon = RenderUtils.getBlockIcon((Block)block)) == null) {
            icon = RenderUtils.getBlockIcon((Block)defaultBlock);
        }
        return icon;
    }

    public static TextureAtlasSprite getBlockIcon(Block block) {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(block.func_176223_P());
    }

    public static void renderFluidContext(double x, double y, double z, IFluidContextRender render) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179084_k();
        GlStateManager.func_179129_p();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        render.renderFluid();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    public static Triple<Float, Float, Float> getFluidVertexBufferColor(int color) {
        return RenderUtils.intToRGB(color);
    }

    public static Triple<Float, Float, Float> intToRGB(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        return Triple.of((Object)Float.valueOf(red), (Object)Float.valueOf(green), (Object)Float.valueOf(blue));
    }

    public static interface IFluidContextRender {
        public void renderFluid();
    }
}

