/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.world.gen;

import com.tiviacz.pizzacraft.handlers.ConfigHandler;
import com.tiviacz.pizzacraft.world.gen.WorldGenOliveTree;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenTrees
implements IWorldGenerator {
    private final WorldGenerator OLIVE = new WorldGenOliveTree();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 1: {
                break;
            }
            case 0: {
                this.runGenerator(this.OLIVE, world, random, chunkX << 4, chunkZ << 4, ConfigHandler.treeGenChance, (Block)Blocks.field_150349_c);
                break;
            }
            case -1: {
                break;
            }
        }
    }

    private void runGenerator(WorldGenerator generator, World world, Random random, int chunkX, int chunkZ, int chance, Block topBlock) {
        boolean validBiome;
        int z;
        int y;
        int x = chunkX + random.nextInt(8) + 4;
        BlockPos pos = new BlockPos(x, y = WorldGenTrees.calculateGenerationHeight(world, x, z = chunkZ + random.nextInt(8) + 4, topBlock), z);
        Biome biome = world.func_180494_b(pos);
        boolean bl = validBiome = !BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY) && (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN));
        if (world.func_175624_G() != WorldType.field_77138_c && validBiome && random.nextInt(chance) == 0) {
            generator.func_180709_b(world, random, pos);
            System.out.println("generated at " + pos);
        }
    }

    private static int calculateGenerationHeight(World world, int x, int z, Block topBlock) {
        int y = world.func_72800_K();
        boolean foundGround = false;
        while (!foundGround && y-- >= 0) {
            Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            foundGround = block == topBlock;
        }
        return y;
    }
}

