--[[
Interface: 1.5.1.0 b6732

Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 25.08.2019
Version: 1.0.0.0

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

History:
V 1.0.0.0 @ 25.08.2019 - Release Version

Important:
No changes are to be made to this script without permission from GtX | Andy
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


ObjectStorageLoader = {}
ObjectStorageLoader.guiPath = ""

local modName = g_currentModName
local modDirectory = g_currentModDirectory

local eventFiles = {
    "ObjectStorageSpawnEvent.lua",
    "ObjectStorageStoreEvent.lua",
    "ObjectStorageFermentEvent.lua",
    "ObjectStorageSpecialStoreEvent.lua"
}

function ObjectStorageLoader.init()
    local xmlFile = loadXMLFile("modDesc", modDirectory .. "modDesc.xml")
    if xmlFile ~= 0 then

        local mainPath = modDirectory

        local filePath = getXMLString(xmlFile, "modDesc.objectStorageLoader#filePath")
        if filePath ~= nil then
            if filePath:sub(-1) ~= "/" then
                mainPath = mainPath .. filePath .. "/"
            else
                mainPath = mainPath .. filePath
            end
        end

        local eventsPath = getXMLString(xmlFile, "modDesc.objectStorageLoader#eventsPath")
        if eventsPath ~= nil then
            if eventsPath:sub(-1) ~= "/" then
                eventsPath = modDirectory .. eventsPath .. "/"
            else
                eventsPath = modDirectory .. eventsPath
            end
        else
            eventsPath = mainPath
        end

        local guiPath = getXMLString(xmlFile, "modDesc.objectStorageLoader#guiPath")
        if guiPath ~= nil then
            if guiPath:sub(-1) ~= "/" then
                guiPath = modDirectory .. guiPath .. "/"
            else
                guiPath = modDirectory .. guiPath
            end
        else
            guiPath = mainPath
        end

        local canLoadPlaceable = true
        ObjectStorageLoader.guiPath = guiPath

        for i = 1, #eventFiles do
            local sourceFile = eventsPath .. eventFiles[i]

            if fileExists(sourceFile) then
                source(sourceFile)
            else
                canLoadPlaceable = false
                print(string.format("  Error: [ObjectStorageLoader] - [%s]  Required event file '%s' could not be found!", modName, sourceFile))
            end
        end

        if ObjectStorageLoader:loadGUI(canLoadPlaceable, guiPath) then
            local placeablePath = mainPath .. "ObjectStorage.lua"

            if fileExists(placeablePath) then
                g_placeableTypeManager:addPlaceableType("objectStoragePlaceable", "ObjectStorage", placeablePath)
            else
                print(string.format("  Error: [ObjectStorageLoader] - [%s]  Required file '%s' could not be found!", modName, placeablePath))
            end
        else
            print(string.format("  Info: [ObjectStorageLoader] - placeableType '%s.objectStoragePlaceable' failed to load! Supporting files are missing.", modName))
        end

        delete(xmlFile)
        xmlFile = nil
    end
end

function ObjectStorageLoader:loadGUI(canLoad, guiPath)
    if canLoad then
        if g_gui ~= nil and g_gui.guis.ObjectStorageGui == nil then
            local luaPath = guiPath .. "ObjectStorageGui.lua"
            if fileExists(luaPath) then
                source(luaPath)
            else
                canLoad = false
                print(string.format("  Error: [ObjectStorageLoader] - [%s]  Required file '%s' could not be found!", modName, luaPath))
            end

            if canLoad then
                local xmlPath = guiPath .. "ObjectStorageGui.xml"
                if fileExists(xmlPath) then
                    local objectStorageGui = ObjectStorageGui:new(nil, nil)
                    g_gui:loadGui(xmlPath, "ObjectStorageGui", objectStorageGui)
                else
                    print(string.format("  Error: [ObjectStorageLoader] - [%s]  Required file '%s' could not be found!", modName, xmlPath))
                end
            end
        end
    end

    return canLoad
end

ObjectStorageLoader.init()
