/*
	Original code by Skyrim
	Full credits to the Reshade team, teej2k, Lycoloko215, Maxpayne09
	Ported by Insomnia 
*/

//	Tonemapping used in Watch Dogs, ripped from the Watch Dogs shaders themselves.

#include "ReShade.fxh"

float3 HPDPass(float4 position : SV_Position, float2 texcoord : TexCoord) : SV_Target
{

	float3 x = tex2D(ReShade::BackBuffer, texcoord).rgb;
    	x = max( (float3)0.0f, x - 0.004f );
    	return pow( abs( ( x * ( 6.2f * x + 0.5f ) ) / ( x * ( 6.2f * x + 1.7f ) + 0.06 ) ), 2.2f );
}


technique HaarmPeterDuikerFilmicToneMapping
{
	pass
	{
		VertexShader = PostProcessVS;
		PixelShader = HPDPass;
	}
}