/*
 * Decompiled with CFR 0.152.
 */
package ink.markidea.note.context.config;

import ink.markidea.note.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ClassPathResource;

public class ContextPropertyLoader
implements EnvironmentPostProcessor,
Ordered {
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        ApplicationHome home = new ApplicationHome(this.getClass());
        HashMap map = new HashMap();
        boolean devSwitch = true;
        String path = devSwitch ? home.getDir().getAbsolutePath() : "/Users/hansanshi/Documents/tests";
        this.addPathAndInitDir(map, path);
        MapPropertySource propertySource = new MapPropertySource("markidea-sys", map);
        environment.getPropertySources().addLast((PropertySource)propertySource);
    }

    public int getOrder() {
        return -2147483639;
    }

    private void addPathAndInitDir(Map<String, Object> map, String basePath) {
        map.put("baseDir", basePath);
        File dbDir = new File(basePath, "db");
        this.checkAndCreateDirIfNecessary(dbDir);
        map.put("dbDir", dbDir.getAbsolutePath());
        File prvKeysDir = new File(basePath, ".ssh");
        this.checkAndCreateDirIfNecessary(prvKeysDir);
        map.put("sshKeysDir", prvKeysDir.getAbsolutePath());
        File notesDir = new File(basePath, "notes");
        this.checkAndCreateDirIfNecessary(notesDir);
        map.put("notesDir", notesDir.getAbsolutePath());
        File staticDir = new File(basePath, "static");
        this.checkAndCreateDirIfNecessary(staticDir);
        map.put("staticDir", staticDir.getAbsolutePath());
        File frontDir = new File(basePath, "front");
        this.checkAndCreateDirIfNecessary(frontDir);
        this.transferFrontResourceIfNecessary(new ClassPathResource("front.zip"), frontDir);
        map.put("frontDir", frontDir.getAbsolutePath());
        File fileDir = new File(staticDir, "file");
        this.checkAndCreateDirIfNecessary(fileDir);
        map.put("fileDir", fileDir.getAbsolutePath());
    }

    private void transferFrontResourceIfNecessary(ClassPathResource resource, File frontDir) {
        if (frontDir.listFiles() != null && frontDir.listFiles().length > 0) {
            return;
        }
        if (!resource.exists()) {
            return;
        }
        try {
            FileUtil.unzip((InputStream)resource.getInputStream(), (String)frontDir.getAbsolutePath());
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't init front dir");
        }
    }

    private void checkAndCreateDirIfNecessary(File dir) {
        if (dir.exists()) {
            if (dir.isDirectory()) {
                return;
            }
            throw new IllegalStateException("not a directory");
        }
        if (!dir.mkdir()) {
            throw new IllegalStateException("create a directory failed");
        }
    }
}

