/*
 * Decompiled with CFR 0.152.
 */
package ink.markidea.note.context.interceptor;

import ink.markidea.note.entity.exception.NoAuthorityException;
import ink.markidea.note.service.IUserService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class AuthorityInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AuthorityInterceptor.class);
    @Autowired
    private IUserService userService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String token = request.getHeader("token");
        String username = request.getHeader("username");
        if (token == null || !this.userService.validate(username, token).isSuccess()) {
            throw new NoAuthorityException();
        }
        return true;
    }
}

