/*
 * Decompiled with CFR 0.152.
 */
package ink.markidea.note.context.task;

import ink.markidea.note.context.task.NoteTimer;
import ink.markidea.note.dao.UserRepository;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
public class NoteTimer
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(NoteTimer.class);
    @Autowired
    private UserRepository userRepository;
    @Value(value="${notesDir}")
    private String notesDir;
    @Value(value="${sshKeysDir}")
    private String sshKeysDir;
    private volatile boolean isPushing = false;
    private volatile List<PushToRemoteTask> pushToRemoteTaskList = new ArrayList();

    @Scheduled(fixedRate=60000L, initialDelay=180000L)
    public void pushLocalChangesToRemote() {
        try {
            if (this.isPushing) {
                return;
            }
            this.isPushing = true;
            this.pushToRemoteTaskList.forEach(Runnable::run);
        }
        finally {
            this.isPushing = false;
        }
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.refreshPushTaskList();
    }

    public synchronized void refreshPushTaskList() {
        ArrayList newTaskList = new ArrayList();
        this.userRepository.findAll().stream().filter(userDO -> userDO.isPush() && StringUtils.isNotBlank((CharSequence)userDO.getRemoteRepository())).forEach(userDO -> {
            PushToRemoteTask task = new PushToRemoteTask(null).setUsername(userDO.getUsername()).setLocalRepoPath(new File(this.notesDir, userDO.getUsername()).getAbsolutePath()).setRemoteRepoUrl(userDO.getRemoteRepository()).setPrivateKeyPath(new File(this.sshKeysDir, userDO.getUsername() + ".prv").getAbsolutePath());
            newTaskList.add(task);
        });
        this.pushToRemoteTaskList = newTaskList;
    }

    public Boolean checkPushTaskStatus(String username) {
        for (PushToRemoteTask task : this.pushToRemoteTaskList) {
            if (!task.getUsername().equals(username)) continue;
            return task.getStatus();
        }
        return null;
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

