/*
 * Decompiled with CFR 0.152.
 */
package ink.markidea.note.controller;

import ink.markidea.note.entity.req.DraftNoteRequest;
import ink.markidea.note.entity.resp.ServerResponse;
import ink.markidea.note.entity.vo.DraftNoteVo;
import ink.markidea.note.service.IDraftNoteService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/draftNote"})
@RestController
public class DraftNoteController {
    @Autowired
    private IDraftNoteService draftNoteService;

    @GetMapping(value={""})
    public ServerResponse<List<DraftNoteVo>> getDraftNotes() {
        return this.draftNoteService.getDraftNotes();
    }

    @DeleteMapping(value={""})
    public ServerResponse delDraftNotes() {
        return this.draftNoteService.deleteDraftNotes();
    }

    @PostMapping(value={"/{notebookName}/{title}"})
    public ServerResponse saveOrUpdateDraftNote(@PathVariable String notebookName, @PathVariable String title, @RequestBody DraftNoteRequest request) {
        return this.draftNoteService.saveDraftNote(notebookName, title, request.getContent());
    }

    @DeleteMapping(value={"/{notebookName}/{title}"})
    public ServerResponse deleteDraftNote(@PathVariable String notebookName, @PathVariable String title) {
        return this.draftNoteService.deleteDraftNote(notebookName, title);
    }
}

