/*
 * Decompiled with CFR 0.152.
 */
package ink.markidea.note.controller;

import ink.markidea.note.entity.resp.ServerResponse;
import ink.markidea.note.entity.resp.VditorFileUploadResponse;
import ink.markidea.note.service.IFileService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;

@RequestMapping(value={"/api/file"})
@RestController
public class FileController {
    @Autowired
    private IFileService fileService;

    @PostMapping(value={""})
    public ServerResponse<String> upload(MultipartFile file) {
        String filePath = this.fileService.upload(file);
        if (filePath == null) {
            return ServerResponse.buildErrorResponse((String)"upload file failed");
        }
        return ServerResponse.buildSuccessResponse((Object)filePath);
    }

    @PostMapping(value={"vditor"})
    public VditorFileUploadResponse upload(StandardMultipartHttpServletRequest request) {
        List files = (List)request.getMultiFileMap().get((Object)"file[]");
        HashMap succFileMap = new HashMap();
        ArrayList errorFileList = new ArrayList();
        files.forEach(file -> {
            try {
                succFileMap.put(file.getOriginalFilename(), this.fileService.upload(file));
            }
            catch (Exception e) {
                errorFileList.add(file.getOriginalFilename());
            }
        });
        VditorFileUploadResponse response = new VditorFileUploadResponse();
        response.setData(new HashMap());
        response.getData().put("errFiles", errorFileList);
        response.getData().put("succMap", succFileMap);
        return response;
    }
}

