/*
 * Decompiled with CFR 0.152.
 */
package ink.markidea.note.controller;

import ink.markidea.note.entity.req.NoteRequest;
import ink.markidea.note.entity.resp.ServerResponse;
import ink.markidea.note.entity.vo.NoteVersionVo;
import ink.markidea.note.entity.vo.NoteVo;
import ink.markidea.note.entity.vo.NotebookVo;
import ink.markidea.note.service.INoteService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/note"})
public class NoteController {
    @Autowired
    private INoteService noteService;

    @PostMapping(value={"/{notebookName}/{noteTitle}"})
    public ServerResponse saveNote(@PathVariable String notebookName, @PathVariable String noteTitle, @RequestBody NoteRequest request) {
        if (StringUtils.isNotBlank((CharSequence)request.getVersionRef())) {
            return this.noteService.resetAndGet(notebookName, noteTitle, request.getVersionRef());
        }
        return this.noteService.saveNote(noteTitle, notebookName, request.getContent());
    }

    @GetMapping(value={""})
    public ServerResponse<List<NotebookVo>> getNotebooks() {
        List notebookNames = (List)this.noteService.listNotebooks().getData();
        ArrayList<NotebookVo> notebookVoList = new ArrayList<NotebookVo>(notebookNames.size());
        for (String notebookName : notebookNames) {
            NotebookVo notebookVo = new NotebookVo().setNotebookName(notebookName).setNoteList(new ArrayList());
            notebookVo.setNoteList((List)this.noteService.listNotes(notebookName).getData());
            notebookVoList.add(notebookVo);
        }
        return ServerResponse.buildSuccessResponse(notebookVoList);
    }

    @GetMapping(value={"/{notebookName}"})
    public ServerResponse<List<NoteVo>> getNotes(@PathVariable String notebookName) {
        return this.noteService.listNotes(notebookName);
    }

    @GetMapping(value={"/{notebookName}/{noteTitle}"})
    public ServerResponse<String> getNote(@PathVariable String notebookName, @PathVariable String noteTitle) {
        return this.noteService.getNote(notebookName, noteTitle);
    }

    @GetMapping(value={"/{notebookName}/{noteTitle}/history"})
    public ServerResponse<List<NoteVersionVo>> getNoteHistory(@PathVariable String notebookName, @PathVariable String noteTitle) {
        return this.noteService.getNoteHistory(notebookName, noteTitle);
    }

    @PutMapping(value={"/{notebookName}"})
    public ServerResponse createNotebook(@PathVariable String notebookName) {
        return this.noteService.createNotebook(notebookName);
    }

    @PutMapping(value={"/{targetNotebook}/{targetNoteTitle}"})
    public ServerResponse copyOrMoveNote(@PathVariable String targetNotebook, @PathVariable String targetNoteTitle, @RequestBody NoteRequest request) {
        String srcNotebook = request.getSrcNotebook();
        String srcTitle = request.getSrcTitle();
        if (request.getMove() != null && request.getMove().booleanValue()) {
            return this.noteService.moveNote(srcNotebook, srcTitle, targetNotebook, targetNoteTitle);
        }
        return this.noteService.copyNote(srcNotebook, targetNotebook, targetNoteTitle);
    }

    @DeleteMapping(value={"/{notebookName}"})
    public ServerResponse delNotebook(@PathVariable String notebookName) {
        return this.noteService.deleteNotebook(notebookName);
    }

    @DeleteMapping(value={"/{notebookName}/{noteTitle}"})
    public ServerResponse delNote(@PathVariable String notebookName, @PathVariable String noteTitle) {
        return this.noteService.deleteNote(notebookName, noteTitle);
    }
}

