/*
 * Decompiled with CFR 0.152.
 */
package ink.markidea.note.db.sqlite;

import ink.markidea.note.db.sqlite.SQLiteDialect;
import ink.markidea.note.db.sqlite.SQLiteDialectIdentityColumnSupport;
import org.hibernate.ScrollMode;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.ViolatedConstraintNameExtracter;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class SQLiteDialect
extends Dialect {
    private final UniqueDelegate uniqueDelegate;
    private static final SQLiteDialectIdentityColumnSupport IDENTITY_COLUMN_SUPPORT = new SQLiteDialectIdentityColumnSupport();
    private static final AbstractLimitHandler LIMIT_HANDLER = new /* Unavailable Anonymous Inner Class!! */;
    private static final int SQLITE_BUSY = 5;
    private static final int SQLITE_LOCKED = 6;
    private static final int SQLITE_IOERR = 10;
    private static final int SQLITE_CORRUPT = 11;
    private static final int SQLITE_NOTFOUND = 12;
    private static final int SQLITE_FULL = 13;
    private static final int SQLITE_CANTOPEN = 14;
    private static final int SQLITE_PROTOCOL = 15;
    private static final int SQLITE_TOOBIG = 18;
    private static final int SQLITE_CONSTRAINT = 19;
    private static final int SQLITE_MISMATCH = 20;
    private static final int SQLITE_NOTADB = 26;
    private static final ViolatedConstraintNameExtracter EXTRACTER = new /* Unavailable Anonymous Inner Class!! */;

    public SQLiteDialect() {
        this.registerColumnType(-7, "boolean");
        this.registerColumnType(3, "decimal");
        this.registerColumnType(1, "char");
        this.registerColumnType(-1, "longvarchar");
        this.registerColumnType(93, "datetime");
        this.registerColumnType(-2, "blob");
        this.registerColumnType(-3, "blob");
        this.registerColumnType(-4, "blob");
        this.registerFunction("concat", (SQLFunction)new VarArgsSQLFunction((Type)StandardBasicTypes.STRING, "", "||", ""));
        this.registerFunction("mod", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.INTEGER, "?1 % ?2"));
        this.registerFunction("quote", (SQLFunction)new StandardSQLFunction("quote", (Type)StandardBasicTypes.STRING));
        this.registerFunction("random", (SQLFunction)new NoArgSQLFunction("random", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("round", (SQLFunction)new StandardSQLFunction("round"));
        this.registerFunction("substr", (SQLFunction)new StandardSQLFunction("substr", (Type)StandardBasicTypes.STRING));
        this.registerFunction("trim", (SQLFunction)new /* Unavailable Anonymous Inner Class!! */);
        this.uniqueDelegate = new SQLiteUniqueDelegate((Dialect)this, null);
    }

    public IdentityColumnSupport getIdentityColumnSupport() {
        return IDENTITY_COLUMN_SUPPORT;
    }

    public LimitHandler getLimitHandler() {
        return LIMIT_HANDLER;
    }

    public boolean supportsLockTimeouts() {
        return false;
    }

    public String getForUpdateString() {
        return "";
    }

    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public String getCurrentTimestampSelectString() {
        return "select current_timestamp";
    }

    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public ViolatedConstraintNameExtracter getViolatedConstraintNameExtracter() {
        return EXTRACTER;
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public boolean canCreateSchema() {
        return false;
    }

    public boolean hasAlterTable() {
        return false;
    }

    public boolean dropConstraints() {
        return false;
    }

    public boolean qualifyIndexName() {
        return false;
    }

    public String getAddColumnString() {
        return "add column";
    }

    public String getDropForeignKeyString() {
        throw new UnsupportedOperationException("No drop foreign key syntax supported by SQLiteDialect");
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        throw new UnsupportedOperationException("No add foreign key syntax supported by SQLiteDialect");
    }

    public String getAddPrimaryKeyConstraintString(String constraintName) {
        throw new UnsupportedOperationException("No add primary key syntax supported by SQLiteDialect");
    }

    public boolean supportsCommentOn() {
        return true;
    }

    public boolean supportsIfExistsBeforeTableName() {
        return true;
    }

    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return true;
    }

    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return true;
    }

    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    public int getInExpressionCountLimit() {
        return 1000;
    }

    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    public String getSelectGUIDString() {
        return "select hex(randomblob(16))";
    }

    public ScrollMode defaultScrollMode() {
        return ScrollMode.FORWARD_ONLY;
    }
}

