/*
 * Decompiled with CFR 0.152.
 */
package ink.markidea.note.entity.exception;

import ink.markidea.note.entity.exception.NoAuthorityException;
import ink.markidea.note.entity.exception.PromptException;
import ink.markidea.note.entity.resp.ServerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={Exception.class})
    public ServerResponse handleException(Exception e) {
        log.error("exception ", (Throwable)e);
        return ServerResponse.buildErrorResponse((String)"System error");
    }

    @ExceptionHandler(value={NullPointerException.class})
    public ServerResponse handleNullException(Exception e) {
        log.error("Argument is null ", (Throwable)e);
        return ServerResponse.buildErrorResponse((String)"Null arguments");
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public ServerResponse handleIllegalArgs(Exception e) {
        log.error("Illegal arguments ", (Throwable)e);
        return ServerResponse.buildErrorResponse((String)"Illegal arguments");
    }

    @ExceptionHandler(value={NoAuthorityException.class})
    public ServerResponse handleNoAuthority(Exception e) {
        return ServerResponse.buildErrorResponse((int)ServerResponse.ResponseCode.NEED_LOGIN.getCode(), (String)"No authority");
    }

    @ExceptionHandler(value={PromptException.class})
    public ServerResponse handlePromptException(Exception e) {
        log.error("exception ", (Throwable)e);
        return ServerResponse.buildErrorResponse((String)e.getMessage());
    }
}

