/*
 * Decompiled with CFR 0.152.
 */
package ink.markidea.note.entity.resp;

import com.fasterxml.jackson.annotation.JsonInclude;
import ink.markidea.note.entity.resp.ServerResponse;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ServerResponse<T> {
    private Integer code;
    private String msg;
    private T data;

    private ServerResponse(Integer code) {
        this.code = code;
    }

    private ServerResponse(Integer code, T data) {
        this.code = code;
        this.data = data;
    }

    private ServerResponse(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public static <T> ServerResponse<T> buildSuccessResponse(T data) {
        return new ServerResponse(Integer.valueOf(ResponseCode.SUCCESS.getCode()), data);
    }

    public static ServerResponse buildSuccessResponse() {
        return new ServerResponse(Integer.valueOf(ResponseCode.SUCCESS.getCode()));
    }

    public static <T> ServerResponse<T> buildErrorResponse(String msg) {
        return new ServerResponse(Integer.valueOf(ResponseCode.ERROR.getCode()), msg);
    }

    public static ServerResponse buildErrorResponse(int code, String msg) {
        return new ServerResponse(Integer.valueOf(code), msg);
    }

    public boolean isSuccess() {
        return Integer.valueOf(0).equals(this.code);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return (T)this.data;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public ServerResponse() {
    }
}

