/*
 * Decompiled with CFR 0.152.
 */
package ink.markidea.note.service.impl;

import ink.markidea.note.context.task.NoteTimer;
import ink.markidea.note.dao.UserRepository;
import ink.markidea.note.entity.resp.ServerResponse;
import ink.markidea.note.service.IAdminService;
import ink.markidea.note.util.SshUtil;
import ink.markidea.note.util.ThreadLocalUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AdminServiceImpl
implements IAdminService {
    private static final Logger log = LoggerFactory.getLogger(AdminServiceImpl.class);
    @Autowired
    private NoteTimer noteTimer;
    @Value(value="${sshKeysDir}")
    private String sshKeysDir;
    @Autowired
    private UserRepository userRepository;

    public ServerResponse setRemoteRepoUrl(String remoteRepoUrl) {
        this.userRepository.save((Object)this.userRepository.findByUsername(this.getUsername()).setRemoteRepository(remoteRepoUrl));
        this.noteTimer.refreshPushTaskList();
        return ServerResponse.buildSuccessResponse();
    }

    public ServerResponse stopPushToRemoteRepo() {
        this.userRepository.save((Object)this.userRepository.findByUsername(this.getUsername()).setPush(false));
        this.noteTimer.refreshPushTaskList();
        return ServerResponse.buildSuccessResponse();
    }

    public ServerResponse<String> generateSshKey() {
        String username = this.getUsername();
        String pubKeyContent = SshUtil.genAndStoreKeyPair((String)(username + ".prv"), (String)(username + ".pub"), (String)this.sshKeysDir);
        return ServerResponse.buildSuccessResponse((Object)pubKeyContent);
    }

    public ServerResponse checkPushTaskStatus() {
        Boolean result = this.noteTimer.checkPushTaskStatus(this.getUsername());
        if (result != null && !result.booleanValue()) {
            return ServerResponse.buildErrorResponse((String)"Can't push to remote repo");
        }
        return ServerResponse.buildSuccessResponse();
    }

    public ServerResponse startPushToRemoteRepo() {
        this.userRepository.save((Object)this.userRepository.findByUsername(this.getUsername()).setPush(true));
        this.noteTimer.refreshPushTaskList();
        return ServerResponse.buildSuccessResponse();
    }

    public ServerResponse getRemoteRepoUrl() {
        String remoteRepoUrl = this.userRepository.findByUsername(this.getUsername()).getRemoteRepository();
        return ServerResponse.buildSuccessResponse((Object)remoteRepoUrl);
    }

    private String getUsername() {
        return ThreadLocalUtil.getUsername();
    }
}

