/*
 * Decompiled with CFR 0.152.
 */
package ink.markidea.note.service.impl;

import ink.markidea.note.dao.DraftNoteRepository;
import ink.markidea.note.entity.DraftNoteDo;
import ink.markidea.note.entity.resp.ServerResponse;
import ink.markidea.note.entity.vo.DraftNoteVo;
import ink.markidea.note.service.IDraftNoteService;
import ink.markidea.note.util.DateTimeUtil;
import ink.markidea.note.util.ThreadLocalUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DraftNoteServiceImpl
implements IDraftNoteService {
    @Autowired
    private DraftNoteRepository draftNoteRepository;

    public ServerResponse<List<DraftNoteVo>> getDraftNotes() {
        List draftNoteDoList = this.draftNoteRepository.findByUsername(this.getUsername());
        ArrayList draftNoteVoList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)draftNoteDoList)) {
            draftNoteDoList.forEach(draftNoteDo -> {
                DraftNoteVo draftNoteVo = new DraftNoteVo();
                draftNoteVo.setId(draftNoteDo.getId()).setNotebookName(draftNoteDo.getNotebookName()).setTitle(draftNoteDo.getTitle()).setContent(draftNoteDo.getContent()).setUpdateTime(DateTimeUtil.dateToStr((Date)draftNoteDo.getUpdateTime()));
                draftNoteVoList.add(draftNoteVo);
            });
        }
        return ServerResponse.buildSuccessResponse(draftNoteVoList);
    }

    public ServerResponse saveDraftNote(String notebookName, String title, String content) {
        this.draftNoteRepository.save((Object)new DraftNoteDo().setUsername(this.getUsername()).setContent(content).setNotebookName(notebookName).setUpdateTime(new Date()).setTitle(title));
        return ServerResponse.buildSuccessResponse();
    }

    public ServerResponse deleteDraftNote(String notebookName, String title) {
        this.draftNoteRepository.deleteByUsernameAndNotebookNameAndTitle(this.getUsername(), notebookName, title);
        return ServerResponse.buildSuccessResponse();
    }

    public ServerResponse deleteDraftNotes() {
        this.draftNoteRepository.deleteByUsername(this.getUsername());
        return ServerResponse.buildSuccessResponse();
    }

    private String getUsername() {
        return ThreadLocalUtil.getUsername();
    }
}

