/*
 * Decompiled with CFR 0.152.
 */
package ink.markidea.note.service.impl;

import ink.markidea.note.service.IFileService;
import ink.markidea.note.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class LocalFileServiceImpl
implements IFileService {
    private static final Logger log = LoggerFactory.getLogger(LocalFileServiceImpl.class);
    @Value(value="${fileDir}")
    private String filePath;
    private final String DIR_PREFIX = "/file/";

    public String upload(MultipartFile sourceFile) {
        String filename = sourceFile.getOriginalFilename();
        String fileExtensionName = filename.substring(filename.indexOf(".") + 1);
        String uploadFileName = UUID.randomUUID().toString() + "." + fileExtensionName;
        log.info("\u5f00\u59cb\u4e0a\u4f20\u6587\u4ef6\uff0c\u4e0a\u4f20\u6587\u4ef6\u7684\u6587\u4ef6\u540d:{}\uff0c\u4e0a\u4f20\u7684\u8def\u5f84:{}\uff0c\u65b0\u6587\u4ef6\u540d:{}", new Object[]{filename, this.filePath, uploadFileName});
        File targetFile = new File(this.filePath, uploadFileName);
        try {
            sourceFile.transferTo(targetFile);
        }
        catch (IOException e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            return null;
        }
        return "/file/" + targetFile.getName();
    }

    public boolean writeStringToFile(String content, File targetFile) {
        return FileUtil.writeStringToFile((String)content, (File)targetFile);
    }

    public String getContentFromFile(File file) {
        return FileUtil.readFileAsString((File)file);
    }

    public String getPreviewLines(File file) {
        StringBuilder builder = new StringBuilder();
        FileUtil.readLines((File)file, (int)2).forEach(line -> builder.append("\n").append((String)line));
        if (builder.length() >= 1) {
            return builder.substring(1);
        }
        return null;
    }

    public void deleteFile(File file) {
        FileUtil.deleteFileOrDirectory((File)file);
    }
}

