/*
 * Decompiled with CFR 0.152.
 */
package ink.markidea.note.service.impl;

import ink.markidea.note.dao.DelNoteRepository;
import ink.markidea.note.dao.DraftNoteRepository;
import ink.markidea.note.entity.DelNoteDo;
import ink.markidea.note.entity.resp.ServerResponse;
import ink.markidea.note.entity.vo.DeletedNoteVo;
import ink.markidea.note.entity.vo.NoteVersionVo;
import ink.markidea.note.entity.vo.NoteVo;
import ink.markidea.note.service.IFileService;
import ink.markidea.note.service.INoteService;
import ink.markidea.note.util.DateTimeUtil;
import ink.markidea.note.util.GitUtil;
import ink.markidea.note.util.ThreadLocalUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.api.Git;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NoteServiceImpl
implements INoteService {
    private static final Logger log = LoggerFactory.getLogger(NoteServiceImpl.class);
    @Value(value="${notesDir}")
    private String notesDir;
    @Autowired
    private IFileService fileService;
    @Autowired
    private DelNoteRepository delNoteRepository;
    @Autowired
    private DraftNoteRepository draftNoteRepository;
    private static final String NOTEBOOK_FLAG_FILE = ".notebook";

    public ServerResponse<List<String>> listNotebooks() {
        File dir = this.getOrCreateUserNotebookDir();
        File[] childFiles = dir.listFiles();
        if (childFiles == null || childFiles.length == 0) {
            return ServerResponse.buildSuccessResponse(Collections.emptyList());
        }
        ArrayList<String> notebookNameList = new ArrayList<String>();
        for (File file : childFiles) {
            String fileName;
            if (!file.isDirectory() || (fileName = file.getName()).startsWith(".")) continue;
            notebookNameList.add(file.getName());
        }
        return ServerResponse.buildSuccessResponse(notebookNameList);
    }

    public ServerResponse<List<NoteVo>> listNotes(String notebookName) {
        File notebookDir = new File(this.getOrCreateUserNotebookDir(), notebookName);
        if (!notebookDir.exists() || notebookDir.isFile()) {
            throw new RuntimeException("No such notebook");
        }
        File[] childFiles = notebookDir.listFiles();
        if (childFiles == null || childFiles.length == 0) {
            return ServerResponse.buildSuccessResponse(Collections.emptyList());
        }
        Arrays.sort(childFiles, (f1, f2) -> (int)(f2.lastModified() - f1.lastModified()));
        List noteVoList = Arrays.stream(childFiles).filter(file -> !file.isDirectory()).filter(file -> this.checkExtension(file.getName())).map(file -> {
            String title = file.getName().substring(0, file.getName().lastIndexOf("."));
            String lastModifiedDate = DateTimeUtil.dateToStr((Date)new Date(file.lastModified()));
            String previewContent = this.fileService.getPreviewLines(file);
            return new NoteVo().setTitle(title).setLastModifiedTime(lastModifiedDate).setPreviewContent(previewContent);
        }).collect(Collectors.toList());
        return ServerResponse.buildSuccessResponse(noteVoList);
    }

    private void createNotebookIfNecessary(String notebookName) {
        File notebookDir = new File(this.getOrCreateUserNotebookDir(), notebookName);
        if (notebookDir.exists()) {
            return;
        }
        this.createNotebook(notebookName);
    }

    public ServerResponse createNotebook(String notebookName) {
        File notebookDir = new File(this.getOrCreateUserNotebookDir(), notebookName);
        if (!notebookDir.mkdir()) {
            throw new RuntimeException("Create notebook failed");
        }
        File notebookFlagFile = new File(notebookDir, NOTEBOOK_FLAG_FILE);
        try {
            if (!notebookFlagFile.createNewFile()) {
                throw new RuntimeException("Create notebook failed");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Create notebook failed");
        }
        String relativeName = notebookName + "/" + NOTEBOOK_FLAG_FILE;
        GitUtil.addAndCommit((Git)this.getOrCreateUserGit(), (String)relativeName);
        log.info("create notebook: {}", (Object)notebookName);
        return ServerResponse.buildSuccessResponse();
    }

    public ServerResponse createNote(String noteTitle, String notebookName, String content) {
        File targetFile = new File(this.getOrCreateUserNotebookDir(), this.getRelativeFileName(notebookName, noteTitle));
        if (targetFile.exists()) {
            throw new RuntimeException("Note already exists");
        }
        return this.saveNote(noteTitle, notebookName, content);
    }

    public ServerResponse saveNote(String noteTitle, String notebookName, String content) {
        this.createNotebookIfNecessary(notebookName);
        String relativeFileName = this.getRelativeFileName(notebookName, noteTitle);
        File noteFile = new File(this.getOrCreateUserNotebookDir(), relativeFileName);
        try {
            if (!noteFile.exists() && !noteFile.createNewFile()) {
                throw new RuntimeException("Save note failed");
            }
        }
        catch (IOException e) {
            log.error("save note error", (Throwable)e);
        }
        this.fileService.writeStringToFile(content, noteFile);
        GitUtil.addAndCommit((Git)this.getOrCreateUserGit(), (String)relativeFileName);
        this.draftNoteRepository.deleteByUsernameAndNotebookNameAndTitle(this.getUsername(), notebookName, noteTitle);
        return ServerResponse.buildSuccessResponse();
    }

    public ServerResponse deleteNote(String notebookName, String noteTitle) {
        String relativeFileName = this.getRelativeFileName(notebookName, noteTitle);
        File noteFile = new File(this.getOrCreateUserNotebookDir(), relativeFileName);
        String content = (String)this.getNote(notebookName, noteTitle).getData();
        if (!noteFile.exists() || !noteFile.delete()) {
            return ServerResponse.buildErrorResponse((String)"Can't delete note");
        }
        String lastRef = GitUtil.getFileCurRef((Git)this.getOrCreateUserGit(), (String)relativeFileName);
        GitUtil.rmAndCommit((Git)this.getOrCreateUserGit(), (String)relativeFileName);
        this.delNoteRepository.save((Object)new DelNoteDo().setNotebook(notebookName).setTitle(noteTitle).setLastRef(lastRef).setContent(content).setUsername(this.getUsername()));
        return ServerResponse.buildSuccessResponse();
    }

    public ServerResponse recoverNote(Integer id) {
        DelNoteDo delNoteDO = this.delNoteRepository.findByIdAndUsername(id, this.getUsername());
        String relativeFileName = this.getRelativeFileName(delNoteDO.getNotebook(), delNoteDO.getTitle());
        File noteFile = new File(this.getOrCreateUserNotebookDir(), relativeFileName);
        if (noteFile.exists()) {
            return ServerResponse.buildErrorResponse((String)"Note already exists");
        }
        GitUtil.recoverDeletedFile((Git)this.getOrCreateUserGit(), (String)relativeFileName, (String)delNoteDO.getLastRef());
        return this.clearDelNote(id);
    }

    public ServerResponse<String> getNote(String notebookName, String noteTitle) {
        String relativeFileName = this.getRelativeFileName(notebookName, noteTitle);
        File noteFile = new File(this.getOrCreateUserNotebookDir(), relativeFileName);
        if (!noteFile.exists()) {
            return ServerResponse.buildErrorResponse((String)"Note not exists");
        }
        String content = this.fileService.getContentFromFile(noteFile);
        if (content == null) {
            return ServerResponse.buildErrorResponse((String)"Read note failed");
        }
        return ServerResponse.buildSuccessResponse((Object)content);
    }

    public ServerResponse<List<NoteVersionVo>> getNoteHistory(String notebookName, String noteTitle) {
        String relativeFileName = this.getRelativeFileName(notebookName, noteTitle);
        List noteVersionVoList = GitUtil.getNoteHistory((Git)this.getOrCreateUserGit(), (String)relativeFileName);
        return ServerResponse.buildSuccessResponse((Object)noteVersionVoList);
    }

    public ServerResponse<String> resetAndGet(String notebookName, String noteTitle, String versionRef) {
        String relativeFileName = this.getRelativeFileName(notebookName, noteTitle);
        boolean result = GitUtil.resetAndCommit((Git)this.getOrCreateUserGit(), (String)relativeFileName, (String)versionRef);
        if (!result) {
            return ServerResponse.buildErrorResponse((String)"Recover to history version failed");
        }
        return this.getNote(notebookName, noteTitle);
    }

    public ServerResponse deleteNotebook(String notebookName) {
        File notebookDir = new File(this.getOrCreateUserNotebookDir(), notebookName);
        ((List)this.listNotes(notebookName).getData()).forEach(noteVo -> this.deleteNote(notebookName, noteVo.getTitle()));
        this.fileService.deleteFile(notebookDir);
        GitUtil.rmAndCommit((Git)this.getOrCreateUserGit(), (String)(notebookName + "/" + NOTEBOOK_FLAG_FILE));
        return ServerResponse.buildSuccessResponse();
    }

    public ServerResponse<List<DeletedNoteVo>> listDelNotes() {
        ArrayList deletedNoteList = new ArrayList();
        this.delNoteRepository.findAllByUsername(this.getUsername()).forEach(delNoteDo -> deletedNoteList.add(new DeletedNoteVo().setId(delNoteDo.getId()).setTitle(delNoteDo.getTitle()).setNotebook(delNoteDo.getNotebook()).setLastRef(delNoteDo.getLastRef()).setUsername(delNoteDo.getUsername()).setContent(delNoteDo.getContent())));
        return ServerResponse.buildSuccessResponse(deletedNoteList);
    }

    public ServerResponse clearDelNote(@NonNull Integer id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.delNoteRepository.deleteByIdAndUsername(id, this.getUsername());
        return ServerResponse.buildSuccessResponse();
    }

    public ServerResponse copyNote(String srcNotebook, String targetNotebook, String title) {
        if (srcNotebook.equals(targetNotebook)) {
            throw new RuntimeException("Same notebook");
        }
        ServerResponse response = this.getNote(srcNotebook, title);
        if (!response.isSuccess()) {
            return response;
        }
        String content = (String)response.getData();
        return this.createNote(title, targetNotebook, content);
    }

    public ServerResponse moveNote(String srcNotebook, String srcTitle, String targetNotebook, String targetTitle) {
        if (srcNotebook.equalsIgnoreCase(targetNotebook) && srcTitle.equalsIgnoreCase(targetTitle)) {
            throw new IllegalArgumentException();
        }
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{srcNotebook, srcTitle, targetNotebook, targetTitle})) {
            throw new IllegalArgumentException();
        }
        ServerResponse response = this.getNote(srcNotebook, srcTitle);
        if (!response.isSuccess()) {
            return response;
        }
        String content = (String)response.getData();
        String targetRelativeName = this.getRelativeFileName(targetNotebook, targetTitle);
        File targetFile = new File(this.getOrCreateUserNotebookDir(), targetRelativeName);
        if (targetFile.exists()) {
            throw new RuntimeException("Note already exists");
        }
        String srcRelativeName = this.getRelativeFileName(srcNotebook, srcTitle);
        File srcFile = new File(this.getOrCreateUserNotebookDir(), srcRelativeName);
        this.fileService.deleteFile(srcFile);
        this.fileService.writeStringToFile(content, targetFile);
        GitUtil.mvAndCommit((Git)this.getOrCreateUserGit(), (String)srcRelativeName, (String)targetRelativeName);
        return ServerResponse.buildSuccessResponse();
    }

    @Transactional
    public ServerResponse clearAllDelNotes() {
        this.delNoteRepository.deleteAllByUsername(this.getUsername());
        return ServerResponse.buildSuccessResponse();
    }

    private String getRelativeFileName(String notebookName, String noteTitle) {
        return notebookName + "/" + noteTitle + ".md";
    }

    private File getOrCreateUserNotebookDir() {
        File dir = new File(this.notesDir, this.getUsername());
        if (dir.exists()) {
            return dir;
        }
        dir.mkdir();
        return dir;
    }

    private String getUsername() {
        return ThreadLocalUtil.getUsername();
    }

    private File getUserNotebookDir() {
        File dir = new File(this.notesDir, ThreadLocalUtil.getUsername());
        if (dir.exists()) {
            return dir;
        }
        return null;
    }

    private Git getOrCreateUserGit() {
        return GitUtil.getOrInitGit((File)this.getOrCreateUserNotebookDir());
    }

    private boolean checkExtension(String filename) {
        return filename.endsWith(".md") || filename.endsWith(".MD") || filename.endsWith(".mD") || filename.endsWith(".Md");
    }
}

