/*
 * Decompiled with CFR 0.152.
 */
package ink.markidea.note.service.impl;

import com.github.benmanes.caffeine.cache.Cache;
import ink.markidea.note.dao.UserRepository;
import ink.markidea.note.entity.UserDo;
import ink.markidea.note.entity.resp.ServerResponse;
import ink.markidea.note.entity.vo.UserVo;
import ink.markidea.note.service.IUserService;
import ink.markidea.note.util.MD5Util;
import ink.markidea.note.util.ThreadLocalUtil;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserServiceImpl
implements IUserService {
    @Autowired
    private Cache<String, UserVo> userCache;
    @Value(value="${username:admin}")
    private String adminUsername;
    @Value(value="${password:admin}")
    private String adminPassword;
    @Value(value="${register-forbidden}")
    private boolean registerForbidden;
    @Autowired
    private UserRepository userRepository;
    private static final String TOKEN_PREFIX = "token_";

    @PostConstruct
    private void initAdminUser() {
        UserDo userDO = this.userRepository.findFirstByStatus(Integer.valueOf(0));
        if (userDO == null) {
            UserDo adminUser = new UserDo().setUsername(this.adminUsername).setPassword(MD5Util.MD5EncodeUtf8((String)this.adminPassword)).setStatus(Integer.valueOf(0));
            this.userRepository.save((Object)adminUser);
        }
    }

    public ServerResponse<UserVo> login(String username, String password) {
        String encodedPassword = MD5Util.MD5EncodeUtf8((String)password);
        UserDo userDO = this.userRepository.findByUsernameAndPassword(username, encodedPassword);
        if (userDO == null) {
            return ServerResponse.buildErrorResponse((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        }
        UserVo userVo = new UserVo().setToken(TOKEN_PREFIX + UUID.randomUUID().toString()).setUsername(username);
        this.userCache.put((Object)userVo.getUsername(), (Object)userVo);
        return ServerResponse.buildSuccessResponse((Object)userVo);
    }

    public ServerResponse validate(String username, String token) {
        UserVo userVo = (UserVo)this.userCache.getIfPresent((Object)username);
        if (userVo == null || !token.equals(userVo.getToken())) {
            return ServerResponse.buildErrorResponse((String)"Invalid token");
        }
        return ServerResponse.buildSuccessResponse();
    }

    public ServerResponse logout() {
        this.userCache.invalidate((Object)this.getUsername());
        return ServerResponse.buildSuccessResponse();
    }

    public ServerResponse<UserVo> register(String username, String password) {
        if (this.registerForbidden) {
            throw new RuntimeException("Register forbidden");
        }
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{username, password})) {
            throw new IllegalArgumentException();
        }
        if (StringUtils.isBlank((CharSequence)username) || StringUtils.isBlank((CharSequence)password)) {
            throw new IllegalArgumentException("Arguments can't be blank");
        }
        UserDo userDO = (UserDo)this.userRepository.save((Object)new UserDo().setUsername(username).setPassword(MD5Util.MD5EncodeUtf8((String)password)));
        UserVo userVo = new UserVo().setUsername(userDO.getUsername());
        return ServerResponse.buildSuccessResponse((Object)userVo);
    }

    @Transactional
    public ServerResponse changePassword(String oldPassword, String newPassword) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{oldPassword, newPassword})) {
            throw new IllegalArgumentException();
        }
        String oldEncodedPassword = MD5Util.MD5EncodeUtf8((String)oldPassword);
        UserDo userDO = this.userRepository.findByUsernameAndPassword(this.getUsername(), oldEncodedPassword);
        if (userDO == null) {
            return ServerResponse.buildErrorResponse((String)"Wrong password");
        }
        String newEncodedPassword = MD5Util.MD5EncodeUtf8((String)newPassword);
        userDO.setPassword(newEncodedPassword);
        this.userRepository.save((Object)userDO);
        return ServerResponse.buildSuccessResponse();
    }

    private String getUsername() {
        return ThreadLocalUtil.getUsername();
    }
}

