/*
 * Decompiled with CFR 0.152.
 */
package ink.markidea.note.util;

import ink.markidea.note.entity.vo.NoteVersionVo;
import ink.markidea.note.util.DateTimeUtil;
import ink.markidea.note.util.GitUtil;
import ink.markidea.note.util.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.util.io.DisabledOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class GitUtil {
    private static final Logger log = LoggerFactory.getLogger(GitUtil.class);
    private static final String DEFAULT_REMOTE_ALIAS_NAME = "origin";
    private static final String DEFAULT_LOCAL_BRANCH_NAME = "master";
    private static final String DEFAULT_REMOTE_BRANCH_NAME = "master";
    private static final String GIT_FLAG_FILE = ".markidea";

    private static Git createNewGit(String path) {
        File gitDir = new File(path);
        return GitUtil.createNewGit((File)gitDir);
    }

    public static Git getOrInitGit(String path) {
        File gitDir = new File(path);
        return GitUtil.getOrInitGit((File)gitDir);
    }

    public static Git getOrInitGit(File gitDir) {
        if (!gitDir.exists() && !gitDir.mkdir()) {
            return null;
        }
        if (gitDir.isFile()) {
            return null;
        }
        Git git = GitUtil.getLocalGit((File)gitDir);
        if (git == null) {
            git = GitUtil.createNewGit((File)gitDir);
        }
        return git;
    }

    private static Git createNewGit(File gitDir) {
        try {
            Git git = Git.init().setDirectory(gitDir).call();
            File file = new File(gitDir, ".markidea");
            file.createNewFile();
            GitUtil.addAndCommit((Git)git, (String)".markidea");
            return git;
        }
        catch (IOException | GitAPIException e) {
            return null;
        }
    }

    public static List<NoteVersionVo> getNoteHistory(Git git, String fileName) {
        ArrayList<NoteVersionVo> noteVersionVoList = new ArrayList<NoteVersionVo>();
        List revCommitList = GitUtil.getVersionHistory((Git)git, (String)fileName);
        HashSet<String> skippedRefs = new HashSet<String>();
        for (RevCommit revCommit : revCommitList) {
            CommitMessage message = (CommitMessage)JsonUtil.stringToObj((String)revCommit.getFullMessage(), CommitMessage.class);
            if (message.getChangeType() == null) continue;
            if (message.getChangeType() == 6) {
                skippedRefs.add(CommitMessage.access$000((CommitMessage)message));
            }
            if (skippedRefs.contains(revCommit.getName()) || !GitUtil.isContentChangeCommit((int)message.getChangeType(), (boolean)fileName.equals(message.getFileName()))) continue;
            noteVersionVoList.add(new NoteVersionVo().setDate(DateTimeUtil.dateToStr((Date)revCommit.getAuthorIdent().getWhen())).setRef(revCommit.getName()));
        }
        return noteVersionVoList;
    }

    private static List<RevCommit> getVersionHistory(Git git, String fileName) {
        ArrayList<RevCommit> list = new ArrayList<RevCommit>();
        Iterable iterable = null;
        try {
            iterable = git.log().addPath(fileName).call();
        }
        catch (GitAPIException e) {
            return list;
        }
        iterable.forEach(list::add);
        return list;
    }

    public static boolean addAndCommit(Git git, String fileName) {
        try {
            git.add().addFilepattern(fileName).call();
            git.commit().setMessage(GitUtil.getCommitMsgStr((int)0, (String)fileName)).call();
            return true;
        }
        catch (GitAPIException | JGitInternalException e) {
            log.error("can't add file: {}, cause is: {}", (Object)fileName, (Object)e.getMessage());
            return false;
        }
    }

    public static boolean mvAndCommit(Git git, String oldFilename, String newFilename) {
        try {
            git.add().addFilepattern(newFilename).call();
            git.rm().addFilepattern(oldFilename).call();
            git.commit().setMessage(GitUtil.getCommitMsgStr((int)3, (String)newFilename)).call();
            return true;
        }
        catch (GitAPIException | JGitInternalException e) {
            log.error("can't move file: {}, cause is: {}", (Object)oldFilename, (Object)e.getMessage());
            return false;
        }
    }

    public static boolean rmAndCommit(Git git, String fileName) {
        try {
            git.rm().addFilepattern(fileName).call();
            git.commit().setMessage(GitUtil.getCommitMsgStr((int)7, (String)fileName)).call();
            return true;
        }
        catch (GitAPIException | JGitInternalException e) {
            log.error("can't remove file: {}, cause is: {}", (Object)fileName, (Object)e.getMessage());
            return false;
        }
    }

    public static boolean resetAndCommit(Git git, String fileName, String versionRef) {
        try {
            git.reset().setRef(versionRef).addPath(fileName).call();
            git.checkout().addPath(fileName).call();
            git.commit().setMessage(JsonUtil.objToString((Object)new CommitMessage().setChangeType(Integer.valueOf(6)).setFileName(fileName).setPrevRef(versionRef))).call();
            log.info("reset file: {} to version: {}", (Object)fileName, (Object)versionRef);
            return true;
        }
        catch (GitAPIException | JGitInternalException e) {
            log.error("can't reset file: {} to version: {}, cause is: {}", new Object[]{fileName, versionRef, e.getMessage()});
            return false;
        }
    }

    public static void recoverDeletedFile(Git git, String fileName, String lastRef) {
        try {
            git.checkout().setStartPoint(lastRef).addPath(fileName).call();
            git.add().addFilepattern(fileName).call();
            git.commit().setMessage(JsonUtil.objToString((Object)new CommitMessage().setChangeType(Integer.valueOf(5)).setFileName(fileName))).call();
            log.info("recover deleted file: {}", (Object)fileName);
        }
        catch (GitAPIException e) {
            log.error("Can't recover deleted file: {}", (Object)fileName, (Object)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public static void pushToRemoteViaSsh(Git git, String privateKeyPath) throws GitAPIException {
        MyJshConfigSessionFactory sshSessionFactory = new MyJshConfigSessionFactory(privateKeyPath);
        ((PushCommand)git.push().setTransportConfigCallback(arg_0 -> GitUtil.lambda$pushToRemoteViaSsh$0((SshSessionFactory)sshSessionFactory, arg_0))).call();
    }

    public static void pushToRemoteViaHttp(Git git, String username, String password) throws GitAPIException {
        ((PushCommand)git.push().setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(username, password))).call();
    }

    public static void setRemoteRepository(Git git, String remoteAliasName, String remoteUrl) throws IOException {
        StoredConfig config = git.getRepository().getConfig();
        config.setString("remote", remoteAliasName, "url", remoteUrl);
        config.setString("remote", remoteAliasName, "fetch", "+refs/heads/*:refs/remotes/" + remoteAliasName + "/*");
        config.save();
    }

    public static void setRemoteRepository(Git git, String remoteUrl) throws IOException {
        GitUtil.setRemoteRepository((Git)git, (String)"origin", (String)remoteUrl);
    }

    public static void setRemoteBranch(Git git, String localBranch, String remoteAliasName, String remoteBranch) throws IOException {
        StoredConfig config = git.getRepository().getConfig();
        config.setString("branch", localBranch, "remote", remoteAliasName);
        config.setString("branch", localBranch, "merge", "refs/heads/" + remoteBranch);
        config.save();
    }

    public static void setRemoteBranch(Git git) throws IOException {
        GitUtil.setRemoteBranch((Git)git, (String)"master", (String)"origin", (String)"master");
    }

    public static void setRemoteRepositoryAndBranch(Git git, String remoteUrl) throws IOException {
        GitUtil.setRemoteRepository((Git)git, (String)remoteUrl);
        GitUtil.setRemoteBranch((Git)git);
    }

    public static String getFileCurRef(Git git, String fileName) {
        List noteVersionVoList = GitUtil.getNoteHistory((Git)git, (String)fileName);
        Iterator iterator = noteVersionVoList.iterator();
        if (iterator.hasNext()) {
            NoteVersionVo noteVersionVo = (NoteVersionVo)iterator.next();
            return noteVersionVo.getRef();
        }
        return null;
    }

    @Deprecated
    public static List<CommitChangeType> getChangeTypeList(Git git, List<RevCommit> revCommitList, String fileName) throws GitAPIException, IOException {
        ArrayList<CommitChangeType> list = new ArrayList<CommitChangeType>();
        Iterator<RevCommit> iterator = revCommitList.iterator();
        if (!iterator.hasNext()) {
            return Collections.emptyList();
        }
        RevCommit newCommit = iterator.next();
        ObjectReader reader = git.getRepository().newObjectReader();
        DiffFormatter diffFormatter = new DiffFormatter((OutputStream)DisabledOutputStream.INSTANCE);
        CanonicalTreeParser newTreeIter = new CanonicalTreeParser();
        CanonicalTreeParser oldTreeIter = new CanonicalTreeParser();
        diffFormatter.setRepository(git.getRepository());
        while (iterator.hasNext()) {
            ObjectId newTree = git.getRepository().resolve(newCommit.getName() + "^{tree}");
            newTreeIter.reset(reader, (AnyObjectId)newTree);
            RevCommit oldCommit = iterator.next();
            ObjectId oldTree = git.getRepository().resolve(oldCommit.getName() + "^{tree}");
            oldTreeIter.reset(reader, (AnyObjectId)oldTree);
            String finalRef = newCommit.getName();
            diffFormatter.scan((AbstractTreeIterator)oldTreeIter, (AbstractTreeIterator)newTreeIter).stream().filter(entry -> entry.getNewPath().equals(fileName) || entry.getOldPath().equals(fileName)).findFirst().ifPresent(entry -> list.add(new CommitChangeType(finalRef, entry.getChangeType())));
            newCommit = oldCommit;
        }
        list.add(new CommitChangeType(newCommit.getName(), DiffEntry.ChangeType.ADD));
        return list;
    }

    private static DiffEntry.ChangeType getChangeType(Git git, List<DiffEntry> entryList, String fileName) {
        for (DiffEntry entry : entryList) {
            if (!entry.getNewPath().equals(fileName) && !entry.getOldPath().equals(fileName)) continue;
            return entry.getChangeType();
        }
        return null;
    }

    private static String getCommitMsgStr(int changeType, String fileName) {
        return JsonUtil.objToString((Object)new CommitMessage().setFileName(fileName).setChangeType(Integer.valueOf(changeType)));
    }

    private static boolean isContentChangeCommit(int changeType, boolean checkFilename) {
        return changeType == 0 || changeType == 1 || changeType == 2 || changeType == 6 || changeType == 3 && checkFilename;
    }

    public static boolean isGitDir(String path) {
        return GitUtil.getLocalGit((String)path) == null;
    }

    private static Git getLocalGit(String path) {
        File gitDirectory = new File(path);
        try {
            return Git.open((File)gitDirectory);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static Git getLocalGit(File gitDir) {
        try {
            return Git.open((File)gitDir);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static /* synthetic */ void lambda$pushToRemoteViaSsh$0(SshSessionFactory sshSessionFactory, Transport transport) {
        SshTransport sshTransport = (SshTransport)transport;
        sshTransport.setSshSessionFactory(sshSessionFactory);
    }
}

